// Arithmetic of genus 3 hyperelliptic curves and their Kummer varieties
// M. Stoll
// Started 2011-12-10

// A hyperelliptic curve of genus 3 is given by an equation
//  y^2 = f(x) = f8*x^8 + f7*x^7 + ... + f1*x + f0

// Define various quantities associated to the curve

function K3quartics(fs : Ring := PolynomialRing(Universe(fs), 8))
  P8 := Ring;
  x := [P8.i : i in [1..8]];
  f0,f1,f2,f3,f4,f5,f6,f7,f8 := Explode(fs);
  return [
// no.1, (d,w) = (4,12)
  (-16*f0*f2*f4*f6 + 4*f0*f2*f5^2 + 4*f0*f3^2*f6 + 4*f1^2*f4*f6 -
f1^2*f5^2)*x[1]^4 + (16*f0*f2*f4 - 4*f0*f3^2 - 4*f1^2*f4)*x[1]^3*x[2] +
(-8*f0*f2*f5 + 2*f1^2*f5)*x[1]^3*x[3] + 4*f0*f3*f5*x[1]^3*x[4] + (16*f0*f2*f6 -
4*f0*f3*f5 - 4*f1^2*f6)*x[1]^3*x[5] + (-8*f0*f3*f6 + 2*f1*f3*f5)*x[1]^3*x[6] +
(16*f0*f4*f6 - 4*f0*f5^2 - 4*f1*f3*f6)*x[1]^3*x[7] + (-6*f0*f4 +
2*f1*f3)*x[1]^3*x[8] + (-16*f0*f2 + 4*f1^2)*x[1]^2*x[2]*x[5] +
8*f0*f3*x[1]^2*x[2]*x[6] + (-10*f0*f4 + 2*f1*f3)*x[1]^2*x[2]*x[7] + (4*f0*f2 -
f1^2)*x[1]^2*x[3]^2 - 4*f0*f3*x[1]^2*x[3]*x[4] + 4*f0*f3*x[1]^2*x[3]*x[5] -
6*f0*f4*x[1]^2*x[3]*x[6] + 8*f0*f5*x[1]^2*x[3]*x[7] + 4*f0*f4*x[1]^2*x[4]^2 +
(-2*f0*f4 - 2*f1*f3)*x[1]^2*x[4]*x[5] + (-4*f0*f5 + 4*f1*f4)*x[1]^2*x[4]*x[6] -
2*f1*f5*x[1]^2*x[4]*x[7] - 2*f0*x[1]^2*x[4]*x[8] + 4*f0*f4*x[1]^2*x[5]^2 +
(4*f0*f5 - 4*f1*f4)*x[1]^2*x[5]*x[6] + (-16*f0*f6 + 2*f1*f5)*x[1]^2*x[5]*x[7] +
7*f0*x[1]^2*x[5]*x[8] + (4*f0*f6 - 2*f1*f5 + 4*f2*f4 - f3^2)*x[1]^2*x[6]^2 +
(4*f1*f6 - 4*f2*f5)*x[1]^2*x[6]*x[7] - 2*f1*x[1]^2*x[6]*x[8] +
4*f2*f6*x[1]^2*x[7]^2 - 2*f2*x[1]^2*x[7]*x[8] + 2*f0*x[1]*x[2]*x[4]*x[7] +
9*f0*x[1]*x[2]*x[5]*x[7] - 4*f0*x[1]*x[2]*x[6]^2 - 2*f1*x[1]*x[2]*x[6]*x[7] -
2*f2*x[1]*x[2]*x[7]^2 - 4*f0*x[1]*x[3]^2*x[7] + 2*f0*x[1]*x[3]*x[4]*x[6] +
2*f1*x[1]*x[3]*x[4]*x[7] + 3*f0*x[1]*x[3]*x[5]*x[6] - 2*f1*x[1]*x[3]*x[5]*x[7] +
2*f2*x[1]*x[3]*x[6]*x[7] - 2*f0*x[1]*x[4]^2*x[5] + f0*x[1]*x[4]*x[5]^2 -
2*f1*x[1]*x[4]*x[5]*x[6] + 2*f2*x[1]*x[4]*x[5]*x[7] - 2*f3*x[1]*x[4]*x[6]*x[7] -
4*f0*x[1]*x[5]^3 + 4*f1*x[1]*x[5]^2*x[6] - 4*f2*x[1]*x[5]*x[6]^2 +
2*f3*x[1]*x[5]*x[6]*x[7] + 2*f3*x[1]*x[6]^3 - 4*f4*x[1]*x[6]^2*x[7] +
4*f5*x[1]*x[6]*x[7]^2 - 4*f6*x[1]*x[7]^3 + 4*x[2]*x[7]^3 - 4*x[3]*x[6]*x[7]^2 -
x[4]^2*x[7]^2 + 2*x[4]*x[5]*x[7]^2 + 2*x[4]*x[6]^2*x[7] - x[5]^2*x[7]^2 +
2*x[5]*x[6]^2*x[7] - x[6]^4,

// no.2, (d,w) = (4,13)
  (-8*f0*f2*f4*f7 + 2*f0*f3^2*f7 + 2*f1^2*f4*f7)*x[1]^4 + (4*f0*f2*f5 -
f1^2*f5)*x[1]^3*x[2] - 2*f0*f3*f5*x[1]^3*x[3] + f1*f3*f5*x[1]^3*x[4] +
(8*f0*f2*f7 - 2*f1^2*f7)*x[1]^3*x[5] - 4*f0*f3*f7*x[1]^3*x[6] + (8*f0*f4*f7 -
2*f1*f3*f7)*x[1]^3*x[7] - f0*f5*x[1]^3*x[8] + (-4*f0*f2 + f1^2)*x[1]^2*x[2]*x[3]
+ 2*f0*f3*x[1]^2*x[2]*x[4] - 2*f0*f3*x[1]^2*x[2]*x[5] + f1*f3*x[1]^2*x[2]*x[6] -
3*f0*f5*x[1]^2*x[2]*x[7] + 2*f0*f3*x[1]^2*x[3]^2 + (-4*f0*f4 -
f1*f3)*x[1]^2*x[3]*x[4] + 4*f0*f4*x[1]^2*x[3]*x[5] + (f0*f5 -
2*f1*f4)*x[1]^2*x[3]*x[6] + f1*f5*x[1]^2*x[3]*x[7] + 2*f0*x[1]^2*x[3]*x[8] +
2*f1*f4*x[1]^2*x[4]^2 + (f0*f5 - 2*f1*f4)*x[1]^2*x[4]*x[5] + (-f1*f5 + 4*f2*f4 -
f3^2)*x[1]^2*x[4]*x[6] - 2*f2*f5*x[1]^2*x[4]*x[7] - f1*x[1]^2*x[4]*x[8] -
8*f0*f7*x[1]^2*x[5]*x[7] + 2*f0*f7*x[1]^2*x[6]^2 + 2*f1*f7*x[1]^2*x[6]*x[7] -
2*f2*x[1]^2*x[6]*x[8] + 2*f2*f7*x[1]^2*x[7]^2 + 2*f0*x[1]*x[2]*x[3]*x[7] -
2*f0*x[1]*x[2]*x[4]*x[6] + 2*f0*x[1]*x[2]*x[5]*x[6] + f1*x[1]*x[2]*x[5]*x[7] -
f1*x[1]*x[2]*x[6]^2 - f1*x[1]*x[3]^2*x[7] + 2*f0*x[1]*x[3]*x[4]*x[5] +
2*f2*x[1]*x[3]*x[4]*x[7] - 4*f0*x[1]*x[3]*x[5]^2 + 2*f1*x[1]*x[3]*x[5]*x[6] -
2*f2*x[1]*x[3]*x[6]^2 + f3*x[1]*x[3]*x[6]*x[7] - f1*x[1]*x[4]^2*x[5] -
f3*x[1]*x[4]^2*x[7] + 2*f1*x[1]*x[4]*x[5]^2 - 2*f2*x[1]*x[4]*x[5]*x[6] +
f3*x[1]*x[4]*x[5]*x[7] + 2*f3*x[1]*x[4]*x[6]^2 - 4*f4*x[1]*x[4]*x[6]*x[7] +
2*f5*x[1]*x[4]*x[7]^2 - 2*f7*x[1]*x[7]^3 + 2*x[2]*x[6]*x[7]^2 - x[3]*x[4]*x[7]^2
- x[3]*x[5]*x[7]^2 - x[3]*x[6]^2*x[7] + x[4]^2*x[6]*x[7] + 3*x[4]*x[5]*x[6]*x[7]
- x[4]*x[6]^3,

// no.3, (d,w) = (4,14)
  (4*f0*f2*f5*f7 - f1^2*f5*f7)*x[1]^4 + (-8*f0*f2*f6 + 2*f1^2*f6)*x[1]^3*x[2] +
(-4*f0*f2*f7 + 4*f0*f3*f6 + f1^2*f7)*x[1]^3*x[3] + (2*f0*f3*f7 -
2*f1*f3*f6)*x[1]^3*x[4] - 2*f0*f3*f7*x[1]^3*x[5] + f1*f3*f7*x[1]^3*x[6] -
4*f0*f5*f7*x[1]^3*x[7] + 3*f0*f6*x[1]^3*x[8] + (8*f0*f2 - 2*f1^2)*x[1]^2*x[2]^2
- 4*f0*f3*x[1]^2*x[2]*x[3] + 2*f1*f3*x[1]^2*x[2]*x[4] + 5*f0*f6*x[1]^2*x[2]*x[7]
- 4*f0*x[1]^2*x[2]*x[8] + 2*f0*f5*x[1]^2*x[3]*x[4] - 2*f0*f5*x[1]^2*x[3]*x[5] +
(-f0*f6 + f1*f5)*x[1]^2*x[3]*x[6] + (4*f0*f7 - 2*f1*f6)*x[1]^2*x[3]*x[7] +
f1*x[1]^2*x[3]*x[8] - f1*f5*x[1]^2*x[4]^2 + (-3*f0*f6 + f1*f5)*x[1]^2*x[4]*x[5]
+ (-2*f0*f7 + 2*f1*f6 - 2*f2*f5)*x[1]^2*x[4]*x[6] + (-f1*f7 +
4*f2*f6)*x[1]^2*x[4]*x[7] - 2*f2*x[1]^2*x[4]*x[8] + 2*f0*f7*x[1]^2*x[5]*x[6] +
f1*f7*x[1]^2*x[5]*x[7] - f1*f7*x[1]^2*x[6]^2 - 2*f2*f7*x[1]^2*x[6]*x[7] -
4*f0*x[1]*x[2]^2*x[7] + f1*x[1]*x[2]*x[3]*x[7] + 2*f0*x[1]*x[2]*x[4]^2 -
2*f2*x[1]*x[2]*x[4]*x[7] + 2*f0*x[1]*x[2]*x[5]^2 - 2*f1*x[1]*x[2]*x[5]*x[6] +
2*f2*x[1]*x[2]*x[6]^2 - 2*f0*x[1]*x[3]^2*x[4] + 2*f0*x[1]*x[3]^2*x[5] +
f1*x[1]*x[3]*x[4]^2 - 2*f1*x[1]*x[3]*x[4]*x[5] - f3*x[1]*x[3]*x[6]^2 +
2*f2*x[1]*x[4]^2*x[5] - f3*x[1]*x[4]^2*x[6] + f3*x[1]*x[4]*x[5]*x[6] +
2*f5*x[1]*x[4]*x[6]*x[7] - 4*f6*x[1]*x[4]*x[7]^2 + 2*f7*x[1]*x[6]*x[7]^2 +
4*x[2]*x[4]*x[7]^2 - 2*x[2]*x[6]^2*x[7] - 3*x[3]*x[4]*x[6]*x[7] +
x[3]*x[5]*x[6]*x[7] + x[3]*x[6]^3 - x[4]^3*x[7] + 2*x[4]^2*x[5]*x[7] +
x[4]^2*x[6]^2 - x[4]*x[5]^2*x[7] - x[4]*x[5]*x[6]^2,

// no.4, (d,w) = (4,14)
  (16*f0*f2*f4*f8 - 4*f0*f3^2*f8 - 4*f1^2*f4*f8)*x[1]^4 + (-16*f0*f2*f8 +
4*f1^2*f8)*x[1]^3*x[5] + 8*f0*f3*f8*x[1]^3*x[6] + (-16*f0*f4*f8 +
4*f1*f3*f8)*x[1]^3*x[7] + (-4*f0*f2 + f1^2)*x[1]^2*x[2]^2 +
4*f0*f3*x[1]^2*x[2]*x[3] - 2*f1*f3*x[1]^2*x[2]*x[4] + 2*f0*x[1]^2*x[2]*x[8] -
4*f0*f4*x[1]^2*x[3]^2 + 4*f1*f4*x[1]^2*x[3]*x[4] - 2*f1*x[1]^2*x[3]*x[8] +
(-4*f2*f4 + f3^2)*x[1]^2*x[4]^2 + 2*f2*x[1]^2*x[4]*x[8] +
16*f0*f8*x[1]^2*x[5]*x[7] - 4*f0*f8*x[1]^2*x[6]^2 - 4*f1*f8*x[1]^2*x[6]*x[7] -
4*f2*f8*x[1]^2*x[7]^2 + 2*f0*x[1]*x[2]^2*x[7] - 2*f0*x[1]*x[2]*x[3]*x[6] -
2*f0*x[1]*x[2]*x[4]*x[5] + 2*f1*x[1]*x[2]*x[4]*x[6] + 2*f2*x[1]*x[2]*x[4]*x[7] +
4*f0*x[1]*x[3]^2*x[5] - 2*f1*x[1]*x[3]^2*x[6] - 2*f1*x[1]*x[3]*x[4]*x[5] +
2*f2*x[1]*x[3]*x[4]*x[6] - 2*f3*x[1]*x[3]*x[4]*x[7] + 2*f2*x[1]*x[4]^2*x[5] -
2*f3*x[1]*x[4]^2*x[6] + 4*f4*x[1]*x[4]^2*x[7] + 4*f8*x[1]*x[7]^3 -
4*x[2]*x[4]*x[7]^2 + x[3]^2*x[7]^2 + 2*x[3]*x[4]*x[6]*x[7] - 4*x[4]^2*x[5]*x[7]
+ x[4]^2*x[6]^2,

// no.5, (d,w) = (4,15)
  -2*f0*f3*f5*f7*x[1]^4 + 4*f0*f3*f6*x[1]^3*x[2] + (2*f0*f3*f7 - 8*f0*f4*f6 +
2*f0*f5^2)*x[1]^3*x[3] + (-4*f0*f4*f7 + 4*f1*f4*f6 - f1*f5^2)*x[1]^3*x[4] +
4*f0*f4*f7*x[1]^3*x[5] + (2*f0*f5*f7 - 2*f1*f4*f7)*x[1]^3*x[6] +
f1*f5*f7*x[1]^3*x[7] + (2*f0*f7 - f1*f6)*x[1]^3*x[8] - 4*f0*f3*x[1]^2*x[2]^2 +
8*f0*f4*x[1]^2*x[2]*x[3] + (2*f0*f5 - 4*f1*f4)*x[1]^2*x[2]*x[4] -
2*f0*f5*x[1]^2*x[2]*x[5] + (-4*f0*f6 + f1*f5)*x[1]^2*x[2]*x[6] + (-2*f0*f7 -
f1*f6)*x[1]^2*x[2]*x[7] + 2*f1*x[1]^2*x[2]*x[8] - 4*f0*f5*x[1]^2*x[3]^2 +
2*f1*f5*x[1]^2*x[3]*x[4] + 8*f0*f6*x[1]^2*x[3]*x[5] - f1*f6*x[1]^2*x[3]*x[6] -
f1*f7*x[1]^2*x[3]*x[7] + (2*f0*f7 - 3*f1*f6)*x[1]^2*x[4]*x[5] +
f3*f5*x[1]^2*x[4]*x[6] - 2*f3*f6*x[1]^2*x[4]*x[7] + f3*x[1]^2*x[4]*x[8] -
4*f0*f7*x[1]^2*x[5]^2 + 2*f1*f7*x[1]^2*x[5]*x[6] + f3*f7*x[1]^2*x[6]*x[7] -
f4*x[1]^2*x[6]*x[8] + f5*x[1]^2*x[7]*x[8] + 4*f0*x[1]*x[2]^2*x[6] -
2*f0*x[1]*x[2]*x[3]*x[4] - 6*f0*x[1]*x[2]*x[3]*x[5] + f1*x[1]*x[2]*x[3]*x[6] +
2*f1*x[1]*x[2]*x[4]*x[5] + f3*x[1]*x[2]*x[4]*x[7] - f3*x[1]*x[2]*x[6]^2 +
f4*x[1]*x[2]*x[6]*x[7] - f5*x[1]*x[2]*x[7]^2 + 2*f0*x[1]*x[3]^3 -
f1*x[1]*x[3]^2*x[4] + f4*x[1]*x[3]*x[6]^2 - f5*x[1]*x[3]*x[6]*x[7] +
2*f6*x[1]*x[3]*x[7]^2 - f3*x[1]*x[4]^2*x[5] + 2*f4*x[1]*x[4]^2*x[6] -
f5*x[1]*x[4]^2*x[7] - f4*x[1]*x[4]*x[5]*x[6] - f5*x[1]*x[4]*x[6]^2 +
2*f6*x[1]*x[4]*x[6]*x[7] + f7*x[1]*x[4]*x[7]^2 - f7*x[1]*x[5]*x[7]^2 -
f7*x[1]*x[6]^2*x[7] - 2*x[2]*x[3]*x[7]^2 - 3*x[2]*x[4]*x[6]*x[7] +
x[2]*x[5]*x[6]*x[7] + x[2]*x[6]^3 + 2*x[3]^2*x[6]*x[7] + x[3]*x[4]^2*x[7] -
x[3]*x[4]*x[5]*x[7] + x[3]*x[4]*x[6]^2 - 2*x[3]*x[5]*x[6]^2 - 2*x[4]^2*x[5]*x[6]
+ 2*x[4]*x[5]^2*x[6],

// no.6, (d,w) = (4,15)
  (8*f0*f2*f5*f8 - 2*f1^2*f5*f8)*x[1]^4 + (-4*f0*f2*f7 + f1^2*f7)*x[1]^3*x[2] +
(-8*f0*f2*f8 + 2*f0*f3*f7 + 2*f1^2*f8)*x[1]^3*x[3] + (4*f0*f3*f8 -
f1*f3*f7)*x[1]^3*x[4] - 4*f0*f3*f8*x[1]^3*x[5] + 2*f1*f3*f8*x[1]^3*x[6] -
8*f0*f5*f8*x[1]^3*x[7] + 2*f0*f7*x[1]^3*x[8] + 2*f0*f7*x[1]^2*x[2]*x[7] -
2*f0*f5*x[1]^2*x[3]^2 + 2*f1*f5*x[1]^2*x[3]*x[4] + (8*f0*f8 -
f1*f7)*x[1]^2*x[3]*x[7] - 2*f2*f5*x[1]^2*x[4]^2 - 2*f0*f7*x[1]^2*x[4]*x[5] +
(-4*f0*f8 + f1*f7)*x[1]^2*x[4]*x[6] + (-2*f1*f8 + 2*f2*f7)*x[1]^2*x[4]*x[7] +
f3*x[1]^2*x[4]*x[8] + 4*f0*f8*x[1]^2*x[5]*x[6] + 2*f1*f8*x[1]^2*x[5]*x[7] -
2*f1*f8*x[1]^2*x[6]^2 - 4*f2*f8*x[1]^2*x[6]*x[7] - 2*f0*x[1]*x[2]*x[3]*x[4] +
2*f0*x[1]*x[2]*x[3]*x[5] - f1*x[1]*x[2]*x[3]*x[6] + f1*x[1]*x[2]*x[4]^2 -
f1*x[1]*x[2]*x[4]*x[5] + 2*f2*x[1]*x[2]*x[4]*x[6] - f3*x[1]*x[2]*x[4]*x[7] +
2*f0*x[1]*x[3]^3 - 2*f1*x[1]*x[3]^2*x[4] + 2*f2*x[1]*x[3]*x[4]^2 -
f3*x[1]*x[4]^3 + 2*f5*x[1]*x[4]^2*x[7] - 2*f7*x[1]*x[4]*x[7]^2 +
4*f8*x[1]*x[6]*x[7]^2 - 2*x[2]*x[4]*x[6]*x[7] + x[3]^2*x[6]*x[7] -
x[3]*x[4]^2*x[7] - x[3]*x[4]*x[5]*x[7] + x[3]*x[4]*x[6]^2 + x[4]^3*x[6] -
x[4]^2*x[5]*x[6],

// no.7, (d,w) = (4,16)
  -4*f0*f3*f5*f8*x[1]^4 + 2*f0*f3*f7*x[1]^3*x[2] + (4*f0*f3*f8 -
4*f0*f4*f7)*x[1]^3*x[3] + (-8*f0*f4*f8 + 2*f1*f4*f7)*x[1]^3*x[4] +
8*f0*f4*f8*x[1]^3*x[5] + (4*f0*f5*f8 - 4*f1*f4*f8)*x[1]^3*x[6] +
2*f1*f5*f8*x[1]^3*x[7] + (3*f0*f8 - f1*f7)*x[1]^3*x[8] +
2*f0*f5*x[1]^2*x[2]*x[3] - f1*f5*x[1]^2*x[2]*x[4] - 2*f0*f7*x[1]^2*x[2]*x[6] -
3*f0*f8*x[1]^2*x[2]*x[7] + 4*f0*f7*x[1]^2*x[3]*x[5] + (-f0*f8 -
f1*f7)*x[1]^2*x[3]*x[6] - 2*f1*f8*x[1]^2*x[3]*x[7] + f3*f5*x[1]^2*x[4]^2 +
(5*f0*f8 - f1*f7)*x[1]^2*x[4]*x[5] - f3*f7*x[1]^2*x[4]*x[7] -
f4*x[1]^2*x[4]*x[8] - 8*f0*f8*x[1]^2*x[5]^2 + 4*f1*f8*x[1]^2*x[5]*x[6] +
2*f3*f8*x[1]^2*x[6]*x[7] + 2*f0*x[1]*x[2]^2*x[4] - 2*f0*x[1]*x[2]^2*x[5] +
f1*x[1]*x[2]^2*x[6] - 2*f0*x[1]*x[2]*x[3]^2 + f1*x[1]*x[2]*x[3]*x[4] -
f3*x[1]*x[2]*x[4]*x[6] + f4*x[1]*x[2]*x[4]*x[7] - f3*x[1]*x[3]*x[4]^2 +
f4*x[1]*x[3]*x[4]*x[6] - f5*x[1]*x[3]*x[4]*x[7] + f7*x[1]*x[3]*x[7]^2 +
2*f4*x[1]*x[4]^3 - f4*x[1]*x[4]^2*x[5] - f5*x[1]*x[4]^2*x[6] +
f7*x[1]*x[4]*x[6]*x[7] + 2*f8*x[1]*x[4]*x[7]^2 - 2*f8*x[1]*x[5]*x[7]^2 -
2*f8*x[1]*x[6]^2*x[7] - x[2]*x[3]*x[6]*x[7] - 2*x[2]*x[4]^2*x[7] +
2*x[2]*x[4]*x[5]*x[7] + x[2]*x[4]*x[6]^2 + x[3]^2*x[4]*x[7] + x[3]*x[4]^2*x[6] -
2*x[3]*x[4]*x[5]*x[6] - 2*x[4]^3*x[5] + 2*x[4]^2*x[5]^2,

// no.8, (d,w) = (4,16)
  f1*f3*f5*f7*x[1]^4 - 2*f1*f3*f6*x[1]^3*x[2] + (-f1*f3*f7 + 4*f1*f4*f6 -
f1*f5^2)*x[1]^3*x[3] + (2*f1*f4*f7 - 8*f2*f4*f6 + 2*f2*f5^2 +
2*f3^2*f6)*x[1]^3*x[4] - 2*f1*f4*f7*x[1]^3*x[5] + (-f1*f5*f7 + 4*f2*f4*f7 -
f3^2*f7)*x[1]^3*x[6] - 2*f2*f5*f7*x[1]^3*x[7] + (-f1*f7 + 3*f2*f6 -
f3*f5)*x[1]^3*x[8] + 2*f1*f3*x[1]^2*x[2]^2 - 4*f1*f4*x[1]^2*x[2]*x[3] + (-f1*f5
+ 8*f2*f4 - 2*f3^2)*x[1]^2*x[2]*x[4] + f1*f5*x[1]^2*x[2]*x[5] + (2*f1*f6 -
2*f2*f5)*x[1]^2*x[2]*x[6] + (f1*f7 + f2*f6 + f3*f5)*x[1]^2*x[2]*x[7] -
4*f2*x[1]^2*x[2]*x[8] + 2*f1*f5*x[1]^2*x[3]^2 - 4*f2*f5*x[1]^2*x[3]*x[4] -
4*f1*f6*x[1]^2*x[3]*x[5] + 3*f2*f6*x[1]^2*x[3]*x[6] + (2*f2*f7 -
2*f3*f6)*x[1]^2*x[3]*x[7] + f3*x[1]^2*x[3]*x[8] + 2*f3*f5*x[1]^2*x[4]^2 +
(-f1*f7 + 5*f2*f6 - f3*f5)*x[1]^2*x[4]*x[5] - 4*f3*f6*x[1]^2*x[4]*x[6] + (-f3*f7
+ 8*f4*f6 - 2*f5^2)*x[1]^2*x[4]*x[7] - 3*f4*x[1]^2*x[4]*x[8] +
2*f1*f7*x[1]^2*x[5]^2 - 4*f2*f7*x[1]^2*x[5]*x[6] + f3*f7*x[1]^2*x[5]*x[7] +
f4*x[1]^2*x[5]*x[8] + 2*f3*f7*x[1]^2*x[6]^2 - 4*f4*f7*x[1]^2*x[6]*x[7] +
f5*x[1]^2*x[6]*x[8] + 2*f5*f7*x[1]^2*x[7]^2 - 4*f6*x[1]^2*x[7]*x[8] -
2*f1*x[1]*x[2]^2*x[6] + f1*x[1]*x[2]*x[3]*x[4] + 3*f1*x[1]*x[2]*x[3]*x[5] -
2*f2*x[1]*x[2]*x[3]*x[6] + f3*x[1]*x[2]*x[3]*x[7] - 4*f2*x[1]*x[2]*x[4]*x[5] +
3*f3*x[1]*x[2]*x[4]*x[6] - 5*f4*x[1]*x[2]*x[4]*x[7] + f3*x[1]*x[2]*x[5]*x[6] -
f4*x[1]*x[2]*x[5]*x[7] + f5*x[1]*x[2]*x[6]*x[7] - f1*x[1]*x[3]^3 +
2*f2*x[1]*x[3]^2*x[4] - 2*f3*x[1]*x[3]*x[4]^2 + f3*x[1]*x[3]*x[4]*x[5] -
f4*x[1]*x[3]*x[4]*x[6] + 3*f5*x[1]*x[3]*x[4]*x[7] - f4*x[1]*x[3]*x[5]*x[6] +
f5*x[1]*x[3]*x[5]*x[7] - 2*f6*x[1]*x[3]*x[6]*x[7] - 2*f7*x[1]*x[3]*x[7]^2 +
2*f4*x[1]*x[4]^3 - f4*x[1]*x[4]^2*x[5] - 2*f5*x[1]*x[4]^2*x[6] +
f4*x[1]*x[4]*x[5]^2 + f5*x[1]*x[4]*x[5]*x[6] - 4*f6*x[1]*x[4]*x[5]*x[7] +
2*f6*x[1]*x[4]*x[6]^2 + f7*x[1]*x[4]*x[6]*x[7] + 3*f7*x[1]*x[5]*x[6]*x[7] -
f7*x[1]*x[6]^3 + 4*x[2]^2*x[7]^2 - 4*x[2]*x[3]*x[6]*x[7] - x[2]*x[4]^2*x[7] +
10*x[2]*x[4]*x[5]*x[7] - x[2]*x[4]*x[6]^2 - x[2]*x[5]^2*x[7] - x[2]*x[5]*x[6]^2
- x[3]^2*x[4]*x[7] - x[3]^2*x[5]*x[7] + x[3]^2*x[6]^2 + 2*x[3]*x[4]^2*x[6] -
4*x[3]*x[4]*x[5]*x[6] + 2*x[3]*x[5]^2*x[6] - 2*x[4]^3*x[5] + 4*x[4]^2*x[5]^2 -
2*x[4]*x[5]^3,

// no.9, (d,w) = (4,16)
  (16*f0*f2*f6*f8 - 4*f0*f2*f7^2 - 4*f1^2*f6*f8 + f1^2*f7^2)*x[1]^4 +
(-16*f0*f2*f8 + 4*f1^2*f8)*x[1]^3*x[2] + (-16*f0*f6*f8 + 4*f0*f7^2)*x[1]^3*x[7]
+ 6*f0*f8*x[1]^3*x[8] + 10*f0*f8*x[1]^2*x[2]*x[7] - 4*f0*f6*x[1]^2*x[3]^2 +
(-4*f0*f7 + 4*f1*f6)*x[1]^2*x[3]*x[4] + 4*f0*f7*x[1]^2*x[3]*x[5] + (6*f0*f8 -
2*f1*f7)*x[1]^2*x[3]*x[6] + (-4*f0*f8 + 2*f1*f7 - 4*f2*f6)*x[1]^2*x[4]^2 +
(2*f0*f8 - 2*f1*f7)*x[1]^2*x[4]*x[5] + (-4*f1*f8 + 4*f2*f7)*x[1]^2*x[4]*x[6] -
4*f0*f8*x[1]^2*x[5]^2 + 4*f1*f8*x[1]^2*x[5]*x[6] - 4*f2*f8*x[1]^2*x[6]^2 +
4*f0*x[1]*x[2]*x[3]^2 - 4*f1*x[1]*x[2]*x[3]*x[4] + 4*f2*x[1]*x[2]*x[4]^2 +
4*f6*x[1]*x[4]^2*x[7] - 4*f7*x[1]*x[4]*x[6]*x[7] + 4*f8*x[1]*x[6]^2*x[7] -
4*x[2]*x[4]^2*x[7] + x[3]^2*x[6]^2 + 2*x[3]*x[4]^2*x[6] - 2*x[3]*x[4]*x[5]*x[6]
+ x[4]^4 - 2*x[4]^3*x[5] + x[4]^2*x[5]^2,

// no.10, (d,w) = (4,17)
  (-8*f0*f3*f6*f8 + 2*f0*f3*f7^2)*x[1]^4 + 8*f0*f3*f8*x[1]^3*x[2] -
2*f0*f5*f7*x[1]^3*x[3] + (-4*f0*f5*f8 + f1*f5*f7)*x[1]^3*x[4] +
4*f0*f5*f8*x[1]^3*x[5] + (8*f0*f6*f8 - 2*f0*f7^2 - 2*f1*f5*f8)*x[1]^3*x[6] +
(4*f1*f6*f8 - f1*f7^2)*x[1]^3*x[7] - 2*f1*f8*x[1]^3*x[8] +
4*f0*f6*x[1]^2*x[2]*x[3] + (2*f0*f7 - 2*f1*f6)*x[1]^2*x[2]*x[4] -
2*f0*f7*x[1]^2*x[2]*x[5] + (-8*f0*f8 + f1*f7)*x[1]^2*x[2]*x[6] -
2*f1*f8*x[1]^2*x[2]*x[7] + 2*f0*f7*x[1]^2*x[3]^2 + (4*f0*f8 -
f1*f7)*x[1]^2*x[3]*x[4] - 4*f0*f8*x[1]^2*x[3]*x[5] + 2*f3*f6*x[1]^2*x[4]^2 +
2*f1*f8*x[1]^2*x[4]*x[5] - 2*f3*f7*x[1]^2*x[4]*x[6] + 2*f3*f8*x[1]^2*x[6]^2 -
4*f0*x[1]*x[2]^2*x[3] + 2*f1*x[1]*x[2]^2*x[4] - 2*f3*x[1]*x[2]*x[4]^2 +
f5*x[1]*x[3]*x[4]*x[6] - 2*f6*x[1]*x[3]*x[4]*x[7] + f7*x[1]*x[3]*x[6]*x[7] +
f5*x[1]*x[4]^3 - f5*x[1]*x[4]^2*x[5] - 2*f6*x[1]*x[4]^2*x[6] -
f7*x[1]*x[4]^2*x[7] + f7*x[1]*x[4]*x[5]*x[7] + 2*f7*x[1]*x[4]*x[6]^2 +
2*f8*x[1]*x[4]*x[6]*x[7] - 2*f8*x[1]*x[5]*x[6]*x[7] - 2*f8*x[1]*x[6]^3 +
2*x[2]*x[3]*x[4]*x[7] - x[2]*x[3]*x[6]^2 + x[2]*x[4]^2*x[6] +
x[2]*x[4]*x[5]*x[6] - x[3]^2*x[4]*x[6] - x[3]*x[4]^3 + x[3]*x[4]^2*x[5],

// no.11, (d,w) = (4,17)
  2*f1*f3*f5*f8*x[1]^4 - f1*f3*f7*x[1]^3*x[2] + (-2*f1*f3*f8 +
2*f1*f4*f7)*x[1]^3*x[3] + (4*f1*f4*f8 - 4*f2*f4*f7 + f3^2*f7)*x[1]^3*x[4] -
4*f1*f4*f8*x[1]^3*x[5] + (-2*f1*f5*f8 + 8*f2*f4*f8 - 2*f3^2*f8)*x[1]^3*x[6] -
4*f2*f5*f8*x[1]^3*x[7] + (-2*f1*f8 + f2*f7)*x[1]^3*x[8] - f1*f5*x[1]^2*x[2]*x[3]
+ 2*f2*f5*x[1]^2*x[2]*x[4] + f1*f7*x[1]^2*x[2]*x[6] + (2*f1*f8 +
f2*f7)*x[1]^2*x[2]*x[7] - f3*x[1]^2*x[2]*x[8] - f3*f5*x[1]^2*x[3]*x[4] -
2*f1*f7*x[1]^2*x[3]*x[5] + f2*f7*x[1]^2*x[3]*x[6] + (4*f2*f8 -
f3*f7)*x[1]^2*x[3]*x[7] + f4*x[1]^2*x[3]*x[8] + (-2*f1*f8 +
3*f2*f7)*x[1]^2*x[4]*x[5] - 2*f3*f7*x[1]^2*x[4]*x[6] + (-2*f3*f8 +
4*f4*f7)*x[1]^2*x[4]*x[7] - f5*x[1]^2*x[4]*x[8] + 4*f1*f8*x[1]^2*x[5]^2 -
8*f2*f8*x[1]^2*x[5]*x[6] + 2*f3*f8*x[1]^2*x[5]*x[7] + 4*f3*f8*x[1]^2*x[6]^2 -
8*f4*f8*x[1]^2*x[6]*x[7] + 4*f5*f8*x[1]^2*x[7]^2 - 2*f7*x[1]^2*x[7]*x[8] -
f1*x[1]*x[2]^2*x[4] + f1*x[1]*x[2]^2*x[5] - 2*f2*x[1]*x[2]^2*x[6] +
f3*x[1]*x[2]^2*x[7] + f1*x[1]*x[2]*x[3]^2 - 2*f2*x[1]*x[2]*x[3]*x[4] +
f3*x[1]*x[2]*x[3]*x[6] - f4*x[1]*x[2]*x[3]*x[7] + f3*x[1]*x[2]*x[4]^2 -
f5*x[1]*x[2]*x[4]*x[7] + f3*x[1]*x[3]^2*x[4] - f4*x[1]*x[3]^2*x[6] +
f5*x[1]*x[3]^2*x[7] - 2*f4*x[1]*x[3]*x[4]^2 + f4*x[1]*x[3]*x[4]*x[5] -
f7*x[1]*x[3]*x[6]*x[7] - 4*f8*x[1]*x[3]*x[7]^2 + f5*x[1]*x[4]^2*x[5] -
2*f7*x[1]*x[4]*x[5]*x[7] + f7*x[1]*x[4]*x[6]^2 + 2*f8*x[1]*x[4]*x[6]*x[7] +
6*f8*x[1]*x[5]*x[6]*x[7] - 2*f8*x[1]*x[6]^3 + 2*x[2]^2*x[6]*x[7] +
3*x[2]*x[3]*x[4]*x[7] - x[2]*x[3]*x[5]*x[7] - 2*x[2]*x[3]*x[6]^2 -
x[2]*x[4]^2*x[6] + x[2]*x[4]*x[5]*x[6] - x[3]^3*x[7] - x[3]^2*x[4]*x[6] +
2*x[3]^2*x[5]*x[6] + 2*x[3]*x[4]^2*x[5] - 2*x[3]*x[4]*x[5]^2,

// no.12, (d,w) = (4,18)
  (4*f1*f3*f6*f8 - f1*f3*f7^2)*x[1]^4 - 4*f1*f3*f8*x[1]^3*x[2] +
f1*f5*f7*x[1]^3*x[3] + (2*f1*f5*f8 - 2*f2*f5*f7)*x[1]^3*x[4] -
2*f1*f5*f8*x[1]^3*x[5] + (-4*f1*f6*f8 + f1*f7^2 + 4*f2*f5*f8)*x[1]^3*x[6] +
(-8*f2*f6*f8 + 2*f2*f7^2)*x[1]^3*x[7] + 3*f2*f8*x[1]^3*x[8] -
2*f1*f6*x[1]^2*x[2]*x[3] + (-f1*f7 + 4*f2*f6)*x[1]^2*x[2]*x[4] +
f1*f7*x[1]^2*x[2]*x[5] + (4*f1*f8 - 2*f2*f7)*x[1]^2*x[2]*x[6] +
5*f2*f8*x[1]^2*x[2]*x[7] - f1*f7*x[1]^2*x[3]^2 + (-2*f1*f8 + 2*f2*f7 -
2*f3*f6)*x[1]^2*x[3]*x[4] + 2*f1*f8*x[1]^2*x[3]*x[5] + (-f2*f8 +
f3*f7)*x[1]^2*x[3]*x[6] + f5*x[1]^2*x[3]*x[8] - f3*f7*x[1]^2*x[4]^2 + (-3*f2*f8
+ f3*f7)*x[1]^2*x[4]*x[5] + 2*f3*f8*x[1]^2*x[4]*x[6] + 2*f5*f7*x[1]^2*x[4]*x[7]
- f6*x[1]^2*x[4]*x[8] - 2*f3*f8*x[1]^2*x[5]*x[6] - 4*f5*f8*x[1]^2*x[6]*x[7] +
(8*f6*f8 - 2*f7^2)*x[1]^2*x[7]^2 - 4*f8*x[1]^2*x[7]*x[8] + 2*f1*x[1]*x[2]^2*x[3]
- 4*f2*x[1]*x[2]^2*x[4] + 2*f3*x[1]*x[2]*x[3]*x[4] - f5*x[1]*x[2]*x[3]*x[7] -
3*f6*x[1]*x[2]*x[4]*x[7] + 2*f7*x[1]*x[2]*x[6]*x[7] - 4*f8*x[1]*x[2]*x[7]^2 +
2*f6*x[1]*x[3]^2*x[7] - f5*x[1]*x[3]*x[4]^2 + f6*x[1]*x[3]*x[4]*x[6] -
2*f7*x[1]*x[3]*x[5]*x[7] - f7*x[1]*x[3]*x[6]^2 + f6*x[1]*x[4]^2*x[5] +
f7*x[1]*x[4]^2*x[6] + 2*f8*x[1]*x[4]^2*x[7] - f7*x[1]*x[4]*x[5]*x[6] -
2*f8*x[1]*x[4]*x[6]^2 + 2*f8*x[1]*x[5]^2*x[7] + 2*f8*x[1]*x[5]*x[6]^2 +
4*x[2]^2*x[4]*x[7] - 2*x[2]*x[3]^2*x[7] - 3*x[2]*x[3]*x[4]*x[6] +
x[2]*x[3]*x[5]*x[6] - x[2]*x[4]^3 + 2*x[2]*x[4]^2*x[5] - x[2]*x[4]*x[5]^2 +
x[3]^3*x[6] + x[3]^2*x[4]^2 - x[3]^2*x[4]*x[5],

// no.13, (d,w) = (4,18)
  (-16*f0*f4*f6*f8 + 4*f0*f4*f7^2 + 4*f0*f5^2*f8)*x[1]^4 + (16*f0*f4*f8 -
4*f0*f5*f7)*x[1]^3*x[2] - 8*f0*f5*f8*x[1]^3*x[3] + (16*f0*f6*f8 -
4*f0*f7^2)*x[1]^3*x[5] + 4*f0*f6*x[1]^2*x[2]^2 + 4*f0*f7*x[1]^2*x[2]*x[3] -
16*f0*f8*x[1]^2*x[2]*x[5] + 4*f0*f8*x[1]^2*x[3]^2 + (4*f4*f6 -
f5^2)*x[1]^2*x[4]^2 - 4*f4*f7*x[1]^2*x[4]*x[6] + 2*f5*f7*x[1]^2*x[4]*x[7] -
2*f6*x[1]^2*x[4]*x[8] + 4*f4*f8*x[1]^2*x[6]^2 - 4*f5*f8*x[1]^2*x[6]*x[7] +
f7*x[1]^2*x[6]*x[8] + (4*f6*f8 - f7^2)*x[1]^2*x[7]^2 - 2*f8*x[1]^2*x[7]*x[8] -
4*f0*x[1]*x[2]^3 - 4*f4*x[1]*x[2]*x[4]^2 + 2*f5*x[1]*x[2]*x[4]*x[6] -
2*f6*x[1]*x[2]*x[4]*x[7] + f7*x[1]*x[2]*x[6]*x[7] - 2*f8*x[1]*x[2]*x[7]^2 +
2*f5*x[1]*x[3]*x[4]^2 - 2*f6*x[1]*x[3]*x[4]*x[6] - 2*f7*x[1]*x[3]*x[4]*x[7] +
f7*x[1]*x[3]*x[6]^2 + 2*f8*x[1]*x[3]*x[6]*x[7] - 2*f6*x[1]*x[4]^2*x[5] +
3*f7*x[1]*x[4]*x[5]*x[6] + 2*f8*x[1]*x[4]*x[5]*x[7] - 4*f8*x[1]*x[5]*x[6]^2 +
4*x[2]^2*x[4]*x[7] - x[2]^2*x[6]^2 - 2*x[2]*x[3]*x[4]*x[6] + 4*x[2]*x[4]^2*x[5]
- x[3]^2*x[4]^2,

// no.14, (d,w) = (4,19)
  (8*f1*f4*f6*f8 - 2*f1*f4*f7^2 - 2*f1*f5^2*f8)*x[1]^4 + (-8*f1*f4*f8 +
2*f1*f5*f7)*x[1]^3*x[2] + 4*f1*f5*f8*x[1]^3*x[3] - f3*f5*f7*x[1]^3*x[4] +
(-8*f1*f6*f8 + 2*f1*f7^2)*x[1]^3*x[5] + 2*f3*f5*f8*x[1]^3*x[6] + (-4*f3*f6*f8 +
f3*f7^2)*x[1]^3*x[7] + 2*f3*f8*x[1]^3*x[8] - 2*f1*f6*x[1]^2*x[2]^2 -
2*f1*f7*x[1]^2*x[2]*x[3] + 2*f3*f6*x[1]^2*x[2]*x[4] + 8*f1*f8*x[1]^2*x[2]*x[5] -
f3*f7*x[1]^2*x[2]*x[6] + 2*f3*f8*x[1]^2*x[2]*x[7] - 2*f1*f8*x[1]^2*x[3]^2 +
(f3*f7 - 4*f4*f6 + f5^2)*x[1]^2*x[3]*x[4] + 2*f4*f7*x[1]^2*x[3]*x[6] -
f5*f7*x[1]^2*x[3]*x[7] + 2*f6*x[1]^2*x[3]*x[8] - 2*f4*f7*x[1]^2*x[4]^2 +
(-2*f3*f8 + 2*f4*f7)*x[1]^2*x[4]*x[5] + (4*f4*f8 + f5*f7)*x[1]^2*x[4]*x[6] -
2*f5*f8*x[1]^2*x[4]*x[7] + f7*x[1]^2*x[4]*x[8] - 4*f4*f8*x[1]^2*x[5]*x[6] +
2*f5*f8*x[1]^2*x[5]*x[7] - 2*f5*f8*x[1]^2*x[6]^2 + (4*f6*f8 -
f7^2)*x[1]^2*x[6]*x[7] - 2*f8*x[1]^2*x[6]*x[8] + 2*f1*x[1]*x[2]^3 -
2*f3*x[1]*x[2]^2*x[4] + 4*f4*x[1]*x[2]*x[3]*x[4] - f5*x[1]*x[2]*x[3]*x[6] +
f5*x[1]*x[2]*x[4]^2 - f5*x[1]*x[2]*x[4]*x[5] - 2*f6*x[1]*x[2]*x[4]*x[6] -
f7*x[1]*x[2]*x[5]*x[7] + f7*x[1]*x[2]*x[6]^2 - 2*f8*x[1]*x[2]*x[6]*x[7] -
2*f5*x[1]*x[3]^2*x[4] + 2*f6*x[1]*x[3]^2*x[6] + f7*x[1]*x[3]^2*x[7] +
2*f6*x[1]*x[3]*x[4]*x[5] + 2*f8*x[1]*x[3]*x[4]*x[7] - 2*f7*x[1]*x[3]*x[5]*x[6] -
2*f8*x[1]*x[3]*x[5]*x[7] + f7*x[1]*x[4]^2*x[5] - 2*f7*x[1]*x[4]*x[5]^2 -
2*f8*x[1]*x[4]*x[5]*x[6] + 4*f8*x[1]*x[5]^2*x[6] - 2*x[2]^2*x[3]*x[7] +
x[2]^2*x[4]*x[6] + x[2]^2*x[5]*x[6] + x[2]*x[3]^2*x[6] - x[2]*x[3]*x[4]^2 -
3*x[2]*x[3]*x[4]*x[5] + x[3]^3*x[4],

// no.15, (d,w) = (4,20)
  (-16*f2*f4*f6*f8 + 4*f2*f4*f7^2 + 4*f2*f5^2*f8 + 4*f3^2*f6*f8 -
f3^2*f7^2)*x[1]^4 + (16*f2*f4*f8 - 4*f2*f5*f7 - 4*f3^2*f8)*x[1]^3*x[2] +
(-8*f2*f5*f8 + 2*f3*f5*f7)*x[1]^3*x[3] + 4*f3*f5*f8*x[1]^3*x[4] + (16*f2*f6*f8 -
4*f2*f7^2 - 4*f3*f5*f8)*x[1]^3*x[5] + (-8*f3*f6*f8 + 2*f3*f7^2)*x[1]^3*x[6] +
(16*f4*f6*f8 - 4*f4*f7^2 - 4*f5^2*f8)*x[1]^3*x[7] + (-6*f4*f8 +
f5*f7)*x[1]^3*x[8] + 4*f2*f6*x[1]^2*x[2]^2 + (4*f2*f7 -
4*f3*f6)*x[1]^2*x[2]*x[3] - 2*f3*f7*x[1]^2*x[2]*x[4] + (-16*f2*f8 +
2*f3*f7)*x[1]^2*x[2]*x[5] + 8*f3*f8*x[1]^2*x[2]*x[6] + (-10*f4*f8 +
3*f5*f7)*x[1]^2*x[2]*x[7] - 2*f6*x[1]^2*x[2]*x[8] + (4*f2*f8 - 2*f3*f7 + 4*f4*f6
- f5^2)*x[1]^2*x[3]^2 + (-4*f3*f8 + 4*f4*f7)*x[1]^2*x[3]*x[4] + (4*f3*f8 -
4*f4*f7)*x[1]^2*x[3]*x[5] + (-6*f4*f8 - f5*f7)*x[1]^2*x[3]*x[6] +
8*f5*f8*x[1]^2*x[3]*x[7] - 3*f7*x[1]^2*x[3]*x[8] + 4*f4*f8*x[1]^2*x[4]^2 +
(-2*f4*f8 - f5*f7)*x[1]^2*x[4]*x[5] - 4*f5*f8*x[1]^2*x[4]*x[6] -
2*f8*x[1]^2*x[4]*x[8] + 4*f4*f8*x[1]^2*x[5]^2 + 4*f5*f8*x[1]^2*x[5]*x[6] +
(-16*f6*f8 + 4*f7^2)*x[1]^2*x[5]*x[7] + 7*f8*x[1]^2*x[5]*x[8] + (4*f6*f8 -
f7^2)*x[1]^2*x[6]^2 - 4*f2*x[1]*x[2]^3 + 4*f3*x[1]*x[2]^2*x[3] -
2*f6*x[1]*x[2]^2*x[7] - 4*f4*x[1]*x[2]*x[3]^2 - 2*f5*x[1]*x[2]*x[3]*x[4] +
2*f5*x[1]*x[2]*x[3]*x[5] + 2*f6*x[1]*x[2]*x[3]*x[6] - f7*x[1]*x[2]*x[3]*x[7] +
2*f6*x[1]*x[2]*x[4]*x[5] + 2*f7*x[1]*x[2]*x[4]*x[6] + 2*f8*x[1]*x[2]*x[4]*x[7] -
2*f7*x[1]*x[2]*x[5]*x[6] + 9*f8*x[1]*x[2]*x[5]*x[7] - 4*f8*x[1]*x[2]*x[6]^2 +
2*f5*x[1]*x[3]^3 - 4*f6*x[1]*x[3]^2*x[5] - f7*x[1]*x[3]^2*x[6] -
4*f8*x[1]*x[3]^2*x[7] - f7*x[1]*x[3]*x[4]*x[5] + 2*f8*x[1]*x[3]*x[4]*x[6] +
4*f7*x[1]*x[3]*x[5]^2 + 3*f8*x[1]*x[3]*x[5]*x[6] - 2*f8*x[1]*x[4]^2*x[5] +
f8*x[1]*x[4]*x[5]^2 - 4*f8*x[1]*x[5]^3 + 4*x[2]^3*x[7] - 4*x[2]^2*x[3]*x[6] -
x[2]^2*x[4]^2 + 2*x[2]^2*x[4]*x[5] - x[2]^2*x[5]^2 + 2*x[2]*x[3]^2*x[4] +
2*x[2]*x[3]^2*x[5] - x[3]^4,

// no.16, (d,w) = (5,17)
  (-8*f0*f2*f4*f7 + 2*f0*f3^2*f7 + 2*f1^2*f4*f7)*x[1]^3*x[4] + (4*f0*f2*f5*f7 -
f1^2*f5*f7)*x[1]^3*x[6] - 2*f0*f3*f5*f7*x[1]^3*x[7] + (3*f0*f2*f7 -
f1^2*f7)*x[1]^3*x[8] + (4*f0*f2*f5 - f1^2*f5)*x[1]^2*x[2]*x[4] + (-8*f0*f2*f6 +
2*f1^2*f6)*x[1]^2*x[2]*x[6] + (-3*f0*f2*f7 + 4*f0*f3*f6 +
f1^2*f7)*x[1]^2*x[2]*x[7] - f0*f3*x[1]^2*x[2]*x[8] - 2*f0*f3*f5*x[1]^2*x[3]*x[4]
+ (-f0*f2*f7 + 4*f0*f3*f6)*x[1]^2*x[3]*x[6] + (2*f0*f3*f7 - 8*f0*f4*f6 +
2*f0*f5^2)*x[1]^2*x[3]*x[7] + 3*f0*f4*x[1]^2*x[3]*x[8] + f1*f3*f5*x[1]^2*x[4]^2
+ (5*f0*f2*f7 - f1^2*f7)*x[1]^2*x[4]*x[5] + (-2*f0*f3*f7 -
2*f1*f3*f6)*x[1]^2*x[4]*x[6] + (4*f0*f4*f7 - 2*f1*f3*f7 + 4*f1*f4*f6 -
f1*f5^2)*x[1]^2*x[4]*x[7] + (-2*f0*f5 - f1*f4)*x[1]^2*x[4]*x[8] -
2*f0*f3*f7*x[1]^2*x[5]*x[6] + 4*f0*f4*f7*x[1]^2*x[5]*x[7] +
f1*f3*f7*x[1]^2*x[6]^2 + (-2*f0*f5*f7 - 2*f1*f4*f7)*x[1]^2*x[6]*x[7] +
2*f0*f6*x[1]^2*x[6]*x[8] + f1*f5*f7*x[1]^2*x[7]^2 + (-2*f0*f7 -
f1*f6)*x[1]^2*x[7]*x[8] + f1*x[1]^2*x[8]^2 + (8*f0*f2 - 2*f1^2)*x[1]*x[2]^2*x[6]
- 3*f0*f3*x[1]*x[2]^2*x[7] + (-4*f0*f2 + f1^2)*x[1]*x[2]*x[3]*x[4] -
5*f0*f3*x[1]*x[2]*x[3]*x[6] + 5*f0*f4*x[1]*x[2]*x[3]*x[7] +
2*f0*f3*x[1]*x[2]*x[4]^2 - f0*f3*x[1]*x[2]*x[4]*x[5] +
3*f1*f3*x[1]*x[2]*x[4]*x[6] - 3*f1*f4*x[1]*x[2]*x[4]*x[7] -
2*f0*f5*x[1]*x[2]*x[5]*x[7] + (2*f0*f6 + f1*f5)*x[1]*x[2]*x[6]*x[7] -
3*f0*x[1]*x[2]*x[6]*x[8] + (2*f0*f7 - f1*f6)*x[1]*x[2]*x[7]^2 +
2*f0*f3*x[1]*x[3]^2*x[4] + 3*f0*f4*x[1]*x[3]^2*x[6] - 4*f0*f5*x[1]*x[3]^2*x[7] +
(-4*f0*f4 - f1*f3)*x[1]*x[3]*x[4]^2 + f0*f4*x[1]*x[3]*x[4]*x[5] + (2*f0*f5 -
3*f1*f4)*x[1]*x[3]*x[4]*x[6] + 3*f1*f5*x[1]*x[3]*x[4]*x[7] +
2*f0*x[1]*x[3]*x[4]*x[8] - 2*f0*f5*x[1]*x[3]*x[5]*x[6] +
8*f0*f6*x[1]*x[3]*x[5]*x[7] - 3*f0*x[1]*x[3]*x[5]*x[8] + (-2*f0*f6 +
f1*f5)*x[1]*x[3]*x[6]^2 - 3*f1*f6*x[1]*x[3]*x[6]*x[7] + 2*f1*x[1]*x[3]*x[6]*x[8]
- f1*f7*x[1]*x[3]*x[7]^2 + 2*f1*f4*x[1]*x[4]^3 + (2*f0*f5 -
f1*f4)*x[1]*x[4]^2*x[5] + (-2*f1*f5 + 4*f2*f4 - f3^2)*x[1]*x[4]^2*x[6] -
2*f2*f5*x[1]*x[4]^2*x[7] - f1*x[1]*x[4]^2*x[8] + (-2*f0*f6 +
f1*f5)*x[1]*x[4]*x[5]*x[6] + (-2*f0*f7 - 3*f1*f6)*x[1]*x[4]*x[5]*x[7] +
f1*x[1]*x[4]*x[5]*x[8] + (2*f1*f6 - 2*f2*f5)*x[1]*x[4]*x[6]^2 + (f1*f7 + 4*f2*f6
+ f3*f5)*x[1]*x[4]*x[6]*x[7] - 3*f2*x[1]*x[4]*x[6]*x[8] + (2*f2*f7 -
2*f3*f6)*x[1]*x[4]*x[7]^2 + f3*x[1]*x[4]*x[7]*x[8] - 4*f0*f7*x[1]*x[5]^2*x[7] +
2*f0*f7*x[1]*x[5]*x[6]^2 + 3*f1*f7*x[1]*x[5]*x[6]*x[7] - f1*f7*x[1]*x[6]^3 -
2*f2*f7*x[1]*x[6]^2*x[7] + f3*f7*x[1]*x[6]*x[7]^2 - f4*x[1]*x[6]*x[7]*x[8] +
f5*x[1]*x[7]^2*x[8] - f0*x[2]^2*x[6]*x[7] + f1*x[2]^2*x[7]^2 -
3*f0*x[2]*x[3]*x[5]*x[7] + f0*x[2]*x[3]*x[6]^2 + f1*x[2]*x[3]*x[6]*x[7] +
f0*x[2]*x[4]*x[5]*x[6] + 2*f1*x[2]*x[4]*x[5]*x[7] - f1*x[2]*x[4]*x[6]^2 -
3*f2*x[2]*x[4]*x[6]*x[7] + f3*x[2]*x[4]*x[7]^2 + 2*f0*x[2]*x[5]^2*x[6] -
2*f1*x[2]*x[5]*x[6]^2 + 2*f2*x[2]*x[6]^3 - f3*x[2]*x[6]^2*x[7] +
f4*x[2]*x[6]*x[7]^2 - f5*x[2]*x[7]^3 + 2*f0*x[3]^3*x[7] - 2*f0*x[3]^2*x[4]*x[6]
- 2*f1*x[3]^2*x[4]*x[7] - f0*x[3]^2*x[5]*x[6] + 2*f0*x[3]*x[4]^2*x[5] +
f1*x[3]*x[4]^2*x[6] + 2*f2*x[3]*x[4]^2*x[7] - f0*x[3]*x[4]*x[5]^2 +
2*f1*x[3]*x[4]*x[5]*x[6] - f2*x[3]*x[4]*x[6]^2 + f3*x[3]*x[4]*x[6]*x[7] -
f3*x[3]*x[6]^3 + f4*x[3]*x[6]^2*x[7] - f5*x[3]*x[6]*x[7]^2 + 2*f6*x[3]*x[7]^3 -
2*x[3]*x[7]^2*x[8] - f1*x[4]^3*x[5] - f3*x[4]^3*x[7] - f2*x[4]^2*x[5]*x[6] +
f3*x[4]^2*x[6]^2 - 2*f4*x[4]^2*x[6]*x[7] + f5*x[4]^2*x[7]^2 +
f3*x[4]*x[5]*x[6]^2 - f4*x[4]*x[5]*x[6]*x[7] + f5*x[4]*x[6]^2*x[7] -
2*f6*x[4]*x[6]*x[7]^2 + 3*x[4]*x[6]*x[7]*x[8] - f7*x[4]*x[7]^3 +
x[5]*x[6]*x[7]*x[8] - f7*x[5]*x[7]^3 - x[6]^3*x[8] + f7*x[6]^2*x[7]^2,

// no.17, (d,w) = (5,18)
  (8*f0*f2*f4*f7 - 2*f0*f3^2*f7 - 2*f1^2*f4*f7)*x[1]^3*x[3] + (-4*f0*f2*f5*f7 +
f1^2*f5*f7)*x[1]^3*x[5] + f1*f3*f5*f7*x[1]^3*x[7] - 2*f0*f3*f7*x[1]^3*x[8] +
(-4*f0*f2*f5 + f1^2*f5)*x[1]^2*x[2]*x[3] + (8*f0*f2*f6 -
2*f1^2*f6)*x[1]^2*x[2]*x[5] + (2*f0*f3*f7 - 2*f1*f3*f6)*x[1]^2*x[2]*x[7] +
2*f0*f3*f5*x[1]^2*x[3]^2 - f1*f3*f5*x[1]^2*x[3]*x[4] + (-4*f0*f2*f7 - 4*f0*f3*f6
+ f1^2*f7)*x[1]^2*x[3]*x[5] + 2*f0*f3*f7*x[1]^2*x[3]*x[6] + (-8*f0*f4*f7 +
f1*f3*f7 + 4*f1*f4*f6 - f1*f5^2)*x[1]^2*x[3]*x[7] + (f0*f5 -
f1*f4)*x[1]^2*x[3]*x[8] + 2*f1*f3*f6*x[1]^2*x[4]*x[5] + (2*f1*f4*f7 - 8*f2*f4*f6
+ 2*f2*f5^2 + 2*f3^2*f6)*x[1]^2*x[4]*x[7] + (3*f2*f4 - f3^2)*x[1]^2*x[4]*x[8] +
2*f0*f3*f7*x[1]^2*x[5]^2 - f1*f3*f7*x[1]^2*x[5]*x[6] + (4*f0*f5*f7 -
2*f1*f4*f7)*x[1]^2*x[5]*x[7] - 3*f0*f6*x[1]^2*x[5]*x[8] + (-f1*f5*f7 +
4*f2*f4*f7 - f3^2*f7)*x[1]^2*x[6]*x[7] + f0*f7*x[1]^2*x[6]*x[8] -
2*f2*f5*f7*x[1]^2*x[7]^2 + (2*f2*f6 - f3*f5)*x[1]^2*x[7]*x[8] - f2*x[1]^2*x[8]^2
+ (-8*f0*f2 + 2*f1^2)*x[1]*x[2]^2*x[5] + 2*f1*f3*x[1]*x[2]^2*x[7] + (4*f0*f2 -
f1^2)*x[1]*x[2]*x[3]^2 - 2*f0*f3*x[1]*x[2]*x[3]*x[4] +
6*f0*f3*x[1]*x[2]*x[3]*x[5] - f1*f3*x[1]*x[2]*x[3]*x[6] + (3*f0*f5 -
3*f1*f4)*x[1]*x[2]*x[3]*x[7] - 2*f1*f3*x[1]*x[2]*x[4]*x[5] + (-f1*f5 + 5*f2*f4 -
f3^2)*x[1]*x[2]*x[4]*x[7] - f0*x[1]*x[2]*x[4]*x[8] + (-5*f0*f6 +
f1*f5)*x[1]*x[2]*x[5]*x[7] + 5*f0*x[1]*x[2]*x[5]*x[8] + (-f0*f7 + 2*f1*f6 -
2*f2*f5)*x[1]*x[2]*x[6]*x[7] - f1*x[1]*x[2]*x[6]*x[8] + (2*f2*f6 +
f3*f5)*x[1]*x[2]*x[7]^2 - 2*f2*x[1]*x[2]*x[7]*x[8] - 2*f0*f3*x[1]*x[3]^3 +
(4*f0*f4 + f1*f3)*x[1]*x[3]^2*x[4] - 4*f0*f4*x[1]*x[3]^2*x[5] + (-f0*f5 +
f1*f4)*x[1]*x[3]^2*x[6] + f1*f5*x[1]*x[3]^2*x[7] - 2*f0*x[1]*x[3]^2*x[8] -
2*f1*f4*x[1]*x[3]*x[4]^2 + (-3*f0*f5 + 3*f1*f4)*x[1]*x[3]*x[4]*x[5] + (f1*f5 -
f2*f4)*x[1]*x[3]*x[4]*x[6] - 2*f2*f5*x[1]*x[3]*x[4]*x[7] +
f1*x[1]*x[3]*x[4]*x[8] + 2*f0*f5*x[1]*x[3]*x[5]^2 + (f0*f6 -
f1*f5)*x[1]*x[3]*x[5]*x[6] + (4*f0*f7 - 2*f1*f6)*x[1]*x[3]*x[5]*x[7] -
f0*f7*x[1]*x[3]*x[6]^2 + (-f1*f7 + 2*f2*f6)*x[1]*x[3]*x[6]*x[7] -
2*f3*f6*x[1]*x[3]*x[7]^2 + f3*x[1]*x[3]*x[7]*x[8] + (f1*f5 - 3*f2*f4 +
f3^2)*x[1]*x[4]^2*x[5] + 2*f3*f5*x[1]*x[4]^2*x[7] + (3*f0*f6 -
f1*f5)*x[1]*x[4]*x[5]^2 + (f0*f7 - 2*f1*f6 + 2*f2*f5)*x[1]*x[4]*x[5]*x[6] +
(-f1*f7 + 2*f2*f6 - f3*f5)*x[1]*x[4]*x[5]*x[7] - 4*f3*f6*x[1]*x[4]*x[6]*x[7] +
2*f3*x[1]*x[4]*x[6]*x[8] + (-f3*f7 + 8*f4*f6 - 2*f5^2)*x[1]*x[4]*x[7]^2 -
5*f4*x[1]*x[4]*x[7]*x[8] - 2*f0*f7*x[1]*x[5]^2*x[6] + f1*f7*x[1]*x[5]^2*x[7] +
f1*f7*x[1]*x[5]*x[6]^2 - 2*f2*f7*x[1]*x[5]*x[6]*x[7] + f3*f7*x[1]*x[5]*x[7]^2 +
f4*x[1]*x[5]*x[7]*x[8] + 2*f3*f7*x[1]*x[6]^2*x[7] - 4*f4*f7*x[1]*x[6]*x[7]^2 +
f5*x[1]*x[6]*x[7]*x[8] + 2*f5*f7*x[1]*x[7]^3 - 2*f6*x[1]*x[7]^2*x[8] +
f0*x[2]^2*x[4]*x[7] + 3*f0*x[2]^2*x[5]*x[7] - f1*x[2]^2*x[6]*x[7] -
f2*x[2]^2*x[7]^2 - 2*f0*x[2]*x[3]^2*x[7] + f0*x[2]*x[3]*x[4]*x[6] +
f1*x[2]*x[3]*x[4]*x[7] - f0*x[2]*x[3]*x[5]*x[6] + f3*x[2]*x[3]*x[7]^2 -
f0*x[2]*x[4]^2*x[5] - f0*x[2]*x[4]*x[5]^2 + f1*x[2]*x[4]*x[5]*x[6] +
f3*x[2]*x[4]*x[6]*x[7] - 3*f4*x[2]*x[4]*x[7]^2 - 2*f0*x[2]*x[5]^3 +
2*f1*x[2]*x[5]^2*x[6] - 2*f2*x[2]*x[5]*x[6]^2 + f3*x[2]*x[5]*x[6]*x[7] -
f4*x[2]*x[5]*x[7]^2 + f5*x[2]*x[6]*x[7]^2 - 2*f6*x[2]*x[7]^3 +
4*x[2]*x[7]^2*x[8] + 2*f0*x[3]^2*x[5]^2 - f1*x[3]^2*x[5]*x[6] + f2*x[3]^2*x[6]^2
- f3*x[3]^2*x[6]*x[7] - f3*x[3]*x[4]^2*x[7] - f1*x[3]*x[4]*x[5]^2 +
f4*x[3]*x[4]*x[6]*x[7] + f5*x[3]*x[4]*x[7]^2 + f3*x[3]*x[5]*x[6]^2 -
f4*x[3]*x[5]*x[6]*x[7] + f5*x[3]*x[5]*x[7]^2 - 2*x[3]*x[6]*x[7]*x[8] +
2*f4*x[4]^3*x[7] + f2*x[4]^2*x[5]^2 - f3*x[4]^2*x[5]*x[6] + f4*x[4]^2*x[5]*x[7]
- 2*f5*x[4]^2*x[6]*x[7] - x[4]^2*x[7]*x[8] - f3*x[4]*x[5]^2*x[6] +
f4*x[4]*x[5]^2*x[7] - f5*x[4]*x[5]*x[6]*x[7] - 2*f6*x[4]*x[5]*x[7]^2 +
2*x[4]*x[5]*x[7]*x[8] + 2*f6*x[4]*x[6]^2*x[7] - x[4]*x[6]^2*x[8] +
f7*x[4]*x[6]*x[7]^2 - x[5]^2*x[7]*x[8] + x[5]*x[6]^2*x[8] + f7*x[5]*x[6]*x[7]^2
- f7*x[6]^3*x[7],

// no.18, (d,w) = (5,18)
  (-4*f0*f2*f3*f5*f8 + 2*f1^2*f3*f5*f8)*x[1]^4 + (2*f0*f2*f3*f7 -
f1^2*f3*f7)*x[1]^3*x[2] + (4*f0*f2*f3*f8 - 4*f0*f2*f4*f7 - 2*f1^2*f3*f8 +
2*f1^2*f4*f7)*x[1]^3*x[3] + (8*f0*f2*f4*f8 - 4*f0*f3^2*f8 - 2*f1*f2*f4*f7 +
f1*f3^2*f7)*x[1]^3*x[4] + (8*f0*f2*f4*f8 - 4*f1^2*f4*f8)*x[1]^3*x[5] +
(-4*f0*f2*f5*f8 + 4*f1*f2*f4*f8 - 2*f1*f3^2*f8)*x[1]^3*x[6] + (4*f0*f3*f5*f8 -
2*f1*f2*f5*f8)*x[1]^3*x[7] + (-3*f0*f2*f8 + f1*f2*f7)*x[1]^3*x[8] + (2*f0*f2*f5
- f1^2*f5)*x[1]^2*x[2]*x[3] + f1*f2*f5*x[1]^2*x[2]*x[4] +
2*f0*f2*f7*x[1]^2*x[2]*x[6] + (3*f0*f2*f8 - 2*f0*f3*f7)*x[1]^2*x[2]*x[7] -
f1*f3*x[1]^2*x[2]*x[8] - f1*f3*f5*x[1]^2*x[3]*x[4] + (4*f0*f2*f7 -
2*f1^2*f7)*x[1]^2*x[3]*x[5] + (f0*f2*f8 - 2*f0*f3*f7 +
f1*f2*f7)*x[1]^2*x[3]*x[6] + (-4*f0*f3*f8 + 4*f0*f4*f7 + 2*f1*f2*f8 -
f1*f3*f7)*x[1]^2*x[3]*x[7] + (-f0*f5 + f1*f4)*x[1]^2*x[3]*x[8] +
f2*f3*f5*x[1]^2*x[4]^2 + (-5*f0*f2*f8 + f1*f2*f7)*x[1]^2*x[4]*x[5] + (4*f0*f3*f8
- f1*f3*f7)*x[1]^2*x[4]*x[6] + (-8*f0*f4*f8 + 2*f1*f3*f8 + 2*f1*f4*f7 -
f2*f3*f7)*x[1]^2*x[4]*x[7] - f2*f4*x[1]^2*x[4]*x[8] + (-8*f0*f2*f8 +
4*f1^2*f8)*x[1]^2*x[5]^2 + (4*f0*f3*f8 - 4*f1*f2*f8)*x[1]^2*x[5]*x[6] +
(-8*f0*f4*f8 + 2*f1*f3*f8)*x[1]^2*x[5]*x[7] + 2*f1*f3*f8*x[1]^2*x[6]^2 +
(4*f0*f5*f8 - 4*f1*f4*f8 + 2*f2*f3*f8)*x[1]^2*x[6]*x[7] - f0*f7*x[1]^2*x[6]*x[8]
+ 2*f1*f5*f8*x[1]^2*x[7]^2 + (3*f0*f8 - f1*f7)*x[1]^2*x[7]*x[8] +
f2*x[1]^2*x[8]^2 - 2*f0*f2*x[1]*x[2]^2*x[4] + (-2*f0*f2 + f1^2)*x[1]*x[2]^2*x[5]
- f1*f2*x[1]*x[2]^2*x[6] + f1*f3*x[1]*x[2]^2*x[7] + (-2*f0*f2 +
f1^2)*x[1]*x[2]*x[3]^2 + (4*f0*f3 - f1*f2)*x[1]*x[2]*x[3]*x[4] +
f1*f3*x[1]*x[2]*x[3]*x[6] + (-f0*f5 - f1*f4)*x[1]*x[2]*x[3]*x[7] -
f1*f3*x[1]*x[2]*x[4]^2 - f2*f3*x[1]*x[2]*x[4]*x[6] + (-f1*f5 +
f2*f4)*x[1]*x[2]*x[4]*x[7] + f0*x[1]*x[2]*x[4]*x[8] + f0*x[1]*x[2]*x[5]*x[8] -
f0*f7*x[1]*x[2]*x[6]*x[7] + f1*x[1]*x[2]*x[6]*x[8] - 3*f0*f8*x[1]*x[2]*x[7]^2 -
f2*x[1]*x[2]*x[7]*x[8] + (-4*f0*f4 + f1*f3)*x[1]*x[3]^2*x[4] + (f0*f5 -
f1*f4)*x[1]*x[3]^2*x[6] + f1*f5*x[1]*x[3]^2*x[7] + 2*f0*x[1]*x[3]^2*x[8] +
(2*f1*f4 - f2*f3)*x[1]*x[3]*x[4]^2 + (f0*f5 + f1*f4)*x[1]*x[3]*x[4]*x[5] +
(-f1*f5 + f2*f4)*x[1]*x[3]*x[4]*x[6] - f2*f5*x[1]*x[3]*x[4]*x[7] -
f1*x[1]*x[3]*x[4]*x[8] - 4*f0*f7*x[1]*x[3]*x[5]*x[7] - f1*x[1]*x[3]*x[5]*x[8] +
f0*f7*x[1]*x[3]*x[6]^2 + (-f0*f8 + f1*f7)*x[1]*x[3]*x[6]*x[7] + (-2*f1*f8 +
f2*f7)*x[1]*x[3]*x[7]^2 + (-2*f2*f4 + f3^2)*x[1]*x[4]^3 - f2*f4*x[1]*x[4]^2*x[5]
+ f2*f5*x[1]*x[4]^2*x[6] - f3*f5*x[1]*x[4]^2*x[7] + f2*x[1]*x[4]^2*x[8] +
f0*f7*x[1]*x[4]*x[5]*x[6] + (5*f0*f8 - f1*f7)*x[1]*x[4]*x[5]*x[7] -
f2*f7*x[1]*x[4]*x[6]*x[7] + (-2*f2*f8 + f3*f7)*x[1]*x[4]*x[7]^2 +
f4*x[1]*x[4]*x[7]*x[8] + 8*f0*f8*x[1]*x[5]^2*x[7] - 4*f0*f8*x[1]*x[5]*x[6]^2 -
2*f2*f8*x[1]*x[5]*x[7]^2 + 2*f2*f8*x[1]*x[6]^2*x[7] - 2*f3*f8*x[1]*x[6]*x[7]^2 +
f0*x[2]^2*x[4]*x[7] + f0*x[2]^2*x[5]*x[7] - f0*x[2]*x[3]*x[4]*x[6] +
f1*x[2]*x[3]*x[4]*x[7] - f0*x[2]*x[3]*x[5]*x[6] - f0*x[2]*x[4]^2*x[5] +
f2*x[2]*x[4]^2*x[7] - f0*x[2]*x[4]*x[5]^2 + f1*x[2]*x[4]*x[5]*x[6] +
f2*x[2]*x[4]*x[5]*x[7] - f2*x[2]*x[4]*x[6]^2 + f3*x[2]*x[4]*x[6]*x[7] -
f4*x[2]*x[4]*x[7]^2 - f1*x[3]^3*x[7] + 2*f0*x[3]^2*x[4]*x[5] +
f2*x[3]^2*x[4]*x[7] + f1*x[3]^2*x[5]*x[6] - f2*x[3]^2*x[6]^2 -
f1*x[3]*x[4]^2*x[5] - f3*x[3]*x[4]^2*x[7] - f1*x[3]*x[4]*x[5]^2 +
f3*x[3]*x[4]*x[6]^2 - f4*x[3]*x[4]*x[6]*x[7] + f5*x[3]*x[4]*x[7]^2 +
x[3]*x[6]*x[7]*x[8] - f7*x[3]*x[7]^3 + f2*x[4]^3*x[5] - f3*x[4]^3*x[6] +
2*f4*x[4]^3*x[7] + f2*x[4]^2*x[5]^2 - f3*x[4]^2*x[5]*x[6] + f4*x[4]^2*x[5]*x[7]
- f5*x[4]^2*x[6]*x[7] - 2*x[4]^2*x[7]*x[8] - 2*x[4]*x[5]*x[7]*x[8] +
x[4]*x[6]^2*x[8] + f7*x[4]*x[6]*x[7]^2 + 2*f8*x[4]*x[7]^3 + 2*f8*x[5]*x[7]^3 -
2*f8*x[6]^2*x[7]^2,

// no.19, (d,w) = (5,19)
  (-4*f0*f2*f5*f7 + f1^2*f5*f7)*x[1]^3*x[3] + (8*f0*f2*f5*f8 -
2*f1^2*f5*f8)*x[1]^3*x[5] + (-8*f0*f3*f6*f8 + 2*f0*f3*f7^2)*x[1]^3*x[7] +
3*f0*f3*f8*x[1]^3*x[8] + (8*f0*f2*f6 - 2*f1^2*f6)*x[1]^2*x[2]*x[3] +
(-4*f0*f2*f7 + f1^2*f7)*x[1]^2*x[2]*x[5] + 5*f0*f3*f8*x[1]^2*x[2]*x[7] +
(4*f0*f2*f7 - 4*f0*f3*f6 - f1^2*f7)*x[1]^2*x[3]^2 + (-2*f0*f3*f7 +
2*f1*f3*f6)*x[1]^2*x[3]*x[4] + (-8*f0*f2*f8 + 4*f0*f3*f7 +
2*f1^2*f8)*x[1]^2*x[3]*x[5] + (3*f0*f3*f8 - f1*f3*f7)*x[1]^2*x[3]*x[6] +
2*f0*f5*f7*x[1]^2*x[3]*x[7] + (-2*f0*f6 + f1*f5)*x[1]^2*x[3]*x[8] + (f0*f3*f8 -
f1*f3*f7)*x[1]^2*x[4]*x[5] + (-4*f0*f5*f8 + f1*f5*f7)*x[1]^2*x[4]*x[7] -
f2*f5*x[1]^2*x[4]*x[8] - 4*f0*f3*f8*x[1]^2*x[5]^2 + 2*f1*f3*f8*x[1]^2*x[5]*x[6]
- 4*f0*f5*f8*x[1]^2*x[5]*x[7] + 2*f0*f7*x[1]^2*x[5]*x[8] + (8*f0*f6*f8 -
2*f0*f7^2 - 2*f1*f5*f8)*x[1]^2*x[6]*x[7] - 3*f0*f8*x[1]^2*x[6]*x[8] +
(4*f1*f6*f8 - f1*f7^2)*x[1]^2*x[7]^2 - 2*f1*f8*x[1]^2*x[7]*x[8] + (-8*f0*f2 +
2*f1^2)*x[1]*x[2]^2*x[3] + 4*f0*f3*x[1]*x[2]*x[3]^2 -
2*f1*f3*x[1]*x[2]*x[3]*x[4] + (-2*f0*f6 - f1*f5)*x[1]*x[2]*x[3]*x[7] +
2*f0*x[1]*x[2]*x[3]*x[8] + (2*f0*f7 - 2*f1*f6 + f2*f5)*x[1]*x[2]*x[4]*x[7] +
f1*x[1]*x[2]*x[4]*x[8] + (-5*f0*f8 + f1*f7)*x[1]*x[2]*x[6]*x[7] +
f2*x[1]*x[2]*x[6]*x[8] - 2*f1*f8*x[1]*x[2]*x[7]^2 - 2*f0*f5*x[1]*x[3]^2*x[4] +
2*f0*f6*x[1]*x[3]^2*x[6] + (-2*f0*f7 + 2*f1*f6)*x[1]*x[3]^2*x[7] -
f1*x[1]*x[3]^2*x[8] + f1*f5*x[1]*x[3]*x[4]^2 + 2*f0*f6*x[1]*x[3]*x[4]*x[5] +
(2*f0*f7 - 2*f1*f6 + f2*f5)*x[1]*x[3]*x[4]*x[6] + (4*f0*f8 -
4*f2*f6)*x[1]*x[3]*x[4]*x[7] + 2*f2*x[1]*x[3]*x[4]*x[8] -
2*f0*f7*x[1]*x[3]*x[5]*x[6] + (4*f0*f8 - 2*f1*f7)*x[1]*x[3]*x[5]*x[7] +
(-3*f0*f8 + f1*f7)*x[1]*x[3]*x[6]^2 + 2*f2*f7*x[1]*x[3]*x[6]*x[7] -
f3*x[1]*x[3]*x[6]*x[8] - f2*f5*x[1]*x[4]^2*x[5] + 2*f3*f6*x[1]*x[4]^2*x[7] -
f3*x[1]*x[4]^2*x[8] - 2*f0*f7*x[1]*x[4]*x[5]^2 + (-f0*f8 +
f1*f7)*x[1]*x[4]*x[5]*x[6] + 2*f2*f7*x[1]*x[4]*x[5]*x[7] +
f3*x[1]*x[4]*x[5]*x[8] - 2*f3*f7*x[1]*x[4]*x[6]*x[7] + 4*f0*f8*x[1]*x[5]^2*x[6]
+ 2*f1*f8*x[1]*x[5]^2*x[7] - 2*f1*f8*x[1]*x[5]*x[6]^2 -
4*f2*f8*x[1]*x[5]*x[6]*x[7] + 2*f3*f8*x[1]*x[6]^2*x[7] + 2*f0*x[2]^2*x[3]*x[7] +
f1*x[2]^2*x[4]*x[7] - f2*x[2]^2*x[6]*x[7] - 2*f0*x[2]*x[3]^2*x[6] -
f1*x[2]*x[3]^2*x[7] - 2*f0*x[2]*x[3]*x[4]^2 + f1*x[2]*x[3]*x[4]*x[6] +
2*f2*x[2]*x[3]*x[4]*x[7] + f1*x[2]*x[3]*x[5]*x[6] - f2*x[2]*x[3]*x[6]^2 +
f3*x[2]*x[3]*x[6]*x[7] - f3*x[2]*x[4]^2*x[7] - f1*x[2]*x[4]*x[5]^2 +
f2*x[2]*x[4]*x[5]*x[6] - f3*x[2]*x[4]*x[5]*x[7] + 2*f0*x[3]^3*x[4] -
f1*x[3]^2*x[4]^2 - f5*x[3]*x[4]*x[6]*x[7] + 2*f6*x[3]*x[4]*x[7]^2 -
2*x[3]*x[4]*x[7]*x[8] + x[3]*x[6]^2*x[8] - f7*x[3]*x[6]*x[7]^2 + f5*x[4]^3*x[7]
+ f5*x[4]^2*x[5]*x[7] - 2*f6*x[4]^2*x[6]*x[7] + x[4]^2*x[6]*x[8] -
f7*x[4]^2*x[7]^2 - x[4]*x[5]*x[6]*x[8] - f7*x[4]*x[5]*x[7]^2 +
2*f7*x[4]*x[6]^2*x[7] + 2*f8*x[4]*x[6]*x[7]^2 + 2*f8*x[5]*x[6]*x[7]^2 -
2*f8*x[6]^3*x[7],

// no.20, (d,w) = (5,19)
  (-8*f0*f2*f4*f7 + 2*f0*f3^2*f7 + 2*f1^2*f4*f7)*x[1]^3*x[2] + (4*f0*f2*f5*f7 -
f1^2*f5*f7)*x[1]^3*x[3] - 2*f0*f3*f5*f7*x[1]^3*x[4] + (3*f0*f4*f7 -
f1*f3*f7)*x[1]^3*x[8] + (4*f0*f2*f5 - f1^2*f5)*x[1]^2*x[2]^2 + (-8*f0*f2*f6 -
2*f0*f3*f5 + 2*f1^2*f6)*x[1]^2*x[2]*x[3] + (4*f0*f3*f6 +
f1*f3*f5)*x[1]^2*x[2]*x[4] + (8*f0*f2*f7 - 2*f1^2*f7)*x[1]^2*x[2]*x[5] -
4*f0*f3*f7*x[1]^2*x[2]*x[6] + (5*f0*f4*f7 - f1*f3*f7)*x[1]^2*x[2]*x[7] -
2*f0*f5*x[1]^2*x[2]*x[8] + (-4*f0*f2*f7 + 4*f0*f3*f6 + f1^2*f7)*x[1]^2*x[3]^2 +
(4*f0*f3*f7 - 8*f0*f4*f6 + 2*f0*f5^2 - 2*f1*f3*f6)*x[1]^2*x[3]*x[4] -
2*f0*f3*f7*x[1]^2*x[3]*x[5] + 3*f0*f4*f7*x[1]^2*x[3]*x[6] -
4*f0*f5*f7*x[1]^2*x[3]*x[7] + 5*f0*f6*x[1]^2*x[3]*x[8] + (-4*f0*f4*f7 +
4*f1*f4*f6 - f1*f5^2)*x[1]^2*x[4]^2 + (f0*f4*f7 + f1*f3*f7)*x[1]^2*x[4]*x[5] +
(2*f0*f5*f7 - 2*f1*f4*f7)*x[1]^2*x[4]*x[6] + f1*f5*f7*x[1]^2*x[4]*x[7] +
(2*f0*f7 - 2*f1*f6)*x[1]^2*x[4]*x[8] - 4*f0*f7*x[1]^2*x[5]*x[8] +
f1*f7*x[1]^2*x[6]*x[8] + f2*f7*x[1]^2*x[7]*x[8] + (4*f0*f2 -
f1^2)*x[1]*x[2]^2*x[3] - 2*f0*f3*x[1]*x[2]^2*x[4] - 2*f0*f3*x[1]*x[2]^2*x[5] +
f1*f3*x[1]*x[2]^2*x[6] - 2*f0*f5*x[1]*x[2]^2*x[7] - 2*f0*f3*x[1]*x[2]*x[3]^2 +
(4*f0*f4 + f1*f3)*x[1]*x[2]*x[3]*x[4] + 4*f0*f4*x[1]*x[2]*x[3]*x[5] -
2*f1*f4*x[1]*x[2]*x[3]*x[6] + (3*f0*f6 + f1*f5)*x[1]*x[2]*x[3]*x[7] -
3*f0*x[1]*x[2]*x[3]*x[8] + (2*f0*f5 - 2*f1*f4)*x[1]*x[2]*x[4]^2 -
2*f1*f4*x[1]*x[2]*x[4]*x[5] + (-4*f0*f6 + 4*f2*f4 - f3^2)*x[1]*x[2]*x[4]*x[6] +
(-2*f0*f7 - 2*f2*f5)*x[1]*x[2]*x[4]*x[7] + f1*x[1]*x[2]*x[4]*x[8] -
4*f0*f7*x[1]*x[2]*x[5]*x[7] + f1*x[1]*x[2]*x[5]*x[8] + 2*f0*f7*x[1]*x[2]*x[6]^2
+ f1*f7*x[1]*x[2]*x[6]*x[7] - 2*f2*x[1]*x[2]*x[6]*x[8] + f2*f7*x[1]*x[2]*x[7]^2
- 2*f0*f5*x[1]*x[3]^2*x[4] - 2*f0*f5*x[1]*x[3]^2*x[5] + (f0*f6 +
f1*f5)*x[1]*x[3]^2*x[6] + (4*f0*f7 - 2*f1*f6)*x[1]*x[3]^2*x[7] +
f1*f5*x[1]*x[3]*x[4]^2 + (3*f0*f6 + f1*f5)*x[1]*x[3]*x[4]*x[5] + (-2*f0*f7 -
2*f2*f5)*x[1]*x[3]*x[4]*x[6] + (-2*f1*f7 + 4*f2*f6)*x[1]*x[3]*x[4]*x[7] -
f2*x[1]*x[3]*x[4]*x[8] - 2*f0*f7*x[1]*x[3]*x[5]*x[6] + f1*f7*x[1]*x[3]*x[5]*x[7]
- f2*f7*x[1]*x[3]*x[6]*x[7] + f3*x[1]*x[3]*x[6]*x[8] + (2*f0*f7 -
2*f1*f6)*x[1]*x[4]^2*x[5] + f3*f5*x[1]*x[4]^2*x[6] - 2*f3*f6*x[1]*x[4]^2*x[7] +
f3*x[1]*x[4]^2*x[8] + f1*f7*x[1]*x[4]*x[5]*x[6] - f2*f7*x[1]*x[4]*x[5]*x[7] +
f3*f7*x[1]*x[4]*x[6]*x[7] - 2*f4*x[1]*x[4]*x[6]*x[8] + f5*x[1]*x[4]*x[7]*x[8] -
f7*x[1]*x[7]^2*x[8] - f0*x[2]^2*x[3]*x[7] + 2*f0*x[2]^2*x[4]*x[6] +
2*f0*x[2]^2*x[5]*x[6] - f1*x[2]^2*x[6]^2 - f0*x[2]*x[3]^2*x[6] +
f1*x[2]*x[3]^2*x[7] - 3*f0*x[2]*x[3]*x[4]*x[5] + f1*x[2]*x[3]*x[4]*x[6] -
f2*x[2]*x[3]*x[4]*x[7] - 2*f0*x[2]*x[3]*x[5]^2 + f1*x[2]*x[3]*x[5]*x[6] +
f1*x[2]*x[4]^2*x[5] + f1*x[2]*x[4]*x[5]^2 - 2*f2*x[2]*x[4]*x[5]*x[6] +
f3*x[2]*x[4]*x[5]*x[7] + f3*x[2]*x[4]*x[6]^2 - 2*f4*x[2]*x[4]*x[6]*x[7] +
f5*x[2]*x[4]*x[7]^2 + 2*x[2]*x[6]*x[7]*x[8] - f7*x[2]*x[7]^3 + 2*f0*x[3]^3*x[5]
- f1*x[3]^3*x[6] - f1*x[3]^2*x[4]*x[5] + f2*x[3]^2*x[4]*x[6] +
f2*x[3]*x[4]^2*x[5] - f3*x[3]*x[4]^2*x[6] + f5*x[3]*x[4]*x[6]*x[7] -
2*f6*x[3]*x[4]*x[7]^2 + x[3]*x[4]*x[7]*x[8] - x[3]*x[5]*x[7]*x[8] -
x[3]*x[6]^2*x[8] + f7*x[3]*x[6]*x[7]^2 - f3*x[4]^3*x[5] + 2*f4*x[4]^3*x[6] -
f5*x[4]^3*x[7] - f5*x[4]^2*x[6]^2 + 2*f6*x[4]^2*x[6]*x[7] - 2*x[4]^2*x[6]*x[8] +
f7*x[4]^2*x[7]^2 + 2*x[4]*x[5]*x[6]*x[8] - f7*x[4]*x[6]^2*x[7],

// no.21, (d,w) = (5,20)
  (-4*f1^2*f4*f6*f8 + f1^2*f4*f7^2 + f1^2*f5^2*f8)*x[1]^4 + (4*f1^2*f4*f8 -
f1^2*f5*f7)*x[1]^3*x[2] - 2*f1^2*f5*f8*x[1]^3*x[3] + (4*f1^2*f6*f8 -
f1^2*f7^2)*x[1]^3*x[5] + f1^2*f6*x[1]^2*x[2]^2 + f1^2*f7*x[1]^2*x[2]*x[3] -
4*f1^2*f8*x[1]^2*x[2]*x[5] + f1^2*f8*x[1]^2*x[3]^2 + (4*f2*f4*f6 - f2*f5^2 -
f3^2*f6)*x[1]^2*x[4]^2 + (-4*f2*f4*f7 + f3^2*f7)*x[1]^2*x[4]*x[6] +
2*f2*f5*f7*x[1]^2*x[4]*x[7] - 2*f2*f6*x[1]^2*x[4]*x[8] + (4*f2*f4*f8 -
f3^2*f8)*x[1]^2*x[6]^2 - 4*f2*f5*f8*x[1]^2*x[6]*x[7] + 2*f2*f7*x[1]^2*x[6]*x[8]
+ (4*f2*f6*f8 - f2*f7^2)*x[1]^2*x[7]^2 - 2*f2*f8*x[1]^2*x[7]*x[8] -
f1^2*x[1]*x[2]^3 + (-4*f2*f4 + f3^2)*x[1]*x[2]*x[4]^2 +
2*f2*f5*x[1]*x[2]*x[4]*x[6] - 2*f2*f6*x[1]*x[2]*x[4]*x[7] +
3*f2*x[1]*x[2]*x[4]*x[8] - f3*x[1]*x[2]*x[6]*x[8] - 2*f2*f8*x[1]*x[2]*x[7]^2 +
2*f2*f5*x[1]*x[3]*x[4]^2 + (-2*f2*f6 - f3*f5)*x[1]*x[3]*x[4]*x[6] + (-2*f2*f7 +
2*f3*f6)*x[1]*x[3]*x[4]*x[7] - f3*x[1]*x[3]*x[4]*x[8] + 2*f2*f7*x[1]*x[3]*x[6]^2
+ (2*f2*f8 - f3*f7)*x[1]*x[3]*x[6]*x[7] + f4*x[1]*x[3]*x[6]*x[8] -
f5*x[1]*x[3]*x[7]*x[8] - f3*f5*x[1]*x[4]^3 + (-2*f2*f6 + f3*f5)*x[1]*x[4]^2*x[5]
+ 2*f3*f6*x[1]*x[4]^2*x[6] + (f3*f7 - 4*f4*f6 + f5^2)*x[1]*x[4]^2*x[7] +
2*f4*x[1]*x[4]^2*x[8] + 2*f2*f7*x[1]*x[4]*x[5]*x[6] + (2*f2*f8 -
f3*f7)*x[1]*x[4]*x[5]*x[7] - f4*x[1]*x[4]*x[5]*x[8] - 2*f3*f7*x[1]*x[4]*x[6]^2 +
(-2*f3*f8 + 4*f4*f7)*x[1]*x[4]*x[6]*x[7] - f5*x[1]*x[4]*x[6]*x[8] -
2*f5*f7*x[1]*x[4]*x[7]^2 + 3*f6*x[1]*x[4]*x[7]*x[8] - 4*f2*f8*x[1]*x[5]*x[6]^2 +
2*f3*f8*x[1]*x[5]*x[6]*x[7] + 2*f3*f8*x[1]*x[6]^3 - 4*f4*f8*x[1]*x[6]^2*x[7] +
4*f5*f8*x[1]*x[6]*x[7]^2 - 2*f7*x[1]*x[6]*x[7]*x[8] + (-4*f6*f8 +
f7^2)*x[1]*x[7]^3 + 2*f8*x[1]*x[7]^2*x[8] + f2*x[2]^2*x[4]*x[7] -
f2*x[2]^2*x[6]^2 + f3*x[2]^2*x[6]*x[7] + f2*x[2]*x[3]*x[4]*x[6] -
f3*x[2]*x[3]*x[4]*x[7] - f4*x[2]*x[3]*x[6]*x[7] + f5*x[2]*x[3]*x[7]^2 +
f2*x[2]*x[4]^2*x[5] - f3*x[2]*x[4]^2*x[6] + 2*f4*x[2]*x[4]^2*x[7] +
f4*x[2]*x[4]*x[5]*x[7] - f5*x[2]*x[4]*x[6]*x[7] + f6*x[2]*x[4]*x[7]^2 -
4*x[2]*x[4]*x[7]*x[8] + x[2]*x[6]^2*x[8] + 2*f8*x[2]*x[7]^3 - f2*x[3]^2*x[4]^2 -
f6*x[3]^2*x[7]^2 + x[3]^2*x[7]*x[8] + f3*x[3]*x[4]^3 - f5*x[3]*x[4]^2*x[7] +
f6*x[3]*x[4]*x[6]*x[7] + x[3]*x[4]*x[6]*x[8] + f7*x[3]*x[4]*x[7]^2 -
x[3]*x[5]*x[6]*x[8] + f7*x[3]*x[5]*x[7]^2 - f7*x[3]*x[6]^2*x[7] -
2*f8*x[3]*x[6]*x[7]^2 - f4*x[4]^4 + f5*x[4]^3*x[6] + x[4]^3*x[8] +
f6*x[4]^2*x[5]*x[7] - 2*x[4]^2*x[5]*x[8] - f6*x[4]^2*x[6]^2 -
f7*x[4]^2*x[6]*x[7] - f8*x[4]^2*x[7]^2 + x[4]*x[5]^2*x[8] -
f7*x[4]*x[5]*x[6]*x[7] + f7*x[4]*x[6]^3 + 2*f8*x[4]*x[6]^2*x[7] -
f8*x[5]^2*x[7]^2 + 2*f8*x[5]*x[6]^2*x[7] - f8*x[6]^4,

// no.22, (d,w) = (5,20)
  (-4*f0*f2*f4*f7^2 - 4*f0*f2*f5^2*f8 + f0*f3^2*f7^2 + f1^2*f4*f7^2 +
f1^2*f5^2*f8)*x[1]^4 + (4*f0*f2*f5*f7 - f1^2*f5*f7)*x[1]^3*x[2] -
2*f0*f3*f5*f7*x[1]^3*x[3] + f1*f3*f5*f7*x[1]^3*x[4] + (4*f0*f2*f7^2 +
4*f0*f3*f5*f8 - f1^2*f7^2)*x[1]^3*x[5] + (-2*f0*f3*f7^2 -
2*f1*f3*f5*f8)*x[1]^3*x[6] + (4*f0*f4*f7^2 + 4*f0*f5^2*f8 -
f1*f3*f7^2)*x[1]^3*x[7] - 2*f0*f5*f7*x[1]^3*x[8] - 2*f0*f3*f7*x[1]^2*x[2]*x[5] +
f1*f3*f7*x[1]^2*x[2]*x[6] - 2*f0*f5*f7*x[1]^2*x[2]*x[7] + (4*f0*f2*f8 + f0*f5^2
- f1^2*f8)*x[1]^2*x[3]^2 + (-4*f0*f3*f8 - f1*f5^2)*x[1]^2*x[3]*x[4] +
4*f0*f4*f7*x[1]^2*x[3]*x[5] - 2*f1*f4*f7*x[1]^2*x[3]*x[6] +
f1*f5*f7*x[1]^2*x[3]*x[7] + (4*f0*f4*f8 + f2*f5^2)*x[1]^2*x[4]^2 + (2*f0*f5*f7 -
2*f1*f4*f7)*x[1]^2*x[4]*x[5] + (-f1*f5*f7 + 4*f2*f4*f7 -
f3^2*f7)*x[1]^2*x[4]*x[6] - 2*f2*f5*f7*x[1]^2*x[4]*x[7] -
2*f0*f8*x[1]^2*x[4]*x[8] - 4*f0*f4*f8*x[1]^2*x[5]^2 + (-4*f0*f5*f8 +
4*f1*f4*f8)*x[1]^2*x[5]*x[6] + (-4*f0*f7^2 - 2*f1*f5*f8)*x[1]^2*x[5]*x[7] +
(f0*f7^2 + 2*f1*f5*f8 - 4*f2*f4*f8 + f3^2*f8)*x[1]^2*x[6]^2 + (f1*f7^2 +
4*f2*f5*f8)*x[1]^2*x[6]*x[7] - 2*f2*f7*x[1]^2*x[6]*x[8] + f2*f7^2*x[1]^2*x[7]^2
- 2*f0*f5*x[1]*x[2]*x[3]*x[5] + f1*f5*x[1]*x[2]*x[3]*x[6] +
f1*f5*x[1]*x[2]*x[4]*x[5] - 2*f2*f5*x[1]*x[2]*x[4]*x[6] +
2*f0*f8*x[1]*x[2]*x[4]*x[7] + 2*f0*f7*x[1]*x[2]*x[5]*x[6] +
f1*f7*x[1]*x[2]*x[5]*x[7] - f1*f7*x[1]*x[2]*x[6]^2 + f3*x[1]*x[2]*x[6]*x[8] -
4*f0*f8*x[1]*x[3]^2*x[7] + (2*f0*f8 + f3*f5)*x[1]*x[3]*x[4]*x[6] +
2*f1*f8*x[1]*x[3]*x[4]*x[7] - 4*f0*f7*x[1]*x[3]*x[5]^2 +
2*f1*f7*x[1]*x[3]*x[5]*x[6] - 2*f2*f7*x[1]*x[3]*x[6]^2 +
f3*f7*x[1]*x[3]*x[6]*x[7] - f4*x[1]*x[3]*x[6]*x[8] + f5*x[1]*x[3]*x[7]*x[8] +
(-2*f0*f8 - f3*f5)*x[1]*x[4]^2*x[5] - f5^2*x[1]*x[4]^2*x[7] +
2*f1*f7*x[1]*x[4]*x[5]^2 - 2*f2*f7*x[1]*x[4]*x[5]*x[6] +
f3*f7*x[1]*x[4]*x[5]*x[7] + f4*x[1]*x[4]*x[5]*x[8] + 2*f3*f7*x[1]*x[4]*x[6]^2 -
4*f4*f7*x[1]*x[4]*x[6]*x[7] + f5*x[1]*x[4]*x[6]*x[8] + 2*f5*f7*x[1]*x[4]*x[7]^2
+ 4*f0*f8*x[1]*x[5]^3 - 4*f1*f8*x[1]*x[5]^2*x[6] + 4*f2*f8*x[1]*x[5]*x[6]^2 -
2*f3*f8*x[1]*x[5]*x[6]*x[7] - 2*f3*f8*x[1]*x[6]^3 + 4*f4*f8*x[1]*x[6]^2*x[7] -
4*f5*f8*x[1]*x[6]*x[7]^2 + 2*f7*x[1]*x[6]*x[7]*x[8] - f7^2*x[1]*x[7]^3 -
f0*x[2]^2*x[4]^2 + f0*x[2]^2*x[5]^2 - f1*x[2]^2*x[5]*x[6] + f2*x[2]^2*x[6]^2 -
f3*x[2]^2*x[6]*x[7] + 2*f0*x[2]*x[3]^2*x[4] - f1*x[2]*x[3]*x[4]^2 +
f4*x[2]*x[3]*x[6]*x[7] - f5*x[2]*x[3]*x[7]^2 - f4*x[2]*x[4]*x[5]*x[7] +
f5*x[2]*x[4]*x[6]*x[7] - x[2]*x[6]^2*x[8] - f0*x[3]^4 + f1*x[3]^3*x[4] -
f2*x[3]^2*x[4]^2 + f3*x[3]*x[4]^3 + x[3]*x[5]*x[6]*x[8] - f7*x[3]*x[5]*x[7]^2 +
f7*x[3]*x[6]^2*x[7] - f4*x[4]^4 + x[4]^3*x[8] - f8*x[4]^2*x[7]^2 -
x[4]*x[5]^2*x[8] + f7*x[4]*x[5]*x[6]*x[7] - f7*x[4]*x[6]^3 + f8*x[5]^2*x[7]^2 -
2*f8*x[5]*x[6]^2*x[7] + f8*x[6]^4,

// no.23, (d,w) = (5,20)
  (4*f0*f3^2*f6*f8 - f0*f3^2*f7^2 - 4*f1^2*f4*f6*f8 + f1^2*f4*f7^2 +
f1^2*f5^2*f8)*x[1]^4 + (-4*f0*f3^2*f8 + 4*f1^2*f4*f8 - f1^2*f5*f7)*x[1]^3*x[2] +
(2*f0*f3*f5*f7 - 2*f1^2*f5*f8)*x[1]^3*x[3] + (-4*f0*f3*f5*f8 + 4*f1^2*f6*f8 -
f1^2*f7^2)*x[1]^3*x[5] + f1^2*f6*x[1]^2*x[2]^2 + (-4*f0*f3*f6 +
f1^2*f7)*x[1]^2*x[2]*x[3] + (2*f0*f3*f7 - 4*f1^2*f8)*x[1]^2*x[2]*x[5] +
(-2*f0*f3*f7 + 4*f0*f4*f6 - f0*f5^2 + f1^2*f8)*x[1]^2*x[3]^2 + (4*f0*f3*f8 -
4*f0*f4*f7)*x[1]^2*x[3]*x[5] + (-4*f0*f4*f8 + 2*f1*f4*f7 -
f3^2*f6)*x[1]^2*x[4]^2 + (4*f0*f5*f8 - 4*f1*f4*f8 - f1*f5*f7 +
f3^2*f7)*x[1]^2*x[4]*x[6] + 2*f1*f5*f8*x[1]^2*x[4]*x[7] + (2*f0*f8 -
f1*f7)*x[1]^2*x[4]*x[8] + 4*f0*f4*f8*x[1]^2*x[5]^2 + (-4*f0*f6*f8 + f0*f7^2 +
2*f1*f5*f8 - f3^2*f8)*x[1]^2*x[6]^2 + (-4*f1*f6*f8 + f1*f7^2)*x[1]^2*x[6]*x[7] +
2*f1*f8*x[1]^2*x[6]*x[8] - f1^2*x[1]*x[2]^3 + 4*f0*f3*x[1]*x[2]^2*x[3] -
4*f0*f4*x[1]*x[2]*x[3]^2 + 2*f0*f5*x[1]*x[2]*x[3]*x[5] + (-f1*f5 +
f3^2)*x[1]*x[2]*x[4]^2 + (-2*f0*f7 + 2*f1*f6)*x[1]*x[2]*x[4]*x[6] -
2*f0*f8*x[1]*x[2]*x[4]*x[7] + (4*f0*f8 - f1*f7)*x[1]*x[2]*x[6]^2 +
2*f1*f8*x[1]*x[2]*x[6]*x[7] - f3*x[1]*x[2]*x[6]*x[8] + 2*f0*f5*x[1]*x[3]^3 -
4*f0*f6*x[1]*x[3]^2*x[5] + (-2*f0*f8 - f3*f5)*x[1]*x[3]*x[4]*x[6] + (-2*f1*f8 +
2*f3*f6)*x[1]*x[3]*x[4]*x[7] - f3*x[1]*x[3]*x[4]*x[8] + 4*f0*f7*x[1]*x[3]*x[5]^2
- f3*f7*x[1]*x[3]*x[6]*x[7] + f4*x[1]*x[3]*x[6]*x[8] - f5*x[1]*x[3]*x[7]*x[8] +
(2*f0*f8 - f1*f7 + f3*f5)*x[1]*x[4]^2*x[5] + 2*f1*f8*x[1]*x[4]*x[5]*x[6] -
f3*f7*x[1]*x[4]*x[5]*x[7] - f4*x[1]*x[4]*x[5]*x[8] - 4*f0*f8*x[1]*x[5]^3 +
2*f3*f8*x[1]*x[5]*x[6]*x[7] + f0*x[2]^2*x[4]^2 - f1*x[2]^2*x[4]*x[6] -
f0*x[2]^2*x[5]^2 + f3*x[2]^2*x[6]*x[7] + 2*f0*x[2]*x[3]^2*x[5] +
f1*x[2]*x[3]*x[4]^2 - f3*x[2]*x[3]*x[4]*x[7] - f4*x[2]*x[3]*x[6]*x[7] +
f5*x[2]*x[3]*x[7]^2 + f4*x[2]*x[4]*x[5]*x[7] - f0*x[3]^4 - f6*x[3]^2*x[7]^2 +
x[3]^2*x[7]*x[8] - x[3]*x[5]*x[6]*x[8] + f7*x[3]*x[5]*x[7]^2 + f4*x[4]^4 -
f5*x[4]^3*x[6] - x[4]^3*x[8] + f6*x[4]^2*x[6]^2 + f7*x[4]^2*x[6]*x[7] +
f8*x[4]^2*x[7]^2 + x[4]*x[5]^2*x[8] - f7*x[4]*x[6]^3 - 2*f8*x[4]*x[6]^2*x[7] -
f8*x[5]^2*x[7]^2 + f8*x[6]^4,

// no.24, (d,w) = (5,21)
  (-8*f0*f2*f5*f6*f8 + 2*f1^2*f5*f6*f8)*x[1]^4 + (8*f0*f2*f5*f8 + 4*f0*f2*f6*f7
- 2*f1^2*f5*f8 - f1^2*f6*f7)*x[1]^3*x[2] + (-8*f0*f2*f6*f8 + 4*f0*f2*f7^2 -
2*f0*f3*f6*f7 + 2*f1^2*f6*f8 - f1^2*f7^2)*x[1]^3*x[3] + (4*f0*f3*f6*f8 -
2*f0*f3*f7^2 + f1*f3*f6*f7)*x[1]^3*x[4] + 4*f0*f3*f6*f8*x[1]^3*x[5] -
2*f1*f3*f6*f8*x[1]^3*x[6] + 8*f0*f5*f6*f8*x[1]^3*x[7] + (-3*f0*f5*f8 -
f0*f6*f7)*x[1]^3*x[8] + (-4*f0*f2*f7 + f1^2*f7)*x[1]^2*x[2]^2 + (8*f0*f2*f8 +
2*f0*f3*f7 - 2*f1^2*f8)*x[1]^2*x[2]*x[3] + (-4*f0*f3*f8 -
f1*f3*f7)*x[1]^2*x[2]*x[4] - 4*f0*f3*f8*x[1]^2*x[2]*x[5] +
2*f1*f3*f8*x[1]^2*x[2]*x[6] + (-5*f0*f5*f8 - 3*f0*f6*f7)*x[1]^2*x[2]*x[7] +
2*f0*f7*x[1]^2*x[2]*x[8] + 2*f0*f5*f6*x[1]^2*x[3]^2 + (2*f0*f5*f7 -
2*f1*f5*f6)*x[1]^2*x[3]*x[4] + (-3*f0*f5*f8 + f0*f6*f7)*x[1]^2*x[3]*x[6] +
(8*f0*f6*f8 - 4*f0*f7^2 + f1*f6*f7)*x[1]^2*x[3]*x[7] - 3*f0*f8*x[1]^2*x[3]*x[8]
+ (4*f0*f5*f8 - f1*f5*f7 + 2*f2*f5*f6)*x[1]^2*x[4]^2 + (-f0*f5*f8 +
f0*f6*f7)*x[1]^2*x[4]*x[5] + (-4*f0*f6*f8 + 2*f0*f7^2 + 2*f1*f5*f8 -
f1*f6*f7)*x[1]^2*x[4]*x[6] + (-2*f1*f6*f8 + f1*f7^2 -
2*f2*f6*f7)*x[1]^2*x[4]*x[7] + f2*f7*x[1]^2*x[4]*x[8] -
4*f0*f6*f8*x[1]^2*x[5]*x[6] - 2*f1*f6*f8*x[1]^2*x[5]*x[7] +
2*f1*f8*x[1]^2*x[5]*x[8] + 2*f1*f6*f8*x[1]^2*x[6]^2 +
4*f2*f6*f8*x[1]^2*x[6]*x[7] - 2*f2*f8*x[1]^2*x[6]*x[8] +
2*f0*f7*x[1]*x[2]^2*x[7] - 2*f0*f5*x[1]*x[2]*x[3]^2 + (-2*f0*f6 +
2*f1*f5)*x[1]*x[2]*x[3]*x[4] - 2*f0*f6*x[1]*x[2]*x[3]*x[5] +
f1*f6*x[1]*x[2]*x[3]*x[6] + (-5*f0*f8 - f1*f7)*x[1]*x[2]*x[3]*x[7] + (-2*f0*f7 +
f1*f6 - 2*f2*f5)*x[1]*x[2]*x[4]^2 + f1*f6*x[1]*x[2]*x[4]*x[5] + (4*f0*f8 -
2*f2*f6)*x[1]*x[2]*x[4]*x[6] + (2*f1*f8 + f2*f7)*x[1]*x[2]*x[4]*x[7] +
4*f0*f8*x[1]*x[2]*x[5]*x[6] - 2*f1*f8*x[1]*x[2]*x[6]^2 -
2*f2*f8*x[1]*x[2]*x[6]*x[7] + 2*f0*f6*x[1]*x[3]^3 + (2*f0*f7 -
2*f1*f6)*x[1]*x[3]^2*x[4] - 4*f0*f7*x[1]*x[3]^2*x[5] + (-3*f0*f8 +
2*f1*f7)*x[1]*x[3]^2*x[6] + (-f1*f7 + 2*f2*f6)*x[1]*x[3]*x[4]^2 + (-f0*f8 +
2*f1*f7)*x[1]*x[3]*x[4]*x[5] + (2*f1*f8 - 3*f2*f7 + f3*f6)*x[1]*x[3]*x[4]*x[6] +
4*f0*f8*x[1]*x[3]*x[5]^2 - 2*f1*f8*x[1]*x[3]*x[5]*x[6] +
2*f2*f8*x[1]*x[3]*x[6]^2 + f6*x[1]*x[3]*x[7]*x[8] - f3*f6*x[1]*x[4]^3 + (-f2*f7
- f3*f6)*x[1]*x[4]^2*x[5] + 2*f3*f7*x[1]*x[4]^2*x[6] - 2*f5*f6*x[1]*x[4]^2*x[7]
+ f5*x[1]*x[4]^2*x[8] - 2*f1*f8*x[1]*x[4]*x[5]^2 + 2*f2*f8*x[1]*x[4]*x[5]*x[6] -
2*f3*f8*x[1]*x[4]*x[6]^2 + f6*x[1]*x[4]*x[6]*x[8] + 2*f6*f7*x[1]*x[4]*x[7]^2 -
2*f7*x[1]*x[4]*x[7]*x[8] - 4*f6*f8*x[1]*x[6]*x[7]^2 + 2*f8*x[1]*x[6]*x[7]*x[8] +
2*f0*x[2]^2*x[3]*x[4] + 2*f0*x[2]^2*x[3]*x[5] - f1*x[2]^2*x[3]*x[6] -
f1*x[2]^2*x[4]^2 - f1*x[2]^2*x[4]*x[5] + 2*f2*x[2]^2*x[4]*x[6] -
2*f0*x[2]*x[3]^3 + 2*f1*x[2]*x[3]^2*x[4] - 2*f2*x[2]*x[3]*x[4]^2 -
f3*x[2]*x[3]*x[4]*x[6] - f6*x[2]*x[3]*x[7]^2 + f3*x[2]*x[4]^3 +
f3*x[2]*x[4]^2*x[5] + f5*x[2]*x[4]^2*x[7] + f6*x[2]*x[4]*x[6]*x[7] -
2*x[2]*x[4]*x[6]*x[8] + 2*f8*x[2]*x[6]*x[7]^2 + x[3]^2*x[6]*x[8] -
f6*x[3]*x[4]^2*x[7] + x[3]*x[4]^2*x[8] - x[3]*x[4]*x[5]*x[8] +
f7*x[3]*x[4]*x[6]*x[7] - 2*f8*x[3]*x[6]^2*x[7] - f5*x[4]^4 + f6*x[4]^3*x[6] +
f7*x[4]^3*x[7] + f7*x[4]^2*x[5]*x[7] - 2*f7*x[4]^2*x[6]^2 -
2*f8*x[4]^2*x[6]*x[7] + 2*f8*x[4]*x[6]^3,

// no.25, (d,w) = (5,21)
  -2*f1*f3*f5*f8*x[1]^3*x[4] + (4*f1*f3*f6*f8 - f1*f3*f7^2)*x[1]^3*x[6] +
(-8*f1*f4*f6*f8 + 2*f1*f4*f7^2 + 2*f1*f5^2*f8)*x[1]^3*x[7] + (3*f1*f4*f8 -
f1*f5*f7)*x[1]^3*x[8] + f1*f3*f7*x[1]^2*x[2]*x[4] - 4*f1*f3*f8*x[1]^2*x[2]*x[6]
+ (5*f1*f4*f8 - f1*f5*f7)*x[1]^2*x[2]*x[7] + f1*f6*x[1]^2*x[2]*x[8] +
(2*f1*f3*f8 - 2*f1*f4*f7)*x[1]^2*x[3]*x[4] + 3*f1*f4*f8*x[1]^2*x[3]*x[6] -
4*f1*f5*f8*x[1]^2*x[3]*x[7] + f1*f7*x[1]^2*x[3]*x[8] + (-4*f1*f4*f8 + 4*f2*f4*f7
- f3^2*f7)*x[1]^2*x[4]^2 + (f1*f4*f8 + f1*f5*f7)*x[1]^2*x[4]*x[5] + (4*f1*f5*f8
- 8*f2*f4*f8 - 2*f2*f5*f7 + 2*f3^2*f8)*x[1]^2*x[4]*x[6] + (4*f2*f5*f8 +
f3*f5*f7)*x[1]^2*x[4]*x[7] + (2*f1*f8 - 2*f2*f7)*x[1]^2*x[4]*x[8] -
2*f1*f5*f8*x[1]^2*x[5]*x[6] + (8*f1*f6*f8 - 2*f1*f7^2)*x[1]^2*x[5]*x[7] -
4*f1*f8*x[1]^2*x[5]*x[8] + (-4*f1*f6*f8 + f1*f7^2 + 4*f2*f5*f8)*x[1]^2*x[6]^2 +
(-8*f2*f6*f8 + 2*f2*f7^2 - 2*f3*f5*f8)*x[1]^2*x[6]*x[7] +
5*f2*f8*x[1]^2*x[6]*x[8] + (4*f3*f6*f8 - f3*f7^2)*x[1]^2*x[7]^2 -
2*f3*f8*x[1]^2*x[7]*x[8] + f1*f6*x[1]*x[2]^2*x[7] - f1*x[1]*x[2]^2*x[8] +
f1*f5*x[1]*x[2]*x[3]*x[4] - f1*f6*x[1]*x[2]*x[3]*x[6] +
f1*f7*x[1]*x[2]*x[3]*x[7] - 2*f2*f5*x[1]*x[2]*x[4]^2 - f1*f6*x[1]*x[2]*x[4]*x[5]
+ (-2*f1*f7 + 4*f2*f6)*x[1]*x[2]*x[4]*x[6] + (-2*f1*f8 -
2*f3*f6)*x[1]*x[2]*x[4]*x[7] + f3*x[1]*x[2]*x[4]*x[8] +
f1*f7*x[1]*x[2]*x[5]*x[6] - 4*f1*f8*x[1]*x[2]*x[5]*x[7] + (4*f1*f8 -
2*f2*f7)*x[1]*x[2]*x[6]^2 + (3*f2*f8 + f3*f7)*x[1]*x[2]*x[6]*x[7] -
2*f3*f8*x[1]*x[2]*x[7]^2 + 2*f1*f8*x[1]*x[3]^2*x[7] + f3*f5*x[1]*x[3]*x[4]^2 +
f1*f7*x[1]*x[3]*x[4]*x[5] + (-2*f1*f8 - 2*f3*f6)*x[1]*x[3]*x[4]*x[6] + (-4*f2*f8
+ 4*f4*f6 - f5^2)*x[1]*x[3]*x[4]*x[7] - 2*f4*x[1]*x[3]*x[4]*x[8] -
2*f1*f8*x[1]*x[3]*x[5]*x[6] + (f2*f8 + f3*f7)*x[1]*x[3]*x[6]^2 -
2*f4*f7*x[1]*x[3]*x[6]*x[7] + f5*x[1]*x[3]*x[6]*x[8] + f5*f7*x[1]*x[3]*x[7]^2 -
2*f6*x[1]*x[3]*x[7]*x[8] + (2*f1*f8 - 2*f2*f7)*x[1]*x[4]^2*x[5] +
f3*f7*x[1]*x[4]^2*x[6] + (2*f3*f8 - 2*f4*f7)*x[1]*x[4]^2*x[7] +
f5*x[1]*x[4]^2*x[8] + (3*f2*f8 + f3*f7)*x[1]*x[4]*x[5]*x[6] -
2*f4*f7*x[1]*x[4]*x[5]*x[7] - 2*f3*f8*x[1]*x[4]*x[6]^2 + (4*f4*f8 +
f5*f7)*x[1]*x[4]*x[6]*x[7] - f6*x[1]*x[4]*x[6]*x[8] - 2*f5*f8*x[1]*x[4]*x[7]^2 +
f7*x[1]*x[4]*x[7]*x[8] - 2*f3*f8*x[1]*x[5]*x[6]^2 + 4*f4*f8*x[1]*x[5]*x[6]*x[7]
- 2*f5*f8*x[1]*x[5]*x[7]^2 + f7*x[1]*x[5]*x[7]*x[8] - 2*f5*f8*x[1]*x[6]^2*x[7] +
(4*f6*f8 - f7^2)*x[1]*x[6]*x[7]^2 - 3*f8*x[1]*x[6]*x[7]*x[8] - f1*x[2]^3*x[7] +
f1*x[2]^2*x[3]*x[6] + f1*x[2]^2*x[4]^2 - 2*f2*x[2]^2*x[4]*x[6] +
f3*x[2]^2*x[4]*x[7] - f1*x[2]*x[3]^2*x[4] + 2*f2*x[2]*x[3]*x[4]^2 +
f3*x[2]*x[3]*x[4]*x[6] - 2*f4*x[2]*x[3]*x[4]*x[7] + 2*x[2]*x[3]*x[7]*x[8] -
f3*x[2]*x[4]^3 + f5*x[2]*x[4]*x[5]*x[7] - f6*x[2]*x[4]*x[6]*x[7] +
x[2]*x[4]*x[6]*x[8] - x[2]*x[5]*x[6]*x[8] + f7*x[2]*x[6]^2*x[7] -
f8*x[2]*x[6]*x[7]^2 - f3*x[3]^2*x[4]^2 + f5*x[3]^2*x[4]*x[7] - x[3]^2*x[6]*x[8]
- f7*x[3]^2*x[7]^2 + 2*f4*x[3]*x[4]^3 - f5*x[3]*x[4]^2*x[6] - 2*x[3]*x[4]^2*x[8]
- 2*f6*x[3]*x[4]*x[5]*x[7] + 2*x[3]*x[4]*x[5]*x[8] + f6*x[3]*x[4]*x[6]^2 +
f7*x[3]*x[4]*x[6]*x[7] + 2*f8*x[3]*x[4]*x[7]^2 + f7*x[3]*x[5]*x[6]*x[7] +
2*f8*x[3]*x[5]*x[7]^2 - f7*x[3]*x[6]^3 - f8*x[3]*x[6]^2*x[7] - f5*x[4]^3*x[5] +
f6*x[4]^2*x[5]*x[6] + f7*x[4]^2*x[5]*x[7] + f7*x[4]*x[5]^2*x[7] -
f7*x[4]*x[5]*x[6]^2 - 3*f8*x[4]*x[5]*x[6]*x[7] - 2*f8*x[5]^2*x[6]*x[7] +
2*f8*x[5]*x[6]^3,

// no.26, (d,w) = (5,22)
  (-4*f0*f3*f5*f6*f8 + 2*f0*f3*f5*f7^2)*x[1]^4 + (4*f0*f3*f5*f8 -
2*f0*f3*f6*f7)*x[1]^3*x[2] + (-4*f0*f3*f6*f8 + 4*f0*f4*f6*f7 -
2*f0*f5^2*f7)*x[1]^3*x[3] + (8*f0*f4*f6*f8 - 4*f0*f5^2*f8 - 2*f1*f4*f6*f7 +
f1*f5^2*f7)*x[1]^3*x[4] + (8*f0*f4*f6*f8 - 4*f0*f4*f7^2)*x[1]^3*x[5] +
(4*f0*f5*f6*f8 - 2*f0*f5*f7^2 - 4*f1*f4*f6*f8 + 2*f1*f4*f7^2)*x[1]^3*x[6] +
(2*f1*f5*f6*f8 - f1*f5*f7^2)*x[1]^3*x[7] + (-3*f0*f6*f8 + f1*f6*f7)*x[1]^3*x[8]
+ 2*f0*f3*f7*x[1]^2*x[2]^2 + (4*f0*f3*f8 - 4*f0*f4*f7 +
2*f0*f5*f6)*x[1]^2*x[2]*x[3] + (-8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f4*f7 -
f1*f5*f6)*x[1]^2*x[2]*x[4] + (-8*f0*f4*f8 + 2*f0*f5*f7)*x[1]^2*x[2]*x[5] +
(-4*f0*f5*f8 + 2*f0*f6*f7 + 4*f1*f4*f8 - f1*f5*f7)*x[1]^2*x[2]*x[6] +
(3*f0*f6*f8 - 2*f1*f5*f8)*x[1]^2*x[2]*x[7] + (3*f0*f8 - f1*f7)*x[1]^2*x[2]*x[8]
+ 2*f0*f5*f7*x[1]^2*x[3]^2 + (4*f0*f5*f8 - f1*f5*f7)*x[1]^2*x[3]*x[4] +
(4*f0*f5*f8 - 4*f0*f6*f7)*x[1]^2*x[3]*x[5] + (f0*f6*f8 - 2*f1*f5*f8 +
f1*f6*f7)*x[1]^2*x[3]*x[6] + 2*f1*f6*f8*x[1]^2*x[3]*x[7] -
f1*f8*x[1]^2*x[3]*x[8] + f3*f5*f6*x[1]^2*x[4]^2 + (-5*f0*f6*f8 +
f1*f6*f7)*x[1]^2*x[4]*x[5] - f3*f5*f7*x[1]^2*x[4]*x[6] +
f3*f6*f7*x[1]^2*x[4]*x[7] - f4*f6*x[1]^2*x[4]*x[8] + (-8*f0*f6*f8 +
4*f0*f7^2)*x[1]^2*x[5]^2 + (4*f1*f6*f8 - 2*f1*f7^2)*x[1]^2*x[5]*x[6] +
(2*f3*f6*f8 - f3*f7^2)*x[1]^2*x[6]*x[7] + (-f3*f8 + f4*f7)*x[1]^2*x[6]*x[8] -
f5*f7*x[1]^2*x[7]*x[8] - 2*f0*f5*x[1]*x[2]^2*x[3] + (-2*f0*f6 +
f1*f5)*x[1]*x[2]^2*x[4] - 2*f0*f6*x[1]*x[2]^2*x[5] + (-2*f0*f7 +
f1*f6)*x[1]*x[2]^2*x[6] - 3*f0*f8*x[1]*x[2]^2*x[7] + 2*f0*f6*x[1]*x[2]*x[3]^2 -
f1*f6*x[1]*x[2]*x[3]*x[4] + (-f0*f8 + f1*f7)*x[1]*x[2]*x[3]*x[6] -
f1*f8*x[1]*x[2]*x[3]*x[7] - f3*f5*x[1]*x[2]*x[4]^2 + (5*f0*f8 -
f1*f7)*x[1]*x[2]*x[4]*x[5] - f3*f6*x[1]*x[2]*x[4]*x[6] + (-f3*f7 +
f4*f6)*x[1]*x[2]*x[4]*x[7] + f4*x[1]*x[2]*x[4]*x[8] + 8*f0*f8*x[1]*x[2]*x[5]^2 -
4*f1*f8*x[1]*x[2]*x[5]*x[6] + f3*f7*x[1]*x[2]*x[6]^2 + (-f3*f8 -
f4*f7)*x[1]*x[2]*x[6]*x[7] + f5*f7*x[1]*x[2]*x[7]^2 - 4*f0*f8*x[1]*x[3]^2*x[5] +
f1*f8*x[1]*x[3]^2*x[6] + f3*f6*x[1]*x[3]*x[4]^2 + f1*f8*x[1]*x[3]*x[4]*x[5] +
(-f3*f7 + f4*f6)*x[1]*x[3]*x[4]*x[6] - f5*f6*x[1]*x[3]*x[4]*x[7] + (f3*f8 -
f4*f7)*x[1]*x[3]*x[6]^2 + f5*f7*x[1]*x[3]*x[6]*x[7] - f6*f7*x[1]*x[3]*x[7]^2 +
f7*x[1]*x[3]*x[7]*x[8] + (-2*f4*f6 + f5^2)*x[1]*x[4]^3 - f4*f6*x[1]*x[4]^2*x[5]
+ (2*f4*f7 - f5*f6)*x[1]*x[4]^2*x[6] - f5*f7*x[1]*x[4]^2*x[7] +
f6*x[1]*x[4]^2*x[8] + (f3*f8 + f4*f7)*x[1]*x[4]*x[5]*x[6] +
2*f6*x[1]*x[4]*x[5]*x[8] + (-4*f4*f8 + f5*f7)*x[1]*x[4]*x[6]^2 + (4*f5*f8 -
f6*f7)*x[1]*x[4]*x[6]*x[7] - f7*x[1]*x[4]*x[6]*x[8] - 2*f6*f8*x[1]*x[4]*x[7]^2 +
f8*x[1]*x[4]*x[7]*x[8] - f7*x[1]*x[5]*x[6]*x[8] + (-2*f6*f8 +
f7^2)*x[1]*x[5]*x[7]^2 + f8*x[1]*x[5]*x[7]*x[8] + (-2*f6*f8 +
f7^2)*x[1]*x[6]^2*x[7] + 2*f8*x[1]*x[6]^2*x[8] + 2*f0*x[2]^3*x[4] +
2*f0*x[2]^3*x[5] - f1*x[2]^3*x[6] - 2*f0*x[2]^2*x[3]^2 + f1*x[2]^2*x[3]*x[4] +
f3*x[2]^2*x[4]*x[6] - f4*x[2]^2*x[4]*x[7] - f3*x[2]*x[3]*x[4]^2 -
f4*x[2]*x[3]*x[4]*x[6] + f5*x[2]*x[3]*x[4]*x[7] - f6*x[2]*x[3]*x[6]*x[7] +
x[2]*x[3]*x[6]*x[8] + 2*f4*x[2]*x[4]^3 + f4*x[2]*x[4]^2*x[5] -
f5*x[2]*x[4]^2*x[6] + f6*x[2]*x[4]^2*x[7] - 2*x[2]*x[4]^2*x[8] -
2*x[2]*x[4]*x[5]*x[8] + f6*x[2]*x[4]*x[6]^2 + f7*x[2]*x[4]*x[6]*x[7] +
f8*x[2]*x[4]*x[7]^2 + f8*x[2]*x[5]*x[7]^2 - f7*x[2]*x[6]^3 + f5*x[3]^2*x[4]*x[6]
- f6*x[3]^2*x[4]*x[7] + x[3]^2*x[4]*x[8] - f5*x[3]*x[4]^3 - f5*x[3]*x[4]^2*x[5]
+ f7*x[3]*x[4]*x[5]*x[7] - f8*x[3]*x[4]*x[6]*x[7] + f7*x[3]*x[5]*x[6]^2 -
f8*x[3]*x[5]*x[6]*x[7] + f6*x[4]^3*x[5] - f7*x[4]^2*x[5]*x[6] -
f8*x[4]^2*x[5]*x[7] - f7*x[4]*x[5]^2*x[6] - f8*x[4]*x[5]^2*x[7] +
2*f8*x[4]*x[5]*x[6]^2,

// no.27, (d,w) = (5,22)
  (4*f1*f3*f4*f6*f8 - f1*f3*f4*f7^2)*x[1]^4 + (-4*f1*f3*f4*f8 +
f1*f3*f5*f7)*x[1]^3*x[2] + f1*f4*f5*f7*x[1]^3*x[3] + (2*f1*f4*f5*f8 -
2*f2*f4*f5*f7)*x[1]^3*x[4] + (-4*f1*f3*f6*f8 + f1*f3*f7^2 -
2*f1*f4*f5*f8)*x[1]^3*x[5] + (4*f1*f4*f6*f8 - f1*f4*f7^2 - 2*f1*f5^2*f8 +
4*f2*f4*f5*f8)*x[1]^3*x[6] + (-8*f2*f4*f6*f8 + 2*f2*f4*f7^2)*x[1]^3*x[7] +
(-2*f1*f5*f8 + 3*f2*f4*f8)*x[1]^3*x[8] - 2*f1*f3*f6*x[1]^2*x[2]^2 + (-f1*f3*f7 +
2*f1*f4*f6 - f1*f5^2)*x[1]^2*x[2]*x[3] + (f1*f4*f7 - 4*f2*f4*f6 + 2*f2*f5^2 +
2*f3^2*f6)*x[1]^2*x[2]*x[4] + (4*f1*f3*f8 - f1*f4*f7)*x[1]^2*x[2]*x[5] +
(-4*f1*f4*f8 + f1*f5*f7 + 2*f2*f4*f7 - f3^2*f7)*x[1]^2*x[2]*x[6] + (2*f1*f5*f8 +
5*f2*f4*f8 - 2*f2*f5*f7)*x[1]^2*x[2]*x[7] + (2*f2*f6 - f3*f5)*x[1]^2*x[2]*x[8] -
f1*f4*f7*x[1]^2*x[3]^2 + (-2*f1*f4*f8 + 2*f2*f4*f7 -
2*f3*f4*f6)*x[1]^2*x[3]*x[4] + (2*f1*f4*f8 - f1*f5*f7)*x[1]^2*x[3]*x[5] +
(2*f1*f5*f8 - f2*f4*f8 + f3*f4*f7)*x[1]^2*x[3]*x[6] + (f1*f8 +
f4*f5)*x[1]^2*x[3]*x[8] - f3*f4*f7*x[1]^2*x[4]^2 + (-3*f2*f4*f8 + 2*f2*f5*f7 +
f3*f4*f7)*x[1]^2*x[4]*x[5] + (2*f3*f4*f8 - f3*f5*f7)*x[1]^2*x[4]*x[6] +
2*f4*f5*f7*x[1]^2*x[4]*x[7] + (2*f4*f6 - f5^2)*x[1]^2*x[4]*x[8] +
2*f1*f5*f8*x[1]^2*x[5]^2 + (-4*f1*f6*f8 + f1*f7^2 - 4*f2*f5*f8 -
2*f3*f4*f8)*x[1]^2*x[5]*x[6] + (8*f2*f6*f8 - 2*f2*f7^2)*x[1]^2*x[5]*x[7] -
3*f2*f8*x[1]^2*x[5]*x[8] + 2*f3*f5*f8*x[1]^2*x[6]^2 + (-4*f3*f6*f8 + f3*f7^2 -
4*f4*f5*f8)*x[1]^2*x[6]*x[7] + f3*f8*x[1]^2*x[6]*x[8] + (8*f4*f6*f8 -
2*f4*f7^2)*x[1]^2*x[7]^2 - 4*f4*f8*x[1]^2*x[7]*x[8] - f6*x[1]^2*x[8]^2 +
2*f1*f3*x[1]*x[2]^3 - 2*f1*f4*x[1]*x[2]^2*x[3] + (-f1*f5 + 4*f2*f4 -
2*f3^2)*x[1]*x[2]^2*x[4] + f1*f5*x[1]*x[2]^2*x[5] - 2*f2*f5*x[1]*x[2]^2*x[6] +
(2*f2*f6 + f3*f5)*x[1]*x[2]^2*x[7] - 2*f2*x[1]*x[2]^2*x[8] +
2*f1*f5*x[1]*x[2]*x[3]^2 + (-4*f2*f5 + 2*f3*f4)*x[1]*x[2]*x[3]*x[4] -
2*f1*f6*x[1]*x[2]*x[3]*x[5] + (-f1*f7 + 2*f2*f6)*x[1]*x[2]*x[3]*x[6] + (-f1*f8 +
2*f2*f7 - 2*f3*f6 - f4*f5)*x[1]*x[2]*x[3]*x[7] + f3*x[1]*x[2]*x[3]*x[8] +
2*f3*f5*x[1]*x[2]*x[4]^2 + (-f1*f7 + 2*f2*f6 - f3*f5)*x[1]*x[2]*x[4]*x[5] -
2*f3*f6*x[1]*x[2]*x[4]*x[6] + (-f3*f7 + 2*f4*f6 - f5^2)*x[1]*x[2]*x[4]*x[7] -
2*f4*x[1]*x[2]*x[4]*x[8] + f1*f7*x[1]*x[2]*x[5]^2 + (4*f1*f8 -
2*f2*f7)*x[1]*x[2]*x[5]*x[6] + (-5*f2*f8 + f3*f7)*x[1]*x[2]*x[5]*x[7] +
f3*f7*x[1]*x[2]*x[6]^2 + (3*f3*f8 - 2*f4*f7)*x[1]*x[2]*x[6]*x[7] +
f5*x[1]*x[2]*x[6]*x[8] + (-4*f4*f8 + 2*f5*f7)*x[1]*x[2]*x[7]^2 -
2*f6*x[1]*x[2]*x[7]*x[8] + f1*f7*x[1]*x[3]^2*x[5] - f1*f8*x[1]*x[3]^2*x[6] +
2*f4*f6*x[1]*x[3]^2*x[7] - f4*x[1]*x[3]^2*x[8] - f4*f5*x[1]*x[3]*x[4]^2 + (f1*f8
- 2*f2*f7 + 2*f3*f6)*x[1]*x[3]*x[4]*x[5] + f3*f7*x[1]*x[3]*x[4]*x[6] +
2*f5*x[1]*x[3]*x[4]*x[8] - 2*f1*f8*x[1]*x[3]*x[5]^2 + (f2*f8 -
f3*f7)*x[1]*x[3]*x[5]*x[6] - 2*f4*f7*x[1]*x[3]*x[5]*x[7] + (-f3*f8 +
f4*f7)*x[1]*x[3]*x[6]^2 - f5*f7*x[1]*x[3]*x[6]*x[7] - f7*x[1]*x[3]*x[7]*x[8] +
(f3*f7 - 2*f4*f6 + f5^2)*x[1]*x[4]^2*x[5] - f4*f7*x[1]*x[4]^2*x[6] +
2*f4*f8*x[1]*x[4]^2*x[7] + (3*f2*f8 - f3*f7)*x[1]*x[4]*x[5]^2 + (-3*f3*f8 +
f4*f7)*x[1]*x[4]*x[5]*x[6] - 2*f5*f7*x[1]*x[4]*x[5]*x[7] + (2*f4*f8 +
f5*f7)*x[1]*x[4]*x[6]^2 - 2*f5*f8*x[1]*x[4]*x[6]*x[7] + f7*x[1]*x[4]*x[6]*x[8] -
f8*x[1]*x[4]*x[7]*x[8] + 2*f3*f8*x[1]*x[5]^2*x[6] + 2*f4*f8*x[1]*x[5]^2*x[7] -
2*f4*f8*x[1]*x[5]*x[6]^2 + 6*f5*f8*x[1]*x[5]*x[6]*x[7] + (-8*f6*f8 +
2*f7^2)*x[1]*x[5]*x[7]^2 + 4*f8*x[1]*x[5]*x[7]*x[8] - 2*f5*f8*x[1]*x[6]^3 +
(4*f6*f8 - f7^2)*x[1]*x[6]^2*x[7] - 2*f8*x[1]*x[6]^2*x[8] - 2*f2*x[2]^3*x[7] +
f1*x[2]^2*x[3]*x[4] + f1*x[2]^2*x[3]*x[5] + f3*x[2]^2*x[3]*x[7] -
2*f2*x[2]^2*x[4]*x[5] + f3*x[2]^2*x[4]*x[6] - 2*f4*x[2]^2*x[4]*x[7] +
f3*x[2]^2*x[5]*x[6] + f5*x[2]^2*x[6]*x[7] - f6*x[2]^2*x[7]^2 +
4*x[2]^2*x[7]*x[8] - f1*x[2]*x[3]^3 + 2*f2*x[2]*x[3]^2*x[4] -
f4*x[2]*x[3]^2*x[7] - 2*f3*x[2]*x[3]*x[4]^2 - f3*x[2]*x[3]*x[4]*x[5] +
f4*x[2]*x[3]*x[4]*x[6] + f5*x[2]*x[3]*x[4]*x[7] - f4*x[2]*x[3]*x[5]*x[6] +
f5*x[2]*x[3]*x[5]*x[7] - f5*x[2]*x[3]*x[6]^2 - 2*x[2]*x[3]*x[6]*x[8] -
f7*x[2]*x[3]*x[7]^2 + f4*x[2]*x[4]^3 - f5*x[2]*x[4]^2*x[6] - x[2]*x[4]^2*x[8] +
f4*x[2]*x[4]*x[5]^2 + 2*x[2]*x[4]*x[5]*x[8] + f7*x[2]*x[4]*x[6]*x[7] +
f8*x[2]*x[4]*x[7]^2 - x[2]*x[5]^2*x[8] + 4*f8*x[2]*x[5]*x[7]^2 -
2*f8*x[2]*x[6]^2*x[7] + f4*x[3]^2*x[4]^2 - x[3]^2*x[4]*x[8] +
f5*x[3]^2*x[5]*x[6] - 2*f6*x[3]^2*x[5]*x[7] + x[3]^2*x[5]*x[8] +
f6*x[3]^2*x[6]^2 - f5*x[3]*x[4]^2*x[5] - f5*x[3]*x[4]*x[5]^2 +
f7*x[3]*x[4]*x[5]*x[7] + f8*x[3]*x[4]*x[6]*x[7] + 2*f7*x[3]*x[5]^2*x[7] -
f7*x[3]*x[5]*x[6]^2 - 2*f8*x[3]*x[5]*x[6]*x[7] + f6*x[4]^2*x[5]^2 -
f8*x[4]^2*x[5]*x[7] - f7*x[4]*x[5]^2*x[6] - 2*f8*x[5]^3*x[7] +
2*f8*x[5]^2*x[6]^2,

// no.28, (d,w) = (5,23)
  -2*f1*f3*f5*f8*x[1]^3*x[2] + (4*f1*f3*f6*f8 - f1*f3*f7^2)*x[1]^3*x[3] +
(-8*f1*f4*f6*f8 + 2*f1*f4*f7^2 + 2*f1*f5^2*f8)*x[1]^3*x[4] + (3*f1*f6*f8 -
f1*f7^2)*x[1]^3*x[8] + f1*f3*f7*x[1]^2*x[2]^2 + (-2*f1*f3*f8 -
2*f1*f4*f7)*x[1]^2*x[2]*x[3] + (4*f1*f4*f8 - 2*f1*f5*f7 + 4*f2*f4*f7 -
f3^2*f7)*x[1]^2*x[2]*x[4] + 4*f1*f4*f8*x[1]^2*x[2]*x[5] + (2*f1*f5*f8 -
8*f2*f4*f8 + 2*f3^2*f8)*x[1]^2*x[2]*x[6] + (-3*f1*f6*f8 + f1*f7^2 +
4*f2*f5*f8)*x[1]^2*x[2]*x[7] + (-f1*f8 - f2*f7)*x[1]^2*x[2]*x[8] +
f1*f5*f7*x[1]^2*x[3]^2 + (-2*f1*f5*f8 - 2*f2*f5*f7)*x[1]^2*x[3]*x[4] -
2*f1*f5*f8*x[1]^2*x[3]*x[5] + (-f1*f6*f8 + 4*f2*f5*f8)*x[1]^2*x[3]*x[6] +
(-8*f2*f6*f8 + 2*f2*f7^2)*x[1]^2*x[3]*x[7] + 2*f2*f8*x[1]^2*x[3]*x[8] +
f3*f5*f7*x[1]^2*x[4]^2 + (5*f1*f6*f8 - f1*f7^2)*x[1]^2*x[4]*x[5] -
2*f3*f5*f8*x[1]^2*x[4]*x[6] + (4*f3*f6*f8 - f3*f7^2)*x[1]^2*x[4]*x[7] +
(-2*f3*f8 - f4*f7)*x[1]^2*x[4]*x[8] + 3*f4*f8*x[1]^2*x[6]*x[8] +
f1*f5*x[1]*x[2]^2*x[3] + (2*f1*f6 - 2*f2*f5)*x[1]*x[2]^2*x[4] -
f1*f7*x[1]*x[2]^2*x[6] + (f1*f8 - f2*f7)*x[1]*x[2]^2*x[7] + f3*x[1]*x[2]^2*x[8]
- 2*f1*f6*x[1]*x[2]*x[3]^2 + (f1*f7 + 4*f2*f6 + f3*f5)*x[1]*x[2]*x[3]*x[4] +
3*f1*f7*x[1]*x[2]*x[3]*x[5] + (f1*f8 - 3*f2*f7)*x[1]*x[2]*x[3]*x[6] + (2*f2*f8 +
f3*f7)*x[1]*x[2]*x[3]*x[7] - f4*x[1]*x[2]*x[3]*x[8] - 2*f3*f6*x[1]*x[2]*x[4]^2 +
(-3*f1*f8 - 3*f2*f7)*x[1]*x[2]*x[4]*x[5] + 3*f3*f7*x[1]*x[2]*x[4]*x[6] -
3*f4*f7*x[1]*x[2]*x[4]*x[7] + f5*x[1]*x[2]*x[4]*x[8] - 4*f1*f8*x[1]*x[2]*x[5]^2
+ 8*f2*f8*x[1]*x[2]*x[5]*x[6] - 2*f3*f8*x[1]*x[2]*x[5]*x[7] -
4*f3*f8*x[1]*x[2]*x[6]^2 + 5*f4*f8*x[1]*x[2]*x[6]*x[7] -
4*f5*f8*x[1]*x[2]*x[7]^2 + f7*x[1]*x[2]*x[7]*x[8] - f1*f7*x[1]*x[3]^3 + (2*f2*f7
- 2*f3*f6)*x[1]*x[3]^2*x[4] + 2*f1*f8*x[1]*x[3]^2*x[5] + (-2*f2*f8 +
f3*f7)*x[1]*x[3]^2*x[6] + (-2*f3*f7 + 4*f4*f6 - f5^2)*x[1]*x[3]*x[4]^2 +
(-2*f2*f8 + f3*f7)*x[1]*x[3]*x[4]*x[5] + (2*f3*f8 - 3*f4*f7)*x[1]*x[3]*x[4]*x[6]
+ 3*f5*f7*x[1]*x[3]*x[4]*x[7] - 3*f6*x[1]*x[3]*x[4]*x[8] -
2*f3*f8*x[1]*x[3]*x[5]*x[6] + 3*f4*f8*x[1]*x[3]*x[6]^2 -
4*f5*f8*x[1]*x[3]*x[6]*x[7] + f7*x[1]*x[3]*x[6]*x[8] + (8*f6*f8 -
2*f7^2)*x[1]*x[3]*x[7]^2 - 3*f8*x[1]*x[3]*x[7]*x[8] + 2*f4*f7*x[1]*x[4]^3 +
(2*f3*f8 - f4*f7)*x[1]*x[4]^2*x[5] + (-4*f4*f8 - f5*f7)*x[1]*x[4]^2*x[6] +
2*f5*f8*x[1]*x[4]^2*x[7] - f7*x[1]*x[4]^2*x[8] + f4*f8*x[1]*x[4]*x[5]*x[6] -
2*f5*f8*x[1]*x[4]*x[5]*x[7] + f7*x[1]*x[4]*x[5]*x[8] + 2*f5*f8*x[1]*x[4]*x[6]^2
+ (-4*f6*f8 + f7^2)*x[1]*x[4]*x[6]*x[7] + 2*f8*x[1]*x[4]*x[6]*x[8] -
3*f8*x[1]*x[5]*x[6]*x[8] - f1*x[2]^3*x[4] - f1*x[2]^3*x[5] + 2*f2*x[2]^3*x[6] -
f3*x[2]^3*x[7] + f1*x[2]^2*x[3]^2 - 2*f2*x[2]^2*x[3]*x[4] - f3*x[2]^2*x[3]*x[6]
+ f4*x[2]^2*x[3]*x[7] + f3*x[2]^2*x[4]^2 + f5*x[2]^2*x[4]*x[7] -
2*x[2]^2*x[6]*x[8] + f7*x[2]^2*x[7]^2 + f3*x[2]*x[3]^2*x[4] +
f4*x[2]*x[3]^2*x[6] - f5*x[2]*x[3]^2*x[7] - 2*f4*x[2]*x[3]*x[4]^2 -
f4*x[2]*x[3]*x[4]*x[5] + f5*x[2]*x[3]*x[4]*x[6] - 3*f6*x[2]*x[3]*x[4]*x[7] +
3*x[2]*x[3]*x[4]*x[8] + x[2]*x[3]*x[5]*x[8] + f7*x[2]*x[3]*x[6]*x[7] -
f8*x[2]*x[3]*x[7]^2 - f5*x[2]*x[4]^3 + 2*f6*x[2]*x[4]^2*x[6] +
3*f7*x[2]*x[4]*x[5]*x[7] - 2*f7*x[2]*x[4]*x[6]^2 - 3*f8*x[2]*x[5]*x[6]*x[7] +
2*f8*x[2]*x[6]^3 - f5*x[3]^3*x[6] + 2*f6*x[3]^3*x[7] - x[3]^3*x[8] +
f5*x[3]^2*x[4]^2 + f5*x[3]^2*x[4]*x[5] - f6*x[3]^2*x[4]*x[6] -
f7*x[3]^2*x[4]*x[7] - 2*f7*x[3]^2*x[5]*x[7] + f8*x[3]^2*x[6]*x[7] -
f6*x[3]*x[4]^2*x[5] + f7*x[3]*x[4]^2*x[6] + f7*x[3]*x[4]*x[5]*x[6] +
f8*x[3]*x[4]*x[5]*x[7] - 2*f8*x[3]*x[4]*x[6]^2 + 2*f8*x[3]*x[5]^2*x[7] -
f8*x[3]*x[5]*x[6]^2 - f7*x[4]^3*x[5] + f7*x[4]^2*x[5]^2 + 2*f8*x[4]^2*x[5]*x[6]
- f8*x[4]*x[5]^2*x[6],

// no.29, (d,w) = (6,22)
  (4*f0*f2*f3^2*f6*f8 - f0*f2*f3^2*f7^2 + 4*f1^2*f2*f4*f6*f8 - f1^2*f2*f4*f7^2 -
f1^2*f2*f5^2*f8)*x[1]^4 + (-4*f0*f2*f3^2*f8 - 4*f1^2*f2*f4*f8 +
f1^2*f2*f5*f7)*x[1]^3*x[2] + (2*f0*f1*f3*f5*f8 + 2*f1^2*f2*f5*f8)*x[1]^3*x[3] -
f1*f2*f3*f5*f7*x[1]^3*x[4] + (-4*f0*f1*f3*f6*f8 + f0*f1*f3*f7^2 -
4*f1^2*f2*f6*f8 + f1^2*f2*f7^2)*x[1]^3*x[5] + 2*f1*f2*f3*f5*f8*x[1]^3*x[6] +
(-4*f0*f3^2*f6*f8 + f0*f3^2*f7^2 - 4*f1*f2*f3*f6*f8 + f1*f2*f3*f7^2)*x[1]^3*x[7]
+ (2*f0*f3^2*f8 + 2*f1*f2*f3*f8)*x[1]^3*x[8] - f1^2*f2*f6*x[1]^2*x[2]^2 +
(-f0*f1*f3*f7 - f1^2*f2*f7)*x[1]^2*x[2]*x[3] + 2*f1*f2*f3*f6*x[1]^2*x[2]*x[4] +
(4*f0*f1*f3*f8 + 4*f1^2*f2*f8)*x[1]^2*x[2]*x[5] - f1*f2*f3*f7*x[1]^2*x[2]*x[6] +
(2*f0*f3^2*f8 + 2*f1*f2*f3*f8)*x[1]^2*x[2]*x[7] + (-2*f0*f1*f3*f8 +
2*f0*f1*f4*f7 - 4*f0*f2*f4*f6 + f0*f2*f5^2 - f1^2*f2*f8)*x[1]^2*x[3]^2 +
(4*f0*f1*f4*f8 + 8*f0*f2*f4*f7 - 3*f0*f3^2*f7 - 4*f1^2*f4*f7 +
f1*f2*f3*f7)*x[1]^2*x[3]*x[4] + (-4*f0*f1*f4*f8 - f0*f1*f5*f7 +
4*f0*f2*f4*f7)*x[1]^2*x[3]*x[5] + (-2*f0*f1*f5*f8 - 8*f0*f2*f4*f8 -
2*f0*f2*f5*f7 + 4*f0*f3^2*f8 + 4*f1^2*f4*f8 + f1^2*f5*f7)*x[1]^2*x[3]*x[6] +
(4*f0*f2*f5*f8 - 2*f1^2*f5*f8)*x[1]^2*x[3]*x[7] + (-f0*f1*f8 - 2*f0*f2*f7 +
f1^2*f7)*x[1]^2*x[3]*x[8] + (-4*f0*f2*f4*f8 - f2*f3^2*f6)*x[1]^2*x[4]^2 +
(-2*f0*f1*f5*f8 - 8*f0*f2*f4*f8 - 2*f0*f2*f5*f7 + 2*f0*f3^2*f8 + 4*f1^2*f4*f8 +
f1^2*f5*f7 - 2*f1*f2*f3*f8)*x[1]^2*x[4]*x[5] + (4*f0*f2*f5*f8 +
f2*f3^2*f7)*x[1]^2*x[4]*x[6] + f1*f3*f5*f7*x[1]^2*x[4]*x[7] + (2*f0*f2*f8 -
f0*f3*f7)*x[1]^2*x[4]*x[8] + (2*f0*f1*f5*f8 - 4*f0*f2*f4*f8)*x[1]^2*x[5]^2 +
(4*f0*f1*f6*f8 - f0*f1*f7^2 + 8*f0*f2*f5*f8 - 4*f1^2*f5*f8)*x[1]^2*x[5]*x[6] +
(-8*f0*f2*f6*f8 + 2*f0*f2*f7^2 + 4*f1^2*f6*f8 - f1^2*f7^2)*x[1]^2*x[5]*x[7] +
(4*f0*f2*f8 - f0*f3*f7 - 2*f1^2*f8)*x[1]^2*x[5]*x[8] + (-4*f0*f2*f6*f8 +
f0*f2*f7^2 - f2*f3^2*f8)*x[1]^2*x[6]^2 - 2*f1*f3*f5*f8*x[1]^2*x[6]*x[7] +
f0*f3*f8*x[1]^2*x[6]*x[8] + (4*f1*f3*f6*f8 - f1*f3*f7^2)*x[1]^2*x[7]^2 -
2*f1*f3*f8*x[1]^2*x[7]*x[8] + f1^2*f2*x[1]*x[2]^3 - 2*f1*f2*f3*x[1]*x[2]^2*x[4]
+ (-f0*f1*f5 + 4*f0*f2*f4)*x[1]*x[2]*x[3]^2 + (-4*f0*f2*f5 +
2*f1^2*f5)*x[1]*x[2]*x[3]*x[4] + (2*f0*f1*f6 - 2*f0*f2*f5)*x[1]*x[2]*x[3]*x[5] +
(f0*f1*f7 + 4*f0*f2*f6 - 2*f1^2*f6)*x[1]*x[2]*x[3]*x[6] +
f0*f1*f8*x[1]*x[2]*x[3]*x[7] + f2*f3^2*x[1]*x[2]*x[4]^2 + (f0*f1*f7 + 4*f0*f2*f6
- 2*f1^2*f6)*x[1]*x[2]*x[4]*x[5] - 2*f0*f2*f7*x[1]*x[2]*x[4]*x[6] + (-2*f0*f2*f8
+ f0*f3*f7 - 2*f1*f3*f6)*x[1]*x[2]*x[4]*x[7] + f1*f3*x[1]*x[2]*x[4]*x[8] -
f0*f1*f7*x[1]*x[2]*x[5]^2 + (-4*f0*f1*f8 - 4*f0*f2*f7 +
2*f1^2*f7)*x[1]*x[2]*x[5]*x[6] + (4*f0*f2*f8 + f0*f3*f7 -
2*f1^2*f8)*x[1]*x[2]*x[5]*x[7] + 4*f0*f2*f8*x[1]*x[2]*x[6]^2 + (-f0*f3*f8 +
f1*f3*f7)*x[1]*x[2]*x[6]*x[7] - 2*f1*f3*f8*x[1]*x[2]*x[7]^2 -
2*f0*f2*f5*x[1]*x[3]^3 + 3*f0*f3*f5*x[1]*x[3]^2*x[4] + (-f0*f1*f7 +
4*f0*f2*f6)*x[1]*x[3]^2*x[5] + (f0*f1*f8 - 4*f0*f3*f6)*x[1]*x[3]^2*x[6] +
(-4*f0*f2*f8 + f0*f3*f7 + 4*f0*f4*f6 - f0*f5^2 + 2*f1^2*f8)*x[1]*x[3]^2*x[7] -
2*f0*f4*x[1]*x[3]^2*x[8] - 2*f1*f3*f5*x[1]*x[3]*x[4]^2 + (-f0*f1*f8 - 4*f0*f2*f7
- 2*f0*f3*f6 + 2*f1^2*f7)*x[1]*x[3]*x[4]*x[5] + (-2*f0*f2*f8 + 3*f0*f3*f7 +
2*f1*f3*f6)*x[1]*x[3]*x[4]*x[6] + (2*f0*f3*f8 - 8*f0*f4*f7 +
2*f1*f3*f7)*x[1]*x[3]*x[4]*x[7] + 2*f0*f5*x[1]*x[3]*x[4]*x[8] + (2*f0*f1*f8 -
4*f0*f2*f7)*x[1]*x[3]*x[5]^2 + (4*f0*f2*f8 + 4*f0*f3*f7 -
2*f1^2*f8)*x[1]*x[3]*x[5]*x[6] + (-2*f0*f3*f8 - 4*f0*f4*f7)*x[1]*x[3]*x[5]*x[7]
+ f0*f5*x[1]*x[3]*x[5]*x[8] + (-3*f0*f3*f8 - f1*f3*f7)*x[1]*x[3]*x[6]^2 +
(8*f0*f4*f8 + 2*f0*f5*f7 - 2*f1*f3*f8)*x[1]*x[3]*x[6]*x[7] + (-2*f0*f6 + f1*f5 -
f2*f4)*x[1]*x[3]*x[6]*x[8] - 4*f0*f5*f8*x[1]*x[3]*x[7]^2 + (3*f0*f7 - f1*f6 +
f2*f5)*x[1]*x[3]*x[7]*x[8] + (2*f0*f2*f8 + 2*f1*f3*f6)*x[1]*x[4]^2*x[5] +
(4*f0*f4*f8 - 4*f2*f4*f6 + f2*f5^2 + 2*f3^2*f6)*x[1]*x[4]^2*x[7] + (-f1*f5 +
2*f2*f4 - f3^2)*x[1]*x[4]^2*x[8] + (4*f0*f2*f8 + 2*f0*f3*f7 -
2*f1^2*f8)*x[1]*x[4]*x[5]^2 + (-3*f0*f3*f8 - 3*f1*f3*f7)*x[1]*x[4]*x[5]*x[6] +
(8*f0*f4*f8 + 2*f0*f5*f7 - 2*f1*f3*f8)*x[1]*x[4]*x[5]*x[7] + (-2*f0*f6 - f1*f5 +
f2*f4)*x[1]*x[4]*x[5]*x[8] + (-4*f0*f5*f8 + 4*f2*f4*f7 -
2*f3^2*f7)*x[1]*x[4]*x[6]*x[7] + (f0*f7 - f2*f5)*x[1]*x[4]*x[6]*x[8] -
2*f2*f5*f7*x[1]*x[4]*x[7]^2 + (-f0*f8 + 2*f2*f6)*x[1]*x[4]*x[7]*x[8] -
2*f2*x[1]*x[4]*x[8]^2 + 4*f0*f2*f8*x[1]*x[5]^3 - 6*f0*f3*f8*x[1]*x[5]^2*x[6] +
4*f0*f4*f8*x[1]*x[5]^2*x[7] + 4*f1*f3*f8*x[1]*x[5]*x[6]^2 -
8*f0*f5*f8*x[1]*x[5]*x[6]*x[7] + 2*f0*f7*x[1]*x[5]*x[6]*x[8] + (8*f0*f6*f8 -
2*f0*f7^2)*x[1]*x[5]*x[7]^2 - 5*f0*f8*x[1]*x[5]*x[7]*x[8] - f2*x[1]*x[5]*x[8]^2
+ (4*f0*f6*f8 - f0*f7^2 - 4*f2*f4*f8 + 2*f3^2*f8)*x[1]*x[6]^2*x[7] -
2*f0*f8*x[1]*x[6]^2*x[8] + 4*f2*f5*f8*x[1]*x[6]*x[7]^2 -
2*f2*f7*x[1]*x[6]*x[7]*x[8] + (-4*f2*f6*f8 + f2*f7^2)*x[1]*x[7]^3 +
2*f2*f8*x[1]*x[7]^2*x[8] - f0*f1*x[2]^2*x[3]*x[4] - f0*f1*x[2]^2*x[3]*x[5] +
(-2*f0*f2 + f1^2)*x[2]^2*x[3]*x[6] + f0*f2*x[2]^2*x[4]^2 + (-2*f0*f2 +
f1^2)*x[2]^2*x[4]*x[5] + f1*f3*x[2]^2*x[4]*x[7] + f0*f2*x[2]^2*x[5]^2 +
f0*f1*x[2]*x[3]^3 + (4*f0*f2 - 2*f1^2)*x[2]*x[3]^2*x[4] -
2*f0*f2*x[2]*x[3]^2*x[5] + 2*f0*f3*x[2]*x[3]^2*x[6] - 2*f0*f4*x[2]*x[3]^2*x[7] -
3*f0*f3*x[2]*x[3]*x[4]^2 + f0*f3*x[2]*x[3]*x[4]*x[5] - f1*f3*x[2]*x[3]*x[4]*x[6]
+ 2*f0*f5*x[2]*x[3]*x[4]*x[7] + f0*f5*x[2]*x[3]*x[5]*x[7] + (-2*f0*f6 - f1*f5 +
f2*f4)*x[2]*x[3]*x[6]*x[7] + 2*f0*x[2]*x[3]*x[6]*x[8] + (-f0*f7 + f1*f6 -
f2*f5)*x[2]*x[3]*x[7]^2 - f1*f3*x[2]*x[4]^2*x[5] + (f1*f5 + 2*f2*f4 -
f3^2)*x[2]*x[4]^2*x[7] - f0*x[2]*x[4]^2*x[8] + (-2*f0*f6 + f1*f5 -
f2*f4)*x[2]*x[4]*x[5]*x[7] + 2*f0*x[2]*x[4]*x[5]*x[8] + (f0*f7 -
f2*f5)*x[2]*x[4]*x[6]*x[7] + (f0*f8 + 2*f2*f6)*x[2]*x[4]*x[7]^2 -
2*f2*x[2]*x[4]*x[7]*x[8] - f0*x[2]*x[5]^2*x[8] + 2*f0*f7*x[2]*x[5]*x[6]*x[7] -
3*f0*f8*x[2]*x[5]*x[7]^2 + f2*x[2]*x[5]*x[7]*x[8] - 2*f0*f8*x[2]*x[6]^2*x[7] +
f2*x[2]*x[6]^2*x[8] + 2*f2*f8*x[2]*x[7]^3 + f0*f2*x[3]^4 - 3*f0*f3*x[3]^3*x[4] +
f0*f5*x[3]^3*x[7] + (6*f0*f4 + 2*f1*f3)*x[3]^2*x[4]^2 - 3*f0*f5*x[3]^2*x[4]*x[6]
- 5*f0*x[3]^2*x[4]*x[8] - 2*f0*f6*x[3]^2*x[5]*x[7] + f0*x[3]^2*x[5]*x[8] +
2*f0*f6*x[3]^2*x[6]^2 + f1*f6*x[3]^2*x[6]*x[7] - f1*x[3]^2*x[6]*x[8] + (4*f0*f8
- f1*f7 + f2*f6)*x[3]^2*x[7]^2 - f2*x[3]^2*x[7]*x[8] - 4*f1*f4*x[3]*x[4]^3 -
3*f0*f5*x[3]*x[4]^2*x[5] + 2*f1*f5*x[3]*x[4]^2*x[6] - f2*f5*x[3]*x[4]^2*x[7] +
3*f1*x[3]*x[4]^2*x[8] + 2*f0*f6*x[3]*x[4]*x[5]*x[6] + (5*f0*f7 -
f1*f6)*x[3]*x[4]*x[5]*x[7] + f1*x[3]*x[4]*x[5]*x[8] - 2*f1*f6*x[3]*x[4]*x[6]^2 +
(f0*f8 - 2*f1*f7 + f3*f5)*x[3]*x[4]*x[6]*x[7] - f2*x[3]*x[4]*x[6]*x[8] +
(-2*f1*f8 + f2*f7 - 2*f3*f6)*x[3]*x[4]*x[7]^2 + 2*f3*x[3]*x[4]*x[7]*x[8] +
2*f0*f7*x[3]*x[5]^2*x[7] - 3*f0*f7*x[3]*x[5]*x[6]^2 + (-3*f0*f8 -
f1*f7)*x[3]*x[5]*x[6]*x[7] + (2*f1*f8 - f2*f7)*x[3]*x[5]*x[7]^2 +
f1*f7*x[3]*x[6]^3 + (2*f1*f8 - f2*f7)*x[3]*x[6]^2*x[7] - f3*x[3]*x[6]^2*x[8] +
(-2*f2*f8 + f3*f7)*x[3]*x[6]*x[7]^2 + f2*f4*x[4]^4 + 2*f1*f5*x[4]^3*x[5] -
f2*f5*x[4]^3*x[6] + f3*f5*x[4]^3*x[7] - f2*x[4]^3*x[8] + 2*f0*f6*x[4]^2*x[5]^2 -
2*f1*f6*x[4]^2*x[5]*x[6] + (-f0*f8 - f1*f7 + 2*f2*f6 - f3*f5)*x[4]^2*x[5]*x[7] +
f2*f6*x[4]^2*x[6]^2 + (f2*f7 - 2*f3*f6)*x[4]^2*x[6]*x[7] + f3*x[4]^2*x[6]*x[8] +
(f2*f8 - f3*f7 + 4*f4*f6 - f5^2)*x[4]^2*x[7]^2 - 4*f4*x[4]^2*x[7]*x[8] -
3*f0*f7*x[4]*x[5]^2*x[6] + (-7*f0*f8 + f1*f7)*x[4]*x[5]^2*x[7] +
3*f1*f7*x[4]*x[5]*x[6]^2 + (4*f1*f8 - f2*f7)*x[4]*x[5]*x[6]*x[7] +
f3*x[4]*x[5]*x[6]*x[8] + f3*f7*x[4]*x[5]*x[7]^2 - f2*f7*x[4]*x[6]^3 + (-2*f2*f8
+ 2*f3*f7)*x[4]*x[6]^2*x[7] + (2*f3*f8 - 4*f4*f7)*x[4]*x[6]*x[7]^2 +
2*f5*x[4]*x[6]*x[7]*x[8] + 2*f5*f7*x[4]*x[7]^3 - 4*f6*x[4]*x[7]^2*x[8] +
4*x[4]*x[7]*x[8]^2 - 2*f0*f8*x[5]^3*x[7] + 6*f0*f8*x[5]^2*x[6]^2 +
f2*f8*x[5]^2*x[7]^2 - 4*f1*f8*x[5]*x[6]^3 + 2*f2*f8*x[5]*x[6]^2*x[7] -
2*f3*f8*x[5]*x[6]*x[7]^2 + f2*f8*x[6]^4 - 2*f3*f8*x[6]^3*x[7] +
4*f4*f8*x[6]^2*x[7]^2 - x[6]^2*x[8]^2 - 4*f5*f8*x[6]*x[7]^3 +
2*f7*x[6]*x[7]^2*x[8] + (4*f6*f8 - f7^2)*x[7]^4 - 4*f8*x[7]^3*x[8],

// no.30, (d,w) = (6,23)
  (4*f0*f2*f4*f5*f7 - f1^2*f4*f5*f7)*x[1]^3*x[3] + (-8*f0*f2*f4*f5*f8 +
2*f1^2*f4*f5*f8)*x[1]^3*x[5] + (8*f0*f3*f4*f6*f8 - 2*f0*f3*f4*f7^2)*x[1]^3*x[7]
- 3*f0*f3*f4*f8*x[1]^3*x[8] + (-8*f0*f2*f4*f6 + 2*f1^2*f4*f6)*x[1]^2*x[2]*x[3] +
(4*f0*f2*f4*f7 - f1^2*f4*f7)*x[1]^2*x[2]*x[5] - 5*f0*f3*f4*f8*x[1]^2*x[2]*x[7] +
(4*f0*f2*f4*f7 - 2*f0*f3^2*f7 + 4*f0*f3*f4*f6 - f1^2*f4*f7)*x[1]^2*x[3]^2 +
(2*f0*f3*f4*f7 - 2*f1*f3*f4*f6)*x[1]^2*x[3]*x[4] + (-8*f0*f2*f4*f8 -
4*f0*f2*f5*f7 + 4*f0*f3^2*f8 - 4*f0*f3*f4*f7 + 2*f1^2*f4*f8 +
f1^2*f5*f7)*x[1]^2*x[3]*x[5] + (-3*f0*f3*f4*f8 + f1*f3*f4*f7)*x[1]^2*x[3]*x[6] +
(4*f0*f3*f5*f8 - 2*f0*f4*f5*f7 + f1*f3*f5*f7)*x[1]^2*x[3]*x[7] + (-2*f0*f3*f7 +
2*f0*f4*f6)*x[1]^2*x[3]*x[8] + (-f0*f3*f4*f8 + f1*f3*f4*f7)*x[1]^2*x[4]*x[5] +
(4*f0*f4*f5*f8 - f1*f4*f5*f7)*x[1]^2*x[4]*x[7] + f2*f4*f5*x[1]^2*x[4]*x[8] +
(8*f0*f2*f5*f8 + 4*f0*f3*f4*f8 - 2*f1^2*f5*f8)*x[1]^2*x[5]^2 -
2*f1*f3*f4*f8*x[1]^2*x[5]*x[6] + (-8*f0*f3*f6*f8 + 2*f0*f3*f7^2 + 4*f0*f4*f5*f8
- 2*f1*f3*f5*f8)*x[1]^2*x[5]*x[7] + (5*f0*f3*f8 - 2*f0*f4*f7)*x[1]^2*x[5]*x[8] +
(-8*f0*f4*f6*f8 + 2*f0*f4*f7^2 + 2*f1*f4*f5*f8)*x[1]^2*x[6]*x[7] +
3*f0*f4*f8*x[1]^2*x[6]*x[8] + (4*f1*f4*f6*f8 - f1*f4*f7^2 -
2*f1*f5^2*f8)*x[1]^2*x[7]^2 + (-2*f1*f4*f8 + f1*f5*f7)*x[1]^2*x[7]*x[8] +
(8*f0*f2*f4 - 2*f1^2*f4)*x[1]*x[2]^2*x[3] + (-4*f0*f2*f5 - 4*f0*f3*f4 +
f1^2*f5)*x[1]*x[2]*x[3]^2 + 2*f1*f3*f4*x[1]*x[2]*x[3]*x[4] + (8*f0*f2*f6 -
2*f1^2*f6)*x[1]*x[2]*x[3]*x[5] + (2*f0*f4*f6 - 2*f1*f3*f6)*x[1]*x[2]*x[3]*x[7] +
(-3*f0*f4 + f1*f3)*x[1]*x[2]*x[3]*x[8] + (-2*f0*f4*f7 + 2*f1*f4*f6 -
f2*f4*f5)*x[1]*x[2]*x[4]*x[7] - f1*f4*x[1]*x[2]*x[4]*x[8] + (-4*f0*f2*f7 +
f1^2*f7)*x[1]*x[2]*x[5]^2 + (3*f0*f3*f8 + f1*f3*f7)*x[1]*x[2]*x[5]*x[7] +
f1*f4*x[1]*x[2]*x[5]*x[8] + (5*f0*f4*f8 - f1*f4*f7)*x[1]*x[2]*x[6]*x[7] -
f2*f4*x[1]*x[2]*x[6]*x[8] + (-2*f1*f4*f8 + f1*f5*f7)*x[1]*x[2]*x[7]^2 -
2*f1*f6*x[1]*x[2]*x[7]*x[8] + f1*x[1]*x[2]*x[8]^2 + 2*f0*f3*f5*x[1]*x[3]^3 +
(2*f0*f4*f5 - f1*f3*f5)*x[1]*x[3]^2*x[4] + (-4*f0*f2*f7 - 4*f0*f3*f6 +
f1^2*f7)*x[1]*x[3]^2*x[5] + (2*f0*f3*f7 - 2*f0*f4*f6 +
f1*f4*f5)*x[1]*x[3]^2*x[6] + (-4*f0*f3*f8 - 2*f0*f4*f7 + f1*f3*f7 + 2*f1*f4*f6 -
f1*f5^2)*x[1]*x[3]^2*x[7] - f1*f4*x[1]*x[3]^2*x[8] - f1*f4*f5*x[1]*x[3]*x[4]^2 +
(-2*f0*f4*f6 + 2*f1*f3*f6 - f1*f4*f5)*x[1]*x[3]*x[4]*x[5] + (-2*f0*f4*f7 +
2*f1*f4*f6 - f2*f4*f5)*x[1]*x[3]*x[4]*x[6] + (4*f0*f4*f8 - 4*f2*f4*f6 +
2*f2*f5^2 + 2*f3^2*f6)*x[1]*x[3]*x[4]*x[7] + (2*f2*f4 -
f3^2)*x[1]*x[3]*x[4]*x[8] + (8*f0*f2*f8 + 4*f0*f3*f7 -
2*f1^2*f8)*x[1]*x[3]*x[5]^2 + (-3*f0*f3*f8 + 2*f0*f4*f7 -
f1*f3*f7)*x[1]*x[3]*x[5]*x[6] + (4*f0*f4*f8 + 2*f0*f5*f7 - 2*f1*f3*f8 -
2*f1*f4*f7)*x[1]*x[3]*x[5]*x[7] + (-2*f0*f6 + f1*f5)*x[1]*x[3]*x[5]*x[8] +
(3*f0*f4*f8 - f1*f4*f7)*x[1]*x[3]*x[6]^2 + (-4*f0*f5*f8 + 2*f2*f4*f7 -
f3^2*f7)*x[1]*x[3]*x[6]*x[7] + (2*f0*f7 + f3*f4)*x[1]*x[3]*x[6]*x[8] +
(2*f1*f5*f8 - 2*f2*f5*f7)*x[1]*x[3]*x[7]^2 + (-2*f0*f8 + 2*f2*f6 -
f3*f5)*x[1]*x[3]*x[7]*x[8] - 2*f2*x[1]*x[3]*x[8]^2 + f2*f4*f5*x[1]*x[4]^2*x[5] -
2*f3*f4*f6*x[1]*x[4]^2*x[7] + f3*f4*x[1]*x[4]^2*x[8] + (-f0*f3*f8 + 2*f0*f4*f7 -
f1*f3*f7)*x[1]*x[4]*x[5]^2 + (f0*f4*f8 - f1*f4*f7)*x[1]*x[4]*x[5]*x[6] +
(-4*f0*f5*f8 + 2*f2*f4*f7 - f3^2*f7)*x[1]*x[4]*x[5]*x[7] + (-2*f2*f5 -
f3*f4)*x[1]*x[4]*x[5]*x[8] + 2*f3*f4*f7*x[1]*x[4]*x[6]*x[7] -
f3*f5*f7*x[1]*x[4]*x[7]^2 + 2*f3*f6*x[1]*x[4]*x[7]*x[8] - f3*x[1]*x[4]*x[8]^2 -
4*f0*f3*f8*x[1]*x[5]^3 + (-4*f0*f4*f8 + 2*f1*f3*f8)*x[1]*x[5]^2*x[6] +
(-4*f0*f5*f8 + 2*f1*f4*f8)*x[1]*x[5]^2*x[7] + f0*f7*x[1]*x[5]^2*x[8] +
2*f1*f4*f8*x[1]*x[5]*x[6]^2 + (8*f0*f6*f8 - 2*f0*f7^2 - 4*f2*f4*f8 +
2*f3^2*f8)*x[1]*x[5]*x[6]*x[7] - 4*f0*f8*x[1]*x[5]*x[6]*x[8] + (-4*f1*f6*f8 +
f1*f7^2 + 4*f2*f5*f8)*x[1]*x[5]*x[7]^2 + 2*f1*f8*x[1]*x[5]*x[7]*x[8] +
f3*x[1]*x[5]*x[8]^2 - 2*f3*f4*f8*x[1]*x[6]^2*x[7] + 2*f3*f5*f8*x[1]*x[6]*x[7]^2
- f3*f7*x[1]*x[6]*x[7]*x[8] + f4*x[1]*x[6]*x[8]^2 + (-4*f3*f6*f8 +
f3*f7^2)*x[1]*x[7]^3 + 2*f3*f8*x[1]*x[7]^2*x[8] + (-4*f0*f2 +
f1^2)*x[2]^2*x[3]*x[5] + (-f0*f4 + f1*f3)*x[2]^2*x[3]*x[7] -
f1*f4*x[2]^2*x[4]*x[7] - f1*f4*x[2]^2*x[5]*x[7] + f2*f4*x[2]^2*x[6]*x[7] +
f1*x[2]^2*x[7]*x[8] + (4*f0*f2 - f1^2)*x[2]*x[3]^3 - 2*f0*f3*x[2]*x[3]^2*x[4] +
2*f0*f3*x[2]*x[3]^2*x[5] + f0*f4*x[2]*x[3]^2*x[6] + (2*f0*f5 -
f1*f4)*x[2]*x[3]^2*x[7] + 2*f0*f4*x[2]*x[3]*x[4]^2 + (f0*f4 -
f1*f3)*x[2]*x[3]*x[4]*x[5] - f1*f4*x[2]*x[3]*x[4]*x[6] + (2*f2*f4 -
f3^2)*x[2]*x[3]*x[4]*x[7] - 2*f0*x[2]*x[3]*x[4]*x[8] + (-2*f0*f6 +
f1*f5)*x[2]*x[3]*x[5]*x[7] + 2*f0*x[2]*x[3]*x[5]*x[8] + f2*f4*x[2]*x[3]*x[6]^2 +
(-2*f2*f5 - f3*f4)*x[2]*x[3]*x[6]*x[7] + (2*f0*f8 - f1*f7 + 2*f2*f6 +
f3*f5)*x[2]*x[3]*x[7]^2 - 2*f2*x[2]*x[3]*x[7]*x[8] + f3*f4*x[2]*x[4]^2*x[7] -
f2*f4*x[2]*x[4]*x[5]*x[6] + (2*f0*f7 + f3*f4)*x[2]*x[4]*x[5]*x[7] -
f3*x[2]*x[4]*x[7]*x[8] + f0*f7*x[2]*x[5]^2*x[7] - f1*x[2]*x[5]^2*x[8] -
4*f0*f8*x[2]*x[5]*x[6]*x[7] + 2*f2*x[2]*x[5]*x[6]*x[8] + (2*f1*f8 -
2*f2*f7)*x[2]*x[5]*x[7]^2 - f3*x[2]*x[5]*x[7]*x[8] - f4*x[2]*x[6]*x[7]*x[8] +
2*f3*f8*x[2]*x[7]^3 - 2*f0*f3*x[3]^4 + (2*f0*f4 + f1*f3)*x[3]^3*x[4] -
2*f0*f5*x[3]^3*x[6] + f1*f5*x[3]^3*x[7] - 2*f0*x[3]^3*x[8] - f1*f4*x[3]^2*x[4]^2
- 2*f0*f5*x[3]^2*x[4]*x[5] + f1*f5*x[3]^2*x[4]*x[6] - 2*f2*f5*x[3]^2*x[4]*x[7] +
f1*x[3]^2*x[4]*x[8] + 2*f0*f6*x[3]^2*x[5]*x[6] + (2*f0*f7 -
2*f1*f6)*x[3]^2*x[5]*x[7] + f1*x[3]^2*x[5]*x[8] + (2*f0*f8 - f1*f7 +
2*f2*f6)*x[3]^2*x[6]*x[7] - 2*f2*x[3]^2*x[6]*x[8] - 2*f3*f6*x[3]^2*x[7]^2 +
2*f3*x[3]^2*x[7]*x[8] + f1*f5*x[3]*x[4]^2*x[5] + f3*f5*x[3]*x[4]^2*x[7] +
2*f0*f6*x[3]*x[4]*x[5]^2 - 2*f1*f6*x[3]*x[4]*x[5]*x[6] + (-2*f0*f8 +
2*f2*f6)*x[3]*x[4]*x[5]*x[7] + (-2*f3*f6 + f4*f5)*x[3]*x[4]*x[6]*x[7] +
f3*x[3]*x[4]*x[6]*x[8] + (f3*f7 + 2*f4*f6 - f5^2)*x[3]*x[4]*x[7]^2 -
2*f4*x[3]*x[4]*x[7]*x[8] - 3*f0*f7*x[3]*x[5]^2*x[6] + (-4*f0*f8 +
2*f1*f7)*x[3]*x[5]^2*x[7] + f1*f7*x[3]*x[5]*x[6]^2 + (2*f1*f8 -
2*f2*f7)*x[3]*x[5]*x[6]*x[7] + 2*f3*f7*x[3]*x[5]*x[7]^2 + f3*f7*x[3]*x[6]^2*x[7]
+ (-2*f3*f8 - f4*f7)*x[3]*x[6]*x[7]^2 + f5*x[3]*x[6]*x[7]*x[8] +
f5*f7*x[3]*x[7]^3 - 2*f6*x[3]*x[7]^2*x[8] + 2*x[3]*x[7]*x[8]^2 -
f4*f5*x[4]^3*x[7] - f4*f5*x[4]^2*x[5]*x[7] + 2*f4*f6*x[4]^2*x[6]*x[7] -
f4*x[4]^2*x[6]*x[8] - f4*f7*x[4]^2*x[7]^2 + f5*x[4]^2*x[7]*x[8] -
f0*f7*x[4]*x[5]^3 + f1*f7*x[4]*x[5]^2*x[6] - 2*f2*f7*x[4]*x[5]^2*x[7] +
f3*f7*x[4]*x[5]*x[6]*x[7] - f4*f7*x[4]*x[5]*x[7]^2 + f5*x[4]*x[5]*x[7]*x[8] -
2*f4*f7*x[4]*x[6]^2*x[7] + (2*f4*f8 + f5*f7)*x[4]*x[6]*x[7]^2 -
2*f6*x[4]*x[6]*x[7]*x[8] + x[4]*x[6]*x[8]^2 - 2*f5*f8*x[4]*x[7]^3 +
f7*x[4]*x[7]^2*x[8] + 4*f0*f8*x[5]^3*x[6] - 2*f1*f8*x[5]^3*x[7] -
2*f1*f8*x[5]^2*x[6]^2 + 4*f2*f8*x[5]^2*x[6]*x[7] - 2*f3*f8*x[5]^2*x[7]^2 -
2*f3*f8*x[5]*x[6]^2*x[7] + 2*f4*f8*x[5]*x[6]*x[7]^2 - x[5]*x[6]*x[8]^2 -
2*f5*f8*x[5]*x[7]^3 + f7*x[5]*x[7]^2*x[8] + 2*f4*f8*x[6]^3*x[7] -
2*f5*f8*x[6]^2*x[7]^2 + f7*x[6]^2*x[7]*x[8] + (4*f6*f8 - f7^2)*x[6]*x[7]^3 -
4*f8*x[6]*x[7]^2*x[8],

// no.31, (d,w) = (6,24)
  (f0*f1*f3*f5*f7*f8 + 4*f0*f2*f3*f5*f6*f8)*x[1]^4 + (-2*f0*f1*f3*f6*f8 -
4*f0*f2*f3*f5*f8 - 2*f0*f2*f3*f6*f7)*x[1]^3*x[2] + (-f0*f1*f3*f7*f8 +
4*f0*f1*f4*f6*f8 - f0*f1*f5^2*f8 - 4*f0*f2*f3*f6*f8 - 4*f0*f2*f4*f6*f7 +
4*f0*f2*f5^2*f7 + 2*f0*f3^2*f6*f7 + 2*f1^2*f4*f6*f7 - f1^2*f5^2*f7)*x[1]^3*x[3]
+ (2*f0*f1*f4*f7*f8 + 2*f0*f2*f5^2*f8 + 2*f0*f3^2*f6*f8 -
2*f1*f2*f4*f6*f7)*x[1]^3*x[4] + (-2*f0*f1*f4*f7*f8 - 8*f0*f2*f4*f6*f8 +
4*f0*f2*f4*f7^2 - 4*f0*f2*f5^2*f8 + 4*f0*f3^2*f6*f8 - 2*f0*f3^2*f7^2 +
4*f1^2*f4*f6*f8 - 2*f1^2*f4*f7^2)*x[1]^3*x[5] + (-f0*f1*f5*f7*f8 +
4*f0*f2*f4*f7*f8 - 4*f0*f2*f5*f6*f8 - f0*f3^2*f7*f8 - 4*f1*f2*f4*f6*f8 +
2*f1*f2*f4*f7^2 + 2*f1*f2*f5^2*f8)*x[1]^3*x[6] + (-2*f0*f2*f5*f7*f8 +
4*f0*f3*f5*f6*f8 - 2*f0*f3*f5*f7^2 - 2*f1*f2*f5*f6*f8)*x[1]^3*x[7] +
(-f0*f1*f7*f8 - f0*f3*f5*f8 + f0*f3*f6*f7 + 2*f1*f2*f5*f8 + f1*f2*f6*f7 -
f1*f3*f5*f7)*x[1]^3*x[8] + (2*f0*f1*f3*f8 + 2*f0*f2*f3*f7)*x[1]^2*x[2]^2 +
(-4*f0*f1*f4*f8 + 4*f0*f2*f3*f8 + 4*f0*f2*f4*f7 - 6*f0*f2*f5*f6 - 2*f0*f3^2*f7 -
2*f1^2*f4*f7 + f1^2*f5*f6)*x[1]^2*x[2]*x[3] + (-f0*f1*f5*f8 - 2*f0*f3^2*f8 +
2*f1*f2*f4*f7 + f1*f2*f5*f6)*x[1]^2*x[2]*x[4] + (f0*f1*f5*f8 + 8*f0*f2*f4*f8 -
4*f0*f3^2*f8 - 4*f1^2*f4*f8 + f1^2*f5*f7)*x[1]^2*x[2]*x[5] + (2*f0*f1*f6*f8 +
2*f0*f2*f5*f8 + 2*f0*f2*f6*f7 + 4*f1*f2*f4*f8 - 2*f1*f2*f5*f7)*x[1]^2*x[2]*x[6]
+ (f0*f1*f7*f8 + 4*f0*f2*f6*f8 - 3*f0*f3*f5*f8 + f0*f3*f6*f7 +
f1*f3*f5*f7)*x[1]^2*x[2]*x[7] + (-f0*f2*f8 - 3*f0*f3*f7 - f1*f2*f7 +
f1*f3*f6)*x[1]^2*x[2]*x[8] + (2*f0*f1*f5*f8 - 4*f0*f2*f5*f7 + 2*f0*f3*f5*f6 +
f1^2*f5*f7)*x[1]^2*x[3]^2 + (-4*f0*f2*f5*f8 + 2*f0*f3*f5*f7 -
f1*f3*f5*f6)*x[1]^2*x[3]*x[4] + (-4*f0*f1*f6*f8 + 4*f0*f2*f6*f7 - 2*f0*f3*f5*f7
+ 2*f1^2*f5*f8 - 2*f1^2*f6*f7)*x[1]^2*x[3]*x[5] + (4*f0*f2*f6*f8 - 3*f0*f3*f6*f7
- 2*f1*f2*f5*f8 + f1*f2*f6*f7 + f1*f3*f5*f7)*x[1]^2*x[3]*x[6] + (2*f0*f2*f7*f8 +
2*f0*f3*f6*f8 + 4*f0*f4*f6*f7 - 2*f0*f5^2*f7 + 2*f1*f2*f6*f8 -
2*f1*f3*f6*f7)*x[1]^2*x[3]*x[7] + (-2*f0*f3*f8 + f0*f5*f6 - f1*f2*f8 + f1*f3*f7
- f1*f4*f6)*x[1]^2*x[3]*x[8] + (2*f0*f3*f5*f8 - f2*f3*f5*f6)*x[1]^2*x[4]^2 +
(-f0*f1*f7*f8 + 3*f0*f3*f5*f8 - f0*f3*f6*f7 - 2*f1*f2*f5*f8 +
f1*f2*f6*f7)*x[1]^2*x[4]*x[5] + (-4*f0*f3*f6*f8 + f2*f3*f5*f7)*x[1]^2*x[4]*x[6]
+ (-f0*f3*f7*f8 + 2*f0*f5^2*f8 + 2*f1*f4*f6*f7 - f1*f5^2*f7 +
f2*f3*f6*f7)*x[1]^2*x[4]*x[7] + (-2*f1*f4*f7 + f2*f4*f6 -
f3^2*f6)*x[1]^2*x[4]*x[8] + (2*f0*f1*f7*f8 + 8*f0*f2*f6*f8 - 4*f0*f2*f7^2 -
4*f1^2*f6*f8 + 2*f1^2*f7^2)*x[1]^2*x[5]^2 + (-4*f0*f2*f7*f8 - 8*f0*f3*f6*f8 +
4*f0*f3*f7^2 + 4*f1*f2*f6*f8 - 2*f1*f2*f7^2)*x[1]^2*x[5]*x[6] + (f0*f3*f7*f8 +
8*f0*f4*f6*f8 - 4*f0*f4*f7^2 - 4*f1*f3*f6*f8 + 2*f1*f3*f7^2)*x[1]^2*x[5]*x[7] +
(-3*f0*f4*f8 + f1*f3*f8 + f1*f4*f7)*x[1]^2*x[5]*x[8] + (2*f0*f3*f7*f8 -
2*f2*f3*f5*f8)*x[1]^2*x[6]^2 + (-4*f0*f4*f7*f8 - 4*f0*f5*f6*f8 + 2*f0*f5*f7^2 +
4*f1*f4*f6*f8 - 2*f1*f4*f7^2 + 2*f2*f3*f6*f8 - f2*f3*f7^2)*x[1]^2*x[6]*x[7] +
(f0*f5*f8 - f0*f6*f7 + f1*f5*f7 - f2*f3*f8 - f2*f4*f7 +
f3^2*f7)*x[1]^2*x[6]*x[8] + (2*f0*f5*f7*f8 - 2*f1*f5*f6*f8 +
f1*f5*f7^2)*x[1]^2*x[7]^2 + (-f1*f6*f7 + f2*f5*f7)*x[1]^2*x[7]*x[8] +
f1*f7*x[1]^2*x[8]^2 + (6*f0*f2*f5 - f1^2*f5)*x[1]*x[2]^2*x[3] + (-2*f0*f2*f6 -
f1*f2*f5)*x[1]*x[2]^2*x[4] + (2*f0*f2*f6 - f1^2*f6)*x[1]*x[2]^2*x[5] +
(-2*f0*f1*f8 - 2*f0*f2*f7 + f1*f2*f6)*x[1]*x[2]^2*x[6] + (-3*f0*f2*f8 + f0*f3*f7
- f1*f3*f6)*x[1]*x[2]^2*x[7] - f1*f3*x[1]*x[2]^2*x[8] + (-2*f0*f2*f6 -
2*f0*f3*f5 + f1^2*f6)*x[1]*x[2]*x[3]^2 + (f0*f1*f8 + 2*f0*f3*f6 - f1*f2*f6 +
f1*f3*f5)*x[1]*x[2]*x[3]*x[4] + (3*f0*f1*f8 - 2*f0*f3*f6)*x[1]*x[2]*x[3]*x[5] +
(-3*f0*f2*f8 + f0*f3*f7 + f1*f2*f7)*x[1]*x[2]*x[3]*x[6] + (-4*f0*f4*f7 +
f0*f5*f6 - f1*f2*f8 + f1*f3*f7 + f1*f4*f6)*x[1]*x[2]*x[3]*x[7] + (-2*f0*f5 +
f1*f4)*x[1]*x[2]*x[3]*x[8] + f2*f3*f5*x[1]*x[2]*x[4]^2 + (f0*f2*f8 - f0*f3*f7 -
f1*f2*f7 + f1*f3*f6)*x[1]*x[2]*x[4]*x[5] + (3*f0*f3*f8 -
f2*f3*f6)*x[1]*x[2]*x[4]*x[6] + (-2*f0*f5*f7 + f1*f5*f6 - f2*f3*f7 - f2*f4*f6 +
f3^2*f6)*x[1]*x[2]*x[4]*x[7] + (f0*f6 - f2*f4)*x[1]*x[2]*x[4]*x[8] +
(-8*f0*f2*f8 + 2*f0*f3*f7 + 4*f1^2*f8)*x[1]*x[2]*x[5]^2 + (9*f0*f3*f8 -
4*f1*f2*f8 - f1*f3*f7)*x[1]*x[2]*x[5]*x[6] + (-5*f0*f4*f8 + 2*f0*f5*f7 +
3*f1*f3*f8 - f1*f4*f7)*x[1]*x[2]*x[5]*x[7] - f0*f6*x[1]*x[2]*x[5]*x[8] +
f2*f3*f7*x[1]*x[2]*x[6]^2 + (5*f0*f5*f8 - f0*f6*f7 - 4*f1*f4*f8 - f2*f3*f8 +
f2*f4*f7 - f3^2*f7)*x[1]*x[2]*x[6]*x[7] + (2*f0*f7 - f1*f6)*x[1]*x[2]*x[6]*x[8]
+ (-4*f0*f6*f8 + 2*f1*f5*f8 - f2*f5*f7)*x[1]*x[2]*x[7]^2 + (2*f0*f8 +
f1*f7)*x[1]*x[2]*x[7]*x[8] + f2*x[1]*x[2]*x[8]^2 + (-f0*f1*f8 +
2*f0*f3*f6)*x[1]*x[3]^3 + (2*f0*f2*f8 - 4*f0*f4*f6 + 2*f0*f5^2 -
f1*f3*f6)*x[1]*x[3]^2*x[4] + (4*f0*f2*f8 - 2*f0*f3*f7 -
2*f1^2*f8)*x[1]*x[3]^2*x[5] + (-3*f0*f3*f8 - f0*f5*f6 + f1*f2*f8 +
f1*f4*f6)*x[1]*x[3]^2*x[6] + (2*f0*f5*f7 - f1*f5*f6)*x[1]*x[3]^2*x[7] +
2*f0*f6*x[1]*x[3]^2*x[8] + (-2*f0*f3*f8 + 2*f1*f4*f6 - f1*f5^2 +
f2*f3*f6)*x[1]*x[3]*x[4]^2 + (-4*f0*f3*f8 + 4*f0*f4*f7 - f0*f5*f6 + f1*f2*f8 +
f1*f3*f7 - f1*f4*f6)*x[1]*x[3]*x[4]*x[5] + (2*f0*f4*f8 - 2*f0*f5*f7 + f1*f5*f6 -
f2*f3*f7 - f2*f4*f6 - f2*f5^2)*x[1]*x[3]*x[4]*x[6] + (-f0*f5*f8 +
3*f2*f5*f6)*x[1]*x[3]*x[4]*x[7] + (-f1*f6 - f2*f5)*x[1]*x[3]*x[4]*x[8] +
4*f0*f3*f8*x[1]*x[3]*x[5]^2 + (-5*f0*f4*f8 + 2*f0*f5*f7 - f1*f3*f8 -
f1*f4*f7)*x[1]*x[3]*x[5]*x[6] + (5*f0*f5*f8 - 4*f0*f6*f7 +
f1*f5*f7)*x[1]*x[3]*x[5]*x[7] + (-2*f0*f7 + f1*f6)*x[1]*x[3]*x[5]*x[8] +
(f0*f6*f7 - f1*f5*f7 + f2*f3*f8 + f2*f4*f7)*x[1]*x[3]*x[6]^2 + (-2*f0*f6*f8 +
2*f1*f5*f8 + f1*f6*f7 - 2*f2*f5*f7)*x[1]*x[3]*x[6]*x[7] + (f0*f8 -
f1*f7)*x[1]*x[3]*x[6]*x[8] + (-2*f0*f7*f8 - 2*f1*f6*f8 +
f2*f6*f7)*x[1]*x[3]*x[7]^2 + (2*f1*f8 - f2*f7)*x[1]*x[3]*x[7]*x[8] + (2*f0*f4*f8
- 2*f2*f4*f6)*x[1]*x[4]^3 + (4*f0*f4*f8 - 2*f1*f4*f7 + f2*f4*f6 +
f2*f5^2)*x[1]*x[4]^2*x[5] + (-2*f0*f5*f8 + 2*f2*f4*f7 +
f2*f5*f6)*x[1]*x[4]^2*x[6] - f3*f5*f6*x[1]*x[4]^2*x[7] + (-f0*f8 +
f2*f6)*x[1]*x[4]^2*x[8] + (-3*f0*f4*f8 - f1*f3*f8 + f1*f4*f7)*x[1]*x[4]*x[5]^2 +
(-3*f0*f5*f8 + f0*f6*f7 + 4*f1*f4*f8 + f2*f3*f8 - f2*f4*f7)*x[1]*x[4]*x[5]*x[6]
+ (-2*f1*f5*f8 - f1*f6*f7 - f2*f5*f7)*x[1]*x[4]*x[5]*x[7] + (-2*f0*f8 + f1*f7 -
2*f2*f6)*x[1]*x[4]*x[5]*x[8] + (2*f0*f6*f8 - 4*f2*f4*f8 -
f2*f5*f7)*x[1]*x[4]*x[6]^2 + (f0*f7*f8 + 2*f2*f5*f8 - f2*f6*f7 +
f3*f5*f7)*x[1]*x[4]*x[6]*x[7] + (-f2*f7 + f3*f6)*x[1]*x[4]*x[6]*x[8] +
(-2*f2*f6*f8 - f3*f6*f7)*x[1]*x[4]*x[7]^2 + (f2*f8 + f3*f7 -
f4*f6)*x[1]*x[4]*x[7]*x[8] + f4*x[1]*x[4]*x[8]^2 + (-8*f0*f6*f8 +
4*f0*f7^2)*x[1]*x[5]^2*x[7] + (4*f0*f8 - f1*f7)*x[1]*x[5]^2*x[8] + (4*f0*f6*f8 -
2*f0*f7^2)*x[1]*x[5]*x[6]^2 + (3*f0*f7*f8 + 2*f2*f5*f8)*x[1]*x[5]*x[6]*x[7] +
(-2*f1*f8 + f2*f7)*x[1]*x[5]*x[6]*x[8] + (2*f2*f6*f8 - f2*f7^2)*x[1]*x[5]*x[7]^2
- f2*f8*x[1]*x[5]*x[7]*x[8] + (-f0*f7*f8 + 2*f2*f5*f8)*x[1]*x[6]^3 +
(-2*f2*f6*f8 + f2*f7^2)*x[1]*x[6]^2*x[7] + (2*f2*f8 - f3*f7)*x[1]*x[6]^2*x[8] +
(-2*f3*f6*f8 + f3*f7^2)*x[1]*x[6]*x[7]^2 + (f3*f8 + f4*f7)*x[1]*x[6]*x[7]*x[8] -
f5*f7*x[1]*x[7]^2*x[8] + f6*x[1]*x[7]*x[8]^2 + 2*f0*f2*x[2]^3*x[4] + (-2*f0*f2 +
f1^2)*x[2]^3*x[5] - f1*f2*x[2]^3*x[6] + f1*f3*x[2]^3*x[7] + (2*f0*f2 -
f1^2)*x[2]^2*x[3]^2 + (-2*f0*f3 + f1*f2)*x[2]^2*x[3]*x[4] +
2*f0*f3*x[2]^2*x[3]*x[5] - f1*f4*x[2]^2*x[3]*x[7] - f1*f3*x[2]^2*x[4]*x[5] +
f2*f3*x[2]^2*x[4]*x[6] + (f0*f6 - f1*f5 + f2*f4)*x[2]^2*x[4]*x[7] -
2*f0*x[2]^2*x[4]*x[8] - f0*f6*x[2]^2*x[5]*x[7] + 2*f0*x[2]^2*x[5]*x[8] +
f1*x[2]^2*x[6]*x[8] + (2*f0*f8 - f1*f7)*x[2]^2*x[7]^2 - f2*x[2]^2*x[7]*x[8] -
2*f0*f3*x[2]*x[3]^3 + (4*f0*f4 + f1*f3)*x[2]*x[3]^2*x[4] -
f1*f4*x[2]*x[3]^2*x[6] + f1*f5*x[2]*x[3]^2*x[7] - 2*f0*x[2]*x[3]^2*x[8] +
(2*f0*f5 - 2*f1*f4 - f2*f3)*x[2]*x[3]*x[4]^2 + (-2*f0*f5 +
f1*f4)*x[2]*x[3]*x[4]*x[5] + (-f0*f6 + f2*f4 - f3^2)*x[2]*x[3]*x[4]*x[6] +
(f1*f6 - 2*f2*f5)*x[2]*x[3]*x[4]*x[7] + f0*f6*x[2]*x[3]*x[5]*x[6] +
2*f0*f7*x[2]*x[3]*x[5]*x[7] - f1*x[2]*x[3]*x[5]*x[8] + f2*f5*x[2]*x[3]*x[6]^2 +
(f0*f8 + f2*f6)*x[2]*x[3]*x[6]*x[7] + 2*f2*f4*x[2]*x[4]^3 + (-f0*f6 + f1*f5 -
f2*f4 + f3^2)*x[2]*x[4]^2*x[5] - 2*f2*f5*x[2]*x[4]^2*x[6] + (f2*f6 +
f3*f5)*x[2]*x[4]^2*x[7] - 2*f2*x[2]*x[4]^2*x[8] + f0*f6*x[2]*x[4]*x[5]^2 +
(2*f0*f7 - f1*f6 - f2*f5)*x[2]*x[4]*x[5]*x[6] + 2*f0*f8*x[2]*x[4]*x[5]*x[7] +
f2*x[2]*x[4]*x[5]*x[8] + (-f0*f8 + f2*f6)*x[2]*x[4]*x[6]^2 +
f2*f7*x[2]*x[4]*x[6]*x[7] - f3*x[2]*x[4]*x[6]*x[8] + (f2*f8 +
f4*f6)*x[2]*x[4]*x[7]^2 - f4*x[2]*x[4]*x[7]*x[8] - 2*f0*f7*x[2]*x[5]^2*x[6] +
3*f0*f8*x[2]*x[5]^2*x[7] + (-5*f0*f8 + f1*f7)*x[2]*x[5]*x[6]^2 +
2*f1*f8*x[2]*x[5]*x[6]*x[7] - f2*f8*x[2]*x[5]*x[7]^2 - f2*f7*x[2]*x[6]^3 +
(f3*f8 - f4*f7)*x[2]*x[6]*x[7]^2 + f5*f7*x[2]*x[7]^3 - f6*x[2]*x[7]^2*x[8] -
2*f0*f5*x[3]^3*x[4] + f1*f5*x[3]^3*x[6] - f1*f6*x[3]^3*x[7] + f1*x[3]^3*x[8] +
f1*f5*x[3]^2*x[4]^2 + (2*f0*f6 - f1*f5)*x[3]^2*x[4]*x[5] -
f2*f5*x[3]^2*x[4]*x[6] + (-f0*f8 + f2*f6)*x[3]^2*x[4]*x[7] - f2*x[3]^2*x[4]*x[8]
- f1*f6*x[3]^2*x[5]*x[6] + (-5*f0*f8 + f1*f7)*x[3]^2*x[5]*x[7] + (2*f0*f8 -
f1*f7)*x[3]^2*x[6]^2 - f3*f6*x[3]^2*x[6]*x[7] + f3*x[3]^2*x[6]*x[8] + (-f1*f6 +
f2*f5)*x[3]*x[4]^2*x[5] + (f0*f8 + f3*f5)*x[3]*x[4]^2*x[6] -
2*f3*f6*x[3]*x[4]^2*x[7] + 2*f3*x[3]*x[4]^2*x[8] + (-2*f0*f7 +
f1*f6)*x[3]*x[4]*x[5]^2 + f0*f8*x[3]*x[4]*x[5]*x[6] + (2*f1*f8 - f2*f7 +
f3*f6)*x[3]*x[4]*x[5]*x[7] - f3*x[3]*x[4]*x[5]*x[8] - f3*f6*x[3]*x[4]*x[6]^2 +
(-f2*f8 + f3*f7 + f4*f6)*x[3]*x[4]*x[6]*x[7] - f4*x[3]*x[4]*x[6]*x[8] -
f5*f6*x[3]*x[4]*x[7]^2 + f5*x[3]*x[4]*x[7]*x[8] + (2*f0*f8 +
f1*f7)*x[3]*x[5]^2*x[6] - 2*f1*f8*x[3]*x[5]^2*x[7] - f2*f7*x[3]*x[5]*x[6]^2 +
(f2*f8 + f3*f7)*x[3]*x[5]*x[6]*x[7] + f3*f7*x[3]*x[6]^3 + (-f3*f8 -
f4*f7)*x[3]*x[6]^2*x[7] + f5*f7*x[3]*x[6]*x[7]^2 + x[3]*x[6]*x[8]^2 -
f6*f7*x[3]*x[7]^3 + f7*x[3]*x[7]^2*x[8] + (-f0*f8 + f2*f6 - f3*f5)*x[4]^3*x[5] +
(2*f4*f6 - f5^2)*x[4]^3*x[7] - 2*f4*x[4]^3*x[8] + (-2*f0*f8 +
2*f1*f7)*x[4]^2*x[5]^2 + (-f2*f7 + f3*f6)*x[4]^2*x[5]*x[6] + (-f2*f8 + f3*f7 -
f4*f6)*x[4]^2*x[5]*x[7] + f4*x[4]^2*x[5]*x[8] + (-2*f4*f7 +
f5*f6)*x[4]^2*x[6]*x[7] + f5*x[4]^2*x[6]*x[8] + f5*f7*x[4]^2*x[7]^2 -
2*f6*x[4]^2*x[7]*x[8] + 2*x[4]^2*x[8]^2 + (2*f0*f8 - f1*f7)*x[4]*x[5]^3 +
(-2*f1*f8 + f2*f7)*x[4]*x[5]^2*x[6] + (f2*f8 - f3*f7)*x[4]*x[5]^2*x[7] +
(2*f2*f8 - f3*f7)*x[4]*x[5]*x[6]^2 + (-3*f3*f8 + f4*f7)*x[4]*x[5]*x[6]*x[7] +
f6*x[4]*x[5]*x[7]*x[8] - 2*x[4]*x[5]*x[8]^2 + (4*f4*f8 - f5*f7)*x[4]*x[6]^2*x[7]
- f6*x[4]*x[6]^2*x[8] + (-4*f5*f8 + f6*f7)*x[4]*x[6]*x[7]^2 +
2*f6*f8*x[4]*x[7]^3 - 2*f8*x[4]*x[7]^2*x[8] - f7*x[5]*x[6]*x[7]*x[8] + (-2*f6*f8
+ f7^2)*x[5]*x[7]^3 + 2*f8*x[5]*x[7]^2*x[8] + f7*x[6]^3*x[8] + (2*f6*f8 -
f7^2)*x[6]^2*x[7]^2 - 2*f8*x[6]^2*x[7]*x[8],

// no.32, (d,w) = (6,24)
  (-4*f0*f2*f4*f5^2*f8 - 4*f0*f3^2*f4*f6*f8 + f0*f3^2*f4*f7^2 -
2*f1^2*f3*f5*f6*f8 + f1^2*f4*f5^2*f8)*x[1]^4 + (4*f0*f2*f3*f5*f8 +
4*f0*f3^2*f4*f8 + f1^2*f3*f6*f7)*x[1]^3*x[2] + (-2*f0*f3*f4*f5*f7 +
2*f1^2*f3*f6*f8 - 2*f1^2*f4*f6*f7)*x[1]^3*x[3] + (-4*f0*f3*f4*f5*f8 -
4*f1^2*f4*f6*f8 + 4*f1*f2*f4*f6*f7 - f1*f3^2*f6*f7 + f1*f3*f4*f5*f7)*x[1]^3*x[4]
+ (4*f0*f2*f5^2*f8 + 4*f0*f3*f4*f5*f8 + f1^2*f4*f7^2)*x[1]^3*x[5] +
(2*f1^2*f5*f6*f8 - 2*f1*f2*f4*f7^2 - 2*f1*f2*f5^2*f8 + 2*f1*f3^2*f6*f8 -
2*f1*f3*f4*f5*f8)*x[1]^3*x[6] + (4*f0*f4*f5^2*f8 + 4*f1*f2*f5*f6*f8)*x[1]^3*x[7]
+ (f1^2*f6*f8 - 2*f1*f2*f5*f8 - f1*f2*f6*f7)*x[1]^3*x[8] + (-2*f0*f2*f3*f7 +
4*f0*f2*f4*f6 - f1^2*f4*f6)*x[1]^2*x[2]^2 + (-4*f0*f2*f3*f8 - 8*f0*f2*f4*f7 +
4*f0*f3^2*f7 + 3*f1^2*f4*f7 + f1^2*f5*f6)*x[1]^2*x[2]*x[3] + (8*f0*f2*f4*f8 -
2*f1*f2*f4*f7 - 2*f1*f2*f5*f6)*x[1]^2*x[2]*x[4] + (8*f0*f2*f4*f8 - 4*f0*f3^2*f8
- f1^2*f5*f7)*x[1]^2*x[2]*x[5] + (-4*f0*f2*f5*f8 - f1^2*f6*f7 - 4*f1*f2*f4*f8 +
2*f1*f2*f5*f7)*x[1]^2*x[2]*x[6] + (-4*f0*f3*f5*f8 - f1^2*f6*f8 - f1*f2*f6*f7 -
f1*f3*f5*f7)*x[1]^2*x[2]*x[7] + (-3*f0*f2*f8 + 2*f0*f3*f7 - 2*f0*f4*f6 +
f1*f2*f7)*x[1]^2*x[2]*x[8] + (4*f0*f2*f4*f8 + f0*f4*f5^2 -
f1^2*f4*f8)*x[1]^2*x[3]^2 + (f1*f3*f5*f6 - f1*f4*f5^2)*x[1]^2*x[3]*x[4] +
(2*f0*f3*f5*f7 - 2*f1^2*f5*f8 + 2*f1^2*f6*f7)*x[1]^2*x[3]*x[5] + (-4*f0*f3*f5*f8
- f1^2*f6*f8 + 2*f1*f2*f5*f8 - f1*f2*f6*f7 - f1*f3*f5*f7)*x[1]^2*x[3]*x[6] +
(-4*f1*f2*f6*f8 + f1*f3*f6*f7)*x[1]^2*x[3]*x[7] + (f0*f3*f8 + 3*f0*f4*f7 +
f1*f2*f8 - f1*f3*f7)*x[1]^2*x[3]*x[8] + (f2*f4*f5^2 + f3^2*f4*f6)*x[1]^2*x[4]^2
+ (3*f1^2*f6*f8 + 2*f1*f2*f5*f8 - 3*f1*f2*f6*f7)*x[1]^2*x[4]*x[5] +
(2*f1*f3*f6*f7 - f2*f3*f5*f7 - f3^2*f4*f7)*x[1]^2*x[4]*x[6] + (2*f1*f3*f6*f8 -
4*f1*f4*f6*f7)*x[1]^2*x[4]*x[7] + (-2*f0*f4*f8 + f1*f4*f7 + f1*f5*f6 -
f3*f4*f5)*x[1]^2*x[4]*x[8] + (-4*f0*f3*f5*f8 - f1^2*f7^2)*x[1]^2*x[5]^2 +
(8*f0*f3*f6*f8 - 2*f0*f3*f7^2 + 2*f1*f2*f7^2 + 2*f1*f3*f5*f8)*x[1]^2*x[5]*x[6] +
(-4*f0*f5^2*f8 + 2*f1*f3*f6*f8 - f1*f3*f7^2)*x[1]^2*x[5]*x[7] + (-3*f0*f4*f8 -
f1*f4*f7)*x[1]^2*x[5]*x[8] + (4*f0*f4*f6*f8 - f0*f4*f7^2 - 4*f1*f3*f6*f8 +
2*f2*f3*f5*f8 + f3^2*f4*f8)*x[1]^2*x[6]^2 + (-4*f1*f4*f6*f8 + 3*f1*f4*f7^2 +
4*f1*f5^2*f8 - 4*f2*f3*f6*f8 + f2*f3*f7^2)*x[1]^2*x[6]*x[7] + (f0*f5*f8 +
2*f1*f4*f8 - f1*f5*f7 + f2*f3*f8)*x[1]^2*x[6]*x[8] + (-4*f1*f5*f6*f8 +
4*f2*f4*f6*f8 - f2*f4*f7^2)*x[1]^2*x[7]^2 + (2*f1*f5*f8 + 2*f1*f6*f7 -
2*f2*f4*f8)*x[1]^2*x[7]*x[8] + (f0*f8 - f1*f7)*x[1]^2*x[8]^2 + (-4*f0*f2*f4 +
f1^2*f4)*x[1]*x[2]^3 + (6*f0*f2*f5 - 2*f1^2*f5)*x[1]*x[2]^2*x[3] + (f1^2*f6 +
f1*f2*f5)*x[1]*x[2]^2*x[4] + (-4*f0*f2*f6 + f1^2*f6)*x[1]*x[2]^2*x[5] +
2*f0*f2*f7*x[1]*x[2]^2*x[6] + (3*f0*f2*f8 - 2*f0*f4*f6 +
2*f1*f3*f6)*x[1]*x[2]^2*x[7] + 3*f0*f4*x[1]*x[2]^2*x[8] + (-4*f0*f3*f5 -
f1^2*f6)*x[1]*x[2]*x[3]^2 + (2*f1*f2*f6 + 2*f1*f3*f5)*x[1]*x[2]*x[3]*x[4] +
(8*f0*f2*f7 - 2*f1^2*f7)*x[1]*x[2]*x[3]*x[5] + (f0*f2*f8 - 4*f0*f3*f7 +
2*f0*f4*f6 - f1*f2*f7)*x[1]*x[2]*x[3]*x[6] + (3*f0*f3*f8 + 5*f0*f4*f7 + f1*f2*f8
- 2*f1*f3*f7 - 2*f1*f4*f6 + f1*f5^2)*x[1]*x[2]*x[3]*x[7] + (-3*f0*f5 +
f1*f4)*x[1]*x[2]*x[3]*x[8] + (-f1*f3*f6 - f2*f3*f5 - f3^2*f4)*x[1]*x[2]*x[4]^2 +
(-5*f0*f2*f8 + 2*f0*f4*f6 + f1*f2*f7 - f1*f3*f6)*x[1]*x[2]*x[4]*x[5] +
(2*f0*f4*f7 - 2*f1*f4*f6 + 2*f2*f3*f6)*x[1]*x[2]*x[4]*x[6] + (-6*f0*f4*f8 +
f1*f5*f6 + f2*f3*f7 + 4*f2*f4*f6 - 2*f2*f5^2 - 2*f3^2*f6 +
f3*f4*f5)*x[1]*x[2]*x[4]*x[7] + (-2*f2*f4 + f3^2)*x[1]*x[2]*x[4]*x[8] -
8*f0*f2*f8*x[1]*x[2]*x[5]^2 + (-2*f0*f4*f7 + 4*f1*f2*f8)*x[1]*x[2]*x[5]*x[6] +
(-5*f0*f4*f8 + 2*f1*f4*f7)*x[1]*x[2]*x[5]*x[7] + 2*f0*f6*x[1]*x[2]*x[5]*x[8] +
(-4*f0*f4*f8 + f1*f4*f7 - f2*f3*f7)*x[1]*x[2]*x[6]^2 + (3*f0*f5*f8 + 6*f1*f4*f8
- 2*f1*f5*f7 + f2*f3*f8 - 2*f2*f4*f7 + f3^2*f7)*x[1]*x[2]*x[6]*x[7] + (-2*f0*f7
+ f1*f6)*x[1]*x[2]*x[6]*x[8] + (-2*f2*f4*f8 + 2*f2*f5*f7)*x[1]*x[2]*x[7]^2 +
(2*f0*f8 - f1*f7 - 2*f2*f6 + f3*f5)*x[1]*x[2]*x[7]*x[8] + f2*x[1]*x[2]*x[8]^2 -
f1*f3*f6*x[1]*x[3]^2*x[4] + (-4*f0*f2*f8 + 4*f0*f4*f6 - 2*f0*f5^2 +
2*f1^2*f8)*x[1]*x[3]^2*x[5] + (5*f0*f3*f8 + f0*f4*f7 - f1*f2*f8 - 2*f1*f4*f6 +
f1*f5^2)*x[1]*x[3]^2*x[6] + (-4*f0*f4*f8 + f1*f4*f7 - f1*f5*f6)*x[1]*x[3]^2*x[7]
+ 2*f1*f4*f6*x[1]*x[3]*x[4]^2 + (3*f0*f3*f8 - 3*f0*f4*f7 - f1*f2*f8 - 2*f1*f4*f6
+ f1*f5^2)*x[1]*x[3]*x[4]*x[5] + (-6*f0*f4*f8 + f2*f3*f7 + 4*f2*f4*f6 - f2*f5^2
- 2*f3^2*f6)*x[1]*x[3]*x[4]*x[6] + (2*f1*f4*f8 - 2*f2*f4*f7)*x[1]*x[3]*x[4]*x[7]
- 2*f1*f6*x[1]*x[3]*x[4]*x[8] - 4*f0*f4*f7*x[1]*x[3]*x[5]^2 + (f0*f4*f8 +
3*f1*f4*f7)*x[1]*x[3]*x[5]*x[6] - 2*f1*f4*f8*x[1]*x[3]*x[5]*x[7] + (-3*f0*f7 +
f1*f6)*x[1]*x[3]*x[5]*x[8] + (5*f0*f5*f8 - f2*f3*f8 - 2*f2*f4*f7 +
f3^2*f7)*x[1]*x[3]*x[6]^2 + (-4*f1*f5*f8 + f1*f6*f7 + 2*f2*f4*f8 +
f2*f5*f7)*x[1]*x[3]*x[6]*x[7] + (2*f0*f8 + f1*f7 - 2*f2*f6)*x[1]*x[3]*x[6]*x[8]
+ 4*f1*f6*f8*x[1]*x[3]*x[7]^2 + (-2*f1*f8 + f2*f7)*x[1]*x[3]*x[7]*x[8] +
f3*f4*f5*x[1]*x[4]^3 + (-2*f0*f4*f8 + f1*f4*f7 - f1*f5*f6 -
f2*f5^2)*x[1]*x[4]^2*x[5] - 2*f2*f4*f7*x[1]*x[4]^2*x[6] -
f4*f5^2*x[1]*x[4]^2*x[7] + (3*f0*f4*f8 + f1*f4*f7)*x[1]*x[4]*x[5]^2 +
(3*f0*f5*f8 - 2*f1*f4*f8 - f2*f3*f8 - 2*f2*f4*f7 + f3^2*f7)*x[1]*x[4]*x[5]*x[6]
+ (2*f1*f6*f7 + 2*f2*f4*f8)*x[1]*x[4]*x[5]*x[7] + (2*f0*f8 +
f3*f5)*x[1]*x[4]*x[5]*x[8] + (-f1*f6*f7 + 4*f2*f4*f8 +
f2*f5*f7)*x[1]*x[4]*x[6]^2 + (-2*f1*f6*f8 - 2*f2*f5*f8 +
2*f3*f5*f7)*x[1]*x[4]*x[6]*x[7] + (f2*f7 - 2*f3*f6)*x[1]*x[4]*x[6]*x[8] +
(-f2*f8 + f5^2)*x[1]*x[4]*x[7]*x[8] + f4*x[1]*x[4]*x[8]^2 +
4*f0*f4*f8*x[1]*x[5]^3 - 4*f1*f4*f8*x[1]*x[5]^2*x[6] + (3*f0*f8 +
f1*f7)*x[1]*x[5]^2*x[8] + (-8*f0*f6*f8 + 2*f0*f7^2 + 4*f2*f4*f8 -
2*f3^2*f8)*x[1]*x[5]*x[6]^2 + (2*f1*f6*f8 - 2*f1*f7^2 -
2*f2*f5*f8)*x[1]*x[5]*x[6]*x[7] + (-3*f1*f8 + f2*f7)*x[1]*x[5]*x[6]*x[8] +
(-4*f2*f6*f8 + f2*f7^2)*x[1]*x[5]*x[7]^2 + f2*f8*x[1]*x[5]*x[7]*x[8] +
(2*f1*f6*f8 - 2*f2*f5*f8)*x[1]*x[6]^3 + (4*f2*f6*f8 - f2*f7^2 -
4*f3*f5*f8)*x[1]*x[6]^2*x[7] - 2*f2*f8*x[1]*x[6]^2*x[8] + (8*f3*f6*f8 -
2*f3*f7^2)*x[1]*x[6]*x[7]^2 + (-3*f3*f8 + f4*f7)*x[1]*x[6]*x[7]*x[8] +
(-4*f4*f6*f8 + f4*f7^2)*x[1]*x[7]^3 + 3*f4*f8*x[1]*x[7]^2*x[8] -
2*f0*f2*x[2]^3*x[4] + (2*f0*f2 - f1^2)*x[2]^3*x[5] + f1*f2*x[2]^3*x[6] + (f0*f4
- 2*f1*f3)*x[2]^3*x[7] + (-6*f0*f2 + 2*f1^2)*x[2]^2*x[3]^2 + (4*f0*f3 -
f1*f2)*x[2]^2*x[3]*x[4] - f0*f4*x[2]^2*x[3]*x[6] + (-3*f0*f5 +
f1*f4)*x[2]^2*x[3]*x[7] - f0*f4*x[2]^2*x[4]^2 - f0*f4*x[2]^2*x[4]*x[5] + (f1*f4
- f2*f3)*x[2]^2*x[4]*x[6] + (-2*f2*f4 + f3^2)*x[2]^2*x[4]*x[7] +
2*f0*x[2]^2*x[4]*x[8] - f0*f4*x[2]^2*x[5]^2 + f1*f4*x[2]^2*x[5]*x[6] + (2*f0*f6
- f1*f5)*x[2]^2*x[5]*x[7] - 2*f0*x[2]^2*x[5]*x[8] - f2*f4*x[2]^2*x[6]^2 +
(-f1*f6 + 2*f2*f5)*x[2]^2*x[6]*x[7] - f1*x[2]^2*x[6]*x[8] + (-3*f0*f8 + f1*f7 -
2*f2*f6 - f3*f5)*x[2]^2*x[7]^2 + 3*f2*x[2]^2*x[7]*x[8] + 4*f0*f3*x[2]*x[3]^3 +
(-6*f0*f4 - 2*f1*f3)*x[2]*x[3]^2*x[4] - 2*f0*f4*x[2]*x[3]^2*x[5] + (3*f0*f5 +
2*f1*f4)*x[2]*x[3]^2*x[6] + 6*f0*x[2]*x[3]^2*x[8] + (3*f1*f4 +
f2*f3)*x[2]*x[3]*x[4]^2 + 3*f0*f5*x[2]*x[3]*x[4]*x[5] + (-2*f1*f5 - 2*f2*f4 +
f3^2)*x[2]*x[3]*x[4]*x[6] + (-f1*f6 + f2*f5)*x[2]*x[3]*x[4]*x[7] -
2*f1*x[2]*x[3]*x[4]*x[8] + 2*f0*f5*x[2]*x[3]*x[5]^2 + (-2*f0*f6 -
2*f1*f5)*x[2]*x[3]*x[5]*x[6] + (-5*f0*f7 + 2*f1*f6)*x[2]*x[3]*x[5]*x[7] -
f1*x[2]*x[3]*x[5]*x[8] + (f1*f6 + f2*f5)*x[2]*x[3]*x[6]^2 + (-2*f0*f8 + 2*f1*f7
- 2*f2*f6)*x[2]*x[3]*x[6]*x[7] + 2*f2*x[2]*x[3]*x[6]*x[8] +
2*f3*f6*x[2]*x[3]*x[7]^2 - 2*f3*x[2]*x[3]*x[7]*x[8] - 2*f2*f4*x[2]*x[4]^3 -
f1*f5*x[2]*x[4]^2*x[5] + (f1*f6 + 2*f2*f5)*x[2]*x[4]^2*x[6] -
f3*f5*x[2]*x[4]^2*x[7] + 2*f2*x[2]*x[4]^2*x[8] - 2*f0*f6*x[2]*x[4]*x[5]^2 +
(-2*f0*f7 + 2*f1*f6 + f2*f5)*x[2]*x[4]*x[5]*x[6] + (2*f0*f8 + f1*f7 -
2*f2*f6)*x[2]*x[4]*x[5]*x[7] + f2*x[2]*x[4]*x[5]*x[8] - 2*f2*f6*x[2]*x[4]*x[6]^2
+ (-f2*f7 + 2*f3*f6)*x[2]*x[4]*x[6]*x[7] + (-f2*f8 - 4*f4*f6 +
f5^2)*x[2]*x[4]*x[7]^2 + 3*f4*x[2]*x[4]*x[7]*x[8] + 2*f0*f7*x[2]*x[5]^2*x[6] +
(5*f0*f8 - 2*f1*f7)*x[2]*x[5]^2*x[7] + (4*f0*f8 - f1*f7)*x[2]*x[5]*x[6]^2 +
(-5*f1*f8 + 2*f2*f7)*x[2]*x[5]*x[6]*x[7] - f3*x[2]*x[5]*x[6]*x[8] + (f2*f8 -
f3*f7)*x[2]*x[5]*x[7]^2 + f2*f7*x[2]*x[6]^3 + f4*x[2]*x[6]^2*x[8] + (-3*f3*f8 +
f4*f7)*x[2]*x[6]*x[7]^2 - 2*f5*x[2]*x[6]*x[7]*x[8] + (f4*f8 -
2*f5*f7)*x[2]*x[7]^3 + 4*f6*x[2]*x[7]^2*x[8] - 4*x[2]*x[7]*x[8]^2 - f0*f4*x[3]^4
+ f1*f4*x[3]^3*x[4] + 2*f0*f5*x[3]^3*x[5] - 2*f1*f5*x[3]^3*x[6] +
f1*f6*x[3]^3*x[7] - f1*x[3]^3*x[8] - f2*f4*x[3]^2*x[4]^2 + (-f1*f6 +
2*f2*f5)*x[3]^2*x[4]*x[6] + f2*x[3]^2*x[4]*x[8] - 4*f0*f6*x[3]^2*x[5]^2 +
(-f0*f7 + 3*f1*f6)*x[3]^2*x[5]*x[6] + (4*f0*f8 - f1*f7)*x[3]^2*x[5]*x[7] +
(-3*f0*f8 + f1*f7 - 2*f2*f6 - f3*f5)*x[3]^2*x[6]^2 + 2*f3*f6*x[3]^2*x[6]*x[7] -
f3*x[3]^2*x[6]*x[8] - f4*f6*x[3]^2*x[7]^2 + f4*x[3]^2*x[7]*x[8] -
f3*f5*x[3]*x[4]^2*x[6] - f3*x[3]*x[4]^2*x[8] + (3*f0*f7 +
f1*f6)*x[3]*x[4]*x[5]^2 + (2*f0*f8 - f1*f7 - 2*f2*f6 +
f3*f5)*x[3]*x[4]*x[5]*x[6] + (-2*f1*f8 + f2*f7)*x[3]*x[4]*x[5]*x[7] +
2*f3*f6*x[3]*x[4]*x[6]^2 + (f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*x[3]*x[4]*x[6]*x[7] + 2*f4*x[3]*x[4]*x[6]*x[8] + f4*f7*x[3]*x[4]*x[7]^2 +
4*f0*f7*x[3]*x[5]^3 + (-f0*f8 - 3*f1*f7)*x[3]*x[5]^2*x[6] +
2*f1*f8*x[3]*x[5]^2*x[7] + (-f1*f8 + 3*f2*f7)*x[3]*x[5]*x[6]^2 + (-f2*f8 -
2*f3*f7)*x[3]*x[5]*x[6]*x[7] + f4*x[3]*x[5]*x[6]*x[8] + f4*f7*x[3]*x[5]*x[7]^2 -
f5*x[3]*x[5]*x[7]*x[8] - 2*f3*f7*x[3]*x[6]^3 + (3*f3*f8 +
2*f4*f7)*x[3]*x[6]^2*x[7] - f5*x[3]*x[6]^2*x[8] - f4*f8*x[3]*x[6]*x[7]^2 +
2*f6*x[3]*x[6]*x[7]*x[8] - x[3]*x[6]*x[8]^2 - f7*x[3]*x[7]^2*x[8] +
f4*x[4]^3*x[8] + (f0*f8 - f1*f7)*x[4]^2*x[5]^2 + f2*f7*x[4]^2*x[5]*x[6] + (f2*f8
- f3*f7)*x[4]^2*x[5]*x[7] - f4*x[4]^2*x[5]*x[8] - f4*f6*x[4]^2*x[6]^2 +
3*f4*f7*x[4]^2*x[6]*x[7] - f5*x[4]^2*x[6]*x[8] - f4*f8*x[4]^2*x[7]^2 -
x[4]^2*x[8]^2 + (-3*f0*f8 - f1*f7)*x[4]*x[5]^3 + (3*f1*f8 +
f2*f7)*x[4]*x[5]^2*x[6] - f2*f8*x[4]*x[5]^2*x[7] - f4*x[4]*x[5]^2*x[8] -
2*f2*f8*x[4]*x[5]*x[6]^2 + 3*f3*f8*x[4]*x[5]*x[6]*x[7] - f4*f8*x[4]*x[5]*x[7]^2
+ f4*f7*x[4]*x[6]^3 + (-6*f4*f8 - 2*f5*f7)*x[4]*x[6]^2*x[7] +
2*f6*x[4]*x[6]^2*x[8] + 4*f5*f8*x[4]*x[6]*x[7]^2 - 2*f7*x[4]*x[6]*x[7]*x[8] +
2*f8*x[4]*x[7]^2*x[8] - 4*f0*f8*x[5]^4 + 4*f1*f8*x[5]^3*x[6] -
4*f2*f8*x[5]^2*x[6]^2 + 2*f3*f8*x[5]^2*x[6]*x[7] - f4*f8*x[5]^2*x[7]^2 +
x[5]^2*x[8]^2 + 2*f3*f8*x[5]*x[6]^3 - 2*f4*f8*x[5]*x[6]^2*x[7] -
f7*x[5]*x[6]*x[7]*x[8] + (4*f6*f8 - f7^2)*x[5]*x[7]^3 - 2*f8*x[5]*x[7]^2*x[8] -
f4*f8*x[6]^4 + 4*f5*f8*x[6]^3*x[7] - f7*x[6]^3*x[8] + (-8*f6*f8 +
2*f7^2)*x[6]^2*x[7]^2 + 6*f8*x[6]^2*x[7]*x[8],

// no.33, (d,w) = (6,25)
  (2*f0*f2*f3*f5*f7*f8 + 8*f0*f2*f4*f5*f6*f8 - 4*f0*f3^2*f5*f6*f8 +
2*f1^2*f4*f5*f6*f8 - f1^2*f4*f5*f7^2 - f1^2*f5^3*f8)*x[1]^4 + (-4*f0*f2*f3*f6*f8
- 8*f0*f2*f4*f5*f8 - 4*f0*f2*f4*f6*f7 + 4*f0*f3^2*f5*f8 + 2*f0*f3^2*f6*f7 -
2*f1^2*f4*f5*f8 + f1^2*f4*f6*f7 + f1^2*f5^2*f7)*x[1]^3*x[2] + (-2*f0*f2*f3*f7*f8
+ 2*f0*f2*f5^2*f8 + 4*f0*f3^2*f6*f8 - 2*f0*f3*f4*f6*f7 + 2*f1^2*f4*f6*f8 +
f1^2*f5^2*f8)*x[1]^3*x[3] + (4*f0*f2*f4*f7*f8 - 4*f0*f3*f4*f6*f8 -
4*f1*f2*f4*f6*f8 + f1*f2*f5^2*f8 + f1*f3*f4*f6*f7 - f1*f3*f5^2*f7)*x[1]^3*x[4] +
(4*f0*f2*f4*f7*f8 - 8*f0*f2*f5*f6*f8 - 2*f0*f3^2*f7*f8 - 4*f0*f3*f4*f6*f8 +
2*f0*f3*f4*f7^2 + 4*f0*f3*f5^2*f8 - 2*f1^2*f4*f7*f8 - 2*f1^2*f5*f6*f8 +
f1^2*f5*f7^2)*x[1]^3*x[5] + (-2*f0*f2*f5*f7*f8 + 4*f0*f3*f5*f6*f8 +
2*f1*f2*f4*f7*f8 + 2*f1*f3*f4*f6*f8 - f1*f3*f4*f7^2)*x[1]^3*x[6] +
(-2*f0*f3*f5*f7*f8 - 8*f0*f4*f5*f6*f8 - f1*f2*f5*f7*f8 +
f1*f3*f5*f7^2)*x[1]^3*x[7] + (-f0*f2*f7*f8 + 3*f0*f3*f6*f8 + 3*f0*f4*f5*f8 +
f0*f4*f6*f7 + f1*f2*f6*f8 - f1*f3*f5*f8 - f1*f3*f6*f7)*x[1]^3*x[8] +
(4*f0*f2*f3*f8 + 4*f0*f2*f4*f7 - 2*f0*f3^2*f7 - f1^2*f4*f7 -
f1^2*f5*f6)*x[1]^2*x[2]^2 + (-4*f0*f3^2*f8 + 2*f0*f3*f4*f7 + 2*f0*f3*f5*f6 -
2*f1^2*f4*f8 - f1^2*f5*f7)*x[1]^2*x[2]*x[3] + (-2*f0*f2*f5*f8 + 4*f0*f3*f4*f8 +
4*f1*f2*f4*f8 - f1*f3*f4*f7 + f1*f3*f5*f6)*x[1]^2*x[2]*x[4] + (6*f0*f2*f5*f8 +
4*f0*f2*f6*f7 + 4*f0*f3*f4*f8 - 4*f0*f3*f5*f7 + 3*f1^2*f5*f8 -
f1^2*f6*f7)*x[1]^2*x[2]*x[5] + (4*f0*f2*f6*f8 - 4*f0*f3*f5*f8 - 2*f0*f3*f6*f7 -
f1*f2*f5*f8 - 2*f1*f3*f4*f8 + f1*f3*f5*f7)*x[1]^2*x[2]*x[6] + (f0*f2*f7*f8 +
f0*f3*f6*f8 + 5*f0*f4*f5*f8 + 3*f0*f4*f6*f7 + f1*f2*f6*f8 + f1*f3*f5*f8 -
f1*f3*f6*f7)*x[1]^2*x[2]*x[7] + (-4*f0*f3*f8 - 2*f0*f4*f7 - 2*f1*f2*f8 +
f1*f3*f7)*x[1]^2*x[2]*x[8] + (-4*f0*f2*f5*f8 - 2*f0*f4*f5*f6 +
f1^2*f5*f8)*x[1]^2*x[3]^2 + (4*f0*f3*f5*f8 - 2*f1*f2*f5*f8 + f1*f3*f5*f7 -
2*f1*f4*f5*f6 + f1*f5^3)*x[1]^2*x[3]*x[4] + (-6*f0*f3*f5*f8 + 2*f0*f3*f6*f7 +
2*f0*f4*f5*f7 - 2*f1^2*f6*f8)*x[1]^2*x[3]*x[5] + (f0*f2*f7*f8 - f0*f3*f6*f8 +
3*f0*f4*f5*f8 - f0*f4*f6*f7 + f1*f2*f6*f8 + f1*f3*f5*f8 - f1*f3*f6*f7 +
f1*f4*f5*f7)*x[1]^2*x[3]*x[6] + (2*f0*f3*f7*f8 - 2*f0*f5^2*f8 + f1*f2*f7*f8 -
4*f1*f3*f6*f8 + f1*f4*f6*f7 - f1*f5^2*f7)*x[1]^2*x[3]*x[7] + (2*f1*f3*f8 +
f1*f5*f6)*x[1]^2*x[3]*x[8] + (-2*f1*f4*f5*f7 + 2*f2*f4*f5*f6 -
f2*f5^3)*x[1]^2*x[4]^2 + (-3*f0*f2*f7*f8 + f0*f3*f6*f8 + f0*f4*f5*f8 -
f0*f4*f6*f7 + 3*f1*f2*f6*f8 + f1*f4*f5*f7)*x[1]^2*x[4]*x[5] + (-4*f0*f4*f6*f8 +
2*f1*f4*f5*f8 + f1*f4*f6*f7 + f1*f5^2*f7 - f2*f3*f5*f8 -
2*f2*f4*f5*f7)*x[1]^2*x[4]*x[6] + (-4*f0*f4*f7*f8 + 6*f1*f4*f6*f8 - 3*f1*f5^2*f8
+ 2*f2*f3*f6*f8 - 2*f2*f4*f6*f7 + 2*f2*f5^2*f7)*x[1]^2*x[4]*x[7] + (f0*f5*f8 -
3*f1*f4*f8 + f1*f5*f7 - f2*f3*f8 - f2*f5*f6)*x[1]^2*x[4]*x[8] + (-4*f0*f2*f7*f8
+ 4*f0*f3*f6*f8 - 2*f0*f3*f7^2 - 4*f0*f4*f5*f8 + 2*f1^2*f7*f8)*x[1]^2*x[5]^2 +
(4*f0*f3*f7*f8 - 4*f0*f4*f6*f8 + 2*f0*f4*f7^2 - 2*f1*f2*f7*f8 - 2*f1*f3*f6*f8 +
f1*f3*f7^2)*x[1]^2*x[5]*x[6] + (-4*f0*f4*f7*f8 + 8*f0*f5*f6*f8 + 2*f1*f3*f7*f8 +
2*f1*f4*f6*f8 - f1*f4*f7^2)*x[1]^2*x[5]*x[7] + (-2*f0*f5*f8 -
2*f0*f6*f7)*x[1]^2*x[5]*x[8] + (2*f1*f4*f6*f8 - f1*f4*f7^2 - 2*f1*f5^2*f8 +
f3^2*f5*f8)*x[1]^2*x[6]^2 + (2*f0*f5*f7*f8 - 2*f1*f4*f7*f8 + 2*f1*f5*f6*f8 -
f1*f5*f7^2 - f2*f3*f7*f8 - 4*f2*f4*f6*f8 + 2*f2*f4*f7^2)*x[1]^2*x[6]*x[7] +
(-f1*f5*f8 + f2*f4*f8)*x[1]^2*x[6]*x[8] + (f1*f5*f7*f8 -
f2*f5*f7^2)*x[1]^2*x[7]^2 + (2*f0*f7*f8 - 2*f1*f6*f8 + f2*f5*f8 +
f2*f6*f7)*x[1]^2*x[7]*x[8] + f1*f8*x[1]^2*x[8]^2 + f1^2*f5*x[1]*x[2]^3 +
(-4*f0*f2*f6 - 2*f0*f3*f5 + f1^2*f6)*x[1]*x[2]^2*x[3] + (2*f0*f3*f6 -
f1*f3*f5)*x[1]*x[2]^2*x[4] + (-4*f0*f2*f7 + 2*f0*f3*f6 +
f1^2*f7)*x[1]*x[2]^2*x[5] + (-4*f0*f2*f8 + 2*f0*f3*f7 -
f1*f3*f6)*x[1]*x[2]^2*x[6] + (-2*f0*f4*f7 + f1*f3*f7)*x[1]*x[2]^2*x[7] +
(2*f0*f3*f6 + 2*f0*f4*f5)*x[1]*x[2]*x[3]^2 + (2*f0*f2*f8 - 2*f0*f4*f6 - f1*f3*f6
+ 2*f1*f4*f5)*x[1]*x[2]*x[3]*x[4] + (2*f0*f2*f8 - 2*f0*f4*f6 +
f1^2*f8)*x[1]*x[2]*x[3]*x[5] + (-f1*f2*f8 + f1*f4*f6 -
f1*f5^2)*x[1]*x[2]*x[3]*x[6] + (2*f1*f3*f8 - f1*f4*f7)*x[1]*x[2]*x[3]*x[7] +
(3*f0*f6 - f1*f5)*x[1]*x[2]*x[3]*x[8] + (f1*f4*f6 + f1*f5^2 -
2*f2*f4*f5)*x[1]*x[2]*x[4]^2 + (-2*f0*f3*f8 - 2*f1*f2*f8 + f1*f4*f6 -
f1*f5^2)*x[1]*x[2]*x[4]*x[5] + (4*f0*f4*f8 - 2*f1*f5*f6 - 2*f2*f4*f6 + 2*f2*f5^2
+ f3^2*f6)*x[1]*x[2]*x[4]*x[6] + (f0*f5*f8 - 3*f1*f4*f8 - f2*f3*f8 + 2*f2*f4*f7
- f2*f5*f6)*x[1]*x[2]*x[4]*x[7] + (-f1*f6 + 2*f2*f5)*x[1]*x[2]*x[4]*x[8] +
(-2*f0*f3*f8 + 2*f0*f4*f7)*x[1]*x[2]*x[5]^2 + (4*f0*f4*f8 + f1*f3*f8 -
2*f1*f4*f7)*x[1]*x[2]*x[5]*x[6] + (-4*f0*f5*f8 - 2*f0*f6*f7 - 2*f1*f4*f8 +
f1*f5*f7)*x[1]*x[2]*x[5]*x[7] + 2*f0*f7*x[1]*x[2]*x[5]*x[8] + (-2*f1*f4*f8 +
f1*f5*f7 + f2*f3*f8 + 2*f2*f4*f7 - f3^2*f7)*x[1]*x[2]*x[6]^2 + (-4*f0*f6*f8 +
f1*f6*f7 + 3*f2*f4*f8 - 2*f2*f5*f7)*x[1]*x[2]*x[6]*x[7] +
f2*f6*x[1]*x[2]*x[6]*x[8] + (-2*f0*f7*f8 - f2*f5*f8 + f2*f6*f7)*x[1]*x[2]*x[7]^2
+ (f1*f8 - 2*f2*f7)*x[1]*x[2]*x[7]*x[8] + (2*f0*f2*f8 - 2*f0*f4*f6 -
f1^2*f8)*x[1]*x[3]^3 + (-4*f0*f3*f8 + f1*f2*f8 + 2*f1*f4*f6 -
2*f1*f5^2)*x[1]*x[3]^2*x[4] + (2*f0*f3*f8 + 2*f0*f4*f7 +
2*f0*f5*f6)*x[1]*x[3]^2*x[5] + (-f1*f4*f7 + f1*f5*f6)*x[1]*x[3]^2*x[6] +
(4*f0*f5*f8 + f1*f5*f7)*x[1]*x[3]^2*x[7] - f1*f6*x[1]*x[3]^2*x[8] + (4*f0*f4*f8
- 2*f2*f4*f6 + 2*f2*f5^2)*x[1]*x[3]*x[4]^2 + (-f1*f3*f8 - f1*f4*f7 +
f1*f5*f6)*x[1]*x[3]*x[4]*x[5] + (-3*f0*f5*f8 - f1*f4*f8 + 2*f2*f4*f7 - f2*f5*f6
- f3*f4*f6)*x[1]*x[3]*x[4]*x[6] + (2*f1*f5*f8 - 2*f2*f5*f7)*x[1]*x[3]*x[4]*x[7]
+ (-2*f0*f8 + f2*f6)*x[1]*x[3]*x[4]*x[8] + (-4*f0*f4*f8 -
2*f0*f5*f7)*x[1]*x[3]*x[5]^2 + (-4*f0*f5*f8 + 2*f1*f4*f8 -
f1*f5*f7)*x[1]*x[3]*x[5]*x[6] + (f1*f5*f8 - f1*f6*f7)*x[1]*x[3]*x[5]*x[7] -
f0*f8*x[1]*x[3]*x[5]*x[8] + (f1*f5*f8 - f2*f4*f8 - f3^2*f8 +
f3*f4*f7)*x[1]*x[3]*x[6]^2 + (-f2*f5*f8 + f2*f6*f7)*x[1]*x[3]*x[6]*x[7] +
(-f1*f7*f8 + 2*f2*f6*f8)*x[1]*x[3]*x[7]^2 - f2*f8*x[1]*x[3]*x[7]*x[8] +
(f3*f4*f6 - f3*f5^2)*x[1]*x[4]^3 + (-f0*f5*f8 + f1*f4*f8 + f1*f5*f7 + f2*f3*f8 -
f2*f5*f6 + f3*f4*f6)*x[1]*x[4]^2*x[5] + (-2*f2*f4*f8 - f3*f4*f7 +
f3*f5*f6)*x[1]*x[4]^2*x[6] + (f2*f5*f8 + f3*f5*f7 - 2*f4*f5*f6 +
f5^3)*x[1]*x[4]^2*x[7] + f4*f5*x[1]*x[4]^2*x[8] + (-2*f0*f5*f8 + 2*f0*f6*f7 +
2*f1*f4*f8 - f1*f5*f7)*x[1]*x[4]*x[5]^2 + (4*f0*f6*f8 - f1*f6*f7 - 3*f2*f4*f8 +
2*f2*f5*f7 + f3^2*f8 - f3*f4*f7)*x[1]*x[4]*x[5]*x[6] + (2*f0*f7*f8 - 4*f1*f6*f8
+ f2*f6*f7)*x[1]*x[4]*x[5]*x[7] + (2*f1*f8 - f3*f6)*x[1]*x[4]*x[5]*x[8] +
(f2*f5*f8 + 2*f3*f4*f8 - f3*f5*f7)*x[1]*x[4]*x[6]^2 + (-2*f2*f6*f8 + f3*f5*f8 -
f3*f6*f7 + 2*f4*f5*f7)*x[1]*x[4]*x[6]*x[7] + (2*f2*f8 + f4*f6 -
f5^2)*x[1]*x[4]*x[6]*x[8] + (-f2*f7*f8 - 2*f3*f6*f8 + 2*f4*f6*f7 -
2*f5^2*f7)*x[1]*x[4]*x[7]^2 + (2*f3*f8 - f4*f7 + f5*f6)*x[1]*x[4]*x[7]*x[8] -
f5*x[1]*x[4]*x[8]^2 + 4*f0*f5*f8*x[1]*x[5]^3 + (4*f0*f6*f8 -
2*f0*f7^2)*x[1]*x[5]^2*x[6] + (4*f0*f7*f8 - 2*f1*f6*f8 +
f1*f7^2)*x[1]*x[5]^2*x[7] + (-2*f0*f7*f8 - 2*f1*f6*f8 +
f1*f7^2)*x[1]*x[5]*x[6]^2 + (4*f2*f6*f8 - 2*f2*f7^2 -
2*f3*f5*f8)*x[1]*x[5]*x[6]*x[7] + (-f2*f8 + f3*f7)*x[1]*x[5]*x[6]*x[8] -
f2*f7*f8*x[1]*x[5]*x[7]^2 + f4*f7*x[1]*x[5]*x[7]*x[8] + (f2*f7*f8 - 2*f3*f6*f8 +
f3*f7^2)*x[1]*x[6]^2*x[7] + (-f3*f8 - f4*f7)*x[1]*x[6]^2*x[8] + (f3*f7*f8 +
4*f4*f6*f8 - 2*f4*f7^2)*x[1]*x[6]*x[7]^2 + (-2*f4*f8 +
f5*f7)*x[1]*x[6]*x[7]*x[8] - f6*x[1]*x[6]*x[8]^2 + f5*f7^2*x[1]*x[7]^3 + (-f5*f8
- f6*f7)*x[1]*x[7]^2*x[8] + f7*x[1]*x[7]*x[8]^2 + (4*f0*f2 - f1^2)*x[2]^3*x[3] -
2*f0*f3*x[2]^3*x[4] - 2*f0*f3*x[2]^3*x[5] + f1*f3*x[2]^3*x[6] -
2*f0*f3*x[2]^2*x[3]^2 + (2*f0*f4 + f1*f3)*x[2]^2*x[3]*x[4] +
2*f0*f4*x[2]^2*x[3]*x[5] - f1*f4*x[2]^2*x[3]*x[6] + f0*f6*x[2]^2*x[3]*x[7] -
4*f0*x[2]^2*x[3]*x[8] - f1*f4*x[2]^2*x[4]^2 - f1*f4*x[2]^2*x[4]*x[5] + (f1*f5 +
2*f2*f4 - f3^2)*x[2]^2*x[4]*x[6] + f1*x[2]^2*x[4]*x[8] + f1*f5*x[2]^2*x[5]*x[6]
+ (2*f0*f7 - f1*f6)*x[2]^2*x[5]*x[7] + f1*x[2]^2*x[5]*x[8] - f2*f5*x[2]^2*x[6]^2
+ (4*f0*f8 - f1*f7 + f2*f6)*x[2]^2*x[6]*x[7] - 2*f2*x[2]^2*x[6]*x[8] +
2*f0*f4*x[2]*x[3]^3 - 2*f1*f4*x[2]*x[3]^2*x[4] - 4*f0*f5*x[2]*x[3]^2*x[5] +
(-f0*f6 + f1*f5)*x[2]*x[3]^2*x[6] + f1*x[2]*x[3]^2*x[8] + (-f1*f5 +
2*f2*f4)*x[2]*x[3]*x[4]^2 + (-f0*f6 + f1*f5)*x[2]*x[3]*x[4]*x[5] + (f1*f6 -
2*f2*f5 + f3*f4)*x[2]*x[3]*x[4]*x[6] + f2*f6*x[2]*x[3]*x[4]*x[7] -
2*f2*x[2]*x[3]*x[4]*x[8] + 2*f0*f6*x[2]*x[3]*x[5]^2 + (2*f0*f7 -
f1*f6)*x[2]*x[3]*x[5]*x[6] - f0*f8*x[2]*x[3]*x[5]*x[7] + (-f1*f7 +
f2*f6)*x[2]*x[3]*x[6]^2 - f3*f6*x[2]*x[3]*x[6]*x[7] + f3*x[2]*x[3]*x[6]*x[8] -
f2*f8*x[2]*x[3]*x[7]^2 - f3*f4*x[2]*x[4]^3 - f3*f4*x[2]*x[4]^2*x[5] +
f3*f5*x[2]*x[4]^2*x[6] + (-f3*f6 + f4*f5)*x[2]*x[4]^2*x[7] + f3*x[2]*x[4]^2*x[8]
- f1*f6*x[2]*x[4]*x[5]^2 + (-2*f0*f8 + f2*f6)*x[2]*x[4]*x[5]*x[6] +
2*f1*f8*x[2]*x[4]*x[5]*x[7] + f3*x[2]*x[4]*x[5]*x[8] - f3*f6*x[2]*x[4]*x[6]^2 +
(f2*f8 + f4*f6 - f5^2)*x[2]*x[4]*x[6]*x[7] - 2*f4*x[2]*x[4]*x[6]*x[8] + (-f4*f7
+ f5*f6)*x[2]*x[4]*x[7]^2 - f5*x[2]*x[4]*x[7]*x[8] - 2*f0*f7*x[2]*x[5]^3 +
(-6*f0*f8 + 2*f1*f7)*x[2]*x[5]^2*x[6] + f1*f8*x[2]*x[5]^2*x[7] + (3*f1*f8 -
2*f2*f7)*x[2]*x[5]*x[6]^2 + (-2*f2*f8 + f3*f7)*x[2]*x[5]*x[6]*x[7] -
f4*f7*x[2]*x[5]*x[7]^2 + (-f2*f8 + f3*f7)*x[2]*x[6]^3 + (2*f3*f8 -
f4*f7)*x[2]*x[6]^2*x[7] + f5*x[2]*x[6]^2*x[8] + (-2*f4*f8 +
f5*f7)*x[2]*x[6]*x[7]^2 - f6*x[2]*x[6]*x[7]*x[8] + 2*x[2]*x[6]*x[8]^2 + (f5*f8 -
f6*f7)*x[2]*x[7]^3 + f7*x[2]*x[7]^2*x[8] + f1*f5*x[3]^3*x[4] +
2*f0*f6*x[3]^3*x[5] - f1*f6*x[3]^3*x[6] - 2*f0*f8*x[3]^3*x[7] -
f2*f5*x[3]^2*x[4]^2 - f1*f6*x[3]^2*x[4]*x[5] + (2*f0*f8 +
f2*f6)*x[3]^2*x[4]*x[6] + f1*f8*x[3]^2*x[4]*x[7] - 2*f0*f7*x[3]^2*x[5]^2 +
(f0*f8 + f1*f7)*x[3]^2*x[5]*x[6] - f1*f8*x[3]^2*x[5]*x[7] - f1*f8*x[3]^2*x[6]^2
+ (f2*f8 + f4*f6)*x[3]^2*x[6]*x[7] - f4*x[3]^2*x[6]*x[8] + f3*f5*x[3]*x[4]^3 +
(-2*f0*f8 + f2*f6)*x[3]*x[4]^2*x[5] - f3*f6*x[3]*x[4]^2*x[6] + (-f2*f8 + f4*f6 -
f5^2)*x[3]*x[4]^2*x[7] - f4*x[3]*x[4]^2*x[8] + (f0*f8 + f1*f7)*x[3]*x[4]*x[5]^2
+ (f1*f8 - 2*f2*f7)*x[3]*x[4]*x[5]*x[6] - f4*f6*x[3]*x[4]*x[5]*x[7] +
f4*x[3]*x[4]*x[5]*x[8] + (f2*f8 + f3*f7)*x[3]*x[4]*x[6]^2 + (-f3*f8 -
f4*f7)*x[3]*x[4]*x[6]*x[7] + f5*x[3]*x[4]*x[6]*x[8] + f5*f7*x[3]*x[4]*x[7]^2 -
f6*x[3]*x[4]*x[7]*x[8] + x[3]*x[4]*x[8]^2 + 4*f0*f8*x[3]*x[5]^3 -
2*f1*f8*x[3]*x[5]^2*x[6] + f2*f8*x[3]*x[5]*x[6]^2 + f3*f8*x[3]*x[5]*x[6]*x[7] +
f6*x[3]*x[5]*x[7]*x[8] - x[3]*x[5]*x[8]^2 - f3*f8*x[3]*x[6]^3 -
f6*x[3]*x[6]^2*x[8] + f5*f8*x[3]*x[6]*x[7]^2 - 2*f6*f8*x[3]*x[7]^3 +
2*f8*x[3]*x[7]^2*x[8] - f4*f5*x[4]^4 - f3*f6*x[4]^3*x[5] + (f4*f6 +
f5^2)*x[4]^3*x[6] + f5*x[4]^3*x[8] - f1*f8*x[4]^2*x[5]^2 +
f3*f7*x[4]^2*x[5]*x[6] + (-f3*f8 + f5*f6)*x[4]^2*x[5]*x[7] + (-f4*f7 -
f5*f6)*x[4]^2*x[6]^2 + (4*f4*f8 - f5*f7)*x[4]^2*x[6]*x[7] - f6*x[4]^2*x[6]*x[8]
- 2*f5*f8*x[4]^2*x[7]^2 - 2*f1*f8*x[4]*x[5]^3 + 3*f2*f8*x[4]*x[5]^2*x[6] -
f3*f8*x[4]*x[5]^2*x[7] - 3*f3*f8*x[4]*x[5]*x[6]^2 + (2*f4*f8 -
f5*f7)*x[4]*x[5]*x[6]*x[7] - f6*f7*x[4]*x[5]*x[7]^2 + (2*f4*f8 +
f5*f7)*x[4]*x[6]^3 + (-3*f5*f8 + f6*f7)*x[4]*x[6]^2*x[7] + f7*x[4]*x[6]^2*x[8] +
4*f6*f8*x[4]*x[6]*x[7]^2 - 5*f8*x[4]*x[6]*x[7]*x[8] + f7*f8*x[4]*x[7]^3 +
f5*f8*x[5]^2*x[7]^2 - f7*x[5]^2*x[7]*x[8] + f7*x[5]*x[6]^2*x[8] + (-2*f6*f8 +
f7^2)*x[5]*x[6]*x[7]^2 + f8*x[5]*x[6]*x[7]*x[8] + f7*f8*x[5]*x[7]^3 -
f5*f8*x[6]^4 + (2*f6*f8 - f7^2)*x[6]^3*x[7] - f8*x[6]^3*x[8] -
f7*f8*x[6]^2*x[7]^2,

// no.34, (d,w) = (6,26)
  (-4*f0*f2*f4*f6*f7^2 - 4*f0*f2*f5^2*f6*f8 + f0*f3^2*f6*f7^2 + f1^2*f4*f6*f7^2
+ f1^2*f5^2*f6*f8)*x[1]^4 + (4*f0*f2*f5^2*f8 + 4*f0*f2*f5*f6*f7 - f1^2*f5^2*f8 -
f1^2*f5*f6*f7)*x[1]^3*x[2] - 2*f0*f3*f5*f6*f7*x[1]^3*x[3] +
f1*f3*f5*f6*f7*x[1]^3*x[4] + (4*f0*f2*f5*f7*f8 + 4*f0*f2*f6*f7^2 - f1^2*f5*f7*f8
- f1^2*f6*f7^2)*x[1]^3*x[5] + (-2*f0*f3*f5*f7*f8 - 2*f0*f3*f6*f7^2)*x[1]^3*x[6]
+ (4*f0*f4*f6*f7^2 + 4*f0*f5^2*f6*f8 - f1*f3*f6*f7^2)*x[1]^3*x[7] +
(-2*f0*f5^2*f8 - f0*f5*f6*f7)*x[1]^3*x[8] + (-4*f0*f2*f5*f7 +
f1^2*f5*f7)*x[1]^2*x[2]^2 + 2*f0*f3*f5*f7*x[1]^2*x[2]*x[3] -
f1*f3*f5*f7*x[1]^2*x[2]*x[4] + (8*f0*f2*f6*f8 - 4*f0*f2*f7^2 - 2*f1^2*f6*f8 +
f1^2*f7^2)*x[1]^2*x[2]*x[5] + (-4*f0*f3*f6*f8 + 2*f0*f3*f7^2)*x[1]^2*x[2]*x[6] +
(-2*f0*f5^2*f8 - 3*f0*f5*f6*f7)*x[1]^2*x[2]*x[7] + 2*f0*f5*f7*x[1]^2*x[2]*x[8] +
(4*f0*f2*f6*f8 + f0*f5^2*f6 - f1^2*f6*f8)*x[1]^2*x[3]^2 + (-4*f0*f3*f6*f8 -
f1*f5^2*f6)*x[1]^2*x[3]*x[4] + (-4*f0*f2*f7*f8 - 8*f0*f3*f6*f8 + 4*f0*f3*f7^2 +
f1^2*f7*f8)*x[1]^2*x[3]*x[5] + (2*f0*f3*f7*f8 + 8*f0*f4*f6*f8 - 4*f0*f4*f7^2 -
4*f0*f5^2*f8 + f0*f5*f6*f7 + 2*f1*f3*f6*f8 - f1*f3*f7^2)*x[1]^2*x[3]*x[6] +
f1*f5*f6*f7*x[1]^2*x[3]*x[7] + (4*f0*f4*f6*f8 + f2*f5^2*f6)*x[1]^2*x[4]^2 +
(2*f0*f3*f7*f8 + 8*f0*f4*f6*f8 - 4*f0*f4*f7^2 - 2*f0*f5^2*f8 + f0*f5*f6*f7 +
2*f1*f3*f6*f8 - f1*f3*f7^2)*x[1]^2*x[4]*x[5] + (-4*f0*f4*f7*f8 - 8*f1*f4*f6*f8 +
4*f1*f4*f7^2 + 3*f1*f5^2*f8 - f1*f5*f6*f7)*x[1]^2*x[4]*x[6] -
2*f2*f5*f6*f7*x[1]^2*x[4]*x[7] + (-2*f0*f6*f8 + f1*f5*f8 +
f2*f5*f7)*x[1]^2*x[4]*x[8] + (-2*f0*f3*f7*f8 + 4*f0*f4*f6*f8)*x[1]^2*x[5]^2 +
(4*f0*f4*f7*f8 + f1*f3*f7*f8 - 4*f1*f4*f6*f8)*x[1]^2*x[5]*x[6] + (-4*f0*f5*f7*f8
- 4*f0*f6*f7^2)*x[1]^2*x[5]*x[7] + (-4*f0*f6*f8 + 2*f0*f7^2 +
f1*f5*f8)*x[1]^2*x[5]*x[8] + (2*f0*f5*f7*f8 + f0*f6*f7^2 - 2*f1*f4*f7*f8 +
4*f2*f4*f6*f8 - f3^2*f6*f8)*x[1]^2*x[6]^2 + (f1*f5*f7*f8 +
f1*f6*f7^2)*x[1]^2*x[6]*x[7] + (f0*f7*f8 + 2*f1*f6*f8 - f1*f7^2 -
f2*f5*f8)*x[1]^2*x[6]*x[8] + f2*f6*f7^2*x[1]^2*x[7]^2 + (4*f0*f2*f6 -
f1^2*f6)*x[1]*x[2]^3 - 4*f0*f3*f6*x[1]*x[2]^2*x[3] + 2*f1*f3*f6*x[1]*x[2]^2*x[4]
+ (-8*f0*f2*f8 + 2*f1^2*f8)*x[1]*x[2]^2*x[5] + 4*f0*f3*f8*x[1]*x[2]^2*x[6] +
2*f0*f5*f7*x[1]*x[2]^2*x[7] - 2*f0*f6*x[1]*x[2]^2*x[8] + (-4*f0*f2*f8 +
4*f0*f4*f6 - 2*f0*f5^2 + f1^2*f8)*x[1]*x[2]*x[3]^2 + (4*f0*f3*f8 - 4*f1*f4*f6 +
2*f1*f5^2)*x[1]*x[2]*x[3]*x[4] + 8*f0*f3*f8*x[1]*x[2]*x[3]*x[5] + (-8*f0*f4*f8 +
2*f0*f5*f7 - 2*f1*f3*f8)*x[1]*x[2]*x[3]*x[6] - f1*f5*f7*x[1]*x[2]*x[3]*x[7] +
f1*f6*x[1]*x[2]*x[3]*x[8] + (-4*f0*f4*f8 + 4*f2*f4*f6 - 2*f2*f5^2 -
f3^2*f6)*x[1]*x[2]*x[4]^2 + (-8*f0*f4*f8 + 2*f0*f5*f7 -
2*f1*f3*f8)*x[1]*x[2]*x[4]*x[5] + (-2*f0*f5*f8 + 8*f1*f4*f8 -
2*f1*f5*f7)*x[1]*x[2]*x[4]*x[6] + (2*f0*f6*f8 - f1*f5*f8 +
f2*f5*f7)*x[1]*x[2]*x[4]*x[7] + (f0*f8 - 3*f2*f6)*x[1]*x[2]*x[4]*x[8] -
4*f0*f4*f8*x[1]*x[2]*x[5]^2 + (2*f0*f5*f8 + 4*f1*f4*f8)*x[1]*x[2]*x[5]*x[6] +
(-4*f0*f6*f8 + 2*f0*f7^2 - f1*f5*f8)*x[1]*x[2]*x[5]*x[7] +
6*f0*f8*x[1]*x[2]*x[5]*x[8] + (4*f0*f6*f8 - 2*f0*f7^2 - f1*f5*f8 - 4*f2*f4*f8 +
f3^2*f8)*x[1]*x[2]*x[6]^2 + (-f0*f7*f8 + f2*f5*f8)*x[1]*x[2]*x[6]*x[7] +
(-3*f1*f8 + f2*f7)*x[1]*x[2]*x[6]*x[8] - 4*f0*f5*f7*x[1]*x[3]^2*x[5] +
(4*f0*f5*f8 + f1*f5*f7)*x[1]*x[3]^2*x[6] - 4*f0*f6*f8*x[1]*x[3]^2*x[7] +
2*f0*f8*x[1]*x[3]^2*x[8] + (2*f0*f5*f8 + 3*f1*f5*f7)*x[1]*x[3]*x[4]*x[5] +
(2*f0*f6*f8 - 3*f1*f5*f8 - f2*f5*f7)*x[1]*x[3]*x[4]*x[6] +
2*f1*f6*f8*x[1]*x[3]*x[4]*x[7] + (-f1*f8 + f3*f6)*x[1]*x[3]*x[4]*x[8] +
6*f0*f5*f8*x[1]*x[3]*x[5]^2 + (-4*f0*f6*f8 + 2*f0*f7^2 -
4*f1*f5*f8)*x[1]*x[3]*x[5]*x[6] + (4*f0*f7*f8 + 4*f1*f6*f8 -
2*f1*f7^2)*x[1]*x[3]*x[5]*x[7] - 2*f1*f8*x[1]*x[3]*x[5]*x[8] + (-f0*f7*f8 +
3*f2*f5*f8)*x[1]*x[3]*x[6]^2 + (-f1*f7*f8 - 4*f2*f6*f8 +
2*f2*f7^2)*x[1]*x[3]*x[6]*x[7] + (2*f2*f8 - f3*f7 + f4*f6)*x[1]*x[3]*x[6]*x[8] +
(-2*f0*f6*f8 - 3*f2*f5*f7)*x[1]*x[4]^2*x[5] + 2*f3*f5*f7*x[1]*x[4]^2*x[6] -
f5^2*f6*x[1]*x[4]^2*x[7] + (-2*f4*f6 + f5^2)*x[1]*x[4]^2*x[8] + (-4*f0*f6*f8 +
2*f0*f7^2 - 2*f1*f5*f8)*x[1]*x[4]*x[5]^2 + (f0*f7*f8 + 4*f1*f6*f8 - 2*f1*f7^2 +
3*f2*f5*f8)*x[1]*x[4]*x[5]*x[6] + (-f1*f7*f8 - 4*f2*f6*f8 +
2*f2*f7^2)*x[1]*x[4]*x[5]*x[7] + (2*f2*f8 + f3*f7 - f4*f6)*x[1]*x[4]*x[5]*x[8] -
3*f3*f5*f8*x[1]*x[4]*x[6]^2 + (4*f3*f6*f8 - 2*f3*f7^2)*x[1]*x[4]*x[6]*x[7] -
2*f3*f8*x[1]*x[4]*x[6]*x[8] + 2*f5*f6*f7*x[1]*x[4]*x[7]^2 -
f5*f7*x[1]*x[4]*x[7]*x[8] + 2*f6*x[1]*x[4]*x[8]^2 - 4*f0*f6*f8*x[1]*x[5]^3 +
(-2*f0*f7*f8 + 4*f1*f6*f8)*x[1]*x[5]^2*x[6] + f1*f7*f8*x[1]*x[5]^2*x[7] +
(f1*f7*f8 - 4*f2*f6*f8)*x[1]*x[5]*x[6]^2 + (-2*f2*f7*f8 +
2*f3*f6*f8)*x[1]*x[5]*x[6]*x[7] - f3*f8*x[1]*x[5]*x[6]*x[8] +
f6*x[1]*x[5]*x[8]^2 + 2*f3*f6*f8*x[1]*x[6]^3 + (f3*f7*f8 -
4*f4*f6*f8)*x[1]*x[6]^2*x[7] + 2*f4*f8*x[1]*x[6]^2*x[8] - f7*x[1]*x[6]*x[8]^2 -
f6*f7^2*x[1]*x[7]^3 + (-4*f0*f2 + f1^2)*x[2]^4 + 4*f0*f3*x[2]^3*x[3] -
2*f1*f3*x[2]^3*x[4] - 2*f0*f6*x[2]^3*x[7] + 4*f0*x[2]^3*x[8] -
4*f0*f4*x[2]^2*x[3]^2 + (-2*f0*f5 + 4*f1*f4)*x[2]^2*x[3]*x[4] +
2*f0*f5*x[2]^2*x[3]*x[5] + (2*f0*f6 - f1*f5)*x[2]^2*x[3]*x[6] +
f1*f6*x[2]^2*x[3]*x[7] - 2*f1*x[2]^2*x[3]*x[8] + (-f0*f6 + f1*f5 - 4*f2*f4 +
f3^2)*x[2]^2*x[4]^2 - f1*f5*x[2]^2*x[4]*x[5] + (2*f0*f7 - f1*f6 +
2*f2*f5)*x[2]^2*x[4]*x[6] + (-f0*f8 - f2*f6)*x[2]^2*x[4]*x[7] +
4*f2*x[2]^2*x[4]*x[8] - f0*f6*x[2]^2*x[5]^2 + (-2*f0*f7 +
f1*f6)*x[2]^2*x[5]*x[6] + 2*f0*f8*x[2]^2*x[5]*x[7] + (-4*f0*f8 + f1*f7 -
f2*f6)*x[2]^2*x[6]^2 + (f1*f8 - f2*f7)*x[2]^2*x[6]*x[7] + 2*f0*f5*x[2]*x[3]^3 +
(2*f0*f6 - 2*f1*f5)*x[2]*x[3]^2*x[4] - 2*f0*f6*x[2]*x[3]^2*x[5] -
2*f0*f7*x[2]*x[3]^2*x[6] + 2*f0*f8*x[2]*x[3]^2*x[7] + (-f1*f6 +
2*f2*f5)*x[2]*x[3]*x[4]^2 + (-4*f0*f7 + 2*f1*f6)*x[2]*x[3]*x[4]*x[5] + (-f0*f8 +
2*f1*f7 - f2*f6 - f3*f5)*x[2]*x[3]*x[4]*x[6] + (-f1*f8 +
f3*f6)*x[2]*x[3]*x[4]*x[7] - 2*f3*x[2]*x[3]*x[4]*x[8] + (4*f0*f8 +
f1*f7)*x[2]*x[3]*x[5]*x[6] - 2*f1*f8*x[2]*x[3]*x[5]*x[7] + (-f2*f7 +
f3*f6)*x[2]*x[3]*x[6]^2 + (2*f2*f8 + f3*f7 - f4*f6)*x[2]*x[3]*x[6]*x[7] -
f3*f5*x[2]*x[4]^3 + (f0*f8 + f1*f7 - f2*f6 + f3*f5)*x[2]*x[4]^2*x[5] +
f3*f6*x[2]*x[4]^2*x[6] + (-2*f4*f6 + f5^2)*x[2]*x[4]^2*x[7] +
4*f4*x[2]*x[4]^2*x[8] + (6*f0*f8 - f1*f7)*x[2]*x[4]*x[5]^2 + (-5*f1*f8 + f2*f7 -
f3*f6)*x[2]*x[4]*x[5]*x[6] + (2*f2*f8 - f3*f7 + f4*f6)*x[2]*x[4]*x[5]*x[7] -
2*f3*f8*x[2]*x[4]*x[6]*x[7] - 2*f5*x[2]*x[4]*x[6]*x[8] - f5*f7*x[2]*x[4]*x[7]^2
+ 2*f6*x[2]*x[4]*x[7]*x[8] - 4*x[2]*x[4]*x[8]^2 + 2*f0*f8*x[2]*x[5]^3 -
2*f1*f8*x[2]*x[5]^2*x[6] + 2*f2*f8*x[2]*x[5]*x[6]^2 - f3*f8*x[2]*x[5]*x[6]*x[7]
- f6*x[2]*x[5]*x[7]*x[8] - f3*f8*x[2]*x[6]^3 + 2*f4*f8*x[2]*x[6]^2*x[7] +
f6*x[2]*x[6]^2*x[8] + f7*x[2]*x[6]*x[7]*x[8] - f0*f6*x[3]^4 + f1*f6*x[3]^3*x[4]
+ 4*f0*f7*x[3]^3*x[5] - f1*f7*x[3]^3*x[6] - f2*f6*x[3]^2*x[4]^2 -
3*f1*f7*x[3]^2*x[4]*x[5] + 2*f2*f7*x[3]^2*x[4]*x[6] - 6*f0*f8*x[3]^2*x[5]^2 +
3*f1*f8*x[3]^2*x[5]*x[6] - 2*f2*f8*x[3]^2*x[6]^2 + f5*x[3]^2*x[6]*x[8] -
f6*x[3]^2*x[7]*x[8] + x[3]^2*x[8]^2 + f3*f6*x[3]*x[4]^3 +
2*f2*f7*x[3]*x[4]^2*x[5] - 3*f3*f7*x[3]*x[4]^2*x[6] - f5*x[3]*x[4]^2*x[8] +
3*f1*f8*x[3]*x[4]*x[5]^2 - 2*f2*f8*x[3]*x[4]*x[5]*x[6] - f5*x[3]*x[4]*x[5]*x[8]
+ 3*f3*f8*x[3]*x[4]*x[6]^2 + f5*f7*x[3]*x[4]*x[6]*x[7] + f6*x[3]*x[4]*x[6]*x[8]
- 2*f5*f8*x[3]*x[6]^2*x[7] + (2*f6*f8 - f7^2)*x[3]*x[6]*x[7]^2 -
2*f8*x[3]*x[6]*x[7]*x[8] - f4*f6*x[4]^4 - f3*f7*x[4]^3*x[5] +
4*f4*f7*x[4]^3*x[6] + f6*x[4]^3*x[8] - 2*f2*f8*x[4]^2*x[5]^2 +
3*f3*f8*x[4]^2*x[5]*x[6] + f5*f7*x[4]^2*x[5]*x[7] + (-6*f4*f8 -
2*f5*f7)*x[4]^2*x[6]^2 + 3*f5*f8*x[4]^2*x[6]*x[7] - 3*f7*x[4]^2*x[6]*x[8] -
f6*f8*x[4]^2*x[7]^2 + f8*x[4]^2*x[7]*x[8] - f5*f8*x[4]*x[5]*x[6]*x[7] + (2*f6*f8
- f7^2)*x[4]*x[5]*x[7]^2 - 2*f8*x[4]*x[5]*x[7]*x[8] + 3*f5*f8*x[4]*x[6]^3 +
(-4*f6*f8 + 2*f7^2)*x[4]*x[6]^2*x[7] + 5*f8*x[4]*x[6]^2*x[8] +
f7*f8*x[4]*x[6]*x[7]^2 - f6*f8*x[5]^2*x[7]^2 + f8*x[5]^2*x[7]*x[8] +
2*f6*f8*x[5]*x[6]^2*x[7] - f8*x[5]*x[6]^2*x[8] + f7*f8*x[5]*x[6]*x[7]^2 -
f6*f8*x[6]^4 - f7*f8*x[6]^3*x[7]
];
end function;

function K3deltas(fs : Ring := PolynomialRing(Universe(fs), 8))
  P8 := Ring;
  x := [P8.i : i in [1..8]];
  f0,f1,f2,f3,f4,f5,f6,f7,f8 := Explode(fs);
  inv8 := [
// number 1
(256*f0^4*f8^4 - 128*f0^3*f1*f7*f8^3 + 512*f0^3*f2*f6*f8^3 -
64*f0^3*f2*f7^2*f8^2 + 384*f0^3*f3*f5*f8^3 - 640*f0^3*f3*f6*f7*f8^2 +
128*f0^3*f3*f7^3*f8 + 512*f0^3*f4^2*f8^3 - 640*f0^3*f4*f5*f7*f8^2 +
256*f0^3*f4*f6^2*f8^2 + 512*f0^3*f4*f6*f7^2*f8 - 128*f0^3*f4*f7^4 +
448*f0^3*f5^2*f6*f8^2 - 640*f0^3*f5*f6^2*f7*f8 + 128*f0^3*f5*f6*f7^3 +
256*f0^3*f6^4*f8 - 64*f0^3*f6^3*f7^2 - 64*f0^2*f1^2*f6*f8^3 +
16*f0^2*f1^2*f7^2*f8^2 - 640*f0^2*f1*f2*f5*f8^3 + 640*f0^2*f1*f2*f6*f7*f8^2 -
160*f0^2*f1*f2*f7^3*f8 - 640*f0^2*f1*f3*f4*f8^3 + 384*f0^2*f1*f3*f5*f7*f8^2 -
128*f0^2*f1*f3*f6^2*f8^2 - 224*f0^2*f1*f3*f6*f7^2*f8 + 64*f0^2*f1*f3*f7^4 +
128*f0^2*f1*f4^2*f7*f8^2 - 128*f0^2*f1*f4*f5*f6*f8^2 - 64*f0^2*f1*f4*f5*f7^2*f8
+ 128*f0^2*f1*f4*f6^2*f7*f8 - 32*f0^2*f1*f4*f6*f7^3 - 160*f0^2*f1*f5^3*f8^2 +
192*f0^2*f1*f5^2*f6*f7*f8 - 32*f0^2*f1*f5^2*f7^3 - 128*f0^2*f1*f5*f6^3*f8 +
32*f0^2*f1*f5*f6^2*f7^2 + 256*f0^2*f2^2*f4*f8^3 - 128*f0^2*f2^2*f5*f7*f8^2 +
768*f0^2*f2^2*f6^2*f8^2 - 192*f0^2*f2^2*f6*f7^2*f8 + 448*f0^2*f2*f3^2*f8^3 -
128*f0^2*f2*f3*f4*f7*f8^2 - 384*f0^2*f2*f3*f5*f6*f8^2 + 96*f0^2*f2*f3*f5*f7^2*f8
- 128*f0^2*f2*f3*f6^2*f7*f8 + 32*f0^2*f2*f3*f6*f7^3 + 768*f0^2*f2*f4^2*f6*f8^2 -
64*f0^2*f2*f4^2*f7^2*f8 + 192*f0^2*f2*f4*f5^2*f8^2 - 256*f0^2*f2*f4*f5*f6*f7*f8
+ 512*f0^2*f2*f4*f6^3*f8 - 128*f0^2*f2*f4*f6^2*f7^2 - 64*f0^2*f2*f5^3*f7*f8 -
64*f0^2*f2*f5^2*f6^2*f8 + 16*f0^2*f2*f5^2*f6*f7^2 - 160*f0^2*f3^3*f7*f8^2 +
192*f0^2*f3^2*f4*f6*f8^2 + 272*f0^2*f3^2*f5^2*f8^2 - 352*f0^2*f3^2*f5*f6*f7*f8 +
64*f0^2*f3^2*f5*f7^3 + 192*f0^2*f3^2*f6^3*f8 - 48*f0^2*f3^2*f6^2*f7^2 -
640*f0^2*f3*f4^2*f5*f8^2 + 128*f0^2*f3*f4^2*f6*f7*f8 - 32*f0^2*f3*f4^2*f7^3 +
192*f0^2*f3*f4*f5^2*f7*f8 - 384*f0^2*f3*f4*f5*f6^2*f8 + 96*f0^2*f3*f4*f5*f6*f7^2
+ 64*f0^2*f3*f5^3*f6*f8 - 16*f0^2*f3*f5^3*f7^2 + 256*f0^2*f4^4*f8^2 -
128*f0^2*f4^3*f5*f7*f8 + 256*f0^2*f4^3*f6^2*f8 - 64*f0^2*f4^3*f6*f7^2 -
64*f0^2*f4^2*f5^2*f6*f8 + 16*f0^2*f4^2*f5^2*f7^2 + 128*f0*f1^3*f5*f8^3 -
160*f0*f1^3*f6*f7*f8^2 + 40*f0*f1^3*f7^3*f8 + 512*f0*f1^2*f2*f4*f8^3 -
224*f0*f1^2*f2*f5*f7*f8^2 - 192*f0*f1^2*f2*f6^2*f8^2 + 176*f0*f1^2*f2*f6*f7^2*f8
- 32*f0*f1^2*f2*f7^4 - 64*f0*f1^2*f3*f4*f7*f8^2 + 96*f0*f1^2*f3*f5*f6*f8^2 +
8*f0*f1^2*f3*f5*f7^2*f8 - 32*f0*f1^2*f3*f6^2*f7*f8 + 8*f0*f1^2*f3*f6*f7^3 -
64*f0*f1^2*f4^2*f6*f8^2 - 32*f0*f1^2*f4*f5*f6*f7*f8 + 16*f0*f1^2*f4*f5*f7^3 -
64*f0*f1^2*f4*f6^3*f8 + 16*f0*f1^2*f4*f6^2*f7^2 + 16*f0*f1^2*f5^3*f7*f8 +
16*f0*f1^2*f5^2*f6^2*f8 - 4*f0*f1^2*f5^2*f6*f7^2 - 640*f0*f1*f2^2*f3*f8^3 +
128*f0*f1*f2^2*f4*f7*f8^2 - 128*f0*f1*f2^2*f5*f6*f8^2 - 32*f0*f1*f2^2*f5*f7^2*f8
+ 128*f0*f1*f2^2*f6^2*f7*f8 - 32*f0*f1*f2^2*f6*f7^3 + 192*f0*f1*f2*f3^2*f7*f8^2
- 256*f0*f1*f2*f3*f4*f6*f8^2 - 32*f0*f1*f2*f3*f4*f7^2*f8 -
352*f0*f1*f2*f3*f5^2*f8^2 + 512*f0*f1*f2*f3*f5*f6*f7*f8 - 80*f0*f1*f2*f3*f5*f7^3
- 384*f0*f1*f2*f3*f6^3*f8 + 96*f0*f1*f2*f3*f6^2*f7^2 + 128*f0*f1*f2*f4^2*f5*f8^2
- 64*f0*f1*f2*f4*f5^2*f7*f8 + 128*f0*f1*f2*f4*f5*f6^2*f8 -
32*f0*f1*f2*f4*f5*f6*f7^2 - 32*f0*f1*f2*f5^3*f6*f8 + 8*f0*f1*f2*f5^3*f7^2 -
64*f0*f1*f3^3*f6*f8^2 + 16*f0*f1*f3^3*f7^2*f8 + 192*f0*f1*f3^2*f4*f5*f8^2 -
64*f0*f1*f3^2*f4*f6*f7*f8 + 16*f0*f1*f3^2*f4*f7^3 - 32*f0*f1*f3^2*f5^2*f7*f8 +
64*f0*f1*f3^2*f5*f6^2*f8 - 16*f0*f1*f3^2*f5*f6*f7^2 - 128*f0*f1*f3*f4^3*f8^2 +
64*f0*f1*f3*f4^2*f5*f7*f8 - 128*f0*f1*f3*f4^2*f6^2*f8 + 32*f0*f1*f3*f4^2*f6*f7^2
+ 32*f0*f1*f3*f4*f5^2*f6*f8 - 8*f0*f1*f3*f4*f5^2*f7^2 + 256*f0*f2^4*f8^3 -
128*f0*f2^3*f3*f7*f8^2 + 512*f0*f2^3*f4*f6*f8^2 - 64*f0*f2^3*f4*f7^2*f8 +
192*f0*f2^3*f5^2*f8^2 - 384*f0*f2^3*f5*f6*f7*f8 + 64*f0*f2^3*f5*f7^3 +
256*f0*f2^3*f6^3*f8 - 64*f0*f2^3*f6^2*f7^2 - 64*f0*f2^2*f3^2*f6*f8^2 +
16*f0*f2^2*f3^2*f7^2*f8 - 384*f0*f2^2*f3*f4*f5*f8^2 + 128*f0*f2^2*f3*f4*f6*f7*f8
- 32*f0*f2^2*f3*f4*f7^3 + 64*f0*f2^2*f3*f5^2*f7*f8 - 128*f0*f2^2*f3*f5*f6^2*f8 +
32*f0*f2^2*f3*f5*f6*f7^2 + 256*f0*f2^2*f4^3*f8^2 - 128*f0*f2^2*f4^2*f5*f7*f8 +
256*f0*f2^2*f4^2*f6^2*f8 - 64*f0*f2^2*f4^2*f6*f7^2 - 64*f0*f2^2*f4*f5^2*f6*f8 +
16*f0*f2^2*f4*f5^2*f7^2 + 64*f0*f2*f3^3*f5*f8^2 - 32*f0*f2*f3^3*f6*f7*f8 +
8*f0*f2*f3^3*f7^3 - 64*f0*f2*f3^2*f4^2*f8^2 + 32*f0*f2*f3^2*f4*f5*f7*f8 -
64*f0*f2*f3^2*f4*f6^2*f8 + 16*f0*f2*f3^2*f4*f6*f7^2 + 16*f0*f2*f3^2*f5^2*f6*f8 -
4*f0*f2*f3^2*f5^2*f7^2 - 128*f1^4*f4*f8^3 + 64*f1^4*f5*f7*f8^2 -
32*f1^4*f6*f7^2*f8 + 8*f1^4*f7^4 + 128*f1^3*f2*f3*f8^3 - 32*f1^3*f2*f4*f7*f8^2 +
32*f1^3*f2*f5*f6*f8^2 + 8*f1^3*f2*f5*f7^2*f8 - 32*f1^3*f2*f6^2*f7*f8 +
8*f1^3*f2*f6*f7^3 - 32*f1^3*f3^2*f7*f8^2 + 16*f1^3*f3*f4*f7^2*f8 +
64*f1^3*f3*f5^2*f8^2 - 80*f1^3*f3*f5*f6*f7*f8 + 12*f1^3*f3*f5*f7^3 +
64*f1^3*f3*f6^3*f8 - 16*f1^3*f3*f6^2*f7^2 - 32*f1^3*f4^2*f5*f8^2 +
16*f1^3*f4*f5^2*f7*f8 - 32*f1^3*f4*f5*f6^2*f8 + 8*f1^3*f4*f5*f6*f7^2 +
8*f1^3*f5^3*f6*f8 - 2*f1^3*f5^3*f7^2 - 64*f1^2*f2^3*f8^3 +
32*f1^2*f2^2*f3*f7*f8^2 - 128*f1^2*f2^2*f4*f6*f8^2 + 16*f1^2*f2^2*f4*f7^2*f8 -
48*f1^2*f2^2*f5^2*f8^2 + 96*f1^2*f2^2*f5*f6*f7*f8 - 16*f1^2*f2^2*f5*f7^3 -
64*f1^2*f2^2*f6^3*f8 + 16*f1^2*f2^2*f6^2*f7^2 + 16*f1^2*f2*f3^2*f6*f8^2 -
4*f1^2*f2*f3^2*f7^2*f8 + 96*f1^2*f2*f3*f4*f5*f8^2 - 32*f1^2*f2*f3*f4*f6*f7*f8 +
8*f1^2*f2*f3*f4*f7^3 - 16*f1^2*f2*f3*f5^2*f7*f8 + 32*f1^2*f2*f3*f5*f6^2*f8 -
8*f1^2*f2*f3*f5*f6*f7^2 - 64*f1^2*f2*f4^3*f8^2 + 32*f1^2*f2*f4^2*f5*f7*f8 -
64*f1^2*f2*f4^2*f6^2*f8 + 16*f1^2*f2*f4^2*f6*f7^2 + 16*f1^2*f2*f4*f5^2*f6*f8 -
4*f1^2*f2*f4*f5^2*f7^2 - 16*f1^2*f3^3*f5*f8^2 + 8*f1^2*f3^3*f6*f7*f8 -
2*f1^2*f3^3*f7^3 + 16*f1^2*f3^2*f4^2*f8^2 - 8*f1^2*f3^2*f4*f5*f7*f8 +
16*f1^2*f3^2*f4*f6^2*f8 - 4*f1^2*f3^2*f4*f6*f7^2 - 4*f1^2*f3^2*f5^2*f6*f8 +
f1^2*f3^2*f5^2*f7^2)*x[1]^4 + (-512*f0^3*f2*f8^3 + 512*f0^3*f3*f7*f8^2 -
512*f0^3*f4*f6*f8^2 - 256*f0^3*f4*f7^2*f8 - 384*f0^3*f5^2*f8^2 +
768*f0^3*f5*f6*f7*f8 - 64*f0^3*f5*f7^3 - 512*f0^3*f6^3*f8 + 128*f0^3*f6^2*f7^2 +
128*f0^2*f1^2*f8^3 - 384*f0^2*f1*f2*f7*f8^2 + 384*f0^2*f1*f3*f6*f8^2 +
32*f0^2*f1*f3*f7^2*f8 + 256*f0^2*f1*f4*f5*f8^2 - 256*f0^2*f1*f4*f6*f7*f8 +
64*f0^2*f1*f4*f7^3 - 64*f0^2*f1*f5^2*f7*f8 + 256*f0^2*f1*f5*f6^2*f8 -
64*f0^2*f1*f5*f6*f7^2 - 1024*f0^2*f2^2*f6*f8^2 + 128*f0^2*f2^2*f7^2*f8 +
384*f0^2*f2*f3*f6*f7*f8 - 64*f0^2*f2*f3*f7^3 - 512*f0^2*f2*f4^2*f8^2 -
1024*f0^2*f2*f4*f6^2*f8 + 256*f0^2*f2*f4*f6*f7^2 + 128*f0^2*f2*f5^2*f6*f8 +
64*f0^2*f2*f5^2*f7^2 + 192*f0^2*f3^2*f5*f7*f8 - 384*f0^2*f3^2*f6^2*f8 +
96*f0^2*f3^2*f6*f7^2 + 768*f0^2*f3*f4*f5*f6*f8 - 192*f0^2*f3*f4*f5*f7^2 -
128*f0^2*f3*f5^3*f8 - 512*f0^2*f4^3*f6*f8 + 128*f0^2*f4^3*f7^2 +
128*f0^2*f4^2*f5^2*f8 + 96*f0*f1^3*f7*f8^2 + 32*f0*f1^2*f2*f7^2*f8 -
32*f0*f1^2*f3*f5*f8^2 + 32*f0*f1^2*f3*f6*f7*f8 - 16*f0*f1^2*f3*f7^3 +
64*f0*f1^2*f4*f5*f7*f8 + 128*f0*f1^2*f4*f6^2*f8 - 32*f0*f1^2*f4*f6*f7^2 -
32*f0*f1^2*f5^2*f6*f8 - 16*f0*f1^2*f5^2*f7^2 + 256*f0*f1*f2^2*f5*f8^2 -
256*f0*f1*f2^2*f6*f7*f8 + 64*f0*f1*f2^2*f7^3 + 128*f0*f1*f2*f3*f4*f8^2 -
224*f0*f1*f2*f3*f5*f7*f8 + 768*f0*f1*f2*f3*f6^2*f8 - 192*f0*f1*f2*f3*f6*f7^2 -
256*f0*f1*f2*f4*f5*f6*f8 + 64*f0*f1*f2*f4*f5*f7^2 + 64*f0*f1*f2*f5^3*f8 +
32*f0*f1*f3^3*f8^2 - 128*f0*f1*f3^2*f5*f6*f8 + 32*f0*f1*f3^2*f5*f7^2 +
256*f0*f1*f3*f4^2*f6*f8 - 64*f0*f1*f3*f4^2*f7^2 - 64*f0*f1*f3*f4*f5^2*f8 -
512*f0*f2^3*f4*f8^2 + 256*f0*f2^3*f5*f7*f8 - 512*f0*f2^3*f6^2*f8 +
128*f0*f2^3*f6*f7^2 + 128*f0*f2^2*f3^2*f8^2 + 256*f0*f2^2*f3*f5*f6*f8 -
64*f0*f2^2*f3*f5*f7^2 - 512*f0*f2^2*f4^2*f6*f8 + 128*f0*f2^2*f4^2*f7^2 +
128*f0*f2^2*f4*f5^2*f8 + 128*f0*f2*f3^2*f4*f6*f8 - 32*f0*f2*f3^2*f4*f7^2 -
32*f0*f2*f3^2*f5^2*f8 + 64*f1^4*f6*f8^2 - 16*f1^4*f7^2*f8 - 64*f1^3*f2*f5*f8^2 +
64*f1^3*f2*f6*f7*f8 - 16*f1^3*f2*f7^3 + 32*f1^3*f3*f4*f8^2 + 24*f1^3*f3*f5*f7*f8
- 128*f1^3*f3*f6^2*f8 + 32*f1^3*f3*f6*f7^2 + 64*f1^3*f4*f5*f6*f8 -
16*f1^3*f4*f5*f7^2 - 16*f1^3*f5^3*f8 + 128*f1^2*f2^2*f4*f8^2 -
64*f1^2*f2^2*f5*f7*f8 + 128*f1^2*f2^2*f6^2*f8 - 32*f1^2*f2^2*f6*f7^2 -
32*f1^2*f2*f3^2*f8^2 - 64*f1^2*f2*f3*f5*f6*f8 + 16*f1^2*f2*f3*f5*f7^2 +
128*f1^2*f2*f4^2*f6*f8 - 32*f1^2*f2*f4^2*f7^2 - 32*f1^2*f2*f4*f5^2*f8 -
32*f1^2*f3^2*f4*f6*f8 + 8*f1^2*f3^2*f4*f7^2 + 8*f1^2*f3^2*f5^2*f8)*x[1]^3*x[2] +
(-512*f0^3*f3*f8^3 + 512*f0^3*f4*f7*f8^2 - 512*f0^3*f5*f6*f8^2 -
64*f0^3*f5*f7^2*f8 + 512*f0^3*f6^2*f7*f8 - 128*f0^3*f6*f7^3 +
768*f0^2*f1*f2*f8^3 - 320*f0^2*f1*f3*f7*f8^2 + 128*f0^2*f1*f4*f7^2*f8 +
384*f0^2*f1*f5^2*f8^2 - 320*f0^2*f1*f5*f6*f7*f8 + 32*f0^2*f1*f5*f7^3 +
256*f0^2*f2^2*f7*f8^2 + 256*f0^2*f2*f4*f6*f7*f8 + 64*f0^2*f2*f5^2*f7*f8 +
256*f0^2*f2*f5*f6^2*f8 - 128*f0^2*f2*f5*f6*f7^2 - 576*f0^2*f3^2*f5*f8^2 +
512*f0^2*f3^2*f6*f7*f8 - 160*f0^2*f3^2*f7^3 + 512*f0^2*f3*f4^2*f8^2 -
256*f0^2*f3*f4*f5*f7*f8 - 128*f0^2*f3*f5^2*f6*f8 + 32*f0^2*f3*f5^2*f7^2 +
256*f0^2*f4^2*f5*f6*f8 - 64*f0^2*f4^2*f5*f7^2 - 64*f0^2*f4*f5^3*f8 -
192*f0*f1^3*f8^3 + 64*f0*f1^2*f2*f7*f8^2 - 48*f0*f1^2*f3*f7^2*f8 -
128*f0*f1^2*f4*f5*f8^2 + 64*f0*f1^2*f4*f6*f7*f8 - 32*f0*f1^2*f4*f7^3 -
32*f0*f1^2*f5^2*f7*f8 - 64*f0*f1^2*f5*f6^2*f8 + 32*f0*f1^2*f5*f6*f7^2 +
256*f0*f1*f2^2*f6*f8^2 - 64*f0*f1*f2^2*f7^2*f8 + 832*f0*f1*f2*f3*f5*f8^2 -
768*f0*f1*f2*f3*f6*f7*f8 + 192*f0*f1*f2*f3*f7^3 - 256*f0*f1*f2*f4^2*f8^2 +
128*f0*f1*f2*f4*f5*f7*f8 - 16*f0*f1*f2*f5^2*f7^2 - 192*f0*f1*f3^2*f4*f8^2 +
16*f0*f1*f3^2*f5*f7*f8 - 128*f0*f1*f3*f4*f5*f6*f8 + 32*f0*f1*f3*f4*f5*f7^2 +
32*f0*f1*f3*f5^3*f8 - 512*f0*f2^3*f5*f8^2 + 512*f0*f2^3*f6*f7*f8 -
128*f0*f2^3*f7^3 + 512*f0*f2^2*f3*f4*f8^2 - 128*f0*f2^2*f3*f5*f7*f8 +
256*f0*f2^2*f4*f5*f6*f8 - 64*f0*f2^2*f4*f5*f7^2 - 64*f0*f2^2*f5^3*f8 -
128*f0*f2*f3^3*f8^2 - 64*f0*f2*f3^2*f5*f6*f8 + 16*f0*f2*f3^2*f5*f7^2 -
32*f1^4*f7*f8^2 - 64*f1^3*f2*f6*f8^2 + 16*f1^3*f2*f7^2*f8 - 160*f1^3*f3*f5*f8^2
+ 128*f1^3*f3*f6*f7*f8 - 32*f1^3*f3*f7^3 + 64*f1^3*f4^2*f8^2 -
32*f1^3*f4*f5*f7*f8 + 4*f1^3*f5^2*f7^2 + 128*f1^2*f2^2*f5*f8^2 -
128*f1^2*f2^2*f6*f7*f8 + 32*f1^2*f2^2*f7^3 - 128*f1^2*f2*f3*f4*f8^2 +
32*f1^2*f2*f3*f5*f7*f8 - 64*f1^2*f2*f4*f5*f6*f8 + 16*f1^2*f2*f4*f5*f7^2 +
16*f1^2*f2*f5^3*f8 + 32*f1^2*f3^3*f8^2 + 16*f1^2*f3^2*f5*f6*f8 -
4*f1^2*f3^2*f5*f7^2)*x[1]^3*x[3] + (-512*f0^3*f4*f8^3 + 384*f0^3*f5*f7*f8^2 +
512*f0^3*f6^2*f8^2 - 640*f0^3*f6*f7^2*f8 + 128*f0^3*f7^4 + 384*f0^2*f1*f3*f8^3 -
384*f0^2*f1*f5*f6*f8^2 + 96*f0^2*f1*f5*f7^2*f8 + 512*f0^2*f2^2*f8^3 -
384*f0^2*f2*f3*f7*f8^2 + 128*f0^2*f2*f4*f7^2*f8 + 256*f0^2*f2*f5^2*f8^2 -
256*f0^2*f2*f5*f6*f7*f8 + 256*f0^2*f3^2*f6*f8^2 - 96*f0^2*f3^2*f7^2*f8 +
640*f0^2*f3*f4*f5*f8^2 - 768*f0^2*f3*f4*f6*f7*f8 + 192*f0^2*f3*f4*f7^3 -
128*f0^2*f3*f5^2*f7*f8 + 256*f0^2*f3*f5*f6^2*f8 - 32*f0^2*f3*f5*f6*f7^2 -
512*f0^2*f4^3*f8^2 + 256*f0^2*f4^2*f5*f7*f8 - 256*f0^2*f4*f5^2*f6*f8 +
32*f0^2*f4*f5^2*f7^2 + 64*f0^2*f5^4*f8 - 640*f0*f1^2*f2*f8^3 +
96*f0*f1^2*f3*f7*f8^2 + 128*f0*f1^2*f4*f6*f8^2 - 128*f0*f1^2*f4*f7^2*f8 -
96*f0*f1^2*f5^2*f8^2 + 96*f0*f1^2*f5*f6*f7*f8 + 16*f0*f1^2*f5*f7^3 -
256*f0*f1*f2*f3*f6*f8^2 + 96*f0*f1*f2*f3*f7^2*f8 - 768*f0*f1*f2*f4*f5*f8^2 +
512*f0*f1*f2*f4*f6*f7*f8 - 128*f0*f1*f2*f4*f7^3 + 96*f0*f1*f2*f5^2*f7*f8 -
256*f0*f1*f2*f5*f6^2*f8 + 64*f0*f1*f2*f5*f6*f7^2 - 128*f0*f1*f3^2*f5*f8^2 +
96*f0*f1*f3^2*f6*f7*f8 - 16*f0*f1*f3^2*f7^3 + 256*f0*f1*f3*f4^2*f8^2 -
32*f0*f1*f3*f4*f5*f7*f8 + 64*f0*f1*f3*f5^2*f6*f8 + 256*f0*f2^2*f3*f5*f8^2 -
256*f0*f2^2*f3*f6*f7*f8 + 64*f0*f2^2*f3*f7^3 - 256*f0*f2*f3^2*f4*f8^2 +
64*f0*f2*f3^2*f5*f7*f8 - 128*f0*f2*f3*f4*f5*f6*f8 + 32*f0*f2*f3*f4*f5*f7^2 +
32*f0*f2*f3*f5^3*f8 + 64*f0*f3^4*f8^2 + 32*f0*f3^3*f5*f6*f8 - 8*f0*f3^3*f5*f7^2
+ 128*f1^4*f8^3 + 16*f1^3*f3*f7^2*f8 + 192*f1^3*f4*f5*f8^2 -
128*f1^3*f4*f6*f7*f8 + 32*f1^3*f4*f7^3 - 16*f1^3*f5^2*f7*f8 + 64*f1^3*f5*f6^2*f8
- 16*f1^3*f5*f6*f7^2 - 32*f1^2*f2*f3*f5*f8^2 + 64*f1^2*f2*f3*f6*f7*f8 -
16*f1^2*f2*f3*f7^3 + 32*f1^2*f3^2*f4*f8^2 + 32*f1^2*f3*f4*f5*f6*f8 -
8*f1^2*f3*f4*f5*f7^2 - 8*f1^2*f3*f5^3*f8)*x[1]^3*x[4] + (-512*f0^3*f4*f8^3 +
384*f0^3*f5*f7*f8^2 - 512*f0^3*f6^2*f8^2 - 128*f0^3*f6*f7^2*f8 + 64*f0^3*f7^4 +
384*f0^2*f1*f3*f8^3 - 256*f0^2*f1*f4*f7*f8^2 + 128*f0^2*f1*f5*f6*f8^2 +
64*f0^2*f1*f5*f7^2*f8 - 512*f0^2*f2^2*f8^3 + 128*f0^2*f2*f3*f7*f8^2 -
1536*f0^2*f2*f4*f6*f8^2 + 128*f0^2*f2*f4*f7^2*f8 - 128*f0^2*f2*f5^2*f8^2 +
384*f0^2*f2*f5*f6*f7*f8 - 512*f0^2*f2*f6^3*f8 + 128*f0^2*f2*f6^2*f7^2 -
128*f0^2*f3^2*f6*f8^2 + 96*f0^2*f3^2*f7^2*f8 + 640*f0^2*f3*f4*f5*f8^2 -
96*f0^2*f3*f5^2*f7*f8 + 256*f0^2*f3*f5*f6^2*f8 - 64*f0^2*f3*f5*f6*f7^2 -
512*f0^2*f4^3*f8^2 + 256*f0^2*f4^2*f5*f7*f8 - 512*f0^2*f4^2*f6^2*f8 +
128*f0^2*f4^2*f6*f7^2 + 128*f0^2*f4*f5^2*f6*f8 - 32*f0^2*f4*f5^2*f7^2 -
128*f0*f1^2*f2*f8^3 + 64*f0*f1^2*f3*f7*f8^2 + 128*f0*f1^2*f4*f6*f8^2 +
32*f0*f1^2*f4*f7^2*f8 + 96*f0*f1^2*f5^2*f8^2 - 96*f0*f1^2*f5*f6*f7*f8 +
128*f0*f1^2*f6^3*f8 - 32*f0*f1^2*f6^2*f7^2 + 384*f0*f1*f2*f3*f6*f8^2 -
96*f0*f1*f2*f3*f7^2*f8 - 128*f0*f1*f2*f4*f6*f7*f8 + 32*f0*f1*f2*f4*f7^3 +
32*f0*f1*f2*f5^2*f7*f8 - 96*f0*f1*f3^2*f5*f8^2 + 32*f0*f1*f3^2*f6*f7*f8 -
8*f0*f1*f3^2*f7^3 + 256*f0*f1*f3*f4^2*f8^2 - 128*f0*f1*f3*f4*f5*f7*f8 +
256*f0*f1*f3*f4*f6^2*f8 - 64*f0*f1*f3*f4*f6*f7^2 - 64*f0*f1*f3*f5^2*f6*f8 +
16*f0*f1*f3*f5^2*f7^2 - 512*f0*f2^3*f6*f8^2 + 128*f0*f2^3*f7^2*f8 +
256*f0*f2^2*f3*f5*f8^2 - 512*f0*f2^2*f4^2*f8^2 + 256*f0*f2^2*f4*f5*f7*f8 -
512*f0*f2^2*f4*f6^2*f8 + 128*f0*f2^2*f4*f6*f7^2 + 128*f0*f2^2*f5^2*f6*f8 -
32*f0*f2^2*f5^2*f7^2 + 128*f0*f2*f3^2*f4*f8^2 - 64*f0*f2*f3^2*f5*f7*f8 +
128*f0*f2*f3^2*f6^2*f8 - 32*f0*f2*f3^2*f6*f7^2 + 64*f1^4*f8^3 +
32*f1^3*f4*f6*f7*f8 - 8*f1^3*f4*f7^3 - 8*f1^3*f5^2*f7*f8 + 128*f1^2*f2^2*f6*f8^2
- 32*f1^2*f2^2*f7^2*f8 - 64*f1^2*f2*f3*f5*f8^2 + 128*f1^2*f2*f4^2*f8^2 -
64*f1^2*f2*f4*f5*f7*f8 + 128*f1^2*f2*f4*f6^2*f8 - 32*f1^2*f2*f4*f6*f7^2 -
32*f1^2*f2*f5^2*f6*f8 + 8*f1^2*f2*f5^2*f7^2 - 32*f1^2*f3^2*f4*f8^2 +
16*f1^2*f3^2*f5*f7*f8 - 32*f1^2*f3^2*f6^2*f8 + 8*f1^2*f3^2*f6*f7^2)*x[1]^3*x[5]
+ (-512*f0^3*f5*f8^3 + 768*f0^3*f6*f7*f8^2 - 192*f0^3*f7^3*f8 +
512*f0^2*f1*f4*f8^3 - 320*f0^2*f1*f5*f7*f8^2 + 256*f0^2*f1*f6^2*f8^2 +
64*f0^2*f1*f6*f7^2*f8 - 32*f0^2*f1*f7^4 - 512*f0^2*f2*f3*f8^3 +
256*f0^2*f2*f6^2*f7*f8 - 64*f0^2*f2*f6*f7^3 + 384*f0^2*f3^2*f7*f8^2 -
128*f0^2*f3*f4*f7^2*f8 - 576*f0^2*f3*f5^2*f8^2 + 832*f0^2*f3*f5*f6*f7*f8 -
160*f0^2*f3*f5*f7^3 - 512*f0^2*f3*f6^3*f8 + 128*f0^2*f3*f6^2*f7^2 +
512*f0^2*f4^2*f5*f8^2 - 256*f0^2*f4^2*f6*f7*f8 + 64*f0^2*f4^2*f7^3 -
192*f0^2*f4*f5^2*f7*f8 + 512*f0^2*f4*f5*f6^2*f8 - 128*f0^2*f4*f5*f6*f7^2 -
128*f0^2*f5^3*f6*f8 + 32*f0^2*f5^3*f7^2 - 64*f0*f1^2*f3*f8^3 +
128*f0*f1^2*f4*f7*f8^2 - 48*f0*f1^2*f5*f7^2*f8 - 64*f0*f1^2*f6^2*f7*f8 +
16*f0*f1^2*f6*f7^3 + 512*f0*f1*f2^2*f8^3 - 320*f0*f1*f2*f3*f7*f8^2 +
256*f0*f1*f2*f4*f6*f8^2 + 64*f0*f1*f2*f4*f7^2*f8 + 512*f0*f1*f2*f5^2*f8^2 -
768*f0*f1*f2*f5*f6*f7*f8 + 128*f0*f1*f2*f5*f7^3 + 512*f0*f1*f2*f6^3*f8 -
128*f0*f1*f2*f6^2*f7^2 + 64*f0*f1*f3^2*f6*f8^2 - 32*f0*f1*f3^2*f7^2*f8 -
256*f0*f1*f3*f4*f5*f8^2 + 128*f0*f1*f3*f4*f6*f7*f8 - 32*f0*f1*f3*f4*f7^3 +
16*f0*f1*f3*f5^2*f7*f8 - 128*f0*f1*f3*f5*f6^2*f8 + 32*f0*f1*f3*f5*f6*f7^2 +
256*f0*f2^2*f3*f6*f8^2 - 64*f0*f2^2*f3*f7^2*f8 - 128*f0*f2*f3^2*f5*f8^2 +
256*f0*f2*f3*f4^2*f8^2 - 128*f0*f2*f3*f4*f5*f7*f8 + 256*f0*f2*f3*f4*f6^2*f8 -
64*f0*f2*f3*f4*f6*f7^2 - 64*f0*f2*f3*f5^2*f6*f8 + 16*f0*f2*f3*f5^2*f7^2 -
64*f0*f3^3*f4*f8^2 + 32*f0*f3^3*f5*f7*f8 - 64*f0*f3^3*f6^2*f8 +
16*f0*f3^3*f6*f7^2 - 128*f1^3*f2*f8^3 + 32*f1^3*f3*f7*f8^2 - 32*f1^3*f4*f7^2*f8
- 160*f1^3*f5^2*f8^2 + 192*f1^3*f5*f6*f7*f8 - 32*f1^3*f5*f7^3 - 128*f1^3*f6^3*f8
+ 32*f1^3*f6^2*f7^2 - 128*f1^2*f2*f3*f6*f8^2 + 32*f1^2*f2*f3*f7^2*f8 +
32*f1^2*f3^2*f5*f8^2 - 16*f1^2*f3^2*f6*f7*f8 + 4*f1^2*f3^2*f7^3 -
64*f1^2*f3*f4^2*f8^2 + 32*f1^2*f3*f4*f5*f7*f8 - 64*f1^2*f3*f4*f6^2*f8 +
16*f1^2*f3*f4*f6*f7^2 + 16*f1^2*f3*f5^2*f6*f8 - 4*f1^2*f3*f5^2*f7^2)*x[1]^3*x[6]
+ (-512*f0^3*f6*f8^3 + 128*f0^3*f7^2*f8^2 + 512*f0^2*f1*f5*f8^3 -
384*f0^2*f1*f6*f7*f8^2 + 96*f0^2*f1*f7^3*f8 - 512*f0^2*f2*f4*f8^3 +
384*f0^2*f2*f5*f7*f8^2 - 1024*f0^2*f2*f6^2*f8^2 + 64*f0^2*f2*f7^4 -
384*f0^2*f3^2*f8^3 + 256*f0^2*f3*f4*f7*f8^2 - 32*f0^2*f3*f5*f7^2*f8 +
256*f0^2*f3*f6^2*f7*f8 - 64*f0^2*f3*f6*f7^3 - 512*f0^2*f4^2*f6*f8^2 +
128*f0^2*f4*f5*f6*f7*f8 + 32*f0^2*f4*f5*f7^3 - 512*f0^2*f4*f6^3*f8 +
128*f0^2*f4*f6^2*f7^2 + 32*f0^2*f5^3*f7*f8 + 128*f0^2*f5^2*f6^2*f8 -
32*f0^2*f5^2*f6*f7^2 - 256*f0*f1^2*f4*f8^3 + 32*f0*f1^2*f5*f7*f8^2 +
128*f0*f1^2*f6^2*f8^2 + 32*f0*f1^2*f6*f7^2*f8 - 16*f0*f1^2*f7^4 +
768*f0*f1*f2*f3*f8^3 - 256*f0*f1*f2*f4*f7*f8^2 + 384*f0*f1*f2*f5*f6*f8^2 +
32*f0*f1*f2*f5*f7^2*f8 - 256*f0*f1*f2*f6^2*f7*f8 + 64*f0*f1*f2*f6*f7^3 -
64*f0*f1*f3^2*f7*f8^2 + 64*f0*f1*f3*f4*f7^2*f8 + 192*f0*f1*f3*f5^2*f8^2 -
224*f0*f1*f3*f5*f6*f7*f8 + 24*f0*f1*f3*f5*f7^3 + 256*f0*f1*f3*f6^3*f8 -
64*f0*f1*f3*f6^2*f7^2 - 512*f0*f2^3*f8^3 + 256*f0*f2^2*f3*f7*f8^2 -
1024*f0*f2^2*f4*f6*f8^2 + 128*f0*f2^2*f4*f7^2*f8 - 384*f0*f2^2*f5^2*f8^2 +
768*f0*f2^2*f5*f6*f7*f8 - 128*f0*f2^2*f5*f7^3 - 512*f0*f2^2*f6^3*f8 +
128*f0*f2^2*f6^2*f7^2 + 128*f0*f2*f3^2*f6*f8^2 - 32*f0*f2*f3^2*f7^2*f8 +
768*f0*f2*f3*f4*f5*f8^2 - 256*f0*f2*f3*f4*f6*f7*f8 + 64*f0*f2*f3*f4*f7^3 -
128*f0*f2*f3*f5^2*f7*f8 + 256*f0*f2*f3*f5*f6^2*f8 - 64*f0*f2*f3*f5*f6*f7^2 -
512*f0*f2*f4^3*f8^2 + 256*f0*f2*f4^2*f5*f7*f8 - 512*f0*f2*f4^2*f6^2*f8 +
128*f0*f2*f4^2*f6*f7^2 + 128*f0*f2*f4*f5^2*f6*f8 - 32*f0*f2*f4*f5^2*f7^2 -
128*f0*f3^3*f5*f8^2 + 64*f0*f3^3*f6*f7*f8 - 16*f0*f3^3*f7^3 +
128*f0*f3^2*f4^2*f8^2 - 64*f0*f3^2*f4*f5*f7*f8 + 128*f0*f3^2*f4*f6^2*f8 -
32*f0*f3^2*f4*f6*f7^2 - 32*f0*f3^2*f5^2*f6*f8 + 8*f0*f3^2*f5^2*f7^2 -
64*f1^3*f3*f8^3 + 64*f1^3*f4*f7*f8^2 - 64*f1^3*f5*f6*f8^2 - 16*f1^3*f5*f7^2*f8 +
64*f1^3*f6^2*f7*f8 - 16*f1^3*f6*f7^3 + 128*f1^2*f2^2*f8^3 -
64*f1^2*f2*f3*f7*f8^2 + 256*f1^2*f2*f4*f6*f8^2 - 32*f1^2*f2*f4*f7^2*f8 +
96*f1^2*f2*f5^2*f8^2 - 192*f1^2*f2*f5*f6*f7*f8 + 32*f1^2*f2*f5*f7^3 +
128*f1^2*f2*f6^3*f8 - 32*f1^2*f2*f6^2*f7^2 + 64*f1^2*f3^2*f6*f8^2 -
16*f1^2*f3^2*f7^2*f8 - 192*f1^2*f3*f4*f5*f8^2 + 64*f1^2*f3*f4*f6*f7*f8 -
16*f1^2*f3*f4*f7^3 + 32*f1^2*f3*f5^2*f7*f8 - 64*f1^2*f3*f5*f6^2*f8 +
16*f1^2*f3*f5*f6*f7^2 + 128*f1^2*f4^3*f8^2 - 64*f1^2*f4^2*f5*f7*f8 +
128*f1^2*f4^2*f6^2*f8 - 32*f1^2*f4^2*f6*f7^2 - 32*f1^2*f4*f5^2*f6*f8 +
8*f1^2*f4*f5^2*f7^2)*x[1]^3*x[7] + (256*f0^2*f2*f6*f8^2 - 256*f0^2*f3*f5*f8^2 +
192*f0^2*f3*f6*f7*f8 - 64*f0^2*f3*f7^3 + 256*f0^2*f4^2*f8^2 -
64*f0^2*f4*f5*f7*f8 + 256*f0^2*f4*f6^2*f8 - 64*f0^2*f4*f6*f7^2 -
64*f0^2*f5^2*f6*f8 - 16*f0*f1^2*f7^2*f8 + 192*f0*f1*f2*f5*f8^2 -
128*f0*f1*f2*f6*f7*f8 + 32*f0*f1*f2*f7^3 - 64*f0*f1*f3*f4*f8^2 -
128*f0*f1*f3*f6^2*f8 + 32*f0*f1*f3*f6*f7^2 + 256*f0*f2^2*f4*f8^2 -
128*f0*f2^2*f5*f7*f8 + 256*f0*f2^2*f6^2*f8 - 64*f0*f2^2*f6*f7^2 -
64*f0*f2*f3^2*f8^2 - 128*f0*f2*f3*f5*f6*f8 + 32*f0*f2*f3*f5*f7^2 +
256*f0*f2*f4^2*f6*f8 - 64*f0*f2*f4^2*f7^2 - 64*f0*f2*f4*f5^2*f8 -
64*f0*f3^2*f4*f6*f8 + 16*f0*f3^2*f4*f7^2 + 16*f0*f3^2*f5^2*f8 - 64*f1^3*f5*f8^2
+ 32*f1^3*f6*f7*f8 - 8*f1^3*f7^3 - 64*f1^2*f2*f4*f8^2 + 32*f1^2*f2*f5*f7*f8 -
64*f1^2*f2*f6^2*f8 + 16*f1^2*f2*f6*f7^2 + 32*f1^2*f3*f5*f6*f8 -
8*f1^2*f3*f5*f7^2 - 64*f1^2*f4^2*f6*f8 + 16*f1^2*f4^2*f7^2 +
16*f1^2*f4*f5^2*f8)*x[1]^3*x[8] + (128*f0^3*f4*f8^2 - 128*f0^3*f5*f7*f8 +
256*f0^3*f6^2*f8 - 128*f0^3*f6*f7^2 - 160*f0^2*f1*f3*f8^2 + 32*f0^2*f1*f4*f7*f8
- 192*f0^2*f1*f5*f6*f8 + 32*f0^2*f1*f5*f7^2 + 256*f0^2*f2^2*f8^2 -
64*f0^2*f2*f3*f7*f8 + 384*f0^2*f2*f4*f6*f8 - 64*f0^2*f2*f4*f7^2 -
96*f0^2*f2*f5*f6*f7 + 192*f0^2*f3^2*f6*f8 - 48*f0^2*f3^2*f7^2 -
224*f0^2*f3*f4*f5*f8 + 32*f0^2*f3*f5^2*f7 + 128*f0^2*f4^3*f8 -
32*f0^2*f4^2*f5*f7 + 64*f0*f1^2*f2*f8^2 - 16*f0*f1^2*f3*f7*f8 -
32*f0*f1^2*f4*f6*f8 + 24*f0*f1^2*f5*f6*f7 + 32*f0*f1*f2^2*f7*f8 -
448*f0*f1*f2*f3*f6*f8 + 80*f0*f1*f2*f3*f7^2 + 64*f0*f1*f2*f4*f5*f8 -
16*f0*f1*f2*f5^2*f7 + 48*f0*f1*f3^2*f5*f8 - 64*f0*f1*f3*f4^2*f8 +
16*f0*f1*f3*f4*f5*f7 + 256*f0*f2^3*f6*f8 - 64*f0*f2^3*f7^2 - 96*f0*f2^2*f3*f5*f8
+ 128*f0*f2^2*f4^2*f8 - 32*f0*f2^2*f4*f5*f7 - 32*f0*f2*f3^2*f4*f8 +
8*f0*f2*f3^2*f5*f7 - 32*f1^4*f8^2 - 8*f1^3*f2*f7*f8 + 80*f1^3*f3*f6*f8 -
12*f1^3*f3*f7^2 - 16*f1^3*f4*f5*f8 + 4*f1^3*f5^2*f7 - 64*f1^2*f2^2*f6*f8 +
16*f1^2*f2^2*f7^2 + 24*f1^2*f2*f3*f5*f8 - 32*f1^2*f2*f4^2*f8 +
8*f1^2*f2*f4*f5*f7 + 8*f1^2*f3^2*f4*f8 - 2*f1^2*f3^2*f5*f7)*x[1]^2*x[2]^2 +
(384*f0^3*f5*f8^2 - 384*f0^3*f6*f7*f8 + 64*f0^3*f7^3 - 32*f0^2*f1*f5*f7*f8 +
128*f0^2*f1*f6^2*f8 + 64*f0^2*f1*f6*f7^2 - 256*f0^2*f2*f5*f6*f8 -
64*f0^2*f2*f5*f7^2 + 128*f0^2*f2*f6^2*f7 - 128*f0^2*f3^2*f7*f8 -
384*f0^2*f3*f4*f6*f8 + 192*f0^2*f3*f4*f7^2 + 224*f0^2*f3*f5^2*f8 -
128*f0^2*f4^2*f5*f8 + 32*f0^2*f4*f5^2*f7 + 96*f0*f1^2*f5*f6*f8 +
16*f0*f1^2*f5*f7^2 - 32*f0*f1^2*f6^2*f7 - 128*f0*f1*f2^2*f8^2 +
128*f0*f1*f2*f3*f7*f8 + 256*f0*f1*f2*f4*f6*f8 - 96*f0*f1*f2*f4*f7^2 -
96*f0*f1*f2*f5^2*f8 + 32*f0*f1*f2*f5*f6*f7 + 128*f0*f1*f3^2*f6*f8 -
24*f0*f1*f3^2*f7^2 + 64*f0*f1*f3*f4*f5*f8 - 16*f0*f1*f3*f5^2*f7 -
128*f0*f2^3*f7*f8 - 128*f0*f2^2*f3*f6*f8 + 64*f0*f2^2*f3*f7^2 -
128*f0*f2^2*f4*f5*f8 + 32*f0*f2^2*f5^2*f7 + 64*f0*f2*f3^2*f5*f8 +
32*f1^3*f2*f8^2 - 8*f1^3*f3*f7*f8 - 64*f1^3*f4*f6*f8 + 24*f1^3*f4*f7^2 +
24*f1^3*f5^2*f8 - 8*f1^3*f5*f6*f7 + 32*f1^2*f2^2*f7*f8 + 32*f1^2*f2*f3*f6*f8 -
16*f1^2*f2*f3*f7^2 + 32*f1^2*f2*f4*f5*f8 - 8*f1^2*f2*f5^2*f7 -
16*f1^2*f3^2*f5*f8)*x[1]^2*x[2]*x[3] + (-256*f0^3*f6*f8^2 + 192*f0^3*f7^2*f8 +
192*f0^2*f1*f6*f7*f8 - 32*f0^2*f1*f7^3 + 256*f0^2*f2*f4*f8^2 -
128*f0^2*f2*f5*f7*f8 + 256*f0^2*f2*f6^2*f8 + 64*f0^2*f2*f6*f7^2 -
192*f0^2*f3^2*f8^2 + 256*f0^2*f3*f4*f7*f8 - 320*f0^2*f3*f5*f6*f8 +
96*f0^2*f3*f5*f7^2 - 64*f0^2*f3*f6^2*f7 + 512*f0^2*f4^2*f6*f8 -
192*f0^2*f4^2*f7^2 - 64*f0^2*f4*f5^2*f8 + 64*f0^2*f4*f5*f6*f7 - 32*f0^2*f5^3*f7
- 64*f0*f1^2*f4*f8^2 + 64*f0*f1^2*f5*f7*f8 - 128*f0*f1^2*f6^2*f8 -
48*f0*f1^2*f6*f7^2 + 192*f0*f1*f2*f3*f8^2 - 64*f0*f1*f2*f4*f7*f8 +
320*f0*f1*f2*f5*f6*f8 - 64*f0*f1*f2*f5*f7^2 - 16*f0*f1*f3^2*f7*f8 -
192*f0*f1*f3*f4*f6*f8 + 32*f0*f1*f3*f4*f7^2 - 16*f0*f1*f3*f5^2*f8 -
32*f0*f1*f3*f5*f6*f7 + 64*f0*f2^2*f3*f7*f8 + 64*f0*f2*f3^2*f6*f8 -
32*f0*f2*f3^2*f7^2 + 64*f0*f2*f3*f4*f5*f8 - 16*f0*f2*f3*f5^2*f7 -
32*f0*f3^3*f5*f8 - 32*f1^3*f3*f8^2 - 96*f1^3*f5*f6*f8 + 16*f1^3*f5*f7^2 -
32*f1^2*f2*f3*f7*f8 - 32*f1^2*f3^2*f6*f8 + 4*f1^2*f3^2*f7^2 -
16*f1^2*f3*f4*f5*f8 + 4*f1^2*f3*f5^2*f7)*x[1]^2*x[2]*x[4] + (512*f0^3*f6*f8^2 +
64*f0^3*f7^2*f8 - 64*f0^2*f1*f6*f7*f8 - 32*f0^2*f1*f7^3 + 768*f0^2*f2*f4*f8^2 +
768*f0^2*f2*f6^2*f8 - 256*f0^2*f2*f6*f7^2 - 64*f0^2*f3^2*f8^2 -
128*f0^2*f3*f4*f7*f8 - 384*f0^2*f3*f5*f6*f8 + 64*f0^2*f3*f5*f7^2 +
768*f0^2*f4^2*f6*f8 - 192*f0^2*f4^2*f7^2 - 192*f0^2*f4*f5^2*f8 -
64*f0*f1^2*f4*f8^2 - 48*f0*f1^2*f5*f7*f8 - 192*f0*f1^2*f6^2*f8 +
64*f0*f1^2*f6*f7^2 + 64*f0*f1*f2*f4*f7*f8 - 16*f0*f1*f2*f5*f7^2 -
16*f0*f1*f3^2*f7*f8 - 384*f0*f1*f3*f4*f6*f8 + 96*f0*f1*f3*f4*f7^2 +
96*f0*f1*f3*f5^2*f8 + 256*f0*f2^3*f8^2 - 64*f0*f2^2*f3*f7*f8 +
768*f0*f2^2*f4*f6*f8 - 192*f0*f2^2*f4*f7^2 - 192*f0*f2^2*f5^2*f8 -
192*f0*f2*f3^2*f6*f8 + 48*f0*f2*f3^2*f7^2 - 64*f1^3*f3*f8^2 - 16*f1^3*f4*f7*f8 +
4*f1^3*f5*f7^2 - 64*f1^2*f2^2*f8^2 + 16*f1^2*f2*f3*f7*f8 - 192*f1^2*f2*f4*f6*f8
+ 48*f1^2*f2*f4*f7^2 + 48*f1^2*f2*f5^2*f8 + 48*f1^2*f3^2*f6*f8 -
12*f1^2*f3^2*f7^2)*x[1]^2*x[2]*x[5] + (-384*f0^3*f7*f8^2 - 512*f0^2*f1*f6*f8^2 +
64*f0^2*f1*f7^2*f8 + 384*f0^2*f2*f5*f8^2 - 512*f0^2*f2*f6*f7*f8 +
64*f0^2*f2*f7^3 - 448*f0^2*f3*f5*f7*f8 + 768*f0^2*f3*f6^2*f8 -
160*f0^2*f3*f6*f7^2 + 128*f0^2*f4^2*f7*f8 - 768*f0^2*f4*f5*f6*f8 +
160*f0^2*f4*f5*f7^2 + 192*f0^2*f5^3*f8 - 128*f0*f1^2*f5*f8^2 +
160*f0*f1^2*f6*f7*f8 - 384*f0*f1*f2*f4*f8^2 + 288*f0*f1*f2*f5*f7*f8 -
768*f0*f1*f2*f6^2*f8 + 192*f0*f1*f2*f6*f7^2 - 64*f0*f1*f3^2*f8^2 +
192*f0*f1*f3*f5*f6*f8 - 16*f0*f1*f3*f5*f7^2 - 128*f0*f2^2*f3*f8^2 +
32*f0*f2*f3^2*f7*f8 - 384*f0*f2*f3*f4*f6*f8 + 96*f0*f2*f3*f4*f7^2 +
96*f0*f2*f3*f5^2*f8 + 96*f0*f3^3*f6*f8 - 24*f0*f3^3*f7^2 + 64*f1^3*f4*f8^2 -
48*f1^3*f5*f7*f8 + 192*f1^3*f6^2*f8 - 48*f1^3*f6*f7^2 + 96*f1^2*f2*f3*f8^2 +
8*f1^2*f3^2*f7*f8 + 96*f1^2*f3*f4*f6*f8 - 24*f1^2*f3*f4*f7^2 -
24*f1^2*f3*f5^2*f8)*x[1]^2*x[2]*x[6] + (256*f0^3*f8^3 + 192*f0^2*f1*f7*f8^2 +
1024*f0^2*f2*f6*f8^2 + 192*f0^2*f3*f5*f8^2 - 384*f0^2*f3*f6*f7*f8 +
64*f0^2*f3*f7^3 + 128*f0^2*f4*f5*f7*f8 + 768*f0^2*f4*f6^2*f8 -
192*f0^2*f4*f6*f7^2 - 192*f0^2*f5^2*f6*f8 - 32*f0^2*f5^2*f7^2 -
96*f0*f1^2*f7^2*f8 - 384*f0*f1*f2*f5*f8^2 + 384*f0*f1*f2*f6*f7*f8 -
96*f0*f1*f2*f7^3 + 128*f0*f1*f3*f4*f8^2 - 384*f0*f1*f3*f6^2*f8 +
96*f0*f1*f3*f6*f7^2 + 768*f0*f2^2*f4*f8^2 - 384*f0*f2^2*f5*f7*f8 +
768*f0*f2^2*f6^2*f8 - 192*f0*f2^2*f6*f7^2 - 192*f0*f2*f3^2*f8^2 -
384*f0*f2*f3*f5*f6*f8 + 96*f0*f2*f3*f5*f7^2 + 768*f0*f2*f4^2*f6*f8 -
192*f0*f2*f4^2*f7^2 - 192*f0*f2*f4*f5^2*f8 - 192*f0*f3^2*f4*f6*f8 +
48*f0*f3^2*f4*f7^2 + 48*f0*f3^2*f5^2*f8 + 64*f1^3*f5*f8^2 - 96*f1^3*f6*f7*f8 +
24*f1^3*f7^3 - 192*f1^2*f2*f4*f8^2 + 96*f1^2*f2*f5*f7*f8 - 192*f1^2*f2*f6^2*f8 +
48*f1^2*f2*f6*f7^2 - 32*f1^2*f3^2*f8^2 + 96*f1^2*f3*f5*f6*f8 -
24*f1^2*f3*f5*f7^2 - 192*f1^2*f4^2*f6*f8 + 48*f1^2*f4^2*f7^2 +
48*f1^2*f4*f5^2*f8)*x[1]^2*x[2]*x[7] + (-128*f0^2*f2*f8^2 - 64*f0^2*f3*f7*f8 -
384*f0^2*f4*f6*f8 + 96*f0^2*f4*f7^2 + 96*f0^2*f5^2*f8 + 32*f0^2*f5*f6*f7 -
32*f0*f1^2*f8^2 + 224*f0*f1*f3*f6*f8 - 24*f0*f1*f3*f7^2 - 256*f0*f2^2*f6*f8 +
64*f0*f2^2*f7^2 + 96*f0*f2*f3*f5*f8 - 128*f0*f2*f4^2*f8 + 32*f0*f2*f4*f5*f7 +
32*f0*f3^2*f4*f8 - 8*f0*f3^2*f5*f7 + 8*f1^3*f7*f8 + 64*f1^2*f2*f6*f8 -
16*f1^2*f2*f7^2 - 24*f1^2*f3*f5*f8 + 32*f1^2*f4^2*f8 -
8*f1^2*f4*f5*f7)*x[1]^2*x[2]*x[8] + (128*f0^3*f6*f8^2 - 256*f0^2*f1*f5*f8^2 +
32*f0^2*f1*f6*f7*f8 - 256*f0^2*f2*f4*f8^2 + 32*f0^2*f2*f5*f7*f8 -
256*f0^2*f2*f6^2*f8 + 64*f0^2*f2*f6*f7^2 + 256*f0^2*f3^2*f8^2 -
64*f0^2*f3*f4*f7*f8 + 160*f0^2*f3*f5*f6*f8 + 48*f0^2*f3*f5*f7^2 -
64*f0^2*f3*f6^2*f7 - 128*f0^2*f4^2*f6*f8 + 64*f0^2*f4*f5^2*f8 -
32*f0^2*f4*f5*f6*f7 + 64*f0*f1^2*f4*f8^2 + 72*f0*f1^2*f5*f7*f8 -
32*f0*f1^2*f6*f7^2 - 288*f0*f1*f2*f3*f8^2 + 32*f0*f1*f2*f4*f7*f8 -
16*f0*f1*f2*f5*f7^2 + 32*f0*f1*f3^2*f7*f8 + 64*f0*f1*f3*f4*f6*f8 -
48*f0*f1*f3*f4*f7^2 - 56*f0*f1*f3*f5^2*f8 + 16*f0*f1*f3*f5*f6*f7 +
128*f0*f2^3*f8^2 - 384*f0*f2^2*f4*f6*f8 + 128*f0*f2^2*f4*f7^2 +
160*f0*f2^2*f5^2*f8 - 32*f0*f2^2*f5*f6*f7 + 128*f0*f2*f3^2*f6*f8 -
48*f0*f2*f3^2*f7^2 - 32*f0*f2*f3*f4*f5*f8 + 64*f1^3*f3*f8^2 - 24*f1^3*f4*f7*f8 +
4*f1^3*f5*f7^2 - 32*f1^2*f2^2*f8^2 + 96*f1^2*f2*f4*f6*f8 - 32*f1^2*f2*f4*f7^2 -
40*f1^2*f2*f5^2*f8 + 8*f1^2*f2*f5*f6*f7 - 32*f1^2*f3^2*f6*f8 + 12*f1^2*f3^2*f7^2
+ 8*f1^2*f3*f4*f5*f8)*x[1]^2*x[3]^2 + (128*f0^2*f1*f6*f8^2 - 96*f0^2*f1*f7^2*f8
- 640*f0^2*f2*f5*f8^2 + 640*f0^2*f2*f6*f7*f8 - 192*f0^2*f2*f7^3 -
256*f0^2*f3*f4*f8^2 + 320*f0^2*f3*f5*f7*f8 - 384*f0^2*f3*f6^2*f8 +
384*f0^2*f4*f5*f6*f8 - 224*f0^2*f4*f5*f7^2 + 128*f0^2*f4*f6^2*f7 -
160*f0^2*f5^3*f8 + 320*f0*f1^2*f5*f8^2 - 224*f0*f1^2*f6*f7*f8 + 48*f0*f1^2*f7^3
+ 512*f0*f1*f2*f4*f8^2 - 288*f0*f1*f2*f5*f7*f8 + 256*f0*f1*f2*f6^2*f8 -
96*f0*f1*f3*f4*f7*f8 - 96*f0*f1*f3*f5*f6*f8 - 24*f0*f1*f3*f5*f7^2 +
32*f0*f1*f3*f6^2*f7 - 128*f0*f1*f4^2*f6*f8 + 128*f0*f1*f4^2*f7^2 +
64*f0*f1*f4*f5^2*f8 - 128*f0*f2^2*f3*f8^2 + 384*f0*f2*f3*f4*f6*f8 -
128*f0*f2*f3*f4*f7^2 - 160*f0*f2*f3*f5^2*f8 + 32*f0*f2*f3*f5*f6*f7 -
128*f0*f3^3*f6*f8 + 48*f0*f3^3*f7^2 + 32*f0*f3^2*f4*f5*f8 - 128*f1^3*f4*f8^2 +
16*f1^3*f6*f7^2 + 32*f1^2*f2*f3*f8^2 + 64*f1^2*f2*f4*f7*f8 - 16*f1^2*f3^2*f7*f8
+ 16*f1^2*f3*f4*f7^2 + 24*f1^2*f3*f5^2*f8 - 8*f1^2*f3*f5*f6*f7)*x[1]^2*x[3]*x[4]
+ (-256*f0^3*f7*f8^2 - 64*f0^2*f1*f7^2*f8 + 128*f0^2*f2*f5*f8^2 -
384*f0^2*f2*f6*f7*f8 + 64*f0^2*f2*f7^3 - 256*f0^2*f3*f4*f8^2 +
64*f0^2*f3*f6*f7^2 - 256*f0^2*f4*f5*f6*f8 + 128*f0^2*f4*f5*f7^2 +
64*f0^2*f5^3*f8 - 160*f0*f1^2*f5*f8^2 + 160*f0*f1^2*f6*f7*f8 +
32*f0*f1*f2*f5*f7*f8 + 32*f0*f1*f3^2*f8^2 + 128*f0*f1*f3*f4*f7*f8 +
96*f0*f1*f3*f5*f6*f8 - 40*f0*f1*f3*f5*f7^2 - 128*f0*f2^2*f3*f8^2 -
128*f0*f2^2*f4*f7*f8 - 128*f0*f2^2*f5*f6*f8 + 64*f0*f2^2*f5*f7^2 +
64*f0*f2*f3^2*f7*f8 + 32*f0*f2*f3*f5^2*f8 + 32*f1^3*f4*f8^2 + 32*f1^2*f2*f3*f8^2
+ 32*f1^2*f2*f4*f7*f8 + 32*f1^2*f2*f5*f6*f8 - 16*f1^2*f2*f5*f7^2 -
16*f1^2*f3^2*f7*f8 - 8*f1^2*f3*f5^2*f8)*x[1]^2*x[3]*x[5] + (256*f0^3*f8^3 +
256*f0^2*f1*f7*f8^2 + 64*f0^2*f2*f7^2*f8 + 704*f0^2*f3*f5*f8^2 -
640*f0^2*f3*f6*f7*f8 + 224*f0^2*f3*f7^3 - 512*f0^2*f4^2*f8^2 +
384*f0^2*f4*f5*f7*f8 - 64*f0^2*f4*f6*f7^2 + 64*f0^2*f5^2*f6*f8 -
32*f0^2*f5^2*f7^2 + 64*f0*f1^2*f6*f8^2 - 16*f0*f1^2*f7^2*f8 -
640*f0*f1*f2*f5*f8^2 + 640*f0*f1*f2*f6*f7*f8 - 192*f0*f1*f2*f7^3 +
384*f0*f1*f3*f4*f8^2 + 16*f0*f1*f3*f5*f7*f8 - 16*f0*f1*f3*f6*f7^2 -
128*f0*f1*f4^2*f7*f8 + 64*f0*f1*f4*f5*f6*f8 - 32*f0*f1*f4*f5*f7^2 -
32*f0*f1*f5^3*f8 + 64*f0*f2*f3^2*f8^2 + 64*f0*f2*f3*f4*f7*f8 +
64*f0*f2*f3*f5*f6*f8 - 32*f0*f2*f3*f5*f7^2 - 32*f0*f3^3*f7*f8 -
16*f0*f3^2*f5^2*f8 + 224*f1^3*f5*f8^2 - 192*f1^3*f6*f7*f8 + 40*f1^3*f7^3 -
64*f1^2*f2*f4*f8^2 - 16*f1^2*f2*f5*f7*f8 - 32*f1^2*f3^2*f8^2 -
32*f1^2*f3*f4*f7*f8 - 32*f1^2*f3*f5*f6*f8 + 12*f1^2*f3*f5*f7^2)*x[1]^2*x[3]*x[6]
+ (-384*f0^2*f1*f8^3 - 512*f0^2*f2*f7*f8^2 + 384*f0^2*f3*f6*f8^2 -
128*f0^2*f3*f7^2*f8 - 384*f0^2*f4*f6*f7*f8 + 64*f0^2*f4*f7^3 -
64*f0^2*f5^2*f7*f8 - 128*f0^2*f5*f6^2*f8 + 96*f0^2*f5*f6*f7^2 +
64*f0*f1^2*f7*f8^2 - 512*f0*f1*f2*f6*f8^2 + 160*f0*f1*f2*f7^2*f8 -
448*f0*f1*f3*f5*f8^2 + 288*f0*f1*f3*f6*f7*f8 - 48*f0*f1*f3*f7^3 +
128*f0*f1*f4^2*f8^2 + 32*f0*f1*f5^2*f6*f8 + 8*f0*f1*f5^2*f7^2 +
768*f0*f2^2*f5*f8^2 - 768*f0*f2^2*f6*f7*f8 + 192*f0*f2^2*f7^3 -
768*f0*f2*f3*f4*f8^2 + 192*f0*f2*f3*f5*f7*f8 - 384*f0*f2*f4*f5*f6*f8 +
96*f0*f2*f4*f5*f7^2 + 96*f0*f2*f5^3*f8 + 192*f0*f3^3*f8^2 + 96*f0*f3^2*f5*f6*f8
- 24*f0*f3^2*f5*f7^2 + 64*f1^3*f6*f8^2 - 160*f1^2*f2*f5*f8^2 +
192*f1^2*f2*f6*f7*f8 - 48*f1^2*f2*f7^3 + 160*f1^2*f3*f4*f8^2 -
16*f1^2*f3*f5*f7*f8 + 96*f1^2*f4*f5*f6*f8 - 24*f1^2*f4*f5*f7^2 -
24*f1^2*f5^3*f8)*x[1]^2*x[3]*x[7] + (128*f0^2*f3*f8^2 + 64*f0^2*f5*f6*f8 +
64*f0^2*f5*f7^2 - 64*f0^2*f6^2*f7 - 64*f0*f1*f2*f8^2 + 48*f0*f1*f3*f7*f8 -
48*f0*f1*f4*f7^2 - 16*f0*f1*f5^2*f8 + 64*f0*f2^2*f7*f8 + 64*f0*f2*f3*f6*f8 -
32*f0*f2*f3*f7^2 + 64*f0*f2*f4*f5*f8 - 16*f0*f2*f5^2*f7 - 32*f0*f3^2*f5*f8 +
32*f1^3*f8^2 - 32*f1^2*f2*f7*f8 - 48*f1^2*f3*f6*f8 + 12*f1^2*f3*f7^2 -
16*f1^2*f4*f5*f8 + 4*f1^2*f5^2*f7)*x[1]^2*x[3]*x[8] + (128*f0^3*f8^3 -
128*f0^2*f1*f7*f8^2 - 256*f0^2*f2*f6*f8^2 - 192*f0^2*f3*f5*f8^2 +
512*f0^2*f3*f6*f7*f8 - 160*f0^2*f3*f7^3 + 384*f0^2*f4^2*f8^2 -
352*f0^2*f4*f5*f7*f8 - 384*f0^2*f4*f6^2*f8 + 128*f0^2*f4*f6*f7^2 +
160*f0^2*f5^2*f6*f8 + 48*f0^2*f5^2*f7^2 - 32*f0^2*f5*f6^2*f7 +
48*f0*f1^2*f7^2*f8 + 512*f0*f1*f2*f5*f8^2 - 672*f0*f1*f2*f6*f7*f8 +
192*f0*f1*f2*f7^3 - 352*f0*f1*f3*f4*f8^2 - 48*f0*f1*f3*f5*f7*f8 +
256*f0*f1*f3*f6^2*f8 + 96*f0*f1*f4^2*f7*f8 - 64*f0*f1*f4*f5*f6*f8 +
32*f0*f1*f4*f5*f7^2 - 64*f0*f1*f4*f6^2*f7 + 16*f0*f1*f5^3*f8 +
16*f0*f1*f5^2*f6*f7 - 384*f0*f2^2*f4*f8^2 + 256*f0*f2^2*f5*f7*f8 -
256*f0*f2^2*f6^2*f8 + 160*f0*f2*f3^2*f8^2 - 64*f0*f2*f3*f4*f7*f8 +
96*f0*f2*f3*f5*f6*f8 - 512*f0*f2*f4^2*f6*f8 + 128*f0*f2*f4^2*f7^2 +
160*f0*f2*f4*f5^2*f8 - 64*f0*f2*f4*f5*f6*f7 + 16*f0*f2*f5^3*f7 +
16*f0*f3^3*f7*f8 + 160*f0*f3^2*f4*f6*f8 - 48*f0*f3^2*f4*f7^2 + 8*f0*f3^2*f5^2*f8
+ 8*f0*f3^2*f5*f6*f7 - 32*f0*f3*f4^2*f5*f8 - 160*f1^3*f5*f8^2 +
192*f1^3*f6*f7*f8 - 48*f1^3*f7^3 + 128*f1^2*f2*f4*f8^2 - 16*f1^2*f2*f6*f7^2 +
48*f1^2*f3^2*f8^2 + 32*f1^2*f3*f4*f7*f8 + 8*f1^2*f3*f5*f7^2 +
128*f1^2*f4^2*f6*f8 - 64*f1^2*f4^2*f7^2 - 48*f1^2*f4*f5^2*f8 +
16*f1^2*f4*f5*f6*f7 - 4*f1^2*f5^3*f7 - 32*f1*f2^2*f3*f8^2 - 64*f1*f2^2*f4*f7*f8
+ 16*f1*f2*f3^2*f7*f8 - 64*f1*f2*f3*f4*f6*f8 + 16*f1*f2*f3*f4*f7^2 +
8*f1*f2*f3*f5^2*f8 + 16*f1*f3^3*f6*f8 - 4*f1*f3^3*f7^2)*x[1]^2*x[4]^2 +
(64*f0^2*f1*f7*f8^2 - 256*f0^2*f2*f6*f8^2 + 64*f0^2*f2*f7^2*f8 -
256*f0^2*f3*f5*f8^2 + 320*f0^2*f3*f6*f7*f8 - 32*f0^2*f3*f7^3 +
256*f0^2*f4^2*f8^2 + 64*f0^2*f4*f5*f7*f8 - 64*f0^2*f4*f6*f7^2 +
64*f0^2*f5^2*f6*f8 + 64*f0*f1^2*f6*f8^2 + 32*f0*f1^2*f7^2*f8 +
320*f0*f1*f2*f5*f8^2 - 128*f0*f1*f2*f6*f7*f8 + 64*f0*f1*f3*f4*f8^2 +
16*f0*f1*f3*f5*f7*f8 - 16*f0*f1*f3*f6*f7^2 - 128*f0*f1*f4^2*f7*f8 +
64*f0*f1*f4*f5*f6*f8 - 32*f0*f1*f4*f5*f7^2 - 32*f0*f1*f5^3*f8 +
64*f0*f2*f3^2*f8^2 + 64*f0*f2*f3*f4*f7*f8 + 64*f0*f2*f3*f5*f6*f8 -
32*f0*f2*f3*f5*f7^2 - 32*f0*f3^3*f7*f8 - 16*f0*f3^2*f5^2*f8 - 32*f1^3*f5*f8^2 -
8*f1^3*f7^3 - 64*f1^2*f2*f4*f8^2 - 16*f1^2*f2*f5*f7*f8 - 32*f1^2*f3*f4*f7*f8 -
32*f1^2*f3*f5*f6*f8 + 12*f1^2*f3*f5*f7^2)*x[1]^2*x[4]*x[5] +
(128*f0^2*f2*f7*f8^2 - 640*f0^2*f3*f6*f8^2 + 320*f0^2*f3*f7^2*f8 -
256*f0^2*f4*f5*f8^2 + 512*f0^2*f4*f6*f7*f8 - 128*f0^2*f4*f7^3 -
128*f0^2*f5*f6^2*f8 + 32*f0^2*f5*f6*f7^2 - 96*f0*f1^2*f7*f8^2 +
640*f0*f1*f2*f6*f8^2 - 224*f0*f1*f2*f7^2*f8 + 320*f0*f1*f3*f5*f8^2 -
288*f0*f1*f3*f6*f7*f8 - 96*f0*f1*f4*f5*f7*f8 + 64*f0*f1*f4*f6*f7^2 -
16*f0*f1*f5^2*f7^2 - 384*f0*f2^2*f5*f8^2 + 256*f0*f2^2*f6*f7*f8 +
384*f0*f2*f3*f4*f8^2 - 96*f0*f2*f3*f5*f7*f8 - 128*f0*f2*f4^2*f7*f8 +
384*f0*f2*f4*f5*f6*f8 - 128*f0*f2*f5^3*f8 - 160*f0*f3^3*f8^2 +
64*f0*f3^2*f4*f7*f8 - 160*f0*f3^2*f5*f6*f8 + 24*f0*f3^2*f5*f7^2 +
32*f0*f3*f4*f5^2*f8 - 192*f1^3*f6*f8^2 + 48*f1^3*f7^2*f8 + 16*f1^2*f2*f7^3 -
224*f1^2*f3*f4*f8^2 - 24*f1^2*f3*f5*f7*f8 + 128*f1^2*f4^2*f7*f8 -
128*f1^2*f4*f5*f6*f8 + 16*f1^2*f4*f5*f7^2 + 48*f1^2*f5^3*f8 +
128*f1*f2^2*f4*f8^2 + 32*f1*f2^2*f5*f7*f8 + 32*f1*f2*f3*f5*f6*f8 -
8*f1*f2*f3*f5*f7^2)*x[1]^2*x[4]*x[6] + (-256*f0^2*f2*f8^3 + 256*f0^2*f4*f6*f8^2
- 64*f0^2*f4*f7^2*f8 - 192*f0^2*f5^2*f8^2 + 192*f0^2*f5*f6*f7*f8 -
32*f0^2*f5*f7^3 + 192*f0*f1^2*f8^3 + 192*f0*f1*f2*f7*f8^2 - 128*f0*f1*f3*f6*f8^2
+ 64*f0*f1*f3*f7^2*f8 + 256*f0*f1*f4*f5*f8^2 - 64*f0*f1*f4*f6*f7*f8 -
16*f0*f1*f5^2*f7*f8 + 64*f0*f1*f5*f6^2*f8 - 32*f0*f1*f5*f6*f7^2 +
256*f0*f2^2*f6*f8^2 - 128*f0*f2^2*f7^2*f8 - 320*f0*f2*f3*f5*f8^2 +
320*f0*f2*f3*f6*f7*f8 - 96*f0*f2*f3*f7^3 + 512*f0*f2*f4^2*f8^2 -
192*f0*f2*f4*f5*f7*f8 + 64*f0*f2*f5^2*f6*f8 - 32*f0*f2*f5^2*f7^2 -
64*f0*f3^2*f4*f8^2 - 16*f0*f3^2*f5*f7*f8 + 64*f0*f3*f4*f5*f6*f8 -
16*f0*f3*f4*f5*f7^2 - 32*f0*f3*f5^3*f8 - 32*f1^3*f7*f8^2 + 64*f1^2*f2*f6*f8^2 -
48*f1^2*f2*f7^2*f8 + 96*f1^2*f3*f5*f8^2 - 64*f1^2*f3*f6*f7*f8 + 16*f1^2*f3*f7^3
- 192*f1^2*f4^2*f8^2 + 32*f1^2*f4*f5*f7*f8 - 32*f1^2*f5^2*f6*f8 +
4*f1^2*f5^2*f7^2 - 64*f1*f2^2*f5*f8^2 + 64*f1*f2*f3*f4*f8^2 -
32*f1*f2*f3*f5*f7*f8 - 32*f1*f3^3*f8^2 - 16*f1*f3^2*f5*f6*f8 +
4*f1*f3^2*f5*f7^2)*x[1]^2*x[4]*x[7] + (-128*f0^2*f4*f8^2 + 96*f0^2*f5*f7*f8 -
32*f0^2*f6*f7^2 + 96*f0*f1*f3*f8^2 - 32*f0*f1*f4*f7*f8 - 32*f0*f1*f5*f6*f8 -
32*f0*f1*f5*f7^2 + 32*f0*f1*f6^2*f7 - 32*f0*f2*f3*f7*f8 + 384*f0*f2*f4*f6*f8 -
64*f0*f2*f4*f7^2 - 160*f0*f2*f5^2*f8 + 32*f0*f2*f5*f6*f7 - 160*f0*f3^2*f6*f8 +
40*f0*f3^2*f7^2 + 32*f0*f3*f4*f5*f8 - 32*f1^2*f2*f8^2 - 32*f1^2*f3*f7*f8 -
64*f1^2*f4*f6*f8 + 40*f1^2*f4*f7^2 + 40*f1^2*f5^2*f8 - 8*f1^2*f5*f6*f7 +
32*f1*f2^2*f7*f8 + 32*f1*f2*f3*f6*f8 - 8*f1*f2*f3*f7^2)*x[1]^2*x[4]*x[8] +
(128*f0^3*f8^3 + 96*f0^2*f1*f7*f8^2 + 640*f0^2*f2*f6*f8^2 - 96*f0^2*f2*f7^2*f8 -
160*f0^2*f3*f5*f8^2 - 64*f0^2*f3*f6*f7*f8 + 384*f0^2*f4^2*f8^2 -
224*f0^2*f4*f5*f7*f8 + 256*f0^2*f4*f6^2*f8 - 64*f0^2*f4*f6*f7^2 -
64*f0^2*f5^2*f6*f8 + 16*f0^2*f5^2*f7^2 - 96*f0*f1^2*f6*f8^2 - 24*f0*f1^2*f7^2*f8
- 64*f0*f1*f2*f5*f8^2 + 32*f0*f1*f2*f6*f7*f8 - 8*f0*f1*f2*f7^3 -
224*f0*f1*f3*f4*f8^2 + 64*f0*f1*f3*f5*f7*f8 - 96*f0*f1*f3*f6^2*f8 +
24*f0*f1*f3*f6*f7^2 + 256*f0*f2^2*f4*f8^2 - 96*f0*f2^2*f5*f7*f8 +
128*f0*f2^2*f6^2*f8 - 32*f0*f2^2*f6*f7^2 - 64*f0*f2*f3^2*f8^2 -
32*f0*f2*f3*f5*f6*f8 + 8*f0*f2*f3*f5*f7^2 - 8*f1^3*f6*f7*f8 + 2*f1^3*f7^3 -
64*f1^2*f2*f4*f8^2 + 24*f1^2*f2*f5*f7*f8 - 32*f1^2*f2*f6^2*f8 +
8*f1^2*f2*f6*f7^2 + 16*f1^2*f3^2*f8^2 + 8*f1^2*f3*f5*f6*f8 -
2*f1^2*f3*f5*f7^2)*x[1]^2*x[5]^2 + (-256*f0^2*f1*f8^3 + 128*f0^2*f3*f6*f8^2 -
160*f0^2*f3*f7^2*f8 - 256*f0^2*f4*f5*f8^2 + 32*f0^2*f4*f7^3 + 32*f0^2*f5^2*f7*f8
- 128*f0^2*f5*f6^2*f8 + 32*f0^2*f5*f6*f7^2 - 64*f0*f1^2*f7*f8^2 -
384*f0*f1*f2*f6*f8^2 + 160*f0*f1*f2*f7^2*f8 + 32*f0*f1*f3*f6*f7*f8 +
128*f0*f1*f4*f5*f7*f8 - 128*f0*f1*f4*f6^2*f8 + 32*f0*f1*f4*f6*f7^2 +
64*f0*f1*f5^2*f6*f8 - 16*f0*f1*f5^2*f7^2 - 256*f0*f2*f3*f4*f8^2 +
96*f0*f2*f3*f5*f7*f8 - 128*f0*f2*f3*f6^2*f8 + 32*f0*f2*f3*f6*f7^2 +
64*f0*f3^3*f8^2 + 32*f0*f3^2*f5*f6*f8 - 8*f0*f3^2*f5*f7^2 + 64*f1^3*f6*f8^2 +
64*f1^2*f2*f5*f8^2 + 128*f1^2*f3*f4*f8^2 - 40*f1^2*f3*f5*f7*f8 +
64*f1^2*f3*f6^2*f8 - 16*f1^2*f3*f6*f7^2)*x[1]^2*x[5]*x[6] + (512*f0^2*f2*f8^3 +
768*f0^2*f4*f6*f8^2 - 64*f0^2*f4*f7^2*f8 - 64*f0^2*f5^2*f8^2 - 64*f0^2*f5*f7^3 +
256*f0^2*f6^3*f8 - 64*f0^2*f6^2*f7^2 + 64*f0*f1^2*f8^3 - 64*f0*f1*f2*f7*f8^2 -
48*f0*f1*f3*f7^2*f8 - 128*f0*f1*f4*f5*f8^2 + 64*f0*f1*f4*f6*f7*f8 -
16*f0*f1*f4*f7^3 - 16*f0*f1*f5^2*f7*f8 - 64*f0*f1*f5*f6^2*f8 +
16*f0*f1*f5*f6*f7^2 + 768*f0*f2^2*f6*f8^2 - 192*f0*f2^2*f7^2*f8 -
384*f0*f2*f3*f5*f8^2 + 768*f0*f2*f4^2*f8^2 - 384*f0*f2*f4*f5*f7*f8 +
768*f0*f2*f4*f6^2*f8 - 192*f0*f2*f4*f6*f7^2 - 192*f0*f2*f5^2*f6*f8 +
48*f0*f2*f5^2*f7^2 - 192*f0*f3^2*f4*f8^2 + 96*f0*f3^2*f5*f7*f8 -
192*f0*f3^2*f6^2*f8 + 48*f0*f3^2*f6*f7^2 - 32*f1^3*f7*f8^2 - 256*f1^2*f2*f6*f8^2
+ 64*f1^2*f2*f7^2*f8 + 64*f1^2*f3*f5*f8^2 - 16*f1^2*f3*f6*f7*f8 + 4*f1^2*f3*f7^3
- 192*f1^2*f4^2*f8^2 + 96*f1^2*f4*f5*f7*f8 - 192*f1^2*f4*f6^2*f8 +
48*f1^2*f4*f6*f7^2 + 48*f1^2*f5^2*f6*f8 - 12*f1^2*f5^2*f7^2)*x[1]^2*x[5]*x[7] +
(-128*f0^2*f4*f8^2 - 96*f0^2*f5*f7*f8 - 128*f0^2*f6^2*f8 + 64*f0^2*f6*f7^2 -
96*f0*f1*f3*f8^2 + 64*f0*f1*f4*f7*f8 + 32*f0*f1*f5*f6*f8 - 128*f0*f2^2*f8^2 +
32*f0*f2*f3*f7*f8 - 384*f0*f2*f4*f6*f8 + 96*f0*f2*f4*f7^2 + 96*f0*f2*f5^2*f8 +
96*f0*f3^2*f6*f8 - 24*f0*f3^2*f7^2 + 64*f1^2*f2*f8^2 + 96*f1^2*f4*f6*f8 -
24*f1^2*f4*f7^2 - 24*f1^2*f5^2*f8)*x[1]^2*x[5]*x[8] + (128*f0^2*f2*f8^3 -
256*f0^2*f3*f7*f8^2 - 256*f0^2*f4*f6*f8^2 + 64*f0^2*f4*f7^2*f8 +
256*f0^2*f5^2*f8^2 - 288*f0^2*f5*f6*f7*f8 + 64*f0^2*f5*f7^3 + 128*f0^2*f6^3*f8 -
32*f0^2*f6^2*f7^2 + 32*f0*f1*f2*f7*f8^2 + 32*f0*f1*f3*f6*f8^2 +
72*f0*f1*f3*f7^2*f8 - 64*f0*f1*f4*f5*f8^2 + 32*f0*f1*f4*f6*f7*f8 -
24*f0*f1*f4*f7^3 + 32*f0*f1*f5^2*f7*f8 - 256*f0*f2^2*f6*f8^2 +
160*f0*f2*f3*f5*f8^2 - 128*f0*f2*f4^2*f8^2 + 64*f0*f2*f4*f5*f7*f8 -
384*f0*f2*f4*f6^2*f8 + 96*f0*f2*f4*f6*f7^2 + 128*f0*f2*f5^2*f6*f8 -
32*f0*f2*f5^2*f7^2 + 64*f0*f3^2*f4*f8^2 - 56*f0*f3^2*f5*f7*f8 +
160*f0*f3^2*f6^2*f8 - 40*f0*f3^2*f6*f7^2 - 32*f0*f3*f4*f5*f6*f8 +
8*f0*f3*f4*f5*f7^2 + 64*f1^2*f2*f6*f8^2 - 32*f1^2*f2*f7^2*f8 +
48*f1^2*f3*f5*f8^2 - 16*f1^2*f3*f6*f7*f8 + 4*f1^2*f3*f7^3 - 48*f1^2*f4*f5*f7*f8
+ 128*f1^2*f4*f6^2*f8 - 32*f1^2*f4*f6*f7^2 - 48*f1^2*f5^2*f6*f8 +
12*f1^2*f5^2*f7^2 - 64*f1*f2^2*f5*f8^2 - 32*f1*f2*f3*f4*f8^2 +
16*f1*f2*f3*f5*f7*f8 - 32*f1*f2*f3*f6^2*f8 + 8*f1*f2*f3*f6*f7^2)*x[1]^2*x[6]^2 +
(384*f0^2*f3*f8^3 - 128*f0^2*f6^2*f7*f8 + 32*f0^2*f6*f7^3 - 384*f0*f1*f2*f8^3 -
32*f0*f1*f3*f7*f8^2 - 128*f0*f1*f5^2*f8^2 + 128*f0*f1*f5*f6*f7*f8 -
8*f0*f1*f5*f7^3 - 128*f0*f1*f6^3*f8 + 32*f0*f1*f6^2*f7^2 + 128*f0*f2^2*f7*f8^2 -
256*f0*f2*f3*f6*f8^2 + 96*f0*f2*f3*f7^2*f8 - 384*f0*f2*f4*f5*f8^2 +
256*f0*f2*f4*f6*f7*f8 - 64*f0*f2*f4*f7^3 + 128*f0*f2*f5^2*f7*f8 -
128*f0*f2*f5*f6^2*f8 + 32*f0*f2*f5*f6*f7^2 + 224*f0*f3^2*f5*f8^2 -
96*f0*f3^2*f6*f7*f8 + 24*f0*f3^2*f7^3 - 128*f0*f3*f4^2*f8^2 +
64*f0*f3*f4*f5*f7*f8 - 128*f0*f3*f4*f6^2*f8 + 32*f0*f3*f4*f6*f7^2 +
64*f0*f3*f5^2*f6*f8 - 16*f0*f3*f5^2*f7^2 + 64*f1^3*f8^3 + 64*f1^2*f2*f7*f8^2 -
64*f1^2*f3*f6*f8^2 + 16*f1^2*f3*f7^2*f8 + 192*f1^2*f4*f5*f8^2 -
96*f1^2*f4*f6*f7*f8 + 24*f1^2*f4*f7^3 - 24*f1^2*f5^2*f7*f8 + 64*f1^2*f5*f6^2*f8
- 16*f1^2*f5*f6*f7^2 + 128*f1*f2^2*f6*f8^2 - 32*f1*f2^2*f7^2*f8 +
32*f1*f2*f3*f6*f7*f8 - 8*f1*f2*f3*f7^3 + 32*f1*f3^2*f4*f8^2 -
16*f1*f3^2*f5*f7*f8 + 32*f1*f3^2*f6^2*f8 - 8*f1*f3^2*f6*f7^2)*x[1]^2*x[6]*x[7] +
(128*f0^2*f5*f8^2 - 64*f0^2*f6*f7*f8 + 32*f0^2*f7^3 + 48*f0*f1*f5*f7*f8 +
64*f0*f1*f6^2*f8 - 32*f0*f1*f6*f7^2 + 64*f0*f2*f3*f8^2 + 64*f0*f2*f5*f6*f8 -
48*f0*f2*f5*f7^2 - 16*f0*f3^2*f7*f8 + 64*f0*f3*f4*f6*f8 - 16*f0*f3*f4*f7^2 -
32*f0*f3*f5^2*f8 + 64*f1^2*f3*f8^2 - 48*f1^2*f4*f7*f8 - 32*f1^2*f5*f6*f8 +
12*f1^2*f5*f7^2 - 64*f1*f2^2*f8^2 - 16*f1*f3^2*f6*f8 +
4*f1*f3^2*f7^2)*x[1]^2*x[6]*x[8] + (128*f0^2*f4*f8^3 - 160*f0^2*f5*f7*f8^2 +
256*f0^2*f6^2*f8^2 + 64*f0^2*f6*f7^2*f8 - 32*f0^2*f7^4 - 128*f0*f1*f3*f8^3 +
32*f0*f1*f4*f7*f8^2 - 64*f0*f1*f5*f6*f8^2 - 16*f0*f1*f5*f7^2*f8 +
32*f0*f1*f6^2*f7*f8 - 8*f0*f1*f6*f7^3 + 256*f0*f2^2*f8^3 - 192*f0*f2*f3*f7*f8^2
+ 384*f0*f2*f4*f6*f8^2 - 32*f0*f2*f4*f7^2*f8 + 192*f0*f2*f5^2*f8^2 -
448*f0*f2*f5*f6*f7*f8 + 80*f0*f2*f5*f7^3 + 256*f0*f2*f6^3*f8 -
64*f0*f2*f6^2*f7^2 - 224*f0*f3*f4*f5*f8^2 + 64*f0*f3*f4*f6*f7*f8 -
16*f0*f3*f4*f7^3 + 48*f0*f3*f5^2*f7*f8 - 96*f0*f3*f5*f6^2*f8 +
24*f0*f3*f5*f6*f7^2 + 128*f0*f4^3*f8^2 - 64*f0*f4^2*f5*f7*f8 +
128*f0*f4^2*f6^2*f8 - 32*f0*f4^2*f6*f7^2 - 32*f0*f4*f5^2*f6*f8 +
8*f0*f4*f5^2*f7^2 - 128*f1^2*f2*f8^3 + 32*f1^2*f3*f7*f8^2 - 64*f1^2*f4*f6*f8^2 -
48*f1^2*f5^2*f8^2 + 80*f1^2*f5*f6*f7*f8 - 12*f1^2*f5*f7^3 - 64*f1^2*f6^3*f8 +
16*f1^2*f6^2*f7^2 - 96*f1*f2*f3*f6*f8^2 + 24*f1*f2*f3*f7^2*f8 +
32*f1*f3^2*f5*f8^2 - 16*f1*f3^2*f6*f7*f8 + 4*f1*f3^2*f7^3 - 32*f1*f3*f4^2*f8^2 +
16*f1*f3*f4*f5*f7*f8 - 32*f1*f3*f4*f6^2*f8 + 8*f1*f3*f4*f6*f7^2 +
8*f1*f3*f5^2*f6*f8 - 2*f1*f3*f5^2*f7^2)*x[1]^2*x[7]^2 + (-128*f0^2*f6*f8^2 -
32*f0^2*f7^2*f8 - 64*f0*f1*f5*f8^2 + 8*f0*f1*f7^3 - 384*f0*f2*f4*f8^2 +
224*f0*f2*f5*f7*f8 - 256*f0*f2*f6^2*f8 + 64*f0*f2*f6*f7^2 + 96*f0*f3^2*f8^2 +
96*f0*f3*f5*f6*f8 - 24*f0*f3*f5*f7^2 - 128*f0*f4^2*f6*f8 + 32*f0*f4^2*f7^2 +
32*f0*f4*f5^2*f8 + 96*f1^2*f4*f8^2 - 24*f1^2*f5*f7*f8 + 64*f1^2*f6^2*f8 -
16*f1^2*f6*f7^2 + 32*f1*f2*f3*f8^2 + 32*f1*f3*f4*f6*f8 - 8*f1*f3*f4*f7^2 -
8*f1*f3*f5^2*f8)*x[1]^2*x[7]*x[8] + (64*f0^3*f7^2 + 64*f0^2*f1*f5*f8 +
64*f0^2*f2*f5*f7 - 32*f0^2*f3^2*f8 - 16*f0*f1^2*f5*f7 + 96*f0*f1*f2*f3*f8 -
24*f1^3*f3*f8)*x[1]*x[2]^3 + (-128*f0^3*f7*f8 - 128*f0^2*f1*f6*f8 -
64*f0^2*f1*f7^2 - 64*f0^2*f2*f5*f8 - 128*f0^2*f2*f6*f7 + 128*f0^2*f3*f4*f8 -
64*f0^2*f3*f5*f7 - 32*f0*f1^2*f5*f8 + 32*f0*f1^2*f6*f7 - 64*f0*f1*f2*f4*f8 +
16*f0*f1*f2*f5*f7 - 80*f0*f1*f3^2*f8 + 16*f1^3*f4*f8 -
4*f1^3*f5*f7)*x[1]*x[2]^2*x[3] + (-32*f0^2*f1*f7*f8 - 256*f0^2*f2*f6*f8 -
64*f0^2*f2*f7^2 + 128*f0^2*f3*f5*f8 + 64*f0^2*f3*f6*f7 - 128*f0^2*f4^2*f8 +
32*f0^2*f4*f5*f7 + 128*f0*f1^2*f6*f8 + 48*f0*f1^2*f7^2 - 96*f0*f1*f2*f5*f8 +
64*f0*f1*f3*f4*f8 + 16*f0*f1*f3*f5*f7 + 48*f1^3*f5*f8 +
24*f1^2*f3^2*f8)*x[1]*x[2]^2*x[4] + (96*f0^2*f1*f7*f8 - 128*f0^2*f2*f6*f8 +
64*f0^2*f2*f7^2 + 64*f0^2*f3*f5*f8 + 32*f0^2*f3*f6*f7 - 128*f0^2*f4^2*f8 +
32*f0^2*f4*f5*f7 + 64*f0*f1^2*f6*f8 - 16*f0*f1^2*f7^2 + 64*f0*f1*f3*f4*f8 -
16*f0*f1*f3*f5*f7 - 128*f0*f2^2*f4*f8 + 32*f0*f2^2*f5*f7 + 32*f0*f2*f3^2*f8 +
32*f1^2*f2*f4*f8 - 8*f1^2*f2*f5*f7 - 8*f1^2*f3^2*f8)*x[1]*x[2]^2*x[5] +
(128*f0^2*f1*f8^2 + 128*f0^2*f2*f7*f8 - 256*f0^2*f3*f6*f8 + 64*f0^2*f3*f7^2 +
128*f0^2*f4*f5*f8 - 32*f0^2*f5^2*f7 - 64*f0*f1^2*f7*f8 + 320*f0*f1*f2*f6*f8 -
64*f0*f1*f2*f7^2 - 32*f0*f1*f3*f5*f8 - 16*f0*f1*f3*f6*f7 + 64*f0*f2*f3*f4*f8 -
16*f0*f2*f3*f5*f7 - 16*f0*f3^3*f8 - 96*f1^3*f6*f8 + 16*f1^3*f7^2 -
16*f1^2*f3*f4*f8 + 4*f1^2*f3*f5*f7)*x[1]*x[2]^2*x[6] + (-128*f0^2*f2*f8^2 -
128*f0^2*f4*f6*f8 + 64*f0^2*f5*f6*f7 - 32*f0*f1^2*f8^2 - 32*f0*f1*f2*f7*f8 +
128*f0*f1*f3*f6*f8 - 16*f0*f1*f3*f7^2 - 256*f0*f2^2*f6*f8 + 64*f0*f2^2*f7^2 +
96*f0*f2*f3*f5*f8 - 128*f0*f2*f4^2*f8 + 32*f0*f2*f4*f5*f7 + 32*f0*f3^2*f4*f8 -
8*f0*f3^2*f5*f7 + 8*f1^3*f7*f8 + 64*f1^2*f2*f6*f8 - 16*f1^2*f2*f7^2 -
24*f1^2*f3*f5*f8 + 32*f1^2*f4^2*f8 - 8*f1^2*f4*f5*f7)*x[1]*x[2]^2*x[7] +
(64*f0^2*f4*f8 - 64*f0^2*f5*f7 - 96*f0*f1*f3*f8)*x[1]*x[2]^2*x[8] +
(224*f0^2*f1*f7*f8 + 256*f0^2*f2*f6*f8 + 64*f0^2*f2*f7^2 - 96*f0^2*f3*f5*f8 +
64*f0^2*f3*f6*f7 + 32*f0^2*f4*f5*f7 + 32*f0*f1*f2*f5*f8 + 32*f0*f1*f3*f4*f8 +
8*f0*f1*f3*f5*f7 + 128*f0*f2^2*f4*f8 - 32*f0*f2^2*f5*f7 - 32*f0*f2*f3^2*f8 -
32*f1^2*f2*f4*f8 + 8*f1^2*f2*f5*f7 + 8*f1^2*f3^2*f8)*x[1]*x[2]*x[3]^2 +
(128*f0^2*f2*f7*f8 + 256*f0^2*f3*f6*f8 - 128*f0^2*f4*f5*f8 - 128*f0^2*f4*f6*f7 +
64*f0^2*f5^2*f7 - 128*f0*f1^2*f7*f8 - 256*f0*f1*f2*f6*f8 + 96*f0*f1*f3*f5*f8 -
32*f0*f1*f3*f6*f7 - 64*f0*f1*f4*f5*f7 - 128*f0*f2*f3*f4*f8 + 32*f0*f2*f3*f5*f7 +
32*f0*f3^3*f8 - 16*f1^3*f7^2 - 32*f1^2*f2*f5*f8 -
32*f1^2*f3*f4*f8)*x[1]*x[2]*x[3]*x[4] + (-256*f0^2*f1*f8^2 - 128*f0^2*f2*f7*f8 +
64*f0^2*f3*f6*f8 - 96*f0^2*f3*f7^2 + 128*f0^2*f4*f5*f8 - 64*f0^2*f4*f6*f7 -
32*f0^2*f5^2*f7 - 48*f0*f1^2*f7*f8 - 64*f0*f1*f2*f6*f8 + 16*f0*f1*f2*f7^2 -
80*f0*f1*f3*f5*f8 + 64*f0*f2^2*f5*f8 - 16*f0*f2*f3*f5*f7 - 4*f1^3*f7^2 -
16*f1^2*f2*f5*f8 + 4*f1^2*f3*f5*f7)*x[1]*x[2]*x[3]*x[5] + (-128*f0^2*f2*f8^2 +
64*f0^2*f3*f7*f8 + 256*f0^2*f4*f6*f8 - 128*f0^2*f4*f7^2 - 128*f0^2*f5^2*f8 +
32*f0^2*f5*f6*f7 + 64*f0*f1^2*f8^2 - 64*f0*f1*f2*f7*f8 - 160*f0*f1*f3*f6*f8 +
40*f0*f1*f3*f7^2 + 32*f0*f1*f4*f6*f7 + 16*f0*f1*f5^2*f7 - 32*f0*f2*f3*f5*f8 +
8*f0*f3^2*f5*f7 + 40*f1^3*f7*f8 + 32*f1^2*f2*f6*f8 +
24*f1^2*f3*f5*f8)*x[1]*x[2]*x[3]*x[6] + (-128*f0^2*f3*f8^2 + 128*f0^2*f4*f7*f8 +
64*f0^2*f5*f6*f8 - 64*f0^2*f6^2*f7 + 128*f0*f1*f2*f8^2 + 32*f0*f1*f3*f7*f8 -
64*f0*f1*f4*f6*f8 + 32*f0*f1*f4*f7^2 - 32*f0*f1*f5*f6*f7 + 128*f0*f2^2*f7*f8 +
128*f0*f2*f3*f6*f8 - 64*f0*f2*f3*f7^2 + 128*f0*f2*f4*f5*f8 - 32*f0*f2*f5^2*f7 -
64*f0*f3^2*f5*f8 - 32*f1^2*f2*f7*f8 - 48*f1^2*f3*f6*f8 + 8*f1^2*f3*f7^2 -
32*f1^2*f4*f5*f8 + 8*f1^2*f5^2*f7)*x[1]*x[2]*x[3]*x[7] + (96*f0^2*f6*f7 +
32*f0*f1*f4*f8 + 24*f0*f1*f5*f7 + 40*f1^2*f3*f8)*x[1]*x[2]*x[3]*x[8] +
(128*f0^2*f2*f8^2 - 192*f0^2*f3*f7*f8 + 128*f0^2*f4*f6*f8 + 64*f0^2*f4*f7^2 -
32*f0^2*f5^2*f8 - 64*f0^2*f5*f6*f7 + 160*f0*f1*f2*f7*f8 - 192*f0*f1*f3*f6*f8 -
48*f0*f1*f3*f7^2 + 64*f0*f1*f4*f5*f8 + 64*f0*f1*f4*f6*f7 - 16*f0*f1*f5^2*f7 +
256*f0*f2^2*f6*f8 - 96*f0*f2*f3*f5*f8 + 128*f0*f2*f4^2*f8 - 32*f0*f3^2*f4*f8 -
48*f1^3*f7*f8 + 16*f1^2*f2*f7^2 - 32*f1^2*f3*f5*f8 + 16*f1^2*f4*f5*f7 +
32*f1*f2^2*f5*f8 + 32*f1*f2*f3*f4*f8 - 8*f1*f2*f3*f5*f7 -
8*f1*f3^3*f8)*x[1]*x[2]*x[4]^2 + (-128*f0^2*f2*f8^2 - 64*f0^2*f3*f7*f8 -
256*f0^2*f4*f6*f8 + 64*f0^2*f4*f7^2 + 64*f0^2*f5^2*f8 - 32*f0^2*f5*f6*f7 +
64*f0*f1^2*f8^2 + 32*f0*f1*f3*f6*f8 + 24*f0*f1*f3*f7^2 + 32*f0*f1*f4*f6*f7 +
16*f0*f1*f5^2*f7 - 32*f0*f2*f3*f5*f8 + 8*f0*f3^2*f5*f7 + 40*f1^3*f7*f8 +
32*f1^2*f2*f6*f8 + 24*f1^2*f3*f5*f8)*x[1]*x[2]*x[4]*x[5] + (256*f0^2*f3*f8^2 -
128*f0^2*f4*f7*f8 + 128*f0^2*f5*f6*f8 - 96*f0^2*f5*f7^2 + 64*f0^2*f6^2*f7 -
192*f0*f1*f2*f8^2 + 64*f0*f1*f3*f7*f8 + 48*f0*f1*f4*f7^2 - 32*f0*f1*f5^2*f8 -
128*f0*f2^2*f7*f8 - 64*f0*f2*f3*f6*f8 - 64*f0*f2*f4*f5*f8 - 64*f0*f2*f4*f6*f7 +
32*f0*f2*f5^2*f7 + 64*f0*f3^2*f5*f8 + 16*f0*f3^2*f6*f7 - 16*f0*f3*f4*f5*f7 +
64*f1^3*f8^2 - 16*f1^2*f2*f7*f8 + 96*f1^2*f3*f6*f8 - 16*f1^2*f3*f7^2 -
16*f1^2*f5^2*f7 - 64*f1*f2^2*f6*f8 - 16*f1*f2*f3*f5*f8)*x[1]*x[2]*x[4]*x[6] +
(-128*f0^2*f4*f8^2 + 32*f0^2*f5*f7*f8 - 128*f0^2*f6^2*f8 + 32*f0*f1*f3*f8^2 -
128*f0*f1*f4*f7*f8 + 40*f0*f1*f5*f7^2 - 128*f0*f2^2*f8^2 - 384*f0*f2*f4*f6*f8 +
128*f0*f2*f4*f7^2 + 96*f0*f2*f5^2*f8 + 96*f0*f3^2*f6*f8 - 16*f0*f3^2*f7^2 -
32*f0*f3*f4*f5*f8 + 16*f0*f3*f5^2*f7 + 40*f1^2*f3*f7*f8 + 128*f1^2*f4*f6*f8 -
48*f1^2*f4*f7^2 - 16*f1^2*f5^2*f8 + 16*f1^2*f5*f6*f7 + 16*f1*f2*f3*f7^2 +
16*f1*f3^2*f5*f8)*x[1]*x[2]*x[4]*x[7] + (64*f0^2*f6*f8 - 32*f0*f1*f6*f7 -
64*f0*f2*f4*f8 - 16*f0*f2*f5*f7 + 32*f0*f3^2*f8 - 32*f1^2*f4*f8 - 8*f1^2*f5*f7 -
32*f1*f2*f3*f8)*x[1]*x[2]*x[4]*x[8] + (-128*f0^2*f2*f8^2 + 64*f0^2*f3*f7*f8 -
256*f0^2*f4*f6*f8 + 96*f0^2*f4*f7^2 + 64*f0^2*f5^2*f8 + 32*f0*f1^2*f8^2 +
96*f0*f1*f3*f6*f8 - 24*f0*f1*f3*f7^2 - 128*f0*f2^2*f6*f8 + 32*f0*f2^2*f7^2 +
32*f0*f2*f3*f5*f8 + 8*f1^3*f7*f8 + 32*f1^2*f2*f6*f8 - 8*f1^2*f2*f7^2 -
8*f1^2*f3*f5*f8)*x[1]*x[2]*x[5]^2 + (128*f0^2*f4*f7*f8 + 128*f0^2*f5*f6*f8 +
128*f0*f1*f2*f8^2 + 128*f0*f1*f4*f6*f8 - 64*f0*f1*f4*f7^2 - 64*f0*f1*f5^2*f8 +
128*f0*f2*f3*f6*f8 - 32*f0*f2*f3*f7^2 - 32*f0*f3^2*f5*f8 - 32*f1^3*f8^2 -
32*f1^2*f2*f7*f8 - 64*f1^2*f3*f6*f8 + 16*f1^2*f3*f7^2)*x[1]*x[2]*x[5]*x[6] +
(-128*f0^2*f4*f8^2 - 160*f0^2*f5*f7*f8 - 256*f0^2*f6^2*f8 + 96*f0^2*f6*f7^2 -
160*f0*f1*f3*f8^2 - 32*f0*f1*f4*f7*f8 + 64*f0*f1*f5*f6*f8 + 8*f0*f1*f5*f7^2 -
256*f0*f2^2*f8^2 + 64*f0*f2*f3*f7*f8 - 768*f0*f2*f4*f6*f8 + 192*f0*f2*f4*f7^2 +
192*f0*f2*f5^2*f8 + 192*f0*f3^2*f6*f8 - 48*f0*f3^2*f7^2 + 96*f1^2*f2*f8^2 +
8*f1^2*f3*f7*f8 + 192*f1^2*f4*f6*f8 - 48*f1^2*f4*f7^2 -
48*f1^2*f5^2*f8)*x[1]*x[2]*x[5]*x[7] + (64*f0^2*f6*f8 - 32*f0^2*f7^2 -
32*f0*f1*f5*f8 - 16*f0*f1*f6*f7 + 128*f0*f2*f4*f8 - 32*f0*f2*f5*f7 -
32*f0*f3^2*f8 - 32*f1^2*f4*f8 + 8*f1^2*f5*f7)*x[1]*x[2]*x[5]*x[8] +
(160*f0^2*f5*f7*f8 - 128*f0^2*f6^2*f8 + 96*f0*f1*f3*f8^2 - 96*f0*f1*f4*f7*f8 -
16*f0*f1*f5*f7^2 + 128*f0*f2^2*f8^2 + 384*f0*f2*f4*f6*f8 - 64*f0*f2*f4*f7^2 -
128*f0*f2*f5^2*f8 - 160*f0*f3^2*f6*f8 + 32*f0*f3^2*f7^2 + 32*f0*f3*f4*f5*f8 -
32*f1^2*f2*f8^2 - 16*f1^2*f3*f7*f8 - 128*f1^2*f4*f6*f8 + 32*f1^2*f4*f7^2 +
48*f1^2*f5^2*f8 + 32*f1*f2^2*f7*f8 + 32*f1*f2*f3*f6*f8 -
8*f1*f2*f3*f7^2)*x[1]*x[2]*x[6]^2 + (-128*f0^2*f5*f8^2 + 128*f0^2*f6*f7*f8 +
128*f0*f1*f4*f8^2 + 32*f0*f1*f5*f7*f8 + 128*f0*f1*f6^2*f8 - 32*f0*f1*f6*f7^2 +
64*f0*f2*f3*f8^2 - 64*f0*f2*f4*f7*f8 + 128*f0*f2*f5*f6*f8 - 48*f0*f2*f5*f7^2 +
128*f0*f3*f4*f6*f8 - 32*f0*f3*f4*f7^2 - 64*f0*f3*f5^2*f8 + 32*f1^2*f4*f7*f8 -
64*f1^2*f5*f6*f8 + 8*f1^2*f5*f7^2 - 64*f1*f2^2*f8^2 - 32*f1*f2*f3*f7*f8 -
32*f1*f3^2*f6*f8 + 8*f1*f3^2*f7^2)*x[1]*x[2]*x[6]*x[7] + (-64*f0*f1*f6*f8 +
8*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 32*f0*f2*f6*f7 - 32*f0*f3*f4*f8 + 16*f0*f3*f5*f7
+ 32*f1^2*f5*f8 + 8*f1*f3^2*f8)*x[1]*x[2]*x[6]*x[8] + (-128*f0^2*f6*f8^2 -
32*f0^2*f7^2*f8 - 32*f0*f1*f6*f7*f8 + 8*f0*f1*f7^3 - 128*f0*f2*f4*f8^2 +
128*f0*f2*f5*f7*f8 - 256*f0*f2*f6^2*f8 + 64*f0*f2*f6*f7^2 + 96*f0*f3*f5*f6*f8 -
24*f0*f3*f5*f7^2 - 128*f0*f4^2*f6*f8 + 32*f0*f4^2*f7^2 + 32*f0*f4*f5^2*f8 -
16*f1^2*f5*f7*f8 + 64*f1^2*f6^2*f8 - 16*f1^2*f6*f7^2 + 64*f1*f2*f3*f8^2 +
32*f1*f3*f4*f6*f8 - 8*f1*f3*f4*f7^2 - 8*f1*f3*f5^2*f8)*x[1]*x[2]*x[7]^2 +
(64*f0^2*f8^2 + 48*f0*f1*f7*f8 + 256*f0*f2*f6*f8 - 96*f0*f2*f7^2 -
80*f0*f3*f5*f8 + 64*f0*f4^2*f8 - 16*f0*f4*f5*f7 - 96*f1^2*f6*f8 + 16*f1^2*f7^2 -
16*f1*f3*f4*f8 + 4*f1*f3*f5*f7)*x[1]*x[2]*x[7]*x[8] +
16*f1^2*f8*x[1]*x[2]*x[8]^2 + (-64*f0^2*f2*f7*f8 - 64*f0^2*f3*f6*f8 -
32*f0^2*f3*f7^2 - 16*f0^2*f5^2*f7 - 64*f0*f1^2*f7*f8 - 64*f0*f2^2*f5*f8 +
16*f0*f2*f3*f5*f7 + 16*f1^2*f2*f5*f8 - 4*f1^2*f3*f5*f7)*x[1]*x[3]^3 +
(128*f0^2*f2*f8^2 - 160*f0^2*f3*f7*f8 - 128*f0^2*f4*f6*f8 + 128*f0^2*f4*f7^2 +
128*f0^2*f5^2*f8 - 64*f0*f1^2*f8^2 + 128*f0*f1*f2*f7*f8 + 96*f0*f1*f3*f6*f8 +
16*f0*f1*f5^2*f7 + 96*f0*f2*f3*f5*f8 - 24*f0*f3^2*f5*f7 +
48*f1^3*f7*f8)*x[1]*x[3]^2*x[4] + (128*f0^2*f2*f8^2 + 96*f0^2*f3*f7*f8 +
128*f0^2*f4*f6*f8 - 64*f0^2*f5^2*f8 + 64*f0^2*f5*f6*f7 + 128*f0*f1^2*f8^2 +
24*f0*f1*f3*f7^2 + 128*f0*f2^2*f6*f8 - 32*f0*f2^2*f7^2 - 32*f0*f2*f3*f5*f8 +
8*f1^3*f7*f8 - 32*f1^2*f2*f6*f8 + 8*f1^2*f2*f7^2 +
8*f1^2*f3*f5*f8)*x[1]*x[3]^2*x[5] + (-128*f0^2*f3*f8^2 - 64*f0^2*f5*f6*f8 -
16*f0^2*f5*f7^2 + 64*f0*f1*f2*f8^2 - 16*f0*f1*f3*f7*f8 - 64*f0*f1*f4*f6*f8 +
32*f0*f1*f4*f7^2 + 32*f0*f1*f5^2*f8 - 32*f0*f1*f5*f6*f7 - 64*f0*f2*f3*f6*f8 +
16*f0*f2*f3*f7^2 + 16*f0*f3^2*f5*f8 - 64*f1^3*f8^2 + 16*f1^2*f3*f6*f8 -
12*f1^2*f3*f7^2)*x[1]*x[3]^2*x[6] + (96*f0^2*f5*f7*f8 + 128*f0^2*f6^2*f8 -
32*f0^2*f6*f7^2 + 160*f0*f1*f3*f8^2 - 96*f0*f1*f4*f7*f8 - 16*f0*f1*f5*f7^2 +
32*f0*f1*f6^2*f7 - 128*f0*f2^2*f8^2 + 384*f0*f2*f4*f6*f8 - 128*f0*f2*f4*f7^2 -
160*f0*f2*f5^2*f8 + 32*f0*f2*f5*f6*f7 - 128*f0*f3^2*f6*f8 + 48*f0*f3^2*f7^2 +
32*f0*f3*f4*f5*f8 - 16*f1^2*f3*f7*f8 - 64*f1^2*f4*f6*f8 + 32*f1^2*f4*f7^2 +
32*f1^2*f5^2*f8 - 8*f1^2*f5*f6*f7)*x[1]*x[3]^2*x[7] + (-64*f0^2*f6*f8 -
48*f0^2*f7^2 - 16*f0*f1*f5*f8 - 16*f0*f1*f6*f7 - 64*f0*f2*f4*f8 + 16*f0*f2*f5*f7
+ 16*f0*f3^2*f8 - 4*f1^2*f5*f7)*x[1]*x[3]^2*x[8] + (128*f0^2*f4*f7*f8 -
128*f0^2*f5*f6*f8 - 32*f0^2*f5*f7^2 - 192*f0*f1*f2*f8^2 + 112*f0*f1*f3*f7*f8 +
128*f0*f1*f4*f6*f8 - 96*f0*f1*f4*f7^2 - 96*f0*f1*f5^2*f8 + 16*f0*f1*f5*f6*f7 -
128*f0*f2^2*f7*f8 - 64*f0*f2*f3*f6*f8 - 64*f0*f2*f4*f5*f8 - 32*f0*f2*f5^2*f7 -
16*f0*f3^2*f5*f8 + 32*f0*f3*f4*f5*f7 + 64*f1^3*f8^2 - 48*f1^2*f2*f7*f8 -
32*f1^2*f3*f6*f8 + 16*f1^2*f3*f7^2 + 4*f1^2*f5^2*f7 - 16*f1*f2*f3*f5*f8 +
4*f1*f3^2*f5*f7)*x[1]*x[3]*x[4]^2 + (128*f0^2*f3*f8^2 - 128*f0^2*f4*f7*f8 -
64*f0^2*f5*f6*f8 + 96*f0^2*f5*f7^2 - 64*f0^2*f6^2*f7 - 128*f0*f1*f2*f8^2 +
32*f0*f1*f3*f7*f8 - 64*f0*f1*f4*f6*f8 - 64*f0*f1*f4*f7^2 + 32*f0*f1*f5^2*f8 -
32*f0*f1*f5*f6*f7 - 128*f0*f2*f3*f6*f8 + 32*f0*f2*f3*f7^2 + 32*f0*f3^2*f5*f8 -
64*f1^3*f8^2 - 32*f1^2*f2*f7*f8 - 16*f1^2*f3*f6*f8 -
8*f1^2*f3*f7^2)*x[1]*x[3]*x[4]*x[5] + (128*f0^2*f4*f8^2 - 160*f0^2*f5*f7*f8 +
128*f0^2*f6^2*f8 + 64*f0^2*f6*f7^2 - 160*f0*f1*f3*f8^2 + 64*f0*f1*f4*f7*f8 +
64*f0*f1*f5*f6*f8 + 8*f0*f1*f5*f7^2 + 128*f0*f2^2*f8^2 + 64*f0*f2*f3*f7*f8 -
384*f0*f2*f4*f6*f8 + 128*f0*f2*f4*f7^2 + 224*f0*f2*f5^2*f8 + 224*f0*f3^2*f6*f8 -
64*f0*f3^2*f7^2 - 96*f0*f3*f4*f5*f8 + 64*f1^2*f2*f8^2 + 8*f1^2*f3*f7*f8 +
128*f1^2*f4*f6*f8 - 48*f1^2*f4*f7^2 - 64*f1^2*f5^2*f8 + 16*f1^2*f5*f6*f7 +
16*f1*f2*f3*f7^2)*x[1]*x[3]*x[4]*x[6] + (256*f0^2*f5*f8^2 - 192*f0^2*f6*f7*f8 +
64*f0^2*f7^3 - 128*f0*f1*f4*f8^2 + 64*f0*f1*f5*f7*f8 - 128*f0*f1*f6^2*f8 -
16*f0*f1*f6*f7^2 + 128*f0*f2*f3*f8^2 - 64*f0*f2*f5*f6*f8 + 96*f0*f2*f5*f7^2 -
64*f0*f2*f6^2*f7 - 32*f0*f3^2*f7*f8 - 64*f0*f3*f4*f6*f8 + 64*f0*f3*f5^2*f8 -
16*f0*f3*f5*f6*f7 - 96*f1^2*f3*f8^2 + 48*f1^2*f4*f7*f8 - 16*f1^2*f5*f7^2 +
64*f1*f2^2*f8^2 - 64*f1*f2*f4*f6*f8 + 16*f1*f2*f5^2*f8 + 32*f1*f3^2*f6*f8 -
16*f1*f3^2*f7^2 - 16*f1*f3*f4*f5*f8)*x[1]*x[3]*x[4]*x[7] + (-64*f0^2*f7*f8 +
64*f0*f1*f6*f8 + 40*f0*f1*f7^2 + 128*f0*f2*f5*f8 + 32*f0*f2*f6*f7 -
24*f0*f3*f5*f7 + 32*f1*f2*f4*f8)*x[1]*x[3]*x[4]*x[8] + (-80*f0^2*f5*f7^2 -
96*f0*f1*f3*f7*f8 - 16*f1^3*f8^2)*x[1]*x[3]*x[5]^2 + (128*f0^2*f4*f8^2 -
96*f0^2*f5*f7*f8 + 32*f0^2*f6*f7^2 - 96*f0*f1*f3*f8^2 + 32*f0*f1*f4*f7*f8 +
56*f0*f1*f5*f7^2 + 32*f1^2*f2*f8^2 + 56*f1^2*f3*f7*f8)*x[1]*x[3]*x[5]*x[6] +
(128*f0^2*f6*f7*f8 - 32*f0^2*f7^3 + 128*f0*f1*f4*f8^2 - 32*f0*f1*f6*f7^2 +
128*f0*f2*f3*f8^2 + 128*f0*f2*f4*f7*f8 + 128*f0*f2*f5*f6*f8 - 64*f0*f2*f5*f7^2 -
64*f0*f3^2*f7*f8 - 32*f0*f3*f5^2*f8 - 64*f1^2*f4*f7*f8 - 32*f1^2*f5*f6*f8 +
16*f1^2*f5*f7^2)*x[1]*x[3]*x[5]*x[7] + (64*f0^2*f7*f8 + 32*f0*f1*f6*f8 +
24*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 8*f0*f3*f5*f7 +
16*f1^2*f5*f8)*x[1]*x[3]*x[5]*x[8] + (-128*f0^2*f5*f8^2 + 64*f0^2*f6*f7*f8 -
64*f0^2*f7^3 - 16*f0*f1*f5*f7*f8 - 64*f0*f2*f3*f8^2 - 64*f0*f2*f4*f7*f8 -
64*f0*f2*f5*f6*f8 + 16*f0*f2*f5*f7^2 + 32*f0*f3^2*f7*f8 + 16*f0*f3*f5^2*f8 -
16*f1^2*f3*f8^2 + 32*f1^2*f4*f7*f8 + 16*f1^2*f5*f6*f8 - 12*f1^2*f5*f7^2 -
32*f1*f2*f3*f7*f8)*x[1]*x[3]*x[6]^2 + (-128*f0^2*f6*f8^2 + 64*f0^2*f7^2*f8 +
64*f0*f1*f5*f8^2 - 64*f0*f1*f6*f7*f8 + 40*f0*f1*f7^3 + 256*f0*f2*f4*f8^2 -
160*f0*f2*f5*f7*f8 + 32*f0*f2*f6*f7^2 - 128*f0*f3^2*f8^2 - 32*f0*f3*f5*f6*f8 +
24*f0*f3*f5*f7^2 - 128*f1^2*f4*f8^2 + 40*f1^2*f5*f7*f8 + 32*f1*f2*f3*f8^2 +
32*f1*f2*f4*f7*f8 + 16*f1*f3^2*f7*f8 + 8*f1*f3*f5^2*f8)*x[1]*x[3]*x[6]*x[7] +
(-64*f0^2*f8^2 - 48*f0*f1*f7*f8 - 128*f0*f2*f6*f8 + 32*f0*f2*f7^2 +
48*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 32*f1^2*f6*f8 - 8*f1^2*f7^2 - 16*f1*f2*f5*f8 -
4*f1*f3*f5*f7)*x[1]*x[3]*x[6]*x[8] + (128*f0^2*f7*f8^2 + 128*f0*f1*f6*f8^2 -
64*f0*f1*f7^2*f8 - 256*f0*f2*f5*f8^2 + 320*f0*f2*f6*f7*f8 - 96*f0*f2*f7^3 +
128*f0*f3*f4*f8^2 - 32*f0*f3*f5*f7*f8 + 64*f0*f4*f5*f6*f8 - 16*f0*f4*f5*f7^2 -
16*f0*f5^3*f8 + 64*f1^2*f5*f8^2 - 64*f1^2*f6*f7*f8 + 16*f1^2*f7^3 -
16*f1*f2*f5*f7*f8 - 32*f1*f3^2*f8^2 - 16*f1*f3*f5*f6*f8 +
4*f1*f3*f5*f7^2)*x[1]*x[3]*x[7]^2 + (-64*f0*f2*f7*f8 - 32*f0*f3*f6*f8 +
32*f0*f3*f7^2 - 32*f0*f4*f5*f8 + 8*f0*f5^2*f7 + 8*f1^2*f7*f8 + 32*f1*f2*f6*f8 +
16*f1*f3*f5*f8)*x[1]*x[3]*x[7]*x[8] - 16*f1*f2*f8*x[1]*x[3]*x[8]^2 +
(-128*f0^2*f4*f8^2 + 96*f0^2*f5*f7*f8 + 96*f0*f1*f3*f8^2 - 128*f0*f1*f4*f7*f8 +
64*f0*f1*f5*f6*f8 + 16*f0*f1*f5*f7^2 + 64*f0*f2*f3*f7*f8 + 128*f0*f2*f4*f6*f8 -
64*f0*f2*f4*f7^2 - 32*f0*f2*f5^2*f8 + 32*f0*f2*f5*f6*f7 - 32*f0*f3^2*f6*f8 +
32*f0*f3^2*f7^2 + 32*f0*f3*f4*f5*f8 + 16*f1^2*f3*f7*f8 - 64*f1^2*f4*f6*f8 +
32*f1^2*f4*f7^2 + 32*f1^2*f5^2*f8 - 16*f1^2*f5*f6*f7 + 32*f1*f2*f3*f6*f8 -
16*f1*f2*f3*f7^2 - 8*f1*f3*f4*f5*f7)*x[1]*x[4]^3 + (128*f0^2*f6^2*f8 +
64*f0*f1*f4*f7*f8 - 48*f0*f1*f5*f7^2 + 32*f0*f1*f6^2*f7 + 128*f0*f2^2*f8^2 +
384*f0*f2*f4*f6*f8 - 64*f0*f2*f4*f7^2 - 96*f0*f2*f5^2*f8 + 32*f0*f2*f5*f6*f7 -
96*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 - 8*f0*f3*f5^2*f7 - 48*f1^2*f3*f7*f8 -
64*f1^2*f4*f6*f8 + 40*f1^2*f4*f7^2 + 16*f1^2*f5^2*f8 - 8*f1^2*f5*f6*f7 +
32*f1*f2^2*f7*f8 + 32*f1*f2*f3*f6*f8 - 8*f1*f2*f3*f7^2 -
8*f1*f3^2*f5*f8)*x[1]*x[4]^2*x[5] + (-192*f0^2*f6*f7*f8 + 64*f0^2*f7^3 +
128*f0*f1*f4*f8^2 + 112*f0*f1*f5*f7*f8 - 128*f0*f1*f6^2*f8 - 48*f0*f1*f6*f7^2 -
128*f0*f2*f3*f8^2 + 128*f0*f2*f4*f7*f8 - 64*f0*f2*f5*f6*f8 - 32*f0*f2*f5*f7^2 -
96*f0*f3^2*f7*f8 - 64*f0*f3*f4*f6*f8 - 16*f0*f3*f5^2*f8 - 16*f0*f3*f5*f6*f7 -
32*f1^2*f3*f8^2 - 96*f1^2*f4*f7*f8 + 16*f1^2*f5*f7^2 + 16*f1*f2*f3*f7*f8 -
32*f1*f3^2*f6*f8 + 4*f1*f3^2*f7^2 + 32*f1*f3*f4*f5*f8 +
4*f1*f3*f5^2*f7)*x[1]*x[4]^2*x[6] + (128*f0^2*f6*f8^2 - 192*f0*f1*f5*f8^2 +
160*f0*f1*f6*f7*f8 - 48*f0*f1*f7^3 + 128*f0*f2*f4*f8^2 - 192*f0*f2*f5*f7*f8 +
256*f0*f2*f6^2*f8 - 32*f0*f3^2*f8^2 + 64*f0*f3*f4*f7*f8 - 96*f0*f3*f5*f6*f8 -
32*f0*f3*f5*f7^2 + 32*f0*f3*f6^2*f7 + 128*f0*f4^2*f6*f8 - 32*f0*f4*f5^2*f8 +
32*f0*f4*f5*f6*f7 - 8*f0*f5^3*f7 + 64*f1^2*f4*f8^2 - 48*f1^2*f5*f7*f8 +
16*f1^2*f6*f7^2 - 64*f1*f2*f3*f8^2 + 64*f1*f2*f4*f7*f8 - 16*f1*f3^2*f7*f8 +
16*f1*f3*f4*f7^2 - 8*f1*f3*f5*f6*f7)*x[1]*x[4]^2*x[7] + (32*f0*f1*f7*f8 -
128*f0*f2*f6*f8 - 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 - 16*f0*f4*f5*f7 - 8*f1^2*f7^2
- 16*f1*f2*f5*f8 - 16*f1*f3*f4*f8 + 12*f1*f3*f5*f7)*x[1]*x[4]^2*x[8] +
(-64*f0^2*f5*f7*f8 + 32*f0^2*f6*f7^2 - 64*f0*f1*f3*f8^2 + 96*f0*f1*f4*f7*f8 +
24*f0*f1*f5*f7^2 + 32*f1^2*f2*f8^2 + 24*f1^2*f3*f7*f8)*x[1]*x[4]*x[5]^2 +
(128*f0^2*f5*f8^2 - 128*f0^2*f6*f7*f8 - 64*f0^2*f7^3 - 128*f0*f1*f4*f8^2 +
32*f0*f1*f5*f7*f8 - 32*f0*f1*f6*f7^2 - 64*f0*f2*f3*f8^2 - 64*f0*f2*f4*f7*f8 -
128*f0*f2*f5*f6*f8 - 16*f0*f2*f5*f7^2 + 32*f0*f3^2*f7*f8 + 32*f0*f3*f5^2*f8 +
96*f1^2*f3*f8^2 - 64*f1^2*f4*f7*f8 + 32*f1^2*f5*f6*f8 - 8*f1^2*f5*f7^2 -
64*f1*f2^2*f8^2 - 32*f1*f2*f3*f7*f8)*x[1]*x[4]*x[5]*x[6] + (-128*f0^2*f6*f8^2 +
64*f0^2*f7^2*f8 - 64*f0*f1*f5*f8^2 + 40*f0*f1*f7^3 - 256*f0*f2*f4*f8^2 +
32*f0*f2*f5*f7*f8 + 32*f0*f2*f6*f7^2 + 64*f0*f3^2*f8^2 - 32*f0*f3*f5*f6*f8 +
24*f0*f3*f5*f7^2 + 64*f1^2*f4*f8^2 + 24*f1^2*f5*f7*f8 - 32*f1*f2*f3*f8^2 +
32*f1*f2*f4*f7*f8 + 16*f1*f3^2*f7*f8 + 8*f1*f3*f5^2*f8)*x[1]*x[4]*x[5]*x[7] +
(64*f0^2*f8^2 - 16*f0*f1*f7*f8 - 64*f0*f2*f6*f8 - 32*f0*f2*f7^2 + 16*f0*f3*f5*f8
- 32*f1^2*f6*f8 - 4*f1^2*f7^2)*x[1]*x[4]*x[5]*x[8] + (128*f0^2*f6*f8^2 -
64*f0^2*f7^2*f8 - 160*f0*f1*f5*f8^2 + 128*f0*f1*f6*f7*f8 + 48*f0*f1*f7^3 -
128*f0*f2*f4*f8^2 + 96*f0*f2*f5*f7*f8 + 128*f0*f3^2*f8^2 + 96*f0*f3*f5*f6*f8 +
128*f1^2*f4*f8^2 + 16*f1*f3^2*f7*f8 - 24*f1*f3*f5^2*f8)*x[1]*x[4]*x[6]^2 +
(128*f0*f1*f6*f8^2 - 128*f0*f1*f7^2*f8 + 256*f0*f2*f5*f8^2 - 256*f0*f2*f6*f7*f8
- 128*f0*f3*f4*f8^2 + 96*f0*f3*f5*f7*f8 - 32*f0*f3*f6*f7^2 - 128*f0*f4*f5*f6*f8
- 32*f0*f4*f5*f7^2 + 32*f0*f5^3*f8 - 16*f1^2*f7^3 - 128*f1*f2*f4*f8^2 -
32*f1*f2*f5*f7*f8 + 64*f1*f3^2*f8^2 - 64*f1*f3*f4*f7*f8 +
32*f1*f3*f5*f6*f8)*x[1]*x[4]*x[6]*x[7] + (-64*f0*f1*f8^2 + 64*f0*f2*f7*f8 +
128*f0*f3*f6*f8 + 32*f0*f4*f6*f7 + 40*f1^2*f7*f8 + 32*f1*f2*f6*f8 -
24*f1*f3*f5*f8)*x[1]*x[4]*x[6]*x[8] + (-32*f0*f1*f7*f8^2 - 256*f0*f2*f6*f8^2 +
128*f0*f2*f7^2*f8 + 128*f0*f3*f5*f8^2 - 96*f0*f3*f6*f7*f8 + 48*f0*f3*f7^3 -
128*f0*f4^2*f8^2 + 64*f0*f4*f5*f7*f8 + 24*f0*f5^2*f7^2 - 64*f1^2*f6*f8^2 +
48*f1^2*f7^2*f8 + 64*f1*f2*f5*f8^2 + 32*f1*f3*f4*f8^2 +
16*f1*f3*f5*f7*f8)*x[1]*x[4]*x[7]^2 + (64*f0*f2*f8^2 - 64*f0*f4*f6*f8 -
32*f0*f4*f7^2 + 32*f0*f5^2*f8 - 32*f0*f5*f6*f7 - 32*f1*f2*f7*f8 - 16*f1*f3*f6*f8
- 8*f1*f3*f7^2)*x[1]*x[4]*x[7]*x[8] + (16*f0*f5*f7 +
16*f1*f3*f8)*x[1]*x[4]*x[8]^2 + (-128*f0^2*f4*f8^2 + 96*f0^2*f5*f7*f8 +
96*f0*f1*f3*f8^2)*x[1]*x[5]^3 + (-16*f0^2*f7^3 - 96*f0*f1*f5*f7*f8 -
80*f1^2*f3*f8^2)*x[1]*x[5]^2*x[6] + (-128*f0^2*f6*f8^2 + 32*f0^2*f7^2*f8 +
64*f0*f1*f5*f8^2 + 8*f0*f1*f7^3 - 256*f0*f2*f4*f8^2 + 96*f0*f2*f5*f7*f8 -
128*f0*f2*f6^2*f8 + 32*f0*f2*f6*f7^2 + 64*f0*f3^2*f8^2 + 32*f0*f3*f5*f6*f8 -
8*f0*f3*f5*f7^2 + 96*f1^2*f4*f8^2 - 24*f1^2*f5*f7*f8 + 32*f1^2*f6^2*f8 -
8*f1^2*f6*f7^2)*x[1]*x[5]^2*x[7] + (-32*f0*f1*f7*f8 + 64*f0*f2*f6*f8 -
16*f0*f2*f7^2 - 16*f0*f3*f5*f8 - 16*f1^2*f6*f8 + 4*f1^2*f7^2)*x[1]*x[5]^2*x[8] +
(128*f0^2*f6*f8^2 + 128*f0^2*f7^2*f8 + 96*f0*f1*f5*f8^2 + 8*f0*f1*f7^3 +
128*f0*f2*f4*f8^2 + 128*f0*f2*f6^2*f8 - 32*f0*f2*f6*f7^2 - 64*f0*f3^2*f8^2 -
32*f0*f3*f5*f6*f8 + 8*f0*f3*f5*f7^2 + 24*f1^2*f5*f7*f8 - 32*f1^2*f6^2*f8 +
8*f1^2*f6*f7^2 + 64*f1*f2*f3*f8^2)*x[1]*x[5]*x[6]^2 + (-256*f0^2*f7*f8^2 -
128*f0*f1*f6*f8^2 - 48*f0*f1*f7^2*f8 + 64*f0*f2*f5*f8^2 - 64*f0*f2*f6*f7*f8 +
128*f0*f3*f4*f8^2 - 80*f0*f3*f5*f7*f8 + 64*f0*f3*f6^2*f8 - 16*f0*f3*f6*f7^2 -
96*f1^2*f5*f8^2 + 16*f1^2*f6*f7*f8 - 4*f1^2*f7^3 - 64*f1*f2*f4*f8^2 -
32*f1*f3^2*f8^2 - 16*f1*f3*f5*f6*f8 + 4*f1*f3*f5*f7^2)*x[1]*x[5]*x[6]*x[7] +
(64*f0*f1*f8^2 + 32*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 + 24*f1^2*f7*f8
+ 8*f1*f3*f5*f8)*x[1]*x[5]*x[6]*x[8] + (96*f0*f1*f7*f8^2 - 128*f0*f2*f6*f8^2 +
64*f0*f2*f7^2*f8 + 64*f0*f3*f5*f8^2 - 128*f0*f4^2*f8^2 + 64*f0*f4*f5*f7*f8 -
128*f0*f4*f6^2*f8 + 32*f0*f4*f6*f7^2 + 32*f0*f5^2*f6*f8 - 8*f0*f5^2*f7^2 +
64*f1^2*f6*f8^2 - 16*f1^2*f7^2*f8 + 32*f1*f2*f5*f8^2 + 32*f1*f3*f4*f8^2 -
16*f1*f3*f5*f7*f8 + 32*f1*f3*f6^2*f8 - 8*f1*f3*f6*f7^2)*x[1]*x[5]*x[7]^2 +
(64*f0*f2*f8^2 - 32*f0*f3*f7*f8 + 128*f0*f4*f6*f8 - 32*f0*f4*f7^2 -
32*f0*f5^2*f8 - 32*f1^2*f8^2 - 16*f1*f2*f7*f8 - 32*f1*f3*f6*f8 +
8*f1*f3*f7^2)*x[1]*x[5]*x[7]*x[8] + (-64*f0*f1*f6*f8^2 - 64*f0*f1*f7^2*f8 -
64*f0*f2*f5*f8^2 - 64*f0*f3*f6^2*f8 + 16*f0*f3*f6*f7^2 - 32*f1^2*f5*f8^2 -
16*f1*f3^2*f8^2 + 16*f1*f3*f5*f6*f8 - 4*f1*f3*f5*f7^2)*x[1]*x[6]^3 +
(224*f0*f1*f7*f8^2 + 256*f0*f2*f6*f8^2 - 96*f0*f3*f5*f8^2 + 32*f0*f3*f6*f7*f8 +
32*f0*f4*f5*f7*f8 + 128*f0*f4*f6^2*f8 - 32*f0*f4*f6*f7^2 - 32*f0*f5^2*f6*f8 +
8*f0*f5^2*f7^2 + 64*f1^2*f6*f8^2 + 64*f1*f2*f5*f8^2 + 32*f1*f3*f4*f8^2 +
8*f1*f3*f5*f7*f8 - 32*f1*f3*f6^2*f8 + 8*f1*f3*f6*f7^2)*x[1]*x[6]^2*x[7] +
(-64*f0*f2*f8^2 - 16*f0*f3*f7*f8 - 64*f0*f4*f6*f8 + 16*f0*f5^2*f8 - 48*f1^2*f8^2
- 16*f1*f2*f7*f8 + 16*f1*f3*f6*f8 - 4*f1*f3*f7^2)*x[1]*x[6]^2*x[8] +
(-128*f0*f1*f8^3 - 128*f0*f2*f7*f8^2 - 64*f0*f3*f6*f8^2 - 32*f0*f3*f7^2*f8 +
128*f0*f4*f5*f8^2 - 64*f0*f4*f6*f7*f8 + 16*f0*f4*f7^3 - 80*f0*f5^2*f7*f8 -
64*f1^2*f7*f8^2 - 128*f1*f2*f6*f8^2 + 32*f1*f2*f7^2*f8 - 64*f1*f3*f5*f8^2 +
16*f1*f3*f6*f7*f8 - 4*f1*f3*f7^3)*x[1]*x[6]*x[7]^2 + (32*f0*f4*f7*f8 +
40*f0*f5*f7^2 + 96*f1*f2*f8^2 + 24*f1*f3*f7*f8)*x[1]*x[6]*x[7]*x[8] -
16*f0*f6*f7*x[1]*x[6]*x[8]^2 + (64*f0*f3*f7*f8^2 - 32*f0*f5^2*f8^2 +
96*f0*f5*f6*f7*f8 - 24*f0*f5*f7^3 + 64*f1^2*f8^3 + 64*f1*f3*f6*f8^2 -
16*f1*f3*f7^2*f8)*x[1]*x[7]^3 + (64*f0*f4*f8^2 - 96*f0*f5*f7*f8 -
64*f1*f3*f8^2)*x[1]*x[7]^2*x[8] + 16*f0*f7^2*x[1]*x[7]*x[8]^2 + (16*f0^2*f2*f6 -
16*f0^2*f3*f5 + 16*f0^2*f4^2 - 4*f0*f1^2*f6 + 8*f0*f1*f2*f5 - 8*f0*f1*f3*f4 +
16*f0*f2^2*f4 - 4*f0*f2*f3^2 - 2*f1^3*f5 - 4*f1^2*f2*f4 + f1^2*f3^2)*x[2]^4 +
(32*f0^2*f3*f6 - 32*f0^2*f4*f5 - 32*f0*f1*f2*f6 + 16*f0*f1*f3*f5 - 32*f0*f2^2*f5
+ 8*f1^3*f6 + 8*f1^2*f2*f5)*x[2]^3*x[3] + (-64*f0^2*f4*f6 + 32*f0^2*f5^2 -
16*f0*f1^2*f8 + 16*f0*f1*f3*f6 + 16*f0*f2*f3*f5 - 4*f1^2*f3*f5)*x[2]^3*x[4] +
(-32*f0^2*f3*f7 - 16*f0*f1^2*f8 + 16*f0*f1*f2*f7 - 4*f1^3*f7)*x[2]^3*x[5] +
(32*f0^2*f4*f7 - 32*f0*f1*f2*f8 + 16*f1^3*f8)*x[2]^3*x[6] + (-32*f0^2*f5*f7 -
16*f0*f1*f3*f8)*x[2]^3*x[7] + (-32*f0*f2*f4 + 8*f0*f3^2 + 8*f1^2*f4)*x[2]^3*x[8]
+ (64*f0^2*f2*f8 - 48*f0^2*f3*f7 + 32*f0^2*f4*f6 + 16*f0^2*f5^2 + 40*f0*f1*f2*f7
- 24*f0*f1*f3*f6 + 64*f0*f2^2*f6 + 8*f0*f2*f3*f5 - 10*f1^3*f7 - 16*f1^2*f2*f6 -
2*f1^2*f3*f5)*x[2]^2*x[3]^2 + (-64*f0^2*f3*f8 + 128*f0^2*f4*f7 - 64*f0^2*f5*f6 +
64*f0*f1*f2*f8 - 24*f0*f1*f3*f7 + 32*f0*f1*f4*f6 - 16*f0*f1*f5^2 -
64*f0*f2*f3*f6 - 8*f0*f3^2*f5 - 16*f1^3*f8 + 8*f1^2*f3*f6)*x[2]^2*x[3]*x[4] +
(64*f0^2*f3*f8 - 64*f0*f1*f2*f8 + 24*f0*f1*f3*f7 - 64*f0*f2^2*f7 + 24*f1^3*f8 +
16*f1^2*f2*f7)*x[2]^2*x[3]*x[5] + (-128*f0^2*f4*f8 + 32*f0^2*f5*f7 +
80*f0*f1*f3*f8 - 32*f0*f1*f4*f7 + 32*f0*f2*f3*f7 - 16*f1^2*f2*f8 -
4*f1^2*f3*f7)*x[2]^2*x[3]*x[6] + (64*f0^2*f5*f8 + 32*f0^2*f6*f7 + 16*f0*f1*f5*f7
+ 16*f1^2*f3*f8)*x[2]^2*x[3]*x[7] + (-32*f0^2*f7 + 48*f0*f2*f5 -
12*f1^2*f5)*x[2]^2*x[3]*x[8] + (32*f0^2*f4*f8 - 32*f0^2*f5*f7 + 64*f0^2*f6^2 +
24*f0*f1*f3*f8 - 24*f0*f1*f4*f7 + 96*f0*f2*f4*f6 - 32*f0*f2*f5^2 - 16*f0*f3^2*f6
+ 8*f0*f3*f4*f5 - 16*f1^2*f2*f8 + 4*f1^2*f3*f7 - 32*f1^2*f4*f6 + 12*f1^2*f5^2 +
8*f1*f2*f3*f6)*x[2]^2*x[4]^2 + (-64*f0^2*f4*f8 + 64*f0^2*f5*f7 + 32*f0*f1*f3*f8
- 32*f0*f1*f4*f7 + 32*f0*f2*f3*f7 - 16*f1^2*f2*f8 -
4*f1^2*f3*f7)*x[2]^2*x[4]*x[5] + (64*f0^2*f5*f8 - 96*f0^2*f6*f7 - 16*f0*f1*f5*f7
- 64*f0*f2*f4*f7 + 8*f0*f3^2*f7 - 40*f1^2*f3*f8 + 32*f1^2*f4*f7 + 32*f1*f2^2*f8
- 8*f1*f2*f3*f7)*x[2]^2*x[4]*x[6] + (-64*f0^2*f6*f8 + 64*f0^2*f7^2 +
64*f0*f2*f4*f8 + 16*f0*f2*f5*f7 - 16*f0*f3^2*f8 - 16*f1^2*f4*f8 - 12*f1^2*f5*f7
- 16*f1*f2*f3*f8)*x[2]^2*x[4]*x[7] + (8*f0*f1*f7 - 32*f0*f2*f6 - 16*f0*f3*f5 +
8*f1^2*f6)*x[2]^2*x[4]*x[8] + (32*f0^2*f4*f8 - 8*f0*f1*f3*f8 + 64*f0*f2^2*f8 -
16*f1^2*f2*f8)*x[2]^2*x[5]^2 + (-64*f0^2*f5*f8 - 32*f0^2*f6*f7 -
64*f0*f2*f3*f8)*x[2]^2*x[5]*x[6] + (64*f0^2*f6*f8 + 64*f0*f2*f4*f8 -
16*f0*f2*f5*f7 - 16*f0*f3^2*f8 - 16*f1^2*f4*f8 + 4*f1^2*f5*f7)*x[2]^2*x[5]*x[7]
+ 8*f0*f1*f7*x[2]^2*x[5]*x[8] + (64*f0^2*f6*f8 + 16*f0^2*f7^2 + 16*f0*f1*f5*f8 +
16*f0*f1*f6*f7 + 32*f0*f2*f4*f8 + 16*f0*f2*f5*f7 - 4*f1^2*f5*f7 +
8*f1*f2*f3*f8)*x[2]^2*x[6]^2 + (-64*f0^2*f7*f8 - 64*f0*f1*f6*f8 - 16*f0*f1*f7^2
- 96*f0*f2*f5*f8 + 16*f1^2*f5*f8)*x[2]^2*x[6]*x[7] + (32*f0*f1*f8 -
4*f1^2*f7)*x[2]^2*x[6]*x[8] + (32*f0^2*f8^2 + 8*f0*f1*f7*f8 + 64*f0*f2*f6*f8 +
8*f0*f3*f5*f8 + 4*f1^2*f7^2)*x[2]^2*x[7]^2 + (-32*f0*f2*f8 +
8*f1^2*f8)*x[2]^2*x[7]*x[8] + (8*f0*f4 - 2*f1*f3)*x[2]^2*x[8]^2 +
(-32*f0^2*f5*f6 - 32*f0*f1*f2*f8 + 8*f0*f1*f3*f7 - 32*f0*f2^2*f7 -
32*f0*f2*f3*f6 + 8*f1^2*f2*f7 + 8*f1^2*f3*f6)*x[2]*x[3]^3 + (-80*f0^2*f5*f7 +
64*f0^2*f6^2 - 48*f0*f1*f3*f8 - 32*f0*f1*f4*f7 + 32*f0*f1*f5*f6 + 48*f0*f2*f3*f7
+ 48*f0*f3^2*f6 + 32*f1^2*f2*f8 - 4*f1^2*f3*f7)*x[2]*x[3]^2*x[4] +
(-16*f0^2*f5*f7 - 48*f0*f1*f3*f8 + 64*f0*f2^2*f8 + 48*f0*f2*f3*f7 -
16*f1^2*f2*f8 - 12*f1^2*f3*f7)*x[2]*x[3]^2*x[5] + (64*f0^2*f5*f8 - 32*f0^2*f6*f7
+ 32*f0*f1*f4*f8 + 8*f0*f1*f5*f7 - 32*f0*f2*f3*f8 - 24*f0*f3^2*f7 +
8*f1^2*f3*f8)*x[2]*x[3]^2*x[6] + (-128*f0^2*f6*f8 + 16*f0^2*f7^2 -
16*f0*f1*f5*f8 - 16*f0*f1*f6*f7 - 64*f0*f2*f4*f8 + 16*f0*f2*f5*f7 +
16*f0*f3^2*f8 - 4*f1^2*f5*f7)*x[2]*x[3]^2*x[7] + (8*f0*f1*f7 - 64*f0*f2*f6 -
8*f0*f3*f5 + 16*f1^2*f6)*x[2]*x[3]^2*x[8] + (96*f0^2*f5*f8 - 64*f0^2*f6*f7 +
88*f0*f1*f5*f7 - 64*f0*f1*f6^2 - 64*f0*f2*f4*f7 + 32*f0*f2*f5*f6 -
64*f0*f3*f4*f6 + 8*f0*f3*f5^2 + 32*f1^2*f3*f8 + 24*f1^2*f4*f7 - 16*f1^2*f5*f6 -
32*f1*f2^2*f8 - 8*f1*f2*f3*f7 - 8*f1*f3^2*f6)*x[2]*x[3]*x[4]^2 + (-32*f0^2*f6*f7
+ 96*f0*f1*f4*f8 + 8*f0*f1*f5*f7 - 64*f0*f2*f3*f8 - 48*f0*f3^2*f7 +
24*f1^2*f3*f8)*x[2]*x[3]*x[4]*x[5] + (-64*f0^2*f6*f8 + 64*f0^2*f7^2 -
128*f0*f1*f5*f8 + 64*f0*f1*f6*f7 + 192*f0*f2*f4*f8 - 48*f0*f2*f5*f7 -
32*f0*f3^2*f8 + 64*f0*f3*f4*f7 - 64*f1^2*f4*f8 + 8*f1^2*f5*f7 +
8*f1*f3^2*f7)*x[2]*x[3]*x[4]*x[6] + (-64*f0^2*f7*f8 + 192*f0*f1*f6*f8 -
56*f0*f1*f7^2 - 64*f0*f2*f5*f8 + 32*f0*f2*f6*f7 - 24*f0*f3*f5*f7 + 32*f1^2*f5*f8
+ 32*f1*f2*f4*f8)*x[2]*x[3]*x[4]*x[7] + (-64*f0*f1*f8 + 80*f0*f3*f6 - 4*f1^2*f7
+ 4*f1*f3*f5)*x[2]*x[3]*x[4]*x[8] + (-32*f0^2*f5*f8 + 32*f0^2*f6*f7 -
64*f0*f2*f3*f8 + 16*f1^2*f3*f8)*x[2]*x[3]*x[5]^2 + (64*f0^2*f6*f8 + 64*f0^2*f7^2
+ 32*f0*f1*f5*f8 - 16*f0*f1*f6*f7 + 64*f0*f3^2*f8)*x[2]*x[3]*x[5]*x[6] +
(-64*f0^2*f7*f8 - 32*f0*f1*f6*f8 - 8*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 8*f0*f3*f5*f7
+ 16*f1^2*f5*f8)*x[2]*x[3]*x[5]*x[7] + (64*f0*f2*f7 -
16*f1^2*f7)*x[2]*x[3]*x[5]*x[8] + (-64*f0^2*f7*f8 - 32*f0*f1*f6*f8 -
32*f0*f1*f7^2 - 32*f0*f2*f5*f8 - 32*f0*f3*f4*f8 - 8*f0*f3*f5*f7 - 8*f1^2*f5*f8 -
8*f1*f3^2*f8)*x[2]*x[3]*x[6]^2 + (192*f0^2*f8^2 + 112*f0*f1*f7*f8 +
192*f0*f2*f6*f8 - 32*f0*f2*f7^2 + 48*f0*f3*f5*f8 - 32*f1^2*f6*f8 +
12*f1^2*f7^2)*x[2]*x[3]*x[6]*x[7] + (-32*f0*f2*f8 -
32*f0*f3*f7)*x[2]*x[3]*x[6]*x[8] + (-64*f0*f1*f8^2 - 64*f0*f2*f7*f8 -
96*f0*f3*f6*f8 + 16*f0*f3*f7^2 - 16*f1^2*f7*f8)*x[2]*x[3]*x[7]^2 + (32*f0*f3*f8
- 16*f1*f2*f8)*x[2]*x[3]*x[7]*x[8] - 8*f0*f5*x[2]*x[3]*x[8]^2 + (-64*f0^2*f6*f8
- 32*f0*f1*f5*f8 + 16*f0*f1*f6*f7 - 64*f0*f2*f4*f8 + 64*f0*f2*f5*f7 -
64*f0*f2*f6^2 + 16*f0*f3^2*f8 + 16*f0*f3*f5*f6 - 32*f1^2*f5*f7 + 32*f1^2*f6^2 +
16*f1*f2*f3*f8 + 4*f1*f3^2*f7 + 16*f1*f3*f4*f6 - 4*f1*f3*f5^2)*x[2]*x[4]^3 +
(64*f0^2*f6*f8 - 32*f0^2*f7^2 - 64*f0*f1*f5*f8 + 16*f0*f1*f6*f7 - 48*f0*f2*f5*f7
+ 16*f0*f3^2*f8 + 32*f0*f3*f4*f7 - 32*f1^2*f4*f8 + 12*f1^2*f5*f7 +
4*f1*f3^2*f7)*x[2]*x[4]^2*x[5] + (32*f0^2*f7*f8 + 64*f0*f1*f6*f8 -
96*f0*f2*f5*f8 + 96*f0*f2*f6*f7 + 96*f1^2*f5*f8 - 48*f1^2*f6*f7 -
24*f1*f3*f4*f7)*x[2]*x[4]^2*x[6] + (64*f0^2*f8^2 - 16*f0*f1*f7*f8 +
64*f0*f2*f6*f8 - 96*f0*f2*f7^2 + 32*f0*f3*f5*f8 - 16*f0*f3*f6*f7 -
16*f0*f4*f5*f7 - 96*f1^2*f6*f8 + 40*f1^2*f7^2 - 16*f1*f2*f5*f8 - 16*f1*f3*f4*f8
+ 12*f1*f3*f5*f7)*x[2]*x[4]^2*x[7] + (-32*f0*f4*f6 + 8*f0*f5^2 + 32*f1^2*f8 -
16*f1*f3*f6)*x[2]*x[4]^2*x[8] + (16*f0^2*f7^2 - 16*f0*f1*f6*f7 +
32*f0*f3^2*f8)*x[2]*x[4]*x[5]^2 + (-24*f0*f1*f7^2 + 96*f0*f2*f5*f8 +
32*f0*f2*f6*f7 - 96*f0*f3*f4*f8 - 16*f1^2*f5*f8 -
8*f1*f3^2*f8)*x[2]*x[4]*x[5]*x[6] + (-64*f0^2*f8^2 + 48*f0*f1*f7*f8 -
128*f0*f2*f6*f8 + 32*f0*f2*f7^2 + 48*f0*f3*f5*f8 - 16*f0*f3*f6*f7 +
32*f1^2*f6*f8 - 8*f1^2*f7^2 - 16*f1*f2*f5*f8 -
4*f1*f3*f5*f7)*x[2]*x[4]*x[5]*x[7] + (32*f0*f2*f8 - 32*f0*f3*f7 +
16*f1^2*f8)*x[2]*x[4]*x[5]*x[8] + (-16*f0*f1*f7*f8 - 64*f0*f2*f6*f8 -
32*f0*f2*f7^2 + 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 16*f1^2*f7^2 + 32*f1*f3*f4*f8
+ 4*f1*f3*f5*f7)*x[2]*x[4]*x[6]^2 + (-64*f0*f1*f8^2 + 192*f0*f2*f7*f8 -
64*f0*f3*f6*f8 + 32*f0*f3*f7^2 + 32*f0*f4*f6*f7 - 56*f1^2*f7*f8 + 32*f1*f2*f6*f8
- 24*f1*f3*f5*f8)*x[2]*x[4]*x[6]*x[7] + (-32*f1*f2*f8 +
16*f1*f3*f7)*x[2]*x[4]*x[6]*x[8] + (-64*f0*f2*f8^2 + 64*f0*f4*f6*f8 -
16*f0*f4*f7^2 - 16*f0*f5^2*f8 - 16*f0*f5*f6*f7 + 64*f1^2*f8^2 + 16*f1*f3*f6*f8 -
12*f1*f3*f7^2)*x[2]*x[4]*x[7]^2 + (-32*f0*f4*f8 + 24*f0*f5*f7 +
24*f1*f3*f8)*x[2]*x[4]*x[7]*x[8] + 16*f0*f6*x[2]*x[4]*x[8]^2 -
16*f0^2*f7^2*x[2]*x[5]^3 + (-96*f0^2*f7*f8 + 16*f0*f1*f7^2)*x[2]*x[5]^2*x[6] +
(64*f0^2*f8^2 + 32*f0*f1*f7*f8 + 64*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 16*f0*f3*f5*f8
- 16*f1^2*f6*f8 + 4*f1^2*f7^2)*x[2]*x[5]^2*x[7] + (-64*f0*f2*f8 +
8*f1^2*f8)*x[2]*x[5]^2*x[8] + (48*f0*f1*f7*f8 - 64*f0*f2*f6*f8 + 16*f0*f3*f5*f8
+ 16*f1^2*f6*f8 - 4*f1^2*f7^2)*x[2]*x[5]*x[6]^2 + (-64*f0*f1*f8^2 -
32*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 - 8*f1^2*f7*f8 +
8*f1*f3*f5*f8)*x[2]*x[5]*x[6]*x[7] + (64*f0*f3*f8 +
16*f1*f2*f8)*x[2]*x[5]*x[6]*x[8] + (64*f0*f2*f8^2 + 64*f0*f4*f6*f8 -
16*f0*f4*f7^2 - 16*f0*f5^2*f8 - 16*f1*f3*f6*f8 + 4*f1*f3*f7^2)*x[2]*x[5]*x[7]^2
+ (-32*f0*f4*f8 + 8*f0*f5*f7 + 8*f1*f3*f8)*x[2]*x[5]*x[7]*x[8] + (32*f0*f2*f7*f8
+ 32*f0*f3*f6*f8 - 8*f1*f3*f5*f8)*x[2]*x[6]^3 + (-128*f0*f2*f8^2 -
16*f0*f3*f7*f8 - 64*f0*f4*f6*f8 + 16*f0*f5^2*f8 + 16*f1^2*f8^2 - 16*f1*f2*f7*f8
+ 16*f1*f3*f6*f8 - 4*f1*f3*f7^2)*x[2]*x[6]^2*x[7] + (-8*f0*f5*f7 -
24*f1*f3*f8)*x[2]*x[6]^2*x[8] + (64*f0*f3*f8^2 + 16*f0*f5*f7^2 + 32*f1*f2*f8^2 +
16*f1*f3*f7*f8)*x[2]*x[6]*x[7]^2 + (32*f0*f5*f8 -
16*f0*f6*f7)*x[2]*x[6]*x[7]*x[8] + 8*f0*f7*x[2]*x[6]*x[8]^2 + (-16*f0*f5*f7*f8 -
32*f1*f3*f8^2)*x[2]*x[7]^3 + (-32*f0*f6*f8 + 8*f0*f7^2)*x[2]*x[7]^2*x[8] +
16*f0*f8*x[2]*x[7]*x[8]^2 + (16*f0^2*f5*f7 + 16*f0^2*f6^2 + 16*f0*f1*f3*f8 +
16*f0*f2^2*f8 + 8*f0*f2*f3*f7 + 16*f0*f2*f4*f6 - 4*f0*f2*f5^2 - 4*f1^2*f2*f8 -
2*f1^2*f3*f7 - 4*f1^2*f4*f6 + f1^2*f5^2)*x[3]^4 + (-32*f0^2*f6*f7 -
32*f0*f1*f6^2 - 32*f0*f2*f3*f8 - 16*f0*f3^2*f7 - 32*f0*f3*f4*f6 + 8*f0*f3*f5^2 -
16*f1^2*f3*f8)*x[3]^3*x[4] + (-32*f0^2*f6*f7 - 32*f0*f2*f3*f8 - 32*f0*f2*f4*f7 +
8*f1^2*f3*f8 + 8*f1^2*f4*f7)*x[3]^3*x[5] + (16*f0^2*f7^2 - 16*f0*f1*f5*f8 +
16*f0*f1*f6*f7 + 16*f0*f3^2*f8 + 16*f0*f3*f4*f7)*x[3]^3*x[6] + (32*f0*f1*f6*f8 +
32*f0*f2*f5*f8 - 8*f0*f3*f5*f7)*x[3]^3*x[7] + (16*f0*f2*f7 + 16*f0*f3*f6 -
4*f1^2*f7)*x[3]^3*x[8] + (32*f0^2*f6*f8 + 64*f0^2*f7^2 + 40*f0*f1*f6*f7 +
64*f0*f2*f4*f8 - 16*f0*f2*f5*f7 + 32*f0*f2*f6^2 + 32*f0*f3*f4*f7 -
24*f0*f3*f5*f6 + 64*f0*f4^2*f6 - 16*f0*f4*f5^2 - 12*f1^2*f5*f7 + 16*f1^2*f6^2 +
24*f1*f2*f3*f8 + 4*f1*f3^2*f7 + 8*f1*f3*f4*f6 - 2*f1*f3*f5^2)*x[3]^2*x[4]^2 +
(64*f0^2*f6*f8 - 16*f0^2*f7^2 - 48*f0*f1*f5*f8 + 48*f0*f1*f6*f7 + 48*f0*f3^2*f8
+ 48*f0*f3*f4*f7)*x[3]^2*x[4]*x[5] + (-64*f0^2*f7*f8 - 40*f0*f1*f7^2 -
32*f0*f2*f5*f8 - 32*f0*f2*f6*f7 - 64*f0*f3*f4*f8 + 24*f0*f3*f5*f7 -
64*f0*f4^2*f7 + 32*f1^2*f5*f8 - 16*f1^2*f6*f7 - 8*f1*f3^2*f8 -
8*f1*f3*f4*f7)*x[3]^2*x[4]*x[6] + (-16*f0*f1*f7*f8 - 64*f0*f2*f6*f8 +
16*f0*f3*f5*f8 + 32*f0*f4*f5*f7 - 32*f1^2*f6*f8 + 16*f1^2*f7^2 - 16*f1*f2*f5*f8
+ 4*f1*f3*f5*f7)*x[3]^2*x[4]*x[7] + (-32*f0*f2*f8 - 24*f0*f3*f7 - 64*f0*f4*f6 +
16*f0*f5^2 - 8*f1*f3*f6)*x[3]^2*x[4]*x[8] + (32*f0^2*f6*f8 + 64*f0*f2*f4*f8 +
8*f0*f2*f5*f7 - 16*f1^2*f4*f8 - 2*f1^2*f5*f7)*x[3]^2*x[5]^2 + (-64*f0^2*f7*f8 -
32*f0*f1*f6*f8 - 16*f0*f1*f7^2 - 64*f0*f3*f4*f8 -
8*f0*f3*f5*f7)*x[3]^2*x[5]*x[6] + (48*f0*f1*f7*f8 - 64*f0*f2*f6*f8 +
16*f0*f2*f7^2 + 16*f0*f3*f5*f8 - 4*f1^2*f7^2)*x[3]^2*x[5]*x[7] + (-32*f0*f2*f8 -
24*f0*f3*f7 + 16*f1^2*f8)*x[3]^2*x[5]*x[8] + (32*f0^2*f8^2 + 40*f0*f1*f7*f8 +
32*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 8*f0*f3*f5*f8 + 32*f0*f4^2*f8 + 8*f0*f4*f5*f7 +
16*f1^2*f6*f8 + 4*f1^2*f7^2 + 8*f1*f3*f4*f8)*x[3]^2*x[6]^2 + (-64*f0*f1*f8^2 -
32*f0*f2*f7*f8 - 32*f0*f3*f6*f8 - 8*f0*f3*f7^2 - 32*f0*f4*f5*f8 - 8*f0*f5^2*f7 -
32*f1^2*f7*f8 - 8*f1*f3*f5*f8)*x[3]^2*x[6]*x[7] + (32*f0*f3*f8 + 32*f0*f4*f7 +
4*f1*f3*f7)*x[3]^2*x[6]*x[8] + (64*f0*f2*f8^2 + 16*f0*f3*f7*f8 + 32*f0*f4*f6*f8
+ 8*f0*f5*f6*f7 + 16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 16*f1*f3*f6*f8 -
4*f1*f3*f7^2)*x[3]^2*x[7]^2 + (-24*f0*f5*f7 - 8*f1*f3*f8)*x[3]^2*x[7]*x[8] +
8*f0*f6*x[3]^2*x[8]^2 + (-64*f0^2*f7*f8 - 32*f0*f1*f6*f8 - 48*f0*f1*f7^2 -
48*f0*f3*f5*f7 + 32*f0*f3*f6^2 - 32*f0*f4*f5*f6 + 8*f0*f5^3 - 16*f1^2*f6*f7 -
32*f1*f2*f4*f8 + 32*f1*f2*f5*f7 - 32*f1*f2*f6^2 - 16*f1*f3^2*f8 - 16*f1*f3*f4*f7
+ 16*f1*f3*f5*f6 - 32*f1*f4^2*f6 + 8*f1*f4*f5^2)*x[3]*x[4]^3 + (-64*f0^2*f7*f8 -
64*f0*f1*f6*f8 + 8*f0*f1*f7^2 + 64*f0*f2*f5*f8 - 32*f0*f2*f6*f7 - 64*f0*f3*f4*f8
+ 24*f0*f3*f5*f7 - 64*f0*f4^2*f7 + 16*f1^2*f5*f8 - 16*f1^2*f6*f7 - 8*f1*f3^2*f8
- 8*f1*f3*f4*f7)*x[3]*x[4]^2*x[5] + (64*f0^2*f8^2 + 96*f0*f1*f7*f8 +
96*f0*f3*f5*f8 - 48*f0*f3*f6*f7 + 48*f0*f4*f5*f7 + 24*f1^2*f7^2 - 48*f1*f2*f5*f8
+ 48*f1*f2*f6*f7 + 48*f1*f3*f4*f8 - 24*f1*f3*f5*f7 +
48*f1*f4^2*f7)*x[3]*x[4]^2*x[6] + (32*f0*f1*f8^2 + 64*f0*f2*f7*f8 -
96*f0*f3*f6*f8 + 96*f0*f3*f7^2 + 96*f1*f2*f6*f8 - 48*f1*f2*f7^2 -
24*f1*f4*f5*f7)*x[3]*x[4]^2*x[7] + (32*f0*f3*f8 + 32*f0*f4*f7 + 16*f1*f2*f8 +
4*f1*f3*f7 + 48*f1*f4*f6 - 12*f1*f5^2)*x[3]*x[4]^2*x[8] + (-64*f0*f3*f4*f8 -
8*f0*f3*f5*f7)*x[3]*x[4]*x[5]^2 + (64*f0^2*f8^2 + 80*f0*f1*f7*f8 +
128*f0*f2*f6*f8 - 32*f0*f2*f7^2 - 80*f0*f3*f5*f8 + 192*f0*f4^2*f8 +
16*f0*f4*f5*f7 - 32*f1^2*f6*f8 + 16*f1^2*f7^2 + 16*f1*f3*f4*f8 +
4*f1*f3*f5*f7)*x[3]*x[4]*x[5]*x[6] + (96*f0*f3*f6*f8 - 16*f0*f3*f7^2 -
96*f0*f4*f5*f8 - 8*f0*f5^2*f7 - 24*f1^2*f7*f8 +
32*f1*f2*f6*f8)*x[3]*x[4]*x[5]*x[7] + (32*f0*f3*f8 + 64*f0*f4*f7 - 16*f1*f2*f8 +
8*f1*f3*f7)*x[3]*x[4]*x[5]*x[8] + (-64*f0*f1*f8^2 - 32*f0*f3*f6*f8 +
32*f0*f3*f7^2 - 64*f0*f4*f5*f8 - 8*f0*f5^2*f7 - 40*f1^2*f7*f8 - 32*f1*f2*f6*f8 -
16*f1*f2*f7^2 + 24*f1*f3*f5*f8 - 64*f1*f4^2*f8 - 8*f1*f4*f5*f7)*x[3]*x[4]*x[6]^2
+ (-64*f0*f2*f8^2 - 128*f0*f3*f7*f8 + 192*f0*f4*f6*f8 - 64*f0*f4*f7^2 -
32*f0*f5^2*f8 + 64*f1^2*f8^2 + 64*f1*f2*f7*f8 - 48*f1*f3*f6*f8 + 8*f1*f3*f7^2 +
64*f1*f4*f5*f8 + 8*f1*f5^2*f7)*x[3]*x[4]*x[6]*x[7] + (-96*f0*f4*f8 + 8*f0*f5*f7
+ 8*f1*f3*f8 - 48*f1*f4*f7)*x[3]*x[4]*x[6]*x[8] + (64*f0*f3*f8^2 - 40*f0*f5*f7^2
+ 32*f0*f6^2*f7 - 96*f1*f2*f8^2 - 16*f1*f3*f7*f8 - 64*f1*f4*f6*f8 +
32*f1*f4*f7^2 + 8*f1*f5^2*f8 - 8*f1*f5*f6*f7)*x[3]*x[4]*x[7]^2 + (-32*f0*f6*f7 +
16*f1*f5*f7)*x[3]*x[4]*x[7]*x[8] - 8*f1*f6*x[3]*x[4]*x[8]^2 + (-32*f0*f2*f5*f8 +
8*f1^2*f5*f8)*x[3]*x[5]^3 + (64*f0^2*f8^2 + 16*f0*f1*f7*f8 +
48*f0*f3*f5*f8)*x[3]*x[5]^2*x[6] + (-96*f0*f1*f8^2 +
16*f1^2*f7*f8)*x[3]*x[5]^2*x[7] + 32*f0*f3*f8*x[3]*x[5]^2*x[8] + (-64*f0*f1*f8^2
- 32*f0*f2*f7*f8 - 64*f0*f4*f5*f8 - 16*f1^2*f7*f8 -
8*f1*f3*f5*f8)*x[3]*x[5]*x[6]^2 + (64*f0*f2*f8^2 + 32*f0*f3*f7*f8 +
64*f0*f5^2*f8 + 64*f1^2*f8^2 - 16*f1*f2*f7*f8)*x[3]*x[5]*x[6]*x[7] +
(-96*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f3*f8)*x[3]*x[5]*x[6]*x[8] + (-64*f0*f3*f8^2 -
64*f0*f5*f6*f8 - 32*f1*f2*f8^2)*x[3]*x[5]*x[7]^2 + (64*f0*f5*f8 +
16*f0*f6*f7)*x[3]*x[5]*x[7]*x[8] - 16*f0*f7*x[3]*x[5]*x[8]^2 + (-16*f0*f3*f7*f8
+ 16*f0*f5^2*f8 + 16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 16*f1*f4*f5*f8)*x[3]*x[6]^3 +
(64*f0*f3*f8^2 + 32*f0*f4*f7*f8 - 32*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 32*f1*f2*f8^2
+ 8*f1*f3*f7*f8 - 24*f1*f5^2*f8)*x[3]*x[6]^2*x[7] + (32*f0*f5*f8 + 32*f1*f4*f8 +
4*f1*f5*f7)*x[3]*x[6]^2*x[8] + (-128*f0*f4*f8^2 + 80*f0*f5*f7*f8 - 16*f0*f6*f7^2
+ 32*f1*f3*f8^2 - 32*f1*f4*f7*f8 + 32*f1*f5*f6*f8 -
4*f1*f5*f7^2)*x[3]*x[6]*x[7]^2 + (-32*f0*f6*f8 -
32*f1*f5*f8)*x[3]*x[6]*x[7]*x[8] + (16*f0*f8 + 4*f1*f7)*x[3]*x[6]*x[8]^2 +
(-32*f0*f6*f7*f8 + 16*f0*f7^3 + 32*f1*f4*f8^2)*x[3]*x[7]^3 + (32*f0*f7*f8 -
4*f1*f7^2)*x[3]*x[7]^2*x[8] + 8*f1*f8*x[3]*x[7]*x[8]^2 + (16*f0^2*f8^2 +
40*f0*f1*f7*f8 + 48*f0*f2*f6*f8 - 8*f0*f3*f5*f8 - 8*f0*f3*f6*f7 + 16*f0*f4*f5*f7
+ 16*f0*f4*f6^2 - 4*f0*f5^2*f6 + 8*f1^2*f7^2 - 8*f1*f2*f5*f8 + 8*f1*f2*f6*f7 +
16*f1*f3*f4*f8 + 12*f1*f3*f5*f7 - 16*f1*f3*f6^2 + 8*f1*f4*f5*f6 - 2*f1*f5^3 +
16*f2^2*f4*f8 - 16*f2^2*f5*f7 + 16*f2^2*f6^2 - 4*f2*f3^2*f8 + 8*f2*f3*f4*f7 -
8*f2*f3*f5*f6 + 16*f2*f4^2*f6 - 4*f2*f4*f5^2 - 2*f3^3*f7 - 4*f3^2*f4*f6 +
f3^2*f5^2)*x[4]^4 + (48*f0*f1*f7*f8 - 64*f0*f2*f6*f8 + 32*f0*f2*f7^2 +
16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 16*f0*f4*f5*f7 + 32*f1^2*f6*f8 - 8*f1^2*f7^2 -
16*f1*f2*f5*f8 + 16*f1*f2*f6*f7 + 16*f1*f3*f4*f8 - 8*f1*f3*f5*f7 +
16*f1*f4^2*f7)*x[4]^3*x[5] + (-64*f0*f1*f8^2 - 32*f0*f2*f7*f8 - 32*f0*f4*f6*f7 -
16*f0*f5^2*f7 - 48*f1^2*f7*f8 - 16*f1*f2*f7^2 - 48*f1*f3*f5*f8 + 32*f1*f3*f6*f7
- 16*f1*f4*f5*f7 + 32*f2^2*f5*f8 - 32*f2^2*f6*f7 - 32*f2*f3*f4*f8 +
16*f2*f3*f5*f7 - 32*f2*f4^2*f7 + 8*f3^3*f8 + 8*f3^2*f4*f7)*x[4]^3*x[6] +
(-64*f0*f2*f8^2 - 32*f0*f3*f7*f8 - 64*f0*f4*f6*f8 + 16*f0*f5^2*f8 +
16*f0*f5*f6*f7 + 16*f1*f2*f7*f8 + 64*f1*f3*f6*f8 - 32*f1*f3*f7^2 + 4*f1*f5^2*f7
- 64*f2^2*f6*f8 + 32*f2^2*f7^2 + 16*f2*f3*f5*f8 + 16*f2*f4*f5*f7 -
4*f3^2*f5*f7)*x[4]^3*x[7] + (-32*f0*f5*f7 - 32*f1*f3*f8 - 8*f1*f4*f7 -
32*f2*f4*f6 + 8*f2*f5^2 + 8*f3^2*f6)*x[4]^3*x[8] + (-16*f0*f1*f7*f8 -
32*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 32*f0*f4^2*f8 + 8*f0*f4*f5*f7 + 16*f1^2*f6*f8 +
8*f1*f3*f4*f8)*x[4]^2*x[5]^2 + (-64*f0*f1*f8^2 - 64*f0*f2*f7*f8 + 64*f0*f3*f6*f8
+ 16*f0*f3*f7^2 - 64*f0*f4*f5*f8 - 8*f0*f5^2*f7 + 8*f1^2*f7*f8 - 32*f1*f2*f6*f8
- 16*f1*f2*f7^2 + 24*f1*f3*f5*f8 - 64*f1*f4^2*f8 -
8*f1*f4*f5*f7)*x[4]^2*x[5]*x[6] + (64*f0*f2*f8^2 - 64*f0*f3*f7*f8 -
32*f0*f4*f7^2 + 16*f0*f5^2*f8 - 32*f1^2*f8^2 + 16*f1*f2*f7*f8 - 48*f1*f3*f6*f8 +
12*f1*f3*f7^2 + 32*f1*f4*f5*f8 + 4*f1*f5^2*f7)*x[4]^2*x[5]*x[7] + (-32*f0*f4*f8
+ 8*f0*f5*f7 + 8*f1*f3*f8 - 24*f1*f4*f7)*x[4]^2*x[5]*x[8] + (32*f0*f2*f8^2 +
64*f0*f4*f6*f8 + 24*f0*f5*f6*f7 + 64*f1^2*f8^2 + 40*f1*f2*f7*f8 - 16*f1*f3*f6*f8
- 12*f1*f3*f7^2 + 32*f1*f4*f5*f8 + 4*f1*f5^2*f7 + 32*f2^2*f6*f8 + 16*f2^2*f7^2 -
24*f2*f3*f5*f8 + 64*f2*f4^2*f8 + 8*f2*f4*f5*f7 - 16*f3^2*f4*f8 -
2*f3^2*f5*f7)*x[4]^2*x[6]^2 + (96*f0*f3*f8^2 + 32*f0*f5*f7^2 - 32*f0*f6^2*f7 -
64*f1*f2*f8^2 + 88*f1*f3*f7*f8 - 64*f1*f4*f6*f8 + 24*f1*f4*f7^2 - 8*f1*f5*f6*f7
- 64*f2^2*f7*f8 + 32*f2*f3*f6*f8 - 16*f2*f3*f7^2 - 64*f2*f4*f5*f8 - 8*f2*f5^2*f7
+ 8*f3^2*f5*f8)*x[4]^2*x[6]*x[7] + (32*f0*f5*f8 + 16*f0*f6*f7 + 32*f1*f4*f8 +
4*f1*f5*f7 + 48*f2*f4*f7 - 12*f3^2*f7)*x[4]^2*x[6]*x[8] + (32*f0*f4*f8^2 +
24*f0*f5*f7*f8 - 16*f0*f6*f7^2 - 32*f1*f3*f8^2 - 24*f1*f4*f7*f8 + 4*f1*f5*f7^2 +
64*f2^2*f8^2 + 96*f2*f4*f6*f8 - 32*f2*f4*f7^2 - 16*f2*f5^2*f8 + 8*f2*f5*f6*f7 -
32*f3^2*f6*f8 + 12*f3^2*f7^2 + 8*f3*f4*f5*f8)*x[4]^2*x[7]^2 + (32*f0*f7^2 -
32*f2*f4*f8 - 16*f2*f5*f7 + 8*f3^2*f8)*x[4]^2*x[7]*x[8] + (8*f0*f8 + 2*f1*f7 +
8*f2*f6 - 2*f3*f5)*x[4]^2*x[8]^2 + (-16*f0*f1*f7*f8 +
16*f0*f3*f5*f8)*x[4]*x[5]^3 + (-64*f0*f4*f5*f8 - 8*f1*f3*f5*f8)*x[4]*x[5]^2*x[6]
+ (32*f0*f5^2*f8 + 16*f1^2*f8^2 - 16*f1*f2*f7*f8)*x[4]*x[5]^2*x[7] +
(-32*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f3*f8)*x[4]*x[5]^2*x[8] + (64*f0*f2*f8^2 -
48*f0*f3*f7*f8 + 48*f0*f5^2*f8 - 16*f1^2*f8^2 + 48*f1*f2*f7*f8 +
48*f1*f4*f5*f8)*x[4]*x[5]*x[6]^2 + (96*f0*f4*f7*f8 - 64*f0*f5*f6*f8 +
24*f0*f5*f7^2 - 32*f1*f2*f8^2 + 8*f1*f3*f7*f8 -
48*f1*f5^2*f8)*x[4]*x[5]*x[6]*x[7] + (32*f0*f5*f8 - 16*f0*f6*f7 + 64*f1*f4*f8 +
8*f1*f5*f7)*x[4]*x[5]*x[6]*x[8] + (-64*f0*f4*f8^2 + 32*f0*f5*f7*f8 -
16*f0*f6*f7^2 + 64*f1*f3*f8^2 - 32*f1*f4*f7*f8 + 32*f1*f5*f6*f8 -
4*f1*f5*f7^2)*x[4]*x[5]*x[7]^2 + (32*f0*f6*f8 + 16*f0*f7^2 -
32*f1*f5*f8)*x[4]*x[5]*x[7]*x[8] + 4*f1*f7*x[4]*x[5]*x[8]^2 + (-32*f0*f5*f6*f8 -
16*f0*f5*f7^2 - 32*f1*f2*f8^2 - 16*f1*f5^2*f8 - 32*f2^2*f7*f8 - 32*f2*f4*f5*f8 +
8*f3^2*f5*f8)*x[4]*x[6]^3 + (-48*f0*f5*f7*f8 + 32*f0*f6*f7^2 - 80*f1*f3*f8^2 -
32*f1*f4*f7*f8 + 48*f1*f5*f6*f8 - 4*f1*f5*f7^2 + 64*f2^2*f8^2 + 32*f2*f3*f7*f8 +
48*f2*f5^2*f8)*x[4]*x[6]^2*x[7] + (-32*f0*f6*f8 - 24*f1*f5*f8 - 64*f2*f4*f8 -
8*f2*f5*f7 + 16*f3^2*f8)*x[4]*x[6]^2*x[8] + (-64*f0*f5*f8^2 + 64*f0*f6*f7*f8 -
16*f0*f7^3 + 128*f1*f4*f8^2 - 24*f1*f5*f7*f8 - 64*f2*f3*f8^2 + 32*f2*f4*f7*f8 -
64*f2*f5*f6*f8 + 8*f2*f5*f7^2 - 16*f3^2*f7*f8 - 8*f3*f5^2*f8)*x[4]*x[6]*x[7]^2 +
(-64*f0*f7*f8 - 4*f1*f7^2 + 80*f2*f5*f8 + 4*f3*f5*f7)*x[4]*x[6]*x[7]*x[8] -
8*f2*f7*x[4]*x[6]*x[8]^2 + (-16*f0*f7^2*f8 - 64*f2*f4*f8^2 + 16*f2*f5*f7*f8 +
32*f3^2*f8^2 + 16*f3*f5*f6*f8 - 4*f3*f5*f7^2)*x[4]*x[7]^3 + (8*f1*f7*f8 -
32*f2*f6*f8 + 8*f2*f7^2 - 16*f3*f5*f8)*x[4]*x[7]^2*x[8] +
16*f2*f8*x[4]*x[7]*x[8]^2 + (16*f0^2*f8^2 + 16*f0*f2*f6*f8 - 4*f0*f2*f7^2 -
4*f1^2*f6*f8 + f1^2*f7^2)*x[5]^4 + (-32*f0*f3*f6*f8 + 8*f0*f3*f7^2)*x[5]^3*x[6]
- 16*f1^2*f8^2*x[5]^3*x[7] + (32*f0*f2*f8^2 + 64*f0*f4*f6*f8 - 16*f0*f4*f7^2 +
8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*x[5]^2*x[6]^2 + (-32*f0*f3*f8^2 - 64*f0*f5*f6*f8 +
16*f0*f5*f7^2 + 32*f1*f2*f8^2)*x[5]^2*x[6]*x[7] + 32*f0*f5*f8*x[5]^2*x[6]*x[8] +
(32*f0*f4*f8^2 - 8*f0*f5*f7*f8 + 64*f0*f6^2*f8 - 16*f0*f6*f7^2)*x[5]^2*x[7]^2 +
(-64*f0*f6*f8 + 8*f0*f7^2)*x[5]^2*x[7]*x[8] + 8*f0*f8*x[5]^2*x[8]^2 +
(-32*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 32*f1*f2*f8^2 - 32*f1*f4*f6*f8 +
8*f1*f4*f7^2)*x[5]*x[6]^3 + (-48*f0*f5*f7*f8 + 64*f0*f6^2*f8 - 16*f0*f6*f7^2 -
16*f1*f3*f8^2 + 48*f1*f5*f6*f8 - 12*f1*f5*f7^2)*x[5]*x[6]^2*x[7] + (-32*f0*f6*f8
+ 16*f0*f7^2 - 24*f1*f5*f8)*x[5]*x[6]^2*x[8] + (64*f0*f5*f8^2 - 64*f0*f6*f7*f8 +
24*f0*f7^3 + 24*f1*f5*f7*f8 - 64*f1*f6^2*f8 + 16*f1*f6*f7^2)*x[5]*x[6]*x[7]^2 +
(64*f1*f6*f8 - 16*f1*f7^2)*x[5]*x[6]*x[7]*x[8] - 16*f1*f8*x[5]*x[6]*x[8]^2 +
(-16*f0*f7^2*f8 - 32*f1*f5*f8^2 + 16*f1*f6*f7*f8 - 4*f1*f7^3)*x[5]*x[7]^3 +
8*f1*f7*f8*x[5]*x[7]^2*x[8] + (16*f0*f5*f7*f8 + 16*f0*f6^2*f8 - 4*f0*f6*f7^2 +
16*f1*f3*f8^2 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2 + 16*f2^2*f8^2 + 16*f2*f4*f6*f8 -
4*f2*f4*f7^2 - 4*f3^2*f6*f8 + f3^2*f7^2)*x[6]^4 + (-32*f0*f6*f7*f8 +
8*f1*f5*f7*f8 - 32*f1*f6^2*f8 + 8*f1*f6*f7^2 - 32*f2*f3*f8^2 - 32*f2*f5*f6*f8 +
8*f2*f5*f7^2)*x[6]^3*x[7] + (16*f1*f6*f8 - 4*f1*f7^2 + 16*f2*f5*f8)*x[6]^3*x[8]
+ (64*f0*f6*f8^2 - 48*f1*f5*f8^2 + 40*f1*f6*f7*f8 - 10*f1*f7^3 + 32*f2*f4*f8^2 -
24*f2*f5*f7*f8 + 64*f2*f6^2*f8 - 16*f2*f6*f7^2 + 16*f3^2*f8^2 + 8*f3*f5*f6*f8 -
2*f3*f5*f7^2)*x[6]^2*x[7]^2 + (8*f1*f7*f8 - 64*f2*f6*f8 + 16*f2*f7^2 -
8*f3*f5*f8)*x[6]^2*x[7]*x[8] + 8*f2*f8*x[6]^2*x[8]^2 + (32*f2*f5*f8^2 -
32*f2*f6*f7*f8 + 8*f2*f7^3 - 32*f3*f4*f8^2 + 16*f3*f5*f7*f8 - 32*f3*f6^2*f8 +
8*f3*f6*f7^2)*x[6]*x[7]^3 + (-32*f1*f8^2 + 48*f3*f6*f8 -
12*f3*f7^2)*x[6]*x[7]^2*x[8] - 8*f3*f8*x[6]*x[7]*x[8]^2 + (16*f2*f6*f8^2 -
4*f2*f7^2*f8 - 16*f3*f5*f8^2 + 8*f3*f6*f7*f8 - 2*f3*f7^3 + 16*f4^2*f8^2 -
8*f4*f5*f7*f8 + 16*f4*f6^2*f8 - 4*f4*f6*f7^2 - 4*f5^2*f6*f8 + f5^2*f7^2)*x[7]^4
+ (-32*f4*f6*f8 + 8*f4*f7^2 + 8*f5^2*f8)*x[7]^3*x[8] + (8*f4*f8 -
2*f5*f7)*x[7]^2*x[8]^2 + x[8]^4,

// number 2
(64*f0^3*f6*f8^3 - 16*f0^3*f7^2*f8^2 - 32*f0^2*f1*f5*f8^3 +
32*f0^2*f2*f5*f7*f8^2 + 64*f0^2*f2*f6^2*f8^2 - 48*f0^2*f2*f6*f7^2*f8 +
8*f0^2*f2*f7^4 + 64*f0^2*f3^2*f8^3 - 64*f0^2*f3*f4*f7*f8^2 +
32*f0^2*f3*f5*f6*f8^2 + 8*f0^2*f3*f5*f7^2*f8 - 32*f0^2*f3*f6^2*f7*f8 +
8*f0^2*f3*f6*f7^3 + 64*f0^2*f4^2*f6*f8^2 - 64*f0^2*f4*f5*f6*f7*f8 +
8*f0^2*f4*f5*f7^3 + 64*f0^2*f4*f6^3*f8 - 16*f0^2*f4*f6^2*f7^2 +
8*f0^2*f5^3*f7*f8 - 16*f0^2*f5^2*f6^2*f8 + 4*f0^2*f5^2*f6*f7^2 +
16*f0*f1^2*f4*f8^3 - 8*f0*f1^2*f5*f7*f8^2 - 16*f0*f1^2*f6^2*f8^2 +
12*f0*f1^2*f6*f7^2*f8 - 2*f0*f1^2*f7^4 - 96*f0*f1*f2*f3*f8^3 +
32*f0*f1*f2*f4*f7*f8^2 - 64*f0*f1*f2*f5*f6*f8^2 + 32*f0*f1*f2*f6^2*f7*f8 -
8*f0*f1*f2*f6*f7^3 + 16*f0*f1*f3^2*f7*f8^2 - 32*f0*f1*f3*f4*f6*f8^2 -
16*f0*f1*f3*f5^2*f8^2 + 40*f0*f1*f3*f5*f6*f7*f8 - 6*f0*f1*f3*f5*f7^3 -
32*f0*f1*f3*f6^3*f8 + 8*f0*f1*f3*f6^2*f7^2 + 64*f0*f2^3*f8^3 -
32*f0*f2^2*f3*f7*f8^2 + 128*f0*f2^2*f4*f6*f8^2 - 16*f0*f2^2*f4*f7^2*f8 +
48*f0*f2^2*f5^2*f8^2 - 96*f0*f2^2*f5*f6*f7*f8 + 16*f0*f2^2*f5*f7^3 +
64*f0*f2^2*f6^3*f8 - 16*f0*f2^2*f6^2*f7^2 - 16*f0*f2*f3^2*f6*f8^2 +
4*f0*f2*f3^2*f7^2*f8 - 96*f0*f2*f3*f4*f5*f8^2 + 32*f0*f2*f3*f4*f6*f7*f8 -
8*f0*f2*f3*f4*f7^3 + 16*f0*f2*f3*f5^2*f7*f8 - 32*f0*f2*f3*f5*f6^2*f8 +
8*f0*f2*f3*f5*f6*f7^2 + 64*f0*f2*f4^3*f8^2 - 32*f0*f2*f4^2*f5*f7*f8 +
64*f0*f2*f4^2*f6^2*f8 - 16*f0*f2*f4^2*f6*f7^2 - 16*f0*f2*f4*f5^2*f6*f8 +
4*f0*f2*f4*f5^2*f7^2 + 16*f0*f3^3*f5*f8^2 - 8*f0*f3^3*f6*f7*f8 + 2*f0*f3^3*f7^3
- 16*f0*f3^2*f4^2*f8^2 + 8*f0*f3^2*f4*f5*f7*f8 - 16*f0*f3^2*f4*f6^2*f8 +
4*f0*f3^2*f4*f6*f7^2 + 4*f0*f3^2*f5^2*f6*f8 - f0*f3^2*f5^2*f7^2 +
16*f1^3*f3*f8^3 - 8*f1^3*f4*f7*f8^2 + 16*f1^3*f5*f6*f8^2 - 8*f1^3*f6^2*f7*f8 +
2*f1^3*f6*f7^3 - 16*f1^2*f2^2*f8^3 + 8*f1^2*f2*f3*f7*f8^2 -
32*f1^2*f2*f4*f6*f8^2 + 4*f1^2*f2*f4*f7^2*f8 - 12*f1^2*f2*f5^2*f8^2 +
24*f1^2*f2*f5*f6*f7*f8 - 4*f1^2*f2*f5*f7^3 - 16*f1^2*f2*f6^3*f8 +
4*f1^2*f2*f6^2*f7^2 + 24*f1^2*f3*f4*f5*f8^2 - 8*f1^2*f3*f4*f6*f7*f8 +
2*f1^2*f3*f4*f7^3 - 4*f1^2*f3*f5^2*f7*f8 + 8*f1^2*f3*f5*f6^2*f8 -
2*f1^2*f3*f5*f6*f7^2 - 16*f1^2*f4^3*f8^2 + 8*f1^2*f4^2*f5*f7*f8 -
16*f1^2*f4^2*f6^2*f8 + 4*f1^2*f4^2*f6*f7^2 + 4*f1^2*f4*f5^2*f6*f8 -
f1^2*f4*f5^2*f7^2)*x[1]^4 + (-64*f0^3*f8^3 + 16*f0^2*f1*f7*f8^2 -
64*f0^2*f2*f6*f8^2 + 16*f0^2*f2*f7^2*f8 - 96*f0^2*f3*f5*f8^2 +
96*f0^2*f3*f6*f7*f8 - 24*f0^2*f3*f7^3 + 32*f0^2*f4*f5*f7*f8 -
128*f0^2*f4*f6^2*f8 + 32*f0^2*f4*f6*f7^2 + 32*f0^2*f5^2*f6*f8 - 8*f0^2*f5^2*f7^2
+ 16*f0*f1^2*f6*f8^2 - 4*f0*f1^2*f7^2*f8 + 96*f0*f1*f2*f5*f8^2 -
64*f0*f1*f2*f6*f7*f8 + 16*f0*f1*f2*f7^3 + 16*f0*f1*f3*f4*f8^2 -
24*f0*f1*f3*f5*f7*f8 + 64*f0*f1*f3*f6^2*f8 - 16*f0*f1*f3*f6*f7^2 -
128*f0*f2^2*f4*f8^2 + 64*f0*f2^2*f5*f7*f8 - 128*f0*f2^2*f6^2*f8 +
32*f0*f2^2*f6*f7^2 + 32*f0*f2*f3^2*f8^2 + 64*f0*f2*f3*f5*f6*f8 -
16*f0*f2*f3*f5*f7^2 - 128*f0*f2*f4^2*f6*f8 + 32*f0*f2*f4^2*f7^2 +
32*f0*f2*f4*f5^2*f8 + 32*f0*f3^2*f4*f6*f8 - 8*f0*f3^2*f4*f7^2 -
8*f0*f3^2*f5^2*f8 - 24*f1^3*f5*f8^2 + 16*f1^3*f6*f7*f8 - 4*f1^3*f7^3 +
32*f1^2*f2*f4*f8^2 - 16*f1^2*f2*f5*f7*f8 + 32*f1^2*f2*f6^2*f8 -
8*f1^2*f2*f6*f7^2 - 4*f1^2*f3^2*f8^2 - 16*f1^2*f3*f5*f6*f8 + 4*f1^2*f3*f5*f7^2 +
32*f1^2*f4^2*f6*f8 - 8*f1^2*f4^2*f7^2 - 8*f1^2*f4*f5^2*f8)*x[1]^3*x[2] +
(32*f0^2*f1*f8^3 - 64*f0^2*f3*f6*f8^2 + 16*f0^2*f3*f7^2*f8 + 32*f0^2*f4*f5*f8^2
+ 64*f0^2*f4*f6*f7*f8 - 16*f0^2*f4*f7^3 - 32*f0^2*f5^2*f7*f8 +
32*f0^2*f5*f6^2*f8 - 8*f0^2*f5*f6*f7^2 - 8*f0*f1^2*f7*f8^2 + 64*f0*f1*f2*f6*f8^2
- 16*f0*f1*f2*f7^2*f8 + 48*f0*f1*f3*f5*f8^2 - 64*f0*f1*f3*f6*f7*f8 +
16*f0*f1*f3*f7^3 - 32*f0*f1*f4^2*f8^2 + 8*f0*f1*f4*f5*f7*f8 - 8*f0*f1*f5^2*f6*f8
+ 2*f0*f1*f5^2*f7^2 - 128*f0*f2^2*f5*f8^2 + 128*f0*f2^2*f6*f7*f8 -
32*f0*f2^2*f7^3 + 128*f0*f2*f3*f4*f8^2 - 32*f0*f2*f3*f5*f7*f8 +
64*f0*f2*f4*f5*f6*f8 - 16*f0*f2*f4*f5*f7^2 - 16*f0*f2*f5^3*f8 - 32*f0*f3^3*f8^2
- 16*f0*f3^2*f5*f6*f8 + 4*f0*f3^2*f5*f7^2 - 16*f1^3*f6*f8^2 + 4*f1^3*f7^2*f8 +
32*f1^2*f2*f5*f8^2 - 32*f1^2*f2*f6*f7*f8 + 8*f1^2*f2*f7^3 - 24*f1^2*f3*f4*f8^2 +
6*f1^2*f3*f5*f7*f8 - 16*f1^2*f4*f5*f6*f8 + 4*f1^2*f4*f5*f7^2 +
4*f1^2*f5^3*f8)*x[1]^3*x[3] + (64*f0^2*f2*f8^3 + 32*f0^2*f3*f7*f8^2 -
16*f0^2*f4*f7^2*f8 + 48*f0^2*f5^2*f8^2 - 48*f0^2*f5*f6*f7*f8 + 16*f0^2*f5*f7^3 -
32*f0*f1^2*f8^3 - 48*f0*f1*f2*f7*f8^2 + 4*f0*f1*f3*f7^2*f8 - 64*f0*f1*f4*f5*f8^2
+ 32*f0*f1*f4*f6*f7*f8 - 8*f0*f1*f4*f7^3 + 12*f0*f1*f5^2*f7*f8 -
16*f0*f1*f5*f6^2*f8 + 4*f0*f1*f5*f6*f7^2 + 48*f0*f2*f3*f5*f8^2 -
64*f0*f2*f3*f6*f7*f8 + 16*f0*f2*f3*f7^3 - 64*f0*f2*f4^2*f8^2 +
16*f0*f2*f4*f5*f7*f8 - 16*f0*f2*f5^2*f6*f8 + 4*f0*f2*f5^2*f7^2 +
8*f0*f3^2*f5*f7*f8 - 16*f0*f3*f4*f5*f6*f8 + 4*f0*f3*f4*f5*f7^2 + 8*f0*f3*f5^3*f8
+ 16*f1^3*f7*f8^2 - 8*f1^2*f3*f5*f8^2 + 16*f1^2*f3*f6*f7*f8 - 4*f1^2*f3*f7^3 +
32*f1^2*f4^2*f8^2 - 8*f1^2*f4*f5*f7*f8 + 8*f1^2*f5^2*f6*f8 - 2*f1^2*f5^2*f7^2 -
16*f1*f2*f3*f4*f8^2 + 4*f1*f2*f3*f5*f7*f8 + 8*f1*f3^3*f8^2 + 4*f1*f3^2*f5*f6*f8
- f1*f3^2*f5*f7^2)*x[1]^3*x[4] + (-64*f0^2*f2*f8^3 + 32*f0^2*f3*f7*f8^2 -
128*f0^2*f4*f6*f8^2 + 16*f0^2*f4*f7^2*f8 - 32*f0^2*f5^2*f8^2 +
96*f0^2*f5*f6*f7*f8 - 16*f0^2*f5*f7^3 - 64*f0^2*f6^3*f8 + 16*f0^2*f6^2*f7^2 +
16*f0*f1^2*f8^3 + 48*f0*f1*f3*f6*f8^2 - 12*f0*f1*f3*f7^2*f8 +
32*f0*f1*f4*f5*f8^2 - 16*f0*f1*f4*f6*f7*f8 + 4*f0*f1*f4*f7^3 -
8*f0*f1*f5^2*f7*f8 + 16*f0*f1*f5*f6^2*f8 - 4*f0*f1*f5*f6*f7^2 -
128*f0*f2^2*f6*f8^2 + 32*f0*f2^2*f7^2*f8 + 64*f0*f2*f3*f5*f8^2 -
128*f0*f2*f4^2*f8^2 + 64*f0*f2*f4*f5*f7*f8 - 128*f0*f2*f4*f6^2*f8 +
32*f0*f2*f4*f6*f7^2 + 32*f0*f2*f5^2*f6*f8 - 8*f0*f2*f5^2*f7^2 +
32*f0*f3^2*f4*f8^2 - 16*f0*f3^2*f5*f7*f8 + 32*f0*f3^2*f6^2*f8 -
8*f0*f3^2*f6*f7^2 + 32*f1^2*f2*f6*f8^2 - 8*f1^2*f2*f7^2*f8 - 20*f1^2*f3*f5*f8^2
+ 4*f1^2*f3*f6*f7*f8 - f1^2*f3*f7^3 + 32*f1^2*f4^2*f8^2 - 16*f1^2*f4*f5*f7*f8 +
32*f1^2*f4*f6^2*f8 - 8*f1^2*f4*f6*f7^2 - 8*f1^2*f5^2*f6*f8 +
2*f1^2*f5^2*f7^2)*x[1]^3*x[5] + (-128*f0^2*f3*f8^3 + 64*f0^2*f4*f7*f8^2 -
32*f0^2*f5*f6*f8^2 - 16*f0^2*f5*f7^2*f8 + 32*f0^2*f6^2*f7*f8 - 8*f0^2*f6*f7^3 +
128*f0*f1*f2*f8^3 - 24*f0*f1*f3*f7*f8^2 + 32*f0*f1*f4*f6*f8^2 +
32*f0*f1*f5^2*f8^2 - 56*f0*f1*f5*f6*f7*f8 + 10*f0*f1*f5*f7^3 + 32*f0*f1*f6^3*f8
- 8*f0*f1*f6^2*f7^2 + 64*f0*f2*f3*f6*f8^2 - 16*f0*f2*f3*f7^2*f8 +
64*f0*f2*f4*f5*f8^2 - 32*f0*f2*f4*f6*f7*f8 + 8*f0*f2*f4*f7^3 -
16*f0*f2*f5^2*f7*f8 + 32*f0*f2*f5*f6^2*f8 - 8*f0*f2*f5*f6*f7^2 -
48*f0*f3^2*f5*f8^2 + 16*f0*f3^2*f6*f7*f8 - 4*f0*f3^2*f7^3 + 32*f0*f3*f4^2*f8^2 -
16*f0*f3*f4*f5*f7*f8 + 32*f0*f3*f4*f6^2*f8 - 8*f0*f3*f4*f6*f7^2 -
16*f0*f3*f5^2*f6*f8 + 4*f0*f3*f5^2*f7^2 - 32*f1^3*f8^3 - 16*f1^2*f3*f6*f8^2 +
4*f1^2*f3*f7^2*f8 - 32*f1^2*f4*f5*f8^2 + 16*f1^2*f4*f6*f7*f8 - 4*f1^2*f4*f7^3 +
8*f1^2*f5^2*f7*f8 - 16*f1^2*f5*f6^2*f8 + 4*f1^2*f5*f6*f7^2 + 8*f1*f2*f3*f5*f8^2
- 8*f1*f2*f3*f6*f7*f8 + 2*f1*f2*f3*f7^3 - 8*f1*f3^2*f4*f8^2 + 4*f1*f3^2*f5*f7*f8
- 8*f1*f3^2*f6^2*f8 + 2*f1*f3^2*f6*f7^2)*x[1]^3*x[6] + (-16*f0^2*f5*f7*f8^2 -
64*f0^2*f6^2*f8^2 + 48*f0^2*f6*f7^2*f8 - 8*f0^2*f7^4 + 48*f0*f1*f3*f8^3 -
16*f0*f1*f4*f7*f8^2 + 48*f0*f1*f5*f6*f8^2 - 4*f0*f1*f5*f7^2*f8 -
16*f0*f1*f6^2*f7*f8 + 4*f0*f1*f6*f7^3 - 128*f0*f2^2*f8^3 + 64*f0*f2*f3*f7*f8^2 -
192*f0*f2*f4*f6*f8^2 + 16*f0*f2*f4*f7^2*f8 - 80*f0*f2*f5^2*f8^2 +
176*f0*f2*f5*f6*f7*f8 - 28*f0*f2*f5*f7^3 - 128*f0*f2*f6^3*f8 +
32*f0*f2*f6^2*f7^2 + 112*f0*f3*f4*f5*f8^2 - 32*f0*f3*f4*f6*f7*f8 +
8*f0*f3*f4*f7^3 - 24*f0*f3*f5^2*f7*f8 + 48*f0*f3*f5*f6^2*f8 -
12*f0*f3*f5*f6*f7^2 - 64*f0*f4^3*f8^2 + 32*f0*f4^2*f5*f7*f8 - 64*f0*f4^2*f6^2*f8
+ 16*f0*f4^2*f6*f7^2 + 16*f0*f4*f5^2*f6*f8 - 4*f0*f4*f5^2*f7^2 + 32*f1^2*f2*f8^3
- 16*f1^2*f3*f7*f8^2 + 32*f1^2*f4*f6*f8^2 + 16*f1^2*f5^2*f8^2 -
40*f1^2*f5*f6*f7*f8 + 6*f1^2*f5*f7^3 + 32*f1^2*f6^3*f8 - 8*f1^2*f6^2*f7^2 +
16*f1*f2*f3*f6*f8^2 - 4*f1*f2*f3*f7^2*f8 - 16*f1*f3^2*f5*f8^2 +
8*f1*f3^2*f6*f7*f8 - 2*f1*f3^2*f7^3 + 16*f1*f3*f4^2*f8^2 - 8*f1*f3*f4*f5*f7*f8 +
16*f1*f3*f4*f6^2*f8 - 4*f1*f3*f4*f6*f7^2 - 4*f1*f3*f5^2*f6*f8 +
f1*f3*f5^2*f7^2)*x[1]^3*x[7] + (8*f0*f1*f5*f8^2 - 8*f0*f1*f6*f7*f8 +
2*f0*f1*f7^3 + 64*f0*f2*f4*f8^2 - 32*f0*f2*f5*f7*f8 + 64*f0*f2*f6^2*f8 -
16*f0*f2*f6*f7^2 - 16*f0*f3^2*f8^2 - 24*f0*f3*f5*f6*f8 + 6*f0*f3*f5*f7^2 +
32*f0*f4^2*f6*f8 - 8*f0*f4^2*f7^2 - 8*f0*f4*f5^2*f8 - 16*f1^2*f4*f8^2 +
8*f1^2*f5*f7*f8 - 16*f1^2*f6^2*f8 + 4*f1^2*f6*f7^2 - 8*f1*f3*f4*f6*f8 +
2*f1*f3*f4*f7^2 + 2*f1*f3*f5^2*f8)*x[1]^3*x[8] + (-16*f0^2*f3*f7*f8 +
32*f0^2*f4*f6*f8 - 4*f0*f1^2*f8^2 + 8*f0*f1*f2*f7*f8 - 32*f0*f1*f3*f6*f8 +
6*f0*f1*f3*f7^2 + 64*f0*f2^2*f6*f8 - 16*f0*f2^2*f7^2 - 24*f0*f2*f3*f5*f8 +
32*f0*f2*f4^2*f8 - 8*f0*f2*f4*f5*f7 - 8*f0*f3^2*f4*f8 + 2*f0*f3^2*f5*f7 -
2*f1^3*f7*f8 - 16*f1^2*f2*f6*f8 + 4*f1^2*f2*f7^2 + 6*f1^2*f3*f5*f8 -
8*f1^2*f4^2*f8 + 2*f1^2*f4*f5*f7)*x[1]^2*x[2]^2 + (64*f0^2*f3*f8^2 -
32*f0^2*f4*f7*f8 - 64*f0^2*f5*f6*f8 + 24*f0^2*f5*f7^2 - 48*f0*f1*f2*f8^2 +
16*f0*f1*f3*f7*f8 + 32*f0*f1*f4*f6*f8 - 12*f0*f1*f4*f7^2 - 32*f0*f2^2*f7*f8 -
32*f0*f2*f3*f6*f8 + 16*f0*f2*f3*f7^2 - 32*f0*f2*f4*f5*f8 + 8*f0*f2*f5^2*f7 +
16*f0*f3^2*f5*f8 + 16*f1^3*f8^2 + 8*f1^2*f2*f7*f8 + 8*f1^2*f3*f6*f8 -
3*f1^2*f3*f7^2 + 8*f1^2*f4*f5*f8 - 2*f1^2*f5^2*f7)*x[1]^2*x[2]*x[3] +
(-32*f0^2*f4*f8^2 + 64*f0^2*f6^2*f8 - 24*f0^2*f6*f7^2 + 8*f0*f1*f3*f8^2 +
16*f0*f1*f5*f6*f8 - 6*f0*f1*f5*f7^2 + 32*f0*f2^2*f8^2 + 16*f0*f2*f3*f7*f8 +
64*f0*f2*f4*f6*f8 - 24*f0*f2*f4*f7^2 - 4*f0*f3*f5^2*f7 - 16*f1^2*f2*f8^2 -
4*f1^2*f3*f7*f8 - 32*f1^2*f4*f6*f8 + 12*f1^2*f4*f7^2 - 2*f1*f2*f3*f7^2 -
4*f1*f3^2*f5*f8)*x[1]^2*x[2]*x[4] + (32*f0^2*f4*f8^2 - 48*f0^2*f5*f7*f8 +
96*f0^2*f6^2*f8 - 24*f0^2*f6*f7^2 - 16*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 -
24*f0*f1*f5*f6*f8 + 6*f0*f1*f5*f7^2 + 64*f0*f2^2*f8^2 - 16*f0*f2*f3*f7*f8 +
192*f0*f2*f4*f6*f8 - 48*f0*f2*f4*f7^2 - 48*f0*f2*f5^2*f8 - 48*f0*f3^2*f6*f8 +
12*f0*f3^2*f7^2 - 16*f1^2*f2*f8^2 + 2*f1^2*f3*f7*f8 - 48*f1^2*f4*f6*f8 +
12*f1^2*f4*f7^2 + 12*f1^2*f5^2*f8)*x[1]^2*x[2]*x[5] + (112*f0^2*f5*f8^2 -
80*f0^2*f6*f7*f8 + 24*f0^2*f7^3 - 48*f0*f1*f4*f8^2 + 28*f0*f1*f5*f7*f8 -
48*f0*f1*f6^2*f8 + 12*f0*f1*f6*f7^2 - 48*f0*f2*f3*f8^2 + 16*f0*f2*f4*f7*f8 -
48*f0*f2*f5*f6*f8 + 12*f0*f2*f5*f7^2 - 48*f0*f3*f4*f6*f8 + 12*f0*f3*f4*f7^2 +
24*f0*f3*f5^2*f8 + 16*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 + 24*f1^2*f5*f6*f8 -
6*f1^2*f5*f7^2 + 4*f1*f2*f3*f7*f8 + 12*f1*f3^2*f6*f8 -
3*f1*f3^2*f7^2)*x[1]^2*x[2]*x[6] + (32*f0^2*f6*f8^2 - 16*f0^2*f7^2*f8 -
48*f0*f1*f5*f8^2 + 24*f0*f1*f6*f7*f8 - 6*f0*f1*f7^3 + 96*f0*f2*f4*f8^2 -
80*f0*f2*f5*f7*f8 + 192*f0*f2*f6^2*f8 - 48*f0*f2*f6*f7^2 - 72*f0*f3*f5*f6*f8 +
18*f0*f3*f5*f7^2 + 96*f0*f4^2*f6*f8 - 24*f0*f4^2*f7^2 - 24*f0*f4*f5^2*f8 +
16*f1^2*f5*f7*f8 - 48*f1^2*f6^2*f8 + 12*f1^2*f6*f7^2 - 16*f1*f2*f3*f8^2 -
24*f1*f3*f4*f6*f8 + 6*f1*f3*f4*f7^2 + 6*f1*f3*f5^2*f8)*x[1]^2*x[2]*x[7] +
(16*f0^2*f8^2 - 80*f0*f2*f6*f8 + 20*f0*f2*f7^2 + 20*f0*f3*f5*f8 - 16*f0*f4^2*f8
+ 4*f0*f4*f5*f7 + 24*f1^2*f6*f8 - 6*f1^2*f7^2 + 4*f1*f3*f4*f8 -
f1*f3*f5*f7)*x[1]^2*x[2]*x[8] + (-32*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 -
8*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 + 8*f0*f1*f5*f6*f8 - 6*f0*f1*f5*f7^2 +
32*f0*f2^2*f8^2 - 96*f0*f2*f4*f6*f8 + 32*f0*f2*f4*f7^2 + 40*f0*f2*f5^2*f8 -
8*f0*f2*f5*f6*f7 + 32*f0*f3^2*f6*f8 - 12*f0*f3^2*f7^2 - 8*f0*f3*f4*f5*f8 -
12*f1^2*f2*f8^2 + 16*f1^2*f4*f6*f8 - 6*f1^2*f4*f7^2 - 9*f1^2*f5^2*f8 +
2*f1^2*f5*f6*f7)*x[1]^2*x[3]^2 + (-112*f0^2*f5*f8^2 + 96*f0^2*f6*f7*f8 -
24*f0^2*f7^3 + 96*f0*f1*f4*f8^2 - 20*f0*f1*f5*f7*f8 - 32*f0*f1*f6^2*f8 +
12*f0*f1*f6*f7^2 - 64*f0*f2*f3*f8^2 + 32*f0*f2*f5*f6*f8 - 12*f0*f2*f5*f7^2 -
32*f0*f3*f5^2*f8 + 8*f0*f3*f5*f6*f7 + 16*f0*f4^2*f5*f8 - 8*f1^2*f3*f8^2 -
8*f1^2*f4*f7*f8 - 8*f1^2*f5*f6*f8 + 6*f1^2*f5*f7^2 + 16*f1*f2^2*f8^2 +
32*f1*f2*f4*f6*f8 - 8*f1*f2*f4*f7^2 - 4*f1*f2*f5^2*f8 - 16*f1*f3^2*f6*f8 +
6*f1*f3^2*f7^2 + 4*f1*f3*f4*f5*f8)*x[1]^2*x[3]*x[4] + (64*f0^2*f5*f8^2 -
96*f0^2*f6*f7*f8 + 24*f0^2*f7^3 - 16*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 -
32*f0*f2*f3*f8^2 - 32*f0*f2*f4*f7*f8 - 32*f0*f2*f5*f6*f8 + 16*f0*f2*f5*f7^2 +
16*f0*f3^2*f7*f8 + 8*f0*f3*f5^2*f8 + 12*f1^2*f3*f8^2 + 8*f1^2*f4*f7*f8 +
12*f1^2*f5*f6*f8 - 5*f1^2*f5*f7^2)*x[1]^2*x[3]*x[5] + (-64*f0*f1*f5*f8^2 +
64*f0*f1*f6*f7*f8 - 18*f0*f1*f7^3 - 32*f0*f2*f4*f8^2 + 16*f0*f2*f5*f7*f8 +
48*f0*f3^2*f8^2 + 24*f0*f3*f5*f6*f8 - 10*f0*f3*f5*f7^2 - 8*f0*f4*f5^2*f8 +
32*f1^2*f4*f8^2 - 12*f1^2*f5*f7*f8 - 16*f1*f2*f3*f8^2 - 8*f1*f2*f5*f6*f8 +
2*f1*f2*f5*f7^2 - 4*f1*f3^2*f7*f8 - 2*f1*f3*f5^2*f8)*x[1]^2*x[3]*x[6] +
(-16*f0*f1*f6*f8^2 + 8*f0*f1*f7^2*f8 + 176*f0*f2*f5*f8^2 - 192*f0*f2*f6*f7*f8 +
48*f0*f2*f7^3 - 96*f0*f3*f4*f8^2 + 32*f0*f3*f5*f7*f8 - 48*f0*f4*f5*f6*f8 +
12*f0*f4*f5*f7^2 + 16*f0*f5^3*f8 - 40*f1^2*f5*f8^2 + 48*f1^2*f6*f7*f8 -
12*f1^2*f7^3 - 16*f1*f2*f4*f8^2 + 4*f1*f2*f5*f7*f8 + 24*f1*f3^2*f8^2 +
12*f1*f3*f5*f6*f8 - 3*f1*f3*f5*f7^2)*x[1]^2*x[3]*x[7] + (-8*f0*f1*f8^2 +
16*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 12*f0*f3*f7^2 - 2*f0*f5^2*f7 - 2*f1^2*f7*f8 -
8*f1*f2*f6*f8 + 2*f1*f2*f7^2 - 4*f1*f3*f5*f8)*x[1]^2*x[3]*x[8] +
(-16*f0^2*f6*f8^2 + 8*f0^2*f7^2*f8 + 48*f0*f1*f5*f8^2 - 48*f0*f1*f6*f7*f8 +
12*f0*f1*f7^3 + 8*f0*f2*f5*f7*f8 - 64*f0*f2*f6^2*f8 + 24*f0*f2*f6*f7^2 -
16*f0*f3^2*f8^2 + 24*f0*f3*f5*f6*f8 - 6*f0*f3*f5*f7^2 - 64*f0*f4^2*f6*f8 +
24*f0*f4^2*f7^2 + 20*f0*f4*f5^2*f8 - 8*f0*f4*f5*f6*f7 + 2*f0*f5^3*f7 -
32*f1^2*f4*f8^2 + 4*f1^2*f5*f7*f8 + 32*f1^2*f6^2*f8 - 12*f1^2*f6*f7^2 +
40*f1*f2*f3*f8^2 + 8*f1*f2*f4*f7*f8 - 8*f1*f2*f5*f6*f8 - 2*f1*f3^2*f7*f8 +
32*f1*f3*f4*f6*f8 - 12*f1*f3*f4*f7^2 + 2*f1*f3*f5^2*f8 - 8*f1*f4^2*f5*f8 -
16*f2^3*f8^2 - 32*f2^2*f4*f6*f8 + 8*f2^2*f4*f7^2 + 4*f2^2*f5^2*f8 +
8*f2*f3^2*f6*f8 - 2*f2*f3^2*f7^2)*x[1]^2*x[4]^2 + (-32*f0^2*f6*f8^2 +
16*f0^2*f7^2*f8 + 8*f0*f1*f5*f8^2 + 16*f0*f1*f6*f7*f8 - 6*f0*f1*f7^3 +
64*f0*f2*f4*f8^2 + 24*f0*f3*f5*f6*f8 - 10*f0*f3*f5*f7^2 - 8*f0*f4*f5^2*f8 -
16*f1^2*f4*f8^2 - 4*f1^2*f5*f7*f8 - 8*f1*f2*f5*f6*f8 + 2*f1*f2*f5*f7^2 -
4*f1*f3^2*f7*f8 - 2*f1*f3*f5^2*f8)*x[1]^2*x[4]*x[5] + (-32*f0^2*f7*f8^2 +
48*f0*f1*f6*f8^2 - 12*f0*f1*f7^2*f8 - 64*f0*f2*f5*f8^2 + 64*f0*f2*f6*f7*f8 -
24*f0*f2*f7^3 + 48*f0*f3*f4*f8^2 - 16*f0*f3*f5*f7*f8 - 32*f0*f4^2*f7*f8 +
48*f0*f4*f5*f6*f8 - 4*f0*f4*f5*f7^2 - 16*f0*f5^3*f8 + 24*f1^2*f5*f8^2 -
32*f1^2*f6*f7*f8 + 12*f1^2*f7^3 - 32*f1*f2*f4*f8^2 + 8*f1*f2*f5*f7*f8 -
20*f1*f3^2*f8^2 + 16*f1*f3*f4*f7*f8 - 24*f1*f3*f5*f6*f8 + 6*f1*f3*f5*f7^2 +
8*f1*f4*f5^2*f8 + 16*f2^2*f3*f8^2 + 16*f2^2*f5*f6*f8 -
4*f2^2*f5*f7^2)*x[1]^2*x[4]*x[6] + (-32*f0^2*f8^3 + 24*f0*f1*f7*f8^2 +
32*f0*f2*f6*f8^2 + 8*f0*f2*f7^2*f8 - 56*f0*f3*f5*f8^2 + 48*f0*f3*f6*f7*f8 -
12*f0*f3*f7^3 + 96*f0*f4^2*f8^2 - 24*f0*f4*f5*f7*f8 + 16*f0*f5^2*f6*f8 -
4*f0*f5^2*f7^2 - 16*f1^2*f6*f8^2 - 4*f1^2*f7^2*f8 - 24*f1*f3*f4*f8^2 -
2*f1*f3*f5*f7*f8 - 4*f1*f5^3*f8 + 32*f2^2*f4*f8^2 - 8*f2^2*f5*f7*f8 -
16*f2*f3^2*f8^2 - 8*f2*f3*f5*f6*f8 + 2*f2*f3*f5*f7^2)*x[1]^2*x[4]*x[7] +
(-16*f0*f2*f8^2 + 32*f0*f4*f6*f8 - 12*f0*f4*f7^2 - 20*f0*f5^2*f8 + 4*f0*f5*f6*f7
+ 8*f1^2*f8^2 - 4*f1*f2*f7*f8 - 24*f1*f3*f6*f8 + 9*f1*f3*f7^2 + 8*f1*f4*f5*f8 +
16*f2^2*f6*f8 - 4*f2^2*f7^2)*x[1]^2*x[4]*x[8] + (64*f0^2*f6*f8^2 -
16*f0^2*f7^2*f8 - 16*f0*f1*f5*f8^2 + 64*f0*f2*f4*f8^2 - 24*f0*f2*f5*f7*f8 +
32*f0*f2*f6^2*f8 - 8*f0*f2*f6*f7^2 - 16*f0*f3^2*f8^2 - 8*f0*f3*f5*f6*f8 +
2*f0*f3*f5*f7^2 - 20*f1^2*f4*f8^2 + 8*f1^2*f5*f7*f8 - 12*f1^2*f6^2*f8 +
3*f1^2*f6*f7^2)*x[1]^2*x[5]^2 + (-16*f0^2*f7*f8^2 - 48*f0*f1*f6*f8^2 +
16*f0*f1*f7^2*f8 - 48*f0*f2*f5*f8^2 + 16*f0*f2*f6*f7*f8 - 4*f0*f2*f7^3 -
48*f0*f3*f4*f8^2 + 32*f0*f3*f5*f7*f8 - 48*f0*f3*f6^2*f8 + 12*f0*f3*f6*f7^2 +
16*f0*f4*f5*f6*f8 - 4*f0*f4*f5*f7^2 + 16*f1^2*f5*f8^2 + 16*f1*f2*f4*f8^2 -
8*f1*f2*f5*f7*f8 + 16*f1*f2*f6^2*f8 - 4*f1*f2*f6*f7^2 + 8*f1*f3^2*f8^2 +
4*f1*f3*f5*f6*f8 - f1*f3*f5*f7^2)*x[1]^2*x[5]*x[6] + (32*f0^2*f8^3 -
8*f0*f1*f7*f8^2 + 160*f0*f2*f6*f8^2 - 40*f0*f2*f7^2*f8 - 64*f0*f3*f5*f8^2 +
96*f0*f4^2*f8^2 - 48*f0*f4*f5*f7*f8 + 96*f0*f4*f6^2*f8 - 24*f0*f4*f6*f7^2 -
32*f0*f5^2*f6*f8 + 8*f0*f5^2*f7^2 - 32*f1^2*f6*f8^2 + 8*f1^2*f7^2*f8 +
8*f1*f2*f5*f8^2 - 8*f1*f2*f6*f7*f8 + 2*f1*f2*f7^3 - 24*f1*f3*f4*f8^2 +
12*f1*f3*f5*f7*f8 - 24*f1*f3*f6^2*f8 + 6*f1*f3*f6*f7^2)*x[1]^2*x[5]*x[7] +
(-32*f0*f2*f8^2 + 8*f0*f3*f7*f8 - 48*f0*f4*f6*f8 + 12*f0*f4*f7^2 + 16*f0*f5^2*f8
+ 4*f1^2*f8^2 + 12*f1*f3*f6*f8 - 3*f1*f3*f7^2)*x[1]^2*x[5]*x[8] + (48*f0^2*f8^3
- 48*f0*f2*f6*f8^2 + 20*f0*f2*f7^2*f8 + 32*f0*f3*f5*f8^2 - 16*f0*f4^2*f8^2 +
16*f0*f4*f5*f7*f8 - 48*f0*f4*f6^2*f8 + 12*f0*f4*f6*f7^2 + 16*f0*f5^2*f6*f8 -
4*f0*f5^2*f7^2 + 16*f1^2*f6*f8^2 - 8*f1^2*f7^2*f8 + 8*f1*f2*f5*f8^2 -
8*f1*f2*f6*f7*f8 + 2*f1*f2*f7^3 + 8*f1*f3*f4*f8^2 - 12*f1*f3*f5*f7*f8 +
24*f1*f3*f6^2*f8 - 6*f1*f3*f6*f7^2 - 8*f1*f4*f5*f6*f8 + 2*f1*f4*f5*f7^2 -
16*f2^2*f4*f8^2 + 8*f2^2*f5*f7*f8 - 16*f2^2*f6^2*f8 +
4*f2^2*f6*f7^2)*x[1]^2*x[6]^2 + (-48*f0*f1*f8^3 - 32*f0*f2*f7*f8^2 -
32*f0*f3*f6*f8^2 + 8*f0*f3*f7^2*f8 - 80*f0*f4*f5*f8^2 + 48*f0*f4*f6*f7*f8 -
12*f0*f4*f7^3 + 16*f0*f5^2*f7*f8 - 32*f0*f5*f6^2*f8 + 8*f0*f5*f6*f7^2 +
16*f1^2*f7*f8^2 + 28*f1*f3*f5*f8^2 - 12*f1*f3*f6*f7*f8 + 3*f1*f3*f7^3 +
8*f1*f5^2*f6*f8 - 2*f1*f5^2*f7^2 - 16*f2^2*f5*f8^2 + 16*f2^2*f6*f7*f8 -
4*f2^2*f7^3 + 16*f2*f3*f4*f8^2 - 8*f2*f3*f5*f7*f8 + 16*f2*f3*f6^2*f8 -
4*f2*f3*f6*f7^2)*x[1]^2*x[6]*x[7] + (8*f0*f3*f8^2 + 8*f0*f4*f7*f8 +
16*f0*f5*f6*f8 - 6*f0*f5*f7^2 + 8*f1*f2*f8^2 - 6*f1*f3*f7*f8 - 4*f1*f5^2*f8 -
8*f2*f3*f6*f8 + 2*f2*f3*f7^2)*x[1]^2*x[6]*x[8] + (80*f0*f2*f8^3 -
24*f0*f3*f7*f8^2 + 48*f0*f4*f6*f8^2 + 28*f0*f5^2*f8^2 - 64*f0*f5*f6*f7*f8 +
10*f0*f5*f7^3 + 48*f0*f6^3*f8 - 12*f0*f6^2*f7^2 - 16*f1^2*f8^3 - 8*f1*f4*f5*f8^2
+ 4*f1*f5^2*f7*f8 - 8*f1*f5*f6^2*f8 + 2*f1*f5*f6*f7^2 - 16*f2^2*f6*f8^2 +
4*f2^2*f7^2*f8 + 16*f2*f3*f5*f8^2 - 8*f2*f3*f6*f7*f8 + 2*f2*f3*f7^3 -
16*f2*f4^2*f8^2 + 8*f2*f4*f5*f7*f8 - 16*f2*f4*f6^2*f8 + 4*f2*f4*f6*f7^2 +
4*f2*f5^2*f6*f8 - f2*f5^2*f7^2)*x[1]^2*x[7]^2 + (-48*f0*f4*f8^2 + 24*f0*f5*f7*f8
- 48*f0*f6^2*f8 + 12*f0*f6*f7^2 + 12*f1*f3*f8^2 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2 +
16*f2*f4*f6*f8 - 4*f2*f4*f7^2 - 4*f2*f5^2*f8)*x[1]^2*x[7]*x[8] + (-8*f0^2*f5*f7
+ 4*f0*f1*f3*f8)*x[1]*x[2]^3 + (24*f0^2*f5*f8 - 8*f0*f1*f4*f8 + 6*f0*f1*f5*f7 -
2*f1^2*f3*f8)*x[1]*x[2]^2*x[3] + (-64*f0^2*f6*f8 + 24*f0^2*f7^2 - 4*f0*f1*f5*f8
- 16*f0*f2*f4*f8 + 12*f0*f2*f5*f7 + 8*f1^2*f4*f8 - 6*f1^2*f5*f7 +
4*f1*f2*f3*f8)*x[1]*x[2]^2*x[4] + (-16*f0^2*f6*f8 - 32*f0*f2*f4*f8 +
8*f0*f2*f5*f7 + 8*f0*f3^2*f8 + 8*f1^2*f4*f8 - 2*f1^2*f5*f7)*x[1]*x[2]^2*x[5] +
(-8*f0^2*f7*f8 + 24*f0*f1*f6*f8 - 6*f0*f1*f7^2 + 8*f0*f3*f4*f8 - 4*f0*f3*f5*f7 -
2*f1*f3^2*f8)*x[1]*x[2]^2*x[6] + (16*f0^2*f8^2 - 48*f0*f2*f6*f8 + 8*f0*f2*f7^2 +
16*f0*f3*f5*f8 - 16*f0*f4^2*f8 + 4*f0*f4*f5*f7 + 8*f1^2*f6*f8 + 4*f1*f3*f4*f8 -
f1*f3*f5*f7)*x[1]*x[2]^2*x[7] + (8*f0*f2*f8 - 4*f1^2*f8)*x[1]*x[2]^2*x[8] +
(-8*f0*f1*f5*f8 + 32*f0*f2*f4*f8 - 8*f0*f2*f5*f7 - 8*f0*f3^2*f8 - 4*f1^2*f4*f8 +
f1^2*f5*f7)*x[1]*x[2]*x[3]^2 + (-32*f0^2*f7*f8 + 32*f0*f1*f6*f8 - 12*f0*f1*f7^2
- 16*f0*f2*f5*f8 - 8*f0*f3*f5*f7 + 8*f1^2*f5*f8 - 16*f1*f2*f4*f8 + 4*f1*f2*f5*f7
+ 4*f1*f3^2*f8)*x[1]*x[2]*x[3]*x[4] + (16*f0^2*f7*f8 + 16*f0*f2*f5*f8 -
4*f0*f3*f5*f7 - 6*f1^2*f5*f8)*x[1]*x[2]*x[3]*x[5] + (4*f0*f1*f7*f8 +
16*f0*f2*f6*f8 - 8*f0*f2*f7^2 - 4*f0*f3*f5*f8 + 4*f0*f4*f5*f7 - 16*f1^2*f6*f8 +
6*f1^2*f7^2 + 4*f1*f2*f5*f8 + f1*f3*f5*f7)*x[1]*x[2]*x[3]*x[6] + (-8*f0*f1*f8^2
+ 32*f0*f2*f7*f8 + 16*f0*f4*f5*f8 - 6*f0*f5^2*f7 - 10*f1^2*f7*f8 + 8*f1*f2*f6*f8
- 4*f1*f2*f7^2 - 8*f1*f3*f5*f8)*x[1]*x[2]*x[3]*x[7] + (-8*f0*f3*f8 +
4*f1*f2*f8)*x[1]*x[2]*x[3]*x[8] + (32*f0^2*f8^2 + 12*f0*f1*f7*f8 +
64*f0*f2*f6*f8 - 24*f0*f2*f7^2 - 4*f0*f3*f5*f8 + 16*f0*f4^2*f8 - 4*f0*f4*f5*f7 -
32*f1^2*f6*f8 + 12*f1^2*f7^2 - 8*f1*f3*f4*f8 + 6*f1*f3*f5*f7 + 16*f2^2*f4*f8 -
4*f2^2*f5*f7 - 4*f2*f3^2*f8)*x[1]*x[2]*x[4]^2 + (4*f0*f1*f7*f8 - 48*f0*f2*f6*f8
+ 16*f0*f2*f7^2 + 4*f0*f3*f5*f8 + 4*f0*f4*f5*f7 + 16*f1^2*f6*f8 - 6*f1^2*f7^2 +
4*f1*f2*f5*f8 + f1*f3*f5*f7)*x[1]*x[2]*x[4]*x[5] + (-24*f0*f1*f8^2 +
16*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 12*f0*f3*f7^2 - 8*f0*f4*f5*f8 + 4*f0*f5^2*f7 -
12*f1^2*f7*f8 + 16*f1*f2*f6*f8 - 4*f1*f2*f7^2 - 4*f1*f4*f5*f7 -
8*f2^2*f5*f8)*x[1]*x[2]*x[4]*x[6] + (-48*f0*f2*f8^2 - 16*f0*f3*f7*f8 -
64*f0*f4*f6*f8 + 24*f0*f4*f7^2 + 12*f0*f5^2*f8 - 4*f0*f5*f6*f7 + 24*f1^2*f8^2 +
4*f1*f2*f7*f8 + 32*f1*f3*f6*f8 - 12*f1*f3*f7^2 + 2*f1*f5^2*f7 - 16*f2^2*f6*f8 +
8*f2^2*f7^2 + 8*f2*f3*f5*f8)*x[1]*x[2]*x[4]*x[7] + (-2*f0*f5*f7 + 2*f1*f3*f8 -
8*f2^2*f8)*x[1]*x[2]*x[4]*x[8] + (-32*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 8*f0*f3*f5*f8
+ 12*f1^2*f6*f8 - 3*f1^2*f7^2)*x[1]*x[2]*x[5]^2 + (48*f0*f3*f6*f8 -
12*f0*f3*f7^2 - 16*f0*f4*f5*f8 - 16*f1*f2*f6*f8 + 4*f1*f2*f7^2 -
4*f1*f3*f5*f8)*x[1]*x[2]*x[5]*x[6] + (-16*f0*f2*f8^2 - 96*f0*f4*f6*f8 +
24*f0*f4*f7^2 + 32*f0*f5^2*f8 - 4*f1^2*f8^2 + 4*f1*f2*f7*f8 + 24*f1*f3*f6*f8 -
6*f1*f3*f7^2)*x[1]*x[2]*x[5]*x[7] + (16*f0*f4*f8 - 6*f0*f5*f7 -
4*f1*f3*f8)*x[1]*x[2]*x[5]*x[8] + (-8*f0*f3*f7*f8 + 48*f0*f4*f6*f8 -
12*f0*f4*f7^2 - 16*f0*f5^2*f8 + 8*f1^2*f8^2 - 24*f1*f3*f6*f8 + 6*f1*f3*f7^2 +
8*f1*f4*f5*f8 + 16*f2^2*f6*f8 - 4*f2^2*f7^2)*x[1]*x[2]*x[6]^2 + (32*f0*f3*f8^2 -
16*f0*f4*f7*f8 + 32*f0*f5*f6*f8 - 6*f0*f5*f7^2 - 8*f1*f2*f8^2 + 8*f1*f3*f7*f8 -
8*f1*f5^2*f8 - 8*f2^2*f7*f8 - 16*f2*f3*f6*f8 + 4*f2*f3*f7^2)*x[1]*x[2]*x[6]*x[7]
+ (-4*f0*f5*f8 + 2*f1*f5*f7 + 4*f2*f3*f8)*x[1]*x[2]*x[6]*x[8] + (16*f0*f5*f7*f8
- 48*f0*f6^2*f8 + 12*f0*f6*f7^2 - 12*f1*f3*f8^2 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2 +
16*f2^2*f8^2 + 16*f2*f4*f6*f8 - 4*f2*f4*f7^2 - 4*f2*f5^2*f8)*x[1]*x[2]*x[7]^2 +
(56*f0*f6*f8 - 12*f0*f7^2 - 8*f1*f5*f8 - 8*f2*f4*f8 +
2*f2*f5*f7)*x[1]*x[2]*x[7]*x[8] - 4*f0*f8*x[1]*x[2]*x[8]^2 + (-16*f0*f2*f5*f8 +
4*f0*f3*f5*f7 + 4*f1^2*f5*f8)*x[1]*x[3]^3 + (48*f0^2*f8^2 + 4*f0*f1*f7*f8 +
28*f0*f3*f5*f8 - 3*f1*f3*f5*f7)*x[1]*x[3]^2*x[4] + (-16*f0^2*f8^2 +
32*f0*f2*f6*f8 - 8*f0*f2*f7^2 - 8*f0*f3*f5*f8 - 8*f1^2*f6*f8 +
3*f1^2*f7^2)*x[1]*x[3]^2*x[5] + (-32*f0*f3*f6*f8 + 12*f0*f3*f7^2 - 2*f0*f5^2*f7
- 2*f1^2*f7*f8 + 8*f1*f2*f6*f8 - 4*f1*f2*f7^2 + 2*f1*f3*f5*f8)*x[1]*x[3]^2*x[6]
+ (-32*f0*f2*f8^2 + 64*f0*f4*f6*f8 - 24*f0*f4*f7^2 - 28*f0*f5^2*f8 +
8*f0*f5*f6*f7 + 16*f1^2*f8^2 - 16*f1*f3*f6*f8 + 6*f1*f3*f7^2 +
4*f1*f4*f5*f8)*x[1]*x[3]^2*x[7] + (-8*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8)*x[1]*x[3]^2*x[8] + (-48*f0*f1*f8^2 + 8*f0*f2*f7*f8 - 24*f0*f3*f6*f8
+ 12*f0*f3*f7^2 - 24*f0*f4*f5*f8 + 2*f0*f5^2*f7 - 4*f1^2*f7*f8 - 8*f1*f3*f5*f8 +
2*f2*f3*f5*f7)*x[1]*x[3]*x[4]^2 + (-8*f0*f1*f8^2 - 16*f0*f4*f5*f8 - 2*f0*f5^2*f7
+ 2*f1^2*f7*f8 - 8*f1*f2*f6*f8 + 4*f1*f3*f5*f8)*x[1]*x[3]*x[4]*x[5] +
(16*f0*f2*f8^2 - 24*f0*f3*f7*f8 + 28*f0*f5^2*f8 - 4*f0*f5*f6*f7 + 8*f1^2*f8^2 +
4*f1*f2*f7*f8 + 32*f1*f3*f6*f8 - 12*f1*f3*f7^2 + 2*f1*f5^2*f7 - 16*f2^2*f6*f8 +
8*f2^2*f7^2)*x[1]*x[3]*x[4]*x[6] + (80*f0*f3*f8^2 - 8*f0*f5*f6*f8 -
24*f1*f2*f8^2 + 4*f1*f3*f7*f8 - 32*f1*f4*f6*f8 + 12*f1*f4*f7^2 + 10*f1*f5^2*f8 -
4*f1*f5*f6*f7 + 16*f2*f3*f6*f8 - 8*f2*f3*f7^2 -
8*f2*f4*f5*f8)*x[1]*x[3]*x[4]*x[7] + (20*f0*f5*f8 + 4*f1*f4*f8 -
f1*f5*f7)*x[1]*x[3]*x[4]*x[8] - 4*f1^2*f7*f8*x[1]*x[3]*x[5]^2 + (16*f0*f2*f8^2 -
16*f0*f3*f7*f8 + 16*f0*f5^2*f8 - 4*f1^2*f8^2 +
12*f1*f2*f7*f8)*x[1]*x[3]*x[5]*x[6] + (32*f0*f4*f7*f8 - 8*f0*f5*f7^2 -
8*f1*f3*f7*f8 - 4*f1*f5^2*f8)*x[1]*x[3]*x[5]*x[7] + (4*f0*f5*f8 +
f1*f5*f7)*x[1]*x[3]*x[5]*x[8] + (-24*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 8*f1*f2*f8^2 +
8*f1*f3*f7*f8 - 4*f1*f5^2*f8 - 8*f2^2*f7*f8)*x[1]*x[3]*x[6]^2 + (-16*f1*f3*f8^2
- 8*f1*f4*f7*f8 + 12*f1*f5*f6*f8 - f1*f5*f7^2 + 16*f2^2*f8^2 + 8*f2*f3*f7*f8 +
4*f2*f5^2*f8)*x[1]*x[3]*x[6]*x[7] + (-40*f0*f6*f8 + 12*f0*f7^2 - 2*f1*f5*f8 -
2*f2*f5*f7)*x[1]*x[3]*x[6]*x[8] + (-56*f0*f5*f8^2 + 48*f0*f6*f7*f8 - 12*f0*f7^3
+ 24*f1*f4*f8^2 - 6*f1*f5*f7*f8 - 16*f2*f3*f8^2 - 8*f2*f5*f6*f8 +
2*f2*f5*f7^2)*x[1]*x[3]*x[7]^2 + (-8*f0*f7*f8 + 8*f2*f5*f8)*x[1]*x[3]*x[7]*x[8]
+ (-16*f0*f2*f8^2 - 4*f0*f3*f7*f8 + 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 - 4*f0*f5^2*f8
+ 4*f0*f5*f6*f7 + 16*f1^2*f8^2 + 8*f1*f3*f6*f8 - 4*f1*f3*f7^2 + 8*f1*f4*f5*f8 -
2*f1*f5^2*f7 - f3^2*f5*f7)*x[1]*x[4]^3 + (16*f0*f2*f8^2 - 4*f0*f3*f7*f8 +
64*f0*f4*f6*f8 - 24*f0*f4*f7^2 - 12*f0*f5^2*f8 + 4*f0*f5*f6*f7 - 4*f1*f2*f7*f8 -
24*f1*f3*f6*f8 + 9*f1*f3*f7^2 + 8*f1*f4*f5*f8 + 16*f2^2*f6*f8 - 4*f2^2*f7^2 -
4*f2*f3*f5*f8)*x[1]*x[4]^2*x[5] + (24*f0*f3*f8^2 + 24*f0*f4*f7*f8 -
8*f0*f5*f6*f8 - 6*f0*f5*f7^2 - 16*f1*f2*f8^2 + 8*f1*f3*f7*f8 - 32*f1*f4*f6*f8 +
12*f1*f4*f7^2 - 2*f2*f3*f7^2 + 2*f3^2*f5*f8)*x[1]*x[4]^2*x[6] + (-16*f0*f4*f8^2
+ 32*f0*f6^2*f8 - 12*f0*f6*f7^2 - 32*f1*f3*f8^2 - 8*f1*f4*f7*f8 - 8*f1*f5*f6*f8
+ 6*f1*f5*f7^2 + 16*f2^2*f8^2 + 32*f2*f4*f6*f8 - 8*f2*f4*f7^2 - 4*f2*f5^2*f8 -
16*f3^2*f6*f8 + 6*f3^2*f7^2 + 4*f3*f4*f5*f8)*x[1]*x[4]^2*x[7] + (-16*f0*f6*f8 +
6*f0*f7^2 - 4*f1*f5*f8 - 8*f2*f4*f8 + 2*f2*f5*f7 + 2*f3^2*f8)*x[1]*x[4]^2*x[8] +
(-16*f0*f2*f8^2 + 8*f0*f5^2*f8 + 4*f1^2*f8^2 + 4*f1*f2*f7*f8)*x[1]*x[4]*x[5]^2 +
(-16*f0*f3*f8^2 + 32*f0*f4*f7*f8 - 48*f0*f5*f6*f8 + 10*f0*f5*f7^2 + 8*f1*f2*f8^2
- 4*f1*f3*f7*f8 - 8*f1*f5^2*f8 - 8*f2^2*f7*f8)*x[1]*x[4]*x[5]*x[6] +
(-96*f0*f4*f8^2 + 16*f0*f5*f7*f8 + 32*f1*f3*f8^2 - 8*f1*f4*f7*f8 +
12*f1*f5*f6*f8 - f1*f5*f7^2 - 16*f2^2*f8^2 + 8*f2*f3*f7*f8 +
4*f2*f5^2*f8)*x[1]*x[4]*x[5]*x[7] + (8*f0*f6*f8 -
8*f1*f5*f8)*x[1]*x[4]*x[5]*x[8] + (-48*f0*f4*f8^2 + 20*f0*f5*f7*f8 +
8*f1*f3*f8^2 - 16*f1*f4*f7*f8 + 24*f1*f5*f6*f8 - 6*f1*f5*f7^2 +
8*f2*f3*f7*f8)*x[1]*x[4]*x[6]^2 + (16*f0*f5*f8^2 - 32*f0*f6*f7*f8 + 12*f0*f7^3 +
64*f1*f4*f8^2 - 16*f1*f5*f7*f8 - 16*f2*f3*f8^2 - 16*f2*f5*f6*f8 + 4*f2*f5*f7^2 -
8*f3^2*f7*f8 - 4*f3*f5^2*f8)*x[1]*x[4]*x[6]*x[7] + (-8*f0*f7*f8 + 16*f1*f6*f8 -
6*f1*f7^2 + 4*f2*f5*f8 + f3*f5*f7)*x[1]*x[4]*x[6]*x[8] + (-16*f0*f6*f8^2 -
4*f0*f7^2*f8 + 16*f1*f5*f8^2 - 32*f2*f4*f8^2 + 8*f2*f5*f7*f8 + 24*f3^2*f8^2 +
12*f3*f5*f6*f8 - 3*f3*f5*f7^2)*x[1]*x[4]*x[7]^2 + (16*f0*f8^2 + 2*f1*f7*f8 -
8*f2*f6*f8 - 8*f3*f5*f8)*x[1]*x[4]*x[7]*x[8] + 4*f2*f8*x[1]*x[4]*x[8]^2 +
4*f1^2*f8^2*x[1]*x[5]^3 + (16*f0*f3*f8^2 - 16*f0*f5*f6*f8 + 4*f0*f5*f7^2 -
16*f1*f2*f8^2)*x[1]*x[5]^2*x[6] + (-32*f0*f4*f8^2 + 8*f0*f5*f7*f8 + 8*f1*f3*f8^2
+ 4*f1*f5*f6*f8 - f1*f5*f7^2)*x[1]*x[5]^2*x[7] - 2*f1*f5*f8*x[1]*x[5]^2*x[8] +
(16*f0*f4*f8^2 - 24*f0*f5*f7*f8 + 48*f0*f6^2*f8 - 12*f0*f6*f7^2 - 4*f1*f3*f8^2 +
8*f1*f5*f6*f8 - 2*f1*f5*f7^2 + 16*f2^2*f8^2)*x[1]*x[5]*x[6]^2 + (72*f0*f5*f8^2 -
48*f0*f6*f7*f8 + 12*f0*f7^3 - 8*f1*f4*f8^2 + 8*f1*f5*f7*f8 - 24*f1*f6^2*f8 +
6*f1*f6*f7^2 - 16*f2*f3*f8^2 - 8*f2*f5*f6*f8 + 2*f2*f5*f7^2)*x[1]*x[5]*x[6]*x[7]
+ (-8*f0*f7*f8 + 12*f1*f6*f8 - 3*f1*f7^2 + 4*f2*f5*f8)*x[1]*x[5]*x[6]*x[8] +
(-16*f0*f6*f8^2 + 4*f0*f7^2*f8 - 12*f1*f5*f8^2 + 12*f1*f6*f7*f8 - 3*f1*f7^3 +
16*f2*f4*f8^2 - 8*f2*f5*f7*f8 + 16*f2*f6^2*f8 - 4*f2*f6*f7^2)*x[1]*x[5]*x[7]^2 +
(16*f0*f8^2 - 16*f2*f6*f8 + 4*f2*f7^2)*x[1]*x[5]*x[7]*x[8] + (-8*f0*f6*f7*f8 +
2*f0*f7^3 + 8*f1*f5*f7*f8 - 16*f1*f6^2*f8 + 4*f1*f6*f7^2 -
8*f2*f3*f8^2)*x[1]*x[6]^3 + (32*f0*f6*f8^2 - 12*f0*f7^2*f8 - 32*f1*f5*f8^2 +
24*f1*f6*f7*f8 - 6*f1*f7^3 + 16*f2*f4*f8^2 - 8*f2*f5*f7*f8 + 16*f2*f6^2*f8 -
4*f2*f6*f7^2 + 8*f3^2*f8^2 + 4*f3*f5*f6*f8 - f3*f5*f7^2)*x[1]*x[6]^2*x[7] +
(8*f0*f8^2 + 4*f1*f7*f8 - 8*f2*f6*f8 + 2*f2*f7^2 - 2*f3*f5*f8)*x[1]*x[6]^2*x[8]
+ (16*f0*f7*f8^2 - 16*f1*f6*f8^2 + 4*f1*f7^2*f8 + 16*f2*f5*f8^2 - 16*f2*f6*f7*f8
+ 4*f2*f7^3 - 24*f3*f4*f8^2 + 12*f3*f5*f7*f8 - 24*f3*f6^2*f8 +
6*f3*f6*f7^2)*x[1]*x[6]*x[7]^2 + (-12*f1*f8^2 + 4*f2*f7*f8 + 24*f3*f6*f8 -
6*f3*f7^2)*x[1]*x[6]*x[7]*x[8] - 2*f3*f8*x[1]*x[6]*x[8]^2 + (-16*f0*f8^3 +
16*f2*f6*f8^2 - 4*f2*f7^2*f8 - 16*f3*f5*f8^2 + 8*f3*f6*f7*f8 - 2*f3*f7^3 +
16*f4^2*f8^2 - 8*f4*f5*f7*f8 + 16*f4*f6^2*f8 - 4*f4*f6*f7^2 - 4*f5^2*f6*f8 +
f5^2*f7^2)*x[1]*x[7]^3 + (-8*f2*f8^2 - 24*f4*f6*f8 + 6*f4*f7^2 +
6*f5^2*f8)*x[1]*x[7]^2*x[8] + (4*f4*f8 - f5*f7)*x[1]*x[7]*x[8]^2 + (4*f0^2*f6 +
4*f0*f2*f4 - f0*f3^2 - f1^2*f4)*x[2]^4 + (-8*f0^2*f7 - 4*f0*f1*f6 - 8*f0*f2*f5 +
2*f1^2*f5)*x[2]^3*x[3] + (8*f0^2*f8 + 2*f0*f1*f7 - 8*f0*f2*f6 + 4*f0*f3*f5 +
4*f1^2*f6)*x[2]^3*x[4] + (8*f0^2*f8 + 2*f0*f1*f7)*x[2]^3*x[5] + (-4*f0*f1*f8 +
4*f0*f2*f7 - 2*f1^2*f7)*x[2]^3*x[6] + (-4*f0*f4 + f1*f3)*x[2]^3*x[8] +
(8*f0^2*f8 + 6*f0*f1*f7 + 16*f0*f2*f6 + 2*f0*f3*f5 - 3*f1^2*f6)*x[2]^2*x[3]^2 +
(-8*f0*f1*f8 + 8*f0*f2*f7 - 4*f0*f4*f5 - 6*f1^2*f7 - 4*f1*f2*f6 -
f1*f3*f5)*x[2]^2*x[3]*x[4] + (-12*f0*f1*f8 - 16*f0*f2*f7 +
3*f1^2*f7)*x[2]^2*x[3]*x[5] + (-8*f0*f2*f8 + 8*f1^2*f8 +
2*f1*f2*f7)*x[2]^2*x[3]*x[6] + 8*f0*f5*x[2]^2*x[3]*x[8] + (-4*f0*f2*f8 -
6*f0*f3*f7 + 12*f0*f4*f6 - 4*f0*f5^2 + 4*f1^2*f8 + 2*f1*f2*f7 - 6*f1*f3*f6 +
2*f1*f4*f5 + 4*f2^2*f6)*x[2]^2*x[4]^2 + (4*f1^2*f8 +
2*f1*f2*f7)*x[2]^2*x[4]*x[5] + (16*f0*f3*f8 - 12*f0*f4*f7 - 8*f1*f2*f8 +
6*f1*f3*f7 - 4*f2^2*f7)*x[2]^2*x[4]*x[6] + (8*f0*f4*f8 + 2*f0*f5*f7 -
4*f1*f3*f8)*x[2]^2*x[4]*x[7] - 2*f1*f5*x[2]^2*x[4]*x[8] + (16*f0*f2*f8 -
3*f1^2*f8)*x[2]^2*x[5]^2 + (-4*f0*f3*f8 - 4*f1*f2*f8)*x[2]^2*x[5]*x[6] +
(8*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8)*x[2]^2*x[5]*x[7] + (4*f0*f4*f8 +
2*f0*f5*f7 - 2*f1*f3*f8 + 4*f2^2*f8)*x[2]^2*x[6]^2 -
12*f0*f5*f8*x[2]^2*x[6]*x[7] + 2*f1*f5*f8*x[2]^2*x[7]^2 -
4*f0*f8*x[2]^2*x[7]*x[8] - f2*x[2]^2*x[8]^2 + (-4*f0*f1*f8 - 8*f0*f2*f7 -
8*f0*f3*f6 + f1^2*f7)*x[2]*x[3]^3 + (-8*f0*f2*f8 + 4*f0*f5^2 + 4*f1^2*f8 +
4*f1*f2*f7 + 6*f1*f3*f6)*x[2]*x[3]^2*x[4] + (16*f0*f2*f8 + 12*f0*f3*f7 -
2*f1^2*f8)*x[2]*x[3]^2*x[5] + (4*f0*f3*f8 - 4*f1*f2*f8 -
3*f1*f3*f7)*x[2]*x[3]^2*x[6] + (-8*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8)*x[2]*x[3]^2*x[7] + (-12*f0*f6 - f1*f5)*x[2]*x[3]^2*x[8] +
(8*f0*f3*f8 - 4*f0*f5*f6 + 3*f1*f3*f7 - 2*f1*f5^2 - 4*f2^2*f7 -
4*f2*f3*f6)*x[2]*x[3]*x[4]^2 + (-4*f1*f2*f8 - 6*f1*f3*f7)*x[2]*x[3]*x[4]*x[5] +
(6*f0*f5*f7 - 10*f1*f3*f8 + 8*f2^2*f8 + 4*f2*f3*f7)*x[2]*x[3]*x[4]*x[6] +
(-4*f0*f5*f8 + 4*f1*f4*f8 - f1*f5*f7)*x[2]*x[3]*x[4]*x[7] + (6*f1*f6 +
2*f2*f5)*x[2]*x[3]*x[4]*x[8] - 16*f0*f3*f8*x[2]*x[3]*x[5]^2 + (-2*f0*f5*f7 +
8*f1*f3*f8)*x[2]*x[3]*x[5]*x[6] + (-4*f0*f5*f8 + f1*f5*f7)*x[2]*x[3]*x[5]*x[7] +
12*f0*f7*x[2]*x[3]*x[5]*x[8] + (-4*f0*f5*f8 - 4*f2*f3*f8)*x[2]*x[3]*x[6]^2 +
(40*f0*f6*f8 - 12*f0*f7^2)*x[2]*x[3]*x[6]*x[7] - 3*f1*f7*x[2]*x[3]*x[6]*x[8] +
(-8*f1*f6*f8 + 3*f1*f7^2)*x[2]*x[3]*x[7]^2 + 2*f1*f8*x[2]*x[3]*x[7]*x[8] +
(-8*f0*f4*f8 + 10*f0*f5*f7 - 8*f0*f6^2 - 4*f1*f4*f7 + 4*f1*f5*f6 + 2*f2*f3*f7 +
2*f3^2*f6)*x[2]*x[4]^3 + (-8*f0*f4*f8 + 2*f2*f3*f7)*x[2]*x[4]^2*x[5] +
(-20*f0*f5*f8 + 12*f0*f6*f7 + 16*f1*f4*f8 - 6*f1*f5*f7 - 4*f2*f3*f8 -
3*f3^2*f7)*x[2]*x[4]^2*x[6] + (8*f0*f6*f8 - 6*f0*f7^2 - 8*f2*f4*f8 + 2*f2*f5*f7
+ 2*f3^2*f8)*x[2]*x[4]^2*x[7] + (-4*f2*f6 - f3*f5)*x[2]*x[4]^2*x[8] +
(-2*f0*f5*f7 + 4*f1*f3*f8)*x[2]*x[4]*x[5]^2 + (12*f0*f5*f8 + 2*f1*f5*f7 -
4*f2*f3*f8)*x[2]*x[4]*x[5]*x[6] + (-8*f0*f6*f8 - 2*f1*f5*f8 -
2*f2*f5*f7)*x[2]*x[4]*x[5]*x[7] - 3*f1*f7*x[2]*x[4]*x[5]*x[8] + (-6*f0*f7^2 +
4*f3^2*f8)*x[2]*x[4]*x[6]^2 + (16*f0*f7*f8 - 16*f1*f6*f8 + 6*f1*f7^2 +
4*f2*f5*f8 + f3*f5*f7)*x[2]*x[4]*x[6]*x[7] + 4*f2*f7*x[2]*x[4]*x[6]*x[8] +
(-8*f0*f8^2 - 2*f1*f7*f8 + 8*f2*f6*f8 - 4*f2*f7^2 - 4*f3*f5*f8)*x[2]*x[4]*x[7]^2
+ 4*f2*f8*x[2]*x[4]*x[7]*x[8] + 8*f0*f5*f8*x[2]*x[5]^2*x[6] -
2*f1*f5*f8*x[2]*x[5]^2*x[7] - 8*f0*f8*x[2]*x[5]^2*x[8] + (-24*f0*f6*f8 +
6*f0*f7^2 - 4*f1*f5*f8)*x[2]*x[5]*x[6]^2 + (8*f0*f7*f8 + 12*f1*f6*f8 - 3*f1*f7^2
+ 4*f2*f5*f8)*x[2]*x[5]*x[6]*x[7] + 2*f1*f8*x[2]*x[5]*x[6]*x[8] + (-8*f0*f8^2 -
2*f1*f7*f8 - 8*f2*f6*f8 + 2*f2*f7^2)*x[2]*x[5]*x[7]^2 +
4*f2*f8*x[2]*x[5]*x[7]*x[8] + (4*f0*f7*f8 + 8*f1*f6*f8 - 2*f1*f7^2)*x[2]*x[6]^3
+ (-16*f0*f8^2 - 4*f1*f7*f8 - 8*f2*f6*f8 + 2*f2*f7^2 -
2*f3*f5*f8)*x[2]*x[6]^2*x[7] - 4*f2*f8*x[2]*x[6]^2*x[8] + (12*f1*f8^2 +
4*f2*f7*f8 + 12*f3*f6*f8 - 3*f3*f7^2)*x[2]*x[6]*x[7]^2 -
4*f3*f8*x[2]*x[6]*x[7]*x[8] + (-8*f2*f8^2 - 8*f4*f6*f8 + 2*f4*f7^2 +
2*f5^2*f8)*x[2]*x[7]^3 + (4*f4*f8 - f5*f7)*x[2]*x[7]^2*x[8] + x[2]*x[8]^3 +
(4*f0*f2*f8 + 2*f0*f3*f7 + 4*f0*f4*f6 - f0*f5^2)*x[3]^4 + (-4*f0*f5*f6 -
4*f1*f2*f8 - 2*f1*f3*f7 - 4*f1*f4*f6 + f1*f5^2)*x[3]^3*x[4] + (-8*f0*f3*f8 -
8*f0*f4*f7)*x[3]^3*x[5] + (2*f0*f5*f7 + 2*f1*f3*f8 + 2*f1*f4*f7)*x[3]^3*x[6] +
(4*f0*f5*f8 - f1*f5*f7)*x[3]^3*x[7] + (4*f0*f7 + 2*f1*f6)*x[3]^3*x[8] +
(-8*f0*f5*f7 + 12*f0*f6^2 + 2*f1*f5*f6 + 4*f2^2*f8 + 2*f2*f3*f7 + 4*f2*f4*f6 -
f2*f5^2)*x[3]^2*x[4]^2 + (6*f0*f5*f7 + 6*f1*f3*f8 + 6*f1*f4*f7)*x[3]^2*x[4]*x[5]
+ (-12*f0*f6*f7 - 2*f1*f5*f7 - 4*f2*f3*f8 - 4*f2*f4*f7)*x[3]^2*x[4]*x[6] +
(-24*f0*f6*f8 + 12*f0*f7^2 + 2*f2*f5*f7)*x[3]^2*x[4]*x[7] + (4*f0*f8 - 3*f1*f7 -
4*f2*f6)*x[3]^2*x[4]*x[8] + (16*f0*f4*f8 + 2*f0*f5*f7)*x[3]^2*x[5]^2 +
(-8*f0*f5*f8 - 8*f1*f4*f8 - f1*f5*f7)*x[3]^2*x[5]*x[6] +
2*f1*f5*f8*x[3]^2*x[5]*x[7] + (-12*f0*f8 - 3*f1*f7)*x[3]^2*x[5]*x[8] +
(4*f0*f6*f8 + 4*f1*f5*f8 + 4*f2*f4*f8)*x[3]^2*x[6]^2 + (-4*f0*f7*f8 - 8*f1*f6*f8
+ 3*f1*f7^2 - 4*f2*f5*f8)*x[3]^2*x[6]*x[7] + (4*f1*f8 +
2*f2*f7)*x[3]^2*x[6]*x[8] + (8*f0*f8^2 - 2*f1*f7*f8 + 8*f2*f6*f8 -
2*f2*f7^2)*x[3]^2*x[7]^2 - 4*f2*f8*x[3]^2*x[7]*x[8] + (8*f0*f5*f8 - 4*f0*f6*f7 +
6*f1*f5*f7 - 8*f1*f6^2 - 4*f2*f3*f8 - 2*f3^2*f7 - 4*f3*f4*f6 +
f3*f5^2)*x[3]*x[4]^3 + (12*f0*f5*f8 - 12*f0*f6*f7 - 2*f1*f5*f7 - 4*f2*f3*f8 -
4*f2*f4*f7)*x[3]*x[4]^2*x[5] + (6*f0*f7^2 - 8*f1*f5*f8 + 12*f1*f6*f7 + 6*f3^2*f8
+ 6*f3*f4*f7)*x[3]*x[4]^2*x[6] + (-8*f0*f7*f8 + 24*f1*f6*f8 - 12*f1*f7^2 -
3*f3*f5*f7)*x[3]*x[4]^2*x[7] + (-4*f1*f8 + 2*f2*f7 + 6*f3*f6)*x[3]*x[4]^2*x[8] +
(-4*f0*f5*f8 - 8*f1*f4*f8 - f1*f5*f7)*x[3]*x[4]*x[5]^2 + (40*f0*f6*f8 +
8*f2*f4*f8 + 2*f2*f5*f7)*x[3]*x[4]*x[5]*x[6] - 16*f0*f7*f8*x[3]*x[4]*x[5]*x[7] +
(6*f1*f8 + 4*f2*f7)*x[3]*x[4]*x[5]*x[8] + (-8*f0*f7*f8 - 16*f1*f6*f8 -
8*f3*f4*f8 - f3*f5*f7)*x[3]*x[4]*x[6]^2 + (14*f1*f7*f8 + 8*f2*f6*f8 - 4*f2*f7^2
+ 4*f3*f5*f8)*x[3]*x[4]*x[6]*x[7] + (-4*f2*f8 - 6*f3*f7)*x[3]*x[4]*x[6]*x[8] +
(-8*f1*f8^2 - 16*f3*f6*f8 + 6*f3*f7^2 + 4*f4*f5*f8)*x[3]*x[4]*x[7]^2 +
4*f3*f8*x[3]*x[4]*x[7]*x[8] - f5*x[3]*x[4]*x[8]^2 - 8*f0*f5*f8*x[3]*x[5]^3 +
6*f1*f5*f8*x[3]*x[5]^2*x[6] + 4*f1*f8*x[3]*x[5]^2*x[8] -
4*f2*f5*f8*x[3]*x[5]*x[6]^2 - 4*f1*f7*f8*x[3]*x[5]*x[6]*x[7] -
4*f2*f8*x[3]*x[5]*x[6]*x[8] + 4*f1*f8^2*x[3]*x[5]*x[7]^2 +
2*f3*f5*f8*x[3]*x[6]^3 + (4*f1*f8^2 + 4*f2*f7*f8)*x[3]*x[6]^2*x[7] +
4*f3*f8*x[3]*x[6]^2*x[8] + (-8*f2*f8^2 - 4*f3*f7*f8 -
2*f5^2*f8)*x[3]*x[6]*x[7]^2 + f5*f7*x[3]*x[6]*x[7]*x[8] + (8*f3*f8^2 +
4*f5*f6*f8 - f5*f7^2)*x[3]*x[7]^3 - 4*f5*f8*x[3]*x[7]^2*x[8] + (4*f0*f6*f8 -
2*f0*f7^2 - 4*f1*f5*f8 + 2*f1*f6*f7 + 4*f2*f4*f8 - 4*f2*f5*f7 + 4*f2*f6^2 +
2*f3*f4*f7 - 2*f3*f5*f6 + 4*f4^2*f6 - f4*f5^2)*x[4]^4 + (-8*f0*f6*f8 + 6*f0*f7^2
- 4*f1*f5*f8 + 4*f1*f6*f7 + 2*f3^2*f8 + 2*f3*f4*f7)*x[4]^3*x[5] + (4*f0*f7*f8 -
4*f1*f7^2 + 8*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 + 4*f3*f5*f7 -
8*f4^2*f7)*x[4]^3*x[6] + (4*f1*f7*f8 - 16*f2*f6*f8 + 8*f2*f7^2 + 4*f3*f5*f8 +
4*f4*f5*f7)*x[4]^3*x[7] + (-f3*f7 - 8*f4*f6 + 2*f5^2)*x[4]^3*x[8] +
(-12*f0*f6*f8 + 6*f0*f7^2 + 2*f1*f5*f8 + 4*f2*f4*f8)*x[4]^2*x[5]^2 +
(-20*f0*f7*f8 - 6*f1*f7^2 - 8*f3*f4*f8 - f3*f5*f7)*x[4]^2*x[5]*x[6] +
(16*f0*f8^2 + 10*f1*f7*f8 - 8*f2*f6*f8 + 2*f2*f7^2 +
2*f3*f5*f8)*x[4]^2*x[5]*x[7] - 3*f3*f7*x[4]^2*x[5]*x[8] + (-4*f0*f8^2 +
10*f1*f7*f8 + 8*f2*f6*f8 + 4*f2*f7^2 - 6*f3*f5*f8 + 16*f4^2*f8 +
2*f4*f5*f7)*x[4]^2*x[6]^2 + (-8*f1*f8^2 - 16*f2*f7*f8 + 8*f3*f6*f8 - 3*f3*f7^2 -
16*f4*f5*f8 - 2*f5^2*f7)*x[4]^2*x[6]*x[7] + (2*f3*f8 +
12*f4*f7)*x[4]^2*x[6]*x[8] + (12*f2*f8^2 + 16*f4*f6*f8 - 6*f4*f7^2 - 3*f5^2*f8 +
2*f5*f6*f7)*x[4]^2*x[7]^2 + (-4*f4*f8 - 5*f5*f7)*x[4]^2*x[7]*x[8] +
3*f6*x[4]^2*x[8]^2 + 2*f1*f5*f8*x[4]*x[5]^3 + (-8*f0*f7*f8 -
4*f2*f5*f8)*x[4]*x[5]^2*x[6] + 16*f0*f8^2*x[4]*x[5]^2*x[7] -
4*f2*f8*x[4]*x[5]^2*x[8] + (24*f0*f8^2 + 8*f1*f7*f8 +
6*f3*f5*f8)*x[4]*x[5]*x[6]^2 + (-28*f1*f8^2 + 4*f2*f7*f8)*x[4]*x[5]*x[6]*x[7] +
8*f3*f8*x[4]*x[5]*x[6]*x[8] + (8*f2*f8^2 - 4*f3*f7*f8 -
2*f5^2*f8)*x[4]*x[5]*x[7]^2 + f5*f7*x[4]*x[5]*x[7]*x[8] + (-8*f1*f8^2 -
8*f2*f7*f8 - 8*f4*f5*f8)*x[4]*x[6]^3 + (16*f2*f8^2 + 4*f3*f7*f8 +
12*f5^2*f8)*x[4]*x[6]^2*x[7] + (-16*f4*f8 - 2*f5*f7)*x[4]*x[6]^2*x[8] +
(-12*f3*f8^2 + 8*f4*f7*f8 - 12*f5*f6*f8 + f5*f7^2)*x[4]*x[6]*x[7]^2 +
18*f5*f8*x[4]*x[6]*x[7]*x[8] - 3*f7*x[4]*x[6]*x[8]^2 + (-8*f4*f8^2 +
2*f5*f7*f8)*x[4]*x[7]^3 + (-8*f6*f8 + 3*f7^2)*x[4]*x[7]^2*x[8] +
2*f8*x[4]*x[7]*x[8]^2 + (4*f0*f6*f8 - f0*f7^2)*x[5]^4 + (-4*f1*f6*f8 +
f1*f7^2)*x[5]^3*x[6] + (-4*f0*f8^2 + 4*f2*f6*f8 - f2*f7^2)*x[5]^2*x[6]^2 +
4*f1*f8^2*x[5]^2*x[6]*x[7] + (-4*f3*f6*f8 + f3*f7^2)*x[5]*x[6]^3 -
8*f2*f8^2*x[5]*x[6]^2*x[7] + (8*f3*f8^2 + 4*f5*f6*f8 - f5*f7^2)*x[5]*x[6]*x[7]^2
- 4*f5*f8*x[5]*x[6]*x[7]*x[8] + (-8*f4*f8^2 + 4*f5*f7*f8 - 8*f6^2*f8 +
2*f6*f7^2)*x[5]*x[7]^3 + (12*f6*f8 - 3*f7^2)*x[5]*x[7]^2*x[8] -
2*f8*x[5]*x[7]*x[8]^2 + (4*f2*f8^2 + 4*f4*f6*f8 - f4*f7^2)*x[6]^4 + (-4*f3*f8^2
- 8*f5*f6*f8 + 2*f5*f7^2)*x[6]^3*x[7] + 4*f5*f8*x[6]^3*x[8] + (4*f4*f8^2 -
4*f5*f7*f8 + 12*f6^2*f8 - 3*f6*f7^2)*x[6]^2*x[7]^2 + (-12*f6*f8 +
3*f7^2)*x[6]^2*x[7]*x[8] + 3*f8*x[6]^2*x[8]^2 + (4*f5*f8^2 - 4*f6*f7*f8 +
f7^3)*x[6]*x[7]^3 - 2*f7*f8*x[6]*x[7]^2*x[8] + 4*f8^2*x[7]^3*x[8],

// number 3
(-64*f0^3*f5*f8^3 + 64*f0^3*f6*f7*f8^2 - 16*f0^3*f7^3*f8 + 64*f0^2*f1*f4*f8^3 -
16*f0^2*f1*f5*f7*f8^2 - 64*f0^2*f2*f3*f8^3 + 32*f0^2*f3^2*f7*f8^2 -
16*f0^2*f3*f4*f7^2*f8 - 64*f0^2*f3*f5^2*f8^2 + 96*f0^2*f3*f5*f6*f7*f8 -
16*f0^2*f3*f5*f7^3 - 64*f0^2*f3*f6^3*f8 + 16*f0^2*f3*f6^2*f7^2 +
64*f0^2*f4^2*f5*f8^2 - 64*f0^2*f4^2*f6*f7*f8 + 16*f0^2*f4^2*f7^3 -
16*f0^2*f4*f5^2*f7*f8 + 64*f0^2*f4*f5*f6^2*f8 - 16*f0^2*f4*f5*f6*f7^2 -
16*f0^2*f5^3*f6*f8 + 4*f0^2*f5^3*f7^2 - 16*f0*f1^2*f3*f8^3 + 64*f0*f1*f2^2*f8^3
- 32*f0*f1*f2*f3*f7*f8^2 + 64*f0*f1*f2*f4*f6*f8^2 + 48*f0*f1*f2*f5^2*f8^2 -
96*f0*f1*f2*f5*f6*f7*f8 + 16*f0*f1*f2*f5*f7^3 + 64*f0*f1*f2*f6^3*f8 -
16*f0*f1*f2*f6^2*f7^2 - 16*f0*f1*f3^2*f6*f8^2 + 4*f0*f1*f3^2*f7^2*f8 -
32*f0*f1*f3*f4*f5*f8^2 + 32*f0*f1*f3*f4*f6*f7*f8 - 8*f0*f1*f3*f4*f7^3 +
4*f0*f1*f3*f5^2*f7*f8 - 16*f0*f1*f3*f5*f6^2*f8 + 4*f0*f1*f3*f5*f6*f7^2 -
16*f1^3*f2*f8^3 + 8*f1^3*f3*f7*f8^2 - 16*f1^3*f4*f6*f8^2 - 12*f1^3*f5^2*f8^2 +
24*f1^3*f5*f6*f7*f8 - 4*f1^3*f5*f7^3 - 16*f1^3*f6^3*f8 + 4*f1^3*f6^2*f7^2 +
4*f1^2*f3^2*f5*f8^2 - 4*f1^2*f3^2*f6*f7*f8 + f1^2*f3^2*f7^3)*x[1]^4 +
(-32*f0^3*f7*f8^2 - 32*f0^2*f1*f6*f8^2 + 16*f0^2*f1*f7^2*f8 + 32*f0^2*f2*f5*f8^2
- 32*f0^2*f3*f4*f8^2 - 56*f0^2*f3*f5*f7*f8 + 128*f0^2*f3*f6^2*f8 -
32*f0^2*f3*f6*f7^2 + 64*f0^2*f4^2*f7*f8 - 128*f0^2*f4*f5*f6*f8 +
16*f0^2*f4*f5*f7^2 + 32*f0^2*f5^3*f8 - 64*f0*f1*f2*f4*f8^2 +
64*f0*f1*f2*f5*f7*f8 - 128*f0*f1*f2*f6^2*f8 + 32*f0*f1*f2*f6*f7^2 +
24*f0*f1*f3^2*f8^2 - 24*f0*f1*f3*f4*f7*f8 + 32*f0*f1*f3*f5*f6*f8 -
4*f0*f1*f3*f5*f7^2 + 16*f1^3*f4*f8^2 - 16*f1^3*f5*f7*f8 + 32*f1^3*f6^2*f8 -
8*f1^3*f6*f7^2 + 2*f1^2*f3^2*f7*f8)*x[1]^3*x[2] + (64*f0^3*f8^3 +
128*f0^2*f3*f5*f8^2 - 128*f0^2*f3*f6*f7*f8 + 32*f0^2*f3*f7^3 - 64*f0^2*f4^2*f8^2
+ 32*f0^2*f4*f5*f7*f8 + 16*f0^2*f5^2*f6*f8 - 8*f0^2*f5^2*f7^2 +
16*f0*f1^2*f6*f8^2 - 8*f0*f1^2*f7^2*f8 - 112*f0*f1*f2*f5*f8^2 +
128*f0*f1*f2*f6*f7*f8 - 32*f0*f1*f2*f7^3 + 48*f0*f1*f3*f4*f8^2 -
12*f0*f1*f3*f5*f7*f8 - 16*f0*f1*f4^2*f7*f8 + 16*f0*f1*f4*f5*f6*f8 -
8*f0*f1*f5^3*f8 + 24*f1^3*f5*f8^2 - 32*f1^3*f6*f7*f8 + 8*f1^3*f7^3 -
8*f1^2*f3^2*f8^2 + 4*f1^2*f3*f4*f7*f8 - 4*f1^2*f3*f5*f6*f8)*x[1]^3*x[3] +
(-32*f0^2*f1*f8^3 - 96*f0^2*f3*f6*f8^2 + 48*f0^2*f3*f7^2*f8 - 32*f0^2*f4*f5*f8^2
+ 96*f0^2*f4*f6*f7*f8 - 32*f0^2*f4*f7^3 - 16*f0^2*f5^2*f7*f8 -
32*f0^2*f5*f6^2*f8 + 16*f0^2*f5*f6*f7^2 + 96*f0*f1*f2*f6*f8^2 -
48*f0*f1*f2*f7^2*f8 - 24*f0*f1*f3*f6*f7*f8 + 8*f0*f1*f3*f7^3 -
32*f0*f2^2*f5*f8^2 + 32*f0*f2*f3*f4*f8^2 + 8*f0*f2*f3*f5*f7*f8 -
32*f0*f2*f4^2*f7*f8 + 32*f0*f2*f4*f5*f6*f8 - 16*f0*f2*f5^3*f8 - 16*f0*f3^3*f8^2
+ 16*f0*f3^2*f4*f7*f8 - 16*f0*f3^2*f5*f6*f8 + 8*f0*f3*f4*f5^2*f8 -
32*f1^3*f6*f8^2 + 16*f1^3*f7^2*f8 + 16*f1^2*f2*f5*f8^2 - 16*f1^2*f3*f4*f8^2 +
16*f1^2*f4^2*f7*f8 - 16*f1^2*f4*f5*f6*f8 + 8*f1^2*f5^3*f8 + 8*f1*f2*f3^2*f8^2 -
8*f1*f2*f3*f4*f7*f8 + 8*f1*f2*f3*f5*f6*f8 - 2*f1*f3^2*f5^2*f8)*x[1]^3*x[4] +
(-32*f0^2*f1*f8^3 + 64*f0^2*f3*f6*f8^2 - 16*f0^2*f3*f7^2*f8 - 96*f0^2*f4*f5*f8^2
+ 64*f0^2*f4*f6*f7*f8 - 16*f0^2*f4*f7^3 + 16*f0^2*f5^2*f7*f8 -
32*f0^2*f5*f6^2*f8 + 8*f0^2*f5*f6*f7^2 + 8*f0*f1^2*f7*f8^2 -
128*f0*f1*f2*f6*f8^2 + 32*f0*f1*f2*f7^2*f8 + 40*f0*f1*f3*f5*f8^2 -
16*f0*f1*f3*f6*f7*f8 + 4*f0*f1*f3*f7^3 + 8*f0*f1*f4*f5*f7*f8 -
32*f0*f1*f4*f6^2*f8 + 8*f0*f1*f4*f6*f7^2 + 16*f0*f1*f5^2*f6*f8 -
4*f0*f1*f5^2*f7^2 + 32*f1^3*f6*f8^2 - 8*f1^3*f7^2*f8 - 2*f1^2*f3*f5*f7*f8 +
8*f1^2*f3*f6^2*f8 - 2*f1^2*f3*f6*f7^2)*x[1]^3*x[5] + (64*f0^2*f2*f8^3 -
80*f0^2*f3*f7*f8^2 - 64*f0^2*f4*f6*f8^2 + 48*f0^2*f4*f7^2*f8 + 96*f0^2*f5^2*f8^2
- 112*f0^2*f5*f6*f7*f8 + 16*f0^2*f5*f7^3 + 64*f0^2*f6^3*f8 - 16*f0^2*f6^2*f7^2 +
48*f0*f1*f2*f7*f8^2 + 48*f0*f1*f3*f6*f8^2 - 16*f0*f1*f3*f7^2*f8 +
16*f0*f2*f4*f5*f7*f8 - 64*f0*f2*f4*f6^2*f8 + 16*f0*f2*f4*f6*f7^2 +
32*f0*f2*f5^2*f6*f8 - 8*f0*f2*f5^2*f7^2 - 8*f0*f3^2*f5*f7*f8 +
32*f0*f3^2*f6^2*f8 - 8*f0*f3^2*f6*f7^2 - 16*f0*f3*f4*f5*f6*f8 +
4*f0*f3*f4*f5*f7^2 - 16*f1^3*f7*f8^2 - 8*f1^2*f3*f5*f8^2 - 8*f1^2*f4*f5*f7*f8 +
32*f1^2*f4*f6^2*f8 - 8*f1^2*f4*f6*f7^2 - 16*f1^2*f5^2*f6*f8 + 4*f1^2*f5^2*f7^2 +
4*f1*f2*f3*f5*f7*f8 - 16*f1*f2*f3*f6^2*f8 + 4*f1*f2*f3*f6*f7^2 +
4*f1*f3^2*f5*f6*f8 - f1*f3^2*f5*f7^2)*x[1]^3*x[6] + (96*f0^2*f3*f8^3 -
32*f0^2*f4*f7*f8^2 + 8*f0^2*f5*f7^2*f8 - 128*f0*f1*f2*f8^3 + 24*f0*f1*f3*f7*f8^2
- 64*f0*f1*f4*f6*f8^2 + 8*f0*f1*f4*f7^2*f8 - 16*f0*f1*f5^2*f8^2 +
48*f0*f1*f5*f6*f7*f8 - 8*f0*f1*f5*f7^3 - 32*f0*f1*f6^3*f8 + 8*f0*f1*f6^2*f7^2 -
64*f0*f2*f4*f5*f8^2 + 64*f0*f2*f4*f6*f7*f8 - 16*f0*f2*f4*f7^3 +
8*f0*f2*f5^2*f7*f8 - 32*f0*f2*f5*f6^2*f8 + 8*f0*f2*f5*f6*f7^2 +
32*f0*f3^2*f5*f8^2 - 32*f0*f3^2*f6*f7*f8 + 8*f0*f3^2*f7^3 + 8*f0*f3*f5^2*f6*f8 -
2*f0*f3*f5^2*f7^2 + 32*f1^3*f8^3 + 16*f1^2*f3*f6*f8^2 - 4*f1^2*f3*f7^2*f8 +
32*f1^2*f4*f5*f8^2 - 32*f1^2*f4*f6*f7*f8 + 8*f1^2*f4*f7^3 - 4*f1^2*f5^2*f7*f8 +
16*f1^2*f5*f6^2*f8 - 4*f1^2*f5*f6*f7^2 - 16*f1*f2*f3*f5*f8^2 +
16*f1*f2*f3*f6*f7*f8 - 4*f1*f2*f3*f7^3)*x[1]^3*x[7] + (32*f0^2*f5*f8^2 -
32*f0^2*f6*f7*f8 + 8*f0^2*f7^3 + 16*f0*f1*f4*f8^2 - 8*f0*f1*f5*f7*f8 +
16*f0*f1*f6^2*f8 - 4*f0*f1*f6*f7^2 + 16*f0*f2*f5*f6*f8 - 4*f0*f2*f5*f7^2 -
4*f0*f3*f5^2*f8 - 4*f1^2*f3*f8^2 - 8*f1^2*f5*f6*f8 + 2*f1^2*f5*f7^2)*x[1]^3*x[8]
+ (16*f0^2*f1*f8^2 - 16*f0^2*f2*f7*f8 - 64*f0^2*f3*f6*f8 + 16*f0^2*f3*f7^2 +
32*f0^2*f4*f5*f8 + 16*f0^2*f4*f6*f7 - 8*f0^2*f5^2*f7 + 64*f0*f1*f2*f6*f8 -
16*f0*f1*f2*f7^2 - 12*f0*f1*f3*f5*f8 - 4*f0*f1*f3*f6*f7 - 16*f1^3*f6*f8 +
4*f1^3*f7^2)*x[1]^2*x[2]^2 + (48*f0^2*f3*f7*f8 + 32*f0^2*f4*f6*f8 -
16*f0^2*f4*f7^2 - 48*f0^2*f5^2*f8 + 8*f0^2*f5*f6*f7 - 8*f0*f1^2*f8^2 -
48*f0*f1*f2*f7*f8 - 8*f0*f1*f3*f6*f8 + 4*f0*f1*f3*f7^2 + 8*f0*f1*f4*f5*f8 -
8*f0*f1*f4*f6*f7 + 4*f0*f1*f5^2*f7 + 16*f1^3*f7*f8 + 2*f1^2*f3*f5*f8 +
2*f1^2*f3*f6*f7)*x[1]^2*x[2]*x[3] + (64*f0^2*f3*f8^2 - 80*f0^2*f4*f7*f8 +
80*f0^2*f5*f6*f8 - 16*f0^2*f6^2*f7 - 48*f0*f1*f2*f8^2 + 16*f0*f1*f3*f7*f8 +
32*f0*f2^2*f7*f8 - 32*f0*f2*f3*f6*f8 + 16*f0*f2*f4*f5*f8 - 16*f0*f2*f4*f6*f7 +
8*f0*f2*f5^2*f7 + 12*f0*f3^2*f5*f8 + 8*f0*f3^2*f6*f7 - 16*f0*f3*f4^2*f8 -
4*f0*f3*f4*f5*f7 + 16*f1^3*f8^2 - 16*f1^2*f2*f7*f8 + 8*f1^2*f3*f6*f8 -
8*f1^2*f4*f5*f8 + 8*f1^2*f4*f6*f7 - 4*f1^2*f5^2*f7 - 4*f1*f2*f3*f5*f8 -
4*f1*f2*f3*f6*f7 + 4*f1*f3^2*f4*f8 + f1*f3^2*f5*f7)*x[1]^2*x[2]*x[4] +
(-16*f0^2*f3*f8^2 - 48*f0^2*f4*f7*f8 + 48*f0^2*f5*f6*f8 - 8*f0^2*f5*f7^2 +
80*f0*f1*f2*f8^2 + 4*f0*f1*f3*f7*f8 + 48*f0*f1*f4*f6*f8 - 8*f0*f1*f4*f7^2 -
24*f0*f1*f5^2*f8 - 24*f1^3*f8^2 - 12*f1^2*f3*f6*f8 +
2*f1^2*f3*f7^2)*x[1]^2*x[2]*x[5] + (64*f0^2*f4*f8^2 + 32*f0^2*f5*f7*f8 -
96*f0^2*f6^2*f8 + 32*f0^2*f6*f7^2 - 40*f0*f1*f3*f8^2 - 32*f0*f2^2*f8^2 +
8*f0*f2*f3*f7*f8 + 96*f0*f2*f4*f6*f8 - 16*f0*f2*f4*f7^2 - 48*f0*f2*f5^2*f8 -
48*f0*f3^2*f6*f8 + 8*f0*f3^2*f7^2 + 24*f0*f3*f4*f5*f8 + 16*f1^2*f2*f8^2 -
48*f1^2*f4*f6*f8 + 8*f1^2*f4*f7^2 + 24*f1^2*f5^2*f8 + 24*f1*f2*f3*f6*f8 -
4*f1*f2*f3*f7^2 - 6*f1*f3^2*f5*f8)*x[1]^2*x[2]*x[6] + (-32*f0^2*f5*f8^2 +
16*f0^2*f6*f7*f8 - 8*f0^2*f7^3 + 48*f0*f1*f4*f8^2 - 32*f0*f1*f5*f7*f8 +
48*f0*f1*f6^2*f8 - 12*f0*f1*f6*f7^2 + 16*f0*f2*f3*f8^2 - 48*f0*f2*f4*f7*f8 +
48*f0*f2*f5*f6*f8 - 4*f0*f2*f5*f7^2 + 16*f0*f3^2*f7*f8 - 12*f0*f3*f5^2*f8 -
20*f1^2*f3*f8^2 + 24*f1^2*f4*f7*f8 - 24*f1^2*f5*f6*f8 + 2*f1^2*f5*f7^2 -
8*f1*f2*f3*f7*f8)*x[1]^2*x[2]*x[7] + (16*f0^2*f7*f8 - 16*f0*f1*f6*f8 +
4*f0*f1*f7^2 - 24*f0*f2*f5*f8 + 8*f0*f3*f4*f8 + 2*f0*f3*f5*f7 + 12*f1^2*f5*f8 -
2*f1*f3^2*f8)*x[1]^2*x[2]*x[8] + (-48*f0^2*f3*f8^2 + 32*f0*f1*f2*f8^2 +
8*f0*f1*f3*f7*f8 - 32*f0*f1*f4*f6*f8 + 8*f0*f1*f4*f7^2 + 20*f0*f1*f5^2*f8 -
4*f0*f1*f5*f6*f7 - 8*f1^3*f8^2 - 4*f1^2*f2*f7*f8 + 8*f1^2*f3*f6*f8 -
2*f1^2*f3*f7^2 - 4*f1^2*f4*f5*f8)*x[1]^2*x[3]^2 + (32*f0^2*f4*f8^2 -
24*f0^2*f5*f7*f8 + 32*f0^2*f6^2*f8 + 40*f0*f1*f4*f7*f8 - 32*f0*f1*f5*f6*f8 -
8*f0*f1*f5*f7^2 + 8*f0*f1*f6^2*f7 - 32*f0*f2*f3*f7*f8 - 32*f0*f2*f4*f6*f8 +
16*f0*f2*f4*f7^2 + 40*f0*f2*f5^2*f8 - 8*f0*f2*f5*f6*f7 + 48*f0*f3^2*f6*f8 -
8*f0*f3^2*f7^2 - 56*f0*f3*f4*f5*f8 + 2*f0*f3*f5^2*f7 + 32*f0*f4^3*f8 -
12*f1^2*f3*f7*f8 + 32*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 - 20*f1^2*f5^2*f8 +
4*f1^2*f5*f6*f7 + 16*f1*f2^2*f7*f8 - 24*f1*f2*f3*f6*f8 + 4*f1*f2*f3*f7^2 +
16*f1*f2*f4*f5*f8 + 4*f1*f3^2*f5*f8 - 8*f1*f3*f4^2*f8)*x[1]^2*x[3]*x[4] +
(64*f0^2*f4*f8^2 - 16*f0^2*f5*f7*f8 - 40*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 -
16*f0*f1*f5*f6*f8 + 8*f0*f1*f5*f7^2 + 8*f1^2*f2*f8^2 + 2*f1^2*f3*f7*f8 +
4*f1^2*f5^2*f8)*x[1]^2*x[3]*x[5] + (-96*f0^2*f5*f8^2 + 80*f0^2*f6*f7*f8 -
24*f0^2*f7^3 - 32*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 - 4*f0*f1*f6*f7^2 +
32*f0*f2*f3*f8^2 - 32*f0*f2*f4*f7*f8 - 16*f0*f2*f5*f6*f8 + 12*f0*f2*f5*f7^2 +
8*f0*f3^2*f7*f8 + 12*f0*f3*f5^2*f8 - 16*f0*f4^2*f5*f8 + 12*f1^2*f3*f8^2 +
8*f1^2*f4*f7*f8 + 8*f1^2*f5*f6*f8 - 6*f1^2*f5*f7^2 - 16*f1*f2^2*f8^2 -
4*f1*f2*f3*f7*f8 - 8*f1*f2*f5^2*f8 + 4*f1*f3*f4*f5*f8)*x[1]^2*x[3]*x[6] +
(-32*f0^2*f6*f8^2 + 16*f0^2*f7^2*f8 + 40*f0*f1*f5*f8^2 - 56*f0*f1*f6*f7*f8 +
16*f0*f1*f7^3 + 64*f0*f2*f4*f8^2 - 16*f0*f2*f5*f7*f8 - 48*f0*f3^2*f8^2 +
16*f0*f3*f4*f7*f8 - 16*f0*f3*f5*f6*f8 + 8*f0*f4*f5^2*f8 - 32*f1^2*f4*f8^2 +
12*f1^2*f5*f7*f8 + 24*f1*f2*f3*f8^2 - 8*f1*f2*f4*f7*f8 + 8*f1*f2*f5*f6*f8 +
2*f1*f3*f5^2*f8)*x[1]^2*x[3]*x[7] + (-16*f0^2*f8^2 + 8*f0*f1*f7*f8 +
16*f0*f3*f5*f8 - 16*f0*f4^2*f8 - 8*f1*f2*f5*f8 + 4*f1*f3*f4*f8 -
f1*f3*f5*f7)*x[1]^2*x[3]*x[8] + (16*f0^2*f5*f8^2 - 48*f0^2*f6*f7*f8 +
16*f0^2*f7^3 - 16*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 - 16*f0*f1*f6^2*f8 -
16*f0*f2*f3*f8^2 + 48*f0*f2*f4*f7*f8 - 32*f0*f2*f5*f6*f8 - 16*f0*f2*f5*f7^2 +
16*f0*f2*f6^2*f7 - 20*f0*f3^2*f7*f8 + 8*f0*f3*f4*f7^2 - 4*f0*f3*f5*f6*f7 +
8*f1^2*f3*f8^2 - 32*f1^2*f4*f7*f8 + 24*f1^2*f5*f6*f8 + 8*f1^2*f5*f7^2 -
8*f1^2*f6^2*f7 + 32*f1*f2*f3*f7*f8 - 16*f1*f2*f4*f6*f8 - 12*f1*f3^2*f6*f8 -
2*f1*f3^2*f7^2 + 24*f1*f3*f4*f5*f8 - 16*f1*f4^3*f8 - 16*f2^3*f7*f8 +
16*f2^2*f3*f6*f8 - 16*f2^2*f4*f5*f8 - 4*f2*f3^2*f5*f8 + 16*f2*f3*f4^2*f8 -
4*f3^3*f4*f8)*x[1]^2*x[4]^2 + (32*f0^2*f5*f8^2 - 32*f0^2*f6*f7*f8 + 8*f0^2*f7^3
- 32*f0*f1*f4*f8^2 + 24*f0*f1*f5*f7*f8 - 4*f0*f1*f6*f7^2 + 16*f0*f2*f3*f8^2 +
16*f0*f2*f4*f7*f8 - 16*f0*f2*f5*f6*f8 + 4*f0*f2*f5*f7^2 - 8*f0*f3^2*f7*f8 +
12*f0*f3*f5^2*f8 - 16*f0*f4^2*f5*f8 + 20*f1^2*f3*f8^2 - 16*f1^2*f4*f7*f8 +
8*f1^2*f5*f6*f8 - 2*f1^2*f5*f7^2 - 16*f1*f2^2*f8^2 + 4*f1*f2*f3*f7*f8 -
8*f1*f2*f5^2*f8 + 4*f1*f3*f4*f5*f8)*x[1]^2*x[4]*x[5] + (96*f0^2*f6*f8^2 -
48*f0^2*f7^2*f8 - 16*f0*f1*f5*f8^2 + 16*f0*f1*f6*f7*f8 - 64*f0*f2*f4*f8^2 +
48*f0*f2*f5*f7*f8 - 16*f0*f2*f6*f7^2 + 56*f0*f3^2*f8^2 - 40*f0*f3*f4*f7*f8 +
32*f0*f3*f5*f6*f8 - 4*f0*f3*f5*f7^2 + 48*f1^2*f4*f8^2 - 32*f1^2*f5*f7*f8 +
8*f1^2*f6*f7^2 - 64*f1*f2*f3*f8^2 + 16*f1*f2*f4*f7*f8 + 10*f1*f3^2*f7*f8 -
16*f1*f3*f5^2*f8 + 16*f1*f4^2*f5*f8 + 32*f2^3*f8^2 - 8*f2^2*f3*f7*f8 +
16*f2^2*f5^2*f8 - 16*f2*f3*f4*f5*f8 + 4*f3^3*f5*f8)*x[1]^2*x[4]*x[6] +
(16*f0^2*f7*f8^2 - 16*f0*f1*f6*f8^2 + 8*f0*f1*f7^2*f8 + 32*f0*f2*f5*f8^2 -
32*f0*f2*f6*f7*f8 + 16*f0*f2*f7^3 - 4*f0*f3*f5*f7*f8 + 16*f0*f4^2*f7*f8 -
16*f0*f4*f5*f6*f8 + 8*f0*f5^3*f8 - 8*f1^2*f5*f8^2 + 16*f1^2*f6*f7*f8 -
8*f1^2*f7^3 - 8*f1*f2*f5*f7*f8 + 8*f1*f3^2*f8^2 - 12*f1*f3*f4*f7*f8 +
12*f1*f3*f5*f6*f8 - 8*f1*f4*f5^2*f8 - 16*f2^2*f3*f8^2 + 16*f2^2*f4*f7*f8 -
16*f2^2*f5*f6*f8 + 4*f2*f3*f5^2*f8)*x[1]^2*x[4]*x[7] + (8*f0*f1*f8^2 -
8*f0*f2*f7*f8 + 24*f0*f3*f6*f8 - 4*f0*f3*f7^2 - 8*f0*f4*f5*f8 - 18*f1*f3*f5*f8 +
2*f1*f3*f6*f7 + 16*f1*f4^2*f8 + 16*f2^2*f5*f8 - 16*f2*f3*f4*f8 +
4*f3^3*f8)*x[1]^2*x[4]*x[8] + (32*f0^2*f5*f8^2 - 16*f0^2*f6*f7*f8 + 4*f0^2*f7^3
- 12*f0*f1*f5*f7*f8 + 16*f0*f1*f6^2*f8 - 4*f0*f1*f6*f7^2 - 4*f1^2*f3*f8^2 -
4*f1^2*f5*f6*f8 + f1^2*f5*f7^2)*x[1]^2*x[5]^2 + (-32*f0^2*f6*f8^2 +
8*f0^2*f7^2*f8 - 32*f0*f1*f5*f8^2 + 8*f0*f1*f6*f7*f8 + 32*f0*f2*f4*f8^2 -
24*f0*f2*f5*f7*f8 + 32*f0*f2*f6^2*f8 - 8*f0*f2*f6*f7^2 - 16*f0*f3^2*f8^2 -
24*f0*f3*f5*f6*f8 + 6*f0*f3*f5*f7^2 + 32*f0*f4^2*f6*f8 - 8*f0*f4^2*f7^2 +
12*f1^2*f5*f7*f8 - 16*f1^2*f6^2*f8 + 4*f1^2*f6*f7^2 + 8*f1*f2*f3*f8^2 +
16*f1*f2*f5*f6*f8 - 4*f1*f2*f5*f7^2 - 8*f1*f3*f4*f6*f8 +
2*f1*f3*f4*f7^2)*x[1]^2*x[5]*x[6] + (96*f0*f1*f6*f8^2 - 28*f0*f1*f7^2*f8 +
48*f0*f2*f5*f8^2 - 32*f0*f2*f6*f7*f8 + 8*f0*f2*f7^3 - 8*f0*f3*f5*f7*f8 +
32*f0*f3*f6^2*f8 - 8*f0*f3*f6*f7^2 - 16*f0*f4*f5*f6*f8 + 4*f0*f4*f5*f7^2 -
32*f1^2*f5*f8^2 + 16*f1^2*f6*f7*f8 - 4*f1^2*f7^3 + 4*f1*f2*f5*f7*f8 -
16*f1*f2*f6^2*f8 + 4*f1*f2*f6*f7^2 - 4*f1*f3*f5*f6*f8 +
f1*f3*f5*f7^2)*x[1]^2*x[5]*x[7] + (-24*f0*f1*f8^2 - 16*f0*f3*f6*f8 +
4*f0*f3*f7^2 + 8*f0*f4*f5*f8 + 8*f1*f2*f6*f8 - 2*f1*f2*f7^2 +
2*f1*f3*f5*f8)*x[1]^2*x[5]*x[8] + (32*f0^2*f7*f8^2 - 16*f0*f1*f6*f8^2 -
32*f0*f2*f5*f8^2 + 16*f0*f2*f6*f7*f8 + 16*f0*f3*f4*f8^2 + 12*f0*f3*f5*f7*f8 -
32*f0*f3*f6^2*f8 + 8*f0*f3*f6*f7^2 + 24*f1^2*f5*f8^2 - 8*f1^2*f6*f7*f8 -
16*f1*f2*f4*f8^2 + 16*f1*f3*f5*f6*f8 - 4*f1*f3*f5*f7^2 - 16*f1*f4^2*f6*f8 +
4*f1*f4^2*f7^2 - 16*f2^2*f5*f6*f8 + 4*f2^2*f5*f7^2 + 16*f2*f3*f4*f6*f8 -
4*f2*f3*f4*f7^2 - 4*f3^3*f6*f8 + f3^3*f7^2)*x[1]^2*x[6]^2 + (-64*f0^2*f8^3 -
8*f0*f1*f7*f8^2 + 32*f0*f2*f6*f8^2 - 24*f0*f2*f7^2*f8 - 48*f0*f3*f5*f8^2 +
32*f0*f3*f6*f7*f8 - 8*f0*f3*f7^3 - 8*f0*f4*f5*f7*f8 + 32*f0*f4*f6^2*f8 -
8*f0*f4*f6*f7^2 - 16*f0*f5^2*f6*f8 + 4*f0*f5^2*f7^2 - 32*f1^2*f6*f8^2 +
16*f1^2*f7^2*f8 + 16*f1*f2*f5*f8^2 + 6*f1*f3*f5*f7*f8 - 24*f1*f3*f6^2*f8 +
6*f1*f3*f6*f7^2 + 16*f1*f4*f5*f6*f8 - 4*f1*f4*f5*f7^2 - 8*f2^2*f5*f7*f8 +
32*f2^2*f6^2*f8 - 8*f2^2*f6*f7^2 - 8*f2*f3*f5*f6*f8 +
2*f2*f3*f5*f7^2)*x[1]^2*x[6]*x[7] + (-16*f0*f4*f6*f8 + 4*f0*f4*f7^2 +
8*f0*f5^2*f8 + 8*f1^2*f8^2 + 12*f1*f3*f6*f8 - 4*f1*f3*f7^2 - 8*f1*f4*f5*f8 -
16*f2^2*f6*f8 + 4*f2^2*f7^2 + 4*f2*f3*f5*f8)*x[1]^2*x[6]*x[8] + (32*f0*f1*f8^3 +
16*f0*f2*f7*f8^2 + 32*f0*f4*f5*f8^2 - 32*f0*f4*f6*f7*f8 + 8*f0*f4*f7^3 -
4*f0*f5^2*f7*f8 + 16*f0*f5*f6^2*f8 - 4*f0*f5*f6*f7^2 - 8*f1^2*f7*f8^2 -
16*f1*f2*f6*f8^2 + 4*f1*f2*f7^2*f8 - 8*f1*f3*f5*f8^2 + 8*f1*f3*f6*f7*f8 -
2*f1*f3*f7^3 - 4*f1*f5^2*f6*f8 + f1*f5^2*f7^2 + 16*f2^2*f5*f8^2 -
16*f2^2*f6*f7*f8 + 4*f2^2*f7^3)*x[1]^2*x[7]^2 + (-16*f0*f3*f8^2 + 8*f0*f4*f7*f8
- 16*f0*f5*f6*f8 + 2*f0*f5*f7^2 + 8*f1*f2*f8^2 + 2*f1*f3*f7*f8 +
4*f1*f5^2*f8)*x[1]^2*x[7]*x[8] + (8*f0^2*f3*f8 - 16*f0^2*f4*f7 +
4*f0*f1*f3*f7)*x[1]*x[2]^3 + (16*f0^2*f4*f8 + 8*f0^2*f5*f7 - 8*f0*f1*f3*f8 +
8*f0*f1*f4*f7 - 2*f1^2*f3*f7)*x[1]*x[2]^2*x[3] + (-48*f0^2*f5*f8 + 16*f0^2*f6*f7
+ 16*f0*f2*f3*f8 + 16*f0*f2*f4*f7 - 8*f0*f3^2*f7 - 8*f1^2*f4*f7 +
4*f1*f2*f3*f7)*x[1]*x[2]^2*x[4] + (-8*f0^2*f6*f7 - 16*f0*f1*f4*f8 +
4*f0*f1*f5*f7 + 4*f1^2*f3*f8)*x[1]*x[2]^2*x[5] + (32*f0^2*f6*f8 - 16*f0^2*f7^2 -
32*f0*f2*f4*f8 + 8*f0*f2*f5*f7 + 12*f0*f3^2*f8 - 4*f0*f3*f4*f7 + 16*f1^2*f4*f8 -
4*f1^2*f5*f7 - 8*f1*f2*f3*f8 + f1*f3^2*f7)*x[1]*x[2]^2*x[6] + (8*f0^2*f7*f8 -
8*f0*f1*f6*f8 + 4*f0*f1*f7^2 - 8*f0*f2*f6*f7 + 2*f0*f3*f5*f7 + 4*f1^2*f6*f7 +
2*f1*f3^2*f8)*x[1]*x[2]^2*x[7] + (-4*f0*f1*f8 + 4*f0*f2*f7 -
2*f1^2*f7)*x[1]*x[2]^2*x[8] + (8*f0^2*f5*f8 - 4*f0*f1*f5*f7 -
2*f1^2*f3*f8)*x[1]*x[2]*x[3]^2 + (-32*f0^2*f6*f8 - 16*f0^2*f7^2 + 32*f0*f1*f5*f8
- 8*f0*f1*f6*f7 - 32*f0*f2*f4*f8 - 8*f0*f2*f5*f7 - 16*f0*f3^2*f8 + 4*f1^2*f5*f7
+ 8*f1*f2*f3*f8)*x[1]*x[2]*x[3]*x[4] + (-16*f0^2*f6*f8 + 8*f0^2*f7^2 +
8*f0*f1*f5*f8 - 2*f1^2*f5*f7)*x[1]*x[2]*x[3]*x[5] + (8*f0^2*f7*f8 +
8*f0*f1*f6*f8 + 4*f0*f1*f7^2 + 32*f0*f2*f5*f8 - 8*f0*f2*f6*f7 + 8*f0*f3*f4*f8 -
8*f0*f3*f5*f7 + 8*f0*f4^2*f7 - 16*f1^2*f5*f8 + 4*f1^2*f6*f7 + 4*f1*f2*f5*f7 +
2*f1*f3^2*f8 - 2*f1*f3*f4*f7)*x[1]*x[2]*x[3]*x[6] + (4*f0*f1*f7*f8 -
16*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 4*f0*f3*f5*f8 + 8*f0*f3*f6*f7 - 4*f0*f4*f5*f7 -
4*f1^2*f7^2 + 4*f1*f2*f5*f8 - 4*f1*f2*f6*f7 - 8*f1*f3*f4*f8)*x[1]*x[2]*x[3]*x[7]
+ (8*f0*f2*f8 - 4*f0*f3*f7 + 2*f1*f2*f7)*x[1]*x[2]*x[3]*x[8] + (32*f0^2*f7*f8 +
16*f0*f1*f6*f8 + 32*f0*f2*f5*f8 - 16*f0*f2*f6*f7 + 8*f0*f3*f5*f7 - 24*f1^2*f5*f8
+ 8*f1^2*f6*f7 + 16*f1*f2*f4*f8 + 6*f1*f3^2*f8 - 8*f2^2*f3*f8)*x[1]*x[2]*x[4]^2
+ (24*f0^2*f7*f8 - 8*f0*f1*f6*f8 + 4*f0*f1*f7^2 - 16*f0*f2*f5*f8 + 8*f0*f2*f6*f7
+ 24*f0*f3*f4*f8 - 8*f0*f3*f5*f7 + 8*f0*f4^2*f7 + 8*f1^2*f5*f8 - 4*f1^2*f6*f7 +
4*f1*f2*f5*f7 - 6*f1*f3^2*f8 - 2*f1*f3*f4*f7)*x[1]*x[2]*x[4]*x[5] +
(-64*f0^2*f8^2 - 16*f0*f1*f7*f8 + 16*f0*f2*f7^2 - 32*f0*f3*f5*f8 - 8*f1^2*f7^2 -
8*f1*f3*f4*f8 + 8*f1*f3*f5*f7 - 8*f1*f4^2*f7 - 8*f2^2*f5*f7 + 4*f2*f3^2*f8 +
8*f2*f3*f4*f7 - 2*f3^3*f7)*x[1]*x[2]*x[4]*x[6] + (-16*f0*f2*f7*f8 - 4*f0*f3*f7^2
+ 8*f0*f4*f6*f7 - 4*f0*f5^2*f7 + 8*f1^2*f7*f8 + 16*f1*f2*f6*f8 + 8*f1*f3*f5*f8 -
8*f1*f3*f6*f7 + 4*f1*f4*f5*f7 - 8*f2^2*f5*f8 + 8*f2^2*f6*f7 + 8*f2*f3*f4*f8 -
2*f2*f3*f5*f7 - 4*f3^3*f8)*x[1]*x[2]*x[4]*x[7] + (-12*f0*f3*f8 - 4*f0*f4*f7 -
8*f1*f2*f8 + 2*f1*f3*f7 - 4*f2^2*f7)*x[1]*x[2]*x[4]*x[8] + (8*f0^2*f7*f8 -
16*f0*f1*f6*f8 + 4*f0*f1*f7^2 + 4*f1^2*f5*f8)*x[1]*x[2]*x[5]^2 + (-8*f0*f1*f7*f8
- 32*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 24*f0*f3*f5*f8 - 32*f0*f4^2*f8 + 16*f1^2*f6*f8
- 4*f1^2*f7^2 - 16*f1*f2*f5*f8 + 8*f1*f3*f4*f8)*x[1]*x[2]*x[5]*x[6] +
(-32*f0*f1*f8^2 + 16*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 4*f0*f3*f7^2 +
16*f0*f4*f5*f8 - 4*f1^2*f7*f8 + 16*f1*f2*f6*f8 - 2*f1*f2*f7^2 +
4*f1*f3*f5*f8)*x[1]*x[2]*x[5]*x[7] + (4*f0*f3*f8 - 4*f0*f4*f7 -
4*f1*f2*f8)*x[1]*x[2]*x[5]*x[8] + (16*f0*f1*f8^2 - 16*f0*f2*f7*f8 +
32*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 8*f1^2*f7*f8 - 16*f1*f3*f5*f8 + 16*f1*f4^2*f8 +
16*f2^2*f5*f8 - 16*f2*f3*f4*f8 + 4*f3^3*f8)*x[1]*x[2]*x[6]^2 + (16*f0*f2*f8^2 -
32*f0*f4*f6*f8 + 4*f0*f4*f7^2 + 16*f0*f5^2*f8 - 8*f1*f2*f7*f8 + 24*f1*f3*f6*f8 -
2*f1*f3*f7^2 - 16*f1*f4*f5*f8 - 32*f2^2*f6*f8 + 4*f2^2*f7^2 +
8*f2*f3*f5*f8)*x[1]*x[2]*x[6]*x[7] + (16*f0*f4*f8 - 4*f0*f5*f7 - 4*f1*f3*f8 +
4*f1*f4*f7 + 8*f2^2*f8 - 2*f2*f3*f7)*x[1]*x[2]*x[6]*x[8] + (-8*f0*f3*f8^2 +
16*f0*f4*f7*f8 - 16*f0*f5*f6*f8 + 2*f0*f5*f7^2 + 8*f1*f2*f8^2 - 6*f1*f3*f7*f8 +
4*f1*f5^2*f8 + 8*f2^2*f7*f8)*x[1]*x[2]*x[7]^2 + (16*f0*f5*f8 + 4*f0*f6*f7 -
8*f1*f4*f8 - 2*f1*f5*f7 + 4*f2*f3*f8)*x[1]*x[2]*x[7]*x[8] -
2*f0*f7*x[1]*x[2]*x[8]^2 + (-12*f0*f1*f5*f8 + 4*f1^2*f4*f8)*x[1]*x[3]^3 +
(32*f0^2*f7*f8 + 8*f0*f1*f7^2 - 8*f0*f2*f5*f8 + 32*f0*f3*f4*f8 + 12*f1^2*f5*f8 -
16*f1*f2*f4*f8)*x[1]*x[3]^2*x[4] + (24*f0*f1*f6*f8 - 4*f0*f1*f7^2 - 4*f1^2*f5*f8
+ 2*f1^2*f6*f7)*x[1]*x[3]^2*x[5] + (-16*f0*f1*f7*f8 - 16*f0*f3*f5*f8 +
8*f0*f3*f6*f7 - 4*f0*f4*f5*f7 - 8*f1^2*f6*f8 + 12*f1*f2*f5*f8 - 4*f1*f2*f6*f7 -
4*f1*f3*f4*f8 + f1*f3*f5*f7)*x[1]*x[3]^2*x[6] + (8*f0*f1*f8^2 + 16*f0*f3*f6*f8 -
8*f0*f3*f7^2 - 8*f0*f4*f5*f8 + 2*f0*f5^2*f7 + 4*f1^2*f7*f8 - 8*f1*f2*f6*f8 +
4*f1*f2*f7^2 - 4*f1*f3*f5*f8 + 8*f1*f4^2*f8)*x[1]*x[3]^2*x[7] + (-8*f0*f3*f8 +
4*f1*f2*f8)*x[1]*x[3]^2*x[8] + (-16*f0^2*f8^2 - 40*f0*f1*f7*f8 + 16*f0*f2*f7^2 +
8*f0*f3*f5*f8 - 32*f0*f4^2*f8 - 8*f1^2*f7^2 - 8*f1*f2*f5*f8 - 12*f1*f3*f4*f8 +
16*f2^2*f4*f8)*x[1]*x[3]*x[4]^2 + (-32*f0^2*f8^2 - 20*f0*f1*f7*f8 +
16*f0*f2*f6*f8 - 8*f0*f2*f7^2 - 4*f0*f3*f5*f8 + 8*f0*f3*f6*f7 - 32*f0*f4^2*f8 -
4*f0*f4*f5*f7 - 16*f1^2*f6*f8 + 4*f1^2*f7^2 + 4*f1*f2*f5*f8 - 4*f1*f2*f6*f7 +
8*f1*f3*f4*f8)*x[1]*x[3]*x[4]*x[5] + (48*f0*f1*f8^2 - 16*f0*f2*f7*f8 -
48*f0*f3*f6*f8 + 4*f0*f3*f7^2 + 48*f0*f4*f5*f8 - 8*f0*f4*f6*f7 + 4*f0*f5^2*f7 +
24*f1^2*f7*f8 + 16*f1*f2*f6*f8 + 20*f1*f3*f5*f8 - 8*f1*f3*f6*f7 + 4*f1*f4*f5*f7
- 24*f2^2*f5*f8 + 8*f2^2*f6*f7 + 8*f2*f3*f4*f8 - 2*f2*f3*f5*f7 -
4*f3^3*f8)*x[1]*x[3]*x[4]*x[6] + (16*f0*f2*f8^2 + 24*f0*f3*f7*f8 -
16*f0*f4*f6*f8 - 8*f0*f5^2*f8 - 16*f1^2*f8^2 - 16*f1*f2*f7*f8 - 8*f1*f3*f6*f8 +
8*f1*f3*f7^2 - 2*f1*f5^2*f7 + 16*f2^2*f6*f8 - 8*f2^2*f7^2 - 16*f2*f4^2*f8 +
8*f3^2*f4*f8)*x[1]*x[3]*x[4]*x[7] + (32*f0*f4*f8 + 2*f0*f5*f7 + 8*f1*f3*f8 -
8*f2^2*f8)*x[1]*x[3]*x[4]*x[8] + (-16*f0^2*f8^2 - 8*f0*f1*f7*f8 -
2*f1^2*f7^2)*x[1]*x[3]*x[5]^2 + (32*f0*f1*f8^2 + 16*f0*f2*f7*f8 - 12*f0*f3*f7^2
+ 32*f0*f4*f5*f8 + 4*f1^2*f7*f8 + 6*f1*f2*f7^2 -
4*f1*f3*f5*f8)*x[1]*x[3]*x[5]*x[6] + (-32*f0*f2*f8^2 + 16*f0*f3*f7*f8 -
8*f0*f5^2*f8 + 8*f1^2*f8^2 - 8*f1*f2*f7*f8 - 8*f1*f4*f5*f8)*x[1]*x[3]*x[5]*x[7]
+ (16*f0*f4*f8 - 2*f1*f3*f8 + 2*f1*f4*f7)*x[1]*x[3]*x[5]*x[8] + (4*f0*f3*f7*f8 +
4*f0*f4*f7^2 - 16*f0*f5^2*f8 - 16*f1^2*f8^2 - 8*f1*f2*f7*f8 + 4*f1*f3*f7^2 -
8*f1*f4*f5*f8 - 4*f2^2*f7^2 + 4*f2*f3*f5*f8)*x[1]*x[3]*x[6]^2 + (8*f0*f3*f8^2 +
24*f0*f5*f6*f8 - 6*f0*f5*f7^2 + 16*f1*f2*f8^2 - 16*f1*f3*f7*f8 + 8*f1*f5^2*f8 +
16*f2^2*f7*f8 + 8*f2*f4*f5*f8 - 4*f3^2*f5*f8)*x[1]*x[3]*x[6]*x[7] +
(-32*f0*f5*f8 + 4*f0*f6*f7 - 8*f1*f4*f8 - 4*f2*f4*f7 +
2*f3^2*f7)*x[1]*x[3]*x[6]*x[8] + (-16*f0*f4*f8^2 + 8*f1*f3*f8^2 + 4*f1*f4*f7*f8
- 4*f1*f5*f6*f8 - 16*f2^2*f8^2 - 4*f2*f5^2*f8)*x[1]*x[3]*x[7]^2 + (8*f0*f6*f8 -
4*f0*f7^2 + 4*f1*f5*f8 + 8*f2*f4*f8 + 2*f2*f5*f7 -
4*f3^2*f8)*x[1]*x[3]*x[7]*x[8] - 4*f0*f8*x[1]*x[3]*x[8]^2 + (-16*f0*f2*f7*f8 +
8*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 16*f1^2*f7*f8 + 16*f1*f4^2*f8 -
8*f2*f3*f4*f8)*x[1]*x[4]^3 + (32*f0*f1*f8^2 - 8*f0*f2*f7*f8 + 16*f0*f4*f5*f8 -
8*f0*f4*f6*f7 + 4*f0*f5^2*f7 + 8*f1^2*f7*f8 - 12*f1*f3*f5*f8 + 2*f1*f3*f6*f7 +
16*f1*f4^2*f8 + 8*f2^2*f5*f8 - 16*f2*f3*f4*f8 + 4*f3^3*f8)*x[1]*x[4]^2*x[5] +
(32*f0*f2*f8^2 + 32*f0*f3*f7*f8 - 32*f1^2*f8^2 - 16*f1*f2*f7*f8 + 8*f1*f3*f6*f8
- 32*f1*f4*f5*f8 + 8*f1*f4*f6*f7 - 4*f1*f5^2*f7 + 8*f2*f3*f5*f8 - 4*f2*f3*f6*f7
+ 4*f3^2*f4*f8 + f3^2*f5*f7)*x[1]*x[4]^2*x[6] + (-8*f0*f3*f8^2 - 24*f0*f4*f7*f8
+ 16*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 8*f0*f6^2*f7 - 12*f1*f3*f7*f8 + 32*f1*f4*f6*f8
- 8*f1*f4*f7^2 - 8*f1*f5^2*f8 + 4*f1*f5*f6*f7 + 16*f2^2*f7*f8 - 24*f2*f3*f6*f8 +
4*f2*f3*f7^2 + 16*f2*f4*f5*f8 + 4*f3^2*f5*f8 - 8*f3*f4^2*f8)*x[1]*x[4]^2*x[7] +
(-4*f0*f5*f8 + 4*f0*f6*f7 - 24*f1*f4*f8 - 2*f1*f5*f7 +
8*f2*f3*f8)*x[1]*x[4]^2*x[8] + (8*f0*f1*f8^2 - 4*f0*f3*f7^2 + 16*f0*f4*f5*f8 +
4*f1^2*f7*f8 + 2*f1*f2*f7^2 - 2*f1*f3*f5*f8)*x[1]*x[4]*x[5]^2 + (-16*f0*f2*f8^2
+ 8*f0*f3*f7*f8 + 12*f0*f4*f7^2 - 32*f0*f5^2*f8 - 16*f1^2*f8^2 - 8*f1*f2*f7*f8 +
2*f1*f3*f7^2 - 16*f1*f4*f5*f8 - 4*f2^2*f7^2 + 8*f2*f3*f5*f8)*x[1]*x[4]*x[5]*x[6]
+ (-8*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 24*f0*f5*f6*f8 - 6*f0*f5*f7^2 +
16*f1*f2*f8^2 + 8*f1*f5^2*f8 + 8*f2*f4*f5*f8 - 4*f3^2*f5*f8)*x[1]*x[4]*x[5]*x[7]
+ (-8*f0*f5*f8 + 4*f0*f6*f7 - 8*f1*f4*f8 - 2*f1*f5*f7 +
8*f2*f3*f8)*x[1]*x[4]*x[5]*x[8] + (-40*f0*f3*f8^2 + 32*f1*f2*f8^2 - 8*f1*f4*f7^2
+ 24*f1*f5^2*f8 + 4*f2*f3*f7^2 - 6*f3^2*f5*f8)*x[1]*x[4]*x[6]^2 + (32*f0*f4*f8^2
- 24*f0*f5*f7*f8 + 8*f0*f6*f7^2 + 8*f1*f3*f8^2 + 16*f1*f4*f7*f8 - 32*f1*f5*f6*f8
+ 4*f1*f5*f7^2 - 32*f2^2*f8^2 - 16*f2*f5^2*f8 +
8*f3*f4*f5*f8)*x[1]*x[4]*x[6]*x[7] + (-8*f0*f6*f8 - 4*f0*f7^2 + 32*f1*f5*f8 -
4*f1*f6*f7 + 4*f2*f5*f7 - 6*f3^2*f8 - 2*f3*f4*f7)*x[1]*x[4]*x[6]*x[8] +
(-8*f0*f5*f8^2 + 16*f0*f6*f7*f8 - 8*f0*f7^3 - 16*f1*f4*f8^2 + 12*f1*f5*f7*f8 +
24*f2*f3*f8^2 - 16*f2*f4*f7*f8 + 16*f2*f5*f6*f8 - 2*f3*f5^2*f8)*x[1]*x[4]*x[7]^2
+ (4*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2 - 12*f2*f5*f8 - 4*f2*f6*f7 +
8*f3*f4*f8)*x[1]*x[4]*x[7]*x[8] + (8*f1*f8 + 2*f2*f7)*x[1]*x[4]*x[8]^2 +
(8*f0*f1*f8^2 + 2*f1^2*f7*f8)*x[1]*x[5]^3 + (-16*f0*f2*f8^2 + 16*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 8*f0*f4*f7^2 - 8*f1^2*f8^2 - 8*f1*f2*f7*f8 + 4*f1*f3*f6*f8 -
f1*f3*f7^2)*x[1]*x[5]^2*x[6] + (-16*f0*f3*f8^2 + 8*f0*f5*f6*f8 - 2*f0*f5*f7^2 +
8*f1*f2*f8^2 + 8*f1*f4*f6*f8 - 2*f1*f4*f7^2)*x[1]*x[5]^2*x[7] + (-4*f0*f5*f8 -
4*f1*f4*f8)*x[1]*x[5]^2*x[8] + (8*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 32*f0*f5*f6*f8 -
8*f0*f5*f7^2 + 16*f1*f2*f8^2 - 6*f1*f3*f7*f8 + 16*f1*f4*f6*f8 - 4*f1*f4*f7^2 +
8*f2^2*f7*f8 - 8*f2*f3*f6*f8 + 2*f2*f3*f7^2)*x[1]*x[5]*x[6]^2 + (24*f0*f5*f7*f8
- 48*f0*f6^2*f8 + 12*f0*f6*f7^2 + 8*f1*f3*f8^2 - 16*f1*f5*f6*f8 + 4*f1*f5*f7^2 -
16*f2^2*f8^2 - 16*f2*f4*f6*f8 + 4*f2*f4*f7^2 + 8*f3^2*f6*f8 -
2*f3^2*f7^2)*x[1]*x[5]*x[6]*x[7] + (24*f0*f6*f8 - 10*f0*f7^2 + 8*f1*f5*f8 +
8*f2*f4*f8 - 4*f3^2*f8)*x[1]*x[5]*x[6]*x[8] + (-24*f0*f5*f8^2 + 16*f0*f6*f7*f8 -
4*f0*f7^3 - 2*f1*f5*f7*f8 + 8*f1*f6^2*f8 - 2*f1*f6*f7^2 + 8*f2*f5*f6*f8 -
2*f2*f5*f7^2)*x[1]*x[5]*x[7]^2 + (4*f0*f7*f8 - 8*f1*f6*f8 + 2*f1*f7^2 -
8*f2*f5*f8)*x[1]*x[5]*x[7]*x[8] + (-8*f1*f3*f8^2 + 8*f1*f4*f7*f8 -
16*f1*f5*f6*f8 + 4*f1*f5*f7^2 - 4*f2*f3*f7*f8 + 4*f3^2*f6*f8 -
f3^2*f7^2)*x[1]*x[6]^3 + (16*f0*f5*f8^2 - 8*f0*f6*f7*f8 - 12*f1*f5*f7*f8 +
32*f1*f6^2*f8 - 8*f1*f6*f7^2 + 8*f2*f3*f8^2 + 16*f2*f5*f6*f8 - 4*f2*f5*f7^2 -
8*f3*f4*f6*f8 + 2*f3*f4*f7^2)*x[1]*x[6]^2*x[7] + (8*f0*f7*f8 - 16*f1*f6*f8 +
6*f1*f7^2 - 8*f2*f5*f8 + 4*f3*f4*f8)*x[1]*x[6]^2*x[8] + (-16*f0*f6*f8^2 +
12*f0*f7^2*f8 + 8*f1*f5*f8^2 - 16*f1*f6*f7*f8 + 4*f1*f7^3 + 8*f2*f5*f7*f8 -
32*f2*f6^2*f8 + 8*f2*f6*f7^2 + 4*f3*f5*f6*f8 - f3*f5*f7^2)*x[1]*x[6]*x[7]^2 +
(-4*f1*f7*f8 + 32*f2*f6*f8 - 6*f2*f7^2 - 4*f3*f5*f8)*x[1]*x[6]*x[7]*x[8] +
(-4*f2*f8 + f3*f7)*x[1]*x[6]*x[8]^2 + (-8*f0*f7*f8^2 + 16*f1*f6*f8^2 -
4*f1*f7^2*f8 - 16*f2*f5*f8^2 + 16*f2*f6*f7*f8 - 4*f2*f7^3)*x[1]*x[7]^3 +
(-4*f1*f8^2 - 4*f2*f7*f8)*x[1]*x[7]^2*x[8] - 2*f3*f8*x[1]*x[7]*x[8]^2 +
4*f0^2*f5*x[2]^4 + (-8*f0^2*f6 - 4*f0*f1*f5)*x[2]^3*x[3] + (-8*f0*f2*f5 +
4*f0*f3*f4 + 4*f1^2*f5 - f1*f3^2)*x[2]^3*x[4] + 8*f0^2*f7*x[2]^3*x[5] +
(-4*f0*f1*f8 + 4*f0*f2*f7 - 2*f1^2*f7)*x[2]^3*x[7] - 2*f0*f3*x[2]^3*x[8] +
(4*f0^2*f7 + 8*f0*f1*f6 + f1^2*f5)*x[2]^2*x[3]^2 + (16*f0^2*f8 + 16*f0*f2*f6 +
6*f0*f3*f5 - 8*f0*f4^2 - 8*f1^2*f6 - 4*f1*f2*f5 + 2*f1*f3*f4)*x[2]^2*x[3]*x[4] +
(-16*f0^2*f8 - 8*f0*f1*f7)*x[2]^2*x[3]*x[5] + (-4*f0*f1*f8 - 4*f0*f2*f7 +
2*f1^2*f7)*x[2]^2*x[3]*x[6] + (-8*f0*f2*f8 - 4*f0*f3*f7 + 8*f1^2*f8 +
2*f1*f2*f7)*x[2]^2*x[3]*x[7] + (4*f0*f4 + f1*f3)*x[2]^2*x[3]*x[8] + (-4*f0*f3*f6
- 4*f1*f3*f5 + 4*f1*f4^2 + 4*f2^2*f5 - 4*f2*f3*f4 + f3^3)*x[2]^2*x[4]^2 +
(4*f0*f1*f8 - 12*f0*f2*f7 + 6*f1^2*f7)*x[2]^2*x[4]*x[5] +
4*f0*f3*f7*x[2]^2*x[4]*x[6] + (8*f0*f3*f8 - 4*f0*f4*f7 - 8*f1*f2*f8 + 4*f1*f3*f7
- 4*f2^2*f7)*x[2]^2*x[4]*x[7] + (4*f0*f5 - 4*f1*f4 + 2*f2*f3)*x[2]^2*x[4]*x[8] +
8*f0*f1*f8*x[2]^2*x[5]^2 + (16*f0*f2*f8 + 2*f0*f3*f7 -
8*f1^2*f8)*x[2]^2*x[5]*x[6] + (-4*f1*f2*f8 - f1*f3*f7)*x[2]^2*x[5]*x[7] -
4*f0*f3*f8*x[2]^2*x[6]^2 + (-4*f1*f3*f8 + 8*f2^2*f8)*x[2]^2*x[6]*x[7] +
(-4*f0*f5*f8 + 4*f1*f4*f8 - 4*f2*f3*f8)*x[2]^2*x[7]^2 - 2*f0*f7*x[2]^2*x[7]*x[8]
+ f1*x[2]^2*x[8]^2 + (-4*f0*f1*f7 - 2*f1^2*f6)*x[2]*x[3]^3 + (-12*f0*f1*f8 -
8*f0*f2*f7 - 16*f0*f3*f6 + 8*f0*f4*f5 + 4*f1^2*f7 + 8*f1*f2*f6 -
f1*f3*f5)*x[2]*x[3]^2*x[4] + (4*f0*f1*f8 + 2*f1^2*f7)*x[2]*x[3]^2*x[5] +
(4*f0*f3*f7 + 4*f1^2*f8 - 2*f1*f2*f7)*x[2]*x[3]^2*x[6] + (8*f0*f3*f8 -
4*f1*f2*f8)*x[2]*x[3]^2*x[7] + (-2*f0*f5 - 2*f1*f4)*x[2]*x[3]^2*x[8] +
(-8*f0*f2*f8 + 4*f0*f3*f7 + 16*f0*f4*f6 - 8*f0*f5^2 + 8*f1^2*f8 + 6*f1*f3*f6 -
4*f1*f4*f5 - 8*f2^2*f6 + 2*f2*f3*f5)*x[2]*x[3]*x[4]^2 + (24*f0*f2*f8 +
12*f0*f3*f7 - 8*f1^2*f8 - 6*f1*f2*f7)*x[2]*x[3]*x[4]*x[5] + (12*f0*f3*f8 -
12*f0*f4*f7 - 8*f1*f2*f8 - 2*f1*f3*f7 + 4*f2^2*f7)*x[2]*x[3]*x[4]*x[6] +
(10*f0*f5*f7 - 8*f1*f3*f8 + 8*f2^2*f8)*x[2]*x[3]*x[4]*x[7] + (-12*f0*f6 +
4*f1*f5 + 4*f2*f4 - 2*f3^2)*x[2]*x[3]*x[4]*x[8] - 2*f1^2*f8*x[2]*x[3]*x[5]^2 +
(-20*f0*f3*f8 - 4*f0*f4*f7 + 4*f1*f2*f8)*x[2]*x[3]*x[5]*x[6] + (6*f1*f3*f8 +
2*f1*f4*f7)*x[2]*x[3]*x[5]*x[7] + (4*f0*f5*f7 + 2*f1*f3*f8)*x[2]*x[3]*x[6]^2 +
(-4*f0*f6*f7 + 8*f1*f4*f8 - 2*f1*f5*f7 - 8*f2*f3*f8)*x[2]*x[3]*x[6]*x[7] +
6*f0*f7*x[2]*x[3]*x[6]*x[8] + (8*f0*f6*f8 - 6*f1*f5*f8 + 2*f1*f6*f7 +
4*f3^2*f8)*x[2]*x[3]*x[7]^2 - 2*f1*f7*x[2]*x[3]*x[7]*x[8] -
2*f2*x[2]*x[3]*x[8]^2 + (-8*f1*f4*f6 + 4*f1*f5^2 + 4*f2*f3*f6 -
f3^2*f5)*x[2]*x[4]^3 + (-8*f0*f3*f8 - 4*f0*f4*f7 - 4*f1*f3*f7 +
4*f2^2*f7)*x[2]*x[4]^2*x[5] + (8*f1*f4*f7 - 4*f2*f3*f7)*x[2]*x[4]^2*x[6] +
(-12*f0*f5*f8 + 4*f0*f6*f7 - 6*f1*f5*f7)*x[2]*x[4]^2*x[7] + (4*f1*f6 - 4*f2*f5 +
2*f3*f4)*x[2]*x[4]^2*x[8] + (-8*f0*f3*f8 - 4*f0*f4*f7 + 4*f1*f2*f8 +
f1*f3*f7)*x[2]*x[4]*x[5]^2 + (16*f0*f4*f8 + 4*f0*f5*f7 + 8*f1*f3*f8 + 4*f1*f4*f7
- 8*f2^2*f8 - 2*f2*f3*f7)*x[2]*x[4]*x[5]*x[6] + (-8*f0*f5*f8 - 4*f0*f6*f7 -
8*f1*f4*f8 - 4*f2*f4*f7 + 2*f3^2*f7)*x[2]*x[4]*x[5]*x[7] +
6*f0*f7*x[2]*x[4]*x[5]*x[8] + (-8*f1*f4*f8 - 4*f1*f5*f7 + 4*f2*f3*f8 +
f3^2*f7)*x[2]*x[4]*x[6]^2 + (8*f0*f6*f8 - 4*f0*f7^2 + 8*f1*f5*f8 + 4*f1*f6*f7 +
4*f2*f5*f7 + 2*f3^2*f8 - 2*f3*f4*f7)*x[2]*x[4]*x[6]*x[7] -
4*f1*f7*x[2]*x[4]*x[6]*x[8] + (-8*f1*f6*f8 + 4*f2*f5*f8 - 4*f2*f6*f7 -
4*f3*f4*f8 + f3*f5*f7)*x[2]*x[4]*x[7]^2 + (8*f1*f8 +
6*f2*f7)*x[2]*x[4]*x[7]*x[8] - f3*x[2]*x[4]*x[8]^2 + (16*f0*f4*f8 -
2*f1*f3*f8)*x[2]*x[5]^2*x[6] + (-4*f0*f5*f8 - 4*f1*f4*f8)*x[2]*x[5]^2*x[7] +
2*f0*f7*x[2]*x[5]^2*x[8] + (-16*f0*f5*f8 - 8*f1*f4*f8 +
4*f2*f3*f8)*x[2]*x[5]*x[6]^2 + (24*f0*f6*f8 - 2*f0*f7^2 + 8*f1*f5*f8 +
8*f2*f4*f8 - 4*f3^2*f8)*x[2]*x[5]*x[6]*x[7] + (-16*f0*f8 -
2*f1*f7)*x[2]*x[5]*x[6]*x[8] + (-8*f0*f7*f8 - 4*f1*f6*f8 -
4*f2*f5*f8)*x[2]*x[5]*x[7]^2 + (8*f1*f8 + 2*f2*f7)*x[2]*x[5]*x[7]*x[8] +
(8*f1*f5*f8 - 2*f3^2*f8)*x[2]*x[6]^3 + (-16*f1*f6*f8 + 2*f1*f7^2 - 8*f2*f5*f8 +
4*f3*f4*f8)*x[2]*x[6]^2*x[7] + 4*f1*f8*x[2]*x[6]^2*x[8] + (8*f1*f7*f8 +
16*f2*f6*f8 - 2*f2*f7^2 - 2*f3*f5*f8)*x[2]*x[6]*x[7]^2 -
12*f2*f8*x[2]*x[6]*x[7]*x[8] + (-4*f1*f8^2 - 4*f2*f7*f8)*x[2]*x[7]^3 +
2*f3*f8*x[2]*x[7]^2*x[8] + (4*f0*f1*f8 + f1^2*f7)*x[3]^4 + (8*f0*f3*f7 -
2*f0*f5^2 - 4*f1^2*f8 - 4*f1*f2*f7)*x[3]^3*x[4] - 2*f1^2*f8*x[3]^3*x[5] +
f1*f5*x[3]^3*x[8] + (-16*f0*f4*f7 + 8*f0*f5*f6 + 4*f1*f2*f8 - 2*f1*f3*f7 +
f1*f5^2 + 4*f2^2*f7)*x[3]^2*x[4]^2 + (-16*f0*f3*f8 +
8*f1*f2*f8)*x[3]^2*x[4]*x[5] + (-2*f0*f5*f7 - 2*f1*f3*f8)*x[3]^2*x[4]*x[6] +
(-12*f0*f5*f8 + 4*f1*f4*f8)*x[3]^2*x[4]*x[7] + (8*f0*f7 - 2*f1*f6 -
2*f2*f5)*x[3]^2*x[4]*x[8] + (2*f0*f5*f7 + 2*f1*f3*f8)*x[3]^2*x[5]*x[6] +
(4*f0*f5*f8 - 4*f1*f4*f8 - f1*f5*f7)*x[3]^2*x[5]*x[7] + (4*f0*f5*f8 - 4*f0*f6*f7
+ 4*f1*f4*f8 - 4*f2*f3*f8)*x[3]^2*x[6]^2 + (4*f0*f7^2 - 8*f1*f5*f8 + 2*f1*f6*f7
+ 4*f3^2*f8)*x[3]^2*x[6]*x[7] + (-4*f0*f7*f8 + 4*f1*f6*f8 - 2*f1*f7^2 +
4*f2*f5*f8 - 4*f3*f4*f8)*x[3]^2*x[7]^2 - 2*f1*f8*x[3]^2*x[7]*x[8] +
f3*x[3]^2*x[8]^2 + (8*f0*f4*f8 + 8*f0*f5*f7 - 8*f0*f6^2 - 4*f1*f3*f8 +
8*f1*f4*f7 - 4*f1*f5*f6 - 4*f2*f3*f7)*x[3]*x[4]^3 + (16*f0*f4*f8 - 6*f0*f5*f7 +
6*f1*f3*f8 - 8*f2^2*f8)*x[3]*x[4]^2*x[5] + (-20*f0*f5*f8 + 12*f0*f6*f7 +
2*f1*f5*f7 + 4*f2*f3*f8)*x[3]*x[4]^2*x[6] + (24*f0*f6*f8 - 16*f0*f7^2 +
12*f1*f5*f8 - 8*f2*f4*f8)*x[3]*x[4]^2*x[7] + (-4*f0*f8 - 4*f1*f7 + 4*f2*f6 +
f3*f5)*x[3]*x[4]^2*x[8] + (8*f0*f4*f8 + 2*f0*f5*f7 -
2*f1*f3*f8)*x[3]*x[4]*x[5]^2 + (24*f0*f5*f8 - 4*f0*f6*f7 - 8*f1*f4*f8 -
2*f1*f5*f7 + 4*f2*f3*f8)*x[3]*x[4]*x[5]*x[6] + (-8*f0*f6*f8 + 4*f0*f7^2 +
8*f2*f4*f8 + 2*f2*f5*f7 - 4*f3^2*f8)*x[3]*x[4]*x[5]*x[7] + (-8*f0*f8 +
2*f1*f7)*x[3]*x[4]*x[5]*x[8] + (-4*f0*f7^2 - 12*f1*f5*f8 + 4*f1*f6*f7 +
2*f3^2*f8)*x[3]*x[4]*x[6]^2 + (12*f0*f7*f8 - 4*f1*f7^2 + 12*f2*f5*f8 -
4*f2*f6*f7 - 8*f3*f4*f8)*x[3]*x[4]*x[6]*x[7] - 2*f2*f7*x[3]*x[4]*x[6]*x[8] +
(-16*f0*f8^2 + 4*f1*f7*f8 - 8*f2*f6*f8 + 4*f2*f7^2 - 4*f3*f5*f8 +
8*f4^2*f8)*x[3]*x[4]*x[7]^2 - 2*f4*x[3]*x[4]*x[8]^2 -
12*f0*f5*f8*x[3]*x[5]^2*x[6] + 6*f1*f5*f8*x[3]*x[5]^2*x[7] + (-4*f0*f8 -
f1*f7)*x[3]*x[5]^2*x[8] + (6*f0*f7^2 + 4*f1*f5*f8)*x[3]*x[5]*x[6]^2 +
(-20*f0*f7*f8 - 2*f1*f7^2 - 8*f2*f5*f8)*x[3]*x[5]*x[6]*x[7] + (4*f1*f8 +
2*f2*f7)*x[3]*x[5]*x[6]*x[8] + (16*f0*f8^2 + 2*f1*f7*f8 +
4*f3*f5*f8)*x[3]*x[5]*x[7]^2 + (-4*f2*f8 - 2*f3*f7)*x[3]*x[5]*x[7]*x[8] -
2*f1*f7^2*x[3]*x[6]^3 + (12*f1*f7*f8 + 2*f2*f7^2 + 2*f3*f5*f8)*x[3]*x[6]^2*x[7]
- f3*f7*x[3]*x[6]^2*x[8] + (-12*f1*f8^2 - 8*f2*f7*f8 -
4*f4*f5*f8)*x[3]*x[6]*x[7]^2 + (6*f3*f8 + 2*f4*f7)*x[3]*x[6]*x[7]*x[8] +
(8*f2*f8^2 + 2*f5^2*f8)*x[3]*x[7]^3 + (-4*f4*f8 - f5*f7)*x[3]*x[7]^2*x[8] +
x[3]*x[8]^3 + (-4*f1*f5*f7 + 4*f1*f6^2 + f3^2*f7)*x[4]^4 + (-4*f0*f5*f8 +
4*f0*f6*f7 - 8*f1*f4*f8 + 2*f1*f5*f7 + 4*f2*f3*f8)*x[4]^3*x[5] + (8*f1*f5*f8 -
8*f1*f6*f7 - 2*f3^2*f8)*x[4]^3*x[6] + (8*f0*f7*f8 - 16*f1*f6*f8 + 8*f1*f7^2 +
4*f3*f4*f8)*x[4]^3*x[7] - 2*f3*f6*x[4]^3*x[8] - 4*f0*f5*f8*x[4]^2*x[5]^2 +
(-8*f0*f6*f8 - 4*f0*f7^2 - 2*f3^2*f8)*x[4]^2*x[5]*x[6] + (8*f0*f7*f8 -
4*f2*f5*f8 + 4*f3*f4*f8 - f3*f5*f7)*x[4]^2*x[5]*x[7] + (4*f1*f8 -
2*f2*f7)*x[4]^2*x[5]*x[8] + (8*f1*f6*f8 + 4*f1*f7^2)*x[4]^2*x[6]^2 +
(-16*f0*f8^2 - 8*f1*f7*f8 - 4*f3*f5*f8 + 2*f3*f6*f7)*x[4]^2*x[6]*x[7] +
2*f3*f7*x[4]^2*x[6]*x[8] + (16*f1*f8^2 - 4*f2*f7*f8 + 8*f3*f6*f8 - 2*f3*f7^2 -
4*f4*f5*f8)*x[4]^2*x[7]^2 - 2*f3*f8*x[4]^2*x[7]*x[8] + f5*x[4]^2*x[8]^2 -
4*f0*f5*f8*x[4]*x[5]^3 + (2*f0*f7^2 + 4*f1*f5*f8)*x[4]*x[5]^2*x[6] -
4*f2*f5*f8*x[4]*x[5]^2*x[7] - 2*f1*f8*x[4]*x[5]^2*x[8] + (8*f0*f7*f8 -
2*f1*f7^2)*x[4]*x[5]*x[6]^2 + (4*f1*f7*f8 + 2*f2*f7^2 +
4*f3*f5*f8)*x[4]*x[5]*x[6]*x[7] + 4*f2*f8*x[4]*x[5]*x[6]*x[8] + (-4*f1*f8^2 -
4*f4*f5*f8)*x[4]*x[5]*x[7]^2 + (-2*f3*f8 + 2*f4*f7)*x[4]*x[5]*x[7]*x[8] -
8*f1*f7*f8*x[4]*x[6]^3 - 2*f3*f7^2*x[4]*x[6]^2*x[7] - 2*f3*f8*x[4]*x[6]^2*x[8] +
(8*f2*f8^2 + 2*f3*f7*f8 + 4*f5^2*f8)*x[4]*x[6]*x[7]^2 -
2*f5*f7*x[4]*x[6]*x[7]*x[8] + (-8*f3*f8^2 + 4*f4*f7*f8 - 4*f5*f6*f8)*x[4]*x[7]^3
+ (2*f5*f8 + 2*f6*f7)*x[4]*x[7]^2*x[8] - 2*f7*x[4]*x[7]*x[8]^2 + (8*f0*f6*f8 -
2*f0*f7^2)*x[5]^3*x[6] + (-4*f1*f6*f8 + f1*f7^2)*x[5]^3*x[7] +
2*f1*f8*x[5]^3*x[8] + (-8*f0*f7*f8 - 4*f1*f6*f8 + f1*f7^2)*x[5]^2*x[6]^2 +
(16*f0*f8^2 + 2*f1*f7*f8 + 8*f2*f6*f8 - 2*f2*f7^2)*x[5]^2*x[6]*x[7] -
4*f2*f8*x[5]^2*x[6]*x[8] + (-4*f3*f6*f8 + f3*f7^2)*x[5]^2*x[7]^2 +
4*f3*f8*x[5]^2*x[7]*x[8] + 4*f1*f7*f8*x[5]*x[6]^3 + (-16*f1*f8^2 - 4*f2*f7*f8 -
4*f3*f6*f8 + f3*f7^2)*x[5]*x[6]^2*x[7] + 2*f3*f8*x[5]*x[6]^2*x[8] + (8*f2*f8^2 +
8*f4*f6*f8 - 2*f4*f7^2)*x[5]*x[6]*x[7]^2 - 8*f4*f8*x[5]*x[6]*x[7]*x[8] +
(-4*f5*f6*f8 + f5*f7^2)*x[5]*x[7]^3 + 6*f5*f8*x[5]*x[7]^2*x[8] -
f7*x[5]*x[7]*x[8]^2 + 4*f1*f8^2*x[6]^4 + 2*f3*f7*f8*x[6]^3*x[7] + (-4*f3*f8^2 -
4*f5*f6*f8 + f5*f7^2)*x[6]^2*x[7]^2 + 4*f5*f8*x[6]^2*x[7]*x[8] + (-2*f5*f7*f8 +
8*f6^2*f8 - 2*f6*f7^2)*x[6]*x[7]^3 + (-12*f6*f8 + 2*f7^2)*x[6]*x[7]^2*x[8] +
4*f8*x[6]*x[7]*x[8]^2 + (4*f5*f8^2 - 4*f6*f7*f8 + f7^3)*x[7]^4 +
2*f7*f8*x[7]^3*x[8],

// number 4
(64*f0^3*f4*f8^3 - 32*f0^3*f5*f7*f8^2 + 64*f0^3*f6^2*f8^2 - 16*f0^3*f6*f7^2*f8 -
32*f0^2*f1*f3*f8^3 - 32*f0^2*f1*f5*f6*f8^2 + 8*f0^2*f1*f5*f7^2*f8 +
64*f0^2*f2^2*f8^3 - 32*f0^2*f2*f3*f7*f8^2 + 192*f0^2*f2*f4*f6*f8^2 -
32*f0^2*f2*f4*f7^2*f8 + 32*f0^2*f2*f5^2*f8^2 - 96*f0^2*f2*f5*f6*f7*f8 +
16*f0^2*f2*f5*f7^3 + 64*f0^2*f2*f6^3*f8 - 16*f0^2*f2*f6^2*f7^2 +
32*f0^2*f3^2*f6*f8^2 - 8*f0^2*f3^2*f7^2*f8 - 96*f0^2*f3*f4*f5*f8^2 +
24*f0^2*f3*f5^2*f7*f8 - 32*f0^2*f3*f5*f6^2*f8 + 8*f0^2*f3*f5*f6*f7^2 +
64*f0^2*f4^3*f8^2 - 32*f0^2*f4^2*f5*f7*f8 + 64*f0^2*f4^2*f6^2*f8 -
16*f0^2*f4^2*f6*f7^2 - 16*f0^2*f4*f5^2*f6*f8 + 4*f0^2*f4*f5^2*f7^2 -
16*f0*f1^2*f2*f8^3 + 8*f0*f1^2*f3*f7*f8^2 - 32*f0*f1^2*f4*f6*f8^2 +
4*f0*f1^2*f4*f7^2*f8 - 8*f0*f1^2*f5^2*f8^2 + 24*f0*f1^2*f5*f6*f7*f8 -
4*f0*f1^2*f5*f7^3 - 16*f0*f1^2*f6^3*f8 + 4*f0*f1^2*f6^2*f7^2 -
96*f0*f1*f2*f3*f6*f8^2 + 24*f0*f1*f2*f3*f7^2*f8 + 32*f0*f1*f2*f4*f6*f7*f8 -
8*f0*f1*f2*f4*f7^3 - 8*f0*f1*f2*f5^2*f7*f8 + 24*f0*f1*f3^2*f5*f8^2 -
8*f0*f1*f3^2*f6*f7*f8 + 2*f0*f1*f3^2*f7^3 - 32*f0*f1*f3*f4^2*f8^2 +
16*f0*f1*f3*f4*f5*f7*f8 - 32*f0*f1*f3*f4*f6^2*f8 + 8*f0*f1*f3*f4*f6*f7^2 +
8*f0*f1*f3*f5^2*f6*f8 - 2*f0*f1*f3*f5^2*f7^2 + 64*f0*f2^3*f6*f8^2 -
16*f0*f2^3*f7^2*f8 - 32*f0*f2^2*f3*f5*f8^2 + 64*f0*f2^2*f4^2*f8^2 -
32*f0*f2^2*f4*f5*f7*f8 + 64*f0*f2^2*f4*f6^2*f8 - 16*f0*f2^2*f4*f6*f7^2 -
16*f0*f2^2*f5^2*f6*f8 + 4*f0*f2^2*f5^2*f7^2 - 16*f0*f2*f3^2*f4*f8^2 +
8*f0*f2*f3^2*f5*f7*f8 - 16*f0*f2*f3^2*f6^2*f8 + 4*f0*f2*f3^2*f6*f7^2 +
16*f1^3*f3*f6*f8^2 - 4*f1^3*f3*f7^2*f8 - 8*f1^3*f4*f6*f7*f8 + 2*f1^3*f4*f7^3 +
2*f1^3*f5^2*f7*f8 - 16*f1^2*f2^2*f6*f8^2 + 4*f1^2*f2^2*f7^2*f8 +
8*f1^2*f2*f3*f5*f8^2 - 16*f1^2*f2*f4^2*f8^2 + 8*f1^2*f2*f4*f5*f7*f8 -
16*f1^2*f2*f4*f6^2*f8 + 4*f1^2*f2*f4*f6*f7^2 + 4*f1^2*f2*f5^2*f6*f8 -
f1^2*f2*f5^2*f7^2 + 4*f1^2*f3^2*f4*f8^2 - 2*f1^2*f3^2*f5*f7*f8 +
4*f1^2*f3^2*f6^2*f8 - f1^2*f3^2*f6*f7^2)*x[1]^4 + (-128*f0^3*f6*f8^2 +
32*f0^3*f7^2*f8 + 48*f0^2*f1*f5*f8^2 - 192*f0^2*f2*f4*f8^2 + 80*f0^2*f2*f5*f7*f8
- 128*f0^2*f2*f6^2*f8 + 32*f0^2*f2*f6*f7^2 - 16*f0^2*f3^2*f8^2 +
32*f0^2*f3*f4*f7*f8 + 64*f0^2*f3*f5*f6*f8 - 24*f0^2*f3*f5*f7^2 -
128*f0^2*f4^2*f6*f8 + 32*f0^2*f4^2*f7^2 + 32*f0^2*f4*f5^2*f8 +
32*f0*f1^2*f4*f8^2 - 20*f0*f1^2*f5*f7*f8 + 32*f0*f1^2*f6^2*f8 -
8*f0*f1^2*f6*f7^2 + 96*f0*f1*f2*f3*f8^2 - 32*f0*f1*f2*f4*f7*f8 +
8*f0*f1*f2*f5*f7^2 - 4*f0*f1*f3^2*f7*f8 + 64*f0*f1*f3*f4*f6*f8 -
16*f0*f1*f3*f4*f7^2 - 16*f0*f1*f3*f5^2*f8 - 64*f0*f2^3*f8^2 +
16*f0*f2^2*f3*f7*f8 - 128*f0*f2^2*f4*f6*f8 + 32*f0*f2^2*f4*f7^2 +
32*f0*f2^2*f5^2*f8 + 32*f0*f2*f3^2*f6*f8 - 8*f0*f2*f3^2*f7^2 - 16*f1^3*f3*f8^2 +
8*f1^3*f4*f7*f8 - 2*f1^3*f5*f7^2 + 16*f1^2*f2^2*f8^2 - 4*f1^2*f2*f3*f7*f8 +
32*f1^2*f2*f4*f6*f8 - 8*f1^2*f2*f4*f7^2 - 8*f1^2*f2*f5^2*f8 - 8*f1^2*f3^2*f6*f8
+ 2*f1^2*f3^2*f7^2)*x[1]^3*x[2] + (32*f0^3*f7*f8^2 + 32*f0^2*f1*f6*f8^2 -
16*f0^2*f1*f7^2*f8 - 64*f0^2*f2*f5*f8^2 + 128*f0^2*f2*f6*f7*f8 - 32*f0^2*f2*f7^3
+ 96*f0^2*f3*f4*f8^2 - 40*f0^2*f3*f5*f7*f8 + 64*f0^2*f4*f5*f6*f8 -
16*f0^2*f4*f5*f7^2 - 16*f0^2*f5^3*f8 + 8*f0*f1^2*f5*f8^2 - 32*f0*f1^2*f6*f7*f8 +
8*f0*f1^2*f7^3 - 32*f0*f1*f3^2*f8^2 - 8*f0*f1*f3*f4*f7*f8 - 24*f0*f1*f3*f5*f6*f8
+ 8*f0*f1*f3*f5*f7^2 + 32*f0*f2^2*f3*f8^2 + 32*f0*f2^2*f4*f7*f8 +
32*f0*f2^2*f5*f6*f8 - 16*f0*f2^2*f5*f7^2 - 16*f0*f2*f3^2*f7*f8 -
8*f0*f2*f3*f5^2*f8 - 8*f1^2*f2*f3*f8^2 - 8*f1^2*f2*f4*f7*f8 - 8*f1^2*f2*f5*f6*f8
+ 4*f1^2*f2*f5*f7^2 + 4*f1^2*f3^2*f7*f8 + 2*f1^2*f3*f5^2*f8)*x[1]^3*x[3] +
(-16*f0^2*f1*f7*f8^2 + 64*f0^2*f2*f6*f8^2 - 32*f0^2*f2*f7^2*f8 +
48*f0^2*f3*f5*f8^2 - 48*f0^2*f3*f6*f7*f8 + 16*f0^2*f3*f7^3 - 64*f0^2*f4^2*f8^2 -
16*f0^2*f5^2*f6*f8 + 8*f0^2*f5^2*f7^2 - 32*f0*f1^2*f6*f8^2 + 16*f0*f1^2*f7^2*f8
- 48*f0*f1*f2*f5*f8^2 + 12*f0*f1*f3*f5*f7*f8 + 16*f0*f1*f4^2*f7*f8 -
16*f0*f1*f4*f5*f6*f8 + 8*f0*f1*f5^3*f8 - 16*f0*f2*f3^2*f8^2 -
16*f0*f2*f3*f4*f7*f8 - 16*f0*f2*f3*f5*f6*f8 + 8*f0*f2*f3*f5*f7^2 +
8*f0*f3^3*f7*f8 + 4*f0*f3^2*f5^2*f8 + 16*f1^3*f5*f8^2 + 8*f1^2*f3^2*f8^2 +
8*f1^2*f3*f5*f6*f8 - 2*f1^2*f3*f5*f7^2)*x[1]^3*x[4] + (-64*f0^3*f8^3 +
16*f0^2*f1*f7*f8^2 - 256*f0^2*f2*f6*f8^2 + 64*f0^2*f2*f7^2*f8 +
64*f0^2*f3*f5*f8^2 + 32*f0^2*f3*f6*f7*f8 - 8*f0^2*f3*f7^3 - 128*f0^2*f4^2*f8^2 +
64*f0^2*f4*f5*f7*f8 - 128*f0^2*f4*f6^2*f8 + 32*f0^2*f4*f6*f7^2 +
32*f0^2*f5^2*f6*f8 - 8*f0^2*f5^2*f7^2 + 64*f0*f1^2*f6*f8^2 - 16*f0*f1^2*f7^2*f8
+ 32*f0*f1*f2*f5*f8^2 - 32*f0*f1*f2*f6*f7*f8 + 8*f0*f1*f2*f7^3 +
64*f0*f1*f3*f4*f8^2 - 28*f0*f1*f3*f5*f7*f8 + 48*f0*f1*f3*f6^2*f8 -
12*f0*f1*f3*f6*f7^2 - 128*f0*f2^2*f4*f8^2 + 48*f0*f2^2*f5*f7*f8 -
64*f0*f2^2*f6^2*f8 + 16*f0*f2^2*f6*f7^2 + 32*f0*f2*f3^2*f8^2 +
16*f0*f2*f3*f5*f6*f8 - 4*f0*f2*f3*f5*f7^2 - 8*f1^3*f5*f8^2 + 8*f1^3*f6*f7*f8 -
2*f1^3*f7^3 + 32*f1^2*f2*f4*f8^2 - 12*f1^2*f2*f5*f7*f8 + 16*f1^2*f2*f6^2*f8 -
4*f1^2*f2*f6*f7^2 - 8*f1^2*f3^2*f8^2 - 4*f1^2*f3*f5*f6*f8 +
f1^2*f3*f5*f7^2)*x[1]^3*x[5] + (32*f0^2*f1*f8^3 + 32*f0^2*f2*f7*f8^2 -
64*f0^2*f3*f6*f8^2 + 8*f0^2*f3*f7^2*f8 + 96*f0^2*f4*f5*f8^2 - 32*f0^2*f5^2*f7*f8
+ 32*f0^2*f5*f6^2*f8 - 8*f0^2*f5*f6*f7^2 - 16*f0*f1^2*f7*f8^2 +
128*f0*f1*f2*f6*f8^2 - 32*f0*f1*f2*f7^2*f8 - 40*f0*f1*f3*f5*f8^2 -
8*f0*f1*f4*f5*f7*f8 + 32*f0*f1*f4*f6^2*f8 - 8*f0*f1*f4*f6*f7^2 -
16*f0*f1*f5^2*f6*f8 + 4*f0*f1*f5^2*f7^2 + 64*f0*f2*f3*f4*f8^2 -
24*f0*f2*f3*f5*f7*f8 + 32*f0*f2*f3*f6^2*f8 - 8*f0*f2*f3*f6*f7^2 -
16*f0*f3^3*f8^2 - 8*f0*f3^2*f5*f6*f8 + 2*f0*f3^2*f5*f7^2 - 32*f1^3*f6*f8^2 +
8*f1^3*f7^2*f8 - 16*f1^2*f3*f4*f8^2 + 8*f1^2*f3*f5*f7*f8 - 16*f1^2*f3*f6^2*f8 +
4*f1^2*f3*f6*f7^2)*x[1]^3*x[6] + (-128*f0^2*f2*f8^3 + 48*f0^2*f3*f7*f8^2 -
192*f0^2*f4*f6*f8^2 + 32*f0^2*f4*f7^2*f8 - 16*f0^2*f5^2*f8^2 +
96*f0^2*f5*f6*f7*f8 - 16*f0^2*f5*f7^3 - 64*f0^2*f6^3*f8 + 16*f0^2*f6^2*f7^2 +
32*f0*f1^2*f8^3 + 80*f0*f1*f3*f6*f8^2 - 20*f0*f1*f3*f7^2*f8 +
32*f0*f1*f4*f5*f8^2 - 32*f0*f1*f4*f6*f7*f8 + 8*f0*f1*f4*f7^3 -
4*f0*f1*f5^2*f7*f8 + 16*f0*f1*f5*f6^2*f8 - 4*f0*f1*f5*f6*f7^2 -
128*f0*f2^2*f6*f8^2 + 32*f0*f2^2*f7^2*f8 + 64*f0*f2*f3*f5*f8^2 -
128*f0*f2*f4^2*f8^2 + 64*f0*f2*f4*f5*f7*f8 - 128*f0*f2*f4*f6^2*f8 +
32*f0*f2*f4*f6*f7^2 + 32*f0*f2*f5^2*f6*f8 - 8*f0*f2*f5^2*f7^2 +
32*f0*f3^2*f4*f8^2 - 16*f0*f3^2*f5*f7*f8 + 32*f0*f3^2*f6^2*f8 -
8*f0*f3^2*f6*f7^2 + 32*f1^2*f2*f6*f8^2 - 8*f1^2*f2*f7^2*f8 - 24*f1^2*f3*f5*f8^2
+ 8*f1^2*f3*f6*f7*f8 - 2*f1^2*f3*f7^3 + 32*f1^2*f4^2*f8^2 - 16*f1^2*f4*f5*f7*f8
+ 32*f1^2*f4*f6^2*f8 - 8*f1^2*f4*f6*f7^2 - 8*f1^2*f5^2*f6*f8 +
2*f1^2*f5^2*f7^2)*x[1]^3*x[7] + (64*f0^2*f4*f8^2 - 24*f0^2*f5*f7*f8 +
32*f0^2*f6^2*f8 - 8*f0^2*f6*f7^2 - 24*f0*f1*f3*f8^2 - 8*f0*f1*f5*f6*f8 +
2*f0*f1*f5*f7^2 + 32*f0*f2^2*f8^2 - 8*f0*f2*f3*f7*f8 + 64*f0*f2*f4*f6*f8 -
16*f0*f2*f4*f7^2 - 16*f0*f2*f5^2*f8 - 16*f0*f3^2*f6*f8 + 4*f0*f3^2*f7^2 -
8*f1^2*f2*f8^2 + 2*f1^2*f3*f7*f8 - 16*f1^2*f4*f6*f8 + 4*f1^2*f4*f7^2 +
4*f1^2*f5^2*f8)*x[1]^3*x[8] + (48*f0^3*f8^2 - 8*f0^2*f1*f7*f8 + 48*f0^2*f2*f6*f8
- 16*f0^2*f2*f7^2 - 24*f0^2*f3*f5*f8 + 8*f0^2*f3*f6*f7 + 32*f0^2*f4^2*f8 -
8*f0^2*f4*f5*f7 - 12*f0*f1^2*f6*f8 + 4*f0*f1^2*f7^2 - 8*f0*f1*f2*f6*f7 -
16*f0*f1*f3*f4*f8 + 4*f0*f1*f3*f5*f7 + 32*f0*f2^2*f4*f8 - 8*f0*f2^2*f5*f7 -
12*f0*f2*f3^2*f8 + 2*f1^3*f6*f7 - 8*f1^2*f2*f4*f8 + 2*f1^2*f2*f5*f7 +
3*f1^2*f3^2*f8)*x[1]^2*x[2]^2 + (-32*f0^2*f1*f8^2 - 64*f0^2*f2*f7*f8 -
48*f0^2*f3*f6*f8 + 24*f0^2*f3*f7^2 - 32*f0^2*f4*f5*f8 + 8*f0^2*f5^2*f7 +
24*f0*f1^2*f7*f8 + 32*f0*f1*f2*f6*f8 - 8*f0*f1*f2*f7^2 + 28*f0*f1*f3*f5*f8 -
4*f0*f1*f3*f6*f7 - 48*f0*f2^2*f5*f8 + 16*f0*f2^2*f6*f7 + 16*f0*f2*f3*f4*f8 +
4*f0*f2*f3*f5*f7 - 8*f1^3*f6*f8 + 2*f1^3*f7^2 + 12*f1^2*f2*f5*f8 -
4*f1^2*f2*f6*f7 - 4*f1^2*f3*f4*f8 - f1^2*f3*f5*f7)*x[1]^2*x[2]*x[3] +
(8*f0^2*f3*f7*f8 + 96*f0^2*f4*f6*f8 - 32*f0^2*f4*f7^2 - 8*f0^2*f5*f6*f7 +
16*f0*f1^2*f8^2 + 16*f0*f1*f2*f7*f8 - 16*f0*f1*f3*f6*f8 - 8*f0*f1*f4*f5*f8 +
8*f0*f1*f4*f6*f7 - 4*f0*f1*f5^2*f7 + 24*f0*f2*f3*f5*f8 - 8*f0*f2*f3*f6*f7 -
8*f0*f3^2*f4*f8 - 2*f0*f3^2*f5*f7 - 8*f1^3*f7*f8 -
8*f1^2*f3*f5*f8)*x[1]^2*x[2]*x[4] + (192*f0^2*f2*f8^2 - 48*f0^2*f3*f7*f8 +
192*f0^2*f4*f6*f8 - 48*f0^2*f4*f7^2 - 48*f0^2*f5^2*f8 - 56*f0*f1^2*f8^2 +
16*f0*f1*f2*f7*f8 - 72*f0*f1*f3*f6*f8 + 20*f0*f1*f3*f7^2 + 96*f0*f2^2*f6*f8 -
32*f0*f2^2*f7^2 - 24*f0*f2*f3*f5*f8 - 4*f1^3*f7*f8 - 24*f1^2*f2*f6*f8 +
8*f1^2*f2*f7^2 + 6*f1^2*f3*f5*f8)*x[1]^2*x[2]*x[5] + (48*f0^2*f3*f8^2 -
16*f0^2*f4*f7*f8 - 48*f0^2*f5*f6*f8 + 24*f0^2*f5*f7^2 - 112*f0*f1*f2*f8^2 +
16*f0*f1*f3*f7*f8 - 48*f0*f1*f4*f6*f8 + 8*f0*f1*f4*f7^2 + 24*f0*f1*f5^2*f8 -
48*f0*f2*f3*f6*f8 + 16*f0*f2*f3*f7^2 + 12*f0*f3^2*f5*f8 + 32*f1^3*f8^2 +
24*f1^2*f3*f6*f8 - 6*f1^2*f3*f7^2)*x[1]^2*x[2]*x[6] + (96*f0^2*f4*f8^2 -
64*f0^2*f5*f7*f8 + 96*f0^2*f6^2*f8 - 24*f0^2*f6*f7^2 - 64*f0*f1*f3*f8^2 +
24*f0*f1*f4*f7*f8 - 24*f0*f1*f5*f6*f8 + 2*f0*f1*f5*f7^2 + 96*f0*f2^2*f8^2 -
24*f0*f2*f3*f7*f8 + 192*f0*f2*f4*f6*f8 - 48*f0*f2*f4*f7^2 - 48*f0*f2*f5^2*f8 -
48*f0*f3^2*f6*f8 + 12*f0*f3^2*f7^2 - 24*f1^2*f2*f8^2 + 2*f1^2*f3*f7*f8 -
48*f1^2*f4*f6*f8 + 12*f1^2*f4*f7^2 + 12*f1^2*f5^2*f8)*x[1]^2*x[2]*x[7] +
(-48*f0^2*f6*f8 + 16*f0^2*f7^2 + 12*f0*f1*f5*f8 - 32*f0*f2*f4*f8 + 8*f0*f2*f5*f7
+ 12*f0*f3^2*f8 + 8*f1^2*f4*f8 - 2*f1^2*f5*f7)*x[1]^2*x[2]*x[8] +
(16*f0^2*f3*f7*f8 - 64*f0^2*f4*f6*f8 + 16*f0^2*f4*f7^2 + 36*f0^2*f5^2*f8 -
8*f0^2*f5*f6*f7 + 4*f0*f1^2*f8^2 + 32*f0*f1*f3*f6*f8 - 12*f0*f1*f3*f7^2 -
8*f0*f1*f4*f5*f8 - 48*f0*f2^2*f6*f8 + 16*f0*f2^2*f7^2 + 24*f0*f2*f3*f5*f8 -
8*f0*f2*f3*f6*f7 - 16*f0*f2*f4^2*f8 - 2*f1^3*f7*f8 + 12*f1^2*f2*f6*f8 -
4*f1^2*f2*f7^2 - 6*f1^2*f3*f5*f8 + 2*f1^2*f3*f6*f7 +
4*f1^2*f4^2*f8)*x[1]^2*x[3]^2 + (-48*f0^2*f3*f8^2 + 64*f0^2*f4*f7*f8 -
32*f0^2*f5*f7^2 + 16*f0^2*f6^2*f7 + 48*f0*f1*f2*f8^2 - 36*f0*f1*f3*f7*f8 +
8*f0*f1*f4*f7^2 - 16*f0*f1*f5^2*f8 + 4*f0*f1*f5*f6*f7 + 48*f0*f2*f3*f6*f8 -
16*f0*f2*f3*f7^2 - 24*f0*f3^2*f5*f8 + 8*f0*f3^2*f6*f7 + 16*f0*f3*f4^2*f8 -
16*f1^3*f8^2 + 8*f1^2*f2*f7*f8 - 16*f1^2*f3*f6*f8 + 6*f1^2*f3*f7^2 +
8*f1^2*f4*f5*f8)*x[1]^2*x[3]*x[4] + (-48*f0^2*f3*f8^2 - 16*f0^2*f4*f7*f8 -
48*f0^2*f5*f6*f8 + 24*f0^2*f5*f7^2 - 16*f0*f1*f2*f8^2 + 28*f0*f1*f3*f7*f8 +
8*f0*f1*f5^2*f8 - 32*f0*f2^2*f7*f8 + 8*f0*f2*f3*f7^2 + 16*f0*f2*f4*f5*f8 +
8*f1^3*f8^2 + 8*f1^2*f2*f7*f8 - 2*f1^2*f3*f7^2 -
4*f1^2*f4*f5*f8)*x[1]^2*x[3]*x[5] + (-96*f0^2*f4*f8^2 + 48*f0^2*f5*f7*f8 -
8*f0^2*f6*f7^2 + 48*f0*f1*f3*f8^2 + 16*f0*f1*f5*f6*f8 - 10*f0*f1*f5*f7^2 +
16*f0*f2*f3*f7*f8 - 4*f0*f3^2*f7^2 - 8*f0*f3*f4*f5*f8 - 8*f1^2*f2*f8^2 -
10*f1^2*f3*f7*f8 - 4*f1^2*f5^2*f8)*x[1]^2*x[3]*x[6] + (48*f0^2*f5*f8^2 -
112*f0^2*f6*f7*f8 + 32*f0^2*f7^3 - 16*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 -
48*f0*f2*f3*f8^2 - 48*f0*f2*f4*f7*f8 - 48*f0*f2*f5*f6*f8 + 24*f0*f2*f5*f7^2 +
24*f0*f3^2*f7*f8 + 12*f0*f3*f5^2*f8 + 24*f1^2*f3*f8^2 + 8*f1^2*f4*f7*f8 +
16*f1^2*f5*f6*f8 - 6*f1^2*f5*f7^2)*x[1]^2*x[3]*x[7] + (16*f0^2*f7*f8 +
8*f0*f1*f6*f8 - 4*f0*f1*f7^2 + 24*f0*f2*f5*f8 - 8*f0*f2*f6*f7 - 8*f0*f3*f4*f8 -
2*f0*f3*f5*f7 - 10*f1^2*f5*f8 + 2*f1^2*f6*f7)*x[1]^2*x[3]*x[8] +
(8*f0^2*f5*f7*f8 - 48*f0^2*f6^2*f8 + 16*f0^2*f6*f7^2 + 8*f0*f1*f3*f8^2 -
32*f0*f1*f4*f7*f8 + 24*f0*f1*f5*f6*f8 + 8*f0*f1*f5*f7^2 - 8*f0*f1*f6^2*f7 -
48*f0*f2^2*f8^2 + 24*f0*f2*f3*f7*f8 - 112*f0*f2*f4*f6*f8 + 32*f0*f2*f4*f7^2 +
12*f0*f2*f5^2*f8 + 12*f0*f3^2*f6*f8 - 4*f0*f3^2*f7^2 + 32*f0*f3*f4*f5*f8 -
8*f0*f3*f4*f6*f7 + 2*f0*f3*f5^2*f7 - 16*f0*f4^3*f8 + 16*f1^2*f2*f8^2 +
8*f1^2*f3*f7*f8 + 32*f1^2*f4*f6*f8 - 12*f1^2*f4*f7^2 - 4*f1^2*f5^2*f8 -
8*f1*f2^2*f7*f8 - 8*f1*f2*f4*f5*f8 + 2*f1*f3^2*f5*f8)*x[1]^2*x[4]^2 +
(40*f0^2*f5*f7*f8 - 8*f0^2*f6*f7^2 + 40*f0*f1*f3*f8^2 - 24*f0*f1*f4*f7*f8 +
16*f0*f1*f5*f6*f8 - 6*f0*f1*f5*f7^2 + 16*f0*f2*f3*f7*f8 - 4*f0*f3^2*f7^2 -
8*f0*f3*f4*f5*f8 - 8*f1^2*f2*f8^2 - 6*f1^2*f3*f7*f8 -
4*f1^2*f5^2*f8)*x[1]^2*x[4]*x[5] + (-48*f0^2*f5*f8^2 + 48*f0^2*f6*f7*f8 -
16*f0^2*f7^3 + 64*f0*f1*f4*f8^2 - 36*f0*f1*f5*f7*f8 + 8*f0*f1*f6*f7^2 +
48*f0*f2*f5*f6*f8 - 16*f0*f2*f5*f7^2 - 16*f0*f3^2*f7*f8 + 8*f0*f3*f4*f7^2 -
24*f0*f3*f5^2*f8 + 16*f0*f4^2*f5*f8 - 32*f1^2*f3*f8^2 + 8*f1^2*f4*f7*f8 -
16*f1^2*f5*f6*f8 + 6*f1^2*f5*f7^2 + 16*f1*f2^2*f8^2 + 4*f1*f2*f3*f7*f8 +
8*f1*f2*f5^2*f8)*x[1]^2*x[4]*x[6] + (16*f0^2*f7^2*f8 + 8*f0*f1*f5*f8^2 +
16*f0*f1*f6*f7*f8 - 8*f0*f1*f7^3 + 96*f0*f2*f4*f8^2 - 16*f0*f2*f5*f7*f8 -
8*f0*f3*f4*f7*f8 + 24*f0*f3*f5*f6*f8 - 8*f0*f3*f5*f7^2 - 8*f0*f4*f5^2*f8 -
32*f1^2*f4*f8^2 - 8*f1*f2*f3*f8^2 + 8*f1*f2*f4*f7*f8 - 8*f1*f2*f5*f6*f8 -
4*f1*f3^2*f7*f8 - 2*f1*f3*f5^2*f8)*x[1]^2*x[4]*x[7] + (-4*f0*f1*f7*f8 +
48*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 36*f0*f3*f5*f8 + 8*f0*f3*f6*f7 + 16*f0*f4^2*f8
- 16*f1^2*f6*f8 + 6*f1^2*f7^2 + 8*f1*f2*f5*f8)*x[1]^2*x[4]*x[8] +
(80*f0^2*f4*f8^2 - 40*f0^2*f5*f7*f8 + 48*f0^2*f6^2*f8 - 12*f0^2*f6*f7^2 -
40*f0*f1*f3*f8^2 - 8*f0*f1*f5*f6*f8 + 2*f0*f1*f5*f7^2 + 48*f0*f2^2*f8^2 -
8*f0*f2*f3*f7*f8 - 16*f0*f2*f4*f6*f8 + 4*f0*f2*f4*f7^2 - 12*f1^2*f2*f8^2 +
2*f1^2*f3*f7*f8 + 4*f1^2*f4*f6*f8 - f1^2*f4*f7^2)*x[1]^2*x[5]^2 +
(-48*f0^2*f5*f8^2 - 16*f0^2*f6*f7*f8 + 8*f0^2*f7^3 - 16*f0*f1*f4*f8^2 +
28*f0*f1*f5*f7*f8 - 32*f0*f1*f6^2*f8 + 8*f0*f1*f6*f7^2 - 48*f0*f2*f3*f8^2 +
8*f0*f3^2*f7*f8 + 16*f0*f3*f4*f6*f8 - 4*f0*f3*f4*f7^2 + 24*f1^2*f3*f8^2 +
8*f1^2*f5*f6*f8 - 2*f1^2*f5*f7^2)*x[1]^2*x[5]*x[6] + (192*f0^2*f6*f8^2 -
56*f0^2*f7^2*f8 - 48*f0*f1*f5*f8^2 + 16*f0*f1*f6*f7*f8 - 4*f0*f1*f7^3 +
192*f0*f2*f4*f8^2 - 72*f0*f2*f5*f7*f8 + 96*f0*f2*f6^2*f8 - 24*f0*f2*f6*f7^2 -
48*f0*f3^2*f8^2 - 24*f0*f3*f5*f6*f8 + 6*f0*f3*f5*f7^2 - 48*f1^2*f4*f8^2 +
20*f1^2*f5*f7*f8 - 32*f1^2*f6^2*f8 + 8*f1^2*f6*f7^2)*x[1]^2*x[5]*x[7] +
(-48*f0^2*f8^2 + 4*f0*f1*f7*f8 - 48*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 12*f0*f3*f5*f8
+ 16*f1^2*f6*f8 - 5*f1^2*f7^2)*x[1]^2*x[5]*x[8] + (4*f0^2*f7^2*f8 +
16*f0*f1*f5*f8^2 - 2*f0*f1*f7^3 - 64*f0*f2*f4*f8^2 + 32*f0*f2*f5*f7*f8 -
48*f0*f2*f6^2*f8 + 12*f0*f2*f6*f7^2 + 36*f0*f3^2*f8^2 - 8*f0*f3*f4*f7*f8 +
24*f0*f3*f5*f6*f8 - 6*f0*f3*f5*f7^2 - 16*f0*f4^2*f6*f8 + 4*f0*f4^2*f7^2 +
16*f1^2*f4*f8^2 - 12*f1^2*f5*f7*f8 + 16*f1^2*f6^2*f8 - 4*f1^2*f6*f7^2 -
8*f1*f2*f3*f8^2 - 8*f1*f2*f5*f6*f8 + 2*f1*f2*f5*f7^2)*x[1]^2*x[6]^2 +
(-32*f0^2*f7*f8^2 - 64*f0*f1*f6*f8^2 + 24*f0*f1*f7^2*f8 - 48*f0*f2*f5*f8^2 +
32*f0*f2*f6*f7*f8 - 8*f0*f2*f7^3 - 32*f0*f3*f4*f8^2 + 28*f0*f3*f5*f7*f8 -
48*f0*f3*f6^2*f8 + 12*f0*f3*f6*f7^2 + 16*f0*f4*f5*f6*f8 - 4*f0*f4*f5*f7^2 +
24*f1^2*f5*f8^2 - 8*f1^2*f6*f7*f8 + 2*f1^2*f7^3 - 4*f1*f2*f5*f7*f8 +
16*f1*f2*f6^2*f8 - 4*f1*f2*f6*f7^2 + 8*f1*f3^2*f8^2 + 4*f1*f3*f5*f6*f8 -
f1*f3*f5*f7^2)*x[1]^2*x[6]*x[7] + (16*f0*f1*f8^2 + 8*f0*f2*f7*f8 +
24*f0*f3*f6*f8 - 10*f0*f3*f7^2 - 8*f0*f4*f5*f8 - 4*f1^2*f7*f8 - 8*f1*f2*f6*f8 +
2*f1*f2*f7^2 - 2*f1*f3*f5*f8)*x[1]^2*x[6]*x[8] + (48*f0^2*f8^3 - 8*f0*f1*f7*f8^2
+ 48*f0*f2*f6*f8^2 - 12*f0*f2*f7^2*f8 - 24*f0*f3*f5*f8^2 + 32*f0*f4^2*f8^2 -
16*f0*f4*f5*f7*f8 + 32*f0*f4*f6^2*f8 - 8*f0*f4*f6*f7^2 - 12*f0*f5^2*f6*f8 +
3*f0*f5^2*f7^2 - 16*f1^2*f6*f8^2 + 4*f1^2*f7^2*f8 + 8*f1*f2*f5*f8^2 -
8*f1*f2*f6*f7*f8 + 2*f1*f2*f7^3 - 8*f1*f3*f4*f8^2 + 4*f1*f3*f5*f7*f8 -
8*f1*f3*f6^2*f8 + 2*f1*f3*f6*f7^2)*x[1]^2*x[7]^2 + (-48*f0*f2*f8^2 +
12*f0*f3*f7*f8 - 32*f0*f4*f6*f8 + 8*f0*f4*f7^2 + 12*f0*f5^2*f8 + 16*f1^2*f8^2 +
8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*x[1]^2*x[7]*x[8] + (16*f0^2*f2*f8 - 8*f0^2*f3*f7 -
4*f0*f1^2*f8 + 8*f0*f1*f2*f7 - 2*f1^3*f7)*x[1]*x[2]^3 + (24*f0^2*f3*f8 -
32*f0*f1*f2*f8 + 4*f0*f1*f3*f7 - 16*f0*f2^2*f7 + 8*f1^3*f8 +
4*f1^2*f2*f7)*x[1]*x[2]^2*x[3] + (-48*f0^2*f4*f8 + 24*f0^2*f5*f7 +
20*f0*f1*f3*f8 - 8*f0*f1*f4*f7 + 8*f0*f2*f3*f7)*x[1]*x[2]^2*x[4] +
(-32*f0^2*f4*f8 + 8*f0^2*f5*f7 + 8*f0*f1*f3*f8 + 4*f0*f2*f3*f7 -
f1^2*f3*f7)*x[1]*x[2]^2*x[5] + (-8*f0^2*f6*f7 + 16*f0*f1*f4*f8 - 4*f0*f1*f5*f7 -
2*f0*f3^2*f7 - 4*f1^2*f3*f8)*x[1]*x[2]^2*x[6] + (4*f0*f1*f6*f7 - 32*f0*f2*f4*f8
+ 8*f0*f2*f5*f7 + 12*f0*f3^2*f8 + 8*f1^2*f4*f8 - 2*f1^2*f5*f7)*x[1]*x[2]^2*x[7]
- 2*f0*f1*f7*x[1]*x[2]^2*x[8] + (16*f0^2*f4*f8 - 20*f0*f1*f3*f8 + 48*f0*f2^2*f8
+ 8*f0*f2*f3*f7 - 12*f1^2*f2*f8 - 2*f1^2*f3*f7)*x[1]*x[2]*x[3]^2 +
(-16*f0^2*f6*f7 + 16*f0*f1*f4*f8 - 4*f0*f1*f5*f7 - 48*f0*f2*f3*f8 - 8*f0*f3^2*f7
+ 8*f1^2*f3*f8)*x[1]*x[2]*x[3]*x[4] + (24*f0^2*f5*f8 - 8*f0^2*f6*f7 -
4*f0*f1*f5*f7 - 24*f0*f2*f3*f8 - 8*f0*f2*f4*f7 + 6*f1^2*f3*f8 +
2*f1^2*f4*f7)*x[1]*x[2]*x[3]*x[5] + (48*f0^2*f6*f8 - 8*f0^2*f7^2 -
20*f0*f1*f5*f8 + 8*f0*f1*f6*f7 + 12*f0*f3^2*f8 + 4*f0*f3*f4*f7 +
2*f1^2*f5*f7)*x[1]*x[2]*x[3]*x[6] + (24*f0^2*f7*f8 - 16*f0*f1*f6*f8 +
48*f0*f2*f5*f8 - 16*f0*f2*f6*f7 - 16*f0*f3*f4*f8 - 4*f0*f3*f5*f7 - 10*f1^2*f5*f8
+ 2*f1^2*f6*f7)*x[1]*x[2]*x[3]*x[7] + (16*f0*f2*f7 -
3*f1^2*f7)*x[1]*x[2]*x[3]*x[8] + (48*f0^2*f6*f8 - 16*f0^2*f7^2 - 20*f0*f1*f5*f8
+ 8*f0*f1*f6*f7 + 64*f0*f2*f4*f8 - 16*f0*f2*f5*f7 - 12*f0*f3^2*f8 +
8*f0*f3*f4*f7 - 16*f1^2*f4*f8 + 6*f1^2*f5*f7 + 4*f1*f2*f3*f8)*x[1]*x[2]*x[4]^2 +
(-48*f0^2*f6*f8 + 24*f0^2*f7^2 + 4*f0*f1*f5*f8 + 12*f0*f3^2*f8 + 4*f0*f3*f4*f7 +
2*f1^2*f5*f7)*x[1]*x[2]*x[4]*x[5] + (-8*f0^2*f7*f8 - 8*f0*f1*f6*f8 -
4*f0*f1*f7^2 - 24*f0*f2*f5*f8 + 8*f0*f2*f6*f7 - 8*f0*f3*f4*f8 + 8*f0*f3*f5*f7 -
8*f0*f4^2*f7 + 8*f1^2*f5*f8 - 4*f1^2*f6*f7 - 4*f1*f2*f5*f7 -
2*f1*f3^2*f8)*x[1]*x[2]*x[4]*x[6] + (-48*f0^2*f8^2 + 4*f0*f1*f7*f8 -
48*f0*f2*f6*f8 + 24*f0*f2*f7^2 + 12*f0*f3*f5*f8 - 4*f0*f3*f6*f7 + 4*f0*f4*f5*f7
+ 24*f1^2*f6*f8 - 8*f1^2*f7^2 - 4*f1*f2*f5*f8 + 4*f1*f2*f6*f7 + 4*f1*f3*f4*f8 +
f1*f3*f5*f7)*x[1]*x[2]*x[4]*x[7] + (-24*f0*f2*f8 - 6*f0*f3*f7 + 4*f1^2*f8 -
2*f1*f2*f7)*x[1]*x[2]*x[4]*x[8] + (-48*f0^2*f6*f8 + 16*f0^2*f7^2 + 8*f0*f1*f5*f8
+ 16*f0*f2*f4*f8 - 4*f1^2*f4*f8)*x[1]*x[2]*x[5]^2 + (32*f0*f1*f6*f8 -
12*f0*f1*f7^2 - 16*f0*f3*f4*f8 - 8*f1^2*f5*f8)*x[1]*x[2]*x[5]*x[6] +
(-48*f0^2*f8^2 - 96*f0*f2*f6*f8 + 32*f0*f2*f7^2 + 24*f0*f3*f5*f8 + 32*f1^2*f6*f8
- 9*f1^2*f7^2)*x[1]*x[2]*x[5]*x[7] + (-4*f0*f3*f7 -
2*f1^2*f8)*x[1]*x[2]*x[5]*x[8] + (4*f0*f1*f7*f8 + 48*f0*f2*f6*f8 - 16*f0*f2*f7^2
- 24*f0*f3*f5*f8 + 16*f0*f4^2*f8 - 16*f1^2*f6*f8 + 6*f1^2*f7^2 +
8*f1*f2*f5*f8)*x[1]*x[2]*x[6]^2 + (24*f0*f1*f8^2 - 16*f0*f2*f7*f8 +
48*f0*f3*f6*f8 - 10*f0*f3*f7^2 - 16*f0*f4*f5*f8 - 16*f1*f2*f6*f8 + 2*f1*f2*f7^2
- 4*f1*f3*f5*f8)*x[1]*x[2]*x[6]*x[7] + (4*f0*f4*f7 + 4*f1*f2*f8 +
f1*f3*f7)*x[1]*x[2]*x[6]*x[8] + (-32*f0*f4*f6*f8 + 8*f0*f4*f7^2 + 12*f0*f5^2*f8
+ 4*f1*f2*f7*f8 + 8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*x[1]*x[2]*x[7]^2 + (8*f0*f4*f8 -
6*f0*f5*f7 - 6*f1*f3*f8)*x[1]*x[2]*x[7]*x[8] + (-24*f0^2*f5*f8 + 8*f0*f1*f4*f8 -
16*f0*f2*f3*f8 + 4*f1^2*f3*f8)*x[1]*x[3]^3 + (16*f0^2*f7^2 + 20*f0*f1*f5*f8 +
24*f0*f3^2*f8 - 8*f1^2*f4*f8)*x[1]*x[3]^2*x[4] + (48*f0^2*f6*f8 - 8*f0^2*f7^2 -
8*f0*f1*f5*f8 + 4*f0*f1*f6*f7 + 16*f0*f2*f4*f8 + 4*f0*f2*f5*f7 - 4*f1^2*f4*f8 -
f1^2*f5*f7)*x[1]*x[3]^2*x[5] + (-24*f0^2*f7*f8 - 24*f0*f1*f6*f8 + 4*f0*f1*f7^2 -
8*f0*f3*f4*f8 - 2*f0*f3*f5*f7 + 6*f1^2*f5*f8 - 2*f1^2*f6*f7)*x[1]*x[3]^2*x[6] +
(4*f0*f1*f7*f8 + 48*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 24*f0*f3*f5*f8 + 8*f0*f3*f6*f7
+ 16*f0*f4^2*f8 - 16*f1^2*f6*f8 + 6*f1^2*f7^2)*x[1]*x[3]^2*x[7] + (-24*f0*f2*f8
- 4*f0*f3*f7 + 8*f1^2*f8)*x[1]*x[3]^2*x[8] + (-32*f0^2*f7*f8 - 8*f0*f1*f7^2 -
32*f0*f3*f4*f8 + 4*f0*f3*f5*f7 - 4*f1^2*f5*f8 + 8*f1*f2*f4*f8 -
4*f1*f3^2*f8)*x[1]*x[3]*x[4]^2 + (-40*f0^2*f7*f8 - 16*f0*f1*f6*f8 -
16*f0*f3*f4*f8 - 4*f0*f3*f5*f7 + 2*f1^2*f5*f8 -
2*f1^2*f6*f7)*x[1]*x[3]*x[4]*x[5] + (48*f0^2*f8^2 + 36*f0*f1*f7*f8 -
48*f0*f2*f6*f8 + 24*f0*f2*f7^2 + 36*f0*f3*f5*f8 - 12*f0*f3*f6*f7 + 4*f0*f4*f5*f7
+ 24*f1^2*f6*f8 - 8*f1^2*f7^2 - 12*f1*f2*f5*f8 + 4*f1*f2*f6*f7 + 4*f1*f3*f4*f8 +
f1*f3*f5*f7)*x[1]*x[3]*x[4]*x[6] + (-8*f0*f1*f8^2 - 8*f0*f2*f7*f8 -
24*f0*f3*f6*f8 + 8*f0*f3*f7^2 - 8*f0*f4*f5*f8 - 2*f0*f5^2*f7 - 4*f1^2*f7*f8 +
8*f1*f2*f6*f8 - 4*f1*f2*f7^2 + 8*f1*f3*f5*f8 - 4*f1*f3*f6*f7 -
8*f1*f4^2*f8)*x[1]*x[3]*x[4]*x[7] + (36*f0*f3*f8 - 4*f1*f2*f8 +
2*f1*f3*f7)*x[1]*x[3]*x[4]*x[8] + (-8*f0^2*f7*f8 - 4*f0*f1*f7^2 - 24*f0*f2*f5*f8
+ 6*f1^2*f5*f8)*x[1]*x[3]*x[5]^2 + (48*f0^2*f8^2 + 8*f0*f1*f7*f8 +
24*f0*f3*f5*f8 + 3*f1^2*f7^2)*x[1]*x[3]*x[5]*x[6] + (32*f0*f2*f7*f8 -
8*f0*f3*f7^2 - 16*f0*f4*f5*f8 - 12*f1^2*f7*f8)*x[1]*x[3]*x[5]*x[7] +
(12*f0*f3*f8 + 4*f0*f4*f7)*x[1]*x[3]*x[5]*x[8] + (-24*f0*f1*f8^2 -
24*f0*f2*f7*f8 + 6*f0*f3*f7^2 - 8*f0*f4*f5*f8 + 4*f1^2*f7*f8 - 2*f1*f2*f7^2 -
2*f1*f3*f5*f8)*x[1]*x[3]*x[6]^2 + (48*f0*f2*f8^2 - 20*f0*f3*f7*f8 +
12*f0*f5^2*f8 - 8*f1^2*f8^2 + 8*f1*f2*f7*f8 + 2*f1*f3*f7^2 +
4*f1*f4*f5*f8)*x[1]*x[3]*x[6]*x[7] + (-16*f0*f4*f8 -
2*f1*f4*f7)*x[1]*x[3]*x[6]*x[8] + (16*f0*f4*f7*f8 - 4*f0*f5*f7^2 - 8*f1*f2*f8^2
- 4*f1*f3*f7*f8 - 2*f1*f5^2*f8)*x[1]*x[3]*x[7]^2 + (4*f0*f6*f7 + 4*f1*f4*f8 +
f1*f5*f7)*x[1]*x[3]*x[7]*x[8] - 2*f0*f7*x[1]*x[3]*x[8]^2 + (-16*f0^2*f8^2 +
16*f0*f1*f7*f8 + 4*f0*f3*f5*f8 + 16*f0*f4^2*f8 - 2*f1*f3*f5*f7)*x[1]*x[4]^3 +
(48*f0^2*f8^2 + 12*f0*f1*f7*f8 + 48*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 24*f0*f3*f5*f8
+ 4*f0*f3*f6*f7 + 16*f0*f4^2*f8 - 16*f1^2*f6*f8 + 6*f1^2*f7^2 +
4*f1*f2*f5*f8)*x[1]*x[4]^2*x[5] + (-32*f0*f1*f8^2 - 4*f0*f3*f7^2 -
32*f0*f4*f5*f8 + 8*f0*f4*f6*f7 - 4*f0*f5^2*f7 - 8*f1^2*f7*f8 +
4*f1*f3*f5*f8)*x[1]*x[4]^2*x[6] + (48*f0*f2*f8^2 - 20*f0*f3*f7*f8 +
64*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 12*f0*f5^2*f8 + 4*f0*f5*f6*f7 - 16*f1^2*f8^2 +
8*f1*f2*f7*f8 - 16*f1*f3*f6*f8 + 6*f1*f3*f7^2 + 8*f1*f4*f5*f8)*x[1]*x[4]^2*x[7]
- 32*f0*f4*f8*x[1]*x[4]^2*x[8] + (8*f0*f1*f7*f8 + 12*f0*f3*f5*f8 +
f1^2*f7^2)*x[1]*x[4]*x[5]^2 + (-40*f0*f1*f8^2 - 16*f0*f2*f7*f8 + 2*f0*f3*f7^2 -
16*f0*f4*f5*f8 - 2*f1*f2*f7^2 - 4*f1*f3*f5*f8)*x[1]*x[4]*x[5]*x[6] +
(-48*f0*f2*f8^2 + 4*f0*f3*f7*f8 + 12*f0*f5^2*f8 + 24*f1^2*f8^2 + 2*f1*f3*f7^2 +
4*f1*f4*f5*f8)*x[1]*x[4]*x[5]*x[7] + (-4*f0*f5*f7 -
4*f1*f3*f8)*x[1]*x[4]*x[5]*x[8] + (20*f0*f3*f7*f8 - 8*f0*f4*f7^2 + 24*f0*f5^2*f8
+ 16*f1^2*f8^2)*x[1]*x[4]*x[6]^2 + (16*f0*f4*f7*f8 - 48*f0*f5*f6*f8 +
8*f0*f5*f7^2 - 16*f1*f2*f8^2 - 4*f1*f3*f7*f8 - 8*f1*f5^2*f8)*x[1]*x[4]*x[6]*x[7]
+ (36*f0*f5*f8 - 4*f0*f6*f7 + 2*f1*f5*f7)*x[1]*x[4]*x[6]*x[8] + (-48*f0*f4*f8^2
+ 20*f0*f5*f7*f8 + 24*f1*f3*f8^2 - 8*f1*f4*f7*f8 +
8*f1*f5*f6*f8)*x[1]*x[4]*x[7]^2 + (-24*f0*f6*f8 + 4*f0*f7^2 - 6*f1*f5*f8 -
2*f1*f6*f7)*x[1]*x[4]*x[7]*x[8] + (12*f0*f8 + f1*f7)*x[1]*x[4]*x[8]^2 +
(4*f0*f1*f7*f8 + 16*f0*f2*f6*f8 - 4*f0*f2*f7^2 - 4*f1^2*f6*f8 +
f1^2*f7^2)*x[1]*x[5]^3 + (-8*f0*f1*f8^2 - 24*f0*f3*f6*f8 + 6*f0*f3*f7^2 -
4*f1^2*f7*f8)*x[1]*x[5]^2*x[6] + (-48*f0*f2*f8^2 + 8*f0*f3*f7*f8 +
16*f0*f4*f6*f8 - 4*f0*f4*f7^2 + 16*f1^2*f8^2)*x[1]*x[5]^2*x[7] -
8*f0*f4*f8*x[1]*x[5]^2*x[8] + (48*f0*f2*f8^2 - 8*f0*f3*f7*f8 + 16*f0*f4*f6*f8 -
4*f0*f4*f7^2 - 8*f1^2*f8^2 + 4*f1*f2*f7*f8 + 4*f1*f3*f6*f8 -
f1*f3*f7^2)*x[1]*x[5]*x[6]^2 + (24*f0*f3*f8^2 - 24*f0*f5*f6*f8 + 6*f0*f5*f7^2 -
8*f1*f2*f8^2 - 4*f1*f3*f7*f8 - 8*f1*f4*f6*f8 + 2*f1*f4*f7^2)*x[1]*x[5]*x[6]*x[7]
+ (12*f0*f5*f8 + 4*f1*f4*f8)*x[1]*x[5]*x[6]*x[8] + (-32*f0*f4*f8^2 +
8*f0*f5*f7*f8 + 8*f1*f3*f8^2 + 4*f1*f5*f6*f8 - f1*f5*f7^2)*x[1]*x[5]*x[7]^2 +
(-2*f0*f7^2 - 4*f1*f5*f8)*x[1]*x[5]*x[7]*x[8] + (-24*f0*f3*f8^2 + 8*f0*f4*f7*f8
- 16*f0*f5*f6*f8 + 4*f0*f5*f7^2)*x[1]*x[6]^3 + (16*f0*f4*f8^2 - 20*f0*f5*f7*f8 +
48*f0*f6^2*f8 - 12*f0*f6*f7^2 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2)*x[1]*x[6]^2*x[7] +
(-24*f0*f6*f8 + 8*f0*f7^2 - 4*f1*f5*f8)*x[1]*x[6]^2*x[8] + (24*f0*f5*f8^2 -
32*f0*f6*f7*f8 + 8*f0*f7^3 + 4*f1*f5*f7*f8 - 16*f1*f6^2*f8 +
4*f1*f6*f7^2)*x[1]*x[6]*x[7]^2 + (16*f1*f6*f8 - 3*f1*f7^2)*x[1]*x[6]*x[7]*x[8] -
2*f1*f8*x[1]*x[6]*x[8]^2 + (16*f0*f6*f8^2 - 4*f0*f7^2*f8 - 8*f1*f5*f8^2 +
8*f1*f6*f7*f8 - 2*f1*f7^3)*x[1]*x[7]^3 - 2*f1*f7*f8*x[1]*x[7]^2*x[8] +
(4*f0^2*f4 - 2*f0*f1*f3 + 4*f0*f2^2 - f1^2*f2)*x[2]^4 + (-8*f0^2*f5 - 4*f0*f2*f3
+ f1^2*f3)*x[2]^3*x[3] + (-8*f0^2*f6 + 4*f0*f1*f5 + 2*f0*f3^2)*x[2]^3*x[4] +
8*f0^2*f7*x[2]^3*x[6] + (-8*f0^2*f8 - 2*f0*f1*f7)*x[2]^3*x[7] + (-8*f0*f2 +
2*f1^2)*x[2]^3*x[8] + (12*f0^2*f6 + 2*f0*f1*f5 + 4*f0*f2*f4 -
f1^2*f4)*x[2]^2*x[3]^2 + (8*f0^2*f7 - 4*f0*f1*f6 - 4*f0*f3*f4 -
2*f1^2*f5)*x[2]^2*x[3]*x[4] - 8*f0^2*f7*x[2]^2*x[3]*x[5] + (-24*f0^2*f8 -
2*f0*f1*f7)*x[2]^2*x[3]*x[6] + (12*f0*f1*f8 + 8*f0*f2*f7 -
f1^2*f7)*x[2]^2*x[3]*x[7] + 6*f0*f3*x[2]^2*x[3]*x[8] + (12*f0^2*f8 - 2*f0*f1*f7
+ 12*f0*f2*f6 - 6*f0*f3*f5 + 4*f0*f4^2 - 4*f1^2*f6 + 2*f1*f2*f5)*x[2]^2*x[4]^2 +
2*f0*f1*f7*x[2]^2*x[4]*x[5] + (4*f0*f1*f8 - 16*f0*f2*f7 +
6*f1^2*f7)*x[2]^2*x[4]*x[6] + (2*f0*f3*f7 - 4*f1^2*f8 -
2*f1*f2*f7)*x[2]^2*x[4]*x[7] + (-4*f0*f4 - f1*f3)*x[2]^2*x[4]*x[8] +
12*f0^2*f8*x[2]^2*x[5]^2 - 4*f0*f1*f8*x[2]^2*x[5]*x[6] + (-2*f0*f3*f7 -
2*f1^2*f8)*x[2]^2*x[5]*x[7] + (12*f0*f2*f8 + 2*f0*f3*f7 -
4*f1^2*f8)*x[2]^2*x[6]^2 + (-12*f0*f3*f8 + 4*f1*f2*f8)*x[2]^2*x[6]*x[7] +
4*f0*f4*f8*x[2]^2*x[7]^2 + 3*f0*x[2]^2*x[8]^2 + (-8*f0^2*f7 - 4*f0*f1*f6 -
4*f0*f2*f5 + f1^2*f5)*x[2]*x[3]^3 + (4*f0*f1*f7 + 6*f0*f3*f5 +
4*f1^2*f6)*x[2]*x[3]^2*x[4] + 4*f0*f1*f7*x[2]*x[3]^2*x[5] + (12*f0*f1*f8 -
f1^2*f7)*x[2]*x[3]^2*x[6] + (-24*f0*f2*f8 - 4*f0*f3*f7 +
4*f1^2*f8)*x[2]*x[3]^2*x[7] - 4*f0*f4*x[2]*x[3]^2*x[8] + (-8*f0*f1*f8 -
8*f0*f2*f7 - 4*f0*f4*f5 + 2*f1^2*f7 - 4*f1*f2*f6 - f1*f3*f5)*x[2]*x[3]*x[4]^2 -
3*f1^2*f7*x[2]*x[3]*x[4]*x[5] + (24*f0*f2*f8 + 6*f0*f3*f7 - 12*f1^2*f8 +
2*f1*f2*f7)*x[2]*x[3]*x[4]*x[6] + (12*f0*f3*f8 + 4*f1*f2*f8 +
2*f1*f3*f7)*x[2]*x[3]*x[4]*x[7] + (6*f0*f5 + 2*f1*f4)*x[2]*x[3]*x[4]*x[8] +
(-4*f0*f1*f8 + 4*f0*f2*f7 - f1^2*f7)*x[2]*x[3]*x[5]^2 + (-4*f0*f3*f7 +
2*f1^2*f8)*x[2]*x[3]*x[5]*x[6] + (12*f0*f3*f8 + 4*f0*f4*f7)*x[2]*x[3]*x[5]*x[7]
- 12*f0*f3*f8*x[2]*x[3]*x[6]^2 + (16*f0*f4*f8 - 4*f0*f5*f7 -
4*f1*f3*f8)*x[2]*x[3]*x[6]*x[7] + (-12*f0*f5*f8 + 4*f0*f6*f7)*x[2]*x[3]*x[7]^2 -
6*f0*f7*x[2]*x[3]*x[7]*x[8] - f1*x[2]*x[3]*x[8]^2 + (-16*f0*f2*f8 + 4*f0*f3*f7 -
8*f0*f4*f6 + 4*f0*f5^2 + 8*f1^2*f8 + 4*f1*f3*f6)*x[2]*x[4]^3 + (-2*f0*f3*f7 +
2*f1*f2*f7)*x[2]*x[4]^2*x[5] + (8*f0*f4*f7 - 6*f1*f3*f7)*x[2]*x[4]^2*x[6] +
(-8*f0*f4*f8 - 4*f0*f5*f7 - 4*f1*f3*f8)*x[2]*x[4]^2*x[7] -
2*f1*f5*x[2]*x[4]^2*x[8] + (-2*f0*f3*f7 + 2*f1^2*f8)*x[2]*x[4]*x[5]^2 +
(4*f0*f4*f7 - 4*f1*f2*f8 + f1*f3*f7)*x[2]*x[4]*x[5]*x[6] + (-16*f0*f4*f8 -
2*f1*f4*f7)*x[2]*x[4]*x[5]*x[7] + (-8*f0*f4*f8 - 4*f0*f5*f7 +
8*f1*f3*f8)*x[2]*x[4]*x[6]^2 + (12*f0*f5*f8 + 4*f0*f6*f7 +
2*f1*f5*f7)*x[2]*x[4]*x[6]*x[7] + (-4*f0*f7^2 + 2*f1*f5*f8 -
2*f1*f6*f7)*x[2]*x[4]*x[7]^2 + (12*f0*f8 + 3*f1*f7)*x[2]*x[4]*x[7]*x[8] +
(-8*f0*f2*f8 + 2*f1^2*f8)*x[2]*x[5]^3 + 12*f0*f3*f8*x[2]*x[5]^2*x[6] -
8*f0*f4*f8*x[2]*x[5]^2*x[7] + (-8*f0*f4*f8 - 2*f1*f3*f8)*x[2]*x[5]*x[6]^2 +
(12*f0*f5*f8 + 4*f1*f4*f8)*x[2]*x[5]*x[6]*x[7] - 2*f0*f7*x[2]*x[5]*x[6]*x[8] +
(-2*f0*f7^2 - 2*f1*f5*f8)*x[2]*x[5]*x[7]^2 + (12*f0*f8 +
f1*f7)*x[2]*x[5]*x[7]*x[8] + 8*f0*f5*f8*x[2]*x[6]^3 + (-24*f0*f6*f8 + 4*f0*f7^2
- 4*f1*f5*f8)*x[2]*x[6]^2*x[7] + (12*f0*f7*f8 + 8*f1*f6*f8 -
f1*f7^2)*x[2]*x[6]*x[7]^2 - 6*f1*f8*x[2]*x[6]*x[7]*x[8] + (-8*f0*f8^2 -
2*f1*f7*f8)*x[2]*x[7]^3 + (8*f0^2*f8 + 2*f0*f1*f7 + 4*f0*f2*f6 - f1^2*f6)*x[3]^4
+ (-12*f0*f1*f8 - 8*f0*f3*f6 - 2*f1^2*f7)*x[3]^3*x[4] + (-4*f0*f1*f8 -
8*f0*f2*f7 + 2*f1^2*f7)*x[3]^3*x[5] + 4*f0*f3*f7*x[3]^3*x[6] +
8*f0*f3*f8*x[3]^3*x[7] + 2*f0*f5*x[3]^3*x[8] + (12*f0*f2*f8 + 16*f0*f4*f6 -
3*f0*f5^2 + 4*f1^2*f8 + 2*f1*f2*f7 + 2*f1*f3*f6)*x[3]^2*x[4]^2 + (12*f0*f3*f7 +
4*f1^2*f8)*x[3]^2*x[4]*x[5] + (-12*f0*f3*f8 - 16*f0*f4*f7 -
2*f1*f3*f7)*x[3]^2*x[4]*x[6] + (-8*f0*f4*f8 + 8*f0*f5*f7 -
4*f1*f3*f8)*x[3]^2*x[4]*x[7] + (-12*f0*f6 - f1*f5)*x[3]^2*x[4]*x[8] +
(12*f0*f2*f8 - 3*f1^2*f8)*x[3]^2*x[5]^2 - 12*f0*f3*f8*x[3]^2*x[5]*x[6] +
(-8*f0*f4*f8 - 2*f0*f5*f7)*x[3]^2*x[5]*x[7] + (12*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8)*x[3]^2*x[6]^2 - 12*f0*f5*f8*x[3]^2*x[6]*x[7] +
6*f0*f7*x[3]^2*x[6]*x[8] + (12*f0*f6*f8 - 4*f0*f7^2 + 2*f1*f5*f8)*x[3]^2*x[7]^2
+ (4*f0*f3*f8 - 4*f0*f5*f6 - 8*f1*f2*f8 - 2*f1*f3*f7 - 8*f1*f4*f6 +
2*f1*f5^2)*x[3]*x[4]^3 + (-16*f0*f4*f7 - 4*f1*f2*f8 -
2*f1*f3*f7)*x[3]*x[4]^2*x[5] + (8*f0*f5*f7 + 8*f1*f3*f8 +
12*f1*f4*f7)*x[3]*x[4]^2*x[6] + (8*f1*f4*f8 - 6*f1*f5*f7)*x[3]*x[4]^2*x[7] +
(4*f0*f7 + 8*f1*f6)*x[3]*x[4]^2*x[8] - 12*f0*f3*f8*x[3]*x[4]*x[5]^2 +
(40*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8)*x[3]*x[4]*x[5]*x[6] + (-4*f0*f6*f7 +
4*f1*f4*f8 + f1*f5*f7)*x[3]*x[4]*x[5]*x[7] + 14*f0*f7*x[3]*x[4]*x[5]*x[8] +
(-12*f0*f5*f8 - 16*f1*f4*f8 - 2*f1*f5*f7)*x[3]*x[4]*x[6]^2 + (24*f0*f6*f8 -
12*f0*f7^2 + 6*f1*f5*f8 + 2*f1*f6*f7)*x[3]*x[4]*x[6]*x[7] + (-12*f0*f8 -
9*f1*f7)*x[3]*x[4]*x[6]*x[8] + (4*f0*f7*f8 - 16*f1*f6*f8 +
6*f1*f7^2)*x[3]*x[4]*x[7]^2 + 12*f0*f5*f8*x[3]*x[5]^2*x[7] -
2*f0*f7*x[3]*x[5]^2*x[8] - 12*f0*f5*f8*x[3]*x[5]*x[6]^2 + (2*f0*f7^2 -
4*f1*f5*f8)*x[3]*x[5]*x[6]*x[7] + (-12*f0*f8 + f1*f7)*x[3]*x[5]*x[6]*x[8] -
4*f0*f7*f8*x[3]*x[5]*x[7]^2 - 2*f1*f8*x[3]*x[5]*x[7]*x[8] +
4*f1*f5*f8*x[3]*x[6]^3 + (12*f0*f7*f8 - f1*f7^2)*x[3]*x[6]^2*x[7] +
6*f1*f8*x[3]*x[6]^2*x[8] + (-24*f0*f8^2 - 2*f1*f7*f8)*x[3]*x[6]*x[7]^2 +
8*f1*f8^2*x[3]*x[7]^3 + (4*f0*f4*f8 - 4*f0*f5*f7 + 4*f0*f6^2 - 4*f1*f3*f8 +
2*f1*f4*f7 + 4*f2^2*f8 + 4*f2*f4*f6 - f2*f5^2 - f3^2*f6)*x[4]^4 + (-8*f0*f4*f8 +
4*f0*f5*f7 + 4*f1*f3*f8 + 4*f1*f4*f7)*x[4]^3*x[5] + (4*f0*f5*f8 - 8*f0*f6*f7 -
2*f1*f5*f7 - 4*f2*f3*f8 - 8*f2*f4*f7 + 2*f3^2*f7)*x[4]^3*x[6] + (-16*f0*f6*f8 +
8*f0*f7^2 + 4*f1*f5*f8 - 8*f2*f4*f8 + 4*f2*f5*f7 + 4*f3^2*f8)*x[4]^3*x[7] +
(-2*f1*f7 - 4*f2*f6 + f3*f5)*x[4]^3*x[8] + (8*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8)*x[4]^2*x[5]^2 + (-4*f0*f6*f7 - 16*f1*f4*f8 -
2*f1*f5*f7)*x[4]^2*x[5]*x[6] + (-2*f1*f5*f8 + 2*f1*f6*f7)*x[4]^2*x[5]*x[7] -
5*f1*f7*x[4]^2*x[5]*x[8] + (12*f0*f6*f8 + 4*f0*f7^2 + 2*f1*f6*f7 + 16*f2*f4*f8 +
2*f2*f5*f7 - 3*f3^2*f8)*x[4]^2*x[6]^2 + (-8*f0*f7*f8 - 8*f1*f6*f8 + 2*f1*f7^2 -
4*f2*f6*f7 - 4*f3*f4*f8 - f3*f5*f7)*x[4]^2*x[6]*x[7] + (4*f1*f8 +
8*f2*f7)*x[4]^2*x[6]*x[8] + (12*f0*f8^2 - 2*f1*f7*f8 + 12*f2*f6*f8 - 4*f2*f7^2 -
6*f3*f5*f8 + 2*f3*f6*f7 + 4*f4^2*f8)*x[4]^2*x[7]^2 - 2*f3*f7*x[4]^2*x[7]*x[8] -
f4*x[4]^2*x[8]^2 - 12*f0*f5*f8*x[4]*x[5]^2*x[6] + (2*f0*f7^2 -
2*f1*f5*f8)*x[4]*x[5]^2*x[7] - 12*f0*f8*x[4]*x[5]^2*x[8] + (4*f0*f7^2 +
12*f1*f5*f8)*x[4]*x[5]*x[6]^2 - 3*f1*f7^2*x[4]*x[5]*x[6]*x[7] +
14*f1*f8*x[4]*x[5]*x[6]*x[8] + 2*f1*f7*f8*x[4]*x[5]*x[7]^2 + (-12*f0*f7*f8 -
2*f1*f7^2 - 8*f2*f5*f8)*x[4]*x[6]^3 + (4*f1*f7*f8 + 4*f2*f7^2 +
6*f3*f5*f8)*x[4]*x[6]^2*x[7] + (-12*f2*f8 - f3*f7)*x[4]*x[6]^2*x[8] + (8*f1*f8^2
- 4*f2*f7*f8 - 2*f3*f7^2 - 4*f4*f5*f8)*x[4]*x[6]*x[7]^2 + (6*f3*f8 +
2*f4*f7)*x[4]*x[6]*x[7]*x[8] + (-8*f2*f8^2 + 4*f3*f7*f8 + 2*f5^2*f8)*x[4]*x[7]^3
+ (-4*f4*f8 - f5*f7)*x[4]*x[7]^2*x[8] + x[4]*x[8]^3 + (-8*f0*f6*f8 +
2*f0*f7^2)*x[5]^3*x[7] + 4*f0*f8*x[5]^3*x[8] + (12*f0*f6*f8 -
3*f0*f7^2)*x[5]^2*x[6]^2 + (-4*f0*f7*f8 + 4*f1*f6*f8 - f1*f7^2)*x[5]^2*x[6]*x[7]
- 2*f1*f8*x[5]^2*x[6]*x[8] + 12*f0*f8^2*x[5]^2*x[7]^2 + (-4*f0*f7*f8 -
8*f1*f6*f8 + 2*f1*f7^2)*x[5]*x[6]^3 + 4*f1*f7*f8*x[5]*x[6]^2*x[7] -
8*f1*f8^2*x[5]*x[6]*x[7]^2 + (8*f0*f8^2 + 2*f1*f7*f8 + 4*f2*f6*f8 -
f2*f7^2)*x[6]^4 + (-8*f1*f8^2 - 4*f2*f7*f8 - 4*f3*f6*f8 + f3*f7^2)*x[6]^3*x[7] +
2*f3*f8*x[6]^3*x[8] + (12*f2*f8^2 + 2*f3*f7*f8 + 4*f4*f6*f8 -
f4*f7^2)*x[6]^2*x[7]^2 - 4*f4*f8*x[6]^2*x[7]*x[8] + (-8*f3*f8^2 - 4*f5*f6*f8 +
f5*f7^2)*x[6]*x[7]^3 + 6*f5*f8*x[6]*x[7]^2*x[8] - f7*x[6]*x[7]*x[8]^2 +
(4*f4*f8^2 - 2*f5*f7*f8 + 4*f6^2*f8 - f6*f7^2)*x[7]^4 + (-8*f6*f8 +
2*f7^2)*x[7]^3*x[8] + 3*f8*x[7]^2*x[8]^2,

// number 5
(64*f0^3*f4*f8^3 - 64*f0^3*f5*f7*f8^2 - 64*f0^3*f6^2*f8^2 + 80*f0^3*f6*f7^2*f8 -
16*f0^3*f7^4 - 64*f0^2*f1*f3*f8^3 + 32*f0^2*f1*f4*f7*f8^2 +
32*f0^2*f1*f5*f6*f8^2 - 16*f0^2*f1*f5*f7^2*f8 - 64*f0^2*f2^2*f8^3 +
32*f0^2*f2*f3*f7*f8^2 + 64*f0^2*f2*f4*f6*f8^2 - 16*f0^2*f2*f4*f7^2*f8 -
16*f0^2*f2*f5^2*f8^2 - 16*f0^2*f3^2*f6*f8^2 - 64*f0^2*f3*f4*f5*f8^2 +
64*f0^2*f3*f4*f6*f7*f8 - 16*f0^2*f3*f4*f7^3 + 64*f0^2*f4^3*f8^2 -
32*f0^2*f4^2*f5*f7*f8 + 4*f0^2*f4*f5^2*f7^2 + 80*f0*f1^2*f2*f8^3 -
16*f0*f1^2*f3*f7*f8^2 - 16*f0*f1^2*f4*f6*f8^2 + 4*f0*f1^2*f4*f7^2*f8 +
64*f0*f1*f2*f4*f5*f8^2 - 64*f0*f1*f2*f4*f6*f7*f8 + 16*f0*f1*f2*f4*f7^3 -
32*f0*f1*f3*f4^2*f8^2 + 8*f0*f1*f3*f4*f5*f7*f8 + 64*f0*f2^2*f4*f6^2*f8 -
16*f0*f2^2*f4*f6*f7^2 - 16*f0*f2^2*f5^2*f6*f8 - 16*f0*f2*f3^2*f6^2*f8 +
4*f0*f2*f3^2*f6*f7^2 - 64*f0*f2*f3*f4*f5*f6*f8 + 16*f0*f2*f3*f4*f5*f7^2 +
16*f0*f2*f3*f5^3*f8 + 16*f0*f3^3*f5*f6*f8 - 4*f0*f3^3*f5*f7^2 - 16*f1^4*f8^3 -
16*f1^3*f4*f5*f8^2 + 16*f1^3*f4*f6*f7*f8 - 4*f1^3*f4*f7^3 -
16*f1^2*f2*f4*f6^2*f8 + 4*f1^2*f2*f4*f6*f7^2 + 4*f1^2*f2*f5^2*f6*f8 +
4*f1^2*f3^2*f4*f8^2 + 16*f1^2*f3*f4*f5*f6*f8 - 4*f1^2*f3*f4*f5*f7^2 -
4*f1^2*f3*f5^3*f8)*x[1]^4 + (64*f0^3*f6*f8^2 - 32*f0^3*f7^2*f8 +
16*f0^2*f1*f5*f8^2 - 48*f0^2*f1*f6*f7*f8 + 16*f0^2*f1*f7^3 - 64*f0^2*f2*f4*f8^2
+ 16*f0^2*f2*f5*f7*f8 + 16*f0^2*f3^2*f8^2 - 32*f0^2*f3*f4*f7*f8 -
64*f0^2*f4^2*f6*f8 + 32*f0^2*f4^2*f7^2 + 32*f0^2*f4*f5^2*f8 -
16*f0^2*f4*f5*f6*f7 + 4*f0*f1^2*f5*f7*f8 - 16*f0*f1*f2*f3*f8^2 +
32*f0*f1*f2*f4*f7*f8 + 4*f0*f1*f3^2*f7*f8 + 16*f0*f1*f3*f4*f6*f8 -
8*f0*f1*f3*f4*f7^2 - 64*f0*f2^2*f4*f6*f8 + 16*f0*f2^2*f5*f6*f7 +
16*f0*f2*f3^2*f6*f8 + 64*f0*f2*f3*f4*f5*f8 - 16*f0*f2*f3*f5^2*f7 -
16*f0*f3^3*f5*f8 + 8*f1^3*f3*f8^2 - 8*f1^3*f4*f7*f8 + 16*f1^2*f2*f4*f6*f8 -
4*f1^2*f2*f5*f6*f7 - 16*f1^2*f3*f4*f5*f8 + 4*f1^2*f3*f5^2*f7)*x[1]^3*x[2] +
(32*f0^3*f7*f8^2 + 96*f0^2*f2*f5*f8^2 - 96*f0^2*f2*f6*f7*f8 + 32*f0^2*f2*f7^3 +
32*f0^2*f3*f4*f8^2 + 8*f0^2*f3*f5*f7*f8 + 32*f0^2*f3*f6^2*f8 -
16*f0^2*f3*f6*f7^2 - 40*f0*f1^2*f5*f8^2 + 48*f0*f1^2*f6*f7*f8 - 16*f0*f1^2*f7^3
- 96*f0*f1*f2*f4*f8^2 + 16*f0*f1*f2*f5*f7*f8 + 32*f0*f1*f3^2*f8^2 -
8*f0*f1*f3*f4*f7*f8 - 16*f0*f1*f3*f5*f6*f8 + 4*f0*f1*f3*f5*f7^2 +
32*f0*f1*f4^2*f6*f8 - 16*f0*f1*f4^2*f7^2 - 16*f0*f1*f4*f5^2*f8 +
8*f0*f1*f4*f5*f6*f7 + 32*f0*f2^2*f5*f6*f8 - 32*f0*f2*f3*f5^2*f8 -
8*f0*f2*f3*f5*f6*f7 + 8*f0*f3^2*f5^2*f7 + 32*f1^3*f4*f8^2 - 8*f1^3*f5*f7*f8 -
8*f1^2*f2*f3*f8^2 - 8*f1^2*f2*f5*f6*f8 - 8*f1^2*f3*f4*f6*f8 + 4*f1^2*f3*f4*f7^2
+ 10*f1^2*f3*f5^2*f8)*x[1]^3*x[3] + (-64*f0^3*f8^3 + 48*f0^2*f3*f5*f8^2 -
96*f0^2*f3*f6*f7*f8 + 32*f0^2*f3*f7^3 - 128*f0^2*f4^2*f8^2 + 80*f0^2*f4*f5*f7*f8
+ 64*f0^2*f4*f6^2*f8 - 32*f0^2*f4*f6*f7^2 - 32*f0^2*f5^2*f6*f8 -
16*f0^2*f5^2*f7^2 + 16*f0^2*f5*f6^2*f7 - 96*f0*f1*f2*f5*f8^2 +
144*f0*f1*f2*f6*f7*f8 - 48*f0*f1*f2*f7^3 + 80*f0*f1*f3*f4*f8^2 -
28*f0*f1*f3*f5*f7*f8 - 32*f0*f1*f3*f6^2*f8 + 16*f0*f1*f3*f6*f7^2 -
16*f0*f1*f4^2*f7*f8 - 16*f0*f1*f4*f5*f6*f8 + 16*f0*f1*f4*f5*f7^2 +
8*f0*f1*f5^3*f8 - 4*f0*f1*f5^2*f6*f7 + 64*f0*f2^2*f4*f8^2 - 32*f0*f2^2*f5*f7*f8
- 32*f0*f2*f3^2*f8^2 - 16*f0*f2*f3*f4*f7*f8 + 8*f0*f2*f3*f5*f7^2 +
64*f0*f2*f4^2*f6*f8 - 32*f0*f2*f4^2*f7^2 - 32*f0*f2*f4*f5^2*f8 +
16*f0*f2*f4*f5*f6*f7 + 8*f0*f3^3*f7*f8 - 32*f0*f3^2*f4*f6*f8 +
16*f0*f3^2*f4*f7^2 + 16*f0*f3^2*f5^2*f8 - 4*f0*f3^2*f5*f6*f7 +
16*f0*f3*f4^2*f5*f8 - 4*f0*f3*f4*f5^2*f7 + 32*f1^3*f5*f8^2 - 48*f1^3*f6*f7*f8 +
16*f1^3*f7^3 - 32*f1^2*f2*f4*f8^2 + 16*f1^2*f2*f5*f7*f8 - 16*f1^2*f3^2*f8^2 +
16*f1^2*f3*f4*f7*f8 + 8*f1^2*f3*f5*f6*f8 - 8*f1^2*f3*f5*f7^2 -
32*f1^2*f4^2*f6*f8 + 16*f1^2*f4^2*f7^2 + 16*f1^2*f4*f5^2*f8 - 8*f1^2*f4*f5*f6*f7
+ 16*f1*f2^2*f3*f8^2 - 4*f1*f2*f3^2*f7*f8 + 16*f1*f2*f3*f4*f6*f8 -
8*f1*f2*f3*f4*f7^2 - 4*f1*f2*f3*f5^2*f8 + 4*f1*f2*f3*f5*f6*f7 -
4*f1*f3^2*f4*f5*f8 - 3*f1*f3^2*f5^2*f7)*x[1]^3*x[4] + (-16*f0^2*f1*f7*f8^2 -
16*f0^2*f2*f7^2*f8 + 16*f0^2*f3*f5*f8^2 - 16*f0^2*f3*f6*f7*f8 + 8*f0^2*f3*f7^3 -
64*f0^2*f4^2*f8^2 + 16*f0^2*f4*f5*f7*f8 - 16*f0*f1^2*f6*f8^2 +
12*f0*f1^2*f7^2*f8 - 16*f0*f1*f2*f5*f8^2 + 16*f0*f1*f3*f4*f8^2 +
4*f0*f1*f3*f5*f7*f8 + 16*f0*f1*f4^2*f7*f8 - 4*f0*f1*f4*f5*f7^2 -
64*f0*f2^2*f6^2*f8 + 16*f0*f2^2*f6*f7^2 + 80*f0*f2*f3*f5*f6*f8 -
16*f0*f2*f3*f5*f7^2 - 16*f0*f3^2*f5^2*f8 + 8*f1^3*f5*f8^2 + 16*f1^2*f2*f6^2*f8 -
4*f1^2*f2*f6*f7^2 - 4*f1^2*f3*f4*f7*f8 - 16*f1^2*f3*f5*f6*f8 +
4*f1^2*f3*f5*f7^2)*x[1]^3*x[5] + (32*f0^2*f1*f8^3 + 96*f0^2*f3*f6*f8^2 -
40*f0^2*f3*f7^2*f8 + 32*f0^2*f4*f5*f8^2 - 96*f0^2*f4*f6*f7*f8 + 32*f0^2*f4*f7^3
+ 32*f0^2*f5^2*f7*f8 - 8*f0^2*f5*f6*f7^2 - 96*f0*f1*f2*f6*f8^2 +
48*f0*f1*f2*f7^2*f8 + 8*f0*f1*f3*f5*f8^2 + 16*f0*f1*f3*f6*f7*f8 -
8*f0*f1*f3*f7^3 - 8*f0*f1*f4*f5*f7*f8 + 32*f0*f2^2*f5*f8^2 -
16*f0*f2*f3*f5*f7*f8 + 32*f0*f2*f3*f6^2*f8 - 8*f0*f2*f3*f6*f7^2 +
32*f0*f2*f4^2*f7*f8 - 8*f0*f2*f4*f5*f7^2 - 16*f0*f3^2*f4*f7*f8 -
32*f0*f3^2*f5*f6*f8 + 10*f0*f3^2*f5*f7^2 + 32*f1^3*f6*f8^2 - 16*f1^3*f7^2*f8 -
16*f1^2*f2*f5*f8^2 + 4*f1^2*f3*f5*f7*f8 - 16*f1^2*f4^2*f7*f8 + 4*f1^2*f4*f5*f7^2
+ 8*f1*f2*f3*f4*f7*f8 - 8*f1*f2*f3*f5*f6*f8 + 8*f1*f3^2*f5^2*f8)*x[1]^3*x[6] +
(64*f0^2*f2*f8^3 + 16*f0^2*f3*f7*f8^2 - 64*f0^2*f4*f6*f8^2 + 16*f0^2*f5^2*f8^2 -
16*f0^2*f5*f6*f7*f8 + 8*f0^2*f5*f7^3 - 32*f0*f1^2*f8^3 - 48*f0*f1*f2*f7*f8^2 +
16*f0*f1*f3*f6*f8^2 + 4*f0*f1*f3*f7^2*f8 - 32*f0*f1*f4*f5*f8^2 +
32*f0*f1*f4*f6*f7*f8 - 8*f0*f1*f4*f7^3 + 4*f0*f1*f5^2*f7*f8 - 64*f0*f2*f4^2*f8^2
+ 16*f0*f2*f4*f5*f7*f8 - 64*f0*f2*f4*f6^2*f8 + 16*f0*f2*f4*f6*f7^2 +
16*f0*f2*f5^2*f6*f8 + 32*f0*f3^2*f4*f8^2 + 64*f0*f3*f4*f5*f6*f8 -
16*f0*f3*f4*f5*f7^2 - 16*f0*f3*f5^3*f8 + 16*f1^3*f7*f8^2 + 32*f1^2*f4^2*f8^2 -
8*f1^2*f4*f5*f7*f8 - 16*f1*f2*f3*f4*f8^2 + 16*f1*f2*f3*f6^2*f8 -
4*f1*f2*f3*f6*f7^2 - 16*f1*f3^2*f5*f6*f8 + 4*f1*f3^2*f5*f7^2)*x[1]^3*x[7] +
(32*f0^2*f4*f8^2 - 2*f0*f1*f5*f7^2 + 8*f0*f2*f4*f7^2 + 8*f0*f2*f5^2*f8 -
8*f0*f2*f5*f6*f7 + 8*f0*f3^2*f6*f8 - 4*f0*f3^2*f7^2 - 24*f0*f3*f4*f5*f8 +
6*f0*f3*f5^2*f7 - 2*f1^2*f3*f7*f8 + 8*f1^2*f4*f6*f8 - 4*f1^2*f4*f7^2 -
4*f1^2*f5^2*f8 + 2*f1^2*f5*f6*f7 - 8*f1*f2*f3*f6*f8 + 2*f1*f2*f3*f7^2 +
6*f1*f3^2*f5*f8)*x[1]^3*x[8] + (-16*f0^3*f8^2 + 16*f0^2*f1*f7*f8 -
16*f0^2*f2*f6*f8 + 32*f0^2*f4^2*f8 - 8*f0^2*f4*f5*f7 + 16*f0^2*f4*f6^2 +
8*f0*f1^2*f6*f8 - 4*f0*f1^2*f7^2 - 8*f0*f1*f3*f4*f8 - 16*f0*f2^2*f6^2 +
16*f0*f2*f3*f5*f6 + 4*f1^2*f2*f6^2 - f1^2*f3^2*f8 -
4*f1^2*f3*f5*f6)*x[1]^2*x[2]^2 + (-16*f0^2*f1*f8^2 + 16*f0^2*f2*f7*f8 -
16*f0^2*f3*f6*f8 + 8*f0^2*f3*f7^2 - 32*f0^2*f4*f5*f8 - 12*f0*f1^2*f7*f8 +
16*f0*f1*f2*f6*f8 - 16*f0*f1*f2*f7^2 + 8*f0*f1*f3*f6*f7 - 16*f0*f1*f4^2*f8 +
12*f0*f1*f4*f5*f7 - 16*f0*f1*f4*f6^2 - 16*f0*f2^2*f6*f7 + 16*f0*f2*f3*f5*f7 +
16*f0*f2*f3*f6^2 - 16*f0*f3^2*f5*f6 - 8*f1^3*f6*f8 + 8*f1^3*f7^2 +
4*f1^2*f2*f6*f7 + 8*f1^2*f3*f4*f8 - 6*f1^2*f3*f5*f7)*x[1]^2*x[2]*x[3] +
(40*f0^2*f3*f7*f8 - 32*f0^2*f4*f7^2 - 16*f0^2*f5^2*f8 + 56*f0^2*f5*f6*f7 -
32*f0^2*f6^3 - 48*f0*f1*f2*f7*f8 + 8*f0*f1*f3*f6*f8 + 8*f0*f1*f3*f7^2 +
24*f0*f1*f4*f5*f8 - 16*f0*f1*f4*f6*f7 - 8*f0*f1*f5^2*f7 + 8*f0*f1*f5*f6^2 -
32*f0*f2^2*f6*f8 + 32*f0*f2^2*f7^2 + 24*f0*f2*f3*f5*f8 - 24*f0*f2*f3*f6*f7 -
32*f0*f2*f4^2*f8 + 24*f0*f2*f4*f5*f7 - 32*f0*f2*f4*f6^2 + 8*f0*f3^2*f4*f8 -
6*f0*f3^2*f5*f7 + 8*f0*f3^2*f6^2 - 16*f0*f3*f4^2*f7 + 8*f0*f3*f4*f5*f6 +
16*f1^3*f7*f8 + 16*f1^2*f2*f6*f8 - 16*f1^2*f2*f7^2 - 12*f1^2*f3*f5*f8 +
8*f1^2*f3*f6*f7 + 16*f1^2*f4^2*f8 - 12*f1^2*f4*f5*f7 + 16*f1^2*f4*f6^2 -
16*f1*f2*f3*f4*f8 + 4*f1*f2*f3*f5*f7 - 8*f1*f2*f3*f6^2 + 4*f1*f3^3*f8 +
4*f1*f3^2*f4*f7 + 6*f1*f3^2*f5*f6)*x[1]^2*x[2]*x[4] + (32*f0^2*f2*f8^2 +
32*f0^2*f4*f6*f8 - 16*f0^2*f4*f7^2 + 8*f0*f1^2*f8^2 + 16*f0*f1*f2*f7*f8 +
8*f0*f1*f3*f6*f8 - 8*f0*f1*f3*f7^2 - 16*f0*f1*f4*f5*f8 + 8*f0*f1*f4*f6*f7 +
64*f0*f2^2*f6*f8 - 64*f0*f2*f3*f5*f8 - 8*f0*f2*f3*f6*f7 + 8*f0*f3^2*f5*f7 -
8*f1^3*f7*f8 - 16*f1^2*f2*f6*f8 + 14*f1^2*f3*f5*f8)*x[1]^2*x[2]*x[5] +
(-64*f0^2*f3*f8^2 + 80*f0^2*f4*f7*f8 - 32*f0^2*f5*f6*f8 - 16*f0^2*f5*f7^2 +
16*f0^2*f6^2*f7 + 48*f0*f1*f2*f8^2 - 20*f0*f1*f3*f7*f8 + 32*f0*f1*f4*f6*f8 -
8*f0*f1*f4*f7^2 - 8*f0*f1*f5^2*f8 + 4*f0*f1*f5*f6*f7 - 32*f0*f2^2*f7*f8 -
16*f0*f2*f3*f6*f8 + 8*f0*f2*f3*f7^2 - 32*f0*f2*f4*f5*f8 + 16*f0*f2*f4*f6*f7 +
32*f0*f3^2*f5*f8 - 4*f0*f3^2*f6*f7 + 16*f0*f3*f4^2*f8 + 4*f0*f3*f4*f5*f7 -
16*f1^3*f8^2 + 16*f1^2*f2*f7*f8 - 16*f1^2*f3*f6*f8 + 4*f1^2*f3*f7^2 +
16*f1^2*f4*f5*f8 - 8*f1^2*f4*f6*f7 + 4*f1*f2*f3*f5*f8 + 4*f1*f2*f3*f6*f7 -
4*f1*f3^2*f4*f8 - 5*f1*f3^2*f5*f7)*x[1]^2*x[2]*x[6] + (8*f0^2*f5*f7*f8 +
32*f0^2*f6^2*f8 - 16*f0^2*f6*f7^2 + 8*f0*f1*f3*f8^2 - 8*f0*f1*f4*f7*f8 -
8*f0*f1*f5*f6*f8 - 2*f0*f1*f5*f7^2 + 32*f0*f2^2*f8^2 - 8*f0*f2*f3*f7*f8 +
96*f0*f2*f4*f6*f8 - 24*f0*f2*f4*f7^2 - 8*f0*f2*f5^2*f8 - 8*f0*f2*f5*f6*f7 -
8*f0*f3^2*f6*f8 + 4*f0*f3^2*f7^2 - 56*f0*f3*f4*f5*f8 + 10*f0*f3*f5^2*f7 -
16*f1^2*f2*f8^2 - 2*f1^2*f3*f7*f8 - 24*f1^2*f4*f6*f8 + 12*f1^2*f4*f7^2 +
4*f1^2*f5^2*f8 - 2*f1^2*f5*f6*f7 - 8*f1*f2*f3*f6*f8 - 2*f1*f2*f3*f7^2 +
10*f1*f3^2*f5*f8)*x[1]^2*x[2]*x[7] + (-4*f0*f1*f5*f8 + 4*f0*f1*f6*f7 -
8*f0*f2*f5*f7 + 16*f0*f2*f6^2 - 4*f0*f3^2*f8 + 8*f0*f3*f4*f7 - 12*f0*f3*f5*f6 +
4*f1^2*f5*f7 - 4*f1^2*f6^2 + 4*f1*f2*f3*f8 - 2*f1*f3^2*f7)*x[1]^2*x[2]*x[8] +
(-48*f0^2*f2*f8^2 - 16*f0^2*f4*f7^2 - 12*f0^2*f5^2*f8 + 32*f0^2*f5*f6*f7 -
16*f0^2*f6^3 + 20*f0*f1^2*f8^2 - 16*f0*f1*f3*f6*f8 + 16*f0*f1*f3*f7^2 +
32*f0*f1*f4*f5*f8 - 16*f0*f1*f4*f6*f7 - 8*f0*f1*f5^2*f7 + 8*f0*f1*f5*f6^2 -
16*f0*f2^2*f6*f8 + 16*f0*f2*f3*f5*f8 + 8*f0*f2*f3*f6*f7 - 16*f0*f2*f4*f6^2 +
4*f0*f2*f5^2*f6 - 8*f0*f3^2*f5*f7 + 16*f0*f3*f4*f5*f6 - 4*f0*f3*f5^3 +
8*f1^2*f2*f6*f8 - 4*f1^2*f2*f7^2 - 4*f1^2*f3*f5*f8 - 4*f1^2*f4^2*f8 +
4*f1^2*f4*f6^2 - f1^2*f5^2*f6)*x[1]^2*x[3]^2 + (16*f0^2*f3*f8^2 -
32*f0^2*f4*f7*f8 + 16*f0^2*f5*f6*f8 + 8*f0^2*f5*f7^2 + 48*f0*f1*f2*f8^2 +
4*f0*f1*f3*f7*f8 - 32*f0*f1*f4*f6*f8 + 40*f0*f1*f4*f7^2 + 24*f0*f1*f5^2*f8 -
64*f0*f1*f5*f6*f7 + 32*f0*f1*f6^3 + 48*f0*f2*f3*f6*f8 - 32*f0*f2*f3*f7^2 +
16*f0*f2*f4*f6*f7 + 16*f0*f2*f5^2*f7 - 16*f0*f2*f5*f6^2 - 32*f0*f3^2*f5*f8 +
16*f0*f3^2*f6*f7 + 16*f0*f3*f4^2*f8 - 24*f0*f3*f4*f5*f7 + 16*f0*f3*f4*f6^2 +
8*f0*f3*f5^2*f6 + 32*f0*f4^3*f7 - 32*f0*f4^2*f5*f6 + 8*f0*f4*f5^3 - 16*f1^3*f8^2
+ 16*f1^2*f3*f6*f8 - 16*f1^2*f3*f7^2 - 32*f1^2*f4*f5*f8 + 16*f1^2*f4*f6*f7 +
8*f1^2*f5^2*f7 - 8*f1^2*f5*f6^2 - 16*f1*f2^2*f6*f8 + 16*f1*f2^2*f7^2 +
8*f1*f2*f3*f5*f8 - 12*f1*f2*f3*f6*f7 + 16*f1*f2*f4^2*f8 - 8*f1*f3^2*f4*f8 +
8*f1*f3^2*f5*f7 - 8*f1*f3*f4^2*f7 - 8*f1*f3*f4*f5*f6 +
2*f1*f3*f5^3)*x[1]^2*x[3]*x[4] + (-16*f0^2*f3*f8^2 + 48*f0^2*f4*f7*f8 -
32*f0^2*f5*f6*f8 - 16*f0^2*f5*f7^2 + 16*f0^2*f6^2*f7 + 16*f0*f1*f2*f8^2 -
28*f0*f1*f3*f7*f8 + 16*f0*f1*f4*f7^2 + 8*f0*f1*f5^2*f8 - 4*f0*f1*f5*f6*f7 -
16*f0*f2*f3*f6*f8 + 16*f0*f2*f4*f6*f7 + 16*f0*f3^2*f5*f8 - 16*f0*f3*f4*f5*f7 -
8*f1^3*f8^2 + 8*f1^2*f2*f7*f8 + 4*f1^2*f4*f5*f8 -
4*f1^2*f4*f6*f7)*x[1]^2*x[3]*x[5] + (-32*f0^2*f4*f8^2 - 8*f0^2*f5*f7*f8 -
8*f0*f1*f3*f8^2 - 40*f0*f1*f4*f7*f8 + 32*f0*f1*f5*f6*f8 + 14*f0*f1*f5*f7^2 -
16*f0*f1*f6^2*f7 + 32*f0*f2*f3*f7*f8 + 32*f0*f2*f4*f6*f8 - 24*f0*f2*f4*f7^2 -
24*f0*f2*f5^2*f8 + 16*f0*f2*f5*f6*f7 - 24*f0*f3^2*f6*f8 + 4*f0*f3^2*f7^2 +
24*f0*f3*f4*f5*f8 - 8*f0*f3*f4*f6*f7 - 10*f0*f3*f5^2*f7 - 32*f0*f4^3*f8 +
8*f0*f4^2*f5*f7 + 14*f1^2*f3*f7*f8 - 24*f1^2*f4*f6*f8 + 4*f1^2*f4*f7^2 +
4*f1^2*f5^2*f8 - 2*f1^2*f5*f6*f7 - 16*f1*f2^2*f7*f8 + 16*f1*f2*f3*f6*f8 -
2*f1*f2*f3*f7^2 - 8*f1*f2*f4*f5*f8 - 10*f1*f3^2*f5*f8 + 8*f1*f3*f4^2*f8 +
6*f1*f3*f4*f5*f7)*x[1]^2*x[3]*x[6] + (-64*f0^2*f5*f8^2 + 48*f0^2*f6*f7*f8 -
16*f0^2*f7^3 + 80*f0*f1*f4*f8^2 - 20*f0*f1*f5*f7*f8 - 32*f0*f1*f6^2*f8 +
16*f0*f1*f6*f7^2 - 32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 - 16*f0*f2*f5*f6*f8 -
16*f0*f2*f5*f7^2 - 8*f0*f3^2*f7*f8 - 32*f0*f3*f4*f6*f8 + 16*f0*f3*f4*f7^2 +
32*f0*f3*f5^2*f8 + 4*f0*f3*f5*f6*f7 + 16*f0*f4^2*f5*f8 - 4*f0*f4*f5^2*f7 -
16*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 + 8*f1^2*f5*f6*f8 + 4*f1^2*f5*f7^2 +
16*f1*f2^2*f8^2 + 4*f1*f2*f3*f7*f8 + 16*f1*f2*f4*f6*f8 - 8*f1*f2*f4*f7^2 -
4*f1*f2*f5^2*f8 + 4*f1*f2*f5*f6*f7 + 4*f1*f3*f4*f5*f8 -
5*f1*f3*f5^2*f7)*x[1]^2*x[3]*x[7] + (4*f0*f1*f7^2 - 8*f0*f2*f5*f8 +
8*f0*f2*f6*f7 + 8*f0*f3*f4*f8 - 2*f0*f3*f5*f7 - 8*f0*f3*f6^2 - 16*f0*f4^2*f7 +
16*f0*f4*f5*f6 - 4*f0*f5^3 + 6*f1^2*f5*f8 - 4*f1^2*f6*f7 - 8*f1*f2*f4*f8 -
2*f1*f2*f5*f7 + 4*f1*f3*f4*f7 + 2*f1*f3*f5*f6)*x[1]^2*x[3]*x[8] +
(64*f0^2*f4*f8^2 - 32*f0^2*f5*f7*f8 - 32*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 -
80*f0*f2*f4*f6*f8 + 32*f0*f2*f4*f7^2 + 20*f0*f2*f5^2*f8 - 32*f0*f2*f5*f6*f7 +
16*f0*f2*f6^3 + 20*f0*f3^2*f6*f8 - 16*f0*f3^2*f7^2 - 24*f0*f3*f4*f5*f8 +
32*f0*f3*f4*f6*f7 + 16*f0*f3*f5^2*f7 - 16*f0*f3*f5*f6^2 + 16*f0*f4^3*f8 -
16*f0*f4^2*f5*f7 - 16*f0*f4^2*f6^2 + 20*f0*f4*f5^2*f6 - 4*f0*f5^4 +
32*f1^2*f4*f6*f8 - 24*f1^2*f4*f7^2 - 16*f1^2*f5^2*f8 + 32*f1^2*f5*f6*f7 -
16*f1^2*f6^3 - 32*f1*f2*f3*f6*f8 + 32*f1*f2*f3*f7^2 + 32*f1*f2*f4*f5*f8 -
24*f1*f2*f4*f6*f7 - 16*f1*f2*f5^2*f7 + 16*f1*f2*f5*f6^2 + 16*f1*f3^2*f5*f8 -
16*f1*f3^2*f6*f7 - 16*f1*f3*f4^2*f8 + 16*f1*f3*f4*f5*f7 - 8*f1*f3*f5^2*f6 -
16*f1*f4^3*f7 + 16*f1*f4^2*f5*f6 - 4*f1*f4*f5^3 + 16*f2^3*f6*f8 - 16*f2^3*f7^2 -
16*f2^2*f3*f5*f8 + 16*f2^2*f3*f6*f7 - 16*f2^2*f4^2*f8 + 20*f2*f3^2*f4*f8 -
8*f2*f3^2*f5*f7 + 16*f2*f3*f4^2*f7 - 4*f3^4*f8 - 4*f3^3*f4*f7)*x[1]^2*x[4]^2 +
(64*f0^2*f4*f8^2 - 16*f0^2*f5*f7*f8 - 32*f0^2*f6^2*f8 + 16*f0^2*f6*f7^2 -
16*f0*f1*f3*f8^2 - 32*f0*f1*f4*f7*f8 + 40*f0*f1*f5*f6*f8 + 10*f0*f1*f5*f7^2 -
16*f0*f1*f6^2*f7 - 32*f0*f2^2*f8^2 + 40*f0*f2*f3*f7*f8 - 64*f0*f2*f4*f6*f8 +
24*f0*f2*f4*f7^2 + 8*f0*f2*f5^2*f8 + 8*f0*f3^2*f6*f8 - 12*f0*f3^2*f7^2 +
8*f0*f3*f4*f5*f8 - 8*f0*f3*f4*f6*f7 - 2*f0*f3*f5^2*f7 - 32*f0*f4^3*f8 +
8*f0*f4^2*f5*f7 + 16*f1^2*f2*f8^2 + 10*f1^2*f3*f7*f8 + 24*f1^2*f4*f6*f8 -
20*f1^2*f4*f7^2 - 12*f1^2*f5^2*f8 + 6*f1^2*f5*f6*f7 - 16*f1*f2^2*f7*f8 +
6*f1*f2*f3*f7^2 - 8*f1*f2*f4*f5*f8 - 2*f1*f3^2*f5*f8 + 8*f1*f3*f4^2*f8 +
6*f1*f3*f4*f5*f7)*x[1]^2*x[4]*x[5] + (16*f0^2*f5*f8^2 + 48*f0^2*f6*f7*f8 -
16*f0^2*f7^3 - 32*f0*f1*f4*f8^2 + 4*f0*f1*f5*f7*f8 + 16*f0*f2*f3*f8^2 -
32*f0*f2*f4*f7*f8 + 48*f0*f2*f5*f6*f8 + 16*f0*f2*f5*f7^2 - 16*f0*f2*f6^2*f7 +
24*f0*f3^2*f7*f8 - 32*f0*f3*f4*f7^2 - 32*f0*f3*f5^2*f8 + 8*f0*f3*f5*f6*f7 +
16*f0*f4^2*f5*f8 + 16*f0*f4^2*f6*f7 - 8*f0*f4*f5^2*f7 + 8*f1^2*f3*f8^2 +
40*f1^2*f4*f7*f8 - 32*f1^2*f5*f6*f8 - 16*f1^2*f5*f7^2 + 16*f1^2*f6^2*f7 -
64*f1*f2*f3*f7*f8 + 16*f1*f2*f4*f6*f8 + 16*f1*f2*f4*f7^2 + 16*f1*f2*f5^2*f8 -
12*f1*f2*f5*f6*f7 + 16*f1*f3^2*f6*f8 + 8*f1*f3^2*f7^2 - 24*f1*f3*f4*f5*f8 +
8*f1*f3*f5^2*f7 + 32*f1*f4^3*f8 - 8*f1*f4^2*f5*f7 + 32*f2^3*f7*f8 -
16*f2^2*f3*f6*f8 - 8*f2^2*f3*f7^2 + 16*f2^2*f4*f5*f8 + 8*f2*f3^2*f5*f8 -
32*f2*f3*f4^2*f8 - 8*f2*f3*f4*f5*f7 + 8*f3^3*f4*f8 +
2*f3^3*f5*f7)*x[1]^2*x[4]*x[6] + (40*f0*f1*f5*f8^2 - 48*f0*f1*f6*f7*f8 +
16*f0*f1*f7^3 + 8*f0*f2*f5*f7*f8 - 32*f0*f2*f6^2*f8 + 16*f0*f2*f6*f7^2 -
16*f0*f3^2*f8^2 + 24*f0*f3*f4*f7*f8 + 24*f0*f3*f5*f6*f8 - 12*f0*f3*f5*f7^2 -
32*f0*f4^2*f6*f8 + 16*f0*f4^2*f7^2 + 8*f0*f4*f5^2*f8 - 16*f0*f4*f5*f6*f7 +
4*f0*f5^3*f7 - 32*f1^2*f4*f8^2 + 8*f1^2*f5*f7*f8 + 32*f1^2*f6^2*f8 -
16*f1^2*f6*f7^2 + 56*f1*f2*f3*f8^2 - 16*f1*f2*f4*f7*f8 - 24*f1*f2*f5*f6*f8 +
8*f1*f2*f5*f7^2 - 8*f1*f3^2*f7*f8 + 24*f1*f3*f4*f6*f8 - 12*f1*f3*f4*f7^2 -
6*f1*f3*f5^2*f8 + 4*f1*f3*f5*f6*f7 - 16*f1*f4^2*f5*f8 + 4*f1*f4*f5^2*f7 -
32*f2^3*f8^2 + 8*f2^2*f3*f7*f8 - 32*f2^2*f4*f6*f8 + 16*f2^2*f4*f7^2 +
8*f2^2*f5^2*f8 - 8*f2^2*f5*f6*f7 + 8*f2*f3*f4*f5*f8 +
6*f2*f3*f5^2*f7)*x[1]^2*x[4]*x[7] + (4*f0*f1*f7*f8 + 32*f0*f2*f6*f8 -
8*f0*f2*f7^2 - 4*f0*f3*f5*f8 - 4*f0*f3*f6*f7 - 4*f0*f4*f5*f7 + 16*f0*f4*f6^2 -
4*f0*f5^2*f6 - 8*f1^2*f6*f8 - 4*f1*f2*f5*f8 + 4*f1*f2*f6*f7 - 4*f1*f3*f4*f8 -
4*f1*f3*f5*f7 + 4*f1*f3*f6^2 + 16*f1*f4^2*f7 - 16*f1*f4*f5*f6 + 4*f1*f5^3 +
16*f2^2*f4*f8 + 4*f2^2*f5*f7 - 4*f2*f3^2*f8 - 16*f2*f3*f4*f7 +
4*f3^3*f7)*x[1]^2*x[4]*x[8] + (-16*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 -
4*f0^2*f6*f7^2 + 16*f0*f1*f3*f8^2 - 16*f0*f1*f4*f7*f8 - 16*f0*f2*f4*f6*f8 +
16*f0*f3*f4*f5*f8 - 4*f1^2*f2*f8^2 + f1^2*f4*f7^2)*x[1]^2*x[5]^2 +
(-16*f0^2*f5*f8^2 + 16*f0^2*f6*f7*f8 - 8*f0^2*f7^3 + 48*f0*f1*f4*f8^2 -
28*f0*f1*f5*f7*f8 + 8*f0*f1*f6*f7^2 - 32*f0*f2*f3*f8^2 - 16*f0*f2*f5*f6*f8 +
8*f0*f3^2*f7*f8 + 4*f0*f3*f4*f7^2 + 16*f0*f3*f5^2*f8 - 16*f1^2*f3*f8^2 +
16*f1^2*f4*f7*f8 + 16*f1*f2^2*f8^2 - 4*f1*f2*f3*f7*f8 + 16*f1*f2*f4*f6*f8 -
4*f1*f2*f4*f7^2 - 16*f1*f3*f4*f5*f8)*x[1]^2*x[5]*x[6] + (32*f0^2*f6*f8^2 +
8*f0^2*f7^2*f8 + 16*f0*f1*f6*f7*f8 - 8*f0*f1*f7^3 + 32*f0*f2*f4*f8^2 +
8*f0*f2*f5*f7*f8 + 64*f0*f2*f6^2*f8 - 16*f0*f2*f6*f7^2 - 16*f0*f3*f4*f7*f8 -
64*f0*f3*f5*f6*f8 + 14*f0*f3*f5*f7^2 - 16*f1^2*f4*f8^2 - 8*f1^2*f5*f7*f8 +
8*f1*f2*f4*f7*f8 - 8*f1*f2*f5*f6*f8 + 8*f1*f3*f5^2*f8)*x[1]^2*x[5]*x[7] +
(-16*f0^2*f8^2 - 8*f0*f1*f7*f8 - 16*f0*f2*f6*f8 - 4*f0*f2*f7^2 + 16*f0*f3*f5*f8
+ 4*f0*f3*f6*f7 + 16*f0*f4^2*f8 - 4*f0*f4*f5*f7 - 4*f1^2*f6*f8 + 4*f1^2*f7^2 +
4*f1*f2*f5*f8 - 4*f1*f3*f4*f8 - f1*f3*f5*f7)*x[1]^2*x[5]*x[8] +
(-48*f0^2*f6*f8^2 + 20*f0^2*f7^2*f8 - 16*f0*f2*f5*f7*f8 - 16*f0*f2*f6^2*f8 +
8*f0*f2*f6*f7^2 - 12*f0*f3^2*f8^2 + 32*f0*f3*f4*f7*f8 + 16*f0*f3*f5*f6*f8 -
4*f0*f3*f5*f7^2 - 4*f0*f4^2*f7^2 - 16*f1^2*f4*f8^2 + 16*f1^2*f5*f7*f8 -
4*f1^2*f6*f7^2 + 32*f1*f2*f3*f8^2 - 16*f1*f2*f4*f7*f8 + 8*f1*f2*f5*f6*f8 -
8*f1*f3^2*f7*f8 - 8*f1*f3*f5^2*f8 - 16*f2^3*f8^2 + 8*f2^2*f3*f7*f8 -
16*f2^2*f4*f6*f8 + 4*f2^2*f4*f7^2 + 4*f2*f3^2*f6*f8 - f2*f3^2*f7^2 +
16*f2*f3*f4*f5*f8 - 4*f3^3*f5*f8)*x[1]^2*x[6]^2 + (-16*f0^2*f7*f8^2 +
16*f0*f1*f6*f8^2 - 12*f0*f1*f7^2*f8 - 16*f0*f2*f5*f8^2 + 16*f0*f2*f6*f7*f8 -
8*f0*f2*f7^3 - 32*f0*f3*f4*f8^2 - 16*f0*f4^2*f7*f8 + 8*f0*f4*f5*f7^2 +
8*f1^2*f5*f8^2 - 16*f1^2*f6*f7*f8 + 8*f1^2*f7^3 + 8*f1*f2*f5*f7*f8 -
16*f1*f2*f6^2*f8 + 4*f1*f2*f6*f7^2 + 12*f1*f3*f4*f7*f8 + 16*f1*f3*f5*f6*f8 -
6*f1*f3*f5*f7^2 - 16*f2^2*f4*f7*f8 + 16*f2^2*f5*f6*f8 -
16*f2*f3*f5^2*f8)*x[1]^2*x[6]*x[7] + (-8*f0*f3*f6*f8 + 6*f0*f3*f7^2 +
8*f0*f4*f5*f8 - 8*f0*f4*f6*f7 + 4*f1^2*f7*f8 + 8*f1*f2*f6*f8 - 4*f1*f2*f7^2 -
2*f1*f3*f5*f8 - 2*f1*f3*f6*f7 - 16*f1*f4^2*f8 + 4*f1*f4*f5*f7 - 8*f2^2*f5*f8 +
16*f2*f3*f4*f8 + 2*f2*f3*f5*f7 - 4*f3^3*f8)*x[1]^2*x[6]*x[8] + (-16*f0^2*f8^3 +
16*f0*f1*f7*f8^2 - 16*f0*f2*f6*f8^2 + 8*f0*f2*f7^2*f8 + 32*f0*f4^2*f8^2 -
8*f0*f4*f5*f7*f8 - f0*f5^2*f7^2 - 4*f1^2*f7^2*f8 - 8*f1*f3*f4*f8^2 +
16*f2^2*f4*f8^2 - 16*f2^2*f6^2*f8 + 4*f2^2*f6*f7^2 + 16*f2*f3*f5*f6*f8 -
4*f2*f3*f5*f7^2)*x[1]^2*x[7]^2 + (-4*f0*f3*f7*f8 - 4*f0*f5^2*f8 + 4*f0*f5*f6*f7
+ 4*f1*f2*f7*f8 - 8*f1*f3*f6*f8 + 4*f1*f3*f7^2 + 8*f1*f4*f5*f8 - 2*f1*f5^2*f7 +
16*f2^2*f6*f8 - 4*f2^2*f7^2 - 12*f2*f3*f5*f8)*x[1]^2*x[7]*x[8] + (16*f0^2*f2*f8
- 16*f0^2*f4*f6 - 4*f0*f1^2*f8 + 16*f0*f2^2*f6 - 16*f0*f2*f3*f5 - 4*f1^2*f2*f6 +
4*f1^2*f3*f5)*x[1]*x[2]^3 + (-8*f0^2*f3*f8 + 16*f0^2*f4*f7 - 4*f0*f1*f3*f7 +
16*f0*f1*f4*f6 - 16*f0*f2*f3*f6 + 16*f0*f3^2*f5)*x[1]*x[2]^2*x[3] +
(-32*f0^2*f5*f7 + 32*f0^2*f6^2 + 8*f0*f1*f4*f7 - 4*f0*f1*f5*f6 + 16*f0*f2*f3*f7
+ 32*f0*f2*f4*f6 - 8*f0*f3^2*f6 - 4*f0*f3*f4*f5 - 4*f1^2*f3*f7 - 16*f1^2*f4*f6 +
8*f1*f2*f3*f6 - 7*f1*f3^2*f5)*x[1]*x[2]^2*x[4] + (-16*f0^2*f4*f8 - 4*f0*f1*f3*f8
- 4*f0*f1*f4*f7 + 2*f1^2*f3*f7)*x[1]*x[2]^2*x[5] + (16*f0^2*f5*f8 - 8*f0^2*f6*f7
- 16*f0*f1*f4*f8 + 8*f0*f1*f5*f7 - 8*f0*f1*f6^2 - 8*f0*f2*f3*f8 - 8*f0*f2*f4*f7
+ 2*f0*f3^2*f7 - 8*f0*f3*f4*f6 + 8*f1^2*f3*f8 + 4*f1^2*f4*f7 - 4*f1*f2*f3*f7 +
2*f1*f3^2*f6)*x[1]*x[2]^2*x[6] + (-16*f0^2*f6*f8 + 8*f0^2*f7^2 + 4*f0*f1*f6*f7 -
16*f0*f2*f4*f8 + 8*f0*f2*f5*f7 + 4*f0*f3^2*f8 - 4*f0*f3*f5*f6 + 8*f1^2*f4*f8 -
4*f1^2*f5*f7 + 4*f1^2*f6^2 + 2*f1*f3^2*f7)*x[1]*x[2]^2*x[7] + (-8*f0^2*f8 -
2*f0*f1*f7 - 16*f0*f2*f6 + 14*f0*f3*f5 + 2*f1^2*f6)*x[1]*x[2]^2*x[8] +
(16*f0^2*f4*f8 - 16*f0^2*f5*f7 + 16*f0^2*f6^2 + 4*f0*f1*f3*f8 - 8*f0*f1*f4*f7 -
4*f0*f1*f5*f6 + 16*f0*f2*f4*f6 - 16*f0*f3*f4*f5 - 4*f1^2*f4*f6)*x[1]*x[2]*x[3]^2
+ (32*f0^2*f5*f8 - 32*f0^2*f6*f7 - 16*f0*f1*f4*f8 + 36*f0*f1*f5*f7 -
32*f0*f1*f6^2 - 16*f0*f2*f3*f8 - 48*f0*f2*f4*f7 + 16*f0*f2*f5*f6 - 8*f0*f3^2*f7
- 16*f0*f3*f4*f6 - 12*f0*f3*f5^2 + 16*f0*f4^2*f5 + 4*f1^2*f3*f8 + 8*f1^2*f4*f7 +
4*f1^2*f5*f6 + 4*f1*f2*f3*f7 + 12*f1*f3*f4*f5)*x[1]*x[2]*x[3]*x[4] +
(8*f0^2*f5*f8 - 8*f0^2*f6*f7 + 16*f0*f1*f4*f8 + 8*f0*f1*f5*f7 - 8*f0*f1*f6^2 -
8*f0*f2*f5*f6 + 8*f0*f3*f5^2 - 2*f1^2*f3*f8 - 2*f1^2*f4*f7 +
2*f1^2*f5*f6)*x[1]*x[2]*x[3]*x[5] + (8*f0^2*f7^2 - 12*f0*f1*f5*f8 +
12*f0*f1*f6*f7 + 16*f0*f2*f4*f8 + 8*f0*f2*f5*f7 - 16*f0*f2*f6^2 + 12*f0*f3^2*f8
+ 4*f0*f3*f4*f7 + 12*f0*f3*f5*f6 + 16*f0*f4^2*f6 - 8*f0*f4*f5^2 - 12*f1^2*f5*f7
+ 12*f1^2*f6^2 - 4*f1*f2*f3*f8 + 4*f1*f2*f4*f7 + 2*f1*f3^2*f7 - 4*f1*f3*f4*f6 -
2*f1*f3*f5^2)*x[1]*x[2]*x[3]*x[6] + (-8*f0^2*f7*f8 + 16*f0*f1*f6*f8 -
4*f0*f1*f7^2 - 16*f0*f2*f5*f8 + 24*f0*f2*f6*f7 + 16*f0*f3*f4*f8 - 16*f0*f3*f5*f7
- 8*f0*f4*f5*f6 + 4*f0*f5^3 + 6*f1^2*f5*f8 - 12*f1^2*f6*f7 - 8*f1*f2*f4*f8 +
6*f1*f2*f5*f7 - 8*f1*f2*f6^2 - 4*f1*f3^2*f8 - 8*f1*f3*f4*f7 +
8*f1*f3*f5*f6)*x[1]*x[2]*x[3]*x[7] + (4*f0*f1*f8 + 4*f0*f2*f7 + 8*f0*f3*f6 -
8*f0*f4*f5 + 4*f1*f2*f6 - 6*f1*f3*f5)*x[1]*x[2]*x[3]*x[8] + (-32*f0^2*f6*f8 +
32*f0^2*f7^2 - 4*f0*f1*f5*f8 + 32*f0*f2*f4*f8 + 16*f0*f2*f5*f7 - 16*f0*f2*f6^2 +
4*f0*f3^2*f8 - 8*f0*f3*f4*f7 + 8*f0*f3*f5*f6 + 16*f0*f4^2*f6 - 8*f0*f4*f5^2 -
8*f1^2*f4*f8 - 16*f1^2*f5*f7 + 16*f1^2*f6^2 + 16*f1*f2*f4*f7 - 12*f1*f2*f5*f6 +
8*f1*f3^2*f7 + 8*f1*f3*f5^2 - 8*f1*f4^2*f5 - 8*f2^2*f3*f7 - 8*f2*f3*f4*f5 +
2*f3^3*f5)*x[1]*x[2]*x[4]^2 + (32*f0^2*f6*f8 - 8*f0^2*f7^2 - 20*f0*f1*f5*f8 +
12*f0*f1*f6*f7 + 48*f0*f2*f4*f8 - 24*f0*f2*f5*f7 + 16*f0*f2*f6^2 - 4*f0*f3^2*f8
+ 20*f0*f3*f4*f7 - 4*f0*f3*f5*f6 + 16*f0*f4^2*f6 - 8*f0*f4*f5^2 - 16*f1^2*f4*f8
+ 4*f1^2*f5*f7 - 4*f1^2*f6^2 + 4*f1*f2*f3*f8 + 4*f1*f2*f4*f7 - 6*f1*f3^2*f7 -
4*f1*f3*f4*f6 - 2*f1*f3*f5^2)*x[1]*x[2]*x[4]*x[5] + (-56*f0^2*f7*f8 +
16*f0*f1*f6*f8 - 8*f0*f1*f7^2 - 24*f0*f2*f5*f8 - 8*f0*f3*f4*f8 - 8*f0*f3*f5*f7 +
16*f0*f3*f6^2 + 8*f0*f4^2*f7 - 24*f0*f4*f5*f6 + 8*f0*f5^3 + 16*f1^2*f5*f8 -
8*f1^2*f6*f7 - 16*f1*f2*f4*f8 + 16*f1*f2*f5*f7 - 8*f1*f2*f6^2 - 10*f1*f3^2*f8 -
8*f1*f3*f4*f7 - 16*f1*f4^2*f6 + 8*f1*f4*f5^2 + 8*f2^2*f3*f8 - 8*f2^2*f4*f7 +
6*f2*f3^2*f7 + 16*f2*f3*f4*f6 - 4*f3^3*f6)*x[1]*x[2]*x[4]*x[6] + (32*f0^2*f8^2 +
8*f0*f1*f7*f8 + 48*f0*f2*f6*f8 - 32*f0*f2*f7^2 - 8*f0*f3*f5*f8 + 4*f0*f3*f6*f7 +
4*f0*f4*f5*f7 + 16*f0*f4*f6^2 - 4*f0*f5^2*f6 - 32*f1^2*f6*f8 + 16*f1^2*f7^2 +
4*f1*f2*f5*f8 + 8*f1*f2*f6*f7 + 4*f1*f3*f4*f8 + 4*f1*f3*f5*f7 - 12*f1*f3*f6^2 +
8*f1*f4*f5*f6 - 4*f1*f5^3 + 16*f2^2*f4*f8 - 12*f2^2*f5*f7 + 16*f2^2*f6^2 -
4*f2*f3^2*f8 + 8*f2*f3*f4*f7 - 12*f2*f3*f5*f6 - 4*f3^3*f7)*x[1]*x[2]*x[4]*x[7] +
(-16*f0*f2*f8 - 6*f0*f3*f7 - 24*f0*f4*f6 + 4*f0*f5^2 + 4*f1^2*f8 - 4*f1*f2*f7 +
2*f1*f3*f6 + 8*f1*f4*f5 - 8*f2^2*f6 + 8*f2*f3*f5)*x[1]*x[2]*x[4]*x[8] +
(-8*f0*f1*f5*f8 + 4*f0*f1*f6*f7 + 4*f1^2*f4*f8)*x[1]*x[2]*x[5]^2 +
(-16*f0*f1*f6*f8 + 4*f0*f1*f7^2 + 16*f0*f2*f5*f8 - 16*f0*f3*f4*f8 -
4*f0*f3*f5*f7 - 16*f0*f4^2*f7 + 8*f1^2*f5*f8 - 4*f1^2*f6*f7 - 16*f1*f2*f4*f8 +
4*f1*f3^2*f8 + 4*f1*f3*f4*f7)*x[1]*x[2]*x[5]*x[6] + (-32*f0^2*f8^2 -
8*f0*f1*f7*f8 - 80*f0*f2*f6*f8 + 12*f0*f2*f7^2 + 48*f0*f3*f5*f8 + 8*f0*f4*f5*f7
+ 12*f1^2*f6*f8 + 4*f1*f2*f6*f7 + 8*f1*f3*f4*f8 -
2*f1*f3*f5*f7)*x[1]*x[2]*x[5]*x[7] + (-8*f0*f4*f6 + 4*f0*f5^2 + 2*f1^2*f8 -
2*f1*f2*f7)*x[1]*x[2]*x[5]*x[8] + (32*f0^2*f8^2 + 4*f0*f1*f7*f8 + 16*f0*f2*f6*f8
- 8*f0*f3*f6*f7 - 16*f0*f4^2*f8 + 8*f0*f4*f5*f7 - 16*f1*f2*f5*f8 + 4*f1*f2*f6*f7
+ 8*f1*f3*f4*f8 + 8*f1*f4^2*f7 + 16*f2^2*f4*f8 - 8*f2*f3^2*f8 - 8*f2*f3*f4*f7 +
2*f3^3*f7)*x[1]*x[2]*x[6]^2 + (-8*f0*f1*f8^2 + 16*f0*f2*f7*f8 - 16*f0*f3*f6*f8 +
6*f0*f3*f7^2 + 16*f0*f4*f5*f8 - 8*f0*f4*f6*f7 - 4*f0*f5^2*f7 - 4*f1^2*f7*f8 +
24*f1*f2*f6*f8 - 12*f1*f2*f7^2 - 16*f1*f3*f5*f8 + 6*f1*f3*f6*f7 - 8*f1*f4*f5*f7
- 8*f2^2*f6*f7 - 8*f2*f3*f4*f8 + 8*f2*f3*f5*f7 + 4*f3^3*f8)*x[1]*x[2]*x[6]*x[7]
+ (12*f0*f3*f8 + 4*f0*f4*f7 + 4*f0*f5*f6 - 4*f1*f2*f8 + 8*f1*f4*f6 - 4*f1*f5^2 +
4*f2^2*f7 - 4*f2*f3*f6)*x[1]*x[2]*x[6]*x[8] + (-16*f0*f2*f8^2 - 16*f0*f4*f6*f8 +
8*f0*f4*f7^2 + 4*f0*f5^2*f8 + 8*f1^2*f8^2 + 4*f1*f2*f7*f8 + 8*f1*f3*f6*f8 -
4*f1*f3*f7^2 + 2*f1*f5^2*f7 + 4*f2^2*f7^2 - 4*f2*f3*f5*f8)*x[1]*x[2]*x[7]^2 +
(8*f0*f4*f8 + 2*f0*f5*f7 - 8*f0*f6^2 + 2*f1*f3*f8 - 8*f1*f4*f7 + 4*f1*f5*f6 -
8*f2^2*f8 + 4*f2*f3*f7)*x[1]*x[2]*x[7]*x[8] + (4*f0*f6 -
2*f1*f5)*x[1]*x[2]*x[8]^2 + (8*f0^2*f5*f8 - 16*f0^2*f6*f7 - 8*f0*f1*f4*f8 +
4*f0*f1*f5*f7 - 8*f0*f2*f5*f6 + 8*f0*f3*f5^2 + 4*f1^2*f4*f7)*x[1]*x[3]^3 +
(-16*f0^2*f6*f8 + 16*f0^2*f7^2 - 24*f0*f1*f5*f8 + 32*f0*f1*f6*f7 +
16*f0*f2*f4*f8 - 8*f0*f2*f5*f7 + 8*f0*f3^2*f8 + 32*f0*f3*f4*f7 - 4*f0*f3*f5*f6 -
8*f0*f4*f5^2 + 8*f1^2*f4*f8 - 4*f1^2*f5*f7 - 4*f1*f2*f3*f8 - 16*f1*f2*f4*f7 +
8*f1*f2*f5*f6 - 7*f1*f3*f5^2)*x[1]*x[3]^2*x[4] + (32*f0^2*f6*f8 + 8*f0^2*f7^2 -
12*f0*f1*f5*f8 + 8*f0*f1*f6*f7 + 16*f0*f2*f6^2 - 16*f0*f3*f5*f6 - 4*f1^2*f4*f8 -
2*f1^2*f5*f7)*x[1]*x[3]^2*x[5] + (-8*f0^2*f7*f8 - 8*f0*f1*f6*f8 - 12*f0*f1*f7^2
+ 8*f0*f2*f5*f8 - 24*f0*f3*f4*f8 - 6*f0*f3*f5*f7 + 8*f0*f3*f6^2 - 8*f0*f4*f5*f6
+ 4*f0*f5^3 + 2*f1^2*f5*f8 - 4*f1^2*f6*f7 + 8*f1*f2*f4*f8 + 6*f1*f2*f5*f7 -
8*f1*f2*f6^2 - 4*f1*f3*f4*f7 + 6*f1*f3*f5*f6)*x[1]*x[3]^2*x[6] + (32*f0^2*f8^2 +
4*f0*f1*f7*f8 + 16*f0*f2*f6*f8 - 16*f0*f3*f6*f7 - 16*f0*f4^2*f8 + 8*f0*f4*f5*f7
+ 16*f0*f4*f6^2 - 8*f0*f5^2*f6 - 8*f1*f2*f5*f8 + 4*f1*f2*f6*f7 + 8*f1*f3*f4*f8 +
8*f1*f4^2*f7 - 8*f1*f4*f5*f6 + 2*f1*f5^3)*x[1]*x[3]^2*x[7] + (-4*f0*f3*f7 -
8*f0*f4*f6 + 6*f0*f5^2 - 2*f1^2*f8 + 2*f1*f2*f7 + 2*f1*f4*f5)*x[1]*x[3]^2*x[8] +
(32*f0*f1*f6*f8 - 32*f0*f1*f7^2 - 24*f0*f2*f5*f8 + 16*f0*f2*f6*f7 -
32*f0*f4^2*f7 + 8*f0*f4*f5*f6 + 4*f0*f5^3 + 16*f1^2*f5*f8 - 16*f1^2*f6*f7 -
16*f1*f2*f4*f8 + 8*f1*f2*f5*f7 - 8*f1*f3^2*f8 - 12*f1*f3*f4*f7 + 4*f1*f3*f5*f6 +
4*f1*f4*f5^2 + 8*f2^2*f3*f8 + 16*f2^2*f4*f7 - 8*f2^2*f5*f6 +
6*f2*f3*f5^2)*x[1]*x[3]*x[4]^2 + (-8*f0^2*f7*f8 - 32*f0*f1*f6*f8 - 12*f0*f1*f7^2
+ 16*f0*f2*f5*f8 - 8*f0*f2*f6*f7 - 48*f0*f3*f4*f8 - 32*f0*f4^2*f7 +
24*f0*f4*f5*f6 - 4*f0*f5^3 + 10*f1^2*f5*f8 - 4*f1^2*f6*f7 + 8*f1*f2*f4*f8 +
2*f1*f2*f5*f7 - 8*f1*f2*f6^2 + 4*f1*f3^2*f8 + 8*f1*f3*f4*f7 +
8*f1*f3*f5*f6)*x[1]*x[3]*x[4]*x[5] + (40*f0*f1*f7*f8 - 16*f0*f2*f6*f8 +
16*f0*f3*f5*f8 - 12*f0*f3*f6*f7 + 32*f0*f4^2*f8 + 28*f0*f4*f5*f7 - 16*f0*f4*f6^2
- 4*f0*f5^2*f6 + 16*f1^2*f7^2 - 12*f1*f2*f5*f8 + 8*f1*f2*f6*f7 + 28*f1*f3*f4*f8
+ 4*f1*f3*f5*f7 - 12*f1*f3*f6^2 + 8*f1*f4*f5*f6 - 4*f1*f5^3 - 16*f2^2*f4*f8 -
12*f2^2*f5*f7 + 16*f2^2*f6^2 - 4*f2*f3^2*f8 + 8*f2*f3*f4*f7 - 12*f2*f3*f5*f6 -
4*f3^3*f7)*x[1]*x[3]*x[4]*x[6] + (-56*f0*f1*f8^2 + 16*f0*f2*f7*f8 -
24*f0*f3*f6*f8 + 16*f0*f3*f7^2 - 8*f0*f4*f5*f8 - 16*f0*f4*f6*f7 - 10*f0*f5^2*f7
+ 8*f0*f5*f6^2 - 8*f1^2*f7*f8 - 8*f1*f2*f7^2 - 8*f1*f3*f5*f8 + 16*f1*f3*f6*f7 +
8*f1*f4^2*f8 - 8*f1*f4*f5*f7 - 8*f1*f4*f6^2 + 6*f1*f5^2*f6 + 16*f2^2*f5*f8 -
8*f2^2*f6*f7 - 24*f2*f3*f4*f8 - 16*f2*f4^2*f7 + 16*f2*f4*f5*f6 - 4*f2*f5^3 +
8*f3^3*f8 + 8*f3^2*f4*f7)*x[1]*x[3]*x[4]*x[7] + (4*f0*f3*f8 + 32*f0*f4*f7 -
4*f0*f5*f6 + 4*f1*f2*f8 + 4*f1*f3*f7 + 4*f1*f4*f6 - 6*f1*f5^2 - 4*f2^2*f7 -
4*f2*f4*f5 - 2*f3^2*f5)*x[1]*x[3]*x[4]*x[8] + (-24*f0^2*f7*f8 - 8*f0*f1*f6*f8 -
4*f0*f1*f7^2 - 16*f0*f2*f6*f7 + 16*f0*f3*f5*f7 + 2*f1^2*f5*f8)*x[1]*x[3]*x[5]^2
+ (32*f0*f1*f7*f8 - 16*f0*f2*f6*f8 + 12*f0*f2*f7^2 + 16*f0*f3*f5*f8 -
8*f0*f3*f6*f7 + 32*f0*f4^2*f8 + 12*f1^2*f6*f8 - 8*f1*f2*f5*f8 + 12*f1*f2*f6*f7 -
10*f1*f3*f5*f7)*x[1]*x[3]*x[5]*x[6] + (-16*f0*f2*f7*f8 + 16*f0*f3*f6*f8 +
8*f0*f3*f7^2 - 16*f0*f4*f5*f8 - 16*f0*f4*f6*f7 + 4*f0*f5^2*f7 + 4*f1^2*f7*f8 -
4*f1*f2*f7^2 - 4*f1*f3*f5*f8 - 16*f1*f4^2*f8 +
4*f1*f4*f5*f7)*x[1]*x[3]*x[5]*x[7] + (4*f0*f3*f8 + 12*f0*f4*f7 - 4*f0*f5*f6 -
2*f1*f3*f7 + 4*f1*f4*f6 - 2*f1*f5^2)*x[1]*x[3]*x[5]*x[8] + (-8*f0*f1*f8^2 -
8*f0*f2*f7*f8 + 8*f0*f3*f6*f8 + 2*f0*f3*f7^2 - 24*f0*f4*f5*f8 + 8*f0*f4*f6*f7 -
12*f1^2*f7*f8 - 4*f1*f2*f7^2 - 6*f1*f3*f5*f8 + 6*f1*f3*f6*f7 - 4*f1*f4*f5*f7 +
8*f2^2*f5*f8 - 8*f2^2*f6*f7 - 8*f2*f3*f4*f8 + 6*f2*f3*f5*f7 +
4*f3^3*f8)*x[1]*x[3]*x[6]^2 + (-12*f0*f3*f7*f8 + 16*f0*f4*f6*f8 + 12*f0*f5^2*f8
- 4*f0*f5*f6*f7 + 8*f1^2*f8^2 + 12*f1*f2*f7*f8 + 8*f1*f3*f6*f8 - 12*f1*f3*f7^2 +
4*f1*f4*f5*f8 + 4*f1*f4*f6*f7 + 2*f1*f5^2*f7 - 16*f2^2*f6*f8 + 12*f2^2*f7^2 +
12*f2*f3*f5*f8 + 16*f2*f4^2*f8 - 4*f2*f4*f5*f7 - 8*f3^2*f4*f8 -
2*f3^2*f5*f7)*x[1]*x[3]*x[6]*x[7] + (-24*f0*f4*f8 - 8*f0*f5*f7 + 8*f0*f6^2 -
8*f1*f3*f8 - 4*f1*f4*f7 - 2*f1*f5*f6 + 8*f2^2*f8 - 2*f2*f3*f7 - 8*f2*f4*f6 +
4*f2*f5^2 + 4*f3^2*f6)*x[1]*x[3]*x[6]*x[8] + (16*f0*f3*f8^2 - 16*f0*f4*f7*f8 -
8*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 8*f1*f2*f8^2 + 8*f1*f3*f7*f8 - 8*f1*f4*f6*f8 +
4*f1*f4*f7^2 + 2*f1*f5^2*f8 - 4*f1*f5*f6*f7 - 8*f2^2*f7*f8 - 8*f2*f4*f5*f8 +
2*f2*f5^2*f7)*x[1]*x[3]*x[7]^2 + (12*f0*f5*f8 - 4*f0*f6*f7 + 4*f1*f4*f8 +
4*f1*f6^2 + 4*f2*f3*f8 + 8*f2*f4*f7 - 4*f2*f5*f6 -
4*f3^2*f7)*x[1]*x[3]*x[7]*x[8] + (-2*f0*f7 - 2*f1*f6 + 2*f2*f5)*x[1]*x[3]*x[8]^2
+ (16*f0*f2*f6*f8 - 16*f0*f2*f7^2 + 4*f0*f3*f5*f8 - 16*f0*f4^2*f8 +
16*f0*f4*f5*f7 - 4*f0*f5^2*f6 - 16*f1^2*f6*f8 + 16*f1^2*f7^2 + 16*f1*f3*f4*f8 -
8*f1*f3*f5*f7 + 16*f1*f4^2*f7 - 8*f1*f4*f5*f6 - 4*f2*f3^2*f8 - 8*f2*f3*f4*f7 +
4*f2*f3*f5*f6 - 3*f3^2*f5^2)*x[1]*x[4]^3 + (-16*f0^2*f8^2 + 20*f0*f1*f7*f8 +
8*f0*f2*f7^2 + 8*f0*f3*f5*f8 - 12*f0*f3*f6*f7 + 16*f0*f4^2*f8 + 8*f0*f4*f5*f7 -
4*f0*f5^2*f6 + 8*f1^2*f6*f8 - 12*f1*f2*f5*f8 + 4*f1*f2*f6*f7 + 8*f1*f3*f4*f8 -
4*f1*f3*f5*f7 + 4*f1*f3*f6^2 + 16*f1*f4^2*f7 - 16*f1*f4*f5*f6 + 4*f1*f5^3 +
4*f2^2*f5*f7 - 4*f2*f3^2*f8 - 16*f2*f3*f4*f7 + 4*f3^3*f7)*x[1]*x[4]^2*x[5] +
(32*f0*f2*f7*f8 - 24*f0*f3*f6*f8 + 16*f0*f3*f7^2 - 16*f0*f4*f6*f7 - 8*f0*f5^2*f7
+ 8*f0*f5*f6^2 - 32*f1^2*f7*f8 + 16*f1*f2*f6*f8 - 16*f1*f2*f7^2 + 8*f1*f3*f6*f7
- 32*f1*f4^2*f8 - 12*f1*f4*f5*f7 + 16*f1*f4*f6^2 + 8*f2*f3*f4*f8 + 4*f2*f3*f5*f7
- 8*f2*f3*f6^2 + 4*f3^3*f8 + 4*f3^2*f4*f7 + 6*f3^2*f5*f6)*x[1]*x[4]^2*x[6] +
(-32*f0*f2*f8^2 - 4*f0*f3*f7*f8 + 32*f0*f4*f6*f8 - 8*f0*f4*f7^2 + 4*f0*f5^2*f8 +
32*f1^2*f8^2 + 16*f1*f3*f6*f8 - 16*f1*f3*f7^2 - 8*f1*f4*f5*f8 + 16*f1*f4*f6*f7 +
8*f1*f5^2*f7 - 8*f1*f5*f6^2 - 16*f2^2*f6*f8 + 16*f2^2*f7^2 + 8*f2*f3*f5*f8 -
12*f2*f3*f6*f7 + 16*f2*f4^2*f8 - 8*f3^2*f4*f8 + 8*f3^2*f5*f7 - 8*f3*f4^2*f7 -
8*f3*f4*f5*f6 + 2*f3*f5^3)*x[1]*x[4]^2*x[7] + (-6*f0*f5*f7 - 6*f1*f3*f8 -
20*f1*f4*f7 + 6*f1*f5*f6 + 6*f2*f3*f7 + 6*f3*f4*f5)*x[1]*x[4]^2*x[8] +
(12*f0*f1*f7*f8 + 16*f0*f2*f6*f8 - 4*f0*f2*f7^2 + 32*f0*f4^2*f8 - 8*f0*f4*f5*f7
- 4*f1^2*f6*f8 + 4*f1^2*f7^2 + 4*f1*f2*f6*f7 - 8*f1*f3*f4*f8 -
5*f1*f3*f5*f7)*x[1]*x[4]*x[5]^2 + (-8*f0*f1*f8^2 - 32*f0*f2*f7*f8 +
16*f0*f3*f6*f8 + 10*f0*f3*f7^2 - 48*f0*f4*f5*f8 + 8*f0*f4*f6*f7 + 4*f0*f5^2*f7 -
12*f1^2*f7*f8 - 8*f1*f2*f6*f8 - 4*f1*f2*f7^2 + 2*f1*f3*f6*f7 - 32*f1*f4^2*f8 +
8*f1*f4*f5*f7 - 8*f2^2*f6*f7 + 24*f2*f3*f4*f8 + 8*f2*f3*f5*f7 -
4*f3^3*f8)*x[1]*x[4]*x[5]*x[6] + (32*f0*f2*f8^2 - 20*f0*f3*f7*f8 +
48*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 4*f0*f5^2*f8 + 4*f0*f5*f6*f7 - 8*f1^2*f8^2 +
12*f1*f2*f7*f8 - 24*f1*f3*f6*f8 + 4*f1*f3*f7^2 + 20*f1*f4*f5*f8 + 4*f1*f4*f6*f7
- 6*f1*f5^2*f7 + 16*f2^2*f6*f8 - 4*f2^2*f7^2 - 4*f2*f3*f5*f8 + 16*f2*f4^2*f8 -
4*f2*f4*f5*f7 - 8*f3^2*f4*f8 - 2*f3^2*f5*f7)*x[1]*x[4]*x[5]*x[7] + (-24*f0*f4*f8
+ 4*f0*f5*f7 - 8*f0*f6^2 + 4*f1*f3*f8 - 10*f1*f4*f7 + 8*f1*f5*f6 - 8*f2^2*f8 +
8*f2*f3*f7)*x[1]*x[4]*x[5]*x[8] + (-16*f0*f2*f8^2 - 24*f0*f3*f7*f8 +
16*f0*f4*f6*f8 + 8*f0*f4*f7^2 + 8*f0*f5^2*f8 - 4*f0*f5*f6*f7 + 16*f1^2*f8^2 +
32*f1*f2*f7*f8 - 8*f1*f3*f6*f8 - 4*f1*f3*f7^2 + 32*f1*f4*f5*f8 - 16*f1*f4*f6*f7
- 4*f2*f3*f5*f8 + 8*f2*f3*f6*f7 - 8*f3^2*f4*f8 - 7*f3^2*f5*f7)*x[1]*x[4]*x[6]^2
+ (32*f0*f3*f8^2 - 16*f0*f4*f7*f8 - 16*f0*f5*f6*f8 + 4*f0*f5*f7^2 -
32*f1*f2*f8^2 + 36*f1*f3*f7*f8 - 48*f1*f4*f6*f8 + 8*f1*f4*f7^2 - 8*f1*f5^2*f8 +
4*f1*f5*f6*f7 - 32*f2^2*f7*f8 + 16*f2*f3*f6*f8 + 4*f2*f3*f7^2 - 16*f2*f4*f5*f8 -
12*f3^2*f5*f8 + 16*f3*f4^2*f8 + 12*f3*f4*f5*f7)*x[1]*x[4]*x[6]*x[7] +
(4*f0*f5*f8 + 4*f0*f6*f7 + 32*f1*f4*f8 + 4*f1*f5*f7 - 4*f1*f6^2 - 4*f2*f3*f8 +
4*f2*f4*f7 - 6*f3^2*f7 - 4*f3*f4*f6 - 2*f3*f5^2)*x[1]*x[4]*x[6]*x[8] +
(-32*f1*f3*f8^2 + 8*f1*f4*f7*f8 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2 + 32*f2^2*f8^2 -
4*f2*f3*f7*f8 + 32*f2*f4*f6*f8 - 16*f2*f4*f7^2 - 8*f2*f5^2*f8 + 8*f2*f5*f6*f7 -
4*f3*f4*f5*f8 - 7*f3*f5^2*f7)*x[1]*x[4]*x[7]^2 + (-16*f0*f6*f8 + 4*f0*f7^2 -
6*f1*f5*f8 - 4*f1*f6*f7 - 24*f2*f4*f8 + 2*f2*f5*f7 - 8*f2*f6^2 + 4*f3^2*f8 +
8*f3*f4*f7 + 8*f3*f5*f6)*x[1]*x[4]*x[7]*x[8] + (4*f0*f8 + 4*f1*f7 + 4*f2*f6 -
5*f3*f5)*x[1]*x[4]*x[8]^2 + (16*f0^2*f8^2 + 4*f0*f1*f7*f8 + 16*f0*f2*f6*f8 -
16*f0*f3*f5*f8)*x[1]*x[5]^3 + (-24*f0*f1*f8^2 - 8*f0*f2*f7*f8 + 2*f0*f3*f7^2 -
4*f1^2*f7*f8 - 16*f1*f2*f6*f8 + 16*f1*f3*f5*f8)*x[1]*x[5]^2*x[6] +
(-8*f0*f3*f7*f8 + 4*f0*f4*f7^2 + 4*f1*f2*f7*f8)*x[1]*x[5]^2*x[7] + (-8*f0*f4*f8
+ 2*f0*f5*f7 + 2*f1*f3*f8 - 2*f1*f4*f7)*x[1]*x[5]^2*x[8] + (32*f0*f2*f8^2 -
12*f0*f3*f7*f8 - 4*f0*f4*f7^2 + 8*f1^2*f8^2 + 8*f1*f2*f7*f8 - 2*f1*f3*f7^2 +
16*f2^2*f6*f8 - 16*f2*f3*f5*f8)*x[1]*x[5]*x[6]^2 + (8*f0*f3*f8^2 +
16*f0*f4*f7*f8 - 2*f0*f5*f7^2 - 8*f1*f2*f8^2 + 8*f1*f3*f7*f8 - 2*f1*f4*f7^2 -
8*f2^2*f7*f8 - 8*f2*f3*f6*f8 + 2*f2*f3*f7^2 + 8*f3^2*f5*f8)*x[1]*x[5]*x[6]*x[7]
+ (4*f0*f5*f8 + 12*f1*f4*f8 - 2*f1*f5*f7 - 4*f2*f3*f8 + 4*f2*f4*f7 -
2*f3^2*f7)*x[1]*x[5]*x[6]*x[8] + (-16*f0*f4*f8^2 - 4*f0*f5*f7*f8 - 4*f1*f4*f7*f8
+ 2*f1*f5*f7^2)*x[1]*x[5]*x[7]^2 + (2*f0*f7^2 - 2*f1*f6*f7 - 8*f2*f4*f8 +
4*f3^2*f8)*x[1]*x[5]*x[7]*x[8] + (8*f0*f3*f8^2 - 8*f0*f4*f7*f8 - 16*f1*f2*f8^2 +
4*f1*f3*f7*f8 + 4*f1*f4*f7^2 - 8*f2*f3*f6*f8 + 8*f3^2*f5*f8)*x[1]*x[6]^3 +
(16*f0*f4*f8^2 + 4*f0*f5*f7*f8 - 16*f1*f3*f8^2 - 8*f1*f4*f7*f8 + 16*f2^2*f8^2 -
4*f2*f3*f7*f8 + 16*f2*f4*f6*f8 - 4*f2*f4*f7^2 - 16*f3*f4*f5*f8)*x[1]*x[6]^2*x[7]
+ (-2*f0*f7^2 - 4*f1*f5*f8 + 2*f1*f6*f7 - 8*f2*f4*f8 + 6*f3^2*f8 +
2*f3*f4*f7)*x[1]*x[6]^2*x[8] + (-8*f0*f5*f8^2 + 16*f1*f4*f8^2 - 4*f1*f5*f7*f8 +
16*f2*f4*f7*f8 - 16*f2*f5*f6*f8 + 16*f3*f5^2*f8)*x[1]*x[6]*x[7]^2 + (4*f0*f7*f8
+ 4*f1*f6*f8 + 8*f2*f5*f8 + 4*f2*f6*f7 - 8*f3*f4*f8 -
6*f3*f5*f7)*x[1]*x[6]*x[7]*x[8] + (-2*f1*f8 - 2*f2*f7 +
2*f3*f6)*x[1]*x[6]*x[8]^2 + (16*f0*f6*f8^2 - 4*f0*f7^2*f8 - 16*f2*f4*f8^2 +
16*f2*f6^2*f8 - 4*f2*f6*f7^2 - 16*f3*f5*f6*f8 + 4*f3*f5*f7^2)*x[1]*x[7]^3 +
(-8*f0*f8^2 - 2*f1*f7*f8 - 16*f2*f6*f8 + 2*f2*f7^2 +
14*f3*f5*f8)*x[1]*x[7]^2*x[8] + (4*f2*f8 - 2*f3*f7)*x[1]*x[7]*x[8]^2 +
4*f0^2*f4*x[2]^4 - 4*f0*f1*f4*x[2]^3*x[3] + (-8*f0^2*f6 - 8*f0*f2*f4 + 2*f0*f3^2
+ 4*f1^2*f4)*x[2]^3*x[4] + (4*f0*f1*f6 + 4*f0*f3*f4 - f1*f3^2)*x[2]^3*x[6] +
(-2*f0*f1*f7 + 2*f0*f3*f5 - 2*f1^2*f6)*x[2]^3*x[7] + (-4*f0^2*f6 +
f1^2*f4)*x[2]^2*x[3]^2 + (16*f0^2*f7 + 8*f0*f1*f6 + 4*f0*f3*f4 -
4*f1*f2*f4)*x[2]^2*x[3]*x[4] + 4*f0*f1*f6*x[2]^2*x[3]*x[5] + (-6*f0*f1*f7 +
8*f0*f2*f6 - 6*f0*f3*f5 - 8*f0*f4^2 - 6*f1^2*f6 + 2*f1*f3*f4)*x[2]^2*x[3]*x[6] +
(-12*f0*f2*f7 + 4*f0*f4*f5 + 8*f1^2*f7 + 4*f1*f2*f6 -
3*f1*f3*f5)*x[2]^2*x[3]*x[7] - 2*f0*f3*x[2]^2*x[3]*x[8] + (4*f0^2*f8 +
8*f0*f2*f6 - 4*f0*f3*f5 - 4*f0*f4^2 - 4*f1^2*f6 + 4*f2^2*f4 -
f2*f3^2)*x[2]^2*x[4]^2 + (-8*f0^2*f8 - 2*f0*f1*f7 - 8*f0*f2*f6 + 2*f0*f3*f5 -
8*f0*f4^2 + 2*f1^2*f6 + 2*f1*f3*f4)*x[2]^2*x[4]*x[5] + (-4*f0*f1*f8 - 8*f0*f3*f6
+ 8*f0*f4*f5 + 4*f1*f2*f6 + 8*f1*f4^2 - 8*f2*f3*f4 + 2*f3^3)*x[2]^2*x[4]*x[6] +
(-8*f0*f2*f8 + 6*f0*f3*f7 - 8*f0*f4*f6 + 4*f1^2*f8 - 4*f1*f2*f7 + 6*f1*f3*f6 -
4*f1*f4*f5 - 8*f2^2*f6 + 6*f2*f3*f5)*x[2]^2*x[4]*x[7] + (8*f0*f4 -
2*f1*f3)*x[2]^2*x[4]*x[8] + (4*f0^2*f8 + 4*f0*f2*f6 - 4*f0*f3*f5 -
f1^2*f6)*x[2]^2*x[5]^2 + (4*f0*f1*f8 + 8*f0*f4*f5 + 2*f1*f3*f5)*x[2]^2*x[5]*x[6]
+ (16*f0*f2*f8 - 2*f0*f3*f7 - 4*f0*f5^2 - 6*f1^2*f8 - 2*f1*f2*f7 -
2*f1*f3*f6)*x[2]^2*x[5]*x[7] + (4*f0*f4 + f1*f3)*x[2]^2*x[5]*x[8] + (4*f0*f2*f8
+ 4*f0*f4*f6 - 4*f0*f5^2 - 4*f1*f4*f5)*x[2]^2*x[6]^2 + (-4*f0*f4*f7 + 4*f0*f5*f6
- 4*f1*f2*f8 + 4*f1*f5^2 + 4*f2^2*f7)*x[2]^2*x[6]*x[7] + (-4*f0*f5 - 4*f1*f4 +
2*f2*f3)*x[2]^2*x[6]*x[8] + (4*f0*f4*f8 - 4*f0*f5*f7 + 4*f0*f6^2 - 4*f1*f3*f8 +
4*f1*f4*f7 - 4*f1*f5*f6 + 4*f2^2*f8 - 4*f2*f3*f7)*x[2]^2*x[7]^2 +
2*f1*f5*x[2]^2*x[7]*x[8] - f0*x[2]^2*x[8]^2 + 8*f0^2*f7*x[2]*x[3]^3 +
(-16*f0^2*f8 - 16*f0*f1*f7 - 8*f0*f2*f6 + 10*f0*f3*f5)*x[2]*x[3]^2*x[4] +
(-16*f0^2*f8 - 8*f0*f1*f7 - 8*f0*f2*f6 + 8*f0*f3*f5)*x[2]*x[3]^2*x[5] +
(8*f0*f1*f8 - 4*f0*f2*f7 - 4*f0*f3*f6 + 8*f0*f4*f5 + 8*f1^2*f7 + 4*f1*f2*f6 -
3*f1*f3*f5)*x[2]*x[3]^2*x[6] + (8*f0*f2*f8 + 12*f0*f3*f7 - 8*f0*f4*f6 -
2*f0*f5^2 - 6*f1^2*f8 - 6*f1*f2*f7 + 2*f1*f4*f5)*x[2]*x[3]^2*x[7] +
4*f0*f4*x[2]*x[3]^2*x[8] + (4*f0*f1*f8 - 8*f0*f2*f7 - 4*f0*f4*f5 + 8*f1^2*f7 +
4*f1*f2*f6 - 6*f1*f3*f5)*x[2]*x[3]*x[4]^2 + (20*f0*f1*f8 + 20*f0*f2*f7 +
4*f1*f2*f6 - 6*f1*f3*f5)*x[2]*x[3]*x[4]*x[5] + (14*f0*f3*f7 + 8*f0*f4*f6 -
4*f0*f5^2 - 4*f1^2*f8 - 12*f1*f2*f7 + 6*f1*f3*f6 - 8*f1*f4*f5 - 8*f2^2*f6 +
8*f2*f3*f5)*x[2]*x[3]*x[4]*x[6] + (-4*f0*f3*f8 + 4*f0*f5*f6 + 4*f1*f2*f8 -
12*f1*f3*f7 + 4*f1*f4*f6 + 2*f1*f5^2 + 12*f2^2*f7 - 4*f2*f4*f5 -
2*f3^2*f5)*x[2]*x[3]*x[4]*x[7] + (-2*f0*f5 - 2*f1*f4 +
2*f2*f3)*x[2]*x[3]*x[4]*x[8] + (8*f0*f1*f8 + 2*f1^2*f7)*x[2]*x[3]*x[5]^2 +
(-8*f0*f4*f6 - 4*f0*f5^2 - 10*f1^2*f8 - 6*f1*f2*f7)*x[2]*x[3]*x[5]*x[6] +
(-12*f0*f3*f8 - 4*f0*f4*f7 + 12*f0*f5*f6 + 8*f1*f2*f8 + 6*f1*f3*f7 + 4*f1*f4*f6
- 2*f1*f5^2)*x[2]*x[3]*x[5]*x[7] + (-4*f0*f5 - 4*f1*f4)*x[2]*x[3]*x[5]*x[8] +
(-8*f0*f3*f8 - 8*f0*f4*f7 + 4*f0*f5*f6 + 4*f1*f2*f8 + 4*f1*f5^2 +
4*f2^2*f7)*x[2]*x[3]*x[6]^2 + (8*f0*f4*f8 + 4*f0*f5*f7 - 8*f0*f6^2 + 4*f1*f3*f8
+ 6*f1*f4*f7 - 8*f1*f5*f6 - 8*f2^2*f8 - 8*f2*f3*f7)*x[2]*x[3]*x[6]*x[7] +
(6*f1*f5 + 4*f2*f4 - 2*f3^2)*x[2]*x[3]*x[6]*x[8] + (-4*f0*f6*f7 - 4*f1*f4*f8 +
4*f1*f6^2 + 4*f2*f3*f8 + 4*f3^2*f7)*x[2]*x[3]*x[7]^2 + (6*f0*f7 -
6*f1*f6)*x[2]*x[3]*x[7]*x[8] + 2*f1*x[2]*x[3]*x[8]^2 + 4*f1*f4*f5*x[2]*x[4]^3 +
(-2*f0*f3*f7 - 4*f1^2*f8 - 4*f1*f2*f7 - 2*f1*f3*f6 + 4*f1*f4*f5 +
2*f2*f3*f5)*x[2]*x[4]^2*x[5] + (4*f0*f3*f8 - 8*f0*f4*f7 + 4*f0*f5*f6 +
4*f1*f3*f7 - 8*f1*f4*f6 + 4*f2*f3*f6 - 5*f3^2*f5)*x[2]*x[4]^2*x[6] +
(-8*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8 + 4*f1*f4*f7 - 2*f1*f5*f6 - 2*f2*f3*f7 +
6*f3*f4*f5)*x[2]*x[4]^2*x[7] - 4*f2*f4*x[2]*x[4]^2*x[8] + (-16*f0*f2*f8 +
2*f0*f3*f7 - 8*f0*f4*f6 + 4*f0*f5^2 + 2*f1^2*f8 - 2*f1*f2*f7 +
2*f1*f3*f6)*x[2]*x[4]*x[5]^2 + (-4*f0*f3*f8 - 4*f0*f4*f7 + 4*f0*f5*f6 +
12*f1*f2*f8 + 8*f1*f4*f6 - 4*f1*f5^2 + 4*f2^2*f7 -
4*f2*f3*f6)*x[2]*x[4]*x[5]*x[6] + (-8*f0*f4*f8 + 8*f0*f5*f7 - 8*f0*f6^2 +
8*f1*f3*f8 - 4*f1*f4*f7 - 2*f1*f5*f6 - 8*f2^2*f8 - 2*f2*f3*f7 - 8*f2*f4*f6 +
4*f2*f5^2 + 4*f3^2*f6)*x[2]*x[4]*x[5]*x[7] + (8*f0*f6 - 2*f1*f5 + 4*f2*f4 -
2*f3^2)*x[2]*x[4]*x[5]*x[8] + (8*f0*f4*f8 + 8*f0*f5*f7 - 8*f0*f6^2 - 4*f1*f3*f8
+ 4*f1*f4*f7 - 4*f2*f3*f7 + 2*f3^2*f6)*x[2]*x[4]*x[6]^2 + (-4*f0*f5*f8 +
4*f0*f6*f7 - 12*f1*f5*f7 + 12*f1*f6^2 + 4*f2*f3*f8 + 4*f2*f4*f7 + 2*f3^2*f7 -
4*f3*f4*f6 - 2*f3*f5^2)*x[2]*x[4]*x[6]*x[7] + (4*f0*f7 - 4*f1*f6 +
4*f3*f4)*x[2]*x[4]*x[6]*x[8] + (-8*f0*f6*f8 + 4*f0*f7^2 + 6*f1*f5*f8 -
4*f1*f6*f7 - 8*f2*f4*f8 + 6*f2*f5*f7 - 8*f2*f6^2 - 4*f3*f4*f7 +
6*f3*f5*f6)*x[2]*x[4]*x[7]^2 + (8*f0*f8 + 12*f2*f6 -
10*f3*f5)*x[2]*x[4]*x[7]*x[8] - 2*f1^2*f8*x[2]*x[5]^3 + (8*f0*f4*f7 + 8*f1*f2*f8
- f1*f3*f7)*x[2]*x[5]^2*x[6] + (8*f0*f4*f8 - 6*f0*f5*f7 - 6*f1*f3*f8 -
2*f1*f4*f7)*x[2]*x[5]^2*x[7] + 2*f1*f5*x[2]*x[5]^2*x[8] + (8*f0*f4*f8 -
4*f0*f5*f7 - 2*f1*f3*f8 - 4*f1*f4*f7 - 8*f2^2*f8 + 2*f2*f3*f7)*x[2]*x[5]*x[6]^2
+ (-12*f0*f5*f8 + 8*f0*f6*f7 - 4*f1*f4*f8 + 6*f1*f5*f7 + 12*f2*f3*f8 +
4*f2*f4*f7 - 2*f3^2*f7)*x[2]*x[5]*x[6]*x[7] + (-2*f0*f7 - 2*f1*f6 -
4*f2*f5)*x[2]*x[5]*x[6]*x[8] + (16*f0*f6*f8 - 6*f0*f7^2 - 2*f1*f5*f8 -
2*f1*f6*f7 - 2*f2*f5*f7 - 4*f3^2*f8)*x[2]*x[5]*x[7]^2 + (-8*f0*f8 + 4*f1*f7 +
4*f2*f6)*x[2]*x[5]*x[7]*x[8] - 2*f2*x[2]*x[5]*x[8]^2 + (-8*f0*f5*f8 + 4*f0*f6*f7
+ 4*f2*f3*f8 - f3^2*f7)*x[2]*x[6]^3 + (8*f0*f6*f8 - 6*f0*f7^2 + 12*f1*f5*f8 -
6*f1*f6*f7 - 8*f2*f4*f8 - 2*f3^2*f8 + 2*f3*f4*f7)*x[2]*x[6]^2*x[7] + (-8*f0*f8 +
2*f3*f5)*x[2]*x[6]^2*x[8] + (-12*f1*f6*f8 + 8*f1*f7^2 + 4*f2*f6*f7 + 4*f3*f4*f8
- 3*f3*f5*f7)*x[2]*x[6]*x[7]^2 + (6*f1*f8 - 6*f2*f7)*x[2]*x[6]*x[7]*x[8] -
f3*x[2]*x[6]*x[8]^2 + (-2*f1*f7*f8 - 2*f2*f7^2 + 2*f3*f5*f8)*x[2]*x[7]^3 +
2*f3*f7*x[2]*x[7]^2*x[8] + (4*f0*f2*f6 - 4*f0*f3*f5)*x[3]^4 + (4*f0*f1*f8 -
4*f1*f2*f6 + 4*f1*f3*f5)*x[3]^3*x[4] + 4*f0*f1*f8*x[3]^3*x[5] + (4*f0*f3*f7 -
2*f0*f5^2 - 2*f1^2*f8 - 2*f1*f2*f7)*x[3]^3*x[6] + (-8*f0*f3*f8 + 4*f0*f5*f6 +
4*f1*f2*f8 - f1*f5^2)*x[3]^3*x[7] - 2*f0*f5*x[3]^3*x[8] + (8*f0*f2*f8 - f0*f5^2
- 4*f1^2*f8 + 4*f2^2*f6 - 4*f2*f3*f5)*x[3]^2*x[4]^2 + (-8*f0*f2*f8 - 4*f0*f3*f7
+ 2*f0*f5^2 - 2*f1^2*f8 + 2*f1*f2*f7)*x[3]^2*x[4]*x[5] + (-4*f0*f3*f8 -
16*f0*f4*f7 + 4*f0*f5*f6 + 4*f1*f2*f8 - 4*f1*f3*f7 + 2*f1*f5^2 +
4*f2^2*f7)*x[3]^2*x[4]*x[6] + (8*f0*f4*f8 - 4*f0*f5*f7 + 8*f1*f3*f8 + 4*f1*f4*f7
- 4*f1*f5*f6 - 8*f2^2*f8 + 2*f2*f5^2)*x[3]^2*x[4]*x[7] +
2*f1*f5*x[3]^2*x[4]*x[8] - f1^2*f8*x[3]^2*x[5]^2 + (-4*f0*f3*f8 + 4*f0*f5*f6 +
4*f1*f2*f8 + 2*f1*f3*f7)*x[3]^2*x[5]*x[6] + (8*f0*f4*f8 - 2*f0*f5*f7 - 8*f0*f6^2
- 4*f1*f3*f8 - 4*f1*f4*f7 + 2*f1*f5*f6)*x[3]^2*x[5]*x[7] + (4*f0*f6 +
f1*f5)*x[3]^2*x[5]*x[8] + (12*f0*f4*f8 + 4*f1*f4*f7 - 4*f1*f5*f6 -
4*f2*f3*f7)*x[3]^2*x[6]^2 + (-8*f0*f5*f8 + 4*f0*f6*f7 - 8*f1*f4*f8 + 4*f1*f6^2 +
4*f2*f3*f8 + 4*f3^2*f7)*x[3]^2*x[6]*x[7] + (2*f0*f7 - 2*f1*f6 -
2*f2*f5)*x[3]^2*x[6]*x[8] + (4*f0*f6*f8 + 4*f2*f4*f8 - 4*f3^2*f8 -
4*f3*f4*f7)*x[3]^2*x[7]^2 + (-8*f0*f8 + 2*f3*f5)*x[3]^2*x[7]*x[8] -
f2*x[3]^2*x[8]^2 + (-4*f0*f3*f8 + 8*f0*f4*f7 - 4*f2*f3*f6 +
4*f3^2*f5)*x[3]*x[4]^3 + (4*f1*f2*f8 + 4*f1*f3*f7 - 2*f1*f5^2 -
4*f2^2*f7)*x[3]*x[4]^2*x[5] + (-8*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8 +
12*f1*f4*f7 - 2*f1*f5*f6 - 2*f2*f3*f7)*x[3]*x[4]^2*x[6] + (4*f0*f5*f8 -
8*f1*f4*f8 + 4*f1*f5*f7 + 4*f2*f3*f8 - 8*f2*f4*f7 + 4*f2*f5*f6 -
5*f3*f5^2)*x[3]*x[4]^2*x[7] + (4*f0*f3*f8 + 8*f0*f4*f7 - 4*f0*f5*f6 -
2*f1*f3*f7)*x[3]*x[4]*x[5]^2 + (24*f0*f4*f8 + 2*f0*f5*f7 - 8*f0*f6^2 +
2*f1*f3*f8 - 8*f1*f4*f7 + 4*f1*f5*f6 - 8*f2^2*f8 +
4*f2*f3*f7)*x[3]*x[4]*x[5]*x[6] + (-4*f0*f5*f8 + 12*f0*f6*f7 - 4*f1*f4*f8 +
4*f1*f6^2 + 4*f2*f3*f8 + 8*f2*f4*f7 - 4*f2*f5*f6 -
4*f3^2*f7)*x[3]*x[4]*x[5]*x[7] + (-6*f0*f7 - 2*f1*f6)*x[3]*x[4]*x[5]*x[8] +
(-4*f0*f5*f8 + 4*f0*f6*f7 - 16*f1*f4*f8 - 4*f1*f5*f7 + 4*f1*f6^2 + 4*f2*f3*f8 +
2*f3^2*f7)*x[3]*x[4]*x[6]^2 + (-4*f0*f7^2 + 14*f1*f5*f8 - 12*f1*f6*f7 +
8*f2*f4*f8 + 6*f2*f5*f7 - 8*f2*f6^2 - 4*f3^2*f8 - 8*f3*f4*f7 +
8*f3*f5*f6)*x[3]*x[4]*x[6]*x[7] + (4*f2*f6 - 2*f3*f5)*x[3]*x[4]*x[6]*x[8] +
(-4*f0*f7*f8 - 8*f2*f5*f8 + 4*f2*f6*f7 + 8*f3*f4*f8 + 8*f4^2*f7 - 8*f4*f5*f6 +
2*f5^3)*x[3]*x[4]*x[7]^2 + (4*f1*f8 - 4*f2*f7 + 4*f4*f5)*x[3]*x[4]*x[7]*x[8] +
(-8*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8)*x[3]*x[5]^2*x[6] + (8*f0*f6*f7 +
8*f1*f4*f8 - f1*f5*f7)*x[3]*x[5]^2*x[7] + (-2*f0*f7 - 2*f1*f6)*x[3]*x[5]^2*x[8]
+ (-4*f0*f5*f8 + 4*f0*f6*f7 + 2*f1*f5*f7 + 4*f2*f3*f8)*x[3]*x[5]*x[6]^2 +
(-10*f0*f7^2 - 6*f1*f6*f7 - 8*f2*f4*f8 - 4*f3^2*f8)*x[3]*x[5]*x[6]*x[7] +
(4*f1*f7 + 4*f2*f6)*x[3]*x[5]*x[6]*x[8] + (4*f0*f7*f8 + 8*f3*f4*f8 +
2*f3*f5*f7)*x[3]*x[5]*x[7]^2 + (-2*f1*f8 - 2*f2*f7 -
4*f3*f6)*x[3]*x[5]*x[7]*x[8] + 2*f3*x[3]*x[5]*x[8]^2 + (-2*f0*f7^2 + 4*f1*f5*f8
- 2*f1*f6*f7 - 2*f3^2*f8)*x[3]*x[6]^3 + (8*f0*f7*f8 - 4*f1*f6*f8 + 8*f1*f7^2 -
4*f2*f5*f8 + 4*f2*f6*f7 + 8*f3*f4*f8 - 3*f3*f5*f7)*x[3]*x[6]^2*x[7] + (2*f1*f8 -
2*f2*f7 - 2*f3*f6)*x[3]*x[6]^2*x[8] + (-6*f1*f7*f8 + 8*f2*f6*f8 - 6*f2*f7^2 -
6*f3*f5*f8 - 8*f4^2*f8 + 2*f4*f5*f7)*x[3]*x[6]*x[7]^2 + (6*f3*f7 + 4*f4*f6 -
2*f5^2)*x[3]*x[6]*x[7]*x[8] - 2*f4*x[3]*x[6]*x[8]^2 + (4*f2*f7*f8 + 4*f4*f5*f8 -
f5^2*f7)*x[3]*x[7]^3 + (-4*f3*f8 - 4*f4*f7 + 2*f5*f6)*x[3]*x[7]^2*x[8] -
f5*x[3]*x[7]*x[8]^2 + (4*f0*f4*f8 - 4*f1*f4*f7 + 4*f2*f4*f6 - 4*f3*f4*f5)*x[4]^4
+ (-2*f0*f5*f7 - 2*f1*f3*f8 - 4*f1*f4*f7 + 2*f1*f5*f6 + 2*f2*f3*f7)*x[4]^3*x[5]
+ (-4*f0*f5*f8 + 8*f1*f4*f8 - 4*f2*f5*f6 + 4*f3*f5^2)*x[4]^3*x[6] +
4*f3*f4*f7*x[4]^3*x[7] + (-4*f0*f8 - 4*f2*f6 + 4*f3*f5)*x[4]^3*x[8] +
(-4*f0*f5*f7 + 4*f0*f6^2 - 4*f1*f3*f8 + 4*f2^2*f8)*x[4]^2*x[5]^2 + (4*f0*f6*f7 +
4*f1*f5*f7 - 4*f1*f6^2 - 2*f3^2*f7)*x[4]^2*x[5]*x[6] + (-4*f0*f7^2 - 2*f1*f5*f8
- 4*f1*f6*f7 - 2*f2*f5*f7 + 4*f3*f4*f7 + 2*f3*f5*f6)*x[4]^2*x[5]*x[7] + (4*f1*f7
- f3*f5)*x[4]^2*x[5]*x[8] + (8*f0*f6*f8 - 4*f0*f7^2 + 4*f2*f6^2 - f3^2*f8 -
4*f3*f5*f6)*x[4]^2*x[6]^2 + (4*f0*f7*f8 - 8*f1*f6*f8 + 8*f1*f7^2 + 4*f2*f6*f7 -
4*f3*f4*f8 - 6*f3*f5*f7)*x[4]^2*x[6]*x[7] + (4*f0*f8^2 + 8*f2*f6*f8 - 4*f2*f7^2
- 4*f3*f5*f8 - 4*f4^2*f8 + 4*f4*f6^2 - f5^2*f6)*x[4]^2*x[7]^2 -
4*f4*f6*x[4]^2*x[7]*x[8] + f4*x[4]^2*x[8]^2 + (-8*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8)*x[4]*x[5]^3 + (4*f0*f5*f8 + 8*f1*f4*f8 - 2*f1*f5*f7 -
4*f2*f3*f8)*x[4]*x[5]^2*x[6] + (-16*f0*f6*f8 + 2*f0*f7^2 + 2*f1*f5*f8 -
2*f1*f6*f7 - 8*f2*f4*f8 + 2*f2*f5*f7 + 4*f3^2*f8)*x[4]*x[5]^2*x[7] +
4*f0*f8*x[4]*x[5]^2*x[8] + (-8*f0*f6*f8 - 2*f0*f7^2 - 4*f1*f5*f8 + 2*f1*f6*f7 +
2*f3^2*f8)*x[4]*x[5]*x[6]^2 + (20*f0*f7*f8 + 20*f1*f6*f8 + 4*f2*f6*f7 -
6*f3*f5*f7)*x[4]*x[5]*x[6]*x[7] + (-6*f1*f8 - 2*f2*f7)*x[4]*x[5]*x[6]*x[8] +
(-8*f0*f8^2 - 2*f1*f7*f8 - 8*f2*f6*f8 + 2*f2*f7^2 + 2*f3*f5*f8 - 8*f4^2*f8 +
2*f4*f5*f7)*x[4]*x[5]*x[7]^2 + (8*f2*f8 - 2*f3*f7 + 4*f4*f6 -
2*f5^2)*x[4]*x[5]*x[7]*x[8] - 2*f4*x[4]*x[5]*x[8]^2 + (4*f0*f7*f8 - 4*f2*f6*f7 +
4*f3*f5*f7)*x[4]*x[6]^3 + (-16*f0*f8^2 - 16*f1*f7*f8 - 8*f2*f6*f8 +
10*f3*f5*f8)*x[4]*x[6]^2*x[7] + 2*f3*f7*x[4]*x[6]^2*x[8] + (16*f1*f8^2 +
8*f2*f7*f8 + 4*f4*f5*f8 - 4*f4*f6*f7)*x[4]*x[6]*x[7]^2 + (-2*f3*f8 - 2*f4*f7 +
2*f5*f6)*x[4]*x[6]*x[7]*x[8] + (-8*f2*f8^2 - 8*f4*f6*f8 + 4*f4*f7^2 +
2*f5^2*f8)*x[4]*x[7]^3 + (8*f4*f8 - 2*f5*f7)*x[4]*x[7]^2*x[8] -
2*f0*f7^2*x[5]^3*x[7] + f1*f7*x[5]^3*x[8] - f0*f7^2*x[5]^2*x[6]^2 + (8*f0*f7*f8
+ 2*f1*f7^2)*x[5]^2*x[6]*x[7] + (-2*f1*f8 - 2*f2*f7)*x[5]^2*x[6]*x[8] +
(4*f0*f8^2 + 4*f2*f6*f8 - f2*f7^2 - 4*f3*f5*f8)*x[5]^2*x[7]^2 +
2*f3*f7*x[5]^2*x[7]*x[8] + 4*f0*f7*f8*x[5]*x[6]^3 + (-16*f0*f8^2 - 8*f1*f7*f8 -
8*f2*f6*f8 + 8*f3*f5*f8)*x[5]*x[6]^2*x[7] + (4*f2*f8 + f3*f7)*x[5]*x[6]^2*x[8] +
4*f2*f7*f8*x[5]*x[6]*x[7]^2 + (-4*f3*f8 - 4*f4*f7)*x[5]*x[6]*x[7]*x[8] +
2*f5*x[5]*x[6]*x[8]^2 + (4*f4*f8 + f5*f7)*x[5]*x[7]^2*x[8] -
2*f6*x[5]*x[7]*x[8]^2 + x[5]*x[8]^3 + (4*f2*f6*f8 - 4*f3*f5*f8)*x[6]^4 +
8*f1*f8^2*x[6]^3*x[7] - 2*f3*f8*x[6]^3*x[8] + (-4*f2*f8^2 +
f4*f7^2)*x[6]^2*x[7]^2 + 4*f4*f8*x[6]^2*x[7]*x[8] - f6*x[6]^2*x[8]^2 -
4*f4*f7*f8*x[6]*x[7]^3 - 2*f5*f8*x[6]*x[7]^2*x[8] + 2*f7*x[6]*x[7]*x[8]^2 +
4*f4*f8^2*x[7]^4 - f8*x[7]^2*x[8]^2,

// number 6
(-64*f0^3*f3*f8^3 + 64*f0^3*f4*f7*f8^2 - 64*f0^3*f5*f6*f8^2 - 16*f0^3*f5*f7^2*f8
+ 64*f0^3*f6^2*f7*f8 - 16*f0^3*f6*f7^3 + 64*f0^2*f1*f2*f8^3 -
16*f0^2*f1*f3*f7*f8^2 + 32*f0^2*f1*f5^2*f8^2 - 32*f0^2*f1*f5*f6*f7*f8 +
8*f0^2*f1*f5*f7^3 + 64*f0^2*f2*f4*f6*f7*f8 - 16*f0^2*f2*f4*f7^3 -
16*f0^2*f2*f5^2*f7*f8 - 64*f0^2*f3^2*f5*f8^2 + 48*f0^2*f3^2*f6*f7*f8 -
12*f0^2*f3^2*f7^3 + 64*f0^2*f3*f4^2*f8^2 - 32*f0^2*f3*f4*f5*f7*f8 +
4*f0^2*f3*f5^2*f7^2 - 16*f0*f1^3*f8^3 - 16*f0*f1^2*f4*f5*f8^2 +
4*f0*f1^2*f5^2*f7*f8 + 96*f0*f1*f2*f3*f5*f8^2 - 96*f0*f1*f2*f3*f6*f7*f8 +
24*f0*f1*f2*f3*f7^3 - 64*f0*f1*f2*f4^2*f8^2 + 32*f0*f1*f2*f4*f5*f7*f8 -
4*f0*f1*f2*f5^2*f7^2 - 16*f0*f1*f3^2*f4*f8^2 + 4*f0*f1*f3^2*f5*f7*f8 -
64*f0*f2^3*f5*f8^2 + 64*f0*f2^3*f6*f7*f8 - 16*f0*f2^3*f7^3 +
64*f0*f2^2*f3*f4*f8^2 - 16*f0*f2^2*f3*f5*f7*f8 - 16*f0*f2*f3^3*f8^2 -
16*f1^3*f3*f5*f8^2 + 16*f1^3*f3*f6*f7*f8 - 4*f1^3*f3*f7^3 + 16*f1^3*f4^2*f8^2 -
8*f1^3*f4*f5*f7*f8 + f1^3*f5^2*f7^2 + 16*f1^2*f2^2*f5*f8^2 -
16*f1^2*f2^2*f6*f7*f8 + 4*f1^2*f2^2*f7^3 - 16*f1^2*f2*f3*f4*f8^2 +
4*f1^2*f2*f3*f5*f7*f8 + 4*f1^2*f3^3*f8^2)*x[1]^4 + (96*f0^3*f5*f8^2 -
128*f0^3*f6*f7*f8 + 32*f0^3*f7^3 - 32*f0^2*f1*f4*f8^2 + 24*f0^2*f1*f5*f7*f8 -
64*f0^2*f2*f4*f7*f8 + 16*f0^2*f2*f5*f7^2 - 16*f0^2*f3^2*f7*f8 -
64*f0^2*f3*f4*f6*f8 + 32*f0^2*f3*f4*f7^2 + 32*f0^2*f3*f5^2*f8 -
16*f0^2*f3*f5*f6*f7 + 8*f0*f1^2*f3*f8^2 + 8*f0*f1^2*f4*f7*f8 - 4*f0*f1^2*f5*f7^2
+ 48*f0*f1*f2*f3*f7*f8 + 64*f0*f1*f2*f4*f6*f8 - 32*f0*f1*f2*f4*f7^2 -
32*f0*f1*f2*f5^2*f8 + 16*f0*f1*f2*f5*f6*f7 + 8*f0*f1*f3^2*f6*f8 -
4*f0*f1*f3^2*f7^2 - 32*f0*f2^3*f7*f8 - 32*f0*f2^2*f3*f6*f8 + 16*f0*f2^2*f3*f7^2
+ 8*f0*f2*f3^2*f5*f8 - 8*f1^3*f3*f7*f8 - 16*f1^3*f4*f6*f8 + 8*f1^3*f4*f7^2 +
8*f1^3*f5^2*f8 - 4*f1^3*f5*f6*f7 + 8*f1^2*f2^2*f7*f8 + 8*f1^2*f2*f3*f6*f8 -
4*f1^2*f2*f3*f7^2 - 2*f1^2*f3^2*f5*f8)*x[1]^3*x[2] + (64*f0^3*f6*f8^2 -
80*f0^2*f1*f5*f8^2 + 48*f0^2*f1*f6*f7*f8 - 16*f0^2*f1*f7^3 - 64*f0^2*f2*f4*f8^2
+ 48*f0^2*f2*f5*f7*f8 + 96*f0^2*f3^2*f8^2 - 8*f0^2*f3*f5*f7^2 +
48*f0*f1^2*f4*f8^2 - 16*f0*f1^2*f5*f7*f8 - 112*f0*f1*f2*f3*f8^2 +
16*f0*f1*f3*f4*f6*f8 - 8*f0*f1*f3*f4*f7^2 - 8*f0*f1*f3*f5^2*f8 +
4*f0*f1*f3*f5*f6*f7 + 64*f0*f2^3*f8^2 - 64*f0*f2^2*f4*f6*f8 + 32*f0*f2^2*f4*f7^2
+ 32*f0*f2^2*f5^2*f8 - 16*f0*f2^2*f5*f6*f7 + 32*f0*f2*f3^2*f6*f8 -
16*f0*f2*f3^2*f7^2 - 16*f0*f2*f3*f4*f5*f8 + 4*f0*f2*f3*f5^2*f7 + 16*f1^3*f3*f8^2
- 16*f1^2*f2^2*f8^2 + 16*f1^2*f2*f4*f6*f8 - 8*f1^2*f2*f4*f7^2 -
8*f1^2*f2*f5^2*f8 + 4*f1^2*f2*f5*f6*f7 - 8*f1^2*f3^2*f6*f8 + 4*f1^2*f3^2*f7^2 +
4*f1^2*f3*f4*f5*f8 - f1^2*f3*f5^2*f7)*x[1]^3*x[3] + (-32*f0^3*f7*f8^2 -
96*f0^2*f2*f5*f8^2 + 96*f0^2*f2*f6*f7*f8 - 32*f0^2*f2*f7^3 - 32*f0^2*f3*f4*f8^2
- 32*f0^2*f3*f6^2*f8 + 16*f0^2*f3*f6*f7^2 + 32*f0^2*f4*f5*f6*f8 -
16*f0^2*f4*f5*f7^2 - 16*f0^2*f5^3*f8 + 8*f0^2*f5^2*f6*f7 + 48*f0*f1^2*f5*f8^2 -
48*f0*f1^2*f6*f7*f8 + 16*f0*f1^2*f7^3 + 96*f0*f1*f2*f4*f8^2 -
24*f0*f1*f2*f5*f7*f8 - 16*f0*f1*f3^2*f8^2 + 8*f0*f1*f3*f5*f6*f8 -
32*f0*f1*f4^2*f6*f8 + 16*f0*f1*f4^2*f7^2 + 16*f0*f1*f4*f5^2*f8 -
8*f0*f1*f4*f5*f6*f7 - 32*f0*f2^2*f3*f8^2 + 32*f0*f2*f3*f4*f6*f8 -
16*f0*f2*f3*f4*f7^2 - 16*f0*f2*f3*f5^2*f8 + 8*f0*f2*f3*f5*f6*f7 -
16*f0*f3^3*f6*f8 + 8*f0*f3^3*f7^2 + 8*f0*f3^2*f4*f5*f8 - 2*f0*f3^2*f5^2*f7 -
32*f1^3*f4*f8^2 + 8*f1^3*f5*f7*f8 + 16*f1^2*f2*f3*f8^2)*x[1]^3*x[4] +
(-32*f0^3*f7*f8^2 + 8*f0^2*f1*f7^2*f8 + 64*f0^2*f2*f5*f8^2 -
128*f0^2*f2*f6*f7*f8 + 32*f0^2*f2*f7^3 - 96*f0^2*f3*f4*f8^2 +
40*f0^2*f3*f5*f7*f8 - 16*f0*f1^2*f5*f8^2 + 32*f0*f1^2*f6*f7*f8 - 8*f0*f1^2*f7^3
+ 64*f0*f1*f2*f4*f8^2 - 16*f0*f1*f2*f5*f7*f8 + 16*f0*f1*f3^2*f8^2 +
8*f0*f1*f3*f4*f7*f8 - 2*f0*f1*f3*f5*f7^2 - 32*f0*f2^2*f3*f8^2 -
32*f0*f2^2*f4*f7*f8 + 8*f0*f2^2*f5*f7^2 + 16*f0*f2*f3^2*f7*f8 - 16*f1^3*f4*f8^2
+ 4*f1^3*f5*f7*f8 + 8*f1^2*f2*f3*f8^2 + 8*f1^2*f2*f4*f7*f8 - 2*f1^2*f2*f5*f7^2 -
4*f1^2*f3^2*f7*f8)*x[1]^3*x[5] + (64*f0^3*f8^3 + 16*f0^2*f2*f7^2*f8 +
128*f0^2*f3*f5*f8^2 - 112*f0^2*f3*f6*f7*f8 + 24*f0^2*f3*f7^3 - 64*f0^2*f4^2*f8^2
+ 48*f0^2*f4*f5*f7*f8 - 8*f0^2*f5^2*f7^2 - 8*f0*f1^2*f7^2*f8 -
128*f0*f1*f2*f5*f8^2 + 128*f0*f1*f2*f6*f7*f8 - 32*f0*f1*f2*f7^3 +
32*f0*f1*f3*f4*f8^2 - 12*f0*f1*f3*f5*f7*f8 - 16*f0*f1*f4^2*f7*f8 +
4*f0*f1*f4*f5*f7^2 + 16*f0*f2*f3^2*f8^2 + 16*f0*f2*f3*f4*f7*f8 -
4*f0*f2*f3*f5*f7^2 - 8*f0*f3^3*f7*f8 + 32*f1^3*f5*f8^2 - 32*f1^3*f6*f7*f8 +
8*f1^3*f7^3 - 8*f1^2*f3^2*f8^2)*x[1]^3*x[6] + (-32*f0^2*f1*f8^3 -
32*f0^2*f2*f7*f8^2 + 32*f0^2*f3*f6*f8^2 - 32*f0^2*f4*f5*f8^2 -
64*f0^2*f4*f6*f7*f8 + 16*f0^2*f4*f7^3 + 24*f0^2*f5^2*f7*f8 + 16*f0*f1^2*f7*f8^2
- 56*f0*f1*f3*f5*f8^2 + 64*f0*f1*f3*f6*f7*f8 - 16*f0*f1*f3*f7^3 +
64*f0*f1*f4^2*f8^2 - 24*f0*f1*f4*f5*f7*f8 + 2*f0*f1*f5^2*f7^2 +
128*f0*f2^2*f5*f8^2 - 128*f0*f2^2*f6*f7*f8 + 32*f0*f2^2*f7^3 -
128*f0*f2*f3*f4*f8^2 + 32*f0*f2*f3*f5*f7*f8 + 32*f0*f3^3*f8^2 -
32*f1^2*f2*f5*f8^2 + 32*f1^2*f2*f6*f7*f8 - 8*f1^2*f2*f7^3 + 16*f1^2*f3*f4*f8^2 -
4*f1^2*f3*f5*f7*f8)*x[1]^3*x[7] + (32*f0^2*f3*f8^2 + 16*f0^2*f4*f7*f8 -
4*f0^2*f5*f7^2 - 32*f0*f1*f2*f8^2 - 8*f0*f1*f3*f7*f8 + 16*f0*f2^2*f7*f8 +
16*f0*f2*f3*f6*f8 - 8*f0*f2*f3*f7^2 - 4*f0*f3^2*f5*f8 + 8*f1^3*f8^2 -
4*f1^2*f2*f7*f8 - 4*f1^2*f3*f6*f8 + 2*f1^2*f3*f7^2)*x[1]^3*x[8] + (32*f0^3*f7*f8
+ 16*f0^2*f1*f6*f8 - 8*f0^2*f1*f7^2 - 16*f0^2*f2*f6*f7 + 32*f0^2*f3*f4*f8 -
8*f0^2*f3*f5*f7 + 16*f0^2*f3*f6^2 + 4*f0*f1^2*f6*f7 - 32*f0*f1*f2*f4*f8 +
8*f0*f1*f2*f5*f7 - 16*f0*f1*f2*f6^2 - 4*f0*f1*f3^2*f8 + 16*f0*f2^2*f3*f8 -
4*f0*f2*f3^2*f7 + 8*f1^3*f4*f8 - 2*f1^3*f5*f7 + 4*f1^3*f6^2 - 4*f1^2*f2*f3*f8 +
f1^2*f3^2*f7)*x[1]^2*x[2]^2 + (-64*f0^3*f8^2 - 8*f0^2*f1*f7*f8 +
32*f0^2*f2*f6*f8 - 32*f0^2*f2*f7^2 - 48*f0^2*f3*f5*f8 + 16*f0^2*f3*f6*f7 -
24*f0*f1^2*f6*f8 + 16*f0*f1^2*f7^2 + 32*f0*f1*f2*f5*f8 - 8*f0*f1*f3*f4*f8 +
6*f0*f1*f3*f5*f7 - 8*f0*f1*f3*f6^2 + 32*f0*f2^2*f4*f8 - 24*f0*f2^2*f5*f7 +
32*f0*f2^2*f6^2 - 16*f0*f2*f3^2*f8 + 16*f0*f2*f3*f4*f7 - 8*f0*f2*f3*f5*f6 -
8*f1^3*f5*f8 - 8*f1^2*f2*f4*f8 + 6*f1^2*f2*f5*f7 - 8*f1^2*f2*f6^2 +
4*f1^2*f3^2*f8 - 4*f1^2*f3*f4*f7 + 2*f1^2*f3*f5*f6)*x[1]^2*x[2]*x[3] +
(16*f0^2*f1*f8^2 - 16*f0^2*f2*f7*f8 + 32*f0^2*f3*f6*f8 - 8*f0^2*f3*f7^2 +
8*f0^2*f5^2*f7 - 16*f0^2*f5*f6^2 + 8*f0*f1^2*f7*f8 - 32*f0*f1*f2*f6*f8 +
16*f0*f1*f2*f7^2 - 4*f0*f1*f3*f5*f8 - 8*f0*f1*f3*f6*f7 + 16*f0*f1*f4^2*f8 -
12*f0*f1*f4*f5*f7 + 16*f0*f1*f4*f6^2 - 16*f0*f2*f3*f4*f8 + 12*f0*f2*f3*f5*f7 -
16*f0*f2*f3*f6^2 + 8*f0*f3^3*f8 - 8*f0*f3^2*f4*f7 + 4*f0*f3^2*f5*f6 +
16*f1^3*f6*f8 - 8*f1^3*f7^2)*x[1]^2*x[2]*x[4] + (96*f0^2*f2*f7*f8 +
48*f0^2*f3*f6*f8 - 32*f0^2*f3*f7^2 - 28*f0*f1^2*f7*f8 - 32*f0*f1*f2*f6*f8 +
16*f0*f1*f2*f7^2 - 8*f0*f1*f3*f5*f8 + 4*f0*f1*f3*f6*f7 + 32*f0*f2^2*f5*f8 -
16*f0*f2^2*f6*f7 - 16*f0*f2*f3*f4*f8 - 4*f0*f2*f3*f5*f7 + 8*f1^3*f6*f8 -
4*f1^3*f7^2 - 8*f1^2*f2*f5*f8 + 4*f1^2*f2*f6*f7 + 4*f1^2*f3*f4*f8 +
f1^2*f3*f5*f7)*x[1]^2*x[2]*x[5] + (-32*f0^2*f2*f8^2 + 40*f0^2*f3*f7*f8 +
64*f0^2*f4*f6*f8 - 32*f0^2*f4*f7^2 - 48*f0^2*f5^2*f8 + 24*f0^2*f5*f6*f7 +
16*f0*f1^2*f8^2 - 56*f0*f1*f2*f7*f8 - 16*f0*f1*f3*f6*f8 + 12*f0*f1*f3*f7^2 +
16*f0*f1*f4*f5*f8 - 8*f0*f1*f4*f6*f7 - 16*f0*f2*f3*f5*f8 + 8*f0*f2*f3*f6*f7 +
8*f0*f3^2*f4*f8 + 2*f0*f3^2*f5*f7 + 16*f1^3*f7*f8)*x[1]^2*x[2]*x[6] +
(-32*f0^2*f3*f8^2 + 48*f0^2*f4*f7*f8 + 16*f0^2*f5*f6*f8 - 20*f0^2*f5*f7^2 +
16*f0*f1*f2*f8^2 - 32*f0*f1*f3*f7*f8 - 48*f0*f1*f4*f6*f8 + 24*f0*f1*f4*f7^2 +
16*f0*f1*f5^2*f8 - 8*f0*f1*f5*f6*f7 + 48*f0*f2^2*f7*f8 + 48*f0*f2*f3*f6*f8 -
24*f0*f2*f3*f7^2 - 12*f0*f3^2*f5*f8 - 8*f1^3*f8^2 - 12*f1^2*f2*f7*f8 -
4*f1^2*f3*f6*f8 + 2*f1^2*f3*f7^2)*x[1]^2*x[2]*x[7] + (-16*f0^2*f5*f8 +
8*f0^2*f6*f7 + 8*f0*f1*f4*f8 + 2*f0*f1*f5*f7 - 16*f0*f2*f3*f8 + 4*f0*f3^2*f7 +
2*f1^2*f3*f8)*x[1]^2*x[2]*x[8] + (32*f0^2*f1*f8^2 - 16*f0^2*f2*f7*f8 -
32*f0^2*f3*f6*f8 + 24*f0^2*f3*f7^2 + 16*f0^2*f4*f5*f8 - 16*f0^2*f4*f6*f7 +
16*f0*f1*f2*f6*f8 - 8*f0*f1*f2*f7^2 + 12*f0*f1*f3*f5*f8 - 32*f0*f2^2*f5*f8 +
16*f0*f2*f3*f5*f7 - 16*f0*f2*f3*f6^2 - 16*f0*f2*f4^2*f7 + 16*f0*f2*f4*f5*f6 -
4*f0*f2*f5^3 + 8*f1^2*f2*f5*f8 - 4*f1^2*f3*f5*f7 + 4*f1^2*f3*f6^2 +
4*f1^2*f4^2*f7 - 4*f1^2*f4*f5*f6 + f1^2*f5^3)*x[1]^2*x[3]^2 + (96*f0^2*f2*f8^2 -
16*f0^2*f3*f7*f8 - 64*f0^2*f4*f6*f8 + 48*f0^2*f4*f7^2 + 56*f0^2*f5^2*f8 -
64*f0^2*f5*f6*f7 + 32*f0^2*f6^3 - 48*f0*f1^2*f8^2 + 16*f0*f1*f2*f7*f8 +
48*f0*f1*f3*f6*f8 - 32*f0*f1*f3*f7^2 - 40*f0*f1*f4*f5*f8 + 16*f0*f1*f4*f6*f7 +
10*f0*f1*f5^2*f7 - 8*f0*f1*f5*f6^2 + 32*f0*f2*f3*f5*f8 - 16*f0*f3^2*f5*f7 +
16*f0*f3^2*f6^2 + 16*f0*f3*f4^2*f7 - 16*f0*f3*f4*f5*f6 + 4*f0*f3*f5^3 -
16*f1^2*f2*f6*f8 + 8*f1^2*f2*f7^2 - 4*f1^2*f3*f5*f8)*x[1]^2*x[3]*x[4] +
(-32*f0^2*f2*f8^2 - 32*f0^2*f3*f7*f8 + 32*f0^2*f4*f6*f8 - 16*f0^2*f5^2*f8 +
8*f0^2*f5*f6*f7 + 8*f0*f1^2*f8^2 + 8*f0*f1*f2*f7*f8 - 24*f0*f1*f3*f6*f8 +
12*f0*f1*f3*f7^2 + 32*f0*f2^2*f6*f8 - 16*f0*f2^2*f7^2 - 24*f0*f2*f3*f5*f8 +
16*f0*f2*f3*f6*f7 + 32*f0*f2*f4^2*f8 - 8*f0*f2*f4*f5*f7 - 8*f1^2*f2*f6*f8 +
4*f1^2*f2*f7^2 + 6*f1^2*f3*f5*f8 - 4*f1^2*f3*f6*f7 - 8*f1^2*f4^2*f8 +
2*f1^2*f4*f5*f7)*x[1]^2*x[3]*x[5] + (-96*f0^2*f3*f8^2 - 32*f0^2*f4*f7*f8 +
32*f0^2*f5*f6*f8 + 12*f0^2*f5*f7^2 - 16*f0^2*f6^2*f7 + 80*f0*f1*f2*f8^2 +
16*f0*f1*f3*f7*f8 - 32*f0*f1*f4*f6*f8 + 8*f0*f1*f4*f7^2 + 8*f0*f1*f5^2*f8 -
4*f0*f1*f5*f6*f7 - 16*f0*f2*f3*f6*f8 + 8*f0*f2*f3*f7^2 + 12*f0*f3^2*f5*f8 -
8*f0*f3^2*f6*f7 - 16*f0*f3*f4^2*f8 + 4*f0*f3*f4*f5*f7 - 24*f1^3*f8^2 -
4*f1^2*f2*f7*f8 + 12*f1^2*f3*f6*f8 - 6*f1^2*f3*f7^2)*x[1]^2*x[3]*x[6] +
(64*f0^2*f4*f8^2 - 40*f0^2*f5*f7*f8 - 32*f0^2*f6^2*f8 + 16*f0^2*f6*f7^2 +
32*f0*f1*f3*f8^2 + 8*f0*f1*f5*f6*f8 - 96*f0*f2^2*f8^2 + 96*f0*f2*f4*f6*f8 -
48*f0*f2*f4*f7^2 - 48*f0*f2*f5^2*f8 + 24*f0*f2*f5*f6*f7 - 48*f0*f3^2*f6*f8 +
24*f0*f3^2*f7^2 + 24*f0*f3*f4*f5*f8 - 6*f0*f3*f5^2*f7 + 32*f1^2*f2*f8^2 -
16*f1^2*f4*f6*f8 + 8*f1^2*f4*f7^2 + 8*f1^2*f5^2*f8 -
4*f1^2*f5*f6*f7)*x[1]^2*x[3]*x[7] + (8*f0^2*f7^2 - 16*f0*f2*f4*f8 +
12*f0*f2*f5*f7 - 16*f0*f2*f6^2 + 8*f0*f3^2*f8 - 8*f0*f3*f4*f7 + 4*f0*f3*f5*f6 +
4*f1^2*f4*f8 - 4*f1^2*f5*f7 + 4*f1^2*f6^2)*x[1]^2*x[3]*x[8] + (16*f0^2*f3*f8^2 -
16*f0^2*f4*f7*f8 - 16*f0^2*f5*f6*f8 + 8*f0^2*f5*f7^2 - 48*f0*f1*f2*f8^2 +
16*f0*f1*f3*f7*f8 + 48*f0*f1*f4*f6*f8 - 32*f0*f1*f4*f7^2 - 20*f0*f1*f5^2*f8 +
32*f0*f1*f5*f6*f7 - 16*f0*f1*f6^3 - 16*f0*f2^2*f7*f8 - 32*f0*f2*f3*f6*f8 +
24*f0*f2*f3*f7^2 - 16*f0*f2*f4*f6*f7 - 12*f0*f2*f5^2*f7 + 16*f0*f2*f5*f6^2 +
24*f0*f3*f4*f5*f7 - 16*f0*f3*f4*f6^2 - 4*f0*f3*f5^2*f6 - 16*f0*f4^3*f7 +
16*f0*f4^2*f5*f6 - 4*f0*f4*f5^3 + 16*f1^3*f8^2 - 16*f1^2*f3*f6*f8 +
8*f1^2*f3*f7^2 + 8*f1^2*f4*f5*f8 - 2*f1^2*f5^2*f7 + 16*f1*f2^2*f6*f8 -
8*f1*f2^2*f7^2 - 4*f1*f2*f3*f5*f8)*x[1]^2*x[4]^2 + (32*f0^2*f3*f8^2 -
32*f0^2*f4*f7*f8 + 16*f0^2*f5*f6*f8 + 20*f0^2*f5*f7^2 - 16*f0^2*f6^2*f7 -
32*f0*f1*f2*f8^2 + 24*f0*f1*f3*f7*f8 + 16*f0*f1*f4*f6*f8 - 16*f0*f1*f4*f7^2 -
8*f0*f1*f5^2*f8 + 4*f0*f1*f5*f6*f7 - 16*f0*f2*f3*f6*f8 + 8*f0*f2*f3*f7^2 +
12*f0*f3^2*f5*f8 - 8*f0*f3^2*f6*f7 - 16*f0*f3*f4^2*f8 + 4*f0*f3*f4*f5*f7 +
8*f1^3*f8^2 - 4*f1^2*f2*f7*f8 + 4*f1^2*f3*f6*f8 -
2*f1^2*f3*f7^2)*x[1]^2*x[4]*x[5] + (32*f0^2*f4*f8^2 - 24*f0*f1*f3*f8^2 +
40*f0*f1*f4*f7*f8 - 32*f0*f1*f5*f6*f8 - 12*f0*f1*f5*f7^2 + 16*f0*f1*f6^2*f7 +
32*f0*f2^2*f8^2 - 32*f0*f2*f3*f7*f8 - 32*f0*f2*f4*f6*f8 + 32*f0*f2*f4*f7^2 +
48*f0*f2*f5^2*f8 - 24*f0*f2*f5*f6*f7 + 40*f0*f3^2*f6*f8 - 20*f0*f3^2*f7^2 -
56*f0*f3*f4*f5*f8 + 16*f0*f3*f4*f6*f7 + 4*f0*f3*f5^2*f7 + 32*f0*f4^3*f8 -
8*f0*f4^2*f5*f7 - 8*f1^2*f3*f7*f8 + 16*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 -
8*f1^2*f5^2*f8 + 4*f1^2*f5*f6*f7 + 8*f1*f2^2*f7*f8 - 8*f1*f2*f3*f6*f8 +
4*f1*f2*f3*f7^2 + 2*f1*f3^2*f5*f8)*x[1]^2*x[4]*x[6] + (64*f0^2*f5*f8^2 -
48*f0^2*f6*f7*f8 + 16*f0^2*f7^3 - 80*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 +
32*f0*f1*f6^2*f8 - 16*f0*f1*f6*f7^2 + 80*f0*f2*f3*f8^2 - 32*f0*f2*f5*f6*f8 +
8*f0*f2*f5*f7^2 + 16*f0*f3*f4*f6*f8 - 8*f0*f3*f4*f7^2 + 12*f0*f3*f5^2*f8 -
4*f0*f3*f5*f6*f7 - 16*f0*f4^2*f5*f8 + 4*f0*f4*f5^2*f7 - 16*f1*f2^2*f8^2 -
16*f1*f2*f4*f6*f8 + 8*f1*f2*f4*f7^2 + 8*f1*f2*f5^2*f8 - 4*f1*f2*f5*f6*f7 +
8*f1*f3^2*f6*f8 - 4*f1*f3^2*f7^2 - 4*f1*f3*f4*f5*f8 +
f1*f3*f5^2*f7)*x[1]^2*x[4]*x[7] + (8*f0^2*f7*f8 - 8*f0*f1*f6*f8 + 24*f0*f2*f5*f8
- 8*f0*f3*f4*f8 - 18*f0*f3*f5*f7 + 16*f0*f3*f6^2 + 16*f0*f4^2*f7 -
16*f0*f4*f5*f6 + 4*f0*f5^3 - 4*f1^2*f5*f8 + 2*f1*f2*f5*f7)*x[1]^2*x[4]*x[8] +
(32*f0^2*f3*f8^2 - 4*f0^2*f5*f7^2 - 16*f0*f1*f2*f8^2 - 12*f0*f1*f3*f7*f8 +
16*f0*f2^2*f7*f8 - 4*f0*f2*f3*f7^2 + 4*f1^3*f8^2 - 4*f1^2*f2*f7*f8 +
f1^2*f3*f7^2)*x[1]^2*x[5]^2 + (64*f0^2*f4*f8^2 - 40*f0^2*f5*f7*f8 +
8*f0^2*f6*f7^2 - 16*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 + 2*f0*f1*f5*f7^2 -
16*f0*f2*f3*f7*f8 + 4*f0*f3^2*f7^2 + 8*f1^2*f3*f7*f8)*x[1]^2*x[5]*x[6] +
(-16*f0^2*f5*f8^2 + 80*f0^2*f6*f7*f8 - 24*f0^2*f7^3 - 48*f0*f1*f4*f8^2 +
4*f0*f1*f5*f7*f8 + 48*f0*f2*f3*f8^2 + 48*f0*f2*f4*f7*f8 - 12*f0*f2*f5*f7^2 -
24*f0*f3^2*f7*f8 - 8*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 +
2*f1^2*f5*f7^2)*x[1]^2*x[5]*x[7] + (-24*f0^2*f7*f8 - 16*f0*f2*f5*f8 +
8*f0*f2*f6*f7 + 8*f0*f3*f4*f8 + 2*f0*f3*f5*f7 + 4*f1^2*f5*f8 -
2*f1^2*f6*f7)*x[1]^2*x[5]*x[8] + (-48*f0^2*f5*f8^2 + 32*f0^2*f6*f7*f8 -
8*f0^2*f7^3 + 8*f0*f1*f5*f7*f8 - 4*f0*f1*f6*f7^2 - 32*f0*f2*f4*f7*f8 +
8*f0*f2*f5*f7^2 + 20*f0*f3^2*f7*f8 - 4*f0*f3*f4*f7^2 + 8*f1^2*f4*f7*f8 -
2*f1^2*f5*f7^2 - 4*f1*f2*f3*f7*f8)*x[1]^2*x[6]^2 + (-8*f0^2*f7^2*f8 +
48*f0*f1*f5*f8^2 - 48*f0*f1*f6*f7*f8 + 16*f0*f1*f7^3 + 32*f0*f2*f4*f8^2 -
8*f0*f2*f5*f7*f8 - 48*f0*f3^2*f8^2 + 8*f0*f3*f4*f7*f8 + 2*f0*f3*f5*f7^2 -
16*f1^2*f4*f8^2 + 4*f1^2*f5*f7*f8 + 8*f1*f2*f3*f8^2 - 8*f1*f2*f4*f7*f8 +
2*f1*f2*f5*f7^2 + 4*f1*f3^2*f7*f8)*x[1]^2*x[6]*x[7] + (-16*f0^2*f8^2 +
8*f0*f1*f7*f8 + 16*f0*f3*f5*f8 - 8*f0*f3*f6*f7 - 16*f0*f4^2*f8 + 4*f0*f4*f5*f7 -
f1*f3*f5*f7)*x[1]^2*x[6]*x[8] + (16*f0^2*f7*f8^2 - 16*f0*f1*f6*f8^2 -
64*f0*f2*f5*f8^2 + 64*f0*f2*f6*f7*f8 - 16*f0*f2*f7^3 + 32*f0*f3*f4*f8^2 -
12*f0*f3*f5*f7*f8 + 16*f1^2*f5*f8^2 - 16*f1^2*f6*f7*f8 + 4*f1^2*f7^3 +
16*f1*f2*f4*f8^2 - 4*f1*f2*f5*f7*f8 - 8*f1*f3^2*f8^2)*x[1]^2*x[7]^2 +
(16*f0*f1*f8^2 - 16*f0*f2*f7*f8 - 24*f0*f3*f6*f8 + 12*f0*f3*f7^2 + 8*f0*f4*f5*f8
- 2*f0*f5^2*f7 + 4*f1^2*f7*f8 + 2*f1*f3*f5*f8)*x[1]^2*x[7]*x[8] + (-8*f0^2*f1*f8
+ 16*f0^2*f2*f7 - 16*f0^2*f3*f6 - 4*f0*f1^2*f7 + 16*f0*f1*f2*f6 -
4*f1^3*f6)*x[1]*x[2]^3 + (-16*f0^2*f2*f8 + 8*f0^2*f3*f7 + 12*f0*f1^2*f8 -
16*f0*f1*f2*f7 + 8*f0*f1*f3*f6 - 32*f0*f2^2*f6 + 4*f0*f2*f3*f5 + 4*f1^3*f7 +
8*f1^2*f2*f6 - f1^2*f3*f5)*x[1]*x[2]^2*x[3] + (-8*f0^2*f3*f8 - 16*f0^2*f4*f7 +
24*f0^2*f5*f6 + 16*f0*f1*f2*f8 + 12*f0*f1*f3*f7 - 16*f0*f1*f4*f6 +
16*f0*f2*f3*f6 - 2*f0*f3^2*f5 - 8*f1^3*f8)*x[1]*x[2]^2*x[4] + (-24*f0^2*f3*f8 +
16*f0*f1*f2*f8 - 2*f0*f1*f3*f7 + 8*f0*f2^2*f7 + 8*f0*f2*f3*f6 - 4*f1^3*f8 -
2*f1^2*f2*f7 - 2*f1^2*f3*f6)*x[1]*x[2]^2*x[5] + (-16*f0^2*f4*f8 + 8*f0^2*f5*f7 -
16*f0^2*f6^2 + 4*f0*f1*f4*f7 - 4*f0*f2*f3*f7 - 4*f0*f3^2*f6)*x[1]*x[2]^2*x[6] +
(-8*f0^2*f5*f8 + 8*f0^2*f6*f7 + 16*f0*f1*f4*f8 - 6*f0*f1*f5*f7 + 8*f0*f1*f6^2 -
16*f0*f2*f3*f8 + 4*f0*f3^2*f7 + 2*f1^2*f3*f8)*x[1]*x[2]^2*x[7] + (-4*f0^2*f7 -
4*f0*f1*f6)*x[1]*x[2]^2*x[8] + (16*f0^2*f3*f8 + 8*f0^2*f5*f6 - 8*f0*f1*f2*f8 -
12*f0*f1*f3*f7 + 32*f0*f2^2*f7 + 16*f0*f2*f3*f6 - 8*f0*f2*f4*f5 - 8*f1^2*f2*f7 -
4*f1^2*f3*f6 + 2*f1^2*f4*f5)*x[1]*x[2]*x[3]^2 + (32*f0^2*f4*f8 + 8*f0^2*f5*f7 -
32*f0^2*f6^2 - 24*f0*f1*f3*f8 + 16*f0*f1*f4*f7 - 32*f0*f2*f3*f7 - 16*f0*f3^2*f6
+ 8*f0*f3*f4*f5 + 8*f1^2*f2*f8 + 4*f1^2*f3*f7)*x[1]*x[2]*x[3]*x[4] +
(8*f0^2*f5*f7 - 16*f0^2*f6^2 + 24*f0*f1*f3*f8 - 48*f0*f2^2*f8 - 16*f0*f2*f3*f7 -
16*f0*f2*f4*f6 + 8*f0*f2*f5^2 + 12*f1^2*f2*f8 + 4*f1^2*f3*f7 + 4*f1^2*f4*f6 -
2*f1^2*f5^2)*x[1]*x[2]*x[3]*x[5] + (8*f0^2*f5*f8 + 16*f0^2*f6*f7 -
16*f0*f1*f5*f7 + 16*f0*f1*f6^2 + 24*f0*f2*f3*f8 + 8*f0*f3^2*f7 + 8*f0*f3*f4*f6 -
4*f0*f3*f5^2 - 6*f1^2*f3*f8)*x[1]*x[2]*x[3]*x[6] + (16*f0^2*f6*f8 -
8*f0*f1*f6*f7 - 32*f0*f2*f4*f8 + 24*f0*f2*f5*f7 - 32*f0*f2*f6^2 + 16*f0*f3^2*f8
- 16*f0*f3*f4*f7 + 8*f0*f3*f5*f6 + 4*f1^2*f4*f8 - 2*f1^2*f5*f7 +
4*f1^2*f6^2)*x[1]*x[2]*x[3]*x[7] + (-4*f0*f1*f7 + 32*f0*f2*f6 - 4*f0*f3*f5 -
6*f1^2*f6)*x[1]*x[2]*x[3]*x[8] + (-8*f0^2*f5*f8 - 24*f0*f1*f4*f8 -
12*f0*f1*f5*f7 + 16*f0*f1*f6^2 + 16*f0*f2*f3*f8 + 32*f0*f2*f4*f7 -
24*f0*f2*f5*f6 - 8*f0*f3^2*f7 + 16*f0*f3*f4*f6 + 4*f0*f3*f5^2 - 8*f0*f4^2*f5 +
8*f1^2*f3*f8 - 8*f1^2*f4*f7 + 4*f1^2*f5*f6 - 8*f1*f2^2*f8 +
4*f1*f2*f3*f7)*x[1]*x[2]*x[4]^2 + (-8*f0^2*f5*f8 + 16*f0^2*f6*f7 -
16*f0*f1*f4*f8 + 24*f0*f2*f3*f8 + 8*f0*f3^2*f7 + 8*f0*f3*f4*f6 - 4*f0*f3*f5^2 -
6*f1^2*f3*f8)*x[1]*x[2]*x[4]*x[5] + (16*f0^2*f6*f8 - 16*f0^2*f7^2 +
24*f0*f1*f5*f8 - 16*f0*f1*f6*f7 - 16*f0*f2*f4*f8 - 8*f0*f2*f5*f7 + 16*f0*f2*f6^2
- 8*f0*f3^2*f8 - 16*f0*f4^2*f6 + 8*f0*f4*f5^2 + 8*f1^2*f5*f7 - 8*f1^2*f6^2 -
2*f1*f3^2*f7)*x[1]*x[2]*x[4]*x[6] + (-16*f0*f1*f6*f8 + 8*f0*f1*f7^2 +
16*f0*f2*f6*f7 + 8*f0*f3*f5*f7 - 8*f0*f3*f6^2 + 8*f0*f4*f5*f6 - 4*f0*f5^3 -
4*f1^2*f5*f8 + 8*f1*f2*f4*f8 - 8*f1*f2*f5*f7 + 8*f1*f2*f6^2 - 4*f1*f3^2*f8 +
4*f1*f3*f4*f7 - 2*f1*f3*f5*f6)*x[1]*x[2]*x[4]*x[7] + (4*f0*f1*f8 - 16*f0*f2*f7 -
12*f0*f3*f6 + 8*f0*f4*f5 + 4*f1^2*f7 - 4*f1*f2*f6)*x[1]*x[2]*x[4]*x[8] +
(-16*f0^2*f5*f8 + 8*f0^2*f6*f7 + 8*f0*f2*f3*f8 + 8*f0*f2*f4*f7 - 2*f1^2*f3*f8 -
2*f1^2*f4*f7)*x[1]*x[2]*x[5]^2 + (-32*f0^2*f6*f8 + 8*f0^2*f7^2 + 16*f0*f1*f5*f8
- 8*f0*f1*f6*f7 - 8*f0*f3^2*f8 - 8*f0*f3*f4*f7)*x[1]*x[2]*x[5]*x[6] +
(-32*f0^2*f7*f8 + 16*f0*f1*f6*f8 - 4*f0*f1*f7^2 - 32*f0*f2*f5*f8 +
16*f0*f2*f6*f7 + 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 + 4*f1^2*f5*f8 -
2*f1^2*f6*f7)*x[1]*x[2]*x[5]*x[7] + (4*f0*f1*f8 - 8*f0*f2*f7 - 8*f0*f3*f6 +
2*f1^2*f7)*x[1]*x[2]*x[5]*x[8] + (8*f0^2*f7*f8 + 4*f0*f1*f7^2 + 16*f0*f2*f5*f8 -
8*f0*f2*f6*f7 - 8*f0*f3*f4*f8 - 4*f0*f3*f5*f7 + 8*f0*f4^2*f7 - 8*f1^2*f5*f8 +
4*f1^2*f6*f7 + 2*f1*f3^2*f8)*x[1]*x[2]*x[6]^2 + (4*f0*f1*f7*f8 - 16*f0*f2*f6*f8
+ 4*f0*f3*f5*f8 + 4*f0*f3*f6*f7 - 8*f0*f4*f5*f7 + 8*f1^2*f6*f8 - 4*f1^2*f7^2 +
8*f1*f2*f5*f8 - 4*f1*f2*f6*f7 - 4*f1*f3*f4*f8)*x[1]*x[2]*x[6]*x[7] + (8*f0*f2*f8
+ 4*f0*f3*f7 + 8*f0*f4*f6 - 4*f0*f5^2 - 4*f1^2*f8 +
2*f1*f3*f6)*x[1]*x[2]*x[6]*x[8] + (8*f0*f1*f8^2 - 8*f0*f2*f7*f8 + 2*f0*f5^2*f7 +
4*f1^2*f7*f8 - 8*f1*f2*f6*f8 + 4*f1*f2*f7^2 + 2*f1*f3*f5*f8)*x[1]*x[2]*x[7]^2 +
(16*f0*f3*f8 - 8*f0*f4*f7 + 4*f0*f5*f6 + 4*f1*f2*f8 -
2*f1*f3*f7)*x[1]*x[2]*x[7]*x[8] - 2*f0*f5*x[1]*x[2]*x[8]^2 + (-8*f0^2*f5*f7 +
8*f0*f1*f4*f7 - 4*f0*f1*f5*f6 - 16*f0*f2*f3*f7 + 4*f0*f2*f5^2 + 4*f1^2*f3*f7 -
f1^2*f5^2)*x[1]*x[3]^3 + (-40*f0^2*f5*f8 + 32*f0^2*f6*f7 + 24*f0*f3^2*f7 -
6*f0*f3*f5^2 - 8*f1^2*f4*f7 + 4*f1^2*f5*f6)*x[1]*x[3]^2*x[4] + (8*f0^2*f5*f8 +
16*f0^2*f6*f7 - 16*f0*f1*f4*f8 - 6*f0*f1*f5*f7 + 8*f0*f1*f6^2 + 32*f0*f2*f3*f8 +
16*f0*f2*f4*f7 - 8*f0*f2*f5*f6 - 8*f1^2*f3*f8 - 4*f1^2*f4*f7 +
2*f1^2*f5*f6)*x[1]*x[3]^2*x[5] + (-16*f0^2*f7^2 + 4*f0*f1*f5*f8 - 8*f0*f1*f6*f7
- 16*f0*f3^2*f8 - 8*f0*f3*f4*f7 + 4*f0*f3*f5*f6 + 4*f1^2*f4*f8 + 4*f1^2*f5*f7 -
4*f1^2*f6^2)*x[1]*x[3]^2*x[6] + (16*f0^2*f7*f8 - 16*f0*f1*f6*f8 + 8*f0*f1*f7^2 +
32*f0*f2*f5*f8 - 16*f0*f3*f5*f7 + 16*f0*f3*f6^2 + 16*f0*f4^2*f7 - 16*f0*f4*f5*f6
+ 4*f0*f5^3 - 8*f1^2*f5*f8)*x[1]*x[3]^2*x[7] + (8*f0*f1*f8 - 16*f0*f2*f7 -
8*f0*f3*f6 + 4*f0*f4*f5 + 6*f1^2*f7)*x[1]*x[3]^2*x[8] + (32*f0^2*f6*f8 -
32*f0^2*f7^2 + 32*f0*f1*f5*f8 - 16*f0*f1*f6*f7 + 8*f0*f2*f5*f7 - 32*f0*f3*f4*f7
+ 8*f0*f3*f5*f6 + 4*f0*f4*f5^2 + 8*f1*f2*f4*f7 - 4*f1*f2*f5*f6 - 4*f1*f3^2*f7 +
f1*f3*f5^2)*x[1]*x[3]*x[4]^2 + (-16*f0^2*f6*f8 - 16*f0^2*f7^2 + 8*f0*f1*f5*f8 -
8*f0*f1*f6*f7 - 32*f0*f3^2*f8 - 16*f0*f3*f4*f7 + 8*f0*f3*f5*f6 + 12*f1^2*f4*f8 +
2*f1^2*f5*f7 - 4*f1^2*f6^2)*x[1]*x[3]*x[4]*x[5] + (48*f0^2*f7*f8 -
16*f0*f1*f6*f8 + 24*f0*f1*f7^2 - 48*f0*f2*f5*f8 + 16*f0*f2*f6*f7 +
48*f0*f3*f4*f8 + 20*f0*f3*f5*f7 - 24*f0*f3*f6^2 + 8*f0*f4*f5*f6 - 4*f0*f5^3 +
4*f1^2*f5*f8 - 8*f1*f2*f4*f8 - 8*f1*f2*f5*f7 + 8*f1*f2*f6^2 + 4*f1*f3^2*f8 +
4*f1*f3*f4*f7 - 2*f1*f3*f5*f6)*x[1]*x[3]*x[4]*x[6] + (-64*f0^2*f8^2 -
16*f0*f1*f7*f8 - 32*f0*f3*f5*f8 - 8*f0*f4*f5*f7 + 4*f0*f5^2*f6 + 16*f1^2*f6*f8 -
8*f1^2*f7^2 + 8*f1*f3*f5*f7 - 8*f1*f3*f6^2 - 8*f1*f4^2*f7 + 8*f1*f4*f5*f6 -
2*f1*f5^3)*x[1]*x[3]*x[4]*x[7] + (-8*f0*f2*f8 + 32*f0*f3*f7 - 6*f0*f5^2 -
4*f1^2*f8 - 4*f1*f2*f7 + 4*f1*f3*f6 - 2*f1*f4*f5)*x[1]*x[3]*x[4]*x[8] +
(-16*f0^2*f6*f8 - 8*f0^2*f7^2 + 16*f0*f1*f5*f8 - 8*f0*f1*f6*f7 - 32*f0*f2*f4*f8
+ 4*f0*f2*f5*f7 + 8*f1^2*f4*f8 - f1^2*f5*f7)*x[1]*x[3]*x[5]^2 + (32*f0^2*f7*f8 +
16*f0*f1*f6*f8 + 4*f0*f1*f7^2 + 32*f0*f3*f4*f8 - 4*f0*f3*f5*f7 - 12*f1^2*f5*f8 +
6*f1^2*f6*f7)*x[1]*x[3]*x[5]*x[6] + (-8*f0*f1*f7*f8 - 32*f0*f2*f6*f8 +
16*f0*f2*f7^2 + 24*f0*f3*f5*f8 - 16*f0*f3*f6*f7 - 32*f0*f4^2*f8 + 8*f0*f4*f5*f7
+ 8*f1^2*f6*f8 - 4*f1^2*f7^2)*x[1]*x[3]*x[5]*x[7] + (24*f0*f2*f8 + 8*f0*f3*f7 +
8*f0*f4*f6 - 4*f0*f5^2 - 10*f1^2*f8)*x[1]*x[3]*x[5]*x[8] + (-16*f0*f1*f7*f8 -
8*f0*f2*f7^2 - 16*f0*f3*f5*f8 + 12*f0*f3*f6*f7 - 4*f0*f4*f5*f7 + 8*f1*f2*f5*f8 -
4*f1*f2*f6*f7 - 4*f1*f3*f4*f8 + f1*f3*f5*f7)*x[1]*x[3]*x[6]^2 + (8*f0*f1*f8^2 +
8*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 16*f0*f3*f7^2 + 8*f0*f4*f5*f8 + 2*f0*f5^2*f7 +
4*f1^2*f7*f8 - 8*f1*f2*f6*f8 + 4*f1*f2*f7^2 - 8*f1*f3*f5*f8 + 4*f1*f3*f6*f7 +
8*f1*f4^2*f8 - 2*f1*f4*f5*f7)*x[1]*x[3]*x[6]*x[7] + (-32*f0*f3*f8 - 8*f0*f4*f7 +
4*f1*f2*f8 - 4*f1*f4*f6 + 2*f1*f5^2)*x[1]*x[3]*x[6]*x[8] + (32*f0*f2*f8^2 -
32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 12*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 16*f1^2*f8^2 +
8*f1*f3*f6*f8 - 4*f1*f3*f7^2 - 4*f1*f4*f5*f8 + f1*f5^2*f7)*x[1]*x[3]*x[7]^2 +
(16*f0*f4*f8 - 4*f0*f5*f7 + 8*f0*f6^2 - 4*f1*f3*f8 + 4*f1*f4*f7 -
2*f1*f5*f6)*x[1]*x[3]*x[7]*x[8] + (-4*f0*f6 + f1*f5)*x[1]*x[3]*x[8]^2 +
(-16*f0*f1*f6*f8 + 16*f0*f1*f7^2 + 8*f0*f2*f5*f8 + 16*f0*f4^2*f7 - 8*f0*f4*f5*f6
- 8*f1^2*f5*f8)*x[1]*x[4]^3 + (32*f0^2*f7*f8 - 8*f0*f1*f6*f8 + 8*f0*f1*f7^2 +
16*f0*f3*f4*f8 - 12*f0*f3*f5*f7 + 8*f0*f3*f6^2 + 16*f0*f4^2*f7 - 16*f0*f4*f5*f6
+ 4*f0*f5^3 - 8*f1*f2*f4*f8 + 2*f1*f2*f5*f7 + 4*f1*f3^2*f8)*x[1]*x[4]^2*x[5] +
(-16*f0^2*f8^2 - 40*f0*f1*f7*f8 + 8*f0*f3*f5*f8 - 8*f0*f3*f6*f7 - 32*f0*f4^2*f8
- 12*f0*f4*f5*f7 + 16*f0*f4*f6^2 + 16*f1^2*f6*f8 - 8*f1^2*f7^2)*x[1]*x[4]^2*x[6]
+ (32*f0*f1*f8^2 + 16*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 24*f0*f3*f7^2 +
16*f0*f4*f6*f7 + 6*f0*f5^2*f7 - 8*f0*f5*f6^2 - 16*f1*f2*f6*f8 + 8*f1*f2*f7^2 +
8*f1*f3*f5*f8)*x[1]*x[4]^2*x[7] + (-4*f0*f3*f8 - 24*f0*f4*f7 + 8*f0*f5*f6 +
4*f1*f2*f8 - 2*f1*f3*f7)*x[1]*x[4]^2*x[8] + (8*f0^2*f7*f8 + 4*f0*f1*f7^2 +
16*f0*f3*f4*f8 - 2*f0*f3*f5*f7 - 4*f1^2*f5*f8 + 2*f1^2*f6*f7)*x[1]*x[4]*x[5]^2 +
(-32*f0^2*f8^2 - 20*f0*f1*f7*f8 + 16*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 4*f0*f3*f5*f8
+ 4*f0*f3*f6*f7 - 32*f0*f4^2*f8 + 8*f0*f4*f5*f7 - 8*f1^2*f6*f8 + 4*f1^2*f7^2 +
8*f1*f2*f5*f8 - 4*f1*f2*f6*f7 - 4*f1*f3*f4*f8)*x[1]*x[4]*x[5]*x[6] +
(24*f0*f1*f8^2 - 8*f0*f2*f7*f8 - 16*f0*f3*f6*f8 + 8*f0*f3*f7^2 + 24*f0*f4*f5*f8
- 6*f0*f5^2*f7 + 4*f1^2*f7*f8 + 8*f1*f2*f6*f8 - 4*f1*f2*f7^2 - 8*f1*f3*f5*f8 +
4*f1*f3*f6*f7 + 8*f1*f4^2*f8 - 2*f1*f4*f5*f7)*x[1]*x[4]*x[5]*x[7] + (-8*f0*f3*f8
- 8*f0*f4*f7 + 8*f0*f5*f6 + 4*f1*f2*f8 - 2*f1*f3*f7)*x[1]*x[4]*x[5]*x[8] +
(32*f0*f1*f8^2 - 8*f0*f3*f6*f8 + 12*f0*f3*f7^2 + 32*f0*f4*f5*f8 - 16*f0*f4*f6*f7
+ 8*f1^2*f7*f8)*x[1]*x[4]*x[6]^2 + (-32*f0*f2*f8^2 + 32*f0*f3*f7*f8 -
32*f0*f4*f6*f8 - 16*f0*f5^2*f8 + 8*f0*f5*f6*f7 - 16*f1^2*f8^2 - 8*f1*f2*f7*f8 -
8*f1*f3*f6*f8 + 4*f1*f3*f7^2)*x[1]*x[4]*x[6]*x[7] + (32*f0*f4*f8 + 8*f0*f5*f7 -
8*f0*f6^2 + 2*f1*f3*f8)*x[1]*x[4]*x[6]*x[8] + (-48*f0*f3*f8^2 + 16*f0*f5*f6*f8 +
16*f1*f2*f8^2 + 16*f1*f4*f6*f8 - 8*f1*f4*f7^2 - 8*f1*f5^2*f8 +
4*f1*f5*f6*f7)*x[1]*x[4]*x[7]^2 + (-12*f0*f5*f8 - 8*f0*f6*f7 - 4*f1*f4*f8 +
2*f1*f5*f7 - 4*f1*f6^2)*x[1]*x[4]*x[7]*x[8] + (8*f0*f7 +
2*f1*f6)*x[1]*x[4]*x[8]^2 + (8*f0^2*f7*f8 + 2*f0*f1*f7^2)*x[1]*x[5]^3 +
(-16*f0^2*f8^2 - 8*f0*f1*f7*f8 - 2*f1^2*f7^2)*x[1]*x[5]^2*x[6] + (8*f0*f1*f8^2 -
16*f0*f2*f7*f8 + 4*f0*f3*f7^2 + 4*f1^2*f7*f8)*x[1]*x[5]^2*x[7] + (-4*f0*f3*f8 -
4*f0*f4*f7)*x[1]*x[5]^2*x[8] + (24*f0*f2*f7*f8 - 4*f0*f3*f7^2 - 4*f1^2*f7*f8 +
2*f1*f2*f7^2)*x[1]*x[5]*x[6]^2 + (-16*f0*f2*f8^2 + 8*f0*f3*f7*f8 + 8*f1^2*f8^2 -
2*f1*f3*f7^2)*x[1]*x[5]*x[6]*x[7] + (16*f0*f4*f8 - 2*f0*f5*f7 +
2*f1*f4*f7)*x[1]*x[5]*x[6]*x[8] + (-16*f0*f4*f7*f8 + 4*f0*f5*f7^2 - 8*f1*f2*f8^2
+ 4*f1*f3*f7*f8)*x[1]*x[5]*x[7]^2 + (4*f0*f5*f8 - 4*f0*f6*f7 -
4*f1*f4*f8)*x[1]*x[5]*x[7]*x[8] + (-12*f0*f3*f7*f8 + 4*f0*f4*f7^2)*x[1]*x[6]^3 +
(8*f0*f3*f8^2 - 2*f0*f5*f7^2 - 4*f1*f3*f7*f8)*x[1]*x[6]^2*x[7] + (-8*f0*f5*f8 +
4*f0*f6*f7)*x[1]*x[6]^2*x[8] + (16*f0*f4*f8^2 - 8*f0*f5*f7*f8 + 8*f1*f3*f8^2 +
8*f1*f4*f7*f8 - 2*f1*f5*f7^2)*x[1]*x[6]*x[7]^2 + (8*f0*f6*f8 - 4*f1*f5*f8 +
2*f1*f6*f7)*x[1]*x[6]*x[7]*x[8] - 4*f0*f8*x[1]*x[6]*x[8]^2 + (8*f0*f5*f8^2 -
16*f1*f4*f8^2 + 4*f1*f5*f7*f8)*x[1]*x[7]^3 + (-4*f0*f7*f8 + 4*f1*f6*f8 -
2*f1*f7^2)*x[1]*x[7]^2*x[8] - 2*f1*f8*x[1]*x[7]*x[8]^2 + (4*f0^2*f3 - 4*f0*f1*f2
+ f1^3)*x[2]^4 + (-2*f0*f1*f3 + 8*f0*f2^2 - 2*f1^2*f2)*x[2]^3*x[3] + (-8*f0^2*f5
+ 4*f0*f1*f4 - 4*f0*f2*f3)*x[2]^3*x[4] + (-4*f0*f2*f3 + f1^2*f3)*x[2]^3*x[5] +
(8*f0^2*f6 + 2*f0*f3^2)*x[2]^3*x[6] + (-4*f0^2*f7 - 4*f0*f1*f6)*x[2]^3*x[7] +
2*f0*f1*x[2]^3*x[8] + (-4*f0^2*f5 - 4*f0*f2*f3 + f1^2*f3)*x[2]^2*x[3]^2 +
(8*f0^2*f6 + 2*f0*f1*f5 + 4*f0*f3^2)*x[2]^2*x[3]*x[4] + (8*f0^2*f6 + 8*f0*f2*f4
- 2*f1^2*f4)*x[2]^2*x[3]*x[5] + (-12*f0^2*f7 - 8*f0*f1*f6 -
4*f0*f3*f4)*x[2]^2*x[3]*x[6] + (8*f0*f1*f7 + 16*f0*f2*f6 - 2*f0*f3*f5 -
2*f1^2*f6)*x[2]^2*x[3]*x[7] + (-12*f0*f2 + 2*f1^2)*x[2]^2*x[3]*x[8] +
(16*f0^2*f7 - 4*f0*f1*f6 + 8*f0*f2*f5 - 4*f0*f3*f4 - 2*f1^2*f5)*x[2]^2*x[4]^2 +
(-4*f0^2*f7 - 4*f0*f3*f4)*x[2]^2*x[4]*x[5] + (-16*f0^2*f8 + 4*f0*f1*f7 -
8*f0*f2*f6 - 4*f0*f3*f5 + 8*f0*f4^2 + 4*f1^2*f6)*x[2]^2*x[4]*x[6] + (-8*f0*f2*f7
+ 4*f0*f3*f6 - 4*f0*f4*f5 - 4*f1*f2*f6 + f1*f3*f5)*x[2]^2*x[4]*x[7] + (2*f0*f3 +
2*f1*f2)*x[2]^2*x[4]*x[8] + (-4*f0*f2*f5 + f1^2*f5)*x[2]^2*x[5]^2 + (16*f0^2*f8
+ 2*f0*f1*f7 + 4*f0*f3*f5)*x[2]^2*x[5]*x[6] + (-8*f0*f1*f8 - 4*f0*f2*f7 -
4*f0*f3*f6)*x[2]^2*x[5]*x[7] + 6*f0*f3*x[2]^2*x[5]*x[8] + (-4*f0*f1*f8 +
4*f0*f2*f7 + 4*f0*f3*f6 - 4*f0*f4*f5 - 2*f1^2*f7)*x[2]^2*x[6]^2 + (8*f0*f2*f8 -
6*f0*f3*f7 + 4*f0*f5^2 + 2*f1*f2*f7)*x[2]^2*x[6]*x[7] + (-4*f0*f4 -
f1*f3)*x[2]^2*x[6]*x[8] + (-4*f0*f3*f8 + 4*f0*f4*f7 - 4*f0*f5*f6)*x[2]^2*x[7]^2
+ 2*f0*f5*x[2]^2*x[7]*x[8] + 2*f0*f1*f5*x[2]*x[3]^3 - 2*f1^2*f5*x[2]*x[3]^2*x[4]
+ (-16*f0^2*f7 - 4*f0*f1*f6 - 4*f0*f2*f5 + f1^2*f5)*x[2]*x[3]^2*x[5] +
(12*f0*f1*f7 + 2*f0*f3*f5 + 2*f1^2*f6)*x[2]*x[3]^2*x[6] + (-16*f0*f2*f7 -
8*f0*f3*f6 + 4*f0*f4*f5 + 2*f1^2*f7)*x[2]*x[3]^2*x[7] + 4*f0*f3*x[2]*x[3]^2*x[8]
+ (-16*f0^2*f8 - 8*f0*f1*f7 - 4*f0*f3*f5 + 2*f1*f2*f5)*x[2]*x[3]*x[4]^2 +
(4*f0*f1*f7 + 4*f0*f3*f5 + 2*f1^2*f6)*x[2]*x[3]*x[4]*x[5] + (12*f0*f1*f8 +
12*f0*f3*f6 - 8*f0*f4*f5 - 4*f1^2*f7 - 4*f1*f2*f6)*x[2]*x[3]*x[4]*x[6] +
(8*f0*f2*f8 + 8*f0*f3*f7 + 2*f0*f5^2 - 4*f1^2*f8 + 4*f1*f2*f7 + 4*f1*f3*f6 -
2*f1*f4*f5)*x[2]*x[3]*x[4]*x[7] - 2*f1*f3*x[2]*x[3]*x[4]*x[8] + (16*f0^2*f8 +
2*f0*f1*f7 + 8*f0*f2*f6 - 2*f1^2*f6)*x[2]*x[3]*x[5]^2 + (-20*f0*f1*f8 -
8*f0*f3*f6 - 2*f1^2*f7)*x[2]*x[3]*x[5]*x[6] + (24*f0*f2*f8 + 8*f0*f3*f7 +
8*f0*f4*f6 - 4*f0*f5^2 - 2*f1^2*f8)*x[2]*x[3]*x[5]*x[7] -
8*f0*f4*x[2]*x[3]*x[5]*x[8] + (-8*f0*f3*f7 + 4*f0*f5^2 + 4*f1^2*f8 +
2*f1*f2*f7)*x[2]*x[3]*x[6]^2 + (8*f0*f4*f7 - 8*f0*f5*f6 - 4*f1*f2*f8 -
2*f1*f3*f7)*x[2]*x[3]*x[6]*x[7] + (6*f0*f5 + 2*f1*f4)*x[2]*x[3]*x[6]*x[8] +
(-4*f0*f5*f7 + 8*f0*f6^2)*x[2]*x[3]*x[7]^2 - 12*f0*f6*x[2]*x[3]*x[7]*x[8] +
4*f0*x[2]*x[3]*x[8]^2 + (8*f0*f1*f8 - 16*f0*f2*f7 + 4*f0*f4*f5 +
8*f1^2*f7)*x[2]*x[4]^3 + (8*f0*f1*f8 - 4*f0*f3*f6 + 4*f0*f4*f5 -
f1*f3*f5)*x[2]*x[4]^2*x[5] + (24*f0*f2*f8 + 12*f0*f3*f7 - 8*f0*f4*f6 -
16*f1^2*f8)*x[2]*x[4]^2*x[6] + (-12*f0*f3*f8 + 4*f1*f2*f8 -
6*f1*f3*f7)*x[2]*x[4]^2*x[7] - 2*f0*f5*x[2]*x[4]^2*x[8] -
4*f0*f3*f6*x[2]*x[4]*x[5]^2 + (-8*f0*f2*f8 + 8*f0*f4*f6 - 4*f0*f5^2 + 4*f1^2*f8
+ 2*f1*f3*f6)*x[2]*x[4]*x[5]*x[6] + (-8*f0*f3*f8 - 8*f0*f4*f7 - 4*f1*f2*f8 -
4*f1*f4*f6 + 2*f1*f5^2)*x[2]*x[4]*x[5]*x[7] + (-2*f0*f5 +
2*f1*f4)*x[2]*x[4]*x[5]*x[8] + (-12*f0*f3*f8 + 4*f0*f4*f7)*x[2]*x[4]*x[6]^2 +
(-8*f0*f5*f7 + 8*f0*f6^2 + 10*f1*f3*f8)*x[2]*x[4]*x[6]*x[7] + (8*f0*f5*f8 -
8*f0*f6*f7 - 4*f1*f4*f8 + 4*f1*f5*f7 - 4*f1*f6^2)*x[2]*x[4]*x[7]^2 + (8*f0*f7 +
6*f1*f6)*x[2]*x[4]*x[7]*x[8] - 2*f1*x[2]*x[4]*x[8]^2 + (-4*f0*f2*f7 +
f1^2*f7)*x[2]*x[5]^3 + 6*f0*f3*f7*x[2]*x[5]^2*x[6] + (-4*f0*f3*f8 -
4*f0*f4*f7)*x[2]*x[5]^2*x[7] + 4*f0*f5*x[2]*x[5]^2*x[8] + (4*f0*f3*f8 -
4*f0*f4*f7 - f1*f3*f7)*x[2]*x[5]*x[6]^2 + (6*f0*f5*f7 +
2*f1*f4*f7)*x[2]*x[5]*x[6]*x[7] + (-4*f0*f6 - 2*f1*f5)*x[2]*x[5]*x[6]*x[8] +
(-4*f0*f6*f7 - f1*f5*f7)*x[2]*x[5]*x[7]^2 + (8*f0*f7 +
2*f1*f6)*x[2]*x[5]*x[7]*x[8] - f1*x[2]*x[5]*x[8]^2 + (8*f0*f5*f8 -
4*f0*f6*f7)*x[2]*x[6]^2*x[7] - 2*f0*f7*x[2]*x[6]^2*x[8] + (-8*f0*f6*f8 +
8*f0*f7^2 - 4*f1*f5*f8 + 2*f1*f6*f7)*x[2]*x[6]*x[7]^2 -
2*f1*f7*x[2]*x[6]*x[7]*x[8] + (-4*f0*f7*f8 + 4*f1*f6*f8 - 2*f1*f7^2)*x[2]*x[7]^3
- 2*f1*f8*x[2]*x[7]^2*x[8] + 4*f0^2*f7*x[3]^4 - 8*f0*f1*f7*x[3]^3*x[4] +
4*f0*f1*f7*x[3]^3*x[5] - 2*f1^2*f7*x[3]^3*x[6] + (8*f0*f3*f7 -
2*f0*f5^2)*x[3]^3*x[7] + (8*f0*f2*f7 + 4*f1^2*f7)*x[3]^2*x[4]^2 + (8*f0*f1*f8 -
2*f1^2*f7)*x[3]^2*x[4]*x[5] + (-12*f0*f3*f7 + 2*f0*f5^2 - 4*f1^2*f8 +
4*f1*f2*f7)*x[3]^2*x[4]*x[6] + (-8*f0*f4*f7 + 4*f0*f5*f6 - 4*f1*f3*f7 +
f1*f5^2)*x[3]^2*x[4]*x[7] - 2*f0*f5*x[3]^2*x[4]*x[8] + (-8*f0*f1*f8 - 4*f0*f2*f7
+ f1^2*f7)*x[3]^2*x[5]^2 + (4*f0*f3*f7 + 6*f1^2*f8)*x[3]^2*x[5]*x[6] +
(-16*f0*f3*f8 - 8*f0*f4*f7 + 4*f0*f5*f6)*x[3]^2*x[5]*x[7] +
2*f0*f5*x[3]^2*x[5]*x[8] + (4*f0*f3*f8 + 4*f0*f4*f7 - 4*f0*f5*f6 -
4*f1*f2*f8)*x[3]^2*x[6]^2 + (2*f0*f5*f7 + 4*f1*f3*f8)*x[3]^2*x[6]*x[7] -
f1*f5*x[3]^2*x[6]*x[8] - 4*f0*f5*f8*x[3]^2*x[7]^2 + 4*f0*f7*x[3]^2*x[7]*x[8] +
(8*f0*f3*f7 - 2*f0*f5^2 - 8*f1*f2*f7)*x[3]*x[4]^3 + (-8*f0*f2*f8 - 2*f0*f5^2 -
4*f1^2*f8)*x[3]*x[4]^2*x[5] + (-20*f0*f3*f8 + 4*f0*f5*f6 + 12*f1*f2*f8 +
2*f1*f3*f7)*x[3]*x[4]^2*x[6] + (8*f1*f4*f7 - 4*f1*f5*f6)*x[3]*x[4]^2*x[7] +
2*f1*f5*x[3]*x[4]^2*x[8] + (4*f0*f3*f7 + 2*f1^2*f8)*x[3]*x[4]*x[5]^2 +
(24*f0*f3*f8 - 8*f0*f4*f7 + 4*f0*f5*f6 - 4*f1*f2*f8 -
2*f1*f3*f7)*x[3]*x[4]*x[5]*x[6] + (16*f0*f4*f8 + 8*f0*f5*f7 - 8*f0*f6^2 +
4*f1*f3*f8 + 4*f1*f4*f7 - 2*f1*f5*f6)*x[3]*x[4]*x[5]*x[7] +
4*f0*f6*x[3]*x[4]*x[5]*x[8] + (-2*f0*f5*f7 - 2*f1*f3*f8)*x[3]*x[4]*x[6]^2 +
(12*f0*f5*f8 - 8*f0*f6*f7 - 12*f1*f4*f8 - 2*f1*f5*f7 +
4*f1*f6^2)*x[3]*x[4]*x[6]*x[7] - 2*f1*f6*x[3]*x[4]*x[6]*x[8] +
4*f1*f5*f8*x[3]*x[4]*x[7]^2 - 4*f1*f7*x[3]*x[4]*x[7]*x[8] + (8*f0*f2*f8 -
2*f1^2*f8)*x[3]*x[5]^3 - 12*f0*f3*f8*x[3]*x[5]^2*x[6] + (16*f0*f4*f8 -
2*f0*f5*f7)*x[3]*x[5]^2*x[7] - 4*f0*f6*x[3]*x[5]^2*x[8] + (2*f0*f5*f7 +
2*f1*f3*f8)*x[3]*x[5]*x[6]^2 + (-20*f0*f5*f8 + 4*f0*f6*f7 -
4*f1*f4*f8)*x[3]*x[5]*x[6]*x[7] + (4*f0*f7 + 2*f1*f6)*x[3]*x[5]*x[6]*x[8] +
(16*f0*f6*f8 - 8*f0*f7^2 + 2*f1*f5*f8)*x[3]*x[5]*x[7]^2 + (-16*f0*f8 -
2*f1*f7)*x[3]*x[5]*x[7]*x[8] + (4*f0*f7^2 + 4*f1*f5*f8 -
2*f1*f6*f7)*x[3]*x[6]^2*x[7] + (-4*f0*f7*f8 - 4*f1*f6*f8 +
2*f1*f7^2)*x[3]*x[6]*x[7]^2 + 6*f1*f8*x[3]*x[6]*x[7]*x[8] + (-4*f1*f3*f7 +
f1*f5^2 + 4*f2^2*f7)*x[4]^4 + (-4*f0*f3*f8 - 8*f0*f4*f7 + 4*f0*f5*f6 +
4*f1*f2*f8 + 2*f1*f3*f7)*x[4]^3*x[5] + (8*f0*f4*f8 - 4*f0*f5*f7 + 8*f1*f3*f8 +
8*f1*f4*f7 - 4*f1*f5*f6 - 8*f2^2*f8 - 4*f2*f3*f7)*x[4]^3*x[6] + (-8*f2*f4*f7 +
4*f2*f5*f6 + 4*f3^2*f7 - f3*f5^2)*x[4]^3*x[7] - 2*f2*f5*x[4]^3*x[8] -
4*f0*f3*f8*x[4]^2*x[5]^2 + (16*f0*f4*f8 + 6*f0*f5*f7 - 8*f0*f6^2 -
6*f1*f3*f8)*x[4]^2*x[5]*x[6] + (-8*f0*f5*f8 - 4*f1*f4*f8 - 4*f1*f5*f7 +
4*f1*f6^2)*x[4]^2*x[5]*x[7] + (4*f0*f7 - 2*f1*f6)*x[4]^2*x[5]*x[8] + (4*f0*f6*f7
- 16*f1*f4*f8 - 2*f1*f5*f7 + 4*f1*f6^2 + 8*f2*f3*f8 + f3^2*f7)*x[4]^2*x[6]^2 +
(-8*f0*f6*f8 + 8*f0*f7^2 + 4*f1*f5*f8 + 16*f2*f4*f8 + 6*f2*f5*f7 - 8*f2*f6^2 -
8*f3^2*f8 - 4*f3*f4*f7 + 2*f3*f5*f6)*x[4]^2*x[6]*x[7] + (-4*f0*f8 - 4*f1*f7 +
4*f2*f6 + f3*f5)*x[4]^2*x[6]*x[8] + (-4*f2*f5*f8 - 4*f3*f5*f7 + 4*f3*f6^2 +
4*f4^2*f7 - 4*f4*f5*f6 + f5^3)*x[4]^2*x[7]^2 + (4*f2*f7 - 4*f3*f6 +
2*f4*f5)*x[4]^2*x[7]*x[8] + f3*x[4]^2*x[8]^2 - 4*f0*f3*f8*x[4]*x[5]^3 +
(8*f0*f4*f8 - 2*f0*f5*f7 + 2*f1*f3*f8)*x[4]*x[5]^2*x[6] + (-8*f0*f5*f8 +
4*f0*f6*f7 - 4*f1*f4*f8 + f1*f5*f7)*x[4]*x[5]^2*x[7] - 2*f0*f7*x[4]*x[5]^2*x[8]
+ (-16*f0*f5*f8 + 8*f0*f6*f7)*x[4]*x[5]*x[6]^2 + (24*f0*f6*f8 - 8*f0*f7^2 +
12*f1*f5*f8 - 6*f1*f6*f7)*x[4]*x[5]*x[6]*x[7] + (-8*f0*f8 +
2*f1*f7)*x[4]*x[5]*x[6]*x[8] + (4*f0*f7*f8 - 12*f1*f6*f8 +
6*f1*f7^2)*x[4]*x[5]*x[7]^2 + 6*f1*f8*x[4]*x[5]*x[7]*x[8] + (-4*f0*f7^2 +
8*f1*f5*f8 - 4*f1*f6*f7 - 2*f3^2*f8)*x[4]*x[6]^3 + (-12*f0*f7*f8 - 8*f1*f6*f8 +
4*f1*f7^2 - 16*f2*f5*f8 + 8*f2*f6*f7 + 8*f3*f4*f8 - f3*f5*f7)*x[4]*x[6]^2*x[7] +
(8*f1*f8 - 2*f2*f7 - 2*f3*f6)*x[4]*x[6]^2*x[8] + (16*f0*f8^2 + 16*f2*f6*f8 -
8*f2*f7^2 + 6*f3*f5*f8 - 4*f3*f6*f7 - 8*f4^2*f8 + 2*f4*f5*f7)*x[4]*x[6]*x[7]^2 +
(-12*f2*f8 + 4*f3*f7 + 4*f4*f6 - 2*f5^2)*x[4]*x[6]*x[7]*x[8] -
2*f4*x[4]*x[6]*x[8]^2 + (-8*f3*f6*f8 + 4*f3*f7^2 + 4*f4*f5*f8 -
f5^2*f7)*x[4]*x[7]^3 + (4*f3*f8 - 4*f4*f7 + 2*f5*f6)*x[4]*x[7]^2*x[8] -
f5*x[4]*x[7]*x[8]^2 + 2*f0*f7*x[5]^3*x[8] - 2*f0*f7^2*x[5]^2*x[6]*x[7] +
(-4*f0*f8 - f1*f7)*x[5]^2*x[6]*x[8] + 8*f0*f7*f8*x[5]^2*x[7]^2 +
2*f1*f8*x[5]^2*x[7]*x[8] - 2*f0*f7^2*x[5]*x[6]^3 + (4*f0*f7*f8 +
2*f1*f7^2)*x[5]*x[6]^2*x[7] + (-16*f0*f8^2 - 8*f1*f7*f8)*x[5]*x[6]*x[7]^2 +
8*f1*f8^2*x[5]*x[7]^3 + (4*f0*f7*f8 + f1*f7^2)*x[6]^4 + (-4*f1*f7*f8 -
2*f2*f7^2)*x[6]^3*x[7] + f3*f7*x[6]^3*x[8] + (4*f1*f8^2 + 8*f2*f7*f8 +
f3*f7^2)*x[6]^2*x[7]^2 + (-2*f3*f8 - 2*f4*f7)*x[6]^2*x[7]*x[8] +
f5*x[6]^2*x[8]^2 + (-8*f2*f8^2 - 4*f3*f7*f8)*x[6]*x[7]^3 + (4*f4*f8 +
f5*f7)*x[6]*x[7]^2*x[8] - 2*f6*x[6]*x[7]*x[8]^2 + x[6]*x[8]^3 + 4*f3*f8^2*x[7]^4
- 2*f5*f8*x[7]^3*x[8] + f7*x[7]^2*x[8]^2,

// number 7
(64*f0^3*f2*f8^3 - 32*f0^3*f3*f7*f8^2 + 16*f0^3*f4*f7^2*f8 + 64*f0^3*f5^2*f8^2 -
96*f0^3*f5*f6*f7*f8 + 16*f0^3*f5*f7^3 + 64*f0^3*f6^3*f8 - 16*f0^3*f6^2*f7^2 -
16*f0^2*f1^2*f8^3 + 32*f0^2*f1*f3*f6*f8^2 - 8*f0^2*f1*f3*f7^2*f8 -
64*f0^2*f1*f4*f5*f8^2 + 32*f0^2*f1*f4*f6*f7*f8 - 8*f0^2*f1*f4*f7^3 +
16*f0^2*f1*f5^2*f7*f8 - 32*f0^2*f1*f5*f6^2*f8 + 8*f0^2*f1*f5*f6*f7^2 +
64*f0^2*f2^2*f6*f8^2 - 16*f0^2*f2^2*f7^2*f8 + 32*f0^2*f2*f3*f5*f8^2 -
64*f0^2*f2*f3*f6*f7*f8 + 16*f0^2*f2*f3*f7^3 + 64*f0^2*f2*f4^2*f8^2 -
32*f0^2*f2*f4*f5*f7*f8 + 128*f0^2*f2*f4*f6^2*f8 - 32*f0^2*f2*f4*f6*f7^2 -
16*f0^2*f2*f5^2*f6*f8 - 16*f0^2*f3^2*f5*f7*f8 + 48*f0^2*f3^2*f6^2*f8 -
12*f0^2*f3^2*f6*f7^2 - 96*f0^2*f3*f4*f5*f6*f8 + 24*f0^2*f3*f4*f5*f7^2 +
16*f0^2*f3*f5^3*f8 + 64*f0^2*f4^3*f6*f8 - 16*f0^2*f4^3*f7^2 -
16*f0^2*f4^2*f5^2*f8 - 48*f0*f1^2*f2*f6*f8^2 + 12*f0*f1^2*f2*f7^2*f8 +
8*f0*f1^2*f3*f5*f8^2 - 16*f0*f1^2*f4*f6^2*f8 + 4*f0*f1^2*f4*f6*f7^2 +
4*f0*f1^2*f5^2*f6*f8 - 32*f0*f1*f2^2*f5*f8^2 + 32*f0*f1*f2^2*f6*f7*f8 -
8*f0*f1*f2^2*f7^3 - 64*f0*f1*f2*f3*f4*f8^2 + 40*f0*f1*f2*f3*f5*f7*f8 -
96*f0*f1*f2*f3*f6^2*f8 + 24*f0*f1*f2*f3*f6*f7^2 + 32*f0*f1*f2*f4*f5*f6*f8 -
8*f0*f1*f2*f4*f5*f7^2 - 8*f0*f1*f2*f5^3*f8 + 8*f0*f1*f3^3*f8^2 +
16*f0*f1*f3^2*f5*f6*f8 - 4*f0*f1*f3^2*f5*f7^2 - 32*f0*f1*f3*f4^2*f6*f8 +
8*f0*f1*f3*f4^2*f7^2 + 8*f0*f1*f3*f4*f5^2*f8 + 64*f0*f2^3*f4*f8^2 -
32*f0*f2^3*f5*f7*f8 + 64*f0*f2^3*f6^2*f8 - 16*f0*f2^3*f6*f7^2 -
16*f0*f2^2*f3^2*f8^2 - 32*f0*f2^2*f3*f5*f6*f8 + 8*f0*f2^2*f3*f5*f7^2 +
64*f0*f2^2*f4^2*f6*f8 - 16*f0*f2^2*f4^2*f7^2 - 16*f0*f2^2*f4*f5^2*f8 -
16*f0*f2*f3^2*f4*f6*f8 + 4*f0*f2*f3^2*f4*f7^2 + 4*f0*f2*f3^2*f5^2*f8 +
8*f1^4*f6*f8^2 - 2*f1^4*f7^2*f8 + 8*f1^3*f2*f5*f8^2 - 8*f1^3*f2*f6*f7*f8 +
2*f1^3*f2*f7^3 + 8*f1^3*f3*f4*f8^2 - 6*f1^3*f3*f5*f7*f8 + 16*f1^3*f3*f6^2*f8 -
4*f1^3*f3*f6*f7^2 - 8*f1^3*f4*f5*f6*f8 + 2*f1^3*f4*f5*f7^2 + 2*f1^3*f5^3*f8 -
16*f1^2*f2^2*f4*f8^2 + 8*f1^2*f2^2*f5*f7*f8 - 16*f1^2*f2^2*f6^2*f8 +
4*f1^2*f2^2*f6*f7^2 + 4*f1^2*f2*f3^2*f8^2 + 8*f1^2*f2*f3*f5*f6*f8 -
2*f1^2*f2*f3*f5*f7^2 - 16*f1^2*f2*f4^2*f6*f8 + 4*f1^2*f2*f4^2*f7^2 +
4*f1^2*f2*f4*f5^2*f8 + 4*f1^2*f3^2*f4*f6*f8 - f1^2*f3^2*f4*f7^2 -
f1^2*f3^2*f5^2*f8)*x[1]^4 + (48*f0^3*f5*f7*f8 - 128*f0^3*f6^2*f8 +
32*f0^3*f6*f7^2 - 16*f0^2*f1*f3*f8^2 - 16*f0^2*f1*f4*f7*f8 + 64*f0^2*f1*f5*f6*f8
- 16*f0^2*f1*f5*f7^2 - 64*f0^2*f2^2*f8^2 + 48*f0^2*f2*f3*f7*f8 -
192*f0^2*f2*f4*f6*f8 + 32*f0^2*f2*f4*f7^2 + 16*f0^2*f2*f5*f6*f7 -
80*f0^2*f3^2*f6*f8 + 16*f0^2*f3^2*f7^2 + 112*f0^2*f3*f4*f5*f8 -
16*f0^2*f3*f5^2*f7 - 64*f0^2*f4^3*f8 + 16*f0^2*f4^2*f5*f7 + 48*f0*f1^2*f2*f8^2 -
4*f0*f1^2*f3*f7*f8 + 16*f0*f1^2*f4*f6*f8 - 4*f0*f1^2*f5*f6*f7 -
16*f0*f1*f2^2*f7*f8 + 176*f0*f1*f2*f3*f6*f8 - 40*f0*f1*f2*f3*f7^2 -
32*f0*f1*f2*f4*f5*f8 + 8*f0*f1*f2*f5^2*f7 - 24*f0*f1*f3^2*f5*f8 +
32*f0*f1*f3*f4^2*f8 - 8*f0*f1*f3*f4*f5*f7 - 128*f0*f2^3*f6*f8 + 32*f0*f2^3*f7^2
+ 48*f0*f2^2*f3*f5*f8 - 64*f0*f2^2*f4^2*f8 + 16*f0*f2^2*f4*f5*f7 +
16*f0*f2*f3^2*f4*f8 - 4*f0*f2*f3^2*f5*f7 - 8*f1^4*f8^2 + 4*f1^3*f2*f7*f8 -
28*f1^3*f3*f6*f8 + 6*f1^3*f3*f7^2 + 8*f1^3*f4*f5*f8 - 2*f1^3*f5^2*f7 +
32*f1^2*f2^2*f6*f8 - 8*f1^2*f2^2*f7^2 - 12*f1^2*f2*f3*f5*f8 + 16*f1^2*f2*f4^2*f8
- 4*f1^2*f2*f4*f5*f7 - 4*f1^2*f3^2*f4*f8 + f1^2*f3^2*f5*f7)*x[1]^3*x[2] +
(-128*f0^3*f5*f8^2 + 128*f0^3*f6*f7*f8 - 32*f0^3*f7^3 + 64*f0^2*f1*f4*f8^2 -
24*f0^2*f1*f5*f7*f8 - 32*f0^2*f2*f3*f8^2 + 32*f0^2*f2*f4*f7*f8 +
64*f0^2*f2*f5*f6*f8 - 16*f0^2*f2*f5*f7^2 + 32*f0^2*f3^2*f7*f8 +
64*f0^2*f3*f4*f6*f8 - 32*f0^2*f3*f4*f7^2 - 48*f0^2*f3*f5^2*f8 +
8*f0^2*f3*f5*f6*f7 + 32*f0^2*f4^2*f5*f8 - 8*f0^2*f4*f5^2*f7 - 16*f0*f1^2*f3*f8^2
- 16*f0*f1^2*f5*f6*f8 + 4*f0*f1^2*f5*f7^2 + 32*f0*f1*f2^2*f8^2 -
56*f0*f1*f2*f3*f7*f8 - 32*f0*f1*f2*f4*f6*f8 + 16*f0*f1*f2*f4*f7^2 +
16*f0*f1*f2*f5^2*f8 - 8*f0*f1*f2*f5*f6*f7 - 16*f0*f1*f3^2*f6*f8 +
8*f0*f1*f3^2*f7^2 - 16*f0*f1*f3*f4*f5*f8 + 4*f0*f1*f3*f5^2*f7 + 32*f0*f2^3*f7*f8
+ 32*f0*f2^2*f3*f6*f8 - 16*f0*f2^2*f3*f7^2 + 32*f0*f2^2*f4*f5*f8 -
8*f0*f2^2*f5^2*f7 - 16*f0*f2*f3^2*f5*f8 - 8*f1^3*f2*f8^2 + 10*f1^3*f3*f7*f8 +
8*f1^3*f4*f6*f8 - 4*f1^3*f4*f7^2 - 4*f1^3*f5^2*f8 + 2*f1^3*f5*f6*f7 -
8*f1^2*f2^2*f7*f8 - 8*f1^2*f2*f3*f6*f8 + 4*f1^2*f2*f3*f7^2 - 8*f1^2*f2*f4*f5*f8
+ 2*f1^2*f2*f5^2*f7 + 4*f1^2*f3^2*f5*f8)*x[1]^3*x[3] + (64*f0^3*f6*f8^2 -
32*f0^3*f7^2*f8 + 32*f0^2*f1*f5*f8^2 - 48*f0^2*f1*f6*f7*f8 + 16*f0^2*f1*f7^3 +
48*f0^2*f3^2*f8^2 - 64*f0^2*f3*f4*f7*f8 + 48*f0^2*f3*f5*f6*f8 -
8*f0^2*f3*f5*f7^2 - 64*f0^2*f4^2*f6*f8 + 32*f0^2*f4^2*f7^2 - 16*f0^2*f4*f5*f6*f7
+ 8*f0^2*f5^3*f7 - 16*f0*f1^2*f4*f8^2 + 4*f0*f1^2*f5*f7*f8 - 48*f0*f1*f2*f3*f8^2
+ 32*f0*f1*f2*f4*f7*f8 - 64*f0*f1*f2*f5*f6*f8 + 16*f0*f1*f2*f5*f7^2 +
12*f0*f1*f3^2*f7*f8 + 16*f0*f1*f3*f4*f6*f8 - 8*f0*f1*f3*f4*f7^2 +
8*f0*f1*f3*f5^2*f8 + 4*f0*f1*f3*f5*f6*f7 - 16*f0*f2^2*f3*f7*f8 -
16*f0*f2*f3^2*f6*f8 + 8*f0*f2*f3^2*f7^2 - 16*f0*f2*f3*f4*f5*f8 +
4*f0*f2*f3*f5^2*f7 + 8*f0*f3^3*f5*f8 + 16*f1^3*f3*f8^2 - 8*f1^3*f4*f7*f8 +
16*f1^3*f5*f6*f8 - 4*f1^3*f5*f7^2 + 4*f1^2*f2*f3*f7*f8 + 4*f1^2*f3^2*f6*f8 -
2*f1^2*f3^2*f7^2 + 4*f1^2*f3*f4*f5*f8 - f1^2*f3*f5^2*f7)*x[1]^3*x[4] +
(-64*f0^3*f6*f8^2 + 16*f0^3*f7^2*f8 + 32*f0^2*f1*f5*f8^2 - 128*f0^2*f2*f4*f8^2 +
48*f0^2*f2*f5*f7*f8 - 128*f0^2*f2*f6^2*f8 + 32*f0^2*f2*f6*f7^2 -
32*f0^2*f3^2*f8^2 + 32*f0^2*f3*f4*f7*f8 + 64*f0^2*f3*f5*f6*f8 -
20*f0^2*f3*f5*f7^2 - 128*f0^2*f4^2*f6*f8 + 32*f0^2*f4^2*f7^2 +
32*f0^2*f4*f5^2*f8 + 16*f0*f1^2*f4*f8^2 - 12*f0*f1^2*f5*f7*f8 +
32*f0*f1^2*f6^2*f8 - 8*f0*f1^2*f6*f7^2 + 96*f0*f1*f2*f3*f8^2 -
16*f0*f1*f2*f4*f7*f8 + 4*f0*f1*f2*f5*f7^2 - 8*f0*f1*f3^2*f7*f8 +
64*f0*f1*f3*f4*f6*f8 - 16*f0*f1*f3*f4*f7^2 - 16*f0*f1*f3*f5^2*f8 -
64*f0*f2^3*f8^2 + 16*f0*f2^2*f3*f7*f8 - 128*f0*f2^2*f4*f6*f8 +
32*f0*f2^2*f4*f7^2 + 32*f0*f2^2*f5^2*f8 + 32*f0*f2*f3^2*f6*f8 -
8*f0*f2*f3^2*f7^2 - 16*f1^3*f3*f8^2 + 4*f1^3*f4*f7*f8 - f1^3*f5*f7^2 +
16*f1^2*f2^2*f8^2 - 4*f1^2*f2*f3*f7*f8 + 32*f1^2*f2*f4*f6*f8 - 8*f1^2*f2*f4*f7^2
- 8*f1^2*f2*f5^2*f8 - 8*f1^2*f3^2*f6*f8 + 2*f1^2*f3^2*f7^2)*x[1]^3*x[5] +
(32*f0^3*f7*f8^2 - 8*f0^2*f1*f7^2*f8 - 64*f0^2*f2*f5*f8^2 + 64*f0^2*f2*f6*f7*f8
- 16*f0^2*f2*f7^3 + 32*f0^2*f3*f4*f8^2 + 48*f0^2*f3*f5*f7*f8 -
128*f0^2*f3*f6^2*f8 + 32*f0^2*f3*f6*f7^2 - 32*f0^2*f4^2*f7*f8 +
128*f0^2*f4*f5*f6*f8 - 24*f0^2*f4*f5*f7^2 - 32*f0^2*f5^3*f8 + 16*f0*f1^2*f5*f8^2
- 16*f0*f1^2*f6*f7*f8 + 4*f0*f1^2*f7^3 + 64*f0*f1*f2*f4*f8^2 -
64*f0*f1*f2*f5*f7*f8 + 128*f0*f1*f2*f6^2*f8 - 32*f0*f1*f2*f6*f7^2 -
32*f0*f1*f3^2*f8^2 + 8*f0*f1*f3*f4*f7*f8 - 32*f0*f1*f3*f5*f6*f8 +
6*f0*f1*f3*f5*f7^2 + 32*f0*f2^2*f3*f8^2 - 8*f0*f2*f3^2*f7*f8 +
64*f0*f2*f3*f4*f6*f8 - 16*f0*f2*f3*f4*f7^2 - 16*f0*f2*f3*f5^2*f8 -
16*f0*f3^3*f6*f8 + 4*f0*f3^3*f7^2 - 16*f1^3*f4*f8^2 + 16*f1^3*f5*f7*f8 -
32*f1^3*f6^2*f8 + 8*f1^3*f6*f7^2 - 8*f1^2*f2*f3*f8^2 + 2*f1^2*f3^2*f7*f8 -
16*f1^2*f3*f4*f6*f8 + 4*f1^2*f3*f4*f7^2 + 4*f1^2*f3*f5^2*f8)*x[1]^3*x[6] +
(-64*f0^3*f8^3 + 16*f0^2*f1*f7*f8^2 - 64*f0^2*f2*f6*f8^2 + 16*f0^2*f2*f7^2*f8 -
96*f0^2*f3*f5*f8^2 + 96*f0^2*f3*f6*f7*f8 - 24*f0^2*f3*f7^3 + 16*f0^2*f4*f5*f7*f8
- 128*f0^2*f4*f6^2*f8 + 32*f0^2*f4*f6*f7^2 + 32*f0^2*f5^2*f6*f8 -
4*f0^2*f5^2*f7^2 + 16*f0*f1^2*f6*f8^2 - 4*f0*f1^2*f7^2*f8 + 96*f0*f1*f2*f5*f8^2
- 64*f0*f1*f2*f6*f7*f8 + 16*f0*f1*f2*f7^3 + 32*f0*f1*f3*f4*f8^2 -
24*f0*f1*f3*f5*f7*f8 + 64*f0*f1*f3*f6^2*f8 - 16*f0*f1*f3*f6*f7^2 -
128*f0*f2^2*f4*f8^2 + 64*f0*f2^2*f5*f7*f8 - 128*f0*f2^2*f6^2*f8 +
32*f0*f2^2*f6*f7^2 + 32*f0*f2*f3^2*f8^2 + 64*f0*f2*f3*f5*f6*f8 -
16*f0*f2*f3*f5*f7^2 - 128*f0*f2*f4^2*f6*f8 + 32*f0*f2*f4^2*f7^2 +
32*f0*f2*f4*f5^2*f8 + 32*f0*f3^2*f4*f6*f8 - 8*f0*f3^2*f4*f7^2 -
8*f0*f3^2*f5^2*f8 - 24*f1^3*f5*f8^2 + 16*f1^3*f6*f7*f8 - 4*f1^3*f7^3 +
32*f1^2*f2*f4*f8^2 - 16*f1^2*f2*f5*f7*f8 + 32*f1^2*f2*f6^2*f8 -
8*f1^2*f2*f6*f7^2 - 8*f1^2*f3^2*f8^2 - 16*f1^2*f3*f5*f6*f8 + 4*f1^2*f3*f5*f7^2 +
32*f1^2*f4^2*f6*f8 - 8*f1^2*f4^2*f7^2 - 8*f1^2*f4*f5^2*f8)*x[1]^3*x[7] +
(8*f0^2*f3*f7*f8 + 64*f0^2*f4*f6*f8 - 16*f0^2*f4*f7^2 - 16*f0^2*f5^2*f8 -
8*f0*f1*f2*f7*f8 - 32*f0*f1*f3*f6*f8 + 8*f0*f1*f3*f7^2 + 64*f0*f2^2*f6*f8 -
16*f0*f2^2*f7^2 - 24*f0*f2*f3*f5*f8 + 32*f0*f2*f4^2*f8 - 8*f0*f2*f4*f5*f7 -
8*f0*f3^2*f4*f8 + 2*f0*f3^2*f5*f7 + 2*f1^3*f7*f8 - 16*f1^2*f2*f6*f8 +
4*f1^2*f2*f7^2 + 6*f1^2*f3*f5*f8 - 8*f1^2*f4^2*f8 + 2*f1^2*f4*f5*f7)*x[1]^3*x[8]
+ (80*f0^3*f6*f8 - 16*f0^3*f7^2 - 24*f0^2*f1*f5*f8 + 48*f0^2*f2*f4*f8 -
16*f0^2*f2*f6^2 + 28*f0^2*f3^2*f8 - 8*f0^2*f3*f4*f7 + 16*f0^2*f3*f5*f6 -
16*f0^2*f4^2*f6 + 4*f0*f1^2*f6^2 - 64*f0*f1*f2*f3*f8 - 8*f0*f1*f2*f5*f6 +
4*f0*f1*f3^2*f7 + 8*f0*f1*f3*f4*f6 + 48*f0*f2^3*f8 - 8*f0*f2^2*f3*f7 -
16*f0*f2^2*f4*f6 + 4*f0*f2*f3^2*f6 + 10*f1^3*f3*f8 + 2*f1^3*f5*f6 -
12*f1^2*f2^2*f8 + 2*f1^2*f2*f3*f7 + 4*f1^2*f2*f4*f6 -
f1^2*f3^2*f6)*x[1]^2*x[2]^2 + (-48*f0^3*f7*f8 - 32*f0^2*f1*f6*f8 +
16*f0^2*f1*f7^2 - 32*f0^2*f2*f5*f8 - 80*f0^2*f3*f4*f8 + 28*f0^2*f3*f5*f7 -
16*f0^2*f3*f6^2 + 16*f0^2*f4*f5*f6 + 8*f0*f1^2*f5*f8 + 48*f0*f1*f2*f4*f8 -
12*f0*f1*f2*f5*f7 + 16*f0*f1*f2*f6^2 + 16*f0*f1*f3^2*f8 - 8*f0*f1*f3*f5*f6 -
32*f0*f2^2*f3*f8 + 16*f0*f2^2*f5*f6 + 8*f0*f2*f3^2*f7 - 12*f1^3*f4*f8 +
3*f1^3*f5*f7 - 4*f1^3*f6^2 + 8*f1^2*f2*f3*f8 - 4*f1^2*f2*f5*f6 -
2*f1^2*f3^2*f7)*x[1]^2*x[2]*x[3] + (-32*f0^3*f8^2 + 24*f0^2*f1*f7*f8 +
32*f0^2*f2*f6*f8 - 16*f0^2*f2*f7^2 - 56*f0^2*f3*f5*f8 + 96*f0^2*f4^2*f8 -
24*f0^2*f4*f5*f7 + 32*f0^2*f4*f6^2 - 16*f0^2*f5^2*f6 + 8*f0*f1^2*f6*f8 -
4*f0*f1^2*f7^2 + 48*f0*f1*f2*f5*f8 - 24*f0*f1*f3*f4*f8 - 2*f0*f1*f3*f5*f7 -
8*f0*f1*f3*f6^2 + 16*f0*f2*f3^2*f8 - 8*f0*f2*f3*f5*f6 - 4*f0*f3^3*f7 -
12*f1^3*f5*f8 - 4*f1^2*f3^2*f8 + 2*f1^2*f3*f5*f6)*x[1]^2*x[2]*x[4] +
(32*f0^3*f8^2 - 8*f0^2*f1*f7*f8 + 160*f0^2*f2*f6*f8 - 32*f0^2*f2*f7^2 -
64*f0^2*f3*f5*f8 + 8*f0^2*f3*f6*f7 + 96*f0^2*f4^2*f8 - 24*f0^2*f4*f5*f7 -
40*f0*f1^2*f6*f8 + 8*f0*f1^2*f7^2 - 8*f0*f1*f2*f6*f7 - 48*f0*f1*f3*f4*f8 +
12*f0*f1*f3*f5*f7 + 96*f0*f2^2*f4*f8 - 24*f0*f2^2*f5*f7 - 32*f0*f2*f3^2*f8 +
2*f1^3*f6*f7 - 24*f1^2*f2*f4*f8 + 6*f1^2*f2*f5*f7 +
8*f1^2*f3^2*f8)*x[1]^2*x[2]*x[5] + (-16*f0^2*f2*f7*f8 + 176*f0^2*f3*f6*f8 -
40*f0^2*f3*f7^2 - 96*f0^2*f4*f5*f8 - 16*f0^2*f4*f6*f7 + 24*f0^2*f5^2*f7 +
8*f0*f1^2*f7*f8 - 192*f0*f1*f2*f6*f8 + 48*f0*f1*f2*f7^2 + 32*f0*f1*f3*f5*f8 +
4*f0*f1*f3*f6*f7 - 48*f0*f2*f3*f4*f8 + 12*f0*f2*f3*f5*f7 + 16*f0*f3^3*f8 +
48*f1^3*f6*f8 - 12*f1^3*f7^2 + 12*f1^2*f3*f4*f8 -
3*f1^2*f3*f5*f7)*x[1]^2*x[2]*x[6] + (32*f0^2*f2*f8^2 - 48*f0^2*f3*f7*f8 +
96*f0^2*f4*f6*f8 - 16*f0^2*f5*f6*f7 - 16*f0*f1^2*f8^2 + 24*f0*f1*f2*f7*f8 -
80*f0*f1*f3*f6*f8 + 16*f0*f1*f3*f7^2 + 192*f0*f2^2*f6*f8 - 48*f0*f2^2*f7^2 -
72*f0*f2*f3*f5*f8 + 96*f0*f2*f4^2*f8 - 24*f0*f2*f4*f5*f7 - 24*f0*f3^2*f4*f8 +
6*f0*f3^2*f5*f7 - 6*f1^3*f7*f8 - 48*f1^2*f2*f6*f8 + 12*f1^2*f2*f7^2 +
18*f1^2*f3*f5*f8 - 24*f1^2*f4^2*f8 + 6*f1^2*f4*f5*f7)*x[1]^2*x[2]*x[7] +
(-48*f0^2*f4*f8 + 12*f0^2*f5*f7 + 24*f0*f1*f3*f8 - 48*f0*f2^2*f8 + 8*f0*f2*f3*f7
+ 16*f0*f2*f4*f6 - 4*f0*f3^2*f6 + 12*f1^2*f2*f8 - 2*f1^2*f3*f7 -
4*f1^2*f4*f6)*x[1]^2*x[2]*x[8] + (48*f0^3*f8^2 - 48*f0^2*f2*f6*f8 +
16*f0^2*f2*f7^2 + 32*f0^2*f3*f5*f8 + 8*f0^2*f3*f6*f7 - 16*f0^2*f4^2*f8 +
8*f0^2*f4*f5*f7 - 16*f0^2*f4*f6^2 + 20*f0*f1^2*f6*f8 - 8*f0*f1^2*f7^2 -
8*f0*f1*f2*f6*f7 + 16*f0*f1*f3*f4*f8 - 12*f0*f1*f3*f5*f7 + 8*f0*f1*f3*f6^2 -
48*f0*f2^2*f4*f8 + 24*f0*f2^2*f5*f7 - 16*f0*f2^2*f6^2 + 16*f0*f2*f3^2*f8 -
8*f0*f2*f3*f4*f7 + 2*f1^3*f6*f7 + 12*f1^2*f2*f4*f8 - 6*f1^2*f2*f5*f7 +
4*f1^2*f2*f6^2 - 4*f1^2*f3^2*f8 + 2*f1^2*f3*f4*f7)*x[1]^2*x[3]^2 +
(-32*f0^2*f1*f8^2 + 48*f0^2*f2*f7*f8 - 64*f0^2*f3*f6*f8 + 24*f0^2*f3*f7^2 +
48*f0^2*f4*f5*f8 - 32*f0^2*f4*f6*f7 - 20*f0^2*f5^2*f7 + 16*f0^2*f5*f6^2 -
12*f0*f1^2*f7*f8 + 64*f0*f1*f2*f6*f8 - 32*f0*f1*f2*f7^2 - 16*f0*f1*f3*f5*f8 +
8*f0*f1*f3*f6*f7 - 32*f0*f1*f4^2*f8 + 16*f0*f1*f4*f5*f7 + 48*f0*f2*f3*f4*f8 -
24*f0*f2*f3*f5*f7 + 16*f0*f2*f3*f6^2 - 16*f0*f3^3*f8 + 8*f0*f3^2*f4*f7 -
24*f1^3*f6*f8 + 12*f1^3*f7^2 - 4*f1^2*f3*f4*f8 + 6*f1^2*f3*f5*f7 -
4*f1^2*f3*f6^2)*x[1]^2*x[3]*x[4] + (-16*f0^2*f1*f8^2 - 48*f0^2*f2*f7*f8 -
48*f0^2*f3*f6*f8 + 16*f0^2*f3*f7^2 - 48*f0^2*f4*f5*f8 + 16*f0^2*f4*f6*f7 +
8*f0^2*f5^2*f7 + 16*f0*f1^2*f7*f8 + 16*f0*f1*f2*f6*f8 + 32*f0*f1*f3*f5*f8 -
8*f0*f1*f3*f6*f7 - 48*f0*f2^2*f5*f8 + 16*f0*f2^2*f6*f7 + 16*f0*f2*f3*f4*f8 +
4*f0*f2*f3*f5*f7 - 4*f1^3*f6*f8 + 12*f1^2*f2*f5*f8 - 4*f1^2*f2*f6*f7 -
4*f1^2*f3*f4*f8 - f1^2*f3*f5*f7)*x[1]^2*x[3]*x[5] + (-64*f0^2*f3*f7*f8 -
32*f0^2*f4*f6*f8 + 32*f0^2*f4*f7^2 + 48*f0^2*f5^2*f8 - 16*f0^2*f5*f6*f7 +
64*f0*f1*f2*f7*f8 + 16*f0*f1*f3*f6*f8 - 12*f0*f1*f3*f7^2 - 4*f0*f1*f5^2*f7 +
24*f0*f2*f3*f5*f8 - 8*f0*f2*f3*f6*f7 - 8*f0*f3^2*f4*f8 - 2*f0*f3^2*f5*f7 -
18*f1^3*f7*f8 - 10*f1^2*f3*f5*f8 + 2*f1^2*f3*f6*f7)*x[1]^2*x[3]*x[6] +
(112*f0^2*f3*f8^2 - 48*f0^2*f4*f7*f8 - 48*f0^2*f5*f6*f8 + 16*f0^2*f5*f7^2 -
80*f0*f1*f2*f8^2 + 28*f0*f1*f3*f7*f8 + 16*f0*f1*f4*f6*f8 - 8*f0*f1*f4*f7^2 +
4*f0*f1*f5*f6*f7 - 48*f0*f2^2*f7*f8 - 48*f0*f2*f3*f6*f8 + 24*f0*f2*f3*f7^2 -
48*f0*f2*f4*f5*f8 + 12*f0*f2*f5^2*f7 + 24*f0*f3^2*f5*f8 + 24*f1^3*f8^2 +
12*f1^2*f2*f7*f8 + 12*f1^2*f3*f6*f8 - 6*f1^2*f3*f7^2 + 12*f1^2*f4*f5*f8 -
3*f1^2*f5^2*f7)*x[1]^2*x[3]*x[7] + (8*f0^2*f5*f8 + 8*f0^2*f6*f7 + 8*f0*f1*f4*f8
- 6*f0*f1*f5*f7 + 16*f0*f2*f3*f8 - 8*f0*f2*f5*f6 - 4*f0*f3^2*f7 - 6*f1^2*f3*f8 +
2*f1^2*f5*f6)*x[1]^2*x[3]*x[8] + (-16*f0^2*f2*f8^2 + 48*f0^2*f3*f7*f8 -
32*f0^2*f4*f7^2 - 16*f0^2*f5^2*f8 + 40*f0^2*f5*f6*f7 - 16*f0^2*f6^3 +
8*f0*f1^2*f8^2 - 48*f0*f1*f2*f7*f8 + 8*f0*f1*f3*f6*f8 + 4*f0*f1*f3*f7^2 +
8*f0*f1*f4*f6*f7 - 2*f0*f1*f5^2*f7 - 64*f0*f2^2*f6*f8 + 32*f0*f2^2*f7^2 +
24*f0*f2*f3*f5*f8 - 8*f0*f2*f3*f6*f7 - 64*f0*f2*f4^2*f8 + 32*f0*f2*f4*f5*f7 -
32*f0*f2*f4*f6^2 + 8*f0*f2*f5^2*f6 + 20*f0*f3^2*f4*f8 + 2*f0*f3^2*f5*f7 +
4*f0*f3^2*f6^2 - 8*f0*f3*f4^2*f7 + 12*f1^3*f7*f8 + 24*f1^2*f2*f6*f8 -
12*f1^2*f2*f7^2 - 6*f1^2*f3*f5*f8 + 24*f1^2*f4^2*f8 - 12*f1^2*f4*f5*f7 +
8*f1^2*f4*f6^2 - 2*f1^2*f5^2*f6 - 8*f1*f2*f3*f4*f8 + 2*f1*f3^3*f8)*x[1]^2*x[4]^2
+ (-32*f0^2*f2*f8^2 + 8*f0^2*f3*f7*f8 + 64*f0^2*f4*f6*f8 - 16*f0^2*f4*f7^2 +
16*f0*f1^2*f8^2 + 16*f0*f1*f2*f7*f8 - 4*f0*f1*f3*f7^2 - 4*f0*f1*f5^2*f7 +
24*f0*f2*f3*f5*f8 - 8*f0*f2*f3*f6*f7 - 8*f0*f3^2*f4*f8 - 2*f0*f3^2*f5*f7 -
6*f1^3*f7*f8 - 10*f1^2*f3*f5*f8 + 2*f1^2*f3*f6*f7)*x[1]^2*x[4]*x[5] +
(-112*f0^2*f3*f8^2 + 96*f0^2*f4*f7*f8 - 64*f0^2*f5*f6*f8 - 8*f0^2*f5*f7^2 +
16*f0^2*f6^2*f7 + 96*f0*f1*f2*f8^2 - 20*f0*f1*f3*f7*f8 - 8*f0*f1*f4*f7^2 -
32*f0*f2^2*f7*f8 + 32*f0*f2*f3*f6*f8 - 8*f0*f2*f3*f7^2 + 32*f0*f2*f4*f6*f7 -
16*f0*f2*f5^2*f7 - 32*f0*f3^2*f5*f8 - 4*f0*f3^2*f6*f7 + 16*f0*f3*f4^2*f8 +
4*f0*f3*f4*f5*f7 - 24*f1^3*f8^2 + 12*f1^2*f2*f7*f8 - 12*f1^2*f3*f6*f8 +
6*f1^2*f3*f7^2 - 8*f1^2*f4*f6*f7 + 6*f1^2*f5^2*f7 +
8*f1*f2*f3*f5*f8)*x[1]^2*x[4]*x[6] + (-32*f0^2*f4*f8^2 + 8*f0^2*f5*f7*f8 +
32*f0^2*f6^2*f8 - 16*f0^2*f6*f7^2 + 16*f0*f1*f5*f6*f8 - 4*f0*f1*f5*f7^2 +
64*f0*f2^2*f8^2 + 16*f0*f2*f3*f7*f8 + 64*f0*f2*f4*f6*f8 - 32*f0*f2*f4*f7^2 -
4*f0*f3*f5^2*f7 - 24*f1^2*f2*f8^2 - 6*f1^2*f3*f7*f8 - 24*f1^2*f4*f6*f8 +
12*f1^2*f4*f7^2 - 2*f1^2*f5*f6*f7 - 4*f1*f3^2*f5*f8)*x[1]^2*x[4]*x[7] +
(-16*f0^2*f6*f8 + 8*f0^2*f7^2 - 4*f0*f1*f6*f7 + 32*f0*f2*f4*f8 - 24*f0*f2*f5*f7
+ 16*f0*f2*f6^2 - 20*f0*f3^2*f8 + 8*f0*f3*f4*f7 - 12*f1^2*f4*f8 + 9*f1^2*f5*f7 -
4*f1^2*f6^2 + 4*f1*f2*f3*f8)*x[1]^2*x[4]*x[8] + (64*f0^2*f2*f8^2 -
16*f0^2*f3*f7*f8 + 64*f0^2*f4*f6*f8 - 20*f0^2*f4*f7^2 - 16*f0^2*f5^2*f8 -
16*f0*f1^2*f8^2 - 24*f0*f1*f3*f6*f8 + 8*f0*f1*f3*f7^2 + 32*f0*f2^2*f6*f8 -
12*f0*f2^2*f7^2 - 8*f0*f2*f3*f5*f8 - 8*f1^2*f2*f6*f8 + 3*f1^2*f2*f7^2 +
2*f1^2*f3*f5*f8)*x[1]^2*x[5]^2 + (64*f0^2*f3*f8^2 - 16*f0^2*f4*f7*f8 -
32*f0^2*f5*f6*f8 + 12*f0^2*f5*f7^2 - 96*f0*f1*f2*f8^2 + 16*f0*f1*f3*f7*f8 -
32*f0*f1*f4*f6*f8 + 8*f0*f1*f4*f7^2 + 16*f0*f1*f5^2*f8 - 32*f0*f2*f3*f6*f8 +
12*f0*f2*f3*f7^2 + 8*f0*f3^2*f5*f8 + 24*f1^3*f8^2 + 16*f1^2*f3*f6*f8 -
5*f1^2*f3*f7^2)*x[1]^2*x[5]*x[6] + (32*f0^2*f4*f8^2 - 16*f0^2*f5*f7*f8 +
64*f0^2*f6^2*f8 - 16*f0^2*f6*f7^2 - 48*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 -
16*f0*f1*f5*f6*f8 + 2*f0*f1*f5*f7^2 + 96*f0*f2^2*f8^2 - 24*f0*f2*f3*f7*f8 +
192*f0*f2*f4*f6*f8 - 48*f0*f2*f4*f7^2 - 48*f0*f2*f5^2*f8 - 48*f0*f3^2*f6*f8 +
12*f0*f3^2*f7^2 - 24*f1^2*f2*f8^2 + 6*f1^2*f3*f7*f8 - 48*f1^2*f4*f6*f8 +
12*f1^2*f4*f7^2 + 12*f1^2*f5^2*f8)*x[1]^2*x[5]*x[7] + (-32*f0^2*f6*f8 +
4*f0^2*f7^2 + 8*f0*f1*f5*f8 - 48*f0*f2*f4*f8 + 12*f0*f2*f5*f7 + 16*f0*f3^2*f8 +
12*f1^2*f4*f8 - 3*f1^2*f5*f7)*x[1]^2*x[5]*x[8] + (-32*f0^2*f4*f8^2 -
8*f0^2*f5*f7*f8 + 32*f0^2*f6^2*f8 - 12*f0^2*f6*f7^2 + 16*f0*f1*f3*f8^2 +
8*f0*f1*f4*f7*f8 + 8*f0*f2*f3*f7*f8 - 96*f0*f2*f4*f6*f8 + 16*f0*f2*f4*f7^2 +
32*f0*f2*f5^2*f8 + 40*f0*f3^2*f6*f8 - 9*f0*f3^2*f7^2 - 8*f0*f3*f4*f5*f8 -
6*f1^2*f3*f7*f8 + 32*f1^2*f4*f6*f8 - 6*f1^2*f4*f7^2 - 12*f1^2*f5^2*f8 -
8*f1*f2*f3*f6*f8 + 2*f1*f2*f3*f7^2)*x[1]^2*x[6]^2 + (64*f0^2*f5*f8^2 -
48*f0^2*f6*f7*f8 + 16*f0^2*f7^3 - 32*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 -
32*f0*f1*f6^2*f8 + 8*f0*f1*f6*f7^2 - 64*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 -
32*f0*f2*f5*f6*f8 + 8*f0*f2*f5*f7^2 - 32*f0*f3*f4*f6*f8 + 8*f0*f3*f4*f7^2 +
16*f0*f3*f5^2*f8 + 24*f1^2*f3*f8^2 - 12*f1^2*f4*f7*f8 + 16*f1^2*f5*f6*f8 -
3*f1^2*f5*f7^2 + 8*f1*f3^2*f6*f8 - 2*f1*f3^2*f7^2)*x[1]^2*x[6]*x[7] +
(-8*f0^2*f7*f8 + 16*f0*f1*f6*f8 - 2*f0*f1*f7^2 + 32*f0*f2*f5*f8 - 8*f0*f2*f6*f7
- 4*f0*f3*f5*f7 - 12*f1^2*f5*f8 + 2*f1^2*f6*f7 - 2*f1*f3^2*f8)*x[1]^2*x[6]*x[8]
+ (-4*f0^2*f7^2*f8 - 16*f0*f1*f5*f8^2 + 8*f0*f1*f6*f7*f8 - 2*f0*f1*f7^3 +
32*f0*f2*f4*f8^2 - 32*f0*f2*f5*f7*f8 + 64*f0*f2*f6^2*f8 - 16*f0*f2*f6*f7^2 -
24*f0*f3*f5*f6*f8 + 6*f0*f3*f5*f7^2 + 32*f0*f4^2*f6*f8 - 8*f0*f4^2*f7^2 -
8*f0*f4*f5^2*f8 + 6*f1^2*f5*f7*f8 - 16*f1^2*f6^2*f8 + 4*f1^2*f6*f7^2 -
8*f1*f3*f4*f6*f8 + 2*f1*f3*f4*f7^2 + 2*f1*f3*f5^2*f8)*x[1]^2*x[7]^2 +
(16*f0^2*f8^2 - 80*f0*f2*f6*f8 + 24*f0*f2*f7^2 + 20*f0*f3*f5*f8 - 16*f0*f4^2*f8
+ 4*f0*f4*f5*f7 + 20*f1^2*f6*f8 - 6*f1^2*f7^2 + 4*f1*f3*f4*f8 -
f1*f3*f5*f7)*x[1]^2*x[7]*x[8] + (-16*f0^3*f8 + 16*f0^2*f2*f6 - 16*f0^2*f3*f5 +
16*f0^2*f4^2 - 4*f0*f1^2*f6 + 8*f0*f1*f2*f5 - 8*f0*f1*f3*f4 + 16*f0*f2^2*f4 -
4*f0*f2*f3^2 - 2*f1^3*f5 - 4*f1^2*f2*f4 + f1^2*f3^2)*x[1]*x[2]^3 +
(16*f0^2*f1*f8 - 16*f0^2*f2*f7 + 16*f0^2*f3*f6 - 24*f0^2*f4*f5 + 4*f0*f1^2*f7 -
16*f0*f1*f2*f6 + 12*f0*f1*f3*f5 - 24*f0*f2^2*f5 + 4*f1^3*f6 +
6*f1^2*f2*f5)*x[1]*x[2]^2*x[3] + (-16*f0^2*f2*f8 + 16*f0^2*f3*f7 - 32*f0^2*f4*f6
+ 24*f0^2*f5^2 - 4*f0*f1^2*f8 + 8*f0*f1*f3*f6 + 12*f0*f2*f3*f5 -
3*f1^2*f3*f5)*x[1]*x[2]^2*x[4] + (-16*f0^2*f2*f8 - 12*f0^2*f3*f7 + 16*f0^2*f4*f6
+ 4*f0*f1^2*f8 + 12*f0*f1*f2*f7 - 8*f0*f1*f3*f6 + 16*f0*f2^2*f6 - 3*f1^3*f7 -
4*f1^2*f2*f6)*x[1]*x[2]^2*x[5] + (-56*f0^2*f3*f8 + 24*f0^2*f4*f7 - 16*f0^2*f5*f6
+ 48*f0*f1*f2*f8 - 6*f0*f1*f3*f7 - 8*f0*f2*f3*f6 - 12*f1^3*f8 +
2*f1^2*f3*f6)*x[1]*x[2]^2*x[6] + (-12*f0^2*f5*f7 + 16*f0^2*f6^2 + 16*f0*f1*f3*f8
- 48*f0*f2^2*f8 + 8*f0*f2*f3*f7 + 16*f0*f2*f4*f6 - 4*f0*f3^2*f6 + 12*f1^2*f2*f8
- 2*f1^2*f3*f7 - 4*f1^2*f4*f6)*x[1]*x[2]^2*x[7] + (-8*f0^2*f6 - 24*f0*f2*f4 +
6*f0*f3^2 + 6*f1^2*f4)*x[1]*x[2]^2*x[8] + (32*f0^2*f2*f8 - 32*f0^2*f3*f7 +
16*f0^2*f4*f6 + 8*f0^2*f5^2 - 12*f0*f1^2*f8 + 24*f0*f1*f2*f7 - 8*f0*f1*f3*f6 +
16*f0*f2^2*f6 + 4*f0*f2*f3*f5 - 6*f1^3*f7 - 4*f1^2*f2*f6 -
f1^2*f3*f5)*x[1]*x[2]*x[3]^2 + (16*f0^2*f3*f8 + 64*f0^2*f4*f7 - 16*f0^2*f5*f6 -
32*f0*f1*f2*f8 - 16*f0*f1*f3*f7 - 8*f0*f1*f5^2 - 16*f0*f2*f3*f6 - 4*f0*f3^2*f5 +
12*f1^3*f8 + 4*f1^2*f3*f6)*x[1]*x[2]*x[3]*x[4] + (72*f0^2*f3*f8 - 8*f0^2*f4*f7 -
16*f0^2*f5*f6 - 48*f0*f1*f2*f8 + 8*f0*f1*f3*f7 - 24*f0*f2^2*f7 - 8*f0*f2*f3*f6 +
12*f1^3*f8 + 6*f1^2*f2*f7 + 2*f1^2*f3*f6)*x[1]*x[2]*x[3]*x[5] + (-16*f0^2*f5*f7
+ 16*f0^2*f6^2 - 8*f0*f1*f4*f7 + 8*f0*f1*f5*f6 + 12*f0*f2*f3*f7 + 4*f0*f3^2*f6 -
f1^2*f3*f7)*x[1]*x[2]*x[3]*x[6] + (32*f0^2*f5*f8 - 8*f0^2*f6*f7 - 16*f0*f1*f4*f8
+ 8*f0*f1*f5*f7 - 8*f0*f1*f6^2 + 32*f0*f2*f3*f8 - 16*f0*f2*f5*f6 - 8*f0*f3^2*f7
- 6*f1^2*f3*f8 + 4*f1^2*f5*f6)*x[1]*x[2]*x[3]*x[7] + (-12*f0^2*f7 + 4*f0*f1*f6 +
24*f0*f2*f5 - 6*f1^2*f5)*x[1]*x[2]*x[3]*x[8] + (-16*f0^2*f4*f8 - 32*f0^2*f5*f7 +
16*f0^2*f6^2 - 8*f0*f1*f4*f7 + 32*f0*f2^2*f8 - 8*f0*f2*f3*f7 + 32*f0*f2*f4*f6 -
16*f0*f2*f5^2 - 4*f0*f3^2*f6 + 4*f0*f3*f4*f5 - 12*f1^2*f2*f8 + 6*f1^2*f3*f7 -
8*f1^2*f4*f6 + 6*f1^2*f5^2)*x[1]*x[2]*x[4]^2 + (-96*f0^2*f4*f8 + 32*f0^2*f5*f7 -
16*f0^2*f6^2 + 16*f0*f1*f3*f8 - 8*f0*f1*f4*f7 + 8*f0*f1*f5*f6 + 12*f0*f2*f3*f7 +
4*f0*f3^2*f6 - f1^2*f3*f7)*x[1]*x[2]*x[4]*x[5] + (80*f0^2*f5*f8 - 24*f0^2*f6*f7
+ 4*f0*f1*f5*f7 - 8*f0*f2*f3*f8 - 32*f0*f2*f4*f7 + 16*f0*f2*f5*f6 +
10*f0*f3^2*f7 - 8*f0*f3*f4*f6 + 12*f1^2*f4*f7 - 8*f1^2*f5*f6 -
4*f1*f2*f3*f7)*x[1]*x[2]*x[4]*x[6] + (-48*f0^2*f6*f8 + 24*f0^2*f7^2 -
16*f0*f1*f5*f8 + 4*f0*f1*f6*f7 - 64*f0*f2*f4*f8 + 32*f0*f2*f5*f7 - 16*f0*f2*f6^2
+ 12*f0*f3^2*f8 + 8*f0*f3*f5*f6 + 24*f1^2*f4*f8 - 12*f1^2*f5*f7 + 8*f1^2*f6^2 -
4*f1*f2*f3*f8 + 2*f1*f3^2*f7)*x[1]*x[2]*x[4]*x[7] + (16*f0^2*f8 + 2*f0*f1*f7 -
8*f0*f2*f6 - 8*f0*f3*f5)*x[1]*x[2]*x[4]*x[8] + (-32*f0^2*f4*f8 + 8*f0^2*f5*f7 +
8*f0*f1*f3*f8 + 4*f0*f2*f3*f7 - f1^2*f3*f7)*x[1]*x[2]*x[5]^2 + (32*f0*f1*f4*f8 -
8*f0*f1*f5*f7 - 4*f0*f3^2*f7 - 8*f1^2*f3*f8)*x[1]*x[2]*x[5]*x[6] +
(-16*f0^2*f6*f8 - 4*f0^2*f7^2 + 4*f0*f1*f6*f7 - 96*f0*f2*f4*f8 + 24*f0*f2*f5*f7
+ 32*f0*f3^2*f8 + 24*f1^2*f4*f8 - 6*f1^2*f5*f7)*x[1]*x[2]*x[5]*x[7] +
(16*f0^2*f8 - 16*f0*f2*f6 + 4*f1^2*f6)*x[1]*x[2]*x[5]*x[8] + (-32*f0^2*f6*f8 +
16*f0^2*f7^2 + 64*f0*f2*f4*f8 - 16*f0*f2*f5*f7 - 28*f0*f3^2*f8 + 4*f0*f3*f4*f7 -
24*f1^2*f4*f8 + 6*f1^2*f5*f7 + 8*f1*f2*f3*f8)*x[1]*x[2]*x[6]^2 + (-8*f0^2*f7*f8
+ 32*f0*f1*f6*f8 - 10*f0*f1*f7^2 + 8*f0*f2*f6*f7 + 16*f0*f3*f4*f8 -
8*f0*f3*f5*f7 - 4*f1^2*f6*f7 - 6*f1*f3^2*f8)*x[1]*x[2]*x[6]*x[7] + (-8*f0*f1*f8
+ 8*f0*f3*f6)*x[1]*x[2]*x[6]*x[8] + (16*f0^2*f8^2 - 48*f0*f2*f6*f8 +
8*f0*f2*f7^2 + 16*f0*f3*f5*f8 - 16*f0*f4^2*f8 + 4*f0*f4*f5*f7 + 8*f1^2*f6*f8 +
4*f1*f3*f4*f8 - f1*f3*f5*f7)*x[1]*x[2]*x[7]^2 + (56*f0*f2*f8 - 8*f0*f3*f7 -
8*f0*f4*f6 - 12*f1^2*f8 + 2*f1*f3*f6)*x[1]*x[2]*x[7]*x[8] + (4*f0*f4 -
f1*f3)*x[1]*x[2]*x[8]^2 + (-8*f0^2*f5*f6 - 8*f0*f1*f2*f8 + 8*f0*f1*f3*f7 -
16*f0*f2^2*f7 + 2*f1^3*f8 + 4*f1^2*f2*f7)*x[1]*x[3]^3 + (-48*f0^2*f4*f8 +
8*f0^2*f5*f7 + 20*f0*f1*f3*f8 - 16*f0*f1*f4*f7 + 8*f0*f1*f5*f6 + 24*f0*f2*f3*f7
- 6*f1^2*f3*f7)*x[1]*x[3]^2*x[4] + (16*f0^2*f4*f8 - 4*f0^2*f5*f7 + 16*f0^2*f6^2
- 24*f0*f1*f3*f8 + 48*f0*f2^2*f8 + 8*f0*f2*f3*f7 - 12*f1^2*f2*f8 -
2*f1^2*f3*f7)*x[1]*x[3]^2*x[5] + (-8*f0^2*f6*f7 + 8*f0*f1*f5*f7 - 8*f0*f1*f6^2 -
24*f0*f2*f3*f8 - 4*f0*f3^2*f7 + 8*f1^2*f3*f8)*x[1]*x[3]^2*x[6] + (8*f0^2*f7^2 -
8*f0*f1*f5*f8 + 48*f0*f2*f4*f8 - 24*f0*f2*f5*f7 + 16*f0*f2*f6^2 - 16*f0*f3^2*f8
+ 8*f0*f3*f4*f7 - 12*f1^2*f4*f8 + 6*f1^2*f5*f7 - 4*f1^2*f6^2)*x[1]*x[3]^2*x[7] +
(8*f0^2*f8 + 4*f0*f1*f7 - 8*f0*f2*f6 - 2*f0*f3*f5 + 2*f1^2*f6)*x[1]*x[3]^2*x[8]
+ (24*f0^2*f5*f8 - 16*f0^2*f6*f7 + 24*f0*f1*f4*f8 + 8*f0*f1*f5*f7 -
8*f0*f2*f3*f8 - 32*f0*f2*f4*f7 + 2*f0*f3*f5^2 - 6*f1^2*f3*f8 + 12*f1^2*f4*f7 -
2*f1^2*f5*f6)*x[1]*x[3]*x[4]^2 + (-16*f0^2*f5*f8 + 8*f0^2*f6*f7 + 32*f0*f1*f4*f8
- 4*f0*f1*f5*f7 - 8*f0*f1*f6^2 - 48*f0*f2*f3*f8 - 8*f0*f3^2*f7 +
10*f1^2*f3*f8)*x[1]*x[3]*x[4]*x[5] + (16*f0^2*f6*f8 + 8*f0^2*f7^2 -
24*f0*f1*f5*f8 + 4*f0*f1*f6*f7 + 32*f0*f2*f5*f7 - 16*f0*f2*f6^2 + 28*f0*f3^2*f8
- 12*f1^2*f5*f7 + 8*f1^2*f6^2 - 4*f1*f2*f3*f8 +
2*f1*f3^2*f7)*x[1]*x[3]*x[4]*x[6] + (-24*f0^2*f7*f8 + 16*f0*f1*f6*f8 -
12*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 16*f0*f2*f6*f7 - 8*f0*f3*f4*f8 - 8*f0*f3*f6^2 +
12*f1^2*f5*f8 - 4*f1^2*f6*f7 + 4*f1*f3^2*f8 - 4*f1*f3*f4*f7)*x[1]*x[3]*x[4]*x[7]
+ (-8*f0*f1*f8 + 16*f0*f2*f7 + 4*f0*f3*f6 - 6*f1^2*f7 +
f1*f3*f5)*x[1]*x[3]*x[4]*x[8] + (16*f0^2*f5*f8 - 16*f0^2*f6*f7 - 16*f0*f2*f3*f8
+ 4*f1^2*f3*f8)*x[1]*x[3]*x[5]^2 + (16*f0^2*f6*f8 - 4*f0^2*f7^2 - 16*f0*f1*f5*f8
+ 12*f0*f1*f6*f7 + 16*f0*f3^2*f8)*x[1]*x[3]*x[5]*x[6] + (48*f0*f2*f5*f8 -
16*f0*f2*f6*f7 - 16*f0*f3*f4*f8 - 4*f0*f3*f5*f7 - 12*f1^2*f5*f8 +
4*f1^2*f6*f7)*x[1]*x[3]*x[5]*x[7] + (-8*f0*f1*f8 + 12*f0*f2*f7 + 4*f0*f3*f6 -
3*f1^2*f7)*x[1]*x[3]*x[5]*x[8] + (-2*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 8*f0*f2*f6*f7
+ 2*f0*f3*f5*f7 + 12*f1^2*f5*f8 - 4*f1^2*f6*f7 - 2*f1*f3^2*f8)*x[1]*x[3]*x[6]^2
+ (4*f0*f1*f7*f8 + 16*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 4*f0*f3*f5*f8 +
4*f0*f3*f6*f7 - 8*f1^2*f6*f8 + 6*f1^2*f7^2 + 4*f1*f3*f4*f8 +
f1*f3*f5*f7)*x[1]*x[3]*x[6]*x[7] + (-40*f0*f2*f8 - 2*f0*f3*f7 + 12*f1^2*f8 -
2*f1*f3*f6)*x[1]*x[3]*x[6]*x[8] + (-8*f0*f1*f8^2 + 24*f0*f2*f7*f8 +
8*f0*f4*f5*f8 - 2*f0*f5^2*f7 - 6*f1^2*f7*f8 - 4*f1*f3*f5*f8)*x[1]*x[3]*x[7]^2 +
(-4*f0*f3*f8 + 4*f0*f5*f6 + 2*f1*f3*f7)*x[1]*x[3]*x[7]*x[8] -
2*f0*f5*x[1]*x[3]*x[8]^2 + (-16*f0^2*f6*f8 + 16*f0^2*f7^2 - 4*f0*f1*f5*f8 +
16*f0*f2*f4*f8 + 8*f0*f2*f5*f7 - 4*f0*f3^2*f8 + 8*f0*f3*f4*f7 - 8*f1^2*f4*f8 -
4*f1^2*f5*f7 + 4*f1*f2*f3*f8 - 2*f1*f3^2*f7 - f1*f3*f5^2)*x[1]*x[4]^3 +
(16*f0^2*f6*f8 - 4*f0*f1*f5*f8 - 4*f0*f1*f6*f7 + 64*f0*f2*f4*f8 - 24*f0*f2*f5*f7
+ 16*f0*f2*f6^2 - 12*f0*f3^2*f8 + 8*f0*f3*f4*f7 - 4*f0*f3*f5*f6 - 24*f1^2*f4*f8
+ 9*f1^2*f5*f7 - 4*f1^2*f6^2 + 4*f1*f2*f3*f8)*x[1]*x[4]^2*x[5] + (-48*f0^2*f7*f8
+ 8*f0*f1*f6*f8 - 4*f0*f1*f7^2 - 24*f0*f2*f5*f8 - 24*f0*f3*f4*f8 - 8*f0*f3*f5*f7
+ 12*f1^2*f5*f8 + 2*f1*f3^2*f8 + 2*f1*f3*f5*f6)*x[1]*x[4]^2*x[6] + (32*f0^2*f8^2
+ 12*f0*f1*f7*f8 + 64*f0*f2*f6*f8 - 32*f0*f2*f7^2 - 4*f0*f3*f5*f8 +
16*f0*f4^2*f8 - 8*f0*f4*f5*f7 + 16*f0*f4*f6^2 - 4*f0*f5^2*f6 - 24*f1^2*f6*f8 +
12*f1^2*f7^2 - 4*f1*f3*f4*f8 + 6*f1*f3*f5*f7 - 4*f1*f3*f6^2)*x[1]*x[4]^2*x[7] +
(-16*f0*f2*f8 - 4*f0*f3*f7 - 8*f0*f4*f6 + 2*f0*f5^2 + 6*f1^2*f8 +
2*f1*f3*f6)*x[1]*x[4]^2*x[8] + (-16*f0^2*f6*f8 + 4*f0^2*f7^2 + 4*f0*f1*f6*f7 +
8*f0*f3^2*f8)*x[1]*x[4]*x[5]^2 + (-8*f0^2*f7*f8 + 2*f0*f1*f7^2 - 8*f0*f2*f6*f7 -
16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 - 2*f1*f3^2*f8)*x[1]*x[4]*x[5]*x[6] +
(4*f0*f1*f7*f8 - 48*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 4*f0*f3*f5*f8 + 4*f0*f3*f6*f7
+ 16*f1^2*f6*f8 - 6*f1^2*f7^2 + 4*f1*f3*f4*f8 + f1*f3*f5*f7)*x[1]*x[4]*x[5]*x[7]
+ (8*f0*f2*f8 - 8*f0*f3*f7)*x[1]*x[4]*x[5]*x[8] + (48*f0^2*f8^2 + 4*f0*f1*f7*f8
+ 28*f0*f3*f5*f8 - 3*f1*f3*f5*f7)*x[1]*x[4]*x[6]^2 + (-32*f0*f1*f8^2 +
32*f0*f2*f7*f8 - 16*f0*f3*f6*f8 + 8*f0*f3*f7^2 - 16*f0*f4*f6*f7 + 4*f0*f5^2*f7 -
12*f1^2*f7*f8 - 8*f1*f3*f5*f8 + 4*f1*f3*f6*f7)*x[1]*x[4]*x[6]*x[7] +
(20*f0*f3*f8 + 4*f0*f4*f7 - f1*f3*f7)*x[1]*x[4]*x[6]*x[8] + (-64*f0*f2*f8^2 -
4*f0*f3*f7*f8 - 16*f0*f4*f6*f8 + 8*f0*f4*f7^2 + 4*f0*f5*f6*f7 + 24*f1^2*f8^2 +
12*f1*f3*f6*f8 - 6*f1*f3*f7^2)*x[1]*x[4]*x[7]^2 + (2*f0*f5*f7 - 8*f0*f6^2 -
2*f1*f3*f8)*x[1]*x[4]*x[7]*x[8] + 4*f0*f6*x[1]*x[4]*x[8]^2 +
4*f0^2*f7^2*x[1]*x[5]^3 - 4*f0*f1*f7^2*x[1]*x[5]^2*x[6] + (-32*f0*f2*f6*f8 +
12*f0*f2*f7^2 + 8*f0*f3*f5*f8 + 8*f1^2*f6*f8 - 3*f1^2*f7^2)*x[1]*x[5]^2*x[7] -
2*f0*f3*f7*x[1]*x[5]^2*x[8] + (-16*f0^2*f8^2 + 32*f0*f2*f6*f8 - 8*f0*f2*f7^2 -
8*f0*f3*f5*f8 - 8*f1^2*f6*f8 + 3*f1^2*f7^2)*x[1]*x[5]*x[6]^2 + (16*f0*f1*f8^2 +
16*f0*f3*f6*f8 - 6*f0*f3*f7^2 - 4*f1*f3*f5*f8)*x[1]*x[5]*x[6]*x[7] + (4*f0*f3*f8
+ f1*f3*f7)*x[1]*x[5]*x[6]*x[8] + (-16*f0*f2*f8^2 - 32*f0*f4*f6*f8 +
8*f0*f4*f7^2 + 8*f0*f5^2*f8 + 8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*x[1]*x[5]*x[7]^2 +
(16*f0*f4*f8 - 4*f0*f5*f7 - 6*f1*f3*f8)*x[1]*x[5]*x[7]*x[8] + (-16*f0*f3*f6*f8 +
4*f0*f3*f7^2 + 4*f1*f3*f5*f8)*x[1]*x[6]^3 + (-8*f0*f3*f7*f8 + 32*f0*f4*f6*f8 -
4*f0*f4*f7^2 - 8*f0*f5^2*f8 - 8*f1*f3*f6*f8 + f1*f3*f7^2)*x[1]*x[6]^2*x[7] +
(-8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8)*x[1]*x[6]^2*x[8] + (24*f0*f3*f8^2 -
8*f0*f4*f7*f8 - 2*f0*f5*f7^2 + 6*f1*f3*f7*f8)*x[1]*x[6]*x[7]^2 + (-8*f0*f5*f8 +
4*f0*f6*f7)*x[1]*x[6]*x[7]*x[8] + (4*f0*f5*f7*f8 - 8*f1*f3*f8^2)*x[1]*x[7]^3 +
(8*f0*f6*f8 - 4*f0*f7^2)*x[1]*x[7]^2*x[8] - 4*f0*f8*x[1]*x[7]*x[8]^2 +
(4*f0^2*f3 - 4*f0*f1*f2 + f1^3)*x[2]^3*x[3] + (-8*f0^2*f4 +
2*f0*f1*f3)*x[2]^3*x[4] + (-8*f0^2*f4 + 4*f0*f1*f3 - 8*f0*f2^2 +
2*f1^2*f2)*x[2]^3*x[5] + (8*f0^2*f5 + 4*f0*f2*f3 - f1^2*f3)*x[2]^3*x[6] +
(-8*f0^2*f6 - 8*f0*f2*f4 + 2*f0*f3^2 + 2*f1^2*f4)*x[2]^3*x[7] +
4*f0^2*x[2]^3*x[8] + (4*f0^2*f4 - 4*f0*f1*f3 + 12*f0*f2^2 -
3*f1^2*f2)*x[2]^2*x[3]^2 + (-12*f0^2*f5 + 8*f0*f1*f4 - 12*f0*f2*f3 +
f1^2*f3)*x[2]^2*x[3]*x[4] + (8*f0^2*f5 + 4*f0*f2*f3 - f1^2*f3)*x[2]^2*x[3]*x[5]
+ (-8*f0^2*f6 - 4*f0*f1*f5 - 2*f0*f3^2)*x[2]^2*x[3]*x[6] + (12*f0^2*f7 +
4*f0*f1*f6 + 12*f0*f2*f5 - 3*f1^2*f5)*x[2]^2*x[3]*x[7] -
2*f0*f1*x[2]^2*x[3]*x[8] + (12*f0^2*f6 + 16*f0*f2*f4 - 3*f0*f3^2 - 6*f1^2*f4 +
2*f1*f2*f3)*x[2]^2*x[4]^2 + (8*f0^2*f6 - 4*f0*f1*f5 -
2*f0*f3^2)*x[2]^2*x[4]*x[5] + (-8*f0^2*f7 - 16*f0*f2*f5 + 4*f0*f3*f4 +
6*f1^2*f5)*x[2]^2*x[4]*x[6] + (-8*f0^2*f8 - 2*f0*f1*f7 + 8*f0*f2*f6 - 4*f0*f3*f5
- 4*f1^2*f6)*x[2]^2*x[4]*x[7] + (-8*f0*f2 + 3*f1^2)*x[2]^2*x[4]*x[8] +
4*f0^2*f7*x[2]^2*x[5]*x[6] + (-8*f0^2*f8 - 2*f0*f1*f7 - 8*f0*f2*f6 +
2*f1^2*f6)*x[2]^2*x[5]*x[7] + (12*f0*f2 - 3*f1^2)*x[2]^2*x[5]*x[8] + (8*f0^2*f8
- 2*f0*f1*f7 + 8*f0*f2*f6 - 2*f1^2*f6)*x[2]^2*x[6]^2 + (-8*f0*f2*f7 +
3*f1^2*f7)*x[2]^2*x[6]*x[7] - 4*f0*f3*x[2]^2*x[6]*x[8] +
2*f0*f3*f7*x[2]^2*x[7]^2 + (4*f0*f4 - f1*f3)*x[2]^2*x[7]*x[8] + (-4*f0^2*f5 -
8*f0*f2*f3 + 2*f1^2*f3)*x[2]*x[3]^3 + (16*f0^2*f6 + 4*f0*f1*f5 +
12*f0*f3^2)*x[2]*x[3]^2*x[4] - 8*f0^2*f6*x[2]*x[3]^2*x[5] + (4*f0^2*f7 +
4*f0*f1*f6)*x[2]*x[3]^2*x[6] + (-16*f0^2*f8 - 4*f0*f1*f7 - 8*f0*f2*f6 -
2*f0*f3*f5 + 2*f1^2*f6)*x[2]*x[3]^2*x[7] + (-12*f0*f2 + 3*f1^2)*x[2]*x[3]^2*x[8]
+ (-8*f0^2*f7 - 16*f0*f1*f6 + 8*f0*f2*f5 - 16*f0*f3*f4 - 3*f1^2*f5 -
2*f1*f3^2)*x[2]*x[3]*x[4]^2 + (-28*f0^2*f7 + 4*f0*f1*f6)*x[2]*x[3]*x[4]*x[5] +
(14*f0*f1*f7 + 8*f0*f2*f6 + 4*f0*f3*f5 - 4*f1^2*f6)*x[2]*x[3]*x[4]*x[6] +
(16*f0*f1*f8 - 16*f0*f2*f7 + 4*f0*f3*f6 + 6*f1^2*f7 +
f1*f3*f5)*x[2]*x[3]*x[4]*x[7] + 18*f0*f3*x[2]*x[3]*x[4]*x[8] +
4*f0^2*f7*x[2]*x[3]*x[5]^2 - 4*f0*f1*f7*x[2]*x[3]*x[5]*x[6] + (8*f0*f1*f8 +
12*f0*f2*f7 + 4*f0*f3*f6 - 3*f1^2*f7)*x[2]*x[3]*x[5]*x[7] -
4*f0*f3*x[2]*x[3]*x[5]*x[8] + (-4*f0*f1*f8 - 8*f0*f2*f7 - 4*f0*f3*f6 +
3*f1^2*f7)*x[2]*x[3]*x[6]^2 + (40*f0*f2*f8 - 12*f1^2*f8)*x[2]*x[3]*x[6]*x[7] +
f1*f3*x[2]*x[3]*x[6]*x[8] - 12*f0*f3*f8*x[2]*x[3]*x[7]^2 -
4*f0*f5*x[2]*x[3]*x[7]*x[8] + (4*f0*f1*f7 - 16*f0*f2*f6 + 4*f0*f3*f5 + 8*f1^2*f6
+ 4*f1*f3*f4)*x[2]*x[4]^3 + (16*f0^2*f8 + 10*f0*f1*f7 - 8*f0*f2*f6 + 2*f0*f3*f5
+ 2*f1^2*f6)*x[2]*x[4]^2*x[5] + (-8*f0*f1*f8 + 24*f0*f2*f7 - 12*f1^2*f7 -
3*f1*f3*f5)*x[2]*x[4]^2*x[6] + (8*f0*f2*f8 - 8*f0*f4*f6 + 2*f0*f5^2 - 6*f1^2*f8
+ 2*f1*f3*f6)*x[2]*x[4]^2*x[7] + (-4*f0*f4 - 5*f1*f3)*x[2]*x[4]^2*x[8] +
16*f0^2*f8*x[2]*x[4]*x[5]^2 - 16*f0*f1*f8*x[2]*x[4]*x[5]*x[6] + (-8*f0*f2*f8 -
2*f0*f3*f7 - 2*f1*f3*f6)*x[2]*x[4]*x[5]*x[7] + f1*f3*x[2]*x[4]*x[5]*x[8] +
(-24*f0*f2*f8 + 12*f1^2*f8 + 2*f1*f3*f6)*x[2]*x[4]*x[6]^2 + (-4*f0*f3*f8 +
4*f0*f4*f7 - f1*f3*f7)*x[2]*x[4]*x[6]*x[7] + 4*f0*f5*x[2]*x[4]*x[6]*x[8] +
(8*f0*f4*f8 - 4*f0*f5*f7 + 2*f1*f3*f8)*x[2]*x[4]*x[7]^2 +
4*f0*f6*x[2]*x[4]*x[7]*x[8] + 2*f0*x[2]*x[4]*x[8]^2 -
2*f0*f3*f7*x[2]*x[5]^2*x[7] + 2*f0*f3*f7*x[2]*x[5]*x[6]^2 + (-4*f0*f3*f8 +
f1*f3*f7)*x[2]*x[5]*x[6]*x[7] + (8*f0*f4*f8 - 2*f0*f5*f7 -
2*f1*f3*f8)*x[2]*x[5]*x[7]^2 + 4*f0*f6*x[2]*x[5]*x[7]*x[8] -
2*f0*x[2]*x[5]*x[8]^2 + (4*f0*f3*f8 - f1*f3*f7)*x[2]*x[6]^3 + (-8*f0*f4*f8 +
2*f0*f5*f7 + 2*f1*f3*f8)*x[2]*x[6]^2*x[7] - 4*f0*f6*x[2]*x[6]^2*x[8] +
2*f0*f7*x[2]*x[6]*x[7]*x[8] - 4*f0*f8*x[2]*x[7]^2*x[8] + (4*f0^2*f6 + 4*f0*f2*f4
- f1^2*f4)*x[3]^4 + (-8*f0^2*f7 - 8*f0*f1*f6 - 8*f0*f3*f4)*x[3]^3*x[4] +
(-4*f0*f2*f5 + f1^2*f5)*x[3]^3*x[5] + 2*f0*f3*f5*x[3]^3*x[6] + (4*f0*f1*f8 +
8*f0*f2*f7 - 2*f1^2*f7)*x[3]^3*x[7] + 4*f0*f3*x[3]^3*x[8] + (-4*f0^2*f8 +
10*f0*f1*f7 + 8*f0*f2*f6 - 6*f0*f3*f5 + 16*f0*f4^2 + 4*f1^2*f6 +
2*f1*f3*f4)*x[3]^2*x[4]^2 + (24*f0^2*f8 + 8*f0*f1*f7 +
6*f0*f3*f5)*x[3]^2*x[4]*x[5] + (-8*f0*f1*f8 - 16*f0*f2*f7 - 8*f0*f4*f5 -
f1*f3*f5)*x[3]^2*x[4]*x[6] + (4*f0*f5^2 - 6*f1^2*f8)*x[3]^2*x[4]*x[7] +
(-16*f0*f4 - 2*f1*f3)*x[3]^2*x[4]*x[8] + (-4*f0^2*f8 + 4*f0*f2*f6 -
f1^2*f6)*x[3]^2*x[5]^2 - 4*f0*f3*f6*x[3]^2*x[5]*x[6] + (-24*f0*f2*f8 -
4*f0*f3*f7 + 6*f1^2*f8)*x[3]^2*x[5]*x[7] + (4*f0*f2*f8 + 4*f0*f3*f7 +
4*f0*f4*f6)*x[3]^2*x[6]^2 + (-4*f0*f3*f8 - 4*f0*f5*f6)*x[3]^2*x[6]*x[7] +
4*f0*f5*x[3]^2*x[6]*x[8] + (4*f0*f4*f8 - 2*f0*f5*f7 + 4*f0*f6^2 +
2*f1*f3*f8)*x[3]^2*x[7]^2 - 4*f0*f6*x[3]^2*x[7]*x[8] + 3*f0*x[3]^2*x[8]^2 +
(4*f0*f1*f8 + 8*f0*f3*f6 - 8*f0*f4*f5 - 4*f1^2*f7 - 8*f1*f2*f6 + 4*f1*f3*f5 -
8*f1*f4^2)*x[3]*x[4]^3 + (-20*f0*f1*f8 - 8*f0*f4*f5 - 6*f1^2*f7 -
f1*f3*f5)*x[3]*x[4]^2*x[5] + (-8*f0*f3*f7 + 6*f0*f5^2 + 6*f1^2*f8 + 12*f1*f2*f7
+ 6*f1*f4*f5)*x[3]*x[4]^2*x[6] + (-20*f0*f3*f8 + 16*f0*f4*f7 - 4*f0*f5*f6 +
12*f1*f2*f8 - 6*f1*f3*f7 - 3*f1*f5^2)*x[3]*x[4]^2*x[7] + (2*f0*f5 +
12*f1*f4)*x[3]*x[4]^2*x[8] + (-8*f0*f1*f8 - 4*f0*f3*f6)*x[3]*x[4]*x[5]^2 +
(40*f0*f2*f8 + 8*f0*f4*f6 + 2*f1*f3*f6)*x[3]*x[4]*x[5]*x[6] + (12*f0*f3*f8 -
4*f0*f5*f6 + 2*f1*f3*f7)*x[3]*x[4]*x[5]*x[7] + 8*f0*f5*x[3]*x[4]*x[5]*x[8] +
(-4*f0*f5*f6 - 12*f1*f2*f8 - 2*f1*f3*f7 - 4*f1*f4*f6)*x[3]*x[4]*x[6]^2 +
(-10*f0*f5*f7 + 8*f0*f6^2 + 6*f1*f3*f8 + 4*f1*f5*f6)*x[3]*x[4]*x[6]*x[7] +
(-4*f0*f6 - 6*f1*f5)*x[3]*x[4]*x[6]*x[8] + (16*f0*f5*f8 - 8*f0*f6*f7 -
12*f1*f4*f8 + 6*f1*f5*f7 - 4*f1*f6^2)*x[3]*x[4]*x[7]^2 +
4*f1*f6*x[3]*x[4]*x[7]*x[8] - 3*f1*x[3]*x[4]*x[8]^2 + (-4*f0*f2*f7 +
f1^2*f7)*x[3]*x[5]^3 + 6*f0*f3*f7*x[3]*x[5]^2*x[6] + 8*f0*f3*f8*x[3]*x[5]^2*x[7]
+ (-8*f0*f3*f8 - 8*f0*f4*f7 - f1*f3*f7)*x[3]*x[5]*x[6]^2 + (8*f0*f5*f7 -
2*f1*f3*f8)*x[3]*x[5]*x[6]*x[7] - 4*f0*f6*x[3]*x[5]*x[6]*x[8] + (-4*f0*f5*f8 -
4*f0*f6*f7)*x[3]*x[5]*x[7]^2 + 2*f0*f7*x[3]*x[5]*x[7]*x[8] + (2*f0*f5*f7 +
2*f1*f3*f8 + 2*f1*f4*f7)*x[3]*x[6]^3 + (4*f0*f5*f8 - 4*f0*f6*f7 -
3*f1*f5*f7)*x[3]*x[6]^2*x[7] + (4*f0*f7 + 2*f1*f6)*x[3]*x[6]^2*x[8] +
(-8*f0*f6*f8 + 8*f0*f7^2 + 2*f1*f6*f7)*x[3]*x[6]*x[7]^2 -
3*f1*f7*x[3]*x[6]*x[7]*x[8] + (-4*f0*f7*f8 + 4*f1*f6*f8 - 2*f1*f7^2)*x[3]*x[7]^3
+ (4*f0*f2*f8 - 4*f0*f3*f7 + 4*f0*f4*f6 - 2*f1^2*f8 + 2*f1*f2*f7 - 4*f1*f3*f6 +
2*f1*f4*f5 + 4*f2^2*f6 - 2*f2*f3*f5 + 4*f2*f4^2 - f3^2*f4)*x[4]^4 + (-8*f0*f2*f8
- 4*f0*f3*f7 + 2*f0*f5^2 + 6*f1^2*f8 + 4*f1*f2*f7 + 2*f1*f4*f5)*x[4]^3*x[5] +
(8*f0*f3*f8 - 4*f0*f5*f6 - 4*f1*f2*f8 + 6*f1*f3*f7 - 2*f1*f5^2 - 8*f2^2*f7 -
4*f2*f4*f5 + f3^2*f5)*x[4]^3*x[6] + (-8*f0*f4*f8 + 10*f1*f3*f8 - 4*f1*f4*f7 +
2*f1*f5*f6 - 8*f2^2*f8 + 4*f2*f3*f7 + 2*f2*f5^2)*x[4]^3*x[7] + (-f1*f5 - 8*f2*f4
+ 2*f3^2)*x[4]^3*x[8] + (-12*f0*f2*f8 + 2*f0*f3*f7 + 4*f0*f4*f6 +
6*f1^2*f8)*x[4]^2*x[5]^2 + (12*f0*f3*f8 - 4*f0*f5*f6 - 12*f1*f2*f8 - 2*f1*f3*f7
- 4*f1*f4*f6)*x[4]^2*x[5]*x[6] + (-8*f0*f4*f8 + 2*f1*f5*f6)*x[4]^2*x[5]*x[7] -
3*f1*f5*x[4]^2*x[5]*x[8] + (4*f0*f6^2 - 8*f1*f3*f8 + 2*f1*f5*f6 + 12*f2^2*f8 +
2*f2*f3*f7 + 4*f2*f4*f6 - f3^2*f6)*x[4]^2*x[6]^2 + (8*f0*f5*f8 + 3*f1*f5*f7 -
4*f1*f6^2 - 4*f2*f3*f8 - 4*f2*f5*f6 - 2*f3^2*f7)*x[4]^2*x[6]*x[7] + (-4*f0*f7 +
2*f1*f6 + 6*f2*f5)*x[4]^2*x[6]*x[8] + (-4*f0*f6*f8 + 4*f0*f7^2 - 6*f1*f5*f8 +
2*f1*f6*f7 + 12*f2*f4*f8 - 6*f2*f5*f7 + 4*f2*f6^2 - 4*f3^2*f8 +
2*f3*f4*f7)*x[4]^2*x[7]^2 + (-4*f2*f6 - f3*f5)*x[4]^2*x[7]*x[8] +
3*f2*x[4]^2*x[8]^2 + 2*f0*f3*f7*x[4]*x[5]^3 + (-4*f0*f3*f8 - 8*f0*f4*f7 -
f1*f3*f7)*x[4]*x[5]^2*x[6] + (4*f0*f5*f7 - 2*f1*f3*f8)*x[4]*x[5]^2*x[7] -
4*f0*f6*x[4]*x[5]^2*x[8] + (6*f0*f5*f7 + 6*f1*f3*f8 +
6*f1*f4*f7)*x[4]*x[5]*x[6]^2 + (-4*f0*f6*f7 - 6*f1*f5*f7)*x[4]*x[5]*x[6]*x[7] +
(6*f0*f7 + 4*f1*f6)*x[4]*x[5]*x[6]*x[8] + (4*f0*f7^2 +
2*f1*f6*f7)*x[4]*x[5]*x[7]^2 - 3*f1*f7*x[4]*x[5]*x[7]*x[8] + (-4*f0*f6*f7 -
2*f1*f5*f7 - 4*f2*f3*f8 - 4*f2*f4*f7 + f3^2*f7)*x[4]*x[6]^3 + (-8*f0*f6*f8 +
4*f0*f7^2 + 4*f1*f6*f7 + 6*f2*f5*f7 + 4*f3^2*f8)*x[4]*x[6]^2*x[7] + (4*f0*f8 -
3*f1*f7 - 4*f2*f6)*x[4]*x[6]^2*x[8] + (-8*f0*f7*f8 + 8*f1*f6*f8 - 6*f1*f7^2 -
4*f2*f6*f7 - 4*f3*f4*f8 - f3*f5*f7)*x[4]*x[6]*x[7]^2 + (6*f2*f7 +
2*f3*f6)*x[4]*x[6]*x[7]*x[8] - f3*x[4]*x[6]*x[8]^2 + (8*f0*f8^2 + 2*f1*f7*f8 -
8*f2*f6*f8 + 4*f2*f7^2 + 4*f3*f5*f8)*x[4]*x[7]^3 - 2*f3*f7*x[4]*x[7]^2*x[8] +
(4*f0*f2*f8 - f1^2*f8)*x[5]^4 - 8*f0*f3*f8*x[5]^3*x[6] + (16*f0*f4*f8 +
2*f1*f3*f8)*x[5]^2*x[6]^2 - 16*f0*f5*f8*x[5]^2*x[6]*x[7] +
4*f0*f7*x[5]^2*x[6]*x[8] + (16*f0*f6*f8 - 3*f0*f7^2)*x[5]^2*x[7]^2 -
8*f0*f8*x[5]^2*x[7]*x[8] + (-8*f0*f5*f8 - 8*f1*f4*f8)*x[5]*x[6]^3 + (16*f0*f6*f8
- 2*f0*f7^2 + 12*f1*f5*f8)*x[5]*x[6]^2*x[7] + (-12*f0*f8 -
3*f1*f7)*x[5]*x[6]^2*x[8] + (-12*f0*f7*f8 - 16*f1*f6*f8 +
3*f1*f7^2)*x[5]*x[6]*x[7]^2 + 12*f1*f8*x[5]*x[6]*x[7]*x[8] + (8*f0*f8^2 +
2*f1*f7*f8)*x[5]*x[7]^3 + (4*f0*f6*f8 + 2*f1*f5*f8 + 4*f2*f4*f8 -
f3^2*f8)*x[6]^4 + (-4*f0*f7*f8 - 8*f1*f6*f8 + f1*f7^2 - 8*f2*f5*f8)*x[6]^3*x[7]
+ (4*f1*f8 + 2*f2*f7)*x[6]^3*x[8] + (8*f0*f8^2 + 6*f1*f7*f8 + 16*f2*f6*f8 -
3*f2*f7^2 + 2*f3*f5*f8)*x[6]^2*x[7]^2 + (-12*f2*f8 - f3*f7)*x[6]^2*x[7]*x[8] +
(-8*f1*f8^2 - 4*f2*f7*f8 - 8*f3*f6*f8 + 2*f3*f7^2)*x[6]*x[7]^3 +
8*f3*f8*x[6]*x[7]^2*x[8] + (4*f2*f8^2 + 4*f4*f6*f8 - f4*f7^2 - f5^2*f8)*x[7]^4 +
(-4*f4*f8 + f5*f7)*x[7]^3*x[8] - f6*x[7]^2*x[8]^2 + x[7]*x[8]^3,

// number 8
(-64*f0^2*f3*f5*f8^2 + 64*f0^2*f3*f6*f7*f8 - 16*f0^2*f3*f7^3 + 64*f0^2*f4^2*f8^2
- 32*f0^2*f4*f5*f7*f8 + 4*f0^2*f5^2*f7^2 + 64*f0*f1*f2*f5*f8^2 -
64*f0*f1*f2*f6*f7*f8 + 16*f0*f1*f2*f7^3 - 32*f0*f1*f3*f4*f8^2 +
8*f0*f1*f3*f5*f7*f8 - 16*f1^3*f5*f8^2 + 16*f1^3*f6*f7*f8 - 4*f1^3*f7^3 +
4*f1^2*f3^2*f8^2)*x[1]^4 + (-32*f0^2*f3*f7*f8 - 64*f0^2*f4*f6*f8 +
32*f0^2*f4*f7^2 + 32*f0^2*f5^2*f8 - 16*f0^2*f5*f6*f7 + 32*f0*f1*f2*f7*f8 +
16*f0*f1*f3*f6*f8 - 8*f0*f1*f3*f7^2 - 8*f1^3*f7*f8)*x[1]^3*x[2] +
(64*f0^2*f3*f8^2 - 64*f0*f1*f2*f8^2 + 32*f0*f1*f4*f6*f8 - 16*f0*f1*f4*f7^2 -
16*f0*f1*f5^2*f8 + 8*f0*f1*f5*f6*f7 + 16*f1^3*f8^2 - 8*f1^2*f3*f6*f8 +
4*f1^2*f3*f7^2)*x[1]^3*x[3] + (-64*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 +
16*f0*f1*f3*f8^2 + 64*f0*f2*f4*f6*f8 - 32*f0*f2*f4*f7^2 - 32*f0*f2*f5^2*f8 +
16*f0*f2*f5*f6*f7 - 32*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 + 16*f0*f3*f4*f5*f8 -
4*f0*f3*f5^2*f7 - 32*f1^2*f4*f6*f8 + 16*f1^2*f4*f7^2 + 16*f1^2*f5^2*f8 -
8*f1^2*f5*f6*f7 + 16*f1*f2*f3*f6*f8 - 8*f1*f2*f3*f7^2 -
4*f1*f3^2*f5*f8)*x[1]^3*x[4] + (-64*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 +
16*f0*f1*f3*f8^2 + 16*f0*f1*f4*f7*f8 - 4*f0*f1*f5*f7^2 -
4*f1^2*f3*f7*f8)*x[1]^3*x[5] + (64*f0^2*f5*f8^2 - 64*f0^2*f6*f7*f8 +
16*f0^2*f7^3 + 32*f0*f2*f4*f7*f8 - 8*f0*f2*f5*f7^2 - 16*f0*f3^2*f7*f8 -
16*f1^2*f4*f7*f8 + 4*f1^2*f5*f7^2 + 8*f1*f2*f3*f7*f8)*x[1]^3*x[6] +
(-32*f0*f1*f5*f8^2 + 32*f0*f1*f6*f7*f8 - 8*f0*f1*f7^3 - 64*f0*f2*f4*f8^2 +
16*f0*f2*f5*f7*f8 + 32*f0*f3^2*f8^2 + 32*f1^2*f4*f8^2 - 8*f1^2*f5*f7*f8 -
16*f1*f2*f3*f8^2)*x[1]^3*x[7] + (16*f0^2*f8^2 - 4*f0*f1*f7*f8 - 4*f0*f3*f5*f8 +
f1*f3*f5*f7)*x[1]^3*x[8] + (32*f0^2*f4*f8 - 8*f0^2*f5*f7 + 16*f0^2*f6^2 -
8*f0*f1*f3*f8)*x[1]^2*x[2]^2 + (-32*f0^2*f5*f8 - 16*f0*f1*f4*f8 + 12*f0*f1*f5*f7
- 16*f0*f1*f6^2 + 4*f1^2*f3*f8)*x[1]^2*x[2]*x[3] + (32*f0^2*f6*f8 - 16*f0^2*f7^2
- 32*f0*f2*f4*f8 + 24*f0*f2*f5*f7 - 32*f0*f2*f6^2 + 16*f0*f3^2*f8 -
16*f0*f3*f4*f7 + 8*f0*f3*f5*f6 + 16*f1^2*f4*f8 - 12*f1^2*f5*f7 + 16*f1^2*f6^2 -
8*f1*f2*f3*f8 + 4*f1*f3^2*f7)*x[1]^2*x[2]*x[4] + (32*f0^2*f6*f8 - 16*f0^2*f7^2 -
16*f0*f1*f5*f8 + 8*f0*f1*f6*f7)*x[1]^2*x[2]*x[5] + (32*f0^2*f7*f8 -
32*f0*f2*f5*f8 + 16*f0*f2*f6*f7 + 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 + 16*f1^2*f5*f8
- 8*f1^2*f6*f7 - 4*f1*f3^2*f8)*x[1]^2*x[2]*x[6] + (-16*f0^2*f8^2 -
12*f0*f1*f7*f8 + 32*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 12*f0*f3*f5*f8 - 16*f1^2*f6*f8
+ 8*f1^2*f7^2 - f1*f3*f5*f7)*x[1]^2*x[2]*x[7] + (-8*f0*f2*f8 + 4*f0*f3*f7 +
4*f1^2*f8 - 2*f1*f3*f6)*x[1]^2*x[2]*x[8] + (16*f0*f1*f5*f8 - 4*f1^2*f5*f7 +
4*f1^2*f6^2)*x[1]^2*x[3]^2 + (-16*f0*f1*f6*f8 + 8*f0*f1*f7^2 + 32*f0*f2*f5*f8 -
32*f0*f3*f5*f7 + 32*f0*f3*f6^2 + 32*f0*f4^2*f7 - 32*f0*f4*f5*f6 + 8*f0*f5^3 -
16*f1^2*f5*f8 + 16*f1*f2*f5*f7 - 16*f1*f2*f6^2 - 8*f1*f3*f4*f7 +
4*f1*f3*f5*f6)*x[1]^2*x[3]*x[4] + (-16*f0*f1*f6*f8 + 8*f0*f1*f7^2 + 8*f1^2*f5*f8
- 4*f1^2*f6*f7)*x[1]^2*x[3]*x[5] + (-48*f0^2*f8^2 - 4*f0*f1*f7*f8 +
28*f0*f3*f5*f8 - 16*f0*f3*f6*f7 - 32*f0*f4^2*f8 + 8*f0*f4*f5*f7 - 16*f1*f2*f5*f8
+ 8*f1*f2*f6*f7 + 8*f1*f3*f4*f8 - 3*f1*f3*f5*f7)*x[1]^2*x[3]*x[6] +
(32*f0*f1*f8^2 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 + 16*f0*f4*f5*f8 - 4*f0*f5^2*f7
+ 16*f1*f2*f6*f8 - 8*f1*f2*f7^2 + 4*f1*f3*f5*f8)*x[1]^2*x[3]*x[7] + (8*f0*f3*f8
- 8*f0*f4*f7 + 4*f0*f5*f6 - 4*f1*f2*f8 + 4*f1*f4*f6 -
2*f1*f5^2)*x[1]^2*x[3]*x[8] + (16*f0^2*f8^2 - 32*f0*f2*f6*f8 + 16*f0*f2*f7^2 -
8*f0*f3*f5*f8 + 16*f1^2*f6*f8 - 8*f1^2*f7^2 + 16*f1*f3*f5*f7 - 16*f1*f3*f6^2 -
16*f1*f4^2*f7 + 16*f1*f4*f5*f6 - 4*f1*f5^3 - 16*f2^2*f5*f7 + 16*f2^2*f6^2 +
16*f2*f3*f4*f7 - 8*f2*f3*f5*f6 - 4*f3^3*f7 + f3^2*f5^2)*x[1]^2*x[4]^2 +
(16*f0^2*f8^2 - 4*f0*f1*f7*f8 - 32*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 28*f0*f3*f5*f8
- 16*f0*f3*f6*f7 - 32*f0*f4^2*f8 + 8*f0*f4*f5*f7 + 16*f1^2*f6*f8 - 8*f1^2*f7^2 -
16*f1*f2*f5*f8 + 8*f1*f2*f6*f7 + 8*f1*f3*f4*f8 + f1*f3*f5*f7)*x[1]^2*x[4]*x[5] +
(-16*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 16*f0*f3*f7^2 + 8*f1^2*f7*f8 -
32*f1*f3*f5*f8 + 16*f1*f3*f6*f7 + 32*f1*f4^2*f8 - 8*f1*f4*f5*f7 + 32*f2^2*f5*f8
- 16*f2^2*f6*f7 - 32*f2*f3*f4*f8 + 4*f2*f3*f5*f7 + 8*f3^3*f8)*x[1]^2*x[4]*x[6] +
(32*f0*f2*f8^2 - 32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 16*f0*f5^2*f8 - 8*f0*f5*f6*f7
- 16*f1^2*f8^2 + 24*f1*f3*f6*f8 - 12*f1*f3*f7^2 - 16*f1*f4*f5*f8 + 4*f1*f5^2*f7
- 32*f2^2*f6*f8 + 16*f2^2*f7^2 + 8*f2*f3*f5*f8)*x[1]^2*x[4]*x[7] + (8*f0*f4*f8 -
8*f0*f5*f7 + 8*f0*f6^2 - 8*f1*f3*f8 + 8*f1*f4*f7 - 4*f1*f5*f6 + 8*f2^2*f8 -
4*f2*f3*f7 - 8*f2*f4*f6 + 4*f2*f5^2 + 4*f3^2*f6 - 2*f3*f4*f5)*x[1]^2*x[4]*x[8] +
(16*f0^2*f8^2 - 8*f0*f1*f7*f8 + f1^2*f7^2)*x[1]^2*x[5]^2 + (-16*f0*f2*f7*f8 +
8*f0*f3*f7^2 + 8*f1^2*f7*f8 - 4*f1*f2*f7^2)*x[1]^2*x[5]*x[6] + (32*f0*f2*f8^2 -
16*f0*f3*f7*f8 - 16*f1^2*f8^2 + 8*f1*f2*f7*f8)*x[1]^2*x[5]*x[7] + (8*f0*f4*f8 -
2*f1*f4*f7)*x[1]^2*x[5]*x[8] + (16*f0*f3*f7*f8 - 4*f1*f3*f7^2 +
4*f2^2*f7^2)*x[1]^2*x[6]^2 + (-32*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 4*f0*f5*f7^2 +
12*f1*f3*f7*f8 - 16*f2^2*f7*f8)*x[1]^2*x[6]*x[7] + (8*f0*f5*f8 - 4*f0*f6*f7 -
8*f1*f4*f8 + 4*f2*f3*f8 + 4*f2*f4*f7 - 2*f3^2*f7)*x[1]^2*x[6]*x[8] +
(32*f0*f4*f8^2 - 8*f0*f5*f7*f8 - 8*f1*f3*f8^2 + 16*f2^2*f8^2)*x[1]^2*x[7]^2 +
(-8*f0*f6*f8 + 4*f0*f7^2 + 4*f1*f5*f8 - 2*f2*f5*f7)*x[1]^2*x[7]*x[8] -
16*f0^2*f6*x[1]*x[2]^3 + (16*f0^2*f7 + 16*f0*f1*f6)*x[1]*x[2]^2*x[3] +
(-16*f0^2*f8 + 32*f0*f2*f6 - 4*f0*f3*f5 - 16*f1^2*f6)*x[1]*x[2]^2*x[4] +
(-16*f0^2*f8 - 4*f0*f1*f7)*x[1]*x[2]^2*x[5] + (-8*f0*f2*f7 - 8*f0*f3*f6 +
4*f1^2*f7)*x[1]*x[2]^2*x[6] + (-8*f0*f2*f8 + 4*f0*f3*f7 + 4*f1^2*f8 +
2*f1*f3*f6)*x[1]*x[2]^2*x[7] + f1*f3*x[1]*x[2]^2*x[8] + (-16*f0*f1*f7 -
4*f1^2*f6)*x[1]*x[2]*x[3]^2 + (8*f0*f1*f8 - 32*f0*f2*f7 - 32*f0*f3*f6 +
16*f0*f4*f5 + 16*f1^2*f7 + 16*f1*f2*f6 - 2*f1*f3*f5)*x[1]*x[2]*x[3]*x[4] +
(24*f0*f1*f8 + 2*f1^2*f7)*x[1]*x[2]*x[3]*x[5] + (24*f0*f2*f8 + 12*f0*f3*f7 +
16*f0*f4*f6 - 8*f0*f5^2 - 12*f1^2*f8 - 4*f1*f2*f7 +
2*f1*f3*f6)*x[1]*x[2]*x[3]*x[6] + (8*f0*f3*f8 - 8*f0*f4*f7 + 4*f0*f5*f6 -
4*f1*f2*f8 - 4*f1*f3*f7 - 4*f1*f4*f6 + 2*f1*f5^2)*x[1]*x[2]*x[3]*x[7] +
(-4*f0*f5 - 2*f1*f4)*x[1]*x[2]*x[3]*x[8] + (16*f0*f2*f8 + 8*f0*f3*f7 - 8*f1^2*f8
+ 16*f1*f3*f6 - 8*f1*f4*f5 - 16*f2^2*f6 + 4*f2*f3*f5)*x[1]*x[2]*x[4]^2 +
(24*f0*f2*f8 + 12*f0*f3*f7 + 16*f0*f4*f6 - 8*f0*f5^2 - 12*f1^2*f8 - 4*f1*f2*f7 -
6*f1*f3*f6)*x[1]*x[2]*x[4]*x[5] + (-24*f0*f3*f8 - 8*f1*f3*f7 - 16*f1*f4*f6 +
8*f1*f5^2 + 8*f2^2*f7 + 8*f2*f3*f6 - 2*f3^2*f5)*x[1]*x[2]*x[4]*x[6] +
(8*f0*f4*f8 - 4*f0*f5*f7 + 8*f0*f6^2 - 4*f1*f3*f8 + 8*f1*f4*f7 - 4*f1*f5*f6 +
8*f2^2*f8 - 4*f2*f3*f7 + 8*f2*f4*f6 - 4*f2*f5^2 - 4*f3^2*f6 +
2*f3*f4*f5)*x[1]*x[2]*x[4]*x[7] + (-12*f0*f6 + 4*f1*f5 + 4*f2*f4 -
2*f3^2)*x[1]*x[2]*x[4]*x[8] + (-8*f0*f3*f8 - 16*f0*f4*f7 +
2*f1*f3*f7)*x[1]*x[2]*x[5]*x[6] + (8*f0*f4*f8 + 4*f0*f5*f7 + 4*f1*f3*f8 +
2*f1*f4*f7)*x[1]*x[2]*x[5]*x[7] + (-4*f0*f6 + 2*f1*f5)*x[1]*x[2]*x[5]*x[8] +
(8*f1*f4*f7 - 4*f2*f3*f7)*x[1]*x[2]*x[6]^2 + (8*f0*f5*f8 - 4*f0*f6*f7 -
8*f1*f4*f8 - 4*f1*f5*f7 + 4*f2*f3*f8 - 4*f2*f4*f7 +
2*f3^2*f7)*x[1]*x[2]*x[6]*x[7] + (4*f0*f7 + 4*f1*f6 - 4*f2*f5 +
2*f3*f4)*x[1]*x[2]*x[6]*x[8] + (-8*f0*f6*f8 + 4*f0*f7^2 + 4*f1*f5*f8 +
2*f2*f5*f7)*x[1]*x[2]*x[7]^2 + (8*f0*f8 - 4*f1*f7 + 4*f2*f6)*x[1]*x[2]*x[7]*x[8]
- 2*f2*x[1]*x[2]*x[8]^2 + 4*f1^2*f7*x[1]*x[3]^3 + (32*f0*f3*f7 - 8*f0*f5^2 -
16*f1*f2*f7)*x[1]*x[3]^2*x[4] - 8*f1^2*f8*x[1]*x[3]^2*x[5] + (-24*f0*f3*f8 -
8*f0*f4*f7 + 4*f0*f5*f6 + 12*f1*f2*f8 - 4*f1*f4*f6 + 2*f1*f5^2)*x[1]*x[3]^2*x[6]
+ (8*f1*f4*f7 - 4*f1*f5*f6)*x[1]*x[3]^2*x[7] + 3*f1*f5*x[1]*x[3]^2*x[8] +
(-32*f0*f4*f7 + 16*f0*f5*f6 - 12*f1*f3*f7 + 4*f1*f5^2 +
16*f2^2*f7)*x[1]*x[3]*x[4]^2 + (-40*f0*f3*f8 - 24*f0*f4*f7 + 12*f0*f5*f6 +
20*f1*f2*f8 + 4*f1*f3*f7 + 4*f1*f4*f6 - 2*f1*f5^2)*x[1]*x[3]*x[4]*x[5] +
(40*f0*f4*f8 + 20*f0*f5*f7 - 24*f0*f6^2 + 20*f1*f3*f8 + 8*f1*f4*f7 - 4*f1*f5*f6
- 24*f2^2*f8 - 4*f2*f3*f7 + 8*f2*f4*f6 - 4*f2*f5^2 - 4*f3^2*f6 +
2*f3*f4*f5)*x[1]*x[3]*x[4]*x[6] + (-24*f0*f5*f8 - 8*f1*f5*f7 + 8*f1*f6^2 -
16*f2*f4*f7 + 8*f2*f5*f6 + 8*f3^2*f7 - 2*f3*f5^2)*x[1]*x[3]*x[4]*x[7] +
(20*f0*f7 - 4*f1*f6 - 6*f2*f5)*x[1]*x[3]*x[4]*x[8] + (40*f0*f4*f8 - 4*f0*f5*f7 -
4*f1*f3*f8 + 2*f1*f4*f7)*x[1]*x[3]*x[5]*x[6] + (-8*f0*f5*f8 - 16*f1*f4*f8 +
2*f1*f5*f7)*x[1]*x[3]*x[5]*x[7] + (4*f0*f7 - 2*f1*f6)*x[1]*x[3]*x[5]*x[8] +
(-24*f0*f5*f8 + 12*f0*f6*f7 - 8*f1*f4*f8 + 4*f2*f3*f8 - 4*f2*f4*f7 +
2*f3^2*f7)*x[1]*x[3]*x[6]^2 + (24*f0*f6*f8 - 12*f0*f7^2 + 12*f1*f5*f8 -
4*f1*f6*f7 + 16*f2*f4*f8 + 2*f2*f5*f7 - 8*f3^2*f8)*x[1]*x[3]*x[6]*x[7] +
(-24*f0*f8 - 4*f2*f6 + 4*f3*f5 - 4*f4^2)*x[1]*x[3]*x[6]*x[8] + (-8*f1*f6*f8 +
4*f1*f7^2 - 8*f2*f5*f8)*x[1]*x[3]*x[7]^2 + (4*f1*f8 + 4*f2*f7 - 4*f3*f6 +
2*f4*f5)*x[1]*x[3]*x[7]*x[8] + 2*f3*x[1]*x[3]*x[8]^2 + (16*f1*f4*f7 - 8*f1*f5*f6
- 8*f2*f3*f7)*x[1]*x[4]^3 + (24*f0*f4*f8 + 4*f0*f5*f7 - 8*f0*f6^2 + 4*f1*f3*f8 +
8*f1*f4*f7 - 4*f1*f5*f6 - 8*f2^2*f8 - 4*f2*f3*f7 - 8*f2*f4*f6 + 4*f2*f5^2 +
4*f3^2*f6 - 2*f3*f4*f5)*x[1]*x[4]^2*x[5] + (-32*f1*f4*f8 - 12*f1*f5*f7 +
16*f1*f6^2 + 16*f2*f3*f8 + 4*f3^2*f7)*x[1]*x[4]^2*x[6] + (16*f0*f6*f8 -
8*f0*f7^2 + 8*f1*f5*f8 + 16*f2*f5*f7 - 16*f2*f6^2 - 8*f3*f4*f7 +
4*f3*f5*f6)*x[1]*x[4]^2*x[7] + (-4*f0*f8 - 8*f1*f7 + 8*f2*f6 +
f3*f5)*x[1]*x[4]^2*x[8] + (24*f0*f4*f8 - 4*f0*f5*f7 - 4*f1*f3*f8 -
2*f1*f4*f7)*x[1]*x[4]*x[5]^2 + (-40*f0*f5*f8 + 20*f0*f6*f7 - 24*f1*f4*f8 +
4*f1*f5*f7 + 12*f2*f3*f8 + 4*f2*f4*f7 - 2*f3^2*f7)*x[1]*x[4]*x[5]*x[6] +
(24*f0*f6*f8 - 12*f0*f7^2 + 12*f1*f5*f8 - 4*f1*f6*f7 + 16*f2*f4*f8 - 6*f2*f5*f7
- 8*f3^2*f8)*x[1]*x[4]*x[5]*x[7] + (-16*f0*f8 - 2*f1*f7 + 8*f2*f6 - 2*f3*f5 +
4*f4^2)*x[1]*x[4]*x[5]*x[8] + (32*f1*f5*f8 - 16*f1*f6*f7 -
8*f3^2*f8)*x[1]*x[4]*x[6]^2 + (8*f0*f7*f8 - 32*f1*f6*f8 + 16*f1*f7^2 -
32*f2*f5*f8 + 16*f2*f6*f7 + 16*f3*f4*f8 - 2*f3*f5*f7)*x[1]*x[4]*x[6]*x[7] +
(20*f1*f8 - 4*f2*f7 - 6*f3*f6)*x[1]*x[4]*x[6]*x[8] + (-16*f0*f8^2 + 32*f2*f6*f8
- 16*f2*f7^2 - 4*f3*f5*f8)*x[1]*x[4]*x[7]^2 + (-12*f2*f8 + 4*f3*f7 + 4*f4*f6 -
2*f5^2)*x[1]*x[4]*x[7]*x[8] - 2*f4*x[1]*x[4]*x[8]^2 + (-4*f0*f8 +
f1*f7)*x[1]*x[5]^2*x[8] - 8*f0*f7^2*x[1]*x[5]*x[6]^2 + (24*f0*f7*f8 +
2*f1*f7^2)*x[1]*x[5]*x[6]*x[7] + (4*f1*f8 - 2*f2*f7)*x[1]*x[5]*x[6]*x[8] +
(-16*f0*f8^2 - 4*f1*f7*f8)*x[1]*x[5]*x[7]^2 + (-4*f2*f8 +
2*f3*f7)*x[1]*x[5]*x[7]*x[8] - 2*f4*x[1]*x[5]*x[8]^2 + 4*f1*f7^2*x[1]*x[6]^3 +
(-16*f1*f7*f8 - 4*f2*f7^2)*x[1]*x[6]^2*x[7] + 3*f3*f7*x[1]*x[6]^2*x[8] +
(16*f1*f8^2 + 16*f2*f7*f8)*x[1]*x[6]*x[7]^2 + (-4*f3*f8 -
2*f4*f7)*x[1]*x[6]*x[7]*x[8] + 2*f5*x[1]*x[6]*x[8]^2 - 16*f2*f8^2*x[1]*x[7]^3 +
f5*f7*x[1]*x[7]^2*x[8] - 2*f6*x[1]*x[7]*x[8]^2 + x[1]*x[8]^3 + 4*f0^2*x[2]^4 -
4*f0*f1*x[2]^3*x[3] + (-8*f0*f2 + 4*f1^2)*x[2]^3*x[4] + 4*f0*f3*x[2]^3*x[6] -
f1*f3*x[2]^3*x[7] + f1^2*x[2]^2*x[3]^2 + (8*f0*f3 - 4*f1*f2)*x[2]^2*x[3]*x[4] +
(-8*f0*f4 - f1*f3)*x[2]^2*x[3]*x[6] + 2*f1*f4*x[2]^2*x[3]*x[7] + (-4*f1*f3 +
4*f2^2)*x[2]^2*x[4]^2 + (-8*f0*f4 + 3*f1*f3)*x[2]^2*x[4]*x[5] + (8*f1*f4 -
4*f2*f3)*x[2]^2*x[4]*x[6] + (-4*f0*f6 - 4*f2*f4 + 2*f3^2)*x[2]^2*x[4]*x[7] +
4*f0*x[2]^2*x[4]*x[8] + 8*f0*f5*x[2]^2*x[5]*x[6] + (-4*f0*f6 -
2*f1*f5)*x[2]^2*x[5]*x[7] + 4*f0*x[2]^2*x[5]*x[8] + (-4*f1*f5 +
f3^2)*x[2]^2*x[6]^2 + (4*f1*f6 + 4*f2*f5 - 2*f3*f4)*x[2]^2*x[6]*x[7] -
4*f1*x[2]^2*x[6]*x[8] - 4*f2*f6*x[2]^2*x[7]^2 + 2*f2*x[2]^2*x[7]*x[8] + (4*f0*f5
+ 2*f1*f4)*x[2]*x[3]^2*x[6] - f1*f5*x[2]*x[3]^2*x[7] - 8*f0*f5*x[2]*x[3]*x[4]^2
+ (4*f0*f5 - 2*f1*f4)*x[2]*x[3]*x[4]*x[5] + (12*f0*f6 - 4*f1*f5 - 4*f2*f4 +
2*f3^2)*x[2]*x[3]*x[4]*x[6] + (4*f0*f7 - 4*f1*f6 + 2*f2*f5)*x[2]*x[3]*x[4]*x[7]
+ 2*f1*x[2]*x[3]*x[4]*x[8] + (-12*f0*f6 - 2*f1*f5)*x[2]*x[3]*x[5]*x[6] +
(4*f0*f7 + 6*f1*f6)*x[2]*x[3]*x[5]*x[7] - 2*f1*x[2]*x[3]*x[5]*x[8] + (-4*f0*f7 +
4*f1*f6 + 4*f2*f5 - 2*f3*f4)*x[2]*x[3]*x[6]^2 + (-2*f1*f7 - 8*f2*f6 - 2*f3*f5 +
4*f4^2)*x[2]*x[3]*x[6]*x[7] + 6*f2*x[2]*x[3]*x[6]*x[8] + (4*f2*f7 + 4*f3*f6 -
2*f4*f5)*x[2]*x[3]*x[7]^2 - 2*f3*x[2]*x[3]*x[7]*x[8] + 4*f1*f5*x[2]*x[4]^3 +
(4*f0*f6 + 4*f2*f4 - 2*f3^2)*x[2]*x[4]^2*x[5] - 8*f1*f6*x[2]*x[4]^2*x[6] +
(-4*f0*f8 + 8*f2*f6 - 3*f3*f5)*x[2]*x[4]^2*x[7] - 4*f2*x[2]*x[4]^2*x[8] +
(-4*f0*f6 + 2*f1*f5)*x[2]*x[4]*x[5]^2 + (-4*f0*f7 + 4*f1*f6 - 4*f2*f5 +
2*f3*f4)*x[2]*x[4]*x[5]*x[6] + (-8*f0*f8 - 4*f2*f6 + 4*f3*f5 -
4*f4^2)*x[2]*x[4]*x[5]*x[7] - 2*f2*x[2]*x[4]*x[5]*x[8] +
4*f1*f7*x[2]*x[4]*x[6]^2 + (4*f1*f8 - 4*f2*f7 + 2*f3*f6)*x[2]*x[4]*x[6]*x[7] +
2*f3*x[2]*x[4]*x[6]*x[8] + (-4*f2*f8 - 4*f4*f6 + 2*f5^2)*x[2]*x[4]*x[7]^2 +
2*f4*x[2]*x[4]*x[7]*x[8] + 8*f0*f7*x[2]*x[5]^2*x[6] + (-4*f0*f8 -
3*f1*f7)*x[2]*x[5]^2*x[7] - 4*f1*f7*x[2]*x[5]*x[6]^2 + (4*f1*f8 +
6*f2*f7)*x[2]*x[5]*x[6]*x[7] - 2*f3*x[2]*x[5]*x[6]*x[8] + (-4*f2*f8 -
2*f3*f7)*x[2]*x[5]*x[7]^2 + 2*f4*x[2]*x[5]*x[7]*x[8] - f3*f7*x[2]*x[6]^2*x[7] +
2*f4*f7*x[2]*x[6]*x[7]^2 - 2*f5*x[2]*x[6]*x[7]*x[8] - f5*f7*x[2]*x[7]^3 +
2*f6*x[2]*x[7]^2*x[8] - x[2]*x[7]*x[8]^2 - f1*f5*x[3]^3*x[6] +
f1*f5*x[3]^2*x[4]*x[5] + (-12*f0*f7 + 2*f2*f5)*x[3]^2*x[4]*x[6] +
4*f1*f7*x[3]^2*x[4]*x[7] + (4*f0*f7 + 2*f1*f6)*x[3]^2*x[5]*x[6] -
4*f1*f7*x[3]^2*x[5]*x[7] + (8*f0*f8 - 4*f2*f6)*x[3]^2*x[6]^2 + (-4*f1*f8 +
4*f2*f7 + 4*f3*f6 - 2*f4*f5)*x[3]^2*x[6]*x[7] - 2*f3*x[3]^2*x[6]*x[8] +
(-4*f3*f7 + f5^2)*x[3]^2*x[7]^2 + 8*f0*f7*x[3]*x[4]^3 + (-4*f0*f7 -
2*f2*f5)*x[3]*x[4]^2*x[5] + (-12*f0*f8 + 8*f1*f7 - f3*f5)*x[3]*x[4]^2*x[6] -
8*f2*f7*x[3]*x[4]^2*x[7] + (4*f0*f7 - 2*f1*f6)*x[3]*x[4]*x[5]^2 + (24*f0*f8 -
4*f1*f7 + 4*f2*f6)*x[3]*x[4]*x[5]*x[6] + (-4*f1*f8 + 4*f2*f7 - 4*f3*f6 +
2*f4*f5)*x[3]*x[4]*x[5]*x[7] + 2*f3*x[3]*x[4]*x[5]*x[8] + (-12*f1*f8 +
2*f3*f6)*x[3]*x[4]*x[6]^2 + (12*f2*f8 - 4*f3*f7 - 4*f4*f6 +
2*f5^2)*x[3]*x[4]*x[6]*x[7] + 2*f4*x[3]*x[4]*x[6]*x[8] + (8*f4*f7 -
4*f5*f6)*x[3]*x[4]*x[7]^2 + 2*f5*x[3]*x[4]*x[7]*x[8] + (-12*f0*f8 -
f1*f7)*x[3]*x[5]^2*x[6] + 8*f1*f8*x[3]*x[5]^2*x[7] + (4*f1*f8 +
2*f2*f7)*x[3]*x[5]*x[6]^2 + (-12*f2*f8 - 2*f3*f7)*x[3]*x[5]*x[6]*x[7] +
2*f4*x[3]*x[5]*x[6]*x[8] + 8*f3*f8*x[3]*x[5]*x[7]^2 - 2*f5*x[3]*x[5]*x[7]*x[8] -
f3*f7*x[3]*x[6]^3 + (4*f3*f8 + 2*f4*f7)*x[3]*x[6]^2*x[7] - 2*f5*x[3]*x[6]^2*x[8]
+ (-8*f4*f8 - f5*f7)*x[3]*x[6]*x[7]^2 + 6*f6*x[3]*x[6]*x[7]*x[8] -
3*x[3]*x[6]*x[8]^2 + 4*f5*f8*x[3]*x[7]^3 - 4*f7*x[3]*x[7]^2*x[8] -
4*f1*f7*x[4]^4 + (-4*f0*f8 + f3*f5)*x[4]^3*x[5] + 8*f1*f8*x[4]^3*x[6] +
4*f3*f7*x[4]^3*x[7] + (-4*f1*f8 - 2*f3*f6)*x[4]^2*x[5]*x[6] + (4*f2*f8 + 4*f4*f6
- 2*f5^2)*x[4]^2*x[5]*x[7] - 2*f4*x[4]^2*x[5]*x[8] - 8*f3*f8*x[4]^2*x[6]*x[7] +
(-4*f5*f7 + 4*f6^2)*x[4]^2*x[7]^2 - 4*f6*x[4]^2*x[7]*x[8] + x[4]^2*x[8]^2 +
(-4*f0*f8 + f1*f7)*x[4]*x[5]^3 + (4*f1*f8 - 2*f2*f7)*x[4]*x[5]^2*x[6] +
(-4*f2*f8 + 2*f3*f7)*x[4]*x[5]^2*x[7] - 2*f4*x[4]*x[5]^2*x[8] +
f3*f7*x[4]*x[5]*x[6]^2 + (4*f3*f8 - 2*f4*f7)*x[4]*x[5]*x[6]*x[7] +
2*f5*x[4]*x[5]*x[6]*x[8] + (-8*f4*f8 + 3*f5*f7)*x[4]*x[5]*x[7]^2 -
2*f6*x[4]*x[5]*x[7]*x[8] + x[4]*x[5]*x[8]^2 + (8*f5*f8 -
4*f6*f7)*x[4]*x[6]*x[7]^2 + 2*f7*x[4]*x[6]*x[7]*x[8] + (-8*f6*f8 +
4*f7^2)*x[4]*x[7]^3 + 4*f8*x[4]*x[7]^2*x[8] + x[5]^2*x[8]^2 -
2*f7*x[5]*x[6]*x[7]*x[8] + 4*f8*x[5]*x[7]^2*x[8] + f7^2*x[6]^2*x[7]^2 -
4*f7*f8*x[6]*x[7]^3 + 4*f8^2*x[7]^4
  ];
  return [4*inv8[8]] cat [4*inv8[j] : j in [2..7]] cat [inv8[1]];
end function;

function Xipolynomials(fs : Ring := PolynomialRing(Universe(fs), 8))
  P8 := Ring;
  x := [P8.i : i in [1..8]];
  f0,f1,f2,f3,f4,f5,f6,f7,f8 := Explode(fs);
  return [
    // Xi*x[1]
    (-8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8)*x[1]^3 - 4*f0*f6*x[1]^2*x[2] + (-4*f0*f7 +
    2*f1*f6)*x[1]^2*x[3] + (-4*f0*f8 + 2*f1*f7 - 4*f2*f6 + f3*f5)*x[1]^2*x[4] + (12*f0*f8
    - f1*f7)*x[1]^2*x[5] + (-4*f1*f8 + 2*f2*f7)*x[1]^2*x[6] - 4*f2*f8*x[1]^2*x[7] +
    6*f0*x[1]*x[2]^2 - 3*f1*x[1]*x[2]*x[3] + 6*f2*x[1]*x[2]*x[4] - f3*x[1]*x[2]*x[6] -
    2*f3*x[1]*x[3]*x[4] + 2*f4*x[1]*x[3]*x[6] - f5*x[1]*x[3]*x[7] + 4*f4*x[1]*x[4]^2 -
    2*f4*x[1]*x[4]*x[5] - 2*f5*x[1]*x[4]*x[6] + 6*f6*x[1]*x[4]*x[7] - 3*f7*x[1]*x[6]*x[7]
    + 6*f8*x[1]*x[7]^2 - 11*x[2]*x[4]*x[7] + x[2]*x[5]*x[7] + 2*x[2]*x[6]^2 +
    2*x[3]^2*x[7] + 5*x[3]*x[4]*x[6] - 3*x[3]*x[5]*x[6] + 2*x[4]^3 - 7*x[4]^2*x[5] +
    3*x[4]*x[5]^2,

    // Xi*x[2]
    (-32*f0*f4*f6*f8 + 8*f0*f4*f7^2 + 8*f0*f5^2*f8 + 8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*x[1]^3 +
    (24*f0*f4*f8 - 6*f0*f5*f7 - 6*f1*f3*f8)*x[1]^2*x[2] + (-16*f0*f5*f8 +
    2*f1*f5*f7)*x[1]^2*x[3] + (4*f1*f5*f8 - 4*f2*f5*f7)*x[1]^2*x[4] + (32*f0*f6*f8 -
    8*f0*f7^2 - 4*f1*f5*f8)*x[1]^2*x[5] + (-8*f1*f6*f8 + 2*f1*f7^2 +
    8*f2*f5*f8)*x[1]^2*x[6] + (-16*f2*f6*f8 + 4*f2*f7^2)*x[1]^2*x[7] + 4*f0*f6*x[1]*x[2]^2
    + (4*f0*f7 - 2*f1*f6)*x[1]*x[2]*x[3] + (-4*f0*f8 + 4*f2*f6 + f3*f5)*x[1]*x[2]*x[4] +
    (-20*f0*f8 + f1*f7)*x[1]*x[2]*x[5] + (4*f1*f8 - 2*f2*f7)*x[1]*x[2]*x[6] +
    12*f2*f8*x[1]*x[2]*x[7] + (8*f0*f8 - 2*f1*f7)*x[1]*x[3]^2 + (-4*f1*f8 + 4*f2*f7 -
    4*f3*f6)*x[1]*x[3]*x[4] + 4*f1*f8*x[1]*x[3]*x[5] + (-8*f2*f8 + 2*f3*f7)*x[1]*x[3]*x[6]
    + (-2*f3*f7 + 8*f4*f6 - 2*f5^2)*x[1]*x[4]^2 + 2*f3*f7*x[1]*x[4]*x[5] + (4*f3*f8 -
    8*f4*f7)*x[1]*x[4]*x[6] + 8*f5*f7*x[1]*x[4]*x[7] - 4*f3*f8*x[1]*x[5]*x[6] +
    8*f4*f8*x[1]*x[6]^2 - 16*f5*f8*x[1]*x[6]*x[7] + (24*f6*f8 - 6*f7^2)*x[1]*x[7]^2 -
    2*f0*x[2]^3 + f1*x[2]^2*x[3] - 2*f2*x[2]^2*x[4] - f3*x[2]^2*x[6] + 2*f3*x[2]*x[3]*x[4]
    + 2*f4*x[2]*x[3]*x[6] - f5*x[2]*x[3]*x[7] - 4*f4*x[2]*x[4]^2 - 2*f4*x[2]*x[4]*x[5] +
    2*f5*x[2]*x[4]*x[6] - 10*f6*x[2]*x[4]*x[7] + 5*x[2]*x[4]*x[8] + x[2]*x[5]*x[8] +
    5*f7*x[2]*x[6]*x[7] - 18*f8*x[2]*x[7]^2 - 2*f5*x[3]^2*x[6] + 4*f6*x[3]^2*x[7] -
    2*x[3]^2*x[8] + 2*f5*x[3]*x[4]^2 + 2*f5*x[3]*x[4]*x[5] + 4*f6*x[3]*x[4]*x[6] -
    4*f7*x[3]*x[4]*x[7] - 4*f7*x[3]*x[5]*x[7] - 2*f7*x[3]*x[6]^2 + 16*f8*x[3]*x[6]*x[7] -
    8*f6*x[4]^2*x[5] + 2*f7*x[4]^2*x[6] + 4*f8*x[4]^2*x[7] + 6*f7*x[4]*x[5]*x[6] -
    8*f8*x[4]*x[5]*x[7] - 4*f8*x[4]*x[6]^2 + 4*f8*x[5]^2*x[7] - 4*f8*x[5]*x[6]^2,

    // Xi*x[3]
    (-16*f0*f3*f6*f8 + 4*f0*f3*f7^2 + 4*f1*f3*f5*f8)*x[1]^3 + (16*f0*f3*f8 -
    2*f1*f3*f7)*x[1]^2*x[2] + (-8*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8 +
    4*f1*f4*f7)*x[1]^2*x[3] + (-8*f0*f5*f8 + 8*f1*f4*f8 + 2*f1*f5*f7 - 8*f2*f4*f7 +
    2*f3^2*f7)*x[1]^2*x[4] + (8*f0*f5*f8 - 8*f1*f4*f8)*x[1]^2*x[5] + (16*f0*f6*f8 -
    4*f0*f7^2 - 8*f1*f5*f8 + 16*f2*f4*f8 - 4*f3^2*f8)*x[1]^2*x[6] + (8*f1*f6*f8 -
    2*f1*f7^2 - 8*f2*f5*f8)*x[1]^2*x[7] + (4*f0*f6 - 2*f1*f5)*x[1]*x[2]*x[3] + (4*f0*f7 -
    4*f1*f6 + 4*f2*f5)*x[1]*x[2]*x[4] - 4*f0*f7*x[1]*x[2]*x[5] + (-16*f0*f8 +
    4*f1*f7)*x[1]*x[2]*x[6] + (-8*f1*f8 + 4*f2*f7)*x[1]*x[2]*x[7] + 2*f1*f6*x[1]*x[3]^2 +
    (4*f0*f8 - 4*f2*f6 - f3*f5)*x[1]*x[3]*x[4] + (4*f0*f8 - 5*f1*f7)*x[1]*x[3]*x[5] +
    (4*f1*f8 + 2*f2*f7)*x[1]*x[3]*x[6] + (4*f2*f8 - 2*f3*f7)*x[1]*x[3]*x[7] +
    4*f3*f6*x[1]*x[4]^2 + (-8*f1*f8 + 8*f2*f7)*x[1]*x[4]*x[5] - 8*f3*f7*x[1]*x[4]*x[6] +
    (-4*f3*f8 + 8*f4*f7)*x[1]*x[4]*x[7] + 8*f1*f8*x[1]*x[5]^2 - 16*f2*f8*x[1]*x[5]*x[6] +
    4*f3*f8*x[1]*x[5]*x[7] + 12*f3*f8*x[1]*x[6]^2 - 16*f4*f8*x[1]*x[6]*x[7] +
    8*f5*f8*x[1]*x[7]^2 - 2*f0*x[2]^2*x[3] + 2*f1*x[2]^2*x[4] + 2*f1*x[2]^2*x[5] -
    4*f2*x[2]^2*x[6] - f1*x[2]*x[3]^2 + 2*f2*x[2]*x[3]*x[4] + 3*f3*x[2]*x[3]*x[6] -
    2*f3*x[2]*x[4]^2 - 2*f3*x[2]*x[4]*x[5] - 4*f5*x[2]*x[4]*x[7] + 4*x[2]*x[6]*x[8] -
    4*f7*x[2]*x[7]^2 - 2*f4*x[3]^2*x[6] + f5*x[3]^2*x[7] + 2*f4*x[3]*x[4]*x[5] +
    2*f5*x[3]*x[4]*x[6] + 2*f6*x[3]*x[4]*x[7] - x[3]*x[4]*x[8] - x[3]*x[5]*x[8] +
    f7*x[3]*x[6]*x[7] - 2*f8*x[3]*x[7]^2 + 2*f5*x[4]^3 - 2*f5*x[4]^2*x[5] -
    4*f6*x[4]^2*x[6] - 2*f7*x[4]^2*x[7] - 6*f7*x[4]*x[5]*x[7] + 6*f7*x[4]*x[6]^2 +
    8*f8*x[4]*x[6]*x[7] + 8*f8*x[5]*x[6]*x[7] - 8*f8*x[6]^3,

    // Xi*x[4]
    (-32*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 8*f0*f3*f5*f8 + 8*f1^2*f6*f8 - 2*f1^2*f7^2)*x[1]^3 +
    (32*f0*f2*f8 - 4*f0*f3*f7 - 8*f1^2*f8)*x[1]^2*x[2] + (-8*f0*f3*f8 +
    8*f0*f4*f7)*x[1]^2*x[3] + (8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8 -
    4*f1*f4*f7)*x[1]^2*x[4] - 16*f0*f4*f8*x[1]^2*x[5] + (-8*f0*f5*f8 +
    8*f1*f4*f8)*x[1]^2*x[6] + (32*f0*f6*f8 - 8*f0*f7^2 - 4*f1*f5*f8)*x[1]^2*x[7] -
    4*f0*f5*x[1]*x[2]*x[3] + (-4*f0*f6 + 2*f1*f5)*x[1]*x[2]*x[4] + 4*f0*f7*x[1]*x[2]*x[6]
    + (-32*f0*f8 + 2*f1*f7)*x[1]*x[2]*x[7] + 8*f0*f6*x[1]*x[3]^2 + (4*f0*f7 -
    6*f1*f6)*x[1]*x[3]*x[4] - 16*f0*f7*x[1]*x[3]*x[5] + (8*f0*f8 + 4*f1*f7)*x[1]*x[3]*x[6]
    + 4*f1*f8*x[1]*x[3]*x[7] + (4*f0*f8 - 2*f1*f7 + 4*f2*f6 - f3*f5)*x[1]*x[4]^2 +
    (-20*f0*f8 + 7*f1*f7)*x[1]*x[4]*x[5] + (4*f1*f8 - 6*f2*f7)*x[1]*x[4]*x[6] + (-4*f2*f8
    + 2*f3*f7)*x[1]*x[4]*x[7] + 24*f0*f8*x[1]*x[5]^2 - 16*f1*f8*x[1]*x[5]*x[6] +
    8*f2*f8*x[1]*x[6]^2 - 4*f3*f8*x[1]*x[6]*x[7] + 2*f0*x[2]^2*x[4] + 4*f0*x[2]^2*x[5] -
    2*f1*x[2]^2*x[6] - 4*f0*x[2]*x[3]^2 + 3*f1*x[2]*x[3]*x[4] - 2*f2*x[2]*x[4]^2 +
    f3*x[2]*x[4]*x[6] - 2*f4*x[3]*x[4]*x[6] + f5*x[3]*x[4]*x[7] + 2*x[3]*x[6]*x[8] -
    2*f7*x[3]*x[7]^2 + 2*f4*x[4]^2*x[5] - 2*f6*x[4]^2*x[7] + x[4]^2*x[8] -
    3*x[4]*x[5]*x[8] + 3*f7*x[4]*x[6]*x[7] + 2*f8*x[4]*x[7]^2 + 4*f8*x[5]*x[7]^2 -
    4*f8*x[6]^2*x[7],

    // Xi*x[5]
    (-8*f0*f3*f5*f8 + 2*f1*f3*f5*f7)*x[1]^3 + (4*f0*f3*f7 - 4*f1*f3*f6)*x[1]^2*x[2] +
    (8*f0*f3*f8 - 8*f0*f4*f7 - 2*f1*f3*f7 + 8*f1*f4*f6 - 2*f1*f5^2)*x[1]^2*x[3] +
    (-16*f0*f4*f8 + 8*f1*f4*f7 - 16*f2*f4*f6 + 4*f2*f5^2 + 4*f3^2*f6)*x[1]^2*x[4] +
    (8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8 - 4*f1*f4*f7)*x[1]^2*x[5] + (8*f0*f5*f8 -
    8*f1*f4*f8 - 2*f1*f5*f7 + 8*f2*f4*f7 - 2*f3^2*f7)*x[1]^2*x[6] + (4*f1*f5*f8 -
    4*f2*f5*f7)*x[1]^2*x[7] + 4*f1*f3*x[1]*x[2]^2 + (4*f0*f5 - 8*f1*f4)*x[1]*x[2]*x[3] +
    (-4*f1*f5 + 16*f2*f4 - 4*f3^2)*x[1]*x[2]*x[4] + (-4*f0*f6 + 2*f1*f5)*x[1]*x[2]*x[5] +
    (-4*f0*f7 + 4*f1*f6 - 4*f2*f5)*x[1]*x[2]*x[6] + (-2*f1*f7 + 8*f2*f6)*x[1]*x[2]*x[7] +
    4*f1*f5*x[1]*x[3]^2 - 8*f2*f5*x[1]*x[3]*x[4] + (4*f0*f7 - 6*f1*f6)*x[1]*x[3]*x[5] +
    (-8*f0*f8 + 2*f1*f7 + 2*f3*f5)*x[1]*x[3]*x[6] + (-4*f1*f8 + 4*f2*f7 -
    4*f3*f6)*x[1]*x[3]*x[7] + 6*f3*f5*x[1]*x[4]^2 + (12*f0*f8 - 6*f1*f7 + 12*f2*f6 -
    3*f3*f5)*x[1]*x[4]*x[5] - 8*f3*f6*x[1]*x[4]*x[6] + (-4*f3*f7 + 16*f4*f6 -
    4*f5^2)*x[1]*x[4]*x[7] + (-4*f0*f8 + 3*f1*f7)*x[1]*x[5]^2 + (4*f1*f8 -
    6*f2*f7)*x[1]*x[5]*x[6] + (-4*f2*f8 + 2*f3*f7)*x[1]*x[5]*x[7] + 4*f3*f7*x[1]*x[6]^2 +
    (4*f3*f8 - 8*f4*f7)*x[1]*x[6]*x[7] + 4*f5*f7*x[1]*x[7]^2 + 4*f0*x[2]^2*x[4] +
    2*f0*x[2]^2*x[5] - 2*f1*x[2]^2*x[6] - 8*f2*x[2]^2*x[7] - 4*f0*x[2]*x[3]^2 +
    4*f1*x[2]*x[3]*x[4] + 3*f1*x[2]*x[3]*x[5] + 4*f2*x[2]*x[3]*x[6] + 4*f3*x[2]*x[3]*x[7]
    - 10*f2*x[2]*x[4]*x[5] + 4*f3*x[2]*x[4]*x[6] - 16*f4*x[2]*x[4]*x[7] +
    f3*x[2]*x[5]*x[6] + 4*f5*x[2]*x[6]*x[7] - 8*f6*x[2]*x[7]^2 + 8*x[2]*x[7]*x[8] -
    2*f1*x[3]^3 + 4*f2*x[3]^2*x[4] - 2*f3*x[3]^2*x[6] - 6*f3*x[3]*x[4]^2 +
    2*f3*x[3]*x[4]*x[5] + 8*f4*x[3]*x[4]*x[6] + 4*f5*x[3]*x[4]*x[7] - 2*f4*x[3]*x[5]*x[6]
    + f5*x[3]*x[5]*x[7] - 2*f5*x[3]*x[6]^2 + 4*f6*x[3]*x[6]*x[7] - 2*x[3]*x[6]*x[8] -
    2*f7*x[3]*x[7]^2 + 8*f4*x[4]^3 - 8*f4*x[4]^2*x[5] - 6*f5*x[4]^2*x[6] - 6*x[4]^2*x[8] +
    2*f4*x[4]*x[5]^2 + 2*f5*x[4]*x[5]*x[6] - 10*f6*x[4]*x[5]*x[7] + 5*x[4]*x[5]*x[8] +
    4*f6*x[4]*x[6]^2 + 4*f7*x[4]*x[6]*x[7] + 4*f8*x[4]*x[7]^2 - x[5]^2*x[8] +
    3*f7*x[5]*x[6]*x[7] + 2*f8*x[5]*x[7]^2 - 2*f7*x[6]^3 - 4*f8*x[6]^2*x[7],

    // Xi*x[6]
    (-16*f0*f2*f5*f8 + 4*f0*f3*f5*f7 + 4*f1^2*f5*f8)*x[1]^3 + (8*f0*f2*f7 - 8*f0*f3*f6 -
    2*f1^2*f7)*x[1]^2*x[2] + (16*f0*f2*f8 - 8*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 -
    4*f1^2*f8)*x[1]^2*x[3] + (-8*f0*f3*f8 + 8*f0*f4*f7 + 2*f1*f3*f7 - 8*f1*f4*f6 +
    2*f1*f5^2)*x[1]^2*x[4] + (8*f0*f3*f8 - 8*f0*f4*f7)*x[1]^2*x[5] + (-8*f0*f4*f8 -
    2*f0*f5*f7 - 2*f1*f3*f8 + 4*f1*f4*f7)*x[1]^2*x[6] + (16*f0*f5*f8 -
    2*f1*f5*f7)*x[1]^2*x[7] + 8*f0*f3*x[1]*x[2]^2 - 16*f0*f4*x[1]*x[2]*x[3] + (-4*f0*f5 +
    8*f1*f4)*x[1]*x[2]*x[4] + 4*f0*f5*x[1]*x[2]*x[5] + (4*f0*f6 - 2*f1*f5)*x[1]*x[2]*x[6]
    + (-8*f0*f7 + 4*f1*f6)*x[1]*x[2]*x[7] + 12*f0*f5*x[1]*x[3]^2 - 8*f1*f5*x[1]*x[3]*x[4]
    - 16*f0*f6*x[1]*x[3]*x[5] + (4*f0*f7 + 2*f1*f6)*x[1]*x[3]*x[6] + (-16*f0*f8 +
    4*f1*f7)*x[1]*x[3]*x[7] + 4*f2*f5*x[1]*x[4]^2 + (-8*f0*f7 + 8*f1*f6)*x[1]*x[4]*x[5] +
    (4*f0*f8 - 4*f2*f6 - f3*f5)*x[1]*x[4]*x[6] + (4*f1*f8 - 4*f2*f7 +
    4*f3*f6)*x[1]*x[4]*x[7] + 8*f0*f7*x[1]*x[5]^2 + (4*f0*f8 - 5*f1*f7)*x[1]*x[5]*x[6] -
    4*f1*f8*x[1]*x[5]*x[7] + 2*f2*f7*x[1]*x[6]^2 + (4*f2*f8 - 2*f3*f7)*x[1]*x[6]*x[7] -
    2*f0*x[2]^2*x[6] - 4*f1*x[2]^2*x[7] + 8*f0*x[2]*x[3]*x[4] + 8*f0*x[2]*x[3]*x[5] +
    f1*x[2]*x[3]*x[6] - 2*f1*x[2]*x[4]^2 - 6*f1*x[2]*x[4]*x[5] + 2*f2*x[2]*x[4]*x[6] -
    4*f3*x[2]*x[4]*x[7] + f3*x[2]*x[6]^2 - 8*f0*x[3]^3 + 6*f1*x[3]^2*x[4] -
    4*f2*x[3]*x[4]^2 + 2*f3*x[3]*x[4]*x[6] - 2*f4*x[3]*x[6]^2 + 3*f5*x[3]*x[6]*x[7] -
    4*f6*x[3]*x[7]^2 + 4*x[3]*x[7]*x[8] + 2*f3*x[4]^3 - 2*f3*x[4]^2*x[5] -
    2*f5*x[4]^2*x[7] + 2*f4*x[4]*x[5]*x[6] - 2*f5*x[4]*x[5]*x[7] + 2*f6*x[4]*x[6]*x[7] -
    x[4]*x[6]*x[8] + 2*f7*x[4]*x[7]^2 - x[5]*x[6]*x[8] + 2*f7*x[5]*x[7]^2 - f7*x[6]^2*x[7]
    - 2*f8*x[6]*x[7]^2,

    // Xi*x[7]
    (-32*f0*f2*f4*f8 + 8*f0*f2*f5*f7 + 8*f0*f3^2*f8 + 8*f1^2*f4*f8 - 2*f1^2*f5*f7)*x[1]^3 +
    (-16*f0*f2*f6 + 4*f1^2*f6)*x[1]^2*x[2] + (-8*f0*f2*f7 + 8*f0*f3*f6 +
    2*f1^2*f7)*x[1]^2*x[3] + (4*f0*f3*f7 - 4*f1*f3*f6)*x[1]^2*x[4] + (32*f0*f2*f8 -
    4*f0*f3*f7 - 8*f1^2*f8)*x[1]^2*x[5] + (-16*f0*f3*f8 + 2*f1*f3*f7)*x[1]^2*x[6] +
    (24*f0*f4*f8 - 6*f0*f5*f7 - 6*f1*f3*f8)*x[1]^2*x[7] + (24*f0*f2 - 6*f1^2)*x[1]*x[2]^2
    - 16*f0*f3*x[1]*x[2]*x[3] + 8*f1*f3*x[1]*x[2]*x[4] + 12*f0*f6*x[1]*x[2]*x[7] +
    8*f0*f4*x[1]*x[3]^2 + (4*f0*f5 - 8*f1*f4)*x[1]*x[3]*x[4] - 4*f0*f5*x[1]*x[3]*x[5] +
    (-8*f0*f6 + 2*f1*f5)*x[1]*x[3]*x[6] + (4*f0*f7 - 2*f1*f6)*x[1]*x[3]*x[7] + (-2*f1*f5 +
    8*f2*f4 - 2*f3^2)*x[1]*x[4]^2 + 2*f1*f5*x[1]*x[4]*x[5] + (-4*f0*f7 + 4*f1*f6 -
    4*f2*f5)*x[1]*x[4]*x[6] + (-4*f0*f8 + 4*f2*f6 + f3*f5)*x[1]*x[4]*x[7] +
    4*f0*f7*x[1]*x[5]*x[6] + (-20*f0*f8 + f1*f7)*x[1]*x[5]*x[7] + (8*f0*f8 -
    2*f1*f7)*x[1]*x[6]^2 + (4*f1*f8 - 2*f2*f7)*x[1]*x[6]*x[7] + 4*f2*f8*x[1]*x[7]^2 -
    18*f0*x[2]^2*x[7] + 16*f0*x[2]*x[3]*x[6] + 5*f1*x[2]*x[3]*x[7] + 4*f0*x[2]*x[4]^2 -
    8*f0*x[2]*x[4]*x[5] - 4*f1*x[2]*x[4]*x[6] - 10*f2*x[2]*x[4]*x[7] + 4*f0*x[2]*x[5]^2 -
    4*f1*x[2]*x[5]*x[6] + 4*f2*x[2]*x[6]^2 - f3*x[2]*x[6]*x[7] - 4*f0*x[3]^2*x[4] -
    4*f0*x[3]^2*x[5] - 2*f1*x[3]^2*x[6] + 2*f1*x[3]*x[4]^2 + 6*f1*x[3]*x[4]*x[5] +
    4*f2*x[3]*x[4]*x[6] + 2*f3*x[3]*x[4]*x[7] - 2*f3*x[3]*x[6]^2 + 2*f4*x[3]*x[6]*x[7] -
    f5*x[3]*x[7]^2 - 8*f2*x[4]^2*x[5] + 2*f3*x[4]^2*x[6] - 4*f4*x[4]^2*x[7] +
    2*f3*x[4]*x[5]*x[6] - 2*f4*x[4]*x[5]*x[7] + 2*f5*x[4]*x[6]*x[7] - 2*f6*x[4]*x[7]^2 +
    5*x[4]*x[7]*x[8] + x[5]*x[7]*x[8] - 2*x[6]^2*x[8] + f7*x[6]*x[7]^2 - 2*f8*x[7]^3,

    // Xi*x[8]
    (-128*f0*f2*f4*f6*f8 + 32*f0*f2*f4*f7^2 + 32*f0*f2*f5^2*f8 + 32*f0*f3^2*f6*f8 -
    8*f0*f3^2*f7^2 + 32*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 - 8*f1^2*f5^2*f8)*x[1]^3 +
    (96*f0*f2*f4*f8 - 24*f0*f2*f5*f7 - 24*f0*f3^2*f8 - 24*f1^2*f4*f8 +
    6*f1^2*f5*f7)*x[1]^2*x[2] + (-48*f0*f2*f5*f8 + 12*f0*f3*f5*f7 +
    12*f1^2*f5*f8)*x[1]^2*x[3] + (24*f0*f3*f5*f8 - 6*f1*f3*f5*f7)*x[1]^2*x[4] +
    (96*f0*f2*f6*f8 - 24*f0*f2*f7^2 - 24*f0*f3*f5*f8 - 24*f1^2*f6*f8 +
    6*f1^2*f7^2)*x[1]^2*x[5] + (-48*f0*f3*f6*f8 + 12*f0*f3*f7^2 +
    12*f1*f3*f5*f8)*x[1]^2*x[6] + (96*f0*f4*f6*f8 - 24*f0*f4*f7^2 - 24*f0*f5^2*f8 -
    24*f1*f3*f6*f8 + 6*f1*f3*f7^2)*x[1]^2*x[7] + (-8*f0*f4*f8 + 2*f0*f5*f7 +
    2*f1*f3*f8)*x[1]^2*x[8] + (16*f0*f2*f6 - 4*f1^2*f6)*x[1]*x[2]^2 + (16*f0*f2*f7 -
    16*f0*f3*f6 - 4*f1^2*f7)*x[1]*x[2]*x[3] + (-8*f0*f3*f7 + 8*f1*f3*f6)*x[1]*x[2]*x[4] +
    (-64*f0*f2*f8 + 8*f0*f3*f7 + 16*f1^2*f8)*x[1]*x[2]*x[5] + (32*f0*f3*f8 -
    4*f1*f3*f7)*x[1]*x[2]*x[6] + (-64*f0*f4*f8 + 16*f0*f5*f7 + 16*f1*f3*f8)*x[1]*x[2]*x[7]
    - 4*f0*f6*x[1]*x[2]*x[8] + (16*f0*f2*f8 - 8*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 -
    4*f1^2*f8)*x[1]*x[3]^2 + (-16*f0*f3*f8 + 16*f0*f4*f7 + 4*f1*f3*f7 - 16*f1*f4*f6 +
    4*f1*f5^2)*x[1]*x[3]*x[4] + (16*f0*f3*f8 - 16*f0*f4*f7)*x[1]*x[3]*x[5] + (-8*f0*f5*f7
    - 8*f1*f3*f8 + 8*f1*f4*f7)*x[1]*x[3]*x[6] + (32*f0*f5*f8 - 4*f1*f5*f7)*x[1]*x[3]*x[7]
    + (-4*f0*f7 + 2*f1*f6)*x[1]*x[3]*x[8] + (16*f0*f4*f8 - 8*f1*f4*f7 + 16*f2*f4*f6 -
    4*f2*f5^2 - 4*f3^2*f6)*x[1]*x[4]^2 + (-32*f0*f4*f8 + 8*f1*f4*f7)*x[1]*x[4]*x[5] +
    (-16*f0*f5*f8 + 16*f1*f4*f8 + 4*f1*f5*f7 - 16*f2*f4*f7 + 4*f3^2*f7)*x[1]*x[4]*x[6] +
    (-8*f1*f5*f8 + 8*f2*f5*f7)*x[1]*x[4]*x[7] + (-4*f0*f8 + 2*f1*f7 - 4*f2*f6 +
    f3*f5)*x[1]*x[4]*x[8] + 16*f0*f4*f8*x[1]*x[5]^2 + (16*f0*f5*f8 -
    16*f1*f4*f8)*x[1]*x[5]*x[6] + (-64*f0*f6*f8 + 16*f0*f7^2 + 8*f1*f5*f8)*x[1]*x[5]*x[7]
    + (12*f0*f8 - f1*f7)*x[1]*x[5]*x[8] + (16*f0*f6*f8 - 4*f0*f7^2 - 8*f1*f5*f8 +
    16*f2*f4*f8 - 4*f3^2*f8)*x[1]*x[6]^2 + (16*f1*f6*f8 - 4*f1*f7^2 -
    16*f2*f5*f8)*x[1]*x[6]*x[7] + (-4*f1*f8 + 2*f2*f7)*x[1]*x[6]*x[8] + (16*f2*f6*f8 -
    4*f2*f7^2)*x[1]*x[7]^2 - 4*f2*f8*x[1]*x[7]*x[8] + (-8*f0*f2 + 2*f1^2)*x[2]^3 +
    8*f0*f3*x[2]^2*x[3] - 4*f1*f3*x[2]^2*x[4] - 8*f0*f6*x[2]^2*x[7] + 6*f0*x[2]^2*x[8] -
    8*f0*f4*x[2]*x[3]^2 + (-4*f0*f5 + 8*f1*f4)*x[2]*x[3]*x[4] + 4*f0*f5*x[2]*x[3]*x[5] +
    (8*f0*f6 - 2*f1*f5)*x[2]*x[3]*x[6] + (-8*f0*f7 + 4*f1*f6)*x[2]*x[3]*x[7] -
    3*f1*x[2]*x[3]*x[8] + (2*f1*f5 - 8*f2*f4 + 2*f3^2)*x[2]*x[4]^2 -
    2*f1*f5*x[2]*x[4]*x[5] + (4*f0*f7 - 4*f1*f6 + 4*f2*f5)*x[2]*x[4]*x[6] + (2*f1*f7 -
    8*f2*f6)*x[2]*x[4]*x[7] + 6*f2*x[2]*x[4]*x[8] - 4*f0*f7*x[2]*x[5]*x[6] + (32*f0*f8 -
    2*f1*f7)*x[2]*x[5]*x[7] + (-8*f0*f8 + 2*f1*f7)*x[2]*x[6]^2 + (-8*f1*f8 +
    4*f2*f7)*x[2]*x[6]*x[7] - f3*x[2]*x[6]*x[8] - 8*f2*f8*x[2]*x[7]^2 + 4*f0*f5*x[3]^3 -
    4*f1*f5*x[3]^2*x[4] - 8*f0*f6*x[3]^2*x[5] + 4*f0*f7*x[3]^2*x[6] + (-8*f0*f8 +
    2*f1*f7)*x[3]^2*x[7] + 4*f2*f5*x[3]*x[4]^2 + (-8*f0*f7 + 8*f1*f6)*x[3]*x[4]*x[5] +
    (8*f0*f8 - 2*f1*f7 - 2*f3*f5)*x[3]*x[4]*x[6] + (4*f1*f8 - 4*f2*f7 +
    4*f3*f6)*x[3]*x[4]*x[7] - 2*f3*x[3]*x[4]*x[8] + 8*f0*f7*x[3]*x[5]^2 + (-8*f0*f8 -
    4*f1*f7)*x[3]*x[5]*x[6] - 4*f1*f8*x[3]*x[5]*x[7] + 4*f1*f8*x[3]*x[6]^2 + (8*f2*f8 -
    2*f3*f7)*x[3]*x[6]*x[7] + 2*f4*x[3]*x[6]*x[8] - f5*x[3]*x[7]*x[8] - 2*f3*f5*x[4]^3 +
    (-8*f0*f8 + 4*f1*f7 - 8*f2*f6 + 2*f3*f5)*x[4]^2*x[5] + 4*f3*f6*x[4]^2*x[6] + (2*f3*f7
    - 8*f4*f6 + 2*f5^2)*x[4]^2*x[7] + 4*f4*x[4]^2*x[8] + (16*f0*f8 - 4*f1*f7)*x[4]*x[5]^2
    + (-8*f1*f8 + 8*f2*f7)*x[4]*x[5]*x[6] - 2*f3*f7*x[4]*x[5]*x[7] - 2*f4*x[4]*x[5]*x[8] -
    4*f3*f7*x[4]*x[6]^2 + (-4*f3*f8 + 8*f4*f7)*x[4]*x[6]*x[7] - 2*f5*x[4]*x[6]*x[8] -
    4*f5*f7*x[4]*x[7]^2 + 6*f6*x[4]*x[7]*x[8] - 3*x[4]*x[8]^2 - 8*f0*f8*x[5]^3 +
    8*f1*f8*x[5]^2*x[6] - 8*f2*f8*x[5]*x[6]^2 + 4*f3*f8*x[5]*x[6]*x[7] + x[5]*x[8]^2 +
    4*f3*f8*x[6]^3 - 8*f4*f8*x[6]^2*x[7] + 8*f5*f8*x[6]*x[7]^2 - 3*f7*x[6]*x[7]*x[8] +
    (-8*f6*f8 + 2*f7^2)*x[7]^3 + 6*f8*x[7]^2*x[8]
  ];
end function;

function K3biquforms(fs : Ring := PolynomialRing(Universe(fs), 16))
  P := Ring;
  z := [P.i : i in [1..16]];
  f0,f1,f2,f3,f4,f5,f6,f7,f8 := Explode(fs);
  return SymmetricMatrix(P, [
// Bmat[1,1]
  2*z[1]^2*z[16]^2 - 4*z[1]*z[2]*z[15]*z[16] + 4*z[1]*z[3]*z[14]*z[16] -
4*z[1]*z[4]*z[13]*z[16] - 4*z[1]*z[5]*z[12]*z[16] + 4*z[1]*z[6]*z[11]*z[16] -
4*z[1]*z[7]*z[10]*z[16] + 3*z[1]*z[8]*z[9]*z[16] + z[1]*z[8]*z[10]*z[15] -
z[1]*z[8]*z[11]*z[14] + z[1]*z[8]*z[12]*z[13] + 2*z[2]^2*z[15]^2 -
4*z[2]*z[3]*z[14]*z[15] + 4*z[2]*z[4]*z[13]*z[15] + 4*z[2]*z[5]*z[12]*z[15] -
4*z[2]*z[6]*z[11]*z[15] + z[2]*z[7]*z[9]*z[16] + 3*z[2]*z[7]*z[10]*z[15] +
z[2]*z[7]*z[11]*z[14] - z[2]*z[7]*z[12]*z[13] - 4*z[2]*z[8]*z[9]*z[15] +
2*z[3]^2*z[14]^2 - 4*z[3]*z[4]*z[13]*z[14] - 4*z[3]*z[5]*z[12]*z[14] -
z[3]*z[6]*z[9]*z[16] + z[3]*z[6]*z[10]*z[15] + 3*z[3]*z[6]*z[11]*z[14] +
z[3]*z[6]*z[12]*z[13] - 4*z[3]*z[7]*z[10]*z[14] + 4*z[3]*z[8]*z[9]*z[14] +
2*z[4]^2*z[13]^2 + z[4]*z[5]*z[9]*z[16] - z[4]*z[5]*z[10]*z[15] +
z[4]*z[5]*z[11]*z[14] + 3*z[4]*z[5]*z[12]*z[13] - 4*z[4]*z[6]*z[11]*z[13] +
4*z[4]*z[7]*z[10]*z[13] - 4*z[4]*z[8]*z[9]*z[13] + 2*z[5]^2*z[12]^2 -
4*z[5]*z[6]*z[11]*z[12] + 4*z[5]*z[7]*z[10]*z[12] - 4*z[5]*z[8]*z[9]*z[12] +
2*z[6]^2*z[11]^2 - 4*z[6]*z[7]*z[10]*z[11] + 4*z[6]*z[8]*z[9]*z[11] +
2*z[7]^2*z[10]^2 - 4*z[7]*z[8]*z[9]*z[10] + 2*z[8]^2*z[9]^2,

// Bmat[2,1]
  (16*f0*f2*f8 - 4*f1^2*f8)*z[1]^2*z[10]^2 - 16*f0*f3*f8*z[1]^2*z[10]*z[11] +
8*f1*f3*f8*z[1]^2*z[10]*z[12] - 8*f0*f8*z[1]^2*z[10]*z[16] +
16*f0*f4*f8*z[1]^2*z[11]^2 - 16*f1*f4*f8*z[1]^2*z[11]*z[12] -
16*f0*f5*f8*z[1]^2*z[11]*z[13] + 8*f1*f5*f8*z[1]^2*z[11]*z[14] +
4*f1*f8*z[1]^2*z[11]*z[16] + (16*f2*f4*f8 - 4*f3^2*f8)*z[1]^2*z[12]^2 +
8*f1*f5*f8*z[1]^2*z[12]*z[13] - 16*f2*f5*f8*z[1]^2*z[12]*z[14] +
8*f3*f5*f8*z[1]^2*z[12]*z[15] - 8*f2*f8*z[1]^2*z[12]*z[16] + (16*f0*f6*f8 -
4*f0*f7^2)*z[1]^2*z[13]^2 + (-16*f1*f6*f8 + 4*f1*f7^2)*z[1]^2*z[13]*z[14] +
(16*f2*f6*f8 - 4*f2*f7^2)*z[1]^2*z[14]^2 + (-16*f3*f6*f8 +
4*f3*f7^2)*z[1]^2*z[14]*z[15] + 4*f3*f8*z[1]^2*z[14]*z[16] + (16*f4*f6*f8 -
4*f4*f7^2 - 4*f5^2*f8)*z[1]^2*z[15]^2 + (-8*f4*f8 + 2*f5*f7)*z[1]^2*z[15]*z[16] +
(-32*f0*f2*f8 + 8*f1^2*f8)*z[1]*z[2]*z[9]*z[10] + 16*f0*f3*f8*z[1]*z[2]*z[9]*z[11]
- 8*f1*f3*f8*z[1]*z[2]*z[9]*z[12] + 8*f0*f8*z[1]*z[2]*z[9]*z[16] +
8*f0*f8*z[1]*z[2]*z[10]*z[15] + 8*f0*f7*z[1]*z[2]*z[11]*z[13] -
4*f1*f7*z[1]*z[2]*z[11]*z[14] - 4*f1*f8*z[1]*z[2]*z[11]*z[15] -
4*f1*f7*z[1]*z[2]*z[12]*z[13] + 8*f2*f7*z[1]*z[2]*z[12]*z[14] + (8*f2*f8 -
4*f3*f7)*z[1]*z[2]*z[12]*z[15] - 16*f0*f8*z[1]*z[2]*z[13]^2 +
16*f1*f8*z[1]*z[2]*z[13]*z[14] - 16*f2*f8*z[1]*z[2]*z[14]^2 +
12*f3*f8*z[1]*z[2]*z[14]*z[15] + (-8*f4*f8 + 2*f5*f7)*z[1]*z[2]*z[15]^2 -
4*f6*z[1]*z[2]*z[15]*z[16] + 2*z[1]*z[2]*z[16]^2 +
16*f0*f3*f8*z[1]*z[3]*z[9]*z[10] - 32*f0*f4*f8*z[1]*z[3]*z[9]*z[11] +
16*f1*f4*f8*z[1]*z[3]*z[9]*z[12] + 16*f0*f5*f8*z[1]*z[3]*z[9]*z[13] -
8*f1*f5*f8*z[1]*z[3]*z[9]*z[14] - 4*f1*f8*z[1]*z[3]*z[9]*z[16] -
8*f0*f7*z[1]*z[3]*z[10]*z[13] + (-8*f0*f8 + 4*f1*f7)*z[1]*z[3]*z[10]*z[14] +
16*f0*f8*z[1]*z[3]*z[11]*z[13] - 4*f1*f8*z[1]*z[3]*z[11]*z[14] -
8*f1*f8*z[1]*z[3]*z[12]*z[13] + (8*f2*f8 - 4*f3*f7)*z[1]*z[3]*z[12]*z[14] +
(-8*f3*f8 + 8*f4*f7)*z[1]*z[3]*z[12]*z[15] - 2*f5*z[1]*z[3]*z[12]*z[16] +
4*f3*f8*z[1]*z[3]*z[14]^2 + (-8*f4*f8 - 2*f5*f7)*z[1]*z[3]*z[14]*z[15] +
4*f6*z[1]*z[3]*z[14]*z[16] + 8*f5*f8*z[1]*z[3]*z[15]^2 -
4*f7*z[1]*z[3]*z[15]*z[16] - 8*f1*f3*f8*z[1]*z[4]*z[9]*z[10] +
16*f1*f4*f8*z[1]*z[4]*z[9]*z[11] + (-32*f2*f4*f8 + 8*f3^2*f8)*z[1]*z[4]*z[9]*z[12]
- 8*f1*f5*f8*z[1]*z[4]*z[9]*z[13] + 16*f2*f5*f8*z[1]*z[4]*z[9]*z[14] -
8*f3*f5*f8*z[1]*z[4]*z[9]*z[15] + 8*f2*f8*z[1]*z[4]*z[9]*z[16] + (-8*f0*f8 +
4*f1*f7)*z[1]*z[4]*z[10]*z[13] + (8*f1*f8 - 8*f2*f7)*z[1]*z[4]*z[10]*z[14] +
4*f3*f7*z[1]*z[4]*z[10]*z[15] - 4*f1*f8*z[1]*z[4]*z[11]*z[13] +
4*f3*f7*z[1]*z[4]*z[11]*z[14] - 8*f4*f7*z[1]*z[4]*z[11]*z[15] +
2*f5*z[1]*z[4]*z[11]*z[16] + 8*f2*f8*z[1]*z[4]*z[12]*z[13] -
8*f3*f8*z[1]*z[4]*z[12]*z[14] + 16*f4*f8*z[1]*z[4]*z[12]*z[15] -
4*f3*f8*z[1]*z[4]*z[13]*z[14] + (8*f4*f8 + 2*f5*f7)*z[1]*z[4]*z[13]*z[15] -
4*f6*z[1]*z[4]*z[13]*z[16] - 8*f5*f8*z[1]*z[4]*z[14]*z[15] +
4*f7*z[1]*z[4]*z[14]*z[16] - 4*f8*z[1]*z[4]*z[15]*z[16] +
16*f0*f5*f8*z[1]*z[5]*z[9]*z[11] - 8*f1*f5*f8*z[1]*z[5]*z[9]*z[12] + (-32*f0*f6*f8
+ 8*f0*f7^2)*z[1]*z[5]*z[9]*z[13] + (16*f1*f6*f8 - 4*f1*f7^2)*z[1]*z[5]*z[9]*z[14]
+ 8*f0*f8*z[1]*z[5]*z[10]*z[12] + 16*f0*f8*z[1]*z[5]*z[10]*z[13] -
8*f1*f8*z[1]*z[5]*z[10]*z[14] - 16*f0*f8*z[1]*z[5]*z[11]^2 +
12*f1*f8*z[1]*z[5]*z[11]*z[12] - 8*f2*f8*z[1]*z[5]*z[12]^2 +
4*f3*f8*z[1]*z[5]*z[12]*z[14] + (-8*f4*f8 - 2*f5*f7)*z[1]*z[5]*z[12]*z[15] +
8*f5*f8*z[1]*z[5]*z[14]*z[15] - 2*f7*z[1]*z[5]*z[14]*z[16] + (-16*f6*f8 +
4*f7^2)*z[1]*z[5]*z[15]^2 + 12*f8*z[1]*z[5]*z[15]*z[16] -
8*f1*f5*f8*z[1]*z[6]*z[9]*z[11] + 16*f2*f5*f8*z[1]*z[6]*z[9]*z[12] + (16*f1*f6*f8
- 4*f1*f7^2)*z[1]*z[6]*z[9]*z[13] + (-32*f2*f6*f8 +
8*f2*f7^2)*z[1]*z[6]*z[9]*z[14] + (16*f3*f6*f8 - 4*f3*f7^2)*z[1]*z[6]*z[9]*z[15] -
4*f3*f8*z[1]*z[6]*z[9]*z[16] + 8*f0*f8*z[1]*z[6]*z[10]*z[11] -
8*f1*f8*z[1]*z[6]*z[10]*z[12] - 8*f1*f8*z[1]*z[6]*z[10]*z[13] +
16*f2*f8*z[1]*z[6]*z[10]*z[14] - 8*f3*f8*z[1]*z[6]*z[10]*z[15] +
4*f1*f8*z[1]*z[6]*z[11]^2 - 8*f2*f8*z[1]*z[6]*z[11]*z[12] -
4*f3*f8*z[1]*z[6]*z[11]*z[14] + (8*f4*f8 + 2*f5*f7)*z[1]*z[6]*z[11]*z[15] +
8*f3*f8*z[1]*z[6]*z[12]^2 - 8*f5*f8*z[1]*z[6]*z[12]*z[15] -
8*f5*f8*z[1]*z[6]*z[13]*z[15] + 2*f7*z[1]*z[6]*z[13]*z[16] + (16*f6*f8 -
4*f7^2)*z[1]*z[6]*z[14]*z[15] - 8*f8*z[1]*z[6]*z[14]*z[16] -
8*f3*f5*f8*z[1]*z[7]*z[9]*z[12] + (16*f3*f6*f8 - 4*f3*f7^2)*z[1]*z[7]*z[9]*z[14] +
(-32*f4*f6*f8 + 8*f4*f7^2 + 8*f5^2*f8)*z[1]*z[7]*z[9]*z[15] + (8*f4*f8 -
2*f5*f7)*z[1]*z[7]*z[9]*z[16] - 8*f0*f8*z[1]*z[7]*z[10]^2 +
4*f1*f8*z[1]*z[7]*z[10]*z[11] - 8*f2*f8*z[1]*z[7]*z[10]*z[12] -
4*f3*f8*z[1]*z[7]*z[10]*z[14] + (8*f4*f8 - 2*f5*f7)*z[1]*z[7]*z[10]*z[15] +
8*f3*f8*z[1]*z[7]*z[11]*z[12] - 8*f5*f8*z[1]*z[7]*z[11]*z[15] -
16*f4*f8*z[1]*z[7]*z[12]^2 + 16*f5*f8*z[1]*z[7]*z[12]*z[14] +
12*f8*z[1]*z[7]*z[12]*z[16] + (16*f6*f8 - 4*f7^2)*z[1]*z[7]*z[13]*z[15] -
4*f8*z[1]*z[7]*z[13]*z[16] + (-16*f6*f8 + 4*f7^2)*z[1]*z[7]*z[14]^2 +
8*f0*f8*z[1]*z[8]*z[9]*z[10] - 4*f1*f8*z[1]*z[8]*z[9]*z[11] +
8*f2*f8*z[1]*z[8]*z[9]*z[12] - 4*f3*f8*z[1]*z[8]*z[9]*z[14] + (8*f4*f8 -
2*f5*f7)*z[1]*z[8]*z[9]*z[15] + 3*f6*z[1]*z[8]*z[9]*z[16] +
f6*z[1]*z[8]*z[10]*z[15] - 2*z[1]*z[8]*z[10]*z[16] - f6*z[1]*z[8]*z[11]*z[14] +
4*f7*z[1]*z[8]*z[11]*z[15] + f6*z[1]*z[8]*z[12]*z[13] - 4*f7*z[1]*z[8]*z[12]*z[14]
- 8*f8*z[1]*z[8]*z[12]*z[15] - 8*f8*z[1]*z[8]*z[13]*z[15] + 8*f8*z[1]*z[8]*z[14]^2
+ (16*f0*f2*f8 - 4*f1^2*f8)*z[2]^2*z[9]^2 - 8*f0*f8*z[2]^2*z[9]*z[15] -
4*f0*z[2]^2*z[11]^2 + 4*f1*z[2]^2*z[11]*z[12] - 4*f2*z[2]^2*z[12]^2 +
2*z[2]^2*z[15]*z[16] - 16*f0*f3*f8*z[2]*z[3]*z[9]^2 + 8*f0*f8*z[2]*z[3]*z[9]*z[14]
+ 4*f1*f8*z[2]*z[3]*z[9]*z[15] + 8*f0*z[2]*z[3]*z[10]*z[11] -
4*f1*z[2]*z[3]*z[10]*z[12] + 4*f3*z[2]*z[3]*z[12]^2 - 2*f5*z[2]*z[3]*z[12]*z[15] -
2*z[2]*z[3]*z[14]*z[16] + 8*f1*f3*f8*z[2]*z[4]*z[9]^2 +
8*f0*f8*z[2]*z[4]*z[9]*z[13] - 8*f1*f8*z[2]*z[4]*z[9]*z[14] -
8*f2*f8*z[2]*z[4]*z[9]*z[15] - 4*f1*z[2]*z[4]*z[10]*z[11] +
8*f2*z[2]*z[4]*z[10]*z[12] - 4*f3*z[2]*z[4]*z[11]*z[12] +
2*f5*z[2]*z[4]*z[11]*z[15] - 4*z[2]*z[4]*z[12]*z[16] + 2*z[2]*z[4]*z[13]*z[16] +
4*f8*z[2]*z[4]*z[15]^2 - 8*f0*f7*z[2]*z[5]*z[9]*z[11] + (-8*f0*f8 +
4*f1*f7)*z[2]*z[5]*z[9]*z[12] + 16*f0*f8*z[2]*z[5]*z[9]*z[13] -
8*f1*f8*z[2]*z[5]*z[9]*z[14] + 4*f6*z[2]*z[5]*z[12]*z[15] -
2*z[2]*z[5]*z[12]*z[16] - 2*f7*z[2]*z[5]*z[14]*z[15] + 4*f8*z[2]*z[5]*z[15]^2 +
(-8*f0*f8 + 4*f1*f7)*z[2]*z[6]*z[9]*z[11] + (8*f1*f8 -
8*f2*f7)*z[2]*z[6]*z[9]*z[12] - 8*f1*f8*z[2]*z[6]*z[9]*z[13] +
16*f2*f8*z[2]*z[6]*z[9]*z[14] - 4*f3*f8*z[2]*z[6]*z[9]*z[15] -
4*f6*z[2]*z[6]*z[11]*z[15] + 2*z[2]*z[6]*z[11]*z[16] + 4*f7*z[2]*z[6]*z[12]*z[15]
+ 2*f7*z[2]*z[6]*z[13]*z[15] - 8*f8*z[2]*z[6]*z[14]*z[15] +
8*f0*f8*z[2]*z[7]*z[9]*z[10] + 4*f3*f7*z[2]*z[7]*z[9]*z[12] -
8*f3*f8*z[2]*z[7]*z[9]*z[14] + (8*f4*f8 - 2*f5*f7)*z[2]*z[7]*z[9]*z[15] +
f6*z[2]*z[7]*z[9]*z[16] + 3*f6*z[2]*z[7]*z[10]*z[15] - 2*z[2]*z[7]*z[10]*z[16] +
f6*z[2]*z[7]*z[11]*z[14] - f6*z[2]*z[7]*z[12]*z[13] - 4*f7*z[2]*z[7]*z[12]*z[14] -
4*f8*z[2]*z[7]*z[12]*z[15] - 4*f8*z[2]*z[7]*z[13]*z[15] + 8*f8*z[2]*z[7]*z[14]^2 -
8*f0*f8*z[2]*z[8]*z[9]^2 - 2*z[2]*z[8]*z[9]*z[16] - 2*z[2]*z[8]*z[10]*z[15] +
4*z[2]*z[8]*z[12]^2 + 16*f0*f4*f8*z[3]^2*z[9]^2 - 16*f0*f8*z[3]^2*z[9]*z[13] +
4*f1*f8*z[3]^2*z[9]*z[14] - 4*f0*z[3]^2*z[10]^2 - 4*f4*z[3]^2*z[12]^2 +
2*f5*z[3]^2*z[12]*z[14] + 4*z[3]^2*z[12]*z[16] - 4*f8*z[3]^2*z[15]^2 -
16*f1*f4*f8*z[3]*z[4]*z[9]^2 + 12*f1*f8*z[3]*z[4]*z[9]*z[13] -
8*f2*f8*z[3]*z[4]*z[9]*z[14] + 8*f3*f8*z[3]*z[4]*z[9]*z[15] +
4*f1*z[3]*z[4]*z[10]^2 - 4*f3*z[3]*z[4]*z[10]*z[12] + 8*f4*z[3]*z[4]*z[11]*z[12] -
2*f5*z[3]*z[4]*z[11]*z[14] - 4*z[3]*z[4]*z[11]*z[16] - 2*f5*z[3]*z[4]*z[12]*z[13]
+ 4*f8*z[3]*z[4]*z[14]*z[15] - 16*f0*f5*f8*z[3]*z[5]*z[9]^2 +
8*f0*f7*z[3]*z[5]*z[9]*z[10] + 16*f0*f8*z[3]*z[5]*z[9]*z[11] -
4*f1*f8*z[3]*z[5]*z[9]*z[12] + 2*f5*z[3]*z[5]*z[12]^2 - 4*f6*z[3]*z[5]*z[12]*z[14]
- 4*f7*z[3]*z[5]*z[12]*z[15] + 2*f7*z[3]*z[5]*z[14]^2 + 4*f8*z[3]*z[5]*z[14]*z[15]
+ 8*f1*f5*f8*z[3]*z[6]*z[9]^2 - 4*f1*f7*z[3]*z[6]*z[9]*z[10] -
4*f1*f8*z[3]*z[6]*z[9]*z[11] + 4*f3*f7*z[3]*z[6]*z[9]*z[12] -
4*f3*f8*z[3]*z[6]*z[9]*z[14] - f6*z[3]*z[6]*z[9]*z[16] + f6*z[3]*z[6]*z[10]*z[15]
- 2*f5*z[3]*z[6]*z[11]*z[12] + 3*f6*z[3]*z[6]*z[11]*z[14] +
f6*z[3]*z[6]*z[12]*z[13] - 2*f7*z[3]*z[6]*z[13]*z[14] -
4*f1*f8*z[3]*z[7]*z[9]*z[10] - 8*f4*f7*z[3]*z[7]*z[9]*z[12] + (8*f4*f8 +
2*f5*f7)*z[3]*z[7]*z[9]*z[14] - 8*f5*f8*z[3]*z[7]*z[9]*z[15] +
4*f7*z[3]*z[7]*z[9]*z[16] + 2*f5*z[3]*z[7]*z[10]*z[12] -
4*f6*z[3]*z[7]*z[10]*z[14] + 8*f8*z[3]*z[7]*z[11]*z[15] +
4*f7*z[3]*z[7]*z[12]*z[13] - 4*f8*z[3]*z[7]*z[12]*z[14] -
4*f8*z[3]*z[7]*z[13]*z[14] + 4*f1*f8*z[3]*z[8]*z[9]^2 + 2*f5*z[3]*z[8]*z[9]*z[12]
+ 2*z[3]*z[8]*z[10]*z[14] - 4*z[3]*z[8]*z[11]*z[12] + (16*f2*f4*f8 -
4*f3^2*f8)*z[4]^2*z[9]^2 - 8*f2*f8*z[4]^2*z[9]*z[13] + 8*f3*f8*z[4]^2*z[9]*z[14] -
16*f4*f8*z[4]^2*z[9]*z[15] - 4*f2*z[4]^2*z[10]^2 + 4*f3*z[4]^2*z[10]*z[11] +
4*z[4]^2*z[10]*z[16] - 4*f4*z[4]^2*z[11]^2 + 2*f5*z[4]^2*z[11]*z[13] +
4*f8*z[4]^2*z[13]*z[15] - 4*f8*z[4]^2*z[14]^2 + 8*f1*f5*f8*z[4]*z[5]*z[9]^2 -
4*f1*f7*z[4]*z[5]*z[9]*z[10] - 8*f1*f8*z[4]*z[5]*z[9]*z[11] +
8*f2*f8*z[4]*z[5]*z[9]*z[12] + f6*z[4]*z[5]*z[9]*z[16] - f6*z[4]*z[5]*z[10]*z[15]
- 2*f5*z[4]*z[5]*z[11]*z[12] + f6*z[4]*z[5]*z[11]*z[14] +
4*f7*z[4]*z[5]*z[11]*z[15] + 3*f6*z[4]*z[5]*z[12]*z[13] -
4*f8*z[4]*z[5]*z[12]*z[15] - 2*f7*z[4]*z[5]*z[13]*z[14] -
4*f8*z[4]*z[5]*z[13]*z[15] - 16*f2*f5*f8*z[4]*z[6]*z[9]^2 +
8*f2*f7*z[4]*z[6]*z[9]*z[10] + (8*f2*f8 - 4*f3*f7)*z[4]*z[6]*z[9]*z[11] -
8*f3*f8*z[4]*z[6]*z[9]*z[12] + 4*f3*f8*z[4]*z[6]*z[9]*z[13] +
16*f5*f8*z[4]*z[6]*z[9]*z[15] - 4*f7*z[4]*z[6]*z[9]*z[16] -
4*f7*z[4]*z[6]*z[10]*z[15] + 2*f5*z[4]*z[6]*z[11]^2 - 4*f6*z[4]*z[6]*z[11]*z[13] -
4*f8*z[4]*z[6]*z[11]*z[15] + 8*f8*z[4]*z[6]*z[12]*z[14] + 2*f7*z[4]*z[6]*z[13]^2 +
8*f3*f5*f8*z[4]*z[7]*z[9]^2 + (8*f2*f8 - 4*f3*f7)*z[4]*z[7]*z[9]*z[10] + (-8*f3*f8
+ 8*f4*f7)*z[4]*z[7]*z[9]*z[11] + 16*f4*f8*z[4]*z[7]*z[9]*z[12] + (-8*f4*f8 -
2*f5*f7)*z[4]*z[7]*z[9]*z[13] - 8*f5*f8*z[4]*z[7]*z[9]*z[14] -
8*f8*z[4]*z[7]*z[9]*z[16] - 2*f5*z[4]*z[7]*z[10]*z[11] +
4*f6*z[4]*z[7]*z[10]*z[13] + 4*f7*z[4]*z[7]*z[10]*z[14] -
4*f8*z[4]*z[7]*z[10]*z[15] - 4*f7*z[4]*z[7]*z[11]*z[13] -
4*f8*z[4]*z[7]*z[12]*z[13] + 4*f8*z[4]*z[7]*z[13]^2 - 8*f2*f8*z[4]*z[8]*z[9]^2 -
2*f5*z[4]*z[8]*z[9]*z[11] + 12*f8*z[4]*z[8]*z[9]*z[15] - 4*z[4]*z[8]*z[10]*z[12] -
2*z[4]*z[8]*z[10]*z[13] + 4*z[4]*z[8]*z[11]^2 + (16*f0*f6*f8 -
4*f0*f7^2)*z[5]^2*z[9]^2 - 16*f0*f8*z[5]^2*z[9]*z[10] + 2*f7*z[5]^2*z[12]*z[14] +
4*f8*z[5]^2*z[12]*z[15] - 4*f8*z[5]^2*z[14]^2 + (-16*f1*f6*f8 +
4*f1*f7^2)*z[5]*z[6]*z[9]^2 + 16*f1*f8*z[5]*z[6]*z[9]*z[10] -
4*f3*f8*z[5]*z[6]*z[9]*z[12] - 2*f7*z[5]*z[6]*z[11]*z[14] -
4*f8*z[5]*z[6]*z[11]*z[15] - 2*f7*z[5]*z[6]*z[12]*z[13] +
8*f8*z[5]*z[6]*z[13]*z[14] + (8*f4*f8 + 2*f5*f7)*z[5]*z[7]*z[9]*z[12] -
8*f5*f8*z[5]*z[7]*z[9]*z[14] + (16*f6*f8 - 4*f7^2)*z[5]*z[7]*z[9]*z[15] -
8*f8*z[5]*z[7]*z[9]*z[16] + 2*f7*z[5]*z[7]*z[10]*z[14] -
4*f8*z[5]*z[7]*z[10]*z[15] + 4*f8*z[5]*z[7]*z[12]^2 - 4*f8*z[5]*z[7]*z[12]*z[13] -
4*f6*z[5]*z[8]*z[9]*z[12] + 2*f7*z[5]*z[8]*z[9]*z[14] - 4*f8*z[5]*z[8]*z[9]*z[15]
+ 2*z[5]*z[8]*z[10]*z[12] + (16*f2*f6*f8 - 4*f2*f7^2)*z[6]^2*z[9]^2 -
16*f2*f8*z[6]^2*z[9]*z[10] + 4*f3*f8*z[6]^2*z[9]*z[11] + (-16*f6*f8 +
4*f7^2)*z[6]^2*z[9]*z[15] + 8*f8*z[6]^2*z[9]*z[16] + 8*f8*z[6]^2*z[10]*z[15] +
2*f7*z[6]^2*z[11]*z[13] - 4*f8*z[6]^2*z[12]^2 - 4*f8*z[6]^2*z[13]^2 +
(-16*f3*f6*f8 + 4*f3*f7^2)*z[6]*z[7]*z[9]^2 + 12*f3*f8*z[6]*z[7]*z[9]*z[10] +
(-8*f4*f8 - 2*f5*f7)*z[6]*z[7]*z[9]*z[11] - 8*f5*f8*z[6]*z[7]*z[9]*z[12] +
8*f5*f8*z[6]*z[7]*z[9]*z[13] + (16*f6*f8 - 4*f7^2)*z[6]*z[7]*z[9]*z[14] -
2*f7*z[6]*z[7]*z[10]*z[13] - 8*f8*z[6]*z[7]*z[10]*z[14] +
4*f8*z[6]*z[7]*z[11]*z[12] + 4*f8*z[6]*z[7]*z[11]*z[13] + 4*f3*f8*z[6]*z[8]*z[9]^2
+ 4*f6*z[6]*z[8]*z[9]*z[11] + 4*f7*z[6]*z[8]*z[9]*z[12] -
2*f7*z[6]*z[8]*z[9]*z[13] - 8*f8*z[6]*z[8]*z[9]*z[14] - 2*z[6]*z[8]*z[10]*z[11] +
(16*f4*f6*f8 - 4*f4*f7^2 - 4*f5^2*f8)*z[7]^2*z[9]^2 + (-8*f4*f8 +
2*f5*f7)*z[7]^2*z[9]*z[10] + 8*f5*f8*z[7]^2*z[9]*z[11] + (-16*f6*f8 +
4*f7^2)*z[7]^2*z[9]*z[13] + 4*f8*z[7]^2*z[10]*z[12] + 4*f8*z[7]^2*z[10]*z[13] -
4*f8*z[7]^2*z[11]^2 + (-8*f4*f8 + 2*f5*f7)*z[7]*z[8]*z[9]^2 -
4*f6*z[7]*z[8]*z[9]*z[10] - 4*f7*z[7]*z[8]*z[9]*z[11] - 4*f8*z[7]*z[8]*z[9]*z[12]
+ 12*f8*z[7]*z[8]*z[9]*z[13] + 2*z[7]*z[8]*z[10]^2 + 2*z[8]^2*z[9]*z[10],

// Bmat[2,2]
  (-256*f0*f2*f4*f6*f8^2 + 64*f0*f2*f4*f7^2*f8 + 64*f0*f2*f5^2*f8^2 +
64*f0*f3^2*f6*f8^2 - 16*f0*f3^2*f7^2*f8 + 64*f1^2*f4*f6*f8^2 - 16*f1^2*f4*f7^2*f8
- 16*f1^2*f5^2*f8^2)*z[1]^2*z[9]^2 + (128*f0*f2*f4*f8^2 - 32*f0*f2*f5*f7*f8 -
32*f0*f3^2*f8^2 - 32*f1^2*f4*f8^2 + 8*f1^2*f5*f7*f8)*z[1]^2*z[9]*z[10] +
(-64*f0*f2*f5*f8^2 + 16*f0*f3*f5*f7*f8 + 16*f1^2*f5*f8^2)*z[1]^2*z[9]*z[11] +
(32*f0*f3*f5*f8^2 - 8*f1*f3*f5*f7*f8)*z[1]^2*z[9]*z[12] + (128*f0*f2*f6*f8^2 -
32*f0*f2*f7^2*f8 - 32*f0*f3*f5*f8^2 - 32*f1^2*f6*f8^2 +
8*f1^2*f7^2*f8)*z[1]^2*z[9]*z[13] + (-64*f0*f3*f6*f8^2 + 16*f0*f3*f7^2*f8 +
16*f1*f3*f5*f8^2)*z[1]^2*z[9]*z[14] + (128*f0*f4*f6*f8^2 - 32*f0*f4*f7^2*f8 -
32*f0*f5^2*f8^2 - 32*f1*f3*f6*f8^2 + 8*f1*f3*f7^2*f8)*z[1]^2*z[9]*z[15] +
(-32*f0*f4*f8^2 + 8*f0*f5*f7*f8 + 8*f1*f3*f8^2)*z[1]^2*z[9]*z[16] + (32*f0^2*f8^2
+ 64*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 16*f1^2*f6*f8 + 4*f1^2*f7^2)*z[1]^2*z[10]^2 +
(-32*f0*f1*f8^2 - 64*f0*f3*f6*f8 + 16*f0*f3*f7^2)*z[1]^2*z[10]*z[11] +
(-64*f0*f2*f8^2 + 32*f1^2*f8^2 + 32*f1*f3*f6*f8 - 8*f1*f3*f7^2)*z[1]^2*z[10]*z[12]
+ 32*f0*f3*f8^2*z[1]^2*z[10]*z[14] + (-32*f0*f4*f8^2 + 8*f0*f5*f7*f8 -
8*f1*f3*f8^2)*z[1]^2*z[10]*z[15] + (-32*f0*f6*f8 + 8*f0*f7^2)*z[1]^2*z[10]*z[16] +
(32*f0*f2*f8^2 + 64*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 8*f0*f5^2*f8)*z[1]^2*z[11]^2 +
(32*f0*f3*f8^2 - 32*f1*f2*f8^2 - 64*f1*f4*f6*f8 + 16*f1*f4*f7^2 +
8*f1*f5^2*f8)*z[1]^2*z[11]*z[12] + (-32*f0*f3*f8^2 - 32*f0*f5*f6*f8 +
8*f0*f5*f7^2)*z[1]^2*z[11]*z[13] + (-32*f0*f4*f8^2 + 8*f0*f5*f7*f8 + 8*f1*f3*f8^2
+ 16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[1]^2*z[11]*z[14] + (32*f1*f4*f8^2 -
8*f1*f5*f7*f8)*z[1]^2*z[11]*z[15] + (16*f1*f6*f8 - 4*f1*f7^2)*z[1]^2*z[11]*z[16] +
(32*f0*f4*f8^2 - 32*f1*f3*f8^2 + 32*f2^2*f8^2 + 64*f2*f4*f6*f8 - 16*f2*f4*f7^2 -
8*f2*f5^2*f8 - 16*f3^2*f6*f8 + 4*f3^2*f7^2)*z[1]^2*z[12]^2 + (-32*f0*f4*f8^2 +
8*f0*f5*f7*f8 + 24*f1*f3*f8^2 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[1]^2*z[12]*z[13]
+ (-32*f0*f5*f8^2 + 32*f1*f4*f8^2 - 8*f1*f5*f7*f8 - 32*f2*f3*f8^2 - 32*f2*f5*f6*f8
+ 8*f2*f5*f7^2)*z[1]^2*z[12]*z[14] + (16*f1*f5*f8^2 - 64*f2*f4*f8^2 +
16*f2*f5*f7*f8 + 32*f3^2*f8^2 + 16*f3*f5*f6*f8 - 4*f3*f5*f7^2)*z[1]^2*z[12]*z[15]
+ (-32*f2*f6*f8 + 8*f2*f7^2)*z[1]^2*z[12]*z[16] + (32*f0*f4*f8^2 - 16*f0*f5*f7*f8
+ 32*f0*f6^2*f8 - 8*f0*f6*f7^2)*z[1]^2*z[13]^2 + (32*f0*f5*f8^2 - 32*f0*f6*f7*f8 +
8*f0*f7^3 - 32*f1*f4*f8^2 + 16*f1*f5*f7*f8 - 32*f1*f6^2*f8 +
8*f1*f6*f7^2)*z[1]^2*z[13]*z[14] + (-16*f1*f5*f8^2 + 16*f1*f6*f7*f8 -
4*f1*f7^3)*z[1]^2*z[13]*z[15] + (32*f0*f6*f8^2 - 8*f0*f7^2*f8 - 16*f1*f5*f8^2 +
16*f1*f6*f7*f8 - 4*f1*f7^3 + 32*f2*f4*f8^2 - 16*f2*f5*f7*f8 + 32*f2*f6^2*f8 -
8*f2*f6*f7^2)*z[1]^2*z[14]^2 + (-32*f1*f6*f8^2 + 8*f1*f7^2*f8 + 32*f2*f5*f8^2 -
32*f2*f6*f7*f8 + 8*f2*f7^3 - 32*f3*f4*f8^2 + 16*f3*f5*f7*f8 - 32*f3*f6^2*f8 +
8*f3*f6*f7^2)*z[1]^2*z[14]*z[15] + (16*f3*f6*f8 - 4*f3*f7^2)*z[1]^2*z[14]*z[16] +
(32*f2*f6*f8^2 - 8*f2*f7^2*f8 - 32*f3*f5*f8^2 + 16*f3*f6*f7*f8 - 4*f3*f7^3 +
32*f4^2*f8^2 - 16*f4*f5*f7*f8 + 32*f4*f6^2*f8 - 8*f4*f6*f7^2 - 8*f5^2*f6*f8 +
2*f5^2*f7^2)*z[1]^2*z[15]^2 + (-32*f4*f6*f8 + 8*f4*f7^2 +
8*f5^2*f8)*z[1]^2*z[15]*z[16] + (128*f0*f2*f4*f8^2 - 32*f0*f2*f5*f7*f8 -
32*f0*f3^2*f8^2 - 32*f1^2*f4*f8^2 + 8*f1^2*f5*f7*f8)*z[1]*z[2]*z[9]^2 +
(-64*f0^2*f8^2 - 64*f0*f2*f6*f8 + 32*f0*f2*f7^2 + 16*f1^2*f6*f8 -
8*f1^2*f7^2)*z[1]*z[2]*z[9]*z[10] + (32*f0*f1*f8^2 + 32*f0*f2*f7*f8 +
32*f0*f3*f6*f8 - 16*f0*f3*f7^2 - 8*f1^2*f7*f8)*z[1]*z[2]*z[9]*z[11] +
(64*f0*f2*f8^2 - 16*f0*f3*f7*f8 - 32*f1^2*f8^2 - 16*f1*f3*f6*f8 +
8*f1*f3*f7^2)*z[1]*z[2]*z[9]*z[12] + (-128*f0*f2*f8^2 + 16*f0*f3*f7*f8 +
32*f1^2*f8^2)*z[1]*z[2]*z[9]*z[13] + (32*f0*f3*f8^2 -
8*f1*f3*f7*f8)*z[1]*z[2]*z[9]*z[14] + (-64*f0*f4*f8^2 + 16*f0*f5*f7*f8 +
32*f1*f3*f8^2)*z[1]*z[2]*z[9]*z[15] + (16*f0*f6*f8 -
8*f0*f7^2)*z[1]*z[2]*z[9]*z[16] + (-32*f0*f2*f8 + 8*f1^2*f8)*z[1]*z[2]*z[10]^2 +
32*f0*f3*f8*z[1]*z[2]*z[10]*z[11] - 16*f1*f3*f8*z[1]*z[2]*z[10]*z[12] +
(16*f0*f6*f8 - 8*f0*f7^2)*z[1]*z[2]*z[10]*z[15] + 16*f0*f8*z[1]*z[2]*z[10]*z[16] +
(-32*f0*f4*f8 + 8*f0*f5*f7)*z[1]*z[2]*z[11]^2 + (-16*f0*f5*f8 + 32*f1*f4*f8 -
8*f1*f5*f7)*z[1]*z[2]*z[11]*z[12] + 16*f0*f5*f8*z[1]*z[2]*z[11]*z[13] +
(16*f0*f6*f8 - 8*f0*f7^2 - 8*f1*f5*f8)*z[1]*z[2]*z[11]*z[14] + (-16*f1*f6*f8 +
8*f1*f7^2)*z[1]*z[2]*z[11]*z[15] - 8*f1*f8*z[1]*z[2]*z[11]*z[16] + (8*f1*f5*f8 -
32*f2*f4*f8 + 8*f2*f5*f7 + 8*f3^2*f8)*z[1]*z[2]*z[12]^2 + (16*f0*f6*f8 - 8*f0*f7^2
- 8*f1*f5*f8)*z[1]*z[2]*z[12]*z[13] + (16*f0*f7*f8 - 16*f1*f6*f8 + 8*f1*f7^2 +
16*f2*f5*f8)*z[1]*z[2]*z[12]*z[14] + (-8*f1*f7*f8 + 32*f2*f6*f8 - 16*f2*f7^2 -
16*f3*f5*f8)*z[1]*z[2]*z[12]*z[15] + 16*f2*f8*z[1]*z[2]*z[12]*z[16] +
(-32*f0*f6*f8 + 8*f0*f7^2)*z[1]*z[2]*z[13]^2 + (16*f0*f7*f8 + 32*f1*f6*f8 -
8*f1*f7^2)*z[1]*z[2]*z[13]*z[14] - 8*f1*f7*f8*z[1]*z[2]*z[13]*z[15] + (-32*f0*f8^2
- 8*f1*f7*f8 - 32*f2*f6*f8 + 8*f2*f7^2)*z[1]*z[2]*z[14]^2 + (32*f1*f8^2 +
16*f2*f7*f8 + 32*f3*f6*f8 - 8*f3*f7^2)*z[1]*z[2]*z[14]*z[15] -
8*f3*f8*z[1]*z[2]*z[14]*z[16] + (-32*f2*f8^2 - 32*f4*f6*f8 + 8*f4*f7^2 +
8*f5^2*f8)*z[1]*z[2]*z[15]^2 + (16*f4*f8 - 4*f5*f7)*z[1]*z[2]*z[15]*z[16] +
(-64*f0*f2*f5*f8^2 + 16*f0*f3*f5*f7*f8 + 16*f1^2*f5*f8^2)*z[1]*z[3]*z[9]^2 +
(32*f0*f1*f8^2 + 32*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 16*f0*f3*f7^2 -
8*f1^2*f7*f8)*z[1]*z[3]*z[9]*z[10] + (-32*f0*f3*f7*f8 - 64*f0*f4*f6*f8 +
32*f0*f4*f7^2 - 16*f1^2*f8^2)*z[1]*z[3]*z[9]*z[11] + (-64*f0*f3*f8^2 +
32*f0*f4*f7*f8 + 32*f1*f2*f8^2 + 8*f1*f3*f7*f8 + 32*f1*f4*f6*f8 -
16*f1*f4*f7^2)*z[1]*z[3]*z[9]*z[12] + (64*f0*f3*f8^2 - 32*f0*f4*f7*f8 +
32*f0*f5*f6*f8 - 8*f0*f5*f7^2)*z[1]*z[3]*z[9]*z[13] + (-16*f0*f5*f7*f8 -
16*f1*f3*f8^2 + 16*f1*f4*f7*f8 - 16*f1*f5*f6*f8 +
4*f1*f5*f7^2)*z[1]*z[3]*z[9]*z[14] + (64*f0*f5*f8^2 -
32*f1*f4*f8^2)*z[1]*z[3]*z[9]*z[15] + (-16*f0*f7*f8 - 8*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[3]*z[9]*z[16] - 8*f0*f5*f7*z[1]*z[3]*z[10]*z[11] +
4*f1*f5*f7*z[1]*z[3]*z[10]*z[12] - 16*f0*f5*f8*z[1]*z[3]*z[10]*z[13] +
(-32*f0*f6*f8 + 16*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[3]*z[10]*z[14] + (-16*f0*f7*f8 +
8*f1*f6*f8 - 4*f1*f7^2)*z[1]*z[3]*z[10]*z[15] + 16*f0*f5*f8*z[1]*z[3]*z[11]^2 -
8*f1*f5*f8*z[1]*z[3]*z[11]*z[12] + (32*f0*f6*f8 -
16*f0*f7^2)*z[1]*z[3]*z[11]*z[13] + (-8*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[3]*z[11]*z[14] + 8*f1*f7*f8*z[1]*z[3]*z[11]*z[15] -
4*f3*f5*f7*z[1]*z[3]*z[12]^2 + (-24*f1*f6*f8 + 12*f1*f7^2)*z[1]*z[3]*z[12]*z[13] +
(32*f0*f8^2 - 8*f1*f7*f8 + 32*f2*f6*f8 - 16*f2*f7^2)*z[1]*z[3]*z[12]*z[14] +
(-16*f1*f8^2 - 32*f3*f6*f8 + 16*f3*f7^2 + 16*f4*f5*f8)*z[1]*z[3]*z[12]*z[15] +
16*f0*f7*f8*z[1]*z[3]*z[13]^2 + (-32*f0*f8^2 - 16*f1*f7*f8)*z[1]*z[3]*z[13]*z[14]
+ 16*f1*f8^2*z[1]*z[3]*z[13]*z[15] + (16*f1*f8^2 + 16*f2*f7*f8)*z[1]*z[3]*z[14]^2
+ (-32*f2*f8^2 - 16*f3*f7*f8 - 8*f5^2*f8)*z[1]*z[3]*z[14]*z[15] +
4*f5*f7*z[1]*z[3]*z[14]*z[16] + (32*f3*f8^2 + 16*f5*f6*f8 -
4*f5*f7^2)*z[1]*z[3]*z[15]^2 - 16*f5*f8*z[1]*z[3]*z[15]*z[16] + (32*f0*f3*f5*f8^2
- 8*f1*f3*f5*f7*f8)*z[1]*z[4]*z[9]^2 + (64*f0*f2*f8^2 - 16*f0*f3*f7*f8 -
32*f1^2*f8^2 - 16*f1*f3*f6*f8 + 8*f1*f3*f7^2)*z[1]*z[4]*z[9]*z[10] +
(-64*f0*f3*f8^2 + 32*f0*f4*f7*f8 + 32*f1*f2*f8^2 + 8*f1*f3*f7*f8 + 32*f1*f4*f6*f8
- 16*f1*f4*f7^2)*z[1]*z[4]*z[9]*z[11] + (64*f1*f3*f8^2 - 32*f1*f4*f7*f8 -
64*f2^2*f8^2 - 64*f2*f4*f6*f8 + 32*f2*f4*f7^2 + 16*f3^2*f6*f8 -
8*f3^2*f7^2)*z[1]*z[4]*z[9]*z[12] + (-16*f0*f5*f7*f8 - 32*f1*f3*f8^2 +
16*f1*f4*f7*f8 - 16*f1*f5*f6*f8 + 4*f1*f5*f7^2)*z[1]*z[4]*z[9]*z[13] +
(16*f1*f5*f7*f8 + 32*f2*f3*f8^2 - 32*f2*f4*f7*f8 + 32*f2*f5*f6*f8 - 8*f2*f5*f7^2 +
8*f3^2*f7*f8)*z[1]*z[4]*z[9]*z[14] + (-32*f1*f5*f8^2 + 64*f2*f4*f8^2 -
32*f3^2*f8^2 - 16*f3*f5*f6*f8 + 4*f3*f5*f7^2)*z[1]*z[4]*z[9]*z[15] + (-16*f0*f8^2
+ 8*f1*f7*f8 + 16*f2*f6*f8 - 8*f2*f7^2 + 4*f3*f5*f8)*z[1]*z[4]*z[9]*z[16] +
4*f1*f5*f7*z[1]*z[4]*z[10]*z[11] - 8*f2*f5*f7*z[1]*z[4]*z[10]*z[12] +
(-32*f0*f6*f8 + 16*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[4]*z[10]*z[13] + (32*f1*f6*f8 -
16*f1*f7^2 - 16*f2*f5*f8)*z[1]*z[4]*z[10]*z[14] + (-16*f0*f8^2 + 8*f1*f7*f8 -
16*f2*f6*f8 + 8*f2*f7^2 + 12*f3*f5*f8)*z[1]*z[4]*z[10]*z[15] -
8*f1*f5*f8*z[1]*z[4]*z[11]^2 + (16*f2*f5*f8 + 4*f3*f5*f7)*z[1]*z[4]*z[11]*z[12] -
16*f0*f7*f8*z[1]*z[4]*z[11]*z[13] + (16*f0*f8^2 + 8*f1*f7*f8 - 16*f2*f6*f8 +
8*f2*f7^2 + 4*f3*f5*f8)*z[1]*z[4]*z[11]*z[14] + (-16*f2*f7*f8 + 16*f3*f6*f8 -
8*f3*f7^2 - 16*f4*f5*f8)*z[1]*z[4]*z[11]*z[15] - 8*f3*f5*f8*z[1]*z[4]*z[12]^2 +
(16*f0*f8^2 + 8*f1*f7*f8 + 16*f2*f6*f8 - 8*f2*f7^2 -
4*f3*f5*f8)*z[1]*z[4]*z[12]*z[13] + (-32*f1*f8^2 - 16*f3*f6*f8 +
8*f3*f7^2)*z[1]*z[4]*z[12]*z[14] + (32*f2*f8^2 + 8*f3*f7*f8 + 32*f4*f6*f8 -
16*f4*f7^2)*z[1]*z[4]*z[12]*z[15] + 4*f5*f7*z[1]*z[4]*z[12]*z[16] + (8*f3*f7*f8 +
8*f5^2*f8)*z[1]*z[4]*z[13]*z[15] - 4*f5*f7*z[1]*z[4]*z[13]*z[16] -
8*f3*f7*f8*z[1]*z[4]*z[14]^2 + (16*f4*f7*f8 - 16*f5*f6*f8 +
4*f5*f7^2)*z[1]*z[4]*z[14]*z[15] + 8*f5*f8*z[1]*z[4]*z[14]*z[16] -
32*f4*f8^2*z[1]*z[4]*z[15]^2 + (128*f0*f2*f6*f8^2 - 32*f0*f2*f7^2*f8 -
32*f0*f3*f5*f8^2 - 32*f1^2*f6*f8^2 + 8*f1^2*f7^2*f8)*z[1]*z[5]*z[9]^2 +
(-128*f0*f2*f8^2 + 16*f0*f3*f7*f8 + 32*f1^2*f8^2)*z[1]*z[5]*z[9]*z[10] +
(64*f0*f3*f8^2 - 32*f0*f4*f7*f8 + 32*f0*f5*f6*f8 -
8*f0*f5*f7^2)*z[1]*z[5]*z[9]*z[11] + (-16*f0*f5*f7*f8 - 32*f1*f3*f8^2 +
16*f1*f4*f7*f8 - 16*f1*f5*f6*f8 + 4*f1*f5*f7^2)*z[1]*z[5]*z[9]*z[12] +
(32*f0*f5*f7*f8 - 64*f0*f6^2*f8 + 16*f0*f6*f7^2)*z[1]*z[5]*z[9]*z[13] +
(32*f0*f6*f7*f8 - 8*f0*f7^3 - 16*f1*f5*f7*f8 + 32*f1*f6^2*f8 -
8*f1*f6*f7^2)*z[1]*z[5]*z[9]*z[14] + (-128*f0*f6*f8^2 + 32*f0*f7^2*f8 +
32*f1*f5*f8^2 - 16*f1*f6*f7*f8 + 4*f1*f7^3)*z[1]*z[5]*z[9]*z[15] + (48*f0*f8^2 -
4*f1*f7*f8)*z[1]*z[5]*z[9]*z[16] + 16*f0*f5*f8*z[1]*z[5]*z[10]*z[11] +
(32*f0*f6*f8 - 8*f0*f7^2 - 8*f1*f5*f8)*z[1]*z[5]*z[10]*z[12] + (32*f0*f6*f8 -
8*f0*f7^2)*z[1]*z[5]*z[10]*z[13] + (-16*f0*f7*f8 - 16*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[5]*z[10]*z[14] + (48*f0*f8^2 + 4*f1*f7*f8)*z[1]*z[5]*z[10]*z[15]
+ (-64*f0*f6*f8 + 16*f0*f7^2)*z[1]*z[5]*z[11]^2 + (48*f1*f6*f8 -
12*f1*f7^2)*z[1]*z[5]*z[11]*z[12] + 16*f0*f7*f8*z[1]*z[5]*z[11]*z[13] +
(16*f0*f8^2 - 4*f1*f7*f8)*z[1]*z[5]*z[11]*z[14] - 32*f1*f8^2*z[1]*z[5]*z[11]*z[15]
+ (-32*f0*f8^2 - 32*f2*f6*f8 + 8*f2*f7^2 + 8*f3*f5*f8)*z[1]*z[5]*z[12]^2 +
(16*f0*f8^2 - 12*f1*f7*f8)*z[1]*z[5]*z[12]*z[13] +
16*f2*f7*f8*z[1]*z[5]*z[12]*z[14] + (32*f2*f8^2 - 16*f3*f7*f8 -
8*f5^2*f8)*z[1]*z[5]*z[12]*z[15] - 32*f0*f8^2*z[1]*z[5]*z[13]^2 +
32*f1*f8^2*z[1]*z[5]*z[13]*z[14] - 32*f2*f8^2*z[1]*z[5]*z[14]^2 + (32*f3*f8^2 +
16*f5*f6*f8 - 4*f5*f7^2)*z[1]*z[5]*z[14]*z[15] - 8*f5*f8*z[1]*z[5]*z[14]*z[16] +
(-32*f4*f8^2 + 16*f5*f7*f8 - 32*f6^2*f8 + 8*f6*f7^2)*z[1]*z[5]*z[15]^2 + (32*f6*f8
- 8*f7^2)*z[1]*z[5]*z[15]*z[16] + (-64*f0*f3*f6*f8^2 + 16*f0*f3*f7^2*f8 +
16*f1*f3*f5*f8^2)*z[1]*z[6]*z[9]^2 + (32*f0*f3*f8^2 -
8*f1*f3*f7*f8)*z[1]*z[6]*z[9]*z[10] + (-16*f0*f5*f7*f8 - 16*f1*f3*f8^2 +
16*f1*f4*f7*f8 - 16*f1*f5*f6*f8 + 4*f1*f5*f7^2)*z[1]*z[6]*z[9]*z[11] +
(16*f1*f5*f7*f8 + 32*f2*f3*f8^2 - 32*f2*f4*f7*f8 + 32*f2*f5*f6*f8 - 8*f2*f5*f7^2 +
8*f3^2*f7*f8)*z[1]*z[6]*z[9]*z[12] + (32*f0*f6*f7*f8 - 8*f0*f7^3 - 16*f1*f5*f7*f8
+ 32*f1*f6^2*f8 - 8*f1*f6*f7^2)*z[1]*z[6]*z[9]*z[13] + (-32*f1*f6*f7*f8 +
8*f1*f7^3 + 32*f2*f5*f7*f8 - 64*f2*f6^2*f8 + 16*f2*f6*f7^2 -
16*f3^2*f8^2)*z[1]*z[6]*z[9]*z[14] + (64*f1*f6*f8^2 - 16*f1*f7^2*f8 -
64*f2*f5*f8^2 + 32*f2*f6*f7*f8 - 8*f2*f7^3 + 32*f3*f4*f8^2 - 16*f3*f5*f7*f8 +
32*f3*f6^2*f8 - 8*f3*f6*f7^2)*z[1]*z[6]*z[9]*z[15] + (-16*f1*f8^2 + 8*f2*f7*f8 -
16*f3*f6*f8 + 4*f3*f7^2)*z[1]*z[6]*z[9]*z[16] + (32*f0*f6*f8 - 8*f0*f7^2 -
8*f1*f5*f8)*z[1]*z[6]*z[10]*z[11] + (-32*f1*f6*f8 + 8*f1*f7^2 +
16*f2*f5*f8)*z[1]*z[6]*z[10]*z[12] + (-16*f0*f7*f8 - 16*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[6]*z[10]*z[13] + (16*f1*f7*f8 + 32*f2*f6*f8 -
8*f2*f7^2)*z[1]*z[6]*z[10]*z[14] + (-16*f1*f8^2 - 8*f2*f7*f8 - 16*f3*f6*f8 +
4*f3*f7^2)*z[1]*z[6]*z[10]*z[15] + (16*f1*f6*f8 - 4*f1*f7^2)*z[1]*z[6]*z[11]^2 +
(-32*f0*f8^2 - 32*f2*f6*f8 + 8*f2*f7^2 - 8*f3*f5*f8)*z[1]*z[6]*z[11]*z[12] +
32*f0*f8^2*z[1]*z[6]*z[11]*z[13] + (-16*f1*f8^2 -
8*f2*f7*f8)*z[1]*z[6]*z[11]*z[14] + (32*f2*f8^2 + 8*f3*f7*f8 +
8*f5^2*f8)*z[1]*z[6]*z[11]*z[15] + (32*f1*f8^2 + 32*f3*f6*f8 -
8*f3*f7^2)*z[1]*z[6]*z[12]^2 + (-16*f1*f8^2 + 8*f2*f7*f8)*z[1]*z[6]*z[12]*z[13] -
8*f3*f7*f8*z[1]*z[6]*z[12]*z[14] + (-48*f3*f8^2 + 16*f4*f7*f8 - 16*f5*f6*f8 +
4*f5*f7^2)*z[1]*z[6]*z[12]*z[15] - 8*f5*f8*z[1]*z[6]*z[12]*z[16] + (-16*f3*f8^2 -
16*f5*f6*f8 + 4*f5*f7^2)*z[1]*z[6]*z[13]*z[15] + 8*f5*f8*z[1]*z[6]*z[13]*z[16] +
16*f3*f8^2*z[1]*z[6]*z[14]^2 + (-16*f5*f7*f8 + 32*f6^2*f8 -
8*f6*f7^2)*z[1]*z[6]*z[14]*z[15] + (-16*f6*f8 + 4*f7^2)*z[1]*z[6]*z[14]*z[16] +
(32*f5*f8^2 - 16*f6*f7*f8 + 4*f7^3)*z[1]*z[6]*z[15]^2 + (128*f0*f4*f6*f8^2 -
32*f0*f4*f7^2*f8 - 32*f0*f5^2*f8^2 - 32*f1*f3*f6*f8^2 +
8*f1*f3*f7^2*f8)*z[1]*z[7]*z[9]^2 + (-64*f0*f4*f8^2 + 16*f0*f5*f7*f8 +
32*f1*f3*f8^2)*z[1]*z[7]*z[9]*z[10] + (64*f0*f5*f8^2 -
32*f1*f4*f8^2)*z[1]*z[7]*z[9]*z[11] + (-32*f1*f5*f8^2 + 64*f2*f4*f8^2 -
32*f3^2*f8^2 - 16*f3*f5*f6*f8 + 4*f3*f5*f7^2)*z[1]*z[7]*z[9]*z[12] +
(-128*f0*f6*f8^2 + 32*f0*f7^2*f8 + 32*f1*f5*f8^2 - 16*f1*f6*f7*f8 +
4*f1*f7^3)*z[1]*z[7]*z[9]*z[13] + (64*f1*f6*f8^2 - 16*f1*f7^2*f8 - 64*f2*f5*f8^2 +
32*f2*f6*f7*f8 - 8*f2*f7^3 + 32*f3*f4*f8^2 - 16*f3*f5*f7*f8 + 32*f3*f6^2*f8 -
8*f3*f6*f7^2)*z[1]*z[7]*z[9]*z[14] + (64*f3*f5*f8^2 - 32*f3*f6*f7*f8 + 8*f3*f7^3 -
64*f4^2*f8^2 + 32*f4*f5*f7*f8 - 64*f4*f6^2*f8 + 16*f4*f6*f7^2 + 16*f5^2*f6*f8 -
4*f5^2*f7^2)*z[1]*z[7]*z[9]*z[15] + (-16*f2*f8^2 + 32*f4*f6*f8 - 8*f4*f7^2 -
8*f5^2*f8)*z[1]*z[7]*z[9]*z[16] + (-32*f0*f6*f8 + 8*f0*f7^2)*z[1]*z[7]*z[10]^2 +
(16*f1*f6*f8 - 4*f1*f7^2)*z[1]*z[7]*z[10]*z[11] + (32*f0*f8^2 - 32*f2*f6*f8 +
8*f2*f7^2)*z[1]*z[7]*z[10]*z[12] + 32*f0*f8^2*z[1]*z[7]*z[10]*z[13] + (-32*f1*f8^2
- 16*f3*f6*f8 + 4*f3*f7^2)*z[1]*z[7]*z[10]*z[14] + (16*f2*f8^2 + 32*f4*f6*f8 -
8*f4*f7^2 - 8*f5^2*f8)*z[1]*z[7]*z[10]*z[15] - 32*f0*f8^2*z[1]*z[7]*z[11]^2 +
(32*f1*f8^2 + 32*f3*f6*f8 - 8*f3*f7^2)*z[1]*z[7]*z[11]*z[12] +
16*f2*f8^2*z[1]*z[7]*z[11]*z[14] + (-32*f3*f8^2 - 16*f5*f6*f8 +
4*f5*f7^2)*z[1]*z[7]*z[11]*z[15] + (-32*f2*f8^2 - 64*f4*f6*f8 + 16*f4*f7^2 +
8*f5^2*f8)*z[1]*z[7]*z[12]^2 - 16*f2*f8^2*z[1]*z[7]*z[12]*z[13] + (32*f3*f8^2 +
32*f5*f6*f8 - 8*f5*f7^2)*z[1]*z[7]*z[12]*z[14] + (32*f4*f8^2 -
16*f5*f7*f8)*z[1]*z[7]*z[12]*z[15] + (48*f6*f8 - 12*f7^2)*z[1]*z[7]*z[12]*z[16] +
(32*f4*f8^2 - 16*f5*f7*f8 + 32*f6^2*f8 - 8*f6*f7^2)*z[1]*z[7]*z[13]*z[15] +
(-16*f6*f8 + 4*f7^2)*z[1]*z[7]*z[13]*z[16] + (-32*f4*f8^2 + 16*f5*f7*f8 -
32*f6^2*f8 + 8*f6*f7^2)*z[1]*z[7]*z[14]^2 + (16*f6*f7*f8 -
4*f7^3)*z[1]*z[7]*z[14]*z[15] + (-32*f6*f8^2 + 8*f7^2*f8)*z[1]*z[7]*z[15]^2 +
(-32*f0*f4*f8^2 + 8*f0*f5*f7*f8 + 8*f1*f3*f8^2)*z[1]*z[8]*z[9]^2 + (16*f0*f6*f8 -
8*f0*f7^2)*z[1]*z[8]*z[9]*z[10] + (-16*f0*f7*f8 - 8*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[8]*z[9]*z[11] + (-16*f0*f8^2 + 8*f1*f7*f8 + 16*f2*f6*f8 -
8*f2*f7^2 + 4*f3*f5*f8)*z[1]*z[8]*z[9]*z[12] + (48*f0*f8^2 -
4*f1*f7*f8)*z[1]*z[8]*z[9]*z[13] + (-16*f1*f8^2 + 8*f2*f7*f8 - 16*f3*f6*f8 +
4*f3*f7^2)*z[1]*z[8]*z[9]*z[14] + (-16*f2*f8^2 + 32*f4*f6*f8 - 8*f4*f7^2 -
8*f5^2*f8)*z[1]*z[8]*z[9]*z[15] + (-8*f4*f8 + 3*f5*f7)*z[1]*z[8]*z[9]*z[16] +
8*f0*f8*z[1]*z[8]*z[10]^2 - 4*f1*f8*z[1]*z[8]*z[10]*z[11] +
8*f2*f8*z[1]*z[8]*z[10]*z[12] + 4*f3*f8*z[1]*z[8]*z[10]*z[14] + (-8*f4*f8 +
f5*f7)*z[1]*z[8]*z[10]*z[15] - 8*f3*f8*z[1]*z[8]*z[11]*z[12] -
f5*f7*z[1]*z[8]*z[11]*z[14] + 12*f5*f8*z[1]*z[8]*z[11]*z[15] + (16*f4*f8 -
4*f5*f7)*z[1]*z[8]*z[12]^2 + f5*f7*z[1]*z[8]*z[12]*z[13] -
8*f5*f8*z[1]*z[8]*z[12]*z[14] + (-24*f6*f8 + 12*f7^2)*z[1]*z[8]*z[12]*z[15] -
12*f8*z[1]*z[8]*z[12]*z[16] + (-16*f6*f8 + 4*f7^2)*z[1]*z[8]*z[13]*z[15] +
4*f8*z[1]*z[8]*z[13]*z[16] + (16*f6*f8 - 4*f7^2)*z[1]*z[8]*z[14]^2 -
12*f7*f8*z[1]*z[8]*z[14]*z[15] + 24*f8^2*z[1]*z[8]*z[15]^2 + (32*f0^2*f8^2 +
64*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 16*f1^2*f6*f8 + 4*f1^2*f7^2)*z[2]^2*z[9]^2 +
(-32*f0*f2*f8 + 8*f1^2*f8)*z[2]^2*z[9]*z[10] + (-32*f0*f6*f8 +
8*f0*f7^2)*z[2]^2*z[9]*z[15] + 8*f0*f8*z[2]^2*z[9]*z[16] +
8*f0*f8*z[2]^2*z[10]*z[15] - 8*f0*f6*z[2]^2*z[11]^2 + (8*f0*f7 +
8*f1*f6)*z[2]^2*z[11]*z[12] + 8*f0*f7*z[2]^2*z[11]*z[13] + (-8*f0*f8 -
4*f1*f7)*z[2]^2*z[11]*z[14] + (-8*f0*f8 - 4*f1*f7 - 8*f2*f6)*z[2]^2*z[12]^2 +
(-8*f0*f8 - 4*f1*f7)*z[2]^2*z[12]*z[13] + (8*f1*f8 + 8*f2*f7)*z[2]^2*z[12]*z[14] -
8*f0*f8*z[2]^2*z[13]^2 + 8*f1*f8*z[2]^2*z[13]*z[14] - 8*f2*f8*z[2]^2*z[14]^2 +
2*z[2]^2*z[16]^2 + (-32*f0*f1*f8^2 - 64*f0*f3*f6*f8 +
16*f0*f3*f7^2)*z[2]*z[3]*z[9]^2 + 32*f0*f3*f8*z[2]*z[3]*z[9]*z[10] -
8*f0*f5*f7*z[2]*z[3]*z[9]*z[11] + 4*f1*f5*f7*z[2]*z[3]*z[9]*z[12] +
16*f0*f5*f8*z[2]*z[3]*z[9]*z[13] + (32*f0*f6*f8 - 8*f0*f7^2 -
8*f1*f5*f8)*z[2]*z[3]*z[9]*z[14] + (16*f1*f6*f8 - 4*f1*f7^2)*z[2]*z[3]*z[9]*z[15]
- 4*f1*f8*z[2]*z[3]*z[9]*z[16] + 16*f0*f6*z[2]*z[3]*z[10]*z[11] + (-8*f0*f7 -
8*f1*f6)*z[2]*z[3]*z[10]*z[12] - 8*f0*f7*z[2]*z[3]*z[10]*z[13] +
4*f1*f7*z[2]*z[3]*z[10]*z[14] - 4*f1*f8*z[2]*z[3]*z[10]*z[15] -
4*f1*f7*z[2]*z[3]*z[11]*z[12] + 4*f1*f8*z[2]*z[3]*z[11]*z[14] + (8*f1*f8 + 8*f2*f7
+ 8*f3*f6)*z[2]*z[3]*z[12]^2 + 4*f1*f8*z[2]*z[3]*z[12]*z[13] + (-16*f2*f8 -
8*f3*f7)*z[2]*z[3]*z[12]*z[14] - 4*f5*z[2]*z[3]*z[12]*z[16] +
8*f3*f8*z[2]*z[3]*z[14]^2 + (-64*f0*f2*f8^2 + 32*f1^2*f8^2 + 32*f1*f3*f6*f8 -
8*f1*f3*f7^2)*z[2]*z[4]*z[9]^2 - 16*f1*f3*f8*z[2]*z[4]*z[9]*z[10] +
4*f1*f5*f7*z[2]*z[4]*z[9]*z[11] - 8*f2*f5*f7*z[2]*z[4]*z[9]*z[12] + (32*f0*f6*f8 -
8*f0*f7^2 - 8*f1*f5*f8)*z[2]*z[4]*z[9]*z[13] + (-32*f1*f6*f8 + 8*f1*f7^2 +
16*f2*f5*f8)*z[2]*z[4]*z[9]*z[14] + (32*f0*f8^2 - 32*f2*f6*f8 +
8*f2*f7^2)*z[2]*z[4]*z[9]*z[15] + 8*f2*f8*z[2]*z[4]*z[9]*z[16] + (-8*f0*f7 -
8*f1*f6)*z[2]*z[4]*z[10]*z[11] + (8*f1*f7 + 16*f2*f6)*z[2]*z[4]*z[10]*z[12] +
4*f1*f7*z[2]*z[4]*z[10]*z[13] - 8*f2*f7*z[2]*z[4]*z[10]*z[14] +
8*f2*f8*z[2]*z[4]*z[10]*z[15] + (16*f0*f8 + 4*f1*f7)*z[2]*z[4]*z[11]^2 +
(-16*f1*f8 - 8*f2*f7 - 8*f3*f6)*z[2]*z[4]*z[11]*z[12] -
8*f1*f8*z[2]*z[4]*z[11]*z[13] + (8*f2*f8 + 4*f3*f7)*z[2]*z[4]*z[11]*z[14] +
4*f5*z[2]*z[4]*z[11]*z[16] + (8*f2*f8 + 4*f3*f7)*z[2]*z[4]*z[12]*z[13] +
4*f5*f7*z[2]*z[4]*z[12]*z[15] - 8*f6*z[2]*z[4]*z[12]*z[16] -
8*f3*f8*z[2]*z[4]*z[13]*z[14] - 8*f5*f8*z[2]*z[4]*z[14]*z[15] +
4*f7*z[2]*z[4]*z[14]*z[16] + (16*f6*f8 - 4*f7^2)*z[2]*z[4]*z[15]^2 -
8*f8*z[2]*z[4]*z[15]*z[16] - 16*f0*f5*f8*z[2]*z[5]*z[9]*z[11] + (-32*f0*f6*f8 +
16*f0*f7^2 + 8*f1*f5*f8)*z[2]*z[5]*z[9]*z[12] + (32*f0*f6*f8 -
8*f0*f7^2)*z[2]*z[5]*z[9]*z[13] + (-16*f0*f7*f8 - 16*f1*f6*f8 +
4*f1*f7^2)*z[2]*z[5]*z[9]*z[14] + 32*f0*f8^2*z[2]*z[5]*z[9]*z[15] -
8*f0*f7*z[2]*z[5]*z[10]*z[11] + 4*f1*f7*z[2]*z[5]*z[10]*z[12] +
16*f0*f8*z[2]*z[5]*z[11]^2 - 8*f1*f8*z[2]*z[5]*z[11]*z[12] -
4*f3*f7*z[2]*z[5]*z[12]^2 + 8*f3*f8*z[2]*z[5]*z[12]*z[14] +
4*f5*f7*z[2]*z[5]*z[12]*z[15] - 8*f5*f8*z[2]*z[5]*z[14]*z[15] + (16*f6*f8 -
4*f7^2)*z[2]*z[5]*z[15]^2 - 8*f8*z[2]*z[5]*z[15]*z[16] +
32*f0*f3*f8^2*z[2]*z[6]*z[9]^2 + (-32*f0*f6*f8 + 16*f0*f7^2 +
8*f1*f5*f8)*z[2]*z[6]*z[9]*z[11] + (32*f1*f6*f8 - 16*f1*f7^2 -
16*f2*f5*f8)*z[2]*z[6]*z[9]*z[12] + (-16*f0*f7*f8 - 16*f1*f6*f8 +
4*f1*f7^2)*z[2]*z[6]*z[9]*z[13] + (16*f1*f7*f8 + 32*f2*f6*f8 -
8*f2*f7^2)*z[2]*z[6]*z[9]*z[14] + (-32*f1*f8^2 - 16*f3*f6*f8 +
4*f3*f7^2)*z[2]*z[6]*z[9]*z[15] + 4*f3*f8*z[2]*z[6]*z[9]*z[16] +
4*f1*f7*z[2]*z[6]*z[10]*z[11] - 8*f2*f7*z[2]*z[6]*z[10]*z[12] +
4*f3*f8*z[2]*z[6]*z[10]*z[15] - 8*f1*f8*z[2]*z[6]*z[11]^2 + (16*f2*f8 +
4*f3*f7)*z[2]*z[6]*z[11]*z[12] - 4*f3*f8*z[2]*z[6]*z[11]*z[14] -
4*f5*f7*z[2]*z[6]*z[11]*z[15] - 8*f3*f8*z[2]*z[6]*z[12]^2 -
4*f3*f8*z[2]*z[6]*z[12]*z[13] + 8*f5*f8*z[2]*z[6]*z[12]*z[15] +
4*f7*z[2]*z[6]*z[12]*z[16] + 8*f5*f8*z[2]*z[6]*z[13]*z[15] + (-16*f6*f8 +
4*f7^2)*z[2]*z[6]*z[14]*z[15] + (-32*f0*f4*f8^2 + 8*f0*f5*f7*f8 -
8*f1*f3*f8^2)*z[2]*z[7]*z[9]^2 + (16*f0*f6*f8 - 8*f0*f7^2)*z[2]*z[7]*z[9]*z[10] +
(-16*f0*f7*f8 + 8*f1*f6*f8 - 4*f1*f7^2)*z[2]*z[7]*z[9]*z[11] + (-16*f0*f8^2 +
8*f1*f7*f8 - 16*f2*f6*f8 + 8*f2*f7^2 + 12*f3*f5*f8)*z[2]*z[7]*z[9]*z[12] +
(48*f0*f8^2 + 4*f1*f7*f8)*z[2]*z[7]*z[9]*z[13] + (-16*f1*f8^2 - 8*f2*f7*f8 -
16*f3*f6*f8 + 4*f3*f7^2)*z[2]*z[7]*z[9]*z[14] + (16*f2*f8^2 + 32*f4*f6*f8 -
8*f4*f7^2 - 8*f5^2*f8)*z[2]*z[7]*z[9]*z[15] + (-8*f4*f8 +
f5*f7)*z[2]*z[7]*z[9]*z[16] + 8*f0*f8*z[2]*z[7]*z[10]^2 -
4*f1*f8*z[2]*z[7]*z[10]*z[11] + 8*f2*f8*z[2]*z[7]*z[10]*z[12] +
4*f3*f8*z[2]*z[7]*z[10]*z[14] + (-8*f4*f8 + 3*f5*f7)*z[2]*z[7]*z[10]*z[15] -
8*f3*f8*z[2]*z[7]*z[11]*z[12] + f5*f7*z[2]*z[7]*z[11]*z[14] +
4*f5*f8*z[2]*z[7]*z[11]*z[15] + (16*f4*f8 - 4*f5*f7)*z[2]*z[7]*z[12]^2 -
f5*f7*z[2]*z[7]*z[12]*z[13] - 8*f5*f8*z[2]*z[7]*z[12]*z[14] + (-8*f6*f8 +
4*f7^2)*z[2]*z[7]*z[12]*z[15] - 12*f8*z[2]*z[7]*z[12]*z[16] + (-16*f6*f8 +
4*f7^2)*z[2]*z[7]*z[13]*z[15] + 4*f8*z[2]*z[7]*z[13]*z[16] + (16*f6*f8 -
4*f7^2)*z[2]*z[7]*z[14]^2 - 4*f7*f8*z[2]*z[7]*z[14]*z[15] +
8*f8^2*z[2]*z[7]*z[15]^2 + (-32*f0*f6*f8 + 8*f0*f7^2)*z[2]*z[8]*z[9]^2 +
16*f0*f8*z[2]*z[8]*z[9]*z[10] - 4*z[2]*z[8]*z[10]*z[16] + 8*f6*z[2]*z[8]*z[12]^2 -
8*f7*z[2]*z[8]*z[12]*z[14] + 8*f8*z[2]*z[8]*z[14]^2 + (32*f0*f2*f8^2 +
64*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 8*f0*f5^2*f8)*z[3]^2*z[9]^2 + (-32*f0*f4*f8 +
8*f0*f5*f7)*z[3]^2*z[9]*z[10] + 16*f0*f5*f8*z[3]^2*z[9]*z[11] -
8*f1*f5*f8*z[3]^2*z[9]*z[12] + (-64*f0*f6*f8 + 16*f0*f7^2)*z[3]^2*z[9]*z[13] +
(16*f1*f6*f8 - 4*f1*f7^2)*z[3]^2*z[9]*z[14] - 32*f0*f8^2*z[3]^2*z[9]*z[15] -
8*f0*f6*z[3]^2*z[10]^2 + (16*f0*f8 + 4*f1*f7)*z[3]^2*z[10]*z[12] +
16*f0*f8*z[3]^2*z[10]*z[13] - 8*f1*f8*z[3]^2*z[10]*z[14] - 16*f0*f8*z[3]^2*z[11]^2
+ 8*f1*f8*z[3]^2*z[11]*z[12] + (-8*f2*f8 - 4*f3*f7 - 8*f4*f6 +
2*f5^2)*z[3]^2*z[12]^2 + (8*f3*f8 + 8*f4*f7)*z[3]^2*z[12]*z[14] -
4*f5*f7*z[3]^2*z[12]*z[15] + 8*f6*z[3]^2*z[12]*z[16] - 8*f4*f8*z[3]^2*z[14]^2 +
8*f5*f8*z[3]^2*z[14]*z[15] - 4*f7*z[3]^2*z[14]*z[16] + (-16*f6*f8 +
4*f7^2)*z[3]^2*z[15]^2 + 8*f8*z[3]^2*z[15]*z[16] + (32*f0*f3*f8^2 - 32*f1*f2*f8^2
- 64*f1*f4*f6*f8 + 16*f1*f4*f7^2 + 8*f1*f5^2*f8)*z[3]*z[4]*z[9]^2 + (-16*f0*f5*f8
+ 32*f1*f4*f8 - 8*f1*f5*f7)*z[3]*z[4]*z[9]*z[10] - 8*f1*f5*f8*z[3]*z[4]*z[9]*z[11]
+ (16*f2*f5*f8 + 4*f3*f5*f7)*z[3]*z[4]*z[9]*z[12] + (48*f1*f6*f8 -
12*f1*f7^2)*z[3]*z[4]*z[9]*z[13] + (-32*f0*f8^2 - 32*f2*f6*f8 + 8*f2*f7^2 -
8*f3*f5*f8)*z[3]*z[4]*z[9]*z[14] + (32*f1*f8^2 + 32*f3*f6*f8 -
8*f3*f7^2)*z[3]*z[4]*z[9]*z[15] - 8*f3*f8*z[3]*z[4]*z[9]*z[16] + (8*f0*f7 +
8*f1*f6)*z[3]*z[4]*z[10]^2 - 4*f1*f7*z[3]*z[4]*z[10]*z[11] + (-16*f1*f8 - 8*f2*f7
- 8*f3*f6)*z[3]*z[4]*z[10]*z[12] - 8*f1*f8*z[3]*z[4]*z[10]*z[13] + (16*f2*f8 +
4*f3*f7)*z[3]*z[4]*z[10]*z[14] - 8*f3*f8*z[3]*z[4]*z[10]*z[15] +
8*f1*f8*z[3]*z[4]*z[11]^2 + (8*f3*f7 + 16*f4*f6 - 4*f5^2)*z[3]*z[4]*z[11]*z[12] +
(-8*f3*f8 - 8*f4*f7)*z[3]*z[4]*z[11]*z[14] + 4*f5*f7*z[3]*z[4]*z[11]*z[15] -
8*f6*z[3]*z[4]*z[11]*z[16] + 8*f3*f8*z[3]*z[4]*z[12]^2 + (-8*f3*f8 -
8*f4*f7)*z[3]*z[4]*z[12]*z[13] - 8*f5*f8*z[3]*z[4]*z[12]*z[15] +
4*f7*z[3]*z[4]*z[12]*z[16] + 16*f4*f8*z[3]*z[4]*z[13]*z[14] -
8*f5*f8*z[3]*z[4]*z[13]*z[15] + 4*f7*z[3]*z[4]*z[13]*z[16] + (16*f6*f8 -
4*f7^2)*z[3]*z[4]*z[14]*z[15] - 8*f8*z[3]*z[4]*z[14]*z[16] + (-32*f0*f3*f8^2 -
32*f0*f5*f6*f8 + 8*f0*f5*f7^2)*z[3]*z[5]*z[9]^2 + 16*f0*f5*f8*z[3]*z[5]*z[9]*z[10]
+ (32*f0*f6*f8 - 16*f0*f7^2)*z[3]*z[5]*z[9]*z[11] -
16*f0*f7*f8*z[3]*z[5]*z[9]*z[12] + 16*f0*f7*f8*z[3]*z[5]*z[9]*z[13] +
32*f0*f8^2*z[3]*z[5]*z[9]*z[14] + 8*f0*f7*z[3]*z[5]*z[10]^2 -
8*f1*f8*z[3]*z[5]*z[10]*z[12] + (8*f3*f8 + 8*f4*f7)*z[3]*z[5]*z[12]^2 + (-16*f4*f8
- 4*f5*f7)*z[3]*z[5]*z[12]*z[14] - 8*f7*z[3]*z[5]*z[12]*z[16] +
8*f5*f8*z[3]*z[5]*z[14]^2 + 8*f8*z[3]*z[5]*z[14]*z[16] + (-32*f0*f4*f8^2 +
8*f0*f5*f7*f8 + 8*f1*f3*f8^2 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[3]*z[6]*z[9]^2 +
(16*f0*f6*f8 - 8*f0*f7^2 - 8*f1*f5*f8)*z[3]*z[6]*z[9]*z[10] + (-8*f1*f6*f8 +
4*f1*f7^2)*z[3]*z[6]*z[9]*z[11] + (16*f0*f8^2 + 8*f1*f7*f8 - 16*f2*f6*f8 +
8*f2*f7^2 + 4*f3*f5*f8)*z[3]*z[6]*z[9]*z[12] + (16*f0*f8^2 -
4*f1*f7*f8)*z[3]*z[6]*z[9]*z[13] + (-16*f1*f8^2 - 8*f2*f7*f8)*z[3]*z[6]*z[9]*z[14]
+ 16*f2*f8^2*z[3]*z[6]*z[9]*z[15] - f5*f7*z[3]*z[6]*z[9]*z[16] + (-8*f0*f8 -
4*f1*f7)*z[3]*z[6]*z[10]^2 + 4*f1*f8*z[3]*z[6]*z[10]*z[11] + (8*f2*f8 +
4*f3*f7)*z[3]*z[6]*z[10]*z[12] - 4*f3*f8*z[3]*z[6]*z[10]*z[14] +
f5*f7*z[3]*z[6]*z[10]*z[15] + (-8*f3*f8 - 8*f4*f7)*z[3]*z[6]*z[11]*z[12] +
(8*f4*f8 + 3*f5*f7)*z[3]*z[6]*z[11]*z[14] - 4*f5*f8*z[3]*z[6]*z[11]*z[15] +
4*f7*z[3]*z[6]*z[11]*z[16] + (8*f4*f8 + f5*f7)*z[3]*z[6]*z[12]*z[13] + (8*f6*f8 -
4*f7^2)*z[3]*z[6]*z[12]*z[15] - 4*f8*z[3]*z[6]*z[12]*z[16] -
8*f5*f8*z[3]*z[6]*z[13]*z[14] - 4*f8*z[3]*z[6]*z[13]*z[16] +
4*f7*f8*z[3]*z[6]*z[14]*z[15] - 8*f8^2*z[3]*z[6]*z[15]^2 + (32*f1*f4*f8^2 -
8*f1*f5*f7*f8)*z[3]*z[7]*z[9]^2 + (-16*f1*f6*f8 + 8*f1*f7^2)*z[3]*z[7]*z[9]*z[10]
+ 8*f1*f7*f8*z[3]*z[7]*z[9]*z[11] + (-16*f2*f7*f8 + 16*f3*f6*f8 - 8*f3*f7^2 -
16*f4*f5*f8)*z[3]*z[7]*z[9]*z[12] - 32*f1*f8^2*z[3]*z[7]*z[9]*z[13] + (32*f2*f8^2
+ 8*f3*f7*f8 + 8*f5^2*f8)*z[3]*z[7]*z[9]*z[14] + (-32*f3*f8^2 - 16*f5*f6*f8 +
4*f5*f7^2)*z[3]*z[7]*z[9]*z[15] + 12*f5*f8*z[3]*z[7]*z[9]*z[16] -
4*f5*f7*z[3]*z[7]*z[10]*z[14] + 4*f5*f8*z[3]*z[7]*z[10]*z[15] +
4*f5*f7*z[3]*z[7]*z[11]*z[12] - 4*f5*f8*z[3]*z[7]*z[11]*z[14] + (16*f6*f8 -
8*f7^2)*z[3]*z[7]*z[11]*z[15] + 4*f5*f8*z[3]*z[7]*z[12]*z[13] + (-16*f6*f8 +
8*f7^2)*z[3]*z[7]*z[12]*z[14] + 8*f7*f8*z[3]*z[7]*z[12]*z[15] +
8*f7*f8*z[3]*z[7]*z[13]*z[15] - 8*f7*f8*z[3]*z[7]*z[14]^2 + (16*f1*f6*f8 -
4*f1*f7^2)*z[3]*z[8]*z[9]^2 - 8*f1*f8*z[3]*z[8]*z[9]*z[10] +
4*f5*z[3]*z[8]*z[10]*z[12] - 8*f6*z[3]*z[8]*z[11]*z[12] +
4*f7*z[3]*z[8]*z[11]*z[14] - 4*f7*z[3]*z[8]*z[12]^2 + 4*f7*z[3]*z[8]*z[12]*z[13] +
8*f8*z[3]*z[8]*z[12]*z[14] - 8*f8*z[3]*z[8]*z[13]*z[14] + (32*f0*f4*f8^2 -
32*f1*f3*f8^2 + 32*f2^2*f8^2 + 64*f2*f4*f6*f8 - 16*f2*f4*f7^2 - 8*f2*f5^2*f8 -
16*f3^2*f6*f8 + 4*f3^2*f7^2)*z[4]^2*z[9]^2 + (8*f1*f5*f8 - 32*f2*f4*f8 +
8*f2*f5*f7 + 8*f3^2*f8)*z[4]^2*z[9]*z[10] - 4*f3*f5*f7*z[4]^2*z[9]*z[11] -
8*f3*f5*f8*z[4]^2*z[9]*z[12] + (-32*f0*f8^2 - 32*f2*f6*f8 + 8*f2*f7^2 +
8*f3*f5*f8)*z[4]^2*z[9]*z[13] + (32*f1*f8^2 + 32*f3*f6*f8 -
8*f3*f7^2)*z[4]^2*z[9]*z[14] + (-32*f2*f8^2 - 64*f4*f6*f8 + 16*f4*f7^2 +
8*f5^2*f8)*z[4]^2*z[9]*z[15] + (16*f4*f8 - 4*f5*f7)*z[4]^2*z[9]*z[16] + (-8*f0*f8
- 4*f1*f7 - 8*f2*f6)*z[4]^2*z[10]^2 + (8*f1*f8 + 8*f2*f7 +
8*f3*f6)*z[4]^2*z[10]*z[11] - 4*f3*f7*z[4]^2*z[10]*z[13] -
8*f3*f8*z[4]^2*z[10]*z[14] + (16*f4*f8 - 4*f5*f7)*z[4]^2*z[10]*z[15] +
8*f6*z[4]^2*z[10]*z[16] + (-8*f2*f8 - 4*f3*f7 - 8*f4*f6 + 2*f5^2)*z[4]^2*z[11]^2 +
8*f3*f8*z[4]^2*z[11]*z[12] + (8*f3*f8 + 8*f4*f7)*z[4]^2*z[11]*z[13] -
4*f7*z[4]^2*z[11]*z[16] - 16*f4*f8*z[4]^2*z[12]^2 + 8*f5*f8*z[4]^2*z[12]*z[14] +
8*f8*z[4]^2*z[12]*z[16] - 8*f4*f8*z[4]^2*z[13]^2 + (16*f6*f8 -
4*f7^2)*z[4]^2*z[13]*z[15] + (-16*f6*f8 + 4*f7^2)*z[4]^2*z[14]^2 + (-32*f0*f4*f8^2
+ 8*f0*f5*f7*f8 + 24*f1*f3*f8^2 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[4]*z[5]*z[9]^2
+ (16*f0*f6*f8 - 8*f0*f7^2 - 8*f1*f5*f8)*z[4]*z[5]*z[9]*z[10] + (-24*f1*f6*f8 +
12*f1*f7^2)*z[4]*z[5]*z[9]*z[11] + (16*f0*f8^2 + 8*f1*f7*f8 + 16*f2*f6*f8 -
8*f2*f7^2 - 4*f3*f5*f8)*z[4]*z[5]*z[9]*z[12] + (16*f0*f8^2 -
12*f1*f7*f8)*z[4]*z[5]*z[9]*z[13] + (-16*f1*f8^2 +
8*f2*f7*f8)*z[4]*z[5]*z[9]*z[14] - 16*f2*f8^2*z[4]*z[5]*z[9]*z[15] +
f5*f7*z[4]*z[5]*z[9]*z[16] + (-8*f0*f8 - 4*f1*f7)*z[4]*z[5]*z[10]^2 +
4*f1*f8*z[4]*z[5]*z[10]*z[11] + (8*f2*f8 + 4*f3*f7)*z[4]*z[5]*z[10]*z[12] -
4*f3*f8*z[4]*z[5]*z[10]*z[14] - f5*f7*z[4]*z[5]*z[10]*z[15] + (-8*f3*f8 -
8*f4*f7)*z[4]*z[5]*z[11]*z[12] + (8*f4*f8 + f5*f7)*z[4]*z[5]*z[11]*z[14] +
4*f5*f8*z[4]*z[5]*z[11]*z[15] + 4*f7*z[4]*z[5]*z[11]*z[16] + (8*f4*f8 +
3*f5*f7)*z[4]*z[5]*z[12]*z[13] + (-8*f6*f8 + 4*f7^2)*z[4]*z[5]*z[12]*z[15] -
4*f8*z[4]*z[5]*z[12]*z[16] - 8*f5*f8*z[4]*z[5]*z[13]*z[14] -
4*f8*z[4]*z[5]*z[13]*z[16] - 4*f7*f8*z[4]*z[5]*z[14]*z[15] +
8*f8^2*z[4]*z[5]*z[15]^2 + (-32*f0*f5*f8^2 + 32*f1*f4*f8^2 - 8*f1*f5*f7*f8 -
32*f2*f3*f8^2 - 32*f2*f5*f6*f8 + 8*f2*f5*f7^2)*z[4]*z[6]*z[9]^2 + (16*f0*f7*f8 -
16*f1*f6*f8 + 8*f1*f7^2 + 16*f2*f5*f8)*z[4]*z[6]*z[9]*z[10] + (32*f0*f8^2 -
8*f1*f7*f8 + 32*f2*f6*f8 - 16*f2*f7^2)*z[4]*z[6]*z[9]*z[11] + (-32*f1*f8^2 -
16*f3*f6*f8 + 8*f3*f7^2)*z[4]*z[6]*z[9]*z[12] + 16*f2*f7*f8*z[4]*z[6]*z[9]*z[13] -
8*f3*f7*f8*z[4]*z[6]*z[9]*z[14] + (32*f3*f8^2 + 32*f5*f6*f8 -
8*f5*f7^2)*z[4]*z[6]*z[9]*z[15] - 8*f5*f8*z[4]*z[6]*z[9]*z[16] + (8*f1*f8 +
8*f2*f7)*z[4]*z[6]*z[10]^2 + (-16*f2*f8 - 8*f3*f7)*z[4]*z[6]*z[10]*z[11] +
8*f3*f8*z[4]*z[6]*z[10]*z[13] - 8*f5*f8*z[4]*z[6]*z[10]*z[15] -
8*f7*z[4]*z[6]*z[10]*z[16] + (8*f3*f8 + 8*f4*f7)*z[4]*z[6]*z[11]^2 + (-16*f4*f8 -
4*f5*f7)*z[4]*z[6]*z[11]*z[13] + (-16*f6*f8 + 8*f7^2)*z[4]*z[6]*z[11]*z[15] +
8*f8*z[4]*z[6]*z[11]*z[16] + 8*f5*f8*z[4]*z[6]*z[12]^2 + (16*f6*f8 -
8*f7^2)*z[4]*z[6]*z[12]*z[14] - 8*f7*f8*z[4]*z[6]*z[12]*z[15] +
8*f5*f8*z[4]*z[6]*z[13]^2 - 8*f7*f8*z[4]*z[6]*z[13]*z[15] +
8*f7*f8*z[4]*z[6]*z[14]^2 + (16*f1*f5*f8^2 - 64*f2*f4*f8^2 + 16*f2*f5*f7*f8 +
32*f3^2*f8^2 + 16*f3*f5*f6*f8 - 4*f3*f5*f7^2)*z[4]*z[7]*z[9]^2 + (-8*f1*f7*f8 +
32*f2*f6*f8 - 16*f2*f7^2 - 16*f3*f5*f8)*z[4]*z[7]*z[9]*z[10] + (-16*f1*f8^2 -
32*f3*f6*f8 + 16*f3*f7^2 + 16*f4*f5*f8)*z[4]*z[7]*z[9]*z[11] + (32*f2*f8^2 +
8*f3*f7*f8 + 32*f4*f6*f8 - 16*f4*f7^2)*z[4]*z[7]*z[9]*z[12] + (32*f2*f8^2 -
16*f3*f7*f8 - 8*f5^2*f8)*z[4]*z[7]*z[9]*z[13] + (-48*f3*f8^2 + 16*f4*f7*f8 -
16*f5*f6*f8 + 4*f5*f7^2)*z[4]*z[7]*z[9]*z[14] + (32*f4*f8^2 -
16*f5*f7*f8)*z[4]*z[7]*z[9]*z[15] + (-24*f6*f8 + 12*f7^2)*z[4]*z[7]*z[9]*z[16] +
4*f5*f7*z[4]*z[7]*z[10]*z[12] + 4*f5*f7*z[4]*z[7]*z[10]*z[13] +
8*f5*f8*z[4]*z[7]*z[10]*z[14] + (-8*f6*f8 + 4*f7^2)*z[4]*z[7]*z[10]*z[15] -
4*f5*f7*z[4]*z[7]*z[11]^2 - 8*f5*f8*z[4]*z[7]*z[11]*z[12] + (8*f6*f8 -
4*f7^2)*z[4]*z[7]*z[11]*z[14] + 8*f7*f8*z[4]*z[7]*z[11]*z[15] + (-8*f6*f8 +
4*f7^2)*z[4]*z[7]*z[12]*z[13] - 8*f7*f8*z[4]*z[7]*z[12]*z[14] -
16*f8^2*z[4]*z[7]*z[12]*z[15] - 16*f8^2*z[4]*z[7]*z[13]*z[15] +
16*f8^2*z[4]*z[7]*z[14]^2 + (-32*f2*f6*f8 + 8*f2*f7^2)*z[4]*z[8]*z[9]^2 +
16*f2*f8*z[4]*z[8]*z[9]*z[10] + 4*f5*f7*z[4]*z[8]*z[9]*z[12] -
8*f5*f8*z[4]*z[8]*z[9]*z[14] + (48*f6*f8 - 12*f7^2)*z[4]*z[8]*z[9]*z[15] -
12*f8*z[4]*z[8]*z[9]*z[16] - 4*f5*z[4]*z[8]*z[10]*z[11] -
8*f6*z[4]*z[8]*z[10]*z[12] + 4*f7*z[4]*z[8]*z[10]*z[14] -
12*f8*z[4]*z[8]*z[10]*z[15] + 8*f6*z[4]*z[8]*z[11]^2 + 4*f7*z[4]*z[8]*z[11]*z[12]
- 8*f7*z[4]*z[8]*z[11]*z[13] - 4*f8*z[4]*z[8]*z[11]*z[14] + 8*f8*z[4]*z[8]*z[12]^2
- 4*f8*z[4]*z[8]*z[12]*z[13] + 8*f8*z[4]*z[8]*z[13]^2 + (32*f0*f4*f8^2 -
16*f0*f5*f7*f8 + 32*f0*f6^2*f8 - 8*f0*f6*f7^2)*z[5]^2*z[9]^2 + (-32*f0*f6*f8 +
8*f0*f7^2)*z[5]^2*z[9]*z[10] + 16*f0*f7*f8*z[5]^2*z[9]*z[11] -
32*f0*f8^2*z[5]^2*z[9]*z[13] - 8*f0*f8*z[5]^2*z[10]^2 - 8*f4*f8*z[5]^2*z[12]^2 +
8*f5*f8*z[5]^2*z[12]*z[14] + 8*f8*z[5]^2*z[12]*z[16] + (-8*f6*f8 +
2*f7^2)*z[5]^2*z[14]^2 + (32*f0*f5*f8^2 - 32*f0*f6*f7*f8 + 8*f0*f7^3 -
32*f1*f4*f8^2 + 16*f1*f5*f7*f8 - 32*f1*f6^2*f8 + 8*f1*f6*f7^2)*z[5]*z[6]*z[9]^2 +
(16*f0*f7*f8 + 32*f1*f6*f8 - 8*f1*f7^2)*z[5]*z[6]*z[9]*z[10] + (-32*f0*f8^2 -
16*f1*f7*f8)*z[5]*z[6]*z[9]*z[11] + 32*f1*f8^2*z[5]*z[6]*z[9]*z[13] +
8*f1*f8*z[5]*z[6]*z[10]^2 - 8*f3*f8*z[5]*z[6]*z[10]*z[12] +
16*f4*f8*z[5]*z[6]*z[11]*z[12] - 8*f5*f8*z[5]*z[6]*z[11]*z[14] -
8*f8*z[5]*z[6]*z[11]*z[16] - 8*f5*f8*z[5]*z[6]*z[12]*z[13] + (16*f6*f8 -
4*f7^2)*z[5]*z[6]*z[13]*z[14] + (-16*f1*f5*f8^2 + 16*f1*f6*f7*f8 -
4*f1*f7^3)*z[5]*z[7]*z[9]^2 - 8*f1*f7*f8*z[5]*z[7]*z[9]*z[10] +
16*f1*f8^2*z[5]*z[7]*z[9]*z[11] + (8*f3*f7*f8 + 8*f5^2*f8)*z[5]*z[7]*z[9]*z[12] +
(-16*f3*f8^2 - 16*f5*f6*f8 + 4*f5*f7^2)*z[5]*z[7]*z[9]*z[14] + (32*f4*f8^2 -
16*f5*f7*f8 + 32*f6^2*f8 - 8*f6*f7^2)*z[5]*z[7]*z[9]*z[15] + (-16*f6*f8 +
4*f7^2)*z[5]*z[7]*z[9]*z[16] + 8*f5*f8*z[5]*z[7]*z[10]*z[14] + (-16*f6*f8 +
4*f7^2)*z[5]*z[7]*z[10]*z[15] - 8*f5*f8*z[5]*z[7]*z[11]*z[12] +
8*f7*f8*z[5]*z[7]*z[11]*z[15] + (16*f6*f8 - 4*f7^2)*z[5]*z[7]*z[12]^2 -
8*f7*f8*z[5]*z[7]*z[12]*z[14] - 16*f8^2*z[5]*z[7]*z[12]*z[15] -
16*f8^2*z[5]*z[7]*z[13]*z[15] + 16*f8^2*z[5]*z[7]*z[14]^2 -
4*f5*f7*z[5]*z[8]*z[9]*z[12] + 8*f5*f8*z[5]*z[8]*z[9]*z[14] + (-16*f6*f8 +
4*f7^2)*z[5]*z[8]*z[9]*z[15] + 4*f8*z[5]*z[8]*z[9]*z[16] +
4*f8*z[5]*z[8]*z[10]*z[15] + 4*f7*z[5]*z[8]*z[11]*z[12] -
4*f8*z[5]*z[8]*z[11]*z[14] - 4*f8*z[5]*z[8]*z[12]*z[13] + (32*f0*f6*f8^2 -
8*f0*f7^2*f8 - 16*f1*f5*f8^2 + 16*f1*f6*f7*f8 - 4*f1*f7^3 + 32*f2*f4*f8^2 -
16*f2*f5*f7*f8 + 32*f2*f6^2*f8 - 8*f2*f6*f7^2)*z[6]^2*z[9]^2 + (-32*f0*f8^2 -
8*f1*f7*f8 - 32*f2*f6*f8 + 8*f2*f7^2)*z[6]^2*z[9]*z[10] + (16*f1*f8^2 +
16*f2*f7*f8)*z[6]^2*z[9]*z[11] - 8*f3*f7*f8*z[6]^2*z[9]*z[12] -
32*f2*f8^2*z[6]^2*z[9]*z[13] + 16*f3*f8^2*z[6]^2*z[9]*z[14] + (-32*f4*f8^2 +
16*f5*f7*f8 - 32*f6^2*f8 + 8*f6*f7^2)*z[6]^2*z[9]*z[15] + (16*f6*f8 -
4*f7^2)*z[6]^2*z[9]*z[16] - 8*f2*f8*z[6]^2*z[10]^2 + 8*f3*f8*z[6]^2*z[10]*z[11] +
(16*f6*f8 - 4*f7^2)*z[6]^2*z[10]*z[15] + 8*f8*z[6]^2*z[10]*z[16] -
8*f4*f8*z[6]^2*z[11]^2 + 8*f5*f8*z[6]^2*z[11]*z[13] - 8*f7*f8*z[6]^2*z[11]*z[15] +
(-16*f6*f8 + 4*f7^2)*z[6]^2*z[12]^2 + 8*f7*f8*z[6]^2*z[12]*z[14] +
16*f8^2*z[6]^2*z[12]*z[15] + (-8*f6*f8 + 2*f7^2)*z[6]^2*z[13]^2 +
16*f8^2*z[6]^2*z[13]*z[15] - 16*f8^2*z[6]^2*z[14]^2 + (-32*f1*f6*f8^2 +
8*f1*f7^2*f8 + 32*f2*f5*f8^2 - 32*f2*f6*f7*f8 + 8*f2*f7^3 - 32*f3*f4*f8^2 +
16*f3*f5*f7*f8 - 32*f3*f6^2*f8 + 8*f3*f6*f7^2)*z[6]*z[7]*z[9]^2 + (32*f1*f8^2 +
16*f2*f7*f8 + 32*f3*f6*f8 - 8*f3*f7^2)*z[6]*z[7]*z[9]*z[10] + (-32*f2*f8^2 -
16*f3*f7*f8 - 8*f5^2*f8)*z[6]*z[7]*z[9]*z[11] + (16*f4*f7*f8 - 16*f5*f6*f8 +
4*f5*f7^2)*z[6]*z[7]*z[9]*z[12] + (32*f3*f8^2 + 16*f5*f6*f8 -
4*f5*f7^2)*z[6]*z[7]*z[9]*z[13] + (-16*f5*f7*f8 + 32*f6^2*f8 -
8*f6*f7^2)*z[6]*z[7]*z[9]*z[14] + (16*f6*f7*f8 - 4*f7^3)*z[6]*z[7]*z[9]*z[15] -
12*f7*f8*z[6]*z[7]*z[9]*z[16] - 8*f5*f8*z[6]*z[7]*z[10]*z[12] -
8*f5*f8*z[6]*z[7]*z[10]*z[13] + (-16*f6*f8 + 4*f7^2)*z[6]*z[7]*z[10]*z[14] -
4*f7*f8*z[6]*z[7]*z[10]*z[15] + 8*f5*f8*z[6]*z[7]*z[11]^2 + (16*f6*f8 -
4*f7^2)*z[6]*z[7]*z[11]*z[12] + 4*f7*f8*z[6]*z[7]*z[11]*z[14] -
4*f7*f8*z[6]*z[7]*z[12]*z[13] + (16*f3*f6*f8 - 4*f3*f7^2)*z[6]*z[8]*z[9]^2 -
8*f3*f8*z[6]*z[8]*z[9]*z[10] + 4*f5*f7*z[6]*z[8]*z[9]*z[11] +
8*f5*f8*z[6]*z[8]*z[9]*z[12] - 8*f5*f8*z[6]*z[8]*z[9]*z[13] + (-16*f6*f8 +
4*f7^2)*z[6]*z[8]*z[9]*z[14] + 4*f7*z[6]*z[8]*z[10]*z[12] - 4*f7*z[6]*z[8]*z[11]^2
- 8*f8*z[6]*z[8]*z[11]*z[12] + 8*f8*z[6]*z[8]*z[11]*z[13] + (32*f2*f6*f8^2 -
8*f2*f7^2*f8 - 32*f3*f5*f8^2 + 16*f3*f6*f7*f8 - 4*f3*f7^3 + 32*f4^2*f8^2 -
16*f4*f5*f7*f8 + 32*f4*f6^2*f8 - 8*f4*f6*f7^2 - 8*f5^2*f6*f8 +
2*f5^2*f7^2)*z[7]^2*z[9]^2 + (-32*f2*f8^2 - 32*f4*f6*f8 + 8*f4*f7^2 +
8*f5^2*f8)*z[7]^2*z[9]*z[10] + (32*f3*f8^2 + 16*f5*f6*f8 -
4*f5*f7^2)*z[7]^2*z[9]*z[11] - 32*f4*f8^2*z[7]^2*z[9]*z[12] + (-32*f4*f8^2 +
16*f5*f7*f8 - 32*f6^2*f8 + 8*f6*f7^2)*z[7]^2*z[9]*z[13] + (32*f5*f8^2 -
16*f6*f7*f8 + 4*f7^3)*z[7]^2*z[9]*z[14] + (-32*f6*f8^2 +
8*f7^2*f8)*z[7]^2*z[9]*z[15] + 24*f8^2*z[7]^2*z[9]*z[16] + (16*f6*f8 -
4*f7^2)*z[7]^2*z[10]*z[12] + (16*f6*f8 - 4*f7^2)*z[7]^2*z[10]*z[13] +
8*f8^2*z[7]^2*z[10]*z[15] + (-16*f6*f8 + 4*f7^2)*z[7]^2*z[11]^2 -
8*f8^2*z[7]^2*z[11]*z[14] + 8*f8^2*z[7]^2*z[12]*z[13] + (-32*f4*f6*f8 + 8*f4*f7^2
+ 8*f5^2*f8)*z[7]*z[8]*z[9]^2 + (16*f4*f8 - 4*f5*f7)*z[7]*z[8]*z[9]*z[10] -
16*f5*f8*z[7]*z[8]*z[9]*z[11] + (32*f6*f8 - 8*f7^2)*z[7]*z[8]*z[9]*z[13] -
8*f8*z[7]*z[8]*z[10]*z[12] - 8*f8*z[7]*z[8]*z[10]*z[13] + 8*f8*z[7]*z[8]*z[11]^2 +
2*z[8]^2*z[10]^2,

// Bmat[3,1]
  (8*f0*f2*f7 - 2*f1^2*f7)*z[1]^2*z[10]^2 + (-16*f0*f2*f8 - 8*f0*f3*f7 +
4*f1^2*f8)*z[1]^2*z[10]*z[11] + (8*f0*f3*f8 + 4*f1*f3*f7)*z[1]^2*z[10]*z[12] +
8*f0*f3*f8*z[1]^2*z[10]*z[13] - 4*f1*f3*f8*z[1]^2*z[10]*z[14] -
4*f0*f7*z[1]^2*z[10]*z[16] + (8*f0*f3*f8 + 8*f0*f4*f7)*z[1]^2*z[11]^2 +
(-16*f0*f4*f8 - 4*f1*f3*f8 - 8*f1*f4*f7)*z[1]^2*z[11]*z[12] + (-16*f0*f4*f8 -
4*f0*f5*f7)*z[1]^2*z[11]*z[13] + (8*f0*f5*f8 + 8*f1*f4*f8 +
2*f1*f5*f7)*z[1]^2*z[11]*z[14] - 4*f1*f5*f8*z[1]^2*z[11]*z[15] + (8*f0*f8 +
2*f1*f7)*z[1]^2*z[11]*z[16] + (8*f1*f4*f8 + 8*f2*f4*f7 - 2*f3^2*f7)*z[1]^2*z[12]^2
+ (8*f0*f5*f8 + 8*f1*f4*f8 + 2*f1*f5*f7)*z[1]^2*z[12]*z[13] + (-8*f1*f5*f8 -
16*f2*f4*f8 - 4*f2*f5*f7 + 4*f3^2*f8)*z[1]^2*z[12]*z[14] + (8*f2*f5*f8 +
2*f3*f5*f7)*z[1]^2*z[12]*z[15] + (-4*f1*f8 - 4*f2*f7)*z[1]^2*z[12]*z[16] +
8*f0*f5*f8*z[1]^2*z[13]^2 + (-16*f0*f6*f8 + 4*f0*f7^2 -
8*f1*f5*f8)*z[1]^2*z[13]*z[14] + (8*f1*f6*f8 - 2*f1*f7^2)*z[1]^2*z[13]*z[15] -
4*f1*f8*z[1]^2*z[13]*z[16] + (8*f1*f6*f8 - 2*f1*f7^2 + 8*f2*f5*f8)*z[1]^2*z[14]^2
+ (-16*f2*f6*f8 + 4*f2*f7^2 - 4*f3*f5*f8)*z[1]^2*z[14]*z[15] +
8*f2*f8*z[1]^2*z[14]*z[16] + (8*f3*f6*f8 - 2*f3*f7^2)*z[1]^2*z[15]^2 -
4*f3*f8*z[1]^2*z[15]*z[16] + (-16*f0*f2*f7 + 4*f1^2*f7)*z[1]*z[2]*z[9]*z[10] +
(16*f0*f2*f8 + 8*f0*f3*f7 - 4*f1^2*f8)*z[1]*z[2]*z[9]*z[11] + (-8*f0*f3*f8 -
4*f1*f3*f7)*z[1]*z[2]*z[9]*z[12] - 8*f0*f3*f8*z[1]*z[2]*z[9]*z[13] +
4*f1*f3*f8*z[1]*z[2]*z[9]*z[14] + 4*f0*f7*z[1]*z[2]*z[9]*z[16] +
4*f0*f7*z[1]*z[2]*z[10]*z[15] - 4*f0*f5*z[1]*z[2]*z[11]^2 +
4*f1*f5*z[1]*z[2]*z[11]*z[12] + 8*f0*f6*z[1]*z[2]*z[11]*z[13] + (-4*f0*f7 -
4*f1*f6)*z[1]*z[2]*z[11]*z[14] - 8*f0*f8*z[1]*z[2]*z[11]*z[15] -
4*f2*f5*z[1]*z[2]*z[12]^2 + (-4*f0*f7 - 4*f1*f6)*z[1]*z[2]*z[12]*z[13] + (4*f1*f7
+ 8*f2*f6)*z[1]*z[2]*z[12]*z[14] + (4*f1*f8 - 4*f3*f6)*z[1]*z[2]*z[12]*z[15] +
2*f3*z[1]*z[2]*z[12]*z[16] - 4*f0*f7*z[1]*z[2]*z[13]^2 + (16*f0*f8 +
4*f1*f7)*z[1]*z[2]*z[13]*z[14] - 4*f1*f8*z[1]*z[2]*z[13]*z[15] + (-8*f1*f8 -
4*f2*f7)*z[1]*z[2]*z[14]^2 + (8*f2*f8 + 2*f3*f7)*z[1]*z[2]*z[14]*z[15] -
4*f3*f8*z[1]*z[2]*z[15]^2 + (16*f0*f2*f8 + 8*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[3]*z[9]*z[10] + (-16*f0*f3*f8 -
16*f0*f4*f7)*z[1]*z[3]*z[9]*z[11] + (16*f0*f4*f8 + 4*f1*f3*f8 +
8*f1*f4*f7)*z[1]*z[3]*z[9]*z[12] + (16*f0*f4*f8 + 4*f0*f5*f7)*z[1]*z[3]*z[9]*z[13]
+ (-8*f0*f5*f8 - 8*f1*f4*f8 - 2*f1*f5*f7)*z[1]*z[3]*z[9]*z[14] +
4*f1*f5*f8*z[1]*z[3]*z[9]*z[15] + (-8*f0*f8 - 2*f1*f7)*z[1]*z[3]*z[9]*z[16] +
4*f0*f5*z[1]*z[3]*z[10]*z[11] - 2*f1*f5*z[1]*z[3]*z[10]*z[12] -
8*f0*f6*z[1]*z[3]*z[10]*z[13] + 4*f1*f6*z[1]*z[3]*z[10]*z[14] -
2*f1*f7*z[1]*z[3]*z[10]*z[15] + 8*f0*f7*z[1]*z[3]*z[11]*z[13] -
2*f1*f7*z[1]*z[3]*z[11]*z[14] + 4*f1*f8*z[1]*z[3]*z[11]*z[15] +
2*f3*f5*z[1]*z[3]*z[12]^2 + (-8*f0*f8 - 2*f1*f7)*z[1]*z[3]*z[12]*z[13] + (4*f1*f8
- 4*f3*f6)*z[1]*z[3]*z[12]*z[14] + (-8*f2*f8 + 8*f4*f6 -
2*f5^2)*z[1]*z[3]*z[12]*z[15] - 4*f4*z[1]*z[3]*z[12]*z[16] -
8*f0*f8*z[1]*z[3]*z[13]^2 + 4*f1*f8*z[1]*z[3]*z[13]*z[14] +
2*f3*f7*z[1]*z[3]*z[14]^2 - 4*f4*f7*z[1]*z[3]*z[14]*z[15] +
2*f5*z[1]*z[3]*z[14]*z[16] + 2*f5*f7*z[1]*z[3]*z[15]^2 -
4*f6*z[1]*z[3]*z[15]*z[16] + 2*z[1]*z[3]*z[16]^2 + (-8*f0*f3*f8 -
4*f1*f3*f7)*z[1]*z[4]*z[9]*z[10] + (16*f0*f4*f8 + 4*f1*f3*f8 +
8*f1*f4*f7)*z[1]*z[4]*z[9]*z[11] + (-16*f1*f4*f8 - 16*f2*f4*f7 +
4*f3^2*f7)*z[1]*z[4]*z[9]*z[12] + (-8*f0*f5*f8 - 8*f1*f4*f8 -
2*f1*f5*f7)*z[1]*z[4]*z[9]*z[13] + (8*f1*f5*f8 + 16*f2*f4*f8 + 4*f2*f5*f7 -
4*f3^2*f8)*z[1]*z[4]*z[9]*z[14] + (-8*f2*f5*f8 - 2*f3*f5*f7)*z[1]*z[4]*z[9]*z[15]
+ (4*f1*f8 + 4*f2*f7)*z[1]*z[4]*z[9]*z[16] - 2*f1*f5*z[1]*z[4]*z[10]*z[11] +
4*f2*f5*z[1]*z[4]*z[10]*z[12] + 4*f1*f6*z[1]*z[4]*z[10]*z[13] + (8*f0*f8 -
8*f2*f6)*z[1]*z[4]*z[10]*z[14] + (-4*f1*f8 + 4*f2*f7 +
4*f3*f6)*z[1]*z[4]*z[10]*z[15] - 2*f3*z[1]*z[4]*z[10]*z[16] -
2*f3*f5*z[1]*z[4]*z[11]*z[12] - 4*f1*f7*z[1]*z[4]*z[11]*z[13] + (-4*f1*f8 +
4*f2*f7 + 4*f3*f6)*z[1]*z[4]*z[11]*z[14] + (-4*f3*f7 - 8*f4*f6 +
2*f5^2)*z[1]*z[4]*z[11]*z[15] + 4*f4*z[1]*z[4]*z[11]*z[16] + (4*f1*f8 +
4*f2*f7)*z[1]*z[4]*z[12]*z[13] - 4*f3*f7*z[1]*z[4]*z[12]*z[14] + (4*f3*f8 +
8*f4*f7)*z[1]*z[4]*z[12]*z[15] - 2*f5*z[1]*z[4]*z[12]*z[16] +
4*f1*f8*z[1]*z[4]*z[13]^2 + (-8*f2*f8 - 2*f3*f7)*z[1]*z[4]*z[13]*z[14] + (4*f3*f8
+ 4*f4*f7)*z[1]*z[4]*z[13]*z[15] - 2*f5*z[1]*z[4]*z[13]*z[16] +
4*f3*f8*z[1]*z[4]*z[14]^2 + (-8*f4*f8 - 2*f5*f7)*z[1]*z[4]*z[14]*z[15] +
4*f6*z[1]*z[4]*z[14]*z[16] + 4*f5*f8*z[1]*z[4]*z[15]^2 -
4*f7*z[1]*z[4]*z[15]*z[16] - 8*f0*f3*f8*z[1]*z[5]*z[9]*z[10] + (16*f0*f4*f8 +
4*f0*f5*f7)*z[1]*z[5]*z[9]*z[11] + (-8*f0*f5*f8 - 8*f1*f4*f8 -
2*f1*f5*f7)*z[1]*z[5]*z[9]*z[12] - 16*f0*f5*f8*z[1]*z[5]*z[9]*z[13] + (16*f0*f6*f8
- 4*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[5]*z[9]*z[14] + (-8*f1*f6*f8 +
2*f1*f7^2)*z[1]*z[5]*z[9]*z[15] + 4*f1*f8*z[1]*z[5]*z[9]*z[16] +
4*f0*f7*z[1]*z[5]*z[10]*z[12] + 4*f0*f7*z[1]*z[5]*z[10]*z[13] + (-8*f0*f8 -
2*f1*f7)*z[1]*z[5]*z[10]*z[14] + 4*f1*f8*z[1]*z[5]*z[10]*z[15] -
8*f0*f7*z[1]*z[5]*z[11]^2 + (8*f0*f8 + 6*f1*f7)*z[1]*z[5]*z[11]*z[12] +
8*f0*f8*z[1]*z[5]*z[11]*z[13] - 4*f1*f8*z[1]*z[5]*z[11]*z[14] + (-4*f1*f8 -
4*f2*f7)*z[1]*z[5]*z[12]^2 - 4*f1*f8*z[1]*z[5]*z[12]*z[13] + (8*f2*f8 +
2*f3*f7)*z[1]*z[5]*z[12]*z[14] - 4*f4*f7*z[1]*z[5]*z[12]*z[15] -
4*f3*f8*z[1]*z[5]*z[14]^2 + 8*f4*f8*z[1]*z[5]*z[14]*z[15] -
4*f5*f8*z[1]*z[5]*z[15]^2 + 2*f7*z[1]*z[5]*z[15]*z[16] +
4*f1*f3*f8*z[1]*z[6]*z[9]*z[10] + (-8*f0*f5*f8 - 8*f1*f4*f8 -
2*f1*f5*f7)*z[1]*z[6]*z[9]*z[11] + (8*f1*f5*f8 + 16*f2*f4*f8 + 4*f2*f5*f7 -
4*f3^2*f8)*z[1]*z[6]*z[9]*z[12] + (16*f0*f6*f8 - 4*f0*f7^2 +
8*f1*f5*f8)*z[1]*z[6]*z[9]*z[13] + (-16*f1*f6*f8 + 4*f1*f7^2 -
16*f2*f5*f8)*z[1]*z[6]*z[9]*z[14] + (16*f2*f6*f8 - 4*f2*f7^2 +
4*f3*f5*f8)*z[1]*z[6]*z[9]*z[15] - 8*f2*f8*z[1]*z[6]*z[9]*z[16] +
4*f0*f7*z[1]*z[6]*z[10]*z[11] + (-8*f0*f8 - 4*f1*f7)*z[1]*z[6]*z[10]*z[12] +
(-8*f0*f8 - 2*f1*f7)*z[1]*z[6]*z[10]*z[13] + (8*f1*f8 +
4*f2*f7)*z[1]*z[6]*z[10]*z[14] + (-8*f2*f8 - 2*f3*f7)*z[1]*z[6]*z[10]*z[15] +
2*f1*f7*z[1]*z[6]*z[11]^2 - 4*f2*f7*z[1]*z[6]*z[11]*z[12] -
2*f3*f7*z[1]*z[6]*z[11]*z[14] + (4*f3*f8 + 4*f4*f7)*z[1]*z[6]*z[11]*z[15] +
4*f3*f7*z[1]*z[6]*z[12]^2 - 4*f3*f8*z[1]*z[6]*z[12]*z[14] + (-8*f4*f8 -
2*f5*f7)*z[1]*z[6]*z[12]*z[15] + 4*f3*f8*z[1]*z[6]*z[13]*z[14] -
8*f4*f8*z[1]*z[6]*z[13]*z[15] + 8*f5*f8*z[1]*z[6]*z[14]*z[15] -
2*f7*z[1]*z[6]*z[14]*z[16] + (-8*f6*f8 + 2*f7^2)*z[1]*z[6]*z[15]^2 +
8*f8*z[1]*z[6]*z[15]*z[16] + 4*f1*f5*f8*z[1]*z[7]*z[9]*z[11] + (-8*f2*f5*f8 -
2*f3*f5*f7)*z[1]*z[7]*z[9]*z[12] + (-8*f1*f6*f8 + 2*f1*f7^2)*z[1]*z[7]*z[9]*z[13]
+ (16*f2*f6*f8 - 4*f2*f7^2 + 4*f3*f5*f8)*z[1]*z[7]*z[9]*z[14] + (-16*f3*f6*f8 +
4*f3*f7^2)*z[1]*z[7]*z[9]*z[15] + 4*f3*f8*z[1]*z[7]*z[9]*z[16] -
4*f0*f7*z[1]*z[7]*z[10]^2 + (8*f0*f8 + 2*f1*f7)*z[1]*z[7]*z[10]*z[11] -
4*f2*f7*z[1]*z[7]*z[10]*z[12] + 4*f3*f8*z[1]*z[7]*z[10]*z[15] -
4*f1*f8*z[1]*z[7]*z[11]^2 + (8*f2*f8 + 4*f3*f7)*z[1]*z[7]*z[11]*z[12] -
4*f3*f8*z[1]*z[7]*z[11]*z[14] - 2*f5*f7*z[1]*z[7]*z[11]*z[15] + (-4*f3*f8 -
8*f4*f7)*z[1]*z[7]*z[12]^2 - 4*f3*f8*z[1]*z[7]*z[12]*z[13] + (16*f4*f8 +
4*f5*f7)*z[1]*z[7]*z[12]*z[14] - 4*f5*f8*z[1]*z[7]*z[12]*z[15] +
6*f7*z[1]*z[7]*z[12]*z[16] + 4*f5*f8*z[1]*z[7]*z[13]*z[15] -
8*f5*f8*z[1]*z[7]*z[14]^2 + (8*f6*f8 - 2*f7^2)*z[1]*z[7]*z[14]*z[15] -
8*f8*z[1]*z[7]*z[14]*z[16] + 4*f0*f7*z[1]*z[8]*z[9]*z[10] + (-8*f0*f8 -
2*f1*f7)*z[1]*z[8]*z[9]*z[11] + (4*f1*f8 + 4*f2*f7)*z[1]*z[8]*z[9]*z[12] +
4*f1*f8*z[1]*z[8]*z[9]*z[13] - 8*f2*f8*z[1]*z[8]*z[9]*z[14] +
4*f3*f8*z[1]*z[8]*z[9]*z[15] + f5*z[1]*z[8]*z[9]*z[16] - f5*z[1]*z[8]*z[10]*z[15]
- f5*z[1]*z[8]*z[11]*z[14] + 4*f6*z[1]*z[8]*z[11]*z[15] - 2*z[1]*z[8]*z[11]*z[16]
+ 2*f5*z[1]*z[8]*z[12]^2 + f5*z[1]*z[8]*z[12]*z[13] - 4*f6*z[1]*z[8]*z[12]*z[14] -
2*f7*z[1]*z[8]*z[12]*z[15] - 2*f7*z[1]*z[8]*z[13]*z[15] + 2*f7*z[1]*z[8]*z[14]^2 +
(8*f0*f2*f7 - 2*f1^2*f7)*z[2]^2*z[9]^2 - 4*f0*f7*z[2]^2*z[9]*z[15] +
4*f0*z[2]^2*z[11]*z[12] - 4*f0*z[2]^2*z[11]*z[13] + 2*f1*z[2]^2*z[11]*z[14] -
2*f1*z[2]^2*z[12]^2 + 2*f1*z[2]^2*z[12]*z[13] - 4*f2*z[2]^2*z[12]*z[14] +
2*f3*z[2]^2*z[12]*z[15] + (-16*f0*f2*f8 - 8*f0*f3*f7 + 4*f1^2*f8)*z[2]*z[3]*z[9]^2
+ 4*f0*f5*z[2]*z[3]*z[9]*z[11] - 2*f1*f5*z[2]*z[3]*z[9]*z[12] +
4*f0*f7*z[2]*z[3]*z[9]*z[14] + (8*f0*f8 + 2*f1*f7)*z[2]*z[3]*z[9]*z[15] -
4*f0*z[2]*z[3]*z[10]*z[12] + 4*f0*z[2]*z[3]*z[10]*z[13] -
2*f1*z[2]*z[3]*z[10]*z[14] - 2*f1*z[2]*z[3]*z[11]*z[12] + 4*f2*z[2]*z[3]*z[12]^2 +
2*f3*z[2]*z[3]*z[12]*z[14] - 4*f4*z[2]*z[3]*z[12]*z[15] + 2*z[2]*z[3]*z[15]*z[16]
+ (8*f0*f3*f8 + 4*f1*f3*f7)*z[2]*z[4]*z[9]^2 - 2*f1*f5*z[2]*z[4]*z[9]*z[11] +
4*f2*f5*z[2]*z[4]*z[9]*z[12] + 4*f0*f7*z[2]*z[4]*z[9]*z[13] + (-8*f0*f8 -
4*f1*f7)*z[2]*z[4]*z[9]*z[14] - 4*f2*f7*z[2]*z[4]*z[9]*z[15] -
4*f0*z[2]*z[4]*z[10]*z[11] + 4*f1*z[2]*z[4]*z[10]*z[12] -
2*f1*z[2]*z[4]*z[10]*z[13] + 4*f2*z[2]*z[4]*z[10]*z[14] -
2*f3*z[2]*z[4]*z[10]*z[15] + 2*f1*z[2]*z[4]*z[11]^2 - 4*f2*z[2]*z[4]*z[11]*z[12] -
2*f3*z[2]*z[4]*z[11]*z[14] + 4*f4*z[2]*z[4]*z[11]*z[15] -
2*f5*z[2]*z[4]*z[12]*z[15] - 2*z[2]*z[4]*z[14]*z[16] + 2*f7*z[2]*z[4]*z[15]^2 +
8*f0*f3*f8*z[2]*z[5]*z[9]^2 - 8*f0*f6*z[2]*z[5]*z[9]*z[11] +
4*f1*f6*z[2]*z[5]*z[9]*z[12] + 4*f0*f7*z[2]*z[5]*z[9]*z[13] + (-8*f0*f8 -
2*f1*f7)*z[2]*z[5]*z[9]*z[14] + 4*f0*z[2]*z[5]*z[10]*z[11] -
2*f1*z[2]*z[5]*z[10]*z[12] + 2*f5*z[2]*z[5]*z[12]*z[15] - 2*z[2]*z[5]*z[14]*z[16]
- 4*f1*f3*f8*z[2]*z[6]*z[9]^2 + 4*f1*f6*z[2]*z[6]*z[9]*z[11] + (8*f0*f8 -
8*f2*f6)*z[2]*z[6]*z[9]*z[12] + (-8*f0*f8 - 2*f1*f7)*z[2]*z[6]*z[9]*z[13] +
(8*f1*f8 + 4*f2*f7)*z[2]*z[6]*z[9]*z[14] - 2*f1*z[2]*z[6]*z[10]*z[11] +
4*f2*z[2]*z[6]*z[10]*z[12] - 2*f5*z[2]*z[6]*z[11]*z[15] +
4*f6*z[2]*z[6]*z[12]*z[15] - 2*z[2]*z[6]*z[12]*z[16] + 2*z[2]*z[6]*z[13]*z[16] -
2*f7*z[2]*z[6]*z[14]*z[15] + 4*f0*f7*z[2]*z[7]*z[9]*z[10] -
2*f1*f7*z[2]*z[7]*z[9]*z[11] + (-4*f1*f8 + 4*f2*f7 + 4*f3*f6)*z[2]*z[7]*z[9]*z[12]
+ 4*f1*f8*z[2]*z[7]*z[9]*z[13] + (-8*f2*f8 - 2*f3*f7)*z[2]*z[7]*z[9]*z[14] +
4*f3*f8*z[2]*z[7]*z[9]*z[15] - f5*z[2]*z[7]*z[9]*z[16] -
2*f3*z[2]*z[7]*z[10]*z[12] + f5*z[2]*z[7]*z[10]*z[15] + f5*z[2]*z[7]*z[11]*z[14] +
2*f5*z[2]*z[7]*z[12]^2 - f5*z[2]*z[7]*z[12]*z[13] - 4*f6*z[2]*z[7]*z[12]*z[14] -
2*f7*z[2]*z[7]*z[12]*z[15] + 2*f7*z[2]*z[7]*z[14]^2 - 4*f0*f7*z[2]*z[8]*z[9]^2 -
2*f3*z[2]*z[8]*z[9]*z[12] - 2*z[2]*z[8]*z[11]*z[15] + 4*z[2]*z[8]*z[12]*z[14] +
(8*f0*f3*f8 + 8*f0*f4*f7)*z[3]^2*z[9]^2 - 4*f0*f5*z[3]^2*z[9]*z[10] -
8*f0*f7*z[3]^2*z[9]*z[13] + 2*f1*f7*z[3]^2*z[9]*z[14] - 4*f1*f8*z[3]^2*z[9]*z[15]
+ 2*f1*z[3]^2*z[10]*z[12] - 2*f3*z[3]^2*z[12]^2 + 2*f5*z[3]^2*z[12]*z[15] -
2*f7*z[3]^2*z[15]^2 + (-16*f0*f4*f8 - 4*f1*f3*f8 - 8*f1*f4*f7)*z[3]*z[4]*z[9]^2 +
4*f1*f5*z[3]*z[4]*z[9]*z[10] - 2*f3*f5*z[3]*z[4]*z[9]*z[12] + (8*f0*f8 +
6*f1*f7)*z[3]*z[4]*z[9]*z[13] - 4*f2*f7*z[3]*z[4]*z[9]*z[14] + (8*f2*f8 +
4*f3*f7)*z[3]*z[4]*z[9]*z[15] + 4*f0*z[3]*z[4]*z[10]^2 -
2*f1*z[3]*z[4]*z[10]*z[11] - 4*f2*z[3]*z[4]*z[10]*z[12] +
4*f3*z[3]*z[4]*z[11]*z[12] - 2*f5*z[3]*z[4]*z[11]*z[15] + 2*z[3]*z[4]*z[12]*z[16]
+ 2*f7*z[3]*z[4]*z[14]*z[15] - 4*f8*z[3]*z[4]*z[15]^2 + (-16*f0*f4*f8 -
4*f0*f5*f7)*z[3]*z[5]*z[9]^2 + 8*f0*f6*z[3]*z[5]*z[9]*z[10] +
8*f0*f7*z[3]*z[5]*z[9]*z[11] - 4*f1*f7*z[3]*z[5]*z[9]*z[12] +
8*f0*f8*z[3]*z[5]*z[9]*z[13] - 4*f0*z[3]*z[5]*z[10]^2 - 4*f6*z[3]*z[5]*z[12]*z[15]
+ 2*z[3]*z[5]*z[12]*z[16] + 2*f7*z[3]*z[5]*z[14]*z[15] + 4*f8*z[3]*z[5]*z[15]^2 +
(8*f0*f5*f8 + 8*f1*f4*f8 + 2*f1*f5*f7)*z[3]*z[6]*z[9]^2 + (-4*f0*f7 -
4*f1*f6)*z[3]*z[6]*z[9]*z[10] - 2*f1*f7*z[3]*z[6]*z[9]*z[11] + (-4*f1*f8 + 4*f2*f7
+ 4*f3*f6)*z[3]*z[6]*z[9]*z[12] - 4*f1*f8*z[3]*z[6]*z[9]*z[13] -
2*f3*f7*z[3]*z[6]*z[9]*z[14] - 4*f3*f8*z[3]*z[6]*z[9]*z[15] -
f5*z[3]*z[6]*z[9]*z[16] + 2*f1*z[3]*z[6]*z[10]^2 - 2*f3*z[3]*z[6]*z[10]*z[12] +
f5*z[3]*z[6]*z[10]*z[15] + f5*z[3]*z[6]*z[11]*z[14] - f5*z[3]*z[6]*z[12]*z[13] -
2*f7*z[3]*z[6]*z[12]*z[15] - 4*f1*f5*f8*z[3]*z[7]*z[9]^2 -
8*f0*f8*z[3]*z[7]*z[9]*z[10] + 4*f1*f8*z[3]*z[7]*z[9]*z[11] + (-4*f3*f7 - 8*f4*f6
+ 2*f5^2)*z[3]*z[7]*z[9]*z[12] + (4*f3*f8 + 4*f4*f7)*z[3]*z[7]*z[9]*z[14] -
2*f5*f7*z[3]*z[7]*z[9]*z[15] + 4*f6*z[3]*z[7]*z[9]*z[16] +
4*f4*z[3]*z[7]*z[10]*z[12] - 2*f5*z[3]*z[7]*z[10]*z[14] - 2*z[3]*z[7]*z[10]*z[16]
- 2*f5*z[3]*z[7]*z[11]*z[12] + 4*f7*z[3]*z[7]*z[11]*z[15] +
4*f6*z[3]*z[7]*z[12]*z[13] + 4*f8*z[3]*z[7]*z[12]*z[15] -
2*f7*z[3]*z[7]*z[13]*z[14] - 4*f8*z[3]*z[7]*z[13]*z[15] + (8*f0*f8 +
2*f1*f7)*z[3]*z[8]*z[9]^2 + 4*f4*z[3]*z[8]*z[9]*z[12] - 2*z[3]*z[8]*z[9]*z[16] -
2*z[3]*z[8]*z[12]^2 - 2*z[3]*z[8]*z[12]*z[13] + (8*f1*f4*f8 + 8*f2*f4*f7 -
2*f3^2*f7)*z[4]^2*z[9]^2 - 4*f2*f5*z[4]^2*z[9]*z[10] + 2*f3*f5*z[4]^2*z[9]*z[11] +
(-4*f1*f8 - 4*f2*f7)*z[4]^2*z[9]*z[13] + 4*f3*f7*z[4]^2*z[9]*z[14] + (-4*f3*f8 -
8*f4*f7)*z[4]^2*z[9]*z[15] + 2*f5*z[4]^2*z[9]*z[16] - 2*f1*z[4]^2*z[10]^2 +
4*f2*z[4]^2*z[10]*z[11] + 2*f5*z[4]^2*z[10]*z[15] - 2*f3*z[4]^2*z[11]^2 -
2*z[4]^2*z[11]*z[16] + 2*f7*z[4]^2*z[13]*z[15] - 2*f7*z[4]^2*z[14]^2 +
4*f8*z[4]^2*z[14]*z[15] + (8*f0*f5*f8 + 8*f1*f4*f8 + 2*f1*f5*f7)*z[4]*z[5]*z[9]^2
+ (-4*f0*f7 - 4*f1*f6)*z[4]*z[5]*z[9]*z[10] + (-8*f0*f8 -
2*f1*f7)*z[4]*z[5]*z[9]*z[11] + (4*f1*f8 + 4*f2*f7)*z[4]*z[5]*z[9]*z[12] -
4*f1*f8*z[4]*z[5]*z[9]*z[13] - 4*f3*f8*z[4]*z[5]*z[9]*z[15] +
f5*z[4]*z[5]*z[9]*z[16] + 2*f1*z[4]*z[5]*z[10]^2 - f5*z[4]*z[5]*z[10]*z[15] -
f5*z[4]*z[5]*z[11]*z[14] + 4*f6*z[4]*z[5]*z[11]*z[15] - 2*z[4]*z[5]*z[11]*z[16] +
f5*z[4]*z[5]*z[12]*z[13] - 2*f7*z[4]*z[5]*z[12]*z[15] - 2*f7*z[4]*z[5]*z[13]*z[15]
+ (-8*f1*f5*f8 - 16*f2*f4*f8 - 4*f2*f5*f7 + 4*f3^2*f8)*z[4]*z[6]*z[9]^2 + (4*f1*f7
+ 8*f2*f6)*z[4]*z[6]*z[9]*z[10] + (4*f1*f8 - 4*f3*f6)*z[4]*z[6]*z[9]*z[11] -
4*f3*f7*z[4]*z[6]*z[9]*z[12] + (8*f2*f8 + 2*f3*f7)*z[4]*z[6]*z[9]*z[13] -
4*f3*f8*z[4]*z[6]*z[9]*z[14] + (16*f4*f8 + 4*f5*f7)*z[4]*z[6]*z[9]*z[15] -
4*f6*z[4]*z[6]*z[9]*z[16] - 4*f2*z[4]*z[6]*z[10]^2 + 2*f3*z[4]*z[6]*z[10]*z[11] -
4*f6*z[4]*z[6]*z[10]*z[15] + 4*z[4]*z[6]*z[10]*z[16] + 4*f7*z[4]*z[6]*z[12]*z[14]
- 4*f8*z[4]*z[6]*z[12]*z[15] - 4*f8*z[4]*z[6]*z[13]*z[15] + (8*f2*f5*f8 +
2*f3*f5*f7)*z[4]*z[7]*z[9]^2 + (4*f1*f8 - 4*f3*f6)*z[4]*z[7]*z[9]*z[10] +
(-8*f2*f8 + 8*f4*f6 - 2*f5^2)*z[4]*z[7]*z[9]*z[11] + (4*f3*f8 +
8*f4*f7)*z[4]*z[7]*z[9]*z[12] - 4*f4*f7*z[4]*z[7]*z[9]*z[13] + (-8*f4*f8 -
2*f5*f7)*z[4]*z[7]*z[9]*z[14] - 4*f5*f8*z[4]*z[7]*z[9]*z[15] -
2*f7*z[4]*z[7]*z[9]*z[16] + 2*f3*z[4]*z[7]*z[10]^2 - 4*f4*z[4]*z[7]*z[10]*z[11] -
2*f5*z[4]*z[7]*z[10]*z[12] + 2*f5*z[4]*z[7]*z[10]*z[13] +
4*f6*z[4]*z[7]*z[10]*z[14] - 2*f7*z[4]*z[7]*z[10]*z[15] + 2*f5*z[4]*z[7]*z[11]^2 -
4*f6*z[4]*z[7]*z[11]*z[13] - 2*f7*z[4]*z[7]*z[11]*z[14] +
4*f8*z[4]*z[7]*z[11]*z[15] - 2*f7*z[4]*z[7]*z[12]*z[13] -
4*f8*z[4]*z[7]*z[12]*z[14] + 2*f7*z[4]*z[7]*z[13]^2 + 4*f8*z[4]*z[7]*z[13]*z[14] +
(-4*f1*f8 - 4*f2*f7)*z[4]*z[8]*z[9]^2 + 2*f3*z[4]*z[8]*z[9]*z[10] -
4*f4*z[4]*z[8]*z[9]*z[11] - 2*f5*z[4]*z[8]*z[9]*z[12] + 6*f7*z[4]*z[8]*z[9]*z[15]
- 2*z[4]*z[8]*z[10]*z[14] + 2*z[4]*z[8]*z[11]*z[12] + 2*z[4]*z[8]*z[11]*z[13] +
8*f0*f5*f8*z[5]^2*z[9]^2 - 4*f0*f7*z[5]^2*z[9]*z[10] - 8*f0*f8*z[5]^2*z[9]*z[11] +
4*f1*f8*z[5]^2*z[9]*z[12] + 2*f7*z[5]^2*z[12]*z[15] - 4*f8*z[5]^2*z[14]*z[15] +
(-16*f0*f6*f8 + 4*f0*f7^2 - 8*f1*f5*f8)*z[5]*z[6]*z[9]^2 + (16*f0*f8 +
4*f1*f7)*z[5]*z[6]*z[9]*z[10] + 4*f1*f8*z[5]*z[6]*z[9]*z[11] + (-8*f2*f8 -
2*f3*f7)*z[5]*z[6]*z[9]*z[12] + 4*f3*f8*z[5]*z[6]*z[9]*z[14] -
2*f7*z[5]*z[6]*z[11]*z[15] + 4*f8*z[5]*z[6]*z[12]*z[15] +
4*f8*z[5]*z[6]*z[13]*z[15] + (8*f1*f6*f8 - 2*f1*f7^2)*z[5]*z[7]*z[9]^2 -
4*f1*f8*z[5]*z[7]*z[9]*z[10] + (4*f3*f8 + 4*f4*f7)*z[5]*z[7]*z[9]*z[12] -
8*f4*f8*z[5]*z[7]*z[9]*z[14] + 4*f5*f8*z[5]*z[7]*z[9]*z[15] -
2*f7*z[5]*z[7]*z[9]*z[16] - 4*f8*z[5]*z[7]*z[11]*z[15] + 2*f7*z[5]*z[7]*z[12]^2 -
2*f7*z[5]*z[7]*z[12]*z[13] - 4*f8*z[5]*z[7]*z[12]*z[14] +
4*f8*z[5]*z[7]*z[13]*z[14] - 4*f1*f8*z[5]*z[8]*z[9]^2 - 2*f5*z[5]*z[8]*z[9]*z[12]
+ 2*z[5]*z[8]*z[10]*z[14] + (8*f1*f6*f8 - 2*f1*f7^2 + 8*f2*f5*f8)*z[6]^2*z[9]^2 +
(-8*f1*f8 - 4*f2*f7)*z[6]^2*z[9]*z[10] + 2*f3*f7*z[6]^2*z[9]*z[11] +
4*f3*f8*z[6]^2*z[9]*z[12] - 4*f3*f8*z[6]^2*z[9]*z[13] - 8*f5*f8*z[6]^2*z[9]*z[15]
+ 2*f7*z[6]^2*z[9]*z[16] + 2*f7*z[6]^2*z[10]*z[15] - 2*f7*z[6]^2*z[12]^2 +
(-16*f2*f6*f8 + 4*f2*f7^2 - 4*f3*f5*f8)*z[6]*z[7]*z[9]^2 + (8*f2*f8 +
2*f3*f7)*z[6]*z[7]*z[9]*z[10] - 4*f4*f7*z[6]*z[7]*z[9]*z[11] + (-8*f4*f8 -
2*f5*f7)*z[6]*z[7]*z[9]*z[12] + 8*f4*f8*z[6]*z[7]*z[9]*z[13] +
8*f5*f8*z[6]*z[7]*z[9]*z[14] + (8*f6*f8 - 2*f7^2)*z[6]*z[7]*z[9]*z[15] -
2*f7*z[6]*z[7]*z[10]*z[14] + 2*f7*z[6]*z[7]*z[11]*z[12] +
2*f7*z[6]*z[7]*z[11]*z[13] + 4*f8*z[6]*z[7]*z[12]^2 - 4*f8*z[6]*z[7]*z[13]^2 +
8*f2*f8*z[6]*z[8]*z[9]^2 + 2*f5*z[6]*z[8]*z[9]*z[11] + 4*f6*z[6]*z[8]*z[9]*z[12] -
2*f7*z[6]*z[8]*z[9]*z[14] - 8*f8*z[6]*z[8]*z[9]*z[15] - 2*z[6]*z[8]*z[10]*z[12] -
2*z[6]*z[8]*z[10]*z[13] + (8*f3*f6*f8 - 2*f3*f7^2)*z[7]^2*z[9]^2 -
4*f3*f8*z[7]^2*z[9]*z[10] + 2*f5*f7*z[7]^2*z[9]*z[11] + 4*f5*f8*z[7]^2*z[9]*z[12]
- 4*f5*f8*z[7]^2*z[9]*z[13] + (-8*f6*f8 + 2*f7^2)*z[7]^2*z[9]*z[14] +
2*f7*z[7]^2*z[10]*z[12] - 2*f7*z[7]^2*z[11]^2 - 4*f8*z[7]^2*z[11]*z[12] +
4*f8*z[7]^2*z[11]*z[13] - 4*f3*f8*z[7]*z[8]*z[9]^2 - 4*f6*z[7]*z[8]*z[9]*z[11] -
4*f7*z[7]*z[8]*z[9]*z[12] + 2*f7*z[7]*z[8]*z[9]*z[13] + 8*f8*z[7]*z[8]*z[9]*z[14]
+ 2*z[7]*z[8]*z[10]*z[11] + 2*z[8]^2*z[9]*z[11],

// Bmat[3,2]
  (-64*f0*f2*f4*f6*f7*f8 + 16*f0*f2*f4*f7^3 + 16*f0*f2*f5^2*f7*f8 +
16*f0*f3^2*f6*f7*f8 - 4*f0*f3^2*f7^3 + 16*f1^2*f4*f6*f7*f8 - 4*f1^2*f4*f7^3 -
4*f1^2*f5^2*f7*f8)*z[1]^2*z[9]^2 + (32*f0*f2*f4*f7*f8 - 8*f0*f2*f5*f7^2 -
8*f0*f3^2*f7*f8 - 8*f1^2*f4*f7*f8 + 2*f1^2*f5*f7^2)*z[1]^2*z[9]*z[10] +
(-16*f0*f2*f5*f7*f8 + 4*f0*f3*f5*f7^2 + 4*f1^2*f5*f7*f8)*z[1]^2*z[9]*z[11] +
(8*f0*f3*f5*f7*f8 - 2*f1*f3*f5*f7^2)*z[1]^2*z[9]*z[12] + (32*f0*f2*f6*f7*f8 -
8*f0*f2*f7^3 - 8*f0*f3*f5*f7*f8 - 8*f1^2*f6*f7*f8 + 2*f1^2*f7^3)*z[1]^2*z[9]*z[13]
+ (-16*f0*f3*f6*f7*f8 + 4*f0*f3*f7^3 + 4*f1*f3*f5*f7*f8)*z[1]^2*z[9]*z[14] +
(32*f0*f4*f6*f7*f8 - 8*f0*f4*f7^3 - 8*f0*f5^2*f7*f8 - 8*f1*f3*f6*f7*f8 +
2*f1*f3*f7^3)*z[1]^2*z[9]*z[15] + (-8*f0*f4*f7*f8 + 2*f0*f5*f7^2 +
2*f1*f3*f7*f8)*z[1]^2*z[9]*z[16] + (16*f0^2*f7*f8 + 32*f0*f2*f5*f8 -
8*f1^2*f5*f8)*z[1]^2*z[10]^2 + (-32*f0^2*f8^2 - 16*f0*f1*f7*f8 - 32*f0*f2*f6*f8 +
8*f0*f2*f7^2 - 24*f0*f3*f5*f8 + 8*f1^2*f6*f8 - 2*f1^2*f7^2)*z[1]^2*z[10]*z[11] +
(16*f0*f1*f8^2 - 32*f0*f2*f7*f8 + 16*f0*f3*f6*f8 - 4*f0*f3*f7^2 + 16*f1^2*f7*f8 +
12*f1*f3*f5*f8)*z[1]^2*z[10]*z[12] + 16*f0*f1*f8^2*z[1]^2*z[10]*z[13] +
(32*f0*f2*f8^2 + 8*f0*f3*f7*f8 - 16*f1^2*f8^2)*z[1]^2*z[10]*z[14] +
(-16*f0*f3*f8^2 - 8*f0*f4*f7*f8 + 2*f0*f5*f7^2 - 2*f1*f3*f7*f8)*z[1]^2*z[10]*z[15]
- 16*f0*f5*f8*z[1]^2*z[10]*z[16] + (16*f0*f1*f8^2 + 16*f0*f2*f7*f8 +
16*f0*f3*f6*f8 - 4*f0*f3*f7^2 + 16*f0*f4*f5*f8)*z[1]^2*z[11]^2 + (16*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 8*f0*f4*f7^2 - 16*f1^2*f8^2 - 16*f1*f2*f7*f8 - 8*f1*f3*f6*f8 +
2*f1*f3*f7^2 - 16*f1*f4*f5*f8)*z[1]^2*z[11]*z[12] + (-32*f0*f2*f8^2 -
8*f0*f3*f7*f8 - 16*f0*f5^2*f8)*z[1]^2*z[11]*z[13] + (-16*f0*f3*f8^2 -
8*f0*f4*f7*f8 + 16*f0*f5*f6*f8 - 2*f0*f5*f7^2 + 16*f1*f2*f8^2 + 2*f1*f3*f7*f8 +
8*f1*f5^2*f8)*z[1]^2*z[11]*z[14] + (32*f0*f4*f8^2 - 8*f0*f5*f7*f8 + 8*f1*f4*f7*f8
- 8*f1*f5*f6*f8)*z[1]^2*z[11]*z[15] + (16*f0*f6*f8 - 4*f0*f7^2 +
8*f1*f5*f8)*z[1]^2*z[11]*z[16] + (-16*f0*f3*f8^2 + 16*f0*f4*f7*f8 + 16*f1*f2*f8^2
- 16*f1*f3*f7*f8 + 16*f1*f4*f6*f8 - 4*f1*f4*f7^2 + 16*f2^2*f7*f8 + 16*f2*f4*f5*f8
- 4*f3^2*f5*f8)*z[1]^2*z[12]^2 + (-8*f0*f4*f7*f8 + 16*f0*f5*f6*f8 - 2*f0*f5*f7^2 +
16*f1*f2*f8^2 + 6*f1*f3*f7*f8 + 8*f1*f5^2*f8)*z[1]^2*z[12]*z[13] +
(-16*f0*f5*f7*f8 + 16*f1*f3*f8^2 + 8*f1*f4*f7*f8 - 16*f1*f5*f6*f8 + 2*f1*f5*f7^2 -
32*f2^2*f8^2 - 8*f2*f3*f7*f8 - 16*f2*f5^2*f8)*z[1]^2*z[12]*z[14] + (16*f0*f5*f8^2
- 32*f1*f4*f8^2 + 12*f1*f5*f7*f8 + 16*f2*f3*f8^2 - 16*f2*f4*f7*f8 + 16*f2*f5*f6*f8
+ 8*f3^2*f7*f8 + 4*f3*f5^2*f8)*z[1]^2*z[12]*z[15] + (-8*f1*f6*f8 + 2*f1*f7^2 -
16*f2*f5*f8)*z[1]^2*z[12]*z[16] + (16*f0*f3*f8^2 + 16*f0*f5*f6*f8 -
4*f0*f5*f7^2)*z[1]^2*z[13]^2 + (8*f0*f5*f7*f8 - 32*f0*f6^2*f8 + 8*f0*f6*f7^2 -
16*f1*f3*f8^2 - 16*f1*f5*f6*f8 + 4*f1*f5*f7^2)*z[1]^2*z[13]*z[14] +
(-16*f0*f5*f8^2 + 16*f0*f6*f7*f8 - 4*f0*f7^3 - 4*f1*f5*f7*f8 + 16*f1*f6^2*f8 -
4*f1*f6*f7^2)*z[1]^2*z[13]*z[15] + (-8*f1*f6*f8 + 2*f1*f7^2)*z[1]^2*z[13]*z[16] +
(16*f0*f6*f7*f8 - 4*f0*f7^3 - 4*f1*f5*f7*f8 + 16*f1*f6^2*f8 - 4*f1*f6*f7^2 +
16*f2*f3*f8^2 + 16*f2*f5*f6*f8 - 4*f2*f5*f7^2)*z[1]^2*z[14]^2 + (-32*f0*f6*f8^2 +
8*f0*f7^2*f8 + 16*f1*f5*f8^2 - 24*f1*f6*f7*f8 + 6*f1*f7^3 + 8*f2*f5*f7*f8 -
32*f2*f6^2*f8 + 8*f2*f6*f7^2 - 16*f3^2*f8^2 - 8*f3*f5*f6*f8 +
2*f3*f5*f7^2)*z[1]^2*z[14]*z[15] + (16*f2*f6*f8 - 4*f2*f7^2 +
4*f3*f5*f8)*z[1]^2*z[14]*z[16] + (16*f1*f6*f8^2 - 4*f1*f7^2*f8 - 16*f2*f5*f8^2 +
16*f2*f6*f7*f8 - 4*f2*f7^3 + 16*f3*f4*f8^2 - 8*f3*f5*f7*f8 + 16*f3*f6^2*f8 -
4*f3*f6*f7^2)*z[1]^2*z[15]^2 + (-16*f3*f6*f8 + 4*f3*f7^2)*z[1]^2*z[15]*z[16] +
(32*f0*f2*f4*f7*f8 - 8*f0*f2*f5*f7^2 - 8*f0*f3^2*f7*f8 - 8*f1^2*f4*f7*f8 +
2*f1^2*f5*f7^2)*z[1]*z[2]*z[9]^2 + (-32*f0^2*f7*f8 - 64*f0*f2*f5*f8 +
16*f0*f2*f6*f7 + 16*f1^2*f5*f8 - 4*f1^2*f6*f7)*z[1]*z[2]*z[9]*z[10] +
(32*f0^2*f8^2 + 16*f0*f1*f7*f8 + 32*f0*f2*f6*f8 + 24*f0*f3*f5*f8 - 8*f0*f3*f6*f7 -
8*f1^2*f6*f8)*z[1]*z[2]*z[9]*z[11] + (-16*f0*f1*f8^2 + 32*f0*f2*f7*f8 -
16*f0*f3*f6*f8 - 16*f1^2*f7*f8 - 12*f1*f3*f5*f8 +
4*f1*f3*f6*f7)*z[1]*z[2]*z[9]*z[12] + (-16*f0*f1*f8^2 - 32*f0*f2*f7*f8 +
4*f0*f3*f7^2 + 8*f1^2*f7*f8)*z[1]*z[2]*z[9]*z[13] + (-32*f0*f2*f8^2 +
8*f0*f3*f7*f8 + 16*f1^2*f8^2 - 2*f1*f3*f7^2)*z[1]*z[2]*z[9]*z[14] + (16*f0*f3*f8^2
- 16*f0*f4*f7*f8 + 4*f0*f5*f7^2 + 8*f1*f3*f7*f8)*z[1]*z[2]*z[9]*z[15] +
(16*f0*f5*f8 - 4*f0*f6*f7)*z[1]*z[2]*z[9]*z[16] + (-8*f0*f2*f7 +
2*f1^2*f7)*z[1]*z[2]*z[10]^2 + (16*f0*f2*f8 + 4*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[2]*z[10]*z[11] - 2*f1*f3*f7*z[1]*z[2]*z[10]*z[12] +
8*f0*f3*f8*z[1]*z[2]*z[10]*z[13] - 4*f1*f3*f8*z[1]*z[2]*z[10]*z[14] + (16*f0*f5*f8
- 4*f0*f6*f7)*z[1]*z[2]*z[10]*z[15] + 4*f0*f7*z[1]*z[2]*z[10]*z[16] -
16*f0*f3*f8*z[1]*z[2]*z[11]^2 + (-4*f0*f5*f7 + 12*f1*f3*f8)*z[1]*z[2]*z[11]*z[12]
+ 8*f0*f5*f7*z[1]*z[2]*z[11]*z[13] + (-4*f0*f6*f7 -
4*f1*f5*f7)*z[1]*z[2]*z[11]*z[14] + (-16*f0*f6*f8 + 8*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[2]*z[11]*z[15] + (-8*f0*f8 - 2*f1*f7)*z[1]*z[2]*z[11]*z[16] +
(2*f1*f5*f7 - 8*f2*f3*f8)*z[1]*z[2]*z[12]^2 + (-4*f0*f6*f7 -
4*f1*f5*f7)*z[1]*z[2]*z[12]*z[13] + (8*f0*f7^2 + 4*f1*f6*f7 + 8*f2*f5*f7 +
4*f3^2*f8)*z[1]*z[2]*z[12]*z[14] + (-8*f0*f7*f8 + 8*f1*f6*f8 - 8*f1*f7^2 +
8*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[1]*z[2]*z[12]*z[15] +
(4*f1*f8 + 4*f2*f7)*z[1]*z[2]*z[12]*z[16] - 16*f0*f5*f8*z[1]*z[2]*z[13]^2 +
(32*f0*f6*f8 - 4*f0*f7^2 + 16*f1*f5*f8)*z[1]*z[2]*z[13]*z[14] + (-8*f0*f7*f8 -
16*f1*f6*f8 + 2*f1*f7^2)*z[1]*z[2]*z[13]*z[15] + 4*f1*f8*z[1]*z[2]*z[13]*z[16] +
(-16*f0*f7*f8 - 16*f1*f6*f8 + 2*f1*f7^2 - 16*f2*f5*f8)*z[1]*z[2]*z[14]^2 +
(32*f0*f8^2 + 16*f1*f7*f8 + 32*f2*f6*f8 - 4*f2*f7^2 +
8*f3*f5*f8)*z[1]*z[2]*z[14]*z[15] + (-8*f2*f8 - 2*f3*f7)*z[1]*z[2]*z[14]*z[16] +
(-16*f1*f8^2 - 8*f2*f7*f8 - 16*f3*f6*f8 + 4*f3*f7^2)*z[1]*z[2]*z[15]^2 +
12*f3*f8*z[1]*z[2]*z[15]*z[16] + (-16*f0*f2*f5*f7*f8 + 4*f0*f3*f5*f7^2 +
4*f1^2*f5*f7*f8)*z[1]*z[3]*z[9]^2 + (32*f0^2*f8^2 + 16*f0*f1*f7*f8 +
32*f0*f2*f6*f8 + 24*f0*f3*f5*f8 - 8*f0*f3*f6*f7 -
8*f1^2*f6*f8)*z[1]*z[3]*z[9]*z[10] + (-32*f0*f1*f8^2 - 16*f0*f2*f7*f8 -
32*f0*f3*f6*f8 - 32*f0*f4*f5*f8 + 16*f0*f4*f6*f7 - 4*f0*f5^2*f7 -
4*f1^2*f7*f8)*z[1]*z[3]*z[9]*z[11] + (-24*f0*f3*f7*f8 + 32*f0*f4*f6*f8 +
16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 8*f1*f3*f6*f8 + 16*f1*f4*f5*f8 - 8*f1*f4*f6*f7 +
2*f1*f5^2*f7)*z[1]*z[3]*z[9]*z[12] + (32*f0*f2*f8^2 + 16*f0*f3*f7*f8 -
8*f0*f4*f7^2 + 16*f0*f5^2*f8)*z[1]*z[3]*z[9]*z[13] + (16*f0*f3*f8^2 -
16*f0*f5*f6*f8 - 16*f1*f2*f8^2 - 4*f1*f3*f7*f8 + 4*f1*f4*f7^2 -
8*f1*f5^2*f8)*z[1]*z[3]*z[9]*z[14] + (-32*f0*f4*f8^2 + 24*f0*f5*f7*f8 -
8*f1*f4*f7*f8 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2)*z[1]*z[3]*z[9]*z[15] + (-16*f0*f6*f8
- 8*f1*f5*f8 + 2*f1*f6*f7)*z[1]*z[3]*z[9]*z[16] + (-16*f0*f2*f8 + 4*f0*f3*f7 +
4*f1^2*f8)*z[1]*z[3]*z[10]^2 + (16*f0*f3*f8 - 8*f0*f4*f7)*z[1]*z[3]*z[10]*z[11] +
(-12*f1*f3*f8 + 4*f1*f4*f7)*z[1]*z[3]*z[10]*z[12] + (-16*f0*f4*f8 -
4*f0*f5*f7)*z[1]*z[3]*z[10]*z[13] + (-16*f0*f5*f8 + 8*f0*f6*f7 + 8*f1*f4*f8 +
2*f1*f5*f7)*z[1]*z[3]*z[10]*z[14] + (-8*f0*f7^2 -
2*f1*f6*f7)*z[1]*z[3]*z[10]*z[15] + 8*f0*f8*z[1]*z[3]*z[10]*z[16] +
4*f0*f5*f7*z[1]*z[3]*z[11]^2 + (8*f1*f4*f8 - 2*f1*f5*f7)*z[1]*z[3]*z[11]*z[12] +
(24*f0*f5*f8 - 8*f0*f6*f7)*z[1]*z[3]*z[11]*z[13] + (-8*f1*f5*f8 +
2*f1*f6*f7)*z[1]*z[3]*z[11]*z[14] + (8*f0*f7*f8 +
8*f1*f6*f8)*z[1]*z[3]*z[11]*z[15] - 4*f1*f8*z[1]*z[3]*z[11]*z[16] + (-16*f2*f4*f8
+ 8*f3^2*f8)*z[1]*z[3]*z[12]^2 + (-16*f0*f6*f8 + 8*f0*f7^2 - 16*f1*f5*f8 +
6*f1*f6*f7)*z[1]*z[3]*z[12]*z[13] + (8*f0*f7*f8 + 8*f1*f6*f8 - 8*f1*f7^2 +
24*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[1]*z[3]*z[12]*z[14] +
(-16*f0*f8^2 - 4*f1*f7*f8 - 16*f2*f6*f8 + 8*f2*f7^2 - 16*f3*f5*f8 + 8*f3*f6*f7 +
16*f4^2*f8)*z[1]*z[3]*z[12]*z[15] + (8*f2*f8 - 4*f3*f7)*z[1]*z[3]*z[12]*z[16] +
4*f0*f7^2*z[1]*z[3]*z[13]^2 + (-16*f0*f7*f8 - 4*f1*f7^2)*z[1]*z[3]*z[13]*z[14] +
(16*f0*f8^2 + 4*f1*f7*f8)*z[1]*z[3]*z[13]*z[15] + (12*f1*f7*f8 + 4*f2*f7^2 +
4*f3*f5*f8)*z[1]*z[3]*z[14]^2 + (-16*f1*f8^2 - 16*f2*f7*f8 - 4*f3*f7^2 -
8*f4*f5*f8)*z[1]*z[3]*z[14]*z[15] + 4*f4*f7*z[1]*z[3]*z[14]*z[16] + (16*f2*f8^2 +
8*f3*f7*f8 + 4*f5^2*f8)*z[1]*z[3]*z[15]^2 + (-8*f4*f8 -
2*f5*f7)*z[1]*z[3]*z[15]*z[16] + (8*f0*f3*f5*f7*f8 -
2*f1*f3*f5*f7^2)*z[1]*z[4]*z[9]^2 + (-16*f0*f1*f8^2 + 32*f0*f2*f7*f8 -
16*f0*f3*f6*f8 - 16*f1^2*f7*f8 - 12*f1*f3*f5*f8 +
4*f1*f3*f6*f7)*z[1]*z[4]*z[9]*z[10] + (-24*f0*f3*f7*f8 + 32*f0*f4*f6*f8 +
16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 8*f1*f3*f6*f8 + 16*f1*f4*f5*f8 - 8*f1*f4*f6*f7 +
2*f1*f5^2*f7)*z[1]*z[4]*z[9]*z[11] + (32*f0*f3*f8^2 - 16*f0*f4*f7*f8 -
32*f1*f2*f8^2 + 32*f1*f3*f7*f8 - 32*f1*f4*f6*f8 - 32*f2^2*f7*f8 - 32*f2*f4*f5*f8 +
16*f2*f4*f6*f7 - 4*f2*f5^2*f7 + 8*f3^2*f5*f8 - 4*f3^2*f6*f7)*z[1]*z[4]*z[9]*z[12]
+ (-16*f0*f5*f6*f8 - 16*f1*f2*f8^2 - 8*f1*f3*f7*f8 + 4*f1*f4*f7^2 -
8*f1*f5^2*f8)*z[1]*z[4]*z[9]*z[13] + (8*f0*f5*f7*f8 - 16*f1*f3*f8^2 +
16*f1*f5*f6*f8 + 32*f2^2*f8^2 + 8*f2*f3*f7*f8 - 8*f2*f4*f7^2 + 16*f2*f5^2*f8 +
2*f3^2*f7^2)*z[1]*z[4]*z[9]*z[14] + (-16*f0*f5*f8^2 + 32*f1*f4*f8^2 -
16*f1*f5*f7*f8 - 16*f2*f3*f8^2 + 16*f2*f4*f7*f8 - 16*f2*f5*f6*f8 + 4*f2*f5*f7^2 -
8*f3^2*f7*f8 - 4*f3*f5^2*f8)*z[1]*z[4]*z[9]*z[15] + (-4*f0*f7*f8 + 8*f1*f6*f8 +
16*f2*f5*f8 - 4*f2*f6*f7 + f3*f5*f7)*z[1]*z[4]*z[9]*z[16] -
2*f1*f3*f7*z[1]*z[4]*z[10]^2 + 4*f1*f4*f7*z[1]*z[4]*z[10]*z[11] + (8*f2*f3*f8 -
8*f2*f4*f7 + 2*f3^2*f7)*z[1]*z[4]*z[10]*z[12] + (-16*f0*f5*f8 + 8*f0*f6*f7 +
8*f1*f4*f8 + 2*f1*f5*f7)*z[1]*z[4]*z[10]*z[13] + (16*f0*f6*f8 - 8*f0*f7^2 +
16*f1*f5*f8 - 8*f1*f6*f7 - 16*f2*f4*f8 - 4*f2*f5*f7)*z[1]*z[4]*z[10]*z[14] +
(-4*f0*f7*f8 - 8*f1*f6*f8 + 8*f1*f7^2 + 4*f2*f6*f7 + 8*f3*f4*f8 +
f3*f5*f7)*z[1]*z[4]*z[10]*z[15] + (-8*f1*f4*f8 - 2*f1*f5*f7)*z[1]*z[4]*z[11]^2 +
(16*f2*f4*f8 + 4*f2*f5*f7 - 8*f3^2*f8)*z[1]*z[4]*z[11]*z[12] -
8*f0*f7^2*z[1]*z[4]*z[11]*z[13] + (12*f0*f7*f8 - 8*f1*f6*f8 + 8*f1*f7^2 -
8*f2*f5*f8 + 4*f2*f6*f7 + 8*f3*f4*f8 + f3*f5*f7)*z[1]*z[4]*z[11]*z[14] +
(-8*f1*f7*f8 - 8*f2*f7^2 + 8*f3*f5*f8 - 4*f3*f6*f7 -
16*f4^2*f8)*z[1]*z[4]*z[11]*z[15] + 2*f3*f7*z[1]*z[4]*z[11]*z[16] -
2*f3*f5*f7*z[1]*z[4]*z[12]^2 + (12*f0*f7*f8 + 8*f1*f6*f8 + 8*f2*f5*f8 - 4*f2*f6*f7
+ f3*f5*f7)*z[1]*z[4]*z[12]*z[13] + (-16*f0*f8^2 - 16*f1*f7*f8 - 12*f3*f5*f8 +
4*f3*f6*f7)*z[1]*z[4]*z[12]*z[14] + (16*f1*f8^2 + 16*f2*f7*f8 + 8*f3*f6*f8 +
16*f4*f5*f8 - 8*f4*f6*f7 + 2*f5^2*f7)*z[1]*z[4]*z[12]*z[15] + (-8*f3*f8 +
4*f4*f7)*z[1]*z[4]*z[12]*z[16] + 8*f0*f7*f8*z[1]*z[4]*z[13]^2 + (-16*f0*f8^2 -
8*f1*f7*f8 - 4*f3*f5*f8)*z[1]*z[4]*z[13]*z[14] + (8*f2*f7*f8 + 2*f3*f7^2 +
8*f4*f5*f8)*z[1]*z[4]*z[13]*z[15] - 4*f4*f7*z[1]*z[4]*z[13]*z[16] + (16*f1*f8^2 -
2*f3*f7^2)*z[1]*z[4]*z[14]^2 + (-16*f2*f8^2 + 4*f4*f7^2 -
8*f5^2*f8)*z[1]*z[4]*z[14]*z[15] + (8*f4*f8 + 2*f5*f7)*z[1]*z[4]*z[14]*z[16] +
(-8*f4*f7*f8 + 8*f5*f6*f8 - 2*f5*f7^2)*z[1]*z[4]*z[15]^2 -
8*f5*f8*z[1]*z[4]*z[15]*z[16] + (32*f0*f2*f6*f7*f8 - 8*f0*f2*f7^3 -
8*f0*f3*f5*f7*f8 - 8*f1^2*f6*f7*f8 + 2*f1^2*f7^3)*z[1]*z[5]*z[9]^2 +
(-16*f0*f1*f8^2 - 32*f0*f2*f7*f8 + 4*f0*f3*f7^2 +
8*f1^2*f7*f8)*z[1]*z[5]*z[9]*z[10] + (32*f0*f2*f8^2 + 16*f0*f3*f7*f8 -
8*f0*f4*f7^2 + 16*f0*f5^2*f8)*z[1]*z[5]*z[9]*z[11] + (-16*f0*f5*f6*f8 -
16*f1*f2*f8^2 - 8*f1*f3*f7*f8 + 4*f1*f4*f7^2 - 8*f1*f5^2*f8)*z[1]*z[5]*z[9]*z[12]
+ (-32*f0*f3*f8^2 + 16*f0*f4*f7*f8 - 32*f0*f5*f6*f8 +
8*f0*f5*f7^2)*z[1]*z[5]*z[9]*z[13] + (32*f0*f6^2*f8 - 8*f0*f6*f7^2 + 16*f1*f3*f8^2
- 8*f1*f4*f7*f8 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[1]*z[5]*z[9]*z[14] +
(16*f0*f5*f8^2 - 48*f0*f6*f7*f8 + 12*f0*f7^3 + 8*f1*f5*f7*f8 - 16*f1*f6^2*f8 +
4*f1*f6*f7^2)*z[1]*z[5]*z[9]*z[15] + (12*f0*f7*f8 + 8*f1*f6*f8 -
3*f1*f7^2)*z[1]*z[5]*z[9]*z[16] - 8*f0*f3*f8*z[1]*z[5]*z[10]^2 +
16*f0*f4*f8*z[1]*z[5]*z[10]*z[11] + (16*f0*f5*f8 -
8*f1*f4*f8)*z[1]*z[5]*z[10]*z[12] + 16*f0*f5*f8*z[1]*z[5]*z[10]*z[13] +
(-16*f0*f6*f8 - 8*f1*f5*f8)*z[1]*z[5]*z[10]*z[14] + (20*f0*f7*f8 + 8*f1*f6*f8 -
f1*f7^2)*z[1]*z[5]*z[10]*z[15] - 24*f0*f5*f8*z[1]*z[5]*z[11]^2 + (16*f0*f6*f8 -
4*f0*f7^2 + 16*f1*f5*f8)*z[1]*z[5]*z[11]*z[12] + 4*f0*f7^2*z[1]*z[5]*z[11]*z[13] +
(4*f0*f7*f8 - f1*f7^2)*z[1]*z[5]*z[11]*z[14] + (-32*f0*f8^2 -
8*f1*f7*f8)*z[1]*z[5]*z[11]*z[15] + (-16*f0*f7*f8 - 8*f1*f6*f8 + 2*f1*f7^2 -
8*f2*f5*f8)*z[1]*z[5]*z[12]^2 + (-4*f0*f7*f8 - 3*f1*f7^2)*z[1]*z[5]*z[12]*z[13] +
(16*f0*f8^2 + 8*f1*f7*f8 + 4*f2*f7^2 + 8*f3*f5*f8)*z[1]*z[5]*z[12]*z[14] +
(16*f1*f8^2 - 4*f3*f7^2 - 8*f4*f5*f8)*z[1]*z[5]*z[12]*z[15] +
8*f3*f8*z[1]*z[5]*z[12]*z[16] - 8*f0*f7*f8*z[1]*z[5]*z[13]^2 + (16*f0*f8^2 +
8*f1*f7*f8)*z[1]*z[5]*z[13]*z[14] + (-16*f1*f8^2 - 8*f2*f7*f8 - 8*f3*f6*f8 +
2*f3*f7^2)*z[1]*z[5]*z[14]^2 + (16*f2*f8^2 + 8*f3*f7*f8 + 16*f4*f6*f8 -
4*f4*f7^2)*z[1]*z[5]*z[14]*z[15] - 8*f4*f8*z[1]*z[5]*z[14]*z[16] + (-16*f3*f8^2 -
8*f5*f6*f8 + 2*f5*f7^2)*z[1]*z[5]*z[15]^2 + 8*f5*f8*z[1]*z[5]*z[15]*z[16] +
(-16*f0*f3*f6*f7*f8 + 4*f0*f3*f7^3 + 4*f1*f3*f5*f7*f8)*z[1]*z[6]*z[9]^2 +
(-32*f0*f2*f8^2 + 8*f0*f3*f7*f8 + 16*f1^2*f8^2 -
2*f1*f3*f7^2)*z[1]*z[6]*z[9]*z[10] + (16*f0*f3*f8^2 - 16*f0*f5*f6*f8 -
16*f1*f2*f8^2 - 4*f1*f3*f7*f8 + 4*f1*f4*f7^2 - 8*f1*f5^2*f8)*z[1]*z[6]*z[9]*z[11]
+ (8*f0*f5*f7*f8 - 16*f1*f3*f8^2 + 16*f1*f5*f6*f8 + 32*f2^2*f8^2 + 8*f2*f3*f7*f8 -
8*f2*f4*f7^2 + 16*f2*f5^2*f8 + 2*f3^2*f7^2)*z[1]*z[6]*z[9]*z[12] + (32*f0*f6^2*f8
- 8*f0*f6*f7^2 + 16*f1*f3*f8^2 - 8*f1*f4*f7*f8 + 16*f1*f5*f6*f8 -
4*f1*f5*f7^2)*z[1]*z[6]*z[9]*z[13] + (-16*f0*f6*f7*f8 + 4*f0*f7^3 - 32*f1*f6^2*f8
+ 8*f1*f6*f7^2 - 32*f2*f3*f8^2 + 16*f2*f4*f7*f8 - 32*f2*f5*f6*f8 + 8*f2*f5*f7^2 -
4*f3^2*f7*f8)*z[1]*z[6]*z[9]*z[14] + (32*f0*f6*f8^2 - 8*f0*f7^2*f8 - 16*f1*f5*f8^2
+ 32*f1*f6*f7*f8 - 8*f1*f7^3 - 16*f2*f5*f7*f8 + 32*f2*f6^2*f8 - 8*f2*f6*f7^2 +
16*f3^2*f8^2 + 8*f3*f5*f6*f8 - 2*f3*f5*f7^2)*z[1]*z[6]*z[9]*z[15] + (-4*f1*f7*f8 -
16*f2*f6*f8 + 6*f2*f7^2 - 4*f3*f5*f8)*z[1]*z[6]*z[9]*z[16] +
4*f1*f3*f8*z[1]*z[6]*z[10]^2 + (16*f0*f5*f8 - 8*f1*f4*f8)*z[1]*z[6]*z[10]*z[11] +
(-16*f0*f6*f8 + 4*f0*f7^2 - 16*f1*f5*f8 + 16*f2*f4*f8 -
4*f3^2*f8)*z[1]*z[6]*z[10]*z[12] + (-16*f0*f6*f8 -
8*f1*f5*f8)*z[1]*z[6]*z[10]*z[13] + (8*f0*f7*f8 + 16*f1*f6*f8 +
16*f2*f5*f8)*z[1]*z[6]*z[10]*z[14] + (-12*f1*f7*f8 - 16*f2*f6*f8 + 2*f2*f7^2 -
4*f3*f5*f8)*z[1]*z[6]*z[10]*z[15] + 8*f1*f5*f8*z[1]*z[6]*z[11]^2 + (-16*f0*f7*f8 -
16*f2*f5*f8)*z[1]*z[6]*z[11]*z[12] + 16*f0*f7*f8*z[1]*z[6]*z[11]*z[13] +
(-12*f1*f7*f8 - 2*f2*f7^2 - 4*f3*f5*f8)*z[1]*z[6]*z[11]*z[14] + (16*f1*f8^2 +
16*f2*f7*f8 + 2*f3*f7^2 + 8*f4*f5*f8)*z[1]*z[6]*z[11]*z[15] -
4*f3*f8*z[1]*z[6]*z[11]*z[16] + (16*f0*f8^2 + 16*f1*f7*f8 +
12*f3*f5*f8)*z[1]*z[6]*z[12]^2 + (-4*f1*f7*f8 + 2*f2*f7^2 -
4*f3*f5*f8)*z[1]*z[6]*z[12]*z[13] + (-16*f1*f8^2 -
2*f3*f7^2)*z[1]*z[6]*z[12]*z[14] + (-16*f2*f8^2 - 12*f3*f7*f8 + 4*f4*f7^2 -
8*f5^2*f8)*z[1]*z[6]*z[12]*z[15] - 8*f4*f8*z[1]*z[6]*z[12]*z[16] -
16*f0*f8^2*z[1]*z[6]*z[13]^2 + (16*f1*f8^2 + 8*f3*f6*f8 -
2*f3*f7^2)*z[1]*z[6]*z[13]*z[14] + (-16*f2*f8^2 - 4*f3*f7*f8 - 16*f4*f6*f8 +
4*f4*f7^2)*z[1]*z[6]*z[13]*z[15] + 8*f4*f8*z[1]*z[6]*z[13]*z[16] +
4*f3*f7*f8*z[1]*z[6]*z[14]^2 + (16*f3*f8^2 - 8*f4*f7*f8 + 16*f5*f6*f8 -
4*f5*f7^2)*z[1]*z[6]*z[14]*z[15] - 8*f5*f8*z[1]*z[6]*z[14]*z[16] + (8*f5*f7*f8 -
16*f6^2*f8 + 4*f6*f7^2)*z[1]*z[6]*z[15]^2 + (16*f6*f8 -
4*f7^2)*z[1]*z[6]*z[15]*z[16] + (32*f0*f4*f6*f7*f8 - 8*f0*f4*f7^3 -
8*f0*f5^2*f7*f8 - 8*f1*f3*f6*f7*f8 + 2*f1*f3*f7^3)*z[1]*z[7]*z[9]^2 +
(16*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 4*f0*f5*f7^2 +
8*f1*f3*f7*f8)*z[1]*z[7]*z[9]*z[10] + (-32*f0*f4*f8^2 + 24*f0*f5*f7*f8 -
8*f1*f4*f7*f8 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2)*z[1]*z[7]*z[9]*z[11] +
(-16*f0*f5*f8^2 + 32*f1*f4*f8^2 - 16*f1*f5*f7*f8 - 16*f2*f3*f8^2 + 16*f2*f4*f7*f8
- 16*f2*f5*f6*f8 + 4*f2*f5*f7^2 - 8*f3^2*f7*f8 -
4*f3*f5^2*f8)*z[1]*z[7]*z[9]*z[12] + (16*f0*f5*f8^2 - 48*f0*f6*f7*f8 + 12*f0*f7^3
+ 8*f1*f5*f7*f8 - 16*f1*f6^2*f8 + 4*f1*f6*f7^2)*z[1]*z[7]*z[9]*z[13] +
(32*f0*f6*f8^2 - 8*f0*f7^2*f8 - 16*f1*f5*f8^2 + 32*f1*f6*f7*f8 - 8*f1*f7^3 -
16*f2*f5*f7*f8 + 32*f2*f6^2*f8 - 8*f2*f6*f7^2 + 16*f3^2*f8^2 + 8*f3*f5*f6*f8 -
2*f3*f5*f7^2)*z[1]*z[7]*z[9]*z[14] + (-32*f1*f6*f8^2 + 8*f1*f7^2*f8 +
32*f2*f5*f8^2 - 16*f2*f6*f7*f8 + 4*f2*f7^3 - 32*f3*f4*f8^2 + 16*f3*f5*f7*f8 -
32*f3*f6^2*f8 + 8*f3*f6*f7^2)*z[1]*z[7]*z[9]*z[15] + (-4*f2*f7*f8 + 16*f3*f6*f8 -
4*f3*f7^2)*z[1]*z[7]*z[9]*z[16] - 16*f0*f5*f8*z[1]*z[7]*z[10]^2 + (16*f0*f6*f8 -
4*f0*f7^2 + 4*f1*f5*f8)*z[1]*z[7]*z[10]*z[11] + (16*f0*f7*f8 -
8*f2*f5*f8)*z[1]*z[7]*z[10]*z[12] + (8*f0*f7*f8 + 8*f1*f6*f8 -
2*f1*f7^2)*z[1]*z[7]*z[10]*z[13] + (-32*f0*f8^2 - 8*f1*f7*f8 - 16*f2*f6*f8 +
4*f2*f7^2 - 4*f3*f5*f8)*z[1]*z[7]*z[10]*z[14] + (16*f1*f8^2 + 4*f2*f7*f8 +
16*f3*f6*f8 - 4*f3*f7^2)*z[1]*z[7]*z[10]*z[15] + (-16*f0*f7*f8 - 8*f1*f6*f8 +
2*f1*f7^2)*z[1]*z[7]*z[11]^2 + (16*f0*f8^2 + 16*f1*f7*f8 + 16*f2*f6*f8 - 4*f2*f7^2
+ 8*f3*f5*f8)*z[1]*z[7]*z[11]*z[12] + 16*f0*f8^2*z[1]*z[7]*z[11]*z[13] +
4*f2*f7*f8*z[1]*z[7]*z[11]*z[14] + (-16*f2*f8^2 - 8*f3*f7*f8 -
4*f5^2*f8)*z[1]*z[7]*z[11]*z[15] + (-16*f1*f8^2 - 16*f2*f7*f8 - 8*f3*f6*f8 +
2*f3*f7^2 - 16*f4*f5*f8)*z[1]*z[7]*z[12]^2 + (-16*f1*f8^2 -
4*f2*f7*f8)*z[1]*z[7]*z[12]*z[13] + (32*f2*f8^2 + 8*f3*f7*f8 +
16*f5^2*f8)*z[1]*z[7]*z[12]*z[14] + (8*f4*f7*f8 - 8*f5*f6*f8 -
2*f5*f7^2)*z[1]*z[7]*z[12]*z[15] + 20*f5*f8*z[1]*z[7]*z[12]*z[16] + (16*f3*f8^2 +
8*f5*f6*f8 - 2*f5*f7^2)*z[1]*z[7]*z[13]*z[15] - 4*f5*f8*z[1]*z[7]*z[13]*z[16] +
(-16*f3*f8^2 - 16*f5*f6*f8 + 4*f5*f7^2)*z[1]*z[7]*z[14]^2 + (16*f6^2*f8 -
4*f6*f7^2)*z[1]*z[7]*z[14]*z[15] + (-8*f6*f8 + 2*f7^2)*z[1]*z[7]*z[14]*z[16] +
(-8*f6*f7*f8 + 2*f7^3)*z[1]*z[7]*z[15]^2 + (-8*f0*f4*f7*f8 + 2*f0*f5*f7^2 +
2*f1*f3*f7*f8)*z[1]*z[8]*z[9]^2 + (16*f0*f5*f8 - 4*f0*f6*f7)*z[1]*z[8]*z[9]*z[10]
+ (-16*f0*f6*f8 - 8*f1*f5*f8 + 2*f1*f6*f7)*z[1]*z[8]*z[9]*z[11] + (-4*f0*f7*f8 +
8*f1*f6*f8 + 16*f2*f5*f8 - 4*f2*f6*f7 + f3*f5*f7)*z[1]*z[8]*z[9]*z[12] +
(12*f0*f7*f8 + 8*f1*f6*f8 - 3*f1*f7^2)*z[1]*z[8]*z[9]*z[13] + (-4*f1*f7*f8 -
16*f2*f6*f8 + 6*f2*f7^2 - 4*f3*f5*f8)*z[1]*z[8]*z[9]*z[14] + (-4*f2*f7*f8 +
16*f3*f6*f8 - 4*f3*f7^2)*z[1]*z[8]*z[9]*z[15] + (-6*f3*f8 +
f4*f7)*z[1]*z[8]*z[9]*z[16] + 2*f0*f7*z[1]*z[8]*z[10]^2 -
f1*f7*z[1]*z[8]*z[10]*z[11] + (-4*f1*f8 + 2*f2*f7)*z[1]*z[8]*z[10]*z[12] -
4*f1*f8*z[1]*z[8]*z[10]*z[13] + (8*f2*f8 + f3*f7)*z[1]*z[8]*z[10]*z[14] +
(-6*f3*f8 - f4*f7)*z[1]*z[8]*z[10]*z[15] + 4*f1*f8*z[1]*z[8]*z[11]^2 -
8*f2*f8*z[1]*z[8]*z[11]*z[12] + (-2*f3*f8 - f4*f7)*z[1]*z[8]*z[11]*z[14] +
(8*f4*f8 + f5*f7)*z[1]*z[8]*z[11]*z[15] + 8*f3*f8*z[1]*z[8]*z[12]^2 + (-2*f3*f8 +
f4*f7)*z[1]*z[8]*z[12]*z[13] - 4*f5*f7*z[1]*z[8]*z[12]*z[14] + (-12*f5*f8 +
6*f6*f7)*z[1]*z[8]*z[12]*z[15] - 3*f7*z[1]*z[8]*z[12]*z[16] -
4*f5*f8*z[1]*z[8]*z[13]*z[15] + f7*z[1]*z[8]*z[13]*z[16] +
8*f5*f8*z[1]*z[8]*z[14]^2 + (-8*f6*f8 - f7^2)*z[1]*z[8]*z[14]*z[15] +
6*f7*f8*z[1]*z[8]*z[15]^2 + (16*f0^2*f7*f8 + 32*f0*f2*f5*f8 -
8*f1^2*f5*f8)*z[2]^2*z[9]^2 + (-8*f0*f2*f7 + 2*f1^2*f7)*z[2]^2*z[9]*z[10] +
(-16*f0*f2*f8 + 4*f0*f3*f7 + 4*f1^2*f8)*z[2]^2*z[9]*z[11] -
2*f1*f3*f7*z[2]^2*z[9]*z[12] - 8*f0*f3*f8*z[2]^2*z[9]*z[13] +
4*f1*f3*f8*z[2]^2*z[9]*z[14] - 16*f0*f5*f8*z[2]^2*z[9]*z[15] +
2*f0*f7*z[2]^2*z[9]*z[16] + 2*f0*f7*z[2]^2*z[10]*z[15] - 4*f0*f5*z[2]^2*z[11]^2 +
(8*f0*f6 + 4*f1*f5)*z[2]^2*z[11]*z[12] - 2*f0*f7*z[2]^2*z[11]*z[14] -
2*f1*f7*z[2]^2*z[11]*z[15] + (-4*f0*f7 - 4*f1*f6 - 4*f2*f5)*z[2]^2*z[12]^2 -
2*f0*f7*z[2]^2*z[12]*z[13] + 2*f1*f7*z[2]^2*z[12]*z[14] + (4*f1*f8 +
4*f2*f7)*z[2]^2*z[12]*z[15] + 2*f3*z[2]^2*z[12]*z[16] + 4*f1*f8*z[2]^2*z[13]*z[15]
- 8*f2*f8*z[2]^2*z[14]*z[15] + (-32*f0^2*f8^2 - 16*f0*f1*f7*f8 - 32*f0*f2*f6*f8 +
8*f0*f2*f7^2 - 24*f0*f3*f5*f8 + 8*f1^2*f6*f8 - 2*f1^2*f7^2)*z[2]*z[3]*z[9]^2 +
(16*f0*f2*f8 + 4*f0*f3*f7 - 4*f1^2*f8)*z[2]*z[3]*z[9]*z[10] + (16*f0*f3*f8 -
8*f0*f4*f7)*z[2]*z[3]*z[9]*z[11] + 4*f1*f4*f7*z[2]*z[3]*z[9]*z[12] +
16*f0*f4*f8*z[2]*z[3]*z[9]*z[13] + (16*f0*f5*f8 - 8*f1*f4*f8)*z[2]*z[3]*z[9]*z[14]
+ (16*f0*f6*f8 - 4*f0*f7^2 + 4*f1*f5*f8)*z[2]*z[3]*z[9]*z[15] -
f1*f7*z[2]*z[3]*z[9]*z[16] + 8*f0*f5*z[2]*z[3]*z[10]*z[11] + (-8*f0*f6 -
4*f1*f5)*z[2]*z[3]*z[10]*z[12] + f1*f7*z[2]*z[3]*z[10]*z[15] + (-4*f0*f7 -
4*f1*f6)*z[2]*z[3]*z[11]*z[12] + 4*f0*f7*z[2]*z[3]*z[11]*z[13] +
f1*f7*z[2]*z[3]*z[11]*z[14] + (8*f0*f8 + 6*f1*f7 + 8*f2*f6 +
2*f3*f5)*z[2]*z[3]*z[12]^2 - f1*f7*z[2]*z[3]*z[12]*z[13] + (-4*f1*f8 -
4*f2*f7)*z[2]*z[3]*z[12]*z[14] + (-8*f2*f8 - 4*f3*f7)*z[2]*z[3]*z[12]*z[15] -
4*f4*z[2]*z[3]*z[12]*z[16] - 8*f0*f8*z[2]*z[3]*z[13]^2 +
4*f1*f8*z[2]*z[3]*z[13]*z[14] + 8*f3*f8*z[2]*z[3]*z[14]*z[15] +
2*z[2]*z[3]*z[16]^2 + (16*f0*f1*f8^2 - 32*f0*f2*f7*f8 + 16*f0*f3*f6*f8 -
4*f0*f3*f7^2 + 16*f1^2*f7*f8 + 12*f1*f3*f5*f8)*z[2]*z[4]*z[9]^2 -
2*f1*f3*f7*z[2]*z[4]*z[9]*z[10] + (-12*f1*f3*f8 + 4*f1*f4*f7)*z[2]*z[4]*z[9]*z[11]
+ (8*f2*f3*f8 - 8*f2*f4*f7 + 2*f3^2*f7)*z[2]*z[4]*z[9]*z[12] + (16*f0*f5*f8 -
8*f1*f4*f8)*z[2]*z[4]*z[9]*z[13] + (-16*f0*f6*f8 + 4*f0*f7^2 - 16*f1*f5*f8 +
16*f2*f4*f8 - 4*f3^2*f8)*z[2]*z[4]*z[9]*z[14] + (16*f0*f7*f8 -
8*f2*f5*f8)*z[2]*z[4]*z[9]*z[15] + (-4*f1*f8 + 2*f2*f7)*z[2]*z[4]*z[9]*z[16] +
(-8*f0*f6 - 4*f1*f5)*z[2]*z[4]*z[10]*z[11] + (4*f0*f7 + 8*f1*f6 +
8*f2*f5)*z[2]*z[4]*z[10]*z[12] + (-4*f1*f8 - 2*f2*f7)*z[2]*z[4]*z[10]*z[15] -
2*f3*z[2]*z[4]*z[10]*z[16] + (8*f0*f7 + 4*f1*f6)*z[2]*z[4]*z[11]^2 + (-8*f0*f8 -
8*f1*f7 - 8*f2*f6 - 2*f3*f5)*z[2]*z[4]*z[11]*z[12] + (-8*f0*f8 -
4*f1*f7)*z[2]*z[4]*z[11]*z[13] + (4*f1*f8 + 2*f2*f7)*z[2]*z[4]*z[11]*z[14] +
(8*f2*f8 + 2*f3*f7)*z[2]*z[4]*z[11]*z[15] + 4*f4*z[2]*z[4]*z[11]*z[16] + (4*f1*f8
+ 6*f2*f7)*z[2]*z[4]*z[12]*z[13] - 2*f3*f7*z[2]*z[4]*z[12]*z[14] + (-4*f3*f8 +
4*f4*f7)*z[2]*z[4]*z[12]*z[15] - 4*f5*z[2]*z[4]*z[12]*z[16] +
4*f1*f8*z[2]*z[4]*z[13]^2 - 8*f2*f8*z[2]*z[4]*z[13]*z[14] -
4*f3*f8*z[2]*z[4]*z[13]*z[15] + 4*f3*f8*z[2]*z[4]*z[14]^2 -
8*f4*f8*z[2]*z[4]*z[14]*z[15] + 4*f5*f8*z[2]*z[4]*z[15]^2 +
16*f0*f1*f8^2*z[2]*z[5]*z[9]^2 + 8*f0*f3*f8*z[2]*z[5]*z[9]*z[10] + (-16*f0*f4*f8 -
4*f0*f5*f7)*z[2]*z[5]*z[9]*z[11] + (-16*f0*f5*f8 + 8*f0*f6*f7 + 8*f1*f4*f8 +
2*f1*f5*f7)*z[2]*z[5]*z[9]*z[12] + 16*f0*f5*f8*z[2]*z[5]*z[9]*z[13] +
(-16*f0*f6*f8 - 8*f1*f5*f8)*z[2]*z[5]*z[9]*z[14] + (8*f0*f7*f8 + 8*f1*f6*f8 -
2*f1*f7^2)*z[2]*z[5]*z[9]*z[15] - 4*f1*f8*z[2]*z[5]*z[9]*z[16] -
4*f0*f7*z[2]*z[5]*z[10]*z[13] + 2*f1*f7*z[2]*z[5]*z[10]*z[14] -
4*f1*f8*z[2]*z[5]*z[10]*z[15] + (8*f0*f8 + 2*f1*f7)*z[2]*z[5]*z[11]*z[12] +
8*f0*f8*z[2]*z[5]*z[11]*z[13] - 4*f1*f8*z[2]*z[5]*z[11]*z[14] + (-4*f1*f8 -
4*f2*f7)*z[2]*z[5]*z[12]^2 - 4*f1*f8*z[2]*z[5]*z[12]*z[13] + (8*f2*f8 -
2*f3*f7)*z[2]*z[5]*z[12]*z[14] + 4*f4*f7*z[2]*z[5]*z[12]*z[15] +
4*f3*f8*z[2]*z[5]*z[14]^2 - 8*f4*f8*z[2]*z[5]*z[14]*z[15] +
4*f5*f8*z[2]*z[5]*z[15]^2 - 2*f7*z[2]*z[5]*z[15]*z[16] + (32*f0*f2*f8^2 +
8*f0*f3*f7*f8 - 16*f1^2*f8^2)*z[2]*z[6]*z[9]^2 - 4*f1*f3*f8*z[2]*z[6]*z[9]*z[10] +
(-16*f0*f5*f8 + 8*f0*f6*f7 + 8*f1*f4*f8 + 2*f1*f5*f7)*z[2]*z[6]*z[9]*z[11] +
(16*f0*f6*f8 - 8*f0*f7^2 + 16*f1*f5*f8 - 8*f1*f6*f7 - 16*f2*f4*f8 -
4*f2*f5*f7)*z[2]*z[6]*z[9]*z[12] + (-16*f0*f6*f8 -
8*f1*f5*f8)*z[2]*z[6]*z[9]*z[13] + (8*f0*f7*f8 + 16*f1*f6*f8 +
16*f2*f5*f8)*z[2]*z[6]*z[9]*z[14] + (-32*f0*f8^2 - 8*f1*f7*f8 - 16*f2*f6*f8 +
4*f2*f7^2 - 4*f3*f5*f8)*z[2]*z[6]*z[9]*z[15] + (8*f2*f8 +
f3*f7)*z[2]*z[6]*z[9]*z[16] + 2*f1*f7*z[2]*z[6]*z[10]*z[13] -
4*f2*f7*z[2]*z[6]*z[10]*z[14] + (8*f2*f8 + f3*f7)*z[2]*z[6]*z[10]*z[15] -
2*f1*f7*z[2]*z[6]*z[11]^2 + 4*f2*f7*z[2]*z[6]*z[11]*z[12] +
f3*f7*z[2]*z[6]*z[11]*z[14] - 4*f4*f7*z[2]*z[6]*z[11]*z[15] +
f3*f7*z[2]*z[6]*z[12]*z[13] - 4*f3*f8*z[2]*z[6]*z[12]*z[14] + (8*f4*f8 +
2*f5*f7)*z[2]*z[6]*z[12]*z[15] - 4*f3*f8*z[2]*z[6]*z[13]*z[14] +
8*f4*f8*z[2]*z[6]*z[13]*z[15] - 8*f5*f8*z[2]*z[6]*z[14]*z[15] +
2*f7*z[2]*z[6]*z[14]*z[16] + (8*f6*f8 - 2*f7^2)*z[2]*z[6]*z[15]^2 -
8*f8*z[2]*z[6]*z[15]*z[16] + (-16*f0*f3*f8^2 - 8*f0*f4*f7*f8 + 2*f0*f5*f7^2 -
2*f1*f3*f7*f8)*z[2]*z[7]*z[9]^2 + (16*f0*f5*f8 - 4*f0*f6*f7)*z[2]*z[7]*z[9]*z[10]
+ (-8*f0*f7^2 - 2*f1*f6*f7)*z[2]*z[7]*z[9]*z[11] + (-4*f0*f7*f8 - 8*f1*f6*f8 +
8*f1*f7^2 + 4*f2*f6*f7 + 8*f3*f4*f8 + f3*f5*f7)*z[2]*z[7]*z[9]*z[12] +
(20*f0*f7*f8 + 8*f1*f6*f8 - f1*f7^2)*z[2]*z[7]*z[9]*z[13] + (-12*f1*f7*f8 -
16*f2*f6*f8 + 2*f2*f7^2 - 4*f3*f5*f8)*z[2]*z[7]*z[9]*z[14] + (16*f1*f8^2 +
4*f2*f7*f8 + 16*f3*f6*f8 - 4*f3*f7^2)*z[2]*z[7]*z[9]*z[15] + (-6*f3*f8 -
f4*f7)*z[2]*z[7]*z[9]*z[16] + 2*f0*f7*z[2]*z[7]*z[10]^2 +
f1*f7*z[2]*z[7]*z[10]*z[11] + (-4*f1*f8 - 2*f2*f7)*z[2]*z[7]*z[10]*z[12] -
4*f1*f8*z[2]*z[7]*z[10]*z[13] + (8*f2*f8 + f3*f7)*z[2]*z[7]*z[10]*z[14] +
(-6*f3*f8 + f4*f7)*z[2]*z[7]*z[10]*z[15] + (-2*f3*f8 +
f4*f7)*z[2]*z[7]*z[11]*z[14] + f5*f7*z[2]*z[7]*z[11]*z[15] +
4*f3*f8*z[2]*z[7]*z[12]^2 + (-2*f3*f8 - f4*f7)*z[2]*z[7]*z[12]*z[13] -
4*f5*f7*z[2]*z[7]*z[12]*z[14] + (-4*f5*f8 + 2*f6*f7)*z[2]*z[7]*z[12]*z[15] -
f7*z[2]*z[7]*z[12]*z[16] - 4*f5*f8*z[2]*z[7]*z[13]*z[15] +
f7*z[2]*z[7]*z[13]*z[16] + 8*f5*f8*z[2]*z[7]*z[14]^2 + (-8*f6*f8 +
f7^2)*z[2]*z[7]*z[14]*z[15] + 2*f7*f8*z[2]*z[7]*z[15]^2 -
16*f0*f5*f8*z[2]*z[8]*z[9]^2 + 4*f0*f7*z[2]*z[8]*z[9]*z[10] +
8*f0*f8*z[2]*z[8]*z[9]*z[11] - 2*f3*z[2]*z[8]*z[10]*z[12] -
2*z[2]*z[8]*z[11]*z[16] + 4*f5*z[2]*z[8]*z[12]^2 - 4*f7*z[2]*z[8]*z[12]*z[15] +
8*f8*z[2]*z[8]*z[14]*z[15] + (16*f0*f1*f8^2 + 16*f0*f2*f7*f8 + 16*f0*f3*f6*f8 -
4*f0*f3*f7^2 + 16*f0*f4*f5*f8)*z[3]^2*z[9]^2 - 16*f0*f3*f8*z[3]^2*z[9]*z[10] +
4*f0*f5*f7*z[3]^2*z[9]*z[11] + (-8*f1*f4*f8 - 2*f1*f5*f7)*z[3]^2*z[9]*z[12] -
24*f0*f5*f8*z[3]^2*z[9]*z[13] + 8*f1*f5*f8*z[3]^2*z[9]*z[14] + (-16*f0*f7*f8 -
8*f1*f6*f8 + 2*f1*f7^2)*z[3]^2*z[9]*z[15] + 4*f1*f8*z[3]^2*z[9]*z[16] -
4*f0*f5*z[3]^2*z[10]^2 + (8*f0*f7 + 4*f1*f6)*z[3]^2*z[10]*z[12] -
2*f1*f7*z[3]^2*z[10]*z[14] - 4*f0*f7*z[3]^2*z[11]^2 + 2*f1*f7*z[3]^2*z[11]*z[12] +
(-4*f1*f8 - 4*f2*f7 - 4*f3*f6)*z[3]^2*z[12]^2 + 4*f1*f8*z[3]^2*z[12]*z[13] +
4*f3*f7*z[3]^2*z[12]*z[14] + 8*f3*f8*z[3]^2*z[12]*z[15] + 2*f5*z[3]^2*z[12]*z[16]
- 4*f3*f8*z[3]^2*z[14]^2 - 4*f5*f8*z[3]^2*z[15]^2 + (16*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 8*f0*f4*f7^2 - 16*f1^2*f8^2 - 16*f1*f2*f7*f8 - 8*f1*f3*f6*f8 +
2*f1*f3*f7^2 - 16*f1*f4*f5*f8)*z[3]*z[4]*z[9]^2 + (-4*f0*f5*f7 +
12*f1*f3*f8)*z[3]*z[4]*z[9]*z[10] + (8*f1*f4*f8 - 2*f1*f5*f7)*z[3]*z[4]*z[9]*z[11]
+ (16*f2*f4*f8 + 4*f2*f5*f7 - 8*f3^2*f8)*z[3]*z[4]*z[9]*z[12] + (16*f0*f6*f8 -
4*f0*f7^2 + 16*f1*f5*f8)*z[3]*z[4]*z[9]*z[13] + (-16*f0*f7*f8 -
16*f2*f5*f8)*z[3]*z[4]*z[9]*z[14] + (16*f0*f8^2 + 16*f1*f7*f8 + 16*f2*f6*f8 -
4*f2*f7^2 + 8*f3*f5*f8)*z[3]*z[4]*z[9]*z[15] - 8*f2*f8*z[3]*z[4]*z[9]*z[16] +
(8*f0*f6 + 4*f1*f5)*z[3]*z[4]*z[10]^2 + (-4*f0*f7 - 4*f1*f6)*z[3]*z[4]*z[10]*z[11]
+ (-8*f0*f8 - 8*f1*f7 - 8*f2*f6 - 2*f3*f5)*z[3]*z[4]*z[10]*z[12] + (8*f0*f8 +
2*f1*f7)*z[3]*z[4]*z[10]*z[13] + 4*f2*f7*z[3]*z[4]*z[10]*z[14] +
2*f1*f7*z[3]*z[4]*z[11]^2 + (8*f1*f8 + 4*f2*f7 + 8*f3*f6)*z[3]*z[4]*z[11]*z[12] -
4*f1*f8*z[3]*z[4]*z[11]*z[13] - 4*f3*f7*z[3]*z[4]*z[11]*z[14] -
8*f3*f8*z[3]*z[4]*z[11]*z[15] - 2*f5*z[3]*z[4]*z[11]*z[16] +
2*f3*f7*z[3]*z[4]*z[12]^2 + (-8*f2*f8 - 4*f3*f7)*z[3]*z[4]*z[12]*z[13] +
4*f3*f8*z[3]*z[4]*z[12]*z[14] + (-8*f4*f8 - 2*f5*f7)*z[3]*z[4]*z[12]*z[15] +
4*f6*z[3]*z[4]*z[12]*z[16] + 8*f3*f8*z[3]*z[4]*z[13]*z[14] +
8*f5*f8*z[3]*z[4]*z[14]*z[15] - 2*f7*z[3]*z[4]*z[14]*z[16] + (-8*f6*f8 +
2*f7^2)*z[3]*z[4]*z[15]^2 + 4*f8*z[3]*z[4]*z[15]*z[16] + (-32*f0*f2*f8^2 -
8*f0*f3*f7*f8 - 16*f0*f5^2*f8)*z[3]*z[5]*z[9]^2 + 8*f0*f5*f7*z[3]*z[5]*z[9]*z[10]
+ (24*f0*f5*f8 - 8*f0*f6*f7)*z[3]*z[5]*z[9]*z[11] - 8*f0*f7^2*z[3]*z[5]*z[9]*z[12]
+ 4*f0*f7^2*z[3]*z[5]*z[9]*z[13] + 16*f0*f7*f8*z[3]*z[5]*z[9]*z[14] +
16*f0*f8^2*z[3]*z[5]*z[9]*z[15] + 4*f0*f7*z[3]*z[5]*z[10]*z[11] + (-8*f0*f8 -
4*f1*f7)*z[3]*z[5]*z[10]*z[12] + 8*f0*f8*z[3]*z[5]*z[10]*z[13] -
4*f1*f8*z[3]*z[5]*z[11]*z[12] + (8*f2*f8 + 4*f3*f7)*z[3]*z[5]*z[12]^2 -
4*f3*f8*z[3]*z[5]*z[12]*z[14] + (-8*f4*f8 - 2*f5*f7)*z[3]*z[5]*z[12]*z[15] +
8*f5*f8*z[3]*z[5]*z[14]*z[15] - 2*f7*z[3]*z[5]*z[14]*z[16] +
4*f8*z[3]*z[5]*z[15]*z[16] + (-16*f0*f3*f8^2 - 8*f0*f4*f7*f8 + 16*f0*f5*f6*f8 -
2*f0*f5*f7^2 + 16*f1*f2*f8^2 + 2*f1*f3*f7*f8 + 8*f1*f5^2*f8)*z[3]*z[6]*z[9]^2 +
(-4*f0*f6*f7 - 4*f1*f5*f7)*z[3]*z[6]*z[9]*z[10] + (-8*f1*f5*f8 +
2*f1*f6*f7)*z[3]*z[6]*z[9]*z[11] + (12*f0*f7*f8 - 8*f1*f6*f8 + 8*f1*f7^2 -
8*f2*f5*f8 + 4*f2*f6*f7 + 8*f3*f4*f8 + f3*f5*f7)*z[3]*z[6]*z[9]*z[12] +
(4*f0*f7*f8 - f1*f7^2)*z[3]*z[6]*z[9]*z[13] + (-12*f1*f7*f8 - 2*f2*f7^2 -
4*f3*f5*f8)*z[3]*z[6]*z[9]*z[14] + 4*f2*f7*f8*z[3]*z[6]*z[9]*z[15] + (-2*f3*f8 -
f4*f7)*z[3]*z[6]*z[9]*z[16] - 2*f0*f7*z[3]*z[6]*z[10]^2 +
f1*f7*z[3]*z[6]*z[10]*z[11] + (4*f1*f8 + 2*f2*f7)*z[3]*z[6]*z[10]*z[12] -
4*f1*f8*z[3]*z[6]*z[10]*z[13] + f3*f7*z[3]*z[6]*z[10]*z[14] + (-2*f3*f8 +
f4*f7)*z[3]*z[6]*z[10]*z[15] - 4*f3*f7*z[3]*z[6]*z[11]*z[12] + (2*f3*f8 +
f4*f7)*z[3]*z[6]*z[11]*z[14] + f5*f7*z[3]*z[6]*z[11]*z[15] -
4*f3*f8*z[3]*z[6]*z[12]^2 + (2*f3*f8 - f4*f7)*z[3]*z[6]*z[12]*z[13] + (4*f5*f8 -
2*f6*f7)*z[3]*z[6]*z[12]*z[15] - f7*z[3]*z[6]*z[12]*z[16] -
4*f5*f8*z[3]*z[6]*z[13]*z[15] + f7*z[3]*z[6]*z[13]*z[16] +
f7^2*z[3]*z[6]*z[14]*z[15] - 2*f7*f8*z[3]*z[6]*z[15]^2 + (32*f0*f4*f8^2 -
8*f0*f5*f7*f8 + 8*f1*f4*f7*f8 - 8*f1*f5*f6*f8)*z[3]*z[7]*z[9]^2 + (-16*f0*f6*f8 +
8*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7)*z[3]*z[7]*z[9]*z[10] + (8*f0*f7*f8 +
8*f1*f6*f8)*z[3]*z[7]*z[9]*z[11] + (-8*f1*f7*f8 - 8*f2*f7^2 + 8*f3*f5*f8 -
4*f3*f6*f7 - 16*f4^2*f8)*z[3]*z[7]*z[9]*z[12] + (-32*f0*f8^2 -
8*f1*f7*f8)*z[3]*z[7]*z[9]*z[13] + (16*f1*f8^2 + 16*f2*f7*f8 + 2*f3*f7^2 +
8*f4*f5*f8)*z[3]*z[7]*z[9]*z[14] + (-16*f2*f8^2 - 8*f3*f7*f8 -
4*f5^2*f8)*z[3]*z[7]*z[9]*z[15] + (8*f4*f8 + f5*f7)*z[3]*z[7]*z[9]*z[16] -
2*f1*f7*z[3]*z[7]*z[10]^2 + (8*f2*f8 + 2*f3*f7)*z[3]*z[7]*z[10]*z[12] -
4*f4*f7*z[3]*z[7]*z[10]*z[14] + f5*f7*z[3]*z[7]*z[10]*z[15] -
8*f3*f8*z[3]*z[7]*z[11]*z[12] + f5*f7*z[3]*z[7]*z[11]*z[14] + (8*f5*f8 -
4*f6*f7)*z[3]*z[7]*z[11]*z[15] + 2*f7*z[3]*z[7]*z[11]*z[16] +
8*f4*f8*z[3]*z[7]*z[12]^2 + (8*f4*f8 + f5*f7)*z[3]*z[7]*z[12]*z[13] + (-12*f5*f8 +
4*f6*f7)*z[3]*z[7]*z[12]*z[14] + 8*f6*f8*z[3]*z[7]*z[12]*z[15] -
8*f8*z[3]*z[7]*z[12]*z[16] - 4*f5*f8*z[3]*z[7]*z[13]*z[14] +
2*f7^2*z[3]*z[7]*z[13]*z[15] - 2*f7^2*z[3]*z[7]*z[14]^2 + (16*f0*f6*f8 - 4*f0*f7^2
+ 8*f1*f5*f8)*z[3]*z[8]*z[9]^2 + (-8*f0*f8 - 2*f1*f7)*z[3]*z[8]*z[9]*z[10] -
4*f1*f8*z[3]*z[8]*z[9]*z[11] + 2*f3*f7*z[3]*z[8]*z[9]*z[12] -
4*f3*f8*z[3]*z[8]*z[9]*z[14] + 4*f4*z[3]*z[8]*z[10]*z[12] -
2*z[3]*z[8]*z[10]*z[16] - 2*f5*z[3]*z[8]*z[11]*z[12] + 2*f7*z[3]*z[8]*z[11]*z[15]
- 4*f6*z[3]*z[8]*z[12]^2 + 2*f7*z[3]*z[8]*z[12]*z[14] + 4*f8*z[3]*z[8]*z[12]*z[15]
- 4*f8*z[3]*z[8]*z[13]*z[15] + (-16*f0*f3*f8^2 + 16*f0*f4*f7*f8 + 16*f1*f2*f8^2 -
16*f1*f3*f7*f8 + 16*f1*f4*f6*f8 - 4*f1*f4*f7^2 + 16*f2^2*f7*f8 + 16*f2*f4*f5*f8 -
4*f3^2*f5*f8)*z[4]^2*z[9]^2 + (2*f1*f5*f7 - 8*f2*f3*f8)*z[4]^2*z[9]*z[10] +
(-16*f2*f4*f8 + 8*f3^2*f8)*z[4]^2*z[9]*z[11] - 2*f3*f5*f7*z[4]^2*z[9]*z[12] +
(-16*f0*f7*f8 - 8*f1*f6*f8 + 2*f1*f7^2 - 8*f2*f5*f8)*z[4]^2*z[9]*z[13] +
(16*f0*f8^2 + 16*f1*f7*f8 + 12*f3*f5*f8)*z[4]^2*z[9]*z[14] + (-16*f1*f8^2 -
16*f2*f7*f8 - 8*f3*f6*f8 + 2*f3*f7^2 - 16*f4*f5*f8)*z[4]^2*z[9]*z[15] +
8*f3*f8*z[4]^2*z[9]*z[16] + (-4*f0*f7 - 4*f1*f6 - 4*f2*f5)*z[4]^2*z[10]^2 +
(8*f0*f8 + 6*f1*f7 + 8*f2*f6 + 2*f3*f5)*z[4]^2*z[10]*z[11] + (-4*f1*f8 -
4*f2*f7)*z[4]^2*z[10]*z[13] + 4*f3*f8*z[4]^2*z[10]*z[15] + 4*f5*z[4]^2*z[10]*z[16]
+ (-4*f1*f8 - 4*f2*f7 - 4*f3*f6)*z[4]^2*z[11]^2 + 2*f3*f7*z[4]^2*z[11]*z[12] +
(8*f2*f8 + 4*f3*f7)*z[4]^2*z[11]*z[13] - 4*f3*f8*z[4]^2*z[11]*z[14] +
8*f4*f8*z[4]^2*z[11]*z[15] - 4*f6*z[4]^2*z[11]*z[16] - 4*f4*f7*z[4]^2*z[12]^2 +
2*f5*f7*z[4]^2*z[12]*z[14] + 2*f7*z[4]^2*z[12]*z[16] - 4*f3*f8*z[4]^2*z[13]^2 +
4*f5*f8*z[4]^2*z[13]*z[15] + 2*f7*z[4]^2*z[13]*z[16] - 8*f5*f8*z[4]^2*z[14]^2 +
(8*f6*f8 - 2*f7^2)*z[4]^2*z[14]*z[15] - 4*f8*z[4]^2*z[14]*z[16] + (-8*f0*f4*f7*f8
+ 16*f0*f5*f6*f8 - 2*f0*f5*f7^2 + 16*f1*f2*f8^2 + 6*f1*f3*f7*f8 +
8*f1*f5^2*f8)*z[4]*z[5]*z[9]^2 + (-4*f0*f6*f7 - 4*f1*f5*f7)*z[4]*z[5]*z[9]*z[10] +
(-16*f0*f6*f8 + 8*f0*f7^2 - 16*f1*f5*f8 + 6*f1*f6*f7)*z[4]*z[5]*z[9]*z[11] +
(12*f0*f7*f8 + 8*f1*f6*f8 + 8*f2*f5*f8 - 4*f2*f6*f7 +
f3*f5*f7)*z[4]*z[5]*z[9]*z[12] + (-4*f0*f7*f8 - 3*f1*f7^2)*z[4]*z[5]*z[9]*z[13] +
(-4*f1*f7*f8 + 2*f2*f7^2 - 4*f3*f5*f8)*z[4]*z[5]*z[9]*z[14] + (-16*f1*f8^2 -
4*f2*f7*f8)*z[4]*z[5]*z[9]*z[15] + (-2*f3*f8 + f4*f7)*z[4]*z[5]*z[9]*z[16] -
2*f0*f7*z[4]*z[5]*z[10]^2 - f1*f7*z[4]*z[5]*z[10]*z[11] + (4*f1*f8 +
6*f2*f7)*z[4]*z[5]*z[10]*z[12] - 4*f1*f8*z[4]*z[5]*z[10]*z[13] +
f3*f7*z[4]*z[5]*z[10]*z[14] + (-2*f3*f8 - f4*f7)*z[4]*z[5]*z[10]*z[15] +
4*f1*f8*z[4]*z[5]*z[11]^2 + (-8*f2*f8 - 4*f3*f7)*z[4]*z[5]*z[11]*z[12] + (2*f3*f8
- f4*f7)*z[4]*z[5]*z[11]*z[14] + (8*f4*f8 + f5*f7)*z[4]*z[5]*z[11]*z[15] +
(2*f3*f8 + f4*f7)*z[4]*z[5]*z[12]*z[13] + (-4*f5*f8 +
2*f6*f7)*z[4]*z[5]*z[12]*z[15] - 3*f7*z[4]*z[5]*z[12]*z[16] -
4*f5*f8*z[4]*z[5]*z[13]*z[15] + f7*z[4]*z[5]*z[13]*z[16] -
f7^2*z[4]*z[5]*z[14]*z[15] + 2*f7*f8*z[4]*z[5]*z[15]^2 + (-16*f0*f5*f7*f8 +
16*f1*f3*f8^2 + 8*f1*f4*f7*f8 - 16*f1*f5*f6*f8 + 2*f1*f5*f7^2 - 32*f2^2*f8^2 -
8*f2*f3*f7*f8 - 16*f2*f5^2*f8)*z[4]*z[6]*z[9]^2 + (8*f0*f7^2 + 4*f1*f6*f7 +
8*f2*f5*f7 + 4*f3^2*f8)*z[4]*z[6]*z[9]*z[10] + (8*f0*f7*f8 + 8*f1*f6*f8 -
8*f1*f7^2 + 24*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 -
2*f3*f5*f7)*z[4]*z[6]*z[9]*z[11] + (-16*f0*f8^2 - 16*f1*f7*f8 - 12*f3*f5*f8 +
4*f3*f6*f7)*z[4]*z[6]*z[9]*z[12] + (16*f0*f8^2 + 8*f1*f7*f8 + 4*f2*f7^2 +
8*f3*f5*f8)*z[4]*z[6]*z[9]*z[13] + (-16*f1*f8^2 - 2*f3*f7^2)*z[4]*z[6]*z[9]*z[14]
+ (32*f2*f8^2 + 8*f3*f7*f8 + 16*f5^2*f8)*z[4]*z[6]*z[9]*z[15] -
4*f5*f7*z[4]*z[6]*z[9]*z[16] + 2*f1*f7*z[4]*z[6]*z[10]^2 + (-4*f1*f8 -
4*f2*f7)*z[4]*z[6]*z[10]*z[11] - 2*f3*f7*z[4]*z[6]*z[10]*z[12] + (8*f2*f8 -
2*f3*f7)*z[4]*z[6]*z[10]*z[13] - 4*f3*f8*z[4]*z[6]*z[10]*z[14] -
4*f5*f7*z[4]*z[6]*z[10]*z[15] + 4*f3*f7*z[4]*z[6]*z[11]^2 +
4*f3*f8*z[4]*z[6]*z[11]*z[12] - 4*f3*f8*z[4]*z[6]*z[11]*z[13] + (-12*f5*f8 +
4*f6*f7)*z[4]*z[6]*z[11]*z[15] + 2*f7*z[4]*z[6]*z[11]*z[16] +
2*f5*f7*z[4]*z[6]*z[12]^2 + (16*f5*f8 - 4*f6*f7)*z[4]*z[6]*z[12]*z[14] -
8*f6*f8*z[4]*z[6]*z[12]*z[15] + 4*f8*z[4]*z[6]*z[12]*z[16] -
2*f7^2*z[4]*z[6]*z[13]*z[15] - 4*f8*z[4]*z[6]*z[13]*z[16] +
2*f7^2*z[4]*z[6]*z[14]^2 + (16*f0*f5*f8^2 - 32*f1*f4*f8^2 + 12*f1*f5*f7*f8 +
16*f2*f3*f8^2 - 16*f2*f4*f7*f8 + 16*f2*f5*f6*f8 + 8*f3^2*f7*f8 +
4*f3*f5^2*f8)*z[4]*z[7]*z[9]^2 + (-8*f0*f7*f8 + 8*f1*f6*f8 - 8*f1*f7^2 +
8*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[4]*z[7]*z[9]*z[10] +
(-16*f0*f8^2 - 4*f1*f7*f8 - 16*f2*f6*f8 + 8*f2*f7^2 - 16*f3*f5*f8 + 8*f3*f6*f7 +
16*f4^2*f8)*z[4]*z[7]*z[9]*z[11] + (16*f1*f8^2 + 16*f2*f7*f8 + 8*f3*f6*f8 +
16*f4*f5*f8 - 8*f4*f6*f7 + 2*f5^2*f7)*z[4]*z[7]*z[9]*z[12] + (16*f1*f8^2 -
4*f3*f7^2 - 8*f4*f5*f8)*z[4]*z[7]*z[9]*z[13] + (-16*f2*f8^2 - 12*f3*f7*f8 +
4*f4*f7^2 - 8*f5^2*f8)*z[4]*z[7]*z[9]*z[14] + (8*f4*f7*f8 - 8*f5*f6*f8 -
2*f5*f7^2)*z[4]*z[7]*z[9]*z[15] + (-12*f5*f8 + 6*f6*f7)*z[4]*z[7]*z[9]*z[16] +
(4*f1*f8 + 4*f2*f7)*z[4]*z[7]*z[10]^2 + (-8*f2*f8 - 4*f3*f7)*z[4]*z[7]*z[10]*z[11]
+ (-4*f3*f8 + 4*f4*f7)*z[4]*z[7]*z[10]*z[12] + 4*f4*f7*z[4]*z[7]*z[10]*z[13] +
(8*f4*f8 + 2*f5*f7)*z[4]*z[7]*z[10]*z[14] + (-4*f5*f8 +
2*f6*f7)*z[4]*z[7]*z[10]*z[15] - 4*f7*z[4]*z[7]*z[10]*z[16] +
8*f3*f8*z[4]*z[7]*z[11]^2 + (-8*f4*f8 - 2*f5*f7)*z[4]*z[7]*z[11]*z[12] + (-8*f4*f8
- 2*f5*f7)*z[4]*z[7]*z[11]*z[13] + (4*f5*f8 - 2*f6*f7)*z[4]*z[7]*z[11]*z[14] +
8*f6*f8*z[4]*z[7]*z[11]*z[15] + 4*f8*z[4]*z[7]*z[11]*z[16] + (-4*f5*f8 +
2*f6*f7)*z[4]*z[7]*z[12]*z[13] - 8*f6*f8*z[4]*z[7]*z[12]*z[14] -
4*f7*f8*z[4]*z[7]*z[12]*z[15] + 4*f5*f8*z[4]*z[7]*z[13]^2 -
4*f7*f8*z[4]*z[7]*z[13]*z[15] + 4*f7*f8*z[4]*z[7]*z[14]^2 + (-8*f1*f6*f8 +
2*f1*f7^2 - 16*f2*f5*f8)*z[4]*z[8]*z[9]^2 + (4*f1*f8 +
4*f2*f7)*z[4]*z[8]*z[9]*z[10] + (8*f2*f8 - 4*f3*f7)*z[4]*z[8]*z[9]*z[11] +
(-8*f3*f8 + 4*f4*f7)*z[4]*z[8]*z[9]*z[12] + 8*f3*f8*z[4]*z[8]*z[9]*z[13] -
8*f4*f8*z[4]*z[8]*z[9]*z[14] + 20*f5*f8*z[4]*z[8]*z[9]*z[15] -
3*f7*z[4]*z[8]*z[9]*z[16] + 2*f3*z[4]*z[8]*z[10]^2 - 4*f4*z[4]*z[8]*z[10]*z[11] -
4*f5*z[4]*z[8]*z[10]*z[12] - f7*z[4]*z[8]*z[10]*z[15] + 2*f5*z[4]*z[8]*z[11]^2 +
4*f6*z[4]*z[8]*z[11]*z[12] - f7*z[4]*z[8]*z[11]*z[14] - 8*f8*z[4]*z[8]*z[11]*z[15]
+ 2*f7*z[4]*z[8]*z[12]^2 - 3*f7*z[4]*z[8]*z[12]*z[13] + 4*f8*z[4]*z[8]*z[12]*z[14]
+ 4*f8*z[4]*z[8]*z[13]*z[14] + (16*f0*f3*f8^2 + 16*f0*f5*f6*f8 -
4*f0*f5*f7^2)*z[5]^2*z[9]^2 - 16*f0*f5*f8*z[5]^2*z[9]*z[10] +
4*f0*f7^2*z[5]^2*z[9]*z[11] + 8*f0*f7*f8*z[5]^2*z[9]*z[12] -
8*f0*f7*f8*z[5]^2*z[9]*z[13] - 16*f0*f8^2*z[5]^2*z[9]*z[14] -
8*f0*f8*z[5]^2*z[10]*z[11] + 4*f1*f8*z[5]^2*z[10]*z[12] - 4*f3*f8*z[5]^2*z[12]^2 +
4*f5*f8*z[5]^2*z[12]*z[15] + (-8*f6*f8 + 2*f7^2)*z[5]^2*z[14]*z[15] +
4*f8*z[5]^2*z[14]*z[16] + (8*f0*f5*f7*f8 - 32*f0*f6^2*f8 + 8*f0*f6*f7^2 -
16*f1*f3*f8^2 - 16*f1*f5*f6*f8 + 4*f1*f5*f7^2)*z[5]*z[6]*z[9]^2 + (32*f0*f6*f8 -
4*f0*f7^2 + 16*f1*f5*f8)*z[5]*z[6]*z[9]*z[10] + (-16*f0*f7*f8 -
4*f1*f7^2)*z[5]*z[6]*z[9]*z[11] + (-16*f0*f8^2 - 8*f1*f7*f8 -
4*f3*f5*f8)*z[5]*z[6]*z[9]*z[12] + (16*f0*f8^2 + 8*f1*f7*f8)*z[5]*z[6]*z[9]*z[13]
+ (16*f1*f8^2 + 8*f3*f6*f8 - 2*f3*f7^2)*z[5]*z[6]*z[9]*z[14] +
4*f1*f8*z[5]*z[6]*z[10]*z[11] - 8*f2*f8*z[5]*z[6]*z[10]*z[12] -
4*f3*f8*z[5]*z[6]*z[10]*z[14] + 8*f3*f8*z[5]*z[6]*z[11]*z[12] -
4*f5*f8*z[5]*z[6]*z[11]*z[15] + 4*f8*z[5]*z[6]*z[12]*z[16] + (8*f6*f8 -
2*f7^2)*z[5]*z[6]*z[13]*z[15] - 4*f8*z[5]*z[6]*z[13]*z[16] + (-16*f0*f5*f8^2 +
16*f0*f6*f7*f8 - 4*f0*f7^3 - 4*f1*f5*f7*f8 + 16*f1*f6^2*f8 -
4*f1*f6*f7^2)*z[5]*z[7]*z[9]^2 + (-8*f0*f7*f8 - 16*f1*f6*f8 +
2*f1*f7^2)*z[5]*z[7]*z[9]*z[10] + (16*f0*f8^2 + 4*f1*f7*f8)*z[5]*z[7]*z[9]*z[11] +
(8*f2*f7*f8 + 2*f3*f7^2 + 8*f4*f5*f8)*z[5]*z[7]*z[9]*z[12] + (-16*f2*f8^2 -
4*f3*f7*f8 - 16*f4*f6*f8 + 4*f4*f7^2)*z[5]*z[7]*z[9]*z[14] + (16*f3*f8^2 +
8*f5*f6*f8 - 2*f5*f7^2)*z[5]*z[7]*z[9]*z[15] - 4*f5*f8*z[5]*z[7]*z[9]*z[16] +
4*f1*f8*z[5]*z[7]*z[10]^2 - 4*f3*f8*z[5]*z[7]*z[10]*z[12] +
8*f4*f8*z[5]*z[7]*z[10]*z[14] - 4*f5*f8*z[5]*z[7]*z[10]*z[15] -
4*f5*f8*z[5]*z[7]*z[11]*z[14] + 2*f7^2*z[5]*z[7]*z[11]*z[15] -
4*f8*z[5]*z[7]*z[11]*z[16] + 4*f5*f8*z[5]*z[7]*z[12]^2 -
4*f5*f8*z[5]*z[7]*z[12]*z[13] - 2*f7^2*z[5]*z[7]*z[12]*z[14] -
4*f7*f8*z[5]*z[7]*z[12]*z[15] + (8*f6*f8 - 2*f7^2)*z[5]*z[7]*z[13]*z[14] -
4*f7*f8*z[5]*z[7]*z[13]*z[15] + 4*f7*f8*z[5]*z[7]*z[14]^2 + (-8*f1*f6*f8 +
2*f1*f7^2)*z[5]*z[8]*z[9]^2 + 4*f1*f8*z[5]*z[8]*z[9]*z[10] -
4*f4*f7*z[5]*z[8]*z[9]*z[12] + 8*f4*f8*z[5]*z[8]*z[9]*z[14] -
4*f5*f8*z[5]*z[8]*z[9]*z[15] + f7*z[5]*z[8]*z[9]*z[16] + f7*z[5]*z[8]*z[10]*z[15]
+ f7*z[5]*z[8]*z[11]*z[14] + 2*f7*z[5]*z[8]*z[12]^2 + f7*z[5]*z[8]*z[12]*z[13] -
4*f8*z[5]*z[8]*z[12]*z[14] - 4*f8*z[5]*z[8]*z[13]*z[14] + (16*f0*f6*f7*f8 -
4*f0*f7^3 - 4*f1*f5*f7*f8 + 16*f1*f6^2*f8 - 4*f1*f6*f7^2 + 16*f2*f3*f8^2 +
16*f2*f5*f6*f8 - 4*f2*f5*f7^2)*z[6]^2*z[9]^2 + (-16*f0*f7*f8 - 16*f1*f6*f8 +
2*f1*f7^2 - 16*f2*f5*f8)*z[6]^2*z[9]*z[10] + (12*f1*f7*f8 + 4*f2*f7^2 +
4*f3*f5*f8)*z[6]^2*z[9]*z[11] + (16*f1*f8^2 - 2*f3*f7^2)*z[6]^2*z[9]*z[12] +
(-16*f1*f8^2 - 8*f2*f7*f8 - 8*f3*f6*f8 + 2*f3*f7^2)*z[6]^2*z[9]*z[13] +
4*f3*f7*f8*z[6]^2*z[9]*z[14] + (-16*f3*f8^2 - 16*f5*f6*f8 +
4*f5*f7^2)*z[6]^2*z[9]*z[15] + 8*f5*f8*z[6]^2*z[9]*z[16] +
4*f3*f8*z[6]^2*z[10]*z[12] + 4*f3*f8*z[6]^2*z[10]*z[13] +
8*f5*f8*z[6]^2*z[10]*z[15] - 4*f3*f8*z[6]^2*z[11]^2 - 2*f7^2*z[6]^2*z[11]*z[15] -
8*f5*f8*z[6]^2*z[12]^2 + 2*f7^2*z[6]^2*z[12]*z[14] + 4*f7*f8*z[6]^2*z[12]*z[15] +
4*f7*f8*z[6]^2*z[13]*z[15] - 4*f7*f8*z[6]^2*z[14]^2 + (-32*f0*f6*f8^2 +
8*f0*f7^2*f8 + 16*f1*f5*f8^2 - 24*f1*f6*f7*f8 + 6*f1*f7^3 + 8*f2*f5*f7*f8 -
32*f2*f6^2*f8 + 8*f2*f6*f7^2 - 16*f3^2*f8^2 - 8*f3*f5*f6*f8 +
2*f3*f5*f7^2)*z[6]*z[7]*z[9]^2 + (32*f0*f8^2 + 16*f1*f7*f8 + 32*f2*f6*f8 -
4*f2*f7^2 + 8*f3*f5*f8)*z[6]*z[7]*z[9]*z[10] + (-16*f1*f8^2 - 16*f2*f7*f8 -
4*f3*f7^2 - 8*f4*f5*f8)*z[6]*z[7]*z[9]*z[11] + (-16*f2*f8^2 + 4*f4*f7^2 -
8*f5^2*f8)*z[6]*z[7]*z[9]*z[12] + (16*f2*f8^2 + 8*f3*f7*f8 + 16*f4*f6*f8 -
4*f4*f7^2)*z[6]*z[7]*z[9]*z[13] + (16*f3*f8^2 - 8*f4*f7*f8 + 16*f5*f6*f8 -
4*f5*f7^2)*z[6]*z[7]*z[9]*z[14] + (16*f6^2*f8 - 4*f6*f7^2)*z[6]*z[7]*z[9]*z[15] +
(-8*f6*f8 - f7^2)*z[6]*z[7]*z[9]*z[16] - 8*f2*f8*z[6]*z[7]*z[10]^2 +
8*f3*f8*z[6]*z[7]*z[10]*z[11] - 8*f4*f8*z[6]*z[7]*z[10]*z[12] -
8*f4*f8*z[6]*z[7]*z[10]*z[13] - 8*f5*f8*z[6]*z[7]*z[10]*z[14] + (-8*f6*f8 +
f7^2)*z[6]*z[7]*z[10]*z[15] + 8*f8*z[6]*z[7]*z[10]*z[16] +
8*f5*f8*z[6]*z[7]*z[11]*z[12] + 8*f5*f8*z[6]*z[7]*z[11]*z[13] +
f7^2*z[6]*z[7]*z[11]*z[14] + (8*f6*f8 - 2*f7^2)*z[6]*z[7]*z[12]^2 -
f7^2*z[6]*z[7]*z[12]*z[13] + (-8*f6*f8 + 2*f7^2)*z[6]*z[7]*z[13]^2 + (16*f2*f6*f8
- 4*f2*f7^2 + 4*f3*f5*f8)*z[6]*z[8]*z[9]^2 + (-8*f2*f8 -
2*f3*f7)*z[6]*z[8]*z[9]*z[10] + 4*f4*f7*z[6]*z[8]*z[9]*z[11] + (8*f4*f8 +
2*f5*f7)*z[6]*z[8]*z[9]*z[12] - 8*f4*f8*z[6]*z[8]*z[9]*z[13] -
8*f5*f8*z[6]*z[8]*z[9]*z[14] + (-8*f6*f8 + 2*f7^2)*z[6]*z[8]*z[9]*z[15] +
2*f7*z[6]*z[8]*z[10]*z[14] - 2*f7*z[6]*z[8]*z[11]*z[12] -
2*f7*z[6]*z[8]*z[11]*z[13] - 4*f8*z[6]*z[8]*z[12]^2 + 4*f8*z[6]*z[8]*z[13]^2 +
(16*f1*f6*f8^2 - 4*f1*f7^2*f8 - 16*f2*f5*f8^2 + 16*f2*f6*f7*f8 - 4*f2*f7^3 +
16*f3*f4*f8^2 - 8*f3*f5*f7*f8 + 16*f3*f6^2*f8 - 4*f3*f6*f7^2)*z[7]^2*z[9]^2 +
(-16*f1*f8^2 - 8*f2*f7*f8 - 16*f3*f6*f8 + 4*f3*f7^2)*z[7]^2*z[9]*z[10] +
(16*f2*f8^2 + 8*f3*f7*f8 + 4*f5^2*f8)*z[7]^2*z[9]*z[11] + (-8*f4*f7*f8 +
8*f5*f6*f8 - 2*f5*f7^2)*z[7]^2*z[9]*z[12] + (-16*f3*f8^2 - 8*f5*f6*f8 +
2*f5*f7^2)*z[7]^2*z[9]*z[13] + (8*f5*f7*f8 - 16*f6^2*f8 +
4*f6*f7^2)*z[7]^2*z[9]*z[14] + (-8*f6*f7*f8 + 2*f7^3)*z[7]^2*z[9]*z[15] +
6*f7*f8*z[7]^2*z[9]*z[16] + 4*f5*f8*z[7]^2*z[10]*z[12] +
4*f5*f8*z[7]^2*z[10]*z[13] + (8*f6*f8 - 2*f7^2)*z[7]^2*z[10]*z[14] +
2*f7*f8*z[7]^2*z[10]*z[15] - 4*f5*f8*z[7]^2*z[11]^2 + (-8*f6*f8 +
2*f7^2)*z[7]^2*z[11]*z[12] - 2*f7*f8*z[7]^2*z[11]*z[14] +
2*f7*f8*z[7]^2*z[12]*z[13] + (-16*f3*f6*f8 + 4*f3*f7^2)*z[7]*z[8]*z[9]^2 +
12*f3*f8*z[7]*z[8]*z[9]*z[10] + (-8*f4*f8 - 2*f5*f7)*z[7]*z[8]*z[9]*z[11] -
8*f5*f8*z[7]*z[8]*z[9]*z[12] + 8*f5*f8*z[7]*z[8]*z[9]*z[13] + (16*f6*f8 -
4*f7^2)*z[7]*z[8]*z[9]*z[14] - 2*f7*z[7]*z[8]*z[10]*z[13] -
8*f8*z[7]*z[8]*z[10]*z[14] + 4*f8*z[7]*z[8]*z[11]*z[12] +
4*f8*z[7]*z[8]*z[11]*z[13] + 2*z[8]^2*z[10]*z[11],

// Bmat[3,3]
  (-256*f0^2*f4*f6*f8^2 + 64*f0^2*f4*f7^2*f8 + 64*f0^2*f5^2*f8^2 +
128*f0*f1*f3*f6*f8^2 - 32*f0*f1*f3*f7^2*f8 - 256*f0*f2^2*f6*f8^2 +
64*f0*f2^2*f7^2*f8 + 128*f0*f2*f3*f5*f8^2 - 256*f0*f2*f4^2*f8^2 +
128*f0*f2*f4*f5*f7*f8 - 256*f0*f2*f4*f6^2*f8 + 64*f0*f2*f4*f6*f7^2 +
64*f0*f2*f5^2*f6*f8 - 16*f0*f2*f5^2*f7^2 + 64*f0*f3^2*f4*f8^2 -
32*f0*f3^2*f5*f7*f8 + 64*f0*f3^2*f6^2*f8 - 16*f0*f3^2*f6*f7^2 + 64*f1^2*f2*f6*f8^2
- 16*f1^2*f2*f7^2*f8 - 32*f1^2*f3*f5*f8^2 + 64*f1^2*f4^2*f8^2 -
32*f1^2*f4*f5*f7*f8 + 64*f1^2*f4*f6^2*f8 - 16*f1^2*f4*f6*f7^2 - 16*f1^2*f5^2*f6*f8
+ 4*f1^2*f5^2*f7^2)*z[1]^2*z[9]^2 + (128*f0^2*f4*f8^2 - 32*f0^2*f5*f7*f8 -
64*f0*f1*f3*f8^2 + 128*f0*f2^2*f8^2 - 32*f0*f2*f3*f7*f8 + 256*f0*f2*f4*f6*f8 -
64*f0*f2*f4*f7^2 - 64*f0*f2*f5^2*f8 - 64*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 -
32*f1^2*f2*f8^2 + 8*f1^2*f3*f7*f8 - 64*f1^2*f4*f6*f8 + 16*f1^2*f4*f7^2 +
16*f1^2*f5^2*f8)*z[1]^2*z[9]*z[10] + (-64*f0^2*f5*f8^2 + 16*f0*f1*f5*f7*f8 -
64*f0*f2*f3*f8^2 - 64*f0*f2*f4*f7*f8 - 64*f0*f2*f5*f6*f8 + 32*f0*f2*f5*f7^2 +
32*f0*f3^2*f7*f8 + 16*f0*f3*f5^2*f8 + 16*f1^2*f3*f8^2 + 16*f1^2*f4*f7*f8 +
16*f1^2*f5*f6*f8 - 8*f1^2*f5*f7^2)*z[1]^2*z[9]*z[11] + (32*f0*f1*f5*f8^2 +
32*f0*f2*f5*f7*f8 + 32*f0*f3^2*f8^2 + 32*f0*f3*f5*f6*f8 - 16*f0*f3*f5*f7^2 -
16*f1^2*f5*f7*f8 - 8*f1*f3^2*f7*f8 - 8*f1*f3*f5^2*f8)*z[1]^2*z[9]*z[12] +
(128*f0^2*f6*f8^2 - 32*f0^2*f7^2*f8 - 32*f0*f1*f5*f8^2 + 256*f0*f2*f4*f8^2 -
96*f0*f2*f5*f7*f8 + 128*f0*f2*f6^2*f8 - 32*f0*f2*f6*f7^2 - 64*f0*f3^2*f8^2 -
32*f0*f3*f5*f6*f8 + 8*f0*f3*f5*f7^2 - 64*f1^2*f4*f8^2 + 24*f1^2*f5*f7*f8 -
32*f1^2*f6^2*f8 + 8*f1^2*f6*f7^2)*z[1]^2*z[9]*z[13] + (-64*f0*f1*f6*f8^2 +
16*f0*f1*f7^2*f8 - 64*f0*f2*f5*f8^2 - 64*f0*f3*f4*f8^2 + 48*f0*f3*f5*f7*f8 -
64*f0*f3*f6^2*f8 + 16*f0*f3*f6*f7^2 + 32*f1^2*f5*f8^2 + 16*f1*f3^2*f8^2 +
16*f1*f3*f5*f6*f8 - 4*f1*f3*f5*f7^2)*z[1]^2*z[9]*z[14] + (256*f0*f2*f6*f8^2 -
64*f0*f2*f7^2*f8 - 96*f0*f3*f5*f8^2 + 128*f0*f4^2*f8^2 - 64*f0*f4*f5*f7*f8 +
128*f0*f4*f6^2*f8 - 32*f0*f4*f6*f7^2 - 32*f0*f5^2*f6*f8 + 8*f0*f5^2*f7^2 -
64*f1^2*f6*f8^2 + 16*f1^2*f7^2*f8 - 32*f1*f3*f4*f8^2 + 16*f1*f3*f5*f7*f8 -
32*f1*f3*f6^2*f8 + 8*f1*f3*f6*f7^2)*z[1]^2*z[9]*z[15] + (-64*f0*f2*f8^2 +
16*f0*f3*f7*f8 - 64*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 16*f0*f5^2*f8 + 16*f1^2*f8^2 +
16*f1*f3*f6*f8 - 4*f1*f3*f7^2)*z[1]^2*z[9]*z[16] + (32*f0^2*f6*f8 + 64*f0*f2*f4*f8
- 8*f0*f3^2*f8 - 16*f1^2*f4*f8)*z[1]^2*z[10]^2 + (-32*f0^2*f7*f8 - 32*f0*f1*f6*f8
- 32*f0*f2*f5*f8 - 32*f0*f3*f4*f8 + 8*f1^2*f5*f8)*z[1]^2*z[10]*z[11] +
(16*f0*f1*f7*f8 - 64*f0*f2*f6*f8 + 32*f0*f3*f5*f8 + 32*f1^2*f6*f8 +
16*f1*f3*f4*f8)*z[1]^2*z[10]*z[12] + (16*f0*f1*f7*f8 - 64*f0*f2*f6*f8 +
16*f0*f2*f7^2 + 16*f0*f3*f5*f8 + 16*f1^2*f6*f8 - 4*f1^2*f7^2)*z[1]^2*z[10]*z[13] +
(32*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 8*f0*f3*f7^2 - 16*f1^2*f7*f8 -
8*f1*f3*f5*f8)*z[1]^2*z[10]*z[14] + (-64*f0*f2*f8^2 - 64*f0*f4*f6*f8 +
16*f0*f4*f7^2 + 16*f0*f5^2*f8 + 16*f1^2*f8^2 + 16*f1*f3*f6*f8 -
4*f1*f3*f7^2)*z[1]^2*z[10]*z[15] - 32*f0*f4*f8*z[1]^2*z[10]*z[16] + (32*f0^2*f8^2
+ 16*f0*f1*f7*f8 + 96*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 16*f0*f3*f5*f8 + 32*f0*f4^2*f8
- 16*f1^2*f6*f8 + 4*f1^2*f7^2)*z[1]^2*z[11]^2 + (-32*f0*f1*f8^2 - 32*f0*f3*f6*f8 +
16*f0*f3*f7^2 - 32*f0*f4*f5*f8 - 16*f1^2*f7*f8 - 32*f1*f2*f6*f8 + 16*f1*f3*f5*f8 -
32*f1*f4^2*f8)*z[1]^2*z[11]*z[12] + (-32*f0*f1*f8^2 - 32*f0*f2*f7*f8 -
32*f0*f4*f5*f8)*z[1]^2*z[11]*z[13] + (-16*f0*f3*f7*f8 + 16*f0*f5^2*f8 +
16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 16*f1*f4*f5*f8)*z[1]^2*z[11]*z[14] +
(32*f0*f3*f8^2 + 32*f0*f4*f7*f8 - 8*f0*f5*f7^2 - 8*f1*f3*f7*f8 -
8*f1*f5^2*f8)*z[1]^2*z[11]*z[15] + (16*f0*f5*f8 + 16*f1*f4*f8)*z[1]^2*z[11]*z[16]
+ (32*f0*f2*f8^2 - 16*f0*f3*f7*f8 + 96*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8
+ 16*f1*f2*f7*f8 - 32*f1*f3*f6*f8 + 16*f1*f4*f5*f8 + 32*f2^2*f6*f8 -
16*f2*f3*f5*f8 + 32*f2*f4^2*f8 - 8*f3^2*f4*f8)*z[1]^2*z[12]^2 + (16*f0*f5^2*f8 +
16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 16*f1*f4*f5*f8)*z[1]^2*z[12]*z[13] +
(-32*f0*f4*f7*f8 - 32*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 32*f1*f2*f8^2 + 24*f1*f3*f7*f8
- 16*f1*f5^2*f8 - 32*f2^2*f7*f8 - 32*f2*f4*f5*f8 +
8*f3^2*f5*f8)*z[1]^2*z[12]*z[14] + (-64*f0*f4*f8^2 + 32*f0*f5*f7*f8 +
16*f1*f3*f8^2 - 16*f1*f4*f7*f8 + 16*f1*f5*f6*f8 + 16*f2*f3*f7*f8 +
16*f2*f5^2*f8)*z[1]^2*z[12]*z[15] + (-32*f0*f6*f8 + 8*f0*f7^2 - 8*f1*f5*f8 -
32*f2*f4*f8 + 8*f3^2*f8)*z[1]^2*z[12]*z[16] + (32*f0*f2*f8^2 + 32*f0*f4*f6*f8 -
8*f0*f4*f7^2)*z[1]^2*z[13]^2 + (-32*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 32*f1*f2*f8^2 -
32*f1*f4*f6*f8 + 8*f1*f4*f7^2)*z[1]^2*z[13]*z[14] + (-64*f0*f4*f8^2 +
16*f0*f5*f7*f8 + 16*f1*f3*f8^2 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[1]^2*z[13]*z[15]
- 8*f1*f5*f8*z[1]^2*z[13]*z[16] + (64*f0*f4*f8^2 - 16*f0*f5*f7*f8 + 32*f0*f6^2*f8
- 8*f0*f6*f7^2 - 16*f1*f3*f8^2 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2 + 32*f2^2*f8^2 +
32*f2*f4*f6*f8 - 8*f2*f4*f7^2 - 8*f3^2*f6*f8 + 2*f3^2*f7^2)*z[1]^2*z[14]^2 +
(-32*f0*f6*f7*f8 + 8*f0*f7^3 + 8*f1*f5*f7*f8 - 32*f1*f6^2*f8 + 8*f1*f6*f7^2 -
32*f2*f3*f8^2 - 32*f2*f5*f6*f8 + 8*f2*f5*f7^2)*z[1]^2*z[14]*z[15] + (16*f1*f6*f8 -
4*f1*f7^2 + 16*f2*f5*f8)*z[1]^2*z[14]*z[16] + (32*f0*f6*f8^2 - 8*f0*f7^2*f8 -
16*f1*f5*f8^2 + 16*f1*f6*f7*f8 - 4*f1*f7^3 + 32*f2*f4*f8^2 - 16*f2*f5*f7*f8 +
32*f2*f6^2*f8 - 8*f2*f6*f7^2)*z[1]^2*z[15]^2 + (-32*f2*f6*f8 +
8*f2*f7^2)*z[1]^2*z[15]*z[16] + (128*f0^2*f4*f8^2 - 32*f0^2*f5*f7*f8 -
64*f0*f1*f3*f8^2 + 128*f0*f2^2*f8^2 - 32*f0*f2*f3*f7*f8 + 256*f0*f2*f4*f6*f8 -
64*f0*f2*f4*f7^2 - 64*f0*f2*f5^2*f8 - 64*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 -
32*f1^2*f2*f8^2 + 8*f1^2*f3*f7*f8 - 64*f1^2*f4*f6*f8 + 16*f1^2*f4*f7^2 +
16*f1^2*f5^2*f8)*z[1]*z[2]*z[9]^2 + (-256*f0*f2*f4*f8 + 32*f0*f2*f5*f7 +
64*f0*f3^2*f8 + 64*f1^2*f4*f8 - 8*f1^2*f5*f7)*z[1]*z[2]*z[9]*z[10] +
(64*f0^2*f7*f8 + 128*f0*f2*f5*f8 - 32*f0*f2*f6*f7 - 8*f0*f3*f5*f7 - 32*f1^2*f5*f8
+ 8*f1^2*f6*f7)*z[1]*z[2]*z[9]*z[11] + (-32*f0*f1*f7*f8 - 64*f0*f3*f5*f8 +
16*f0*f3*f6*f7 + 4*f1*f3*f5*f7)*z[1]*z[2]*z[9]*z[12] + (-128*f0^2*f8^2 -
128*f0*f2*f6*f8 + 48*f0*f2*f7^2 + 32*f0*f3*f5*f8 + 32*f1^2*f6*f8 -
12*f1^2*f7^2)*z[1]*z[2]*z[9]*z[13] + (64*f0*f1*f8^2 + 64*f0*f3*f6*f8 -
24*f0*f3*f7^2 - 16*f1*f3*f5*f8)*z[1]*z[2]*z[9]*z[14] + (-128*f0*f2*f8^2 +
32*f0*f3*f7*f8 - 128*f0*f4*f6*f8 + 32*f0*f4*f7^2 + 32*f0*f5^2*f8 + 32*f1^2*f8^2 +
32*f1*f3*f6*f8 - 8*f1*f3*f7^2)*z[1]*z[2]*z[9]*z[15] + (64*f0*f4*f8 - 8*f0*f5*f7 -
16*f1*f3*f8)*z[1]*z[2]*z[9]*z[16] - 32*f0^2*f8*z[1]*z[2]*z[10]^2 + (32*f0*f1*f8 +
16*f0*f2*f7 - 4*f1^2*f7)*z[1]*z[2]*z[10]*z[11] + (64*f0*f2*f8 - 8*f0*f3*f7 -
32*f1^2*f8)*z[1]*z[2]*z[10]*z[12] + (64*f0*f2*f8 - 8*f0*f3*f7 -
16*f1^2*f8)*z[1]*z[2]*z[10]*z[13] + (-32*f0*f3*f8 +
4*f1*f3*f7)*z[1]*z[2]*z[10]*z[14] + (64*f0*f4*f8 - 8*f0*f5*f7 -
16*f1*f3*f8)*z[1]*z[2]*z[10]*z[15] + (-96*f0*f2*f8 + 16*f1^2*f8)*z[1]*z[2]*z[11]^2
+ (32*f0*f3*f8 + 32*f1*f2*f8)*z[1]*z[2]*z[11]*z[12] + (16*f0*f3*f8 +
16*f0*f4*f7)*z[1]*z[2]*z[11]*z[13] + (-8*f0*f5*f7 - 8*f1*f3*f8 -
8*f1*f4*f7)*z[1]*z[2]*z[11]*z[14] + (-32*f0*f5*f8 + 16*f0*f6*f7 +
4*f1*f5*f7)*z[1]*z[2]*z[11]*z[15] - 8*f0*f7*z[1]*z[2]*z[11]*z[16] + (-64*f0*f4*f8
+ 8*f0*f5*f7 + 24*f1*f3*f8 - 32*f2^2*f8)*z[1]*z[2]*z[12]^2 + (-8*f0*f5*f7 -
8*f1*f3*f8 - 8*f1*f4*f7)*z[1]*z[2]*z[12]*z[13] + (32*f0*f5*f8 + 8*f1*f5*f7 +
16*f2*f3*f8 + 16*f2*f4*f7 - 4*f3^2*f7)*z[1]*z[2]*z[12]*z[14] + (-16*f0*f7^2 -
8*f1*f6*f7 - 8*f2*f5*f7 - 8*f3^2*f8)*z[1]*z[2]*z[12]*z[15] + (32*f0*f8 +
4*f1*f7)*z[1]*z[2]*z[12]*z[16] - 32*f0*f4*f8*z[1]*z[2]*z[13]^2 + (32*f0*f5*f8 +
32*f1*f4*f8)*z[1]*z[2]*z[13]*z[14] + (-8*f0*f7^2 -
16*f1*f5*f8)*z[1]*z[2]*z[13]*z[15] + 4*f1*f7*z[1]*z[2]*z[13]*z[16] + (-32*f0*f6*f8
+ 8*f0*f7^2 - 16*f1*f5*f8 - 32*f2*f4*f8 + 8*f3^2*f8)*z[1]*z[2]*z[14]^2 +
(32*f0*f7*f8 + 32*f1*f6*f8 - 4*f1*f7^2 + 32*f2*f5*f8)*z[1]*z[2]*z[14]*z[15] +
(-16*f1*f8 - 8*f2*f7)*z[1]*z[2]*z[14]*z[16] + (-32*f0*f8^2 - 8*f1*f7*f8 -
32*f2*f6*f8 + 8*f2*f7^2)*z[1]*z[2]*z[15]^2 + 32*f2*f8*z[1]*z[2]*z[15]*z[16] +
(-64*f0^2*f5*f8^2 + 16*f0*f1*f5*f7*f8 - 64*f0*f2*f3*f8^2 - 64*f0*f2*f4*f7*f8 -
64*f0*f2*f5*f6*f8 + 32*f0*f2*f5*f7^2 + 32*f0*f3^2*f7*f8 + 16*f0*f3*f5^2*f8 +
16*f1^2*f3*f8^2 + 16*f1^2*f4*f7*f8 + 16*f1^2*f5*f6*f8 -
8*f1^2*f5*f7^2)*z[1]*z[3]*z[9]^2 + (64*f0^2*f7*f8 + 128*f0*f2*f5*f8 -
32*f0*f2*f6*f7 - 8*f0*f3*f5*f7 - 32*f1^2*f5*f8 +
8*f1^2*f6*f7)*z[1]*z[3]*z[9]*z[10] + (-64*f0*f1*f7*f8 - 32*f0*f2*f7^2 -
64*f0*f3*f5*f8 + 32*f0*f3*f6*f7 + 8*f1^2*f7^2)*z[1]*z[3]*z[9]*z[11] +
(16*f0*f3*f7^2 + 64*f0*f4*f5*f8 - 32*f0*f4*f6*f7 + 8*f0*f5^2*f7 + 32*f1^2*f7*f8 +
16*f1*f3*f5*f8 - 8*f1*f3*f6*f7)*z[1]*z[3]*z[9]*z[12] + (64*f0*f1*f8^2 +
96*f0*f2*f7*f8 - 16*f0*f3*f7^2 - 24*f1^2*f7*f8)*z[1]*z[3]*z[9]*z[13] +
(-48*f0*f3*f7*f8 + 16*f0*f4*f7^2 - 32*f0*f5^2*f8 - 32*f1^2*f8^2 +
4*f1*f3*f7^2)*z[1]*z[3]*z[9]*z[14] + (64*f0*f3*f8^2 + 64*f0*f5*f6*f8 -
24*f0*f5*f7^2 - 16*f1*f3*f7*f8)*z[1]*z[3]*z[9]*z[15] + (-64*f0*f5*f8 +
16*f0*f6*f7)*z[1]*z[3]*z[9]*z[16] + (16*f0*f2*f7 - 4*f1^2*f7)*z[1]*z[3]*z[10]^2 -
16*f0*f3*f7*z[1]*z[3]*z[10]*z[11] + (-32*f0*f3*f8 + 16*f0*f4*f7 +
4*f1*f3*f7)*z[1]*z[3]*z[10]*z[12] - 16*f0*f3*f8*z[1]*z[3]*z[10]*z[13] +
(8*f0*f5*f7 + 8*f1*f3*f8)*z[1]*z[3]*z[10]*z[14] -
32*f0*f5*f8*z[1]*z[3]*z[10]*z[15] - 8*f0*f7*z[1]*z[3]*z[10]*z[16] +
32*f0*f3*f8*z[1]*z[3]*z[11]^2 + (-8*f0*f5*f7 - 16*f1*f3*f8)*z[1]*z[3]*z[11]*z[12]
- 8*f0*f5*f7*z[1]*z[3]*z[11]*z[13] + 4*f1*f5*f7*z[1]*z[3]*z[11]*z[14] +
(16*f0*f7^2 + 16*f1*f5*f8 - 8*f1*f6*f7)*z[1]*z[3]*z[11]*z[15] +
4*f1*f7*z[1]*z[3]*z[11]*z[16] + (32*f0*f5*f8 - 16*f1*f4*f8 +
16*f2*f3*f8)*z[1]*z[3]*z[12]^2 + (-32*f0*f5*f8 + 16*f0*f6*f7 +
4*f1*f5*f7)*z[1]*z[3]*z[12]*z[13] + (-16*f0*f7^2 + 16*f1*f5*f8 - 8*f1*f6*f7 -
8*f2*f5*f7 - 8*f3^2*f8)*z[1]*z[3]*z[12]*z[14] + (-32*f0*f7*f8 + 8*f1*f7^2 -
32*f2*f5*f8 + 16*f2*f6*f7 + 16*f3*f4*f8)*z[1]*z[3]*z[12]*z[15] -
8*f2*f7*z[1]*z[3]*z[12]*z[16] + 16*f0*f5*f8*z[1]*z[3]*z[13]^2 + (-8*f0*f7^2 -
16*f1*f5*f8)*z[1]*z[3]*z[13]*z[14] + (-16*f0*f7*f8 +
4*f1*f7^2)*z[1]*z[3]*z[13]*z[15] + (32*f0*f7*f8 + 4*f1*f7^2 +
16*f2*f5*f8)*z[1]*z[3]*z[14]^2 + (-24*f1*f7*f8 - 8*f2*f7^2 -
8*f3*f5*f8)*z[1]*z[3]*z[14]*z[15] + 4*f3*f7*z[1]*z[3]*z[14]*z[16] + (16*f1*f8^2 +
16*f2*f7*f8)*z[1]*z[3]*z[15]^2 - 8*f3*f8*z[1]*z[3]*z[15]*z[16] + (32*f0*f1*f5*f8^2
+ 32*f0*f2*f5*f7*f8 + 32*f0*f3^2*f8^2 + 32*f0*f3*f5*f6*f8 - 16*f0*f3*f5*f7^2 -
16*f1^2*f5*f7*f8 - 8*f1*f3^2*f7*f8 - 8*f1*f3*f5^2*f8)*z[1]*z[4]*z[9]^2 +
(-32*f0*f1*f7*f8 - 64*f0*f3*f5*f8 + 16*f0*f3*f6*f7 +
4*f1*f3*f5*f7)*z[1]*z[4]*z[9]*z[10] + (16*f0*f3*f7^2 + 64*f0*f4*f5*f8 -
32*f0*f4*f6*f7 + 8*f0*f5^2*f7 + 32*f1^2*f7*f8 + 16*f1*f3*f5*f8 -
8*f1*f3*f6*f7)*z[1]*z[4]*z[9]*z[11] + (64*f0*f3*f7*f8 - 32*f0*f4*f7^2 -
64*f1*f2*f7*f8 - 64*f1*f4*f5*f8 + 32*f1*f4*f6*f7 -
8*f1*f5^2*f7)*z[1]*z[4]*z[9]*z[12] + (-48*f0*f3*f7*f8 + 16*f0*f4*f7^2 -
32*f0*f5^2*f8 - 32*f1^2*f8^2 + 4*f1*f3*f7^2)*z[1]*z[4]*z[9]*z[13] +
(-64*f0*f3*f8^2 + 32*f0*f4*f7*f8 + 8*f0*f5*f7^2 + 64*f1*f2*f8^2 + 16*f1*f3*f7*f8 -
16*f1*f4*f7^2 + 32*f1*f5^2*f8)*z[1]*z[4]*z[9]*z[14] + (-48*f0*f5*f7*f8 -
32*f1*f3*f8^2 + 32*f1*f4*f7*f8 - 32*f1*f5*f6*f8 +
8*f1*f5*f7^2)*z[1]*z[4]*z[9]*z[15] + (8*f0*f7^2 + 32*f1*f5*f8 -
8*f1*f6*f7)*z[1]*z[4]*z[9]*z[16] - 8*f0*f3*f7*z[1]*z[4]*z[10]^2 + (16*f0*f4*f7 +
4*f1*f3*f7)*z[1]*z[4]*z[10]*z[11] + (8*f0*f5*f7 + 16*f1*f3*f8 -
16*f1*f4*f7)*z[1]*z[4]*z[10]*z[12] + (8*f0*f5*f7 +
8*f1*f3*f8)*z[1]*z[4]*z[10]*z[13] + (32*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f5*f7 -
16*f2*f3*f8)*z[1]*z[4]*z[10]*z[14] + (8*f0*f7^2 + 8*f1*f6*f7 +
8*f3^2*f8)*z[1]*z[4]*z[10]*z[15] + (-32*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f3*f8)*z[1]*z[4]*z[11]^2 + (32*f1*f4*f8 + 8*f1*f5*f7)*z[1]*z[4]*z[11]*z[12] +
(8*f0*f7^2 - 16*f1*f5*f8 + 8*f1*f6*f7 + 8*f3^2*f8)*z[1]*z[4]*z[11]*z[14] +
(-16*f1*f7^2 - 16*f3*f4*f8)*z[1]*z[4]*z[11]*z[15] + (-16*f1*f5*f8 -
8*f3^2*f8)*z[1]*z[4]*z[12]^2 + (8*f0*f7^2 + 16*f1*f5*f8 -
8*f1*f6*f7)*z[1]*z[4]*z[12]*z[13] + (-32*f0*f7*f8 +
4*f3*f5*f7)*z[1]*z[4]*z[12]*z[14] + (32*f1*f7*f8 + 16*f3*f5*f8 -
8*f3*f6*f7)*z[1]*z[4]*z[12]*z[15] + 4*f3*f7*z[1]*z[4]*z[12]*z[16] -
16*f0*f7*f8*z[1]*z[4]*z[13]*z[14] + (16*f1*f7*f8 +
8*f3*f5*f8)*z[1]*z[4]*z[13]*z[15] - 4*f3*f7*z[1]*z[4]*z[13]*z[16] + (32*f0*f8^2 -
8*f3*f5*f8)*z[1]*z[4]*z[14]^2 + (-32*f1*f8^2 + 4*f3*f7^2)*z[1]*z[4]*z[14]*z[15] +
8*f3*f8*z[1]*z[4]*z[14]*z[16] - 8*f3*f7*f8*z[1]*z[4]*z[15]^2 + (128*f0^2*f6*f8^2 -
32*f0^2*f7^2*f8 - 32*f0*f1*f5*f8^2 + 256*f0*f2*f4*f8^2 - 96*f0*f2*f5*f7*f8 +
128*f0*f2*f6^2*f8 - 32*f0*f2*f6*f7^2 - 64*f0*f3^2*f8^2 - 32*f0*f3*f5*f6*f8 +
8*f0*f3*f5*f7^2 - 64*f1^2*f4*f8^2 + 24*f1^2*f5*f7*f8 - 32*f1^2*f6^2*f8 +
8*f1^2*f6*f7^2)*z[1]*z[5]*z[9]^2 + (-128*f0^2*f8^2 - 128*f0*f2*f6*f8 +
48*f0*f2*f7^2 + 32*f0*f3*f5*f8 + 32*f1^2*f6*f8 -
12*f1^2*f7^2)*z[1]*z[5]*z[9]*z[10] + (64*f0*f1*f8^2 + 96*f0*f2*f7*f8 -
16*f0*f3*f7^2 - 24*f1^2*f7*f8)*z[1]*z[5]*z[9]*z[11] + (-48*f0*f3*f7*f8 +
16*f0*f4*f7^2 - 32*f0*f5^2*f8 - 32*f1^2*f8^2 + 4*f1*f3*f7^2)*z[1]*z[5]*z[9]*z[12]
+ (-256*f0*f2*f8^2 + 32*f0*f3*f7*f8 + 64*f1^2*f8^2)*z[1]*z[5]*z[9]*z[13] +
(128*f0*f3*f8^2 - 32*f0*f4*f7*f8 + 64*f0*f5*f6*f8 - 16*f0*f5*f7^2 -
8*f1*f3*f7*f8)*z[1]*z[5]*z[9]*z[14] + (-128*f0*f4*f8^2 + 80*f0*f5*f7*f8 -
128*f0*f6^2*f8 + 32*f0*f6*f7^2 + 32*f1*f3*f8^2)*z[1]*z[5]*z[9]*z[15] +
(64*f0*f6*f8 - 24*f0*f7^2)*z[1]*z[5]*z[9]*z[16] + (-64*f0*f2*f8 +
16*f1^2*f8)*z[1]*z[5]*z[10]^2 + 48*f0*f3*f8*z[1]*z[5]*z[10]*z[11] -
24*f1*f3*f8*z[1]*z[5]*z[10]*z[12] - 32*f0*f5*f8*z[1]*z[5]*z[10]*z[14] +
(64*f0*f6*f8 - 16*f0*f7^2)*z[1]*z[5]*z[10]*z[15] + 32*f0*f8*z[1]*z[5]*z[10]*z[16]
- 32*f0*f4*f8*z[1]*z[5]*z[11]^2 + (32*f0*f5*f8 +
32*f1*f4*f8)*z[1]*z[5]*z[11]*z[12] + 32*f0*f5*f8*z[1]*z[5]*z[11]*z[13] -
16*f1*f5*f8*z[1]*z[5]*z[11]*z[14] + (-48*f0*f7*f8 +
4*f1*f7^2)*z[1]*z[5]*z[11]*z[15] - 16*f1*f8*z[1]*z[5]*z[11]*z[16] + (-64*f0*f6*f8
+ 8*f0*f7^2 - 32*f2*f4*f8 + 8*f3^2*f8)*z[1]*z[5]*z[12]^2 + (-8*f0*f7^2 -
16*f1*f5*f8)*z[1]*z[5]*z[12]*z[13] + (64*f0*f7*f8 + 4*f1*f7^2 +
32*f2*f5*f8)*z[1]*z[5]*z[12]*z[14] + (64*f0*f8^2 - 8*f1*f7*f8 - 8*f2*f7^2 -
8*f3*f5*f8)*z[1]*z[5]*z[12]*z[15] + 32*f2*f8*z[1]*z[5]*z[12]*z[16] + (-32*f0*f6*f8
+ 8*f0*f7^2)*z[1]*z[5]*z[13]^2 + (16*f0*f7*f8 + 32*f1*f6*f8 -
8*f1*f7^2)*z[1]*z[5]*z[13]*z[14] + (64*f0*f8^2 - 8*f1*f7*f8)*z[1]*z[5]*z[13]*z[15]
+ (-96*f0*f8^2 - 8*f1*f7*f8 - 32*f2*f6*f8 + 8*f2*f7^2)*z[1]*z[5]*z[14]^2 +
(32*f1*f8^2 + 16*f2*f7*f8 + 16*f3*f6*f8 - 4*f3*f7^2)*z[1]*z[5]*z[14]*z[15] -
8*f3*f8*z[1]*z[5]*z[14]*z[16] - 32*f2*f8^2*z[1]*z[5]*z[15]^2 + (-64*f0*f1*f6*f8^2
+ 16*f0*f1*f7^2*f8 - 64*f0*f2*f5*f8^2 - 64*f0*f3*f4*f8^2 + 48*f0*f3*f5*f7*f8 -
64*f0*f3*f6^2*f8 + 16*f0*f3*f6*f7^2 + 32*f1^2*f5*f8^2 + 16*f1*f3^2*f8^2 +
16*f1*f3*f5*f6*f8 - 4*f1*f3*f5*f7^2)*z[1]*z[6]*z[9]^2 + (64*f0*f1*f8^2 +
64*f0*f3*f6*f8 - 24*f0*f3*f7^2 - 16*f1*f3*f5*f8)*z[1]*z[6]*z[9]*z[10] +
(-48*f0*f3*f7*f8 + 16*f0*f4*f7^2 - 32*f0*f5^2*f8 - 32*f1^2*f8^2 +
4*f1*f3*f7^2)*z[1]*z[6]*z[9]*z[11] + (-64*f0*f3*f8^2 + 32*f0*f4*f7*f8 +
8*f0*f5*f7^2 + 64*f1*f2*f8^2 + 16*f1*f3*f7*f8 - 16*f1*f4*f7^2 +
32*f1*f5^2*f8)*z[1]*z[6]*z[9]*z[12] + (128*f0*f3*f8^2 - 32*f0*f4*f7*f8 +
64*f0*f5*f6*f8 - 16*f0*f5*f7^2 - 8*f1*f3*f7*f8)*z[1]*z[6]*z[9]*z[13] +
(-32*f0*f5*f7*f8 - 64*f1*f3*f8^2 + 32*f1*f4*f7*f8 - 64*f1*f5*f6*f8 +
16*f1*f5*f7^2)*z[1]*z[6]*z[9]*z[14] + (64*f0*f5*f8^2 + 32*f0*f6*f7*f8 - 8*f0*f7^3
- 32*f1*f5*f7*f8 + 64*f1*f6^2*f8 - 16*f1*f6*f7^2)*z[1]*z[6]*z[9]*z[15] +
(-16*f0*f7*f8 - 32*f1*f6*f8 + 12*f1*f7^2)*z[1]*z[6]*z[9]*z[16] +
16*f0*f3*f8*z[1]*z[6]*z[10]^2 - 8*f1*f3*f8*z[1]*z[6]*z[10]*z[11] + (-32*f0*f5*f8 +
16*f2*f3*f8)*z[1]*z[6]*z[10]*z[12] - 32*f0*f5*f8*z[1]*z[6]*z[10]*z[13] +
(8*f0*f7^2 + 32*f1*f5*f8)*z[1]*z[6]*z[10]*z[14] + (-16*f0*f7*f8 - 32*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[6]*z[10]*z[15] + 32*f0*f5*f8*z[1]*z[6]*z[11]^2 + (-8*f0*f7^2 -
32*f1*f5*f8 - 8*f3^2*f8)*z[1]*z[6]*z[11]*z[12] - 4*f1*f7^2*z[1]*z[6]*z[11]*z[14] +
(32*f1*f7*f8 + 8*f3*f5*f8)*z[1]*z[6]*z[11]*z[15] + (16*f0*f7*f8 + 32*f1*f6*f8 +
16*f3*f4*f8)*z[1]*z[6]*z[12]^2 + 4*f1*f7^2*z[1]*z[6]*z[12]*z[13] + (-32*f1*f7*f8 -
16*f3*f5*f8)*z[1]*z[6]*z[12]*z[14] + (-32*f1*f8^2 +
4*f3*f7^2)*z[1]*z[6]*z[12]*z[15] - 24*f3*f8*z[1]*z[6]*z[12]*z[16] + (-32*f1*f8^2 -
16*f3*f6*f8 + 4*f3*f7^2)*z[1]*z[6]*z[13]*z[15] + 8*f3*f8*z[1]*z[6]*z[13]*z[16] +
(32*f1*f8^2 + 16*f3*f6*f8 - 4*f3*f7^2)*z[1]*z[6]*z[14]^2 -
8*f3*f7*f8*z[1]*z[6]*z[14]*z[15] + 16*f3*f8^2*z[1]*z[6]*z[15]^2 +
(256*f0*f2*f6*f8^2 - 64*f0*f2*f7^2*f8 - 96*f0*f3*f5*f8^2 + 128*f0*f4^2*f8^2 -
64*f0*f4*f5*f7*f8 + 128*f0*f4*f6^2*f8 - 32*f0*f4*f6*f7^2 - 32*f0*f5^2*f6*f8 +
8*f0*f5^2*f7^2 - 64*f1^2*f6*f8^2 + 16*f1^2*f7^2*f8 - 32*f1*f3*f4*f8^2 +
16*f1*f3*f5*f7*f8 - 32*f1*f3*f6^2*f8 + 8*f1*f3*f6*f7^2)*z[1]*z[7]*z[9]^2 +
(-128*f0*f2*f8^2 + 32*f0*f3*f7*f8 - 128*f0*f4*f6*f8 + 32*f0*f4*f7^2 +
32*f0*f5^2*f8 + 32*f1^2*f8^2 + 32*f1*f3*f6*f8 - 8*f1*f3*f7^2)*z[1]*z[7]*z[9]*z[10]
+ (64*f0*f3*f8^2 + 64*f0*f5*f6*f8 - 24*f0*f5*f7^2 -
16*f1*f3*f7*f8)*z[1]*z[7]*z[9]*z[11] + (-48*f0*f5*f7*f8 - 32*f1*f3*f8^2 +
32*f1*f4*f7*f8 - 32*f1*f5*f6*f8 + 8*f1*f5*f7^2)*z[1]*z[7]*z[9]*z[12] +
(-128*f0*f4*f8^2 + 80*f0*f5*f7*f8 - 128*f0*f6^2*f8 + 32*f0*f6*f7^2 +
32*f1*f3*f8^2)*z[1]*z[7]*z[9]*z[13] + (64*f0*f5*f8^2 + 32*f0*f6*f7*f8 - 8*f0*f7^3
- 32*f1*f5*f7*f8 + 64*f1*f6^2*f8 - 16*f1*f6*f7^2)*z[1]*z[7]*z[9]*z[14] +
(-256*f0*f6*f8^2 + 64*f0*f7^2*f8 + 64*f1*f5*f8^2 - 32*f1*f6*f7*f8 +
8*f1*f7^3)*z[1]*z[7]*z[9]*z[15] + (64*f0*f8^2 - 8*f1*f7*f8)*z[1]*z[7]*z[9]*z[16] +
(-32*f0*f4*f8 + 8*f1*f3*f8)*z[1]*z[7]*z[10]^2 + 32*f0*f5*f8*z[1]*z[7]*z[10]*z[11]
+ (64*f0*f6*f8 - 8*f0*f7^2 - 16*f1*f5*f8 - 8*f3^2*f8)*z[1]*z[7]*z[10]*z[12] +
(64*f0*f6*f8 - 16*f0*f7^2)*z[1]*z[7]*z[10]*z[13] + (-32*f0*f7*f8 - 32*f1*f6*f8 +
8*f1*f7^2)*z[1]*z[7]*z[10]*z[14] + (64*f0*f8^2 + 8*f1*f7*f8)*z[1]*z[7]*z[10]*z[15]
+ (-96*f0*f6*f8 + 16*f0*f7^2)*z[1]*z[7]*z[11]^2 + (16*f0*f7*f8 + 64*f1*f6*f8 -
8*f1*f7^2 + 16*f3*f4*f8)*z[1]*z[7]*z[11]*z[12] + 32*f0*f7*f8*z[1]*z[7]*z[11]*z[13]
+ (-8*f1*f7*f8 - 8*f3*f5*f8)*z[1]*z[7]*z[11]*z[14] -
32*f1*f8^2*z[1]*z[7]*z[11]*z[15] - 8*f3*f8*z[1]*z[7]*z[11]*z[16] + (-32*f0*f8^2 -
16*f1*f7*f8 - 32*f2*f6*f8 + 16*f3*f5*f8 - 32*f4^2*f8)*z[1]*z[7]*z[12]^2 +
(-24*f1*f7*f8 - 8*f3*f5*f8)*z[1]*z[7]*z[12]*z[13] + (32*f1*f8^2 + 32*f2*f7*f8 +
32*f4*f5*f8)*z[1]*z[7]*z[12]*z[14] + (-16*f3*f7*f8 -
16*f5^2*f8)*z[1]*z[7]*z[12]*z[15] + 32*f4*f8*z[1]*z[7]*z[12]*z[16] -
32*f0*f8^2*z[1]*z[7]*z[13]^2 + (32*f1*f8^2 + 16*f3*f6*f8 -
4*f3*f7^2)*z[1]*z[7]*z[13]*z[14] + (-32*f2*f8^2 - 32*f4*f6*f8 +
8*f4*f7^2)*z[1]*z[7]*z[14]^2 + (32*f3*f8^2 + 32*f5*f6*f8 -
8*f5*f7^2)*z[1]*z[7]*z[14]*z[15] - 16*f5*f8*z[1]*z[7]*z[14]*z[16] + (-32*f4*f8^2 +
16*f5*f7*f8 - 32*f6^2*f8 + 8*f6*f7^2)*z[1]*z[7]*z[15]^2 + (32*f6*f8 -
8*f7^2)*z[1]*z[7]*z[15]*z[16] + (-64*f0*f2*f8^2 + 16*f0*f3*f7*f8 - 64*f0*f4*f6*f8
+ 16*f0*f4*f7^2 + 16*f0*f5^2*f8 + 16*f1^2*f8^2 + 16*f1*f3*f6*f8 -
4*f1*f3*f7^2)*z[1]*z[8]*z[9]^2 + (64*f0*f4*f8 - 8*f0*f5*f7 -
16*f1*f3*f8)*z[1]*z[8]*z[9]*z[10] + (-64*f0*f5*f8 +
16*f0*f6*f7)*z[1]*z[8]*z[9]*z[11] + (8*f0*f7^2 + 32*f1*f5*f8 -
8*f1*f6*f7)*z[1]*z[8]*z[9]*z[12] + (64*f0*f6*f8 - 24*f0*f7^2)*z[1]*z[8]*z[9]*z[13]
+ (-16*f0*f7*f8 - 32*f1*f6*f8 + 12*f1*f7^2)*z[1]*z[8]*z[9]*z[14] + (64*f0*f8^2 -
8*f1*f7*f8)*z[1]*z[8]*z[9]*z[15] + f3*f7*z[1]*z[8]*z[9]*z[16] -
8*f0*f7*z[1]*z[8]*z[10]*z[11] + (-32*f0*f8 + 4*f1*f7)*z[1]*z[8]*z[10]*z[12] -
32*f0*f8*z[1]*z[8]*z[10]*z[13] + 16*f1*f8*z[1]*z[8]*z[10]*z[14] -
f3*f7*z[1]*z[8]*z[10]*z[15] + 48*f0*f8*z[1]*z[8]*z[11]^2 -
32*f1*f8*z[1]*z[8]*z[11]*z[12] + f3*f7*z[1]*z[8]*z[11]*z[14] +
8*f3*f8*z[1]*z[8]*z[11]*z[15] + 16*f2*f8*z[1]*z[8]*z[12]^2 +
3*f3*f7*z[1]*z[8]*z[12]*z[13] + (-8*f3*f8 - 8*f4*f7)*z[1]*z[8]*z[12]*z[14] +
4*f5*f7*z[1]*z[8]*z[12]*z[15] - 8*f3*f8*z[1]*z[8]*z[13]*z[14] +
16*f4*f8*z[1]*z[8]*z[14]^2 - 16*f5*f8*z[1]*z[8]*z[14]*z[15] +
4*f7*z[1]*z[8]*z[14]*z[16] + (16*f6*f8 - 4*f7^2)*z[1]*z[8]*z[15]^2 -
16*f8*z[1]*z[8]*z[15]*z[16] + (32*f0^2*f6*f8 + 64*f0*f2*f4*f8 - 8*f0*f3^2*f8 -
16*f1^2*f4*f8)*z[2]^2*z[9]^2 - 32*f0^2*f8*z[2]^2*z[9]*z[10] + (16*f0*f2*f7 -
4*f1^2*f7)*z[2]^2*z[9]*z[11] - 8*f0*f3*f7*z[2]^2*z[9]*z[12] + (-64*f0*f2*f8 +
16*f1^2*f8)*z[2]^2*z[9]*z[13] + 16*f0*f3*f8*z[2]^2*z[9]*z[14] + (-32*f0*f4*f8 +
8*f1*f3*f8)*z[2]^2*z[9]*z[15] + (-16*f0*f2 + 4*f1^2)*z[2]^2*z[10]^2 +
8*f0*f3*z[2]^2*z[10]*z[11] - 4*f1*f3*z[2]^2*z[10]*z[12] + 8*f0*z[2]^2*z[10]*z[16]
- 8*f0*f4*z[2]^2*z[11]^2 + (8*f0*f5 + 8*f1*f4)*z[2]^2*z[11]*z[12] -
8*f0*f7*z[2]^2*z[11]*z[15] - 4*f1*z[2]^2*z[11]*z[16] + (-8*f0*f6 - 4*f1*f5 -
8*f2*f4 + 2*f3^2)*z[2]^2*z[12]^2 + 8*f0*f7*z[2]^2*z[12]*z[14] + (16*f0*f8 +
4*f1*f7)*z[2]^2*z[12]*z[15] + 8*f2*z[2]^2*z[12]*z[16] +
16*f0*f8*z[2]^2*z[13]*z[15] - 16*f0*f8*z[2]^2*z[14]^2 - 8*f2*f8*z[2]^2*z[15]^2 +
(-32*f0^2*f7*f8 - 32*f0*f1*f6*f8 - 32*f0*f2*f5*f8 - 32*f0*f3*f4*f8 +
8*f1^2*f5*f8)*z[2]*z[3]*z[9]^2 + (32*f0*f1*f8 + 16*f0*f2*f7 -
4*f1^2*f7)*z[2]*z[3]*z[9]*z[10] - 16*f0*f3*f7*z[2]*z[3]*z[9]*z[11] + (16*f0*f4*f7
+ 4*f1*f3*f7)*z[2]*z[3]*z[9]*z[12] + 48*f0*f3*f8*z[2]*z[3]*z[9]*z[13] -
8*f1*f3*f8*z[2]*z[3]*z[9]*z[14] + 32*f0*f5*f8*z[2]*z[3]*z[9]*z[15] -
8*f0*f7*z[2]*z[3]*z[9]*z[16] + 8*f0*f3*z[2]*z[3]*z[10]^2 -
16*f0*f5*z[2]*z[3]*z[10]*z[12] + 8*f0*f5*z[2]*z[3]*z[11]^2 -
8*f1*f5*z[2]*z[3]*z[11]*z[12] + 4*f1*f7*z[2]*z[3]*z[11]*z[15] + (8*f0*f7 + 8*f1*f6
+ 8*f2*f5)*z[2]*z[3]*z[12]^2 - 8*f0*f7*z[2]*z[3]*z[12]*z[13] -
4*f1*f7*z[2]*z[3]*z[12]*z[14] + (-16*f1*f8 - 8*f2*f7)*z[2]*z[3]*z[12]*z[15] -
4*f3*z[2]*z[3]*z[12]*z[16] + 8*f1*f8*z[2]*z[3]*z[14]^2 + 8*f3*f8*z[2]*z[3]*z[15]^2
+ (16*f0*f1*f7*f8 - 64*f0*f2*f6*f8 + 32*f0*f3*f5*f8 + 32*f1^2*f6*f8 +
16*f1*f3*f4*f8)*z[2]*z[4]*z[9]^2 + (64*f0*f2*f8 - 8*f0*f3*f7 -
32*f1^2*f8)*z[2]*z[4]*z[9]*z[10] + (-32*f0*f3*f8 + 16*f0*f4*f7 +
4*f1*f3*f7)*z[2]*z[4]*z[9]*z[11] + (8*f0*f5*f7 + 16*f1*f3*f8 -
16*f1*f4*f7)*z[2]*z[4]*z[9]*z[12] - 24*f1*f3*f8*z[2]*z[4]*z[9]*z[13] +
(-32*f0*f5*f8 + 16*f2*f3*f8)*z[2]*z[4]*z[9]*z[14] + (64*f0*f6*f8 - 8*f0*f7^2 -
16*f1*f5*f8 - 8*f3^2*f8)*z[2]*z[4]*z[9]*z[15] + (-32*f0*f8 +
4*f1*f7)*z[2]*z[4]*z[9]*z[16] - 4*f1*f3*z[2]*z[4]*z[10]^2 -
16*f0*f5*z[2]*z[4]*z[10]*z[11] + 16*f1*f5*z[2]*z[4]*z[10]*z[12] +
8*f0*f7*z[2]*z[4]*z[10]*z[14] + (-32*f0*f8 - 4*f1*f7)*z[2]*z[4]*z[10]*z[15] +
16*f0*f6*z[2]*z[4]*z[11]^2 + (-8*f0*f7 - 16*f1*f6)*z[2]*z[4]*z[11]*z[12] -
16*f0*f7*z[2]*z[4]*z[11]*z[13] + 4*f1*f7*z[2]*z[4]*z[11]*z[14] +
16*f1*f8*z[2]*z[4]*z[11]*z[15] + 4*f3*z[2]*z[4]*z[11]*z[16] + (16*f0*f8 -
4*f3*f5)*z[2]*z[4]*z[12]^2 + 12*f1*f7*z[2]*z[4]*z[12]*z[13] +
4*f3*f7*z[2]*z[4]*z[12]*z[15] + 16*f0*f8*z[2]*z[4]*z[13]^2 -
16*f1*f8*z[2]*z[4]*z[13]*z[14] - 8*f3*f8*z[2]*z[4]*z[14]*z[15] + (16*f0*f1*f7*f8 -
64*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 16*f0*f3*f5*f8 + 16*f1^2*f6*f8 -
4*f1^2*f7^2)*z[2]*z[5]*z[9]^2 + (64*f0*f2*f8 - 8*f0*f3*f7 -
16*f1^2*f8)*z[2]*z[5]*z[9]*z[10] - 16*f0*f3*f8*z[2]*z[5]*z[9]*z[11] + (8*f0*f5*f7
+ 8*f1*f3*f8)*z[2]*z[5]*z[9]*z[12] - 32*f0*f5*f8*z[2]*z[5]*z[9]*z[14] +
(64*f0*f6*f8 - 16*f0*f7^2)*z[2]*z[5]*z[9]*z[15] - 32*f0*f8*z[2]*z[5]*z[9]*z[16] +
8*f0*f7*z[2]*z[5]*z[10]*z[14] - 32*f0*f8*z[2]*z[5]*z[10]*z[15] -
8*f0*f7*z[2]*z[5]*z[11]*z[13] + 4*f1*f7*z[2]*z[5]*z[11]*z[14] + (16*f0*f8 -
4*f1*f7)*z[2]*z[5]*z[12]^2 + 4*f1*f7*z[2]*z[5]*z[12]*z[13] -
8*f2*f7*z[2]*z[5]*z[12]*z[14] + 4*f3*f7*z[2]*z[5]*z[12]*z[15] +
16*f0*f8*z[2]*z[5]*z[13]^2 - 16*f1*f8*z[2]*z[5]*z[13]*z[14] +
16*f2*f8*z[2]*z[5]*z[14]^2 - 8*f3*f8*z[2]*z[5]*z[14]*z[15] + (32*f0*f2*f7*f8 +
32*f0*f3*f6*f8 - 8*f0*f3*f7^2 - 16*f1^2*f7*f8 - 8*f1*f3*f5*f8)*z[2]*z[6]*z[9]^2 +
(-32*f0*f3*f8 + 4*f1*f3*f7)*z[2]*z[6]*z[9]*z[10] + (8*f0*f5*f7 +
8*f1*f3*f8)*z[2]*z[6]*z[9]*z[11] + (32*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f5*f7 -
16*f2*f3*f8)*z[2]*z[6]*z[9]*z[12] - 32*f0*f5*f8*z[2]*z[6]*z[9]*z[13] + (8*f0*f7^2
+ 32*f1*f5*f8)*z[2]*z[6]*z[9]*z[14] + (-32*f0*f7*f8 - 32*f1*f6*f8 +
8*f1*f7^2)*z[2]*z[6]*z[9]*z[15] + 16*f1*f8*z[2]*z[6]*z[9]*z[16] +
8*f0*f7*z[2]*z[6]*z[10]*z[12] + 8*f0*f7*z[2]*z[6]*z[10]*z[13] -
8*f1*f7*z[2]*z[6]*z[10]*z[14] + 16*f1*f8*z[2]*z[6]*z[10]*z[15] -
8*f0*f7*z[2]*z[6]*z[11]^2 + 8*f1*f7*z[2]*z[6]*z[11]*z[12] -
4*f3*f7*z[2]*z[6]*z[11]*z[15] - 16*f1*f8*z[2]*z[6]*z[12]^2 +
4*f3*f7*z[2]*z[6]*z[12]*z[14] + 8*f3*f8*z[2]*z[6]*z[12]*z[15] +
8*f3*f8*z[2]*z[6]*z[13]*z[15] - 8*f3*f8*z[2]*z[6]*z[14]^2 + (-64*f0*f2*f8^2 -
64*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 16*f0*f5^2*f8 + 16*f1^2*f8^2 + 16*f1*f3*f6*f8 -
4*f1*f3*f7^2)*z[2]*z[7]*z[9]^2 + (64*f0*f4*f8 - 8*f0*f5*f7 -
16*f1*f3*f8)*z[2]*z[7]*z[9]*z[10] - 32*f0*f5*f8*z[2]*z[7]*z[9]*z[11] + (8*f0*f7^2
+ 8*f1*f6*f7 + 8*f3^2*f8)*z[2]*z[7]*z[9]*z[12] + (64*f0*f6*f8 -
16*f0*f7^2)*z[2]*z[7]*z[9]*z[13] + (-16*f0*f7*f8 - 32*f1*f6*f8 +
4*f1*f7^2)*z[2]*z[7]*z[9]*z[14] + (64*f0*f8^2 + 8*f1*f7*f8)*z[2]*z[7]*z[9]*z[15] -
f3*f7*z[2]*z[7]*z[9]*z[16] + (-32*f0*f8 - 4*f1*f7)*z[2]*z[7]*z[10]*z[12] -
32*f0*f8*z[2]*z[7]*z[10]*z[13] + 16*f1*f8*z[2]*z[7]*z[10]*z[14] +
f3*f7*z[2]*z[7]*z[10]*z[15] + 32*f0*f8*z[2]*z[7]*z[11]^2 -
16*f1*f8*z[2]*z[7]*z[11]*z[12] + 3*f3*f7*z[2]*z[7]*z[11]*z[14] +
16*f2*f8*z[2]*z[7]*z[12]^2 + f3*f7*z[2]*z[7]*z[12]*z[13] + (-8*f3*f8 -
8*f4*f7)*z[2]*z[7]*z[12]*z[14] + 4*f5*f7*z[2]*z[7]*z[12]*z[15] -
8*f3*f8*z[2]*z[7]*z[13]*z[14] + 16*f4*f8*z[2]*z[7]*z[14]^2 -
16*f5*f8*z[2]*z[7]*z[14]*z[15] + 4*f7*z[2]*z[7]*z[14]*z[16] + (16*f6*f8 -
4*f7^2)*z[2]*z[7]*z[15]^2 - 16*f8*z[2]*z[7]*z[15]*z[16] -
32*f0*f4*f8*z[2]*z[8]*z[9]^2 - 8*f0*f7*z[2]*z[8]*z[9]*z[11] +
32*f0*f8*z[2]*z[8]*z[9]*z[13] + 8*f0*z[2]*z[8]*z[10]^2 -
4*f3*z[2]*z[8]*z[11]*z[12] + 8*f4*z[2]*z[8]*z[12]^2 - 8*z[2]*z[8]*z[12]*z[16] +
8*f8*z[2]*z[8]*z[15]^2 + (32*f0^2*f8^2 + 16*f0*f1*f7*f8 + 96*f0*f2*f6*f8 -
16*f0*f2*f7^2 - 16*f0*f3*f5*f8 + 32*f0*f4^2*f8 - 16*f1^2*f6*f8 +
4*f1^2*f7^2)*z[3]^2*z[9]^2 + (-96*f0*f2*f8 + 16*f1^2*f8)*z[3]^2*z[9]*z[10] +
32*f0*f3*f8*z[3]^2*z[9]*z[11] + (-32*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f3*f8)*z[3]^2*z[9]*z[12] - 32*f0*f4*f8*z[3]^2*z[9]*z[13] +
32*f0*f5*f8*z[3]^2*z[9]*z[14] + (-96*f0*f6*f8 + 16*f0*f7^2)*z[3]^2*z[9]*z[15] +
48*f0*f8*z[3]^2*z[9]*z[16] - 8*f0*f4*z[3]^2*z[10]^2 + 8*f0*f5*z[3]^2*z[10]*z[11] +
16*f0*f6*z[3]^2*z[10]*z[12] - 8*f0*f7*z[3]^2*z[10]*z[14] +
32*f0*f8*z[3]^2*z[10]*z[15] - 16*f0*f6*z[3]^2*z[11]^2 + 8*f1*f6*z[3]^2*z[11]*z[12]
+ 16*f0*f7*z[3]^2*z[11]*z[13] - 4*f1*f7*z[3]^2*z[11]*z[14] -
8*f1*f8*z[3]^2*z[11]*z[15] + (-24*f0*f8 - 4*f1*f7 - 8*f2*f6)*z[3]^2*z[12]^2 +
(16*f0*f8 - 4*f1*f7)*z[3]^2*z[12]*z[13] + 8*f2*f7*z[3]^2*z[12]*z[14] +
16*f2*f8*z[3]^2*z[12]*z[15] - 24*f0*f8*z[3]^2*z[13]^2 +
16*f1*f8*z[3]^2*z[13]*z[14] - 16*f2*f8*z[3]^2*z[14]^2 + 8*f3*f8*z[3]^2*z[14]*z[15]
- 8*f4*f8*z[3]^2*z[15]^2 + 2*z[3]^2*z[16]^2 + (-32*f0*f1*f8^2 - 32*f0*f3*f6*f8 +
16*f0*f3*f7^2 - 32*f0*f4*f5*f8 - 16*f1^2*f7*f8 - 32*f1*f2*f6*f8 + 16*f1*f3*f5*f8 -
32*f1*f4^2*f8)*z[3]*z[4]*z[9]^2 + (32*f0*f3*f8 + 32*f1*f2*f8)*z[3]*z[4]*z[9]*z[10]
+ (-8*f0*f5*f7 - 16*f1*f3*f8)*z[3]*z[4]*z[9]*z[11] + (32*f1*f4*f8 +
8*f1*f5*f7)*z[3]*z[4]*z[9]*z[12] + (32*f0*f5*f8 +
32*f1*f4*f8)*z[3]*z[4]*z[9]*z[13] + (-8*f0*f7^2 - 32*f1*f5*f8 -
8*f3^2*f8)*z[3]*z[4]*z[9]*z[14] + (16*f0*f7*f8 + 64*f1*f6*f8 - 8*f1*f7^2 +
16*f3*f4*f8)*z[3]*z[4]*z[9]*z[15] - 32*f1*f8*z[3]*z[4]*z[9]*z[16] + (8*f0*f5 +
8*f1*f4)*z[3]*z[4]*z[10]^2 - 8*f1*f5*z[3]*z[4]*z[10]*z[11] + (-8*f0*f7 -
16*f1*f6)*z[3]*z[4]*z[10]*z[12] + 8*f1*f7*z[3]*z[4]*z[10]*z[14] -
16*f1*f8*z[3]*z[4]*z[10]*z[15] - 4*f3*z[3]*z[4]*z[10]*z[16] +
8*f1*f6*z[3]*z[4]*z[11]^2 + 8*f1*f7*z[3]*z[4]*z[11]*z[12] -
8*f1*f7*z[3]*z[4]*z[11]*z[13] + (16*f1*f8 + 8*f3*f6)*z[3]*z[4]*z[12]^2 -
16*f1*f8*z[3]*z[4]*z[12]*z[13] - 8*f3*f7*z[3]*z[4]*z[12]*z[14] -
16*f3*f8*z[3]*z[4]*z[12]*z[15] + 8*f1*f8*z[3]*z[4]*z[13]^2 -
8*f3*f8*z[3]*z[4]*z[13]*z[15] + 16*f3*f8*z[3]*z[4]*z[14]^2 + (-32*f0*f1*f8^2 -
32*f0*f2*f7*f8 - 32*f0*f4*f5*f8)*z[3]*z[5]*z[9]^2 + (16*f0*f3*f8 +
16*f0*f4*f7)*z[3]*z[5]*z[9]*z[10] - 8*f0*f5*f7*z[3]*z[5]*z[9]*z[11] +
32*f0*f5*f8*z[3]*z[5]*z[9]*z[13] + 32*f0*f7*f8*z[3]*z[5]*z[9]*z[15] -
16*f0*f7*z[3]*z[5]*z[10]*z[12] - 8*f0*f7*z[3]*z[5]*z[10]*z[13] +
16*f0*f7*z[3]*z[5]*z[11]^2 - 8*f1*f7*z[3]*z[5]*z[11]*z[12] + (8*f1*f8 +
8*f2*f7)*z[3]*z[5]*z[12]^2 - 8*f3*f8*z[3]*z[5]*z[12]*z[15] +
8*f5*f8*z[3]*z[5]*z[15]^2 - 4*f7*z[3]*z[5]*z[15]*z[16] + (-16*f0*f3*f7*f8 +
16*f0*f5^2*f8 + 16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 16*f1*f4*f5*f8)*z[3]*z[6]*z[9]^2 +
(-8*f0*f5*f7 - 8*f1*f3*f8 - 8*f1*f4*f7)*z[3]*z[6]*z[9]*z[10] +
4*f1*f5*f7*z[3]*z[6]*z[9]*z[11] + (8*f0*f7^2 - 16*f1*f5*f8 + 8*f1*f6*f7 +
8*f3^2*f8)*z[3]*z[6]*z[9]*z[12] - 16*f1*f5*f8*z[3]*z[6]*z[9]*z[13] -
4*f1*f7^2*z[3]*z[6]*z[9]*z[14] + (-8*f1*f7*f8 - 8*f3*f5*f8)*z[3]*z[6]*z[9]*z[15] +
f3*f7*z[3]*z[6]*z[9]*z[16] + 4*f1*f7*z[3]*z[6]*z[10]*z[12] +
4*f1*f7*z[3]*z[6]*z[10]*z[13] + 3*f3*f7*z[3]*z[6]*z[10]*z[15] -
4*f1*f7*z[3]*z[6]*z[11]^2 + f3*f7*z[3]*z[6]*z[11]*z[14] -
4*f3*f7*z[3]*z[6]*z[12]^2 - f3*f7*z[3]*z[6]*z[12]*z[13] + (32*f0*f3*f8^2 +
32*f0*f4*f7*f8 - 8*f0*f5*f7^2 - 8*f1*f3*f7*f8 - 8*f1*f5^2*f8)*z[3]*z[7]*z[9]^2 +
(-32*f0*f5*f8 + 16*f0*f6*f7 + 4*f1*f5*f7)*z[3]*z[7]*z[9]*z[10] + (16*f0*f7^2 +
16*f1*f5*f8 - 8*f1*f6*f7)*z[3]*z[7]*z[9]*z[11] + (-16*f1*f7^2 -
16*f3*f4*f8)*z[3]*z[7]*z[9]*z[12] + (-48*f0*f7*f8 +
4*f1*f7^2)*z[3]*z[7]*z[9]*z[13] + (32*f1*f7*f8 + 8*f3*f5*f8)*z[3]*z[7]*z[9]*z[14]
- 32*f1*f8^2*z[3]*z[7]*z[9]*z[15] + 8*f3*f8*z[3]*z[7]*z[9]*z[16] -
8*f0*f7*z[3]*z[7]*z[10]^2 + 4*f1*f7*z[3]*z[7]*z[10]*z[11] +
16*f1*f8*z[3]*z[7]*z[10]*z[12] - 4*f3*f7*z[3]*z[7]*z[10]*z[14] -
8*f1*f8*z[3]*z[7]*z[11]^2 - 8*f3*f8*z[3]*z[7]*z[12]^2 +
8*f3*f8*z[3]*z[7]*z[12]*z[13] + 4*f5*f7*z[3]*z[7]*z[12]*z[14] + (16*f5*f8 -
8*f6*f7)*z[3]*z[7]*z[12]*z[15] + 4*f7*z[3]*z[7]*z[12]*z[16] -
8*f5*f8*z[3]*z[7]*z[14]^2 + 4*f7^2*z[3]*z[7]*z[14]*z[15] -
8*f7*f8*z[3]*z[7]*z[15]^2 + (16*f0*f5*f8 + 16*f1*f4*f8)*z[3]*z[8]*z[9]^2 -
8*f0*f7*z[3]*z[8]*z[9]*z[10] + 4*f1*f7*z[3]*z[8]*z[9]*z[11] -
16*f1*f8*z[3]*z[8]*z[9]*z[13] - 8*f3*f8*z[3]*z[8]*z[9]*z[15] -
4*f1*z[3]*z[8]*z[10]^2 + 4*f3*z[3]*z[8]*z[10]*z[12] - 4*f5*z[3]*z[8]*z[12]^2 +
4*f7*z[3]*z[8]*z[12]*z[15] + (32*f0*f2*f8^2 - 16*f0*f3*f7*f8 + 96*f0*f4*f6*f8 -
16*f0*f4*f7^2 - 16*f0*f5^2*f8 + 16*f1*f2*f7*f8 - 32*f1*f3*f6*f8 + 16*f1*f4*f5*f8 +
32*f2^2*f6*f8 - 16*f2*f3*f5*f8 + 32*f2*f4^2*f8 - 8*f3^2*f4*f8)*z[4]^2*z[9]^2 +
(-64*f0*f4*f8 + 8*f0*f5*f7 + 24*f1*f3*f8 - 32*f2^2*f8)*z[4]^2*z[9]*z[10] +
(32*f0*f5*f8 - 16*f1*f4*f8 + 16*f2*f3*f8)*z[4]^2*z[9]*z[11] + (-16*f1*f5*f8 -
8*f3^2*f8)*z[4]^2*z[9]*z[12] + (-64*f0*f6*f8 + 8*f0*f7^2 - 32*f2*f4*f8 +
8*f3^2*f8)*z[4]^2*z[9]*z[13] + (16*f0*f7*f8 + 32*f1*f6*f8 +
16*f3*f4*f8)*z[4]^2*z[9]*z[14] + (-32*f0*f8^2 - 16*f1*f7*f8 - 32*f2*f6*f8 +
16*f3*f5*f8 - 32*f4^2*f8)*z[4]^2*z[9]*z[15] + 16*f2*f8*z[4]^2*z[9]*z[16] +
(-8*f0*f6 - 4*f1*f5 - 8*f2*f4 + 2*f3^2)*z[4]^2*z[10]^2 + (8*f0*f7 + 8*f1*f6 +
8*f2*f5)*z[4]^2*z[10]*z[11] + (16*f0*f8 - 4*f3*f5)*z[4]^2*z[10]*z[12] + (16*f0*f8
- 4*f1*f7)*z[4]^2*z[10]*z[13] - 16*f1*f8*z[4]^2*z[10]*z[14] +
16*f2*f8*z[4]^2*z[10]*z[15] + 8*f4*z[4]^2*z[10]*z[16] + (-24*f0*f8 - 4*f1*f7 -
8*f2*f6)*z[4]^2*z[11]^2 + (16*f1*f8 + 8*f3*f6)*z[4]^2*z[11]*z[12] + (8*f1*f8 +
8*f2*f7)*z[4]^2*z[11]*z[13] - 4*f3*f7*z[4]^2*z[11]*z[14] -
8*f3*f8*z[4]^2*z[11]*z[15] - 4*f5*z[4]^2*z[11]*z[16] + (-16*f2*f8 - 16*f4*f6 +
4*f5^2)*z[4]^2*z[12]^2 - 4*f3*f7*z[4]^2*z[12]*z[13] + (8*f3*f8 +
16*f4*f7)*z[4]^2*z[12]*z[14] + (16*f4*f8 - 8*f5*f7)*z[4]^2*z[12]*z[15] +
8*f6*z[4]^2*z[12]*z[16] - 8*f2*f8*z[4]^2*z[13]^2 + 8*f3*f8*z[4]^2*z[13]*z[14] +
16*f4*f8*z[4]^2*z[13]*z[15] - 32*f4*f8*z[4]^2*z[14]^2 +
16*f5*f8*z[4]^2*z[14]*z[15] - 4*f7*z[4]^2*z[14]*z[16] + (-16*f6*f8 +
4*f7^2)*z[4]^2*z[15]^2 + 8*f8*z[4]^2*z[15]*z[16] + (16*f0*f5^2*f8 + 16*f1^2*f8^2 +
16*f1*f2*f7*f8 + 16*f1*f4*f5*f8)*z[4]*z[5]*z[9]^2 + (-8*f0*f5*f7 - 8*f1*f3*f8 -
8*f1*f4*f7)*z[4]*z[5]*z[9]*z[10] + (-32*f0*f5*f8 + 16*f0*f6*f7 +
4*f1*f5*f7)*z[4]*z[5]*z[9]*z[11] + (8*f0*f7^2 + 16*f1*f5*f8 -
8*f1*f6*f7)*z[4]*z[5]*z[9]*z[12] + (-8*f0*f7^2 - 16*f1*f5*f8)*z[4]*z[5]*z[9]*z[13]
+ 4*f1*f7^2*z[4]*z[5]*z[9]*z[14] + (-24*f1*f7*f8 -
8*f3*f5*f8)*z[4]*z[5]*z[9]*z[15] + 3*f3*f7*z[4]*z[5]*z[9]*z[16] -
8*f0*f7*z[4]*z[5]*z[10]*z[11] + 12*f1*f7*z[4]*z[5]*z[10]*z[12] +
4*f1*f7*z[4]*z[5]*z[10]*z[13] + f3*f7*z[4]*z[5]*z[10]*z[15] + (16*f0*f8 -
4*f1*f7)*z[4]*z[5]*z[11]^2 - 16*f1*f8*z[4]*z[5]*z[11]*z[12] -
f3*f7*z[4]*z[5]*z[11]*z[14] + 8*f3*f8*z[4]*z[5]*z[11]*z[15] -
4*f3*f7*z[4]*z[5]*z[12]^2 + f3*f7*z[4]*z[5]*z[12]*z[13] + (-32*f0*f4*f7*f8 -
32*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 32*f1*f2*f8^2 + 24*f1*f3*f7*f8 - 16*f1*f5^2*f8 -
32*f2^2*f7*f8 - 32*f2*f4*f5*f8 + 8*f3^2*f5*f8)*z[4]*z[6]*z[9]^2 + (32*f0*f5*f8 +
8*f1*f5*f7 + 16*f2*f3*f8 + 16*f2*f4*f7 - 4*f3^2*f7)*z[4]*z[6]*z[9]*z[10] +
(-16*f0*f7^2 + 16*f1*f5*f8 - 8*f1*f6*f7 - 8*f2*f5*f7 -
8*f3^2*f8)*z[4]*z[6]*z[9]*z[11] + (-32*f0*f7*f8 + 4*f3*f5*f7)*z[4]*z[6]*z[9]*z[12]
+ (64*f0*f7*f8 + 4*f1*f7^2 + 32*f2*f5*f8)*z[4]*z[6]*z[9]*z[13] + (-32*f1*f7*f8 -
16*f3*f5*f8)*z[4]*z[6]*z[9]*z[14] + (32*f1*f8^2 + 32*f2*f7*f8 +
32*f4*f5*f8)*z[4]*z[6]*z[9]*z[15] + (-8*f3*f8 - 8*f4*f7)*z[4]*z[6]*z[9]*z[16] +
8*f0*f7*z[4]*z[6]*z[10]^2 - 4*f1*f7*z[4]*z[6]*z[10]*z[11] -
8*f2*f7*z[4]*z[6]*z[10]*z[13] + 4*f3*f7*z[4]*z[6]*z[10]*z[14] + (-8*f3*f8 -
8*f4*f7)*z[4]*z[6]*z[10]*z[15] + 8*f2*f7*z[4]*z[6]*z[11]^2 -
8*f3*f7*z[4]*z[6]*z[11]*z[12] + 4*f5*f7*z[4]*z[6]*z[11]*z[15] + (8*f3*f8 +
16*f4*f7)*z[4]*z[6]*z[12]^2 - 8*f5*f7*z[4]*z[6]*z[12]*z[14] + (-16*f5*f8 +
8*f6*f7)*z[4]*z[6]*z[12]*z[15] - 12*f7*z[4]*z[6]*z[12]*z[16] -
16*f5*f8*z[4]*z[6]*z[13]*z[15] + 4*f7*z[4]*z[6]*z[13]*z[16] +
16*f5*f8*z[4]*z[6]*z[14]^2 - 4*f7^2*z[4]*z[6]*z[14]*z[15] +
8*f7*f8*z[4]*z[6]*z[15]^2 + (-64*f0*f4*f8^2 + 32*f0*f5*f7*f8 + 16*f1*f3*f8^2 -
16*f1*f4*f7*f8 + 16*f1*f5*f6*f8 + 16*f2*f3*f7*f8 + 16*f2*f5^2*f8)*z[4]*z[7]*z[9]^2
+ (-16*f0*f7^2 - 8*f1*f6*f7 - 8*f2*f5*f7 - 8*f3^2*f8)*z[4]*z[7]*z[9]*z[10] +
(-32*f0*f7*f8 + 8*f1*f7^2 - 32*f2*f5*f8 + 16*f2*f6*f7 +
16*f3*f4*f8)*z[4]*z[7]*z[9]*z[11] + (32*f1*f7*f8 + 16*f3*f5*f8 -
8*f3*f6*f7)*z[4]*z[7]*z[9]*z[12] + (64*f0*f8^2 - 8*f1*f7*f8 - 8*f2*f7^2 -
8*f3*f5*f8)*z[4]*z[7]*z[9]*z[13] + (-32*f1*f8^2 + 4*f3*f7^2)*z[4]*z[7]*z[9]*z[14]
+ (-16*f3*f7*f8 - 16*f5^2*f8)*z[4]*z[7]*z[9]*z[15] + 4*f5*f7*z[4]*z[7]*z[9]*z[16]
+ (16*f0*f8 + 4*f1*f7)*z[4]*z[7]*z[10]^2 + (-16*f1*f8 -
8*f2*f7)*z[4]*z[7]*z[10]*z[11] + 4*f3*f7*z[4]*z[7]*z[10]*z[12] +
4*f3*f7*z[4]*z[7]*z[10]*z[13] + 8*f3*f8*z[4]*z[7]*z[10]*z[14] +
4*f5*f7*z[4]*z[7]*z[10]*z[15] + 16*f2*f8*z[4]*z[7]*z[11]^2 -
16*f3*f8*z[4]*z[7]*z[11]*z[12] - 8*f3*f8*z[4]*z[7]*z[11]*z[13] + (16*f5*f8 -
8*f6*f7)*z[4]*z[7]*z[11]*z[15] + 4*f7*z[4]*z[7]*z[11]*z[16] + (16*f4*f8 -
8*f5*f7)*z[4]*z[7]*z[12]^2 + (-16*f5*f8 + 8*f6*f7)*z[4]*z[7]*z[12]*z[14] +
8*f7^2*z[4]*z[7]*z[12]*z[15] - 16*f8*z[4]*z[7]*z[12]*z[16] +
4*f7^2*z[4]*z[7]*z[13]*z[15] - 4*f7^2*z[4]*z[7]*z[14]^2 -
8*f7*f8*z[4]*z[7]*z[14]*z[15] + 16*f8^2*z[4]*z[7]*z[15]^2 + (-32*f0*f6*f8 +
8*f0*f7^2 - 8*f1*f5*f8 - 32*f2*f4*f8 + 8*f3^2*f8)*z[4]*z[8]*z[9]^2 + (32*f0*f8 +
4*f1*f7)*z[4]*z[8]*z[9]*z[10] - 8*f2*f7*z[4]*z[8]*z[9]*z[11] +
4*f3*f7*z[4]*z[8]*z[9]*z[12] + 32*f2*f8*z[4]*z[8]*z[9]*z[13] -
24*f3*f8*z[4]*z[8]*z[9]*z[14] + 32*f4*f8*z[4]*z[8]*z[9]*z[15] +
8*f2*z[4]*z[8]*z[10]^2 - 4*f3*z[4]*z[8]*z[10]*z[11] - 8*z[4]*z[8]*z[10]*z[16] +
4*f7*z[4]*z[8]*z[11]*z[15] + 8*f6*z[4]*z[8]*z[12]^2 - 12*f7*z[4]*z[8]*z[12]*z[14]
- 16*f8*z[4]*z[8]*z[12]*z[15] - 16*f8*z[4]*z[8]*z[13]*z[15] +
24*f8*z[4]*z[8]*z[14]^2 + (32*f0*f2*f8^2 + 32*f0*f4*f6*f8 -
8*f0*f4*f7^2)*z[5]^2*z[9]^2 - 32*f0*f4*f8*z[5]^2*z[9]*z[10] +
16*f0*f5*f8*z[5]^2*z[9]*z[11] + (-32*f0*f6*f8 + 8*f0*f7^2)*z[5]^2*z[9]*z[13] -
32*f0*f8^2*z[5]^2*z[9]*z[15] + 16*f0*f8*z[5]^2*z[10]*z[12] +
16*f0*f8*z[5]^2*z[10]*z[13] - 24*f0*f8*z[5]^2*z[11]^2 + 8*f1*f8*z[5]^2*z[11]*z[12]
- 8*f2*f8*z[5]^2*z[12]^2 + (-8*f6*f8 + 2*f7^2)*z[5]^2*z[15]^2 +
8*f8*z[5]^2*z[15]*z[16] + (-32*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 32*f1*f2*f8^2 -
32*f1*f4*f6*f8 + 8*f1*f4*f7^2)*z[5]*z[6]*z[9]^2 + (32*f0*f5*f8 +
32*f1*f4*f8)*z[5]*z[6]*z[9]*z[10] + (-8*f0*f7^2 -
16*f1*f5*f8)*z[5]*z[6]*z[9]*z[11] - 16*f0*f7*f8*z[5]*z[6]*z[9]*z[12] +
(16*f0*f7*f8 + 32*f1*f6*f8 - 8*f1*f7^2)*z[5]*z[6]*z[9]*z[13] + (32*f1*f8^2 +
16*f3*f6*f8 - 4*f3*f7^2)*z[5]*z[6]*z[9]*z[15] - 8*f3*f8*z[5]*z[6]*z[9]*z[16] -
16*f1*f8*z[5]*z[6]*z[10]*z[12] - 16*f1*f8*z[5]*z[6]*z[10]*z[13] -
8*f3*f8*z[5]*z[6]*z[10]*z[15] + 16*f1*f8*z[5]*z[6]*z[11]^2 +
8*f3*f8*z[5]*z[6]*z[12]^2 + (-64*f0*f4*f8^2 + 16*f0*f5*f7*f8 + 16*f1*f3*f8^2 +
16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[5]*z[7]*z[9]^2 + (-8*f0*f7^2 -
16*f1*f5*f8)*z[5]*z[7]*z[9]*z[10] + (-16*f0*f7*f8 +
4*f1*f7^2)*z[5]*z[7]*z[9]*z[11] + (16*f1*f7*f8 + 8*f3*f5*f8)*z[5]*z[7]*z[9]*z[12]
+ (64*f0*f8^2 - 8*f1*f7*f8)*z[5]*z[7]*z[9]*z[13] + (-32*f1*f8^2 - 16*f3*f6*f8 +
4*f3*f7^2)*z[5]*z[7]*z[9]*z[14] + 16*f0*f8*z[5]*z[7]*z[10]^2 +
8*f3*f8*z[5]*z[7]*z[10]*z[14] - 8*f3*f8*z[5]*z[7]*z[11]*z[12] +
16*f4*f8*z[5]*z[7]*z[12]^2 - 16*f5*f8*z[5]*z[7]*z[12]*z[14] +
4*f7^2*z[5]*z[7]*z[12]*z[15] - 16*f8*z[5]*z[7]*z[12]*z[16] + (16*f6*f8 -
4*f7^2)*z[5]*z[7]*z[14]^2 - 8*f7*f8*z[5]*z[7]*z[14]*z[15] +
16*f8^2*z[5]*z[7]*z[15]^2 - 8*f1*f5*f8*z[5]*z[8]*z[9]^2 +
4*f1*f7*z[5]*z[8]*z[9]*z[10] - 4*f3*f7*z[5]*z[8]*z[9]*z[12] +
8*f3*f8*z[5]*z[8]*z[9]*z[14] + 4*f7*z[5]*z[8]*z[12]*z[14] - 8*f8*z[5]*z[8]*z[14]^2
+ (64*f0*f4*f8^2 - 16*f0*f5*f7*f8 + 32*f0*f6^2*f8 - 8*f0*f6*f7^2 - 16*f1*f3*f8^2 +
16*f1*f5*f6*f8 - 4*f1*f5*f7^2 + 32*f2^2*f8^2 + 32*f2*f4*f6*f8 - 8*f2*f4*f7^2 -
8*f3^2*f6*f8 + 2*f3^2*f7^2)*z[6]^2*z[9]^2 + (-32*f0*f6*f8 + 8*f0*f7^2 -
16*f1*f5*f8 - 32*f2*f4*f8 + 8*f3^2*f8)*z[6]^2*z[9]*z[10] + (32*f0*f7*f8 +
4*f1*f7^2 + 16*f2*f5*f8)*z[6]^2*z[9]*z[11] + (32*f0*f8^2 -
8*f3*f5*f8)*z[6]^2*z[9]*z[12] + (-96*f0*f8^2 - 8*f1*f7*f8 - 32*f2*f6*f8 +
8*f2*f7^2)*z[6]^2*z[9]*z[13] + (32*f1*f8^2 + 16*f3*f6*f8 -
4*f3*f7^2)*z[6]^2*z[9]*z[14] + (-32*f2*f8^2 - 32*f4*f6*f8 +
8*f4*f7^2)*z[6]^2*z[9]*z[15] + 16*f4*f8*z[6]^2*z[9]*z[16] -
16*f0*f8*z[6]^2*z[10]^2 + 8*f1*f8*z[6]^2*z[10]*z[11] + 16*f2*f8*z[6]^2*z[10]*z[13]
- 8*f3*f8*z[6]^2*z[10]*z[14] + 16*f4*f8*z[6]^2*z[10]*z[15] -
16*f2*f8*z[6]^2*z[11]^2 + 16*f3*f8*z[6]^2*z[11]*z[12] - 8*f5*f8*z[6]^2*z[11]*z[15]
- 32*f4*f8*z[6]^2*z[12]^2 + 16*f5*f8*z[6]^2*z[12]*z[14] -
4*f7^2*z[6]^2*z[12]*z[15] + 24*f8*z[6]^2*z[12]*z[16] + (16*f6*f8 -
4*f7^2)*z[6]^2*z[13]*z[15] - 8*f8*z[6]^2*z[13]*z[16] + (-16*f6*f8 +
4*f7^2)*z[6]^2*z[14]^2 + 8*f7*f8*z[6]^2*z[14]*z[15] - 16*f8^2*z[6]^2*z[15]^2 +
(-32*f0*f6*f7*f8 + 8*f0*f7^3 + 8*f1*f5*f7*f8 - 32*f1*f6^2*f8 + 8*f1*f6*f7^2 -
32*f2*f3*f8^2 - 32*f2*f5*f6*f8 + 8*f2*f5*f7^2)*z[6]*z[7]*z[9]^2 + (32*f0*f7*f8 +
32*f1*f6*f8 - 4*f1*f7^2 + 32*f2*f5*f8)*z[6]*z[7]*z[9]*z[10] + (-24*f1*f7*f8 -
8*f2*f7^2 - 8*f3*f5*f8)*z[6]*z[7]*z[9]*z[11] + (-32*f1*f8^2 +
4*f3*f7^2)*z[6]*z[7]*z[9]*z[12] + (32*f1*f8^2 + 16*f2*f7*f8 + 16*f3*f6*f8 -
4*f3*f7^2)*z[6]*z[7]*z[9]*z[13] - 8*f3*f7*f8*z[6]*z[7]*z[9]*z[14] + (32*f3*f8^2 +
32*f5*f6*f8 - 8*f5*f7^2)*z[6]*z[7]*z[9]*z[15] - 16*f5*f8*z[6]*z[7]*z[9]*z[16] -
8*f3*f8*z[6]*z[7]*z[10]*z[12] - 8*f3*f8*z[6]*z[7]*z[10]*z[13] -
16*f5*f8*z[6]*z[7]*z[10]*z[15] + 8*f3*f8*z[6]*z[7]*z[11]^2 +
4*f7^2*z[6]*z[7]*z[11]*z[15] + 16*f5*f8*z[6]*z[7]*z[12]^2 -
4*f7^2*z[6]*z[7]*z[12]*z[14] - 8*f7*f8*z[6]*z[7]*z[12]*z[15] -
8*f7*f8*z[6]*z[7]*z[13]*z[15] + 8*f7*f8*z[6]*z[7]*z[14]^2 + (16*f1*f6*f8 -
4*f1*f7^2 + 16*f2*f5*f8)*z[6]*z[8]*z[9]^2 + (-16*f1*f8 -
8*f2*f7)*z[6]*z[8]*z[9]*z[10] + 4*f3*f7*z[6]*z[8]*z[9]*z[11] +
8*f3*f8*z[6]*z[8]*z[9]*z[12] - 8*f3*f8*z[6]*z[8]*z[9]*z[13] -
16*f5*f8*z[6]*z[8]*z[9]*z[15] + 4*f7*z[6]*z[8]*z[9]*z[16] +
4*f7*z[6]*z[8]*z[10]*z[15] - 4*f7*z[6]*z[8]*z[12]^2 + (32*f0*f6*f8^2 -
8*f0*f7^2*f8 - 16*f1*f5*f8^2 + 16*f1*f6*f7*f8 - 4*f1*f7^3 + 32*f2*f4*f8^2 -
16*f2*f5*f7*f8 + 32*f2*f6^2*f8 - 8*f2*f6*f7^2)*z[7]^2*z[9]^2 + (-32*f0*f8^2 -
8*f1*f7*f8 - 32*f2*f6*f8 + 8*f2*f7^2)*z[7]^2*z[9]*z[10] + (16*f1*f8^2 +
16*f2*f7*f8)*z[7]^2*z[9]*z[11] - 8*f3*f7*f8*z[7]^2*z[9]*z[12] -
32*f2*f8^2*z[7]^2*z[9]*z[13] + 16*f3*f8^2*z[7]^2*z[9]*z[14] + (-32*f4*f8^2 +
16*f5*f7*f8 - 32*f6^2*f8 + 8*f6*f7^2)*z[7]^2*z[9]*z[15] + (16*f6*f8 -
4*f7^2)*z[7]^2*z[9]*z[16] - 8*f2*f8*z[7]^2*z[10]^2 + 8*f3*f8*z[7]^2*z[10]*z[11] +
(16*f6*f8 - 4*f7^2)*z[7]^2*z[10]*z[15] + 8*f8*z[7]^2*z[10]*z[16] -
8*f4*f8*z[7]^2*z[11]^2 + 8*f5*f8*z[7]^2*z[11]*z[13] - 8*f7*f8*z[7]^2*z[11]*z[15] +
(-16*f6*f8 + 4*f7^2)*z[7]^2*z[12]^2 + 8*f7*f8*z[7]^2*z[12]*z[14] +
16*f8^2*z[7]^2*z[12]*z[15] + (-8*f6*f8 + 2*f7^2)*z[7]^2*z[13]^2 +
16*f8^2*z[7]^2*z[13]*z[15] - 16*f8^2*z[7]^2*z[14]^2 + (-32*f2*f6*f8 +
8*f2*f7^2)*z[7]*z[8]*z[9]^2 + 32*f2*f8*z[7]*z[8]*z[9]*z[10] -
8*f3*f8*z[7]*z[8]*z[9]*z[11] + (32*f6*f8 - 8*f7^2)*z[7]*z[8]*z[9]*z[15] -
16*f8*z[7]*z[8]*z[9]*z[16] - 16*f8*z[7]*z[8]*z[10]*z[15] -
4*f7*z[7]*z[8]*z[11]*z[13] + 8*f8*z[7]*z[8]*z[12]^2 + 8*f8*z[7]*z[8]*z[13]^2 +
2*z[8]^2*z[11]^2,

// Bmat[4,1]
  (64*f0*f2*f4*f6*f8 - 16*f0*f2*f4*f7^2 - 16*f0*f2*f5^2*f8 - 16*f0*f3^2*f6*f8 +
4*f0*f3^2*f7^2 - 16*f1^2*f4*f6*f8 + 4*f1^2*f4*f7^2 + 4*f1^2*f5^2*f8)*z[1]^2*z[9]^2
+ (-32*f0*f2*f4*f8 + 8*f0*f2*f5*f7 + 8*f0*f3^2*f8 + 8*f1^2*f4*f8 -
2*f1^2*f5*f7)*z[1]^2*z[9]*z[10] + (16*f0*f2*f5*f8 - 4*f0*f3*f5*f7 -
4*f1^2*f5*f8)*z[1]^2*z[9]*z[11] + (-8*f0*f3*f5*f8 +
2*f1*f3*f5*f7)*z[1]^2*z[9]*z[12] + (-32*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 8*f0*f3*f5*f8
+ 8*f1^2*f6*f8 - 2*f1^2*f7^2)*z[1]^2*z[9]*z[13] + (16*f0*f3*f6*f8 - 4*f0*f3*f7^2 -
4*f1*f3*f5*f8)*z[1]^2*z[9]*z[14] + (-32*f0*f4*f6*f8 + 8*f0*f4*f7^2 + 8*f0*f5^2*f8
+ 8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*z[1]^2*z[9]*z[15] + (8*f0*f4*f8 - 2*f0*f5*f7 -
2*f1*f3*f8)*z[1]^2*z[9]*z[16] + (-8*f0*f2*f7 + 2*f1^2*f7)*z[1]^2*z[10]*z[11] +
4*f0*f3*f7*z[1]^2*z[10]*z[12] + (16*f0*f2*f8 - 4*f1^2*f8)*z[1]^2*z[10]*z[13] -
8*f0*f3*f8*z[1]^2*z[10]*z[14] + (8*f0*f4*f8 - 2*f0*f5*f7 -
2*f1*f3*f8)*z[1]^2*z[10]*z[15] + 4*f0*f3*f7*z[1]^2*z[11]^2 + (-8*f0*f4*f7 -
2*f1*f3*f7)*z[1]^2*z[11]*z[12] - 8*f0*f3*f8*z[1]^2*z[11]*z[13] + (8*f0*f4*f8 +
2*f0*f5*f7 + 2*f1*f3*f8)*z[1]^2*z[11]*z[14] - 8*f0*f5*f8*z[1]^2*z[11]*z[15] +
4*f0*f7*z[1]^2*z[11]*z[16] + 4*f1*f4*f7*z[1]^2*z[12]^2 + (8*f0*f4*f8 + 2*f0*f5*f7
+ 2*f1*f3*f8)*z[1]^2*z[12]*z[13] + (-8*f1*f4*f8 - 2*f1*f5*f7)*z[1]^2*z[12]*z[14] +
4*f1*f5*f8*z[1]^2*z[12]*z[15] - 2*f1*f7*z[1]^2*z[12]*z[16] -
8*f0*f5*f8*z[1]^2*z[13]*z[14] + (16*f0*f6*f8 - 4*f0*f7^2)*z[1]^2*z[13]*z[15] -
8*f0*f8*z[1]^2*z[13]*z[16] + 4*f1*f5*f8*z[1]^2*z[14]^2 + (-8*f1*f6*f8 +
2*f1*f7^2)*z[1]^2*z[14]*z[15] + 4*f1*f8*z[1]^2*z[14]*z[16] + (-32*f0*f2*f4*f8 +
8*f0*f2*f5*f7 + 8*f0*f3^2*f8 + 8*f1^2*f4*f8 - 2*f1^2*f5*f7)*z[1]*z[2]*z[9]^2 +
(-16*f0*f2*f6 + 4*f1^2*f6)*z[1]*z[2]*z[9]*z[10] + 8*f0*f3*f6*z[1]*z[2]*z[9]*z[11]
- 4*f1*f3*f6*z[1]*z[2]*z[9]*z[12] + (16*f0*f2*f8 - 4*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[2]*z[9]*z[13] + (-8*f0*f3*f8 + 2*f1*f3*f7)*z[1]*z[2]*z[9]*z[14]
+ (16*f0*f4*f8 - 4*f0*f5*f7 - 4*f1*f3*f8)*z[1]*z[2]*z[9]*z[15] +
4*f0*f6*z[1]*z[2]*z[9]*z[16] + (8*f0*f2 - 2*f1^2)*z[1]*z[2]*z[10]^2 -
4*f0*f3*z[1]*z[2]*z[10]*z[11] + 2*f1*f3*z[1]*z[2]*z[10]*z[12] +
4*f0*f6*z[1]*z[2]*z[10]*z[15] - 4*f0*z[1]*z[2]*z[10]*z[16] +
4*f0*f5*z[1]*z[2]*z[11]*z[12] - 4*f0*f6*z[1]*z[2]*z[11]*z[14] -
2*f1*f5*z[1]*z[2]*z[12]^2 - 4*f0*f6*z[1]*z[2]*z[12]*z[13] +
4*f1*f6*z[1]*z[2]*z[12]*z[14] + 4*f0*f7*z[1]*z[2]*z[13]*z[14] -
8*f0*f8*z[1]*z[2]*z[13]*z[15] - 2*f1*f7*z[1]*z[2]*z[14]^2 +
4*f1*f8*z[1]*z[2]*z[14]*z[15] + (16*f0*f2*f5*f8 - 4*f0*f3*f5*f7 -
4*f1^2*f5*f8)*z[1]*z[3]*z[9]^2 + 8*f0*f3*f6*z[1]*z[3]*z[9]*z[10] + (-16*f0*f2*f8 -
16*f0*f4*f6 + 4*f0*f5^2 + 4*f1^2*f8)*z[1]*z[3]*z[9]*z[11] + (8*f0*f3*f8 +
8*f1*f4*f6 - 2*f1*f5^2)*z[1]*z[3]*z[9]*z[12] + 8*f0*f4*f7*z[1]*z[3]*z[9]*z[13] -
4*f1*f4*f7*z[1]*z[3]*z[9]*z[14] + (-8*f0*f5*f8 + 2*f1*f5*f7)*z[1]*z[3]*z[9]*z[15]
- 2*f1*f6*z[1]*z[3]*z[9]*z[16] - 4*f0*f3*z[1]*z[3]*z[10]^2 +
8*f0*f4*z[1]*z[3]*z[10]*z[11] - 4*f1*f4*z[1]*z[3]*z[10]*z[12] -
4*f0*f5*z[1]*z[3]*z[10]*z[13] + 2*f1*f5*z[1]*z[3]*z[10]*z[14] -
2*f1*f6*z[1]*z[3]*z[10]*z[15] + 2*f1*z[1]*z[3]*z[10]*z[16] -
4*f0*f5*z[1]*z[3]*z[11]^2 + 2*f1*f5*z[1]*z[3]*z[11]*z[12] +
8*f0*f6*z[1]*z[3]*z[11]*z[13] - 2*f1*f6*z[1]*z[3]*z[11]*z[14] +
8*f0*f8*z[1]*z[3]*z[11]*z[15] - 2*f1*f6*z[1]*z[3]*z[12]*z[13] -
4*f1*f8*z[1]*z[3]*z[12]*z[15] - 4*f0*f7*z[1]*z[3]*z[13]^2 +
2*f1*f7*z[1]*z[3]*z[13]*z[14] + (-8*f0*f3*f5*f8 + 2*f1*f3*f5*f7)*z[1]*z[4]*z[9]^2
- 4*f1*f3*f6*z[1]*z[4]*z[9]*z[10] + (8*f0*f3*f8 + 8*f1*f4*f6 -
2*f1*f5^2)*z[1]*z[4]*z[9]*z[11] + (-16*f0*f4*f8 - 16*f2*f4*f6 + 4*f2*f5^2 +
4*f3^2*f6)*z[1]*z[4]*z[9]*z[12] - 4*f1*f4*f7*z[1]*z[4]*z[9]*z[13] + (8*f0*f5*f8 +
8*f2*f4*f7 - 2*f3^2*f7)*z[1]*z[4]*z[9]*z[14] - 4*f2*f5*f7*z[1]*z[4]*z[9]*z[15] +
(4*f0*f8 + 4*f2*f6 - f3*f5)*z[1]*z[4]*z[9]*z[16] + 2*f1*f3*z[1]*z[4]*z[10]^2 -
4*f1*f4*z[1]*z[4]*z[10]*z[11] + (8*f2*f4 - 2*f3^2)*z[1]*z[4]*z[10]*z[12] +
2*f1*f5*z[1]*z[4]*z[10]*z[13] - 4*f2*f5*z[1]*z[4]*z[10]*z[14] + (-4*f0*f8 +
4*f2*f6 + f3*f5)*z[1]*z[4]*z[10]*z[15] - 4*f2*z[1]*z[4]*z[10]*z[16] +
2*f1*f5*z[1]*z[4]*z[11]^2 - 4*f2*f5*z[1]*z[4]*z[11]*z[12] -
4*f1*f6*z[1]*z[4]*z[11]*z[13] + (-4*f0*f8 + 4*f2*f6 + f3*f5)*z[1]*z[4]*z[11]*z[14]
- 4*f3*f6*z[1]*z[4]*z[11]*z[15] + 2*f3*z[1]*z[4]*z[11]*z[16] +
2*f3*f5*z[1]*z[4]*z[12]^2 + (4*f0*f8 + 4*f2*f6 - f3*f5)*z[1]*z[4]*z[12]*z[13] -
4*f3*f6*z[1]*z[4]*z[12]*z[14] + (8*f4*f6 - 2*f5^2)*z[1]*z[4]*z[12]*z[15] -
4*f4*z[1]*z[4]*z[12]*z[16] + 2*f1*f7*z[1]*z[4]*z[13]^2 -
4*f2*f7*z[1]*z[4]*z[13]*z[14] + 2*f3*f7*z[1]*z[4]*z[13]*z[15] +
2*f3*f7*z[1]*z[4]*z[14]^2 - 4*f4*f7*z[1]*z[4]*z[14]*z[15] +
2*f5*z[1]*z[4]*z[14]*z[16] + 2*f5*f7*z[1]*z[4]*z[15]^2 -
4*f6*z[1]*z[4]*z[15]*z[16] + 2*z[1]*z[4]*z[16]^2 + (-32*f0*f2*f6*f8 + 8*f0*f2*f7^2
+ 8*f0*f3*f5*f8 + 8*f1^2*f6*f8 - 2*f1^2*f7^2)*z[1]*z[5]*z[9]^2 + (16*f0*f2*f8 -
4*f0*f3*f7 - 4*f1^2*f8)*z[1]*z[5]*z[9]*z[10] + 8*f0*f4*f7*z[1]*z[5]*z[9]*z[11] -
4*f1*f4*f7*z[1]*z[5]*z[9]*z[12] - 16*f0*f4*f8*z[1]*z[5]*z[9]*z[13] +
8*f1*f4*f8*z[1]*z[5]*z[9]*z[14] + (16*f0*f6*f8 - 4*f0*f7^2 -
4*f1*f5*f8)*z[1]*z[5]*z[9]*z[15] + (-4*f0*f8 + f1*f7)*z[1]*z[5]*z[9]*z[16] +
(-4*f0*f8 + f1*f7)*z[1]*z[5]*z[10]*z[15] + 4*f0*f7*z[1]*z[5]*z[11]*z[12] -
4*f0*f7*z[1]*z[5]*z[11]*z[13] + (-4*f0*f8 + f1*f7)*z[1]*z[5]*z[11]*z[14] -
2*f1*f7*z[1]*z[5]*z[12]^2 + (-4*f0*f8 + f1*f7)*z[1]*z[5]*z[12]*z[13] +
4*f1*f8*z[1]*z[5]*z[12]*z[14] + 8*f0*f8*z[1]*z[5]*z[13]^2 -
4*f1*f8*z[1]*z[5]*z[13]*z[14] + (16*f0*f3*f6*f8 - 4*f0*f3*f7^2 -
4*f1*f3*f5*f8)*z[1]*z[6]*z[9]^2 + (-8*f0*f3*f8 + 2*f1*f3*f7)*z[1]*z[6]*z[9]*z[10]
- 4*f1*f4*f7*z[1]*z[6]*z[9]*z[11] + (8*f0*f5*f8 + 8*f2*f4*f7 -
2*f3^2*f7)*z[1]*z[6]*z[9]*z[12] + 8*f1*f4*f8*z[1]*z[6]*z[9]*z[13] + (-16*f0*f6*f8
+ 4*f0*f7^2 - 16*f2*f4*f8 + 4*f3^2*f8)*z[1]*z[6]*z[9]*z[14] +
8*f2*f5*f8*z[1]*z[6]*z[9]*z[15] - 2*f2*f7*z[1]*z[6]*z[9]*z[16] -
4*f0*f7*z[1]*z[6]*z[10]*z[12] + 8*f0*f8*z[1]*z[6]*z[10]*z[14] -
2*f2*f7*z[1]*z[6]*z[10]*z[15] + 2*f1*f7*z[1]*z[6]*z[11]*z[13] -
2*f2*f7*z[1]*z[6]*z[11]*z[14] + 2*f3*f7*z[1]*z[6]*z[11]*z[15] -
2*f2*f7*z[1]*z[6]*z[12]*z[13] + 2*f3*f7*z[1]*z[6]*z[12]*z[14] -
4*f4*f7*z[1]*z[6]*z[12]*z[15] - 4*f1*f8*z[1]*z[6]*z[13]^2 +
8*f2*f8*z[1]*z[6]*z[13]*z[14] - 4*f3*f8*z[1]*z[6]*z[13]*z[15] -
4*f3*f8*z[1]*z[6]*z[14]^2 + 8*f4*f8*z[1]*z[6]*z[14]*z[15] -
4*f5*f8*z[1]*z[6]*z[15]^2 + 2*f7*z[1]*z[6]*z[15]*z[16] + (-32*f0*f4*f6*f8 +
8*f0*f4*f7^2 + 8*f0*f5^2*f8 + 8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*z[1]*z[7]*z[9]^2 +
(16*f0*f4*f8 - 4*f0*f5*f7 - 4*f1*f3*f8)*z[1]*z[7]*z[9]*z[10] + (-8*f0*f5*f8 +
2*f1*f5*f7)*z[1]*z[7]*z[9]*z[11] - 4*f2*f5*f7*z[1]*z[7]*z[9]*z[12] + (16*f0*f6*f8
- 4*f0*f7^2 - 4*f1*f5*f8)*z[1]*z[7]*z[9]*z[13] + 8*f2*f5*f8*z[1]*z[7]*z[9]*z[14] +
(-16*f2*f6*f8 + 4*f2*f7^2)*z[1]*z[7]*z[9]*z[15] + 4*f2*f8*z[1]*z[7]*z[9]*z[16] +
4*f0*f7*z[1]*z[7]*z[10]*z[11] - 8*f0*f8*z[1]*z[7]*z[10]*z[13] +
4*f2*f8*z[1]*z[7]*z[10]*z[15] - 2*f1*f7*z[1]*z[7]*z[11]^2 +
4*f2*f7*z[1]*z[7]*z[11]*z[12] + 4*f1*f8*z[1]*z[7]*z[11]*z[13] -
4*f2*f8*z[1]*z[7]*z[11]*z[14] - 2*f3*f7*z[1]*z[7]*z[12]^2 -
4*f2*f8*z[1]*z[7]*z[12]*z[13] + 4*f3*f8*z[1]*z[7]*z[12]*z[14] +
2*f5*f7*z[1]*z[7]*z[12]*z[15] - 4*f5*f8*z[1]*z[7]*z[14]*z[15] + (8*f6*f8 -
2*f7^2)*z[1]*z[7]*z[15]^2 - 4*f8*z[1]*z[7]*z[15]*z[16] + (8*f0*f4*f8 - 2*f0*f5*f7
- 2*f1*f3*f8)*z[1]*z[8]*z[9]^2 + 4*f0*f6*z[1]*z[8]*z[9]*z[10] -
2*f1*f6*z[1]*z[8]*z[9]*z[11] + (4*f0*f8 + 4*f2*f6 - f3*f5)*z[1]*z[8]*z[9]*z[12] +
(-4*f0*f8 + f1*f7)*z[1]*z[8]*z[9]*z[13] - 2*f2*f7*z[1]*z[8]*z[9]*z[14] +
4*f2*f8*z[1]*z[8]*z[9]*z[15] + f4*z[1]*z[8]*z[9]*z[16] - 2*f0*z[1]*z[8]*z[10]^2 +
f1*z[1]*z[8]*z[10]*z[11] - 2*f2*z[1]*z[8]*z[10]*z[12] + f3*z[1]*z[8]*z[10]*z[14] -
f4*z[1]*z[8]*z[10]*z[15] - f4*z[1]*z[8]*z[11]*z[14] + f5*z[1]*z[8]*z[11]*z[15] +
f4*z[1]*z[8]*z[12]*z[13] - 2*f6*z[1]*z[8]*z[12]*z[15] + z[1]*z[8]*z[12]*z[16] -
z[1]*z[8]*z[13]*z[16] + f7*z[1]*z[8]*z[14]*z[15] - 2*f8*z[1]*z[8]*z[15]^2 +
(8*f0*f2 - 2*f1^2)*z[2]^2*z[9]*z[10] - 4*f0*f3*z[2]^2*z[9]*z[11] +
2*f1*f3*z[2]^2*z[9]*z[12] - 2*f0*z[2]^2*z[9]*z[16] - 2*f0*z[2]^2*z[10]*z[15] +
2*f0*z[2]^2*z[11]*z[14] + 2*f0*z[2]^2*z[12]*z[13] - 2*f1*z[2]^2*z[12]*z[14] +
(-8*f0*f2*f7 + 2*f1^2*f7)*z[2]*z[3]*z[9]^2 - 4*f0*f3*z[2]*z[3]*z[9]*z[10] +
8*f0*f4*z[2]*z[3]*z[9]*z[11] - 4*f1*f4*z[2]*z[3]*z[9]*z[12] +
4*f0*f7*z[2]*z[3]*z[9]*z[15] + f1*z[2]*z[3]*z[9]*z[16] + f1*z[2]*z[3]*z[10]*z[15]
- 4*f0*z[2]*z[3]*z[11]*z[12] - 4*f0*z[2]*z[3]*z[11]*z[13] +
f1*z[2]*z[3]*z[11]*z[14] + 2*f1*z[2]*z[3]*z[12]^2 + f1*z[2]*z[3]*z[12]*z[13] +
4*f0*f3*f7*z[2]*z[4]*z[9]^2 + 2*f1*f3*z[2]*z[4]*z[9]*z[10] -
4*f1*f4*z[2]*z[4]*z[9]*z[11] + (8*f2*f4 - 2*f3^2)*z[2]*z[4]*z[9]*z[12] -
4*f0*f7*z[2]*z[4]*z[9]*z[14] - 2*f2*z[2]*z[4]*z[9]*z[16] +
4*f0*z[2]*z[4]*z[10]*z[12] - 2*f2*z[2]*z[4]*z[10]*z[15] +
2*f1*z[2]*z[4]*z[11]*z[13] - 2*f2*z[2]*z[4]*z[11]*z[14] +
2*f3*z[2]*z[4]*z[11]*z[15] - 2*f2*z[2]*z[4]*z[12]*z[13] +
2*f3*z[2]*z[4]*z[12]*z[14] - 4*f4*z[2]*z[4]*z[12]*z[15] + 2*z[2]*z[4]*z[15]*z[16]
+ (16*f0*f2*f8 - 4*f1^2*f8)*z[2]*z[5]*z[9]^2 - 4*f0*f5*z[2]*z[5]*z[9]*z[11] +
2*f1*f5*z[2]*z[5]*z[9]*z[12] - 8*f0*f8*z[2]*z[5]*z[9]*z[15] +
4*f0*z[2]*z[5]*z[10]*z[13] - 2*f1*z[2]*z[5]*z[10]*z[14] -
8*f0*f3*f8*z[2]*z[6]*z[9]^2 + 2*f1*f5*z[2]*z[6]*z[9]*z[11] -
4*f2*f5*z[2]*z[6]*z[9]*z[12] + 8*f0*f8*z[2]*z[6]*z[9]*z[14] +
f3*z[2]*z[6]*z[9]*z[16] - 2*f1*z[2]*z[6]*z[10]*z[13] + 4*f2*z[2]*z[6]*z[10]*z[14]
- f3*z[2]*z[6]*z[10]*z[15] - f3*z[2]*z[6]*z[11]*z[14] + f3*z[2]*z[6]*z[12]*z[13] +
2*f5*z[2]*z[6]*z[12]*z[15] - 2*z[2]*z[6]*z[14]*z[16] + (8*f0*f4*f8 - 2*f0*f5*f7 -
2*f1*f3*f8)*z[2]*z[7]*z[9]^2 + 4*f0*f6*z[2]*z[7]*z[9]*z[10] -
2*f1*f6*z[2]*z[7]*z[9]*z[11] + (-4*f0*f8 + 4*f2*f6 + f3*f5)*z[2]*z[7]*z[9]*z[12] +
(-4*f0*f8 + f1*f7)*z[2]*z[7]*z[9]*z[13] - 2*f2*f7*z[2]*z[7]*z[9]*z[14] +
4*f2*f8*z[2]*z[7]*z[9]*z[15] - f4*z[2]*z[7]*z[9]*z[16] - 2*f0*z[2]*z[7]*z[10]^2 +
f1*z[2]*z[7]*z[10]*z[11] - 2*f2*z[2]*z[7]*z[10]*z[12] - f3*z[2]*z[7]*z[10]*z[14] +
f4*z[2]*z[7]*z[10]*z[15] + f4*z[2]*z[7]*z[11]*z[14] - f5*z[2]*z[7]*z[11]*z[15] -
f4*z[2]*z[7]*z[12]*z[13] - 2*f6*z[2]*z[7]*z[12]*z[15] + z[2]*z[7]*z[12]*z[16] +
z[2]*z[7]*z[13]*z[16] + f7*z[2]*z[7]*z[14]*z[15] - 2*f8*z[2]*z[7]*z[15]^2 -
4*f0*z[2]*z[8]*z[9]*z[10] + 2*f1*z[2]*z[8]*z[9]*z[11] - 4*f2*z[2]*z[8]*z[9]*z[12]
+ 2*z[2]*z[8]*z[12]*z[15] + 4*f0*f3*f7*z[3]^2*z[9]^2 - 4*f0*f5*z[3]^2*z[9]*z[11] +
2*f1*f5*z[3]^2*z[9]*z[12] - 2*f1*f7*z[3]^2*z[9]*z[15] + 4*f0*z[3]^2*z[11]^2 -
2*f1*z[3]^2*z[11]*z[12] + (-8*f0*f4*f7 - 2*f1*f3*f7)*z[3]*z[4]*z[9]^2 +
4*f0*f5*z[3]*z[4]*z[9]*z[10] + 2*f1*f5*z[3]*z[4]*z[9]*z[11] -
4*f2*f5*z[3]*z[4]*z[9]*z[12] + 4*f0*f7*z[3]*z[4]*z[9]*z[13] +
4*f2*f7*z[3]*z[4]*z[9]*z[15] - 4*f0*z[3]*z[4]*z[10]*z[11] - 2*f1*z[3]*z[4]*z[11]^2
+ 4*f2*z[3]*z[4]*z[11]*z[12] - 2*f3*z[3]*z[4]*z[12]^2 + 2*f5*z[3]*z[4]*z[12]*z[15]
- 2*f7*z[3]*z[4]*z[15]^2 - 8*f0*f3*f8*z[3]*z[5]*z[9]^2 +
8*f0*f6*z[3]*z[5]*z[9]*z[11] - 4*f1*f6*z[3]*z[5]*z[9]*z[12] -
4*f0*f7*z[3]*z[5]*z[9]*z[13] + 2*f1*f7*z[3]*z[5]*z[9]*z[14] +
4*f1*f8*z[3]*z[5]*z[9]*z[15] - 4*f0*z[3]*z[5]*z[10]*z[11] +
2*f1*z[3]*z[5]*z[10]*z[12] + (8*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8)*z[3]*z[6]*z[9]^2 - 4*f0*f6*z[3]*z[6]*z[9]*z[10] -
2*f1*f6*z[3]*z[6]*z[9]*z[11] + (-4*f0*f8 + 4*f2*f6 + f3*f5)*z[3]*z[6]*z[9]*z[12] +
(-4*f0*f8 + f1*f7)*z[3]*z[6]*z[9]*z[13] - 2*f2*f7*z[3]*z[6]*z[9]*z[14] -
4*f2*f8*z[3]*z[6]*z[9]*z[15] - f4*z[3]*z[6]*z[9]*z[16] + 2*f0*z[3]*z[6]*z[10]^2 +
f1*z[3]*z[6]*z[10]*z[11] - 2*f2*z[3]*z[6]*z[10]*z[12] - f3*z[3]*z[6]*z[10]*z[14] +
f4*z[3]*z[6]*z[10]*z[15] + f4*z[3]*z[6]*z[11]*z[14] - f5*z[3]*z[6]*z[11]*z[15] -
f4*z[3]*z[6]*z[12]*z[13] - 2*f6*z[3]*z[6]*z[12]*z[15] + z[3]*z[6]*z[12]*z[16] +
z[3]*z[6]*z[13]*z[16] + f7*z[3]*z[6]*z[14]*z[15] + 2*f8*z[3]*z[6]*z[15]^2 -
8*f0*f5*f8*z[3]*z[7]*z[9]^2 + 8*f0*f8*z[3]*z[7]*z[9]*z[11] -
4*f3*f6*z[3]*z[7]*z[9]*z[12] + 2*f3*f7*z[3]*z[7]*z[9]*z[14] +
f5*z[3]*z[7]*z[9]*z[16] + 2*f3*z[3]*z[7]*z[10]*z[12] - f5*z[3]*z[7]*z[10]*z[15] -
f5*z[3]*z[7]*z[11]*z[14] + 4*f6*z[3]*z[7]*z[11]*z[15] - 2*z[3]*z[7]*z[11]*z[16] +
f5*z[3]*z[7]*z[12]*z[13] - 2*f7*z[3]*z[7]*z[13]*z[15] + 4*f0*f7*z[3]*z[8]*z[9]^2 +
2*f3*z[3]*z[8]*z[9]*z[12] - 2*z[3]*z[8]*z[11]*z[15] + 4*f1*f4*f7*z[4]^2*z[9]^2 -
2*f1*f5*z[4]^2*z[9]*z[10] + 2*f3*f5*z[4]^2*z[9]*z[12] - 2*f1*f7*z[4]^2*z[9]*z[13]
- 2*f3*f7*z[4]^2*z[9]*z[15] + 2*f1*z[4]^2*z[10]*z[11] - 2*f3*z[4]^2*z[11]*z[12] +
4*f4*z[4]^2*z[12]^2 - 2*f5*z[4]^2*z[12]*z[14] - 2*z[4]^2*z[12]*z[16] +
2*f7*z[4]^2*z[14]*z[15] + (8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8)*z[4]*z[5]*z[9]^2
- 4*f0*f6*z[4]*z[5]*z[9]*z[10] - 2*f1*f6*z[4]*z[5]*z[9]*z[11] + (4*f0*f8 + 4*f2*f6
- f3*f5)*z[4]*z[5]*z[9]*z[12] + (-4*f0*f8 + f1*f7)*z[4]*z[5]*z[9]*z[13] -
2*f2*f7*z[4]*z[5]*z[9]*z[14] - 4*f2*f8*z[4]*z[5]*z[9]*z[15] +
f4*z[4]*z[5]*z[9]*z[16] + 2*f0*z[4]*z[5]*z[10]^2 + f1*z[4]*z[5]*z[10]*z[11] -
2*f2*z[4]*z[5]*z[10]*z[12] + f3*z[4]*z[5]*z[10]*z[14] - f4*z[4]*z[5]*z[10]*z[15] -
f4*z[4]*z[5]*z[11]*z[14] + f5*z[4]*z[5]*z[11]*z[15] + f4*z[4]*z[5]*z[12]*z[13] -
2*f6*z[4]*z[5]*z[12]*z[15] + z[4]*z[5]*z[12]*z[16] - z[4]*z[5]*z[13]*z[16] +
f7*z[4]*z[5]*z[14]*z[15] + 2*f8*z[4]*z[5]*z[15]^2 + (-8*f1*f4*f8 -
2*f1*f5*f7)*z[4]*z[6]*z[9]^2 + 4*f1*f6*z[4]*z[6]*z[9]*z[10] -
4*f3*f6*z[4]*z[6]*z[9]*z[12] + 4*f1*f8*z[4]*z[6]*z[9]*z[13] +
2*f3*f7*z[4]*z[6]*z[9]*z[14] + 4*f3*f8*z[4]*z[6]*z[9]*z[15] -
2*f1*z[4]*z[6]*z[10]^2 + 2*f3*z[4]*z[6]*z[10]*z[12] - 2*f5*z[4]*z[6]*z[12]^2 +
4*f6*z[4]*z[6]*z[12]*z[14] - 2*f7*z[4]*z[6]*z[14]^2 - 4*f8*z[4]*z[6]*z[14]*z[15] +
4*f1*f5*f8*z[4]*z[7]*z[9]^2 - 4*f1*f8*z[4]*z[7]*z[9]*z[11] + (8*f4*f6 -
2*f5^2)*z[4]*z[7]*z[9]*z[12] - 4*f4*f7*z[4]*z[7]*z[9]*z[14] +
2*f5*f7*z[4]*z[7]*z[9]*z[15] - 2*f6*z[4]*z[7]*z[9]*z[16] -
4*f4*z[4]*z[7]*z[10]*z[12] + 2*f5*z[4]*z[7]*z[10]*z[14] -
2*f6*z[4]*z[7]*z[10]*z[15] + 2*z[4]*z[7]*z[10]*z[16] + 2*f5*z[4]*z[7]*z[11]*z[12]
- 2*f6*z[4]*z[7]*z[11]*z[14] - 2*f6*z[4]*z[7]*z[12]*z[13] +
4*f8*z[4]*z[7]*z[12]*z[15] + 2*f7*z[4]*z[7]*z[13]*z[14] - 2*f1*f7*z[4]*z[8]*z[9]^2
- 4*f4*z[4]*z[8]*z[9]*z[12] + z[4]*z[8]*z[9]*z[16] + z[4]*z[8]*z[10]*z[15] +
z[4]*z[8]*z[11]*z[14] - 2*z[4]*z[8]*z[12]^2 + z[4]*z[8]*z[12]*z[13] -
4*f0*f7*z[5]^2*z[9]*z[11] + 2*f1*f7*z[5]^2*z[9]*z[12] + 8*f0*f8*z[5]^2*z[9]*z[13]
- 4*f1*f8*z[5]^2*z[9]*z[14] - 8*f0*f5*f8*z[5]*z[6]*z[9]^2 +
4*f0*f7*z[5]*z[6]*z[9]*z[10] + 2*f1*f7*z[5]*z[6]*z[9]*z[11] -
4*f2*f7*z[5]*z[6]*z[9]*z[12] - 4*f1*f8*z[5]*z[6]*z[9]*z[13] +
8*f2*f8*z[5]*z[6]*z[9]*z[14] + 2*f7*z[5]*z[6]*z[12]*z[15] -
4*f8*z[5]*z[6]*z[14]*z[15] + (16*f0*f6*f8 - 4*f0*f7^2)*z[5]*z[7]*z[9]^2 -
8*f0*f8*z[5]*z[7]*z[9]*z[10] + 2*f3*f7*z[5]*z[7]*z[9]*z[12] -
4*f3*f8*z[5]*z[7]*z[9]*z[14] - 2*f7*z[5]*z[7]*z[11]*z[15] +
4*f8*z[5]*z[7]*z[13]*z[15] - 8*f0*f8*z[5]*z[8]*z[9]^2 - z[5]*z[8]*z[9]*z[16] +
z[5]*z[8]*z[10]*z[15] + z[5]*z[8]*z[11]*z[14] - z[5]*z[8]*z[12]*z[13] +
4*f1*f5*f8*z[6]^2*z[9]^2 - 2*f1*f7*z[6]^2*z[9]*z[10] + 2*f3*f7*z[6]^2*z[9]*z[12] -
4*f3*f8*z[6]^2*z[9]*z[14] - 2*f7*z[6]^2*z[12]*z[14] + 4*f8*z[6]^2*z[14]^2 +
(-8*f1*f6*f8 + 2*f1*f7^2)*z[6]*z[7]*z[9]^2 + 4*f1*f8*z[6]*z[7]*z[9]*z[10] -
4*f4*f7*z[6]*z[7]*z[9]*z[12] + 8*f4*f8*z[6]*z[7]*z[9]*z[14] -
4*f5*f8*z[6]*z[7]*z[9]*z[15] + f7*z[6]*z[7]*z[9]*z[16] + f7*z[6]*z[7]*z[10]*z[15]
+ f7*z[6]*z[7]*z[11]*z[14] + 2*f7*z[6]*z[7]*z[12]^2 + f7*z[6]*z[7]*z[12]*z[13] -
4*f8*z[6]*z[7]*z[12]*z[14] - 4*f8*z[6]*z[7]*z[13]*z[14] + 4*f1*f8*z[6]*z[8]*z[9]^2
+ 2*f5*z[6]*z[8]*z[9]*z[12] - 2*z[6]*z[8]*z[10]*z[14] + 2*f5*f7*z[7]^2*z[9]*z[12]
- 4*f5*f8*z[7]^2*z[9]*z[14] + (8*f6*f8 - 2*f7^2)*z[7]^2*z[9]*z[15] -
2*f8*z[7]^2*z[9]*z[16] - 2*f8*z[7]^2*z[10]*z[15] - 2*f7*z[7]^2*z[11]*z[12] +
2*f8*z[7]^2*z[11]*z[14] + 2*f8*z[7]^2*z[12]*z[13] - 4*f6*z[7]*z[8]*z[9]*z[12] +
2*f7*z[7]*z[8]*z[9]*z[14] - 4*f8*z[7]*z[8]*z[9]*z[15] + 2*z[7]*z[8]*z[10]*z[12] +
2*z[8]^2*z[9]*z[12],

// Bmat[4,2]
  (128*f0^2*f4*f6*f8^2 - 32*f0^2*f4*f7^2*f8 - 32*f0^2*f5^2*f8^2 -
64*f0*f1*f3*f6*f8^2 + 16*f0*f1*f3*f7^2*f8 + 128*f0*f2^2*f6*f8^2 -
32*f0*f2^2*f7^2*f8 - 64*f0*f2*f3*f5*f8^2 + 128*f0*f2*f4^2*f8^2 -
64*f0*f2*f4*f5*f7*f8 + 128*f0*f2*f4*f6^2*f8 - 32*f0*f2*f4*f6*f7^2 -
32*f0*f2*f5^2*f6*f8 + 8*f0*f2*f5^2*f7^2 - 32*f0*f3^2*f4*f8^2 + 16*f0*f3^2*f5*f7*f8
- 32*f0*f3^2*f6^2*f8 + 8*f0*f3^2*f6*f7^2 - 32*f1^2*f2*f6*f8^2 + 8*f1^2*f2*f7^2*f8
+ 16*f1^2*f3*f5*f8^2 - 32*f1^2*f4^2*f8^2 + 16*f1^2*f4*f5*f7*f8 -
32*f1^2*f4*f6^2*f8 + 8*f1^2*f4*f6*f7^2 + 8*f1^2*f5^2*f6*f8 -
2*f1^2*f5^2*f7^2)*z[1]^2*z[9]^2 + (-64*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 +
32*f0*f1*f3*f8^2 - 64*f0*f2^2*f8^2 + 16*f0*f2*f3*f7*f8 - 128*f0*f2*f4*f6*f8 +
32*f0*f2*f4*f7^2 + 32*f0*f2*f5^2*f8 + 32*f0*f3^2*f6*f8 - 8*f0*f3^2*f7^2 +
16*f1^2*f2*f8^2 - 4*f1^2*f3*f7*f8 + 32*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 -
8*f1^2*f5^2*f8)*z[1]^2*z[9]*z[10] + (32*f0^2*f5*f8^2 - 8*f0*f1*f5*f7*f8 +
32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 + 32*f0*f2*f5*f6*f8 - 16*f0*f2*f5*f7^2 -
16*f0*f3^2*f7*f8 - 8*f0*f3*f5^2*f8 - 8*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 -
8*f1^2*f5*f6*f8 + 4*f1^2*f5*f7^2)*z[1]^2*z[9]*z[11] + (-16*f0*f1*f5*f8^2 -
16*f0*f2*f5*f7*f8 - 16*f0*f3^2*f8^2 - 16*f0*f3*f5*f6*f8 + 8*f0*f3*f5*f7^2 +
8*f1^2*f5*f7*f8 + 4*f1*f3^2*f7*f8 + 4*f1*f3*f5^2*f8)*z[1]^2*z[9]*z[12] +
(-64*f0^2*f6*f8^2 + 16*f0^2*f7^2*f8 + 16*f0*f1*f5*f8^2 - 128*f0*f2*f4*f8^2 +
48*f0*f2*f5*f7*f8 - 64*f0*f2*f6^2*f8 + 16*f0*f2*f6*f7^2 + 32*f0*f3^2*f8^2 +
16*f0*f3*f5*f6*f8 - 4*f0*f3*f5*f7^2 + 32*f1^2*f4*f8^2 - 12*f1^2*f5*f7*f8 +
16*f1^2*f6^2*f8 - 4*f1^2*f6*f7^2)*z[1]^2*z[9]*z[13] + (32*f0*f1*f6*f8^2 -
8*f0*f1*f7^2*f8 + 32*f0*f2*f5*f8^2 + 32*f0*f3*f4*f8^2 - 24*f0*f3*f5*f7*f8 +
32*f0*f3*f6^2*f8 - 8*f0*f3*f6*f7^2 - 16*f1^2*f5*f8^2 - 8*f1*f3^2*f8^2 -
8*f1*f3*f5*f6*f8 + 2*f1*f3*f5*f7^2)*z[1]^2*z[9]*z[14] + (-128*f0*f2*f6*f8^2 +
32*f0*f2*f7^2*f8 + 48*f0*f3*f5*f8^2 - 64*f0*f4^2*f8^2 + 32*f0*f4*f5*f7*f8 -
64*f0*f4*f6^2*f8 + 16*f0*f4*f6*f7^2 + 16*f0*f5^2*f6*f8 - 4*f0*f5^2*f7^2 +
32*f1^2*f6*f8^2 - 8*f1^2*f7^2*f8 + 16*f1*f3*f4*f8^2 - 8*f1*f3*f5*f7*f8 +
16*f1*f3*f6^2*f8 - 4*f1*f3*f6*f7^2)*z[1]^2*z[9]*z[15] + (32*f0*f2*f8^2 -
8*f0*f3*f7*f8 + 32*f0*f4*f6*f8 - 8*f0*f4*f7^2 - 8*f0*f5^2*f8 - 8*f1^2*f8^2 -
8*f1*f3*f6*f8 + 2*f1*f3*f7^2)*z[1]^2*z[9]*z[16] - 16*f0^2*f7*f8*z[1]^2*z[10]*z[11]
+ 8*f0*f1*f7*f8*z[1]^2*z[10]*z[12] + (32*f0^2*f8^2 + 32*f0*f2*f6*f8 - 8*f0*f2*f7^2
- 8*f0*f3*f5*f8 - 8*f1^2*f6*f8 + 2*f1^2*f7^2)*z[1]^2*z[10]*z[13] + (-16*f0*f1*f8^2
- 16*f0*f3*f6*f8 + 4*f0*f3*f7^2 + 4*f1*f3*f5*f8)*z[1]^2*z[10]*z[14] +
(32*f0*f2*f8^2 - 8*f0*f3*f7*f8 + 32*f0*f4*f6*f8 - 8*f0*f4*f7^2 - 8*f0*f5^2*f8 -
8*f1^2*f8^2 - 8*f1*f3*f6*f8 + 2*f1*f3*f7^2)*z[1]^2*z[10]*z[15] + (8*f0*f1*f7*f8 -
32*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 8*f0*f3*f5*f8 + 8*f1^2*f6*f8 -
2*f1^2*f7^2)*z[1]^2*z[11]^2 + (32*f0*f3*f6*f8 - 8*f0*f3*f7^2 - 16*f0*f4*f5*f8 -
8*f1^2*f7*f8 - 4*f1*f3*f5*f8)*z[1]^2*z[11]*z[12] -
16*f0*f1*f8^2*z[1]^2*z[11]*z[13] + (8*f0*f5^2*f8 + 8*f1^2*f8^2)*z[1]^2*z[11]*z[14]
+ (-16*f0*f3*f8^2 - 16*f0*f5*f6*f8 + 4*f0*f5*f7^2 +
4*f1*f3*f7*f8)*z[1]^2*z[11]*z[15] + 8*f0*f5*f8*z[1]^2*z[11]*z[16] +
(-8*f0*f3*f7*f8 - 32*f0*f4*f6*f8 + 8*f0*f4*f7^2 + 8*f0*f5^2*f8 + 8*f1*f2*f7*f8 +
8*f1*f4*f5*f8)*z[1]^2*z[12]^2 + (8*f0*f5^2*f8 + 8*f1^2*f8^2)*z[1]^2*z[12]*z[13] +
(16*f0*f3*f8^2 + 16*f0*f4*f7*f8 - 4*f0*f5*f7^2 - 16*f1*f2*f8^2 - 4*f1*f3*f7*f8 -
8*f1*f5^2*f8)*z[1]^2*z[12]*z[14] + (8*f1*f3*f8^2 - 8*f1*f4*f7*f8 +
8*f1*f5*f6*f8)*z[1]^2*z[12]*z[15] + (16*f0*f6*f8 - 4*f0*f7^2 -
8*f1*f5*f8)*z[1]^2*z[12]*z[16] + (-16*f0*f5*f6*f8 +
4*f0*f5*f7^2)*z[1]^2*z[13]*z[14] + (32*f0*f4*f8^2 - 16*f0*f5*f7*f8 + 32*f0*f6^2*f8
- 8*f0*f6*f7^2 - 8*f1*f3*f8^2)*z[1]^2*z[13]*z[15] + (-16*f0*f6*f8 +
4*f0*f7^2)*z[1]^2*z[13]*z[16] + (-32*f0*f4*f8^2 + 8*f0*f5*f7*f8 + 8*f1*f3*f8^2 +
8*f1*f5*f6*f8 - 2*f1*f5*f7^2)*z[1]^2*z[14]^2 + (16*f0*f5*f8^2 - 16*f0*f6*f7*f8 +
4*f0*f7^3 + 4*f1*f5*f7*f8 - 16*f1*f6^2*f8 + 4*f1*f6*f7^2)*z[1]^2*z[14]*z[15] +
(8*f1*f6*f8 - 2*f1*f7^2)*z[1]^2*z[14]*z[16] + (-8*f1*f5*f8^2 + 8*f1*f6*f7*f8 -
2*f1*f7^3)*z[1]^2*z[15]^2 + (-64*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 +
32*f0*f1*f3*f8^2 - 64*f0*f2^2*f8^2 + 16*f0*f2*f3*f7*f8 - 128*f0*f2*f4*f6*f8 +
32*f0*f2*f4*f7^2 + 32*f0*f2*f5^2*f8 + 32*f0*f3^2*f6*f8 - 8*f0*f3^2*f7^2 +
16*f1^2*f2*f8^2 - 4*f1^2*f3*f7*f8 + 32*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 -
8*f1^2*f5^2*f8)*z[1]*z[2]*z[9]^2 + (-32*f0^2*f6*f8 + 64*f0*f2*f4*f8 -
16*f0*f2*f5*f7 - 24*f0*f3^2*f8 - 16*f1^2*f4*f8 +
4*f1^2*f5*f7)*z[1]*z[2]*z[9]*z[10] + (16*f0*f1*f6*f8 - 48*f0*f2*f5*f8 +
16*f0*f2*f6*f7 + 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 + 12*f1^2*f5*f8 -
4*f1^2*f6*f7)*z[1]*z[2]*z[9]*z[11] + (32*f0*f2*f6*f8 + 16*f0*f3*f5*f8 -
8*f0*f3*f6*f7 - 16*f1^2*f6*f8 - 8*f1*f3*f4*f8 -
2*f1*f3*f5*f7)*z[1]*z[2]*z[9]*z[12] + (32*f0^2*f8^2 - 8*f0*f1*f7*f8 +
64*f0*f2*f6*f8 - 24*f0*f2*f7^2 - 16*f0*f3*f5*f8 - 16*f1^2*f6*f8 +
6*f1^2*f7^2)*z[1]*z[2]*z[9]*z[13] + (-16*f0*f1*f8^2 - 16*f0*f2*f7*f8 -
32*f0*f3*f6*f8 + 12*f0*f3*f7^2 + 8*f1^2*f7*f8 +
8*f1*f3*f5*f8)*z[1]*z[2]*z[9]*z[14] + (64*f0*f2*f8^2 - 8*f0*f3*f7*f8 +
64*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8 - 16*f1^2*f8^2 - 16*f1*f3*f6*f8 +
4*f1*f3*f7^2)*z[1]*z[2]*z[9]*z[15] + (-16*f0*f4*f8 + 4*f0*f5*f7 +
8*f1*f3*f8)*z[1]*z[2]*z[9]*z[16] + 16*f0^2*f8*z[1]*z[2]*z[10]^2 + (-8*f0*f1*f8 -
8*f0*f2*f7 + 2*f1^2*f7)*z[1]*z[2]*z[10]*z[11] + (-16*f0*f2*f8 + 4*f0*f3*f7 +
8*f1^2*f8)*z[1]*z[2]*z[10]*z[12] + (-16*f0*f2*f8 + 4*f0*f3*f7 +
4*f1^2*f8)*z[1]*z[2]*z[10]*z[13] + (16*f0*f3*f8 -
2*f1*f3*f7)*z[1]*z[2]*z[10]*z[14] + (-16*f0*f4*f8 + 4*f0*f5*f7 +
4*f1*f3*f8)*z[1]*z[2]*z[10]*z[15] + (32*f0*f2*f8 - 8*f1^2*f8)*z[1]*z[2]*z[11]^2 -
24*f0*f3*f8*z[1]*z[2]*z[11]*z[12] - 8*f0*f3*f8*z[1]*z[2]*z[11]*z[13] -
4*f0*f5*f7*z[1]*z[2]*z[11]*z[14] + 8*f0*f5*f8*z[1]*z[2]*z[11]*z[15] + (32*f0*f4*f8
- 4*f0*f5*f7 - 4*f1*f3*f8)*z[1]*z[2]*z[12]^2 + (-4*f0*f5*f7 +
4*f1*f3*f8)*z[1]*z[2]*z[12]*z[13] + (-16*f0*f5*f8 + 8*f0*f6*f7 +
4*f1*f5*f7)*z[1]*z[2]*z[12]*z[14] + (4*f1*f5*f8 -
4*f1*f6*f7)*z[1]*z[2]*z[12]*z[15] + (-16*f0*f8 + 2*f1*f7)*z[1]*z[2]*z[12]*z[16] +
16*f0*f5*f8*z[1]*z[2]*z[13]*z[14] + (-32*f0*f6*f8 +
8*f0*f7^2)*z[1]*z[2]*z[13]*z[15] + 8*f0*f8*z[1]*z[2]*z[13]*z[16] + (-4*f0*f7^2 -
8*f1*f5*f8)*z[1]*z[2]*z[14]^2 + (8*f0*f7*f8 + 16*f1*f6*f8 -
2*f1*f7^2)*z[1]*z[2]*z[14]*z[15] - 4*f1*f8*z[1]*z[2]*z[14]*z[16] -
4*f1*f7*f8*z[1]*z[2]*z[15]^2 + (32*f0^2*f5*f8^2 - 8*f0*f1*f5*f7*f8 +
32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 + 32*f0*f2*f5*f6*f8 - 16*f0*f2*f5*f7^2 -
16*f0*f3^2*f7*f8 - 8*f0*f3*f5^2*f8 - 8*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 -
8*f1^2*f5*f6*f8 + 4*f1^2*f5*f7^2)*z[1]*z[3]*z[9]^2 + (16*f0*f1*f6*f8 -
48*f0*f2*f5*f8 + 16*f0*f2*f6*f7 + 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 + 12*f1^2*f5*f8 -
4*f1^2*f6*f7)*z[1]*z[3]*z[9]*z[10] + (-32*f0^2*f8^2 - 32*f0*f2*f6*f8 +
16*f0*f2*f7^2 + 32*f0*f3*f5*f8 - 16*f0*f3*f6*f7 - 32*f0*f4^2*f8 -
4*f1^2*f7^2)*z[1]*z[3]*z[9]*z[11] + (16*f0*f1*f8^2 - 16*f0*f3*f6*f8 - 8*f0*f3*f7^2
+ 16*f0*f4*f6*f7 - 4*f0*f5^2*f7 + 16*f1*f2*f6*f8 - 12*f1*f3*f5*f8 + 4*f1*f3*f6*f7
+ 16*f1*f4^2*f8)*z[1]*z[3]*z[9]*z[12] + (-32*f0*f2*f7*f8 + 8*f0*f3*f7^2 +
16*f0*f4*f5*f8 + 12*f1^2*f7*f8)*z[1]*z[3]*z[9]*z[13] + (32*f0*f3*f7*f8 -
8*f0*f4*f7^2 - 8*f1*f2*f7*f8 - 2*f1*f3*f7^2 - 8*f1*f4*f5*f8)*z[1]*z[3]*z[9]*z[14]
+ (-32*f0*f3*f8^2 - 16*f0*f4*f7*f8 - 16*f0*f5*f6*f8 + 12*f0*f5*f7^2 +
8*f1*f3*f7*f8 + 4*f1*f5^2*f8)*z[1]*z[3]*z[9]*z[15] + (16*f0*f5*f8 - 8*f0*f6*f7 -
8*f1*f4*f8)*z[1]*z[3]*z[9]*z[16] + (-8*f0*f1*f8 - 8*f0*f2*f7 +
2*f1^2*f7)*z[1]*z[3]*z[10]^2 + (16*f0*f2*f8 + 8*f0*f3*f7)*z[1]*z[3]*z[10]*z[11] +
(8*f0*f3*f8 - 8*f0*f4*f7 - 8*f1*f2*f8 - 2*f1*f3*f7)*z[1]*z[3]*z[10]*z[12] -
8*f0*f4*f7*z[1]*z[3]*z[10]*z[13] + (-16*f0*f4*f8 + 4*f0*f5*f7 +
4*f1*f4*f7)*z[1]*z[3]*z[10]*z[14] + (16*f0*f5*f8 - 8*f0*f6*f7 -
2*f1*f5*f7)*z[1]*z[3]*z[10]*z[15] + 8*f0*f7*z[1]*z[3]*z[10]*z[16] -
16*f0*f3*f8*z[1]*z[3]*z[11]^2 + (16*f0*f4*f8 + 4*f0*f5*f7 +
8*f1*f3*f8)*z[1]*z[3]*z[11]*z[12] + (16*f0*f4*f8 +
4*f0*f5*f7)*z[1]*z[3]*z[11]*z[13] + (-8*f0*f5*f8 -
2*f1*f5*f7)*z[1]*z[3]*z[11]*z[14] + (16*f0*f6*f8 - 8*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[3]*z[11]*z[15] + (-8*f0*f8 - 2*f1*f7)*z[1]*z[3]*z[11]*z[16] +
(-16*f0*f5*f8 - 8*f1*f4*f8)*z[1]*z[3]*z[12]^2 + (-8*f0*f5*f8 -
8*f1*f4*f8)*z[1]*z[3]*z[12]*z[13] + (16*f0*f6*f8 + 12*f1*f5*f8 -
4*f1*f6*f7)*z[1]*z[3]*z[12]*z[14] + (8*f0*f7*f8 - 16*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[3]*z[12]*z[15] + 8*f1*f8*z[1]*z[3]*z[12]*z[16] -
8*f0*f5*f8*z[1]*z[3]*z[13]^2 + 4*f1*f5*f8*z[1]*z[3]*z[13]*z[14] + (16*f0*f7*f8 -
2*f1*f7^2)*z[1]*z[3]*z[13]*z[15] + (-8*f0*f7*f8 + 2*f1*f7^2)*z[1]*z[3]*z[14]^2 +
(-16*f0*f8^2 - 4*f1*f7*f8)*z[1]*z[3]*z[14]*z[15] + 8*f1*f8^2*z[1]*z[3]*z[15]^2 +
(-16*f0*f1*f5*f8^2 - 16*f0*f2*f5*f7*f8 - 16*f0*f3^2*f8^2 - 16*f0*f3*f5*f6*f8 +
8*f0*f3*f5*f7^2 + 8*f1^2*f5*f7*f8 + 4*f1*f3^2*f7*f8 +
4*f1*f3*f5^2*f8)*z[1]*z[4]*z[9]^2 + (32*f0*f2*f6*f8 + 16*f0*f3*f5*f8 -
8*f0*f3*f6*f7 - 16*f1^2*f6*f8 - 8*f1*f3*f4*f8 -
2*f1*f3*f5*f7)*z[1]*z[4]*z[9]*z[10] + (16*f0*f1*f8^2 - 16*f0*f3*f6*f8 -
8*f0*f3*f7^2 + 16*f0*f4*f6*f7 - 4*f0*f5^2*f7 + 16*f1*f2*f6*f8 - 12*f1*f3*f5*f8 +
4*f1*f3*f6*f7 + 16*f1*f4^2*f8)*z[1]*z[4]*z[9]*z[11] + (-32*f0*f2*f8^2 -
32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 32*f1*f3*f6*f8 - 16*f1*f4*f6*f7 + 4*f1*f5^2*f7 -
32*f2^2*f6*f8 + 16*f2*f3*f5*f8 - 32*f2*f4^2*f8 +
8*f3^2*f4*f8)*z[1]*z[4]*z[9]*z[12] + (24*f0*f3*f7*f8 - 8*f0*f4*f7^2 -
8*f1*f2*f7*f8 - 2*f1*f3*f7^2 - 8*f1*f4*f5*f8)*z[1]*z[4]*z[9]*z[13] +
(16*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 - 4*f0*f5*f7^2 - 16*f1*f3*f7*f8 +
8*f1*f4*f7^2 + 16*f2^2*f7*f8 + 16*f2*f4*f5*f8 - 4*f3^2*f5*f8)*z[1]*z[4]*z[9]*z[14]
+ (32*f0*f4*f8^2 + 8*f0*f5*f7*f8 - 4*f1*f5*f7^2 - 8*f2*f3*f7*f8 -
8*f2*f5^2*f8)*z[1]*z[4]*z[9]*z[15] + (-4*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7 +
16*f2*f4*f8 - 4*f3^2*f8)*z[1]*z[4]*z[9]*z[16] + (-16*f0*f2*f8 + 4*f0*f3*f7 +
8*f1^2*f8)*z[1]*z[4]*z[10]^2 + (16*f0*f3*f8 - 8*f0*f4*f7 - 8*f1*f2*f8 -
2*f1*f3*f7)*z[1]*z[4]*z[10]*z[11] + (-4*f0*f5*f7 - 16*f1*f3*f8 + 8*f1*f4*f7 +
16*f2^2*f8)*z[1]*z[4]*z[10]*z[12] + (-16*f0*f4*f8 + 4*f0*f5*f7 + 4*f1*f3*f8 +
4*f1*f4*f7)*z[1]*z[4]*z[10]*z[13] + (16*f1*f4*f8 - 4*f1*f5*f7 - 8*f2*f3*f8 -
8*f2*f4*f7 + 2*f3^2*f7)*z[1]*z[4]*z[10]*z[14] + (-16*f0*f6*f8 + 4*f0*f7^2 -
4*f1*f5*f8 + 4*f1*f6*f7 + 4*f2*f5*f7 + 4*f3^2*f8)*z[1]*z[4]*z[10]*z[15] + (8*f0*f8
- 4*f1*f7)*z[1]*z[4]*z[10]*z[16] + (4*f0*f5*f7 + 4*f1*f3*f8)*z[1]*z[4]*z[11]^2 +
(-4*f1*f5*f7 - 8*f2*f3*f8)*z[1]*z[4]*z[11]*z[12] + (8*f0*f5*f8 - 8*f0*f6*f7 -
8*f1*f4*f8 - 2*f1*f5*f7)*z[1]*z[4]*z[11]*z[13] + (4*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7 + 4*f2*f5*f7 + 4*f3^2*f8)*z[1]*z[4]*z[11]*z[14] + (-8*f0*f7*f8 +
8*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8)*z[1]*z[4]*z[11]*z[15] +
4*f2*f7*z[1]*z[4]*z[11]*z[16] + (8*f1*f5*f8 + 4*f3^2*f8)*z[1]*z[4]*z[12]^2 +
(16*f0*f6*f8 - 4*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7 + 16*f2*f4*f8 -
4*f3^2*f8)*z[1]*z[4]*z[12]*z[13] + (-16*f1*f6*f8 - 8*f3*f4*f8 -
2*f3*f5*f7)*z[1]*z[4]*z[12]*z[14] + (16*f0*f8^2 + 16*f2*f6*f8 - 12*f3*f5*f8 +
4*f3*f6*f7 + 16*f4^2*f8)*z[1]*z[4]*z[12]*z[15] + (-8*f2*f8 -
2*f3*f7)*z[1]*z[4]*z[12]*z[16] + (4*f0*f7^2 + 4*f1*f5*f8)*z[1]*z[4]*z[13]^2 +
(-8*f0*f7*f8 - 4*f1*f7^2 - 8*f2*f5*f8)*z[1]*z[4]*z[13]*z[14] + (4*f2*f7^2 +
4*f3*f5*f8)*z[1]*z[4]*z[13]*z[15] - 2*f3*f7*z[1]*z[4]*z[13]*z[16] + (8*f1*f7*f8 +
4*f3*f5*f8)*z[1]*z[4]*z[14]^2 + (-8*f2*f7*f8 - 2*f3*f7^2 -
8*f4*f5*f8)*z[1]*z[4]*z[14]*z[15] + (4*f3*f8 + 4*f4*f7)*z[1]*z[4]*z[14]*z[16] +
(4*f3*f7*f8 + 4*f5^2*f8)*z[1]*z[4]*z[15]^2 + (-8*f4*f8 -
2*f5*f7)*z[1]*z[4]*z[15]*z[16] + (-64*f0^2*f6*f8^2 + 16*f0^2*f7^2*f8 +
16*f0*f1*f5*f8^2 - 128*f0*f2*f4*f8^2 + 48*f0*f2*f5*f7*f8 - 64*f0*f2*f6^2*f8 +
16*f0*f2*f6*f7^2 + 32*f0*f3^2*f8^2 + 16*f0*f3*f5*f6*f8 - 4*f0*f3*f5*f7^2 +
32*f1^2*f4*f8^2 - 12*f1^2*f5*f7*f8 + 16*f1^2*f6^2*f8 -
4*f1^2*f6*f7^2)*z[1]*z[5]*z[9]^2 + (32*f0^2*f8^2 - 8*f0*f1*f7*f8 + 64*f0*f2*f6*f8
- 24*f0*f2*f7^2 - 16*f0*f3*f5*f8 - 16*f1^2*f6*f8 +
6*f1^2*f7^2)*z[1]*z[5]*z[9]*z[10] + (-32*f0*f2*f7*f8 + 8*f0*f3*f7^2 +
16*f0*f4*f5*f8 + 12*f1^2*f7*f8)*z[1]*z[5]*z[9]*z[11] + (24*f0*f3*f7*f8 -
8*f0*f4*f7^2 - 8*f1*f2*f7*f8 - 2*f1*f3*f7^2 - 8*f1*f4*f5*f8)*z[1]*z[5]*z[9]*z[12]
+ (96*f0*f2*f8^2 - 16*f0*f3*f7*f8 - 32*f0*f4*f6*f8 + 8*f0*f4*f7^2 -
32*f1^2*f8^2)*z[1]*z[5]*z[9]*z[13] + (-64*f0*f3*f8^2 + 16*f0*f4*f7*f8 +
16*f1*f2*f8^2 + 4*f1*f3*f7*f8 + 16*f1*f4*f6*f8 -
4*f1*f4*f7^2)*z[1]*z[5]*z[9]*z[14] + (64*f0*f4*f8^2 - 32*f0*f5*f7*f8 +
32*f0*f6^2*f8 - 8*f0*f6*f7^2 - 16*f1*f3*f8^2 - 8*f1*f5*f6*f8 +
2*f1*f5*f7^2)*z[1]*z[5]*z[9]*z[15] + (-16*f0*f6*f8 + 8*f0*f7^2 +
4*f1*f5*f8)*z[1]*z[5]*z[9]*z[16] + (16*f0*f2*f8 - 4*f1^2*f8)*z[1]*z[5]*z[10]^2 -
16*f0*f3*f8*z[1]*z[5]*z[10]*z[11] + (16*f0*f4*f8 +
4*f1*f3*f8)*z[1]*z[5]*z[10]*z[12] + 16*f0*f4*f8*z[1]*z[5]*z[10]*z[13] -
8*f1*f4*f8*z[1]*z[5]*z[10]*z[14] + (-16*f0*f6*f8 + 8*f0*f7^2 +
4*f1*f5*f8)*z[1]*z[5]*z[10]*z[15] - 16*f0*f8*z[1]*z[5]*z[10]*z[16] -
16*f0*f5*f8*z[1]*z[5]*z[11]*z[13] + 4*f1*f5*f8*z[1]*z[5]*z[11]*z[14] + (8*f0*f7*f8
- 2*f1*f7^2)*z[1]*z[5]*z[11]*z[15] + 4*f1*f8*z[1]*z[5]*z[11]*z[16] + (16*f0*f6*f8
- 4*f0*f7^2 - 4*f1*f5*f8)*z[1]*z[5]*z[12]^2 + 4*f1*f5*f8*z[1]*z[5]*z[12]*z[13] +
(-16*f0*f7*f8 + 2*f1*f7^2)*z[1]*z[5]*z[12]*z[14] + (-16*f0*f8^2 +
4*f1*f7*f8)*z[1]*z[5]*z[12]*z[15] + (16*f0*f6*f8 - 4*f0*f7^2)*z[1]*z[5]*z[13]^2 +
(-8*f1*f6*f8 + 2*f1*f7^2)*z[1]*z[5]*z[13]*z[14] + (-32*f0*f8^2 +
4*f1*f7*f8)*z[1]*z[5]*z[13]*z[15] + (32*f0*f8^2 - 4*f1*f7*f8)*z[1]*z[5]*z[14]^2 +
(32*f0*f1*f6*f8^2 - 8*f0*f1*f7^2*f8 + 32*f0*f2*f5*f8^2 + 32*f0*f3*f4*f8^2 -
24*f0*f3*f5*f7*f8 + 32*f0*f3*f6^2*f8 - 8*f0*f3*f6*f7^2 - 16*f1^2*f5*f8^2 -
8*f1*f3^2*f8^2 - 8*f1*f3*f5*f6*f8 + 2*f1*f3*f5*f7^2)*z[1]*z[6]*z[9]^2 +
(-16*f0*f1*f8^2 - 16*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 12*f0*f3*f7^2 + 8*f1^2*f7*f8 +
8*f1*f3*f5*f8)*z[1]*z[6]*z[9]*z[10] + (32*f0*f3*f7*f8 - 8*f0*f4*f7^2 -
8*f1*f2*f7*f8 - 2*f1*f3*f7^2 - 8*f1*f4*f5*f8)*z[1]*z[6]*z[9]*z[11] +
(16*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 - 4*f0*f5*f7^2 - 16*f1*f3*f7*f8 +
8*f1*f4*f7^2 + 16*f2^2*f7*f8 + 16*f2*f4*f5*f8 - 4*f3^2*f5*f8)*z[1]*z[6]*z[9]*z[12]
+ (-64*f0*f3*f8^2 + 16*f0*f4*f7*f8 + 16*f1*f2*f8^2 + 4*f1*f3*f7*f8 +
16*f1*f4*f6*f8 - 4*f1*f4*f7^2)*z[1]*z[6]*z[9]*z[13] + (16*f0*f5*f7*f8 -
32*f0*f6^2*f8 + 8*f0*f6*f7^2 + 32*f1*f3*f8^2 - 16*f1*f4*f7*f8 - 32*f2^2*f8^2 -
32*f2*f4*f6*f8 + 8*f2*f4*f7^2 + 8*f3^2*f6*f8 - 2*f3^2*f7^2)*z[1]*z[6]*z[9]*z[14] +
(-48*f0*f5*f8^2 + 16*f0*f6*f7*f8 - 4*f0*f7^3 + 8*f1*f5*f7*f8 + 16*f2*f3*f8^2 +
16*f2*f5*f6*f8 - 4*f2*f5*f7^2)*z[1]*z[6]*z[9]*z[15] + (8*f0*f7*f8 - 2*f1*f7^2 -
8*f2*f5*f8)*z[1]*z[6]*z[9]*z[16] - 8*f0*f3*f8*z[1]*z[6]*z[10]^2 + (16*f0*f4*f8 +
4*f1*f3*f8)*z[1]*z[6]*z[10]*z[11] - 16*f1*f4*f8*z[1]*z[6]*z[10]*z[12] -
8*f1*f4*f8*z[1]*z[6]*z[10]*z[13] + (16*f0*f6*f8 - 4*f0*f7^2 + 16*f2*f4*f8 -
4*f3^2*f8)*z[1]*z[6]*z[10]*z[14] + (-2*f1*f7^2 - 8*f2*f5*f8)*z[1]*z[6]*z[10]*z[15]
+ 8*f1*f8*z[1]*z[6]*z[10]*z[16] - 8*f0*f5*f8*z[1]*z[6]*z[11]^2 + (-16*f0*f6*f8 +
4*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[6]*z[11]*z[12] + (4*f0*f7^2 +
8*f1*f5*f8)*z[1]*z[6]*z[11]*z[13] + (-8*f0*f7*f8 - 2*f1*f7^2 -
8*f2*f5*f8)*z[1]*z[6]*z[11]*z[14] + (16*f0*f8^2 + 4*f2*f7^2 +
4*f3*f5*f8)*z[1]*z[6]*z[11]*z[15] - 8*f2*f8*z[1]*z[6]*z[11]*z[16] +
8*f0*f7*f8*z[1]*z[6]*z[12]^2 + (-2*f1*f7^2 - 8*f2*f5*f8)*z[1]*z[6]*z[12]*z[13] +
(-16*f0*f8^2 + 8*f1*f7*f8 + 8*f3*f5*f8)*z[1]*z[6]*z[12]*z[14] + (-8*f2*f7*f8 -
2*f3*f7^2 - 8*f4*f5*f8)*z[1]*z[6]*z[12]*z[15] + 4*f3*f8*z[1]*z[6]*z[12]*z[16] +
(-8*f0*f7*f8 - 8*f1*f6*f8 + 2*f1*f7^2)*z[1]*z[6]*z[13]^2 + (16*f0*f8^2 +
8*f1*f7*f8 + 16*f2*f6*f8 - 4*f2*f7^2)*z[1]*z[6]*z[13]*z[14] + (-8*f2*f7*f8 -
8*f3*f6*f8 + 2*f3*f7^2)*z[1]*z[6]*z[13]*z[15] + 4*f3*f8*z[1]*z[6]*z[13]*z[16] +
(-16*f1*f8^2 - 8*f3*f6*f8 + 2*f3*f7^2)*z[1]*z[6]*z[14]^2 + (16*f2*f8^2 +
4*f3*f7*f8 + 16*f4*f6*f8 - 4*f4*f7^2)*z[1]*z[6]*z[14]*z[15] -
8*f4*f8*z[1]*z[6]*z[14]*z[16] + (-8*f3*f8^2 - 8*f5*f6*f8 +
2*f5*f7^2)*z[1]*z[6]*z[15]^2 + 8*f5*f8*z[1]*z[6]*z[15]*z[16] + (-128*f0*f2*f6*f8^2
+ 32*f0*f2*f7^2*f8 + 48*f0*f3*f5*f8^2 - 64*f0*f4^2*f8^2 + 32*f0*f4*f5*f7*f8 -
64*f0*f4*f6^2*f8 + 16*f0*f4*f6*f7^2 + 16*f0*f5^2*f6*f8 - 4*f0*f5^2*f7^2 +
32*f1^2*f6*f8^2 - 8*f1^2*f7^2*f8 + 16*f1*f3*f4*f8^2 - 8*f1*f3*f5*f7*f8 +
16*f1*f3*f6^2*f8 - 4*f1*f3*f6*f7^2)*z[1]*z[7]*z[9]^2 + (64*f0*f2*f8^2 -
8*f0*f3*f7*f8 + 64*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8 - 16*f1^2*f8^2 -
16*f1*f3*f6*f8 + 4*f1*f3*f7^2)*z[1]*z[7]*z[9]*z[10] + (-32*f0*f3*f8^2 -
16*f0*f4*f7*f8 - 16*f0*f5*f6*f8 + 12*f0*f5*f7^2 + 8*f1*f3*f7*f8 +
4*f1*f5^2*f8)*z[1]*z[7]*z[9]*z[11] + (32*f0*f4*f8^2 + 8*f0*f5*f7*f8 - 4*f1*f5*f7^2
- 8*f2*f3*f7*f8 - 8*f2*f5^2*f8)*z[1]*z[7]*z[9]*z[12] + (64*f0*f4*f8^2 -
32*f0*f5*f7*f8 + 32*f0*f6^2*f8 - 8*f0*f6*f7^2 - 16*f1*f3*f8^2 - 8*f1*f5*f6*f8 +
2*f1*f5*f7^2)*z[1]*z[7]*z[9]*z[13] + (-48*f0*f5*f8^2 + 16*f0*f6*f7*f8 - 4*f0*f7^3
+ 8*f1*f5*f7*f8 + 16*f2*f3*f8^2 + 16*f2*f5*f6*f8 -
4*f2*f5*f7^2)*z[1]*z[7]*z[9]*z[14] + (96*f0*f6*f8^2 - 24*f0*f7^2*f8 -
16*f1*f6*f7*f8 + 4*f1*f7^3 - 32*f2*f4*f8^2 + 16*f2*f5*f7*f8 - 32*f2*f6^2*f8 +
8*f2*f6*f7^2)*z[1]*z[7]*z[9]*z[15] + (-32*f0*f8^2 + 4*f1*f7*f8 + 16*f2*f6*f8 -
4*f2*f7^2)*z[1]*z[7]*z[9]*z[16] - 8*f0*f5*f8*z[1]*z[7]*z[10]*z[11] + (-16*f0*f6*f8
+ 4*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[7]*z[10]*z[12] + (-16*f0*f6*f8 + 4*f0*f7^2 +
4*f1*f5*f8)*z[1]*z[7]*z[10]*z[13] - 8*f2*f5*f8*z[1]*z[7]*z[10]*z[14] +
(-16*f0*f8^2 + 4*f1*f7*f8 + 16*f2*f6*f8 - 4*f2*f7^2)*z[1]*z[7]*z[10]*z[15] +
(32*f0*f6*f8 - 8*f0*f7^2 - 4*f1*f5*f8)*z[1]*z[7]*z[11]^2 + (8*f0*f7*f8 -
16*f1*f6*f8 + 4*f1*f7^2 + 8*f2*f5*f8)*z[1]*z[7]*z[11]*z[12] -
8*f0*f7*f8*z[1]*z[7]*z[11]*z[13] + 4*f1*f7*f8*z[1]*z[7]*z[11]*z[14] -
8*f2*f7*f8*z[1]*z[7]*z[11]*z[15] + (-8*f1*f7*f8 - 4*f3*f5*f8)*z[1]*z[7]*z[12]^2 +
(-16*f0*f8^2 + 4*f1*f7*f8)*z[1]*z[7]*z[12]*z[13] +
16*f1*f8^2*z[1]*z[7]*z[12]*z[14] + (8*f3*f7*f8 + 4*f5^2*f8)*z[1]*z[7]*z[12]*z[15]
+ 16*f0*f8^2*z[1]*z[7]*z[13]^2 - 16*f1*f8^2*z[1]*z[7]*z[13]*z[14] +
16*f2*f8^2*z[1]*z[7]*z[13]*z[15] + (-16*f3*f8^2 - 8*f5*f6*f8 +
2*f5*f7^2)*z[1]*z[7]*z[14]*z[15] + 4*f5*f8*z[1]*z[7]*z[14]*z[16] + (16*f4*f8^2 -
8*f5*f7*f8 + 16*f6^2*f8 - 4*f6*f7^2)*z[1]*z[7]*z[15]^2 + (-16*f6*f8 +
4*f7^2)*z[1]*z[7]*z[15]*z[16] + (32*f0*f2*f8^2 - 8*f0*f3*f7*f8 + 32*f0*f4*f6*f8 -
8*f0*f4*f7^2 - 8*f0*f5^2*f8 - 8*f1^2*f8^2 - 8*f1*f3*f6*f8 +
2*f1*f3*f7^2)*z[1]*z[8]*z[9]^2 + (-16*f0*f4*f8 + 4*f0*f5*f7 +
8*f1*f3*f8)*z[1]*z[8]*z[9]*z[10] + (16*f0*f5*f8 - 8*f0*f6*f7 -
8*f1*f4*f8)*z[1]*z[8]*z[9]*z[11] + (-4*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7 +
16*f2*f4*f8 - 4*f3^2*f8)*z[1]*z[8]*z[9]*z[12] + (-16*f0*f6*f8 + 8*f0*f7^2 +
4*f1*f5*f8)*z[1]*z[8]*z[9]*z[13] + (8*f0*f7*f8 - 2*f1*f7^2 -
8*f2*f5*f8)*z[1]*z[8]*z[9]*z[14] + (-32*f0*f8^2 + 4*f1*f7*f8 + 16*f2*f6*f8 -
4*f2*f7^2)*z[1]*z[8]*z[9]*z[15] + (-10*f2*f8 + f3*f7)*z[1]*z[8]*z[9]*z[16] +
4*f0*f7*z[1]*z[8]*z[10]*z[11] + (8*f0*f8 - 2*f1*f7)*z[1]*z[8]*z[10]*z[12] +
(8*f0*f8 - 2*f1*f7)*z[1]*z[8]*z[10]*z[13] + (-4*f1*f8 +
4*f2*f7)*z[1]*z[8]*z[10]*z[14] + (-6*f2*f8 - f3*f7)*z[1]*z[8]*z[10]*z[15] -
16*f0*f8*z[1]*z[8]*z[11]^2 + 8*f1*f8*z[1]*z[8]*z[11]*z[12] +
4*f1*f8*z[1]*z[8]*z[11]*z[13] + (-2*f2*f8 - f3*f7)*z[1]*z[8]*z[11]*z[14] +
4*f3*f8*z[1]*z[8]*z[11]*z[15] + (-6*f2*f8 + f3*f7)*z[1]*z[8]*z[12]*z[13] +
4*f3*f8*z[1]*z[8]*z[12]*z[14] - 8*f4*f8*z[1]*z[8]*z[12]*z[15] +
4*f5*f8*z[1]*z[8]*z[14]*z[15] - 2*f7*z[1]*z[8]*z[14]*z[16] + (-8*f6*f8 +
2*f7^2)*z[1]*z[8]*z[15]^2 + 8*f8*z[1]*z[8]*z[15]*z[16] +
16*f0^2*f8*z[2]^2*z[9]*z[10] + (-8*f0*f1*f8 - 8*f0*f2*f7 +
2*f1^2*f7)*z[2]^2*z[9]*z[11] + (-16*f0*f2*f8 + 4*f0*f3*f7 +
8*f1^2*f8)*z[2]^2*z[9]*z[12] + (16*f0*f2*f8 - 4*f1^2*f8)*z[2]^2*z[9]*z[13] -
8*f0*f3*f8*z[2]^2*z[9]*z[14] + (8*f0*f2 - 2*f1^2)*z[2]^2*z[10]^2 -
4*f0*f3*z[2]^2*z[10]*z[11] + 2*f1*f3*z[2]^2*z[10]*z[12] - 4*f0*z[2]^2*z[10]*z[16]
+ 4*f0*f5*z[2]^2*z[11]*z[12] - 2*f1*f5*z[2]^2*z[12]^2 - 4*f0*f7*z[2]^2*z[12]*z[14]
+ 2*f1*f7*z[2]^2*z[12]*z[15] + 8*f0*f8*z[2]^2*z[14]^2 - 4*f1*f8*z[2]^2*z[14]*z[15]
- 16*f0^2*f7*f8*z[2]*z[3]*z[9]^2 + (-8*f0*f1*f8 - 8*f0*f2*f7 +
2*f1^2*f7)*z[2]*z[3]*z[9]*z[10] + (16*f0*f2*f8 + 8*f0*f3*f7)*z[2]*z[3]*z[9]*z[11]
+ (16*f0*f3*f8 - 8*f0*f4*f7 - 8*f1*f2*f8 - 2*f1*f3*f7)*z[2]*z[3]*z[9]*z[12] -
16*f0*f3*f8*z[2]*z[3]*z[9]*z[13] + (16*f0*f4*f8 + 4*f1*f3*f8)*z[2]*z[3]*z[9]*z[14]
- 8*f0*f5*f8*z[2]*z[3]*z[9]*z[15] + 4*f0*f7*z[2]*z[3]*z[9]*z[16] -
4*f0*f3*z[2]*z[3]*z[10]^2 + 8*f0*f4*z[2]*z[3]*z[10]*z[11] -
4*f1*f4*z[2]*z[3]*z[10]*z[12] + 4*f0*f7*z[2]*z[3]*z[10]*z[15] +
2*f1*z[2]*z[3]*z[10]*z[16] - 4*f0*f5*z[2]*z[3]*z[11]^2 + (-8*f0*f6 +
2*f1*f5)*z[2]*z[3]*z[11]*z[12] + 4*f0*f7*z[2]*z[3]*z[11]*z[14] -
2*f1*f7*z[2]*z[3]*z[11]*z[15] + (4*f0*f7 + 4*f1*f6)*z[2]*z[3]*z[12]^2 +
4*f0*f7*z[2]*z[3]*z[12]*z[13] + (-8*f0*f8 - 2*f1*f7)*z[2]*z[3]*z[12]*z[14] -
8*f0*f8*z[2]*z[3]*z[13]*z[14] + 4*f1*f8*z[2]*z[3]*z[13]*z[15] +
8*f0*f1*f7*f8*z[2]*z[4]*z[9]^2 + (-16*f0*f2*f8 + 4*f0*f3*f7 +
8*f1^2*f8)*z[2]*z[4]*z[9]*z[10] + (8*f0*f3*f8 - 8*f0*f4*f7 - 8*f1*f2*f8 -
2*f1*f3*f7)*z[2]*z[4]*z[9]*z[11] + (-4*f0*f5*f7 - 16*f1*f3*f8 + 8*f1*f4*f7 +
16*f2^2*f8)*z[2]*z[4]*z[9]*z[12] + (16*f0*f4*f8 + 4*f1*f3*f8)*z[2]*z[4]*z[9]*z[13]
- 16*f1*f4*f8*z[2]*z[4]*z[9]*z[14] + (-16*f0*f6*f8 + 4*f0*f7^2 +
8*f1*f5*f8)*z[2]*z[4]*z[9]*z[15] + (8*f0*f8 - 2*f1*f7)*z[2]*z[4]*z[9]*z[16] +
2*f1*f3*z[2]*z[4]*z[10]^2 - 4*f1*f4*z[2]*z[4]*z[10]*z[11] + (8*f0*f6 + 8*f2*f4 -
2*f3^2)*z[2]*z[4]*z[10]*z[12] - 4*f0*f7*z[2]*z[4]*z[10]*z[14] + (8*f0*f8 -
2*f1*f7)*z[2]*z[4]*z[10]*z[15] - 4*f2*z[2]*z[4]*z[10]*z[16] +
2*f1*f5*z[2]*z[4]*z[11]^2 + (-4*f0*f7 - 4*f2*f5)*z[2]*z[4]*z[11]*z[12] +
4*f0*f7*z[2]*z[4]*z[11]*z[13] - 2*f1*f7*z[2]*z[4]*z[11]*z[14] +
4*f2*f7*z[2]*z[4]*z[11]*z[15] + 2*f3*z[2]*z[4]*z[11]*z[16] + (-8*f0*f8 +
2*f3*f5)*z[2]*z[4]*z[12]^2 - 2*f1*f7*z[2]*z[4]*z[12]*z[13] +
8*f1*f8*z[2]*z[4]*z[12]*z[14] + (-8*f2*f8 - 2*f3*f7)*z[2]*z[4]*z[12]*z[15] -
4*f4*z[2]*z[4]*z[12]*z[16] - 8*f0*f8*z[2]*z[4]*z[13]^2 +
8*f1*f8*z[2]*z[4]*z[13]*z[14] - 8*f2*f8*z[2]*z[4]*z[13]*z[15] +
4*f3*f8*z[2]*z[4]*z[14]*z[15] + 2*z[2]*z[4]*z[16]^2 + (32*f0^2*f8^2 +
32*f0*f2*f6*f8 - 8*f0*f2*f7^2 - 8*f0*f3*f5*f8 - 8*f1^2*f6*f8 +
2*f1^2*f7^2)*z[2]*z[5]*z[9]^2 + (-16*f0*f2*f8 + 4*f0*f3*f7 +
4*f1^2*f8)*z[2]*z[5]*z[9]*z[10] - 8*f0*f4*f7*z[2]*z[5]*z[9]*z[11] + (-16*f0*f4*f8
+ 4*f0*f5*f7 + 4*f1*f3*f8 + 4*f1*f4*f7)*z[2]*z[5]*z[9]*z[12] +
16*f0*f4*f8*z[2]*z[5]*z[9]*z[13] - 8*f1*f4*f8*z[2]*z[5]*z[9]*z[14] + (-16*f0*f6*f8
+ 4*f0*f7^2 + 4*f1*f5*f8)*z[2]*z[5]*z[9]*z[15] + (8*f0*f8 -
2*f1*f7)*z[2]*z[5]*z[9]*z[16] - 4*f0*f7*z[2]*z[5]*z[10]*z[14] +
8*f0*f8*z[2]*z[5]*z[10]*z[15] + 4*f0*f7*z[2]*z[5]*z[11]*z[12] +
4*f0*f7*z[2]*z[5]*z[11]*z[13] - 4*f1*f8*z[2]*z[5]*z[11]*z[15] + (-8*f0*f8 -
2*f1*f7)*z[2]*z[5]*z[12]^2 - 2*f1*f7*z[2]*z[5]*z[12]*z[13] +
4*f1*f8*z[2]*z[5]*z[12]*z[14] - 8*f0*f8*z[2]*z[5]*z[13]^2 +
4*f1*f8*z[2]*z[5]*z[13]*z[14] + (-16*f0*f1*f8^2 - 16*f0*f3*f6*f8 + 4*f0*f3*f7^2 +
4*f1*f3*f5*f8)*z[2]*z[6]*z[9]^2 + (16*f0*f3*f8 - 2*f1*f3*f7)*z[2]*z[6]*z[9]*z[10]
+ (-16*f0*f4*f8 + 4*f0*f5*f7 + 4*f1*f4*f7)*z[2]*z[6]*z[9]*z[11] + (16*f1*f4*f8 -
4*f1*f5*f7 - 8*f2*f3*f8 - 8*f2*f4*f7 + 2*f3^2*f7)*z[2]*z[6]*z[9]*z[12] -
8*f1*f4*f8*z[2]*z[6]*z[9]*z[13] + (16*f0*f6*f8 - 4*f0*f7^2 + 16*f2*f4*f8 -
4*f3^2*f8)*z[2]*z[6]*z[9]*z[14] - 8*f2*f5*f8*z[2]*z[6]*z[9]*z[15] + (-4*f1*f8 +
4*f2*f7)*z[2]*z[6]*z[9]*z[16] - 4*f0*f7*z[2]*z[6]*z[10]*z[12] -
4*f0*f7*z[2]*z[6]*z[10]*z[13] + 4*f1*f7*z[2]*z[6]*z[10]*z[14] -
4*f1*f8*z[2]*z[6]*z[10]*z[15] + 8*f0*f8*z[2]*z[6]*z[11]*z[12] + (8*f0*f8 -
2*f1*f7)*z[2]*z[6]*z[11]*z[13] - 4*f1*f8*z[2]*z[6]*z[11]*z[14] + (8*f2*f8 -
2*f3*f7)*z[2]*z[6]*z[11]*z[15] + (-4*f1*f8 + 4*f2*f7)*z[2]*z[6]*z[12]*z[13] -
2*f3*f7*z[2]*z[6]*z[12]*z[14] + 4*f4*f7*z[2]*z[6]*z[12]*z[15] +
4*f1*f8*z[2]*z[6]*z[13]^2 - 8*f2*f8*z[2]*z[6]*z[13]*z[14] +
4*f3*f8*z[2]*z[6]*z[13]*z[15] + 4*f3*f8*z[2]*z[6]*z[14]^2 -
8*f4*f8*z[2]*z[6]*z[14]*z[15] + 4*f5*f8*z[2]*z[6]*z[15]^2 -
2*f7*z[2]*z[6]*z[15]*z[16] + (32*f0*f2*f8^2 - 8*f0*f3*f7*f8 + 32*f0*f4*f6*f8 -
8*f0*f4*f7^2 - 8*f0*f5^2*f8 - 8*f1^2*f8^2 - 8*f1*f3*f6*f8 +
2*f1*f3*f7^2)*z[2]*z[7]*z[9]^2 + (-16*f0*f4*f8 + 4*f0*f5*f7 +
4*f1*f3*f8)*z[2]*z[7]*z[9]*z[10] + (16*f0*f5*f8 - 8*f0*f6*f7 -
2*f1*f5*f7)*z[2]*z[7]*z[9]*z[11] + (-16*f0*f6*f8 + 4*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7 + 4*f2*f5*f7 + 4*f3^2*f8)*z[2]*z[7]*z[9]*z[12] + (-16*f0*f6*f8 +
8*f0*f7^2 + 4*f1*f5*f8)*z[2]*z[7]*z[9]*z[13] + (-2*f1*f7^2 -
8*f2*f5*f8)*z[2]*z[7]*z[9]*z[14] + (-16*f0*f8^2 + 4*f1*f7*f8 + 16*f2*f6*f8 -
4*f2*f7^2)*z[2]*z[7]*z[9]*z[15] + (-6*f2*f8 - f3*f7)*z[2]*z[7]*z[9]*z[16] +
4*f0*f7*z[2]*z[7]*z[10]*z[11] + (8*f0*f8 - 2*f1*f7)*z[2]*z[7]*z[10]*z[12] +
8*f0*f8*z[2]*z[7]*z[10]*z[13] - 4*f1*f8*z[2]*z[7]*z[10]*z[14] + (-2*f2*f8 +
f3*f7)*z[2]*z[7]*z[10]*z[15] - 16*f0*f8*z[2]*z[7]*z[11]^2 +
8*f1*f8*z[2]*z[7]*z[11]*z[12] + (2*f2*f8 + f3*f7)*z[2]*z[7]*z[11]*z[14] -
4*f3*f8*z[2]*z[7]*z[11]*z[15] + (-2*f2*f8 - f3*f7)*z[2]*z[7]*z[12]*z[13] -
2*f5*f7*z[2]*z[7]*z[12]*z[15] + 4*f5*f8*z[2]*z[7]*z[14]*z[15] + (-8*f6*f8 +
2*f7^2)*z[2]*z[7]*z[15]^2 + 4*f8*z[2]*z[7]*z[15]*z[16] +
8*f0*f7*z[2]*z[8]*z[9]*z[11] + (8*f0*f8 - 4*f1*f7)*z[2]*z[8]*z[9]*z[12] -
16*f0*f8*z[2]*z[8]*z[9]*z[13] + 8*f1*f8*z[2]*z[8]*z[9]*z[14] -
4*f0*z[2]*z[8]*z[10]^2 + 2*f1*z[2]*z[8]*z[10]*z[11] - 4*f2*z[2]*z[8]*z[10]*z[12] +
2*z[2]*z[8]*z[12]*z[16] + (8*f0*f1*f7*f8 - 32*f0*f2*f6*f8 + 8*f0*f2*f7^2 +
8*f0*f3*f5*f8 + 8*f1^2*f6*f8 - 2*f1^2*f7^2)*z[3]^2*z[9]^2 + (32*f0*f2*f8 -
8*f1^2*f8)*z[3]^2*z[9]*z[10] - 16*f0*f3*f8*z[3]^2*z[9]*z[11] + (4*f0*f5*f7 +
4*f1*f3*f8)*z[3]^2*z[9]*z[12] - 8*f0*f5*f8*z[3]^2*z[9]*z[14] + (32*f0*f6*f8 -
8*f0*f7^2 - 4*f1*f5*f8)*z[3]^2*z[9]*z[15] - 16*f0*f8*z[3]^2*z[9]*z[16] -
4*f0*f5*z[3]^2*z[10]*z[11] + 2*f1*f5*z[3]^2*z[10]*z[12] -
16*f0*f8*z[3]^2*z[10]*z[15] + 8*f0*f6*z[3]^2*z[11]^2 - 4*f1*f6*z[3]^2*z[11]*z[12]
- 8*f0*f7*z[3]^2*z[11]*z[13] + 2*f1*f7*z[3]^2*z[11]*z[14] +
4*f1*f8*z[3]^2*z[11]*z[15] + (8*f0*f8 - 2*f1*f7)*z[3]^2*z[12]^2 +
2*f1*f7*z[3]^2*z[12]*z[13] + 8*f0*f8*z[3]^2*z[13]^2 - 4*f1*f8*z[3]^2*z[13]*z[14] +
(32*f0*f3*f6*f8 - 8*f0*f3*f7^2 - 16*f0*f4*f5*f8 - 8*f1^2*f7*f8 -
4*f1*f3*f5*f8)*z[3]*z[4]*z[9]^2 - 24*f0*f3*f8*z[3]*z[4]*z[9]*z[10] + (16*f0*f4*f8
+ 4*f0*f5*f7 + 8*f1*f3*f8)*z[3]*z[4]*z[9]*z[11] + (-4*f1*f5*f7 -
8*f2*f3*f8)*z[3]*z[4]*z[9]*z[12] + (-16*f0*f6*f8 + 4*f0*f7^2 +
8*f1*f5*f8)*z[3]*z[4]*z[9]*z[14] + (8*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2 +
8*f2*f5*f8)*z[3]*z[4]*z[9]*z[15] + 8*f1*f8*z[3]*z[4]*z[9]*z[16] +
4*f0*f5*z[3]*z[4]*z[10]^2 + (-8*f0*f6 + 2*f1*f5)*z[3]*z[4]*z[10]*z[11] + (-4*f0*f7
- 4*f2*f5)*z[3]*z[4]*z[10]*z[12] + 4*f0*f7*z[3]*z[4]*z[10]*z[13] +
8*f0*f8*z[3]*z[4]*z[10]*z[14] + 8*f1*f8*z[3]*z[4]*z[10]*z[15] -
4*f1*f6*z[3]*z[4]*z[11]^2 + (8*f0*f8 + 4*f1*f7 + 8*f2*f6)*z[3]*z[4]*z[11]*z[12] +
(-8*f0*f8 + 4*f1*f7)*z[3]*z[4]*z[11]*z[13] - 4*f2*f7*z[3]*z[4]*z[11]*z[14] -
8*f2*f8*z[3]*z[4]*z[11]*z[15] + (-8*f1*f8 - 4*f3*f6)*z[3]*z[4]*z[12]^2 -
4*f2*f7*z[3]*z[4]*z[12]*z[13] + 4*f3*f7*z[3]*z[4]*z[12]*z[14] +
8*f3*f8*z[3]*z[4]*z[12]*z[15] + 2*f5*z[3]*z[4]*z[12]*z[16] -
4*f1*f8*z[3]*z[4]*z[13]^2 + 8*f2*f8*z[3]*z[4]*z[13]*z[14] -
4*f3*f8*z[3]*z[4]*z[14]^2 - 4*f5*f8*z[3]*z[4]*z[15]^2 -
16*f0*f1*f8^2*z[3]*z[5]*z[9]^2 - 8*f0*f3*f8*z[3]*z[5]*z[9]*z[10] + (16*f0*f4*f8 +
4*f0*f5*f7)*z[3]*z[5]*z[9]*z[11] + (8*f0*f5*f8 - 8*f0*f6*f7 - 8*f1*f4*f8 -
2*f1*f5*f7)*z[3]*z[5]*z[9]*z[12] - 16*f0*f5*f8*z[3]*z[5]*z[9]*z[13] + (4*f0*f7^2 +
8*f1*f5*f8)*z[3]*z[5]*z[9]*z[14] - 8*f0*f7*f8*z[3]*z[5]*z[9]*z[15] +
4*f1*f8*z[3]*z[5]*z[9]*z[16] + 4*f0*f7*z[3]*z[5]*z[10]*z[12] +
4*f0*f7*z[3]*z[5]*z[10]*z[13] + (8*f0*f8 - 2*f1*f7)*z[3]*z[5]*z[10]*z[14] -
8*f0*f7*z[3]*z[5]*z[11]^2 + (-8*f0*f8 + 4*f1*f7)*z[3]*z[5]*z[11]*z[12] +
8*f0*f8*z[3]*z[5]*z[11]*z[13] - 4*f1*f8*z[3]*z[5]*z[11]*z[14] +
4*f1*f8*z[3]*z[5]*z[12]^2 + (8*f0*f5^2*f8 + 8*f1^2*f8^2)*z[3]*z[6]*z[9]^2 -
4*f0*f5*f7*z[3]*z[6]*z[9]*z[10] + (-8*f0*f5*f8 - 2*f1*f5*f7)*z[3]*z[6]*z[9]*z[11]
+ (4*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7 + 4*f2*f5*f7 +
4*f3^2*f8)*z[3]*z[6]*z[9]*z[12] + 4*f1*f5*f8*z[3]*z[6]*z[9]*z[13] + (-8*f0*f7*f8 -
2*f1*f7^2 - 8*f2*f5*f8)*z[3]*z[6]*z[9]*z[14] + 4*f1*f7*f8*z[3]*z[6]*z[9]*z[15] +
(-2*f2*f8 - f3*f7)*z[3]*z[6]*z[9]*z[16] + 4*f0*f7*z[3]*z[6]*z[10]*z[11] -
2*f1*f7*z[3]*z[6]*z[10]*z[12] - 4*f1*f8*z[3]*z[6]*z[10]*z[14] + (2*f2*f8 +
f3*f7)*z[3]*z[6]*z[10]*z[15] + 2*f1*f7*z[3]*z[6]*z[11]^2 -
4*f2*f7*z[3]*z[6]*z[11]*z[12] - 4*f1*f8*z[3]*z[6]*z[11]*z[13] + (6*f2*f8 +
f3*f7)*z[3]*z[6]*z[11]*z[14] - 4*f3*f8*z[3]*z[6]*z[11]*z[15] +
2*f3*f7*z[3]*z[6]*z[12]^2 + (2*f2*f8 - f3*f7)*z[3]*z[6]*z[12]*z[13] -
4*f3*f8*z[3]*z[6]*z[12]*z[14] - 2*f5*f7*z[3]*z[6]*z[12]*z[15] +
4*f5*f8*z[3]*z[6]*z[14]*z[15] + (-16*f0*f3*f8^2 - 16*f0*f5*f6*f8 + 4*f0*f5*f7^2 +
4*f1*f3*f7*f8)*z[3]*z[7]*z[9]^2 + 8*f0*f5*f8*z[3]*z[7]*z[9]*z[10] + (16*f0*f6*f8 -
8*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7)*z[3]*z[7]*z[9]*z[11] + (-8*f0*f7*f8 +
8*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8)*z[3]*z[7]*z[9]*z[12] + (8*f0*f7*f8 -
2*f1*f7^2)*z[3]*z[7]*z[9]*z[13] + (16*f0*f8^2 + 4*f2*f7^2 +
4*f3*f5*f8)*z[3]*z[7]*z[9]*z[14] - 8*f2*f7*f8*z[3]*z[7]*z[9]*z[15] +
4*f3*f8*z[3]*z[7]*z[9]*z[16] - 2*f1*f7*z[3]*z[7]*z[10]*z[11] +
4*f2*f7*z[3]*z[7]*z[10]*z[12] - 4*f1*f8*z[3]*z[7]*z[10]*z[13] + (8*f2*f8 -
2*f3*f7)*z[3]*z[7]*z[10]*z[14] - 4*f3*f8*z[3]*z[7]*z[10]*z[15] +
4*f1*f8*z[3]*z[7]*z[11]^2 - 8*f2*f8*z[3]*z[7]*z[11]*z[12] -
4*f3*f8*z[3]*z[7]*z[11]*z[14] + 8*f4*f8*z[3]*z[7]*z[11]*z[15] +
4*f3*f8*z[3]*z[7]*z[12]^2 + 4*f3*f8*z[3]*z[7]*z[12]*z[13] + (-4*f5*f8 +
4*f6*f7)*z[3]*z[7]*z[12]*z[15] - 2*f7*z[3]*z[7]*z[12]*z[16] -
4*f5*f8*z[3]*z[7]*z[13]*z[15] + 2*f7*z[3]*z[7]*z[13]*z[16] -
2*f7^2*z[3]*z[7]*z[14]*z[15] - 4*f8*z[3]*z[7]*z[14]*z[16] +
4*f7*f8*z[3]*z[7]*z[15]^2 + 8*f0*f5*f8*z[3]*z[8]*z[9]^2 + (-8*f0*f8 -
2*f1*f7)*z[3]*z[8]*z[9]*z[11] + 4*f2*f7*z[3]*z[8]*z[9]*z[12] +
4*f1*f8*z[3]*z[8]*z[9]*z[13] - 8*f2*f8*z[3]*z[8]*z[9]*z[14] +
2*f3*z[3]*z[8]*z[10]*z[12] - 2*z[3]*z[8]*z[11]*z[16] - 2*f7*z[3]*z[8]*z[12]*z[15]
+ 4*f8*z[3]*z[8]*z[14]*z[15] + (-8*f0*f3*f7*f8 - 32*f0*f4*f6*f8 + 8*f0*f4*f7^2 +
8*f0*f5^2*f8 + 8*f1*f2*f7*f8 + 8*f1*f4*f5*f8)*z[4]^2*z[9]^2 + (32*f0*f4*f8 -
4*f0*f5*f7 - 4*f1*f3*f8)*z[4]^2*z[9]*z[10] + (-16*f0*f5*f8 -
8*f1*f4*f8)*z[4]^2*z[9]*z[11] + (8*f1*f5*f8 + 4*f3^2*f8)*z[4]^2*z[9]*z[12] +
(16*f0*f6*f8 - 4*f0*f7^2 - 4*f1*f5*f8)*z[4]^2*z[9]*z[13] +
8*f0*f7*f8*z[4]^2*z[9]*z[14] + (-8*f1*f7*f8 - 4*f3*f5*f8)*z[4]^2*z[9]*z[15] -
2*f1*f5*z[4]^2*z[10]^2 + (4*f0*f7 + 4*f1*f6)*z[4]^2*z[10]*z[11] + (-8*f0*f8 +
2*f3*f5)*z[4]^2*z[10]*z[12] + (-8*f0*f8 - 2*f1*f7)*z[4]^2*z[10]*z[13] + (8*f0*f8 -
2*f1*f7)*z[4]^2*z[11]^2 + (-8*f1*f8 - 4*f3*f6)*z[4]^2*z[11]*z[12] +
4*f1*f8*z[4]^2*z[11]*z[13] + 2*f3*f7*z[4]^2*z[11]*z[14] +
4*f3*f8*z[4]^2*z[11]*z[15] + (8*f2*f8 + 8*f4*f6 - 2*f5^2)*z[4]^2*z[12]^2 +
2*f3*f7*z[4]^2*z[12]*z[13] + (-4*f3*f8 - 8*f4*f7)*z[4]^2*z[12]*z[14] + (-8*f4*f8 +
4*f5*f7)*z[4]^2*z[12]*z[15] - 4*f6*z[4]^2*z[12]*z[16] - 4*f3*f8*z[4]^2*z[13]*z[14]
+ 8*f4*f8*z[4]^2*z[14]^2 - 4*f5*f8*z[4]^2*z[14]*z[15] + 2*f7*z[4]^2*z[14]*z[16] +
(8*f6*f8 - 2*f7^2)*z[4]^2*z[15]^2 - 4*f8*z[4]^2*z[15]*z[16] + (8*f0*f5^2*f8 +
8*f1^2*f8^2)*z[4]*z[5]*z[9]^2 + (-4*f0*f5*f7 + 4*f1*f3*f8)*z[4]*z[5]*z[9]*z[10] +
(-8*f0*f5*f8 - 8*f1*f4*f8)*z[4]*z[5]*z[9]*z[11] + (16*f0*f6*f8 - 4*f0*f7^2 -
4*f1*f5*f8 + 4*f1*f6*f7 + 16*f2*f4*f8 - 4*f3^2*f8)*z[4]*z[5]*z[9]*z[12] +
4*f1*f5*f8*z[4]*z[5]*z[9]*z[13] + (-2*f1*f7^2 - 8*f2*f5*f8)*z[4]*z[5]*z[9]*z[14] +
(-16*f0*f8^2 + 4*f1*f7*f8)*z[4]*z[5]*z[9]*z[15] + (-6*f2*f8 +
f3*f7)*z[4]*z[5]*z[9]*z[16] + 4*f0*f7*z[4]*z[5]*z[10]*z[11] -
2*f1*f7*z[4]*z[5]*z[10]*z[12] - 2*f1*f7*z[4]*z[5]*z[10]*z[13] + (-4*f1*f8 +
4*f2*f7)*z[4]*z[5]*z[10]*z[14] + (-2*f2*f8 - f3*f7)*z[4]*z[5]*z[10]*z[15] +
2*f1*f7*z[4]*z[5]*z[11]^2 - 4*f2*f7*z[4]*z[5]*z[11]*z[12] + (2*f2*f8 -
f3*f7)*z[4]*z[5]*z[11]*z[14] + 4*f3*f8*z[4]*z[5]*z[11]*z[15] +
2*f3*f7*z[4]*z[5]*z[12]^2 + (-2*f2*f8 + f3*f7)*z[4]*z[5]*z[12]*z[13] -
8*f4*f8*z[4]*z[5]*z[12]*z[15] + 4*f5*f8*z[4]*z[5]*z[14]*z[15] -
2*f7*z[4]*z[5]*z[14]*z[16] + 4*f8*z[4]*z[5]*z[15]*z[16] + (16*f0*f3*f8^2 +
16*f0*f4*f7*f8 - 4*f0*f5*f7^2 - 16*f1*f2*f8^2 - 4*f1*f3*f7*f8 -
8*f1*f5^2*f8)*z[4]*z[6]*z[9]^2 + (-16*f0*f5*f8 + 8*f0*f6*f7 +
4*f1*f5*f7)*z[4]*z[6]*z[9]*z[10] + (16*f0*f6*f8 + 12*f1*f5*f8 -
4*f1*f6*f7)*z[4]*z[6]*z[9]*z[11] + (-16*f1*f6*f8 - 8*f3*f4*f8 -
2*f3*f5*f7)*z[4]*z[6]*z[9]*z[12] + (-16*f0*f7*f8 + 2*f1*f7^2)*z[4]*z[6]*z[9]*z[13]
+ (-16*f0*f8^2 + 8*f1*f7*f8 + 8*f3*f5*f8)*z[4]*z[6]*z[9]*z[14] +
16*f1*f8^2*z[4]*z[6]*z[9]*z[15] + 4*f3*f8*z[4]*z[6]*z[9]*z[16] -
4*f0*f7*z[4]*z[6]*z[10]^2 + (-8*f0*f8 - 2*f1*f7)*z[4]*z[6]*z[10]*z[11] +
8*f1*f8*z[4]*z[6]*z[10]*z[12] + 4*f1*f8*z[4]*z[6]*z[10]*z[13] -
2*f3*f7*z[4]*z[6]*z[10]*z[14] + 4*f3*f7*z[4]*z[6]*z[11]*z[12] -
4*f3*f8*z[4]*z[6]*z[11]*z[14] + (-4*f3*f8 - 8*f4*f7)*z[4]*z[6]*z[12]^2 + (16*f4*f8
+ 4*f5*f7)*z[4]*z[6]*z[12]*z[14] + (4*f5*f8 - 4*f6*f7)*z[4]*z[6]*z[12]*z[15] +
6*f7*z[4]*z[6]*z[12]*z[16] - 8*f5*f8*z[4]*z[6]*z[14]^2 +
2*f7^2*z[4]*z[6]*z[14]*z[15] - 4*f8*z[4]*z[6]*z[14]*z[16] -
4*f7*f8*z[4]*z[6]*z[15]^2 + (8*f1*f3*f8^2 - 8*f1*f4*f7*f8 +
8*f1*f5*f6*f8)*z[4]*z[7]*z[9]^2 + (4*f1*f5*f8 - 4*f1*f6*f7)*z[4]*z[7]*z[9]*z[10] +
(8*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2)*z[4]*z[7]*z[9]*z[11] + (16*f0*f8^2 +
16*f2*f6*f8 - 12*f3*f5*f8 + 4*f3*f6*f7 + 16*f4^2*f8)*z[4]*z[7]*z[9]*z[12] +
(-16*f0*f8^2 + 4*f1*f7*f8)*z[4]*z[7]*z[9]*z[13] + (-8*f2*f7*f8 - 2*f3*f7^2 -
8*f4*f5*f8)*z[4]*z[7]*z[9]*z[14] + (8*f3*f7*f8 + 4*f5^2*f8)*z[4]*z[7]*z[9]*z[15] -
8*f4*f8*z[4]*z[7]*z[9]*z[16] + 2*f1*f7*z[4]*z[7]*z[10]^2 + (-8*f2*f8 -
2*f3*f7)*z[4]*z[7]*z[10]*z[12] + 4*f4*f7*z[4]*z[7]*z[10]*z[14] -
2*f5*f7*z[4]*z[7]*z[10]*z[15] + 8*f3*f8*z[4]*z[7]*z[11]*z[12] -
2*f5*f7*z[4]*z[7]*z[11]*z[14] + (-4*f5*f8 + 4*f6*f7)*z[4]*z[7]*z[11]*z[15] -
2*f7*z[4]*z[7]*z[11]*z[16] + (-8*f4*f8 + 4*f5*f7)*z[4]*z[7]*z[12]^2 -
8*f4*f8*z[4]*z[7]*z[12]*z[13] + (4*f5*f8 - 4*f6*f7)*z[4]*z[7]*z[12]*z[14] -
4*f7^2*z[4]*z[7]*z[12]*z[15] + 8*f8*z[4]*z[7]*z[12]*z[16] +
4*f5*f8*z[4]*z[7]*z[13]*z[14] - 2*f7^2*z[4]*z[7]*z[13]*z[15] +
2*f7^2*z[4]*z[7]*z[14]^2 + 4*f7*f8*z[4]*z[7]*z[14]*z[15] -
8*f8^2*z[4]*z[7]*z[15]^2 + (16*f0*f6*f8 - 4*f0*f7^2 - 8*f1*f5*f8)*z[4]*z[8]*z[9]^2
+ (-16*f0*f8 + 2*f1*f7)*z[4]*z[8]*z[9]*z[10] + 8*f1*f8*z[4]*z[8]*z[9]*z[11] +
(-8*f2*f8 - 2*f3*f7)*z[4]*z[8]*z[9]*z[12] + 4*f3*f8*z[4]*z[8]*z[9]*z[14] -
4*f4*z[4]*z[8]*z[10]*z[12] + 2*z[4]*z[8]*z[10]*z[16] + 2*f5*z[4]*z[8]*z[11]*z[12]
- 2*f7*z[4]*z[8]*z[11]*z[15] - 4*f6*z[4]*z[8]*z[12]^2 + 6*f7*z[4]*z[8]*z[12]*z[14]
+ 8*f8*z[4]*z[8]*z[12]*z[15] + 4*f8*z[4]*z[8]*z[13]*z[15] - 8*f8*z[4]*z[8]*z[14]^2
- 8*f0*f5*f8*z[5]^2*z[9]*z[11] + (4*f0*f7^2 + 4*f1*f5*f8)*z[5]^2*z[9]*z[12] +
(16*f0*f6*f8 - 4*f0*f7^2)*z[5]^2*z[9]*z[13] + (-8*f0*f7*f8 - 8*f1*f6*f8 +
2*f1*f7^2)*z[5]^2*z[9]*z[14] + 16*f0*f8^2*z[5]^2*z[9]*z[15] -
8*f0*f8*z[5]^2*z[10]*z[12] - 8*f0*f8*z[5]^2*z[10]*z[13] +
4*f1*f8*z[5]^2*z[10]*z[14] + 8*f0*f8*z[5]^2*z[11]^2 - 4*f1*f8*z[5]^2*z[11]*z[12] +
(-16*f0*f5*f6*f8 + 4*f0*f5*f7^2)*z[5]*z[6]*z[9]^2 +
16*f0*f5*f8*z[5]*z[6]*z[9]*z[10] + 4*f1*f5*f8*z[5]*z[6]*z[9]*z[11] + (-8*f0*f7*f8
- 4*f1*f7^2 - 8*f2*f5*f8)*z[5]*z[6]*z[9]*z[12] + (-8*f1*f6*f8 +
2*f1*f7^2)*z[5]*z[6]*z[9]*z[13] + (16*f0*f8^2 + 8*f1*f7*f8 + 16*f2*f6*f8 -
4*f2*f7^2)*z[5]*z[6]*z[9]*z[14] - 16*f1*f8^2*z[5]*z[6]*z[9]*z[15] -
8*f0*f8*z[5]*z[6]*z[10]*z[11] + 8*f1*f8*z[5]*z[6]*z[10]*z[12] +
4*f1*f8*z[5]*z[6]*z[10]*z[13] - 8*f2*f8*z[5]*z[6]*z[10]*z[14] -
4*f1*f8*z[5]*z[6]*z[11]^2 + 8*f2*f8*z[5]*z[6]*z[11]*z[12] -
4*f3*f8*z[5]*z[6]*z[12]^2 + 4*f5*f8*z[5]*z[6]*z[12]*z[15] + (-8*f6*f8 +
2*f7^2)*z[5]*z[6]*z[14]*z[15] + 4*f8*z[5]*z[6]*z[14]*z[16] + (32*f0*f4*f8^2 -
16*f0*f5*f7*f8 + 32*f0*f6^2*f8 - 8*f0*f6*f7^2 - 8*f1*f3*f8^2)*z[5]*z[7]*z[9]^2 +
(-32*f0*f6*f8 + 8*f0*f7^2)*z[5]*z[7]*z[9]*z[10] + (16*f0*f7*f8 -
2*f1*f7^2)*z[5]*z[7]*z[9]*z[11] + (4*f2*f7^2 + 4*f3*f5*f8)*z[5]*z[7]*z[9]*z[12] +
(-32*f0*f8^2 + 4*f1*f7*f8)*z[5]*z[7]*z[9]*z[13] + (-8*f2*f7*f8 - 8*f3*f6*f8 +
2*f3*f7^2)*z[5]*z[7]*z[9]*z[14] + 16*f2*f8^2*z[5]*z[7]*z[9]*z[15] +
4*f1*f8*z[5]*z[7]*z[10]*z[11] - 8*f2*f8*z[5]*z[7]*z[10]*z[12] +
4*f3*f8*z[5]*z[7]*z[10]*z[14] - 4*f5*f8*z[5]*z[7]*z[11]*z[15] -
2*f7^2*z[5]*z[7]*z[12]*z[15] + 4*f8*z[5]*z[7]*z[12]*z[16] + (8*f6*f8 -
2*f7^2)*z[5]*z[7]*z[13]*z[15] - 4*f8*z[5]*z[7]*z[13]*z[16] +
4*f7*f8*z[5]*z[7]*z[14]*z[15] - 8*f8^2*z[5]*z[7]*z[15]^2 + (-16*f0*f6*f8 +
4*f0*f7^2)*z[5]*z[8]*z[9]^2 + 8*f0*f8*z[5]*z[8]*z[9]*z[10] -
2*f3*f7*z[5]*z[8]*z[9]*z[12] + 4*f3*f8*z[5]*z[8]*z[9]*z[14] +
2*f7*z[5]*z[8]*z[11]*z[15] - 4*f8*z[5]*z[8]*z[13]*z[15] + (-32*f0*f4*f8^2 +
8*f0*f5*f7*f8 + 8*f1*f3*f8^2 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2)*z[6]^2*z[9]^2 +
(-4*f0*f7^2 - 8*f1*f5*f8)*z[6]^2*z[9]*z[10] + (-8*f0*f7*f8 +
2*f1*f7^2)*z[6]^2*z[9]*z[11] + (8*f1*f7*f8 + 4*f3*f5*f8)*z[6]^2*z[9]*z[12] +
(32*f0*f8^2 - 4*f1*f7*f8)*z[6]^2*z[9]*z[13] + (-16*f1*f8^2 - 8*f3*f6*f8 +
2*f3*f7^2)*z[6]^2*z[9]*z[14] + 8*f0*f8*z[6]^2*z[10]^2 + 4*f3*f8*z[6]^2*z[10]*z[14]
- 4*f3*f8*z[6]^2*z[11]*z[12] + 8*f4*f8*z[6]^2*z[12]^2 - 8*f5*f8*z[6]^2*z[12]*z[14]
+ 2*f7^2*z[6]^2*z[12]*z[15] - 8*f8*z[6]^2*z[12]*z[16] + (8*f6*f8 -
2*f7^2)*z[6]^2*z[14]^2 - 4*f7*f8*z[6]^2*z[14]*z[15] + 8*f8^2*z[6]^2*z[15]^2 +
(16*f0*f5*f8^2 - 16*f0*f6*f7*f8 + 4*f0*f7^3 + 4*f1*f5*f7*f8 - 16*f1*f6^2*f8 +
4*f1*f6*f7^2)*z[6]*z[7]*z[9]^2 + (8*f0*f7*f8 + 16*f1*f6*f8 -
2*f1*f7^2)*z[6]*z[7]*z[9]*z[10] + (-16*f0*f8^2 - 4*f1*f7*f8)*z[6]*z[7]*z[9]*z[11]
+ (-8*f2*f7*f8 - 2*f3*f7^2 - 8*f4*f5*f8)*z[6]*z[7]*z[9]*z[12] + (16*f2*f8^2 +
4*f3*f7*f8 + 16*f4*f6*f8 - 4*f4*f7^2)*z[6]*z[7]*z[9]*z[14] + (-16*f3*f8^2 -
8*f5*f6*f8 + 2*f5*f7^2)*z[6]*z[7]*z[9]*z[15] + 4*f5*f8*z[6]*z[7]*z[9]*z[16] -
4*f1*f8*z[6]*z[7]*z[10]^2 + 4*f3*f8*z[6]*z[7]*z[10]*z[12] -
8*f4*f8*z[6]*z[7]*z[10]*z[14] + 4*f5*f8*z[6]*z[7]*z[10]*z[15] +
4*f5*f8*z[6]*z[7]*z[11]*z[14] - 2*f7^2*z[6]*z[7]*z[11]*z[15] +
4*f8*z[6]*z[7]*z[11]*z[16] - 4*f5*f8*z[6]*z[7]*z[12]^2 +
4*f5*f8*z[6]*z[7]*z[12]*z[13] + 2*f7^2*z[6]*z[7]*z[12]*z[14] +
4*f7*f8*z[6]*z[7]*z[12]*z[15] + (-8*f6*f8 + 2*f7^2)*z[6]*z[7]*z[13]*z[14] +
4*f7*f8*z[6]*z[7]*z[13]*z[15] - 4*f7*f8*z[6]*z[7]*z[14]^2 + (8*f1*f6*f8 -
2*f1*f7^2)*z[6]*z[8]*z[9]^2 - 4*f1*f8*z[6]*z[8]*z[9]*z[10] + (4*f3*f8 +
4*f4*f7)*z[6]*z[8]*z[9]*z[12] - 8*f4*f8*z[6]*z[8]*z[9]*z[14] +
4*f5*f8*z[6]*z[8]*z[9]*z[15] - 2*f7*z[6]*z[8]*z[9]*z[16] -
4*f8*z[6]*z[8]*z[11]*z[15] + 2*f7*z[6]*z[8]*z[12]^2 - 2*f7*z[6]*z[8]*z[12]*z[13] -
4*f8*z[6]*z[8]*z[12]*z[14] + 4*f8*z[6]*z[8]*z[13]*z[14] + (-8*f1*f5*f8^2 +
8*f1*f6*f7*f8 - 2*f1*f7^3)*z[7]^2*z[9]^2 - 4*f1*f7*f8*z[7]^2*z[9]*z[10] +
8*f1*f8^2*z[7]^2*z[9]*z[11] + (4*f3*f7*f8 + 4*f5^2*f8)*z[7]^2*z[9]*z[12] +
(-8*f3*f8^2 - 8*f5*f6*f8 + 2*f5*f7^2)*z[7]^2*z[9]*z[14] + (16*f4*f8^2 - 8*f5*f7*f8
+ 16*f6^2*f8 - 4*f6*f7^2)*z[7]^2*z[9]*z[15] + (-8*f6*f8 +
2*f7^2)*z[7]^2*z[9]*z[16] + 4*f5*f8*z[7]^2*z[10]*z[14] + (-8*f6*f8 +
2*f7^2)*z[7]^2*z[10]*z[15] - 4*f5*f8*z[7]^2*z[11]*z[12] +
4*f7*f8*z[7]^2*z[11]*z[15] + (8*f6*f8 - 2*f7^2)*z[7]^2*z[12]^2 -
4*f7*f8*z[7]^2*z[12]*z[14] - 8*f8^2*z[7]^2*z[12]*z[15] - 8*f8^2*z[7]^2*z[13]*z[15]
+ 8*f8^2*z[7]^2*z[14]^2 + (-8*f4*f8 - 2*f5*f7)*z[7]*z[8]*z[9]*z[12] +
8*f5*f8*z[7]*z[8]*z[9]*z[14] + (-16*f6*f8 + 4*f7^2)*z[7]*z[8]*z[9]*z[15] +
8*f8*z[7]*z[8]*z[9]*z[16] - 2*f7*z[7]*z[8]*z[10]*z[14] +
4*f8*z[7]*z[8]*z[10]*z[15] - 4*f8*z[7]*z[8]*z[12]^2 + 4*f8*z[7]*z[8]*z[12]*z[13] +
2*z[8]^2*z[10]*z[12],

// Bmat[4,3]
  (16*f0^2*f5*f8 + 16*f0*f2*f3*f8 - 4*f1^2*f3*f8)*z[1]^2*z[10]^2 + (-32*f0^2*f6*f8
- 8*f0*f1*f5*f8 - 16*f0*f3^2*f8)*z[1]^2*z[10]*z[11] + (16*f0*f1*f6*f8 -
16*f0*f2*f5*f8 + 16*f0*f3*f4*f8 + 8*f1^2*f5*f8 + 4*f1*f3^2*f8)*z[1]^2*z[10]*z[12]
+ 16*f0^2*f7*f8*z[1]^2*z[10]*z[13] - 8*f0*f1*f7*f8*z[1]^2*z[10]*z[14] -
16*f0*f3*f8*z[1]^2*z[10]*z[16] + (16*f0^2*f7*f8 + 16*f0*f1*f6*f8 +
16*f0*f3*f4*f8)*z[1]^2*z[11]^2 + (-16*f0*f1*f7*f8 + 8*f0*f3*f5*f8 - 32*f0*f4^2*f8
- 16*f1^2*f6*f8 - 8*f1*f3*f4*f8)*z[1]^2*z[11]*z[12] + (-32*f0^2*f8^2 -
16*f0*f1*f7*f8 - 16*f0*f3*f5*f8)*z[1]^2*z[11]*z[13] + (16*f0*f1*f8^2 +
16*f0*f4*f5*f8 + 8*f1^2*f7*f8 + 4*f1*f3*f5*f8)*z[1]^2*z[11]*z[14] -
8*f0*f5^2*f8*z[1]^2*z[11]*z[15] + (16*f0*f4*f8 + 4*f1*f3*f8)*z[1]^2*z[11]*z[16] +
(16*f0*f2*f7*f8 - 16*f0*f3*f6*f8 + 16*f0*f4*f5*f8 + 16*f1*f2*f6*f8 - 8*f1*f3*f5*f8
+ 16*f1*f4^2*f8)*z[1]^2*z[12]^2 + (16*f0*f1*f8^2 + 16*f0*f4*f5*f8 + 8*f1^2*f7*f8 +
4*f1*f3*f5*f8)*z[1]^2*z[12]*z[13] + (-32*f0*f2*f8^2 + 8*f0*f3*f7*f8 -
16*f0*f5^2*f8 - 16*f1*f2*f7*f8 - 16*f1*f4*f5*f8)*z[1]^2*z[12]*z[14] +
(16*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 + 8*f1*f3*f7*f8 +
8*f1*f5^2*f8)*z[1]^2*z[12]*z[15] + (-8*f0*f5*f8 - 16*f1*f4*f8)*z[1]^2*z[12]*z[16]
+ (16*f0*f1*f8^2 + 16*f0*f3*f6*f8 - 4*f0*f3*f7^2)*z[1]^2*z[13]^2 +
(-32*f0*f4*f6*f8 + 8*f0*f4*f7^2 - 16*f1^2*f8^2 - 8*f1*f3*f6*f8 +
2*f1*f3*f7^2)*z[1]^2*z[13]*z[14] + (16*f0*f5*f6*f8 -
4*f0*f5*f7^2)*z[1]^2*z[13]*z[15] - 8*f0*f5*f8*z[1]^2*z[13]*z[16] + (16*f0*f5*f6*f8
- 4*f0*f5*f7^2 + 16*f1*f2*f8^2 + 16*f1*f4*f6*f8 - 4*f1*f4*f7^2)*z[1]^2*z[14]^2 +
(8*f0*f5*f7*f8 - 32*f0*f6^2*f8 + 8*f0*f6*f7^2 - 16*f1*f3*f8^2 - 16*f1*f5*f6*f8 +
4*f1*f5*f7^2)*z[1]^2*z[14]*z[15] + (16*f0*f6*f8 - 4*f0*f7^2 +
8*f1*f5*f8)*z[1]^2*z[14]*z[16] + (-16*f0*f5*f8^2 + 16*f0*f6*f7*f8 - 4*f0*f7^3 +
16*f1*f4*f8^2 - 8*f1*f5*f7*f8 + 16*f1*f6^2*f8 - 4*f1*f6*f7^2)*z[1]^2*z[15]^2 +
(-16*f1*f6*f8 + 4*f1*f7^2)*z[1]^2*z[15]*z[16] + (-32*f0^2*f5*f8 - 32*f0*f2*f3*f8 +
8*f1^2*f3*f8)*z[1]*z[2]*z[9]*z[10] + (32*f0^2*f6*f8 + 8*f0*f1*f5*f8 +
16*f0*f3^2*f8)*z[1]*z[2]*z[9]*z[11] + (-16*f0*f1*f6*f8 + 16*f0*f2*f5*f8 -
16*f0*f3*f4*f8 - 8*f1^2*f5*f8 - 4*f1*f3^2*f8)*z[1]*z[2]*z[9]*z[12] -
16*f0^2*f7*f8*z[1]*z[2]*z[9]*z[13] + 8*f0*f1*f7*f8*z[1]*z[2]*z[9]*z[14] +
16*f0*f3*f8*z[1]*z[2]*z[9]*z[16] + 16*f0^2*f8*z[1]*z[2]*z[10]*z[11] -
8*f0*f1*f8*z[1]*z[2]*z[10]*z[12] + 8*f0*f1*f8*z[1]*z[2]*z[10]*z[13] + (16*f0*f2*f8
- 8*f1^2*f8)*z[1]*z[2]*z[10]*z[14] + 8*f0*f3*f8*z[1]*z[2]*z[10]*z[15] -
16*f0*f1*f8*z[1]*z[2]*z[11]^2 + 16*f1^2*f8*z[1]*z[2]*z[11]*z[12] +
8*f0*f3*f7*z[1]*z[2]*z[11]*z[13] + (-8*f0*f3*f8 - 8*f0*f4*f7 -
2*f1*f3*f7)*z[1]*z[2]*z[11]*z[14] + (4*f0*f5*f7 -
4*f1*f3*f8)*z[1]*z[2]*z[11]*z[15] + (8*f0*f3*f8 - 16*f1*f2*f8)*z[1]*z[2]*z[12]^2 +
(-8*f0*f4*f7 - 2*f1*f3*f7)*z[1]*z[2]*z[12]*z[13] + (8*f0*f5*f7 + 8*f1*f3*f8 +
8*f1*f4*f7)*z[1]*z[2]*z[12]*z[14] + (-8*f0*f6*f7 -
4*f1*f5*f7)*z[1]*z[2]*z[12]*z[15] + 4*f0*f7*z[1]*z[2]*z[12]*z[16] -
16*f0*f3*f8*z[1]*z[2]*z[13]^2 + (32*f0*f4*f8 + 8*f1*f3*f8)*z[1]*z[2]*z[13]*z[14] -
16*f0*f5*f8*z[1]*z[2]*z[13]*z[15] + 4*f0*f7*z[1]*z[2]*z[13]*z[16] + (-16*f0*f5*f8
- 16*f1*f4*f8)*z[1]*z[2]*z[14]^2 + (32*f0*f6*f8 - 4*f0*f7^2 +
16*f1*f5*f8)*z[1]*z[2]*z[14]*z[15] + (-16*f0*f8 - 4*f1*f7)*z[1]*z[2]*z[14]*z[16] +
(-8*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2)*z[1]*z[2]*z[15]^2 +
16*f1*f8*z[1]*z[2]*z[15]*z[16] + (32*f0^2*f6*f8 + 8*f0*f1*f5*f8 +
16*f0*f3^2*f8)*z[1]*z[3]*z[9]*z[10] + (-32*f0^2*f7*f8 - 32*f0*f1*f6*f8 -
32*f0*f3*f4*f8)*z[1]*z[3]*z[9]*z[11] + (16*f0*f1*f7*f8 - 8*f0*f3*f5*f8 +
32*f0*f4^2*f8 + 16*f1^2*f6*f8 + 8*f1*f3*f4*f8)*z[1]*z[3]*z[9]*z[12] +
(32*f0^2*f8^2 + 16*f0*f1*f7*f8 + 16*f0*f3*f5*f8)*z[1]*z[3]*z[9]*z[13] +
(-16*f0*f1*f8^2 - 16*f0*f4*f5*f8 - 8*f1^2*f7*f8 -
4*f1*f3*f5*f8)*z[1]*z[3]*z[9]*z[14] + 8*f0*f5^2*f8*z[1]*z[3]*z[9]*z[15] +
(-16*f0*f4*f8 - 4*f1*f3*f8)*z[1]*z[3]*z[9]*z[16] - 16*f0^2*f8*z[1]*z[3]*z[10]^2 +
16*f0*f1*f8*z[1]*z[3]*z[10]*z[11] - 8*f1^2*f8*z[1]*z[3]*z[10]*z[12] + (-8*f0*f3*f7
- 4*f1^2*f8)*z[1]*z[3]*z[10]*z[13] + (-16*f0*f3*f8 + 8*f0*f4*f7 + 8*f1*f2*f8 +
2*f1*f3*f7)*z[1]*z[3]*z[10]*z[14] + (-4*f0*f5*f7 -
4*f1*f3*f8)*z[1]*z[3]*z[10]*z[15] + 16*f0*f3*f8*z[1]*z[3]*z[11]*z[13] -
4*f1*f3*f8*z[1]*z[3]*z[11]*z[14] + (8*f0*f5*f8 + 8*f1*f4*f8)*z[1]*z[3]*z[11]*z[15]
+ (-16*f0*f4*f8 + 8*f1*f3*f8)*z[1]*z[3]*z[12]^2 + (-16*f0*f4*f8 + 4*f0*f5*f7 -
4*f1*f3*f8)*z[1]*z[3]*z[12]*z[13] + (24*f0*f5*f8 - 8*f0*f6*f7 -
4*f1*f5*f7)*z[1]*z[3]*z[12]*z[14] + (-16*f0*f6*f8 + 8*f0*f7^2 - 16*f1*f5*f8 +
8*f1*f6*f7)*z[1]*z[3]*z[12]*z[15] + (8*f0*f8 - 4*f1*f7)*z[1]*z[3]*z[12]*z[16] -
8*f0*f5*f8*z[1]*z[3]*z[13]*z[14] - 4*f1*f5*f8*z[1]*z[3]*z[13]*z[15] +
2*f1*f7*z[1]*z[3]*z[13]*z[16] + (4*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[3]*z[14]^2 +
(-16*f0*f7*f8 - 4*f1*f7^2)*z[1]*z[3]*z[14]*z[15] - 4*f1*f8*z[1]*z[3]*z[14]*z[16] +
(16*f0*f8^2 + 8*f1*f7*f8)*z[1]*z[3]*z[15]^2 + (-16*f0*f1*f6*f8 + 16*f0*f2*f5*f8 -
16*f0*f3*f4*f8 - 8*f1^2*f5*f8 - 4*f1*f3^2*f8)*z[1]*z[4]*z[9]*z[10] +
(16*f0*f1*f7*f8 - 8*f0*f3*f5*f8 + 32*f0*f4^2*f8 + 16*f1^2*f6*f8 +
8*f1*f3*f4*f8)*z[1]*z[4]*z[9]*z[11] + (-32*f0*f2*f7*f8 + 32*f0*f3*f6*f8 -
32*f0*f4*f5*f8 - 32*f1*f2*f6*f8 + 16*f1*f3*f5*f8 -
32*f1*f4^2*f8)*z[1]*z[4]*z[9]*z[12] + (-16*f0*f1*f8^2 - 16*f0*f4*f5*f8 -
8*f1^2*f7*f8 - 4*f1*f3*f5*f8)*z[1]*z[4]*z[9]*z[13] + (32*f0*f2*f8^2 -
8*f0*f3*f7*f8 + 16*f0*f5^2*f8 + 16*f1*f2*f7*f8 +
16*f1*f4*f5*f8)*z[1]*z[4]*z[9]*z[14] + (-16*f0*f3*f8^2 + 16*f0*f4*f7*f8 -
16*f0*f5*f6*f8 - 8*f1*f3*f7*f8 - 8*f1*f5^2*f8)*z[1]*z[4]*z[9]*z[15] + (8*f0*f5*f8
+ 16*f1*f4*f8)*z[1]*z[4]*z[9]*z[16] + 8*f0*f1*f8*z[1]*z[4]*z[10]^2 -
8*f1^2*f8*z[1]*z[4]*z[10]*z[11] + (-8*f0*f3*f8 +
16*f1*f2*f8)*z[1]*z[4]*z[10]*z[12] + (-8*f0*f3*f8 + 8*f0*f4*f7 + 8*f1*f2*f8 +
2*f1*f3*f7)*z[1]*z[4]*z[10]*z[13] + (16*f0*f4*f8 - 8*f0*f5*f7 + 8*f1*f3*f8 -
8*f1*f4*f7 - 16*f2^2*f8)*z[1]*z[4]*z[10]*z[14] + (-8*f0*f5*f8 + 8*f0*f6*f7 +
4*f1*f5*f7 + 8*f2*f3*f8)*z[1]*z[4]*z[10]*z[15] - 4*f0*f7*z[1]*z[4]*z[10]*z[16] +
(16*f0*f4*f8 - 8*f1*f3*f8)*z[1]*z[4]*z[11]*z[12] + (-16*f0*f4*f8 - 4*f0*f5*f7 -
4*f1*f3*f8)*z[1]*z[4]*z[11]*z[13] + (-8*f0*f5*f8 + 8*f0*f6*f7 + 4*f1*f5*f7 +
8*f2*f3*f8)*z[1]*z[4]*z[11]*z[14] + (-8*f0*f7^2 + 8*f1*f5*f8 - 8*f1*f6*f7 -
16*f2*f4*f8)*z[1]*z[4]*z[11]*z[15] + 4*f1*f7*z[1]*z[4]*z[11]*z[16] + (8*f0*f5*f8 +
16*f1*f4*f8)*z[1]*z[4]*z[12]*z[13] + (-16*f0*f6*f8 - 8*f1*f5*f8 -
4*f3^2*f8)*z[1]*z[4]*z[12]*z[14] + (16*f0*f7*f8 + 16*f1*f6*f8 +
8*f3*f4*f8)*z[1]*z[4]*z[12]*z[15] - 8*f1*f8*z[1]*z[4]*z[12]*z[16] +
8*f0*f5*f8*z[1]*z[4]*z[13]^2 + (-4*f0*f7^2 - 8*f1*f5*f8)*z[1]*z[4]*z[13]*z[14] +
(8*f0*f7*f8 + 4*f1*f7^2 + 8*f2*f5*f8)*z[1]*z[4]*z[13]*z[15] -
4*f2*f7*z[1]*z[4]*z[13]*z[16] + 8*f0*f7*f8*z[1]*z[4]*z[14]^2 + (-16*f0*f8^2 -
8*f1*f7*f8 - 4*f3*f5*f8)*z[1]*z[4]*z[14]*z[15] + (8*f2*f8 +
2*f3*f7)*z[1]*z[4]*z[14]*z[16] - 4*f3*f8*z[1]*z[4]*z[15]*z[16] -
16*f0^2*f7*f8*z[1]*z[5]*z[9]*z[10] + (32*f0^2*f8^2 + 16*f0*f1*f7*f8 +
16*f0*f3*f5*f8)*z[1]*z[5]*z[9]*z[11] + (-16*f0*f1*f8^2 - 16*f0*f4*f5*f8 -
8*f1^2*f7*f8 - 4*f1*f3*f5*f8)*z[1]*z[5]*z[9]*z[12] + (-32*f0*f1*f8^2 -
32*f0*f3*f6*f8 + 8*f0*f3*f7^2)*z[1]*z[5]*z[9]*z[13] + (32*f0*f4*f6*f8 -
8*f0*f4*f7^2 + 16*f1^2*f8^2 + 8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*z[1]*z[5]*z[9]*z[14] +
(-16*f0*f5*f6*f8 + 4*f0*f5*f7^2)*z[1]*z[5]*z[9]*z[15] +
8*f0*f5*f8*z[1]*z[5]*z[9]*z[16] - 8*f0*f1*f8*z[1]*z[5]*z[10]^2 +
4*f1^2*f8*z[1]*z[5]*z[10]*z[11] + (8*f0*f3*f8 - 8*f1*f2*f8)*z[1]*z[5]*z[10]*z[12]
+ 16*f0*f3*f8*z[1]*z[5]*z[10]*z[13] + (-16*f0*f4*f8 -
4*f1*f3*f8)*z[1]*z[5]*z[10]*z[14] + 8*f0*f5*f8*z[1]*z[5]*z[10]*z[15] -
16*f0*f3*f8*z[1]*z[5]*z[11]^2 + (32*f0*f4*f8 + 8*f1*f3*f8)*z[1]*z[5]*z[11]*z[12] -
8*f0*f5*f8*z[1]*z[5]*z[11]*z[14] - 4*f1*f5*f8*z[1]*z[5]*z[11]*z[15] -
8*f0*f8*z[1]*z[5]*z[11]*z[16] + (-8*f0*f5*f8 - 16*f1*f4*f8)*z[1]*z[5]*z[12]^2 -
8*f0*f5*f8*z[1]*z[5]*z[12]*z[13] + (4*f0*f7^2 + 16*f1*f5*f8)*z[1]*z[5]*z[12]*z[14]
- 4*f1*f7^2*z[1]*z[5]*z[12]*z[15] + 20*f1*f8*z[1]*z[5]*z[12]*z[16] + (16*f0*f6*f8
- 4*f0*f7^2)*z[1]*z[5]*z[13]*z[14] + (8*f1*f6*f8 -
2*f1*f7^2)*z[1]*z[5]*z[13]*z[15] - 4*f1*f8*z[1]*z[5]*z[13]*z[16] + (-8*f0*f7*f8 -
16*f1*f6*f8 + 4*f1*f7^2)*z[1]*z[5]*z[14]^2 + (16*f0*f8^2 +
8*f1*f7*f8)*z[1]*z[5]*z[14]*z[15] - 16*f1*f8^2*z[1]*z[5]*z[15]^2 +
8*f0*f1*f7*f8*z[1]*z[6]*z[9]*z[10] + (-16*f0*f1*f8^2 - 16*f0*f4*f5*f8 -
8*f1^2*f7*f8 - 4*f1*f3*f5*f8)*z[1]*z[6]*z[9]*z[11] + (32*f0*f2*f8^2 -
8*f0*f3*f7*f8 + 16*f0*f5^2*f8 + 16*f1*f2*f7*f8 +
16*f1*f4*f5*f8)*z[1]*z[6]*z[9]*z[12] + (32*f0*f4*f6*f8 - 8*f0*f4*f7^2 +
16*f1^2*f8^2 + 8*f1*f3*f6*f8 - 2*f1*f3*f7^2)*z[1]*z[6]*z[9]*z[13] +
(-32*f0*f5*f6*f8 + 8*f0*f5*f7^2 - 32*f1*f2*f8^2 - 32*f1*f4*f6*f8 +
8*f1*f4*f7^2)*z[1]*z[6]*z[9]*z[14] + (-8*f0*f5*f7*f8 + 32*f0*f6^2*f8 -
8*f0*f6*f7^2 + 16*f1*f3*f8^2 + 16*f1*f5*f6*f8 - 4*f1*f5*f7^2)*z[1]*z[6]*z[9]*z[15]
+ (-16*f0*f6*f8 + 4*f0*f7^2 - 8*f1*f5*f8)*z[1]*z[6]*z[9]*z[16] + (-16*f0*f2*f8 +
8*f1^2*f8)*z[1]*z[6]*z[10]^2 + (24*f0*f3*f8 - 8*f1*f2*f8)*z[1]*z[6]*z[10]*z[11] +
(-16*f0*f4*f8 - 16*f1*f3*f8 + 16*f2^2*f8)*z[1]*z[6]*z[10]*z[12] + (-16*f0*f4*f8 -
4*f1*f3*f8)*z[1]*z[6]*z[10]*z[13] + (16*f0*f5*f8 +
16*f1*f4*f8)*z[1]*z[6]*z[10]*z[14] + (-16*f0*f6*f8 -
8*f1*f5*f8)*z[1]*z[6]*z[10]*z[15] + 16*f0*f8*z[1]*z[6]*z[10]*z[16] +
4*f1*f3*f8*z[1]*z[6]*z[11]^2 + (-16*f0*f5*f8 - 8*f2*f3*f8)*z[1]*z[6]*z[11]*z[12] +
16*f0*f5*f8*z[1]*z[6]*z[11]*z[13] + (-4*f0*f7^2 -
8*f1*f5*f8)*z[1]*z[6]*z[11]*z[14] + (16*f0*f7*f8 + 4*f1*f7^2 +
8*f2*f5*f8)*z[1]*z[6]*z[11]*z[15] - 8*f1*f8*z[1]*z[6]*z[11]*z[16] + (16*f0*f6*f8 +
8*f1*f5*f8 + 4*f3^2*f8)*z[1]*z[6]*z[12]^2 - 8*f1*f5*f8*z[1]*z[6]*z[12]*z[13] -
8*f0*f7*f8*z[1]*z[6]*z[12]*z[14] + (-16*f0*f8^2 - 8*f1*f7*f8 -
4*f3*f5*f8)*z[1]*z[6]*z[12]*z[15] - 8*f2*f8*z[1]*z[6]*z[12]*z[16] + (-16*f0*f6*f8
+ 4*f0*f7^2)*z[1]*z[6]*z[13]^2 + (8*f0*f7*f8 + 16*f1*f6*f8 -
4*f1*f7^2)*z[1]*z[6]*z[13]*z[14] + (-16*f0*f8^2 - 8*f1*f7*f8 - 16*f2*f6*f8 +
4*f2*f7^2)*z[1]*z[6]*z[13]*z[15] + 8*f2*f8*z[1]*z[6]*z[13]*z[16] + (16*f1*f8^2 +
8*f3*f6*f8 - 2*f3*f7^2)*z[1]*z[6]*z[14]*z[15] - 4*f3*f8*z[1]*z[6]*z[14]*z[16] +
8*f0*f5^2*f8*z[1]*z[7]*z[9]*z[11] + (-16*f0*f3*f8^2 + 16*f0*f4*f7*f8 -
16*f0*f5*f6*f8 - 8*f1*f3*f7*f8 - 8*f1*f5^2*f8)*z[1]*z[7]*z[9]*z[12] +
(-16*f0*f5*f6*f8 + 4*f0*f5*f7^2)*z[1]*z[7]*z[9]*z[13] + (-8*f0*f5*f7*f8 +
32*f0*f6^2*f8 - 8*f0*f6*f7^2 + 16*f1*f3*f8^2 + 16*f1*f5*f6*f8 -
4*f1*f5*f7^2)*z[1]*z[7]*z[9]*z[14] + (32*f0*f5*f8^2 - 32*f0*f6*f7*f8 + 8*f0*f7^3 -
32*f1*f4*f8^2 + 16*f1*f5*f7*f8 - 32*f1*f6^2*f8 +
8*f1*f6*f7^2)*z[1]*z[7]*z[9]*z[15] + (16*f1*f6*f8 -
4*f1*f7^2)*z[1]*z[7]*z[9]*z[16] - 8*f0*f3*f8*z[1]*z[7]*z[10]^2 +
8*f1*f3*f8*z[1]*z[7]*z[10]*z[11] + (8*f0*f5*f8 - 8*f2*f3*f8)*z[1]*z[7]*z[10]*z[12]
+ 8*f0*f5*f8*z[1]*z[7]*z[10]*z[13] + (-16*f0*f6*f8 + 4*f0*f7^2 -
8*f1*f5*f8)*z[1]*z[7]*z[10]*z[14] + (8*f0*f7*f8 + 16*f1*f6*f8 -
4*f1*f7^2)*z[1]*z[7]*z[10]*z[15] + 8*f1*f8*z[1]*z[7]*z[10]*z[16] + (-8*f0*f5*f8 -
8*f1*f4*f8)*z[1]*z[7]*z[11]^2 + (16*f0*f6*f8 + 8*f1*f5*f8 +
16*f2*f4*f8)*z[1]*z[7]*z[11]*z[12] + 8*f1*f5*f8*z[1]*z[7]*z[11]*z[13] -
8*f2*f5*f8*z[1]*z[7]*z[11]*z[14] + (-16*f0*f8^2 -
8*f1*f7*f8)*z[1]*z[7]*z[11]*z[15] - 8*f2*f8*z[1]*z[7]*z[11]*z[16] + (-16*f0*f7*f8
- 16*f1*f6*f8 - 8*f3*f4*f8)*z[1]*z[7]*z[12]^2 + (-8*f0*f7*f8 -
8*f2*f5*f8)*z[1]*z[7]*z[12]*z[13] + (32*f0*f8^2 + 16*f1*f7*f8 +
8*f3*f5*f8)*z[1]*z[7]*z[12]*z[14] + 8*f3*f8*z[1]*z[7]*z[12]*z[16] + (-8*f1*f6*f8 +
2*f1*f7^2)*z[1]*z[7]*z[13]^2 + (16*f2*f6*f8 - 4*f2*f7^2)*z[1]*z[7]*z[13]*z[14] +
16*f1*f8^2*z[1]*z[7]*z[13]*z[15] + (-16*f1*f8^2 - 8*f3*f6*f8 +
2*f3*f7^2)*z[1]*z[7]*z[14]^2 + 16*f0*f3*f8*z[1]*z[8]*z[9]*z[10] + (-16*f0*f4*f8 -
4*f1*f3*f8)*z[1]*z[8]*z[9]*z[11] + (8*f0*f5*f8 + 16*f1*f4*f8)*z[1]*z[8]*z[9]*z[12]
+ 8*f0*f5*f8*z[1]*z[8]*z[9]*z[13] + (-16*f0*f6*f8 + 4*f0*f7^2 -
8*f1*f5*f8)*z[1]*z[8]*z[9]*z[14] + (16*f1*f6*f8 - 4*f1*f7^2)*z[1]*z[8]*z[9]*z[15]
+ (-14*f1*f8 + f2*f7)*z[1]*z[8]*z[9]*z[16] - 4*f0*f7*z[1]*z[8]*z[10]*z[13] +
4*f1*f7*z[1]*z[8]*z[10]*z[14] + (-10*f1*f8 - f2*f7)*z[1]*z[8]*z[10]*z[15] -
8*f0*f8*z[1]*z[8]*z[11]*z[12] + (8*f0*f8 - 2*f1*f7)*z[1]*z[8]*z[11]*z[13] +
(-2*f1*f8 + f2*f7)*z[1]*z[8]*z[11]*z[14] + 8*f2*f8*z[1]*z[8]*z[11]*z[15] +
8*f1*f8*z[1]*z[8]*z[12]^2 + (-6*f1*f8 + 3*f2*f7)*z[1]*z[8]*z[12]*z[13] -
2*f3*f7*z[1]*z[8]*z[12]*z[14] - 4*f3*f8*z[1]*z[8]*z[12]*z[15] +
4*f1*f8*z[1]*z[8]*z[13]^2 - 8*f2*f8*z[1]*z[8]*z[13]*z[14] +
4*f3*f8*z[1]*z[8]*z[14]^2 + (16*f0^2*f5*f8 + 16*f0*f2*f3*f8 -
4*f1^2*f3*f8)*z[2]^2*z[9]^2 - 16*f0^2*f8*z[2]^2*z[9]*z[11] +
8*f0*f1*f8*z[2]^2*z[9]*z[12] - 8*f0*f1*f8*z[2]^2*z[9]*z[13] + (-16*f0*f2*f8 +
8*f1^2*f8)*z[2]^2*z[9]*z[14] - 8*f0*f3*f8*z[2]^2*z[9]*z[15] -
4*f0*f3*z[2]^2*z[11]^2 + (8*f0*f4 + 2*f1*f3)*z[2]^2*z[11]*z[12] -
4*f0*z[2]^2*z[11]*z[16] + (-4*f0*f5 - 4*f1*f4)*z[2]^2*z[12]^2 +
4*f0*f7*z[2]^2*z[12]*z[15] + 4*f1*z[2]^2*z[12]*z[16] - 4*f1*f8*z[2]^2*z[15]^2 +
(-32*f0^2*f6*f8 - 8*f0*f1*f5*f8 - 16*f0*f3^2*f8)*z[2]*z[3]*z[9]^2 +
16*f0^2*f8*z[2]*z[3]*z[9]*z[10] + 16*f0*f1*f8*z[2]*z[3]*z[9]*z[11] -
8*f1^2*f8*z[2]*z[3]*z[9]*z[12] + 4*f1^2*f8*z[2]*z[3]*z[9]*z[13] + (24*f0*f3*f8 -
8*f1*f2*f8)*z[2]*z[3]*z[9]*z[14] + 8*f1*f3*f8*z[2]*z[3]*z[9]*z[15] +
8*f0*f3*z[2]*z[3]*z[10]*z[11] + (-8*f0*f4 - 2*f1*f3)*z[2]*z[3]*z[10]*z[12] +
4*f0*z[2]*z[3]*z[10]*z[16] - 4*f0*f5*z[2]*z[3]*z[11]*z[12] -
2*f1*z[2]*z[3]*z[11]*z[16] + (8*f0*f6 + 4*f1*f5)*z[2]*z[3]*z[12]^2 -
4*f0*f7*z[2]*z[3]*z[12]*z[14] + (-8*f0*f8 - 4*f1*f7)*z[2]*z[3]*z[12]*z[15] +
8*f0*f8*z[2]*z[3]*z[13]*z[15] + 4*f1*f8*z[2]*z[3]*z[14]*z[15] + (16*f0*f1*f6*f8 -
16*f0*f2*f5*f8 + 16*f0*f3*f4*f8 + 8*f1^2*f5*f8 + 4*f1*f3^2*f8)*z[2]*z[4]*z[9]^2 -
8*f0*f1*f8*z[2]*z[4]*z[9]*z[10] - 8*f1^2*f8*z[2]*z[4]*z[9]*z[11] + (-8*f0*f3*f8 +
16*f1*f2*f8)*z[2]*z[4]*z[9]*z[12] + (8*f0*f3*f8 - 8*f1*f2*f8)*z[2]*z[4]*z[9]*z[13]
+ (-16*f0*f4*f8 - 16*f1*f3*f8 + 16*f2^2*f8)*z[2]*z[4]*z[9]*z[14] + (8*f0*f5*f8 -
8*f2*f3*f8)*z[2]*z[4]*z[9]*z[15] + (-8*f0*f4 - 2*f1*f3)*z[2]*z[4]*z[10]*z[11] +
(8*f0*f5 + 8*f1*f4)*z[2]*z[4]*z[10]*z[12] - 4*f0*f7*z[2]*z[4]*z[10]*z[15] -
4*f1*z[2]*z[4]*z[10]*z[16] + 4*f0*f5*z[2]*z[4]*z[11]^2 + (-8*f0*f6 -
4*f1*f5)*z[2]*z[4]*z[11]*z[12] + (8*f0*f8 + 4*f1*f7)*z[2]*z[4]*z[11]*z[15] +
4*f2*z[2]*z[4]*z[11]*z[16] + 4*f0*f7*z[2]*z[4]*z[12]*z[13] +
8*f0*f8*z[2]*z[4]*z[12]*z[14] - 8*f1*f8*z[2]*z[4]*z[12]*z[15] -
2*f3*z[2]*z[4]*z[12]*z[16] - 8*f0*f8*z[2]*z[4]*z[13]*z[14] -
8*f1*f8*z[2]*z[4]*z[13]*z[15] + 8*f1*f8*z[2]*z[4]*z[14]^2 -
8*f2*f8*z[2]*z[4]*z[14]*z[15] + 4*f3*f8*z[2]*z[4]*z[15]^2 +
16*f0^2*f7*f8*z[2]*z[5]*z[9]^2 + 8*f0*f1*f8*z[2]*z[5]*z[9]*z[10] + (-8*f0*f3*f7 -
4*f1^2*f8)*z[2]*z[5]*z[9]*z[11] + (-8*f0*f3*f8 + 8*f0*f4*f7 + 8*f1*f2*f8 +
2*f1*f3*f7)*z[2]*z[5]*z[9]*z[12] + 16*f0*f3*f8*z[2]*z[5]*z[9]*z[13] +
(-16*f0*f4*f8 - 4*f1*f3*f8)*z[2]*z[5]*z[9]*z[14] + 8*f0*f5*f8*z[2]*z[5]*z[9]*z[15]
- 4*f0*f7*z[2]*z[5]*z[9]*z[16] + 4*f0*f7*z[2]*z[5]*z[11]*z[14] + (-8*f0*f8 +
2*f1*f7)*z[2]*z[5]*z[11]*z[15] - 4*f0*f7*z[2]*z[5]*z[12]^2 + (8*f0*f8 -
4*f1*f7)*z[2]*z[5]*z[12]*z[14] - 4*f1*f8*z[2]*z[5]*z[12]*z[15] -
8*f0*f8*z[2]*z[5]*z[13]*z[14] - 4*f1*f8*z[2]*z[5]*z[13]*z[15] +
8*f1*f8*z[2]*z[5]*z[14]^2 - 8*f0*f1*f7*f8*z[2]*z[6]*z[9]^2 + (16*f0*f2*f8 -
8*f1^2*f8)*z[2]*z[6]*z[9]*z[10] + (-16*f0*f3*f8 + 8*f0*f4*f7 + 8*f1*f2*f8 +
2*f1*f3*f7)*z[2]*z[6]*z[9]*z[11] + (16*f0*f4*f8 - 8*f0*f5*f7 + 8*f1*f3*f8 -
8*f1*f4*f7 - 16*f2^2*f8)*z[2]*z[6]*z[9]*z[12] + (-16*f0*f4*f8 -
4*f1*f3*f8)*z[2]*z[6]*z[9]*z[13] + (16*f0*f5*f8 +
16*f1*f4*f8)*z[2]*z[6]*z[9]*z[14] + (-16*f0*f6*f8 + 4*f0*f7^2 -
8*f1*f5*f8)*z[2]*z[6]*z[9]*z[15] + 4*f1*f7*z[2]*z[6]*z[9]*z[16] +
4*f0*f7*z[2]*z[6]*z[11]*z[12] - 4*f0*f7*z[2]*z[6]*z[11]*z[13] + (8*f1*f8 -
4*f2*f7)*z[2]*z[6]*z[11]*z[15] - 8*f0*f8*z[2]*z[6]*z[12]^2 +
4*f1*f7*z[2]*z[6]*z[12]*z[13] - 8*f1*f8*z[2]*z[6]*z[12]*z[14] + (8*f2*f8 +
2*f3*f7)*z[2]*z[6]*z[12]*z[15] + 8*f0*f8*z[2]*z[6]*z[13]^2 -
8*f1*f8*z[2]*z[6]*z[13]*z[14] + 8*f2*f8*z[2]*z[6]*z[13]*z[15] -
4*f3*f8*z[2]*z[6]*z[14]*z[15] + 8*f0*f3*f8*z[2]*z[7]*z[9]*z[10] + (-4*f0*f5*f7 -
4*f1*f3*f8)*z[2]*z[7]*z[9]*z[11] + (-8*f0*f5*f8 + 8*f0*f6*f7 + 4*f1*f5*f7 +
8*f2*f3*f8)*z[2]*z[7]*z[9]*z[12] + 8*f0*f5*f8*z[2]*z[7]*z[9]*z[13] + (-16*f0*f6*f8
- 8*f1*f5*f8)*z[2]*z[7]*z[9]*z[14] + (8*f0*f7*f8 + 16*f1*f6*f8 -
4*f1*f7^2)*z[2]*z[7]*z[9]*z[15] + (-10*f1*f8 - f2*f7)*z[2]*z[7]*z[9]*z[16] -
4*f0*f7*z[2]*z[7]*z[10]*z[12] + (-6*f1*f8 + f2*f7)*z[2]*z[7]*z[10]*z[15] -
2*f1*f7*z[2]*z[7]*z[11]*z[13] + (2*f1*f8 + 3*f2*f7)*z[2]*z[7]*z[11]*z[14] +
8*f1*f8*z[2]*z[7]*z[12]^2 + (-2*f1*f8 + f2*f7)*z[2]*z[7]*z[12]*z[13] -
2*f3*f7*z[2]*z[7]*z[12]*z[14] - 4*f3*f8*z[2]*z[7]*z[12]*z[15] +
4*f1*f8*z[2]*z[7]*z[13]^2 - 8*f2*f8*z[2]*z[7]*z[13]*z[14] +
4*f3*f8*z[2]*z[7]*z[14]^2 - 16*f0*f3*f8*z[2]*z[8]*z[9]^2 -
4*f0*f7*z[2]*z[8]*z[9]*z[12] + 16*f0*f8*z[2]*z[8]*z[9]*z[14] +
8*f1*f8*z[2]*z[8]*z[9]*z[15] + 4*f0*z[2]*z[8]*z[10]*z[11] -
4*f1*z[2]*z[8]*z[10]*z[12] + 2*f1*z[2]*z[8]*z[11]^2 - 4*f2*z[2]*z[8]*z[11]*z[12] +
2*f3*z[2]*z[8]*z[12]^2 + (16*f0^2*f7*f8 + 16*f0*f1*f6*f8 +
16*f0*f3*f4*f8)*z[3]^2*z[9]^2 - 16*f0*f1*f8*z[3]^2*z[9]*z[10] -
16*f0*f3*f8*z[3]^2*z[9]*z[13] + 4*f1*f3*f8*z[3]^2*z[9]*z[14] + (-8*f0*f5*f8 -
8*f1*f4*f8)*z[3]^2*z[9]*z[15] - 4*f0*f3*z[3]^2*z[10]^2 +
4*f0*f5*z[3]^2*z[10]*z[12] + 2*f1*z[3]^2*z[10]*z[16] + (-4*f0*f7 -
4*f1*f6)*z[3]^2*z[12]^2 + 4*f1*f7*z[3]^2*z[12]*z[14] + 8*f1*f8*z[3]^2*z[12]*z[15]
+ 4*f1*f8*z[3]^2*z[13]*z[15] - 8*f1*f8*z[3]^2*z[14]^2 + (-16*f0*f1*f7*f8 +
8*f0*f3*f5*f8 - 32*f0*f4^2*f8 - 16*f1^2*f6*f8 - 8*f1*f3*f4*f8)*z[3]*z[4]*z[9]^2 +
16*f1^2*f8*z[3]*z[4]*z[9]*z[10] + (16*f0*f4*f8 - 8*f1*f3*f8)*z[3]*z[4]*z[9]*z[12]
+ (32*f0*f4*f8 + 8*f1*f3*f8)*z[3]*z[4]*z[9]*z[13] + (-16*f0*f5*f8 -
8*f2*f3*f8)*z[3]*z[4]*z[9]*z[14] + (16*f0*f6*f8 + 8*f1*f5*f8 +
16*f2*f4*f8)*z[3]*z[4]*z[9]*z[15] - 8*f0*f8*z[3]*z[4]*z[9]*z[16] + (8*f0*f4 +
2*f1*f3)*z[3]*z[4]*z[10]^2 - 4*f0*f5*z[3]*z[4]*z[10]*z[11] + (-8*f0*f6 -
4*f1*f5)*z[3]*z[4]*z[10]*z[12] + 4*f0*f7*z[3]*z[4]*z[10]*z[14] -
4*f2*z[3]*z[4]*z[10]*z[16] + (8*f0*f7 + 8*f1*f6)*z[3]*z[4]*z[11]*z[12] -
4*f1*f7*z[3]*z[4]*z[11]*z[14] - 8*f1*f8*z[3]*z[4]*z[11]*z[15] + (-8*f0*f8 -
4*f1*f7)*z[3]*z[4]*z[12]*z[13] - 8*f0*f8*z[3]*z[4]*z[13]^2 +
16*f1*f8*z[3]*z[4]*z[13]*z[14] - 8*f2*f8*z[3]*z[4]*z[13]*z[15] +
8*f3*f8*z[3]*z[4]*z[14]*z[15] - 8*f4*f8*z[3]*z[4]*z[15]^2 + 2*z[3]*z[4]*z[16]^2 +
(-32*f0^2*f8^2 - 16*f0*f1*f7*f8 - 16*f0*f3*f5*f8)*z[3]*z[5]*z[9]^2 +
8*f0*f3*f7*z[3]*z[5]*z[9]*z[10] + 16*f0*f3*f8*z[3]*z[5]*z[9]*z[11] + (-16*f0*f4*f8
- 4*f0*f5*f7 - 4*f1*f3*f8)*z[3]*z[5]*z[9]*z[12] + 16*f0*f5*f8*z[3]*z[5]*z[9]*z[14]
+ 8*f1*f5*f8*z[3]*z[5]*z[9]*z[15] + (8*f0*f8 - 2*f1*f7)*z[3]*z[5]*z[9]*z[16] -
4*f0*f7*z[3]*z[5]*z[10]*z[14] - 2*f1*f7*z[3]*z[5]*z[10]*z[15] -
4*f1*f8*z[3]*z[5]*z[11]*z[15] + (8*f0*f8 + 4*f1*f7)*z[3]*z[5]*z[12]^2 +
8*f0*f8*z[3]*z[5]*z[12]*z[13] + (16*f0*f1*f8^2 + 16*f0*f4*f5*f8 + 8*f1^2*f7*f8 +
4*f1*f3*f5*f8)*z[3]*z[6]*z[9]^2 + (-8*f0*f3*f8 - 8*f0*f4*f7 -
2*f1*f3*f7)*z[3]*z[6]*z[9]*z[10] - 4*f1*f3*f8*z[3]*z[6]*z[9]*z[11] + (-8*f0*f5*f8
+ 8*f0*f6*f7 + 4*f1*f5*f7 + 8*f2*f3*f8)*z[3]*z[6]*z[9]*z[12] -
8*f0*f5*f8*z[3]*z[6]*z[9]*z[13] + (-4*f0*f7^2 - 8*f1*f5*f8)*z[3]*z[6]*z[9]*z[14] -
8*f2*f5*f8*z[3]*z[6]*z[9]*z[15] + (-2*f1*f8 + f2*f7)*z[3]*z[6]*z[9]*z[16] +
4*f0*f7*z[3]*z[6]*z[10]*z[13] + (2*f1*f8 + 3*f2*f7)*z[3]*z[6]*z[10]*z[15] -
4*f1*f7*z[3]*z[6]*z[11]*z[12] + (2*f1*f8 + f2*f7)*z[3]*z[6]*z[11]*z[14] +
(-2*f1*f8 - f2*f7)*z[3]*z[6]*z[12]*z[13] - 4*f3*f8*z[3]*z[6]*z[12]*z[15] +
4*f5*f8*z[3]*z[6]*z[15]^2 - 2*f7*z[3]*z[6]*z[15]*z[16] -
8*f0*f5^2*f8*z[3]*z[7]*z[9]^2 + (4*f0*f5*f7 - 4*f1*f3*f8)*z[3]*z[7]*z[9]*z[10] +
(8*f0*f5*f8 + 8*f1*f4*f8)*z[3]*z[7]*z[9]*z[11] + (-8*f0*f7^2 + 8*f1*f5*f8 -
8*f1*f6*f7 - 16*f2*f4*f8)*z[3]*z[7]*z[9]*z[12] - 4*f1*f5*f8*z[3]*z[7]*z[9]*z[13] +
(16*f0*f7*f8 + 4*f1*f7^2 + 8*f2*f5*f8)*z[3]*z[7]*z[9]*z[14] + (-16*f0*f8^2 -
8*f1*f7*f8)*z[3]*z[7]*z[9]*z[15] + 8*f2*f8*z[3]*z[7]*z[9]*z[16] + (8*f0*f8 +
4*f1*f7)*z[3]*z[7]*z[10]*z[12] + (-8*f0*f8 + 2*f1*f7)*z[3]*z[7]*z[10]*z[13] +
(8*f1*f8 - 4*f2*f7)*z[3]*z[7]*z[10]*z[14] - 8*f1*f8*z[3]*z[7]*z[11]*z[12] -
4*f1*f8*z[3]*z[7]*z[11]*z[13] + 8*f2*f8*z[3]*z[7]*z[12]*z[13] -
4*f3*f8*z[3]*z[7]*z[12]*z[14] + 8*f4*f8*z[3]*z[7]*z[12]*z[15] -
4*f5*f8*z[3]*z[7]*z[14]*z[15] + 2*f7*z[3]*z[7]*z[14]*z[16] -
4*f8*z[3]*z[7]*z[15]*z[16] + (16*f0*f4*f8 + 4*f1*f3*f8)*z[3]*z[8]*z[9]^2 +
4*f1*f7*z[3]*z[8]*z[9]*z[12] - 8*f0*f8*z[3]*z[8]*z[9]*z[13] -
8*f1*f8*z[3]*z[8]*z[9]*z[14] - 8*f2*f8*z[3]*z[8]*z[9]*z[15] -
4*f0*z[3]*z[8]*z[10]^2 - 2*f1*z[3]*z[8]*z[10]*z[11] + 4*f2*z[3]*z[8]*z[10]*z[12] -
2*z[3]*z[8]*z[12]*z[16] + 4*f8*z[3]*z[8]*z[15]^2 + (16*f0*f2*f7*f8 -
16*f0*f3*f6*f8 + 16*f0*f4*f5*f8 + 16*f1*f2*f6*f8 - 8*f1*f3*f5*f8 +
16*f1*f4^2*f8)*z[4]^2*z[9]^2 + (8*f0*f3*f8 - 16*f1*f2*f8)*z[4]^2*z[9]*z[10] +
(-16*f0*f4*f8 + 8*f1*f3*f8)*z[4]^2*z[9]*z[11] + (-8*f0*f5*f8 -
16*f1*f4*f8)*z[4]^2*z[9]*z[13] + (16*f0*f6*f8 + 8*f1*f5*f8 +
4*f3^2*f8)*z[4]^2*z[9]*z[14] + (-16*f0*f7*f8 - 16*f1*f6*f8 -
8*f3*f4*f8)*z[4]^2*z[9]*z[15] + 8*f1*f8*z[4]^2*z[9]*z[16] + (-4*f0*f5 -
4*f1*f4)*z[4]^2*z[10]^2 + (8*f0*f6 + 4*f1*f5)*z[4]^2*z[10]*z[11] -
4*f0*f7*z[4]^2*z[10]*z[13] - 8*f0*f8*z[4]^2*z[10]*z[14] +
8*f1*f8*z[4]^2*z[10]*z[15] + 2*f3*z[4]^2*z[10]*z[16] + (-4*f0*f7 -
4*f1*f6)*z[4]^2*z[11]^2 + (8*f0*f8 + 4*f1*f7)*z[4]^2*z[11]*z[13] -
4*f1*f8*z[4]^2*z[13]^2 + 4*f3*f8*z[4]^2*z[13]*z[15] - 4*f3*f8*z[4]^2*z[14]^2 +
(16*f0*f1*f8^2 + 16*f0*f4*f5*f8 + 8*f1^2*f7*f8 + 4*f1*f3*f5*f8)*z[4]*z[5]*z[9]^2 +
(-8*f0*f4*f7 - 2*f1*f3*f7)*z[4]*z[5]*z[9]*z[10] + (-16*f0*f4*f8 + 4*f0*f5*f7 -
4*f1*f3*f8)*z[4]*z[5]*z[9]*z[11] + (8*f0*f5*f8 + 16*f1*f4*f8)*z[4]*z[5]*z[9]*z[12]
- 8*f0*f5*f8*z[4]*z[5]*z[9]*z[13] - 8*f1*f5*f8*z[4]*z[5]*z[9]*z[14] + (-8*f0*f7*f8
- 8*f2*f5*f8)*z[4]*z[5]*z[9]*z[15] + (-6*f1*f8 + 3*f2*f7)*z[4]*z[5]*z[9]*z[16] +
4*f0*f7*z[4]*z[5]*z[10]*z[12] + 4*f1*f7*z[4]*z[5]*z[10]*z[14] + (-2*f1*f8 +
f2*f7)*z[4]*z[5]*z[10]*z[15] + (-8*f0*f8 - 4*f1*f7)*z[4]*z[5]*z[11]*z[12] +
8*f0*f8*z[4]*z[5]*z[11]*z[13] + (-2*f1*f8 - f2*f7)*z[4]*z[5]*z[11]*z[14] +
8*f2*f8*z[4]*z[5]*z[11]*z[15] + (-6*f1*f8 + f2*f7)*z[4]*z[5]*z[12]*z[13] -
4*f3*f8*z[4]*z[5]*z[12]*z[15] + 4*f5*f8*z[4]*z[5]*z[15]^2 -
2*f7*z[4]*z[5]*z[15]*z[16] + (-32*f0*f2*f8^2 + 8*f0*f3*f7*f8 - 16*f0*f5^2*f8 -
16*f1*f2*f7*f8 - 16*f1*f4*f5*f8)*z[4]*z[6]*z[9]^2 + (8*f0*f5*f7 + 8*f1*f3*f8 +
8*f1*f4*f7)*z[4]*z[6]*z[9]*z[10] + (24*f0*f5*f8 - 8*f0*f6*f7 -
4*f1*f5*f7)*z[4]*z[6]*z[9]*z[11] + (-16*f0*f6*f8 - 8*f1*f5*f8 -
4*f3^2*f8)*z[4]*z[6]*z[9]*z[12] + (4*f0*f7^2 + 16*f1*f5*f8)*z[4]*z[6]*z[9]*z[13] -
8*f0*f7*f8*z[4]*z[6]*z[9]*z[14] + (32*f0*f8^2 + 16*f1*f7*f8 +
8*f3*f5*f8)*z[4]*z[6]*z[9]*z[15] - 2*f3*f7*z[4]*z[6]*z[9]*z[16] -
4*f0*f7*z[4]*z[6]*z[10]*z[11] + 8*f0*f8*z[4]*z[6]*z[10]*z[12] + (8*f0*f8 -
4*f1*f7)*z[4]*z[6]*z[10]*z[13] - 8*f1*f8*z[4]*z[6]*z[10]*z[14] -
2*f3*f7*z[4]*z[6]*z[10]*z[15] + 4*f1*f7*z[4]*z[6]*z[11]^2 -
4*f3*f8*z[4]*z[6]*z[11]*z[15] + 8*f3*f8*z[4]*z[6]*z[12]*z[14] + (16*f0*f3*f8^2 -
16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 + 8*f1*f3*f7*f8 + 8*f1*f5^2*f8)*z[4]*z[7]*z[9]^2 +
(-8*f0*f6*f7 - 4*f1*f5*f7)*z[4]*z[7]*z[9]*z[10] + (-16*f0*f6*f8 + 8*f0*f7^2 -
16*f1*f5*f8 + 8*f1*f6*f7)*z[4]*z[7]*z[9]*z[11] + (16*f0*f7*f8 + 16*f1*f6*f8 +
8*f3*f4*f8)*z[4]*z[7]*z[9]*z[12] - 4*f1*f7^2*z[4]*z[7]*z[9]*z[13] + (-16*f0*f8^2 -
8*f1*f7*f8 - 4*f3*f5*f8)*z[4]*z[7]*z[9]*z[14] - 4*f3*f8*z[4]*z[7]*z[9]*z[16] +
4*f0*f7*z[4]*z[7]*z[10]^2 + (-8*f0*f8 - 4*f1*f7)*z[4]*z[7]*z[10]*z[11] -
8*f1*f8*z[4]*z[7]*z[10]*z[12] - 4*f1*f8*z[4]*z[7]*z[10]*z[13] + (8*f2*f8 +
2*f3*f7)*z[4]*z[7]*z[10]*z[14] - 4*f3*f8*z[4]*z[7]*z[10]*z[15] +
8*f1*f8*z[4]*z[7]*z[11]^2 - 4*f3*f8*z[4]*z[7]*z[11]*z[14] +
8*f4*f8*z[4]*z[7]*z[11]*z[15] - 4*f3*f8*z[4]*z[7]*z[12]*z[13] -
4*f5*f8*z[4]*z[7]*z[13]*z[15] + 2*f7*z[4]*z[7]*z[13]*z[16] -
4*f8*z[4]*z[7]*z[14]*z[16] + (-8*f0*f5*f8 - 16*f1*f4*f8)*z[4]*z[8]*z[9]^2 +
4*f0*f7*z[4]*z[8]*z[9]*z[10] + (8*f0*f8 - 4*f1*f7)*z[4]*z[8]*z[9]*z[11] -
8*f1*f8*z[4]*z[8]*z[9]*z[12] + 20*f1*f8*z[4]*z[8]*z[9]*z[13] -
8*f2*f8*z[4]*z[8]*z[9]*z[14] + 8*f3*f8*z[4]*z[8]*z[9]*z[15] +
4*f1*z[4]*z[8]*z[10]^2 - 2*f3*z[4]*z[8]*z[10]*z[12] - 2*z[4]*z[8]*z[11]*z[16] +
4*f8*z[4]*z[8]*z[14]*z[15] + (16*f0*f1*f8^2 + 16*f0*f3*f6*f8 -
4*f0*f3*f7^2)*z[5]^2*z[9]^2 - 16*f0*f3*f8*z[5]^2*z[9]*z[10] +
8*f0*f5*f8*z[5]^2*z[9]*z[12] + (-16*f0*f6*f8 + 4*f0*f7^2)*z[5]^2*z[9]*z[14] +
(-8*f1*f6*f8 + 2*f1*f7^2)*z[5]^2*z[9]*z[15] + 4*f1*f8*z[5]^2*z[9]*z[16] +
8*f0*f8*z[5]^2*z[10]*z[14] + 4*f1*f8*z[5]^2*z[10]*z[15] -
8*f0*f8*z[5]^2*z[11]*z[12] - 4*f1*f8*z[5]^2*z[12]^2 + (-32*f0*f4*f6*f8 +
8*f0*f4*f7^2 - 16*f1^2*f8^2 - 8*f1*f3*f6*f8 + 2*f1*f3*f7^2)*z[5]*z[6]*z[9]^2 +
(32*f0*f4*f8 + 8*f1*f3*f8)*z[5]*z[6]*z[9]*z[10] - 8*f0*f5*f8*z[5]*z[6]*z[9]*z[11]
+ (-4*f0*f7^2 - 8*f1*f5*f8)*z[5]*z[6]*z[9]*z[12] + (16*f0*f6*f8 -
4*f0*f7^2)*z[5]*z[6]*z[9]*z[13] + (8*f0*f7*f8 + 16*f1*f6*f8 -
4*f1*f7^2)*z[5]*z[6]*z[9]*z[14] + (16*f2*f6*f8 - 4*f2*f7^2)*z[5]*z[6]*z[9]*z[15] -
8*f2*f8*z[5]*z[6]*z[9]*z[16] - 8*f0*f8*z[5]*z[6]*z[10]*z[12] -
8*f0*f8*z[5]*z[6]*z[10]*z[13] - 8*f1*f8*z[5]*z[6]*z[10]*z[14] -
8*f2*f8*z[5]*z[6]*z[10]*z[15] + 16*f1*f8*z[5]*z[6]*z[11]*z[12] + (-8*f6*f8 +
2*f7^2)*z[5]*z[6]*z[15]^2 + 8*f8*z[5]*z[6]*z[15]*z[16] + (16*f0*f5*f6*f8 -
4*f0*f5*f7^2)*z[5]*z[7]*z[9]^2 - 16*f0*f5*f8*z[5]*z[7]*z[9]*z[10] -
4*f1*f5*f8*z[5]*z[7]*z[9]*z[11] + (8*f0*f7*f8 + 4*f1*f7^2 +
8*f2*f5*f8)*z[5]*z[7]*z[9]*z[12] + (8*f1*f6*f8 - 2*f1*f7^2)*z[5]*z[7]*z[9]*z[13] +
(-16*f0*f8^2 - 8*f1*f7*f8 - 16*f2*f6*f8 + 4*f2*f7^2)*z[5]*z[7]*z[9]*z[14] +
16*f1*f8^2*z[5]*z[7]*z[9]*z[15] + 8*f0*f8*z[5]*z[7]*z[10]*z[11] -
8*f1*f8*z[5]*z[7]*z[10]*z[12] - 4*f1*f8*z[5]*z[7]*z[10]*z[13] +
8*f2*f8*z[5]*z[7]*z[10]*z[14] + 4*f1*f8*z[5]*z[7]*z[11]^2 -
8*f2*f8*z[5]*z[7]*z[11]*z[12] + 4*f3*f8*z[5]*z[7]*z[12]^2 -
4*f5*f8*z[5]*z[7]*z[12]*z[15] + (8*f6*f8 - 2*f7^2)*z[5]*z[7]*z[14]*z[15] -
4*f8*z[5]*z[7]*z[14]*z[16] - 8*f0*f5*f8*z[5]*z[8]*z[9]^2 +
4*f0*f7*z[5]*z[8]*z[9]*z[10] + 2*f1*f7*z[5]*z[8]*z[9]*z[11] -
4*f2*f7*z[5]*z[8]*z[9]*z[12] - 4*f1*f8*z[5]*z[8]*z[9]*z[13] +
8*f2*f8*z[5]*z[8]*z[9]*z[14] + 2*f7*z[5]*z[8]*z[12]*z[15] -
4*f8*z[5]*z[8]*z[14]*z[15] + (16*f0*f5*f6*f8 - 4*f0*f5*f7^2 + 16*f1*f2*f8^2 +
16*f1*f4*f6*f8 - 4*f1*f4*f7^2)*z[6]^2*z[9]^2 + (-16*f0*f5*f8 -
16*f1*f4*f8)*z[6]^2*z[9]*z[10] + (4*f0*f7^2 + 8*f1*f5*f8)*z[6]^2*z[9]*z[11] +
8*f0*f7*f8*z[6]^2*z[9]*z[12] + (-8*f0*f7*f8 - 16*f1*f6*f8 +
4*f1*f7^2)*z[6]^2*z[9]*z[13] + (-16*f1*f8^2 - 8*f3*f6*f8 +
2*f3*f7^2)*z[6]^2*z[9]*z[15] + 4*f3*f8*z[6]^2*z[9]*z[16] +
8*f1*f8*z[6]^2*z[10]*z[12] + 8*f1*f8*z[6]^2*z[10]*z[13] +
4*f3*f8*z[6]^2*z[10]*z[15] - 8*f1*f8*z[6]^2*z[11]^2 - 4*f3*f8*z[6]^2*z[12]^2 +
(8*f0*f5*f7*f8 - 32*f0*f6^2*f8 + 8*f0*f6*f7^2 - 16*f1*f3*f8^2 - 16*f1*f5*f6*f8 +
4*f1*f5*f7^2)*z[6]*z[7]*z[9]^2 + (32*f0*f6*f8 - 4*f0*f7^2 +
16*f1*f5*f8)*z[6]*z[7]*z[9]*z[10] + (-16*f0*f7*f8 -
4*f1*f7^2)*z[6]*z[7]*z[9]*z[11] + (-16*f0*f8^2 - 8*f1*f7*f8 -
4*f3*f5*f8)*z[6]*z[7]*z[9]*z[12] + (16*f0*f8^2 + 8*f1*f7*f8)*z[6]*z[7]*z[9]*z[13]
+ (16*f1*f8^2 + 8*f3*f6*f8 - 2*f3*f7^2)*z[6]*z[7]*z[9]*z[14] +
4*f1*f8*z[6]*z[7]*z[10]*z[11] - 8*f2*f8*z[6]*z[7]*z[10]*z[12] -
4*f3*f8*z[6]*z[7]*z[10]*z[14] + 8*f3*f8*z[6]*z[7]*z[11]*z[12] -
4*f5*f8*z[6]*z[7]*z[11]*z[15] + 4*f8*z[6]*z[7]*z[12]*z[16] + (8*f6*f8 -
2*f7^2)*z[6]*z[7]*z[13]*z[15] - 4*f8*z[6]*z[7]*z[13]*z[16] + (16*f0*f6*f8 -
4*f0*f7^2 + 8*f1*f5*f8)*z[6]*z[8]*z[9]^2 + (-16*f0*f8 -
4*f1*f7)*z[6]*z[8]*z[9]*z[10] - 4*f1*f8*z[6]*z[8]*z[9]*z[11] + (8*f2*f8 +
2*f3*f7)*z[6]*z[8]*z[9]*z[12] - 4*f3*f8*z[6]*z[8]*z[9]*z[14] +
2*f7*z[6]*z[8]*z[11]*z[15] - 4*f8*z[6]*z[8]*z[12]*z[15] -
4*f8*z[6]*z[8]*z[13]*z[15] + (-16*f0*f5*f8^2 + 16*f0*f6*f7*f8 - 4*f0*f7^3 +
16*f1*f4*f8^2 - 8*f1*f5*f7*f8 + 16*f1*f6^2*f8 - 4*f1*f6*f7^2)*z[7]^2*z[9]^2 +
(-8*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2)*z[7]^2*z[9]*z[10] + (16*f0*f8^2 +
8*f1*f7*f8)*z[7]^2*z[9]*z[11] - 16*f1*f8^2*z[7]^2*z[9]*z[13] -
4*f1*f8*z[7]^2*z[10]^2 + 4*f3*f8*z[7]^2*z[10]*z[12] - 8*f4*f8*z[7]^2*z[11]*z[12] +
4*f5*f8*z[7]^2*z[11]*z[14] + 4*f8*z[7]^2*z[11]*z[16] + 4*f5*f8*z[7]^2*z[12]*z[13]
+ (-8*f6*f8 + 2*f7^2)*z[7]^2*z[13]*z[14] + (-16*f1*f6*f8 +
4*f1*f7^2)*z[7]*z[8]*z[9]^2 + 16*f1*f8*z[7]*z[8]*z[9]*z[10] -
4*f3*f8*z[7]*z[8]*z[9]*z[12] - 2*f7*z[7]*z[8]*z[11]*z[14] -
4*f8*z[7]*z[8]*z[11]*z[15] - 2*f7*z[7]*z[8]*z[12]*z[13] +
8*f8*z[7]*z[8]*z[13]*z[14] + 2*z[8]^2*z[11]*z[12],

// Bmat[4,4]
  (32*f0^2*f4*f8 - 16*f0*f1*f3*f8 + 32*f0*f2^2*f8 - 8*f1^2*f2*f8)*z[1]^2*z[10]^2 +
(-32*f0^2*f5*f8 - 32*f0*f2*f3*f8 + 8*f1^2*f3*f8)*z[1]^2*z[10]*z[11] +
(16*f0*f1*f5*f8 + 16*f0*f3^2*f8)*z[1]^2*z[10]*z[12] + (-32*f0*f2*f8 +
8*f1^2*f8)*z[1]^2*z[10]*z[16] + (32*f0^2*f6*f8 + 32*f0*f2*f4*f8 -
8*f1^2*f4*f8)*z[1]^2*z[11]^2 + (-32*f0*f1*f6*f8 -
32*f0*f3*f4*f8)*z[1]^2*z[11]*z[12] + (-32*f0^2*f7*f8 - 32*f0*f2*f5*f8 +
8*f1^2*f5*f8)*z[1]^2*z[11]*z[13] + (16*f0*f1*f7*f8 +
16*f0*f3*f5*f8)*z[1]^2*z[11]*z[14] + 16*f0*f3*f8*z[1]^2*z[11]*z[16] +
(32*f0*f2*f6*f8 - 16*f0*f3*f5*f8 + 32*f0*f4^2*f8)*z[1]^2*z[12]^2 + (16*f0*f1*f7*f8
+ 16*f0*f3*f5*f8)*z[1]^2*z[12]*z[13] + (-32*f0*f2*f7*f8 -
32*f0*f4*f5*f8)*z[1]^2*z[12]*z[14] + (16*f0*f3*f7*f8 +
16*f0*f5^2*f8)*z[1]^2*z[12]*z[15] - 32*f0*f4*f8*z[1]^2*z[12]*z[16] + (32*f0^2*f8^2
+ 32*f0*f2*f6*f8 - 8*f0*f2*f7^2 - 8*f1^2*f6*f8 + 2*f1^2*f7^2)*z[1]^2*z[13]^2 +
(-32*f0*f1*f8^2 - 32*f0*f3*f6*f8 + 8*f0*f3*f7^2)*z[1]^2*z[13]*z[14] +
(32*f0*f2*f8^2 + 32*f0*f4*f6*f8 - 8*f0*f4*f7^2)*z[1]^2*z[14]^2 + (-32*f0*f3*f8^2 -
32*f0*f5*f6*f8 + 8*f0*f5*f7^2)*z[1]^2*z[14]*z[15] + 16*f0*f5*f8*z[1]^2*z[14]*z[16]
+ (32*f0*f4*f8^2 - 16*f0*f5*f7*f8 + 32*f0*f6^2*f8 - 8*f0*f6*f7^2)*z[1]^2*z[15]^2 +
(-32*f0*f6*f8 + 8*f0*f7^2)*z[1]^2*z[15]*z[16] + (-64*f0^2*f4*f8 + 32*f0*f1*f3*f8 -
64*f0*f2^2*f8 + 16*f1^2*f2*f8)*z[1]*z[2]*z[9]*z[10] + (32*f0^2*f5*f8 +
32*f0*f2*f3*f8 - 8*f1^2*f3*f8)*z[1]*z[2]*z[9]*z[11] + (-16*f0*f1*f5*f8 -
16*f0*f3^2*f8)*z[1]*z[2]*z[9]*z[12] + (32*f0*f2*f8 -
8*f1^2*f8)*z[1]*z[2]*z[9]*z[16] + 32*f0^2*f8*z[1]*z[2]*z[10]*z[13] -
16*f0*f1*f8*z[1]*z[2]*z[10]*z[14] + (32*f0*f2*f8 -
8*f1^2*f8)*z[1]*z[2]*z[10]*z[15] - 32*f0^2*f8*z[1]*z[2]*z[11]^2 +
32*f0*f1*f8*z[1]*z[2]*z[11]*z[12] + (16*f0*f2*f7 -
4*f1^2*f7)*z[1]*z[2]*z[11]*z[13] - 8*f0*f3*f7*z[1]*z[2]*z[11]*z[14] -
16*f0*f3*f8*z[1]*z[2]*z[11]*z[15] - 32*f0*f2*f8*z[1]*z[2]*z[12]^2 -
8*f0*f3*f7*z[1]*z[2]*z[12]*z[13] + (16*f0*f3*f8 +
16*f0*f4*f7)*z[1]*z[2]*z[12]*z[14] - 8*f0*f5*f7*z[1]*z[2]*z[12]*z[15] +
(-32*f0*f2*f8 + 8*f1^2*f8)*z[1]*z[2]*z[13]^2 + 32*f0*f3*f8*z[1]*z[2]*z[13]*z[14] -
32*f0*f4*f8*z[1]*z[2]*z[14]^2 + 32*f0*f5*f8*z[1]*z[2]*z[14]*z[15] -
8*f0*f7*z[1]*z[2]*z[14]*z[16] + (-32*f0*f6*f8 + 8*f0*f7^2)*z[1]*z[2]*z[15]^2 +
32*f0*f8*z[1]*z[2]*z[15]*z[16] + (32*f0^2*f5*f8 + 32*f0*f2*f3*f8 -
8*f1^2*f3*f8)*z[1]*z[3]*z[9]*z[10] + (-64*f0^2*f6*f8 - 64*f0*f2*f4*f8 +
16*f1^2*f4*f8)*z[1]*z[3]*z[9]*z[11] + (32*f0*f1*f6*f8 +
32*f0*f3*f4*f8)*z[1]*z[3]*z[9]*z[12] + (32*f0^2*f7*f8 + 32*f0*f2*f5*f8 -
8*f1^2*f5*f8)*z[1]*z[3]*z[9]*z[13] + (-16*f0*f1*f7*f8 -
16*f0*f3*f5*f8)*z[1]*z[3]*z[9]*z[14] - 16*f0*f3*f8*z[1]*z[3]*z[9]*z[16] +
32*f0^2*f8*z[1]*z[3]*z[10]*z[11] - 16*f0*f1*f8*z[1]*z[3]*z[10]*z[12] +
(-16*f0*f1*f8 - 16*f0*f2*f7 + 4*f1^2*f7)*z[1]*z[3]*z[10]*z[13] + (8*f0*f3*f7 +
8*f1^2*f8)*z[1]*z[3]*z[10]*z[14] - 16*f0*f3*f8*z[1]*z[3]*z[10]*z[15] +
(32*f0*f2*f8 - 8*f1^2*f8)*z[1]*z[3]*z[11]*z[13] -
16*f0*f3*f8*z[1]*z[3]*z[11]*z[14] + 32*f0*f4*f8*z[1]*z[3]*z[11]*z[15] +
16*f0*f3*f8*z[1]*z[3]*z[12]^2 - 16*f0*f3*f8*z[1]*z[3]*z[12]*z[13] -
8*f0*f5*f7*z[1]*z[3]*z[12]*z[14] + (-32*f0*f5*f8 +
16*f0*f6*f7)*z[1]*z[3]*z[12]*z[15] - 8*f0*f7*z[1]*z[3]*z[12]*z[16] -
16*f0*f5*f8*z[1]*z[3]*z[13]*z[15] + 8*f0*f7*z[1]*z[3]*z[13]*z[16] +
16*f0*f5*f8*z[1]*z[3]*z[14]^2 - 8*f0*f7^2*z[1]*z[3]*z[14]*z[15] -
16*f0*f8*z[1]*z[3]*z[14]*z[16] + 16*f0*f7*f8*z[1]*z[3]*z[15]^2 + (-16*f0*f1*f5*f8
- 16*f0*f3^2*f8)*z[1]*z[4]*z[9]*z[10] + (32*f0*f1*f6*f8 +
32*f0*f3*f4*f8)*z[1]*z[4]*z[9]*z[11] + (-64*f0*f2*f6*f8 + 32*f0*f3*f5*f8 -
64*f0*f4^2*f8)*z[1]*z[4]*z[9]*z[12] + (-16*f0*f1*f7*f8 -
16*f0*f3*f5*f8)*z[1]*z[4]*z[9]*z[13] + (32*f0*f2*f7*f8 +
32*f0*f4*f5*f8)*z[1]*z[4]*z[9]*z[14] + (-16*f0*f3*f7*f8 -
16*f0*f5^2*f8)*z[1]*z[4]*z[9]*z[15] + 32*f0*f4*f8*z[1]*z[4]*z[9]*z[16] -
16*f0*f1*f8*z[1]*z[4]*z[10]*z[11] + 32*f0*f2*f8*z[1]*z[4]*z[10]*z[12] +
(8*f0*f3*f7 + 8*f1^2*f8)*z[1]*z[4]*z[10]*z[13] + (16*f0*f3*f8 - 16*f0*f4*f7 -
16*f1*f2*f8)*z[1]*z[4]*z[10]*z[14] + (8*f0*f5*f7 +
8*f1*f3*f8)*z[1]*z[4]*z[10]*z[15] - 16*f0*f3*f8*z[1]*z[4]*z[11]*z[12] -
16*f0*f3*f8*z[1]*z[4]*z[11]*z[13] + (8*f0*f5*f7 +
8*f1*f3*f8)*z[1]*z[4]*z[11]*z[14] + (16*f0*f5*f8 - 16*f0*f6*f7 -
16*f1*f4*f8)*z[1]*z[4]*z[11]*z[15] + 8*f0*f7*z[1]*z[4]*z[11]*z[16] +
32*f0*f4*f8*z[1]*z[4]*z[12]*z[13] - 16*f0*f5*f8*z[1]*z[4]*z[12]*z[14] +
32*f0*f6*f8*z[1]*z[4]*z[12]*z[15] - 16*f0*f8*z[1]*z[4]*z[12]*z[16] -
16*f0*f5*f8*z[1]*z[4]*z[13]*z[14] + (8*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[4]*z[13]*z[15]
- 4*f1*f7*z[1]*z[4]*z[13]*z[16] - 16*f0*f7*f8*z[1]*z[4]*z[14]*z[15] +
8*f1*f8*z[1]*z[4]*z[14]*z[16] + (32*f0^2*f7*f8 + 32*f0*f2*f5*f8 -
8*f1^2*f5*f8)*z[1]*z[5]*z[9]*z[11] + (-16*f0*f1*f7*f8 -
16*f0*f3*f5*f8)*z[1]*z[5]*z[9]*z[12] + (-64*f0^2*f8^2 - 64*f0*f2*f6*f8 +
16*f0*f2*f7^2 + 16*f1^2*f6*f8 - 4*f1^2*f7^2)*z[1]*z[5]*z[9]*z[13] + (32*f0*f1*f8^2
+ 32*f0*f3*f6*f8 - 8*f0*f3*f7^2)*z[1]*z[5]*z[9]*z[14] -
32*f0^2*f8*z[1]*z[5]*z[10]^2 + 16*f0*f1*f8*z[1]*z[5]*z[10]*z[11] -
8*f1^2*f8*z[1]*z[5]*z[10]*z[12] + (32*f0*f2*f8 - 8*f1^2*f8)*z[1]*z[5]*z[10]*z[13]
- 16*f0*f3*f8*z[1]*z[5]*z[10]*z[14] + (-32*f0*f2*f8 + 8*f1^2*f8)*z[1]*z[5]*z[11]^2
+ 32*f0*f3*f8*z[1]*z[5]*z[11]*z[12] - 16*f0*f5*f8*z[1]*z[5]*z[11]*z[15] -
32*f0*f4*f8*z[1]*z[5]*z[12]^2 + 32*f0*f5*f8*z[1]*z[5]*z[12]*z[14] -
8*f0*f7^2*z[1]*z[5]*z[12]*z[15] + 48*f0*f8*z[1]*z[5]*z[12]*z[16] + (32*f0*f6*f8 -
8*f0*f7^2)*z[1]*z[5]*z[13]*z[15] - 16*f0*f8*z[1]*z[5]*z[13]*z[16] + (-32*f0*f6*f8
+ 8*f0*f7^2)*z[1]*z[5]*z[14]^2 + 16*f0*f7*f8*z[1]*z[5]*z[14]*z[15] -
32*f0*f8^2*z[1]*z[5]*z[15]^2 + (-16*f0*f1*f7*f8 -
16*f0*f3*f5*f8)*z[1]*z[6]*z[9]*z[11] + (32*f0*f2*f7*f8 +
32*f0*f4*f5*f8)*z[1]*z[6]*z[9]*z[12] + (32*f0*f1*f8^2 + 32*f0*f3*f6*f8 -
8*f0*f3*f7^2)*z[1]*z[6]*z[9]*z[13] + (-64*f0*f2*f8^2 - 64*f0*f4*f6*f8 +
16*f0*f4*f7^2)*z[1]*z[6]*z[9]*z[14] + (32*f0*f3*f8^2 + 32*f0*f5*f6*f8 -
8*f0*f5*f7^2)*z[1]*z[6]*z[9]*z[15] - 16*f0*f5*f8*z[1]*z[6]*z[9]*z[16] +
16*f0*f1*f8*z[1]*z[6]*z[10]^2 - 8*f1^2*f8*z[1]*z[6]*z[10]*z[11] + (-32*f0*f3*f8 +
16*f1*f2*f8)*z[1]*z[6]*z[10]*z[12] - 16*f0*f3*f8*z[1]*z[6]*z[10]*z[13] +
32*f0*f4*f8*z[1]*z[6]*z[10]*z[14] - 16*f0*f5*f8*z[1]*z[6]*z[10]*z[15] +
16*f0*f3*f8*z[1]*z[6]*z[11]^2 - 8*f1*f3*f8*z[1]*z[6]*z[11]*z[12] -
16*f0*f5*f8*z[1]*z[6]*z[11]*z[14] + (8*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[6]*z[11]*z[15]
- 16*f0*f8*z[1]*z[6]*z[11]*z[16] + 16*f0*f5*f8*z[1]*z[6]*z[12]^2 -
16*f0*f5*f8*z[1]*z[6]*z[12]*z[13] - 16*f0*f7*f8*z[1]*z[6]*z[12]*z[15] -
8*f1*f8*z[1]*z[6]*z[12]*z[16] + (32*f0*f6*f8 - 8*f0*f7^2)*z[1]*z[6]*z[13]*z[14] +
(-16*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2)*z[1]*z[6]*z[13]*z[15] +
8*f1*f8*z[1]*z[6]*z[13]*z[16] + 32*f0*f8^2*z[1]*z[6]*z[14]*z[15] +
(-16*f0*f3*f7*f8 - 16*f0*f5^2*f8)*z[1]*z[7]*z[9]*z[12] + (32*f0*f3*f8^2 +
32*f0*f5*f6*f8 - 8*f0*f5*f7^2)*z[1]*z[7]*z[9]*z[14] + (-64*f0*f4*f8^2 +
32*f0*f5*f7*f8 - 64*f0*f6^2*f8 + 16*f0*f6*f7^2)*z[1]*z[7]*z[9]*z[15] +
(32*f0*f6*f8 - 8*f0*f7^2)*z[1]*z[7]*z[9]*z[16] + (-32*f0*f2*f8 +
8*f1^2*f8)*z[1]*z[7]*z[10]^2 + 32*f0*f3*f8*z[1]*z[7]*z[10]*z[11] -
8*f1*f3*f8*z[1]*z[7]*z[10]*z[12] - 16*f0*f5*f8*z[1]*z[7]*z[10]*z[14] +
(32*f0*f6*f8 - 8*f0*f7^2)*z[1]*z[7]*z[10]*z[15] + 32*f0*f8*z[1]*z[7]*z[10]*z[16] -
32*f0*f4*f8*z[1]*z[7]*z[11]^2 + (16*f0*f5*f8 + 16*f1*f4*f8)*z[1]*z[7]*z[11]*z[12]
+ 32*f0*f5*f8*z[1]*z[7]*z[11]*z[13] - 8*f1*f5*f8*z[1]*z[7]*z[11]*z[14] -
16*f0*f7*f8*z[1]*z[7]*z[11]*z[15] - 8*f1*f8*z[1]*z[7]*z[11]*z[16] -
32*f0*f6*f8*z[1]*z[7]*z[12]^2 - 8*f1*f5*f8*z[1]*z[7]*z[12]*z[13] +
32*f0*f7*f8*z[1]*z[7]*z[12]*z[14] + (-32*f0*f6*f8 + 8*f0*f7^2)*z[1]*z[7]*z[13]^2 +
(16*f1*f6*f8 - 4*f1*f7^2)*z[1]*z[7]*z[13]*z[14] + 32*f0*f8^2*z[1]*z[7]*z[13]*z[15]
- 32*f0*f8^2*z[1]*z[7]*z[14]^2 + (32*f0*f2*f8 - 8*f1^2*f8)*z[1]*z[8]*z[9]*z[10] -
16*f0*f3*f8*z[1]*z[8]*z[9]*z[11] + 32*f0*f4*f8*z[1]*z[8]*z[9]*z[12] -
16*f0*f5*f8*z[1]*z[8]*z[9]*z[14] + (32*f0*f6*f8 - 8*f0*f7^2)*z[1]*z[8]*z[9]*z[15]
+ (-36*f0*f8 + f1*f7)*z[1]*z[8]*z[9]*z[16] + 8*f0*f7*z[1]*z[8]*z[10]*z[14] +
(-28*f0*f8 - f1*f7)*z[1]*z[8]*z[10]*z[15] - 8*f0*f7*z[1]*z[8]*z[11]*z[13] +
(-4*f0*f8 + f1*f7)*z[1]*z[8]*z[11]*z[14] + 8*f1*f8*z[1]*z[8]*z[11]*z[15] +
16*f0*f8*z[1]*z[8]*z[12]^2 + (-12*f0*f8 + 3*f1*f7)*z[1]*z[8]*z[12]*z[13] +
16*f0*f8*z[1]*z[8]*z[13]^2 - 8*f1*f8*z[1]*z[8]*z[13]*z[14] + (32*f0^2*f4*f8 -
16*f0*f1*f3*f8 + 32*f0*f2^2*f8 - 8*f1^2*f2*f8)*z[2]^2*z[9]^2 -
32*f0^2*f8*z[2]^2*z[9]*z[13] + 16*f0*f1*f8*z[2]^2*z[9]*z[14] + (-32*f0*f2*f8 +
8*f1^2*f8)*z[2]^2*z[9]*z[15] + (-8*f0*f2 + 2*f1^2)*z[2]^2*z[11]^2 +
8*f0*f3*z[2]^2*z[11]*z[12] - 8*f0*f4*z[2]^2*z[12]^2 + 8*f0*z[2]^2*z[12]*z[16] -
8*f0*f8*z[2]^2*z[15]^2 + (-32*f0^2*f5*f8 - 32*f0*f2*f3*f8 +
8*f1^2*f3*f8)*z[2]*z[3]*z[9]^2 + 32*f0^2*f8*z[2]*z[3]*z[9]*z[11] -
16*f0*f1*f8*z[2]*z[3]*z[9]*z[12] + 16*f0*f1*f8*z[2]*z[3]*z[9]*z[13] -
8*f1^2*f8*z[2]*z[3]*z[9]*z[14] + 32*f0*f3*f8*z[2]*z[3]*z[9]*z[15] + (16*f0*f2 -
4*f1^2)*z[2]*z[3]*z[10]*z[11] - 8*f0*f3*z[2]*z[3]*z[10]*z[12] -
8*f0*z[2]*z[3]*z[11]*z[16] + 8*f0*f5*z[2]*z[3]*z[12]^2 -
8*f0*f7*z[2]*z[3]*z[12]*z[15] + 16*f0*f8*z[2]*z[3]*z[14]*z[15] + (16*f0*f1*f5*f8 +
16*f0*f3^2*f8)*z[2]*z[4]*z[9]^2 - 16*f0*f1*f8*z[2]*z[4]*z[9]*z[11] +
32*f0*f2*f8*z[2]*z[4]*z[9]*z[12] - 8*f1^2*f8*z[2]*z[4]*z[9]*z[13] + (-32*f0*f3*f8
+ 16*f1*f2*f8)*z[2]*z[4]*z[9]*z[14] - 8*f1*f3*f8*z[2]*z[4]*z[9]*z[15] -
8*f0*f3*z[2]*z[4]*z[10]*z[11] + 16*f0*f4*z[2]*z[4]*z[10]*z[12] -
8*f0*z[2]*z[4]*z[10]*z[16] - 8*f0*f5*z[2]*z[4]*z[11]*z[12] +
8*f0*f7*z[2]*z[4]*z[11]*z[15] + 4*f1*z[2]*z[4]*z[11]*z[16] -
16*f0*f8*z[2]*z[4]*z[12]*z[15] - 16*f0*f8*z[2]*z[4]*z[13]*z[15] +
16*f0*f8*z[2]*z[4]*z[14]^2 - 8*f1*f8*z[2]*z[4]*z[14]*z[15] +
32*f0^2*f8*z[2]*z[5]*z[9]*z[10] + (-16*f0*f1*f8 - 16*f0*f2*f7 +
4*f1^2*f7)*z[2]*z[5]*z[9]*z[11] + (8*f0*f3*f7 + 8*f1^2*f8)*z[2]*z[5]*z[9]*z[12] +
(32*f0*f2*f8 - 8*f1^2*f8)*z[2]*z[5]*z[9]*z[13] - 16*f0*f3*f8*z[2]*z[5]*z[9]*z[14]
+ 8*f0*f7*z[2]*z[5]*z[11]*z[15] - 8*f0*f7*z[2]*z[5]*z[12]*z[14] -
16*f0*f8*z[2]*z[5]*z[12]*z[15] - 16*f0*f8*z[2]*z[5]*z[13]*z[15] +
16*f0*f8*z[2]*z[5]*z[14]^2 - 16*f0*f1*f8*z[2]*z[6]*z[9]*z[10] + (8*f0*f3*f7 +
8*f1^2*f8)*z[2]*z[6]*z[9]*z[11] + (16*f0*f3*f8 - 16*f0*f4*f7 -
16*f1*f2*f8)*z[2]*z[6]*z[9]*z[12] - 16*f0*f3*f8*z[2]*z[6]*z[9]*z[13] +
32*f0*f4*f8*z[2]*z[6]*z[9]*z[14] - 16*f0*f5*f8*z[2]*z[6]*z[9]*z[15] +
8*f0*f7*z[2]*z[6]*z[9]*z[16] + (16*f0*f8 - 4*f1*f7)*z[2]*z[6]*z[11]*z[15] +
8*f0*f7*z[2]*z[6]*z[12]*z[13] - 16*f0*f8*z[2]*z[6]*z[12]*z[14] +
8*f1*f8*z[2]*z[6]*z[12]*z[15] - 16*f0*f8*z[2]*z[6]*z[13]*z[14] +
8*f1*f8*z[2]*z[6]*z[13]*z[15] + (32*f0*f2*f8 - 8*f1^2*f8)*z[2]*z[7]*z[9]*z[10] -
16*f0*f3*f8*z[2]*z[7]*z[9]*z[11] + (8*f0*f5*f7 + 8*f1*f3*f8)*z[2]*z[7]*z[9]*z[12]
- 16*f0*f5*f8*z[2]*z[7]*z[9]*z[14] + (32*f0*f6*f8 -
8*f0*f7^2)*z[2]*z[7]*z[9]*z[15] + (-28*f0*f8 - f1*f7)*z[2]*z[7]*z[9]*z[16] +
(-20*f0*f8 + f1*f7)*z[2]*z[7]*z[10]*z[15] - 8*f0*f7*z[2]*z[7]*z[11]*z[13] +
(4*f0*f8 + 3*f1*f7)*z[2]*z[7]*z[11]*z[14] + 16*f0*f8*z[2]*z[7]*z[12]^2 + (-4*f0*f8
+ f1*f7)*z[2]*z[7]*z[12]*z[13] + 16*f0*f8*z[2]*z[7]*z[13]^2 -
8*f1*f8*z[2]*z[7]*z[13]*z[14] + (-32*f0*f2*f8 + 8*f1^2*f8)*z[2]*z[8]*z[9]^2 +
32*f0*f8*z[2]*z[8]*z[9]*z[15] - 8*f0*z[2]*z[8]*z[10]*z[12] +
8*f0*z[2]*z[8]*z[11]^2 - 4*f1*z[2]*z[8]*z[11]*z[12] + (32*f0^2*f6*f8 +
32*f0*f2*f4*f8 - 8*f1^2*f4*f8)*z[3]^2*z[9]^2 - 32*f0^2*f8*z[3]^2*z[9]*z[10] +
(-32*f0*f2*f8 + 8*f1^2*f8)*z[3]^2*z[9]*z[13] + 16*f0*f3*f8*z[3]^2*z[9]*z[14] -
32*f0*f4*f8*z[3]^2*z[9]*z[15] + (-8*f0*f2 + 2*f1^2)*z[3]^2*z[10]^2 +
8*f0*z[3]^2*z[10]*z[16] - 8*f0*f6*z[3]^2*z[12]^2 + 8*f0*f7*z[3]^2*z[12]*z[14] +
16*f0*f8*z[3]^2*z[12]*z[15] + 16*f0*f8*z[3]^2*z[13]*z[15] -
24*f0*f8*z[3]^2*z[14]^2 + (-32*f0*f1*f6*f8 - 32*f0*f3*f4*f8)*z[3]*z[4]*z[9]^2 +
32*f0*f1*f8*z[3]*z[4]*z[9]*z[10] - 16*f0*f3*f8*z[3]*z[4]*z[9]*z[12] +
32*f0*f3*f8*z[3]*z[4]*z[9]*z[13] - 8*f1*f3*f8*z[3]*z[4]*z[9]*z[14] + (16*f0*f5*f8
+ 16*f1*f4*f8)*z[3]*z[4]*z[9]*z[15] + 8*f0*f3*z[3]*z[4]*z[10]^2 -
8*f0*f5*z[3]*z[4]*z[10]*z[12] - 4*f1*z[3]*z[4]*z[10]*z[16] +
16*f0*f6*z[3]*z[4]*z[11]*z[12] - 8*f0*f7*z[3]*z[4]*z[11]*z[14] -
16*f0*f8*z[3]*z[4]*z[11]*z[15] - 8*f0*f7*z[3]*z[4]*z[12]*z[13] +
16*f0*f8*z[3]*z[4]*z[13]*z[14] - 8*f1*f8*z[3]*z[4]*z[13]*z[15] +
8*f1*f8*z[3]*z[4]*z[14]^2 + (-32*f0^2*f7*f8 - 32*f0*f2*f5*f8 +
8*f1^2*f5*f8)*z[3]*z[5]*z[9]^2 + (16*f0*f2*f7 - 4*f1^2*f7)*z[3]*z[5]*z[9]*z[10] +
(32*f0*f2*f8 - 8*f1^2*f8)*z[3]*z[5]*z[9]*z[11] - 16*f0*f3*f8*z[3]*z[5]*z[9]*z[12]
+ 32*f0*f5*f8*z[3]*z[5]*z[9]*z[15] - 8*f0*f7*z[3]*z[5]*z[9]*z[16] -
8*f0*f7*z[3]*z[5]*z[10]*z[15] - 16*f0*f8*z[3]*z[5]*z[11]*z[15] +
8*f0*f7*z[3]*z[5]*z[12]^2 + 16*f0*f8*z[3]*z[5]*z[12]*z[14] + (16*f0*f1*f7*f8 +
16*f0*f3*f5*f8)*z[3]*z[6]*z[9]^2 - 8*f0*f3*f7*z[3]*z[6]*z[9]*z[10] -
16*f0*f3*f8*z[3]*z[6]*z[9]*z[11] + (8*f0*f5*f7 + 8*f1*f3*f8)*z[3]*z[6]*z[9]*z[12]
- 16*f0*f5*f8*z[3]*z[6]*z[9]*z[14] - 8*f1*f5*f8*z[3]*z[6]*z[9]*z[15] + (-4*f0*f8 +
f1*f7)*z[3]*z[6]*z[9]*z[16] + (4*f0*f8 + 3*f1*f7)*z[3]*z[6]*z[10]*z[15] -
8*f0*f7*z[3]*z[6]*z[11]*z[12] + (12*f0*f8 + f1*f7)*z[3]*z[6]*z[11]*z[14] +
(4*f0*f8 - f1*f7)*z[3]*z[6]*z[12]*z[13] - 8*f1*f8*z[3]*z[6]*z[12]*z[14] -
16*f0*f3*f8*z[3]*z[7]*z[9]*z[10] + 32*f0*f4*f8*z[3]*z[7]*z[9]*z[11] + (16*f0*f5*f8
- 16*f0*f6*f7 - 16*f1*f4*f8)*z[3]*z[7]*z[9]*z[12] -
16*f0*f5*f8*z[3]*z[7]*z[9]*z[13] + (8*f0*f7^2 + 8*f1*f5*f8)*z[3]*z[7]*z[9]*z[14] -
16*f0*f7*f8*z[3]*z[7]*z[9]*z[15] + 8*f1*f8*z[3]*z[7]*z[9]*z[16] +
8*f0*f7*z[3]*z[7]*z[10]*z[12] + 8*f0*f7*z[3]*z[7]*z[10]*z[13] + (16*f0*f8 -
4*f1*f7)*z[3]*z[7]*z[10]*z[14] - 16*f0*f8*z[3]*z[7]*z[11]*z[12] -
16*f0*f8*z[3]*z[7]*z[11]*z[13] + 8*f1*f8*z[3]*z[7]*z[12]*z[13] +
16*f0*f3*f8*z[3]*z[8]*z[9]^2 + 8*f0*f7*z[3]*z[8]*z[9]*z[12] -
16*f0*f8*z[3]*z[8]*z[9]*z[14] - 8*f1*f8*z[3]*z[8]*z[9]*z[15] -
8*f0*z[3]*z[8]*z[10]*z[11] + 4*f1*z[3]*z[8]*z[10]*z[12] + (32*f0*f2*f6*f8 -
16*f0*f3*f5*f8 + 32*f0*f4^2*f8)*z[4]^2*z[9]^2 - 32*f0*f2*f8*z[4]^2*z[9]*z[10] +
16*f0*f3*f8*z[4]^2*z[9]*z[11] - 32*f0*f4*f8*z[4]^2*z[9]*z[13] +
16*f0*f5*f8*z[4]^2*z[9]*z[14] - 32*f0*f6*f8*z[4]^2*z[9]*z[15] +
16*f0*f8*z[4]^2*z[9]*z[16] - 8*f0*f4*z[4]^2*z[10]^2 + 8*f0*f5*z[4]^2*z[10]*z[11] +
16*f0*f8*z[4]^2*z[10]*z[15] - 8*f0*f6*z[4]^2*z[11]^2 + 8*f0*f7*z[4]^2*z[11]*z[13]
- 16*f0*f8*z[4]^2*z[13]^2 + 8*f1*f8*z[4]^2*z[13]*z[14] - 8*f2*f8*z[4]^2*z[14]^2 +
8*f3*f8*z[4]^2*z[14]*z[15] - 8*f4*f8*z[4]^2*z[15]^2 + 2*z[4]^2*z[16]^2 +
(16*f0*f1*f7*f8 + 16*f0*f3*f5*f8)*z[4]*z[5]*z[9]^2 -
8*f0*f3*f7*z[4]*z[5]*z[9]*z[10] - 16*f0*f3*f8*z[4]*z[5]*z[9]*z[11] +
32*f0*f4*f8*z[4]*z[5]*z[9]*z[12] - 16*f0*f5*f8*z[4]*z[5]*z[9]*z[14] -
8*f1*f5*f8*z[4]*z[5]*z[9]*z[15] + (-12*f0*f8 + 3*f1*f7)*z[4]*z[5]*z[9]*z[16] +
8*f0*f7*z[4]*z[5]*z[10]*z[14] + (-4*f0*f8 + f1*f7)*z[4]*z[5]*z[10]*z[15] -
8*f0*f7*z[4]*z[5]*z[11]*z[12] + (4*f0*f8 - f1*f7)*z[4]*z[5]*z[11]*z[14] +
8*f1*f8*z[4]*z[5]*z[11]*z[15] + (-4*f0*f8 + f1*f7)*z[4]*z[5]*z[12]*z[13] -
8*f1*f8*z[4]*z[5]*z[12]*z[14] + (-32*f0*f2*f7*f8 -
32*f0*f4*f5*f8)*z[4]*z[6]*z[9]^2 + (16*f0*f3*f8 +
16*f0*f4*f7)*z[4]*z[6]*z[9]*z[10] - 8*f0*f5*f7*z[4]*z[6]*z[9]*z[11] -
16*f0*f5*f8*z[4]*z[6]*z[9]*z[12] + 32*f0*f5*f8*z[4]*z[6]*z[9]*z[13] +
32*f0*f7*f8*z[4]*z[6]*z[9]*z[15] - 8*f0*f7*z[4]*z[6]*z[10]*z[13] -
16*f0*f8*z[4]*z[6]*z[10]*z[14] + 8*f0*f7*z[4]*z[6]*z[11]^2 +
16*f0*f8*z[4]*z[6]*z[11]*z[13] - 8*f1*f8*z[4]*z[6]*z[11]*z[14] -
8*f1*f8*z[4]*z[6]*z[12]*z[13] + 16*f2*f8*z[4]*z[6]*z[12]*z[14] -
8*f3*f8*z[4]*z[6]*z[12]*z[15] + 8*f5*f8*z[4]*z[6]*z[15]^2 -
4*f7*z[4]*z[6]*z[15]*z[16] + (16*f0*f3*f7*f8 + 16*f0*f5^2*f8)*z[4]*z[7]*z[9]^2 -
8*f0*f5*f7*z[4]*z[7]*z[9]*z[10] + (-32*f0*f5*f8 +
16*f0*f6*f7)*z[4]*z[7]*z[9]*z[11] + 32*f0*f6*f8*z[4]*z[7]*z[9]*z[12] -
8*f0*f7^2*z[4]*z[7]*z[9]*z[13] - 16*f0*f7*f8*z[4]*z[7]*z[9]*z[14] -
8*f0*f7*z[4]*z[7]*z[10]*z[11] - 16*f0*f8*z[4]*z[7]*z[10]*z[12] -
16*f0*f8*z[4]*z[7]*z[10]*z[13] + 8*f1*f8*z[4]*z[7]*z[10]*z[14] +
16*f0*f8*z[4]*z[7]*z[11]^2 - 8*f3*f8*z[4]*z[7]*z[12]*z[14] +
16*f4*f8*z[4]*z[7]*z[12]*z[15] - 8*f5*f8*z[4]*z[7]*z[14]*z[15] +
4*f7*z[4]*z[7]*z[14]*z[16] - 8*f8*z[4]*z[7]*z[15]*z[16] -
32*f0*f4*f8*z[4]*z[8]*z[9]^2 - 8*f0*f7*z[4]*z[8]*z[9]*z[11] -
16*f0*f8*z[4]*z[8]*z[9]*z[12] + 48*f0*f8*z[4]*z[8]*z[9]*z[13] -
8*f1*f8*z[4]*z[8]*z[9]*z[14] + 8*f0*z[4]*z[8]*z[10]^2 - 4*z[4]*z[8]*z[12]*z[16] +
8*f8*z[4]*z[8]*z[15]^2 + (32*f0^2*f8^2 + 32*f0*f2*f6*f8 - 8*f0*f2*f7^2 -
8*f1^2*f6*f8 + 2*f1^2*f7^2)*z[5]^2*z[9]^2 + (-32*f0*f2*f8 +
8*f1^2*f8)*z[5]^2*z[9]*z[10] + (-32*f0*f6*f8 + 8*f0*f7^2)*z[5]^2*z[9]*z[15] +
16*f0*f8*z[5]^2*z[9]*z[16] + 16*f0*f8*z[5]^2*z[10]*z[15] - 16*f0*f8*z[5]^2*z[12]^2
+ (-32*f0*f1*f8^2 - 32*f0*f3*f6*f8 + 8*f0*f3*f7^2)*z[5]*z[6]*z[9]^2 +
32*f0*f3*f8*z[5]*z[6]*z[9]*z[10] - 16*f0*f5*f8*z[5]*z[6]*z[9]*z[12] + (32*f0*f6*f8
- 8*f0*f7^2)*z[5]*z[6]*z[9]*z[14] + (16*f1*f6*f8 - 4*f1*f7^2)*z[5]*z[6]*z[9]*z[15]
- 8*f1*f8*z[5]*z[6]*z[9]*z[16] - 16*f0*f8*z[5]*z[6]*z[10]*z[14] -
8*f1*f8*z[5]*z[6]*z[10]*z[15] + 16*f0*f8*z[5]*z[6]*z[11]*z[12] +
8*f1*f8*z[5]*z[6]*z[12]^2 - 16*f0*f5*f8*z[5]*z[7]*z[9]*z[11] + (8*f0*f7^2 +
8*f1*f5*f8)*z[5]*z[7]*z[9]*z[12] + (32*f0*f6*f8 - 8*f0*f7^2)*z[5]*z[7]*z[9]*z[13]
+ (-16*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2)*z[5]*z[7]*z[9]*z[14] +
32*f0*f8^2*z[5]*z[7]*z[9]*z[15] - 16*f0*f8*z[5]*z[7]*z[10]*z[12] -
16*f0*f8*z[5]*z[7]*z[10]*z[13] + 8*f1*f8*z[5]*z[7]*z[10]*z[14] +
16*f0*f8*z[5]*z[7]*z[11]^2 - 8*f1*f8*z[5]*z[7]*z[11]*z[12] +
8*f0*f7*z[5]*z[8]*z[9]*z[11] - 4*f1*f7*z[5]*z[8]*z[9]*z[12] -
16*f0*f8*z[5]*z[8]*z[9]*z[13] + 8*f1*f8*z[5]*z[8]*z[9]*z[14] + (32*f0*f2*f8^2 +
32*f0*f4*f6*f8 - 8*f0*f4*f7^2)*z[6]^2*z[9]^2 - 32*f0*f4*f8*z[6]^2*z[9]*z[10] +
16*f0*f5*f8*z[6]^2*z[9]*z[11] + (-32*f0*f6*f8 + 8*f0*f7^2)*z[6]^2*z[9]*z[13] -
32*f0*f8^2*z[6]^2*z[9]*z[15] + 16*f0*f8*z[6]^2*z[10]*z[12] +
16*f0*f8*z[6]^2*z[10]*z[13] - 24*f0*f8*z[6]^2*z[11]^2 + 8*f1*f8*z[6]^2*z[11]*z[12]
- 8*f2*f8*z[6]^2*z[12]^2 + (-8*f6*f8 + 2*f7^2)*z[6]^2*z[15]^2 +
8*f8*z[6]^2*z[15]*z[16] + (-32*f0*f3*f8^2 - 32*f0*f5*f6*f8 +
8*f0*f5*f7^2)*z[6]*z[7]*z[9]^2 + 32*f0*f5*f8*z[6]*z[7]*z[9]*z[10] -
8*f0*f7^2*z[6]*z[7]*z[9]*z[11] - 16*f0*f7*f8*z[6]*z[7]*z[9]*z[12] +
16*f0*f7*f8*z[6]*z[7]*z[9]*z[13] + 32*f0*f8^2*z[6]*z[7]*z[9]*z[14] +
16*f0*f8*z[6]*z[7]*z[10]*z[11] - 8*f1*f8*z[6]*z[7]*z[10]*z[12] +
8*f3*f8*z[6]*z[7]*z[12]^2 - 8*f5*f8*z[6]*z[7]*z[12]*z[15] + (16*f6*f8 -
4*f7^2)*z[6]*z[7]*z[14]*z[15] - 8*f8*z[6]*z[7]*z[14]*z[16] +
16*f0*f5*f8*z[6]*z[8]*z[9]^2 - 8*f0*f7*z[6]*z[8]*z[9]*z[10] -
16*f0*f8*z[6]*z[8]*z[9]*z[11] + 8*f1*f8*z[6]*z[8]*z[9]*z[12] +
4*f7*z[6]*z[8]*z[12]*z[15] - 8*f8*z[6]*z[8]*z[14]*z[15] + (32*f0*f4*f8^2 -
16*f0*f5*f7*f8 + 32*f0*f6^2*f8 - 8*f0*f6*f7^2)*z[7]^2*z[9]^2 + (-32*f0*f6*f8 +
8*f0*f7^2)*z[7]^2*z[9]*z[10] + 16*f0*f7*f8*z[7]^2*z[9]*z[11] -
32*f0*f8^2*z[7]^2*z[9]*z[13] - 8*f0*f8*z[7]^2*z[10]^2 - 8*f4*f8*z[7]^2*z[12]^2 +
8*f5*f8*z[7]^2*z[12]*z[14] + 8*f8*z[7]^2*z[12]*z[16] + (-8*f6*f8 +
2*f7^2)*z[7]^2*z[14]^2 + (-32*f0*f6*f8 + 8*f0*f7^2)*z[7]*z[8]*z[9]^2 +
32*f0*f8*z[7]*z[8]*z[9]*z[10] - 4*f7*z[7]*z[8]*z[12]*z[14] -
8*f8*z[7]*z[8]*z[12]*z[15] + 8*f8*z[7]*z[8]*z[14]^2 + 2*z[8]^2*z[12]^2,

// Bmat[5,1]
  (-192*f0*f2*f4*f6*f8 + 48*f0*f2*f4*f7^2 + 48*f0*f2*f5^2*f8 + 48*f0*f3^2*f6*f8 -
12*f0*f3^2*f7^2 + 48*f1^2*f4*f6*f8 - 12*f1^2*f4*f7^2 -
12*f1^2*f5^2*f8)*z[1]^2*z[9]^2 + (96*f0*f2*f4*f8 - 24*f0*f2*f5*f7 - 24*f0*f3^2*f8
- 24*f1^2*f4*f8 + 6*f1^2*f5*f7)*z[1]^2*z[9]*z[10] + (-48*f0*f2*f5*f8 +
12*f0*f3*f5*f7 + 12*f1^2*f5*f8)*z[1]^2*z[9]*z[11] + (24*f0*f3*f5*f8 -
6*f1*f3*f5*f7)*z[1]^2*z[9]*z[12] + (96*f0*f2*f6*f8 - 24*f0*f2*f7^2 -
24*f0*f3*f5*f8 - 24*f1^2*f6*f8 + 6*f1^2*f7^2)*z[1]^2*z[9]*z[13] + (-48*f0*f3*f6*f8
+ 12*f0*f3*f7^2 + 12*f1*f3*f5*f8)*z[1]^2*z[9]*z[14] + (96*f0*f4*f6*f8 -
24*f0*f4*f7^2 - 24*f0*f5^2*f8 - 24*f1*f3*f6*f8 + 6*f1*f3*f7^2)*z[1]^2*z[9]*z[15] +
(-24*f0*f4*f8 + 6*f0*f5*f7 + 6*f1*f3*f8)*z[1]^2*z[9]*z[16] + (16*f0*f2*f6 -
4*f1^2*f6)*z[1]^2*z[10]^2 + (-8*f0*f2*f7 - 16*f0*f3*f6 +
2*f1^2*f7)*z[1]^2*z[10]*z[11] + (4*f0*f3*f7 + 8*f1*f3*f6)*z[1]^2*z[10]*z[12] +
(-16*f0*f2*f8 + 8*f0*f3*f7 + 4*f1^2*f8)*z[1]^2*z[10]*z[13] + (8*f0*f3*f8 -
4*f1*f3*f7)*z[1]^2*z[10]*z[14] + (-24*f0*f4*f8 + 6*f0*f5*f7 +
6*f1*f3*f8)*z[1]^2*z[10]*z[15] - 8*f0*f6*z[1]^2*z[10]*z[16] + (16*f0*f2*f8 +
4*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 - 4*f1^2*f8)*z[1]^2*z[11]^2 + (-16*f0*f3*f8 -
8*f0*f4*f7 - 2*f1*f3*f7 - 16*f1*f4*f6 + 4*f1*f5^2)*z[1]^2*z[11]*z[12] +
(-8*f0*f3*f8 - 16*f0*f4*f7)*z[1]^2*z[11]*z[13] + (8*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8 + 8*f1*f4*f7)*z[1]^2*z[11]*z[14] + (8*f0*f5*f8 -
4*f1*f5*f7)*z[1]^2*z[11]*z[15] + (4*f0*f7 + 4*f1*f6)*z[1]^2*z[11]*z[16] +
(16*f0*f4*f8 + 4*f1*f4*f7 + 16*f2*f4*f6 - 4*f2*f5^2 - 4*f3^2*f6)*z[1]^2*z[12]^2 +
(8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8 + 8*f1*f4*f7)*z[1]^2*z[12]*z[13] +
(-16*f0*f5*f8 - 8*f1*f4*f8 - 2*f1*f5*f7 - 16*f2*f4*f7 +
4*f3^2*f7)*z[1]^2*z[12]*z[14] + (4*f1*f5*f8 + 8*f2*f5*f7)*z[1]^2*z[12]*z[15] +
(-8*f0*f8 - 2*f1*f7 - 8*f2*f6 + 2*f3*f5)*z[1]^2*z[12]*z[16] +
16*f0*f4*f8*z[1]^2*z[13]^2 + (-8*f0*f5*f8 - 16*f1*f4*f8)*z[1]^2*z[13]*z[14] +
(-16*f0*f6*f8 + 4*f0*f7^2 + 8*f1*f5*f8)*z[1]^2*z[13]*z[15] -
2*f1*f7*z[1]^2*z[13]*z[16] + (16*f0*f6*f8 - 4*f0*f7^2 + 4*f1*f5*f8 + 16*f2*f4*f8 -
4*f3^2*f8)*z[1]^2*z[14]^2 + (-8*f1*f6*f8 + 2*f1*f7^2 -
16*f2*f5*f8)*z[1]^2*z[14]*z[15] + (4*f1*f8 + 4*f2*f7)*z[1]^2*z[14]*z[16] +
(16*f2*f6*f8 - 4*f2*f7^2)*z[1]^2*z[15]^2 - 8*f2*f8*z[1]^2*z[15]*z[16] +
(96*f0*f2*f4*f8 - 24*f0*f2*f5*f7 - 24*f0*f3^2*f8 - 24*f1^2*f4*f8 +
6*f1^2*f5*f7)*z[1]*z[2]*z[9]^2 + (16*f0*f2*f6 - 4*f1^2*f6)*z[1]*z[2]*z[9]*z[10] +
(32*f0*f2*f7 - 8*f0*f3*f6 - 8*f1^2*f7)*z[1]*z[2]*z[9]*z[11] + (-16*f0*f3*f7 +
4*f1*f3*f6)*z[1]*z[2]*z[9]*z[12] + (-80*f0*f2*f8 + 4*f0*f3*f7 +
20*f1^2*f8)*z[1]*z[2]*z[9]*z[13] + (40*f0*f3*f8 - 2*f1*f3*f7)*z[1]*z[2]*z[9]*z[14]
+ (-48*f0*f4*f8 + 12*f0*f5*f7 + 12*f1*f3*f8)*z[1]*z[2]*z[9]*z[15] -
4*f0*f6*z[1]*z[2]*z[9]*z[16] + (-24*f0*f2 + 6*f1^2)*z[1]*z[2]*z[10]^2 +
20*f0*f3*z[1]*z[2]*z[10]*z[11] - 10*f1*f3*z[1]*z[2]*z[10]*z[12] -
4*f0*f6*z[1]*z[2]*z[10]*z[15] + 12*f0*z[1]*z[2]*z[10]*z[16] -
16*f0*f4*z[1]*z[2]*z[11]^2 + (4*f0*f5 + 16*f1*f4)*z[1]*z[2]*z[11]*z[12] +
8*f0*f5*z[1]*z[2]*z[11]*z[13] + (-4*f0*f6 - 4*f1*f5)*z[1]*z[2]*z[11]*z[14] +
(-8*f0*f7 + 4*f1*f6)*z[1]*z[2]*z[11]*z[15] - 6*f1*z[1]*z[2]*z[11]*z[16] +
(-2*f1*f5 - 16*f2*f4 + 4*f3^2)*z[1]*z[2]*z[12]^2 + (-4*f0*f6 -
4*f1*f5)*z[1]*z[2]*z[12]*z[13] + (8*f0*f7 + 4*f1*f6 +
8*f2*f5)*z[1]*z[2]*z[12]*z[14] + (8*f0*f8 - 8*f2*f6 -
2*f3*f5)*z[1]*z[2]*z[12]*z[15] + 12*f2*z[1]*z[2]*z[12]*z[16] +
4*f0*f7*z[1]*z[2]*z[13]*z[14] + (16*f0*f8 - 2*f1*f7)*z[1]*z[2]*z[13]*z[15] +
(-16*f0*f8 - 2*f1*f7)*z[1]*z[2]*z[14]^2 + (4*f1*f8 +
4*f2*f7)*z[1]*z[2]*z[14]*z[15] - 2*f3*z[1]*z[2]*z[14]*z[16] -
8*f2*f8*z[1]*z[2]*z[15]^2 + (-48*f0*f2*f5*f8 + 12*f0*f3*f5*f7 +
12*f1^2*f5*f8)*z[1]*z[3]*z[9]^2 + (32*f0*f2*f7 - 8*f0*f3*f6 -
8*f1^2*f7)*z[1]*z[3]*z[9]*z[10] + (16*f0*f2*f8 - 32*f0*f3*f7 + 16*f0*f4*f6 -
4*f0*f5^2 - 4*f1^2*f8)*z[1]*z[3]*z[9]*z[11] + (-8*f0*f3*f8 + 32*f0*f4*f7 +
8*f1*f3*f7 - 8*f1*f4*f6 + 2*f1*f5^2)*z[1]*z[3]*z[9]*z[12] + (32*f0*f3*f8 -
8*f0*f4*f7)*z[1]*z[3]*z[9]*z[13] + (-32*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f3*f8 +
4*f1*f4*f7)*z[1]*z[3]*z[9]*z[14] + (40*f0*f5*f8 - 2*f1*f5*f7)*z[1]*z[3]*z[9]*z[15]
+ (-16*f0*f7 + 2*f1*f6)*z[1]*z[3]*z[9]*z[16] + 4*f0*f3*z[1]*z[3]*z[10]^2 -
8*f0*f4*z[1]*z[3]*z[10]*z[11] + (-8*f0*f5 + 4*f1*f4)*z[1]*z[3]*z[10]*z[12] -
4*f0*f5*z[1]*z[3]*z[10]*z[13] + (8*f0*f6 + 2*f1*f5)*z[1]*z[3]*z[10]*z[14] +
(-8*f0*f7 - 2*f1*f6)*z[1]*z[3]*z[10]*z[15] + 12*f0*f5*z[1]*z[3]*z[11]^2 -
10*f1*f5*z[1]*z[3]*z[11]*z[12] - 8*f0*f6*z[1]*z[3]*z[11]*z[13] +
2*f1*f6*z[1]*z[3]*z[11]*z[14] + (-8*f0*f8 + 8*f1*f7)*z[1]*z[3]*z[11]*z[15] +
8*f2*f5*z[1]*z[3]*z[12]^2 + (-8*f0*f7 + 6*f1*f6)*z[1]*z[3]*z[12]*z[13] + (8*f0*f8
- 8*f2*f6 - 2*f3*f5)*z[1]*z[3]*z[12]*z[14] + (-4*f1*f8 - 8*f2*f7 +
8*f3*f6)*z[1]*z[3]*z[12]*z[15] - 4*f3*z[1]*z[3]*z[12]*z[16] +
4*f0*f7*z[1]*z[3]*z[13]^2 + (8*f0*f8 - 4*f1*f7)*z[1]*z[3]*z[13]*z[14] -
8*f1*f8*z[1]*z[3]*z[13]*z[15] + 4*f2*f7*z[1]*z[3]*z[14]^2 + (8*f2*f8 -
4*f3*f7)*z[1]*z[3]*z[14]*z[15] + 4*f4*z[1]*z[3]*z[14]*z[16] -
2*f5*z[1]*z[3]*z[15]*z[16] + (24*f0*f3*f5*f8 - 6*f1*f3*f5*f7)*z[1]*z[4]*z[9]^2 +
(-16*f0*f3*f7 + 4*f1*f3*f6)*z[1]*z[4]*z[9]*z[10] + (-8*f0*f3*f8 + 32*f0*f4*f7 +
8*f1*f3*f7 - 8*f1*f4*f6 + 2*f1*f5^2)*z[1]*z[4]*z[9]*z[11] + (16*f0*f4*f8 -
32*f1*f4*f7 + 16*f2*f4*f6 - 4*f2*f5^2 - 4*f3^2*f6)*z[1]*z[4]*z[9]*z[12] +
(-32*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f3*f8 + 4*f1*f4*f7)*z[1]*z[4]*z[9]*z[13] +
(-8*f0*f5*f8 + 32*f1*f4*f8 + 8*f1*f5*f7 - 8*f2*f4*f7 +
2*f3^2*f7)*z[1]*z[4]*z[9]*z[14] + (-16*f1*f5*f8 + 4*f2*f5*f7)*z[1]*z[4]*z[9]*z[15]
+ (-4*f0*f8 + 8*f1*f7 - 4*f2*f6 + f3*f5)*z[1]*z[4]*z[9]*z[16] -
2*f1*f3*z[1]*z[4]*z[10]^2 + (-8*f0*f5 + 4*f1*f4)*z[1]*z[4]*z[10]*z[11] + (8*f1*f5
- 8*f2*f4 + 2*f3^2)*z[1]*z[4]*z[10]*z[12] + (8*f0*f6 +
2*f1*f5)*z[1]*z[4]*z[10]*z[13] + (8*f0*f7 - 8*f1*f6 -
4*f2*f5)*z[1]*z[4]*z[10]*z[14] + (-4*f0*f8 + 4*f2*f6 +
f3*f5)*z[1]*z[4]*z[10]*z[15] - 2*f1*f5*z[1]*z[4]*z[11]^2 +
4*f2*f5*z[1]*z[4]*z[11]*z[12] - 8*f0*f7*z[1]*z[4]*z[11]*z[13] + (-4*f0*f8 +
4*f2*f6 + f3*f5)*z[1]*z[4]*z[11]*z[14] + (8*f1*f8 - 8*f2*f7 -
4*f3*f6)*z[1]*z[4]*z[11]*z[15] + 2*f3*z[1]*z[4]*z[11]*z[16] -
6*f3*f5*z[1]*z[4]*z[12]^2 + (-4*f0*f8 + 8*f1*f7 - 4*f2*f6 +
f3*f5)*z[1]*z[4]*z[12]*z[13] + 4*f3*f6*z[1]*z[4]*z[12]*z[14] + (8*f3*f7 - 8*f4*f6
+ 2*f5^2)*z[1]*z[4]*z[12]*z[15] + 4*f4*z[1]*z[4]*z[12]*z[16] +
8*f0*f8*z[1]*z[4]*z[13]^2 - 8*f1*f8*z[1]*z[4]*z[13]*z[14] + (8*f2*f8 +
2*f3*f7)*z[1]*z[4]*z[13]*z[15] - 4*f4*z[1]*z[4]*z[13]*z[16] -
2*f3*f7*z[1]*z[4]*z[14]^2 + (-8*f3*f8 + 4*f4*f7)*z[1]*z[4]*z[14]*z[15] +
2*f5*z[1]*z[4]*z[14]*z[16] - 2*f5*f7*z[1]*z[4]*z[15]^2 + (96*f0*f2*f6*f8 -
24*f0*f2*f7^2 - 24*f0*f3*f5*f8 - 24*f1^2*f6*f8 + 6*f1^2*f7^2)*z[1]*z[5]*z[9]^2 +
(-80*f0*f2*f8 + 4*f0*f3*f7 + 20*f1^2*f8)*z[1]*z[5]*z[9]*z[10] + (32*f0*f3*f8 -
8*f0*f4*f7)*z[1]*z[5]*z[9]*z[11] + (-32*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f3*f8 +
4*f1*f4*f7)*z[1]*z[5]*z[9]*z[12] + 16*f0*f4*f8*z[1]*z[5]*z[9]*z[13] + (32*f0*f5*f8
- 8*f1*f4*f8)*z[1]*z[5]*z[9]*z[14] + (-80*f0*f6*f8 + 20*f0*f7^2 +
4*f1*f5*f8)*z[1]*z[5]*z[9]*z[15] + (36*f0*f8 - f1*f7)*z[1]*z[5]*z[9]*z[16] +
8*f0*f5*z[1]*z[5]*z[10]*z[11] + (8*f0*f6 - 4*f1*f5)*z[1]*z[5]*z[10]*z[12] -
8*f0*f7*z[1]*z[5]*z[10]*z[14] + (28*f0*f8 + f1*f7)*z[1]*z[5]*z[10]*z[15] -
16*f0*f6*z[1]*z[5]*z[11]^2 + (4*f0*f7 + 12*f1*f6)*z[1]*z[5]*z[11]*z[12] +
20*f0*f7*z[1]*z[5]*z[11]*z[13] + (-4*f0*f8 - 7*f1*f7)*z[1]*z[5]*z[11]*z[14] -
8*f1*f8*z[1]*z[5]*z[11]*z[15] + (-8*f0*f8 - 2*f1*f7 - 8*f2*f6 +
2*f3*f5)*z[1]*z[5]*z[12]^2 + (4*f0*f8 - 9*f1*f7)*z[1]*z[5]*z[12]*z[13] + (4*f1*f8
+ 12*f2*f7)*z[1]*z[5]*z[12]*z[14] + (8*f2*f8 - 4*f3*f7)*z[1]*z[5]*z[12]*z[15] -
4*f4*z[1]*z[5]*z[12]*z[16] - 24*f0*f8*z[1]*z[5]*z[13]^2 +
20*f1*f8*z[1]*z[5]*z[13]*z[14] - 16*f2*f8*z[1]*z[5]*z[14]^2 +
8*f3*f8*z[1]*z[5]*z[14]*z[15] + 2*z[1]*z[5]*z[16]^2 + (-48*f0*f3*f6*f8 +
12*f0*f3*f7^2 + 12*f1*f3*f5*f8)*z[1]*z[6]*z[9]^2 + (40*f0*f3*f8 -
2*f1*f3*f7)*z[1]*z[6]*z[9]*z[10] + (-32*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f3*f8 +
4*f1*f4*f7)*z[1]*z[6]*z[9]*z[11] + (-8*f0*f5*f8 + 32*f1*f4*f8 + 8*f1*f5*f7 -
8*f2*f4*f7 + 2*f3^2*f7)*z[1]*z[6]*z[9]*z[12] + (32*f0*f5*f8 -
8*f1*f4*f8)*z[1]*z[6]*z[9]*z[13] + (16*f0*f6*f8 - 4*f0*f7^2 - 32*f1*f5*f8 +
16*f2*f4*f8 - 4*f3^2*f8)*z[1]*z[6]*z[9]*z[14] + (32*f1*f6*f8 - 8*f1*f7^2 -
8*f2*f5*f8)*z[1]*z[6]*z[9]*z[15] + (-16*f1*f8 + 2*f2*f7)*z[1]*z[6]*z[9]*z[16] +
(8*f0*f6 - 4*f1*f5)*z[1]*z[6]*z[10]*z[11] + (-4*f0*f7 - 8*f1*f6 +
8*f2*f5)*z[1]*z[6]*z[10]*z[12] - 8*f0*f7*z[1]*z[6]*z[10]*z[13] + (-8*f0*f8 +
8*f1*f7)*z[1]*z[6]*z[10]*z[14] + (-8*f1*f8 - 2*f2*f7)*z[1]*z[6]*z[10]*z[15] -
2*f3*z[1]*z[6]*z[10]*z[16] + 4*f1*f6*z[1]*z[6]*z[11]^2 + (8*f0*f8 - 8*f2*f6 -
2*f3*f5)*z[1]*z[6]*z[11]*z[12] + (8*f0*f8 - 4*f1*f7)*z[1]*z[6]*z[11]*z[13] +
2*f2*f7*z[1]*z[6]*z[11]*z[14] + (8*f2*f8 + 2*f3*f7)*z[1]*z[6]*z[11]*z[15] +
4*f4*z[1]*z[6]*z[11]*z[16] + 8*f3*f6*z[1]*z[6]*z[12]^2 + (-8*f1*f8 +
6*f2*f7)*z[1]*z[6]*z[12]*z[13] - 10*f3*f7*z[1]*z[6]*z[12]*z[14] + (-8*f3*f8 +
4*f4*f7)*z[1]*z[6]*z[12]*z[15] - 4*f5*z[1]*z[6]*z[12]*z[16] +
4*f1*f8*z[1]*z[6]*z[13]^2 - 8*f2*f8*z[1]*z[6]*z[13]*z[14] -
4*f3*f8*z[1]*z[6]*z[13]*z[15] + 12*f3*f8*z[1]*z[6]*z[14]^2 -
8*f4*f8*z[1]*z[6]*z[14]*z[15] + 4*f5*f8*z[1]*z[6]*z[15]^2 + (96*f0*f4*f6*f8 -
24*f0*f4*f7^2 - 24*f0*f5^2*f8 - 24*f1*f3*f6*f8 + 6*f1*f3*f7^2)*z[1]*z[7]*z[9]^2 +
(-48*f0*f4*f8 + 12*f0*f5*f7 + 12*f1*f3*f8)*z[1]*z[7]*z[9]*z[10] + (40*f0*f5*f8 -
2*f1*f5*f7)*z[1]*z[7]*z[9]*z[11] + (-16*f1*f5*f8 +
4*f2*f5*f7)*z[1]*z[7]*z[9]*z[12] + (-80*f0*f6*f8 + 20*f0*f7^2 +
4*f1*f5*f8)*z[1]*z[7]*z[9]*z[13] + (32*f1*f6*f8 - 8*f1*f7^2 -
8*f2*f5*f8)*z[1]*z[7]*z[9]*z[14] + (16*f2*f6*f8 - 4*f2*f7^2)*z[1]*z[7]*z[9]*z[15]
- 4*f2*f8*z[1]*z[7]*z[9]*z[16] - 8*f0*f6*z[1]*z[7]*z[10]^2 + (4*f0*f7 +
4*f1*f6)*z[1]*z[7]*z[10]*z[11] + (8*f0*f8 - 8*f2*f6 -
2*f3*f5)*z[1]*z[7]*z[10]*z[12] + (16*f0*f8 - 2*f1*f7)*z[1]*z[7]*z[10]*z[13] +
(-8*f1*f8 + 4*f2*f7)*z[1]*z[7]*z[10]*z[14] - 4*f2*f8*z[1]*z[7]*z[10]*z[15] +
(-16*f0*f8 - 2*f1*f7)*z[1]*z[7]*z[11]^2 + (8*f1*f8 + 4*f2*f7 +
8*f3*f6)*z[1]*z[7]*z[11]*z[12] + 4*f1*f8*z[1]*z[7]*z[11]*z[13] + (-4*f2*f8 -
4*f3*f7)*z[1]*z[7]*z[11]*z[14] - 2*f5*z[1]*z[7]*z[11]*z[16] + (-2*f3*f7 - 16*f4*f6
+ 4*f5^2)*z[1]*z[7]*z[12]^2 + (-4*f2*f8 - 4*f3*f7)*z[1]*z[7]*z[12]*z[13] +
(4*f3*f8 + 16*f4*f7)*z[1]*z[7]*z[12]*z[14] - 10*f5*f7*z[1]*z[7]*z[12]*z[15] +
12*f6*z[1]*z[7]*z[12]*z[16] + 8*f3*f8*z[1]*z[7]*z[13]*z[14] -
16*f4*f8*z[1]*z[7]*z[14]^2 + 20*f5*f8*z[1]*z[7]*z[14]*z[15] -
6*f7*z[1]*z[7]*z[14]*z[16] + (-24*f6*f8 + 6*f7^2)*z[1]*z[7]*z[15]^2 +
12*f8*z[1]*z[7]*z[15]*z[16] + (-24*f0*f4*f8 + 6*f0*f5*f7 +
6*f1*f3*f8)*z[1]*z[8]*z[9]^2 - 4*f0*f6*z[1]*z[8]*z[9]*z[10] + (-16*f0*f7 +
2*f1*f6)*z[1]*z[8]*z[9]*z[11] + (-4*f0*f8 + 8*f1*f7 - 4*f2*f6 +
f3*f5)*z[1]*z[8]*z[9]*z[12] + (36*f0*f8 - f1*f7)*z[1]*z[8]*z[9]*z[13] + (-16*f1*f8
+ 2*f2*f7)*z[1]*z[8]*z[9]*z[14] - 4*f2*f8*z[1]*z[8]*z[9]*z[15] +
f4*z[1]*z[8]*z[9]*z[16] + 6*f0*z[1]*z[8]*z[10]^2 - 3*f1*z[1]*z[8]*z[10]*z[11] +
6*f2*z[1]*z[8]*z[10]*z[12] + f3*z[1]*z[8]*z[10]*z[14] - f4*z[1]*z[8]*z[10]*z[15] -
4*f3*z[1]*z[8]*z[11]*z[12] - f4*z[1]*z[8]*z[11]*z[14] + f5*z[1]*z[8]*z[11]*z[15] +
8*f4*z[1]*z[8]*z[12]^2 + f4*z[1]*z[8]*z[12]*z[13] - 4*f5*z[1]*z[8]*z[12]*z[14] +
6*f6*z[1]*z[8]*z[12]*z[15] - 9*z[1]*z[8]*z[12]*z[16] + z[1]*z[8]*z[13]*z[16] -
3*f7*z[1]*z[8]*z[14]*z[15] + 6*f8*z[1]*z[8]*z[15]^2 + (16*f0*f2*f6 -
4*f1^2*f6)*z[2]^2*z[9]^2 + (-24*f0*f2 + 6*f1^2)*z[2]^2*z[9]*z[10] +
4*f0*f3*z[2]^2*z[9]*z[11] - 2*f1*f3*z[2]^2*z[9]*z[12] - 8*f0*f6*z[2]^2*z[9]*z[15]
+ 6*f0*z[2]^2*z[9]*z[16] + 6*f0*z[2]^2*z[10]*z[15] + 2*f0*z[2]^2*z[11]*z[14] -
2*f1*z[2]^2*z[11]*z[15] - 4*f0*z[2]^2*z[12]^2 + 2*f0*z[2]^2*z[12]*z[13] -
2*f1*z[2]^2*z[12]*z[14] + 4*f2*z[2]^2*z[12]*z[15] - 4*f0*z[2]^2*z[13]^2 +
4*f1*z[2]^2*z[13]*z[14] - 4*f2*z[2]^2*z[14]^2 + 2*f3*z[2]^2*z[14]*z[15] +
(-8*f0*f2*f7 - 16*f0*f3*f6 + 2*f1^2*f7)*z[2]*z[3]*z[9]^2 +
20*f0*f3*z[2]*z[3]*z[9]*z[10] - 8*f0*f4*z[2]*z[3]*z[9]*z[11] + (-8*f0*f5 +
4*f1*f4)*z[2]*z[3]*z[9]*z[12] + 8*f0*f5*z[2]*z[3]*z[9]*z[13] + (8*f0*f6 -
4*f1*f5)*z[2]*z[3]*z[9]*z[14] + (4*f0*f7 + 4*f1*f6)*z[2]*z[3]*z[9]*z[15] -
3*f1*z[2]*z[3]*z[9]*z[16] - 8*f0*z[2]*z[3]*z[10]*z[14] - f1*z[2]*z[3]*z[10]*z[15]
+ 4*f0*z[2]*z[3]*z[11]*z[12] + 4*f0*z[2]*z[3]*z[11]*z[13] -
f1*z[2]*z[3]*z[11]*z[14] + 2*f1*z[2]*z[3]*z[12]^2 - 3*f1*z[2]*z[3]*z[12]*z[13] +
4*f2*z[2]*z[3]*z[12]*z[14] - 4*f3*z[2]*z[3]*z[12]*z[15] + 2*f3*z[2]*z[3]*z[14]^2 -
4*f4*z[2]*z[3]*z[14]*z[15] + 2*f5*z[2]*z[3]*z[15]^2 + (4*f0*f3*f7 +
8*f1*f3*f6)*z[2]*z[4]*z[9]^2 - 10*f1*f3*z[2]*z[4]*z[9]*z[10] + (-8*f0*f5 +
4*f1*f4)*z[2]*z[4]*z[9]*z[11] + (8*f1*f5 - 8*f2*f4 + 2*f3^2)*z[2]*z[4]*z[9]*z[12]
+ (8*f0*f6 - 4*f1*f5)*z[2]*z[4]*z[9]*z[13] + (-4*f0*f7 - 8*f1*f6 +
8*f2*f5)*z[2]*z[4]*z[9]*z[14] + (8*f0*f8 - 8*f2*f6 - 2*f3*f5)*z[2]*z[4]*z[9]*z[15]
+ 6*f2*z[2]*z[4]*z[9]*z[16] - 4*f0*z[2]*z[4]*z[10]*z[12] -
8*f0*z[2]*z[4]*z[10]*z[13] + 8*f1*z[2]*z[4]*z[10]*z[14] +
2*f2*z[2]*z[4]*z[10]*z[15] + 8*f0*z[2]*z[4]*z[11]^2 - 8*f1*z[2]*z[4]*z[11]*z[12] -
2*f2*z[2]*z[4]*z[11]*z[14] + 2*f3*z[2]*z[4]*z[11]*z[15] +
2*f2*z[2]*z[4]*z[12]*z[13] - 2*f3*z[2]*z[4]*z[12]*z[14] +
4*f4*z[2]*z[4]*z[12]*z[15] - 2*f3*z[2]*z[4]*z[13]*z[14] +
4*f4*z[2]*z[4]*z[13]*z[15] - 4*f5*z[2]*z[4]*z[14]*z[15] + 4*f6*z[2]*z[4]*z[15]^2 -
4*z[2]*z[4]*z[15]*z[16] + (-16*f0*f2*f8 + 8*f0*f3*f7 + 4*f1^2*f8)*z[2]*z[5]*z[9]^2
- 4*f0*f5*z[2]*z[5]*z[9]*z[11] + (8*f0*f6 + 2*f1*f5)*z[2]*z[5]*z[9]*z[12] -
8*f0*f7*z[2]*z[5]*z[9]*z[14] + (16*f0*f8 - 2*f1*f7)*z[2]*z[5]*z[9]*z[15] -
8*f0*z[2]*z[5]*z[10]*z[12] - 4*f0*z[2]*z[5]*z[10]*z[13] +
2*f1*z[2]*z[5]*z[10]*z[14] + 8*f0*z[2]*z[5]*z[11]^2 - 6*f1*z[2]*z[5]*z[11]*z[12] +
4*f2*z[2]*z[5]*z[12]^2 - 2*f3*z[2]*z[5]*z[12]*z[14] + 4*f4*z[2]*z[5]*z[12]*z[15] -
2*z[2]*z[5]*z[15]*z[16] + (8*f0*f3*f8 - 4*f1*f3*f7)*z[2]*z[6]*z[9]^2 + (8*f0*f6 +
2*f1*f5)*z[2]*z[6]*z[9]*z[11] + (8*f0*f7 - 8*f1*f6 - 4*f2*f5)*z[2]*z[6]*z[9]*z[12]
- 8*f0*f7*z[2]*z[6]*z[9]*z[13] + (-8*f0*f8 + 8*f1*f7)*z[2]*z[6]*z[9]*z[14] +
(-8*f1*f8 + 4*f2*f7)*z[2]*z[6]*z[9]*z[15] + f3*z[2]*z[6]*z[9]*z[16] -
8*f0*z[2]*z[6]*z[10]*z[11] + 8*f1*z[2]*z[6]*z[10]*z[12] +
2*f1*z[2]*z[6]*z[10]*z[13] - 4*f2*z[2]*z[6]*z[10]*z[14] + f3*z[2]*z[6]*z[10]*z[15]
- 2*f1*z[2]*z[6]*z[11]^2 + 4*f2*z[2]*z[6]*z[11]*z[12] + f3*z[2]*z[6]*z[11]*z[14] -
4*f4*z[2]*z[6]*z[11]*z[15] - 4*f3*z[2]*z[6]*z[12]^2 + f3*z[2]*z[6]*z[12]*z[13] +
2*f5*z[2]*z[6]*z[12]*z[15] + 2*z[2]*z[6]*z[14]*z[16] - 2*f7*z[2]*z[6]*z[15]^2 +
(-24*f0*f4*f8 + 6*f0*f5*f7 + 6*f1*f3*f8)*z[2]*z[7]*z[9]^2 -
4*f0*f6*z[2]*z[7]*z[9]*z[10] + (-8*f0*f7 - 2*f1*f6)*z[2]*z[7]*z[9]*z[11] +
(-4*f0*f8 + 4*f2*f6 + f3*f5)*z[2]*z[7]*z[9]*z[12] + (28*f0*f8 +
f1*f7)*z[2]*z[7]*z[9]*z[13] + (-8*f1*f8 - 2*f2*f7)*z[2]*z[7]*z[9]*z[14] -
4*f2*f8*z[2]*z[7]*z[9]*z[15] - f4*z[2]*z[7]*z[9]*z[16] + 6*f0*z[2]*z[7]*z[10]^2 -
f1*z[2]*z[7]*z[10]*z[11] + 2*f2*z[2]*z[7]*z[10]*z[12] + f3*z[2]*z[7]*z[10]*z[14] +
f4*z[2]*z[7]*z[10]*z[15] - 4*f3*z[2]*z[7]*z[11]*z[12] + f4*z[2]*z[7]*z[11]*z[14] +
f5*z[2]*z[7]*z[11]*z[15] + 8*f4*z[2]*z[7]*z[12]^2 - f4*z[2]*z[7]*z[12]*z[13] -
4*f5*z[2]*z[7]*z[12]*z[14] + 2*f6*z[2]*z[7]*z[12]*z[15] - 7*z[2]*z[7]*z[12]*z[16]
+ z[2]*z[7]*z[13]*z[16] - f7*z[2]*z[7]*z[14]*z[15] + 6*f8*z[2]*z[7]*z[15]^2 -
8*f0*f6*z[2]*z[8]*z[9]^2 + 12*f0*z[2]*z[8]*z[9]*z[10] - 2*f3*z[2]*z[8]*z[9]*z[14]
- 4*z[2]*z[8]*z[12]*z[15] - 2*z[2]*z[8]*z[13]*z[15] + 4*z[2]*z[8]*z[14]^2 +
(16*f0*f2*f8 + 4*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 - 4*f1^2*f8)*z[3]^2*z[9]^2 -
16*f0*f4*z[3]^2*z[9]*z[10] + 12*f0*f5*z[3]^2*z[9]*z[11] -
2*f1*f5*z[3]^2*z[9]*z[12] - 16*f0*f6*z[3]^2*z[9]*z[13] + 4*f1*f6*z[3]^2*z[9]*z[14]
+ (-16*f0*f8 - 2*f1*f7)*z[3]^2*z[9]*z[15] + 8*f0*z[3]^2*z[10]*z[12] +
8*f0*z[3]^2*z[10]*z[13] - 2*f1*z[3]^2*z[10]*z[14] - 12*f0*z[3]^2*z[11]^2 +
6*f1*z[3]^2*z[11]*z[12] - 4*f2*z[3]^2*z[12]^2 + 2*f5*z[3]^2*z[14]*z[15] -
4*f6*z[3]^2*z[15]^2 + 4*z[3]^2*z[15]*z[16] + (-16*f0*f3*f8 - 8*f0*f4*f7 -
2*f1*f3*f7 - 16*f1*f4*f6 + 4*f1*f5^2)*z[3]*z[4]*z[9]^2 + (4*f0*f5 +
16*f1*f4)*z[3]*z[4]*z[9]*z[10] - 10*f1*f5*z[3]*z[4]*z[9]*z[11] +
4*f2*f5*z[3]*z[4]*z[9]*z[12] + (4*f0*f7 + 12*f1*f6)*z[3]*z[4]*z[9]*z[13] +
(8*f0*f8 - 8*f2*f6 - 2*f3*f5)*z[3]*z[4]*z[9]*z[14] + (8*f1*f8 + 4*f2*f7 +
8*f3*f6)*z[3]*z[4]*z[9]*z[15] - 4*f3*z[3]*z[4]*z[9]*z[16] +
4*f0*z[3]*z[4]*z[10]*z[11] - 8*f1*z[3]*z[4]*z[10]*z[12] -
6*f1*z[3]*z[4]*z[10]*z[13] + 4*f2*z[3]*z[4]*z[10]*z[14] -
4*f3*z[3]*z[4]*z[10]*z[15] + 6*f1*z[3]*z[4]*z[11]^2 - 4*f2*z[3]*z[4]*z[11]*z[12] +
6*f3*z[3]*z[4]*z[12]^2 - 2*f5*z[3]*z[4]*z[12]*z[15] - 2*f5*z[3]*z[4]*z[13]*z[15] +
4*f6*z[3]*z[4]*z[14]*z[15] - 2*z[3]*z[4]*z[14]*z[16] - 2*f7*z[3]*z[4]*z[15]^2 +
(-8*f0*f3*f8 - 16*f0*f4*f7)*z[3]*z[5]*z[9]^2 + 8*f0*f5*z[3]*z[5]*z[9]*z[10] -
8*f0*f6*z[3]*z[5]*z[9]*z[11] - 8*f0*f7*z[3]*z[5]*z[9]*z[12] +
20*f0*f7*z[3]*z[5]*z[9]*z[13] + (8*f0*f8 - 4*f1*f7)*z[3]*z[5]*z[9]*z[14] +
4*f1*f8*z[3]*z[5]*z[9]*z[15] + 4*f0*z[3]*z[5]*z[10]*z[11] -
2*f5*z[3]*z[5]*z[12]*z[15] - 2*z[3]*z[5]*z[14]*z[16] + 4*f7*z[3]*z[5]*z[15]^2 +
(8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8 + 8*f1*f4*f7)*z[3]*z[6]*z[9]^2 + (-4*f0*f6 -
4*f1*f5)*z[3]*z[6]*z[9]*z[10] + 2*f1*f6*z[3]*z[6]*z[9]*z[11] + (-4*f0*f8 + 4*f2*f6
+ f3*f5)*z[3]*z[6]*z[9]*z[12] + (-4*f0*f8 - 7*f1*f7)*z[3]*z[6]*z[9]*z[13] +
2*f2*f7*z[3]*z[6]*z[9]*z[14] + (-4*f2*f8 - 4*f3*f7)*z[3]*z[6]*z[9]*z[15] -
f4*z[3]*z[6]*z[9]*z[16] + 2*f0*z[3]*z[6]*z[10]^2 - f1*z[3]*z[6]*z[10]*z[11] -
2*f2*z[3]*z[6]*z[10]*z[12] + f3*z[3]*z[6]*z[10]*z[14] + f4*z[3]*z[6]*z[10]*z[15] +
f4*z[3]*z[6]*z[11]*z[14] + f5*z[3]*z[6]*z[11]*z[15] - f4*z[3]*z[6]*z[12]*z[13] -
2*f6*z[3]*z[6]*z[12]*z[15] + z[3]*z[6]*z[12]*z[16] + z[3]*z[6]*z[13]*z[16] -
f7*z[3]*z[6]*z[14]*z[15] + 2*f8*z[3]*z[6]*z[15]^2 + (8*f0*f5*f8 -
4*f1*f5*f7)*z[3]*z[7]*z[9]^2 + (-8*f0*f7 + 4*f1*f6)*z[3]*z[7]*z[9]*z[10] +
(-8*f0*f8 + 8*f1*f7)*z[3]*z[7]*z[9]*z[11] + (8*f1*f8 - 8*f2*f7 -
4*f3*f6)*z[3]*z[7]*z[9]*z[12] - 8*f1*f8*z[3]*z[7]*z[9]*z[13] + (8*f2*f8 +
2*f3*f7)*z[3]*z[7]*z[9]*z[14] + f5*z[3]*z[7]*z[9]*z[16] - 2*f1*z[3]*z[7]*z[10]^2 +
2*f3*z[3]*z[7]*z[10]*z[12] - 4*f4*z[3]*z[7]*z[10]*z[14] + f5*z[3]*z[7]*z[10]*z[15]
+ f5*z[3]*z[7]*z[11]*z[14] - 4*f6*z[3]*z[7]*z[11]*z[15] + 2*z[3]*z[7]*z[11]*z[16]
- 4*f5*z[3]*z[7]*z[12]^2 + f5*z[3]*z[7]*z[12]*z[13] + 4*f6*z[3]*z[7]*z[12]*z[14] +
8*f7*z[3]*z[7]*z[12]*z[15] + 2*f7*z[3]*z[7]*z[13]*z[15] - 2*f7*z[3]*z[7]*z[14]^2 -
8*f8*z[3]*z[7]*z[14]*z[15] + (4*f0*f7 + 4*f1*f6)*z[3]*z[8]*z[9]^2 -
6*f1*z[3]*z[8]*z[9]*z[10] + 2*f3*z[3]*z[8]*z[9]*z[12] + 4*f4*z[3]*z[8]*z[9]*z[14]
- 2*f5*z[3]*z[8]*z[9]*z[15] + 2*z[3]*z[8]*z[11]*z[15] - 2*z[3]*z[8]*z[12]*z[14] -
2*z[3]*z[8]*z[13]*z[14] + (16*f0*f4*f8 + 4*f1*f4*f7 + 16*f2*f4*f6 - 4*f2*f5^2 -
4*f3^2*f6)*z[4]^2*z[9]^2 + (-2*f1*f5 - 16*f2*f4 + 4*f3^2)*z[4]^2*z[9]*z[10] +
8*f2*f5*z[4]^2*z[9]*z[11] - 6*f3*f5*z[4]^2*z[9]*z[12] + (-8*f0*f8 - 2*f1*f7 -
8*f2*f6 + 2*f3*f5)*z[4]^2*z[9]*z[13] + 8*f3*f6*z[4]^2*z[9]*z[14] + (-2*f3*f7 -
16*f4*f6 + 4*f5^2)*z[4]^2*z[9]*z[15] + 8*f4*z[4]^2*z[9]*z[16] -
4*f0*z[4]^2*z[10]^2 + 2*f1*z[4]^2*z[10]*z[11] + 4*f2*z[4]^2*z[10]*z[13] -
4*f3*z[4]^2*z[10]*z[14] + 8*f4*z[4]^2*z[10]*z[15] - 4*f2*z[4]^2*z[11]^2 +
6*f3*z[4]^2*z[11]*z[12] - 4*f5*z[4]^2*z[11]*z[15] - 12*f4*z[4]^2*z[12]^2 +
6*f5*z[4]^2*z[12]*z[14] + 6*z[4]^2*z[12]*z[16] + 4*f6*z[4]^2*z[13]*z[15] -
2*z[4]^2*z[13]*z[16] - 4*f6*z[4]^2*z[14]^2 + 2*f7*z[4]^2*z[14]*z[15] -
4*f8*z[4]^2*z[15]^2 + (8*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8 +
8*f1*f4*f7)*z[4]*z[5]*z[9]^2 + (-4*f0*f6 - 4*f1*f5)*z[4]*z[5]*z[9]*z[10] +
(-8*f0*f7 + 6*f1*f6)*z[4]*z[5]*z[9]*z[11] + (-4*f0*f8 + 8*f1*f7 - 4*f2*f6 +
f3*f5)*z[4]*z[5]*z[9]*z[12] + (4*f0*f8 - 9*f1*f7)*z[4]*z[5]*z[9]*z[13] + (-8*f1*f8
+ 6*f2*f7)*z[4]*z[5]*z[9]*z[14] + (-4*f2*f8 - 4*f3*f7)*z[4]*z[5]*z[9]*z[15] +
f4*z[4]*z[5]*z[9]*z[16] + 2*f0*z[4]*z[5]*z[10]^2 - 3*f1*z[4]*z[5]*z[10]*z[11] +
2*f2*z[4]*z[5]*z[10]*z[12] + f3*z[4]*z[5]*z[10]*z[14] - f4*z[4]*z[5]*z[10]*z[15] -
f4*z[4]*z[5]*z[11]*z[14] + f5*z[4]*z[5]*z[11]*z[15] + f4*z[4]*z[5]*z[12]*z[13] +
2*f6*z[4]*z[5]*z[12]*z[15] - z[4]*z[5]*z[12]*z[16] + z[4]*z[5]*z[13]*z[16] -
3*f7*z[4]*z[5]*z[14]*z[15] + 2*f8*z[4]*z[5]*z[15]^2 + (-16*f0*f5*f8 - 8*f1*f4*f8 -
2*f1*f5*f7 - 16*f2*f4*f7 + 4*f3^2*f7)*z[4]*z[6]*z[9]^2 + (8*f0*f7 + 4*f1*f6 +
8*f2*f5)*z[4]*z[6]*z[9]*z[10] + (8*f0*f8 - 8*f2*f6 - 2*f3*f5)*z[4]*z[6]*z[9]*z[11]
+ 4*f3*f6*z[4]*z[6]*z[9]*z[12] + (4*f1*f8 + 12*f2*f7)*z[4]*z[6]*z[9]*z[13] -
10*f3*f7*z[4]*z[6]*z[9]*z[14] + (4*f3*f8 + 16*f4*f7)*z[4]*z[6]*z[9]*z[15] -
4*f5*z[4]*z[6]*z[9]*z[16] - 2*f1*z[4]*z[6]*z[10]^2 + 4*f2*z[4]*z[6]*z[10]*z[11] -
2*f3*z[4]*z[6]*z[10]*z[12] - 2*f3*z[4]*z[6]*z[10]*z[13] -
4*f5*z[4]*z[6]*z[10]*z[15] + 4*f6*z[4]*z[6]*z[11]*z[15] - 2*z[4]*z[6]*z[11]*z[16]
+ 6*f5*z[4]*z[6]*z[12]^2 - 4*f6*z[4]*z[6]*z[12]*z[14] - 8*f7*z[4]*z[6]*z[12]*z[15]
- 6*f7*z[4]*z[6]*z[13]*z[15] + 6*f7*z[4]*z[6]*z[14]^2 + 4*f8*z[4]*z[6]*z[14]*z[15]
+ (4*f1*f5*f8 + 8*f2*f5*f7)*z[4]*z[7]*z[9]^2 + (8*f0*f8 - 8*f2*f6 -
2*f3*f5)*z[4]*z[7]*z[9]*z[10] + (-4*f1*f8 - 8*f2*f7 +
8*f3*f6)*z[4]*z[7]*z[9]*z[11] + (8*f3*f7 - 8*f4*f6 + 2*f5^2)*z[4]*z[7]*z[9]*z[12]
+ (8*f2*f8 - 4*f3*f7)*z[4]*z[7]*z[9]*z[13] + (-8*f3*f8 +
4*f4*f7)*z[4]*z[7]*z[9]*z[14] - 10*f5*f7*z[4]*z[7]*z[9]*z[15] +
6*f6*z[4]*z[7]*z[9]*z[16] + 4*f2*z[4]*z[7]*z[10]^2 - 4*f3*z[4]*z[7]*z[10]*z[11] +
4*f4*z[4]*z[7]*z[10]*z[12] + 4*f4*z[4]*z[7]*z[10]*z[13] +
2*f5*z[4]*z[7]*z[10]*z[14] + 2*f6*z[4]*z[7]*z[10]*z[15] - 4*z[4]*z[7]*z[10]*z[16]
- 2*f5*z[4]*z[7]*z[11]*z[12] - 2*f5*z[4]*z[7]*z[11]*z[13] -
2*f6*z[4]*z[7]*z[11]*z[14] + 8*f7*z[4]*z[7]*z[11]*z[15] +
2*f6*z[4]*z[7]*z[12]*z[13] - 8*f7*z[4]*z[7]*z[12]*z[14] -
4*f8*z[4]*z[7]*z[12]*z[15] - 8*f8*z[4]*z[7]*z[13]*z[15] + 8*f8*z[4]*z[7]*z[14]^2 +
(-8*f0*f8 - 2*f1*f7 - 8*f2*f6 + 2*f3*f5)*z[4]*z[8]*z[9]^2 +
12*f2*z[4]*z[8]*z[9]*z[10] - 4*f3*z[4]*z[8]*z[9]*z[11] + 4*f4*z[4]*z[8]*z[9]*z[12]
- 4*f4*z[4]*z[8]*z[9]*z[13] - 4*f5*z[4]*z[8]*z[9]*z[14] +
12*f6*z[4]*z[8]*z[9]*z[15] - 9*z[4]*z[8]*z[9]*z[16] - 7*z[4]*z[8]*z[10]*z[15] +
z[4]*z[8]*z[11]*z[14] + 6*z[4]*z[8]*z[12]^2 - z[4]*z[8]*z[12]*z[13] +
2*z[4]*z[8]*z[13]^2 + 16*f0*f4*f8*z[5]^2*z[9]^2 + 4*f0*f7*z[5]^2*z[9]*z[11] +
8*f0*f8*z[5]^2*z[9]*z[12] - 24*f0*f8*z[5]^2*z[9]*z[13] + 4*f1*f8*z[5]^2*z[9]*z[14]
- 4*f0*z[5]^2*z[10]^2 + 2*z[5]^2*z[12]*z[16] - 4*f8*z[5]^2*z[15]^2 + (-8*f0*f5*f8
- 16*f1*f4*f8)*z[5]*z[6]*z[9]^2 + 4*f0*f7*z[5]*z[6]*z[9]*z[10] + (8*f0*f8 -
4*f1*f7)*z[5]*z[6]*z[9]*z[11] - 8*f1*f8*z[5]*z[6]*z[9]*z[12] +
20*f1*f8*z[5]*z[6]*z[9]*z[13] - 8*f2*f8*z[5]*z[6]*z[9]*z[14] +
8*f3*f8*z[5]*z[6]*z[9]*z[15] + 4*f1*z[5]*z[6]*z[10]^2 - 2*f3*z[5]*z[6]*z[10]*z[12]
- 2*z[5]*z[6]*z[11]*z[16] + 4*f8*z[5]*z[6]*z[14]*z[15] + (-16*f0*f6*f8 + 4*f0*f7^2
+ 8*f1*f5*f8)*z[5]*z[7]*z[9]^2 + (16*f0*f8 - 2*f1*f7)*z[5]*z[7]*z[9]*z[10] -
8*f1*f8*z[5]*z[7]*z[9]*z[11] + (8*f2*f8 + 2*f3*f7)*z[5]*z[7]*z[9]*z[12] -
4*f3*f8*z[5]*z[7]*z[9]*z[14] + 4*f4*z[5]*z[7]*z[10]*z[12] -
2*z[5]*z[7]*z[10]*z[16] - 2*f5*z[5]*z[7]*z[11]*z[12] + 2*f7*z[5]*z[7]*z[11]*z[15]
+ 4*f6*z[5]*z[7]*z[12]^2 - 6*f7*z[5]*z[7]*z[12]*z[14] - 8*f8*z[5]*z[7]*z[12]*z[15]
- 4*f8*z[5]*z[7]*z[13]*z[15] + 8*f8*z[5]*z[7]*z[14]^2 - 2*f1*f7*z[5]*z[8]*z[9]^2 -
4*f4*z[5]*z[8]*z[9]*z[12] + z[5]*z[8]*z[9]*z[16] + z[5]*z[8]*z[10]*z[15] +
z[5]*z[8]*z[11]*z[14] - 2*z[5]*z[8]*z[12]^2 + z[5]*z[8]*z[12]*z[13] + (16*f0*f6*f8
- 4*f0*f7^2 + 4*f1*f5*f8 + 16*f2*f4*f8 - 4*f3^2*f8)*z[6]^2*z[9]^2 + (-16*f0*f8 -
2*f1*f7)*z[6]^2*z[9]*z[10] + 4*f2*f7*z[6]^2*z[9]*z[11] - 2*f3*f7*z[6]^2*z[9]*z[12]
- 16*f2*f8*z[6]^2*z[9]*z[13] + 12*f3*f8*z[6]^2*z[9]*z[14] -
16*f4*f8*z[6]^2*z[9]*z[15] - 4*f2*z[6]^2*z[10]^2 + 2*f3*z[6]^2*z[10]*z[11] +
4*z[6]^2*z[10]*z[16] - 2*f7*z[6]^2*z[11]*z[15] - 4*f6*z[6]^2*z[12]^2 +
6*f7*z[6]^2*z[12]*z[14] + 8*f8*z[6]^2*z[12]*z[15] + 8*f8*z[6]^2*z[13]*z[15] -
12*f8*z[6]^2*z[14]^2 + (-8*f1*f6*f8 + 2*f1*f7^2 - 16*f2*f5*f8)*z[6]*z[7]*z[9]^2 +
(4*f1*f8 + 4*f2*f7)*z[6]*z[7]*z[9]*z[10] + (8*f2*f8 -
4*f3*f7)*z[6]*z[7]*z[9]*z[11] + (-8*f3*f8 + 4*f4*f7)*z[6]*z[7]*z[9]*z[12] +
8*f3*f8*z[6]*z[7]*z[9]*z[13] - 8*f4*f8*z[6]*z[7]*z[9]*z[14] +
20*f5*f8*z[6]*z[7]*z[9]*z[15] - 3*f7*z[6]*z[7]*z[9]*z[16] + 2*f3*z[6]*z[7]*z[10]^2
- 4*f4*z[6]*z[7]*z[10]*z[11] - 4*f5*z[6]*z[7]*z[10]*z[12] -
f7*z[6]*z[7]*z[10]*z[15] + 2*f5*z[6]*z[7]*z[11]^2 + 4*f6*z[6]*z[7]*z[11]*z[12] -
f7*z[6]*z[7]*z[11]*z[14] - 8*f8*z[6]*z[7]*z[11]*z[15] + 2*f7*z[6]*z[7]*z[12]^2 -
3*f7*z[6]*z[7]*z[12]*z[13] + 4*f8*z[6]*z[7]*z[12]*z[14] +
4*f8*z[6]*z[7]*z[13]*z[14] + (4*f1*f8 + 4*f2*f7)*z[6]*z[8]*z[9]^2 -
2*f3*z[6]*z[8]*z[9]*z[10] + 4*f4*z[6]*z[8]*z[9]*z[11] + 2*f5*z[6]*z[8]*z[9]*z[12]
- 6*f7*z[6]*z[8]*z[9]*z[15] + 2*z[6]*z[8]*z[10]*z[14] - 2*z[6]*z[8]*z[11]*z[12] -
2*z[6]*z[8]*z[11]*z[13] + (16*f2*f6*f8 - 4*f2*f7^2)*z[7]^2*z[9]^2 -
8*f2*f8*z[7]^2*z[9]*z[10] - 2*f5*f7*z[7]^2*z[9]*z[12] + 4*f5*f8*z[7]^2*z[9]*z[14]
+ (-24*f6*f8 + 6*f7^2)*z[7]^2*z[9]*z[15] + 6*f8*z[7]^2*z[9]*z[16] +
2*f5*z[7]^2*z[10]*z[11] + 4*f6*z[7]^2*z[10]*z[12] - 2*f7*z[7]^2*z[10]*z[14] +
6*f8*z[7]^2*z[10]*z[15] - 4*f6*z[7]^2*z[11]^2 - 2*f7*z[7]^2*z[11]*z[12] +
4*f7*z[7]^2*z[11]*z[13] + 2*f8*z[7]^2*z[11]*z[14] - 4*f8*z[7]^2*z[12]^2 +
2*f8*z[7]^2*z[12]*z[13] - 4*f8*z[7]^2*z[13]^2 - 8*f2*f8*z[7]*z[8]*z[9]^2 -
2*f5*z[7]*z[8]*z[9]*z[11] + 12*f8*z[7]*z[8]*z[9]*z[15] - 4*z[7]*z[8]*z[10]*z[12] -
2*z[7]*z[8]*z[10]*z[13] + 4*z[7]*z[8]*z[11]^2 + 2*z[8]^2*z[9]*z[13],

// Bmat[5,2]
  (128*f0^2*f4*f6*f8^2 - 32*f0^2*f4*f7^2*f8 - 32*f0^2*f5^2*f8^2 -
64*f0*f1*f3*f6*f8^2 + 16*f0*f1*f3*f7^2*f8 + 128*f0*f2^2*f6*f8^2 -
32*f0*f2^2*f7^2*f8 - 64*f0*f2*f3*f5*f8^2 + 128*f0*f2*f4^2*f8^2 -
64*f0*f2*f4*f5*f7*f8 + 8*f0*f2*f5^2*f7^2 - 32*f0*f3^2*f4*f8^2 +
16*f0*f3^2*f5*f7*f8 - 32*f1^2*f2*f6*f8^2 + 8*f1^2*f2*f7^2*f8 + 16*f1^2*f3*f5*f8^2
- 32*f1^2*f4^2*f8^2 + 16*f1^2*f4*f5*f7*f8 - 2*f1^2*f5^2*f7^2)*z[1]^2*z[9]^2 +
(-64*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 + 32*f0*f1*f3*f8^2 - 64*f0*f2^2*f8^2 +
16*f0*f2*f3*f7*f8 - 64*f0*f2*f4*f6*f8 + 32*f0*f2*f4*f7^2 + 32*f0*f2*f5^2*f8 -
16*f0*f2*f5*f6*f7 + 16*f0*f3^2*f6*f8 - 8*f0*f3^2*f7^2 + 16*f1^2*f2*f8^2 -
4*f1^2*f3*f7*f8 + 16*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 - 8*f1^2*f5^2*f8 +
4*f1^2*f5*f6*f7)*z[1]^2*z[9]*z[10] + (32*f0^2*f5*f8^2 - 8*f0*f1*f5*f7*f8 +
32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 - 16*f0*f2*f5*f7^2 - 16*f0*f3^2*f7*f8 -
8*f0*f3*f5^2*f8 + 8*f0*f3*f5*f6*f7 - 8*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 +
4*f1^2*f5*f7^2)*z[1]^2*z[9]*z[11] + (-16*f0*f1*f5*f8^2 - 16*f0*f2*f5*f7*f8 -
16*f0*f3^2*f8^2 + 8*f0*f3*f5*f7^2 + 8*f1^2*f5*f7*f8 + 4*f1*f3^2*f7*f8 +
4*f1*f3*f5^2*f8 - 4*f1*f3*f5*f6*f7)*z[1]^2*z[9]*z[12] + (-64*f0^2*f6*f8^2 +
16*f0^2*f7^2*f8 + 16*f0*f1*f5*f8^2 - 128*f0*f2*f4*f8^2 + 48*f0*f2*f5*f7*f8 +
32*f0*f3^2*f8^2 - 4*f0*f3*f5*f7^2 + 32*f1^2*f4*f8^2 -
12*f1^2*f5*f7*f8)*z[1]^2*z[9]*z[13] + (32*f0*f1*f6*f8^2 - 8*f0*f1*f7^2*f8 +
32*f0*f2*f5*f8^2 + 32*f0*f3*f4*f8^2 - 24*f0*f3*f5*f7*f8 - 16*f1^2*f5*f8^2 -
8*f1*f3^2*f8^2 + 2*f1*f3*f5*f7^2)*z[1]^2*z[9]*z[14] + (-128*f0*f2*f6*f8^2 +
32*f0*f2*f7^2*f8 + 48*f0*f3*f5*f8^2 - 64*f0*f4^2*f8^2 + 32*f0*f4*f5*f7*f8 -
4*f0*f5^2*f7^2 + 32*f1^2*f6*f8^2 - 8*f1^2*f7^2*f8 + 16*f1*f3*f4*f8^2 -
8*f1*f3*f5*f7*f8)*z[1]^2*z[9]*z[15] + (32*f0*f2*f8^2 - 8*f0*f3*f7*f8 +
16*f0*f4*f6*f8 - 8*f0*f4*f7^2 - 8*f0*f5^2*f8 + 4*f0*f5*f6*f7 - 8*f1^2*f8^2 -
4*f1*f3*f6*f8 + 2*f1*f3*f7^2)*z[1]^2*z[9]*z[16] + (-32*f0^2*f6*f8 + 16*f0^2*f7^2 +
16*f0*f2*f5*f7 - 4*f1^2*f5*f7)*z[1]^2*z[10]^2 + (-16*f0^2*f7*f8 + 32*f0*f1*f6*f8 -
16*f0*f1*f7^2 - 16*f0*f2*f5*f8 - 12*f0*f3*f5*f7 + 4*f1^2*f5*f8)*z[1]^2*z[10]*z[11]
+ (32*f0^2*f8^2 + 8*f0*f1*f7*f8 + 64*f0*f2*f6*f8 - 32*f0*f2*f7^2 - 32*f1^2*f6*f8 +
16*f1^2*f7^2 + 6*f1*f3*f5*f7)*z[1]^2*z[10]*z[12] +
8*f0*f1*f7*f8*z[1]^2*z[10]*z[13] + (-16*f0*f1*f8^2 + 16*f0*f2*f7*f8 -
16*f0*f3*f6*f8 + 8*f0*f3*f7^2 - 8*f1^2*f7*f8)*z[1]^2*z[10]*z[14] + (-8*f0*f3*f7*f8
+ 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 - 8*f0*f5^2*f8 + 4*f0*f5*f6*f7 + 8*f1^2*f8^2 +
4*f1*f3*f6*f8 - 2*f1*f3*f7^2)*z[1]^2*z[10]*z[15] - 8*f0*f5*f7*z[1]^2*z[10]*z[16] +
(8*f0*f1*f7*f8 - 32*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 16*f0*f3*f5*f8 +
8*f0*f4*f5*f7)*z[1]^2*z[11]^2 + (-16*f0*f1*f8^2 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 -
4*f0*f5^2*f7 - 8*f1^2*f7*f8 + 32*f1*f2*f6*f8 - 16*f1*f2*f7^2 - 12*f1*f3*f5*f8 -
8*f1*f4*f5*f7)*z[1]^2*z[11]*z[12] + (-16*f0*f2*f7*f8 + 16*f0*f3*f6*f8 -
8*f0*f3*f7^2 - 16*f0*f4*f5*f8 - 4*f0*f5^2*f7)*z[1]^2*z[11]*z[13] + (-8*f0*f3*f7*f8
+ 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 + 4*f0*f5*f6*f7 + 8*f1^2*f8^2 + 8*f1*f2*f7*f8 -
4*f1*f3*f6*f8 + 2*f1*f3*f7^2 + 8*f1*f4*f5*f8 + 2*f1*f5^2*f7)*z[1]^2*z[11]*z[14] +
(16*f0*f3*f8^2 - 16*f1*f2*f8^2 + 4*f1*f3*f7*f8 - 16*f1*f4*f6*f8 + 8*f1*f4*f7^2 +
4*f1*f5^2*f8 - 4*f1*f5*f6*f7)*z[1]^2*z[11]*z[15] + (8*f0*f5*f8 +
4*f1*f5*f7)*z[1]^2*z[11]*z[16] + (-32*f0*f2*f8^2 - 8*f0*f3*f7*f8 - 32*f0*f4*f6*f8
+ 16*f0*f4*f7^2 + 8*f0*f5^2*f8 + 16*f1^2*f8^2 + 8*f1*f2*f7*f8 + 32*f1*f3*f6*f8 -
16*f1*f3*f7^2 + 2*f1*f5^2*f7 - 32*f2^2*f6*f8 + 16*f2^2*f7^2 + 8*f2*f3*f5*f8 +
8*f2*f4*f5*f7 - 2*f3^2*f5*f7)*z[1]^2*z[12]^2 + (32*f0*f2*f8^2 - 8*f0*f3*f7*f8 +
16*f0*f4*f6*f8 - 8*f0*f4*f7^2 + 4*f0*f5*f6*f7 - 8*f1^2*f8^2 + 8*f1*f2*f7*f8 -
12*f1*f3*f6*f8 + 6*f1*f3*f7^2 + 8*f1*f4*f5*f8 + 2*f1*f5^2*f7)*z[1]^2*z[12]*z[13] +
(32*f0*f3*f8^2 - 8*f0*f5*f7^2 - 16*f1*f2*f8^2 + 12*f1*f3*f7*f8 - 16*f1*f4*f6*f8 +
8*f1*f4*f7^2 - 4*f1*f5*f6*f7 - 16*f2^2*f7*f8 + 16*f2*f3*f6*f8 - 8*f2*f3*f7^2 -
16*f2*f4*f5*f8 - 4*f2*f5^2*f7)*z[1]^2*z[12]*z[14] + (32*f0*f4*f8^2 - 40*f1*f3*f8^2
- 8*f1*f4*f7*f8 + 4*f1*f5*f7^2 + 32*f2^2*f8^2 + 32*f2*f4*f6*f8 - 16*f2*f4*f7^2 -
8*f2*f5^2*f8 + 8*f2*f5*f6*f7 - 16*f3^2*f6*f8 + 8*f3^2*f7^2 +
8*f3*f4*f5*f8)*z[1]^2*z[12]*z[15] + (-4*f1*f5*f8 - 8*f2*f5*f7)*z[1]^2*z[12]*z[16]
+ (8*f0*f3*f7*f8 + 8*f0*f5^2*f8)*z[1]^2*z[13]^2 + (-16*f0*f3*f8^2 + 16*f0*f4*f7*f8
- 16*f0*f5*f6*f8 - 8*f1*f3*f7*f8 - 8*f1*f5^2*f8)*z[1]^2*z[13]*z[14] +
(8*f1*f3*f8^2 - 8*f1*f4*f7*f8 + 8*f1*f5*f6*f8)*z[1]^2*z[13]*z[15] -
4*f1*f5*f8*z[1]^2*z[13]*z[16] + (-32*f0*f4*f8^2 + 16*f0*f5*f7*f8 + 8*f1*f3*f8^2 -
8*f1*f4*f7*f8 + 8*f1*f5*f6*f8 + 8*f2*f3*f7*f8 + 8*f2*f5^2*f8)*z[1]^2*z[14]^2 +
(-16*f0*f5*f8^2 + 32*f1*f4*f8^2 - 12*f1*f5*f7*f8 - 16*f2*f3*f8^2 + 16*f2*f4*f7*f8
- 16*f2*f5*f6*f8 - 8*f3^2*f7*f8 - 4*f3*f5^2*f8)*z[1]^2*z[14]*z[15] + (8*f2*f5*f8 +
2*f3*f5*f7)*z[1]^2*z[14]*z[16] + (8*f1*f5*f8^2 - 32*f2*f4*f8^2 + 8*f2*f5*f7*f8 +
16*f3^2*f8^2 + 8*f3*f5*f6*f8 - 2*f3*f5*f7^2)*z[1]^2*z[15]^2 -
8*f3*f5*f8*z[1]^2*z[15]*z[16] + (-64*f0^2*f4*f8^2 + 16*f0^2*f5*f7*f8 +
32*f0*f1*f3*f8^2 - 64*f0*f2^2*f8^2 + 16*f0*f2*f3*f7*f8 - 64*f0*f2*f4*f6*f8 +
32*f0*f2*f4*f7^2 + 32*f0*f2*f5^2*f8 - 16*f0*f2*f5*f6*f7 + 16*f0*f3^2*f6*f8 -
8*f0*f3^2*f7^2 + 16*f1^2*f2*f8^2 - 4*f1^2*f3*f7*f8 + 16*f1^2*f4*f6*f8 -
8*f1^2*f4*f7^2 - 8*f1^2*f5^2*f8 + 4*f1^2*f5*f6*f7)*z[1]*z[2]*z[9]^2 +
(32*f0^2*f6*f8 - 32*f0^2*f7^2 + 64*f0*f2*f4*f8 - 48*f0*f2*f5*f7 + 32*f0*f2*f6^2 -
24*f0*f3^2*f8 - 16*f1^2*f4*f8 + 12*f1^2*f5*f7 - 8*f1^2*f6^2)*z[1]*z[2]*z[9]*z[10]
+ (-16*f0*f1*f6*f8 + 16*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 32*f0*f2*f6*f7 +
16*f0*f3*f4*f8 + 16*f0*f3*f5*f7 - 16*f0*f3*f6^2 + 8*f1^2*f5*f8 -
8*f1^2*f6*f7)*z[1]*z[2]*z[9]*z[11] + (-32*f0^2*f8^2 - 32*f0*f2*f6*f8 +
32*f0*f2*f7^2 + 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 16*f1^2*f6*f8 - 16*f1^2*f7^2 -
8*f1*f3*f4*f8 - 8*f1*f3*f5*f7 + 8*f1*f3*f6^2)*z[1]*z[2]*z[9]*z[12] + (64*f0^2*f8^2
- 16*f0*f1*f7*f8 + 32*f0*f2*f6*f8 - 32*f0*f2*f7^2 - 24*f0*f3*f5*f8 + 8*f0*f3*f6*f7
- 8*f1^2*f6*f8 + 8*f1^2*f7^2)*z[1]*z[2]*z[9]*z[13] + (-16*f0*f1*f8^2 -
32*f0*f2*f7*f8 + 8*f0*f3*f7^2 + 16*f1^2*f7*f8 + 12*f1*f3*f5*f8 -
4*f1*f3*f6*f7)*z[1]*z[2]*z[9]*z[14] + (96*f0*f2*f8^2 - 8*f0*f3*f7*f8 +
32*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8 + 8*f0*f5*f6*f7 - 32*f1^2*f8^2 -
16*f1*f3*f6*f8 + 8*f1*f3*f7^2)*z[1]*z[2]*z[9]*z[15] + (-16*f0*f4*f8 + 12*f0*f5*f7
- 8*f0*f6^2 + 8*f1*f3*f8)*z[1]*z[2]*z[9]*z[16] + (16*f0^2*f8 - 16*f0*f2*f6 +
4*f1^2*f6)*z[1]*z[2]*z[10]^2 + (-16*f0*f1*f8 + 8*f0*f3*f6)*z[1]*z[2]*z[10]*z[11] +
(-32*f0*f2*f8 + 8*f0*f3*f7 + 16*f1^2*f8 - 4*f1*f3*f6)*z[1]*z[2]*z[10]*z[12] +
(-16*f0*f2*f8 + 8*f0*f3*f7 + 4*f1^2*f8)*z[1]*z[2]*z[10]*z[13] + (8*f0*f3*f8 -
4*f1*f3*f7)*z[1]*z[2]*z[10]*z[14] + (-16*f0*f4*f8 + 12*f0*f5*f7 - 8*f0*f6^2 +
4*f1*f3*f8)*z[1]*z[2]*z[10]*z[15] + 8*f0*f6*z[1]*z[2]*z[10]*z[16] + (32*f0*f2*f8 -
8*f0*f3*f7 - 4*f0*f5^2 - 4*f1^2*f8)*z[1]*z[2]*z[11]^2 + (8*f0*f3*f8 - 16*f0*f4*f7
+ 8*f0*f5*f6 - 16*f1*f2*f8 + 8*f1*f3*f7 + 4*f1*f5^2)*z[1]*z[2]*z[11]*z[12] +
(-8*f0*f3*f8 + 8*f0*f5*f6)*z[1]*z[2]*z[11]*z[13] + (4*f0*f5*f7 - 8*f0*f6^2 -
4*f1*f5*f6)*z[1]*z[2]*z[11]*z[14] + (-8*f0*f5*f8 + 8*f1*f4*f8 - 8*f1*f5*f7 +
8*f1*f6^2)*z[1]*z[2]*z[11]*z[15] - 4*f1*f6*z[1]*z[2]*z[11]*z[16] + (32*f0*f4*f8 -
8*f0*f5*f7 - 20*f1*f3*f8 + 8*f1*f4*f7 - 4*f1*f5*f6 + 16*f2^2*f8 - 8*f2*f3*f7 -
4*f2*f5^2)*z[1]*z[2]*z[12]^2 + (4*f0*f5*f7 - 8*f0*f6^2 + 4*f1*f3*f8 -
4*f1*f5*f6)*z[1]*z[2]*z[12]*z[13] + (-16*f0*f5*f8 + 16*f0*f6*f7 - 4*f1*f5*f7 +
8*f1*f6^2 + 8*f2*f5*f6 + 4*f3^2*f7)*z[1]*z[2]*z[12]*z[14] + (16*f1*f5*f8 -
8*f1*f6*f7 - 16*f2*f4*f8 + 16*f2*f5*f7 - 16*f2*f6^2 + 8*f3^2*f8 -
8*f3*f4*f7)*z[1]*z[2]*z[12]*z[15] + (-8*f0*f8 + 8*f2*f6 +
2*f3*f5)*z[1]*z[2]*z[12]*z[16] - 4*f0*f5*f7*z[1]*z[2]*z[13]^2 + (8*f0*f6*f7 +
4*f1*f5*f7)*z[1]*z[2]*z[13]*z[14] + (4*f1*f5*f8 -
4*f1*f6*f7)*z[1]*z[2]*z[13]*z[15] + (-8*f0*f7^2 - 4*f1*f6*f7 - 4*f2*f5*f7 -
4*f3^2*f8)*z[1]*z[2]*z[14]^2 + (8*f0*f7*f8 - 8*f1*f6*f8 + 8*f1*f7^2 - 8*f2*f5*f8 +
8*f2*f6*f7 + 8*f3*f4*f8 + 2*f3*f5*f7)*z[1]*z[2]*z[14]*z[15] + (4*f1*f8 -
4*f3*f6)*z[1]*z[2]*z[14]*z[16] + (-4*f1*f7*f8 + 16*f2*f6*f8 - 8*f2*f7^2 -
8*f3*f5*f8)*z[1]*z[2]*z[15]^2 + (-8*f2*f8 + 4*f3*f7)*z[1]*z[2]*z[15]*z[16] +
(32*f0^2*f5*f8^2 - 8*f0*f1*f5*f7*f8 + 32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 -
16*f0*f2*f5*f7^2 - 16*f0*f3^2*f7*f8 - 8*f0*f3*f5^2*f8 + 8*f0*f3*f5*f6*f7 -
8*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 + 4*f1^2*f5*f7^2)*z[1]*z[3]*z[9]^2 +
(-16*f0*f1*f6*f8 + 16*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 32*f0*f2*f6*f7 +
16*f0*f3*f4*f8 + 16*f0*f3*f5*f7 - 16*f0*f3*f6^2 + 8*f1^2*f5*f8 -
8*f1^2*f6*f7)*z[1]*z[3]*z[9]*z[10] + (-32*f0^2*f8^2 + 16*f0*f3*f5*f8 -
32*f0*f3*f6*f7 - 32*f0*f4^2*f8 - 16*f0*f4*f5*f7 + 32*f0*f4*f6^2 - 8*f0*f5^2*f6 +
8*f1^2*f6*f8 - 8*f1^2*f7^2)*z[1]*z[3]*z[9]*z[11] + (32*f0*f1*f8^2 + 32*f0*f3*f6*f8
- 32*f0*f3*f7^2 - 16*f0*f4*f5*f8 + 32*f0*f4*f6*f7 - 16*f1*f2*f6*f8 + 16*f1*f2*f7^2
- 4*f1*f3*f5*f8 + 8*f1*f3*f6*f7 + 16*f1*f4^2*f8 + 8*f1*f4*f5*f7 - 16*f1*f4*f6^2 +
4*f1*f5^2*f6)*z[1]*z[3]*z[9]*z[12] + (-16*f0*f1*f8^2 - 16*f0*f2*f7*f8 +
16*f0*f3*f7^2 + 32*f0*f4*f5*f8 - 16*f0*f4*f6*f7 + 4*f0*f5^2*f7 +
12*f1^2*f7*f8)*z[1]*z[3]*z[9]*z[13] + (40*f0*f3*f7*f8 - 32*f0*f4*f6*f8 +
8*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 16*f1*f2*f7*f8 - 4*f1*f3*f7^2 - 16*f1*f4*f5*f8 +
8*f1*f4*f6*f7 - 2*f1*f5^2*f7)*z[1]*z[3]*z[9]*z[14] + (-64*f0*f3*f8^2 -
16*f0*f4*f7*f8 + 16*f0*f5*f7^2 + 16*f1*f2*f8^2 + 8*f1*f3*f7*f8 + 16*f1*f4*f6*f8 -
8*f1*f4*f7^2)*z[1]*z[3]*z[9]*z[15] + (16*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f4*f8 -
4*f1*f5*f7 + 4*f1*f6^2)*z[1]*z[3]*z[9]*z[16] + (-16*f0*f2*f7 + 8*f0*f3*f6 +
4*f1^2*f7)*z[1]*z[3]*z[10]^2 + (16*f0*f2*f8 + 16*f0*f3*f7 - 16*f0*f4*f6 +
4*f0*f5^2 - 4*f1^2*f8)*z[1]*z[3]*z[10]*z[11] + (-8*f0*f3*f8 - 8*f0*f5*f6 -
12*f1*f3*f7 + 8*f1*f4*f6 - 2*f1*f5^2)*z[1]*z[3]*z[10]*z[12] -
16*f0*f4*f7*z[1]*z[3]*z[10]*z[13] + (-16*f0*f5*f7 + 16*f0*f6^2 + 4*f1*f3*f8 +
8*f1*f4*f7)*z[1]*z[3]*z[10]*z[14] + (24*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f4*f8 +
4*f1*f5*f7 - 4*f1*f6^2)*z[1]*z[3]*z[10]*z[15] + 8*f0*f7*z[1]*z[3]*z[10]*z[16] +
(-16*f0*f3*f8 + 8*f0*f5*f6)*z[1]*z[3]*z[11]^2 + (16*f0*f4*f8 + 8*f1*f3*f8 +
8*f1*f4*f7 - 8*f1*f5*f6)*z[1]*z[3]*z[11]*z[12] + (16*f0*f4*f8 + 16*f0*f5*f7 -
16*f0*f6^2)*z[1]*z[3]*z[11]*z[13] + (-8*f1*f4*f8 - 4*f1*f5*f7 +
4*f1*f6^2)*z[1]*z[3]*z[11]*z[14] + (-4*f1*f5*f8 +
8*f1*f6*f7)*z[1]*z[3]*z[11]*z[15] + (-8*f0*f8 - 4*f1*f7)*z[1]*z[3]*z[11]*z[16] +
(-8*f0*f5*f8 - 8*f1*f4*f8 + 4*f1*f5*f7 - 16*f2*f4*f7 + 8*f2*f5*f6 +
8*f3^2*f7)*z[1]*z[3]*z[12]^2 + (-8*f0*f5*f8 - 8*f1*f4*f8 - 12*f1*f5*f7 +
12*f1*f6^2)*z[1]*z[3]*z[12]*z[13] + (-16*f0*f6*f8 + 16*f0*f7^2 + 8*f1*f5*f8 -
8*f1*f6*f7 + 16*f2*f4*f8 + 16*f2*f5*f7 - 16*f2*f6^2 - 8*f3^2*f8 -
8*f3*f4*f7)*z[1]*z[3]*z[12]*z[14] + (8*f1*f6*f8 - 8*f1*f7^2 - 8*f2*f5*f8 -
16*f3*f5*f7 + 16*f3*f6^2 + 16*f4^2*f7 - 8*f4*f5*f6 + 2*f5^3)*z[1]*z[3]*z[12]*z[15]
+ (4*f1*f8 + 8*f2*f7 - 8*f3*f6)*z[1]*z[3]*z[12]*z[16] + (-16*f0*f5*f8 +
8*f0*f6*f7)*z[1]*z[3]*z[13]^2 + (16*f0*f6*f8 - 8*f0*f7^2 + 16*f1*f5*f8 -
8*f1*f6*f7)*z[1]*z[3]*z[13]*z[14] + (8*f0*f7*f8 - 16*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[3]*z[13]*z[15] + 4*f1*f8*z[1]*z[3]*z[13]*z[16] + (-16*f0*f7*f8 +
4*f1*f7^2 - 16*f2*f5*f8 + 8*f2*f6*f7 + 8*f3*f4*f8)*z[1]*z[3]*z[14]^2 + (16*f0*f8^2
+ 4*f1*f7*f8 + 16*f2*f6*f8 - 8*f2*f7^2 + 16*f3*f5*f8 - 8*f3*f6*f7 -
16*f4^2*f8)*z[1]*z[3]*z[14]*z[15] + (-8*f2*f8 + 8*f4*f6 -
2*f5^2)*z[1]*z[3]*z[14]*z[16] + (-8*f1*f8^2 - 16*f3*f6*f8 + 8*f3*f7^2 +
8*f4*f5*f8)*z[1]*z[3]*z[15]^2 + (8*f3*f8 - 8*f4*f7)*z[1]*z[3]*z[15]*z[16] +
(-16*f0*f1*f5*f8^2 - 16*f0*f2*f5*f7*f8 - 16*f0*f3^2*f8^2 + 8*f0*f3*f5*f7^2 +
8*f1^2*f5*f7*f8 + 4*f1*f3^2*f7*f8 + 4*f1*f3*f5^2*f8 -
4*f1*f3*f5*f6*f7)*z[1]*z[4]*z[9]^2 + (-32*f0^2*f8^2 - 32*f0*f2*f6*f8 +
32*f0*f2*f7^2 + 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 16*f1^2*f6*f8 - 16*f1^2*f7^2 -
8*f1*f3*f4*f8 - 8*f1*f3*f5*f7 + 8*f1*f3*f6^2)*z[1]*z[4]*z[9]*z[10] +
(32*f0*f1*f8^2 + 32*f0*f3*f6*f8 - 32*f0*f3*f7^2 - 16*f0*f4*f5*f8 + 32*f0*f4*f6*f7
- 16*f1*f2*f6*f8 + 16*f1*f2*f7^2 - 4*f1*f3*f5*f8 + 8*f1*f3*f6*f7 + 16*f1*f4^2*f8 +
8*f1*f4*f5*f7 - 16*f1*f4*f6^2 + 4*f1*f5^2*f6)*z[1]*z[4]*z[9]*z[11] +
(32*f0*f2*f8^2 - 32*f1^2*f8^2 - 32*f1*f3*f6*f8 + 32*f1*f3*f7^2 + 16*f1*f4*f5*f8 -
32*f1*f4*f6*f7 + 32*f2^2*f6*f8 - 32*f2^2*f7^2 - 32*f2*f4^2*f8 - 16*f2*f4*f5*f7 +
32*f2*f4*f6^2 - 8*f2*f5^2*f6 + 8*f3^2*f4*f8 + 4*f3^2*f5*f7 -
8*f3^2*f6^2)*z[1]*z[4]*z[9]*z[12] + (-32*f0*f2*f8^2 + 32*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 8*f0*f5^2*f8 - 8*f0*f5*f6*f7 + 16*f1^2*f8^2 - 16*f1*f2*f7*f8 +
8*f1*f3*f6*f8 - 8*f1*f3*f7^2 - 16*f1*f4*f5*f8 + 8*f1*f4*f6*f7 -
2*f1*f5^2*f7)*z[1]*z[4]*z[9]*z[13] + (-32*f1*f3*f7*f8 + 32*f1*f4*f6*f8 -
8*f1*f5^2*f8 + 8*f1*f5*f6*f7 + 32*f2^2*f7*f8 - 16*f2*f3*f6*f8 + 8*f2*f3*f7^2 +
32*f2*f4*f5*f8 - 16*f2*f4*f6*f7 + 4*f2*f5^2*f7 - 4*f3^2*f5*f8 +
4*f3^2*f6*f7)*z[1]*z[4]*z[9]*z[14] + (8*f0*f5*f7*f8 + 48*f1*f3*f8^2 - 8*f1*f5*f7^2
- 32*f2^2*f8^2 - 8*f2*f3*f7*f8 - 32*f2*f4*f6*f8 + 16*f2*f4*f7^2 + 16*f3^2*f6*f8 -
8*f3^2*f7^2 - 8*f3*f4*f5*f8)*z[1]*z[4]*z[9]*z[15] + (8*f0*f6*f8 - 8*f0*f7^2 -
8*f1*f5*f8 + 8*f1*f6*f7 + 16*f2*f4*f8 + 8*f2*f5*f7 - 8*f2*f6^2 - 4*f3^2*f8 +
2*f3*f5*f6)*z[1]*z[4]*z[9]*z[16] - 4*f1*f3*f6*z[1]*z[4]*z[10]^2 + (-8*f0*f5*f6 +
8*f1*f4*f6 - 2*f1*f5^2)*z[1]*z[4]*z[10]*z[11] + (8*f1*f5*f6 + 8*f2*f3*f7 -
16*f2*f4*f6 + 4*f2*f5^2 + 4*f3^2*f6)*z[1]*z[4]*z[10]*z[12] + (-16*f0*f5*f7 +
16*f0*f6^2 - 4*f1*f3*f8 + 8*f1*f4*f7)*z[1]*z[4]*z[10]*z[13] + (8*f0*f5*f8 +
16*f1*f5*f7 - 16*f1*f6^2 - 16*f2*f4*f7)*z[1]*z[4]*z[10]*z[14] + (8*f0*f6*f8 -
8*f0*f7^2 - 16*f1*f5*f8 + 8*f1*f6*f7 + 16*f2*f4*f8 - 8*f2*f5*f7 + 8*f2*f6^2 -
4*f3^2*f8 + 8*f3*f4*f7 - 2*f3*f5*f6)*z[1]*z[4]*z[10]*z[15] + (8*f0*f5*f7 +
4*f1*f3*f8 - 8*f1*f4*f7)*z[1]*z[4]*z[11]^2 + (-8*f0*f5*f8 - 8*f1*f5*f7 -
8*f2*f3*f8 + 16*f2*f4*f7 - 8*f3^2*f7)*z[1]*z[4]*z[11]*z[12] + (8*f0*f5*f8 -
16*f0*f6*f7)*z[1]*z[4]*z[11]*z[13] + (-8*f0*f6*f8 + 8*f0*f7^2 - 8*f1*f5*f8 +
8*f1*f6*f7 - 8*f2*f5*f7 + 8*f2*f6^2 + 4*f3^2*f8 + 8*f3*f4*f7 -
2*f3*f5*f6)*z[1]*z[4]*z[11]*z[14] + (16*f2*f5*f8 - 16*f2*f6*f7 - 8*f3*f4*f8 +
12*f3*f5*f7 - 8*f3*f6^2 - 16*f4^2*f7 + 8*f4*f5*f6 - 2*f5^3)*z[1]*z[4]*z[11]*z[15]
+ 4*f3*f6*z[1]*z[4]*z[11]*z[16] + (8*f1*f5*f8 + 4*f3^2*f8 -
4*f3*f5*f6)*z[1]*z[4]*z[12]^2 + (-8*f0*f6*f8 + 8*f0*f7^2 + 8*f1*f6*f7 + 8*f2*f5*f7
- 8*f2*f6^2 + 4*f3^2*f8 + 2*f3*f5*f6)*z[1]*z[4]*z[12]*z[13] + (16*f1*f6*f8 -
16*f1*f7^2 - 8*f3*f4*f8 - 8*f3*f5*f7 + 8*f3*f6^2)*z[1]*z[4]*z[12]*z[14] +
(-16*f2*f6*f8 + 16*f2*f7^2 - 4*f3*f5*f8 + 8*f3*f6*f7 + 16*f4^2*f8 + 8*f4*f5*f7 -
16*f4*f6^2 + 4*f5^2*f6)*z[1]*z[4]*z[12]*z[15] + (-8*f3*f7 + 8*f4*f6 -
2*f5^2)*z[1]*z[4]*z[12]*z[16] + 16*f0*f6*f8*z[1]*z[4]*z[13]^2 + (-16*f0*f7*f8 -
16*f1*f6*f8 - 8*f3*f4*f8)*z[1]*z[4]*z[13]*z[14] + (16*f0*f8^2 + 16*f2*f6*f8 -
12*f3*f5*f8 + 4*f3*f6*f7 + 16*f4^2*f8)*z[1]*z[4]*z[13]*z[15] + (-8*f4*f6 +
2*f5^2)*z[1]*z[4]*z[13]*z[16] + (16*f1*f7*f8 + 8*f3*f5*f8 -
4*f3*f6*f7)*z[1]*z[4]*z[14]^2 + (-16*f1*f8^2 - 16*f2*f7*f8 - 8*f3*f6*f8 -
16*f4*f5*f8 + 8*f4*f6*f7 - 2*f5^2*f7)*z[1]*z[4]*z[14]*z[15] + (4*f3*f8 +
8*f4*f7)*z[1]*z[4]*z[14]*z[16] + (16*f2*f8^2 + 4*f3*f7*f8 + 16*f4*f6*f8 -
8*f4*f7^2)*z[1]*z[4]*z[15]^2 - 16*f4*f8*z[1]*z[4]*z[15]*z[16] + (-64*f0^2*f6*f8^2
+ 16*f0^2*f7^2*f8 + 16*f0*f1*f5*f8^2 - 128*f0*f2*f4*f8^2 + 48*f0*f2*f5*f7*f8 +
32*f0*f3^2*f8^2 - 4*f0*f3*f5*f7^2 + 32*f1^2*f4*f8^2 -
12*f1^2*f5*f7*f8)*z[1]*z[5]*z[9]^2 + (64*f0^2*f8^2 - 16*f0*f1*f7*f8 +
32*f0*f2*f6*f8 - 32*f0*f2*f7^2 - 24*f0*f3*f5*f8 + 8*f0*f3*f6*f7 - 8*f1^2*f6*f8 +
8*f1^2*f7^2)*z[1]*z[5]*z[9]*z[10] + (-16*f0*f1*f8^2 - 16*f0*f2*f7*f8 +
16*f0*f3*f7^2 + 32*f0*f4*f5*f8 - 16*f0*f4*f6*f7 + 4*f0*f5^2*f7 +
12*f1^2*f7*f8)*z[1]*z[5]*z[9]*z[11] + (-32*f0*f2*f8^2 + 32*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 8*f0*f5^2*f8 - 8*f0*f5*f6*f7 + 16*f1^2*f8^2 - 16*f1*f2*f7*f8 +
8*f1*f3*f6*f8 - 8*f1*f3*f7^2 - 16*f1*f4*f5*f8 + 8*f1*f4*f6*f7 -
2*f1*f5^2*f7)*z[1]*z[5]*z[9]*z[12] + (96*f0*f2*f8^2 - 32*f0*f3*f7*f8 +
8*f0*f4*f7^2 - 16*f0*f5^2*f8 - 32*f1^2*f8^2)*z[1]*z[5]*z[9]*z[13] +
(-48*f0*f3*f8^2 + 16*f0*f5*f6*f8 + 4*f0*f5*f7^2 + 16*f1*f2*f8^2 + 12*f1*f3*f7*f8 -
4*f1*f4*f7^2 + 8*f1*f5^2*f8)*z[1]*z[5]*z[9]*z[14] + (96*f0*f4*f8^2 -
48*f0*f5*f7*f8 - 32*f1*f3*f8^2 + 8*f1*f4*f7*f8 - 8*f1*f5*f6*f8 +
2*f1*f5*f7^2)*z[1]*z[5]*z[9]*z[15] + (-8*f0*f6*f8 + 12*f0*f7^2 + 8*f1*f5*f8 -
2*f1*f6*f7)*z[1]*z[5]*z[9]*z[16] + (16*f0*f2*f8 - 4*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[5]*z[10]^2 + (-16*f0*f3*f8 + 8*f0*f4*f7)*z[1]*z[5]*z[10]*z[11] +
(12*f0*f5*f7 + 12*f1*f3*f8 - 4*f1*f4*f7)*z[1]*z[5]*z[10]*z[12] + (16*f0*f4*f8 +
4*f0*f5*f7)*z[1]*z[5]*z[10]*z[13] + (8*f0*f5*f8 - 8*f0*f6*f7 - 8*f1*f4*f8 -
2*f1*f5*f7)*z[1]*z[5]*z[10]*z[14] + (-8*f0*f6*f8 + 12*f0*f7^2 +
2*f1*f6*f7)*z[1]*z[5]*z[10]*z[15] - 8*f0*f8*z[1]*z[5]*z[10]*z[16] -
12*f0*f5*f7*z[1]*z[5]*z[11]^2 + (-8*f1*f4*f8 + 10*f1*f5*f7)*z[1]*z[5]*z[11]*z[12]
+ (-8*f0*f5*f8 + 8*f0*f6*f7)*z[1]*z[5]*z[11]*z[13] + (-8*f0*f6*f8 + 4*f0*f7^2 -
2*f1*f6*f7)*z[1]*z[5]*z[11]*z[14] + (8*f1*f6*f8 - 8*f1*f7^2)*z[1]*z[5]*z[11]*z[15]
+ 4*f1*f8*z[1]*z[5]*z[11]*z[16] + (32*f0*f6*f8 - 16*f0*f7^2 - 8*f1*f5*f8 +
16*f2*f4*f8 - 8*f2*f5*f7 - 8*f3^2*f8)*z[1]*z[5]*z[12]^2 + (-8*f0*f6*f8 + 4*f0*f7^2
+ 8*f1*f5*f8 - 6*f1*f6*f7)*z[1]*z[5]*z[12]*z[13] + (-8*f0*f7*f8 + 8*f1*f6*f8 -
8*f2*f5*f8 + 8*f2*f6*f7 + 8*f3*f4*f8 + 2*f3*f5*f7)*z[1]*z[5]*z[12]*z[14] +
(-32*f0*f8^2 + 12*f1*f7*f8 - 16*f2*f6*f8 + 8*f2*f7^2 + 16*f3*f5*f8 - 8*f3*f6*f7 -
16*f4^2*f8)*z[1]*z[5]*z[12]*z[15] + (-8*f2*f8 + 4*f3*f7)*z[1]*z[5]*z[12]*z[16] -
4*f0*f7^2*z[1]*z[5]*z[13]^2 + 4*f1*f7^2*z[1]*z[5]*z[13]*z[14] + (-16*f0*f8^2 +
4*f1*f7*f8)*z[1]*z[5]*z[13]*z[15] + (32*f0*f8^2 - 4*f1*f7*f8 - 4*f2*f7^2 -
4*f3*f5*f8)*z[1]*z[5]*z[14]^2 + (-16*f1*f8^2 + 4*f3*f7^2 +
8*f4*f5*f8)*z[1]*z[5]*z[14]*z[15] - 4*f4*f7*z[1]*z[5]*z[14]*z[16] + (16*f2*f8^2 -
8*f3*f7*f8 - 4*f5^2*f8)*z[1]*z[5]*z[15]^2 + (8*f4*f8 +
2*f5*f7)*z[1]*z[5]*z[15]*z[16] + (32*f0*f1*f6*f8^2 - 8*f0*f1*f7^2*f8 +
32*f0*f2*f5*f8^2 + 32*f0*f3*f4*f8^2 - 24*f0*f3*f5*f7*f8 - 16*f1^2*f5*f8^2 -
8*f1*f3^2*f8^2 + 2*f1*f3*f5*f7^2)*z[1]*z[6]*z[9]^2 + (-16*f0*f1*f8^2 -
32*f0*f2*f7*f8 + 8*f0*f3*f7^2 + 16*f1^2*f7*f8 + 12*f1*f3*f5*f8 -
4*f1*f3*f6*f7)*z[1]*z[6]*z[9]*z[10] + (40*f0*f3*f7*f8 - 32*f0*f4*f6*f8 +
8*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 16*f1*f2*f7*f8 - 4*f1*f3*f7^2 - 16*f1*f4*f5*f8 +
8*f1*f4*f6*f7 - 2*f1*f5^2*f7)*z[1]*z[6]*z[9]*z[11] + (-32*f1*f3*f7*f8 +
32*f1*f4*f6*f8 - 8*f1*f5^2*f8 + 8*f1*f5*f6*f7 + 32*f2^2*f7*f8 - 16*f2*f3*f6*f8 +
8*f2*f3*f7^2 + 32*f2*f4*f5*f8 - 16*f2*f4*f6*f7 + 4*f2*f5^2*f7 - 4*f3^2*f5*f8 +
4*f3^2*f6*f7)*z[1]*z[6]*z[9]*z[12] + (-48*f0*f3*f8^2 + 16*f0*f5*f6*f8 +
4*f0*f5*f7^2 + 16*f1*f2*f8^2 + 12*f1*f3*f7*f8 - 4*f1*f4*f7^2 +
8*f1*f5^2*f8)*z[1]*z[6]*z[9]*z[13] + (32*f1*f3*f8^2 - 16*f1*f5*f6*f8 -
4*f1*f5*f7^2 - 32*f2^2*f8^2 - 16*f2*f3*f7*f8 + 8*f2*f4*f7^2 - 16*f2*f5^2*f8 -
2*f3^2*f7^2)*z[1]*z[6]*z[9]*z[14] + (-16*f0*f5*f8^2 - 32*f1*f4*f8^2 +
24*f1*f5*f7*f8 + 32*f2*f3*f8^2 - 16*f2*f4*f7*f8 + 16*f2*f5*f6*f8 - 4*f2*f5*f7^2 +
8*f3^2*f7*f8 + 4*f3*f5^2*f8)*z[1]*z[6]*z[9]*z[15] + (8*f0*f7*f8 - 4*f1*f7^2 -
16*f2*f5*f8 + 4*f2*f6*f7 - 2*f3*f5*f7)*z[1]*z[6]*z[9]*z[16] +
2*f1*f3*f7*z[1]*z[6]*z[10]^2 + (12*f0*f5*f7 - 4*f1*f4*f7)*z[1]*z[6]*z[10]*z[11] +
(-8*f0*f5*f8 - 12*f1*f5*f7 - 8*f2*f3*f8 + 8*f2*f4*f7 -
2*f3^2*f7)*z[1]*z[6]*z[10]*z[12] + (8*f0*f5*f8 - 8*f0*f6*f7 - 8*f1*f4*f8 -
2*f1*f5*f7)*z[1]*z[6]*z[10]*z[13] + (-8*f1*f5*f8 + 8*f1*f6*f7 + 16*f2*f4*f8 +
4*f2*f5*f7)*z[1]*z[6]*z[10]*z[14] + (8*f0*f7*f8 - 4*f1*f7^2 - 4*f2*f6*f7 -
8*f3*f4*f8)*z[1]*z[6]*z[10]*z[15] + (-16*f0*f5*f8 + 8*f1*f4*f8 +
2*f1*f5*f7)*z[1]*z[6]*z[11]^2 + (32*f0*f6*f8 - 16*f0*f7^2 + 16*f1*f5*f8 -
16*f2*f4*f8 - 4*f2*f5*f7 + 8*f3^2*f8)*z[1]*z[6]*z[11]*z[12] +
8*f0*f7^2*z[1]*z[6]*z[11]*z[13] + (-4*f1*f7^2 + 8*f2*f5*f8 - 4*f2*f6*f7 -
8*f3*f4*f8)*z[1]*z[6]*z[11]*z[14] + (-16*f0*f8^2 + 8*f2*f7^2 - 12*f3*f5*f8 +
4*f3*f6*f7 + 16*f4^2*f8)*z[1]*z[6]*z[11]*z[15] - 2*f3*f7*z[1]*z[6]*z[11]*z[16] +
(8*f0*f7*f8 - 32*f1*f6*f8 + 16*f1*f7^2 + 6*f3*f5*f7)*z[1]*z[6]*z[12]^2 +
(-4*f1*f7^2 - 8*f2*f5*f8 + 4*f2*f6*f7 - 2*f3*f5*f7)*z[1]*z[6]*z[12]*z[13] +
(-16*f0*f8^2 + 4*f3*f5*f8 - 4*f3*f6*f7)*z[1]*z[6]*z[12]*z[14] + (32*f1*f8^2 -
16*f2*f7*f8 + 16*f3*f6*f8 - 12*f3*f7^2 - 16*f4*f5*f8 + 8*f4*f6*f7 -
2*f5^2*f7)*z[1]*z[6]*z[12]*z[15] + (8*f3*f8 - 4*f4*f7)*z[1]*z[6]*z[12]*z[16] -
8*f0*f7*f8*z[1]*z[6]*z[13]^2 + (16*f0*f8^2 + 8*f1*f7*f8 +
4*f3*f5*f8)*z[1]*z[6]*z[13]*z[14] + (-8*f2*f7*f8 - 2*f3*f7^2 -
8*f4*f5*f8)*z[1]*z[6]*z[13]*z[15] + 4*f4*f7*z[1]*z[6]*z[13]*z[16] + (-16*f1*f8^2 +
2*f3*f7^2)*z[1]*z[6]*z[14]^2 + (16*f2*f8^2 + 12*f3*f7*f8 - 4*f4*f7^2 +
8*f5^2*f8)*z[1]*z[6]*z[14]*z[15] + (-8*f4*f8 - 2*f5*f7)*z[1]*z[6]*z[14]*z[16] +
(-24*f3*f8^2 + 8*f4*f7*f8 - 8*f5*f6*f8 + 2*f5*f7^2)*z[1]*z[6]*z[15]^2 +
8*f5*f8*z[1]*z[6]*z[15]*z[16] + (-128*f0*f2*f6*f8^2 + 32*f0*f2*f7^2*f8 +
48*f0*f3*f5*f8^2 - 64*f0*f4^2*f8^2 + 32*f0*f4*f5*f7*f8 - 4*f0*f5^2*f7^2 +
32*f1^2*f6*f8^2 - 8*f1^2*f7^2*f8 + 16*f1*f3*f4*f8^2 -
8*f1*f3*f5*f7*f8)*z[1]*z[7]*z[9]^2 + (96*f0*f2*f8^2 - 8*f0*f3*f7*f8 +
32*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8 + 8*f0*f5*f6*f7 - 32*f1^2*f8^2 -
16*f1*f3*f6*f8 + 8*f1*f3*f7^2)*z[1]*z[7]*z[9]*z[10] + (-64*f0*f3*f8^2 -
16*f0*f4*f7*f8 + 16*f0*f5*f7^2 + 16*f1*f2*f8^2 + 8*f1*f3*f7*f8 + 16*f1*f4*f6*f8 -
8*f1*f4*f7^2)*z[1]*z[7]*z[9]*z[11] + (8*f0*f5*f7*f8 + 48*f1*f3*f8^2 - 8*f1*f5*f7^2
- 32*f2^2*f8^2 - 8*f2*f3*f7*f8 - 32*f2*f4*f6*f8 + 16*f2*f4*f7^2 + 16*f3^2*f6*f8 -
8*f3^2*f7^2 - 8*f3*f4*f5*f8)*z[1]*z[7]*z[9]*z[12] + (96*f0*f4*f8^2 -
48*f0*f5*f7*f8 - 32*f1*f3*f8^2 + 8*f1*f4*f7*f8 - 8*f1*f5*f6*f8 +
2*f1*f5*f7^2)*z[1]*z[7]*z[9]*z[13] + (-16*f0*f5*f8^2 - 32*f1*f4*f8^2 +
24*f1*f5*f7*f8 + 32*f2*f3*f8^2 - 16*f2*f4*f7*f8 + 16*f2*f5*f6*f8 - 4*f2*f5*f7^2 +
8*f3^2*f7*f8 + 4*f3*f5^2*f8)*z[1]*z[7]*z[9]*z[14] + (96*f0*f6*f8^2 - 24*f0*f7^2*f8
- 32*f1*f5*f8^2 + 32*f2*f4*f8^2 - 32*f3^2*f8^2 - 16*f3*f5*f6*f8 +
4*f3*f5*f7^2)*z[1]*z[7]*z[9]*z[15] + (-32*f0*f8^2 + 4*f1*f7*f8 + 8*f2*f6*f8 -
4*f2*f7^2 + 8*f3*f5*f8)*z[1]*z[7]*z[9]*z[16] - 8*f0*f5*f7*z[1]*z[7]*z[10]^2 +
2*f1*f5*f7*z[1]*z[7]*z[10]*z[11] + (-32*f0*f6*f8 + 16*f0*f7^2 + 8*f1*f5*f8 -
4*f2*f5*f7)*z[1]*z[7]*z[10]*z[12] + (-16*f0*f6*f8 + 8*f0*f7^2 +
4*f1*f5*f8)*z[1]*z[7]*z[10]*z[13] + (-8*f0*f7*f8 + 16*f1*f6*f8 - 8*f1*f7^2 -
8*f2*f5*f8 - 2*f3*f5*f7)*z[1]*z[7]*z[10]*z[14] + (-16*f0*f8^2 + 4*f1*f7*f8 -
8*f2*f6*f8 + 4*f2*f7^2 + 8*f3*f5*f8)*z[1]*z[7]*z[10]*z[15] + (32*f0*f6*f8 -
16*f0*f7^2 - 4*f1*f5*f8)*z[1]*z[7]*z[11]^2 + (8*f0*f7*f8 - 32*f1*f6*f8 +
16*f1*f7^2 + 8*f2*f5*f8 + 4*f3*f5*f7)*z[1]*z[7]*z[11]*z[12] +
8*f0*f7*f8*z[1]*z[7]*z[11]*z[13] + (-4*f1*f7*f8 - 8*f2*f6*f8 +
4*f2*f7^2)*z[1]*z[7]*z[11]*z[14] + (16*f1*f8^2 - 8*f2*f7*f8 + 16*f3*f6*f8 -
8*f3*f7^2 - 8*f4*f5*f8)*z[1]*z[7]*z[11]*z[15] + (16*f0*f8^2 - 8*f1*f7*f8 +
32*f2*f6*f8 - 16*f2*f7^2 - 12*f3*f5*f8 - 8*f4*f5*f7)*z[1]*z[7]*z[12]^2 +
(-16*f0*f8^2 - 4*f1*f7*f8 + 8*f2*f6*f8 - 4*f2*f7^2)*z[1]*z[7]*z[12]*z[13] +
(16*f2*f7*f8 - 16*f3*f6*f8 + 8*f3*f7^2 + 16*f4*f5*f8 +
4*f5^2*f7)*z[1]*z[7]*z[12]*z[14] + (-16*f2*f8^2 + 8*f3*f7*f8 - 16*f4*f6*f8 +
8*f4*f7^2 + 8*f5^2*f8 - 8*f5*f6*f7)*z[1]*z[7]*z[12]*z[15] +
10*f5*f7*z[1]*z[7]*z[12]*z[16] + (8*f3*f7*f8 + 4*f5^2*f8)*z[1]*z[7]*z[13]*z[15] -
2*f5*f7*z[1]*z[7]*z[13]*z[16] + (-8*f3*f7*f8 - 8*f5^2*f8)*z[1]*z[7]*z[14]^2 +
(-8*f4*f7*f8 + 8*f5*f6*f8 + 2*f5*f7^2)*z[1]*z[7]*z[14]*z[15] -
4*f5*f8*z[1]*z[7]*z[14]*z[16] + (16*f4*f8^2 - 8*f5*f7*f8)*z[1]*z[7]*z[15]^2 +
(32*f0*f2*f8^2 - 8*f0*f3*f7*f8 + 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 - 8*f0*f5^2*f8 +
4*f0*f5*f6*f7 - 8*f1^2*f8^2 - 4*f1*f3*f6*f8 + 2*f1*f3*f7^2)*z[1]*z[8]*z[9]^2 +
(-16*f0*f4*f8 + 12*f0*f5*f7 - 8*f0*f6^2 + 8*f1*f3*f8)*z[1]*z[8]*z[9]*z[10] +
(16*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f4*f8 - 4*f1*f5*f7 +
4*f1*f6^2)*z[1]*z[8]*z[9]*z[11] + (8*f0*f6*f8 - 8*f0*f7^2 - 8*f1*f5*f8 +
8*f1*f6*f7 + 16*f2*f4*f8 + 8*f2*f5*f7 - 8*f2*f6^2 - 4*f3^2*f8 +
2*f3*f5*f6)*z[1]*z[8]*z[9]*z[12] + (-8*f0*f6*f8 + 12*f0*f7^2 + 8*f1*f5*f8 -
2*f1*f6*f7)*z[1]*z[8]*z[9]*z[13] + (8*f0*f7*f8 - 4*f1*f7^2 - 16*f2*f5*f8 +
4*f2*f6*f7 - 2*f3*f5*f7)*z[1]*z[8]*z[9]*z[14] + (-32*f0*f8^2 + 4*f1*f7*f8 +
8*f2*f6*f8 - 4*f2*f7^2 + 8*f3*f5*f8)*z[1]*z[8]*z[9]*z[15] + (-6*f2*f8 - 2*f3*f7 +
2*f4*f6 - f5^2)*z[1]*z[8]*z[9]*z[16] + 4*f0*f6*z[1]*z[8]*z[10]^2 + (4*f0*f7 -
2*f1*f6)*z[1]*z[8]*z[10]*z[11] + (8*f0*f8 - 4*f1*f7 + 4*f2*f6 -
2*f3*f5)*z[1]*z[8]*z[10]*z[12] + (8*f0*f8 - 2*f1*f7)*z[1]*z[8]*z[10]*z[13] +
(-4*f1*f8 + 4*f2*f7 + 2*f3*f6)*z[1]*z[8]*z[10]*z[14] + (-2*f2*f8 - 2*f3*f7 -
2*f4*f6 + f5^2)*z[1]*z[8]*z[10]*z[15] + (-16*f0*f8 + 2*f1*f7)*z[1]*z[8]*z[11]^2 +
(12*f1*f8 - 4*f2*f7)*z[1]*z[8]*z[11]*z[12] + (2*f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*z[1]*z[8]*z[11]*z[14] + (-4*f3*f8 + 8*f4*f7 - 2*f5*f6)*z[1]*z[8]*z[11]*z[15]
+ (-8*f2*f8 + 6*f3*f7 + 2*f5^2)*z[1]*z[8]*z[12]^2 + (-2*f2*f8 - 2*f3*f7 + 2*f4*f6
- f5^2)*z[1]*z[8]*z[12]*z[13] - 4*f5*f6*z[1]*z[8]*z[12]*z[14] + (-12*f5*f7 +
12*f6^2)*z[1]*z[8]*z[12]*z[15] - 6*f6*z[1]*z[8]*z[12]*z[16] +
4*f3*f8*z[1]*z[8]*z[13]*z[14] - 8*f4*f8*z[1]*z[8]*z[13]*z[15] +
2*f6*z[1]*z[8]*z[13]*z[16] + 2*f5*f7*z[1]*z[8]*z[14]^2 + (12*f5*f8 -
6*f6*f7)*z[1]*z[8]*z[14]*z[15] - 2*f7*z[1]*z[8]*z[14]*z[16] + (-12*f6*f8 +
6*f7^2)*z[1]*z[8]*z[15]^2 + 8*f8*z[1]*z[8]*z[15]*z[16] + (-32*f0^2*f6*f8 +
16*f0^2*f7^2 + 16*f0*f2*f5*f7 - 4*f1^2*f5*f7)*z[2]^2*z[9]^2 + (16*f0^2*f8 -
16*f0*f2*f6 + 4*f1^2*f6)*z[2]^2*z[9]*z[10] + (-16*f0*f2*f7 + 8*f0*f3*f6 +
4*f1^2*f7)*z[2]^2*z[9]*z[11] - 4*f1*f3*f6*z[2]^2*z[9]*z[12] + (16*f0*f2*f8 -
4*f0*f3*f7 - 4*f1^2*f8)*z[2]^2*z[9]*z[13] + 2*f1*f3*f7*z[2]^2*z[9]*z[14] -
8*f0*f5*f7*z[2]^2*z[9]*z[15] + 4*f0*f6*z[2]^2*z[9]*z[16] + (8*f0*f2 -
2*f1^2)*z[2]^2*z[10]^2 - 4*f0*f3*z[2]^2*z[10]*z[11] + 2*f1*f3*z[2]^2*z[10]*z[12] +
4*f0*f6*z[2]^2*z[10]*z[15] - 4*f0*z[2]^2*z[10]*z[16] - 4*f0*f5*z[2]^2*z[11]*z[13]
+ (4*f0*f6 + 2*f1*f5)*z[2]^2*z[11]*z[14] - 4*f1*f6*z[2]^2*z[11]*z[15] +
2*f1*z[2]^2*z[11]*z[16] + (4*f0*f6 + 2*f1*f5)*z[2]^2*z[12]*z[13] + (-8*f0*f7 -
4*f1*f6 - 4*f2*f5)*z[2]^2*z[12]*z[14] + (4*f1*f7 + 8*f2*f6)*z[2]^2*z[12]*z[15] -
4*f2*z[2]^2*z[12]*z[16] - 4*f0*f7*z[2]^2*z[13]*z[14] + 2*f1*f7*z[2]^2*z[13]*z[15]
+ (8*f0*f8 + 2*f1*f7)*z[2]^2*z[14]^2 + (-4*f1*f8 - 4*f2*f7)*z[2]^2*z[14]*z[15] +
2*f3*z[2]^2*z[14]*z[16] + (-16*f0^2*f7*f8 + 32*f0*f1*f6*f8 - 16*f0*f1*f7^2 -
16*f0*f2*f5*f8 - 12*f0*f3*f5*f7 + 4*f1^2*f5*f8)*z[2]*z[3]*z[9]^2 + (-16*f0*f1*f8 +
8*f0*f3*f6)*z[2]*z[3]*z[9]*z[10] + (16*f0*f2*f8 + 16*f0*f3*f7 - 16*f0*f4*f6 +
4*f0*f5^2 - 4*f1^2*f8)*z[2]*z[3]*z[9]*z[11] + (-8*f0*f5*f6 + 8*f1*f4*f6 -
2*f1*f5^2)*z[2]*z[3]*z[9]*z[12] + (-16*f0*f3*f8 + 8*f0*f4*f7)*z[2]*z[3]*z[9]*z[13]
+ (12*f0*f5*f7 - 4*f1*f4*f7)*z[2]*z[3]*z[9]*z[14] +
2*f1*f5*f7*z[2]*z[3]*z[9]*z[15] + (4*f0*f7 - 2*f1*f6)*z[2]*z[3]*z[9]*z[16] -
4*f0*f3*z[2]*z[3]*z[10]^2 + 8*f0*f4*z[2]*z[3]*z[10]*z[11] + (4*f0*f5 -
4*f1*f4)*z[2]*z[3]*z[10]*z[12] + 4*f0*f5*z[2]*z[3]*z[10]*z[13] + (-8*f0*f6 -
2*f1*f5)*z[2]*z[3]*z[10]*z[14] + (4*f0*f7 + 2*f1*f6)*z[2]*z[3]*z[10]*z[15] -
4*f0*f5*z[2]*z[3]*z[11]^2 + 2*f1*f5*z[2]*z[3]*z[11]*z[12] +
8*f0*f6*z[2]*z[3]*z[11]*z[13] + (-4*f0*f7 - 2*f1*f6)*z[2]*z[3]*z[11]*z[14] +
(-4*f0*f7 - 6*f1*f6)*z[2]*z[3]*z[12]*z[13] + (8*f0*f8 + 8*f1*f7 + 8*f2*f6 +
2*f3*f5)*z[2]*z[3]*z[12]*z[14] + (-4*f1*f8 - 8*f2*f7 -
8*f3*f6)*z[2]*z[3]*z[12]*z[15] + 4*f3*z[2]*z[3]*z[12]*z[16] -
4*f0*f7*z[2]*z[3]*z[13]^2 + (8*f0*f8 + 4*f1*f7)*z[2]*z[3]*z[13]*z[14] + (-8*f1*f8
- 4*f2*f7)*z[2]*z[3]*z[14]^2 + (8*f2*f8 + 4*f3*f7)*z[2]*z[3]*z[14]*z[15] -
4*f4*z[2]*z[3]*z[14]*z[16] + 2*f5*z[2]*z[3]*z[15]*z[16] + (32*f0^2*f8^2 +
8*f0*f1*f7*f8 + 64*f0*f2*f6*f8 - 32*f0*f2*f7^2 - 32*f1^2*f6*f8 + 16*f1^2*f7^2 +
6*f1*f3*f5*f7)*z[2]*z[4]*z[9]^2 + (-32*f0*f2*f8 + 8*f0*f3*f7 + 16*f1^2*f8 -
4*f1*f3*f6)*z[2]*z[4]*z[9]*z[10] + (-8*f0*f3*f8 - 8*f0*f5*f6 - 12*f1*f3*f7 +
8*f1*f4*f6 - 2*f1*f5^2)*z[2]*z[4]*z[9]*z[11] + (8*f1*f5*f6 + 8*f2*f3*f7 -
16*f2*f4*f6 + 4*f2*f5^2 + 4*f3^2*f6)*z[2]*z[4]*z[9]*z[12] + (12*f0*f5*f7 +
12*f1*f3*f8 - 4*f1*f4*f7)*z[2]*z[4]*z[9]*z[13] + (-8*f0*f5*f8 - 12*f1*f5*f7 -
8*f2*f3*f8 + 8*f2*f4*f7 - 2*f3^2*f7)*z[2]*z[4]*z[9]*z[14] + (-32*f0*f6*f8 +
16*f0*f7^2 + 8*f1*f5*f8 - 4*f2*f5*f7)*z[2]*z[4]*z[9]*z[15] + (8*f0*f8 - 4*f1*f7 +
4*f2*f6 - 2*f3*f5)*z[2]*z[4]*z[9]*z[16] + 2*f1*f3*z[2]*z[4]*z[10]^2 + (4*f0*f5 -
4*f1*f4)*z[2]*z[4]*z[10]*z[11] + (-4*f1*f5 + 8*f2*f4 -
2*f3^2)*z[2]*z[4]*z[10]*z[12] + (-8*f0*f6 - 2*f1*f5)*z[2]*z[4]*z[10]*z[13] +
(8*f1*f6 + 4*f2*f5)*z[2]*z[4]*z[10]*z[14] + (8*f0*f8 - 4*f1*f7 -
4*f2*f6)*z[2]*z[4]*z[10]*z[15] + 2*f1*f5*z[2]*z[4]*z[11]^2 -
4*f2*f5*z[2]*z[4]*z[11]*z[12] + 8*f0*f7*z[2]*z[4]*z[11]*z[13] + (-4*f1*f7 -
4*f2*f6)*z[2]*z[4]*z[11]*z[14] + (8*f2*f7 + 4*f3*f6)*z[2]*z[4]*z[11]*z[15] -
2*f3*z[2]*z[4]*z[11]*z[16] + (-8*f0*f8 + 2*f3*f5)*z[2]*z[4]*z[12]^2 + (-4*f1*f7 +
4*f2*f6 - 2*f3*f5)*z[2]*z[4]*z[12]*z[13] - 4*f3*f6*z[2]*z[4]*z[12]*z[14] +
(-4*f3*f7 + 8*f4*f6 - 2*f5^2)*z[2]*z[4]*z[12]*z[15] - 4*f4*z[2]*z[4]*z[12]*z[16] -
8*f0*f8*z[2]*z[4]*z[13]^2 + 8*f1*f8*z[2]*z[4]*z[13]*z[14] + (-8*f2*f8 -
2*f3*f7)*z[2]*z[4]*z[13]*z[15] + 4*f4*z[2]*z[4]*z[13]*z[16] +
2*f3*f7*z[2]*z[4]*z[14]^2 + (4*f3*f8 - 4*f4*f7)*z[2]*z[4]*z[14]*z[15] -
2*f5*z[2]*z[4]*z[14]*z[16] + 2*f5*f7*z[2]*z[4]*z[15]^2 +
8*f0*f1*f7*f8*z[2]*z[5]*z[9]^2 + (-16*f0*f2*f8 + 8*f0*f3*f7 +
4*f1^2*f8)*z[2]*z[5]*z[9]*z[10] - 16*f0*f4*f7*z[2]*z[5]*z[9]*z[11] + (-16*f0*f5*f7
+ 16*f0*f6^2 - 4*f1*f3*f8 + 8*f1*f4*f7)*z[2]*z[5]*z[9]*z[12] + (16*f0*f4*f8 +
4*f0*f5*f7)*z[2]*z[5]*z[9]*z[13] + (8*f0*f5*f8 - 8*f0*f6*f7 - 8*f1*f4*f8 -
2*f1*f5*f7)*z[2]*z[5]*z[9]*z[14] + (-16*f0*f6*f8 + 8*f0*f7^2 +
4*f1*f5*f8)*z[2]*z[5]*z[9]*z[15] + (8*f0*f8 - 2*f1*f7)*z[2]*z[5]*z[9]*z[16] +
4*f0*f5*z[2]*z[5]*z[10]*z[11] + (-8*f0*f6 - 2*f1*f5)*z[2]*z[5]*z[10]*z[12] -
8*f0*f6*z[2]*z[5]*z[10]*z[13] + 4*f1*f6*z[2]*z[5]*z[10]*z[14] + (8*f0*f8 -
2*f1*f7)*z[2]*z[5]*z[10]*z[15] + 8*f0*f7*z[2]*z[5]*z[11]*z[12] +
8*f0*f7*z[2]*z[5]*z[11]*z[13] - 2*f1*f7*z[2]*z[5]*z[11]*z[14] -
4*f1*f8*z[2]*z[5]*z[11]*z[15] + (-8*f0*f8 + 2*f3*f5)*z[2]*z[5]*z[12]^2 -
2*f1*f7*z[2]*z[5]*z[12]*z[13] + (-4*f1*f8 - 4*f3*f6)*z[2]*z[5]*z[12]*z[14] +
(8*f2*f8 + 8*f4*f6 - 2*f5^2)*z[2]*z[5]*z[12]*z[15] - 4*f4*z[2]*z[5]*z[12]*z[16] -
8*f0*f8*z[2]*z[5]*z[13]^2 + 4*f1*f8*z[2]*z[5]*z[13]*z[14] +
2*f3*f7*z[2]*z[5]*z[14]^2 - 4*f4*f7*z[2]*z[5]*z[14]*z[15] +
2*f5*z[2]*z[5]*z[14]*z[16] + 2*f5*f7*z[2]*z[5]*z[15]^2 -
4*f6*z[2]*z[5]*z[15]*z[16] + 2*z[2]*z[5]*z[16]^2 + (-16*f0*f1*f8^2 +
16*f0*f2*f7*f8 - 16*f0*f3*f6*f8 + 8*f0*f3*f7^2 - 8*f1^2*f7*f8)*z[2]*z[6]*z[9]^2 +
(8*f0*f3*f8 - 4*f1*f3*f7)*z[2]*z[6]*z[9]*z[10] + (-16*f0*f5*f7 + 16*f0*f6^2 +
4*f1*f3*f8 + 8*f1*f4*f7)*z[2]*z[6]*z[9]*z[11] + (8*f0*f5*f8 + 16*f1*f5*f7 -
16*f1*f6^2 - 16*f2*f4*f7)*z[2]*z[6]*z[9]*z[12] + (8*f0*f5*f8 - 8*f0*f6*f7 -
8*f1*f4*f8 - 2*f1*f5*f7)*z[2]*z[6]*z[9]*z[13] + (-8*f1*f5*f8 + 8*f1*f6*f7 +
16*f2*f4*f8 + 4*f2*f5*f7)*z[2]*z[6]*z[9]*z[14] + (-8*f0*f7*f8 + 16*f1*f6*f8 -
8*f1*f7^2 - 8*f2*f5*f8 - 2*f3*f5*f7)*z[2]*z[6]*z[9]*z[15] + (-4*f1*f8 + 4*f2*f7 +
2*f3*f6)*z[2]*z[6]*z[9]*z[16] + (-8*f0*f6 - 2*f1*f5)*z[2]*z[6]*z[10]*z[11] +
(8*f1*f6 + 4*f2*f5)*z[2]*z[6]*z[10]*z[12] + 4*f1*f6*z[2]*z[6]*z[10]*z[13] -
8*f2*f6*z[2]*z[6]*z[10]*z[14] + (-4*f1*f8 + 4*f2*f7 +
2*f3*f6)*z[2]*z[6]*z[10]*z[15] - 2*f3*z[2]*z[6]*z[10]*z[16] +
8*f0*f7*z[2]*z[6]*z[11]^2 + (-8*f0*f8 - 8*f1*f7 - 2*f3*f5)*z[2]*z[6]*z[11]*z[12] +
(-8*f0*f8 - 4*f1*f7)*z[2]*z[6]*z[11]*z[13] + (4*f1*f8 + 4*f2*f7 +
2*f3*f6)*z[2]*z[6]*z[11]*z[14] + (-8*f4*f6 + 2*f5^2)*z[2]*z[6]*z[11]*z[15] +
4*f4*z[2]*z[6]*z[11]*z[16] + 8*f1*f8*z[2]*z[6]*z[12]^2 + (4*f1*f8 + 4*f2*f7 +
2*f3*f6)*z[2]*z[6]*z[12]*z[13] - 4*f3*f7*z[2]*z[6]*z[12]*z[14] + (-4*f3*f8 +
8*f4*f7)*z[2]*z[6]*z[12]*z[15] - 2*f5*z[2]*z[6]*z[12]*z[16] +
4*f1*f8*z[2]*z[6]*z[13]^2 + (-8*f2*f8 - 2*f3*f7)*z[2]*z[6]*z[13]*z[14] +
4*f4*f7*z[2]*z[6]*z[13]*z[15] - 2*f5*z[2]*z[6]*z[13]*z[16] +
4*f3*f8*z[2]*z[6]*z[14]^2 + (-8*f4*f8 - 2*f5*f7)*z[2]*z[6]*z[14]*z[15] +
4*f6*z[2]*z[6]*z[14]*z[16] + 4*f5*f8*z[2]*z[6]*z[15]^2 -
4*f7*z[2]*z[6]*z[15]*z[16] + (-8*f0*f3*f7*f8 + 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 -
8*f0*f5^2*f8 + 4*f0*f5*f6*f7 + 8*f1^2*f8^2 + 4*f1*f3*f6*f8 -
2*f1*f3*f7^2)*z[2]*z[7]*z[9]^2 + (-16*f0*f4*f8 + 12*f0*f5*f7 - 8*f0*f6^2 +
4*f1*f3*f8)*z[2]*z[7]*z[9]*z[10] + (24*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f4*f8 +
4*f1*f5*f7 - 4*f1*f6^2)*z[2]*z[7]*z[9]*z[11] + (8*f0*f6*f8 - 8*f0*f7^2 -
16*f1*f5*f8 + 8*f1*f6*f7 + 16*f2*f4*f8 - 8*f2*f5*f7 + 8*f2*f6^2 - 4*f3^2*f8 +
8*f3*f4*f7 - 2*f3*f5*f6)*z[2]*z[7]*z[9]*z[12] + (-8*f0*f6*f8 + 12*f0*f7^2 +
2*f1*f6*f7)*z[2]*z[7]*z[9]*z[13] + (8*f0*f7*f8 - 4*f1*f7^2 - 4*f2*f6*f7 -
8*f3*f4*f8)*z[2]*z[7]*z[9]*z[14] + (-16*f0*f8^2 + 4*f1*f7*f8 - 8*f2*f6*f8 +
4*f2*f7^2 + 8*f3*f5*f8)*z[2]*z[7]*z[9]*z[15] + (-2*f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*z[2]*z[7]*z[9]*z[16] + 4*f0*f6*z[2]*z[7]*z[10]^2 + (4*f0*f7 +
2*f1*f6)*z[2]*z[7]*z[10]*z[11] + (8*f0*f8 - 4*f1*f7 -
4*f2*f6)*z[2]*z[7]*z[10]*z[12] + (8*f0*f8 - 2*f1*f7)*z[2]*z[7]*z[10]*z[13] +
(-4*f1*f8 + 4*f2*f7 + 2*f3*f6)*z[2]*z[7]*z[10]*z[14] + (2*f2*f8 - 2*f3*f7 +
2*f4*f6 - f5^2)*z[2]*z[7]*z[10]*z[15] + (-16*f0*f8 - 2*f1*f7)*z[2]*z[7]*z[11]^2 +
(12*f1*f8 + 4*f2*f7)*z[2]*z[7]*z[11]*z[12] + 4*f1*f8*z[2]*z[7]*z[11]*z[13] +
(-2*f2*f8 - 2*f3*f7 + 2*f4*f6 - f5^2)*z[2]*z[7]*z[11]*z[14] + (-4*f3*f8 +
2*f5*f6)*z[2]*z[7]*z[11]*z[15] - 2*f5*z[2]*z[7]*z[11]*z[16] + (-8*f2*f8 + 2*f3*f7
+ 2*f5^2)*z[2]*z[7]*z[12]^2 + (-6*f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*z[2]*z[7]*z[12]*z[13] + (4*f3*f8 - 4*f5*f6)*z[2]*z[7]*z[12]*z[14] +
(-4*f5*f7 + 4*f6^2)*z[2]*z[7]*z[12]*z[15] - 2*f6*z[2]*z[7]*z[12]*z[16] +
4*f3*f8*z[2]*z[7]*z[13]*z[14] - 2*f5*f7*z[2]*z[7]*z[13]*z[15] +
2*f6*z[2]*z[7]*z[13]*z[16] + 2*f5*f7*z[2]*z[7]*z[14]^2 + (4*f5*f8 -
2*f6*f7)*z[2]*z[7]*z[14]*z[15] - 2*f7*z[2]*z[7]*z[14]*z[16] + (-4*f6*f8 +
2*f7^2)*z[2]*z[7]*z[15]^2 + 4*f8*z[2]*z[7]*z[15]*z[16] -
8*f0*f5*f7*z[2]*z[8]*z[9]^2 + 8*f0*f6*z[2]*z[8]*z[9]*z[10] +
8*f0*f7*z[2]*z[8]*z[9]*z[11] - 8*f0*f8*z[2]*z[8]*z[9]*z[13] -
4*f0*z[2]*z[8]*z[10]^2 - 2*f3*z[2]*z[8]*z[10]*z[14] + 4*f5*z[2]*z[8]*z[12]*z[14] -
8*f6*z[2]*z[8]*z[12]*z[15] + 4*z[2]*z[8]*z[12]*z[16] - 2*z[2]*z[8]*z[13]*z[16] +
4*f7*z[2]*z[8]*z[14]*z[15] + (8*f0*f1*f7*f8 - 32*f0*f2*f6*f8 + 16*f0*f2*f7^2 +
16*f0*f3*f5*f8 + 8*f0*f4*f5*f7)*z[3]^2*z[9]^2 + (32*f0*f2*f8 - 8*f0*f3*f7 -
4*f0*f5^2 - 4*f1^2*f8)*z[3]^2*z[9]*z[10] + (-16*f0*f3*f8 +
8*f0*f5*f6)*z[3]^2*z[9]*z[11] + (8*f0*f5*f7 + 4*f1*f3*f8 -
8*f1*f4*f7)*z[3]^2*z[9]*z[12] - 12*f0*f5*f7*z[3]^2*z[9]*z[13] + (-16*f0*f5*f8 +
8*f1*f4*f8 + 2*f1*f5*f7)*z[3]^2*z[9]*z[14] + (32*f0*f6*f8 - 16*f0*f7^2 -
4*f1*f5*f8)*z[3]^2*z[9]*z[15] + (-16*f0*f8 + 2*f1*f7)*z[3]^2*z[9]*z[16] -
4*f0*f5*z[3]^2*z[10]*z[11] + 2*f1*f5*z[3]^2*z[10]*z[12] +
8*f0*f7*z[3]^2*z[10]*z[14] + (-16*f0*f8 - 2*f1*f7)*z[3]^2*z[10]*z[15] -
8*f0*f7*z[3]^2*z[11]*z[13] + 2*f1*f7*z[3]^2*z[11]*z[14] +
4*f1*f8*z[3]^2*z[11]*z[15] + (8*f0*f8 - 2*f3*f5)*z[3]^2*z[12]^2 +
6*f1*f7*z[3]^2*z[12]*z[13] + (-4*f1*f8 - 8*f2*f7)*z[3]^2*z[12]*z[14] +
8*f3*f7*z[3]^2*z[12]*z[15] + 8*f0*f8*z[3]^2*z[13]^2 - 8*f1*f8*z[3]^2*z[13]*z[14] +
8*f2*f8*z[3]^2*z[14]^2 - 8*f3*f8*z[3]^2*z[14]*z[15] + 2*f5*z[3]^2*z[14]*z[16] -
2*f5*f7*z[3]^2*z[15]^2 + (-16*f0*f1*f8^2 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 -
4*f0*f5^2*f7 - 8*f1^2*f7*f8 + 32*f1*f2*f6*f8 - 16*f1*f2*f7^2 - 12*f1*f3*f5*f8 -
8*f1*f4*f5*f7)*z[3]*z[4]*z[9]^2 + (8*f0*f3*f8 - 16*f0*f4*f7 + 8*f0*f5*f6 -
16*f1*f2*f8 + 8*f1*f3*f7 + 4*f1*f5^2)*z[3]*z[4]*z[9]*z[10] + (16*f0*f4*f8 +
8*f1*f3*f8 + 8*f1*f4*f7 - 8*f1*f5*f6)*z[3]*z[4]*z[9]*z[11] + (-8*f0*f5*f8 -
8*f1*f5*f7 - 8*f2*f3*f8 + 16*f2*f4*f7 - 8*f3^2*f7)*z[3]*z[4]*z[9]*z[12] +
(-8*f1*f4*f8 + 10*f1*f5*f7)*z[3]*z[4]*z[9]*z[13] + (32*f0*f6*f8 - 16*f0*f7^2 +
16*f1*f5*f8 - 16*f2*f4*f8 - 4*f2*f5*f7 + 8*f3^2*f8)*z[3]*z[4]*z[9]*z[14] +
(8*f0*f7*f8 - 32*f1*f6*f8 + 16*f1*f7^2 + 8*f2*f5*f8 +
4*f3*f5*f7)*z[3]*z[4]*z[9]*z[15] + (12*f1*f8 - 4*f2*f7)*z[3]*z[4]*z[9]*z[16] +
2*f1*f5*z[3]*z[4]*z[10]*z[11] - 4*f2*f5*z[3]*z[4]*z[10]*z[12] +
8*f0*f7*z[3]*z[4]*z[10]*z[13] + (-8*f0*f8 - 8*f1*f7 -
2*f3*f5)*z[3]*z[4]*z[10]*z[14] + (12*f1*f8 + 4*f2*f7)*z[3]*z[4]*z[10]*z[15] +
(8*f0*f8 + 4*f3*f5)*z[3]*z[4]*z[11]*z[12] - 8*f0*f8*z[3]*z[4]*z[11]*z[13] +
(4*f1*f8 + 4*f2*f7)*z[3]*z[4]*z[11]*z[14] + (-8*f2*f8 -
8*f3*f7)*z[3]*z[4]*z[11]*z[15] - 8*f1*f8*z[3]*z[4]*z[12]^2 + (4*f1*f8 -
4*f2*f7)*z[3]*z[4]*z[12]*z[13] + 8*f3*f7*z[3]*z[4]*z[12]*z[14] + (8*f3*f8 -
8*f4*f7)*z[3]*z[4]*z[12]*z[15] + 2*f5*z[3]*z[4]*z[12]*z[16] +
8*f3*f8*z[3]*z[4]*z[13]*z[15] - 2*f5*z[3]*z[4]*z[13]*z[16] -
8*f3*f8*z[3]*z[4]*z[14]^2 + (8*f4*f8 + 2*f5*f7)*z[3]*z[4]*z[14]*z[15] -
4*f5*f8*z[3]*z[4]*z[15]^2 + (-16*f0*f2*f7*f8 + 16*f0*f3*f6*f8 - 8*f0*f3*f7^2 -
16*f0*f4*f5*f8 - 4*f0*f5^2*f7)*z[3]*z[5]*z[9]^2 + (-8*f0*f3*f8 +
8*f0*f5*f6)*z[3]*z[5]*z[9]*z[10] + (16*f0*f4*f8 + 16*f0*f5*f7 -
16*f0*f6^2)*z[3]*z[5]*z[9]*z[11] + (8*f0*f5*f8 - 16*f0*f6*f7)*z[3]*z[5]*z[9]*z[12]
+ (-8*f0*f5*f8 + 8*f0*f6*f7)*z[3]*z[5]*z[9]*z[13] + 8*f0*f7^2*z[3]*z[5]*z[9]*z[14]
+ 8*f0*f7*f8*z[3]*z[5]*z[9]*z[15] - 4*f0*f5*z[3]*z[5]*z[10]^2 +
8*f0*f6*z[3]*z[5]*z[10]*z[11] + 8*f0*f7*z[3]*z[5]*z[10]*z[12] +
8*f0*f7*z[3]*z[5]*z[10]*z[13] + (-8*f0*f8 - 4*f1*f7)*z[3]*z[5]*z[10]*z[14] +
4*f1*f8*z[3]*z[5]*z[10]*z[15] - 8*f0*f7*z[3]*z[5]*z[11]^2 -
8*f0*f8*z[3]*z[5]*z[11]*z[12] + 8*f0*f8*z[3]*z[5]*z[11]*z[13] -
4*f1*f8*z[3]*z[5]*z[12]*z[13] + (8*f2*f8 + 4*f3*f7)*z[3]*z[5]*z[12]*z[14] +
(-8*f3*f8 - 8*f4*f7)*z[3]*z[5]*z[12]*z[15] + 2*f5*z[3]*z[5]*z[12]*z[16] -
4*f3*f8*z[3]*z[5]*z[14]^2 + (8*f4*f8 + 2*f5*f7)*z[3]*z[5]*z[14]*z[15] -
4*f6*z[3]*z[5]*z[14]*z[16] + 4*f7*z[3]*z[5]*z[15]*z[16] + (-8*f0*f3*f7*f8 +
16*f0*f4*f6*f8 - 8*f0*f4*f7^2 + 4*f0*f5*f6*f7 + 8*f1^2*f8^2 + 8*f1*f2*f7*f8 -
4*f1*f3*f6*f8 + 2*f1*f3*f7^2 + 8*f1*f4*f5*f8 + 2*f1*f5^2*f7)*z[3]*z[6]*z[9]^2 +
(4*f0*f5*f7 - 8*f0*f6^2 - 4*f1*f5*f6)*z[3]*z[6]*z[9]*z[10] + (-8*f1*f4*f8 -
4*f1*f5*f7 + 4*f1*f6^2)*z[3]*z[6]*z[9]*z[11] + (-8*f0*f6*f8 + 8*f0*f7^2 -
8*f1*f5*f8 + 8*f1*f6*f7 - 8*f2*f5*f7 + 8*f2*f6^2 + 4*f3^2*f8 + 8*f3*f4*f7 -
2*f3*f5*f6)*z[3]*z[6]*z[9]*z[12] + (-8*f0*f6*f8 + 4*f0*f7^2 -
2*f1*f6*f7)*z[3]*z[6]*z[9]*z[13] + (-4*f1*f7^2 + 8*f2*f5*f8 - 4*f2*f6*f7 -
8*f3*f4*f8)*z[3]*z[6]*z[9]*z[14] + (-4*f1*f7*f8 - 8*f2*f6*f8 +
4*f2*f7^2)*z[3]*z[6]*z[9]*z[15] + (2*f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*z[3]*z[6]*z[9]*z[16] + (4*f0*f6 + 2*f1*f5)*z[3]*z[6]*z[10]^2 + (-4*f0*f7 -
2*f1*f6)*z[3]*z[6]*z[10]*z[11] + (-4*f1*f7 - 4*f2*f6)*z[3]*z[6]*z[10]*z[12] -
2*f1*f7*z[3]*z[6]*z[10]*z[13] + (4*f1*f8 + 4*f2*f7 +
2*f3*f6)*z[3]*z[6]*z[10]*z[14] + (-2*f2*f8 - 2*f3*f7 + 2*f4*f6 -
f5^2)*z[3]*z[6]*z[10]*z[15] + 2*f1*f7*z[3]*z[6]*z[11]^2 + (4*f1*f8 +
4*f2*f7)*z[3]*z[6]*z[11]*z[12] + (-6*f2*f8 - 2*f3*f7 + 2*f4*f6 -
f5^2)*z[3]*z[6]*z[11]*z[14] + (4*f3*f8 + 2*f5*f6)*z[3]*z[6]*z[11]*z[15] -
2*f5*z[3]*z[6]*z[11]*z[16] - 2*f3*f7*z[3]*z[6]*z[12]^2 + (-2*f2*f8 - 2*f3*f7 -
2*f4*f6 + f5^2)*z[3]*z[6]*z[12]*z[13] + (4*f5*f7 - 4*f6^2)*z[3]*z[6]*z[12]*z[15] +
2*f6*z[3]*z[6]*z[12]*z[16] + 4*f3*f8*z[3]*z[6]*z[13]*z[14] -
2*f5*f7*z[3]*z[6]*z[13]*z[15] + 2*f6*z[3]*z[6]*z[13]*z[16] + (-4*f5*f8 +
2*f6*f7)*z[3]*z[6]*z[14]*z[15] - 2*f7*z[3]*z[6]*z[14]*z[16] + (4*f6*f8 -
2*f7^2)*z[3]*z[6]*z[15]^2 + (16*f0*f3*f8^2 - 16*f1*f2*f8^2 + 4*f1*f3*f7*f8 -
16*f1*f4*f6*f8 + 8*f1*f4*f7^2 + 4*f1*f5^2*f8 - 4*f1*f5*f6*f7)*z[3]*z[7]*z[9]^2 +
(-8*f0*f5*f8 + 8*f1*f4*f8 - 8*f1*f5*f7 + 8*f1*f6^2)*z[3]*z[7]*z[9]*z[10] +
(-4*f1*f5*f8 + 8*f1*f6*f7)*z[3]*z[7]*z[9]*z[11] + (16*f2*f5*f8 - 16*f2*f6*f7 -
8*f3*f4*f8 + 12*f3*f5*f7 - 8*f3*f6^2 - 16*f4^2*f7 + 8*f4*f5*f6 -
2*f5^3)*z[3]*z[7]*z[9]*z[12] + (8*f1*f6*f8 - 8*f1*f7^2)*z[3]*z[7]*z[9]*z[13] +
(-16*f0*f8^2 + 8*f2*f7^2 - 12*f3*f5*f8 + 4*f3*f6*f7 +
16*f4^2*f8)*z[3]*z[7]*z[9]*z[14] + (16*f1*f8^2 - 8*f2*f7*f8 + 16*f3*f6*f8 -
8*f3*f7^2 - 8*f4*f5*f8)*z[3]*z[7]*z[9]*z[15] + (-4*f3*f8 + 8*f4*f7 -
2*f5*f6)*z[3]*z[7]*z[9]*z[16] - 4*f1*f6*z[3]*z[7]*z[10]^2 + (8*f2*f7 +
4*f3*f6)*z[3]*z[7]*z[10]*z[12] - 4*f1*f8*z[3]*z[7]*z[10]*z[13] + (-8*f4*f6 +
2*f5^2)*z[3]*z[7]*z[10]*z[14] + (-4*f3*f8 + 2*f5*f6)*z[3]*z[7]*z[10]*z[15] +
4*f1*f8*z[3]*z[7]*z[11]^2 + (-8*f2*f8 - 8*f3*f7)*z[3]*z[7]*z[11]*z[12] + (4*f3*f8
+ 2*f5*f6)*z[3]*z[7]*z[11]*z[14] + (8*f4*f8 + 4*f5*f7 -
8*f6^2)*z[3]*z[7]*z[11]*z[15] + 4*f6*z[3]*z[7]*z[11]*z[16] + (4*f3*f8 + 8*f4*f7 -
4*f5*f6)*z[3]*z[7]*z[12]^2 + (4*f3*f8 + 8*f4*f7 - 2*f5*f6)*z[3]*z[7]*z[12]*z[13] +
(-8*f4*f8 - 8*f5*f7 + 8*f6^2)*z[3]*z[7]*z[12]*z[14] + (-4*f5*f8 +
8*f6*f7)*z[3]*z[7]*z[12]*z[15] - 8*f7*z[3]*z[7]*z[12]*z[16] -
8*f4*f8*z[3]*z[7]*z[13]*z[14] + (-4*f5*f8 + 4*f6*f7)*z[3]*z[7]*z[13]*z[15] +
(8*f5*f8 - 4*f6*f7)*z[3]*z[7]*z[14]^2 - 8*f6*f8*z[3]*z[7]*z[14]*z[15] +
4*f8*z[3]*z[7]*z[14]*z[16] + 4*f7*f8*z[3]*z[7]*z[15]^2 + (8*f0*f5*f8 +
4*f1*f5*f7)*z[3]*z[8]*z[9]^2 - 4*f1*f6*z[3]*z[8]*z[9]*z[10] + (-8*f0*f8 -
4*f1*f7)*z[3]*z[8]*z[9]*z[11] + 4*f3*f6*z[3]*z[8]*z[9]*z[12] +
4*f1*f8*z[3]*z[8]*z[9]*z[13] - 2*f3*f7*z[3]*z[8]*z[9]*z[14] +
2*f1*z[3]*z[8]*z[10]^2 - 2*f3*z[3]*z[8]*z[10]*z[12] + 4*f4*z[3]*z[8]*z[10]*z[14] -
2*f5*z[3]*z[8]*z[10]*z[15] - 2*f5*z[3]*z[8]*z[11]*z[14] +
4*f6*z[3]*z[8]*z[11]*z[15] - 2*z[3]*z[8]*z[11]*z[16] - 4*f6*z[3]*z[8]*z[12]*z[14]
+ 4*f7*z[3]*z[8]*z[12]*z[15] - 2*f7*z[3]*z[8]*z[13]*z[15] + 2*f7*z[3]*z[8]*z[14]^2
- 4*f8*z[3]*z[8]*z[14]*z[15] + (-32*f0*f2*f8^2 - 8*f0*f3*f7*f8 - 32*f0*f4*f6*f8 +
16*f0*f4*f7^2 + 8*f0*f5^2*f8 + 16*f1^2*f8^2 + 8*f1*f2*f7*f8 + 32*f1*f3*f6*f8 -
16*f1*f3*f7^2 + 2*f1*f5^2*f7 - 32*f2^2*f6*f8 + 16*f2^2*f7^2 + 8*f2*f3*f5*f8 +
8*f2*f4*f5*f7 - 2*f3^2*f5*f7)*z[4]^2*z[9]^2 + (32*f0*f4*f8 - 8*f0*f5*f7 -
20*f1*f3*f8 + 8*f1*f4*f7 - 4*f1*f5*f6 + 16*f2^2*f8 - 8*f2*f3*f7 -
4*f2*f5^2)*z[4]^2*z[9]*z[10] + (-8*f0*f5*f8 - 8*f1*f4*f8 + 4*f1*f5*f7 -
16*f2*f4*f7 + 8*f2*f5*f6 + 8*f3^2*f7)*z[4]^2*z[9]*z[11] + (8*f1*f5*f8 + 4*f3^2*f8
- 4*f3*f5*f6)*z[4]^2*z[9]*z[12] + (32*f0*f6*f8 - 16*f0*f7^2 - 8*f1*f5*f8 +
16*f2*f4*f8 - 8*f2*f5*f7 - 8*f3^2*f8)*z[4]^2*z[9]*z[13] + (8*f0*f7*f8 -
32*f1*f6*f8 + 16*f1*f7^2 + 6*f3*f5*f7)*z[4]^2*z[9]*z[14] + (16*f0*f8^2 -
8*f1*f7*f8 + 32*f2*f6*f8 - 16*f2*f7^2 - 12*f3*f5*f8 -
8*f4*f5*f7)*z[4]^2*z[9]*z[15] + (-8*f2*f8 + 6*f3*f7 + 2*f5^2)*z[4]^2*z[9]*z[16] +
(-8*f0*f8 + 2*f3*f5)*z[4]^2*z[10]*z[12] + (-8*f0*f8 + 2*f3*f5)*z[4]^2*z[10]*z[13]
+ 8*f1*f8*z[4]^2*z[10]*z[14] + (-8*f2*f8 + 2*f3*f7 + 2*f5^2)*z[4]^2*z[10]*z[15] +
(8*f0*f8 - 2*f3*f5)*z[4]^2*z[11]^2 - 8*f1*f8*z[4]^2*z[11]*z[12] -
2*f3*f7*z[4]^2*z[11]*z[14] + (4*f3*f8 + 8*f4*f7 - 4*f5*f6)*z[4]^2*z[11]*z[15] +
(8*f2*f8 - 2*f5^2)*z[4]^2*z[12]^2 + 2*f3*f7*z[4]^2*z[12]*z[13] + (-4*f3*f8 -
8*f4*f7 + 4*f5*f6)*z[4]^2*z[12]*z[14] + (-8*f4*f8 + 4*f5*f7)*z[4]^2*z[12]*z[15] +
(-8*f4*f8 + 4*f5*f7)*z[4]^2*z[13]*z[15] + (8*f4*f8 - 4*f5*f7)*z[4]^2*z[14]^2 +
(32*f0*f2*f8^2 - 8*f0*f3*f7*f8 + 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 + 4*f0*f5*f6*f7 -
8*f1^2*f8^2 + 8*f1*f2*f7*f8 - 12*f1*f3*f6*f8 + 6*f1*f3*f7^2 + 8*f1*f4*f5*f8 +
2*f1*f5^2*f7)*z[4]*z[5]*z[9]^2 + (4*f0*f5*f7 - 8*f0*f6^2 + 4*f1*f3*f8 -
4*f1*f5*f6)*z[4]*z[5]*z[9]*z[10] + (-8*f0*f5*f8 - 8*f1*f4*f8 - 12*f1*f5*f7 +
12*f1*f6^2)*z[4]*z[5]*z[9]*z[11] + (-8*f0*f6*f8 + 8*f0*f7^2 + 8*f1*f6*f7 +
8*f2*f5*f7 - 8*f2*f6^2 + 4*f3^2*f8 + 2*f3*f5*f6)*z[4]*z[5]*z[9]*z[12] +
(-8*f0*f6*f8 + 4*f0*f7^2 + 8*f1*f5*f8 - 6*f1*f6*f7)*z[4]*z[5]*z[9]*z[13] +
(-4*f1*f7^2 - 8*f2*f5*f8 + 4*f2*f6*f7 - 2*f3*f5*f7)*z[4]*z[5]*z[9]*z[14] +
(-16*f0*f8^2 - 4*f1*f7*f8 + 8*f2*f6*f8 - 4*f2*f7^2)*z[4]*z[5]*z[9]*z[15] +
(-2*f2*f8 - 2*f3*f7 + 2*f4*f6 - f5^2)*z[4]*z[5]*z[9]*z[16] + (4*f0*f6 +
2*f1*f5)*z[4]*z[5]*z[10]^2 + (-4*f0*f7 - 6*f1*f6)*z[4]*z[5]*z[10]*z[11] +
(-4*f1*f7 + 4*f2*f6 - 2*f3*f5)*z[4]*z[5]*z[10]*z[12] -
2*f1*f7*z[4]*z[5]*z[10]*z[13] + (4*f1*f8 + 4*f2*f7 +
2*f3*f6)*z[4]*z[5]*z[10]*z[14] + (-6*f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*z[4]*z[5]*z[10]*z[15] + 6*f1*f7*z[4]*z[5]*z[11]^2 + (4*f1*f8 -
4*f2*f7)*z[4]*z[5]*z[11]*z[12] - 4*f1*f8*z[4]*z[5]*z[11]*z[13] + (-2*f2*f8 -
2*f3*f7 - 2*f4*f6 + f5^2)*z[4]*z[5]*z[11]*z[14] + (4*f3*f8 + 8*f4*f7 -
2*f5*f6)*z[4]*z[5]*z[11]*z[15] + 2*f3*f7*z[4]*z[5]*z[12]^2 + (2*f2*f8 - 2*f3*f7 +
2*f4*f6 - f5^2)*z[4]*z[5]*z[12]*z[13] - 4*f3*f8*z[4]*z[5]*z[12]*z[14] + (-4*f5*f7
+ 4*f6^2)*z[4]*z[5]*z[12]*z[15] - 2*f6*z[4]*z[5]*z[12]*z[16] +
4*f3*f8*z[4]*z[5]*z[13]*z[14] - 8*f4*f8*z[4]*z[5]*z[13]*z[15] +
2*f6*z[4]*z[5]*z[13]*z[16] + (4*f5*f8 - 2*f6*f7)*z[4]*z[5]*z[14]*z[15] -
2*f7*z[4]*z[5]*z[14]*z[16] + (-4*f6*f8 + 2*f7^2)*z[4]*z[5]*z[15]^2 +
4*f8*z[4]*z[5]*z[15]*z[16] + (32*f0*f3*f8^2 - 8*f0*f5*f7^2 - 16*f1*f2*f8^2 +
12*f1*f3*f7*f8 - 16*f1*f4*f6*f8 + 8*f1*f4*f7^2 - 4*f1*f5*f6*f7 - 16*f2^2*f7*f8 +
16*f2*f3*f6*f8 - 8*f2*f3*f7^2 - 16*f2*f4*f5*f8 - 4*f2*f5^2*f7)*z[4]*z[6]*z[9]^2 +
(-16*f0*f5*f8 + 16*f0*f6*f7 - 4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f5*f6 +
4*f3^2*f7)*z[4]*z[6]*z[9]*z[10] + (-16*f0*f6*f8 + 16*f0*f7^2 + 8*f1*f5*f8 -
8*f1*f6*f7 + 16*f2*f4*f8 + 16*f2*f5*f7 - 16*f2*f6^2 - 8*f3^2*f8 -
8*f3*f4*f7)*z[4]*z[6]*z[9]*z[11] + (16*f1*f6*f8 - 16*f1*f7^2 - 8*f3*f4*f8 -
8*f3*f5*f7 + 8*f3*f6^2)*z[4]*z[6]*z[9]*z[12] + (-8*f0*f7*f8 + 8*f1*f6*f8 -
8*f2*f5*f8 + 8*f2*f6*f7 + 8*f3*f4*f8 + 2*f3*f5*f7)*z[4]*z[6]*z[9]*z[13] +
(-16*f0*f8^2 + 4*f3*f5*f8 - 4*f3*f6*f7)*z[4]*z[6]*z[9]*z[14] + (16*f2*f7*f8 -
16*f3*f6*f8 + 8*f3*f7^2 + 16*f4*f5*f8 + 4*f5^2*f7)*z[4]*z[6]*z[9]*z[15] -
4*f5*f6*z[4]*z[6]*z[9]*z[16] + (-8*f0*f7 - 4*f1*f6 - 4*f2*f5)*z[4]*z[6]*z[10]^2 +
(8*f0*f8 + 8*f1*f7 + 8*f2*f6 + 2*f3*f5)*z[4]*z[6]*z[10]*z[11] -
4*f3*f6*z[4]*z[6]*z[10]*z[12] + (-4*f1*f8 - 4*f3*f6)*z[4]*z[6]*z[10]*z[13] -
4*f3*f7*z[4]*z[6]*z[10]*z[14] + (4*f3*f8 - 4*f5*f6)*z[4]*z[6]*z[10]*z[15] +
4*f5*z[4]*z[6]*z[10]*z[16] + (-4*f1*f8 - 8*f2*f7)*z[4]*z[6]*z[11]^2 +
8*f3*f7*z[4]*z[6]*z[11]*z[12] + (8*f2*f8 + 4*f3*f7)*z[4]*z[6]*z[11]*z[13] +
(-8*f4*f8 - 8*f5*f7 + 8*f6^2)*z[4]*z[6]*z[11]*z[15] - 4*f6*z[4]*z[6]*z[11]*z[16] +
(-4*f3*f8 - 8*f4*f7 + 4*f5*f6)*z[4]*z[6]*z[12]^2 - 4*f3*f8*z[4]*z[6]*z[12]*z[13] +
(16*f4*f8 + 12*f5*f7 - 8*f6^2)*z[4]*z[6]*z[12]*z[14] -
8*f6*f7*z[4]*z[6]*z[12]*z[15] + 8*f7*z[4]*z[6]*z[12]*z[16] -
4*f3*f8*z[4]*z[6]*z[13]^2 + (4*f5*f8 - 4*f6*f7)*z[4]*z[6]*z[13]*z[15] + (-8*f5*f8
+ 4*f6*f7)*z[4]*z[6]*z[14]^2 + 8*f6*f8*z[4]*z[6]*z[14]*z[15] -
4*f8*z[4]*z[6]*z[14]*z[16] - 4*f7*f8*z[4]*z[6]*z[15]^2 + (32*f0*f4*f8^2 -
40*f1*f3*f8^2 - 8*f1*f4*f7*f8 + 4*f1*f5*f7^2 + 32*f2^2*f8^2 + 32*f2*f4*f6*f8 -
16*f2*f4*f7^2 - 8*f2*f5^2*f8 + 8*f2*f5*f6*f7 - 16*f3^2*f6*f8 + 8*f3^2*f7^2 +
8*f3*f4*f5*f8)*z[4]*z[7]*z[9]^2 + (16*f1*f5*f8 - 8*f1*f6*f7 - 16*f2*f4*f8 +
16*f2*f5*f7 - 16*f2*f6^2 + 8*f3^2*f8 - 8*f3*f4*f7)*z[4]*z[7]*z[9]*z[10] +
(8*f1*f6*f8 - 8*f1*f7^2 - 8*f2*f5*f8 - 16*f3*f5*f7 + 16*f3*f6^2 + 16*f4^2*f7 -
8*f4*f5*f6 + 2*f5^3)*z[4]*z[7]*z[9]*z[11] + (-16*f2*f6*f8 + 16*f2*f7^2 -
4*f3*f5*f8 + 8*f3*f6*f7 + 16*f4^2*f8 + 8*f4*f5*f7 - 16*f4*f6^2 +
4*f5^2*f6)*z[4]*z[7]*z[9]*z[12] + (-32*f0*f8^2 + 12*f1*f7*f8 - 16*f2*f6*f8 +
8*f2*f7^2 + 16*f3*f5*f8 - 8*f3*f6*f7 - 16*f4^2*f8)*z[4]*z[7]*z[9]*z[13] +
(32*f1*f8^2 - 16*f2*f7*f8 + 16*f3*f6*f8 - 12*f3*f7^2 - 16*f4*f5*f8 + 8*f4*f6*f7 -
2*f5^2*f7)*z[4]*z[7]*z[9]*z[14] + (-16*f2*f8^2 + 8*f3*f7*f8 - 16*f4*f6*f8 +
8*f4*f7^2 + 8*f5^2*f8 - 8*f5*f6*f7)*z[4]*z[7]*z[9]*z[15] + (-12*f5*f7 +
12*f6^2)*z[4]*z[7]*z[9]*z[16] + (4*f1*f7 + 8*f2*f6)*z[4]*z[7]*z[10]^2 + (-4*f1*f8
- 8*f2*f7 - 8*f3*f6)*z[4]*z[7]*z[10]*z[11] + (-4*f3*f7 + 8*f4*f6 -
2*f5^2)*z[4]*z[7]*z[10]*z[12] + (8*f2*f8 + 8*f4*f6 - 2*f5^2)*z[4]*z[7]*z[10]*z[13]
+ (-4*f3*f8 + 8*f4*f7)*z[4]*z[7]*z[10]*z[14] + (-4*f5*f7 +
4*f6^2)*z[4]*z[7]*z[10]*z[15] - 8*f6*z[4]*z[7]*z[10]*z[16] +
8*f3*f7*z[4]*z[7]*z[11]^2 + (8*f3*f8 - 8*f4*f7)*z[4]*z[7]*z[11]*z[12] + (-8*f3*f8
- 8*f4*f7)*z[4]*z[7]*z[11]*z[13] + (4*f5*f7 - 4*f6^2)*z[4]*z[7]*z[11]*z[14] +
(-4*f5*f8 + 8*f6*f7)*z[4]*z[7]*z[11]*z[15] + 4*f7*z[4]*z[7]*z[11]*z[16] +
(-8*f4*f8 + 4*f5*f7)*z[4]*z[7]*z[12]^2 + (-4*f5*f7 + 4*f6^2)*z[4]*z[7]*z[12]*z[13]
- 8*f6*f7*z[4]*z[7]*z[12]*z[14] + (8*f6*f8 - 8*f7^2)*z[4]*z[7]*z[12]*z[15] +
4*f8*z[4]*z[7]*z[12]*z[16] + 8*f4*f8*z[4]*z[7]*z[13]^2 -
4*f7^2*z[4]*z[7]*z[13]*z[15] - 4*f8*z[4]*z[7]*z[13]*z[16] +
4*f7^2*z[4]*z[7]*z[14]^2 + 4*f7*f8*z[4]*z[7]*z[14]*z[15] -
8*f8^2*z[4]*z[7]*z[15]^2 + (-4*f1*f5*f8 - 8*f2*f5*f7)*z[4]*z[8]*z[9]^2 + (-8*f0*f8
+ 8*f2*f6 + 2*f3*f5)*z[4]*z[8]*z[9]*z[10] + (4*f1*f8 + 8*f2*f7 -
8*f3*f6)*z[4]*z[8]*z[9]*z[11] + (-8*f3*f7 + 8*f4*f6 - 2*f5^2)*z[4]*z[8]*z[9]*z[12]
+ (-8*f2*f8 + 4*f3*f7)*z[4]*z[8]*z[9]*z[13] + (8*f3*f8 -
4*f4*f7)*z[4]*z[8]*z[9]*z[14] + 10*f5*f7*z[4]*z[8]*z[9]*z[15] -
6*f6*z[4]*z[8]*z[9]*z[16] - 4*f2*z[4]*z[8]*z[10]^2 + 4*f3*z[4]*z[8]*z[10]*z[11] -
4*f4*z[4]*z[8]*z[10]*z[12] - 4*f4*z[4]*z[8]*z[10]*z[13] -
2*f5*z[4]*z[8]*z[10]*z[14] - 2*f6*z[4]*z[8]*z[10]*z[15] + 4*z[4]*z[8]*z[10]*z[16]
+ 2*f5*z[4]*z[8]*z[11]*z[12] + 2*f5*z[4]*z[8]*z[11]*z[13] +
2*f6*z[4]*z[8]*z[11]*z[14] - 8*f7*z[4]*z[8]*z[11]*z[15] -
2*f6*z[4]*z[8]*z[12]*z[13] + 8*f7*z[4]*z[8]*z[12]*z[14] +
4*f8*z[4]*z[8]*z[12]*z[15] + 8*f8*z[4]*z[8]*z[13]*z[15] - 8*f8*z[4]*z[8]*z[14]^2 +
(8*f0*f3*f7*f8 + 8*f0*f5^2*f8)*z[5]^2*z[9]^2 - 4*f0*f5*f7*z[5]^2*z[9]*z[10] +
(-16*f0*f5*f8 + 8*f0*f6*f7)*z[5]^2*z[9]*z[11] + 16*f0*f6*f8*z[5]^2*z[9]*z[12] -
4*f0*f7^2*z[5]^2*z[9]*z[13] - 8*f0*f7*f8*z[5]^2*z[9]*z[14] -
4*f0*f7*z[5]^2*z[10]*z[11] - 8*f0*f8*z[5]^2*z[10]*z[12] -
8*f0*f8*z[5]^2*z[10]*z[13] + 4*f1*f8*z[5]^2*z[10]*z[14] + 8*f0*f8*z[5]^2*z[11]^2 -
4*f3*f8*z[5]^2*z[12]*z[14] + 8*f4*f8*z[5]^2*z[12]*z[15] -
4*f5*f8*z[5]^2*z[14]*z[15] + 2*f7*z[5]^2*z[14]*z[16] - 4*f8*z[5]^2*z[15]*z[16] +
(-16*f0*f3*f8^2 + 16*f0*f4*f7*f8 - 16*f0*f5*f6*f8 - 8*f1*f3*f7*f8 -
8*f1*f5^2*f8)*z[5]*z[6]*z[9]^2 + (8*f0*f6*f7 + 4*f1*f5*f7)*z[5]*z[6]*z[9]*z[10] +
(16*f0*f6*f8 - 8*f0*f7^2 + 16*f1*f5*f8 - 8*f1*f6*f7)*z[5]*z[6]*z[9]*z[11] +
(-16*f0*f7*f8 - 16*f1*f6*f8 - 8*f3*f4*f8)*z[5]*z[6]*z[9]*z[12] +
4*f1*f7^2*z[5]*z[6]*z[9]*z[13] + (16*f0*f8^2 + 8*f1*f7*f8 +
4*f3*f5*f8)*z[5]*z[6]*z[9]*z[14] + 4*f3*f8*z[5]*z[6]*z[9]*z[16] -
4*f0*f7*z[5]*z[6]*z[10]^2 + (8*f0*f8 + 4*f1*f7)*z[5]*z[6]*z[10]*z[11] +
8*f1*f8*z[5]*z[6]*z[10]*z[12] + 4*f1*f8*z[5]*z[6]*z[10]*z[13] + (-8*f2*f8 -
2*f3*f7)*z[5]*z[6]*z[10]*z[14] + 4*f3*f8*z[5]*z[6]*z[10]*z[15] -
8*f1*f8*z[5]*z[6]*z[11]^2 + 4*f3*f8*z[5]*z[6]*z[11]*z[14] -
8*f4*f8*z[5]*z[6]*z[11]*z[15] + 4*f3*f8*z[5]*z[6]*z[12]*z[13] +
4*f5*f8*z[5]*z[6]*z[13]*z[15] - 2*f7*z[5]*z[6]*z[13]*z[16] +
4*f8*z[5]*z[6]*z[14]*z[16] + (8*f1*f3*f8^2 - 8*f1*f4*f7*f8 +
8*f1*f5*f6*f8)*z[5]*z[7]*z[9]^2 + (4*f1*f5*f8 - 4*f1*f6*f7)*z[5]*z[7]*z[9]*z[10] +
(8*f0*f7*f8 - 16*f1*f6*f8 + 4*f1*f7^2)*z[5]*z[7]*z[9]*z[11] + (16*f0*f8^2 +
16*f2*f6*f8 - 12*f3*f5*f8 + 4*f3*f6*f7 + 16*f4^2*f8)*z[5]*z[7]*z[9]*z[12] +
(-16*f0*f8^2 + 4*f1*f7*f8)*z[5]*z[7]*z[9]*z[13] + (-8*f2*f7*f8 - 2*f3*f7^2 -
8*f4*f5*f8)*z[5]*z[7]*z[9]*z[14] + (8*f3*f7*f8 + 4*f5^2*f8)*z[5]*z[7]*z[9]*z[15] -
8*f4*f8*z[5]*z[7]*z[9]*z[16] + 2*f1*f7*z[5]*z[7]*z[10]^2 + (-8*f2*f8 -
2*f3*f7)*z[5]*z[7]*z[10]*z[12] + 4*f4*f7*z[5]*z[7]*z[10]*z[14] -
2*f5*f7*z[5]*z[7]*z[10]*z[15] + 8*f3*f8*z[5]*z[7]*z[11]*z[12] -
2*f5*f7*z[5]*z[7]*z[11]*z[14] + (-4*f5*f8 + 4*f6*f7)*z[5]*z[7]*z[11]*z[15] -
2*f7*z[5]*z[7]*z[11]*z[16] + (-8*f4*f8 + 4*f5*f7)*z[5]*z[7]*z[12]^2 -
8*f4*f8*z[5]*z[7]*z[12]*z[13] + (4*f5*f8 - 4*f6*f7)*z[5]*z[7]*z[12]*z[14] -
4*f7^2*z[5]*z[7]*z[12]*z[15] + 8*f8*z[5]*z[7]*z[12]*z[16] +
4*f5*f8*z[5]*z[7]*z[13]*z[14] - 2*f7^2*z[5]*z[7]*z[13]*z[15] +
2*f7^2*z[5]*z[7]*z[14]^2 + 4*f7*f8*z[5]*z[7]*z[14]*z[15] -
8*f8^2*z[5]*z[7]*z[15]^2 - 4*f1*f5*f8*z[5]*z[8]*z[9]^2 +
4*f1*f8*z[5]*z[8]*z[9]*z[11] + (-8*f4*f6 + 2*f5^2)*z[5]*z[8]*z[9]*z[12] +
4*f4*f7*z[5]*z[8]*z[9]*z[14] - 2*f5*f7*z[5]*z[8]*z[9]*z[15] +
2*f6*z[5]*z[8]*z[9]*z[16] + 4*f4*z[5]*z[8]*z[10]*z[12] -
2*f5*z[5]*z[8]*z[10]*z[14] + 2*f6*z[5]*z[8]*z[10]*z[15] - 2*z[5]*z[8]*z[10]*z[16]
- 2*f5*z[5]*z[8]*z[11]*z[12] + 2*f6*z[5]*z[8]*z[11]*z[14] +
2*f6*z[5]*z[8]*z[12]*z[13] - 4*f8*z[5]*z[8]*z[12]*z[15] -
2*f7*z[5]*z[8]*z[13]*z[14] + (-32*f0*f4*f8^2 + 16*f0*f5*f7*f8 + 8*f1*f3*f8^2 -
8*f1*f4*f7*f8 + 8*f1*f5*f6*f8 + 8*f2*f3*f7*f8 + 8*f2*f5^2*f8)*z[6]^2*z[9]^2 +
(-8*f0*f7^2 - 4*f1*f6*f7 - 4*f2*f5*f7 - 4*f3^2*f8)*z[6]^2*z[9]*z[10] +
(-16*f0*f7*f8 + 4*f1*f7^2 - 16*f2*f5*f8 + 8*f2*f6*f7 +
8*f3*f4*f8)*z[6]^2*z[9]*z[11] + (16*f1*f7*f8 + 8*f3*f5*f8 -
4*f3*f6*f7)*z[6]^2*z[9]*z[12] + (32*f0*f8^2 - 4*f1*f7*f8 - 4*f2*f7^2 -
4*f3*f5*f8)*z[6]^2*z[9]*z[13] + (-16*f1*f8^2 + 2*f3*f7^2)*z[6]^2*z[9]*z[14] +
(-8*f3*f7*f8 - 8*f5^2*f8)*z[6]^2*z[9]*z[15] + 2*f5*f7*z[6]^2*z[9]*z[16] + (8*f0*f8
+ 2*f1*f7)*z[6]^2*z[10]^2 + (-8*f1*f8 - 4*f2*f7)*z[6]^2*z[10]*z[11] +
2*f3*f7*z[6]^2*z[10]*z[12] + 2*f3*f7*z[6]^2*z[10]*z[13] +
4*f3*f8*z[6]^2*z[10]*z[14] + 2*f5*f7*z[6]^2*z[10]*z[15] + 8*f2*f8*z[6]^2*z[11]^2 -
8*f3*f8*z[6]^2*z[11]*z[12] - 4*f3*f8*z[6]^2*z[11]*z[13] + (8*f5*f8 -
4*f6*f7)*z[6]^2*z[11]*z[15] + 2*f7*z[6]^2*z[11]*z[16] + (8*f4*f8 -
4*f5*f7)*z[6]^2*z[12]^2 + (-8*f5*f8 + 4*f6*f7)*z[6]^2*z[12]*z[14] +
4*f7^2*z[6]^2*z[12]*z[15] - 8*f8*z[6]^2*z[12]*z[16] + 2*f7^2*z[6]^2*z[13]*z[15] -
2*f7^2*z[6]^2*z[14]^2 - 4*f7*f8*z[6]^2*z[14]*z[15] + 8*f8^2*z[6]^2*z[15]^2 +
(-16*f0*f5*f8^2 + 32*f1*f4*f8^2 - 12*f1*f5*f7*f8 - 16*f2*f3*f8^2 + 16*f2*f4*f7*f8
- 16*f2*f5*f6*f8 - 8*f3^2*f7*f8 - 4*f3*f5^2*f8)*z[6]*z[7]*z[9]^2 + (8*f0*f7*f8 -
8*f1*f6*f8 + 8*f1*f7^2 - 8*f2*f5*f8 + 8*f2*f6*f7 + 8*f3*f4*f8 +
2*f3*f5*f7)*z[6]*z[7]*z[9]*z[10] + (16*f0*f8^2 + 4*f1*f7*f8 + 16*f2*f6*f8 -
8*f2*f7^2 + 16*f3*f5*f8 - 8*f3*f6*f7 - 16*f4^2*f8)*z[6]*z[7]*z[9]*z[11] +
(-16*f1*f8^2 - 16*f2*f7*f8 - 8*f3*f6*f8 - 16*f4*f5*f8 + 8*f4*f6*f7 -
2*f5^2*f7)*z[6]*z[7]*z[9]*z[12] + (-16*f1*f8^2 + 4*f3*f7^2 +
8*f4*f5*f8)*z[6]*z[7]*z[9]*z[13] + (16*f2*f8^2 + 12*f3*f7*f8 - 4*f4*f7^2 +
8*f5^2*f8)*z[6]*z[7]*z[9]*z[14] + (-8*f4*f7*f8 + 8*f5*f6*f8 +
2*f5*f7^2)*z[6]*z[7]*z[9]*z[15] + (12*f5*f8 - 6*f6*f7)*z[6]*z[7]*z[9]*z[16] +
(-4*f1*f8 - 4*f2*f7)*z[6]*z[7]*z[10]^2 + (8*f2*f8 + 4*f3*f7)*z[6]*z[7]*z[10]*z[11]
+ (4*f3*f8 - 4*f4*f7)*z[6]*z[7]*z[10]*z[12] - 4*f4*f7*z[6]*z[7]*z[10]*z[13] +
(-8*f4*f8 - 2*f5*f7)*z[6]*z[7]*z[10]*z[14] + (4*f5*f8 -
2*f6*f7)*z[6]*z[7]*z[10]*z[15] + 4*f7*z[6]*z[7]*z[10]*z[16] -
8*f3*f8*z[6]*z[7]*z[11]^2 + (8*f4*f8 + 2*f5*f7)*z[6]*z[7]*z[11]*z[12] + (8*f4*f8 +
2*f5*f7)*z[6]*z[7]*z[11]*z[13] + (-4*f5*f8 + 2*f6*f7)*z[6]*z[7]*z[11]*z[14] -
8*f6*f8*z[6]*z[7]*z[11]*z[15] - 4*f8*z[6]*z[7]*z[11]*z[16] + (4*f5*f8 -
2*f6*f7)*z[6]*z[7]*z[12]*z[13] + 8*f6*f8*z[6]*z[7]*z[12]*z[14] +
4*f7*f8*z[6]*z[7]*z[12]*z[15] - 4*f5*f8*z[6]*z[7]*z[13]^2 +
4*f7*f8*z[6]*z[7]*z[13]*z[15] - 4*f7*f8*z[6]*z[7]*z[14]^2 + (8*f2*f5*f8 +
2*f3*f5*f7)*z[6]*z[8]*z[9]^2 + (4*f1*f8 - 4*f3*f6)*z[6]*z[8]*z[9]*z[10] +
(-8*f2*f8 + 8*f4*f6 - 2*f5^2)*z[6]*z[8]*z[9]*z[11] + (4*f3*f8 +
8*f4*f7)*z[6]*z[8]*z[9]*z[12] - 4*f4*f7*z[6]*z[8]*z[9]*z[13] + (-8*f4*f8 -
2*f5*f7)*z[6]*z[8]*z[9]*z[14] - 4*f5*f8*z[6]*z[8]*z[9]*z[15] -
2*f7*z[6]*z[8]*z[9]*z[16] + 2*f3*z[6]*z[8]*z[10]^2 - 4*f4*z[6]*z[8]*z[10]*z[11] -
2*f5*z[6]*z[8]*z[10]*z[12] + 2*f5*z[6]*z[8]*z[10]*z[13] +
4*f6*z[6]*z[8]*z[10]*z[14] - 2*f7*z[6]*z[8]*z[10]*z[15] + 2*f5*z[6]*z[8]*z[11]^2 -
4*f6*z[6]*z[8]*z[11]*z[13] - 2*f7*z[6]*z[8]*z[11]*z[14] +
4*f8*z[6]*z[8]*z[11]*z[15] - 2*f7*z[6]*z[8]*z[12]*z[13] -
4*f8*z[6]*z[8]*z[12]*z[14] + 2*f7*z[6]*z[8]*z[13]^2 + 4*f8*z[6]*z[8]*z[13]*z[14] +
(8*f1*f5*f8^2 - 32*f2*f4*f8^2 + 8*f2*f5*f7*f8 + 16*f3^2*f8^2 + 8*f3*f5*f6*f8 -
2*f3*f5*f7^2)*z[7]^2*z[9]^2 + (-4*f1*f7*f8 + 16*f2*f6*f8 - 8*f2*f7^2 -
8*f3*f5*f8)*z[7]^2*z[9]*z[10] + (-8*f1*f8^2 - 16*f3*f6*f8 + 8*f3*f7^2 +
8*f4*f5*f8)*z[7]^2*z[9]*z[11] + (16*f2*f8^2 + 4*f3*f7*f8 + 16*f4*f6*f8 -
8*f4*f7^2)*z[7]^2*z[9]*z[12] + (16*f2*f8^2 - 8*f3*f7*f8 -
4*f5^2*f8)*z[7]^2*z[9]*z[13] + (-24*f3*f8^2 + 8*f4*f7*f8 - 8*f5*f6*f8 +
2*f5*f7^2)*z[7]^2*z[9]*z[14] + (16*f4*f8^2 - 8*f5*f7*f8)*z[7]^2*z[9]*z[15] +
(-12*f6*f8 + 6*f7^2)*z[7]^2*z[9]*z[16] + 2*f5*f7*z[7]^2*z[10]*z[12] +
2*f5*f7*z[7]^2*z[10]*z[13] + 4*f5*f8*z[7]^2*z[10]*z[14] + (-4*f6*f8 +
2*f7^2)*z[7]^2*z[10]*z[15] - 2*f5*f7*z[7]^2*z[11]^2 - 4*f5*f8*z[7]^2*z[11]*z[12] +
(4*f6*f8 - 2*f7^2)*z[7]^2*z[11]*z[14] + 4*f7*f8*z[7]^2*z[11]*z[15] + (-4*f6*f8 +
2*f7^2)*z[7]^2*z[12]*z[13] - 4*f7*f8*z[7]^2*z[12]*z[14] -
8*f8^2*z[7]^2*z[12]*z[15] - 8*f8^2*z[7]^2*z[13]*z[15] + 8*f8^2*z[7]^2*z[14]^2 -
8*f3*f5*f8*z[7]*z[8]*z[9]^2 + (-8*f2*f8 + 4*f3*f7)*z[7]*z[8]*z[9]*z[10] + (8*f3*f8
- 8*f4*f7)*z[7]*z[8]*z[9]*z[11] - 16*f4*f8*z[7]*z[8]*z[9]*z[12] + (8*f4*f8 +
2*f5*f7)*z[7]*z[8]*z[9]*z[13] + 8*f5*f8*z[7]*z[8]*z[9]*z[14] +
8*f8*z[7]*z[8]*z[9]*z[16] + 2*f5*z[7]*z[8]*z[10]*z[11] -
4*f6*z[7]*z[8]*z[10]*z[13] - 4*f7*z[7]*z[8]*z[10]*z[14] +
4*f8*z[7]*z[8]*z[10]*z[15] + 4*f7*z[7]*z[8]*z[11]*z[13] +
4*f8*z[7]*z[8]*z[12]*z[13] - 4*f8*z[7]*z[8]*z[13]^2 + 2*z[8]^2*z[10]*z[13],

// Bmat[5,3]
  (128*f0^2*f3*f6*f8^2 - 32*f0^2*f3*f7^2*f8 - 128*f0^2*f4*f6*f7*f8 +
32*f0^2*f4*f7^3 + 32*f0^2*f5^2*f7*f8 - 128*f0*f1*f2*f6*f8^2 + 32*f0*f1*f2*f7^2*f8
- 32*f0*f1*f3*f5*f8^2 + 64*f0*f1*f3*f6*f7*f8 - 16*f0*f1*f3*f7^3 +
128*f0*f2^2*f5*f8^2 - 128*f0*f2^2*f6*f7*f8 + 32*f0*f2^2*f7^3 -
128*f0*f2*f3*f4*f8^2 + 32*f0*f2*f3*f5*f7*f8 - 128*f0*f2*f4*f5*f6*f8 +
32*f0*f2*f4*f5*f7^2 + 32*f0*f2*f5^3*f8 + 32*f0*f3^3*f8^2 + 32*f0*f3^2*f5*f6*f8 -
8*f0*f3^2*f5*f7^2 + 32*f1^3*f6*f8^2 - 8*f1^3*f7^2*f8 - 32*f1^2*f2*f5*f8^2 +
32*f1^2*f2*f6*f7*f8 - 8*f1^2*f2*f7^3 + 32*f1^2*f3*f4*f8^2 - 8*f1^2*f3*f5*f7*f8 +
32*f1^2*f4*f5*f6*f8 - 8*f1^2*f4*f5*f7^2 - 8*f1^2*f5^3*f8)*z[1]^2*z[9]^2 +
(-64*f0^2*f3*f8^2 + 64*f0^2*f4*f7*f8 - 16*f0^2*f5*f7^2 + 64*f0*f1*f2*f8^2 -
24*f0*f1*f3*f7*f8 + 32*f0*f2^2*f7*f8 + 32*f0*f2*f3*f6*f8 - 16*f0*f2*f3*f7^2 +
64*f0*f2*f4*f5*f8 - 16*f0*f2*f5^2*f7 - 24*f0*f3^2*f5*f8 - 16*f1^3*f8^2 -
8*f1^2*f2*f7*f8 - 8*f1^2*f3*f6*f8 + 4*f1^2*f3*f7^2 - 16*f1^2*f4*f5*f8 +
4*f1^2*f5^2*f7)*z[1]^2*z[9]*z[10] + (-16*f0^2*f5*f7*f8 + 16*f0*f1*f3*f8^2 -
16*f0*f1*f4*f7*f8 + 8*f0*f1*f5*f7^2 - 64*f0*f2^2*f8^2 + 64*f0*f2*f4*f6*f8 -
32*f0*f2*f4*f7^2 - 64*f0*f2*f5^2*f8 + 16*f0*f2*f5*f6*f7 - 32*f0*f3^2*f6*f8 +
16*f0*f3^2*f7^2 + 16*f0*f3*f4*f5*f8 + 4*f0*f3*f5^2*f7 + 16*f1^2*f2*f8^2 +
4*f1^2*f3*f7*f8 - 16*f1^2*f4*f6*f8 + 8*f1^2*f4*f7^2 + 16*f1^2*f5^2*f8 -
4*f1^2*f5*f6*f7)*z[1]^2*z[9]*z[11] + (32*f0^2*f5*f8^2 - 32*f0*f1*f4*f8^2 +
8*f0*f1*f5*f7*f8 + 32*f0*f2*f3*f8^2 - 32*f0*f2*f4*f7*f8 + 16*f0*f2*f5*f7^2 +
16*f0*f3^2*f7*f8 + 24*f0*f3*f5^2*f8 - 8*f0*f3*f5*f6*f7 + 16*f1^2*f4*f7*f8 -
8*f1^2*f5*f7^2 - 8*f1*f2*f3*f7*f8 + 8*f1*f3^2*f6*f8 - 4*f1*f3^2*f7^2 -
8*f1*f3*f4*f5*f8 - 2*f1*f3*f5^2*f7)*z[1]^2*z[9]*z[12] + (-32*f0^2*f5*f8^2 +
64*f0^2*f6*f7*f8 - 16*f0^2*f7^3 + 32*f0*f1*f4*f8^2 - 16*f0*f1*f5*f7*f8 +
32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 + 64*f0*f2*f5*f6*f8 - 24*f0*f2*f5*f7^2 -
16*f0*f3^2*f7*f8 - 16*f0*f3*f5^2*f8 - 16*f1^2*f3*f8^2 - 8*f1^2*f4*f7*f8 -
16*f1^2*f5*f6*f8 + 6*f1^2*f5*f7^2)*z[1]^2*z[9]*z[13] + (-64*f0^2*f6*f8^2 +
16*f0^2*f7^2*f8 + 32*f0*f1*f5*f8^2 - 32*f0*f1*f6*f7*f8 + 8*f0*f1*f7^3 +
64*f0*f2*f4*f8^2 - 32*f0*f2*f5*f7*f8 - 48*f0*f3^2*f8^2 - 32*f0*f3*f5*f6*f8 +
12*f0*f3*f5*f7^2 - 32*f1^2*f4*f8^2 + 16*f1^2*f5*f7*f8 + 16*f1*f2*f3*f8^2 +
4*f1*f3^2*f7*f8 + 8*f1*f3*f5^2*f8)*z[1]^2*z[9]*z[14] + (32*f0*f1*f6*f8^2 -
8*f0*f1*f7^2*f8 - 96*f0*f2*f5*f8^2 + 128*f0*f2*f6*f7*f8 - 32*f0*f2*f7^3 +
64*f0*f3*f4*f8^2 - 24*f0*f3*f5*f7*f8 + 64*f0*f4*f5*f6*f8 - 16*f0*f4*f5*f7^2 -
16*f0*f5^3*f8 + 16*f1^2*f5*f8^2 - 32*f1^2*f6*f7*f8 + 8*f1^2*f7^3 - 16*f1*f3^2*f8^2
- 16*f1*f3*f5*f6*f8 + 4*f1*f3*f5*f7^2)*z[1]^2*z[9]*z[15] + (-16*f0*f2*f7*f8 -
16*f0*f3*f6*f8 + 8*f0*f3*f7^2 - 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 + 4*f1^2*f7*f8 +
8*f1*f3*f5*f8)*z[1]^2*z[9]*z[16] + (-16*f0^2*f5*f8 + 16*f0^2*f6*f7 +
32*f0*f2*f4*f7 - 4*f0*f3^2*f7 - 8*f1^2*f4*f7)*z[1]^2*z[10]^2 + (-16*f0^2*f7^2 +
16*f0*f1*f5*f8 - 16*f0*f1*f6*f7 - 32*f0*f2*f4*f8 - 8*f0*f2*f5*f7 - 16*f0*f3*f4*f7
+ 8*f1^2*f4*f8 + 2*f1^2*f5*f7)*z[1]^2*z[10]*z[11] + (16*f0^2*f7*f8 + 8*f0*f1*f7^2
+ 32*f0*f2*f5*f8 - 32*f0*f2*f6*f7 + 12*f0*f3*f5*f7 - 16*f1^2*f5*f8 + 16*f1^2*f6*f7
+ 4*f1*f3^2*f8 + 8*f1*f3*f4*f7)*z[1]^2*z[10]*z[12] + (8*f0*f1*f7^2 -
32*f0*f2*f5*f8 + 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 + 8*f1^2*f5*f8)*z[1]^2*z[10]*z[13]
+ (-8*f0*f1*f7*f8 + 16*f0*f2*f7^2 + 8*f0*f3*f5*f8 - 8*f1^2*f7^2 - 8*f1*f3*f4*f8 -
2*f1*f3*f5*f7)*z[1]^2*z[10]*z[14] + (-32*f0*f2*f7*f8 - 16*f0*f4*f5*f8 +
4*f0*f5^2*f7 + 12*f1^2*f7*f8 + 8*f1*f3*f5*f8)*z[1]^2*z[10]*z[15] -
16*f0*f4*f7*z[1]^2*z[10]*z[16] + (16*f0^2*f7*f8 + 8*f0*f1*f7^2 + 16*f0*f2*f5*f8 +
16*f0*f2*f6*f7 + 16*f0*f3*f4*f8 - 8*f0*f3*f5*f7 + 16*f0*f4^2*f7 -
8*f1^2*f5*f8)*z[1]^2*z[11]^2 + (-32*f0^2*f8^2 - 24*f0*f1*f7*f8 - 40*f0*f3*f5*f8 +
16*f0*f3*f6*f7 - 16*f0*f4*f5*f7 - 8*f1^2*f7^2 + 16*f1*f2*f5*f8 - 16*f1*f2*f6*f7 -
16*f1*f3*f4*f8 + 8*f1*f3*f5*f7 - 16*f1*f4^2*f7)*z[1]^2*z[11]*z[12] +
(-16*f0*f1*f7*f8 - 16*f0*f2*f7^2 + 8*f0*f3*f5*f8 - 32*f0*f4^2*f8 -
8*f0*f4*f5*f7)*z[1]^2*z[11]*z[13] + (16*f0*f1*f8^2 - 8*f0*f3*f7^2 + 16*f0*f4*f5*f8
+ 4*f0*f5^2*f7 + 12*f1^2*f7*f8 + 8*f1*f2*f7^2 - 4*f1*f3*f5*f8 + 16*f1*f4^2*f8 +
4*f1*f4*f5*f7)*z[1]^2*z[11]*z[14] + (32*f0*f2*f8^2 + 16*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 16*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 16*f1^2*f8^2 -
8*f1*f2*f7*f8 + 8*f1*f3*f6*f8 - 4*f1*f3*f7^2 - 8*f1*f4*f5*f8 -
2*f1*f5^2*f7)*z[1]^2*z[11]*z[15] + (16*f0*f4*f8 + 4*f0*f5*f7 +
8*f1*f4*f7)*z[1]^2*z[11]*z[16] + (16*f0*f1*f8^2 - 8*f0*f3*f7^2 + 16*f0*f4*f5*f8 +
16*f0*f4*f6*f7 - 4*f0*f5^2*f7 + 8*f1^2*f7*f8 + 8*f1*f2*f7^2 + 12*f1*f3*f5*f8 -
16*f1*f3*f6*f7 + 8*f1*f4*f5*f7 - 16*f2^2*f5*f8 + 16*f2^2*f6*f7 + 16*f2*f3*f4*f8 -
8*f2*f3*f5*f7 + 16*f2*f4^2*f7 - 4*f3^3*f8 - 4*f3^2*f4*f7)*z[1]^2*z[12]^2 +
(16*f0*f1*f8^2 + 16*f0*f2*f7*f8 - 16*f0*f3*f6*f8 + 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 +
4*f1^2*f7*f8 + 8*f1*f2*f7^2 - 4*f1*f3*f5*f8 + 16*f1*f4^2*f8 +
4*f1*f4*f5*f7)*z[1]^2*z[12]*z[13] + (16*f0*f3*f7*f8 - 16*f0*f4*f7^2 -
16*f0*f5^2*f8 - 16*f1^2*f8^2 - 24*f1*f2*f7*f8 + 8*f1*f3*f6*f8 + 12*f1*f3*f7^2 -
16*f1*f4*f5*f8 - 4*f1*f5^2*f7 - 16*f2^2*f7^2 + 8*f2*f3*f5*f8 - 32*f2*f4^2*f8 -
8*f2*f4*f5*f7 + 8*f3^2*f4*f8 + 2*f3^2*f5*f7)*z[1]^2*z[12]*z[14] + (-32*f0*f3*f8^2
+ 8*f0*f5*f7^2 + 16*f1*f2*f8^2 - 12*f1*f3*f7*f8 + 16*f1*f4*f6*f8 - 8*f1*f4*f7^2 +
4*f1*f5*f6*f7 + 16*f2^2*f7*f8 - 16*f2*f3*f6*f8 + 8*f2*f3*f7^2 + 16*f2*f4*f5*f8 +
4*f2*f5^2*f7)*z[1]^2*z[12]*z[15] + (-16*f0*f5*f8 - 8*f1*f4*f8 - 2*f1*f5*f7 -
16*f2*f4*f7 + 4*f3^2*f7)*z[1]^2*z[12]*z[16] + (16*f0*f2*f7*f8 +
16*f0*f4*f5*f8)*z[1]^2*z[13]^2 + (-32*f0*f2*f8^2 + 8*f0*f3*f7*f8 - 16*f0*f5^2*f8 -
16*f1*f2*f7*f8 - 16*f1*f4*f5*f8)*z[1]^2*z[13]*z[14] + (-16*f0*f3*f8^2 -
16*f0*f4*f7*f8 + 4*f0*f5*f7^2 + 16*f1*f2*f8^2 + 4*f1*f3*f7*f8 +
8*f1*f5^2*f8)*z[1]^2*z[13]*z[15] + (-8*f1*f4*f8 - 2*f1*f5*f7)*z[1]^2*z[13]*z[16] +
(16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 - 4*f0*f5*f7^2 + 16*f1*f2*f8^2 - 12*f1*f3*f7*f8 +
8*f1*f5^2*f8 + 16*f2^2*f7*f8 + 16*f2*f4*f5*f8 - 4*f3^2*f5*f8)*z[1]^2*z[14]^2 +
(-16*f0*f5*f7*f8 + 16*f1*f3*f8^2 + 8*f1*f4*f7*f8 - 16*f1*f5*f6*f8 + 2*f1*f5*f7^2 -
32*f2^2*f8^2 - 8*f2*f3*f7*f8 - 16*f2*f5^2*f8)*z[1]^2*z[14]*z[15] + (8*f1*f5*f8 +
16*f2*f4*f8 + 4*f2*f5*f7 - 4*f3^2*f8)*z[1]^2*z[14]*z[16] + (16*f0*f5*f8^2 -
16*f1*f4*f8^2 + 4*f1*f5*f7*f8 + 16*f2*f3*f8^2 + 16*f2*f5*f6*f8 -
4*f2*f5*f7^2)*z[1]^2*z[15]^2 - 16*f2*f5*f8*z[1]^2*z[15]*z[16] + (-64*f0^2*f3*f8^2
+ 64*f0^2*f4*f7*f8 - 16*f0^2*f5*f7^2 + 64*f0*f1*f2*f8^2 - 24*f0*f1*f3*f7*f8 +
32*f0*f2^2*f7*f8 + 32*f0*f2*f3*f6*f8 - 16*f0*f2*f3*f7^2 + 64*f0*f2*f4*f5*f8 -
16*f0*f2*f5^2*f7 - 24*f0*f3^2*f5*f8 - 16*f1^3*f8^2 - 8*f1^2*f2*f7*f8 -
8*f1^2*f3*f6*f8 + 4*f1^2*f3*f7^2 - 16*f1^2*f4*f5*f8 +
4*f1^2*f5^2*f7)*z[1]*z[2]*z[9]^2 + (32*f0^2*f5*f8 - 32*f0*f2*f3*f8 -
64*f0*f2*f4*f7 + 32*f0*f2*f5*f6 + 16*f0*f3^2*f7 + 8*f1^2*f3*f8 + 16*f1^2*f4*f7 -
8*f1^2*f5*f6)*z[1]*z[2]*z[9]*z[10] + (-32*f0^2*f6*f8 + 32*f0^2*f7^2 -
8*f0*f1*f5*f8 + 48*f0*f2*f5*f7 - 32*f0*f2*f6^2 + 16*f0*f3^2*f8 - 8*f0*f3*f5*f6 -
12*f1^2*f5*f7 + 8*f1^2*f6^2)*z[1]*z[2]*z[9]*z[11] + (-32*f0^2*f7*f8 +
16*f0*f1*f6*f8 - 16*f0*f1*f7^2 - 16*f0*f2*f5*f8 - 16*f0*f3*f4*f8 - 24*f0*f3*f5*f7
+ 16*f0*f3*f6^2 + 8*f1^2*f5*f8 - 4*f1*f3^2*f8 +
4*f1*f3*f5*f6)*z[1]*z[2]*z[9]*z[12] + (-48*f0^2*f7*f8 - 64*f0*f2*f5*f8 +
16*f0*f2*f6*f7 + 8*f0*f3*f5*f7 + 16*f1^2*f5*f8 -
4*f1^2*f6*f7)*z[1]*z[2]*z[9]*z[13] + (64*f0^2*f8^2 + 24*f0*f1*f7*f8 +
48*f0*f3*f5*f8 - 8*f0*f3*f6*f7 - 4*f1*f3*f5*f7)*z[1]*z[2]*z[9]*z[14] +
(-32*f0*f1*f8^2 - 32*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 - 32*f0*f4*f5*f8
+ 8*f0*f5^2*f7 + 8*f1^2*f7*f8 + 8*f1*f3*f5*f8)*z[1]*z[2]*z[9]*z[15] + (16*f0*f3*f8
+ 16*f0*f4*f7 - 8*f0*f5*f6 - 4*f1*f3*f7)*z[1]*z[2]*z[9]*z[16] + (-16*f0^2*f7 -
16*f0*f2*f5 + 4*f1^2*f5)*z[1]*z[2]*z[10]^2 + (16*f0^2*f8 + 16*f0*f1*f7 +
16*f0*f2*f6 + 8*f0*f3*f5 - 4*f1^2*f6)*z[1]*z[2]*z[10]*z[11] + (-8*f0*f1*f8 +
32*f0*f2*f7 - 8*f0*f3*f6 - 16*f1^2*f7 - 4*f1*f3*f5)*z[1]*z[2]*z[10]*z[12] +
(-8*f0*f1*f8 + 16*f0*f2*f7 - 8*f0*f3*f6 - 4*f1^2*f7)*z[1]*z[2]*z[10]*z[13] +
(-16*f0*f2*f8 - 8*f0*f3*f7 + 8*f1^2*f8 + 4*f1*f3*f6)*z[1]*z[2]*z[10]*z[14] +
(8*f0*f3*f8 + 16*f0*f4*f7 - 8*f0*f5*f6 - 4*f1*f3*f7)*z[1]*z[2]*z[10]*z[15] +
8*f0*f5*z[1]*z[2]*z[10]*z[16] + (-8*f0*f1*f8 - 32*f0*f2*f7 - 8*f0*f4*f5 +
4*f1^2*f7)*z[1]*z[2]*z[11]^2 + (8*f0*f5^2 + 8*f1^2*f8 + 16*f1*f2*f7 +
8*f1*f4*f5)*z[1]*z[2]*z[11]*z[12] + (16*f0*f2*f8 + 8*f0*f3*f7 +
16*f0*f4*f6)*z[1]*z[2]*z[11]*z[13] + (-8*f0*f5*f6 - 8*f1*f2*f8 - 4*f1*f3*f7 -
8*f1*f4*f6)*z[1]*z[2]*z[11]*z[14] + (-16*f0*f5*f7 + 16*f0*f6^2 +
4*f1*f5*f6)*z[1]*z[2]*z[11]*z[15] + (-8*f0*f6 - 4*f1*f5)*z[1]*z[2]*z[11]*z[16] +
(8*f0*f3*f8 - 16*f0*f4*f7 - 8*f1*f2*f8 + 12*f1*f3*f7 - 4*f1*f5^2 - 16*f2^2*f7 -
8*f2*f4*f5 + 2*f3^2*f5)*z[1]*z[2]*z[12]^2 + (8*f0*f3*f8 - 8*f0*f5*f6 - 8*f1*f2*f8
- 4*f1*f3*f7 - 8*f1*f4*f6)*z[1]*z[2]*z[12]*z[13] + (16*f0*f5*f7 - 8*f1*f3*f8 +
8*f1*f5*f6 + 16*f2^2*f8 + 8*f2*f3*f7 + 16*f2*f4*f6 -
4*f3^2*f6)*z[1]*z[2]*z[12]*z[14] + (16*f0*f5*f8 - 16*f0*f6*f7 + 4*f1*f5*f7 -
8*f1*f6^2 - 8*f2*f5*f6 - 4*f3^2*f7)*z[1]*z[2]*z[12]*z[15] + (8*f0*f7 + 4*f1*f6 +
8*f2*f5)*z[1]*z[2]*z[12]*z[16] + (-8*f0*f3*f8 - 8*f0*f4*f7)*z[1]*z[2]*z[13]^2 +
(8*f0*f5*f7 + 8*f1*f3*f8 + 8*f1*f4*f7)*z[1]*z[2]*z[13]*z[14] + (16*f0*f5*f8 -
8*f0*f6*f7 - 4*f1*f5*f7)*z[1]*z[2]*z[13]*z[15] + 4*f1*f6*z[1]*z[2]*z[13]*z[16] +
(-16*f0*f5*f8 - 4*f1*f5*f7 - 8*f2*f3*f8 - 8*f2*f4*f7 +
2*f3^2*f7)*z[1]*z[2]*z[14]^2 + (8*f0*f7^2 + 4*f1*f6*f7 + 8*f2*f5*f7 +
4*f3^2*f8)*z[1]*z[2]*z[14]*z[15] + (-4*f1*f7 - 8*f2*f6)*z[1]*z[2]*z[14]*z[16] +
(-8*f0*f7*f8 + 8*f1*f6*f8 - 4*f1*f7^2 - 8*f2*f5*f8)*z[1]*z[2]*z[15]^2 +
8*f2*f7*z[1]*z[2]*z[15]*z[16] + (-16*f0^2*f5*f7*f8 + 16*f0*f1*f3*f8^2 -
16*f0*f1*f4*f7*f8 + 8*f0*f1*f5*f7^2 - 64*f0*f2^2*f8^2 + 64*f0*f2*f4*f6*f8 -
32*f0*f2*f4*f7^2 - 64*f0*f2*f5^2*f8 + 16*f0*f2*f5*f6*f7 - 32*f0*f3^2*f6*f8 +
16*f0*f3^2*f7^2 + 16*f0*f3*f4*f5*f8 + 4*f0*f3*f5^2*f7 + 16*f1^2*f2*f8^2 +
4*f1^2*f3*f7*f8 - 16*f1^2*f4*f6*f8 + 8*f1^2*f4*f7^2 + 16*f1^2*f5^2*f8 -
4*f1^2*f5*f6*f7)*z[1]*z[3]*z[9]^2 + (-32*f0^2*f6*f8 + 32*f0^2*f7^2 - 8*f0*f1*f5*f8
+ 48*f0*f2*f5*f7 - 32*f0*f2*f6^2 + 16*f0*f3^2*f8 - 8*f0*f3*f5*f6 - 12*f1^2*f5*f7 +
8*f1^2*f6^2)*z[1]*z[3]*z[9]*z[10] + (-32*f0^2*f7*f8 + 32*f0*f1*f6*f8 -
32*f0*f1*f7^2 + 64*f0*f2*f5*f8 - 32*f0*f2*f6*f7 - 32*f0*f3*f4*f8 - 32*f0*f3*f5*f7
+ 32*f0*f3*f6^2 - 16*f1^2*f5*f8 + 8*f1^2*f6*f7)*z[1]*z[3]*z[9]*z[11] +
(32*f0*f1*f7*f8 - 24*f0*f3*f5*f8 + 16*f0*f3*f6*f7 + 32*f0*f4^2*f8 + 32*f0*f4*f5*f7
- 32*f0*f4*f6^2 + 8*f0*f5^2*f6 - 16*f1^2*f6*f8 + 16*f1^2*f7^2 + 8*f1*f3*f4*f8 +
8*f1*f3*f5*f7 - 8*f1*f3*f6^2)*z[1]*z[3]*z[9]*z[12] + (32*f0^2*f8^2 +
32*f0*f1*f7*f8 - 32*f0*f2*f6*f8 + 32*f0*f2*f7^2 + 32*f0*f3*f5*f8 - 16*f0*f3*f6*f7
+ 8*f1^2*f6*f8 - 8*f1^2*f7^2)*z[1]*z[3]*z[9]*z[13] + (-48*f0*f1*f8^2 +
16*f0*f3*f6*f8 - 16*f0*f3*f7^2 - 48*f0*f4*f5*f8 + 16*f0*f4*f6*f7 - 8*f0*f5^2*f7 -
16*f1^2*f7*f8 - 12*f1*f3*f5*f8 + 4*f1*f3*f6*f7)*z[1]*z[3]*z[9]*z[14] +
(64*f0*f2*f8^2 + 40*f0*f5^2*f8 - 8*f0*f5*f6*f7 + 16*f1*f3*f6*f8 -
8*f1*f3*f7^2)*z[1]*z[3]*z[9]*z[15] + (-16*f0*f4*f8 - 24*f0*f5*f7 + 16*f0*f6^2 -
4*f1*f3*f8)*z[1]*z[3]*z[9]*z[16] + (16*f0^2*f8 + 16*f0*f2*f6 + 4*f0*f3*f5 -
4*f1^2*f6)*z[1]*z[3]*z[10]^2 + (-16*f0*f1*f8 - 16*f0*f3*f6)*z[1]*z[3]*z[10]*z[11]
+ (-32*f0*f2*f8 - 16*f0*f3*f7 + 16*f0*f4*f6 - 8*f0*f5^2 + 16*f1^2*f8 +
4*f1*f3*f6)*z[1]*z[3]*z[10]*z[12] + (16*f0*f2*f8 - 8*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[3]*z[10]*z[13] + (8*f0*f3*f8 + 8*f0*f5*f6 +
4*f1*f3*f7)*z[1]*z[3]*z[10]*z[14] + (-8*f0*f5*f7 -
8*f1*f3*f8)*z[1]*z[3]*z[10]*z[15] - 8*f0*f6*z[1]*z[3]*z[10]*z[16] + (16*f0*f3*f7 +
4*f0*f5^2 + 4*f1^2*f8)*z[1]*z[3]*z[11]^2 + (32*f0*f3*f8 - 8*f0*f5*f6 - 16*f1*f2*f8
- 8*f1*f3*f7 - 4*f1*f5^2)*z[1]*z[3]*z[11]*z[12] + (-16*f0*f3*f8 -
8*f0*f5*f6)*z[1]*z[3]*z[11]*z[13] + (4*f1*f3*f8 +
4*f1*f5*f6)*z[1]*z[3]*z[11]*z[14] + (-24*f0*f5*f8 + 16*f0*f6*f7 + 8*f1*f4*f8 +
8*f1*f5*f7 - 8*f1*f6^2)*z[1]*z[3]*z[11]*z[15] + 4*f1*f6*z[1]*z[3]*z[11]*z[16] +
(-16*f0*f4*f8 + 16*f0*f5*f7 - 12*f1*f3*f8 - 8*f1*f4*f7 + 4*f1*f5*f6 + 16*f2^2*f8 +
8*f2*f3*f7 + 4*f2*f5^2)*z[1]*z[3]*z[12]^2 + (-16*f0*f4*f8 - 16*f0*f5*f7 +
16*f0*f6^2 + 8*f1*f3*f8 + 4*f1*f5*f6)*z[1]*z[3]*z[12]*z[13] + (8*f0*f5*f8 -
16*f0*f6*f7 + 16*f1*f4*f8 + 4*f1*f5*f7 - 8*f1*f6^2 - 16*f2*f3*f8 - 8*f2*f5*f6 -
4*f3^2*f7)*z[1]*z[3]*z[12]*z[14] + (16*f0*f6*f8 - 16*f0*f7^2 - 8*f1*f5*f8 +
8*f1*f6*f7 - 16*f2*f4*f8 - 16*f2*f5*f7 + 16*f2*f6^2 + 8*f3^2*f8 +
8*f3*f4*f7)*z[1]*z[3]*z[12]*z[15] + (8*f0*f8 - 8*f2*f6 -
2*f3*f5)*z[1]*z[3]*z[12]*z[16] + 4*f0*f5*f7*z[1]*z[3]*z[13]^2 + (24*f0*f5*f8 -
8*f0*f6*f7 - 4*f1*f5*f7)*z[1]*z[3]*z[13]*z[14] + (-16*f0*f6*f8 - 12*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[3]*z[13]*z[15] + (8*f0*f7^2 - 8*f1*f5*f8 + 4*f1*f6*f7 +
4*f2*f5*f7 + 4*f3^2*f8)*z[1]*z[3]*z[14]^2 + (8*f0*f7*f8 + 8*f1*f6*f8 - 8*f1*f7^2 +
24*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[1]*z[3]*z[14]*z[15] +
(-4*f1*f8 + 4*f3*f6)*z[1]*z[3]*z[14]*z[16] + (-16*f0*f8^2 + 4*f1*f7*f8 -
16*f2*f6*f8 + 8*f2*f7^2)*z[1]*z[3]*z[15]^2 + (8*f2*f8 -
4*f3*f7)*z[1]*z[3]*z[15]*z[16] + (32*f0^2*f5*f8^2 - 32*f0*f1*f4*f8^2 +
8*f0*f1*f5*f7*f8 + 32*f0*f2*f3*f8^2 - 32*f0*f2*f4*f7*f8 + 16*f0*f2*f5*f7^2 +
16*f0*f3^2*f7*f8 + 24*f0*f3*f5^2*f8 - 8*f0*f3*f5*f6*f7 + 16*f1^2*f4*f7*f8 -
8*f1^2*f5*f7^2 - 8*f1*f2*f3*f7*f8 + 8*f1*f3^2*f6*f8 - 4*f1*f3^2*f7^2 -
8*f1*f3*f4*f5*f8 - 2*f1*f3*f5^2*f7)*z[1]*z[4]*z[9]^2 + (-32*f0^2*f7*f8 +
16*f0*f1*f6*f8 - 16*f0*f1*f7^2 - 16*f0*f2*f5*f8 - 16*f0*f3*f4*f8 - 24*f0*f3*f5*f7
+ 16*f0*f3*f6^2 + 8*f1^2*f5*f8 - 4*f1*f3^2*f8 +
4*f1*f3*f5*f6)*z[1]*z[4]*z[9]*z[10] + (32*f0*f1*f7*f8 - 24*f0*f3*f5*f8 +
16*f0*f3*f6*f7 + 32*f0*f4^2*f8 + 32*f0*f4*f5*f7 - 32*f0*f4*f6^2 + 8*f0*f5^2*f6 -
16*f1^2*f6*f8 + 16*f1^2*f7^2 + 8*f1*f3*f4*f8 + 8*f1*f3*f5*f7 -
8*f1*f3*f6^2)*z[1]*z[4]*z[9]*z[11] + (32*f0*f2*f7*f8 - 32*f0*f3*f6*f8 +
32*f0*f3*f7^2 + 32*f0*f4*f5*f8 - 32*f0*f4*f6*f7 - 32*f1^2*f7*f8 + 32*f1*f2*f6*f8 -
32*f1*f2*f7^2 - 32*f1*f4^2*f8 - 32*f1*f4*f5*f7 + 32*f1*f4*f6^2 -
8*f1*f5^2*f6)*z[1]*z[4]*z[9]*z[12] + (-16*f0*f1*f8^2 + 16*f0*f3*f6*f8 -
16*f0*f3*f7^2 - 48*f0*f4*f5*f8 + 16*f0*f4*f6*f7 - 8*f0*f5^2*f7 - 16*f1^2*f7*f8 -
4*f1*f3*f5*f8 + 4*f1*f3*f6*f7)*z[1]*z[4]*z[9]*z[13] + (-32*f0*f2*f8^2 -
40*f0*f3*f7*f8 + 32*f0*f4*f6*f8 - 16*f0*f5^2*f8 + 8*f0*f5*f6*f7 + 32*f1^2*f8^2 +
32*f1*f2*f7*f8 - 16*f1*f3*f6*f8 + 8*f1*f3*f7^2 + 48*f1*f4*f5*f8 - 16*f1*f4*f6*f7 +
8*f1*f5^2*f7)*z[1]*z[4]*z[9]*z[14] + (16*f0*f3*f8^2 + 16*f0*f4*f7*f8 -
16*f0*f5*f7^2 - 32*f1*f2*f8^2 - 32*f1*f4*f6*f8 + 16*f1*f4*f7^2 -
8*f1*f5^2*f8)*z[1]*z[4]*z[9]*z[15] + (-8*f0*f5*f8 + 8*f0*f6*f7 + 16*f1*f4*f8 +
12*f1*f5*f7 - 8*f1*f6^2)*z[1]*z[4]*z[9]*z[16] + (-8*f0*f3*f6 -
2*f1*f3*f5)*z[1]*z[4]*z[10]^2 + (16*f0*f4*f6 - 8*f0*f5^2 +
4*f1*f3*f6)*z[1]*z[4]*z[10]*z[11] + (8*f0*f3*f8 + 8*f0*f5*f6 + 8*f1*f3*f7 -
16*f1*f4*f6 + 8*f1*f5^2)*z[1]*z[4]*z[10]*z[12] + (8*f0*f5*f6 +
4*f1*f3*f7)*z[1]*z[4]*z[10]*z[13] + (16*f0*f4*f8 + 16*f0*f5*f7 - 16*f0*f6^2 -
8*f1*f3*f8 - 8*f1*f5*f6 - 8*f2*f3*f7)*z[1]*z[4]*z[10]*z[14] + (-8*f0*f5*f8 +
8*f0*f6*f7 - 4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 +
4*f3^2*f7)*z[1]*z[4]*z[10]*z[15] + (-16*f0*f4*f7 - 4*f1*f3*f7)*z[1]*z[4]*z[11]^2 +
(-16*f0*f4*f8 + 16*f1*f4*f7)*z[1]*z[4]*z[11]*z[12] + (16*f0*f4*f8 -
8*f0*f5*f7)*z[1]*z[4]*z[11]*z[13] + (-8*f0*f5*f8 + 8*f0*f6*f7 - 16*f1*f4*f8 -
4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 + 4*f3^2*f7)*z[1]*z[4]*z[11]*z[14] +
(16*f1*f5*f8 - 16*f1*f6*f7 - 8*f3^2*f8 - 8*f3*f4*f7)*z[1]*z[4]*z[11]*z[15] +
2*f3*f5*z[1]*z[4]*z[11]*z[16] + (-8*f0*f5*f8 + 16*f1*f4*f8 - 8*f1*f5*f7 -
8*f2*f3*f8 - 4*f3^2*f7 - 2*f3*f5^2)*z[1]*z[4]*z[12]^2 + (-8*f0*f5*f8 + 8*f0*f6*f7
+ 12*f1*f5*f7 - 8*f1*f6^2)*z[1]*z[4]*z[12]*z[13] + (16*f0*f6*f8 - 16*f0*f7^2 +
8*f1*f5*f8 + 4*f3^2*f8 + 4*f3*f5*f6)*z[1]*z[4]*z[12]*z[14] + (-16*f1*f6*f8 +
16*f1*f7^2 + 8*f3*f4*f8 + 8*f3*f5*f7 - 8*f3*f6^2)*z[1]*z[4]*z[12]*z[15] +
4*f3*f6*z[1]*z[4]*z[12]*z[16] + 8*f0*f5*f8*z[1]*z[4]*z[13]^2 + (-16*f0*f6*f8 -
8*f1*f5*f8 - 4*f3^2*f8)*z[1]*z[4]*z[13]*z[14] + (16*f1*f6*f8 + 8*f3*f4*f8 +
2*f3*f5*f7)*z[1]*z[4]*z[13]*z[15] - 4*f3*f6*z[1]*z[4]*z[13]*z[16] + (16*f0*f7*f8 -
2*f3*f5*f7)*z[1]*z[4]*z[14]^2 + (-16*f0*f8^2 - 16*f1*f7*f8 - 12*f3*f5*f8 +
4*f3*f6*f7)*z[1]*z[4]*z[14]*z[15] + 4*f3*f7*z[1]*z[4]*z[14]*z[16] + (16*f1*f8^2 +
8*f3*f6*f8 - 4*f3*f7^2)*z[1]*z[4]*z[15]^2 - 8*f3*f8*z[1]*z[4]*z[15]*z[16] +
(-32*f0^2*f5*f8^2 + 64*f0^2*f6*f7*f8 - 16*f0^2*f7^3 + 32*f0*f1*f4*f8^2 -
16*f0*f1*f5*f7*f8 + 32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 + 64*f0*f2*f5*f6*f8 -
24*f0*f2*f5*f7^2 - 16*f0*f3^2*f7*f8 - 16*f0*f3*f5^2*f8 - 16*f1^2*f3*f8^2 -
8*f1^2*f4*f7*f8 - 16*f1^2*f5*f6*f8 + 6*f1^2*f5*f7^2)*z[1]*z[5]*z[9]^2 +
(-48*f0^2*f7*f8 - 64*f0*f2*f5*f8 + 16*f0*f2*f6*f7 + 8*f0*f3*f5*f7 + 16*f1^2*f5*f8
- 4*f1^2*f6*f7)*z[1]*z[5]*z[9]*z[10] + (32*f0^2*f8^2 + 32*f0*f1*f7*f8 -
32*f0*f2*f6*f8 + 32*f0*f2*f7^2 + 32*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 8*f1^2*f6*f8 -
8*f1^2*f7^2)*z[1]*z[5]*z[9]*z[11] + (-16*f0*f1*f8^2 + 16*f0*f3*f6*f8 -
16*f0*f3*f7^2 - 48*f0*f4*f5*f8 + 16*f0*f4*f6*f7 - 8*f0*f5^2*f7 - 16*f1^2*f7*f8 -
4*f1*f3*f5*f8 + 4*f1*f3*f6*f7)*z[1]*z[5]*z[9]*z[12] + (-32*f0*f1*f8^2 -
64*f0*f2*f7*f8 + 8*f0*f3*f7^2 + 16*f1^2*f7*f8)*z[1]*z[5]*z[9]*z[13] +
(32*f0*f3*f7*f8 - 8*f0*f4*f7^2 + 32*f0*f5^2*f8 + 16*f1^2*f8^2 -
2*f1*f3*f7^2)*z[1]*z[5]*z[9]*z[14] + (-32*f0*f3*f8^2 - 64*f0*f5*f6*f8 +
20*f0*f5*f7^2 + 8*f1*f3*f7*f8)*z[1]*z[5]*z[9]*z[15] + (40*f0*f5*f8 -
8*f0*f6*f7)*z[1]*z[5]*z[9]*z[16] + (-24*f0*f2*f7 + 6*f1^2*f7)*z[1]*z[5]*z[10]^2 +
(16*f0*f2*f8 + 16*f0*f3*f7 - 4*f1^2*f8)*z[1]*z[5]*z[10]*z[11] + (8*f0*f4*f7 -
10*f1*f3*f7)*z[1]*z[5]*z[10]*z[12] + (-16*f0*f4*f8 - 8*f0*f5*f7 +
4*f1*f3*f8)*z[1]*z[5]*z[10]*z[14] + 24*f0*f5*f8*z[1]*z[5]*z[10]*z[15] +
12*f0*f7*z[1]*z[5]*z[10]*z[16] + (-16*f0*f3*f8 - 16*f0*f4*f7)*z[1]*z[5]*z[11]^2 +
(12*f0*f5*f7 + 12*f1*f3*f8 + 16*f1*f4*f7)*z[1]*z[5]*z[11]*z[12] + (32*f0*f4*f8 +
8*f0*f5*f7)*z[1]*z[5]*z[11]*z[13] + (-8*f0*f5*f8 - 16*f1*f4*f8 -
4*f1*f5*f7)*z[1]*z[5]*z[11]*z[14] + (16*f0*f6*f8 - 16*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[5]*z[11]*z[15] + (-8*f0*f8 - 6*f1*f7)*z[1]*z[5]*z[11]*z[16] +
(-16*f0*f6*f7 - 2*f1*f5*f7 - 8*f2*f3*f8 - 16*f2*f4*f7 +
4*f3^2*f7)*z[1]*z[5]*z[12]^2 + (8*f0*f5*f8 - 8*f0*f6*f7 - 16*f1*f4*f8 -
4*f1*f5*f7)*z[1]*z[5]*z[12]*z[13] + (24*f0*f7^2 + 4*f1*f6*f7 + 32*f2*f4*f8 +
8*f2*f5*f7 - 4*f3^2*f8)*z[1]*z[5]*z[12]*z[14] + (8*f0*f7*f8 - 8*f1*f6*f8 +
8*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[1]*z[5]*z[12]*z[15] +
(4*f1*f8 + 12*f2*f7)*z[1]*z[5]*z[12]*z[16] - 16*f0*f5*f8*z[1]*z[5]*z[13]^2 +
(4*f0*f7^2 + 16*f1*f5*f8)*z[1]*z[5]*z[13]*z[14] + (16*f0*f7*f8 -
2*f1*f7^2)*z[1]*z[5]*z[13]*z[15] + 4*f1*f8*z[1]*z[5]*z[13]*z[16] + (-32*f0*f7*f8 -
2*f1*f7^2 - 16*f2*f5*f8)*z[1]*z[5]*z[14]^2 + (16*f0*f8^2 + 8*f1*f7*f8 + 4*f2*f7^2
+ 8*f3*f5*f8)*z[1]*z[5]*z[14]*z[15] + (-8*f2*f8 - 2*f3*f7)*z[1]*z[5]*z[14]*z[16] -
8*f2*f7*f8*z[1]*z[5]*z[15]^2 + 4*f3*f8*z[1]*z[5]*z[15]*z[16] + (-64*f0^2*f6*f8^2 +
16*f0^2*f7^2*f8 + 32*f0*f1*f5*f8^2 - 32*f0*f1*f6*f7*f8 + 8*f0*f1*f7^3 +
64*f0*f2*f4*f8^2 - 32*f0*f2*f5*f7*f8 - 48*f0*f3^2*f8^2 - 32*f0*f3*f5*f6*f8 +
12*f0*f3*f5*f7^2 - 32*f1^2*f4*f8^2 + 16*f1^2*f5*f7*f8 + 16*f1*f2*f3*f8^2 +
4*f1*f3^2*f7*f8 + 8*f1*f3*f5^2*f8)*z[1]*z[6]*z[9]^2 + (64*f0^2*f8^2 +
24*f0*f1*f7*f8 + 48*f0*f3*f5*f8 - 8*f0*f3*f6*f7 -
4*f1*f3*f5*f7)*z[1]*z[6]*z[9]*z[10] + (-48*f0*f1*f8^2 + 16*f0*f3*f6*f8 -
16*f0*f3*f7^2 - 48*f0*f4*f5*f8 + 16*f0*f4*f6*f7 - 8*f0*f5^2*f7 - 16*f1^2*f7*f8 -
12*f1*f3*f5*f8 + 4*f1*f3*f6*f7)*z[1]*z[6]*z[9]*z[11] + (-32*f0*f2*f8^2 -
40*f0*f3*f7*f8 + 32*f0*f4*f6*f8 - 16*f0*f5^2*f8 + 8*f0*f5*f6*f7 + 32*f1^2*f8^2 +
32*f1*f2*f7*f8 - 16*f1*f3*f6*f8 + 8*f1*f3*f7^2 + 48*f1*f4*f5*f8 - 16*f1*f4*f6*f7 +
8*f1*f5^2*f7)*z[1]*z[6]*z[9]*z[12] + (32*f0*f3*f7*f8 - 8*f0*f4*f7^2 +
32*f0*f5^2*f8 + 16*f1^2*f8^2 - 2*f1*f3*f7^2)*z[1]*z[6]*z[9]*z[13] + (64*f0*f3*f8^2
- 8*f0*f5*f7^2 - 32*f1*f2*f8^2 - 16*f1*f3*f7*f8 + 8*f1*f4*f7^2 -
32*f1*f5^2*f8)*z[1]*z[6]*z[9]*z[14] + (-64*f0*f4*f8^2 + 40*f0*f5*f7*f8 +
16*f1*f3*f8^2 - 16*f1*f4*f7*f8 + 32*f1*f5*f6*f8 -
8*f1*f5*f7^2)*z[1]*z[6]*z[9]*z[15] + (-4*f0*f7^2 - 24*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[6]*z[9]*z[16] + 4*f0*f3*f7*z[1]*z[6]*z[10]^2 + (8*f0*f4*f7 -
2*f1*f3*f7)*z[1]*z[6]*z[10]*z[11] + (-16*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f4*f7 +
8*f2*f3*f7)*z[1]*z[6]*z[10]*z[12] + (-16*f0*f4*f8 - 8*f0*f5*f7 -
4*f1*f3*f8)*z[1]*z[6]*z[10]*z[13] + (-16*f0*f5*f8 + 8*f0*f6*f7 + 16*f1*f4*f8 +
8*f1*f5*f7)*z[1]*z[6]*z[10]*z[14] + (-4*f0*f7^2 - 8*f1*f5*f8 - 4*f1*f6*f7 -
4*f3^2*f8)*z[1]*z[6]*z[10]*z[15] + (8*f0*f5*f7 + 4*f1*f3*f8)*z[1]*z[6]*z[11]^2 +
(32*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f5*f7 - 8*f2*f3*f8 -
4*f3^2*f7)*z[1]*z[6]*z[11]*z[12] + (4*f0*f7^2 + 8*f1*f5*f8 -
4*f1*f6*f7)*z[1]*z[6]*z[11]*z[14] + (-8*f0*f7*f8 + 8*f1*f7^2 + 8*f3*f4*f8 +
2*f3*f5*f7)*z[1]*z[6]*z[11]*z[15] + (8*f0*f7^2 - 16*f1*f5*f8 + 16*f1*f6*f7 +
8*f3^2*f8 + 8*f3*f4*f7)*z[1]*z[6]*z[12]^2 + (4*f0*f7^2 - 8*f1*f5*f8 + 4*f1*f6*f7 +
4*f3^2*f8)*z[1]*z[6]*z[12]*z[13] + (-8*f0*f7*f8 - 16*f1*f7^2 - 16*f3*f4*f8 -
4*f3*f5*f7)*z[1]*z[6]*z[12]*z[14] + (16*f0*f8^2 - 4*f3*f5*f8 +
4*f3*f6*f7)*z[1]*z[6]*z[12]*z[15] - 10*f3*f7*z[1]*z[6]*z[12]*z[16] -
8*f0*f7*f8*z[1]*z[6]*z[13]*z[14] + (16*f0*f8^2 - 8*f1*f7*f8 -
8*f3*f5*f8)*z[1]*z[6]*z[13]*z[15] + 2*f3*f7*z[1]*z[6]*z[13]*z[16] + (16*f1*f7*f8 +
8*f3*f5*f8)*z[1]*z[6]*z[14]^2 + (-16*f1*f8^2 - 2*f3*f7^2)*z[1]*z[6]*z[14]*z[15] +
4*f3*f8*z[1]*z[6]*z[14]*z[16] + 4*f3*f7*f8*z[1]*z[6]*z[15]^2 + (32*f0*f1*f6*f8^2 -
8*f0*f1*f7^2*f8 - 96*f0*f2*f5*f8^2 + 128*f0*f2*f6*f7*f8 - 32*f0*f2*f7^3 +
64*f0*f3*f4*f8^2 - 24*f0*f3*f5*f7*f8 + 64*f0*f4*f5*f6*f8 - 16*f0*f4*f5*f7^2 -
16*f0*f5^3*f8 + 16*f1^2*f5*f8^2 - 32*f1^2*f6*f7*f8 + 8*f1^2*f7^3 - 16*f1*f3^2*f8^2
- 16*f1*f3*f5*f6*f8 + 4*f1*f3*f5*f7^2)*z[1]*z[7]*z[9]^2 + (-32*f0*f1*f8^2 -
32*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 - 32*f0*f4*f5*f8 + 8*f0*f5^2*f7 +
8*f1^2*f7*f8 + 8*f1*f3*f5*f8)*z[1]*z[7]*z[9]*z[10] + (64*f0*f2*f8^2 +
40*f0*f5^2*f8 - 8*f0*f5*f6*f7 + 16*f1*f3*f6*f8 -
8*f1*f3*f7^2)*z[1]*z[7]*z[9]*z[11] + (16*f0*f3*f8^2 + 16*f0*f4*f7*f8 -
16*f0*f5*f7^2 - 32*f1*f2*f8^2 - 32*f1*f4*f6*f8 + 16*f1*f4*f7^2 -
8*f1*f5^2*f8)*z[1]*z[7]*z[9]*z[12] + (-32*f0*f3*f8^2 - 64*f0*f5*f6*f8 +
20*f0*f5*f7^2 + 8*f1*f3*f7*f8)*z[1]*z[7]*z[9]*z[13] + (-64*f0*f4*f8^2 +
40*f0*f5*f7*f8 + 16*f1*f3*f8^2 - 16*f1*f4*f7*f8 + 32*f1*f5*f6*f8 -
8*f1*f5*f7^2)*z[1]*z[7]*z[9]*z[14] + (32*f0*f5*f8^2 - 96*f0*f6*f7*f8 + 24*f0*f7^3
+ 32*f1*f4*f8^2)*z[1]*z[7]*z[9]*z[15] + (16*f0*f7*f8 + 8*f1*f6*f8 -
4*f1*f7^2)*z[1]*z[7]*z[9]*z[16] + (8*f0*f3*f8 - 16*f0*f4*f7 +
4*f1*f3*f7)*z[1]*z[7]*z[10]^2 + (12*f0*f5*f7 - 4*f1*f3*f8)*z[1]*z[7]*z[10]*z[11] +
(-8*f0*f5*f8 + 16*f0*f6*f7 + 16*f1*f4*f8 - 8*f1*f5*f7 - 8*f2*f3*f8 -
4*f3^2*f7)*z[1]*z[7]*z[10]*z[12] + 24*f0*f5*f8*z[1]*z[7]*z[10]*z[13] +
(16*f0*f6*f8 - 16*f0*f7^2 - 8*f1*f5*f8 + 4*f3^2*f8)*z[1]*z[7]*z[10]*z[14] +
(24*f0*f7*f8 - 8*f1*f6*f8 + 4*f1*f7^2)*z[1]*z[7]*z[10]*z[15] + (-16*f0*f5*f8 -
16*f0*f6*f7)*z[1]*z[7]*z[11]^2 + (8*f0*f7^2 + 16*f1*f6*f7 + 8*f3^2*f8 +
8*f3*f4*f7)*z[1]*z[7]*z[11]*z[12] + 16*f0*f7^2*z[1]*z[7]*z[11]*z[13] +
(-8*f0*f7*f8 - 8*f1*f6*f8 - 4*f1*f7^2 - 8*f3*f4*f8 -
2*f3*f5*f7)*z[1]*z[7]*z[11]*z[14] - 16*f0*f8^2*z[1]*z[7]*z[11]*z[15] -
4*f3*f7*z[1]*z[7]*z[11]*z[16] + (-8*f0*f7*f8 - 8*f1*f7^2 + 16*f2*f5*f8 -
16*f2*f6*f7 - 16*f3*f4*f8 + 8*f3*f5*f7 - 16*f4^2*f7)*z[1]*z[7]*z[12]^2 +
(-16*f0*f7*f8 + 8*f1*f6*f8 - 12*f1*f7^2 - 8*f3*f4*f8 -
2*f3*f5*f7)*z[1]*z[7]*z[12]*z[13] + (24*f1*f7*f8 + 16*f2*f7^2 - 8*f3*f5*f8 +
32*f4^2*f8 + 8*f4*f5*f7)*z[1]*z[7]*z[12]*z[14] + (-16*f2*f7*f8 + 16*f3*f6*f8 -
8*f3*f7^2 - 16*f4*f5*f8 - 4*f5^2*f7)*z[1]*z[7]*z[12]*z[15] + (4*f3*f8 +
16*f4*f7)*z[1]*z[7]*z[12]*z[16] - 16*f0*f7*f8*z[1]*z[7]*z[13]^2 + (32*f0*f8^2 +
16*f1*f7*f8 + 8*f3*f5*f8)*z[1]*z[7]*z[13]*z[14] - 16*f1*f8^2*z[1]*z[7]*z[13]*z[15]
+ 4*f3*f8*z[1]*z[7]*z[13]*z[16] + (-16*f1*f8^2 - 16*f2*f7*f8 -
16*f4*f5*f8)*z[1]*z[7]*z[14]^2 + (32*f2*f8^2 + 8*f3*f7*f8 +
16*f5^2*f8)*z[1]*z[7]*z[14]*z[15] + (-16*f4*f8 - 4*f5*f7)*z[1]*z[7]*z[14]*z[16] +
(-16*f3*f8^2 - 16*f5*f6*f8 + 4*f5*f7^2)*z[1]*z[7]*z[15]^2 +
16*f5*f8*z[1]*z[7]*z[15]*z[16] + (-16*f0*f2*f7*f8 - 16*f0*f3*f6*f8 + 8*f0*f3*f7^2
- 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 + 4*f1^2*f7*f8 + 8*f1*f3*f5*f8)*z[1]*z[8]*z[9]^2 +
(16*f0*f3*f8 + 16*f0*f4*f7 - 8*f0*f5*f6 - 4*f1*f3*f7)*z[1]*z[8]*z[9]*z[10] +
(-16*f0*f4*f8 - 24*f0*f5*f7 + 16*f0*f6^2 - 4*f1*f3*f8)*z[1]*z[8]*z[9]*z[11] +
(-8*f0*f5*f8 + 8*f0*f6*f7 + 16*f1*f4*f8 + 12*f1*f5*f7 -
8*f1*f6^2)*z[1]*z[8]*z[9]*z[12] + (40*f0*f5*f8 - 8*f0*f6*f7)*z[1]*z[8]*z[9]*z[13]
+ (-4*f0*f7^2 - 24*f1*f5*f8 + 4*f1*f6*f7)*z[1]*z[8]*z[9]*z[14] + (16*f0*f7*f8 +
8*f1*f6*f8 - 4*f1*f7^2)*z[1]*z[8]*z[9]*z[15] + (-6*f1*f8 +
f3*f6)*z[1]*z[8]*z[9]*z[16] + 4*f0*f5*z[1]*z[8]*z[10]^2 -
8*f0*f6*z[1]*z[8]*z[10]*z[11] + (-12*f0*f7 + 4*f1*f6)*z[1]*z[8]*z[10]*z[12] -
8*f0*f7*z[1]*z[8]*z[10]*z[13] + 4*f1*f7*z[1]*z[8]*z[10]*z[14] + (-2*f1*f8 -
f3*f6)*z[1]*z[8]*z[10]*z[15] + 16*f0*f7*z[1]*z[8]*z[11]^2 + (8*f0*f8 - 12*f1*f7 -
2*f3*f5)*z[1]*z[8]*z[11]*z[12] - 8*f0*f8*z[1]*z[8]*z[11]*z[13] + (6*f1*f8 +
f3*f6)*z[1]*z[8]*z[11]*z[14] + 4*f3*f7*z[1]*z[8]*z[11]*z[15] + (-4*f1*f8 + 8*f2*f7
+ 4*f4*f5)*z[1]*z[8]*z[12]^2 + (2*f1*f8 + 3*f3*f6)*z[1]*z[8]*z[12]*z[13] +
(-8*f2*f8 - 4*f3*f7 - 8*f4*f6)*z[1]*z[8]*z[12]*z[14] +
4*f5*f6*z[1]*z[8]*z[12]*z[15] - 4*f5*z[1]*z[8]*z[12]*z[16] -
2*f3*f7*z[1]*z[8]*z[13]*z[14] - 4*f3*f8*z[1]*z[8]*z[13]*z[15] + (4*f3*f8 +
4*f4*f7)*z[1]*z[8]*z[14]^2 - 4*f5*f7*z[1]*z[8]*z[14]*z[15] +
4*f6*z[1]*z[8]*z[14]*z[16] + 4*f5*f8*z[1]*z[8]*z[15]^2 -
4*f7*z[1]*z[8]*z[15]*z[16] + (-16*f0^2*f5*f8 + 16*f0^2*f6*f7 + 32*f0*f2*f4*f7 -
4*f0*f3^2*f7 - 8*f1^2*f4*f7)*z[2]^2*z[9]^2 + (-16*f0^2*f7 - 16*f0*f2*f5 +
4*f1^2*f5)*z[2]^2*z[9]*z[10] + (16*f0^2*f8 + 16*f0*f2*f6 + 4*f0*f3*f5 -
4*f1^2*f6)*z[2]^2*z[9]*z[11] + (-8*f0*f3*f6 - 2*f1*f3*f5)*z[2]^2*z[9]*z[12] +
(-24*f0*f2*f7 + 6*f1^2*f7)*z[2]^2*z[9]*z[13] + 4*f0*f3*f7*z[2]^2*z[9]*z[14] +
(8*f0*f3*f8 - 16*f0*f4*f7 + 4*f1*f3*f7)*z[2]^2*z[9]*z[15] +
4*f0*f5*z[2]^2*z[9]*z[16] + (-8*f0*f2 + 2*f1^2)*z[2]^2*z[10]*z[11] +
4*f0*f3*z[2]^2*z[10]*z[12] + 4*f0*f3*z[2]^2*z[10]*z[13] -
2*f1*f3*z[2]^2*z[10]*z[14] + 4*f0*f5*z[2]^2*z[10]*z[15] -
8*f0*f4*z[2]^2*z[11]*z[13] + (4*f0*f5 + 4*f1*f4)*z[2]^2*z[11]*z[14] + (-8*f0*f6 -
2*f1*f5)*z[2]^2*z[11]*z[15] + 4*f0*z[2]^2*z[11]*z[16] - 4*f0*f5*z[2]^2*z[12]^2 +
(4*f0*f5 + 4*f1*f4)*z[2]^2*z[12]*z[13] + (-4*f1*f5 - 8*f2*f4 +
2*f3^2)*z[2]^2*z[12]*z[14] + (8*f0*f7 + 4*f1*f6 + 4*f2*f5)*z[2]^2*z[12]*z[15] -
2*f1*z[2]^2*z[12]*z[16] + 4*f0*f7*z[2]^2*z[13]*z[15] - 2*f1*z[2]^2*z[13]*z[16] -
4*f0*f7*z[2]^2*z[14]^2 + 2*f1*f7*z[2]^2*z[14]*z[15] + 4*f2*z[2]^2*z[14]*z[16] +
(-4*f1*f8 - 4*f2*f7)*z[2]^2*z[15]^2 + (-16*f0^2*f7^2 + 16*f0*f1*f5*f8 -
16*f0*f1*f6*f7 - 32*f0*f2*f4*f8 - 8*f0*f2*f5*f7 - 16*f0*f3*f4*f7 + 8*f1^2*f4*f8 +
2*f1^2*f5*f7)*z[2]*z[3]*z[9]^2 + (16*f0^2*f8 + 16*f0*f1*f7 + 16*f0*f2*f6 +
8*f0*f3*f5 - 4*f1^2*f6)*z[2]*z[3]*z[9]*z[10] + (-16*f0*f1*f8 -
16*f0*f3*f6)*z[2]*z[3]*z[9]*z[11] + (16*f0*f4*f6 - 8*f0*f5^2 +
4*f1*f3*f6)*z[2]*z[3]*z[9]*z[12] + (16*f0*f2*f8 + 16*f0*f3*f7 -
4*f1^2*f8)*z[2]*z[3]*z[9]*z[13] + (8*f0*f4*f7 - 2*f1*f3*f7)*z[2]*z[3]*z[9]*z[14] +
(12*f0*f5*f7 - 4*f1*f3*f8)*z[2]*z[3]*z[9]*z[15] - 8*f0*f6*z[2]*z[3]*z[9]*z[16] +
(-8*f0*f2 + 2*f1^2)*z[2]*z[3]*z[10]^2 + 8*f0*f3*z[2]*z[3]*z[10]*z[11] + (-8*f0*f4
- 2*f1*f3)*z[2]*z[3]*z[10]*z[12] - 8*f0*f5*z[2]*z[3]*z[10]*z[14] +
4*f0*z[2]*z[3]*z[10]*z[16] + 4*f0*f5*z[2]*z[3]*z[11]*z[12] +
8*f0*f5*z[2]*z[3]*z[11]*z[13] - 4*f1*f5*z[2]*z[3]*z[11]*z[14] +
4*f1*f6*z[2]*z[3]*z[11]*z[15] - 2*f1*z[2]*z[3]*z[11]*z[16] +
2*f1*f5*z[2]*z[3]*z[12]^2 + (-8*f0*f6 - 4*f1*f5)*z[2]*z[3]*z[12]*z[13] + (8*f0*f7
+ 4*f1*f6 + 8*f2*f5)*z[2]*z[3]*z[12]*z[14] + (-8*f0*f8 - 8*f1*f7 - 8*f2*f6 -
2*f3*f5)*z[2]*z[3]*z[12]*z[15] + 4*f2*z[2]*z[3]*z[12]*z[16] -
4*f0*f7*z[2]*z[3]*z[13]*z[14] + (8*f0*f8 + 2*f1*f7)*z[2]*z[3]*z[13]*z[15] +
2*f1*f7*z[2]*z[3]*z[14]^2 + (-4*f1*f8 - 4*f2*f7)*z[2]*z[3]*z[14]*z[15] -
2*f3*z[2]*z[3]*z[14]*z[16] + (8*f2*f8 + 4*f3*f7)*z[2]*z[3]*z[15]^2 +
(16*f0^2*f7*f8 + 8*f0*f1*f7^2 + 32*f0*f2*f5*f8 - 32*f0*f2*f6*f7 + 12*f0*f3*f5*f7 -
16*f1^2*f5*f8 + 16*f1^2*f6*f7 + 4*f1*f3^2*f8 + 8*f1*f3*f4*f7)*z[2]*z[4]*z[9]^2 +
(-8*f0*f1*f8 + 32*f0*f2*f7 - 8*f0*f3*f6 - 16*f1^2*f7 -
4*f1*f3*f5)*z[2]*z[4]*z[9]*z[10] + (-32*f0*f2*f8 - 16*f0*f3*f7 + 16*f0*f4*f6 -
8*f0*f5^2 + 16*f1^2*f8 + 4*f1*f3*f6)*z[2]*z[4]*z[9]*z[11] + (8*f0*f3*f8 +
8*f0*f5*f6 + 8*f1*f3*f7 - 16*f1*f4*f6 + 8*f1*f5^2)*z[2]*z[4]*z[9]*z[12] +
(8*f0*f4*f7 - 10*f1*f3*f7)*z[2]*z[4]*z[9]*z[13] + (-16*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f4*f7 + 8*f2*f3*f7)*z[2]*z[4]*z[9]*z[14] + (-8*f0*f5*f8 + 16*f0*f6*f7 +
16*f1*f4*f8 - 8*f1*f5*f7 - 8*f2*f3*f8 - 4*f3^2*f7)*z[2]*z[4]*z[9]*z[15] +
(-12*f0*f7 + 4*f1*f6)*z[2]*z[4]*z[9]*z[16] + 4*f0*f3*z[2]*z[4]*z[10]^2 + (-8*f0*f4
- 2*f1*f3)*z[2]*z[4]*z[10]*z[11] + (-8*f0*f5 + 8*f1*f4)*z[2]*z[4]*z[10]*z[12] -
8*f0*f5*z[2]*z[4]*z[10]*z[13] + (8*f0*f6 + 8*f1*f5)*z[2]*z[4]*z[10]*z[14] +
(-12*f0*f7 - 4*f1*f6)*z[2]*z[4]*z[10]*z[15] + 8*f0*f5*z[2]*z[4]*z[11]^2 -
8*f1*f5*z[2]*z[4]*z[11]*z[12] + (-4*f0*f7 - 4*f1*f6)*z[2]*z[4]*z[11]*z[14] +
(8*f0*f8 + 8*f1*f7 + 2*f3*f5)*z[2]*z[4]*z[11]*z[15] + 8*f0*f7*z[2]*z[4]*z[12]^2 +
(-4*f0*f7 + 4*f1*f6)*z[2]*z[4]*z[12]*z[13] + (-8*f0*f8 -
4*f3*f5)*z[2]*z[4]*z[12]*z[14] + 4*f3*f6*z[2]*z[4]*z[12]*z[15] -
2*f3*z[2]*z[4]*z[12]*z[16] + 8*f0*f8*z[2]*z[4]*z[13]*z[14] -
8*f1*f8*z[2]*z[4]*z[13]*z[15] + 2*f3*z[2]*z[4]*z[13]*z[16] -
2*f3*f7*z[2]*z[4]*z[14]*z[15] + (8*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 16*f0*f3*f4*f8 +
4*f0*f3*f5*f7 + 8*f1^2*f5*f8)*z[2]*z[5]*z[9]^2 + (-8*f0*f1*f8 + 16*f0*f2*f7 -
8*f0*f3*f6 - 4*f1^2*f7)*z[2]*z[5]*z[9]*z[10] + (16*f0*f2*f8 - 8*f0*f3*f7 -
4*f1^2*f8)*z[2]*z[5]*z[9]*z[11] + (8*f0*f5*f6 + 4*f1*f3*f7)*z[2]*z[5]*z[9]*z[12] +
(-16*f0*f4*f8 - 8*f0*f5*f7 - 4*f1*f3*f8)*z[2]*z[5]*z[9]*z[14] +
24*f0*f5*f8*z[2]*z[5]*z[9]*z[15] - 8*f0*f7*z[2]*z[5]*z[9]*z[16] +
4*f0*f3*z[2]*z[5]*z[10]^2 - 8*f0*f5*z[2]*z[5]*z[10]*z[12] +
8*f0*f6*z[2]*z[5]*z[10]*z[14] - 8*f0*f7*z[2]*z[5]*z[10]*z[15] +
4*f0*f5*z[2]*z[5]*z[11]^2 - 4*f1*f5*z[2]*z[5]*z[11]*z[12] -
8*f0*f6*z[2]*z[5]*z[11]*z[13] + 4*f1*f6*z[2]*z[5]*z[11]*z[14] -
8*f0*f8*z[2]*z[5]*z[11]*z[15] + (8*f0*f7 + 4*f2*f5)*z[2]*z[5]*z[12]^2 +
4*f1*f6*z[2]*z[5]*z[12]*z[13] + (-8*f0*f8 - 4*f1*f7 -
8*f2*f6)*z[2]*z[5]*z[12]*z[14] + (4*f1*f8 + 4*f3*f6)*z[2]*z[5]*z[12]*z[15] -
2*f3*z[2]*z[5]*z[12]*z[16] + 4*f0*f7*z[2]*z[5]*z[13]^2 + (8*f0*f8 -
4*f1*f7)*z[2]*z[5]*z[13]*z[14] - 4*f1*f8*z[2]*z[5]*z[13]*z[15] +
4*f2*f7*z[2]*z[5]*z[14]^2 + (8*f2*f8 - 2*f3*f7)*z[2]*z[5]*z[14]*z[15] -
4*f3*f8*z[2]*z[5]*z[15]^2 + (-8*f0*f1*f7*f8 + 16*f0*f2*f7^2 + 8*f0*f3*f5*f8 -
8*f1^2*f7^2 - 8*f1*f3*f4*f8 - 2*f1*f3*f5*f7)*z[2]*z[6]*z[9]^2 + (-16*f0*f2*f8 -
8*f0*f3*f7 + 8*f1^2*f8 + 4*f1*f3*f6)*z[2]*z[6]*z[9]*z[10] + (8*f0*f3*f8 +
8*f0*f5*f6 + 4*f1*f3*f7)*z[2]*z[6]*z[9]*z[11] + (16*f0*f4*f8 + 16*f0*f5*f7 -
16*f0*f6^2 - 8*f1*f3*f8 - 8*f1*f5*f6 - 8*f2*f3*f7)*z[2]*z[6]*z[9]*z[12] +
(-16*f0*f4*f8 - 8*f0*f5*f7 + 4*f1*f3*f8)*z[2]*z[6]*z[9]*z[13] + (-16*f0*f5*f8 +
8*f0*f6*f7 + 16*f1*f4*f8 + 8*f1*f5*f7)*z[2]*z[6]*z[9]*z[14] + (16*f0*f6*f8 -
16*f0*f7^2 - 8*f1*f5*f8 + 4*f3^2*f8)*z[2]*z[6]*z[9]*z[15] +
4*f1*f7*z[2]*z[6]*z[9]*z[16] - 2*f1*f3*z[2]*z[6]*z[10]^2 -
8*f0*f5*z[2]*z[6]*z[10]*z[11] + (8*f0*f6 + 8*f1*f5)*z[2]*z[6]*z[10]*z[12] +
8*f0*f6*z[2]*z[6]*z[10]*z[13] - 8*f1*f6*z[2]*z[6]*z[10]*z[14] +
4*f1*f7*z[2]*z[6]*z[10]*z[15] - 8*f0*f7*z[2]*z[6]*z[11]*z[13] +
4*f1*f7*z[2]*z[6]*z[11]*z[14] - 4*f3*f6*z[2]*z[6]*z[11]*z[15] +
2*f3*z[2]*z[6]*z[11]*z[16] + (-8*f0*f8 - 8*f1*f7 - 2*f3*f5)*z[2]*z[6]*z[12]^2 +
4*f1*f7*z[2]*z[6]*z[12]*z[13] + (8*f1*f8 + 4*f3*f6)*z[2]*z[6]*z[12]*z[14] +
4*f3*f7*z[2]*z[6]*z[12]*z[15] + 8*f0*f8*z[2]*z[6]*z[13]^2 -
8*f1*f8*z[2]*z[6]*z[13]*z[14] + 2*f3*f7*z[2]*z[6]*z[13]*z[15] -
2*f3*f7*z[2]*z[6]*z[14]^2 - 4*f3*f8*z[2]*z[6]*z[14]*z[15] + (-32*f0*f2*f7*f8 -
16*f0*f4*f5*f8 + 4*f0*f5^2*f7 + 12*f1^2*f7*f8 + 8*f1*f3*f5*f8)*z[2]*z[7]*z[9]^2 +
(8*f0*f3*f8 + 16*f0*f4*f7 - 8*f0*f5*f6 - 4*f1*f3*f7)*z[2]*z[7]*z[9]*z[10] +
(-8*f0*f5*f7 - 8*f1*f3*f8)*z[2]*z[7]*z[9]*z[11] + (-8*f0*f5*f8 + 8*f0*f6*f7 -
4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 + 4*f3^2*f7)*z[2]*z[7]*z[9]*z[12] +
24*f0*f5*f8*z[2]*z[7]*z[9]*z[13] + (-4*f0*f7^2 - 8*f1*f5*f8 - 4*f1*f6*f7 -
4*f3^2*f8)*z[2]*z[7]*z[9]*z[14] + (24*f0*f7*f8 - 8*f1*f6*f8 +
4*f1*f7^2)*z[2]*z[7]*z[9]*z[15] + (-2*f1*f8 - f3*f6)*z[2]*z[7]*z[9]*z[16] +
4*f0*f5*z[2]*z[7]*z[10]^2 + (-12*f0*f7 - 4*f1*f6)*z[2]*z[7]*z[10]*z[12] -
8*f0*f7*z[2]*z[7]*z[10]*z[13] + 4*f1*f7*z[2]*z[7]*z[10]*z[14] + (2*f1*f8 +
f3*f6)*z[2]*z[7]*z[10]*z[15] + 8*f0*f7*z[2]*z[7]*z[11]^2 + (-4*f1*f7 -
2*f3*f5)*z[2]*z[7]*z[11]*z[12] + (2*f1*f8 + 3*f3*f6)*z[2]*z[7]*z[11]*z[14] +
(4*f1*f8 + 8*f2*f7 + 4*f4*f5)*z[2]*z[7]*z[12]^2 + (-2*f1*f8 +
f3*f6)*z[2]*z[7]*z[12]*z[13] + (-8*f2*f8 - 4*f3*f7 -
8*f4*f6)*z[2]*z[7]*z[12]*z[14] + (-4*f3*f8 + 4*f5*f6)*z[2]*z[7]*z[12]*z[15] -
4*f5*z[2]*z[7]*z[12]*z[16] - 2*f3*f7*z[2]*z[7]*z[13]*z[14] + (4*f3*f8 +
4*f4*f7)*z[2]*z[7]*z[14]^2 - 4*f5*f7*z[2]*z[7]*z[14]*z[15] +
4*f6*z[2]*z[7]*z[14]*z[16] + 4*f5*f8*z[2]*z[7]*z[15]^2 -
4*f7*z[2]*z[7]*z[15]*z[16] - 16*f0*f4*f7*z[2]*z[8]*z[9]^2 +
8*f0*f5*z[2]*z[8]*z[9]*z[10] - 8*f0*f6*z[2]*z[8]*z[9]*z[11] +
12*f0*f7*z[2]*z[8]*z[9]*z[13] + 4*f0*z[2]*z[8]*z[10]*z[11] -
2*f3*z[2]*z[8]*z[11]*z[14] - 2*f3*z[2]*z[8]*z[12]*z[13] +
8*f4*z[2]*z[8]*z[12]*z[14] - 4*f5*z[2]*z[8]*z[12]*z[15] - 4*z[2]*z[8]*z[14]*z[16]
+ 4*f7*z[2]*z[8]*z[15]^2 + (16*f0^2*f7*f8 + 8*f0*f1*f7^2 + 16*f0*f2*f5*f8 +
16*f0*f2*f6*f7 + 16*f0*f3*f4*f8 - 8*f0*f3*f5*f7 + 16*f0*f4^2*f7 -
8*f1^2*f5*f8)*z[3]^2*z[9]^2 + (-8*f0*f1*f8 - 32*f0*f2*f7 - 8*f0*f4*f5 +
4*f1^2*f7)*z[3]^2*z[9]*z[10] + (16*f0*f3*f7 + 4*f0*f5^2 +
4*f1^2*f8)*z[3]^2*z[9]*z[11] + (-16*f0*f4*f7 - 4*f1*f3*f7)*z[3]^2*z[9]*z[12] +
(-16*f0*f3*f8 - 16*f0*f4*f7)*z[3]^2*z[9]*z[13] + (8*f0*f5*f7 +
4*f1*f3*f8)*z[3]^2*z[9]*z[14] + (-16*f0*f5*f8 - 16*f0*f6*f7)*z[3]^2*z[9]*z[15] +
16*f0*f7*z[3]^2*z[9]*z[16] + 8*f0*f5*z[3]^2*z[10]*z[12] +
4*f0*f5*z[3]^2*z[10]*z[13] + 8*f0*f7*z[3]^2*z[10]*z[15] - 8*f0*f5*z[3]^2*z[11]^2 +
4*f1*f5*z[3]^2*z[11]*z[12] - 4*f1*f7*z[3]^2*z[11]*z[15] + (-8*f0*f7 -
4*f2*f5)*z[3]^2*z[12]^2 + 8*f0*f7*z[3]^2*z[12]*z[13] - 4*f1*f7*z[3]^2*z[12]*z[14]
+ (4*f1*f8 + 8*f2*f7)*z[3]^2*z[12]*z[15] - 4*f0*f7*z[3]^2*z[13]^2 +
4*f1*f7*z[3]^2*z[13]*z[14] - 4*f2*f7*z[3]^2*z[14]^2 + 4*f3*f7*z[3]^2*z[14]*z[15] +
(-4*f3*f8 - 4*f4*f7)*z[3]^2*z[15]^2 + 2*f5*z[3]^2*z[15]*z[16] + (-32*f0^2*f8^2 -
24*f0*f1*f7*f8 - 40*f0*f3*f5*f8 + 16*f0*f3*f6*f7 - 16*f0*f4*f5*f7 - 8*f1^2*f7^2 +
16*f1*f2*f5*f8 - 16*f1*f2*f6*f7 - 16*f1*f3*f4*f8 + 8*f1*f3*f5*f7 -
16*f1*f4^2*f7)*z[3]*z[4]*z[9]^2 + (8*f0*f5^2 + 8*f1^2*f8 + 16*f1*f2*f7 +
8*f1*f4*f5)*z[3]*z[4]*z[9]*z[10] + (32*f0*f3*f8 - 8*f0*f5*f6 - 16*f1*f2*f8 -
8*f1*f3*f7 - 4*f1*f5^2)*z[3]*z[4]*z[9]*z[11] + (-16*f0*f4*f8 +
16*f1*f4*f7)*z[3]*z[4]*z[9]*z[12] + (12*f0*f5*f7 + 12*f1*f3*f8 +
16*f1*f4*f7)*z[3]*z[4]*z[9]*z[13] + (32*f0*f5*f8 - 16*f0*f6*f7 - 8*f1*f5*f7 -
8*f2*f3*f8 - 4*f3^2*f7)*z[3]*z[4]*z[9]*z[14] + (8*f0*f7^2 + 16*f1*f6*f7 +
8*f3^2*f8 + 8*f3*f4*f7)*z[3]*z[4]*z[9]*z[15] + (8*f0*f8 - 12*f1*f7 -
2*f3*f5)*z[3]*z[4]*z[9]*z[16] + 4*f0*f5*z[3]*z[4]*z[10]*z[11] -
8*f1*f5*z[3]*z[4]*z[10]*z[12] - 4*f1*f5*z[3]*z[4]*z[10]*z[13] + (-4*f1*f7 -
2*f3*f5)*z[3]*z[4]*z[10]*z[15] + 4*f1*f5*z[3]*z[4]*z[11]^2 -
8*f0*f7*z[3]*z[4]*z[11]*z[12] + 4*f1*f7*z[3]*z[4]*z[11]*z[14] + (8*f0*f8 + 8*f1*f7
+ 4*f3*f5)*z[3]*z[4]*z[12]^2 + (8*f0*f8 - 4*f1*f7)*z[3]*z[4]*z[12]*z[13] -
8*f1*f8*z[3]*z[4]*z[12]*z[14] - 8*f3*f7*z[3]*z[4]*z[12]*z[15] -
4*f3*f7*z[3]*z[4]*z[13]*z[15] + 4*f3*f7*z[3]*z[4]*z[14]^2 +
4*f3*f8*z[3]*z[4]*z[14]*z[15] + (-16*f0*f1*f7*f8 - 16*f0*f2*f7^2 + 8*f0*f3*f5*f8 -
32*f0*f4^2*f8 - 8*f0*f4*f5*f7)*z[3]*z[5]*z[9]^2 + (16*f0*f2*f8 + 8*f0*f3*f7 +
16*f0*f4*f6)*z[3]*z[5]*z[9]*z[10] + (-16*f0*f3*f8 -
8*f0*f5*f6)*z[3]*z[5]*z[9]*z[11] + (16*f0*f4*f8 - 8*f0*f5*f7)*z[3]*z[5]*z[9]*z[12]
+ (32*f0*f4*f8 + 8*f0*f5*f7)*z[3]*z[5]*z[9]*z[13] +
16*f0*f7^2*z[3]*z[5]*z[9]*z[15] - 8*f0*f8*z[3]*z[5]*z[9]*z[16] -
8*f0*f4*z[3]*z[5]*z[10]^2 + 8*f0*f5*z[3]*z[5]*z[10]*z[11] -
8*f0*f6*z[3]*z[5]*z[10]*z[13] - 8*f0*f7*z[3]*z[5]*z[10]*z[14] +
16*f0*f7*z[3]*z[5]*z[11]*z[13] - 4*f1*f7*z[3]*z[5]*z[11]*z[14] +
4*f1*f8*z[3]*z[5]*z[11]*z[15] + (-8*f0*f8 - 4*f1*f7)*z[3]*z[5]*z[12]*z[13] +
(8*f1*f8 + 8*f2*f7)*z[3]*z[5]*z[12]*z[14] + (-8*f2*f8 -
4*f3*f7)*z[3]*z[5]*z[12]*z[15] - 8*f0*f8*z[3]*z[5]*z[13]^2 -
4*f3*f8*z[3]*z[5]*z[14]*z[15] + (8*f4*f8 + 2*f5*f7)*z[3]*z[5]*z[15]^2 -
4*f6*z[3]*z[5]*z[15]*z[16] + 2*z[3]*z[5]*z[16]^2 + (16*f0*f1*f8^2 - 8*f0*f3*f7^2 +
16*f0*f4*f5*f8 + 4*f0*f5^2*f7 + 12*f1^2*f7*f8 + 8*f1*f2*f7^2 - 4*f1*f3*f5*f8 +
16*f1*f4^2*f8 + 4*f1*f4*f5*f7)*z[3]*z[6]*z[9]^2 + (-8*f0*f5*f6 - 8*f1*f2*f8 -
4*f1*f3*f7 - 8*f1*f4*f6)*z[3]*z[6]*z[9]*z[10] + (4*f1*f3*f8 +
4*f1*f5*f6)*z[3]*z[6]*z[9]*z[11] + (-8*f0*f5*f8 + 8*f0*f6*f7 - 16*f1*f4*f8 -
4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 + 4*f3^2*f7)*z[3]*z[6]*z[9]*z[12] +
(-8*f0*f5*f8 - 16*f1*f4*f8 - 4*f1*f5*f7)*z[3]*z[6]*z[9]*z[13] + (4*f0*f7^2 +
8*f1*f5*f8 - 4*f1*f6*f7)*z[3]*z[6]*z[9]*z[14] + (-8*f0*f7*f8 - 8*f1*f6*f8 -
4*f1*f7^2 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[3]*z[6]*z[9]*z[15] + (6*f1*f8 +
f3*f6)*z[3]*z[6]*z[9]*z[16] + (4*f0*f5 + 4*f1*f4)*z[3]*z[6]*z[10]^2 -
4*f1*f5*z[3]*z[6]*z[10]*z[11] + (-4*f0*f7 - 4*f1*f6)*z[3]*z[6]*z[10]*z[12] +
4*f1*f6*z[3]*z[6]*z[10]*z[13] + 4*f1*f7*z[3]*z[6]*z[10]*z[14] + (2*f1*f8 +
3*f3*f6)*z[3]*z[6]*z[10]*z[15] - 2*f3*z[3]*z[6]*z[10]*z[16] +
4*f1*f7*z[3]*z[6]*z[11]*z[12] - 4*f1*f7*z[3]*z[6]*z[11]*z[13] + (-6*f1*f8 +
f3*f6)*z[3]*z[6]*z[11]*z[14] + 4*f1*f8*z[3]*z[6]*z[12]^2 + (-2*f1*f8 -
f3*f6)*z[3]*z[6]*z[12]*z[13] - 4*f3*f7*z[3]*z[6]*z[12]*z[14] +
4*f1*f8*z[3]*z[6]*z[13]^2 + 4*f3*f8*z[3]*z[6]*z[13]*z[15] + (32*f0*f2*f8^2 +
16*f0*f3*f7*f8 - 32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 16*f0*f5^2*f8 - 8*f0*f5*f6*f7 -
16*f1^2*f8^2 - 8*f1*f2*f7*f8 + 8*f1*f3*f6*f8 - 4*f1*f3*f7^2 - 8*f1*f4*f5*f8 -
2*f1*f5^2*f7)*z[3]*z[7]*z[9]^2 + (-16*f0*f5*f7 + 16*f0*f6^2 +
4*f1*f5*f6)*z[3]*z[7]*z[9]*z[10] + (-24*f0*f5*f8 + 16*f0*f6*f7 + 8*f1*f4*f8 +
8*f1*f5*f7 - 8*f1*f6^2)*z[3]*z[7]*z[9]*z[11] + (16*f1*f5*f8 - 16*f1*f6*f7 -
8*f3^2*f8 - 8*f3*f4*f7)*z[3]*z[7]*z[9]*z[12] + (16*f0*f6*f8 - 16*f0*f7^2 -
4*f1*f5*f8 + 4*f1*f6*f7)*z[3]*z[7]*z[9]*z[13] + (-8*f0*f7*f8 + 8*f1*f7^2 +
8*f3*f4*f8 + 2*f3*f5*f7)*z[3]*z[7]*z[9]*z[14] - 16*f0*f8^2*z[3]*z[7]*z[9]*z[15] +
4*f3*f7*z[3]*z[7]*z[9]*z[16] + (-8*f0*f6 - 2*f1*f5)*z[3]*z[7]*z[10]^2 +
4*f1*f6*z[3]*z[7]*z[10]*z[11] + (8*f0*f8 + 8*f1*f7 +
2*f3*f5)*z[3]*z[7]*z[10]*z[12] - 8*f0*f8*z[3]*z[7]*z[10]*z[13] -
4*f3*f6*z[3]*z[7]*z[10]*z[14] - 4*f1*f7*z[3]*z[7]*z[11]^2 +
4*f1*f8*z[3]*z[7]*z[11]*z[13] + (-8*f2*f8 - 4*f3*f7 - 2*f5^2)*z[3]*z[7]*z[12]^2 +
4*f3*f7*z[3]*z[7]*z[12]*z[13] + (8*f3*f8 + 4*f5*f6)*z[3]*z[7]*z[12]*z[14] +
(8*f4*f8 + 8*f5*f7 - 8*f6^2)*z[3]*z[7]*z[12]*z[15] + 4*f6*z[3]*z[7]*z[12]*z[16] -
4*f3*f8*z[3]*z[7]*z[13]*z[14] - 2*f5*f7*z[3]*z[7]*z[14]^2 + (-12*f5*f8 +
4*f6*f7)*z[3]*z[7]*z[14]*z[15] + (8*f6*f8 - 4*f7^2)*z[3]*z[7]*z[15]^2 -
4*f8*z[3]*z[7]*z[15]*z[16] + (16*f0*f4*f8 + 4*f0*f5*f7 +
8*f1*f4*f7)*z[3]*z[8]*z[9]^2 + (-8*f0*f6 - 4*f1*f5)*z[3]*z[8]*z[9]*z[10] +
4*f1*f6*z[3]*z[8]*z[9]*z[11] + 2*f3*f5*z[3]*z[8]*z[9]*z[12] + (-8*f0*f8 -
6*f1*f7)*z[3]*z[8]*z[9]*z[13] - 4*f3*f7*z[3]*z[8]*z[9]*z[15] +
4*f0*z[3]*z[8]*z[10]^2 - 2*f1*z[3]*z[8]*z[10]*z[11] + 2*f3*z[3]*z[8]*z[10]*z[14] -
4*f5*z[3]*z[8]*z[12]*z[14] + 4*f6*z[3]*z[8]*z[12]*z[15] - 2*z[3]*z[8]*z[12]*z[16]
+ 2*f7*z[3]*z[8]*z[14]*z[15] - 4*f8*z[3]*z[8]*z[15]^2 + (16*f0*f1*f8^2 -
8*f0*f3*f7^2 + 16*f0*f4*f5*f8 + 16*f0*f4*f6*f7 - 4*f0*f5^2*f7 + 8*f1^2*f7*f8 +
8*f1*f2*f7^2 + 12*f1*f3*f5*f8 - 16*f1*f3*f6*f7 + 8*f1*f4*f5*f7 - 16*f2^2*f5*f8 +
16*f2^2*f6*f7 + 16*f2*f3*f4*f8 - 8*f2*f3*f5*f7 + 16*f2*f4^2*f7 - 4*f3^3*f8 -
4*f3^2*f4*f7)*z[4]^2*z[9]^2 + (8*f0*f3*f8 - 16*f0*f4*f7 - 8*f1*f2*f8 + 12*f1*f3*f7
- 4*f1*f5^2 - 16*f2^2*f7 - 8*f2*f4*f5 + 2*f3^2*f5)*z[4]^2*z[9]*z[10] +
(-16*f0*f4*f8 + 16*f0*f5*f7 - 12*f1*f3*f8 - 8*f1*f4*f7 + 4*f1*f5*f6 + 16*f2^2*f8 +
8*f2*f3*f7 + 4*f2*f5^2)*z[4]^2*z[9]*z[11] + (-8*f0*f5*f8 + 16*f1*f4*f8 -
8*f1*f5*f7 - 8*f2*f3*f8 - 4*f3^2*f7 - 2*f3*f5^2)*z[4]^2*z[9]*z[12] + (-16*f0*f6*f7
- 2*f1*f5*f7 - 8*f2*f3*f8 - 16*f2*f4*f7 + 4*f3^2*f7)*z[4]^2*z[9]*z[13] +
(8*f0*f7^2 - 16*f1*f5*f8 + 16*f1*f6*f7 + 8*f3^2*f8 + 8*f3*f4*f7)*z[4]^2*z[9]*z[14]
+ (-8*f0*f7*f8 - 8*f1*f7^2 + 16*f2*f5*f8 - 16*f2*f6*f7 - 16*f3*f4*f8 + 8*f3*f5*f7
- 16*f4^2*f7)*z[4]^2*z[9]*z[15] + (-4*f1*f8 + 8*f2*f7 + 4*f4*f5)*z[4]^2*z[9]*z[16]
- 4*f0*f5*z[4]^2*z[10]^2 + 2*f1*f5*z[4]^2*z[10]*z[11] + 8*f0*f7*z[4]^2*z[10]*z[12]
+ (8*f0*f7 + 4*f2*f5)*z[4]^2*z[10]*z[13] + (-8*f0*f8 - 8*f1*f7 -
2*f3*f5)*z[4]^2*z[10]*z[14] + (4*f1*f8 + 8*f2*f7 + 4*f4*f5)*z[4]^2*z[10]*z[15] +
(-8*f0*f7 - 4*f2*f5)*z[4]^2*z[11]^2 + (8*f0*f8 + 8*f1*f7 +
4*f3*f5)*z[4]^2*z[11]*z[12] + 4*f1*f8*z[4]^2*z[11]*z[14] + (-8*f2*f8 - 4*f3*f7 -
2*f5^2)*z[4]^2*z[11]*z[15] + (-8*f1*f8 - 8*f2*f7 - 8*f4*f5)*z[4]^2*z[12]^2 -
4*f1*f8*z[4]^2*z[12]*z[13] + (8*f2*f8 + 4*f3*f7 + 4*f5^2)*z[4]^2*z[12]*z[14] +
(4*f3*f8 + 8*f4*f7 - 4*f5*f6)*z[4]^2*z[12]*z[15] + 6*f5*z[4]^2*z[12]*z[16] +
(4*f3*f8 + 8*f4*f7)*z[4]^2*z[13]*z[15] - 2*f5*z[4]^2*z[13]*z[16] + (-4*f3*f8 -
8*f4*f7)*z[4]^2*z[14]^2 + 2*f5*f7*z[4]^2*z[14]*z[15] - 4*f5*f8*z[4]^2*z[15]^2 +
(16*f0*f1*f8^2 + 16*f0*f2*f7*f8 - 16*f0*f3*f6*f8 + 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 +
4*f1^2*f7*f8 + 8*f1*f2*f7^2 - 4*f1*f3*f5*f8 + 16*f1*f4^2*f8 +
4*f1*f4*f5*f7)*z[4]*z[5]*z[9]^2 + (8*f0*f3*f8 - 8*f0*f5*f6 - 8*f1*f2*f8 -
4*f1*f3*f7 - 8*f1*f4*f6)*z[4]*z[5]*z[9]*z[10] + (-16*f0*f4*f8 - 16*f0*f5*f7 +
16*f0*f6^2 + 8*f1*f3*f8 + 4*f1*f5*f6)*z[4]*z[5]*z[9]*z[11] + (-8*f0*f5*f8 +
8*f0*f6*f7 + 12*f1*f5*f7 - 8*f1*f6^2)*z[4]*z[5]*z[9]*z[12] + (8*f0*f5*f8 -
8*f0*f6*f7 - 16*f1*f4*f8 - 4*f1*f5*f7)*z[4]*z[5]*z[9]*z[13] + (4*f0*f7^2 -
8*f1*f5*f8 + 4*f1*f6*f7 + 4*f3^2*f8)*z[4]*z[5]*z[9]*z[14] + (-16*f0*f7*f8 +
8*f1*f6*f8 - 12*f1*f7^2 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[4]*z[5]*z[9]*z[15] + (2*f1*f8
+ 3*f3*f6)*z[4]*z[5]*z[9]*z[16] + (4*f0*f5 + 4*f1*f4)*z[4]*z[5]*z[10]^2 +
(-8*f0*f6 - 4*f1*f5)*z[4]*z[5]*z[10]*z[11] + (-4*f0*f7 +
4*f1*f6)*z[4]*z[5]*z[10]*z[12] + 4*f1*f6*z[4]*z[5]*z[10]*z[13] +
4*f1*f7*z[4]*z[5]*z[10]*z[14] + (-2*f1*f8 + f3*f6)*z[4]*z[5]*z[10]*z[15] -
2*f3*z[4]*z[5]*z[10]*z[16] + 8*f0*f7*z[4]*z[5]*z[11]^2 + (8*f0*f8 -
4*f1*f7)*z[4]*z[5]*z[11]*z[12] + (-8*f0*f8 - 4*f1*f7)*z[4]*z[5]*z[11]*z[13] +
(-2*f1*f8 - f3*f6)*z[4]*z[5]*z[11]*z[14] + 4*f3*f7*z[4]*z[5]*z[11]*z[15] -
4*f1*f8*z[4]*z[5]*z[12]^2 + (2*f1*f8 + f3*f6)*z[4]*z[5]*z[12]*z[13] -
4*f3*f7*z[4]*z[5]*z[12]*z[14] + 4*f3*f8*z[4]*z[5]*z[12]*z[15] +
4*f1*f8*z[4]*z[5]*z[13]^2 + (16*f0*f3*f7*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8 -
16*f1^2*f8^2 - 24*f1*f2*f7*f8 + 8*f1*f3*f6*f8 + 12*f1*f3*f7^2 - 16*f1*f4*f5*f8 -
4*f1*f5^2*f7 - 16*f2^2*f7^2 + 8*f2*f3*f5*f8 - 32*f2*f4^2*f8 - 8*f2*f4*f5*f7 +
8*f3^2*f4*f8 + 2*f3^2*f5*f7)*z[4]*z[6]*z[9]^2 + (16*f0*f5*f7 - 8*f1*f3*f8 +
8*f1*f5*f6 + 16*f2^2*f8 + 8*f2*f3*f7 + 16*f2*f4*f6 -
4*f3^2*f6)*z[4]*z[6]*z[9]*z[10] + (8*f0*f5*f8 - 16*f0*f6*f7 + 16*f1*f4*f8 +
4*f1*f5*f7 - 8*f1*f6^2 - 16*f2*f3*f8 - 8*f2*f5*f6 -
4*f3^2*f7)*z[4]*z[6]*z[9]*z[11] + (16*f0*f6*f8 - 16*f0*f7^2 + 8*f1*f5*f8 +
4*f3^2*f8 + 4*f3*f5*f6)*z[4]*z[6]*z[9]*z[12] + (24*f0*f7^2 + 4*f1*f6*f7 +
32*f2*f4*f8 + 8*f2*f5*f7 - 4*f3^2*f8)*z[4]*z[6]*z[9]*z[13] + (-8*f0*f7*f8 -
16*f1*f7^2 - 16*f3*f4*f8 - 4*f3*f5*f7)*z[4]*z[6]*z[9]*z[14] + (24*f1*f7*f8 +
16*f2*f7^2 - 8*f3*f5*f8 + 32*f4^2*f8 + 8*f4*f5*f7)*z[4]*z[6]*z[9]*z[15] +
(-8*f2*f8 - 4*f3*f7 - 8*f4*f6)*z[4]*z[6]*z[9]*z[16] + (-4*f1*f5 - 8*f2*f4 +
2*f3^2)*z[4]*z[6]*z[10]^2 + (8*f0*f7 + 4*f1*f6 + 8*f2*f5)*z[4]*z[6]*z[10]*z[11] +
(-8*f0*f8 - 4*f3*f5)*z[4]*z[6]*z[10]*z[12] + (-8*f0*f8 - 4*f1*f7 -
8*f2*f6)*z[4]*z[6]*z[10]*z[13] + (8*f1*f8 + 4*f3*f6)*z[4]*z[6]*z[10]*z[14] +
(-8*f2*f8 - 4*f3*f7 - 8*f4*f6)*z[4]*z[6]*z[10]*z[15] + 8*f4*z[4]*z[6]*z[10]*z[16]
- 4*f1*f7*z[4]*z[6]*z[11]^2 - 8*f1*f8*z[4]*z[6]*z[11]*z[12] + (8*f1*f8 +
8*f2*f7)*z[4]*z[6]*z[11]*z[13] - 4*f3*f7*z[4]*z[6]*z[11]*z[14] + (8*f3*f8 +
4*f5*f6)*z[4]*z[6]*z[11]*z[15] - 4*f5*z[4]*z[6]*z[11]*z[16] + (8*f2*f8 + 4*f3*f7 +
4*f5^2)*z[4]*z[6]*z[12]^2 - 4*f3*f7*z[4]*z[6]*z[12]*z[13] + (-8*f3*f8 + 16*f4*f7 -
8*f5*f6)*z[4]*z[6]*z[12]*z[14] + (-16*f4*f8 - 12*f5*f7 +
8*f6^2)*z[4]*z[6]*z[12]*z[15] - 4*f6*z[4]*z[6]*z[12]*z[16] -
8*f2*f8*z[4]*z[6]*z[13]^2 + 8*f3*f8*z[4]*z[6]*z[13]*z[14] + (-16*f4*f8 -
4*f5*f7)*z[4]*z[6]*z[13]*z[15] + 4*f6*z[4]*z[6]*z[13]*z[16] +
4*f5*f7*z[4]*z[6]*z[14]^2 + (16*f5*f8 - 4*f6*f7)*z[4]*z[6]*z[14]*z[15] -
4*f7*z[4]*z[6]*z[14]*z[16] + (-8*f6*f8 + 4*f7^2)*z[4]*z[6]*z[15]^2 +
8*f8*z[4]*z[6]*z[15]*z[16] + (-32*f0*f3*f8^2 + 8*f0*f5*f7^2 + 16*f1*f2*f8^2 -
12*f1*f3*f7*f8 + 16*f1*f4*f6*f8 - 8*f1*f4*f7^2 + 4*f1*f5*f6*f7 + 16*f2^2*f7*f8 -
16*f2*f3*f6*f8 + 8*f2*f3*f7^2 + 16*f2*f4*f5*f8 + 4*f2*f5^2*f7)*z[4]*z[7]*z[9]^2 +
(16*f0*f5*f8 - 16*f0*f6*f7 + 4*f1*f5*f7 - 8*f1*f6^2 - 8*f2*f5*f6 -
4*f3^2*f7)*z[4]*z[7]*z[9]*z[10] + (16*f0*f6*f8 - 16*f0*f7^2 - 8*f1*f5*f8 +
8*f1*f6*f7 - 16*f2*f4*f8 - 16*f2*f5*f7 + 16*f2*f6^2 + 8*f3^2*f8 +
8*f3*f4*f7)*z[4]*z[7]*z[9]*z[11] + (-16*f1*f6*f8 + 16*f1*f7^2 + 8*f3*f4*f8 +
8*f3*f5*f7 - 8*f3*f6^2)*z[4]*z[7]*z[9]*z[12] + (8*f0*f7*f8 - 8*f1*f6*f8 +
8*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[4]*z[7]*z[9]*z[13] +
(16*f0*f8^2 - 4*f3*f5*f8 + 4*f3*f6*f7)*z[4]*z[7]*z[9]*z[14] + (-16*f2*f7*f8 +
16*f3*f6*f8 - 8*f3*f7^2 - 16*f4*f5*f8 - 4*f5^2*f7)*z[4]*z[7]*z[9]*z[15] +
4*f5*f6*z[4]*z[7]*z[9]*z[16] + (8*f0*f7 + 4*f1*f6 + 4*f2*f5)*z[4]*z[7]*z[10]^2 +
(-8*f0*f8 - 8*f1*f7 - 8*f2*f6 - 2*f3*f5)*z[4]*z[7]*z[10]*z[11] +
4*f3*f6*z[4]*z[7]*z[10]*z[12] + (4*f1*f8 + 4*f3*f6)*z[4]*z[7]*z[10]*z[13] +
4*f3*f7*z[4]*z[7]*z[10]*z[14] + (-4*f3*f8 + 4*f5*f6)*z[4]*z[7]*z[10]*z[15] -
4*f5*z[4]*z[7]*z[10]*z[16] + (4*f1*f8 + 8*f2*f7)*z[4]*z[7]*z[11]^2 -
8*f3*f7*z[4]*z[7]*z[11]*z[12] + (-8*f2*f8 - 4*f3*f7)*z[4]*z[7]*z[11]*z[13] +
(8*f4*f8 + 8*f5*f7 - 8*f6^2)*z[4]*z[7]*z[11]*z[15] + 4*f6*z[4]*z[7]*z[11]*z[16] +
(4*f3*f8 + 8*f4*f7 - 4*f5*f6)*z[4]*z[7]*z[12]^2 + 4*f3*f8*z[4]*z[7]*z[12]*z[13] +
(-16*f4*f8 - 12*f5*f7 + 8*f6^2)*z[4]*z[7]*z[12]*z[14] +
8*f6*f7*z[4]*z[7]*z[12]*z[15] - 8*f7*z[4]*z[7]*z[12]*z[16] +
4*f3*f8*z[4]*z[7]*z[13]^2 + (-4*f5*f8 + 4*f6*f7)*z[4]*z[7]*z[13]*z[15] + (8*f5*f8
- 4*f6*f7)*z[4]*z[7]*z[14]^2 - 8*f6*f8*z[4]*z[7]*z[14]*z[15] +
4*f8*z[4]*z[7]*z[14]*z[16] + 4*f7*f8*z[4]*z[7]*z[15]^2 + (-16*f0*f5*f8 -
8*f1*f4*f8 - 2*f1*f5*f7 - 16*f2*f4*f7 + 4*f3^2*f7)*z[4]*z[8]*z[9]^2 + (8*f0*f7 +
4*f1*f6 + 8*f2*f5)*z[4]*z[8]*z[9]*z[10] + (8*f0*f8 - 8*f2*f6 -
2*f3*f5)*z[4]*z[8]*z[9]*z[11] + 4*f3*f6*z[4]*z[8]*z[9]*z[12] + (4*f1*f8 +
12*f2*f7)*z[4]*z[8]*z[9]*z[13] - 10*f3*f7*z[4]*z[8]*z[9]*z[14] + (4*f3*f8 +
16*f4*f7)*z[4]*z[8]*z[9]*z[15] - 4*f5*z[4]*z[8]*z[9]*z[16] -
2*f1*z[4]*z[8]*z[10]^2 + 4*f2*z[4]*z[8]*z[10]*z[11] - 2*f3*z[4]*z[8]*z[10]*z[12] -
2*f3*z[4]*z[8]*z[10]*z[13] - 4*f5*z[4]*z[8]*z[10]*z[15] +
4*f6*z[4]*z[8]*z[11]*z[15] - 2*z[4]*z[8]*z[11]*z[16] + 6*f5*z[4]*z[8]*z[12]^2 -
4*f6*z[4]*z[8]*z[12]*z[14] - 8*f7*z[4]*z[8]*z[12]*z[15] -
6*f7*z[4]*z[8]*z[13]*z[15] + 6*f7*z[4]*z[8]*z[14]^2 + 4*f8*z[4]*z[8]*z[14]*z[15] +
(16*f0*f2*f7*f8 + 16*f0*f4*f5*f8)*z[5]^2*z[9]^2 + (-8*f0*f3*f8 -
8*f0*f4*f7)*z[5]^2*z[9]*z[10] + 4*f0*f5*f7*z[5]^2*z[9]*z[11] +
8*f0*f5*f8*z[5]^2*z[9]*z[12] - 16*f0*f5*f8*z[5]^2*z[9]*z[13] -
16*f0*f7*f8*z[5]^2*z[9]*z[15] + 4*f0*f7*z[5]^2*z[10]*z[13] +
8*f0*f8*z[5]^2*z[10]*z[14] - 4*f0*f7*z[5]^2*z[11]^2 - 8*f0*f8*z[5]^2*z[11]*z[13] +
4*f1*f8*z[5]^2*z[11]*z[14] + 4*f1*f8*z[5]^2*z[12]*z[13] -
8*f2*f8*z[5]^2*z[12]*z[14] + 4*f3*f8*z[5]^2*z[12]*z[15] - 4*f5*f8*z[5]^2*z[15]^2 +
2*f7*z[5]^2*z[15]*z[16] + (-32*f0*f2*f8^2 + 8*f0*f3*f7*f8 - 16*f0*f5^2*f8 -
16*f1*f2*f7*f8 - 16*f1*f4*f5*f8)*z[5]*z[6]*z[9]^2 + (8*f0*f5*f7 + 8*f1*f3*f8 +
8*f1*f4*f7)*z[5]*z[6]*z[9]*z[10] + (24*f0*f5*f8 - 8*f0*f6*f7 -
4*f1*f5*f7)*z[5]*z[6]*z[9]*z[11] + (-16*f0*f6*f8 - 8*f1*f5*f8 -
4*f3^2*f8)*z[5]*z[6]*z[9]*z[12] + (4*f0*f7^2 + 16*f1*f5*f8)*z[5]*z[6]*z[9]*z[13] -
8*f0*f7*f8*z[5]*z[6]*z[9]*z[14] + (32*f0*f8^2 + 16*f1*f7*f8 +
8*f3*f5*f8)*z[5]*z[6]*z[9]*z[15] - 2*f3*f7*z[5]*z[6]*z[9]*z[16] -
4*f0*f7*z[5]*z[6]*z[10]*z[11] + 8*f0*f8*z[5]*z[6]*z[10]*z[12] + (8*f0*f8 -
4*f1*f7)*z[5]*z[6]*z[10]*z[13] - 8*f1*f8*z[5]*z[6]*z[10]*z[14] -
2*f3*f7*z[5]*z[6]*z[10]*z[15] + 4*f1*f7*z[5]*z[6]*z[11]^2 -
4*f3*f8*z[5]*z[6]*z[11]*z[15] + 8*f3*f8*z[5]*z[6]*z[12]*z[14] + (-16*f0*f3*f8^2 -
16*f0*f4*f7*f8 + 4*f0*f5*f7^2 + 16*f1*f2*f8^2 + 4*f1*f3*f7*f8 +
8*f1*f5^2*f8)*z[5]*z[7]*z[9]^2 + (16*f0*f5*f8 - 8*f0*f6*f7 -
4*f1*f5*f7)*z[5]*z[7]*z[9]*z[10] + (-16*f0*f6*f8 - 12*f1*f5*f8 +
4*f1*f6*f7)*z[5]*z[7]*z[9]*z[11] + (16*f1*f6*f8 + 8*f3*f4*f8 +
2*f3*f5*f7)*z[5]*z[7]*z[9]*z[12] + (16*f0*f7*f8 - 2*f1*f7^2)*z[5]*z[7]*z[9]*z[13]
+ (16*f0*f8^2 - 8*f1*f7*f8 - 8*f3*f5*f8)*z[5]*z[7]*z[9]*z[14] -
16*f1*f8^2*z[5]*z[7]*z[9]*z[15] - 4*f3*f8*z[5]*z[7]*z[9]*z[16] +
4*f0*f7*z[5]*z[7]*z[10]^2 + (8*f0*f8 + 2*f1*f7)*z[5]*z[7]*z[10]*z[11] -
8*f1*f8*z[5]*z[7]*z[10]*z[12] - 4*f1*f8*z[5]*z[7]*z[10]*z[13] +
2*f3*f7*z[5]*z[7]*z[10]*z[14] - 4*f3*f7*z[5]*z[7]*z[11]*z[12] +
4*f3*f8*z[5]*z[7]*z[11]*z[14] + (4*f3*f8 + 8*f4*f7)*z[5]*z[7]*z[12]^2 + (-16*f4*f8
- 4*f5*f7)*z[5]*z[7]*z[12]*z[14] + (-4*f5*f8 + 4*f6*f7)*z[5]*z[7]*z[12]*z[15] -
6*f7*z[5]*z[7]*z[12]*z[16] + 8*f5*f8*z[5]*z[7]*z[14]^2 -
2*f7^2*z[5]*z[7]*z[14]*z[15] + 4*f8*z[5]*z[7]*z[14]*z[16] +
4*f7*f8*z[5]*z[7]*z[15]^2 + (-8*f1*f4*f8 - 2*f1*f5*f7)*z[5]*z[8]*z[9]^2 +
4*f1*f6*z[5]*z[8]*z[9]*z[10] - 4*f3*f6*z[5]*z[8]*z[9]*z[12] +
4*f1*f8*z[5]*z[8]*z[9]*z[13] + 2*f3*f7*z[5]*z[8]*z[9]*z[14] +
4*f3*f8*z[5]*z[8]*z[9]*z[15] - 2*f1*z[5]*z[8]*z[10]^2 + 2*f3*z[5]*z[8]*z[10]*z[12]
- 2*f5*z[5]*z[8]*z[12]^2 + 4*f6*z[5]*z[8]*z[12]*z[14] - 2*f7*z[5]*z[8]*z[14]^2 -
4*f8*z[5]*z[8]*z[14]*z[15] + (16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 - 4*f0*f5*f7^2 +
16*f1*f2*f8^2 - 12*f1*f3*f7*f8 + 8*f1*f5^2*f8 + 16*f2^2*f7*f8 + 16*f2*f4*f5*f8 -
4*f3^2*f5*f8)*z[6]^2*z[9]^2 + (-16*f0*f5*f8 - 4*f1*f5*f7 - 8*f2*f3*f8 - 8*f2*f4*f7
+ 2*f3^2*f7)*z[6]^2*z[9]*z[10] + (8*f0*f7^2 - 8*f1*f5*f8 + 4*f1*f6*f7 + 4*f2*f5*f7
+ 4*f3^2*f8)*z[6]^2*z[9]*z[11] + (16*f0*f7*f8 - 2*f3*f5*f7)*z[6]^2*z[9]*z[12] +
(-32*f0*f7*f8 - 2*f1*f7^2 - 16*f2*f5*f8)*z[6]^2*z[9]*z[13] + (16*f1*f7*f8 +
8*f3*f5*f8)*z[6]^2*z[9]*z[14] + (-16*f1*f8^2 - 16*f2*f7*f8 -
16*f4*f5*f8)*z[6]^2*z[9]*z[15] + (4*f3*f8 + 4*f4*f7)*z[6]^2*z[9]*z[16] -
4*f0*f7*z[6]^2*z[10]^2 + 2*f1*f7*z[6]^2*z[10]*z[11] + 4*f2*f7*z[6]^2*z[10]*z[13] -
2*f3*f7*z[6]^2*z[10]*z[14] + (4*f3*f8 + 4*f4*f7)*z[6]^2*z[10]*z[15] -
4*f2*f7*z[6]^2*z[11]^2 + 4*f3*f7*z[6]^2*z[11]*z[12] - 2*f5*f7*z[6]^2*z[11]*z[15] +
(-4*f3*f8 - 8*f4*f7)*z[6]^2*z[12]^2 + 4*f5*f7*z[6]^2*z[12]*z[14] + (8*f5*f8 -
4*f6*f7)*z[6]^2*z[12]*z[15] + 6*f7*z[6]^2*z[12]*z[16] + 8*f5*f8*z[6]^2*z[13]*z[15]
- 2*f7*z[6]^2*z[13]*z[16] - 8*f5*f8*z[6]^2*z[14]^2 + 2*f7^2*z[6]^2*z[14]*z[15] -
4*f7*f8*z[6]^2*z[15]^2 + (-16*f0*f5*f7*f8 + 16*f1*f3*f8^2 + 8*f1*f4*f7*f8 -
16*f1*f5*f6*f8 + 2*f1*f5*f7^2 - 32*f2^2*f8^2 - 8*f2*f3*f7*f8 -
16*f2*f5^2*f8)*z[6]*z[7]*z[9]^2 + (8*f0*f7^2 + 4*f1*f6*f7 + 8*f2*f5*f7 +
4*f3^2*f8)*z[6]*z[7]*z[9]*z[10] + (8*f0*f7*f8 + 8*f1*f6*f8 - 8*f1*f7^2 +
24*f2*f5*f8 - 8*f2*f6*f7 - 8*f3*f4*f8 - 2*f3*f5*f7)*z[6]*z[7]*z[9]*z[11] +
(-16*f0*f8^2 - 16*f1*f7*f8 - 12*f3*f5*f8 + 4*f3*f6*f7)*z[6]*z[7]*z[9]*z[12] +
(16*f0*f8^2 + 8*f1*f7*f8 + 4*f2*f7^2 + 8*f3*f5*f8)*z[6]*z[7]*z[9]*z[13] +
(-16*f1*f8^2 - 2*f3*f7^2)*z[6]*z[7]*z[9]*z[14] + (32*f2*f8^2 + 8*f3*f7*f8 +
16*f5^2*f8)*z[6]*z[7]*z[9]*z[15] - 4*f5*f7*z[6]*z[7]*z[9]*z[16] +
2*f1*f7*z[6]*z[7]*z[10]^2 + (-4*f1*f8 - 4*f2*f7)*z[6]*z[7]*z[10]*z[11] -
2*f3*f7*z[6]*z[7]*z[10]*z[12] + (8*f2*f8 - 2*f3*f7)*z[6]*z[7]*z[10]*z[13] -
4*f3*f8*z[6]*z[7]*z[10]*z[14] - 4*f5*f7*z[6]*z[7]*z[10]*z[15] +
4*f3*f7*z[6]*z[7]*z[11]^2 + 4*f3*f8*z[6]*z[7]*z[11]*z[12] -
4*f3*f8*z[6]*z[7]*z[11]*z[13] + (-12*f5*f8 + 4*f6*f7)*z[6]*z[7]*z[11]*z[15] +
2*f7*z[6]*z[7]*z[11]*z[16] + 2*f5*f7*z[6]*z[7]*z[12]^2 + (16*f5*f8 -
4*f6*f7)*z[6]*z[7]*z[12]*z[14] - 8*f6*f8*z[6]*z[7]*z[12]*z[15] +
4*f8*z[6]*z[7]*z[12]*z[16] - 2*f7^2*z[6]*z[7]*z[13]*z[15] -
4*f8*z[6]*z[7]*z[13]*z[16] + 2*f7^2*z[6]*z[7]*z[14]^2 + (8*f1*f5*f8 + 16*f2*f4*f8
+ 4*f2*f5*f7 - 4*f3^2*f8)*z[6]*z[8]*z[9]^2 + (-4*f1*f7 -
8*f2*f6)*z[6]*z[8]*z[9]*z[10] + (-4*f1*f8 + 4*f3*f6)*z[6]*z[8]*z[9]*z[11] +
4*f3*f7*z[6]*z[8]*z[9]*z[12] + (-8*f2*f8 - 2*f3*f7)*z[6]*z[8]*z[9]*z[13] +
4*f3*f8*z[6]*z[8]*z[9]*z[14] + (-16*f4*f8 - 4*f5*f7)*z[6]*z[8]*z[9]*z[15] +
4*f6*z[6]*z[8]*z[9]*z[16] + 4*f2*z[6]*z[8]*z[10]^2 - 2*f3*z[6]*z[8]*z[10]*z[11] +
4*f6*z[6]*z[8]*z[10]*z[15] - 4*z[6]*z[8]*z[10]*z[16] - 4*f7*z[6]*z[8]*z[12]*z[14]
+ 4*f8*z[6]*z[8]*z[12]*z[15] + 4*f8*z[6]*z[8]*z[13]*z[15] + (16*f0*f5*f8^2 -
16*f1*f4*f8^2 + 4*f1*f5*f7*f8 + 16*f2*f3*f8^2 + 16*f2*f5*f6*f8 -
4*f2*f5*f7^2)*z[7]^2*z[9]^2 + (-8*f0*f7*f8 + 8*f1*f6*f8 - 4*f1*f7^2 -
8*f2*f5*f8)*z[7]^2*z[9]*z[10] + (-16*f0*f8^2 + 4*f1*f7*f8 - 16*f2*f6*f8 +
8*f2*f7^2)*z[7]^2*z[9]*z[11] + (16*f1*f8^2 + 8*f3*f6*f8 -
4*f3*f7^2)*z[7]^2*z[9]*z[12] - 8*f2*f7*f8*z[7]^2*z[9]*z[13] +
4*f3*f7*f8*z[7]^2*z[9]*z[14] + (-16*f3*f8^2 - 16*f5*f6*f8 +
4*f5*f7^2)*z[7]^2*z[9]*z[15] + 4*f5*f8*z[7]^2*z[9]*z[16] + (-4*f1*f8 -
4*f2*f7)*z[7]^2*z[10]^2 + (8*f2*f8 + 4*f3*f7)*z[7]^2*z[10]*z[11] -
4*f3*f8*z[7]^2*z[10]*z[13] + 4*f5*f8*z[7]^2*z[10]*z[15] + 4*f7*z[7]^2*z[10]*z[16]
+ (-4*f3*f8 - 4*f4*f7)*z[7]^2*z[11]^2 + (8*f4*f8 + 2*f5*f7)*z[7]^2*z[11]*z[13] +
(8*f6*f8 - 4*f7^2)*z[7]^2*z[11]*z[15] - 4*f8*z[7]^2*z[11]*z[16] -
4*f5*f8*z[7]^2*z[12]^2 + (-8*f6*f8 + 4*f7^2)*z[7]^2*z[12]*z[14] +
4*f7*f8*z[7]^2*z[12]*z[15] - 4*f5*f8*z[7]^2*z[13]^2 + 4*f7*f8*z[7]^2*z[13]*z[15] -
4*f7*f8*z[7]^2*z[14]^2 - 16*f2*f5*f8*z[7]*z[8]*z[9]^2 +
8*f2*f7*z[7]*z[8]*z[9]*z[10] + (8*f2*f8 - 4*f3*f7)*z[7]*z[8]*z[9]*z[11] -
8*f3*f8*z[7]*z[8]*z[9]*z[12] + 4*f3*f8*z[7]*z[8]*z[9]*z[13] +
16*f5*f8*z[7]*z[8]*z[9]*z[15] - 4*f7*z[7]*z[8]*z[9]*z[16] -
4*f7*z[7]*z[8]*z[10]*z[15] + 2*f5*z[7]*z[8]*z[11]^2 - 4*f6*z[7]*z[8]*z[11]*z[13] -
4*f8*z[7]*z[8]*z[11]*z[15] + 8*f8*z[7]*z[8]*z[12]*z[14] + 2*f7*z[7]*z[8]*z[13]^2 +
2*z[8]^2*z[11]*z[13],

// Bmat[5,4]
  (-64*f0^2*f3*f5*f8^2 + 64*f0^2*f3*f6*f7*f8 - 16*f0^2*f3*f7^3 + 64*f0^2*f4^2*f8^2
- 32*f0^2*f4*f5*f7*f8 + 4*f0^2*f5^2*f7^2 + 64*f0*f1*f2*f5*f8^2 -
64*f0*f1*f2*f6*f7*f8 + 16*f0*f1*f2*f7^3 - 32*f0*f1*f3*f4*f8^2 +
8*f0*f1*f3*f5*f7*f8 - 16*f1^3*f5*f8^2 + 16*f1^3*f6*f7*f8 - 4*f1^3*f7^3 +
4*f1^2*f3^2*f8^2)*z[1]^2*z[9]^2 + (-16*f0^2*f3*f7*f8 - 32*f0^2*f4*f6*f8 +
16*f0^2*f4*f7^2 + 16*f0^2*f5^2*f8 - 8*f0^2*f5*f6*f7 + 16*f0*f1*f2*f7*f8 +
8*f0*f1*f3*f6*f8 - 4*f0*f1*f3*f7^2 - 4*f1^3*f7*f8)*z[1]^2*z[9]*z[10] +
(32*f0^2*f3*f8^2 - 32*f0*f1*f2*f8^2 + 16*f0*f1*f4*f6*f8 - 8*f0*f1*f4*f7^2 -
8*f0*f1*f5^2*f8 + 4*f0*f1*f5*f6*f7 + 8*f1^3*f8^2 - 4*f1^2*f3*f6*f8 +
2*f1^2*f3*f7^2)*z[1]^2*z[9]*z[11] + (-32*f0^2*f4*f8^2 + 8*f0^2*f5*f7*f8 +
8*f0*f1*f3*f8^2 + 32*f0*f2*f4*f6*f8 - 16*f0*f2*f4*f7^2 - 16*f0*f2*f5^2*f8 +
8*f0*f2*f5*f6*f7 - 16*f0*f3^2*f6*f8 + 8*f0*f3^2*f7^2 + 8*f0*f3*f4*f5*f8 -
2*f0*f3*f5^2*f7 - 16*f1^2*f4*f6*f8 + 8*f1^2*f4*f7^2 + 8*f1^2*f5^2*f8 -
4*f1^2*f5*f6*f7 + 8*f1*f2*f3*f6*f8 - 4*f1*f2*f3*f7^2 -
2*f1*f3^2*f5*f8)*z[1]^2*z[9]*z[12] + (-32*f0^2*f4*f8^2 + 8*f0^2*f5*f7*f8 +
8*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 - 2*f0*f1*f5*f7^2 -
2*f1^2*f3*f7*f8)*z[1]^2*z[9]*z[13] + (32*f0^2*f5*f8^2 - 32*f0^2*f6*f7*f8 +
8*f0^2*f7^3 + 16*f0*f2*f4*f7*f8 - 4*f0*f2*f5*f7^2 - 8*f0*f3^2*f7*f8 -
8*f1^2*f4*f7*f8 + 2*f1^2*f5*f7^2 + 4*f1*f2*f3*f7*f8)*z[1]^2*z[9]*z[14] +
(-16*f0*f1*f5*f8^2 + 16*f0*f1*f6*f7*f8 - 4*f0*f1*f7^3 - 32*f0*f2*f4*f8^2 +
8*f0*f2*f5*f7*f8 + 16*f0*f3^2*f8^2 + 16*f1^2*f4*f8^2 - 4*f1^2*f5*f7*f8 -
8*f1*f2*f3*f8^2)*z[1]^2*z[9]*z[15] + (-16*f0^2*f4*f8 + 12*f0^2*f5*f7 +
4*f0*f1*f3*f8 + 8*f0*f2*f3*f7 - 2*f1^2*f3*f7)*z[1]^2*z[10]^2 + (-16*f0^2*f6*f7 +
8*f0*f1*f4*f8 - 6*f0*f1*f5*f7 - 16*f0*f2*f3*f8 - 8*f0*f3^2*f7 +
2*f1^2*f3*f8)*z[1]^2*z[10]*z[11] + (32*f0^2*f6*f8 - 8*f0^2*f7^2 - 8*f0*f1*f5*f8 +
8*f0*f1*f6*f7 + 16*f0*f2*f4*f8 - 12*f0*f2*f5*f7 + 8*f0*f3*f4*f7 - 8*f1^2*f4*f8 +
6*f1^2*f5*f7 + 4*f1*f2*f3*f8 + 2*f1*f3^2*f7)*z[1]^2*z[10]*z[12] + (8*f0^2*f7^2 +
8*f0*f3^2*f8)*z[1]^2*z[10]*z[13] + (-4*f0*f1*f7^2 - 8*f0*f3*f4*f8 + 2*f0*f3*f5*f7
- 2*f1*f3^2*f8)*z[1]^2*z[10]*z[14] - 8*f0*f3*f7*z[1]^2*z[10]*z[16] + (8*f0^2*f7^2
+ 8*f0*f1*f6*f7 + 8*f0*f3^2*f8 + 8*f0*f3*f4*f7)*z[1]^2*z[11]^2 + (-16*f0^2*f7*f8 -
16*f0*f1*f6*f8 - 4*f0*f1*f7^2 + 16*f0*f2*f5*f8 - 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 -
16*f0*f4^2*f7 - 8*f1^2*f6*f7 - 4*f1*f3^2*f8 - 4*f1*f3*f4*f7)*z[1]^2*z[11]*z[12] +
(-16*f0^2*f7*f8 - 8*f0*f1*f7^2 - 16*f0*f3*f4*f8 -
4*f0*f3*f5*f7)*z[1]^2*z[11]*z[13] + (16*f0*f1*f7*f8 + 16*f0*f4^2*f8 +
4*f0*f4*f5*f7 + 4*f1^2*f7^2 + 4*f1*f3*f4*f8)*z[1]^2*z[11]*z[14] + (-8*f0*f4*f5*f8
- 2*f0*f5^2*f7 - 4*f1^2*f7*f8 + 2*f1*f3*f5*f8)*z[1]^2*z[11]*z[15] + (8*f0*f3*f8 +
8*f0*f4*f7 + 2*f1*f3*f7)*z[1]^2*z[11]*z[16] + (8*f0*f1*f7*f8 - 32*f0*f2*f6*f8 +
16*f0*f2*f7^2 + 8*f0*f3*f5*f8 - 8*f0*f3*f6*f7 + 8*f0*f4*f5*f7 + 16*f1^2*f6*f8 -
4*f1^2*f7^2 - 8*f1*f2*f5*f8 + 8*f1*f2*f6*f7 + 8*f1*f3*f4*f8 - 4*f1*f3*f5*f7 +
8*f1*f4^2*f7)*z[1]^2*z[12]^2 + (32*f0^2*f8^2 + 8*f0*f1*f7*f8 - 8*f0*f3*f5*f8 +
16*f0*f4^2*f8 + 4*f0*f4*f5*f7 + 4*f1^2*f7^2 + 4*f1*f3*f4*f8 +
2*f1*f3*f5*f7)*z[1]^2*z[12]*z[13] + (-16*f0*f1*f8^2 - 16*f0*f2*f7*f8 +
16*f0*f3*f6*f8 - 16*f0*f4*f5*f8 - 4*f0*f5^2*f7 - 4*f1^2*f7*f8 - 8*f1*f2*f7^2 +
4*f1*f3*f5*f8 - 16*f1*f4^2*f8 - 4*f1*f4*f5*f7)*z[1]^2*z[12]*z[14] + (32*f0*f2*f8^2
- 8*f0*f3*f7*f8 + 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 + 4*f0*f5*f6*f7 - 8*f1^2*f8^2 +
8*f1*f2*f7*f8 - 12*f1*f3*f6*f8 + 6*f1*f3*f7^2 + 8*f1*f4*f5*f8 +
2*f1*f5^2*f7)*z[1]^2*z[12]*z[15] + (-8*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8 -
8*f1*f4*f7)*z[1]^2*z[12]*z[16] + (8*f0*f1*f7*f8 + 8*f0*f3*f5*f8)*z[1]^2*z[13]^2 +
(-16*f0*f1*f8^2 - 16*f0*f4*f5*f8 - 8*f1^2*f7*f8 -
4*f1*f3*f5*f8)*z[1]^2*z[13]*z[14] + (8*f0*f5^2*f8 +
8*f1^2*f8^2)*z[1]^2*z[13]*z[15] + (-8*f0*f4*f8 - 2*f0*f5*f7 -
2*f1*f3*f8)*z[1]^2*z[13]*z[16] + (8*f0*f5^2*f8 + 8*f1^2*f8^2 + 8*f1*f2*f7*f8 +
8*f1*f4*f5*f8)*z[1]^2*z[14]^2 + (8*f0*f4*f7*f8 - 16*f0*f5*f6*f8 + 2*f0*f5*f7^2 -
16*f1*f2*f8^2 - 6*f1*f3*f7*f8 - 8*f1*f5^2*f8)*z[1]^2*z[14]*z[15] + (8*f0*f5*f8 +
8*f1*f4*f8 + 2*f1*f5*f7)*z[1]^2*z[14]*z[16] + (-16*f0*f4*f8^2 + 4*f0*f5*f7*f8 +
12*f1*f3*f8^2 + 8*f1*f5*f6*f8 - 2*f1*f5*f7^2)*z[1]^2*z[15]^2 -
8*f1*f5*f8*z[1]^2*z[15]*z[16] + (-16*f0^2*f3*f7*f8 - 32*f0^2*f4*f6*f8 +
16*f0^2*f4*f7^2 + 16*f0^2*f5^2*f8 - 8*f0^2*f5*f6*f7 + 16*f0*f1*f2*f7*f8 +
8*f0*f1*f3*f6*f8 - 4*f0*f1*f3*f7^2 - 4*f1^3*f7*f8)*z[1]*z[2]*z[9]^2 +
(64*f0^2*f4*f8 - 32*f0^2*f5*f7 + 16*f0^2*f6^2 - 16*f0*f1*f3*f8 - 16*f0*f2*f3*f7 +
4*f1^2*f3*f7)*z[1]*z[2]*z[9]*z[10] + (-16*f0^2*f5*f8 + 16*f0^2*f6*f7 -
16*f0*f1*f4*f8 + 12*f0*f1*f5*f7 - 8*f0*f1*f6^2 + 16*f0*f2*f3*f8 +
8*f0*f3^2*f7)*z[1]*z[2]*z[9]*z[11] + (-16*f0^2*f6*f8 + 8*f0*f1*f5*f8 -
8*f0*f1*f6*f7 - 32*f0*f2*f4*f8 + 24*f0*f2*f5*f7 - 16*f0*f2*f6^2 + 8*f0*f3^2*f8 -
16*f0*f3*f4*f7 + 4*f0*f3*f5*f6 + 16*f1^2*f4*f8 - 12*f1^2*f5*f7 + 8*f1^2*f6^2 -
8*f1*f2*f3*f8)*z[1]*z[2]*z[9]*z[12] + (16*f0^2*f6*f8 - 16*f0^2*f7^2 -
8*f0*f1*f5*f8 + 4*f0*f1*f6*f7 - 8*f0*f3^2*f8)*z[1]*z[2]*z[9]*z[13] +
(16*f0^2*f7*f8 + 4*f0*f1*f7^2 - 16*f0*f2*f5*f8 + 8*f0*f2*f6*f7 + 16*f0*f3*f4*f8 +
8*f1^2*f5*f8 - 4*f1^2*f6*f7)*z[1]*z[2]*z[9]*z[14] + (-8*f0*f1*f7*f8 +
16*f0*f2*f6*f8 - 8*f0*f2*f7^2 - 8*f0*f3*f5*f8 - 8*f1^2*f6*f8 +
4*f1^2*f7^2)*z[1]*z[2]*z[9]*z[15] + (-4*f0*f2*f8 + 10*f0*f3*f7 + 2*f1^2*f8 -
f1*f3*f6)*z[1]*z[2]*z[9]*z[16] - 8*f0^2*f6*z[1]*z[2]*z[10]^2 + (16*f0^2*f7 +
4*f0*f1*f6)*z[1]*z[2]*z[10]*z[11] + (-16*f0^2*f8 - 4*f0*f1*f7 + 8*f0*f2*f6 -
4*f1^2*f6)*z[1]*z[2]*z[10]*z[12] + (-16*f0^2*f8 +
4*f0*f1*f7)*z[1]*z[2]*z[10]*z[13] + (8*f0*f2*f7 - 4*f0*f3*f6 -
4*f1^2*f7)*z[1]*z[2]*z[10]*z[14] + (-12*f0*f2*f8 + 6*f0*f3*f7 + 6*f1^2*f8 +
f1*f3*f6)*z[1]*z[2]*z[10]*z[15] + (-12*f0*f1*f7 - 4*f0*f3*f5)*z[1]*z[2]*z[11]^2 +
(16*f0*f1*f8 - 8*f0*f2*f7 + 8*f0*f4*f5 + 12*f1^2*f7 +
2*f1*f3*f5)*z[1]*z[2]*z[11]*z[12] + (8*f0*f1*f8 +
8*f0*f3*f6)*z[1]*z[2]*z[11]*z[13] + (-4*f0*f2*f8 - 2*f0*f3*f7 - 8*f0*f4*f6 -
2*f1^2*f8 - f1*f3*f6)*z[1]*z[2]*z[11]*z[14] + (4*f0*f5*f6 -
4*f1*f3*f7)*z[1]*z[2]*z[11]*z[15] - 4*f0*f5*z[1]*z[2]*z[11]*z[16] + (16*f0*f2*f8 +
4*f0*f3*f7 - 4*f0*f5^2 - 12*f1^2*f8 - 8*f1*f2*f7 - 4*f1*f4*f5)*z[1]*z[2]*z[12]^2 +
(4*f0*f2*f8 + 2*f0*f3*f7 - 8*f0*f4*f6 - 6*f1^2*f8 -
3*f1*f3*f6)*z[1]*z[2]*z[12]*z[13] + (-8*f0*f3*f8 + 8*f0*f5*f6 + 8*f1*f2*f8 +
4*f1*f3*f7 + 8*f1*f4*f6)*z[1]*z[2]*z[12]*z[14] + (4*f0*f5*f7 - 8*f0*f6^2 +
4*f1*f3*f8 - 4*f1*f5*f6)*z[1]*z[2]*z[12]*z[15] + (4*f0*f6 +
4*f1*f5)*z[1]*z[2]*z[12]*z[16] - 4*f0*f3*f7*z[1]*z[2]*z[13]^2 + (8*f0*f4*f7 +
2*f1*f3*f7)*z[1]*z[2]*z[13]*z[14] + (-4*f0*f5*f7 +
4*f1*f3*f8)*z[1]*z[2]*z[13]*z[15] + 4*f0*f6*z[1]*z[2]*z[13]*z[16] + (-4*f0*f5*f7 -
4*f1*f3*f8 - 4*f1*f4*f7)*z[1]*z[2]*z[14]^2 + (4*f0*f6*f7 +
4*f1*f5*f7)*z[1]*z[2]*z[14]*z[15] + (-4*f0*f7 - 4*f1*f6)*z[1]*z[2]*z[14]*z[16] +
(8*f0*f6*f8 - 4*f0*f7^2 - 4*f1*f5*f8)*z[1]*z[2]*z[15]^2 +
4*f1*f7*z[1]*z[2]*z[15]*z[16] + (32*f0^2*f3*f8^2 - 32*f0*f1*f2*f8^2 +
16*f0*f1*f4*f6*f8 - 8*f0*f1*f4*f7^2 - 8*f0*f1*f5^2*f8 + 4*f0*f1*f5*f6*f7 +
8*f1^3*f8^2 - 4*f1^2*f3*f6*f8 + 2*f1^2*f3*f7^2)*z[1]*z[3]*z[9]^2 + (-16*f0^2*f5*f8
+ 16*f0^2*f6*f7 - 16*f0*f1*f4*f8 + 12*f0*f1*f5*f7 - 8*f0*f1*f6^2 + 16*f0*f2*f3*f8
+ 8*f0*f3^2*f7)*z[1]*z[3]*z[9]*z[10] + (-16*f0^2*f7^2 + 16*f0*f1*f5*f8 -
16*f0*f1*f6*f7 - 16*f0*f3^2*f8 - 16*f0*f3*f4*f7 - 4*f1^2*f5*f7 +
4*f1^2*f6^2)*z[1]*z[3]*z[9]*z[11] + (16*f0^2*f7*f8 + 8*f0*f1*f6*f8 + 8*f0*f1*f7^2
+ 16*f0*f3*f4*f8 - 20*f0*f3*f5*f7 + 16*f0*f3*f6^2 + 32*f0*f4^2*f7 - 16*f0*f4*f5*f6
+ 4*f0*f5^3 - 8*f1^2*f5*f8 + 8*f1^2*f6*f7 + 8*f1*f2*f5*f7 - 8*f1*f2*f6^2 +
4*f1*f3^2*f8 + 2*f1*f3*f5*f6)*z[1]*z[3]*z[9]*z[12] + (16*f0^2*f7*f8 -
8*f0*f1*f6*f8 + 12*f0*f1*f7^2 + 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 + 4*f1^2*f5*f8 -
2*f1^2*f6*f7)*z[1]*z[3]*z[9]*z[13] + (-32*f0^2*f8^2 - 16*f0*f1*f7*f8 +
16*f0*f3*f5*f8 - 8*f0*f3*f6*f7 - 32*f0*f4^2*f8 - 4*f1^2*f7^2 - 8*f1*f2*f5*f8 +
4*f1*f2*f6*f7 - 2*f1*f3*f5*f7)*z[1]*z[3]*z[9]*z[14] + (16*f0*f1*f8^2 -
16*f0*f3*f6*f8 + 8*f0*f3*f7^2 + 16*f0*f4*f5*f8 + 4*f1^2*f7*f8 + 8*f1*f2*f6*f8 -
4*f1*f2*f7^2)*z[1]*z[3]*z[9]*z[15] + (-4*f0*f3*f8 - 12*f0*f4*f7 + 2*f0*f5*f6 -
2*f1*f2*f8 - 2*f1*f3*f7 + 2*f1*f4*f6 - f1*f5^2)*z[1]*z[3]*z[9]*z[16] + (-8*f0^2*f7
+ 4*f0*f1*f6)*z[1]*z[3]*z[10]^2 + (4*f0*f1*f7 + 4*f0*f3*f5 -
2*f1^2*f6)*z[1]*z[3]*z[10]*z[11] + (-8*f0*f3*f6 - 4*f1^2*f7 + 4*f1*f2*f6 -
2*f1*f3*f5)*z[1]*z[3]*z[10]*z[12] + (-8*f0*f3*f6 -
2*f1^2*f7)*z[1]*z[3]*z[10]*z[13] + (-8*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 +
4*f1^2*f8 + 4*f1*f2*f7 + 2*f1*f3*f6)*z[1]*z[3]*z[10]*z[14] + (4*f0*f3*f8 -
4*f0*f4*f7 - 2*f0*f5*f6 - 6*f1*f2*f8 - 2*f1*f3*f7 - 2*f1*f4*f6 +
f1*f5^2)*z[1]*z[3]*z[10]*z[15] + 2*f1^2*f7*z[1]*z[3]*z[11]^2 + (8*f0*f3*f7 -
4*f0*f5^2 - 4*f1^2*f8 - 4*f1*f2*f7)*z[1]*z[3]*z[11]*z[12] +
8*f0*f3*f7*z[1]*z[3]*z[11]*z[13] + (4*f0*f3*f8 - 4*f0*f4*f7 + 2*f0*f5*f6 -
2*f1*f2*f8 - 2*f1*f3*f7 - 2*f1*f4*f6 + f1*f5^2)*z[1]*z[3]*z[11]*z[14] +
(4*f0*f5*f7 + 4*f1*f3*f8 + 8*f1*f4*f7 - 2*f1*f5*f6)*z[1]*z[3]*z[11]*z[15] +
(-8*f0*f3*f8 - 16*f0*f4*f7 + 8*f0*f5*f6 + 8*f1*f2*f8 + 6*f1*f3*f7 +
2*f1*f5^2)*z[1]*z[3]*z[12]^2 + (-4*f0*f3*f8 - 12*f0*f4*f7 + 6*f0*f5*f6 +
2*f1*f2*f8 - 2*f1*f3*f7 + 2*f1*f4*f6 - f1*f5^2)*z[1]*z[3]*z[12]*z[13] +
(16*f0*f4*f8 + 16*f0*f5*f7 - 16*f0*f6^2 - 8*f1*f3*f8 -
4*f1*f5*f6)*z[1]*z[3]*z[12]*z[14] + (-8*f0*f5*f8 - 8*f1*f4*f8 - 12*f1*f5*f7 +
12*f1*f6^2)*z[1]*z[3]*z[12]*z[15] + (8*f0*f7 - 6*f1*f6)*z[1]*z[3]*z[12]*z[16] -
8*f0*f3*f8*z[1]*z[3]*z[13]^2 + (16*f0*f4*f8 - 4*f0*f5*f7 +
4*f1*f3*f8)*z[1]*z[3]*z[13]*z[14] + (-8*f0*f5*f8 -
8*f1*f4*f8)*z[1]*z[3]*z[13]*z[15] + 2*f1*f6*z[1]*z[3]*z[13]*z[16] + (-16*f0*f5*f8
+ 8*f0*f6*f7 + 2*f1*f5*f7)*z[1]*z[3]*z[14]^2 + (16*f0*f6*f8 - 8*f0*f7^2 +
16*f1*f5*f8 - 6*f1*f6*f7)*z[1]*z[3]*z[14]*z[15] + (-8*f0*f8 -
2*f1*f7)*z[1]*z[3]*z[14]*z[16] + (-12*f1*f6*f8 + 6*f1*f7^2)*z[1]*z[3]*z[15]^2 +
8*f1*f8*z[1]*z[3]*z[15]*z[16] + (-32*f0^2*f4*f8^2 + 8*f0^2*f5*f7*f8 +
8*f0*f1*f3*f8^2 + 32*f0*f2*f4*f6*f8 - 16*f0*f2*f4*f7^2 - 16*f0*f2*f5^2*f8 +
8*f0*f2*f5*f6*f7 - 16*f0*f3^2*f6*f8 + 8*f0*f3^2*f7^2 + 8*f0*f3*f4*f5*f8 -
2*f0*f3*f5^2*f7 - 16*f1^2*f4*f6*f8 + 8*f1^2*f4*f7^2 + 8*f1^2*f5^2*f8 -
4*f1^2*f5*f6*f7 + 8*f1*f2*f3*f6*f8 - 4*f1*f2*f3*f7^2 -
2*f1*f3^2*f5*f8)*z[1]*z[4]*z[9]^2 + (-16*f0^2*f6*f8 + 8*f0*f1*f5*f8 -
8*f0*f1*f6*f7 - 32*f0*f2*f4*f8 + 24*f0*f2*f5*f7 - 16*f0*f2*f6^2 + 8*f0*f3^2*f8 -
16*f0*f3*f4*f7 + 4*f0*f3*f5*f6 + 16*f1^2*f4*f8 - 12*f1^2*f5*f7 + 8*f1^2*f6^2 -
8*f1*f2*f3*f8)*z[1]*z[4]*z[9]*z[10] + (16*f0^2*f7*f8 + 8*f0*f1*f6*f8 +
8*f0*f1*f7^2 + 16*f0*f3*f4*f8 - 20*f0*f3*f5*f7 + 16*f0*f3*f6^2 + 32*f0*f4^2*f7 -
16*f0*f4*f5*f6 + 4*f0*f5^3 - 8*f1^2*f5*f8 + 8*f1^2*f6*f7 + 8*f1*f2*f5*f7 -
8*f1*f2*f6^2 + 4*f1*f3^2*f8 + 2*f1*f3*f5*f6)*z[1]*z[4]*z[9]*z[11] + (16*f0^2*f8^2
- 16*f0*f1*f7*f8 + 32*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 24*f0*f3*f5*f8 +
16*f0*f3*f6*f7 - 16*f0*f4*f5*f7 - 16*f1^2*f6*f8 + 16*f1*f2*f5*f8 - 16*f1*f2*f6*f7
- 16*f1*f3*f4*f8 + 24*f1*f3*f5*f7 - 16*f1*f3*f6^2 - 32*f1*f4^2*f7 + 16*f1*f4*f5*f6
- 4*f1*f5^3 - 16*f2^2*f5*f7 + 16*f2^2*f6^2 + 16*f2*f3*f4*f7 - 8*f2*f3*f5*f6 -
4*f3^3*f7 + f3^2*f5^2)*z[1]*z[4]*z[9]*z[12] + (-16*f0^2*f8^2 - 12*f0*f1*f7*f8 -
16*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 20*f0*f3*f5*f8 - 8*f0*f3*f6*f7 - 32*f0*f4^2*f8 +
8*f1^2*f6*f8 - 8*f1^2*f7^2 - 8*f1*f2*f5*f8 + 4*f1*f2*f6*f7 -
f1*f3*f5*f7)*z[1]*z[4]*z[9]*z[13] + (16*f0*f1*f8^2 + 8*f0*f2*f7*f8 - 8*f0*f3*f7^2
+ 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 + 8*f1^2*f7*f8 + 8*f1*f2*f7^2 - 20*f1*f3*f5*f8 +
8*f1*f3*f6*f7 + 32*f1*f4^2*f8 + 16*f2^2*f5*f8 - 8*f2^2*f6*f7 - 16*f2*f3*f4*f8 +
2*f2*f3*f5*f7 + 4*f3^3*f8)*z[1]*z[4]*z[9]*z[14] + (-16*f0*f2*f8^2 + 8*f0*f3*f7*f8
- 32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 8*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 8*f1*f2*f7*f8 +
24*f1*f3*f6*f8 - 12*f1*f3*f7^2 - 16*f1*f4*f5*f8 - 16*f2^2*f6*f8 + 8*f2^2*f7^2 +
4*f2*f3*f5*f8)*z[1]*z[4]*z[9]*z[15] + (12*f0*f4*f8 - 2*f0*f5*f7 + 4*f0*f6^2 -
2*f1*f3*f8 + 12*f1*f4*f7 - 2*f1*f5*f6 + 4*f2^2*f8 - 2*f2*f3*f7 - 4*f2*f4*f6 +
2*f2*f5^2 + 2*f3^2*f6 - f3*f4*f5)*z[1]*z[4]*z[9]*z[16] + (8*f0^2*f8 + 4*f0*f1*f7 +
8*f0*f2*f6 - 2*f0*f3*f5 - 4*f1^2*f6)*z[1]*z[4]*z[10]^2 + (-12*f0*f1*f8 -
8*f0*f2*f7 - 8*f0*f3*f6 + 4*f1*f2*f6 - f1*f3*f5)*z[1]*z[4]*z[10]*z[11] +
(-8*f0*f2*f8 + 4*f0*f5^2 + 8*f1^2*f8 + 8*f1*f2*f7 + 8*f1*f3*f6 - 8*f2^2*f6 +
2*f2*f3*f5)*z[1]*z[4]*z[10]*z[12] + (16*f0*f2*f8 - 4*f0*f3*f7 + 16*f0*f4*f6 -
4*f0*f5^2 - 4*f1^2*f8 + 4*f1*f2*f7)*z[1]*z[4]*z[10]*z[13] + (4*f0*f3*f8 +
8*f0*f4*f7 - 8*f0*f5*f6 - 8*f1*f2*f8 + 4*f1*f3*f7 - 16*f1*f4*f6 + 4*f1*f5^2 -
8*f2^2*f7 + 4*f2*f3*f6 - f3^2*f5)*z[1]*z[4]*z[10]*z[14] + (4*f0*f4*f8 -
10*f0*f5*f7 + 12*f0*f6^2 - 10*f1*f3*f8 + 4*f1*f4*f7 + 2*f1*f5*f6 + 12*f2^2*f8 +
2*f2*f3*f7 + 4*f2*f4*f6 - 2*f2*f5^2 - 2*f3^2*f6 + f3*f4*f5)*z[1]*z[4]*z[10]*z[15]
- 8*f0*f6*z[1]*z[4]*z[10]*z[16] + (8*f0*f3*f7 + 4*f1^2*f8 -
4*f1*f2*f7)*z[1]*z[4]*z[11]^2 + (8*f0*f3*f8 - 8*f1*f2*f8 - 12*f1*f3*f7 +
8*f2^2*f7)*z[1]*z[4]*z[11]*z[12] + (-8*f0*f3*f8 -
16*f0*f4*f7)*z[1]*z[4]*z[11]*z[13] + (-12*f0*f4*f8 + 2*f0*f5*f7 + 4*f0*f6^2 +
2*f1*f3*f8 + 4*f1*f4*f7 + 2*f1*f5*f6 + 4*f2^2*f8 + 2*f2*f3*f7 + 4*f2*f4*f6 -
2*f2*f5^2 - 2*f3^2*f6 + f3*f4*f5)*z[1]*z[4]*z[11]*z[14] + (4*f0*f5*f8 - 8*f0*f6*f7
+ 8*f1*f4*f8 + 4*f1*f5*f7 - 8*f1*f6^2 - 8*f2*f3*f8 - 16*f2*f4*f7 + 4*f2*f5*f6 +
4*f3^2*f7 - f3*f5^2)*z[1]*z[4]*z[11]*z[15] + (4*f0*f7 +
4*f1*f6)*z[1]*z[4]*z[11]*z[16] + (8*f1*f4*f7 - 4*f1*f5*f6 -
4*f2*f3*f7)*z[1]*z[4]*z[12]^2 + (-4*f0*f4*f8 + 10*f0*f5*f7 - 4*f0*f6^2 +
10*f1*f3*f8 + 12*f1*f4*f7 - 2*f1*f5*f6 - 4*f2^2*f8 - 2*f2*f3*f7 - 4*f2*f4*f6 +
2*f2*f5^2 + 2*f3^2*f6 - f3*f4*f5)*z[1]*z[4]*z[12]*z[13] + (8*f0*f5*f8 - 8*f0*f6*f7
- 12*f1*f5*f7 + 8*f1*f6^2)*z[1]*z[4]*z[12]*z[14] + (-8*f0*f6*f8 + 8*f0*f7^2 +
8*f1*f6*f7 + 8*f2*f5*f7 - 8*f2*f6^2 + 4*f3^2*f8 +
2*f3*f5*f6)*z[1]*z[4]*z[12]*z[15] + (4*f0*f8 - 8*f1*f7 + 4*f2*f6 -
f3*f5)*z[1]*z[4]*z[12]*z[16] + 16*f0*f4*f8*z[1]*z[4]*z[13]^2 + (-8*f0*f5*f8 -
16*f1*f4*f8)*z[1]*z[4]*z[13]*z[14] + (16*f0*f6*f8 - 4*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7 + 16*f2*f4*f8 - 4*f3^2*f8)*z[1]*z[4]*z[13]*z[15] + (-4*f0*f8 - 4*f2*f6
+ f3*f5)*z[1]*z[4]*z[13]*z[16] + (4*f0*f7^2 + 8*f1*f5*f8 -
4*f1*f6*f7)*z[1]*z[4]*z[14]^2 + (-12*f0*f7*f8 - 8*f1*f6*f8 - 8*f2*f5*f8 +
4*f2*f6*f7 - f3*f5*f7)*z[1]*z[4]*z[14]*z[15] + (4*f1*f8 +
4*f2*f7)*z[1]*z[4]*z[14]*z[16] + (8*f0*f8^2 + 4*f1*f7*f8 + 8*f2*f6*f8 - 4*f2*f7^2
- 2*f3*f5*f8)*z[1]*z[4]*z[15]^2 - 8*f2*f8*z[1]*z[4]*z[15]*z[16] +
(-32*f0^2*f4*f8^2 + 8*f0^2*f5*f7*f8 + 8*f0*f1*f3*f8^2 + 8*f0*f1*f4*f7*f8 -
2*f0*f1*f5*f7^2 - 2*f1^2*f3*f7*f8)*z[1]*z[5]*z[9]^2 + (16*f0^2*f6*f8 -
16*f0^2*f7^2 - 8*f0*f1*f5*f8 + 4*f0*f1*f6*f7 - 8*f0*f3^2*f8)*z[1]*z[5]*z[9]*z[10]
+ (16*f0^2*f7*f8 - 8*f0*f1*f6*f8 + 12*f0*f1*f7^2 + 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7
+ 4*f1^2*f5*f8 - 2*f1^2*f6*f7)*z[1]*z[5]*z[9]*z[11] + (-16*f0^2*f8^2 -
12*f0*f1*f7*f8 - 16*f0*f2*f6*f8 + 8*f0*f2*f7^2 + 20*f0*f3*f5*f8 - 8*f0*f3*f6*f7 -
32*f0*f4^2*f8 + 8*f1^2*f6*f8 - 8*f1^2*f7^2 - 8*f1*f2*f5*f8 + 4*f1*f2*f6*f7 -
f1*f3*f5*f7)*z[1]*z[5]*z[9]*z[12] + (16*f0^2*f8^2 - 24*f0*f1*f7*f8 -
16*f0*f3*f5*f8 + f1^2*f7^2)*z[1]*z[5]*z[9]*z[13] + (16*f0*f1*f8^2 - 8*f0*f2*f7*f8
+ 4*f0*f3*f7^2 + 16*f0*f4*f5*f8 + 12*f1^2*f7*f8 - 2*f1*f2*f7^2 +
4*f1*f3*f5*f8)*z[1]*z[5]*z[9]*z[14] + (16*f0*f2*f8^2 - 8*f0*f3*f7*f8 -
8*f0*f5^2*f8 - 16*f1^2*f8^2 + 4*f1*f2*f7*f8)*z[1]*z[5]*z[9]*z[15] + (12*f0*f4*f8 +
2*f0*f5*f7 + 2*f1*f3*f8 - f1*f4*f7)*z[1]*z[5]*z[9]*z[16] + (8*f0^2*f8 -
6*f0*f1*f7)*z[1]*z[5]*z[10]^2 + (4*f0*f1*f8 + 3*f1^2*f7)*z[1]*z[5]*z[10]*z[11] +
(-8*f0*f2*f8 + 8*f0*f3*f7 + 4*f1^2*f8 - 6*f1*f2*f7)*z[1]*z[5]*z[10]*z[12] +
4*f0*f3*f7*z[1]*z[5]*z[10]*z[13] + (4*f0*f3*f8 - 8*f0*f4*f7 -
f1*f3*f7)*z[1]*z[5]*z[10]*z[14] + (4*f0*f4*f8 + 2*f0*f5*f7 + 2*f1*f3*f8 +
f1*f4*f7)*z[1]*z[5]*z[10]*z[15] + (-8*f0*f3*f7 - 4*f1^2*f8)*z[1]*z[5]*z[11]^2 +
(-8*f0*f3*f8 + 16*f0*f4*f7 + 8*f1*f2*f8 + 4*f1*f3*f7)*z[1]*z[5]*z[11]*z[12] +
8*f0*f3*f8*z[1]*z[5]*z[11]*z[13] + (-12*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8 +
f1*f4*f7)*z[1]*z[5]*z[11]*z[14] + (4*f0*f5*f8 - 8*f1*f4*f8 -
f1*f5*f7)*z[1]*z[5]*z[11]*z[15] - 4*f0*f7*z[1]*z[5]*z[11]*z[16] + (16*f0*f4*f8 -
8*f0*f5*f7 - 8*f1*f3*f8 - 8*f1*f4*f7)*z[1]*z[5]*z[12]^2 + (-4*f0*f4*f8 -
2*f0*f5*f7 - 2*f1*f3*f8 - f1*f4*f7)*z[1]*z[5]*z[12]*z[13] + (-8*f0*f5*f8 +
8*f0*f6*f7 + 16*f1*f4*f8 + 4*f1*f5*f7)*z[1]*z[5]*z[12]*z[14] + (-8*f0*f6*f8 +
4*f0*f7^2 + 8*f1*f5*f8 - 6*f1*f6*f7)*z[1]*z[5]*z[12]*z[15] + (-4*f0*f8 +
9*f1*f7)*z[1]*z[5]*z[12]*z[16] + 8*f0*f5*f8*z[1]*z[5]*z[13]*z[14] +
4*f1*f5*f8*z[1]*z[5]*z[13]*z[15] + (4*f0*f8 - f1*f7)*z[1]*z[5]*z[13]*z[16] +
(-4*f0*f7^2 - 8*f1*f5*f8)*z[1]*z[5]*z[14]^2 + (4*f0*f7*f8 +
3*f1*f7^2)*z[1]*z[5]*z[14]*z[15] - 4*f1*f8*z[1]*z[5]*z[14]*z[16] + (8*f0*f8^2 -
6*f1*f7*f8)*z[1]*z[5]*z[15]^2 + (32*f0^2*f5*f8^2 - 32*f0^2*f6*f7*f8 + 8*f0^2*f7^3
+ 16*f0*f2*f4*f7*f8 - 4*f0*f2*f5*f7^2 - 8*f0*f3^2*f7*f8 - 8*f1^2*f4*f7*f8 +
2*f1^2*f5*f7^2 + 4*f1*f2*f3*f7*f8)*z[1]*z[6]*z[9]^2 + (16*f0^2*f7*f8 +
4*f0*f1*f7^2 - 16*f0*f2*f5*f8 + 8*f0*f2*f6*f7 + 16*f0*f3*f4*f8 + 8*f1^2*f5*f8 -
4*f1^2*f6*f7)*z[1]*z[6]*z[9]*z[10] + (-32*f0^2*f8^2 - 16*f0*f1*f7*f8 +
16*f0*f3*f5*f8 - 8*f0*f3*f6*f7 - 32*f0*f4^2*f8 - 4*f1^2*f7^2 - 8*f1*f2*f5*f8 +
4*f1*f2*f6*f7 - 2*f1*f3*f5*f7)*z[1]*z[6]*z[9]*z[11] + (16*f0*f1*f8^2 +
8*f0*f2*f7*f8 - 8*f0*f3*f7^2 + 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 + 8*f1^2*f7*f8 +
8*f1*f2*f7^2 - 20*f1*f3*f5*f8 + 8*f1*f3*f6*f7 + 32*f1*f4^2*f8 + 16*f2^2*f5*f8 -
8*f2^2*f6*f7 - 16*f2*f3*f4*f8 + 2*f2*f3*f5*f7 + 4*f3^3*f8)*z[1]*z[6]*z[9]*z[12] +
(16*f0*f1*f8^2 - 8*f0*f2*f7*f8 + 4*f0*f3*f7^2 + 16*f0*f4*f5*f8 + 12*f1^2*f7*f8 -
2*f1*f2*f7^2 + 4*f1*f3*f5*f8)*z[1]*z[6]*z[9]*z[13] + (16*f0*f3*f7*f8 -
16*f0*f5^2*f8 - 16*f1^2*f8^2 - 16*f1*f2*f7*f8 - 4*f1*f3*f7^2 - 16*f1*f4*f5*f8 +
4*f2^2*f7^2)*z[1]*z[6]*z[9]*z[14] + (-16*f0*f3*f8^2 - 16*f0*f4*f7*f8 +
16*f0*f5*f6*f8 + 16*f1*f2*f8^2 + 12*f1*f3*f7*f8 + 8*f1*f5^2*f8 -
8*f2^2*f7*f8)*z[1]*z[6]*z[9]*z[15] + (-4*f0*f5*f8 - 2*f0*f6*f7 - 12*f1*f4*f8 -
2*f1*f5*f7 + 2*f2*f3*f8 + 2*f2*f4*f7 - f3^2*f7)*z[1]*z[6]*z[9]*z[16] +
(-12*f0*f2*f7 + 6*f1^2*f7)*z[1]*z[6]*z[10]^2 + (16*f0*f2*f8 + 16*f0*f3*f7 -
8*f1^2*f8 - 6*f1*f2*f7)*z[1]*z[6]*z[10]*z[11] + (-8*f0*f3*f8 - 8*f0*f4*f7 -
12*f1*f3*f7 + 12*f2^2*f7)*z[1]*z[6]*z[10]*z[12] + (-8*f0*f3*f8 -
8*f0*f4*f7)*z[1]*z[6]*z[10]*z[13] + (4*f0*f5*f7 + 4*f1*f3*f8 + 8*f1*f4*f7 -
2*f2*f3*f7)*z[1]*z[6]*z[10]*z[14] + (4*f0*f5*f8 - 6*f0*f6*f7 - 4*f1*f4*f8 -
2*f1*f5*f7 - 2*f2*f3*f8 - 2*f2*f4*f7 + f3^2*f7)*z[1]*z[6]*z[10]*z[15] +
8*f0*f7*z[1]*z[6]*z[10]*z[16] + (-16*f0*f3*f8 + 8*f1*f2*f8 +
2*f1*f3*f7)*z[1]*z[6]*z[11]^2 + (16*f0*f4*f8 - 8*f0*f5*f7 + 16*f1*f3*f8 -
16*f2^2*f8 - 4*f2*f3*f7)*z[1]*z[6]*z[11]*z[12] + (16*f0*f4*f8 + 4*f0*f5*f7 -
4*f1*f3*f8)*z[1]*z[6]*z[11]*z[13] + (4*f0*f5*f8 - 2*f0*f6*f7 - 4*f1*f4*f8 -
2*f1*f5*f7 + 2*f2*f3*f8 - 2*f2*f4*f7 + f3^2*f7)*z[1]*z[6]*z[11]*z[14] + (4*f0*f7^2
- 8*f1*f5*f8 + 4*f1*f6*f7 + 16*f2*f4*f8 + 2*f2*f5*f7 -
4*f3^2*f8)*z[1]*z[6]*z[11]*z[15] + (-8*f0*f8 - 2*f1*f7)*z[1]*z[6]*z[11]*z[16] +
(-8*f0*f5*f8 + 8*f0*f6*f7 - 16*f1*f4*f8 + 6*f1*f5*f7 + 8*f2*f3*f8 +
2*f3^2*f7)*z[1]*z[6]*z[12]^2 + (-4*f0*f5*f8 + 2*f0*f6*f7 - 12*f1*f4*f8 -
2*f1*f5*f7 + 6*f2*f3*f8 + 2*f2*f4*f7 - f3^2*f7)*z[1]*z[6]*z[12]*z[13] +
(-4*f0*f7^2 + 8*f1*f5*f8 - 4*f1*f6*f7 - 4*f3^2*f8)*z[1]*z[6]*z[12]*z[14] +
(-4*f1*f7^2 - 8*f2*f5*f8 + 4*f2*f6*f7 - 2*f3*f5*f7)*z[1]*z[6]*z[12]*z[15] +
(8*f1*f8 - 6*f2*f7)*z[1]*z[6]*z[12]*z[16] - 8*f0*f5*f8*z[1]*z[6]*z[13]^2 +
8*f1*f5*f8*z[1]*z[6]*z[13]*z[14] + (-2*f1*f7^2 - 8*f2*f5*f8)*z[1]*z[6]*z[13]*z[15]
+ 2*f2*f7*z[1]*z[6]*z[13]*z[16] + 2*f1*f7^2*z[1]*z[6]*z[14]^2 + (4*f1*f7*f8 -
2*f2*f7^2 + 4*f3*f5*f8)*z[1]*z[6]*z[14]*z[15] + (-8*f1*f8^2 +
4*f2*f7*f8)*z[1]*z[6]*z[15]^2 + (-16*f0*f1*f5*f8^2 + 16*f0*f1*f6*f7*f8 -
4*f0*f1*f7^3 - 32*f0*f2*f4*f8^2 + 8*f0*f2*f5*f7*f8 + 16*f0*f3^2*f8^2 +
16*f1^2*f4*f8^2 - 4*f1^2*f5*f7*f8 - 8*f1*f2*f3*f8^2)*z[1]*z[7]*z[9]^2 +
(-8*f0*f1*f7*f8 + 16*f0*f2*f6*f8 - 8*f0*f2*f7^2 - 8*f0*f3*f5*f8 - 8*f1^2*f6*f8 +
4*f1^2*f7^2)*z[1]*z[7]*z[9]*z[10] + (16*f0*f1*f8^2 - 16*f0*f3*f6*f8 + 8*f0*f3*f7^2
+ 16*f0*f4*f5*f8 + 4*f1^2*f7*f8 + 8*f1*f2*f6*f8 -
4*f1*f2*f7^2)*z[1]*z[7]*z[9]*z[11] + (-16*f0*f2*f8^2 + 8*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 8*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 8*f1*f2*f7*f8 +
24*f1*f3*f6*f8 - 12*f1*f3*f7^2 - 16*f1*f4*f5*f8 - 16*f2^2*f6*f8 + 8*f2^2*f7^2 +
4*f2*f3*f5*f8)*z[1]*z[7]*z[9]*z[12] + (16*f0*f2*f8^2 - 8*f0*f3*f7*f8 -
8*f0*f5^2*f8 - 16*f1^2*f8^2 + 4*f1*f2*f7*f8)*z[1]*z[7]*z[9]*z[13] +
(-16*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 + 16*f1*f2*f8^2 + 12*f1*f3*f7*f8
+ 8*f1*f5^2*f8 - 8*f2^2*f7*f8)*z[1]*z[7]*z[9]*z[14] + (64*f0*f4*f8^2 -
16*f0*f5*f7*f8 - 32*f1*f3*f8^2 - 16*f1*f5*f6*f8 + 4*f1*f5*f7^2 +
16*f2^2*f8^2)*z[1]*z[7]*z[9]*z[15] + (-4*f0*f6*f8 + 2*f0*f7^2 + 10*f1*f5*f8 -
f2*f5*f7)*z[1]*z[7]*z[9]*z[16] + (8*f0*f2*f8 - 4*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[7]*z[10]^2 + (4*f1*f2*f8 + 4*f1*f3*f7)*z[1]*z[7]*z[10]*z[11] +
(4*f0*f5*f7 + 4*f1*f3*f8 - 8*f2^2*f8 - 4*f2*f3*f7)*z[1]*z[7]*z[10]*z[12] +
(4*f0*f5*f7 - 4*f1*f3*f8)*z[1]*z[7]*z[10]*z[13] + (-4*f1*f5*f7 +
4*f2*f3*f8)*z[1]*z[7]*z[10]*z[14] + (-12*f0*f6*f8 + 6*f0*f7^2 + 6*f1*f5*f8 +
f2*f5*f7)*z[1]*z[7]*z[10]*z[15] + 4*f1*f7*z[1]*z[7]*z[10]*z[16] + (-4*f0*f5*f7 -
4*f1*f3*f8 - 4*f1*f4*f7)*z[1]*z[7]*z[11]^2 + (-8*f0*f5*f8 + 8*f0*f6*f7 +
4*f1*f5*f7 + 8*f2*f3*f8 + 8*f2*f4*f7)*z[1]*z[7]*z[11]*z[12] + (8*f1*f4*f8 +
2*f1*f5*f7)*z[1]*z[7]*z[11]*z[13] + (-4*f0*f6*f8 - 2*f0*f7^2 - 2*f1*f5*f8 -
8*f2*f4*f8 - f2*f5*f7)*z[1]*z[7]*z[11]*z[14] + (8*f1*f6*f8 - 4*f1*f7^2 -
4*f2*f5*f8)*z[1]*z[7]*z[11]*z[15] + (-4*f1*f8 - 4*f2*f7)*z[1]*z[7]*z[11]*z[16] +
(16*f0*f6*f8 - 12*f0*f7^2 + 4*f1*f5*f8 - 8*f1*f6*f7 - 4*f3^2*f8 -
4*f3*f4*f7)*z[1]*z[7]*z[12]^2 + (4*f0*f6*f8 - 6*f0*f7^2 + 2*f1*f5*f8 - 8*f2*f4*f8
- 3*f2*f5*f7)*z[1]*z[7]*z[12]*z[13] + (16*f0*f7*f8 - 8*f1*f6*f8 + 12*f1*f7^2 +
8*f3*f4*f8 + 2*f3*f5*f7)*z[1]*z[7]*z[12]*z[14] + (-16*f0*f8^2 - 4*f1*f7*f8 +
8*f2*f6*f8 - 4*f2*f7^2)*z[1]*z[7]*z[12]*z[15] + (4*f2*f8 +
4*f3*f7)*z[1]*z[7]*z[12]*z[16] - 4*f1*f5*f8*z[1]*z[7]*z[13]^2 + (8*f0*f7*f8 +
8*f2*f5*f8)*z[1]*z[7]*z[13]*z[14] + (-16*f0*f8^2 +
4*f1*f7*f8)*z[1]*z[7]*z[13]*z[15] + 4*f2*f8*z[1]*z[7]*z[13]*z[16] + (-12*f1*f7*f8
- 4*f3*f5*f8)*z[1]*z[7]*z[14]^2 + (16*f1*f8^2 + 4*f2*f7*f8)*z[1]*z[7]*z[14]*z[15]
- 4*f3*f8*z[1]*z[7]*z[14]*z[16] - 8*f2*f8^2*z[1]*z[7]*z[15]^2 + (-4*f0*f2*f8 +
10*f0*f3*f7 + 2*f1^2*f8 - f1*f3*f6)*z[1]*z[8]*z[9]*z[10] + (-4*f0*f3*f8 -
12*f0*f4*f7 + 2*f0*f5*f6 - 2*f1*f2*f8 - 2*f1*f3*f7 + 2*f1*f4*f6 -
f1*f5^2)*z[1]*z[8]*z[9]*z[11] + (12*f0*f4*f8 - 2*f0*f5*f7 + 4*f0*f6^2 - 2*f1*f3*f8
+ 12*f1*f4*f7 - 2*f1*f5*f6 + 4*f2^2*f8 - 2*f2*f3*f7 - 4*f2*f4*f6 + 2*f2*f5^2 +
2*f3^2*f6 - f3*f4*f5)*z[1]*z[8]*z[9]*z[12] + (12*f0*f4*f8 + 2*f0*f5*f7 +
2*f1*f3*f8 - f1*f4*f7)*z[1]*z[8]*z[9]*z[13] + (-4*f0*f5*f8 - 2*f0*f6*f7 -
12*f1*f4*f8 - 2*f1*f5*f7 + 2*f2*f3*f8 + 2*f2*f4*f7 - f3^2*f7)*z[1]*z[8]*z[9]*z[14]
+ (-4*f0*f6*f8 + 2*f0*f7^2 + 10*f1*f5*f8 - f2*f5*f7)*z[1]*z[8]*z[9]*z[15] +
(-6*f1*f7 + 3*f2*f6 - f3*f5 + f4^2 - 1)*z[1]*z[8]*z[9]*z[16] + (2*f0*f5 -
f1*f4)*z[1]*z[8]*z[10]*z[11] + (-2*f0*f6 - 2*f1*f5 + 2*f2*f4 -
f3^2)*z[1]*z[8]*z[10]*z[12] + (-6*f0*f6 + f1*f5)*z[1]*z[8]*z[10]*z[13] + (-2*f0*f7
+ 6*f1*f6 - 2*f2*f5 + f3*f4)*z[1]*z[8]*z[10]*z[14] + (4*f0*f8 - 4*f1*f7 - f2*f6 +
f3*f5 - f4^2 + 1)*z[1]*z[8]*z[10]*z[15] - f2*z[1]*z[8]*z[10]*z[16] + (-2*f0*f7 -
3*f2*f5)*z[1]*z[8]*z[11]*z[12] + (6*f0*f7 - 3*f1*f6)*z[1]*z[8]*z[11]*z[13] +
(4*f0*f8 - 2*f1*f7 + f2*f6 + f3*f5 - f4^2 - 1)*z[1]*z[8]*z[11]*z[14] + (-2*f1*f8 +
6*f2*f7 - 2*f3*f6 + f4*f5)*z[1]*z[8]*z[11]*z[15] + f3*z[1]*z[8]*z[11]*z[16] +
(-4*f1*f7 + 5*f2*f6 - f3*f5 + f4^2 + 1)*z[1]*z[8]*z[12]*z[13] + (-2*f1*f8 -
3*f3*f6)*z[1]*z[8]*z[12]*z[14] + (-2*f2*f8 - 2*f3*f7 + 2*f4*f6 -
f5^2)*z[1]*z[8]*z[12]*z[15] - f4*z[1]*z[8]*z[12]*z[16] + (6*f1*f8 -
3*f2*f7)*z[1]*z[8]*z[13]*z[14] + (-6*f2*f8 + f3*f7)*z[1]*z[8]*z[13]*z[15] -
f4*z[1]*z[8]*z[13]*z[16] + (2*f3*f8 - f4*f7)*z[1]*z[8]*z[14]*z[15] +
f5*z[1]*z[8]*z[14]*z[16] - f6*z[1]*z[8]*z[15]*z[16] + (-16*f0^2*f4*f8 +
12*f0^2*f5*f7 + 4*f0*f1*f3*f8 + 8*f0*f2*f3*f7 - 2*f1^2*f3*f7)*z[2]^2*z[9]^2 -
8*f0^2*f6*z[2]^2*z[9]*z[10] + (-8*f0^2*f7 + 4*f0*f1*f6)*z[2]^2*z[9]*z[11] +
(8*f0^2*f8 + 4*f0*f1*f7 + 8*f0*f2*f6 - 2*f0*f3*f5 - 4*f1^2*f6)*z[2]^2*z[9]*z[12] +
(8*f0^2*f8 - 6*f0*f1*f7)*z[2]^2*z[9]*z[13] + (-12*f0*f2*f7 +
6*f1^2*f7)*z[2]^2*z[9]*z[14] + (8*f0*f2*f8 - 4*f0*f3*f7 -
4*f1^2*f8)*z[2]^2*z[9]*z[15] + 4*f0^2*z[2]^2*z[10]^2 - 2*f0*f1*z[2]^2*z[10]*z[11]
+ (-4*f0*f2 + 2*f1^2)*z[2]^2*z[10]*z[12] + 2*f0*f3*z[2]^2*z[10]*z[14] -
4*f0*f3*z[2]^2*z[11]*z[13] + 4*f0*f4*z[2]^2*z[11]*z[14] -
2*f0*f5*z[2]^2*z[11]*z[15] + (4*f0*f4 + 2*f1*f3)*z[2]^2*z[12]*z[13] + (-4*f0*f5 -
4*f1*f4)*z[2]^2*z[12]*z[14] + (4*f0*f6 + 2*f1*f5)*z[2]^2*z[12]*z[15] -
2*f0*z[2]^2*z[12]*z[16] - 2*f0*z[2]^2*z[13]*z[16] + 2*f0*f7*z[2]^2*z[14]*z[15] +
2*f1*z[2]^2*z[14]*z[16] + (-4*f0*f8 - 2*f1*f7)*z[2]^2*z[15]^2 + (-16*f0^2*f6*f7 +
8*f0*f1*f4*f8 - 6*f0*f1*f5*f7 - 16*f0*f2*f3*f8 - 8*f0*f3^2*f7 +
2*f1^2*f3*f8)*z[2]*z[3]*z[9]^2 + (16*f0^2*f7 + 4*f0*f1*f6)*z[2]*z[3]*z[9]*z[10] +
(4*f0*f1*f7 + 4*f0*f3*f5 - 2*f1^2*f6)*z[2]*z[3]*z[9]*z[11] + (-12*f0*f1*f8 -
8*f0*f2*f7 - 8*f0*f3*f6 + 4*f1*f2*f6 - f1*f3*f5)*z[2]*z[3]*z[9]*z[12] +
(4*f0*f1*f8 + 3*f1^2*f7)*z[2]*z[3]*z[9]*z[13] + (16*f0*f2*f8 + 16*f0*f3*f7 -
8*f1^2*f8 - 6*f1*f2*f7)*z[2]*z[3]*z[9]*z[14] + (4*f1*f2*f8 +
4*f1*f3*f7)*z[2]*z[3]*z[9]*z[15] + (2*f0*f5 - f1*f4)*z[2]*z[3]*z[9]*z[16] -
2*f0*f1*z[2]*z[3]*z[10]^2 + f1^2*z[2]*z[3]*z[10]*z[11] + (4*f0*f3 -
2*f1*f2)*z[2]*z[3]*z[10]*z[12] + 4*f0*f3*z[2]*z[3]*z[10]*z[13] + (-8*f0*f4 -
f1*f3)*z[2]*z[3]*z[10]*z[14] + (2*f0*f5 + f1*f4)*z[2]*z[3]*z[10]*z[15] + (-2*f0*f5
+ f1*f4)*z[2]*z[3]*z[11]*z[14] - f1*f5*z[2]*z[3]*z[11]*z[15] + (-2*f0*f5 -
f1*f4)*z[2]*z[3]*z[12]*z[13] + (8*f0*f6 + 4*f1*f5)*z[2]*z[3]*z[12]*z[14] +
(-4*f0*f7 - 6*f1*f6)*z[2]*z[3]*z[12]*z[15] + 3*f1*z[2]*z[3]*z[12]*z[16] +
4*f0*f7*z[2]*z[3]*z[13]*z[15] - f1*z[2]*z[3]*z[13]*z[16] -
4*f0*f7*z[2]*z[3]*z[14]^2 + f1*f7*z[2]*z[3]*z[14]*z[15] +
2*f1*f8*z[2]*z[3]*z[15]^2 + (32*f0^2*f6*f8 - 8*f0^2*f7^2 - 8*f0*f1*f5*f8 +
8*f0*f1*f6*f7 + 16*f0*f2*f4*f8 - 12*f0*f2*f5*f7 + 8*f0*f3*f4*f7 - 8*f1^2*f4*f8 +
6*f1^2*f5*f7 + 4*f1*f2*f3*f8 + 2*f1*f3^2*f7)*z[2]*z[4]*z[9]^2 + (-16*f0^2*f8 -
4*f0*f1*f7 + 8*f0*f2*f6 - 4*f1^2*f6)*z[2]*z[4]*z[9]*z[10] + (-8*f0*f3*f6 -
4*f1^2*f7 + 4*f1*f2*f6 - 2*f1*f3*f5)*z[2]*z[4]*z[9]*z[11] + (-8*f0*f2*f8 +
4*f0*f5^2 + 8*f1^2*f8 + 8*f1*f2*f7 + 8*f1*f3*f6 - 8*f2^2*f6 +
2*f2*f3*f5)*z[2]*z[4]*z[9]*z[12] + (-8*f0*f2*f8 + 8*f0*f3*f7 + 4*f1^2*f8 -
6*f1*f2*f7)*z[2]*z[4]*z[9]*z[13] + (-8*f0*f3*f8 - 8*f0*f4*f7 - 12*f1*f3*f7 +
12*f2^2*f7)*z[2]*z[4]*z[9]*z[14] + (4*f0*f5*f7 + 4*f1*f3*f8 - 8*f2^2*f8 -
4*f2*f3*f7)*z[2]*z[4]*z[9]*z[15] + (-2*f0*f6 - 2*f1*f5 + 2*f2*f4 -
f3^2)*z[2]*z[4]*z[9]*z[16] + (-4*f0*f2 + 2*f1^2)*z[2]*z[4]*z[10]^2 + (4*f0*f3 -
2*f1*f2)*z[2]*z[4]*z[10]*z[11] + (-4*f1*f3 + 4*f2^2)*z[2]*z[4]*z[10]*z[12] -
8*f0*f4*z[2]*z[4]*z[10]*z[13] + (4*f0*f5 + 8*f1*f4 -
2*f2*f3)*z[2]*z[4]*z[10]*z[14] + (-6*f0*f6 - 2*f1*f5 - 2*f2*f4 +
f3^2)*z[2]*z[4]*z[10]*z[15] + 4*f0*z[2]*z[4]*z[10]*z[16] -
4*f0*f5*z[2]*z[4]*z[11]*z[12] + 4*f0*f5*z[2]*z[4]*z[11]*z[13] + (-2*f0*f6 -
2*f1*f5 - 2*f2*f4 + f3^2)*z[2]*z[4]*z[11]*z[14] + (4*f0*f7 + 4*f1*f6 +
2*f2*f5)*z[2]*z[4]*z[11]*z[15] - 2*f1*z[2]*z[4]*z[11]*z[16] +
2*f1*f5*z[2]*z[4]*z[12]^2 + (2*f0*f6 - 2*f1*f5 + 2*f2*f4 -
f3^2)*z[2]*z[4]*z[12]*z[13] + (4*f0*f7 - 4*f1*f6)*z[2]*z[4]*z[12]*z[14] +
(-4*f1*f7 + 4*f2*f6 - 2*f3*f5)*z[2]*z[4]*z[12]*z[15] - 2*f2*z[2]*z[4]*z[12]*z[16]
- 4*f0*f7*z[2]*z[4]*z[13]*z[14] - 2*f1*f7*z[2]*z[4]*z[13]*z[15] +
2*f2*z[2]*z[4]*z[13]*z[16] + 6*f1*f7*z[2]*z[4]*z[14]^2 + (-4*f1*f8 -
6*f2*f7)*z[2]*z[4]*z[14]*z[15] + (4*f2*f8 + 2*f3*f7)*z[2]*z[4]*z[15]^2 +
(8*f0^2*f7^2 + 8*f0*f3^2*f8)*z[2]*z[5]*z[9]^2 + (-16*f0^2*f8 +
4*f0*f1*f7)*z[2]*z[5]*z[9]*z[10] + (-8*f0*f3*f6 - 2*f1^2*f7)*z[2]*z[5]*z[9]*z[11]
+ (16*f0*f2*f8 - 4*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 - 4*f1^2*f8 +
4*f1*f2*f7)*z[2]*z[5]*z[9]*z[12] + 4*f0*f3*f7*z[2]*z[5]*z[9]*z[13] + (-8*f0*f3*f8
- 8*f0*f4*f7)*z[2]*z[5]*z[9]*z[14] + (4*f0*f5*f7 -
4*f1*f3*f8)*z[2]*z[5]*z[9]*z[15] + (-6*f0*f6 + f1*f5)*z[2]*z[5]*z[9]*z[16] +
4*f0*f3*z[2]*z[5]*z[10]*z[11] - 8*f0*f4*z[2]*z[5]*z[10]*z[12] +
4*f0*f5*z[2]*z[5]*z[10]*z[14] + (-2*f0*f6 - f1*f5)*z[2]*z[5]*z[10]*z[15] +
4*f0*z[2]*z[5]*z[10]*z[16] + (2*f0*f6 - f1*f5)*z[2]*z[5]*z[11]*z[14] + (-4*f0*f7 +
4*f1*f6)*z[2]*z[5]*z[11]*z[15] - 2*f1*z[2]*z[5]*z[11]*z[16] +
2*f1*f5*z[2]*z[5]*z[12]^2 + (-2*f0*f6 + f1*f5)*z[2]*z[5]*z[12]*z[13] -
4*f1*f6*z[2]*z[5]*z[12]*z[14] - 2*f1*f7*z[2]*z[5]*z[12]*z[15] -
2*f1*f7*z[2]*z[5]*z[13]*z[15] + 2*f1*f7*z[2]*z[5]*z[14]^2 +
4*f1*f8*z[2]*z[5]*z[14]*z[15] + (-4*f0*f1*f7^2 - 8*f0*f3*f4*f8 + 2*f0*f3*f5*f7 -
2*f1*f3^2*f8)*z[2]*z[6]*z[9]^2 + (8*f0*f2*f7 - 4*f0*f3*f6 -
4*f1^2*f7)*z[2]*z[6]*z[9]*z[10] + (-8*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 +
4*f1^2*f8 + 4*f1*f2*f7 + 2*f1*f3*f6)*z[2]*z[6]*z[9]*z[11] + (4*f0*f3*f8 +
8*f0*f4*f7 - 8*f0*f5*f6 - 8*f1*f2*f8 + 4*f1*f3*f7 - 16*f1*f4*f6 + 4*f1*f5^2 -
8*f2^2*f7 + 4*f2*f3*f6 - f3^2*f5)*z[2]*z[6]*z[9]*z[12] + (4*f0*f3*f8 - 8*f0*f4*f7
- f1*f3*f7)*z[2]*z[6]*z[9]*z[13] + (4*f0*f5*f7 + 4*f1*f3*f8 + 8*f1*f4*f7 -
2*f2*f3*f7)*z[2]*z[6]*z[9]*z[14] + (-4*f1*f5*f7 + 4*f2*f3*f8)*z[2]*z[6]*z[9]*z[15]
+ (-2*f0*f7 + 6*f1*f6 - 2*f2*f5 + f3*f4)*z[2]*z[6]*z[9]*z[16] +
2*f0*f3*z[2]*z[6]*z[10]^2 + (-8*f0*f4 - f1*f3)*z[2]*z[6]*z[10]*z[11] + (4*f0*f5 +
8*f1*f4 - 2*f2*f3)*z[2]*z[6]*z[10]*z[12] + 4*f0*f5*z[2]*z[6]*z[10]*z[13] +
(-4*f1*f5 + f3^2)*z[2]*z[6]*z[10]*z[14] + (-2*f0*f7 + 2*f1*f6 + 2*f2*f5 -
f3*f4)*z[2]*z[6]*z[10]*z[15] - 4*f1*z[2]*z[6]*z[10]*z[16] +
4*f0*f5*z[2]*z[6]*z[11]^2 - 4*f1*f5*z[2]*z[6]*z[11]*z[12] -
8*f0*f6*z[2]*z[6]*z[11]*z[13] + (2*f0*f7 + 2*f1*f6 + 2*f2*f5 -
f3*f4)*z[2]*z[6]*z[11]*z[14] + (4*f1*f7 - 8*f2*f6 + f3*f5)*z[2]*z[6]*z[11]*z[15] +
4*f2*z[2]*z[6]*z[11]*z[16] - 4*f0*f7*z[2]*z[6]*z[12]^2 + (2*f0*f7 + 6*f1*f6 -
2*f2*f5 + f3*f4)*z[2]*z[6]*z[12]*z[13] - 4*f1*f7*z[2]*z[6]*z[12]*z[14] + (4*f1*f8
+ 4*f2*f7 + 2*f3*f6)*z[2]*z[6]*z[12]*z[15] - f3*z[2]*z[6]*z[12]*z[16] +
4*f0*f7*z[2]*z[6]*z[13]^2 - 4*f1*f7*z[2]*z[6]*z[13]*z[14] + (-4*f1*f8 +
4*f2*f7)*z[2]*z[6]*z[13]*z[15] - f3*z[2]*z[6]*z[13]*z[16] -
f3*f7*z[2]*z[6]*z[14]*z[15] - 2*f3*f8*z[2]*z[6]*z[15]^2 + (-12*f0*f2*f8 +
6*f0*f3*f7 + 6*f1^2*f8 + f1*f3*f6)*z[2]*z[7]*z[9]*z[10] + (4*f0*f3*f8 - 4*f0*f4*f7
- 2*f0*f5*f6 - 6*f1*f2*f8 - 2*f1*f3*f7 - 2*f1*f4*f6 +
f1*f5^2)*z[2]*z[7]*z[9]*z[11] + (4*f0*f4*f8 - 10*f0*f5*f7 + 12*f0*f6^2 -
10*f1*f3*f8 + 4*f1*f4*f7 + 2*f1*f5*f6 + 12*f2^2*f8 + 2*f2*f3*f7 + 4*f2*f4*f6 -
2*f2*f5^2 - 2*f3^2*f6 + f3*f4*f5)*z[2]*z[7]*z[9]*z[12] + (4*f0*f4*f8 + 2*f0*f5*f7
+ 2*f1*f3*f8 + f1*f4*f7)*z[2]*z[7]*z[9]*z[13] + (4*f0*f5*f8 - 6*f0*f6*f7 -
4*f1*f4*f8 - 2*f1*f5*f7 - 2*f2*f3*f8 - 2*f2*f4*f7 + f3^2*f7)*z[2]*z[7]*z[9]*z[14]
+ (-12*f0*f6*f8 + 6*f0*f7^2 + 6*f1*f5*f8 + f2*f5*f7)*z[2]*z[7]*z[9]*z[15] +
(4*f0*f8 - 4*f1*f7 - f2*f6 + f3*f5 - f4^2 + 1)*z[2]*z[7]*z[9]*z[16] + (2*f0*f5 +
f1*f4)*z[2]*z[7]*z[10]*z[11] + (-6*f0*f6 - 2*f1*f5 - 2*f2*f4 +
f3^2)*z[2]*z[7]*z[10]*z[12] + (-2*f0*f6 - f1*f5)*z[2]*z[7]*z[10]*z[13] + (-2*f0*f7
+ 2*f1*f6 + 2*f2*f5 - f3*f4)*z[2]*z[7]*z[10]*z[14] + (8*f0*f8 - 2*f1*f7 - f2*f6 -
f3*f5 + f4^2 - 1)*z[2]*z[7]*z[10]*z[15] + f2*z[2]*z[7]*z[10]*z[16] +
2*f1*f5*z[2]*z[7]*z[11]^2 + (2*f0*f7 - f2*f5)*z[2]*z[7]*z[11]*z[12] + (2*f0*f7 -
f1*f6)*z[2]*z[7]*z[11]*z[13] + (f2*f6 - f3*f5 + f4^2 + 1)*z[2]*z[7]*z[11]*z[14] +
(-2*f1*f8 + 2*f2*f7 + 2*f3*f6 - f4*f5)*z[2]*z[7]*z[11]*z[15] -
f3*z[2]*z[7]*z[11]*z[16] + (-8*f0*f8 + 8*f1*f7 + 2*f3*f5)*z[2]*z[7]*z[12]^2 +
(-4*f0*f8 - 2*f1*f7 + f2*f6 + f3*f5 - f4^2 - 1)*z[2]*z[7]*z[12]*z[13] + (2*f1*f8 -
f3*f6)*z[2]*z[7]*z[12]*z[14] + (-6*f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*z[2]*z[7]*z[12]*z[15] + f4*z[2]*z[7]*z[12]*z[16] + (-8*f0*f8 +
2*f1*f7)*z[2]*z[7]*z[13]^2 + (2*f1*f8 - f2*f7)*z[2]*z[7]*z[13]*z[14] + (-2*f2*f8 -
f3*f7)*z[2]*z[7]*z[13]*z[15] + f4*z[2]*z[7]*z[13]*z[16] +
2*f3*f7*z[2]*z[7]*z[14]^2 + (2*f3*f8 + f4*f7)*z[2]*z[7]*z[14]*z[15] -
f5*z[2]*z[7]*z[14]*z[16] + f6*z[2]*z[7]*z[15]*z[16] - 8*f0*f3*f7*z[2]*z[8]*z[9]^2
- 8*f0*f6*z[2]*z[8]*z[9]*z[12] + 8*f0*f7*z[2]*z[8]*z[9]*z[14] +
4*f1*f7*z[2]*z[8]*z[9]*z[15] - f2*z[2]*z[8]*z[9]*z[16] +
4*f0*z[2]*z[8]*z[10]*z[12] + 4*f0*z[2]*z[8]*z[10]*z[13] -
4*f1*z[2]*z[8]*z[10]*z[14] + f2*z[2]*z[8]*z[10]*z[15] + 2*f1*z[2]*z[8]*z[11]*z[13]
- f2*z[2]*z[8]*z[11]*z[14] - 3*f2*z[2]*z[8]*z[12]*z[13] +
2*f3*z[2]*z[8]*z[12]*z[14] + (8*f0^2*f7^2 + 8*f0*f1*f6*f7 + 8*f0*f3^2*f8 +
8*f0*f3*f4*f7)*z[3]^2*z[9]^2 + (-12*f0*f1*f7 - 4*f0*f3*f5)*z[3]^2*z[9]*z[10] +
2*f1^2*f7*z[3]^2*z[9]*z[11] + (8*f0*f3*f7 + 4*f1^2*f8 -
4*f1*f2*f7)*z[3]^2*z[9]*z[12] + (-8*f0*f3*f7 - 4*f1^2*f8)*z[3]^2*z[9]*z[13] +
(-16*f0*f3*f8 + 8*f1*f2*f8 + 2*f1*f3*f7)*z[3]^2*z[9]*z[14] + (-4*f0*f5*f7 -
4*f1*f3*f8 - 4*f1*f4*f7)*z[3]^2*z[9]*z[15] + 4*f0*f5*z[3]^2*z[10]*z[14] +
2*f1*f5*z[3]^2*z[10]*z[15] - 2*f1*f5*z[3]^2*z[11]*z[14] - 2*f1*f5*z[3]^2*z[12]^2 +
2*f1*f5*z[3]^2*z[12]*z[13] - 8*f0*f7*z[3]^2*z[12]*z[14] +
6*f1*f7*z[3]^2*z[12]*z[15] + 2*f1*f7*z[3]^2*z[13]*z[15] + (8*f0*f8 -
2*f1*f7)*z[3]^2*z[14]^2 - 4*f1*f8*z[3]^2*z[14]*z[15] + (-16*f0^2*f7*f8 -
16*f0*f1*f6*f8 - 4*f0*f1*f7^2 + 16*f0*f2*f5*f8 - 16*f0*f3*f4*f8 + 4*f0*f3*f5*f7 -
16*f0*f4^2*f7 - 8*f1^2*f6*f7 - 4*f1*f3^2*f8 - 4*f1*f3*f4*f7)*z[3]*z[4]*z[9]^2 +
(16*f0*f1*f8 - 8*f0*f2*f7 + 8*f0*f4*f5 + 12*f1^2*f7 +
2*f1*f3*f5)*z[3]*z[4]*z[9]*z[10] + (8*f0*f3*f7 - 4*f0*f5^2 - 4*f1^2*f8 -
4*f1*f2*f7)*z[3]*z[4]*z[9]*z[11] + (8*f0*f3*f8 - 8*f1*f2*f8 - 12*f1*f3*f7 +
8*f2^2*f7)*z[3]*z[4]*z[9]*z[12] + (-8*f0*f3*f8 + 16*f0*f4*f7 + 8*f1*f2*f8 +
4*f1*f3*f7)*z[3]*z[4]*z[9]*z[13] + (16*f0*f4*f8 - 8*f0*f5*f7 + 16*f1*f3*f8 -
16*f2^2*f8 - 4*f2*f3*f7)*z[3]*z[4]*z[9]*z[14] + (-8*f0*f5*f8 + 8*f0*f6*f7 +
4*f1*f5*f7 + 8*f2*f3*f8 + 8*f2*f4*f7)*z[3]*z[4]*z[9]*z[15] + (-2*f0*f7 -
3*f2*f5)*z[3]*z[4]*z[9]*z[16] - 4*f0*f5*z[3]*z[4]*z[10]*z[12] -
4*f1*f5*z[3]*z[4]*z[10]*z[14] + (2*f0*f7 - f2*f5)*z[3]*z[4]*z[10]*z[15] +
4*f1*f5*z[3]*z[4]*z[11]*z[12] + (2*f0*f7 + f2*f5)*z[3]*z[4]*z[11]*z[14] -
4*f1*f7*z[3]*z[4]*z[11]*z[15] + 4*f0*f7*z[3]*z[4]*z[12]^2 + (-2*f0*f7 -
f2*f5)*z[3]*z[4]*z[12]*z[13] + (-8*f0*f8 + 4*f1*f7)*z[3]*z[4]*z[12]*z[14] +
(4*f1*f8 - 4*f2*f7)*z[3]*z[4]*z[12]*z[15] - 4*f0*f7*z[3]*z[4]*z[13]^2 + (8*f0*f8 +
4*f1*f7)*z[3]*z[4]*z[13]*z[14] - 4*f2*f7*z[3]*z[4]*z[13]*z[15] -
8*f1*f8*z[3]*z[4]*z[14]^2 + (8*f2*f8 + 4*f3*f7)*z[3]*z[4]*z[14]*z[15] + (-4*f3*f8
- 4*f4*f7)*z[3]*z[4]*z[15]^2 + 2*f5*z[3]*z[4]*z[15]*z[16] + (-16*f0^2*f7*f8 -
8*f0*f1*f7^2 - 16*f0*f3*f4*f8 - 4*f0*f3*f5*f7)*z[3]*z[5]*z[9]^2 + (8*f0*f1*f8 +
8*f0*f3*f6)*z[3]*z[5]*z[9]*z[10] + 8*f0*f3*f7*z[3]*z[5]*z[9]*z[11] + (-8*f0*f3*f8
- 16*f0*f4*f7)*z[3]*z[5]*z[9]*z[12] + 8*f0*f3*f8*z[3]*z[5]*z[9]*z[13] +
(16*f0*f4*f8 + 4*f0*f5*f7 - 4*f1*f3*f8)*z[3]*z[5]*z[9]*z[14] + (8*f1*f4*f8 +
2*f1*f5*f7)*z[3]*z[5]*z[9]*z[15] + (6*f0*f7 - 3*f1*f6)*z[3]*z[5]*z[9]*z[16] -
4*f0*f3*z[3]*z[5]*z[10]^2 + 4*f0*f5*z[3]*z[5]*z[10]*z[12] -
8*f0*f6*z[3]*z[5]*z[10]*z[14] + (2*f0*f7 - f1*f6)*z[3]*z[5]*z[10]*z[15] +
2*f1*z[3]*z[5]*z[10]*z[16] + (2*f0*f7 + f1*f6)*z[3]*z[5]*z[11]*z[14] -
4*f1*f7*z[3]*z[5]*z[11]*z[15] + (6*f0*f7 - f1*f6)*z[3]*z[5]*z[12]*z[13] + (8*f0*f8
+ 4*f1*f7)*z[3]*z[5]*z[12]*z[14] - 4*f1*f8*z[3]*z[5]*z[12]*z[15] -
8*f0*f8*z[3]*z[5]*z[13]*z[14] + (16*f0*f1*f7*f8 + 16*f0*f4^2*f8 + 4*f0*f4*f5*f7 +
4*f1^2*f7^2 + 4*f1*f3*f4*f8)*z[3]*z[6]*z[9]^2 + (-4*f0*f2*f8 - 2*f0*f3*f7 -
8*f0*f4*f6 - 2*f1^2*f8 - f1*f3*f6)*z[3]*z[6]*z[9]*z[10] + (4*f0*f3*f8 - 4*f0*f4*f7
+ 2*f0*f5*f6 - 2*f1*f2*f8 - 2*f1*f3*f7 - 2*f1*f4*f6 +
f1*f5^2)*z[3]*z[6]*z[9]*z[11] + (-12*f0*f4*f8 + 2*f0*f5*f7 + 4*f0*f6^2 +
2*f1*f3*f8 + 4*f1*f4*f7 + 2*f1*f5*f6 + 4*f2^2*f8 + 2*f2*f3*f7 + 4*f2*f4*f6 -
2*f2*f5^2 - 2*f3^2*f6 + f3*f4*f5)*z[3]*z[6]*z[9]*z[12] + (-12*f0*f4*f8 -
2*f0*f5*f7 - 2*f1*f3*f8 + f1*f4*f7)*z[3]*z[6]*z[9]*z[13] + (4*f0*f5*f8 -
2*f0*f6*f7 - 4*f1*f4*f8 - 2*f1*f5*f7 + 2*f2*f3*f8 - 2*f2*f4*f7 +
f3^2*f7)*z[3]*z[6]*z[9]*z[14] + (-4*f0*f6*f8 - 2*f0*f7^2 - 2*f1*f5*f8 - 8*f2*f4*f8
- f2*f5*f7)*z[3]*z[6]*z[9]*z[15] + (4*f0*f8 - 2*f1*f7 + f2*f6 + f3*f5 - f4^2 -
1)*z[3]*z[6]*z[9]*z[16] + 4*f0*f4*z[3]*z[6]*z[10]^2 + (-2*f0*f5 +
f1*f4)*z[3]*z[6]*z[10]*z[11] + (-2*f0*f6 - 2*f1*f5 - 2*f2*f4 +
f3^2)*z[3]*z[6]*z[10]*z[12] + (2*f0*f6 - f1*f5)*z[3]*z[6]*z[10]*z[13] + (2*f0*f7 +
2*f1*f6 + 2*f2*f5 - f3*f4)*z[3]*z[6]*z[10]*z[14] + (f2*f6 - f3*f5 + f4^2 +
1)*z[3]*z[6]*z[10]*z[15] - f2*z[3]*z[6]*z[10]*z[16] - 2*f1*f5*z[3]*z[6]*z[11]^2 +
(2*f0*f7 + f2*f5)*z[3]*z[6]*z[11]*z[12] + (2*f0*f7 + f1*f6)*z[3]*z[6]*z[11]*z[13]
+ (-8*f0*f8 - 2*f1*f7 - f2*f6 - f3*f5 + f4^2 - 1)*z[3]*z[6]*z[11]*z[14] + (2*f1*f8
+ 2*f2*f7 + 2*f3*f6 - f4*f5)*z[3]*z[6]*z[11]*z[15] - f3*z[3]*z[6]*z[11]*z[16] +
(8*f0*f8 - 4*f1*f7 - 2*f3*f5)*z[3]*z[6]*z[12]^2 + (-4*f0*f8 - 4*f1*f7 - f2*f6 +
f3*f5 - f4^2 + 1)*z[3]*z[6]*z[12]*z[13] + (2*f1*f8 + f3*f6)*z[3]*z[6]*z[12]*z[14]
+ (-2*f2*f8 - 2*f3*f7 - 2*f4*f6 + f5^2)*z[3]*z[6]*z[12]*z[15] +
f4*z[3]*z[6]*z[12]*z[16] + (8*f0*f8 - 2*f1*f7)*z[3]*z[6]*z[13]^2 + (2*f1*f8 +
f2*f7)*z[3]*z[6]*z[13]*z[14] + (2*f2*f8 - f3*f7)*z[3]*z[6]*z[13]*z[15] +
f4*z[3]*z[6]*z[13]*z[16] - 2*f3*f7*z[3]*z[6]*z[14]^2 + (-2*f3*f8 +
f4*f7)*z[3]*z[6]*z[14]*z[15] - f5*z[3]*z[6]*z[14]*z[16] +
4*f4*f8*z[3]*z[6]*z[15]^2 - f6*z[3]*z[6]*z[15]*z[16] + (-8*f0*f4*f5*f8 -
2*f0*f5^2*f7 - 4*f1^2*f7*f8 + 2*f1*f3*f5*f8)*z[3]*z[7]*z[9]^2 + (4*f0*f5*f6 -
4*f1*f3*f7)*z[3]*z[7]*z[9]*z[10] + (4*f0*f5*f7 + 4*f1*f3*f8 + 8*f1*f4*f7 -
2*f1*f5*f6)*z[3]*z[7]*z[9]*z[11] + (4*f0*f5*f8 - 8*f0*f6*f7 + 8*f1*f4*f8 +
4*f1*f5*f7 - 8*f1*f6^2 - 8*f2*f3*f8 - 16*f2*f4*f7 + 4*f2*f5*f6 + 4*f3^2*f7 -
f3*f5^2)*z[3]*z[7]*z[9]*z[12] + (4*f0*f5*f8 - 8*f1*f4*f8 -
f1*f5*f7)*z[3]*z[7]*z[9]*z[13] + (4*f0*f7^2 - 8*f1*f5*f8 + 4*f1*f6*f7 +
16*f2*f4*f8 + 2*f2*f5*f7 - 4*f3^2*f8)*z[3]*z[7]*z[9]*z[14] + (8*f1*f6*f8 -
4*f1*f7^2 - 4*f2*f5*f8)*z[3]*z[7]*z[9]*z[15] + (-2*f1*f8 + 6*f2*f7 - 2*f3*f6 +
f4*f5)*z[3]*z[7]*z[9]*z[16] - 2*f0*f5*z[3]*z[7]*z[10]^2 -
f1*f5*z[3]*z[7]*z[10]*z[11] + (4*f0*f7 + 4*f1*f6 + 2*f2*f5)*z[3]*z[7]*z[10]*z[12]
+ (-4*f0*f7 + 4*f1*f6)*z[3]*z[7]*z[10]*z[13] + (4*f1*f7 - 8*f2*f6 +
f3*f5)*z[3]*z[7]*z[10]*z[14] + (-2*f1*f8 + 2*f2*f7 + 2*f3*f6 -
f4*f5)*z[3]*z[7]*z[10]*z[15] - 4*f1*f7*z[3]*z[7]*z[11]*z[12] -
4*f1*f7*z[3]*z[7]*z[11]*z[13] + (2*f1*f8 + 2*f2*f7 + 2*f3*f6 -
f4*f5)*z[3]*z[7]*z[11]*z[14] + (-4*f3*f7 + f5^2)*z[3]*z[7]*z[11]*z[15] -
4*f1*f8*z[3]*z[7]*z[12]^2 + (2*f1*f8 + 6*f2*f7 - 2*f3*f6 +
f4*f5)*z[3]*z[7]*z[12]*z[13] - 4*f3*f7*z[3]*z[7]*z[12]*z[14] + (4*f3*f8 + 8*f4*f7
- 2*f5*f6)*z[3]*z[7]*z[12]*z[15] - f5*z[3]*z[7]*z[12]*z[16] +
4*f1*f8*z[3]*z[7]*z[13]^2 - 8*f2*f8*z[3]*z[7]*z[13]*z[14] +
4*f3*f8*z[3]*z[7]*z[13]*z[15] - f5*z[3]*z[7]*z[13]*z[16] +
4*f3*f8*z[3]*z[7]*z[14]^2 + (-8*f4*f8 - f5*f7)*z[3]*z[7]*z[14]*z[15] +
4*f6*z[3]*z[7]*z[14]*z[16] + 2*f5*f8*z[3]*z[7]*z[15]^2 -
4*f7*z[3]*z[7]*z[15]*z[16] + (8*f0*f3*f8 + 8*f0*f4*f7 +
2*f1*f3*f7)*z[3]*z[8]*z[9]^2 - 4*f0*f5*z[3]*z[8]*z[9]*z[10] + (4*f0*f7 +
4*f1*f6)*z[3]*z[8]*z[9]*z[12] - 4*f0*f7*z[3]*z[8]*z[9]*z[13] + (-8*f0*f8 -
2*f1*f7)*z[3]*z[8]*z[9]*z[14] + (-4*f1*f8 - 4*f2*f7)*z[3]*z[8]*z[9]*z[15] +
f3*z[3]*z[8]*z[9]*z[16] - 2*f1*z[3]*z[8]*z[10]*z[12] - 2*f1*z[3]*z[8]*z[10]*z[13]
+ 4*f2*z[3]*z[8]*z[10]*z[14] - f3*z[3]*z[8]*z[10]*z[15] - f3*z[3]*z[8]*z[11]*z[14]
+ f3*z[3]*z[8]*z[12]*z[13] - 2*z[3]*z[8]*z[14]*z[16] + 2*f7*z[3]*z[8]*z[15]^2 +
(8*f0*f1*f7*f8 - 32*f0*f2*f6*f8 + 16*f0*f2*f7^2 + 8*f0*f3*f5*f8 - 8*f0*f3*f6*f7 +
8*f0*f4*f5*f7 + 16*f1^2*f6*f8 - 4*f1^2*f7^2 - 8*f1*f2*f5*f8 + 8*f1*f2*f6*f7 +
8*f1*f3*f4*f8 - 4*f1*f3*f5*f7 + 8*f1*f4^2*f7)*z[4]^2*z[9]^2 + (16*f0*f2*f8 +
4*f0*f3*f7 - 4*f0*f5^2 - 12*f1^2*f8 - 8*f1*f2*f7 - 4*f1*f4*f5)*z[4]^2*z[9]*z[10] +
(-8*f0*f3*f8 - 16*f0*f4*f7 + 8*f0*f5*f6 + 8*f1*f2*f8 + 6*f1*f3*f7 +
2*f1*f5^2)*z[4]^2*z[9]*z[11] + (8*f1*f4*f7 - 4*f1*f5*f6 -
4*f2*f3*f7)*z[4]^2*z[9]*z[12] + (16*f0*f4*f8 - 8*f0*f5*f7 - 8*f1*f3*f8 -
8*f1*f4*f7)*z[4]^2*z[9]*z[13] + (-8*f0*f5*f8 + 8*f0*f6*f7 - 16*f1*f4*f8 +
6*f1*f5*f7 + 8*f2*f3*f8 + 2*f3^2*f7)*z[4]^2*z[9]*z[14] + (16*f0*f6*f8 - 12*f0*f7^2
+ 4*f1*f5*f8 - 8*f1*f6*f7 - 4*f3^2*f8 - 4*f3*f4*f7)*z[4]^2*z[9]*z[15] +
2*f1*f5*z[4]^2*z[10]*z[12] + 2*f1*f5*z[4]^2*z[10]*z[13] -
4*f0*f7*z[4]^2*z[10]*z[14] + (-8*f0*f8 + 8*f1*f7 + 2*f3*f5)*z[4]^2*z[10]*z[15] -
2*f1*f5*z[4]^2*z[11]^2 + 4*f0*f7*z[4]^2*z[11]*z[12] + (8*f0*f8 - 4*f1*f7 -
2*f3*f5)*z[4]^2*z[11]*z[14] - 4*f1*f8*z[4]^2*z[11]*z[15] - 4*f1*f7*z[4]^2*z[12]^2
+ (-8*f0*f8 + 4*f1*f7 + 2*f3*f5)*z[4]^2*z[12]*z[13] + 4*f1*f8*z[4]^2*z[12]*z[14] +
2*f3*f7*z[4]^2*z[12]*z[15] + 2*f3*f7*z[4]^2*z[13]*z[15] - 2*f3*f7*z[4]^2*z[14]^2 +
(32*f0^2*f8^2 + 8*f0*f1*f7*f8 - 8*f0*f3*f5*f8 + 16*f0*f4^2*f8 + 4*f0*f4*f5*f7 +
4*f1^2*f7^2 + 4*f1*f3*f4*f8 + 2*f1*f3*f5*f7)*z[4]*z[5]*z[9]^2 + (4*f0*f2*f8 +
2*f0*f3*f7 - 8*f0*f4*f6 - 6*f1^2*f8 - 3*f1*f3*f6)*z[4]*z[5]*z[9]*z[10] +
(-4*f0*f3*f8 - 12*f0*f4*f7 + 6*f0*f5*f6 + 2*f1*f2*f8 - 2*f1*f3*f7 + 2*f1*f4*f6 -
f1*f5^2)*z[4]*z[5]*z[9]*z[11] + (-4*f0*f4*f8 + 10*f0*f5*f7 - 4*f0*f6^2 +
10*f1*f3*f8 + 12*f1*f4*f7 - 2*f1*f5*f6 - 4*f2^2*f8 - 2*f2*f3*f7 - 4*f2*f4*f6 +
2*f2*f5^2 + 2*f3^2*f6 - f3*f4*f5)*z[4]*z[5]*z[9]*z[12] + (-4*f0*f4*f8 - 2*f0*f5*f7
- 2*f1*f3*f8 - f1*f4*f7)*z[4]*z[5]*z[9]*z[13] + (-4*f0*f5*f8 + 2*f0*f6*f7 -
12*f1*f4*f8 - 2*f1*f5*f7 + 6*f2*f3*f8 + 2*f2*f4*f7 - f3^2*f7)*z[4]*z[5]*z[9]*z[14]
+ (4*f0*f6*f8 - 6*f0*f7^2 + 2*f1*f5*f8 - 8*f2*f4*f8 -
3*f2*f5*f7)*z[4]*z[5]*z[9]*z[15] + (-4*f1*f7 + 5*f2*f6 - f3*f5 + f4^2 +
1)*z[4]*z[5]*z[9]*z[16] + (4*f0*f4 + 2*f1*f3)*z[4]*z[5]*z[10]^2 + (-2*f0*f5 -
f1*f4)*z[4]*z[5]*z[10]*z[11] + (2*f0*f6 - 2*f1*f5 + 2*f2*f4 -
f3^2)*z[4]*z[5]*z[10]*z[12] + (-2*f0*f6 + f1*f5)*z[4]*z[5]*z[10]*z[13] + (2*f0*f7
+ 6*f1*f6 - 2*f2*f5 + f3*f4)*z[4]*z[5]*z[10]*z[14] + (-4*f0*f8 - 2*f1*f7 + f2*f6 +
f3*f5 - f4^2 - 1)*z[4]*z[5]*z[10]*z[15] - 3*f2*z[4]*z[5]*z[10]*z[16] +
2*f1*f5*z[4]*z[5]*z[11]^2 + (-2*f0*f7 - f2*f5)*z[4]*z[5]*z[11]*z[12] + (6*f0*f7 -
f1*f6)*z[4]*z[5]*z[11]*z[13] + (-4*f0*f8 - 4*f1*f7 - f2*f6 + f3*f5 - f4^2 +
1)*z[4]*z[5]*z[11]*z[14] + (2*f1*f8 + 6*f2*f7 - 2*f3*f6 +
f4*f5)*z[4]*z[5]*z[11]*z[15] + f3*z[4]*z[5]*z[11]*z[16] + (-8*f0*f8 + 4*f1*f7 +
2*f3*f5)*z[4]*z[5]*z[12]^2 + (-6*f1*f7 + 3*f2*f6 - f3*f5 + f4^2 -
1)*z[4]*z[5]*z[12]*z[13] + (-2*f1*f8 - f3*f6)*z[4]*z[5]*z[12]*z[14] + (2*f2*f8 -
2*f3*f7 + 2*f4*f6 - f5^2)*z[4]*z[5]*z[12]*z[15] - f4*z[4]*z[5]*z[12]*z[16] +
(-8*f0*f8 + 2*f1*f7)*z[4]*z[5]*z[13]^2 + (6*f1*f8 - f2*f7)*z[4]*z[5]*z[13]*z[14] +
(-2*f2*f8 + f3*f7)*z[4]*z[5]*z[13]*z[15] - f4*z[4]*z[5]*z[13]*z[16] +
2*f3*f7*z[4]*z[5]*z[14]^2 + (-2*f3*f8 - f4*f7)*z[4]*z[5]*z[14]*z[15] +
f5*z[4]*z[5]*z[14]*z[16] + (4*f4*f8 + 2*f5*f7)*z[4]*z[5]*z[15]^2 -
3*f6*z[4]*z[5]*z[15]*z[16] + 2*z[4]*z[5]*z[16]^2 + (-16*f0*f1*f8^2 -
16*f0*f2*f7*f8 + 16*f0*f3*f6*f8 - 16*f0*f4*f5*f8 - 4*f0*f5^2*f7 - 4*f1^2*f7*f8 -
8*f1*f2*f7^2 + 4*f1*f3*f5*f8 - 16*f1*f4^2*f8 - 4*f1*f4*f5*f7)*z[4]*z[6]*z[9]^2 +
(-8*f0*f3*f8 + 8*f0*f5*f6 + 8*f1*f2*f8 + 4*f1*f3*f7 +
8*f1*f4*f6)*z[4]*z[6]*z[9]*z[10] + (16*f0*f4*f8 + 16*f0*f5*f7 - 16*f0*f6^2 -
8*f1*f3*f8 - 4*f1*f5*f6)*z[4]*z[6]*z[9]*z[11] + (8*f0*f5*f8 - 8*f0*f6*f7 -
12*f1*f5*f7 + 8*f1*f6^2)*z[4]*z[6]*z[9]*z[12] + (-8*f0*f5*f8 + 8*f0*f6*f7 +
16*f1*f4*f8 + 4*f1*f5*f7)*z[4]*z[6]*z[9]*z[13] + (-4*f0*f7^2 + 8*f1*f5*f8 -
4*f1*f6*f7 - 4*f3^2*f8)*z[4]*z[6]*z[9]*z[14] + (16*f0*f7*f8 - 8*f1*f6*f8 +
12*f1*f7^2 + 8*f3*f4*f8 + 2*f3*f5*f7)*z[4]*z[6]*z[9]*z[15] + (-2*f1*f8 -
3*f3*f6)*z[4]*z[6]*z[9]*z[16] + (-4*f0*f5 - 4*f1*f4)*z[4]*z[6]*z[10]^2 + (8*f0*f6
+ 4*f1*f5)*z[4]*z[6]*z[10]*z[11] + (4*f0*f7 - 4*f1*f6)*z[4]*z[6]*z[10]*z[12] -
4*f1*f6*z[4]*z[6]*z[10]*z[13] - 4*f1*f7*z[4]*z[6]*z[10]*z[14] + (2*f1*f8 -
f3*f6)*z[4]*z[6]*z[10]*z[15] + 2*f3*z[4]*z[6]*z[10]*z[16] -
8*f0*f7*z[4]*z[6]*z[11]^2 + (-8*f0*f8 + 4*f1*f7)*z[4]*z[6]*z[11]*z[12] + (8*f0*f8
+ 4*f1*f7)*z[4]*z[6]*z[11]*z[13] + (2*f1*f8 + f3*f6)*z[4]*z[6]*z[11]*z[14] -
4*f3*f7*z[4]*z[6]*z[11]*z[15] + 4*f1*f8*z[4]*z[6]*z[12]^2 + (-2*f1*f8 -
f3*f6)*z[4]*z[6]*z[12]*z[13] + 4*f3*f7*z[4]*z[6]*z[12]*z[14] -
4*f3*f8*z[4]*z[6]*z[12]*z[15] - 4*f1*f8*z[4]*z[6]*z[13]^2 + (32*f0*f2*f8^2 -
8*f0*f3*f7*f8 + 16*f0*f4*f6*f8 - 8*f0*f4*f7^2 + 4*f0*f5*f6*f7 - 8*f1^2*f8^2 +
8*f1*f2*f7*f8 - 12*f1*f3*f6*f8 + 6*f1*f3*f7^2 + 8*f1*f4*f5*f8 +
2*f1*f5^2*f7)*z[4]*z[7]*z[9]^2 + (4*f0*f5*f7 - 8*f0*f6^2 + 4*f1*f3*f8 -
4*f1*f5*f6)*z[4]*z[7]*z[9]*z[10] + (-8*f0*f5*f8 - 8*f1*f4*f8 - 12*f1*f5*f7 +
12*f1*f6^2)*z[4]*z[7]*z[9]*z[11] + (-8*f0*f6*f8 + 8*f0*f7^2 + 8*f1*f6*f7 +
8*f2*f5*f7 - 8*f2*f6^2 + 4*f3^2*f8 + 2*f3*f5*f6)*z[4]*z[7]*z[9]*z[12] +
(-8*f0*f6*f8 + 4*f0*f7^2 + 8*f1*f5*f8 - 6*f1*f6*f7)*z[4]*z[7]*z[9]*z[13] +
(-4*f1*f7^2 - 8*f2*f5*f8 + 4*f2*f6*f7 - 2*f3*f5*f7)*z[4]*z[7]*z[9]*z[14] +
(-16*f0*f8^2 - 4*f1*f7*f8 + 8*f2*f6*f8 - 4*f2*f7^2)*z[4]*z[7]*z[9]*z[15] +
(-2*f2*f8 - 2*f3*f7 + 2*f4*f6 - f5^2)*z[4]*z[7]*z[9]*z[16] + (4*f0*f6 +
2*f1*f5)*z[4]*z[7]*z[10]^2 + (-4*f0*f7 - 6*f1*f6)*z[4]*z[7]*z[10]*z[11] +
(-4*f1*f7 + 4*f2*f6 - 2*f3*f5)*z[4]*z[7]*z[10]*z[12] -
2*f1*f7*z[4]*z[7]*z[10]*z[13] + (4*f1*f8 + 4*f2*f7 +
2*f3*f6)*z[4]*z[7]*z[10]*z[14] + (-6*f2*f8 - 2*f3*f7 - 2*f4*f6 +
f5^2)*z[4]*z[7]*z[10]*z[15] + 6*f1*f7*z[4]*z[7]*z[11]^2 + (4*f1*f8 -
4*f2*f7)*z[4]*z[7]*z[11]*z[12] - 4*f1*f8*z[4]*z[7]*z[11]*z[13] + (-2*f2*f8 -
2*f3*f7 - 2*f4*f6 + f5^2)*z[4]*z[7]*z[11]*z[14] + (4*f3*f8 + 8*f4*f7 -
2*f5*f6)*z[4]*z[7]*z[11]*z[15] + 2*f3*f7*z[4]*z[7]*z[12]^2 + (2*f2*f8 - 2*f3*f7 +
2*f4*f6 - f5^2)*z[4]*z[7]*z[12]*z[13] - 4*f3*f8*z[4]*z[7]*z[12]*z[14] + (-4*f5*f7
+ 4*f6^2)*z[4]*z[7]*z[12]*z[15] - 2*f6*z[4]*z[7]*z[12]*z[16] +
4*f3*f8*z[4]*z[7]*z[13]*z[14] - 8*f4*f8*z[4]*z[7]*z[13]*z[15] +
2*f6*z[4]*z[7]*z[13]*z[16] + (4*f5*f8 - 2*f6*f7)*z[4]*z[7]*z[14]*z[15] -
2*f7*z[4]*z[7]*z[14]*z[16] + (-4*f6*f8 + 2*f7^2)*z[4]*z[7]*z[15]^2 +
4*f8*z[4]*z[7]*z[15]*z[16] + (-8*f0*f4*f8 - 2*f0*f5*f7 - 2*f1*f3*f8 -
8*f1*f4*f7)*z[4]*z[8]*z[9]^2 + (4*f0*f6 + 4*f1*f5)*z[4]*z[8]*z[9]*z[10] + (8*f0*f7
- 6*f1*f6)*z[4]*z[8]*z[9]*z[11] + (4*f0*f8 - 8*f1*f7 + 4*f2*f6 -
f3*f5)*z[4]*z[8]*z[9]*z[12] + (-4*f0*f8 + 9*f1*f7)*z[4]*z[8]*z[9]*z[13] + (8*f1*f8
- 6*f2*f7)*z[4]*z[8]*z[9]*z[14] + (4*f2*f8 + 4*f3*f7)*z[4]*z[8]*z[9]*z[15] -
f4*z[4]*z[8]*z[9]*z[16] - 2*f0*z[4]*z[8]*z[10]^2 + 3*f1*z[4]*z[8]*z[10]*z[11] -
2*f2*z[4]*z[8]*z[10]*z[12] - f3*z[4]*z[8]*z[10]*z[14] + f4*z[4]*z[8]*z[10]*z[15] +
f4*z[4]*z[8]*z[11]*z[14] - f5*z[4]*z[8]*z[11]*z[15] - f4*z[4]*z[8]*z[12]*z[13] -
2*f6*z[4]*z[8]*z[12]*z[15] + z[4]*z[8]*z[12]*z[16] - z[4]*z[8]*z[13]*z[16] +
3*f7*z[4]*z[8]*z[14]*z[15] - 2*f8*z[4]*z[8]*z[15]^2 + (8*f0*f1*f7*f8 +
8*f0*f3*f5*f8)*z[5]^2*z[9]^2 - 4*f0*f3*f7*z[5]^2*z[9]*z[10] -
8*f0*f3*f8*z[5]^2*z[9]*z[11] + 16*f0*f4*f8*z[5]^2*z[9]*z[12] -
8*f0*f5*f8*z[5]^2*z[9]*z[14] - 4*f1*f5*f8*z[5]^2*z[9]*z[15] +
4*f0*f7*z[5]^2*z[10]*z[14] + (-8*f0*f8 + 2*f1*f7)*z[5]^2*z[10]*z[15] -
4*f0*f7*z[5]^2*z[11]*z[12] + (8*f0*f8 - 2*f1*f7)*z[5]^2*z[11]*z[14] +
4*f1*f8*z[5]^2*z[11]*z[15] + (-8*f0*f8 + 2*f1*f7)*z[5]^2*z[12]*z[13] -
4*f1*f8*z[5]^2*z[12]*z[14] + (-16*f0*f1*f8^2 - 16*f0*f4*f5*f8 - 8*f1^2*f7*f8 -
4*f1*f3*f5*f8)*z[5]*z[6]*z[9]^2 + (8*f0*f4*f7 + 2*f1*f3*f7)*z[5]*z[6]*z[9]*z[10] +
(16*f0*f4*f8 - 4*f0*f5*f7 + 4*f1*f3*f8)*z[5]*z[6]*z[9]*z[11] + (-8*f0*f5*f8 -
16*f1*f4*f8)*z[5]*z[6]*z[9]*z[12] + 8*f0*f5*f8*z[5]*z[6]*z[9]*z[13] +
8*f1*f5*f8*z[5]*z[6]*z[9]*z[14] + (8*f0*f7*f8 + 8*f2*f5*f8)*z[5]*z[6]*z[9]*z[15] +
(6*f1*f8 - 3*f2*f7)*z[5]*z[6]*z[9]*z[16] - 4*f0*f7*z[5]*z[6]*z[10]*z[12] -
4*f1*f7*z[5]*z[6]*z[10]*z[14] + (2*f1*f8 - f2*f7)*z[5]*z[6]*z[10]*z[15] + (8*f0*f8
+ 4*f1*f7)*z[5]*z[6]*z[11]*z[12] - 8*f0*f8*z[5]*z[6]*z[11]*z[13] + (2*f1*f8 +
f2*f7)*z[5]*z[6]*z[11]*z[14] - 8*f2*f8*z[5]*z[6]*z[11]*z[15] + (6*f1*f8 -
f2*f7)*z[5]*z[6]*z[12]*z[13] + 4*f3*f8*z[5]*z[6]*z[12]*z[15] -
4*f5*f8*z[5]*z[6]*z[15]^2 + 2*f7*z[5]*z[6]*z[15]*z[16] + (8*f0*f5^2*f8 +
8*f1^2*f8^2)*z[5]*z[7]*z[9]^2 + (-4*f0*f5*f7 + 4*f1*f3*f8)*z[5]*z[7]*z[9]*z[10] +
(-8*f0*f5*f8 - 8*f1*f4*f8)*z[5]*z[7]*z[9]*z[11] + (16*f0*f6*f8 - 4*f0*f7^2 -
4*f1*f5*f8 + 4*f1*f6*f7 + 16*f2*f4*f8 - 4*f3^2*f8)*z[5]*z[7]*z[9]*z[12] +
4*f1*f5*f8*z[5]*z[7]*z[9]*z[13] + (-2*f1*f7^2 - 8*f2*f5*f8)*z[5]*z[7]*z[9]*z[14] +
(-16*f0*f8^2 + 4*f1*f7*f8)*z[5]*z[7]*z[9]*z[15] + (-6*f2*f8 +
f3*f7)*z[5]*z[7]*z[9]*z[16] + 4*f0*f7*z[5]*z[7]*z[10]*z[11] -
2*f1*f7*z[5]*z[7]*z[10]*z[12] - 2*f1*f7*z[5]*z[7]*z[10]*z[13] + (-4*f1*f8 +
4*f2*f7)*z[5]*z[7]*z[10]*z[14] + (-2*f2*f8 - f3*f7)*z[5]*z[7]*z[10]*z[15] +
2*f1*f7*z[5]*z[7]*z[11]^2 - 4*f2*f7*z[5]*z[7]*z[11]*z[12] + (2*f2*f8 -
f3*f7)*z[5]*z[7]*z[11]*z[14] + 4*f3*f8*z[5]*z[7]*z[11]*z[15] +
2*f3*f7*z[5]*z[7]*z[12]^2 + (-2*f2*f8 + f3*f7)*z[5]*z[7]*z[12]*z[13] -
8*f4*f8*z[5]*z[7]*z[12]*z[15] + 4*f5*f8*z[5]*z[7]*z[14]*z[15] -
2*f7*z[5]*z[7]*z[14]*z[16] + 4*f8*z[5]*z[7]*z[15]*z[16] + (-8*f0*f4*f8 -
2*f0*f5*f7 - 2*f1*f3*f8)*z[5]*z[8]*z[9]^2 + 4*f0*f6*z[5]*z[8]*z[9]*z[10] +
2*f1*f6*z[5]*z[8]*z[9]*z[11] + (-4*f0*f8 - 4*f2*f6 + f3*f5)*z[5]*z[8]*z[9]*z[12] +
(4*f0*f8 - f1*f7)*z[5]*z[8]*z[9]*z[13] + 2*f2*f7*z[5]*z[8]*z[9]*z[14] +
4*f2*f8*z[5]*z[8]*z[9]*z[15] - f4*z[5]*z[8]*z[9]*z[16] - 2*f0*z[5]*z[8]*z[10]^2 -
f1*z[5]*z[8]*z[10]*z[11] + 2*f2*z[5]*z[8]*z[10]*z[12] - f3*z[5]*z[8]*z[10]*z[14] +
f4*z[5]*z[8]*z[10]*z[15] + f4*z[5]*z[8]*z[11]*z[14] - f5*z[5]*z[8]*z[11]*z[15] -
f4*z[5]*z[8]*z[12]*z[13] + 2*f6*z[5]*z[8]*z[12]*z[15] - z[5]*z[8]*z[12]*z[16] +
z[5]*z[8]*z[13]*z[16] - f7*z[5]*z[8]*z[14]*z[15] - 2*f8*z[5]*z[8]*z[15]^2 +
(8*f0*f5^2*f8 + 8*f1^2*f8^2 + 8*f1*f2*f7*f8 + 8*f1*f4*f5*f8)*z[6]^2*z[9]^2 +
(-4*f0*f5*f7 - 4*f1*f3*f8 - 4*f1*f4*f7)*z[6]^2*z[9]*z[10] + (-16*f0*f5*f8 +
8*f0*f6*f7 + 2*f1*f5*f7)*z[6]^2*z[9]*z[11] + (4*f0*f7^2 + 8*f1*f5*f8 -
4*f1*f6*f7)*z[6]^2*z[9]*z[12] + (-4*f0*f7^2 - 8*f1*f5*f8)*z[6]^2*z[9]*z[13] +
2*f1*f7^2*z[6]^2*z[9]*z[14] + (-12*f1*f7*f8 - 4*f3*f5*f8)*z[6]^2*z[9]*z[15] -
4*f0*f7*z[6]^2*z[10]*z[11] + 6*f1*f7*z[6]^2*z[10]*z[12] +
2*f1*f7*z[6]^2*z[10]*z[13] + 2*f3*f7*z[6]^2*z[10]*z[15] + (8*f0*f8 -
2*f1*f7)*z[6]^2*z[11]^2 - 8*f1*f8*z[6]^2*z[11]*z[12] - 2*f3*f7*z[6]^2*z[11]*z[14]
+ 4*f3*f8*z[6]^2*z[11]*z[15] - 2*f3*f7*z[6]^2*z[12]^2 + 2*f3*f7*z[6]^2*z[12]*z[13]
+ (8*f0*f4*f7*f8 - 16*f0*f5*f6*f8 + 2*f0*f5*f7^2 - 16*f1*f2*f8^2 - 6*f1*f3*f7*f8 -
8*f1*f5^2*f8)*z[6]*z[7]*z[9]^2 + (4*f0*f6*f7 + 4*f1*f5*f7)*z[6]*z[7]*z[9]*z[10] +
(16*f0*f6*f8 - 8*f0*f7^2 + 16*f1*f5*f8 - 6*f1*f6*f7)*z[6]*z[7]*z[9]*z[11] +
(-12*f0*f7*f8 - 8*f1*f6*f8 - 8*f2*f5*f8 + 4*f2*f6*f7 -
f3*f5*f7)*z[6]*z[7]*z[9]*z[12] + (4*f0*f7*f8 + 3*f1*f7^2)*z[6]*z[7]*z[9]*z[13] +
(4*f1*f7*f8 - 2*f2*f7^2 + 4*f3*f5*f8)*z[6]*z[7]*z[9]*z[14] + (16*f1*f8^2 +
4*f2*f7*f8)*z[6]*z[7]*z[9]*z[15] + (2*f3*f8 - f4*f7)*z[6]*z[7]*z[9]*z[16] +
2*f0*f7*z[6]*z[7]*z[10]^2 + f1*f7*z[6]*z[7]*z[10]*z[11] + (-4*f1*f8 -
6*f2*f7)*z[6]*z[7]*z[10]*z[12] + 4*f1*f8*z[6]*z[7]*z[10]*z[13] -
f3*f7*z[6]*z[7]*z[10]*z[14] + (2*f3*f8 + f4*f7)*z[6]*z[7]*z[10]*z[15] -
4*f1*f8*z[6]*z[7]*z[11]^2 + (8*f2*f8 + 4*f3*f7)*z[6]*z[7]*z[11]*z[12] + (-2*f3*f8
+ f4*f7)*z[6]*z[7]*z[11]*z[14] + (-8*f4*f8 - f5*f7)*z[6]*z[7]*z[11]*z[15] +
(-2*f3*f8 - f4*f7)*z[6]*z[7]*z[12]*z[13] + (4*f5*f8 -
2*f6*f7)*z[6]*z[7]*z[12]*z[15] + 3*f7*z[6]*z[7]*z[12]*z[16] +
4*f5*f8*z[6]*z[7]*z[13]*z[15] - f7*z[6]*z[7]*z[13]*z[16] +
f7^2*z[6]*z[7]*z[14]*z[15] - 2*f7*f8*z[6]*z[7]*z[15]^2 + (8*f0*f5*f8 + 8*f1*f4*f8
+ 2*f1*f5*f7)*z[6]*z[8]*z[9]^2 + (-4*f0*f7 - 4*f1*f6)*z[6]*z[8]*z[9]*z[10] +
(-8*f0*f8 - 2*f1*f7)*z[6]*z[8]*z[9]*z[11] + (4*f1*f8 +
4*f2*f7)*z[6]*z[8]*z[9]*z[12] - 4*f1*f8*z[6]*z[8]*z[9]*z[13] -
4*f3*f8*z[6]*z[8]*z[9]*z[15] + f5*z[6]*z[8]*z[9]*z[16] + 2*f1*z[6]*z[8]*z[10]^2 -
f5*z[6]*z[8]*z[10]*z[15] - f5*z[6]*z[8]*z[11]*z[14] + 4*f6*z[6]*z[8]*z[11]*z[15] -
2*z[6]*z[8]*z[11]*z[16] + f5*z[6]*z[8]*z[12]*z[13] - 2*f7*z[6]*z[8]*z[12]*z[15] -
2*f7*z[6]*z[8]*z[13]*z[15] + (-16*f0*f4*f8^2 + 4*f0*f5*f7*f8 + 12*f1*f3*f8^2 +
8*f1*f5*f6*f8 - 2*f1*f5*f7^2)*z[7]^2*z[9]^2 + (8*f0*f6*f8 - 4*f0*f7^2 -
4*f1*f5*f8)*z[7]^2*z[9]*z[10] + (-12*f1*f6*f8 + 6*f1*f7^2)*z[7]^2*z[9]*z[11] +
(8*f0*f8^2 + 4*f1*f7*f8 + 8*f2*f6*f8 - 4*f2*f7^2 - 2*f3*f5*f8)*z[7]^2*z[9]*z[12] +
(8*f0*f8^2 - 6*f1*f7*f8)*z[7]^2*z[9]*z[13] + (-8*f1*f8^2 +
4*f2*f7*f8)*z[7]^2*z[9]*z[14] - 8*f2*f8^2*z[7]^2*z[9]*z[15] + (-4*f0*f8 -
2*f1*f7)*z[7]^2*z[10]^2 + 2*f1*f8*z[7]^2*z[10]*z[11] + (4*f2*f8 +
2*f3*f7)*z[7]^2*z[10]*z[12] - 2*f3*f8*z[7]^2*z[10]*z[14] + (-4*f3*f8 -
4*f4*f7)*z[7]^2*z[11]*z[12] + 4*f4*f8*z[7]^2*z[11]*z[14] +
2*f5*f8*z[7]^2*z[11]*z[15] + 2*f7*z[7]^2*z[11]*z[16] + (4*f4*f8 +
2*f5*f7)*z[7]^2*z[12]*z[13] + (-4*f6*f8 + 2*f7^2)*z[7]^2*z[12]*z[15] -
2*f8*z[7]^2*z[12]*z[16] - 4*f5*f8*z[7]^2*z[13]*z[14] - 2*f8*z[7]^2*z[13]*z[16] -
2*f7*f8*z[7]^2*z[14]*z[15] + 4*f8^2*z[7]^2*z[15]^2 - 8*f1*f5*f8*z[7]*z[8]*z[9]^2 +
4*f1*f7*z[7]*z[8]*z[9]*z[10] + 8*f1*f8*z[7]*z[8]*z[9]*z[11] -
8*f2*f8*z[7]*z[8]*z[9]*z[12] - f6*z[7]*z[8]*z[9]*z[16] + f6*z[7]*z[8]*z[10]*z[15]
+ 2*f5*z[7]*z[8]*z[11]*z[12] - f6*z[7]*z[8]*z[11]*z[14] -
4*f7*z[7]*z[8]*z[11]*z[15] - 3*f6*z[7]*z[8]*z[12]*z[13] +
4*f8*z[7]*z[8]*z[12]*z[15] + 2*f7*z[7]*z[8]*z[13]*z[14] +
4*f8*z[7]*z[8]*z[13]*z[15] + 2*z[8]^2*z[12]*z[13],

// Bmat[5,5]
  (-256*f0^2*f2*f6*f8^2 + 64*f0^2*f2*f7^2*f8 - 128*f0^2*f3*f5*f8^2 +
256*f0^2*f3*f6*f7*f8 - 64*f0^2*f3*f7^3 - 256*f0^2*f4*f6^2*f8 + 64*f0^2*f4*f6*f7^2
+ 64*f0^2*f5^2*f6*f8 + 64*f0*f1^2*f6*f8^2 - 16*f0*f1^2*f7^2*f8 +
256*f0*f1*f2*f5*f8^2 - 256*f0*f1*f2*f6*f7*f8 + 64*f0*f1*f2*f7^3 -
32*f0*f1*f3*f5*f7*f8 + 128*f0*f1*f3*f6^2*f8 - 32*f0*f1*f3*f6*f7^2 -
256*f0*f2^2*f4*f8^2 + 128*f0*f2^2*f5*f7*f8 - 256*f0*f2^2*f6^2*f8 +
64*f0*f2^2*f6*f7^2 + 64*f0*f2*f3^2*f8^2 + 128*f0*f2*f3*f5*f6*f8 -
32*f0*f2*f3*f5*f7^2 - 512*f0*f2*f4^2*f6*f8 + 128*f0*f2*f4^2*f7^2 +
128*f0*f2*f4*f5^2*f8 + 128*f0*f3^2*f4*f6*f8 - 32*f0*f3^2*f4*f7^2 -
16*f0*f3^2*f5^2*f8 - 64*f1^3*f5*f8^2 + 64*f1^3*f6*f7*f8 - 16*f1^3*f7^3 +
64*f1^2*f2*f4*f8^2 - 32*f1^2*f2*f5*f7*f8 + 64*f1^2*f2*f6^2*f8 - 16*f1^2*f2*f6*f7^2
- 32*f1^2*f3*f5*f6*f8 + 8*f1^2*f3*f5*f7^2 + 128*f1^2*f4^2*f6*f8 -
32*f1^2*f4^2*f7^2 - 32*f1^2*f4*f5^2*f8)*z[1]^2*z[9]^2 + (128*f0^2*f2*f8^2 -
96*f0^2*f3*f7*f8 + 128*f0^2*f4*f6*f8 - 32*f0^2*f5*f6*f7 - 32*f0*f1^2*f8^2 +
64*f0*f1*f2*f7*f8 - 96*f0*f1*f3*f6*f8 + 16*f0*f1*f3*f7^2 + 256*f0*f2^2*f6*f8 -
64*f0*f2^2*f7^2 - 96*f0*f2*f3*f5*f8 + 256*f0*f2*f4^2*f8 - 64*f0*f2*f4*f5*f7 -
64*f0*f3^2*f4*f8 + 8*f0*f3^2*f5*f7 - 16*f1^3*f7*f8 - 64*f1^2*f2*f6*f8 +
16*f1^2*f2*f7^2 + 24*f1^2*f3*f5*f8 - 64*f1^2*f4^2*f8 +
16*f1^2*f4*f5*f7)*z[1]^2*z[9]*z[10] + (64*f0^2*f3*f8^2 - 64*f0^2*f4*f7*f8 -
64*f0^2*f5*f6*f8 + 32*f0^2*f5*f7^2 - 128*f0*f1*f2*f8^2 + 48*f0*f1*f3*f7*f8 +
64*f0*f1*f4*f6*f8 - 32*f0*f1*f4*f7^2 - 16*f0*f1*f5^2*f8 + 16*f0*f1*f5*f6*f7 -
64*f0*f2^2*f7*f8 - 64*f0*f2*f3*f6*f8 + 32*f0*f2*f3*f7^2 - 128*f0*f2*f4*f5*f8 +
16*f0*f2*f5^2*f7 + 32*f0*f3^2*f5*f8 + 16*f0*f3*f4*f5*f7 + 32*f1^3*f8^2 +
16*f1^2*f2*f7*f8 + 32*f1^2*f4*f5*f8 - 4*f1^2*f5^2*f7)*z[1]^2*z[9]*z[11] +
(-128*f0^2*f4*f8^2 + 64*f0^2*f5*f7*f8 + 64*f0*f1*f3*f8^2 + 32*f0*f1*f5*f6*f8 -
16*f0*f1*f5*f7^2 + 32*f0*f2*f3*f7*f8 + 128*f0*f2*f4*f6*f8 - 64*f0*f2*f4*f7^2 -
32*f0*f2*f5^2*f8 + 32*f0*f2*f5*f6*f7 - 32*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 +
64*f0*f3*f4*f5*f8 - 16*f0*f3*f5^2*f7 - 16*f1^2*f3*f7*f8 - 64*f1^2*f4*f6*f8 +
32*f1^2*f4*f7^2 + 16*f1^2*f5^2*f8 - 16*f1^2*f5*f6*f7 + 32*f1*f2*f3*f6*f8 -
16*f1*f2*f3*f7^2 - 16*f1*f3^2*f5*f8 - 8*f1*f3*f4*f5*f7)*z[1]^2*z[9]*z[12] +
(128*f0^2*f4*f8^2 - 64*f0^2*f5*f7*f8 + 128*f0^2*f6^2*f8 - 32*f0^2*f6*f7^2 -
64*f0*f1*f3*f8^2 + 32*f0*f1*f4*f7*f8 - 32*f0*f1*f5*f6*f8 + 128*f0*f2^2*f8^2 -
32*f0*f2*f3*f7*f8 + 384*f0*f2*f4*f6*f8 - 96*f0*f2*f4*f7^2 - 64*f0*f2*f5^2*f8 -
64*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 - 32*f0*f3*f4*f5*f8 - 32*f1^2*f2*f8^2 -
96*f1^2*f4*f6*f8 + 24*f1^2*f4*f7^2 + 16*f1^2*f5^2*f8)*z[1]^2*z[9]*z[13] +
(64*f0^2*f5*f8^2 - 128*f0^2*f6*f7*f8 + 32*f0^2*f7^3 - 64*f0*f1*f4*f8^2 +
48*f0*f1*f5*f7*f8 - 64*f0*f1*f6^2*f8 + 16*f0*f1*f6*f7^2 - 64*f0*f2*f3*f8^2 +
64*f0*f2*f4*f7*f8 - 64*f0*f2*f5*f6*f8 - 16*f0*f3^2*f7*f8 - 128*f0*f3*f4*f6*f8 +
32*f0*f3*f4*f7^2 + 32*f0*f3*f5^2*f8 + 32*f1^2*f3*f8^2 - 32*f1^2*f4*f7*f8 +
32*f1^2*f5*f6*f8 + 16*f1*f2*f3*f7*f8 + 16*f1*f3^2*f6*f8 - 4*f1*f3^2*f7^2 +
16*f1*f3*f4*f5*f8)*z[1]^2*z[9]*z[14] + (128*f0^2*f6*f8^2 - 32*f0^2*f7^2*f8 -
96*f0*f1*f5*f8^2 + 64*f0*f1*f6*f7*f8 - 16*f0*f1*f7^3 + 128*f0*f2*f4*f8^2 -
96*f0*f2*f5*f7*f8 + 256*f0*f2*f6^2*f8 - 64*f0*f2*f6*f7^2 - 96*f0*f3*f5*f6*f8 +
24*f0*f3*f5*f7^2 + 256*f0*f4^2*f6*f8 - 64*f0*f4^2*f7^2 - 64*f0*f4*f5^2*f8 +
16*f1^2*f5*f7*f8 - 64*f1^2*f6^2*f8 + 16*f1^2*f6*f7^2 - 32*f1*f2*f3*f8^2 -
64*f1*f3*f4*f6*f8 + 16*f1*f3*f4*f7^2 + 8*f1*f3*f5^2*f8)*z[1]^2*z[9]*z[15] +
(-128*f0*f2*f6*f8 + 32*f0*f2*f7^2 + 32*f0*f3*f5*f8 - 64*f0*f4^2*f8 +
16*f0*f4*f5*f7 + 32*f1^2*f6*f8 - 8*f1^2*f7^2 + 16*f1*f3*f4*f8)*z[1]^2*z[9]*z[16] +
(32*f0^2*f4*f8 - 32*f0^2*f5*f7 + 32*f0^2*f6^2 + 64*f0*f2*f4*f6 - 16*f0*f2*f5^2 -
8*f0*f3^2*f6 - 16*f1^2*f4*f6 + 4*f1^2*f5^2)*z[1]^2*z[10]^2 + (32*f0^2*f5*f8 -
32*f0^2*f6*f7 - 32*f0*f1*f4*f8 + 32*f0*f1*f5*f7 - 32*f0*f1*f6^2 - 32*f0*f2*f4*f7 -
32*f0*f3*f4*f6 + 8*f0*f3*f5^2 + 8*f1^2*f4*f7)*z[1]^2*z[10]*z[11] + (-64*f0^2*f6*f8
+ 32*f0^2*f7^2 - 16*f0*f1*f5*f8 + 16*f0*f1*f6*f7 - 64*f0*f2*f4*f8 + 64*f0*f2*f5*f7
- 64*f0*f2*f6^2 + 16*f0*f3^2*f8 + 16*f0*f3*f5*f6 + 32*f1^2*f4*f8 - 32*f1^2*f5*f7 +
32*f1^2*f6^2 + 4*f1*f3^2*f7 + 16*f1*f3*f4*f6 - 4*f1*f3*f5^2)*z[1]^2*z[10]*z[12] +
(-16*f0*f1*f5*f8 + 16*f0*f1*f6*f7 - 64*f0*f2*f4*f8 + 16*f0*f3^2*f8 +
16*f0*f3*f4*f7 + 16*f1^2*f4*f8)*z[1]^2*z[10]*z[13] + (32*f0*f1*f6*f8 -
16*f0*f1*f7^2 - 32*f0*f2*f5*f8 + 32*f0*f2*f6*f7 + 32*f0*f3*f4*f8 - 8*f0*f3*f5*f7 +
16*f1^2*f5*f8 - 16*f1^2*f6*f7 - 8*f1*f3^2*f8 - 8*f1*f3*f4*f7)*z[1]^2*z[10]*z[14] +
(-64*f0*f2*f6*f8 + 32*f0*f3*f5*f8 - 64*f0*f4^2*f8 + 16*f0*f4*f5*f7 + 8*f1^2*f7^2 +
16*f1*f3*f4*f8)*z[1]^2*z[10]*z[15] + (-32*f0*f4*f6 + 8*f0*f5^2)*z[1]^2*z[10]*z[16]
+ (32*f0^2*f6*f8 - 16*f0*f1*f5*f8 + 16*f0*f1*f6*f7 + 96*f0*f2*f4*f8 -
32*f0*f2*f5*f7 + 32*f0*f2*f6^2 - 16*f0*f3^2*f8 + 16*f0*f3*f4*f7 - 16*f0*f3*f5*f6 +
32*f0*f4^2*f6 - 8*f0*f4*f5^2 - 16*f1^2*f4*f8)*z[1]^2*z[11]^2 + (-32*f0^2*f7*f8 -
16*f0*f1*f7^2 - 32*f0*f3*f4*f8 - 24*f0*f3*f5*f7 + 32*f0*f3*f6^2 - 32*f0*f4*f5*f6 +
8*f0*f5^3 + 16*f1^2*f5*f8 - 16*f1^2*f6*f7 - 32*f1*f2*f4*f8 + 32*f1*f2*f5*f7 -
32*f1*f2*f6^2 + 8*f1*f3^2*f8 - 16*f1*f3*f4*f7 + 16*f1*f3*f5*f6 - 32*f1*f4^2*f6 +
8*f1*f4*f5^2)*z[1]^2*z[11]*z[12] + (-32*f0*f1*f6*f8 + 32*f0*f2*f5*f8 -
32*f0*f2*f6*f7 - 32*f0*f3*f4*f8 + 16*f0*f3*f5*f7 -
32*f0*f4^2*f7)*z[1]^2*z[11]*z[13] + (16*f0*f1*f7*f8 + 16*f0*f3*f5*f8 -
16*f0*f3*f6*f7 + 16*f0*f4*f5*f7 + 8*f1^2*f7^2 - 16*f1*f2*f5*f8 + 16*f1*f2*f6*f7 +
16*f1*f3*f4*f8 - 8*f1*f3*f5*f7 + 16*f1*f4^2*f7)*z[1]^2*z[11]*z[14] +
(32*f0*f2*f7*f8 - 32*f0*f3*f6*f8 + 16*f0*f3*f7^2 + 32*f0*f4*f5*f8 - 8*f0*f5^2*f7 -
16*f1^2*f7*f8 + 32*f1*f2*f6*f8 - 16*f1*f2*f7^2 - 8*f1*f3*f5*f8 -
8*f1*f4*f5*f7)*z[1]^2*z[11]*z[15] + (16*f0*f4*f7 + 16*f1*f4*f6 -
4*f1*f5^2)*z[1]^2*z[11]*z[16] + (32*f0^2*f8^2 + 16*f0*f1*f7*f8 + 96*f0*f2*f6*f8 -
32*f0*f2*f7^2 - 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 64*f0*f4^2*f8 - 16*f0*f4*f5*f7 +
32*f0*f4*f6^2 - 8*f0*f5^2*f6 - 32*f1^2*f6*f8 + 16*f1^2*f7^2 - 16*f1*f2*f5*f8 +
16*f1*f2*f6*f7 - 16*f1*f3*f4*f8 + 24*f1*f3*f5*f7 - 32*f1*f3*f6^2 + 16*f1*f4*f5*f6
- 4*f1*f5^3 + 32*f2^2*f4*f8 - 32*f2^2*f5*f7 + 32*f2^2*f6^2 - 8*f2*f3^2*f8 +
16*f2*f3*f4*f7 - 16*f2*f3*f5*f6 + 32*f2*f4^2*f6 - 8*f2*f4*f5^2 - 4*f3^3*f7 -
8*f3^2*f4*f6 + 2*f3^2*f5^2)*z[1]^2*z[12]^2 + (16*f0*f1*f7*f8 - 64*f0*f2*f6*f8 +
32*f0*f2*f7^2 + 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 16*f0*f4*f5*f7 + 32*f1^2*f6*f8 -
8*f1^2*f7^2 - 16*f1*f2*f5*f8 + 16*f1*f2*f6*f7 + 16*f1*f3*f4*f8 - 8*f1*f3*f5*f7 +
16*f1*f4^2*f7)*z[1]^2*z[12]*z[13] + (-32*f0*f1*f8^2 + 16*f0*f3*f7^2 -
32*f0*f4*f5*f8 - 32*f0*f4*f6*f7 + 8*f0*f5^2*f7 - 16*f1^2*f7*f8 - 16*f1*f2*f7^2 -
24*f1*f3*f5*f8 + 32*f1*f3*f6*f7 - 16*f1*f4*f5*f7 + 32*f2^2*f5*f8 - 32*f2^2*f6*f7 -
32*f2*f3*f4*f8 + 16*f2*f3*f5*f7 - 32*f2*f4^2*f7 + 8*f3^3*f8 +
8*f3^2*f4*f7)*z[1]^2*z[12]*z[14] + (-64*f0*f2*f8^2 - 16*f0*f3*f7*f8 -
64*f0*f4*f6*f8 + 32*f0*f4*f7^2 + 16*f0*f5^2*f8 + 32*f1^2*f8^2 + 16*f1*f2*f7*f8 +
64*f1*f3*f6*f8 - 32*f1*f3*f7^2 + 4*f1*f5^2*f7 - 64*f2^2*f6*f8 + 32*f2^2*f7^2 +
16*f2*f3*f5*f8 + 16*f2*f4*f5*f7 - 4*f3^2*f5*f7)*z[1]^2*z[12]*z[15] + (-32*f0*f4*f8
- 8*f1*f4*f7 - 32*f2*f4*f6 + 8*f2*f5^2 + 8*f3^2*f6)*z[1]^2*z[12]*z[16] +
(32*f0*f2*f6*f8 - 16*f0*f3*f5*f8 + 32*f0*f4^2*f8)*z[1]^2*z[13]^2 +
(-32*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 32*f0*f4*f5*f8 - 32*f1*f2*f6*f8 +
16*f1*f3*f5*f8 - 32*f1*f4^2*f8)*z[1]^2*z[13]*z[14] + (-16*f0*f3*f7*f8 -
64*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 16*f0*f5^2*f8 + 16*f1*f2*f7*f8 +
16*f1*f4*f5*f8)*z[1]^2*z[13]*z[15] - 8*f1*f4*f7*z[1]^2*z[13]*z[16] +
(32*f0*f2*f8^2 - 16*f0*f3*f7*f8 + 96*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8 +
16*f1*f2*f7*f8 - 32*f1*f3*f6*f8 + 16*f1*f4*f5*f8 + 32*f2^2*f6*f8 - 16*f2*f3*f5*f8
+ 32*f2*f4^2*f8 - 8*f3^2*f4*f8)*z[1]^2*z[14]^2 + (32*f0*f3*f8^2 - 32*f0*f4*f7*f8 -
32*f1*f2*f8^2 + 32*f1*f3*f7*f8 - 32*f1*f4*f6*f8 + 8*f1*f4*f7^2 - 32*f2^2*f7*f8 -
32*f2*f4*f5*f8 + 8*f3^2*f5*f8)*z[1]^2*z[14]*z[15] + (16*f1*f4*f8 + 16*f2*f4*f7 -
4*f3^2*f7)*z[1]^2*z[14]*z[16] + (32*f0*f4*f8^2 - 32*f1*f3*f8^2 + 32*f2^2*f8^2 +
64*f2*f4*f6*f8 - 16*f2*f4*f7^2 - 8*f2*f5^2*f8 - 16*f3^2*f6*f8 +
4*f3^2*f7^2)*z[1]^2*z[15]^2 + (-32*f2*f4*f8 + 8*f3^2*f8)*z[1]^2*z[15]*z[16] +
(128*f0^2*f2*f8^2 - 96*f0^2*f3*f7*f8 + 128*f0^2*f4*f6*f8 - 32*f0^2*f5*f6*f7 -
32*f0*f1^2*f8^2 + 64*f0*f1*f2*f7*f8 - 96*f0*f1*f3*f6*f8 + 16*f0*f1*f3*f7^2 +
256*f0*f2^2*f6*f8 - 64*f0*f2^2*f7^2 - 96*f0*f2*f3*f5*f8 + 256*f0*f2*f4^2*f8 -
64*f0*f2*f4*f5*f7 - 64*f0*f3^2*f4*f8 + 8*f0*f3^2*f5*f7 - 16*f1^3*f7*f8 -
64*f1^2*f2*f6*f8 + 16*f1^2*f2*f7^2 + 24*f1^2*f3*f5*f8 - 64*f1^2*f4^2*f8 +
16*f1^2*f4*f5*f7)*z[1]*z[2]*z[9]^2 + (-64*f0^2*f4*f8 + 64*f0^2*f5*f7 +
64*f0*f1*f3*f8 - 192*f0*f2^2*f8 + 32*f0*f2*f3*f7 + 32*f0*f2*f5^2 + 48*f1^2*f2*f8 -
8*f1^2*f3*f7 - 8*f1^2*f5^2)*z[1]*z[2]*z[9]*z[10] + (-32*f0*f1*f4*f8 -
16*f0*f1*f5*f7 + 64*f0*f2*f3*f8 + 64*f0*f2*f4*f7 - 32*f0*f2*f5*f6 - 16*f0*f3^2*f7
- 8*f0*f3*f5^2 - 8*f1^2*f3*f8 - 16*f1^2*f4*f7 + 8*f1^2*f5*f6)*z[1]*z[2]*z[9]*z[11]
+ (64*f0^2*f6*f8 - 64*f0^2*f7^2 - 16*f0*f1*f5*f8 - 64*f0*f2*f4*f8 - 32*f0*f2*f5*f7
- 32*f0*f3*f4*f7 + 16*f0*f3*f5*f6 + 32*f1^2*f4*f8 + 16*f1^2*f5*f7 - 16*f1*f2*f3*f8
+ 8*f1*f3^2*f7 + 4*f1*f3*f5^2)*z[1]*z[2]*z[9]*z[12] + (-128*f0^2*f6*f8 +
32*f0^2*f7^2 + 32*f0*f1*f5*f8 - 256*f0*f2*f4*f8 + 48*f0*f2*f5*f7 + 48*f0*f3^2*f8 +
64*f1^2*f4*f8 - 12*f1^2*f5*f7)*z[1]*z[2]*z[9]*z[13] + (96*f0^2*f7*f8 +
64*f0*f1*f6*f8 - 16*f0*f1*f7^2 + 64*f0*f2*f5*f8 + 96*f0*f3*f4*f8 - 8*f0*f3*f5*f7 -
32*f1^2*f5*f8 - 16*f1*f3^2*f8)*z[1]*z[2]*z[9]*z[14] + (-128*f0^2*f8^2 -
16*f0*f1*f7*f8 - 256*f0*f2*f6*f8 + 64*f0*f2*f7^2 + 48*f0*f3*f5*f8 - 128*f0*f4^2*f8
+ 32*f0*f4*f5*f7 + 64*f1^2*f6*f8 - 16*f1^2*f7^2 + 32*f1*f3*f4*f8 -
8*f1*f3*f5*f7)*z[1]*z[2]*z[9]*z[15] + (96*f0*f2*f8 - 8*f0*f3*f7 - 8*f0*f5^2 -
24*f1^2*f8)*z[1]*z[2]*z[9]*z[16] + (-32*f0^2*f6 - 64*f0*f2*f4 + 8*f0*f3^2 +
16*f1^2*f4)*z[1]*z[2]*z[10]^2 + (32*f0^2*f7 + 32*f0*f1*f6 + 16*f0*f2*f5 +
32*f0*f3*f4 - 4*f1^2*f5)*z[1]*z[2]*z[10]*z[11] + (32*f0^2*f8 - 16*f0*f1*f7 +
64*f0*f2*f6 - 24*f0*f3*f5 - 32*f1^2*f6 - 16*f1*f3*f4)*z[1]*z[2]*z[10]*z[12] +
(-16*f0*f1*f7 - 8*f0*f3*f5)*z[1]*z[2]*z[10]*z[13] + (-16*f0*f1*f8 - 32*f0*f2*f7 +
16*f1^2*f7 + 4*f1*f3*f5)*z[1]*z[2]*z[10]*z[14] + (64*f0*f2*f8 - 8*f0*f3*f7 -
8*f0*f5^2 - 8*f1^2*f8)*z[1]*z[2]*z[10]*z[15] + 32*f0*f4*z[1]*z[2]*z[10]*z[16] +
(-32*f0^2*f8 - 16*f0*f1*f7 - 32*f0*f2*f6 + 16*f0*f3*f5 -
32*f0*f4^2)*z[1]*z[2]*z[11]^2 + (16*f0*f1*f8 - 32*f0*f3*f6 + 32*f0*f4*f5 +
16*f1^2*f7 + 32*f1*f2*f6 - 16*f1*f3*f5 + 32*f1*f4^2)*z[1]*z[2]*z[11]*z[12] +
(32*f0*f1*f8 + 32*f0*f2*f7 + 16*f0*f4*f5)*z[1]*z[2]*z[11]*z[13] + (8*f0*f3*f7 -
8*f0*f5^2 - 8*f1^2*f8 - 16*f1*f2*f7 - 8*f1*f4*f5)*z[1]*z[2]*z[11]*z[14] +
(16*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 - 16*f1*f2*f8 + 8*f1*f3*f7 +
4*f1*f5^2)*z[1]*z[2]*z[11]*z[15] + (-8*f0*f5 - 16*f1*f4)*z[1]*z[2]*z[11]*z[16] +
(-64*f0*f2*f8 + 32*f0*f3*f7 - 32*f0*f4*f6 + 8*f0*f5^2 + 16*f1^2*f8 - 16*f1*f2*f7 +
32*f1*f3*f6 - 16*f1*f4*f5 - 32*f2^2*f6 + 16*f2*f3*f5 - 32*f2*f4^2 +
8*f3^2*f4)*z[1]*z[2]*z[12]^2 + (32*f0*f2*f8 + 8*f0*f3*f7 - 8*f0*f5^2 - 24*f1^2*f8
- 16*f1*f2*f7 - 8*f1*f4*f5)*z[1]*z[2]*z[12]*z[13] + (-16*f0*f3*f8 + 32*f0*f4*f7 +
16*f1*f2*f8 - 24*f1*f3*f7 + 8*f1*f5^2 + 32*f2^2*f7 + 16*f2*f4*f5 -
4*f3^2*f5)*z[1]*z[2]*z[12]*z[14] + (64*f0*f4*f8 - 16*f0*f5*f7 - 40*f1*f3*f8 +
16*f1*f4*f7 - 8*f1*f5*f6 + 32*f2^2*f8 - 16*f2*f3*f7 -
8*f2*f5^2)*z[1]*z[2]*z[12]*z[15] + (4*f1*f5 + 32*f2*f4 -
8*f3^2)*z[1]*z[2]*z[12]*z[16] - 32*f0*f2*f8*z[1]*z[2]*z[13]^2 + (-16*f0*f3*f8 +
32*f1*f2*f8)*z[1]*z[2]*z[13]*z[14] + (64*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f3*f8)*z[1]*z[2]*z[13]*z[15] + 4*f1*f5*z[1]*z[2]*z[13]*z[16] + (-64*f0*f4*f8
+ 8*f0*f5*f7 + 24*f1*f3*f8 - 32*f2^2*f8)*z[1]*z[2]*z[14]^2 + (-4*f1*f5*f7 +
16*f2*f3*f8)*z[1]*z[2]*z[14]*z[15] - 8*f2*f5*z[1]*z[2]*z[14]*z[16] + (8*f1*f5*f8 -
32*f2*f4*f8 + 8*f2*f5*f7 + 8*f3^2*f8)*z[1]*z[2]*z[15]^2 + (64*f0^2*f3*f8^2 -
64*f0^2*f4*f7*f8 - 64*f0^2*f5*f6*f8 + 32*f0^2*f5*f7^2 - 128*f0*f1*f2*f8^2 +
48*f0*f1*f3*f7*f8 + 64*f0*f1*f4*f6*f8 - 32*f0*f1*f4*f7^2 - 16*f0*f1*f5^2*f8 +
16*f0*f1*f5*f6*f7 - 64*f0*f2^2*f7*f8 - 64*f0*f2*f3*f6*f8 + 32*f0*f2*f3*f7^2 -
128*f0*f2*f4*f5*f8 + 16*f0*f2*f5^2*f7 + 32*f0*f3^2*f5*f8 + 16*f0*f3*f4*f5*f7 +
32*f1^3*f8^2 + 16*f1^2*f2*f7*f8 + 32*f1^2*f4*f5*f8 -
4*f1^2*f5^2*f7)*z[1]*z[3]*z[9]^2 + (-32*f0*f1*f4*f8 - 16*f0*f1*f5*f7 +
64*f0*f2*f3*f8 + 64*f0*f2*f4*f7 - 32*f0*f2*f5*f6 - 16*f0*f3^2*f7 - 8*f0*f3*f5^2 -
8*f1^2*f3*f8 - 16*f1^2*f4*f7 + 8*f1^2*f5*f6)*z[1]*z[3]*z[9]*z[10] + (64*f0^2*f6*f8
- 64*f0^2*f7^2 + 32*f0*f1*f5*f8 + 64*f0*f2*f4*f8 - 32*f0*f2*f5*f7 - 32*f0*f3^2*f8
- 32*f0*f3*f4*f7 + 32*f0*f3*f5*f6 - 16*f1^2*f4*f8 +
8*f1^2*f5*f7)*z[1]*z[3]*z[9]*z[11] + (-64*f0*f1*f6*f8 + 64*f0*f1*f7^2 +
32*f0*f2*f5*f8 + 16*f0*f3*f5*f7 + 64*f0*f4^2*f7 - 32*f0*f4*f5*f6 + 8*f0*f5^3 -
16*f1^2*f5*f8 + 8*f1*f3^2*f8 - 8*f1*f3*f5*f6)*z[1]*z[3]*z[9]*z[12] +
(96*f0^2*f7*f8 + 64*f0*f2*f5*f8 + 32*f0*f3*f4*f8 - 24*f0*f3*f5*f7 -
16*f1^2*f5*f8)*z[1]*z[3]*z[9]*z[13] + (-64*f0^2*f8^2 - 80*f0*f1*f7*f8 -
48*f0*f3*f5*f8 - 64*f0*f4^2*f8 + 4*f1*f3*f5*f7)*z[1]*z[3]*z[9]*z[14] +
(96*f0*f1*f8^2 + 64*f0*f2*f7*f8 + 64*f0*f3*f6*f8 - 32*f0*f3*f7^2 + 96*f0*f4*f5*f8
- 16*f0*f5^2*f7 - 16*f1^2*f7*f8 - 8*f1*f3*f5*f8)*z[1]*z[3]*z[9]*z[15] +
(-32*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 + 4*f1*f3*f7)*z[1]*z[3]*z[9]*z[16] +
(32*f0^2*f7 + 32*f0*f2*f5 - 8*f1^2*f5)*z[1]*z[3]*z[10]^2 + (-32*f0^2*f8 -
32*f0*f1*f7 - 24*f0*f3*f5)*z[1]*z[3]*z[10]*z[11] + (16*f0*f1*f8 - 64*f0*f2*f7 +
32*f1^2*f7 + 12*f1*f3*f5)*z[1]*z[3]*z[10]*z[12] +
16*f0*f1*f8*z[1]*z[3]*z[10]*z[13] + (32*f0*f2*f8 + 16*f0*f3*f7 + 8*f0*f5^2 -
16*f1^2*f8)*z[1]*z[3]*z[10]*z[14] + (-32*f0*f3*f8 -
4*f1*f3*f7)*z[1]*z[3]*z[10]*z[15] - 16*f0*f5*z[1]*z[3]*z[10]*z[16] + (16*f0*f1*f8
+ 32*f0*f2*f7 + 16*f0*f4*f5)*z[1]*z[3]*z[11]^2 + (32*f0*f3*f7 - 16*f0*f5^2 -
16*f1^2*f8 - 32*f1*f2*f7 - 16*f1*f4*f5)*z[1]*z[3]*z[11]*z[12] + (-32*f0*f2*f8 -
16*f0*f3*f7 - 8*f0*f5^2)*z[1]*z[3]*z[11]*z[13] + (-16*f0*f3*f8 + 16*f1*f2*f8 +
4*f1*f3*f7 + 4*f1*f5^2)*z[1]*z[3]*z[11]*z[14] + (-32*f0*f4*f8 + 16*f0*f5*f7 +
8*f1*f3*f8 + 16*f1*f4*f7 - 8*f1*f5*f6)*z[1]*z[3]*z[11]*z[15] +
8*f1*f5*z[1]*z[3]*z[11]*z[16] + (16*f0*f5*f6 + 16*f1*f2*f8 - 32*f1*f3*f7 +
4*f1*f5^2 + 32*f2^2*f7 + 16*f2*f4*f5 - 4*f3^2*f5)*z[1]*z[3]*z[12]^2 +
(-16*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 + 16*f1*f2*f8 + 12*f1*f3*f7 +
4*f1*f5^2)*z[1]*z[3]*z[12]*z[13] + (32*f0*f4*f8 - 32*f0*f5*f7 + 24*f1*f3*f8 +
16*f1*f4*f7 - 8*f1*f5*f6 - 32*f2^2*f8 - 16*f2*f3*f7 -
8*f2*f5^2)*z[1]*z[3]*z[12]*z[14] + (-16*f0*f5*f8 - 16*f1*f4*f8 + 8*f1*f5*f7 -
32*f2*f4*f7 + 16*f2*f5*f6 + 16*f3^2*f7)*z[1]*z[3]*z[12]*z[15] -
16*f2*f5*z[1]*z[3]*z[12]*z[16] + 16*f0*f3*f8*z[1]*z[3]*z[13]^2 + (32*f0*f4*f8 -
16*f1*f3*f8)*z[1]*z[3]*z[13]*z[14] + (-32*f0*f5*f8 -
16*f1*f4*f8)*z[1]*z[3]*z[13]*z[15] + (32*f0*f5*f8 - 16*f1*f4*f8 +
16*f2*f3*f8)*z[1]*z[3]*z[14]^2 + (32*f2*f4*f8 - 16*f3^2*f8)*z[1]*z[3]*z[14]*z[15]
+ 4*f3*f5*z[1]*z[3]*z[14]*z[16] - 4*f3*f5*f7*z[1]*z[3]*z[15]^2 +
(-128*f0^2*f4*f8^2 + 64*f0^2*f5*f7*f8 + 64*f0*f1*f3*f8^2 + 32*f0*f1*f5*f6*f8 -
16*f0*f1*f5*f7^2 + 32*f0*f2*f3*f7*f8 + 128*f0*f2*f4*f6*f8 - 64*f0*f2*f4*f7^2 -
32*f0*f2*f5^2*f8 + 32*f0*f2*f5*f6*f7 - 32*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 +
64*f0*f3*f4*f5*f8 - 16*f0*f3*f5^2*f7 - 16*f1^2*f3*f7*f8 - 64*f1^2*f4*f6*f8 +
32*f1^2*f4*f7^2 + 16*f1^2*f5^2*f8 - 16*f1^2*f5*f6*f7 + 32*f1*f2*f3*f6*f8 -
16*f1*f2*f3*f7^2 - 16*f1*f3^2*f5*f8 - 8*f1*f3*f4*f5*f7)*z[1]*z[4]*z[9]^2 +
(64*f0^2*f6*f8 - 64*f0^2*f7^2 - 16*f0*f1*f5*f8 - 64*f0*f2*f4*f8 - 32*f0*f2*f5*f7 -
32*f0*f3*f4*f7 + 16*f0*f3*f5*f6 + 32*f1^2*f4*f8 + 16*f1^2*f5*f7 - 16*f1*f2*f3*f8 +
8*f1*f3^2*f7 + 4*f1*f3*f5^2)*z[1]*z[4]*z[9]*z[10] + (-64*f0*f1*f6*f8 +
64*f0*f1*f7^2 + 32*f0*f2*f5*f8 + 16*f0*f3*f5*f7 + 64*f0*f4^2*f7 - 32*f0*f4*f5*f6 +
8*f0*f5^3 - 16*f1^2*f5*f8 + 8*f1*f3^2*f8 - 8*f1*f3*f5*f6)*z[1]*z[4]*z[9]*z[11] +
(-64*f0*f2*f6*f8 + 64*f0*f2*f7^2 - 32*f0*f3*f5*f8 + 64*f0*f4^2*f8 - 32*f0*f4*f5*f7
+ 64*f1^2*f6*f8 - 64*f1^2*f7^2 - 32*f1*f3*f4*f8 - 64*f1*f4^2*f7 + 32*f1*f4*f5*f6 -
8*f1*f5^3 + 32*f2*f3*f4*f7 - 8*f3^3*f7)*z[1]*z[4]*z[9]*z[12] + (64*f0^2*f8^2 -
64*f0*f1*f7*f8 - 32*f0*f3*f5*f8 - 64*f0*f4^2*f8 +
12*f1*f3*f5*f7)*z[1]*z[4]*z[9]*z[13] + (-64*f0*f2*f7*f8 + 32*f0*f3*f6*f8 -
16*f0*f3*f7^2 + 8*f0*f5^2*f7 + 64*f1^2*f7*f8 + 16*f1*f3*f5*f8 + 64*f1*f4^2*f8 -
32*f2*f3*f4*f8 - 8*f2*f3*f5*f7 + 8*f3^3*f8)*z[1]*z[4]*z[9]*z[14] + (64*f0*f2*f8^2
- 16*f0*f3*f7*f8 - 64*f0*f4*f6*f8 + 32*f0*f4*f7^2 - 16*f0*f5*f6*f7 - 64*f1^2*f8^2
- 32*f1*f3*f6*f8 + 16*f1*f3*f7^2 - 32*f1*f4*f5*f8 + 8*f1*f5^2*f7 + 16*f2*f3*f5*f8
+ 4*f3^2*f5*f7)*z[1]*z[4]*z[9]*z[15] + (16*f0*f5*f7 + 16*f1*f3*f8 + 16*f1*f4*f7 -
8*f1*f5*f6 - 8*f2*f3*f7)*z[1]*z[4]*z[9]*z[16] - 8*f0*f3*f5*z[1]*z[4]*z[10]^2 +
4*f1*f3*f5*z[1]*z[4]*z[10]*z[11] + (16*f0*f3*f7 + 8*f0*f5^2 -
8*f2*f3*f5)*z[1]*z[4]*z[10]*z[12] + (16*f0*f3*f7 +
8*f0*f5^2)*z[1]*z[4]*z[10]*z[13] + (-16*f0*f3*f8 + 32*f0*f4*f7 - 16*f0*f5*f6 -
16*f1*f3*f7 - 8*f1*f5^2)*z[1]*z[4]*z[10]*z[14] + (16*f0*f5*f7 + 16*f1*f3*f8 -
16*f1*f4*f7 + 8*f1*f5*f6 + 8*f2*f3*f7)*z[1]*z[4]*z[10]*z[15] + (-16*f0*f3*f7 -
8*f0*f5^2)*z[1]*z[4]*z[11]^2 + (16*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 +
16*f1*f3*f7 + 8*f1*f5^2 + 4*f3^2*f5)*z[1]*z[4]*z[11]*z[12] + (-16*f1*f4*f7 +
8*f1*f5*f6 + 8*f2*f3*f7)*z[1]*z[4]*z[11]*z[14] + (-16*f0*f5*f8 + 32*f1*f4*f8 -
16*f1*f5*f7 - 16*f2*f3*f8 - 8*f3^2*f7)*z[1]*z[4]*z[11]*z[15] + (-16*f0*f5*f7 -
16*f1*f3*f8 + 32*f1*f4*f7 - 16*f1*f5*f6 - 16*f2*f3*f7 -
8*f3*f4*f5)*z[1]*z[4]*z[12]^2 + (16*f1*f4*f7 - 8*f1*f5*f6 -
8*f2*f3*f7)*z[1]*z[4]*z[12]*z[13] + (16*f0*f5*f8 - 32*f1*f4*f8 + 16*f1*f5*f7 +
16*f2*f3*f8 + 8*f3^2*f7 + 4*f3*f5^2)*z[1]*z[4]*z[12]*z[14] + (16*f1*f5*f8 +
8*f3^2*f8 - 8*f3*f5*f6)*z[1]*z[4]*z[12]*z[15] + 12*f3*f5*z[1]*z[4]*z[12]*z[16] +
(16*f1*f5*f8 + 8*f3^2*f8)*z[1]*z[4]*z[13]*z[15] - 4*f3*f5*z[1]*z[4]*z[13]*z[16] +
(-16*f1*f5*f8 - 8*f3^2*f8)*z[1]*z[4]*z[14]^2 + 4*f3*f5*f7*z[1]*z[4]*z[14]*z[15] -
8*f3*f5*f8*z[1]*z[4]*z[15]^2 + (128*f0^2*f4*f8^2 - 64*f0^2*f5*f7*f8 +
128*f0^2*f6^2*f8 - 32*f0^2*f6*f7^2 - 64*f0*f1*f3*f8^2 + 32*f0*f1*f4*f7*f8 -
32*f0*f1*f5*f6*f8 + 128*f0*f2^2*f8^2 - 32*f0*f2*f3*f7*f8 + 384*f0*f2*f4*f6*f8 -
96*f0*f2*f4*f7^2 - 64*f0*f2*f5^2*f8 - 64*f0*f3^2*f6*f8 + 16*f0*f3^2*f7^2 -
32*f0*f3*f4*f5*f8 - 32*f1^2*f2*f8^2 - 96*f1^2*f4*f6*f8 + 24*f1^2*f4*f7^2 +
16*f1^2*f5^2*f8)*z[1]*z[5]*z[9]^2 + (-128*f0^2*f6*f8 + 32*f0^2*f7^2 +
32*f0*f1*f5*f8 - 256*f0*f2*f4*f8 + 48*f0*f2*f5*f7 + 48*f0*f3^2*f8 + 64*f1^2*f4*f8
- 12*f1^2*f5*f7)*z[1]*z[5]*z[9]*z[10] + (96*f0^2*f7*f8 + 64*f0*f2*f5*f8 +
32*f0*f3*f4*f8 - 24*f0*f3*f5*f7 - 16*f1^2*f5*f8)*z[1]*z[5]*z[9]*z[11] +
(64*f0^2*f8^2 - 64*f0*f1*f7*f8 - 32*f0*f3*f5*f8 - 64*f0*f4^2*f8 +
12*f1*f3*f5*f7)*z[1]*z[5]*z[9]*z[12] + (-192*f0^2*f8^2 - 192*f0*f2*f6*f8 +
48*f0*f2*f7^2 + 64*f0*f3*f5*f8 + 48*f1^2*f6*f8 -
12*f1^2*f7^2)*z[1]*z[5]*z[9]*z[13] + (96*f0*f1*f8^2 + 64*f0*f3*f6*f8 -
16*f0*f3*f7^2 + 32*f0*f4*f5*f8 - 24*f1*f3*f5*f8)*z[1]*z[5]*z[9]*z[14] +
(-128*f0*f2*f8^2 + 32*f0*f3*f7*f8 - 256*f0*f4*f6*f8 + 64*f0*f4*f7^2 +
48*f0*f5^2*f8 + 32*f1^2*f8^2 + 48*f1*f3*f6*f8 -
12*f1*f3*f7^2)*z[1]*z[5]*z[9]*z[15] + (96*f0*f4*f8 - 16*f0*f5*f7 -
16*f1*f3*f8)*z[1]*z[5]*z[9]*z[16] + (-32*f0^2*f8 - 32*f0*f2*f6 + 8*f0*f3*f5 +
8*f1^2*f6)*z[1]*z[5]*z[10]^2 + (32*f0*f1*f8 + 16*f0*f2*f7 + 16*f0*f3*f6 -
4*f1^2*f7)*z[1]*z[5]*z[10]*z[11] + (64*f0*f2*f8 - 16*f0*f3*f7 + 32*f0*f4*f6 -
16*f0*f5^2 - 32*f1^2*f8 - 16*f1*f3*f6)*z[1]*z[5]*z[10]*z[12] + (32*f0*f2*f8 -
8*f0*f3*f7 - 8*f1^2*f8)*z[1]*z[5]*z[10]*z[13] + (-16*f0*f3*f8 - 16*f0*f4*f7 +
8*f1*f3*f7)*z[1]*z[5]*z[10]*z[14] + (64*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f3*f8)*z[1]*z[5]*z[10]*z[15] + 16*f0*f6*z[1]*z[5]*z[10]*z[16] + (-64*f0*f2*f8
- 32*f0*f4*f6 + 8*f0*f5^2 + 8*f1^2*f8)*z[1]*z[5]*z[11]^2 + (16*f0*f5*f6 +
32*f1*f2*f8 + 4*f1*f3*f7 + 32*f1*f4*f6 - 8*f1*f5^2)*z[1]*z[5]*z[11]*z[12] +
(16*f0*f3*f8 + 32*f0*f4*f7)*z[1]*z[5]*z[11]*z[13] + (-8*f0*f5*f7 - 8*f1*f3*f8 -
16*f1*f4*f7)*z[1]*z[5]*z[11]*z[14] + (-16*f0*f5*f8 - 16*f1*f4*f8 +
8*f1*f5*f7)*z[1]*z[5]*z[11]*z[15] + (-8*f0*f7 - 8*f1*f6)*z[1]*z[5]*z[11]*z[16] +
(-64*f0*f4*f8 + 32*f0*f5*f7 - 32*f0*f6^2 + 32*f1*f3*f8 - 8*f1*f4*f7 - 32*f2^2*f8 -
32*f2*f4*f6 + 8*f2*f5^2 + 8*f3^2*f6)*z[1]*z[5]*z[12]^2 + (32*f0*f4*f8 -
16*f0*f5*f7 - 16*f1*f3*f8 - 16*f1*f4*f7)*z[1]*z[5]*z[12]*z[13] + (32*f0*f6*f7 +
4*f1*f5*f7 + 16*f2*f3*f8 + 32*f2*f4*f7 - 8*f3^2*f7)*z[1]*z[5]*z[12]*z[14] +
(64*f0*f6*f8 - 32*f0*f7^2 - 16*f1*f5*f8 + 32*f2*f4*f8 - 16*f2*f5*f7 -
16*f3^2*f8)*z[1]*z[5]*z[12]*z[15] + (16*f0*f8 + 4*f1*f7 + 16*f2*f6 -
4*f3*f5)*z[1]*z[5]*z[12]*z[16] - 32*f0*f4*f8*z[1]*z[5]*z[13]^2 + (16*f0*f5*f8 +
32*f1*f4*f8)*z[1]*z[5]*z[13]*z[14] + (32*f0*f6*f8 - 8*f0*f7^2 -
8*f1*f5*f8)*z[1]*z[5]*z[13]*z[15] + 4*f1*f7*z[1]*z[5]*z[13]*z[16] + (-64*f0*f6*f8
+ 8*f0*f7^2 - 32*f2*f4*f8 + 8*f3^2*f8)*z[1]*z[5]*z[14]^2 + (32*f0*f7*f8 +
16*f1*f6*f8 - 4*f1*f7^2 + 16*f2*f5*f8)*z[1]*z[5]*z[14]*z[15] + (-8*f1*f8 -
8*f2*f7)*z[1]*z[5]*z[14]*z[16] + (-32*f0*f8^2 - 32*f2*f6*f8 + 8*f2*f7^2 +
8*f3*f5*f8)*z[1]*z[5]*z[15]^2 + 16*f2*f8*z[1]*z[5]*z[15]*z[16] + (64*f0^2*f5*f8^2
- 128*f0^2*f6*f7*f8 + 32*f0^2*f7^3 - 64*f0*f1*f4*f8^2 + 48*f0*f1*f5*f7*f8 -
64*f0*f1*f6^2*f8 + 16*f0*f1*f6*f7^2 - 64*f0*f2*f3*f8^2 + 64*f0*f2*f4*f7*f8 -
64*f0*f2*f5*f6*f8 - 16*f0*f3^2*f7*f8 - 128*f0*f3*f4*f6*f8 + 32*f0*f3*f4*f7^2 +
32*f0*f3*f5^2*f8 + 32*f1^2*f3*f8^2 - 32*f1^2*f4*f7*f8 + 32*f1^2*f5*f6*f8 +
16*f1*f2*f3*f7*f8 + 16*f1*f3^2*f6*f8 - 4*f1*f3^2*f7^2 +
16*f1*f3*f4*f5*f8)*z[1]*z[6]*z[9]^2 + (96*f0^2*f7*f8 + 64*f0*f1*f6*f8 -
16*f0*f1*f7^2 + 64*f0*f2*f5*f8 + 96*f0*f3*f4*f8 - 8*f0*f3*f5*f7 - 32*f1^2*f5*f8 -
16*f1*f3^2*f8)*z[1]*z[6]*z[9]*z[10] + (-64*f0^2*f8^2 - 80*f0*f1*f7*f8 -
48*f0*f3*f5*f8 - 64*f0*f4^2*f8 + 4*f1*f3*f5*f7)*z[1]*z[6]*z[9]*z[11] +
(-64*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 16*f0*f3*f7^2 + 8*f0*f5^2*f7 + 64*f1^2*f7*f8 +
16*f1*f3*f5*f8 + 64*f1*f4^2*f8 - 32*f2*f3*f4*f8 - 8*f2*f3*f5*f7 +
8*f3^3*f8)*z[1]*z[6]*z[9]*z[12] + (96*f0*f1*f8^2 + 64*f0*f3*f6*f8 - 16*f0*f3*f7^2
+ 32*f0*f4*f5*f8 - 24*f1*f3*f5*f8)*z[1]*z[6]*z[9]*z[13] + (64*f0*f2*f8^2 +
32*f0*f3*f7*f8 + 64*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 32*f0*f5^2*f8 - 64*f1^2*f8^2 -
32*f1*f3*f6*f8 + 8*f1*f3*f7^2 - 32*f1*f4*f5*f8 +
32*f2*f3*f5*f8)*z[1]*z[6]*z[9]*z[14] + (-32*f0*f4*f7*f8 + 64*f0*f5*f6*f8 -
8*f0*f5*f7^2 - 16*f1*f3*f7*f8 + 64*f1*f4*f6*f8 - 16*f1*f4*f7^2 - 16*f1*f5^2*f8 -
32*f2*f3*f6*f8 + 8*f2*f3*f7^2 - 8*f3^2*f5*f8)*z[1]*z[6]*z[9]*z[15] + (-32*f0*f5*f8
- 32*f1*f4*f8 + 4*f1*f5*f7 + 16*f2*f3*f8)*z[1]*z[6]*z[9]*z[16] -
4*f1*f3*f5*z[1]*z[6]*z[10]^2 + (32*f0*f4*f6 - 16*f0*f5^2)*z[1]*z[6]*z[10]*z[11] +
(-16*f0*f3*f8 - 16*f0*f4*f7 + 8*f1*f3*f7 - 32*f1*f4*f6 + 16*f1*f5^2 +
16*f2*f3*f6)*z[1]*z[6]*z[10]*z[12] + (-32*f0*f3*f8 -
16*f0*f4*f7)*z[1]*z[6]*z[10]*z[13] + (-32*f0*f4*f8 + 8*f0*f5*f7 + 16*f1*f3*f8 +
16*f1*f4*f7 - 8*f2*f3*f7)*z[1]*z[6]*z[10]*z[14] + (-32*f0*f5*f8 -
4*f1*f5*f7)*z[1]*z[6]*z[10]*z[15] + (32*f0*f3*f8 - 16*f0*f4*f7 +
16*f0*f5*f6)*z[1]*z[6]*z[11]^2 + (32*f0*f4*f8 + 24*f0*f5*f7 - 32*f0*f6^2 -
32*f1*f3*f8 + 16*f1*f4*f7 - 16*f1*f5*f6 - 8*f2*f3*f7 -
8*f3^2*f6)*z[1]*z[6]*z[11]*z[12] + (32*f0*f4*f8 -
16*f0*f5*f7)*z[1]*z[6]*z[11]*z[13] + (-16*f0*f5*f8 + 16*f0*f6*f7 + 4*f1*f5*f7 +
4*f3^2*f7)*z[1]*z[6]*z[11]*z[14] + (32*f0*f6*f8 - 16*f0*f7^2 + 16*f1*f5*f8 +
8*f3^2*f8)*z[1]*z[6]*z[11]*z[15] + 4*f3*f5*z[1]*z[6]*z[11]*z[16] + (16*f0*f6*f7 -
32*f1*f5*f7 + 32*f1*f6^2 + 16*f2*f3*f8 + 4*f3^2*f7 + 16*f3*f4*f6 -
4*f3*f5^2)*z[1]*z[6]*z[12]^2 + (-16*f0*f5*f8 + 16*f0*f6*f7 - 32*f1*f4*f8 +
12*f1*f5*f7 + 16*f2*f3*f8 + 4*f3^2*f7)*z[1]*z[6]*z[12]*z[13] + (-16*f0*f7^2 +
32*f1*f5*f8 - 32*f1*f6*f7 - 16*f3^2*f8 - 16*f3*f4*f7)*z[1]*z[6]*z[12]*z[14] +
(16*f0*f7*f8 - 64*f1*f6*f8 + 32*f1*f7^2 + 12*f3*f5*f7)*z[1]*z[6]*z[12]*z[15] -
16*f3*f6*z[1]*z[6]*z[12]*z[16] + 16*f0*f5*f8*z[1]*z[6]*z[13]^2 + (-32*f0*f6*f8 -
16*f1*f5*f8 - 8*f3^2*f8)*z[1]*z[6]*z[13]*z[14] + 16*f0*f7*f8*z[1]*z[6]*z[13]*z[15]
+ (16*f0*f7*f8 + 32*f1*f6*f8 + 16*f3*f4*f8)*z[1]*z[6]*z[14]^2 + (-32*f0*f8^2 -
32*f1*f7*f8 - 24*f3*f5*f8)*z[1]*z[6]*z[14]*z[15] + 8*f3*f7*z[1]*z[6]*z[14]*z[16] +
(32*f1*f8^2 + 32*f3*f6*f8 - 8*f3*f7^2)*z[1]*z[6]*z[15]^2 -
16*f3*f8*z[1]*z[6]*z[15]*z[16] + (128*f0^2*f6*f8^2 - 32*f0^2*f7^2*f8 -
96*f0*f1*f5*f8^2 + 64*f0*f1*f6*f7*f8 - 16*f0*f1*f7^3 + 128*f0*f2*f4*f8^2 -
96*f0*f2*f5*f7*f8 + 256*f0*f2*f6^2*f8 - 64*f0*f2*f6*f7^2 - 96*f0*f3*f5*f6*f8 +
24*f0*f3*f5*f7^2 + 256*f0*f4^2*f6*f8 - 64*f0*f4^2*f7^2 - 64*f0*f4*f5^2*f8 +
16*f1^2*f5*f7*f8 - 64*f1^2*f6^2*f8 + 16*f1^2*f6*f7^2 - 32*f1*f2*f3*f8^2 -
64*f1*f3*f4*f6*f8 + 16*f1*f3*f4*f7^2 + 8*f1*f3*f5^2*f8)*z[1]*z[7]*z[9]^2 +
(-128*f0^2*f8^2 - 16*f0*f1*f7*f8 - 256*f0*f2*f6*f8 + 64*f0*f2*f7^2 +
48*f0*f3*f5*f8 - 128*f0*f4^2*f8 + 32*f0*f4*f5*f7 + 64*f1^2*f6*f8 - 16*f1^2*f7^2 +
32*f1*f3*f4*f8 - 8*f1*f3*f5*f7)*z[1]*z[7]*z[9]*z[10] + (96*f0*f1*f8^2 +
64*f0*f2*f7*f8 + 64*f0*f3*f6*f8 - 32*f0*f3*f7^2 + 96*f0*f4*f5*f8 - 16*f0*f5^2*f7 -
16*f1^2*f7*f8 - 8*f1*f3*f5*f8)*z[1]*z[7]*z[9]*z[11] + (64*f0*f2*f8^2 -
16*f0*f3*f7*f8 - 64*f0*f4*f6*f8 + 32*f0*f4*f7^2 - 16*f0*f5*f6*f7 - 64*f1^2*f8^2 -
32*f1*f3*f6*f8 + 16*f1*f3*f7^2 - 32*f1*f4*f5*f8 + 8*f1*f5^2*f7 + 16*f2*f3*f5*f8 +
4*f3^2*f5*f7)*z[1]*z[7]*z[9]*z[12] + (-128*f0*f2*f8^2 + 32*f0*f3*f7*f8 -
256*f0*f4*f6*f8 + 64*f0*f4*f7^2 + 48*f0*f5^2*f8 + 32*f1^2*f8^2 + 48*f1*f3*f6*f8 -
12*f1*f3*f7^2)*z[1]*z[7]*z[9]*z[13] + (-32*f0*f4*f7*f8 + 64*f0*f5*f6*f8 -
8*f0*f5*f7^2 - 16*f1*f3*f7*f8 + 64*f1*f4*f6*f8 - 16*f1*f4*f7^2 - 16*f1*f5^2*f8 -
32*f2*f3*f6*f8 + 8*f2*f3*f7^2 - 8*f3^2*f5*f8)*z[1]*z[7]*z[9]*z[14] +
(-64*f0*f4*f8^2 + 64*f0*f5*f7*f8 - 192*f0*f6^2*f8 + 48*f0*f6*f7^2 + 64*f1*f3*f8^2
+ 32*f1*f5*f6*f8 - 8*f1*f5*f7^2 + 32*f3^2*f6*f8 -
8*f3^2*f7^2)*z[1]*z[7]*z[9]*z[15] + (96*f0*f6*f8 - 24*f0*f7^2 - 8*f1*f5*f8 -
8*f3^2*f8)*z[1]*z[7]*z[9]*z[16] + (8*f0*f3*f7 - 32*f0*f4*f6 + 8*f0*f5^2 +
8*f1*f3*f6)*z[1]*z[7]*z[10]^2 + (16*f0*f5*f6 - 4*f1*f3*f7)*z[1]*z[7]*z[10]*z[11] +
(64*f0*f4*f8 - 40*f0*f5*f7 + 32*f0*f6^2 - 16*f1*f3*f8 + 16*f1*f4*f7 - 16*f1*f5*f6
- 8*f2*f3*f7 - 8*f3^2*f6)*z[1]*z[7]*z[10]*z[12] + (64*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f3*f8)*z[1]*z[7]*z[10]*z[13] + (16*f0*f5*f8 - 16*f0*f6*f7 - 32*f1*f4*f8 +
8*f1*f5*f7 + 16*f2*f3*f8 + 4*f3^2*f7)*z[1]*z[7]*z[10]*z[14] + (64*f0*f6*f8 -
8*f0*f7^2 - 8*f1*f5*f8 - 8*f3^2*f8)*z[1]*z[7]*z[10]*z[15] + (-64*f0*f4*f8 +
24*f0*f5*f7 - 32*f0*f6^2 + 8*f1*f3*f8)*z[1]*z[7]*z[11]^2 + (-16*f0*f5*f8 +
16*f0*f6*f7 + 32*f1*f4*f8 - 24*f1*f5*f7 + 32*f1*f6^2 + 8*f3^2*f7 + 16*f3*f4*f6 -
4*f3*f5^2)*z[1]*z[7]*z[11]*z[12] + (-16*f0*f5*f8 +
32*f0*f6*f7)*z[1]*z[7]*z[11]*z[13] + (-8*f0*f7^2 + 8*f1*f5*f8 - 16*f1*f6*f7 -
8*f3^2*f8 - 8*f3*f4*f7)*z[1]*z[7]*z[11]*z[14] + (-16*f0*f7*f8 - 32*f1*f6*f8 +
16*f1*f7^2 + 4*f3*f5*f7)*z[1]*z[7]*z[11]*z[15] - 8*f3*f6*z[1]*z[7]*z[11]*z[16] +
(-64*f0*f6*f8 + 16*f0*f7^2 + 32*f1*f5*f8 - 16*f1*f6*f7 - 32*f2*f4*f8 + 32*f2*f5*f7
- 32*f2*f6^2 + 8*f3^2*f8 - 16*f3*f4*f7 + 16*f3*f5*f6 - 32*f4^2*f6 +
8*f4*f5^2)*z[1]*z[7]*z[12]^2 + (32*f0*f6*f8 - 24*f0*f7^2 + 8*f1*f5*f8 -
16*f1*f6*f7 - 8*f3^2*f8 - 8*f3*f4*f7)*z[1]*z[7]*z[12]*z[13] + (16*f0*f7*f8 +
16*f1*f7^2 - 32*f2*f5*f8 + 32*f2*f6*f7 + 32*f3*f4*f8 - 16*f3*f5*f7 +
32*f4^2*f7)*z[1]*z[7]*z[12]*z[14] + (32*f0*f8^2 - 16*f1*f7*f8 + 64*f2*f6*f8 -
32*f2*f7^2 - 24*f3*f5*f8 - 16*f4*f5*f7)*z[1]*z[7]*z[12]*z[15] + (4*f3*f7 +
32*f4*f6 - 8*f5^2)*z[1]*z[7]*z[12]*z[16] - 32*f0*f6*f8*z[1]*z[7]*z[13]^2 +
(32*f0*f7*f8 + 32*f1*f6*f8 + 16*f3*f4*f8)*z[1]*z[7]*z[13]*z[14] + (-16*f1*f7*f8 -
8*f3*f5*f8)*z[1]*z[7]*z[13]*z[15] + 4*f3*f7*z[1]*z[7]*z[13]*z[16] + (-32*f0*f8^2 -
16*f1*f7*f8 - 32*f2*f6*f8 + 16*f3*f5*f8 - 32*f4^2*f8)*z[1]*z[7]*z[14]^2 +
(32*f1*f8^2 + 32*f2*f7*f8 + 16*f3*f6*f8 - 4*f3*f7^2 +
32*f4*f5*f8)*z[1]*z[7]*z[14]*z[15] + (-8*f3*f8 - 16*f4*f7)*z[1]*z[7]*z[14]*z[16] +
(-32*f2*f8^2 - 64*f4*f6*f8 + 16*f4*f7^2 + 8*f5^2*f8)*z[1]*z[7]*z[15]^2 +
32*f4*f8*z[1]*z[7]*z[15]*z[16] + (-128*f0*f2*f6*f8 + 32*f0*f2*f7^2 +
32*f0*f3*f5*f8 - 64*f0*f4^2*f8 + 16*f0*f4*f5*f7 + 32*f1^2*f6*f8 - 8*f1^2*f7^2 +
16*f1*f3*f4*f8)*z[1]*z[8]*z[9]^2 + (96*f0*f2*f8 - 8*f0*f3*f7 - 8*f0*f5^2 -
24*f1^2*f8)*z[1]*z[8]*z[9]*z[10] + (-32*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 +
4*f1*f3*f7)*z[1]*z[8]*z[9]*z[11] + (16*f0*f5*f7 + 16*f1*f3*f8 + 16*f1*f4*f7 -
8*f1*f5*f6 - 8*f2*f3*f7)*z[1]*z[8]*z[9]*z[12] + (96*f0*f4*f8 - 16*f0*f5*f7 -
16*f1*f3*f8)*z[1]*z[8]*z[9]*z[13] + (-32*f0*f5*f8 - 32*f1*f4*f8 + 4*f1*f5*f7 +
16*f2*f3*f8)*z[1]*z[8]*z[9]*z[14] + (96*f0*f6*f8 - 24*f0*f7^2 - 8*f1*f5*f8 -
8*f3^2*f8)*z[1]*z[8]*z[9]*z[15] + (-36*f0*f8 + f3*f5)*z[1]*z[8]*z[9]*z[16] +
(16*f0*f4 - 4*f1*f3)*z[1]*z[8]*z[10]^2 - 16*f0*f5*z[1]*z[8]*z[10]*z[11] +
(-16*f0*f6 + 12*f1*f5 + 4*f3^2)*z[1]*z[8]*z[10]*z[12] +
8*f0*f7*z[1]*z[8]*z[10]*z[14] + (-28*f0*f8 - f3*f5)*z[1]*z[8]*z[10]*z[15] +
16*f0*f6*z[1]*z[8]*z[11]^2 + (8*f0*f7 - 16*f1*f6 - 8*f3*f4)*z[1]*z[8]*z[11]*z[12]
- 16*f0*f7*z[1]*z[8]*z[11]*z[13] + (-4*f0*f8 + 8*f1*f7 +
f3*f5)*z[1]*z[8]*z[11]*z[14] + 8*f1*f8*z[1]*z[8]*z[11]*z[15] +
4*f3*z[1]*z[8]*z[11]*z[16] + (16*f0*f8 - 8*f1*f7 + 16*f2*f6 - 8*f3*f5 +
16*f4^2)*z[1]*z[8]*z[12]^2 + (-12*f0*f8 + 8*f1*f7 + 3*f3*f5)*z[1]*z[8]*z[12]*z[13]
+ (8*f1*f8 - 16*f2*f7 - 8*f4*f5)*z[1]*z[8]*z[12]*z[14] + (-16*f2*f8 + 12*f3*f7 +
4*f5^2)*z[1]*z[8]*z[12]*z[15] - 16*f4*z[1]*z[8]*z[12]*z[16] +
16*f0*f8*z[1]*z[8]*z[13]^2 - 16*f1*f8*z[1]*z[8]*z[13]*z[14] +
16*f2*f8*z[1]*z[8]*z[14]^2 - 16*f3*f8*z[1]*z[8]*z[14]*z[15] +
4*f5*z[1]*z[8]*z[14]*z[16] + (16*f4*f8 - 4*f5*f7)*z[1]*z[8]*z[15]^2 +
(32*f0^2*f4*f8 - 32*f0^2*f5*f7 + 32*f0^2*f6^2 + 64*f0*f2*f4*f6 - 16*f0*f2*f5^2 -
8*f0*f3^2*f6 - 16*f1^2*f4*f6 + 4*f1^2*f5^2)*z[2]^2*z[9]^2 + (-32*f0^2*f6 -
64*f0*f2*f4 + 8*f0*f3^2 + 16*f1^2*f4)*z[2]^2*z[9]*z[10] + (32*f0^2*f7 +
32*f0*f2*f5 - 8*f1^2*f5)*z[2]^2*z[9]*z[11] - 8*f0*f3*f5*z[2]^2*z[9]*z[12] +
(-32*f0^2*f8 - 32*f0*f2*f6 + 8*f0*f3*f5 + 8*f1^2*f6)*z[2]^2*z[9]*z[13] -
4*f1*f3*f5*z[2]^2*z[9]*z[14] + (8*f0*f3*f7 - 32*f0*f4*f6 + 8*f0*f5^2 +
8*f1*f3*f6)*z[2]^2*z[9]*z[15] + (16*f0*f4 - 4*f1*f3)*z[2]^2*z[9]*z[16] + (16*f0*f2
- 4*f1^2)*z[2]^2*z[10]*z[13] + (16*f0*f4 - 4*f1*f3)*z[2]^2*z[10]*z[15] +
(-16*f0*f2 + 4*f1^2)*z[2]^2*z[11]^2 + 8*f0*f3*z[2]^2*z[11]*z[12] -
8*f0*f5*z[2]^2*z[11]*z[15] - 16*f0*f4*z[2]^2*z[12]^2 + 8*f0*f5*z[2]^2*z[12]*z[14]
+ 8*f0*z[2]^2*z[12]*z[16] - 8*f0*f4*z[2]^2*z[13]^2 + (8*f0*f5 +
8*f1*f4)*z[2]^2*z[13]*z[14] - 4*f1*f5*z[2]^2*z[13]*z[15] + (-8*f0*f6 - 4*f1*f5 -
8*f2*f4 + 2*f3^2)*z[2]^2*z[14]^2 + (8*f0*f7 + 8*f1*f6 +
8*f2*f5)*z[2]^2*z[14]*z[15] - 4*f1*z[2]^2*z[14]*z[16] + (-8*f0*f8 - 4*f1*f7 -
8*f2*f6)*z[2]^2*z[15]^2 + 8*f2*z[2]^2*z[15]*z[16] + (32*f0^2*f5*f8 - 32*f0^2*f6*f7
- 32*f0*f1*f4*f8 + 32*f0*f1*f5*f7 - 32*f0*f1*f6^2 - 32*f0*f2*f4*f7 -
32*f0*f3*f4*f6 + 8*f0*f3*f5^2 + 8*f1^2*f4*f7)*z[2]*z[3]*z[9]^2 + (32*f0^2*f7 +
32*f0*f1*f6 + 16*f0*f2*f5 + 32*f0*f3*f4 - 4*f1^2*f5)*z[2]*z[3]*z[9]*z[10] +
(-32*f0^2*f8 - 32*f0*f1*f7 - 24*f0*f3*f5)*z[2]*z[3]*z[9]*z[11] +
4*f1*f3*f5*z[2]*z[3]*z[9]*z[12] + (32*f0*f1*f8 + 16*f0*f2*f7 + 16*f0*f3*f6 -
4*f1^2*f7)*z[2]*z[3]*z[9]*z[13] + (32*f0*f4*f6 - 16*f0*f5^2)*z[2]*z[3]*z[9]*z[14]
+ (16*f0*f5*f6 - 4*f1*f3*f7)*z[2]*z[3]*z[9]*z[15] - 16*f0*f5*z[2]*z[3]*z[9]*z[16]
+ (-16*f0*f2 + 4*f1^2)*z[2]*z[3]*z[10]*z[11] - 8*f0*f3*z[2]*z[3]*z[10]*z[13] -
16*f0*f4*z[2]*z[3]*z[10]*z[14] - 8*f0*f5*z[2]*z[3]*z[10]*z[15] +
16*f0*f3*z[2]*z[3]*z[11]^2 - 4*f1*f3*z[2]*z[3]*z[11]*z[12] +
8*f0*f5*z[2]*z[3]*z[11]*z[14] + 8*f0*z[2]*z[3]*z[11]*z[16] +
8*f1*f4*z[2]*z[3]*z[12]^2 - 4*f1*f5*z[2]*z[3]*z[12]*z[14] -
4*f1*z[2]*z[3]*z[12]*z[16] + 8*f0*f5*z[2]*z[3]*z[13]^2 + (-16*f0*f6 -
8*f1*f5)*z[2]*z[3]*z[13]*z[14] + (8*f0*f7 + 8*f1*f6)*z[2]*z[3]*z[13]*z[15] -
4*f1*z[2]*z[3]*z[13]*z[16] + (8*f0*f7 + 8*f1*f6 + 8*f2*f5)*z[2]*z[3]*z[14]^2 +
(-16*f0*f8 - 12*f1*f7 - 16*f2*f6 - 4*f3*f5)*z[2]*z[3]*z[14]*z[15] +
8*f2*z[2]*z[3]*z[14]*z[16] + (8*f1*f8 + 8*f2*f7 + 8*f3*f6)*z[2]*z[3]*z[15]^2 -
8*f3*z[2]*z[3]*z[15]*z[16] + (-64*f0^2*f6*f8 + 32*f0^2*f7^2 - 16*f0*f1*f5*f8 +
16*f0*f1*f6*f7 - 64*f0*f2*f4*f8 + 64*f0*f2*f5*f7 - 64*f0*f2*f6^2 + 16*f0*f3^2*f8 +
16*f0*f3*f5*f6 + 32*f1^2*f4*f8 - 32*f1^2*f5*f7 + 32*f1^2*f6^2 + 4*f1*f3^2*f7 +
16*f1*f3*f4*f6 - 4*f1*f3*f5^2)*z[2]*z[4]*z[9]^2 + (32*f0^2*f8 - 16*f0*f1*f7 +
64*f0*f2*f6 - 24*f0*f3*f5 - 32*f1^2*f6 - 16*f1*f3*f4)*z[2]*z[4]*z[9]*z[10] +
(16*f0*f1*f8 - 64*f0*f2*f7 + 32*f1^2*f7 + 12*f1*f3*f5)*z[2]*z[4]*z[9]*z[11] +
(16*f0*f3*f7 + 8*f0*f5^2 - 8*f2*f3*f5)*z[2]*z[4]*z[9]*z[12] + (64*f0*f2*f8 -
16*f0*f3*f7 + 32*f0*f4*f6 - 16*f0*f5^2 - 32*f1^2*f8 -
16*f1*f3*f6)*z[2]*z[4]*z[9]*z[13] + (-16*f0*f3*f8 - 16*f0*f4*f7 + 8*f1*f3*f7 -
32*f1*f4*f6 + 16*f1*f5^2 + 16*f2*f3*f6)*z[2]*z[4]*z[9]*z[14] + (64*f0*f4*f8 -
40*f0*f5*f7 + 32*f0*f6^2 - 16*f1*f3*f8 + 16*f1*f4*f7 - 16*f1*f5*f6 - 8*f2*f3*f7 -
8*f3^2*f6)*z[2]*z[4]*z[9]*z[15] + (-16*f0*f6 + 12*f1*f5 +
4*f3^2)*z[2]*z[4]*z[9]*z[16] + (-16*f0*f4 + 8*f1*f3)*z[2]*z[4]*z[10]*z[12] +
(-16*f0*f4 + 8*f1*f3)*z[2]*z[4]*z[10]*z[13] + (8*f0*f5 + 16*f1*f4 -
8*f2*f3)*z[2]*z[4]*z[10]*z[14] + (-16*f0*f6 + 4*f1*f5 +
4*f3^2)*z[2]*z[4]*z[10]*z[15] + (16*f0*f4 - 8*f1*f3)*z[2]*z[4]*z[11]^2 + (-8*f0*f5
- 16*f1*f4 + 8*f2*f3)*z[2]*z[4]*z[11]*z[12] - 4*f1*f5*z[2]*z[4]*z[11]*z[14] +
16*f0*f7*z[2]*z[4]*z[11]*z[15] + (16*f0*f6 - 4*f3^2)*z[2]*z[4]*z[12]^2 +
4*f1*f5*z[2]*z[4]*z[12]*z[13] - 16*f0*f7*z[2]*z[4]*z[12]*z[14] + (-16*f0*f8 +
4*f3*f5)*z[2]*z[4]*z[12]*z[15] + (-16*f0*f8 + 4*f3*f5)*z[2]*z[4]*z[13]*z[15] +
(16*f0*f8 - 4*f3*f5)*z[2]*z[4]*z[14]^2 + (-16*f0*f1*f5*f8 + 16*f0*f1*f6*f7 -
64*f0*f2*f4*f8 + 16*f0*f3^2*f8 + 16*f0*f3*f4*f7 + 16*f1^2*f4*f8)*z[2]*z[5]*z[9]^2
+ (-16*f0*f1*f7 - 8*f0*f3*f5)*z[2]*z[5]*z[9]*z[10] +
16*f0*f1*f8*z[2]*z[5]*z[9]*z[11] + (16*f0*f3*f7 + 8*f0*f5^2)*z[2]*z[5]*z[9]*z[12]
+ (32*f0*f2*f8 - 8*f0*f3*f7 - 8*f1^2*f8)*z[2]*z[5]*z[9]*z[13] + (-32*f0*f3*f8 -
16*f0*f4*f7)*z[2]*z[5]*z[9]*z[14] + (64*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f3*f8)*z[2]*z[5]*z[9]*z[15] + (16*f0*f2 - 4*f1^2)*z[2]*z[5]*z[10]^2 -
8*f0*f3*z[2]*z[5]*z[10]*z[11] + (-16*f0*f4 + 8*f1*f3)*z[2]*z[5]*z[10]*z[12] +
8*f0*f5*z[2]*z[5]*z[10]*z[14] - 8*f0*z[2]*z[5]*z[10]*z[16] +
16*f0*f4*z[2]*z[5]*z[11]^2 + (-8*f0*f5 - 16*f1*f4)*z[2]*z[5]*z[11]*z[12] -
8*f0*f5*z[2]*z[5]*z[11]*z[13] + 4*f1*f5*z[2]*z[5]*z[11]*z[14] +
4*f1*z[2]*z[5]*z[11]*z[16] + (16*f0*f6 + 16*f2*f4 - 4*f3^2)*z[2]*z[5]*z[12]^2 +
4*f1*f5*z[2]*z[5]*z[12]*z[13] + (-16*f0*f7 - 8*f2*f5)*z[2]*z[5]*z[12]*z[14] +
(-16*f0*f8 + 4*f3*f5)*z[2]*z[5]*z[12]*z[15] - 8*f2*z[2]*z[5]*z[12]*z[16] +
8*f0*f7*z[2]*z[5]*z[13]*z[14] + (-16*f0*f8 - 4*f1*f7)*z[2]*z[5]*z[13]*z[15] +
(16*f0*f8 - 4*f1*f7)*z[2]*z[5]*z[14]^2 + (8*f1*f8 + 8*f2*f7)*z[2]*z[5]*z[14]*z[15]
- 4*f3*f7*z[2]*z[5]*z[15]^2 + (32*f0*f1*f6*f8 - 16*f0*f1*f7^2 - 32*f0*f2*f5*f8 +
32*f0*f2*f6*f7 + 32*f0*f3*f4*f8 - 8*f0*f3*f5*f7 + 16*f1^2*f5*f8 - 16*f1^2*f6*f7 -
8*f1*f3^2*f8 - 8*f1*f3*f4*f7)*z[2]*z[6]*z[9]^2 + (-16*f0*f1*f8 - 32*f0*f2*f7 +
16*f1^2*f7 + 4*f1*f3*f5)*z[2]*z[6]*z[9]*z[10] + (32*f0*f2*f8 + 16*f0*f3*f7 +
8*f0*f5^2 - 16*f1^2*f8)*z[2]*z[6]*z[9]*z[11] + (-16*f0*f3*f8 + 32*f0*f4*f7 -
16*f0*f5*f6 - 16*f1*f3*f7 - 8*f1*f5^2)*z[2]*z[6]*z[9]*z[12] + (-16*f0*f3*f8 -
16*f0*f4*f7 + 8*f1*f3*f7)*z[2]*z[6]*z[9]*z[13] + (-32*f0*f4*f8 + 8*f0*f5*f7 +
16*f1*f3*f8 + 16*f1*f4*f7 - 8*f2*f3*f7)*z[2]*z[6]*z[9]*z[14] + (16*f0*f5*f8 -
16*f0*f6*f7 - 32*f1*f4*f8 + 8*f1*f5*f7 + 16*f2*f3*f8 +
4*f3^2*f7)*z[2]*z[6]*z[9]*z[15] + 8*f0*f7*z[2]*z[6]*z[9]*z[16] -
16*f0*f4*z[2]*z[6]*z[10]*z[11] + (8*f0*f5 + 16*f1*f4 -
8*f2*f3)*z[2]*z[6]*z[10]*z[12] + 8*f0*f5*z[2]*z[6]*z[10]*z[13] -
8*f1*f5*z[2]*z[6]*z[10]*z[14] + 8*f0*f7*z[2]*z[6]*z[10]*z[15] -
8*f0*f5*z[2]*z[6]*z[11]^2 + (16*f0*f6 + 8*f1*f5 + 4*f3^2)*z[2]*z[6]*z[11]*z[12] -
8*f0*f7*z[2]*z[6]*z[11]*z[14] + (-16*f0*f8 - 4*f3*f5)*z[2]*z[6]*z[11]*z[15] +
(-16*f0*f7 - 16*f1*f6 - 8*f3*f4)*z[2]*z[6]*z[12]^2 - 8*f0*f7*z[2]*z[6]*z[12]*z[13]
+ (16*f0*f8 + 16*f1*f7 + 4*f3*f5)*z[2]*z[6]*z[12]*z[14] +
16*f1*f8*z[2]*z[6]*z[12]*z[15] + 8*f3*z[2]*z[6]*z[12]*z[16] +
16*f0*f8*z[2]*z[6]*z[13]*z[14] - 16*f1*f8*z[2]*z[6]*z[14]^2 -
8*f3*f8*z[2]*z[6]*z[15]^2 + (-64*f0*f2*f6*f8 + 32*f0*f3*f5*f8 - 64*f0*f4^2*f8 +
16*f0*f4*f5*f7 + 8*f1^2*f7^2 + 16*f1*f3*f4*f8)*z[2]*z[7]*z[9]^2 + (64*f0*f2*f8 -
8*f0*f3*f7 - 8*f0*f5^2 - 8*f1^2*f8)*z[2]*z[7]*z[9]*z[10] + (-32*f0*f3*f8 -
4*f1*f3*f7)*z[2]*z[7]*z[9]*z[11] + (16*f0*f5*f7 + 16*f1*f3*f8 - 16*f1*f4*f7 +
8*f1*f5*f6 + 8*f2*f3*f7)*z[2]*z[7]*z[9]*z[12] + (64*f0*f4*f8 - 8*f0*f5*f7 -
8*f1*f3*f8)*z[2]*z[7]*z[9]*z[13] + (-32*f0*f5*f8 -
4*f1*f5*f7)*z[2]*z[7]*z[9]*z[14] + (64*f0*f6*f8 - 8*f0*f7^2 - 8*f1*f5*f8 -
8*f3^2*f8)*z[2]*z[7]*z[9]*z[15] + (-28*f0*f8 - f3*f5)*z[2]*z[7]*z[9]*z[16] +
(16*f0*f4 - 4*f1*f3)*z[2]*z[7]*z[10]^2 - 8*f0*f5*z[2]*z[7]*z[10]*z[11] +
(-16*f0*f6 + 4*f1*f5 + 4*f3^2)*z[2]*z[7]*z[10]*z[12] +
8*f0*f7*z[2]*z[7]*z[10]*z[14] + (-20*f0*f8 + f3*f5)*z[2]*z[7]*z[10]*z[15] +
16*f0*f6*z[2]*z[7]*z[11]^2 + (-8*f0*f7 - 16*f1*f6 - 8*f3*f4)*z[2]*z[7]*z[11]*z[12]
- 16*f0*f7*z[2]*z[7]*z[11]*z[13] + (4*f0*f8 + 8*f1*f7 +
3*f3*f5)*z[2]*z[7]*z[11]*z[14] + 8*f1*f8*z[2]*z[7]*z[11]*z[15] +
4*f3*z[2]*z[7]*z[11]*z[16] + (16*f0*f8 + 8*f1*f7 + 16*f2*f6 - 8*f3*f5 +
16*f4^2)*z[2]*z[7]*z[12]^2 + (-4*f0*f8 + 8*f1*f7 + f3*f5)*z[2]*z[7]*z[12]*z[13] +
(-8*f1*f8 - 16*f2*f7 - 8*f4*f5)*z[2]*z[7]*z[12]*z[14] + (-16*f2*f8 + 4*f3*f7 +
4*f5^2)*z[2]*z[7]*z[12]*z[15] - 16*f4*z[2]*z[7]*z[12]*z[16] +
16*f0*f8*z[2]*z[7]*z[13]^2 - 16*f1*f8*z[2]*z[7]*z[13]*z[14] +
16*f2*f8*z[2]*z[7]*z[14]^2 - 8*f3*f8*z[2]*z[7]*z[14]*z[15] +
4*f5*z[2]*z[7]*z[14]*z[16] + (16*f4*f8 - 4*f5*f7)*z[2]*z[7]*z[15]^2 +
(-32*f0*f4*f6 + 8*f0*f5^2)*z[2]*z[8]*z[9]^2 + 32*f0*f4*z[2]*z[8]*z[9]*z[10] -
16*f0*f5*z[2]*z[8]*z[9]*z[11] + 16*f0*f6*z[2]*z[8]*z[9]*z[13] -
8*f0*z[2]*z[8]*z[10]*z[13] + 8*f0*z[2]*z[8]*z[11]^2 - 4*f3*z[2]*z[8]*z[13]*z[14] +
8*f4*z[2]*z[8]*z[14]^2 - 8*f5*z[2]*z[8]*z[14]*z[15] + 8*f6*z[2]*z[8]*z[15]^2 -
8*z[2]*z[8]*z[15]*z[16] + (32*f0^2*f6*f8 - 16*f0*f1*f5*f8 + 16*f0*f1*f6*f7 +
96*f0*f2*f4*f8 - 32*f0*f2*f5*f7 + 32*f0*f2*f6^2 - 16*f0*f3^2*f8 + 16*f0*f3*f4*f7 -
16*f0*f3*f5*f6 + 32*f0*f4^2*f6 - 8*f0*f4*f5^2 - 16*f1^2*f4*f8)*z[3]^2*z[9]^2 +
(-32*f0^2*f8 - 16*f0*f1*f7 - 32*f0*f2*f6 + 16*f0*f3*f5 -
32*f0*f4^2)*z[3]^2*z[9]*z[10] + (16*f0*f1*f8 + 32*f0*f2*f7 +
16*f0*f4*f5)*z[3]^2*z[9]*z[11] + (-16*f0*f3*f7 - 8*f0*f5^2)*z[3]^2*z[9]*z[12] +
(-64*f0*f2*f8 - 32*f0*f4*f6 + 8*f0*f5^2 + 8*f1^2*f8)*z[3]^2*z[9]*z[13] +
(32*f0*f3*f8 - 16*f0*f4*f7 + 16*f0*f5*f6)*z[3]^2*z[9]*z[14] + (-64*f0*f4*f8 +
24*f0*f5*f7 - 32*f0*f6^2 + 8*f1*f3*f8)*z[3]^2*z[9]*z[15] +
16*f0*f6*z[3]^2*z[9]*z[16] + (-16*f0*f2 + 4*f1^2)*z[3]^2*z[10]^2 +
16*f0*f3*z[3]^2*z[10]*z[11] + (16*f0*f4 - 8*f1*f3)*z[3]^2*z[10]*z[12] +
16*f0*f4*z[3]^2*z[10]*z[13] - 8*f0*f5*z[3]^2*z[10]*z[14] +
16*f0*f6*z[3]^2*z[10]*z[15] + 8*f0*z[3]^2*z[10]*z[16] - 32*f0*f4*z[3]^2*z[11]^2 +
(8*f0*f5 + 16*f1*f4)*z[3]^2*z[11]*z[12] + 8*f0*f5*z[3]^2*z[11]*z[13] -
4*f1*f5*z[3]^2*z[11]*z[14] - 16*f0*f7*z[3]^2*z[11]*z[15] - 4*f1*z[3]^2*z[11]*z[16]
+ (-16*f0*f6 - 16*f2*f4 + 4*f3^2)*z[3]^2*z[12]^2 - 4*f1*f5*z[3]^2*z[12]*z[13] +
(16*f0*f7 + 8*f2*f5)*z[3]^2*z[12]*z[14] + (16*f0*f8 - 4*f3*f5)*z[3]^2*z[12]*z[15]
+ 8*f2*z[3]^2*z[12]*z[16] - 8*f0*f6*z[3]^2*z[13]^2 + (8*f0*f7 +
8*f1*f6)*z[3]^2*z[13]*z[14] + (16*f0*f8 - 4*f1*f7)*z[3]^2*z[13]*z[15] + (-24*f0*f8
- 4*f1*f7 - 8*f2*f6)*z[3]^2*z[14]^2 + (8*f1*f8 + 8*f2*f7 +
8*f3*f6)*z[3]^2*z[14]*z[15] - 4*f3*z[3]^2*z[14]*z[16] + (-8*f2*f8 - 4*f3*f7 -
8*f4*f6 + 2*f5^2)*z[3]^2*z[15]^2 + 8*f4*z[3]^2*z[15]*z[16] + (-32*f0^2*f7*f8 -
16*f0*f1*f7^2 - 32*f0*f3*f4*f8 - 24*f0*f3*f5*f7 + 32*f0*f3*f6^2 - 32*f0*f4*f5*f6 +
8*f0*f5^3 + 16*f1^2*f5*f8 - 16*f1^2*f6*f7 - 32*f1*f2*f4*f8 + 32*f1*f2*f5*f7 -
32*f1*f2*f6^2 + 8*f1*f3^2*f8 - 16*f1*f3*f4*f7 + 16*f1*f3*f5*f6 - 32*f1*f4^2*f6 +
8*f1*f4*f5^2)*z[3]*z[4]*z[9]^2 + (16*f0*f1*f8 - 32*f0*f3*f6 + 32*f0*f4*f5 +
16*f1^2*f7 + 32*f1*f2*f6 - 16*f1*f3*f5 + 32*f1*f4^2)*z[3]*z[4]*z[9]*z[10] +
(32*f0*f3*f7 - 16*f0*f5^2 - 16*f1^2*f8 - 32*f1*f2*f7 -
16*f1*f4*f5)*z[3]*z[4]*z[9]*z[11] + (16*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 +
16*f1*f3*f7 + 8*f1*f5^2 + 4*f3^2*f5)*z[3]*z[4]*z[9]*z[12] + (16*f0*f5*f6 +
32*f1*f2*f8 + 4*f1*f3*f7 + 32*f1*f4*f6 - 8*f1*f5^2)*z[3]*z[4]*z[9]*z[13] +
(32*f0*f4*f8 + 24*f0*f5*f7 - 32*f0*f6^2 - 32*f1*f3*f8 + 16*f1*f4*f7 - 16*f1*f5*f6
- 8*f2*f3*f7 - 8*f3^2*f6)*z[3]*z[4]*z[9]*z[14] + (-16*f0*f5*f8 + 16*f0*f6*f7 +
32*f1*f4*f8 - 24*f1*f5*f7 + 32*f1*f6^2 + 8*f3^2*f7 + 16*f3*f4*f6 -
4*f3*f5^2)*z[3]*z[4]*z[9]*z[15] + (8*f0*f7 - 16*f1*f6 -
8*f3*f4)*z[3]*z[4]*z[9]*z[16] + 8*f0*f3*z[3]*z[4]*z[10]^2 -
4*f1*f3*z[3]*z[4]*z[10]*z[11] + (-8*f0*f5 - 16*f1*f4 +
8*f2*f3)*z[3]*z[4]*z[10]*z[12] + (-8*f0*f5 - 16*f1*f4)*z[3]*z[4]*z[10]*z[13] +
(16*f0*f6 + 8*f1*f5 + 4*f3^2)*z[3]*z[4]*z[10]*z[14] + (-8*f0*f7 - 16*f1*f6 -
8*f3*f4)*z[3]*z[4]*z[10]*z[15] + (8*f0*f5 + 16*f1*f4)*z[3]*z[4]*z[11]^2 +
(-16*f0*f6 - 8*f1*f5 - 8*f3^2)*z[3]*z[4]*z[11]*z[12] -
8*f0*f7*z[3]*z[4]*z[11]*z[14] + (16*f0*f8 + 16*f1*f7 +
4*f3*f5)*z[3]*z[4]*z[11]*z[15] + (16*f0*f7 + 16*f1*f6 +
16*f3*f4)*z[3]*z[4]*z[12]^2 + 8*f0*f7*z[3]*z[4]*z[12]*z[13] + (-16*f0*f8 -
16*f1*f7 - 8*f3*f5)*z[3]*z[4]*z[12]*z[14] - 16*f1*f8*z[3]*z[4]*z[12]*z[15] -
12*f3*z[3]*z[4]*z[12]*z[16] + (-16*f1*f8 - 8*f3*f6)*z[3]*z[4]*z[13]*z[15] +
4*f3*z[3]*z[4]*z[13]*z[16] + (16*f1*f8 + 8*f3*f6)*z[3]*z[4]*z[14]^2 -
4*f3*f7*z[3]*z[4]*z[14]*z[15] + 8*f3*f8*z[3]*z[4]*z[15]^2 + (-32*f0*f1*f6*f8 +
32*f0*f2*f5*f8 - 32*f0*f2*f6*f7 - 32*f0*f3*f4*f8 + 16*f0*f3*f5*f7 -
32*f0*f4^2*f7)*z[3]*z[5]*z[9]^2 + (32*f0*f1*f8 + 32*f0*f2*f7 +
16*f0*f4*f5)*z[3]*z[5]*z[9]*z[10] + (-32*f0*f2*f8 - 16*f0*f3*f7 -
8*f0*f5^2)*z[3]*z[5]*z[9]*z[11] + (16*f0*f3*f8 + 32*f0*f4*f7)*z[3]*z[5]*z[9]*z[13]
+ (32*f0*f4*f8 - 16*f0*f5*f7)*z[3]*z[5]*z[9]*z[14] + (-16*f0*f5*f8 +
32*f0*f6*f7)*z[3]*z[5]*z[9]*z[15] - 16*f0*f7*z[3]*z[5]*z[9]*z[16] -
8*f0*f5*z[3]*z[5]*z[10]*z[13] - 16*f0*f7*z[3]*z[5]*z[10]*z[15] +
8*f0*f5*z[3]*z[5]*z[11]^2 + 16*f0*f8*z[3]*z[5]*z[11]*z[15] +
8*f0*f7*z[3]*z[5]*z[13]^2 + (-16*f0*f8 - 8*f1*f7)*z[3]*z[5]*z[13]*z[14] +
8*f1*f8*z[3]*z[5]*z[13]*z[15] + (8*f1*f8 + 8*f2*f7)*z[3]*z[5]*z[14]^2 + (-16*f2*f8
- 8*f3*f7)*z[3]*z[5]*z[14]*z[15] + (8*f3*f8 + 8*f4*f7)*z[3]*z[5]*z[15]^2 -
4*f5*z[3]*z[5]*z[15]*z[16] + (16*f0*f1*f7*f8 + 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 +
16*f0*f4*f5*f7 + 8*f1^2*f7^2 - 16*f1*f2*f5*f8 + 16*f1*f2*f6*f7 + 16*f1*f3*f4*f8 -
8*f1*f3*f5*f7 + 16*f1*f4^2*f7)*z[3]*z[6]*z[9]^2 + (8*f0*f3*f7 - 8*f0*f5^2 -
8*f1^2*f8 - 16*f1*f2*f7 - 8*f1*f4*f5)*z[3]*z[6]*z[9]*z[10] + (-16*f0*f3*f8 +
16*f1*f2*f8 + 4*f1*f3*f7 + 4*f1*f5^2)*z[3]*z[6]*z[9]*z[11] + (-16*f1*f4*f7 +
8*f1*f5*f6 + 8*f2*f3*f7)*z[3]*z[6]*z[9]*z[12] + (-8*f0*f5*f7 - 8*f1*f3*f8 -
16*f1*f4*f7)*z[3]*z[6]*z[9]*z[13] + (-16*f0*f5*f8 + 16*f0*f6*f7 + 4*f1*f5*f7 +
4*f3^2*f7)*z[3]*z[6]*z[9]*z[14] + (-8*f0*f7^2 + 8*f1*f5*f8 - 16*f1*f6*f7 -
8*f3^2*f8 - 8*f3*f4*f7)*z[3]*z[6]*z[9]*z[15] + (-4*f0*f8 + 8*f1*f7 +
f3*f5)*z[3]*z[6]*z[9]*z[16] + 8*f0*f5*z[3]*z[6]*z[10]*z[11] -
4*f1*f5*z[3]*z[6]*z[10]*z[12] + 4*f1*f5*z[3]*z[6]*z[10]*z[13] -
8*f0*f7*z[3]*z[6]*z[10]*z[14] + (4*f0*f8 + 8*f1*f7 +
3*f3*f5)*z[3]*z[6]*z[10]*z[15] - 4*f1*f5*z[3]*z[6]*z[11]^2 -
8*f0*f7*z[3]*z[6]*z[11]*z[12] + (12*f0*f8 + f3*f5)*z[3]*z[6]*z[11]*z[14] -
8*f1*f8*z[3]*z[6]*z[11]*z[15] + 8*f1*f7*z[3]*z[6]*z[12]^2 + (4*f0*f8 -
f3*f5)*z[3]*z[6]*z[12]*z[13] - 8*f1*f8*z[3]*z[6]*z[12]*z[14] -
4*f3*f7*z[3]*z[6]*z[12]*z[15] + 4*f3*f7*z[3]*z[6]*z[13]*z[15] -
4*f3*f7*z[3]*z[6]*z[14]^2 + 8*f3*f8*z[3]*z[6]*z[14]*z[15] + (32*f0*f2*f7*f8 -
32*f0*f3*f6*f8 + 16*f0*f3*f7^2 + 32*f0*f4*f5*f8 - 8*f0*f5^2*f7 - 16*f1^2*f7*f8 +
32*f1*f2*f6*f8 - 16*f1*f2*f7^2 - 8*f1*f3*f5*f8 - 8*f1*f4*f5*f7)*z[3]*z[7]*z[9]^2 +
(16*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 - 16*f1*f2*f8 + 8*f1*f3*f7 +
4*f1*f5^2)*z[3]*z[7]*z[9]*z[10] + (-32*f0*f4*f8 + 16*f0*f5*f7 + 8*f1*f3*f8 +
16*f1*f4*f7 - 8*f1*f5*f6)*z[3]*z[7]*z[9]*z[11] + (-16*f0*f5*f8 + 32*f1*f4*f8 -
16*f1*f5*f7 - 16*f2*f3*f8 - 8*f3^2*f7)*z[3]*z[7]*z[9]*z[12] + (-16*f0*f5*f8 -
16*f1*f4*f8 + 8*f1*f5*f7)*z[3]*z[7]*z[9]*z[13] + (32*f0*f6*f8 - 16*f0*f7^2 +
16*f1*f5*f8 + 8*f3^2*f8)*z[3]*z[7]*z[9]*z[14] + (-16*f0*f7*f8 - 32*f1*f6*f8 +
16*f1*f7^2 + 4*f3*f5*f7)*z[3]*z[7]*z[9]*z[15] + 8*f1*f8*z[3]*z[7]*z[9]*z[16] -
8*f0*f5*z[3]*z[7]*z[10]^2 + 16*f0*f7*z[3]*z[7]*z[10]*z[12] + (-16*f0*f8 -
4*f3*f5)*z[3]*z[7]*z[10]*z[14] + 8*f1*f8*z[3]*z[7]*z[10]*z[15] -
16*f0*f7*z[3]*z[7]*z[11]^2 + (16*f0*f8 + 16*f1*f7 + 4*f3*f5)*z[3]*z[7]*z[11]*z[12]
+ 16*f0*f8*z[3]*z[7]*z[11]*z[13] - 8*f1*f8*z[3]*z[7]*z[11]*z[14] -
8*f3*f7*z[3]*z[7]*z[11]*z[15] + (-16*f1*f8 - 16*f2*f7 - 8*f4*f5)*z[3]*z[7]*z[12]^2
- 8*f1*f8*z[3]*z[7]*z[12]*z[13] + (16*f2*f8 + 8*f3*f7 +
4*f5^2)*z[3]*z[7]*z[12]*z[14] + (8*f3*f8 + 16*f4*f7 -
8*f5*f6)*z[3]*z[7]*z[12]*z[15] + 8*f5*z[3]*z[7]*z[12]*z[16] +
8*f3*f8*z[3]*z[7]*z[13]*z[15] - 8*f3*f8*z[3]*z[7]*z[14]^2 -
16*f4*f8*z[3]*z[7]*z[14]*z[15] + (16*f0*f4*f7 + 16*f1*f4*f6 -
4*f1*f5^2)*z[3]*z[8]*z[9]^2 + (-8*f0*f5 - 16*f1*f4)*z[3]*z[8]*z[9]*z[10] +
8*f1*f5*z[3]*z[8]*z[9]*z[11] + (-8*f0*f7 - 8*f1*f6)*z[3]*z[8]*z[9]*z[13] +
4*f3*f5*z[3]*z[8]*z[9]*z[14] - 8*f3*f6*z[3]*z[8]*z[9]*z[15] +
4*f3*z[3]*z[8]*z[9]*z[16] + 8*f0*z[3]*z[8]*z[10]*z[11] +
4*f1*z[3]*z[8]*z[10]*z[13] + 4*f3*z[3]*z[8]*z[10]*z[15] - 4*f1*z[3]*z[8]*z[11]^2 -
4*f5*z[3]*z[8]*z[14]^2 + 8*f6*z[3]*z[8]*z[14]*z[15] - 4*z[3]*z[8]*z[14]*z[16] -
4*f7*z[3]*z[8]*z[15]^2 + (32*f0^2*f8^2 + 16*f0*f1*f7*f8 + 96*f0*f2*f6*f8 -
32*f0*f2*f7^2 - 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 64*f0*f4^2*f8 - 16*f0*f4*f5*f7 +
32*f0*f4*f6^2 - 8*f0*f5^2*f6 - 32*f1^2*f6*f8 + 16*f1^2*f7^2 - 16*f1*f2*f5*f8 +
16*f1*f2*f6*f7 - 16*f1*f3*f4*f8 + 24*f1*f3*f5*f7 - 32*f1*f3*f6^2 + 16*f1*f4*f5*f6
- 4*f1*f5^3 + 32*f2^2*f4*f8 - 32*f2^2*f5*f7 + 32*f2^2*f6^2 - 8*f2*f3^2*f8 +
16*f2*f3*f4*f7 - 16*f2*f3*f5*f6 + 32*f2*f4^2*f6 - 8*f2*f4*f5^2 - 4*f3^3*f7 -
8*f3^2*f4*f6 + 2*f3^2*f5^2)*z[4]^2*z[9]^2 + (-64*f0*f2*f8 + 32*f0*f3*f7 -
32*f0*f4*f6 + 8*f0*f5^2 + 16*f1^2*f8 - 16*f1*f2*f7 + 32*f1*f3*f6 - 16*f1*f4*f5 -
32*f2^2*f6 + 16*f2*f3*f5 - 32*f2*f4^2 + 8*f3^2*f4)*z[4]^2*z[9]*z[10] +
(16*f0*f5*f6 + 16*f1*f2*f8 - 32*f1*f3*f7 + 4*f1*f5^2 + 32*f2^2*f7 + 16*f2*f4*f5 -
4*f3^2*f5)*z[4]^2*z[9]*z[11] + (-16*f0*f5*f7 - 16*f1*f3*f8 + 32*f1*f4*f7 -
16*f1*f5*f6 - 16*f2*f3*f7 - 8*f3*f4*f5)*z[4]^2*z[9]*z[12] + (-64*f0*f4*f8 +
32*f0*f5*f7 - 32*f0*f6^2 + 32*f1*f3*f8 - 8*f1*f4*f7 - 32*f2^2*f8 - 32*f2*f4*f6 +
8*f2*f5^2 + 8*f3^2*f6)*z[4]^2*z[9]*z[13] + (16*f0*f6*f7 - 32*f1*f5*f7 + 32*f1*f6^2
+ 16*f2*f3*f8 + 4*f3^2*f7 + 16*f3*f4*f6 - 4*f3*f5^2)*z[4]^2*z[9]*z[14] +
(-64*f0*f6*f8 + 16*f0*f7^2 + 32*f1*f5*f8 - 16*f1*f6*f7 - 32*f2*f4*f8 + 32*f2*f5*f7
- 32*f2*f6^2 + 8*f3^2*f8 - 16*f3*f4*f7 + 16*f3*f5*f6 - 32*f4^2*f6 +
8*f4*f5^2)*z[4]^2*z[9]*z[15] + (16*f0*f8 - 8*f1*f7 + 16*f2*f6 - 8*f3*f5 +
16*f4^2)*z[4]^2*z[9]*z[16] - 16*f0*f4*z[4]^2*z[10]^2 + 8*f1*f4*z[4]^2*z[10]*z[11]
+ (16*f0*f6 - 4*f3^2)*z[4]^2*z[10]*z[12] + (16*f0*f6 + 16*f2*f4 -
4*f3^2)*z[4]^2*z[10]*z[13] + (-16*f0*f7 - 16*f1*f6 - 8*f3*f4)*z[4]^2*z[10]*z[14] +
(16*f0*f8 + 8*f1*f7 + 16*f2*f6 - 8*f3*f5 + 16*f4^2)*z[4]^2*z[10]*z[15] +
(-16*f0*f6 - 16*f2*f4 + 4*f3^2)*z[4]^2*z[11]^2 + (16*f0*f7 + 16*f1*f6 +
16*f3*f4)*z[4]^2*z[11]*z[12] + 8*f1*f7*z[4]^2*z[11]*z[14] + (-16*f1*f8 - 16*f2*f7
- 8*f4*f5)*z[4]^2*z[11]*z[15] + (-16*f0*f8 - 16*f1*f7 - 16*f2*f6 + 8*f3*f5 -
32*f4^2)*z[4]^2*z[12]^2 - 8*f1*f7*z[4]^2*z[12]*z[13] + (16*f1*f8 + 16*f2*f7 +
16*f4*f5)*z[4]^2*z[12]*z[14] + (16*f2*f8 - 4*f5^2)*z[4]^2*z[12]*z[15] +
24*f4*z[4]^2*z[12]*z[16] + (16*f2*f8 + 16*f4*f6 - 4*f5^2)*z[4]^2*z[13]*z[15] -
8*f4*z[4]^2*z[13]*z[16] + (-16*f2*f8 - 16*f4*f6 + 4*f5^2)*z[4]^2*z[14]^2 +
8*f4*f7*z[4]^2*z[14]*z[15] - 16*f4*f8*z[4]^2*z[15]^2 + (16*f0*f1*f7*f8 -
64*f0*f2*f6*f8 + 32*f0*f2*f7^2 + 16*f0*f3*f5*f8 - 16*f0*f3*f6*f7 + 16*f0*f4*f5*f7
+ 32*f1^2*f6*f8 - 8*f1^2*f7^2 - 16*f1*f2*f5*f8 + 16*f1*f2*f6*f7 + 16*f1*f3*f4*f8 -
8*f1*f3*f5*f7 + 16*f1*f4^2*f7)*z[4]*z[5]*z[9]^2 + (32*f0*f2*f8 + 8*f0*f3*f7 -
8*f0*f5^2 - 24*f1^2*f8 - 16*f1*f2*f7 - 8*f1*f4*f5)*z[4]*z[5]*z[9]*z[10] +
(-16*f0*f3*f8 - 32*f0*f4*f7 + 16*f0*f5*f6 + 16*f1*f2*f8 + 12*f1*f3*f7 +
4*f1*f5^2)*z[4]*z[5]*z[9]*z[11] + (16*f1*f4*f7 - 8*f1*f5*f6 -
8*f2*f3*f7)*z[4]*z[5]*z[9]*z[12] + (32*f0*f4*f8 - 16*f0*f5*f7 - 16*f1*f3*f8 -
16*f1*f4*f7)*z[4]*z[5]*z[9]*z[13] + (-16*f0*f5*f8 + 16*f0*f6*f7 - 32*f1*f4*f8 +
12*f1*f5*f7 + 16*f2*f3*f8 + 4*f3^2*f7)*z[4]*z[5]*z[9]*z[14] + (32*f0*f6*f8 -
24*f0*f7^2 + 8*f1*f5*f8 - 16*f1*f6*f7 - 8*f3^2*f8 -
8*f3*f4*f7)*z[4]*z[5]*z[9]*z[15] + (-12*f0*f8 + 8*f1*f7 +
3*f3*f5)*z[4]*z[5]*z[9]*z[16] + 4*f1*f5*z[4]*z[5]*z[10]*z[12] +
4*f1*f5*z[4]*z[5]*z[10]*z[13] - 8*f0*f7*z[4]*z[5]*z[10]*z[14] + (-4*f0*f8 +
8*f1*f7 + f3*f5)*z[4]*z[5]*z[10]*z[15] - 4*f1*f5*z[4]*z[5]*z[11]^2 +
8*f0*f7*z[4]*z[5]*z[11]*z[12] + (4*f0*f8 - f3*f5)*z[4]*z[5]*z[11]*z[14] -
8*f1*f8*z[4]*z[5]*z[11]*z[15] - 8*f1*f7*z[4]*z[5]*z[12]^2 + (-4*f0*f8 +
f3*f5)*z[4]*z[5]*z[12]*z[13] + 8*f1*f8*z[4]*z[5]*z[12]*z[14] +
4*f3*f7*z[4]*z[5]*z[12]*z[15] + 4*f3*f7*z[4]*z[5]*z[13]*z[15] -
4*f3*f7*z[4]*z[5]*z[14]^2 + (-32*f0*f1*f8^2 + 16*f0*f3*f7^2 - 32*f0*f4*f5*f8 -
32*f0*f4*f6*f7 + 8*f0*f5^2*f7 - 16*f1^2*f7*f8 - 16*f1*f2*f7^2 - 24*f1*f3*f5*f8 +
32*f1*f3*f6*f7 - 16*f1*f4*f5*f7 + 32*f2^2*f5*f8 - 32*f2^2*f6*f7 - 32*f2*f3*f4*f8 +
16*f2*f3*f5*f7 - 32*f2*f4^2*f7 + 8*f3^3*f8 + 8*f3^2*f4*f7)*z[4]*z[6]*z[9]^2 +
(-16*f0*f3*f8 + 32*f0*f4*f7 + 16*f1*f2*f8 - 24*f1*f3*f7 + 8*f1*f5^2 + 32*f2^2*f7 +
16*f2*f4*f5 - 4*f3^2*f5)*z[4]*z[6]*z[9]*z[10] + (32*f0*f4*f8 - 32*f0*f5*f7 +
24*f1*f3*f8 + 16*f1*f4*f7 - 8*f1*f5*f6 - 32*f2^2*f8 - 16*f2*f3*f7 -
8*f2*f5^2)*z[4]*z[6]*z[9]*z[11] + (16*f0*f5*f8 - 32*f1*f4*f8 + 16*f1*f5*f7 +
16*f2*f3*f8 + 8*f3^2*f7 + 4*f3*f5^2)*z[4]*z[6]*z[9]*z[12] + (32*f0*f6*f7 +
4*f1*f5*f7 + 16*f2*f3*f8 + 32*f2*f4*f7 - 8*f3^2*f7)*z[4]*z[6]*z[9]*z[13] +
(-16*f0*f7^2 + 32*f1*f5*f8 - 32*f1*f6*f7 - 16*f3^2*f8 -
16*f3*f4*f7)*z[4]*z[6]*z[9]*z[14] + (16*f0*f7*f8 + 16*f1*f7^2 - 32*f2*f5*f8 +
32*f2*f6*f7 + 32*f3*f4*f8 - 16*f3*f5*f7 + 32*f4^2*f7)*z[4]*z[6]*z[9]*z[15] +
(8*f1*f8 - 16*f2*f7 - 8*f4*f5)*z[4]*z[6]*z[9]*z[16] + 8*f0*f5*z[4]*z[6]*z[10]^2 -
4*f1*f5*z[4]*z[6]*z[10]*z[11] - 16*f0*f7*z[4]*z[6]*z[10]*z[12] + (-16*f0*f7 -
8*f2*f5)*z[4]*z[6]*z[10]*z[13] + (16*f0*f8 + 16*f1*f7 +
4*f3*f5)*z[4]*z[6]*z[10]*z[14] + (-8*f1*f8 - 16*f2*f7 -
8*f4*f5)*z[4]*z[6]*z[10]*z[15] + (16*f0*f7 + 8*f2*f5)*z[4]*z[6]*z[11]^2 +
(-16*f0*f8 - 16*f1*f7 - 8*f3*f5)*z[4]*z[6]*z[11]*z[12] -
8*f1*f8*z[4]*z[6]*z[11]*z[14] + (16*f2*f8 + 8*f3*f7 +
4*f5^2)*z[4]*z[6]*z[11]*z[15] + (16*f1*f8 + 16*f2*f7 + 16*f4*f5)*z[4]*z[6]*z[12]^2
+ 8*f1*f8*z[4]*z[6]*z[12]*z[13] + (-16*f2*f8 - 8*f3*f7 -
8*f5^2)*z[4]*z[6]*z[12]*z[14] + (-8*f3*f8 - 16*f4*f7 +
8*f5*f6)*z[4]*z[6]*z[12]*z[15] - 12*f5*z[4]*z[6]*z[12]*z[16] + (-8*f3*f8 -
16*f4*f7)*z[4]*z[6]*z[13]*z[15] + 4*f5*z[4]*z[6]*z[13]*z[16] + (8*f3*f8 +
16*f4*f7)*z[4]*z[6]*z[14]^2 - 4*f5*f7*z[4]*z[6]*z[14]*z[15] +
8*f5*f8*z[4]*z[6]*z[15]^2 + (-64*f0*f2*f8^2 - 16*f0*f3*f7*f8 - 64*f0*f4*f6*f8 +
32*f0*f4*f7^2 + 16*f0*f5^2*f8 + 32*f1^2*f8^2 + 16*f1*f2*f7*f8 + 64*f1*f3*f6*f8 -
32*f1*f3*f7^2 + 4*f1*f5^2*f7 - 64*f2^2*f6*f8 + 32*f2^2*f7^2 + 16*f2*f3*f5*f8 +
16*f2*f4*f5*f7 - 4*f3^2*f5*f7)*z[4]*z[7]*z[9]^2 + (64*f0*f4*f8 - 16*f0*f5*f7 -
40*f1*f3*f8 + 16*f1*f4*f7 - 8*f1*f5*f6 + 32*f2^2*f8 - 16*f2*f3*f7 -
8*f2*f5^2)*z[4]*z[7]*z[9]*z[10] + (-16*f0*f5*f8 - 16*f1*f4*f8 + 8*f1*f5*f7 -
32*f2*f4*f7 + 16*f2*f5*f6 + 16*f3^2*f7)*z[4]*z[7]*z[9]*z[11] + (16*f1*f5*f8 +
8*f3^2*f8 - 8*f3*f5*f6)*z[4]*z[7]*z[9]*z[12] + (64*f0*f6*f8 - 32*f0*f7^2 -
16*f1*f5*f8 + 32*f2*f4*f8 - 16*f2*f5*f7 - 16*f3^2*f8)*z[4]*z[7]*z[9]*z[13] +
(16*f0*f7*f8 - 64*f1*f6*f8 + 32*f1*f7^2 + 12*f3*f5*f7)*z[4]*z[7]*z[9]*z[14] +
(32*f0*f8^2 - 16*f1*f7*f8 + 64*f2*f6*f8 - 32*f2*f7^2 - 24*f3*f5*f8 -
16*f4*f5*f7)*z[4]*z[7]*z[9]*z[15] + (-16*f2*f8 + 12*f3*f7 +
4*f5^2)*z[4]*z[7]*z[9]*z[16] + (-16*f0*f8 + 4*f3*f5)*z[4]*z[7]*z[10]*z[12] +
(-16*f0*f8 + 4*f3*f5)*z[4]*z[7]*z[10]*z[13] + 16*f1*f8*z[4]*z[7]*z[10]*z[14] +
(-16*f2*f8 + 4*f3*f7 + 4*f5^2)*z[4]*z[7]*z[10]*z[15] + (16*f0*f8 -
4*f3*f5)*z[4]*z[7]*z[11]^2 - 16*f1*f8*z[4]*z[7]*z[11]*z[12] -
4*f3*f7*z[4]*z[7]*z[11]*z[14] + (8*f3*f8 + 16*f4*f7 -
8*f5*f6)*z[4]*z[7]*z[11]*z[15] + (16*f2*f8 - 4*f5^2)*z[4]*z[7]*z[12]^2 +
4*f3*f7*z[4]*z[7]*z[12]*z[13] + (-8*f3*f8 - 16*f4*f7 +
8*f5*f6)*z[4]*z[7]*z[12]*z[14] + (-16*f4*f8 + 8*f5*f7)*z[4]*z[7]*z[12]*z[15] +
(-16*f4*f8 + 8*f5*f7)*z[4]*z[7]*z[13]*z[15] + (16*f4*f8 -
8*f5*f7)*z[4]*z[7]*z[14]^2 + (-32*f0*f4*f8 - 8*f1*f4*f7 - 32*f2*f4*f6 + 8*f2*f5^2
+ 8*f3^2*f6)*z[4]*z[8]*z[9]^2 + (4*f1*f5 + 32*f2*f4 - 8*f3^2)*z[4]*z[8]*z[9]*z[10]
- 16*f2*f5*z[4]*z[8]*z[9]*z[11] + 12*f3*f5*z[4]*z[8]*z[9]*z[12] + (16*f0*f8 +
4*f1*f7 + 16*f2*f6 - 4*f3*f5)*z[4]*z[8]*z[9]*z[13] - 16*f3*f6*z[4]*z[8]*z[9]*z[14]
+ (4*f3*f7 + 32*f4*f6 - 8*f5^2)*z[4]*z[8]*z[9]*z[15] - 16*f4*z[4]*z[8]*z[9]*z[16]
+ 8*f0*z[4]*z[8]*z[10]^2 - 4*f1*z[4]*z[8]*z[10]*z[11] - 8*f2*z[4]*z[8]*z[10]*z[13]
+ 8*f3*z[4]*z[8]*z[10]*z[14] - 16*f4*z[4]*z[8]*z[10]*z[15] +
8*f2*z[4]*z[8]*z[11]^2 - 12*f3*z[4]*z[8]*z[11]*z[12] + 8*f5*z[4]*z[8]*z[11]*z[15]
+ 24*f4*z[4]*z[8]*z[12]^2 - 12*f5*z[4]*z[8]*z[12]*z[14] - 12*z[4]*z[8]*z[12]*z[16]
- 8*f6*z[4]*z[8]*z[13]*z[15] + 4*z[4]*z[8]*z[13]*z[16] + 8*f6*z[4]*z[8]*z[14]^2 -
4*f7*z[4]*z[8]*z[14]*z[15] + 8*f8*z[4]*z[8]*z[15]^2 + (32*f0*f2*f6*f8 -
16*f0*f3*f5*f8 + 32*f0*f4^2*f8)*z[5]^2*z[9]^2 - 32*f0*f2*f8*z[5]^2*z[9]*z[10] +
16*f0*f3*f8*z[5]^2*z[9]*z[11] - 32*f0*f4*f8*z[5]^2*z[9]*z[13] +
16*f0*f5*f8*z[5]^2*z[9]*z[14] - 32*f0*f6*f8*z[5]^2*z[9]*z[15] +
16*f0*f8*z[5]^2*z[9]*z[16] - 8*f0*f4*z[5]^2*z[10]^2 + 8*f0*f5*z[5]^2*z[10]*z[11] +
16*f0*f8*z[5]^2*z[10]*z[15] - 8*f0*f6*z[5]^2*z[11]^2 + 8*f0*f7*z[5]^2*z[11]*z[13]
- 16*f0*f8*z[5]^2*z[13]^2 + 8*f1*f8*z[5]^2*z[13]*z[14] - 8*f2*f8*z[5]^2*z[14]^2 +
8*f3*f8*z[5]^2*z[14]*z[15] - 8*f4*f8*z[5]^2*z[15]^2 + 2*z[5]^2*z[16]^2 +
(-32*f0*f2*f7*f8 + 32*f0*f3*f6*f8 - 32*f0*f4*f5*f8 - 32*f1*f2*f6*f8 +
16*f1*f3*f5*f8 - 32*f1*f4^2*f8)*z[5]*z[6]*z[9]^2 + (-16*f0*f3*f8 +
32*f1*f2*f8)*z[5]*z[6]*z[9]*z[10] + (32*f0*f4*f8 -
16*f1*f3*f8)*z[5]*z[6]*z[9]*z[11] + (16*f0*f5*f8 +
32*f1*f4*f8)*z[5]*z[6]*z[9]*z[13] + (-32*f0*f6*f8 - 16*f1*f5*f8 -
8*f3^2*f8)*z[5]*z[6]*z[9]*z[14] + (32*f0*f7*f8 + 32*f1*f6*f8 +
16*f3*f4*f8)*z[5]*z[6]*z[9]*z[15] - 16*f1*f8*z[5]*z[6]*z[9]*z[16] + (8*f0*f5 +
8*f1*f4)*z[5]*z[6]*z[10]^2 + (-16*f0*f6 - 8*f1*f5)*z[5]*z[6]*z[10]*z[11] +
8*f0*f7*z[5]*z[6]*z[10]*z[13] + 16*f0*f8*z[5]*z[6]*z[10]*z[14] -
16*f1*f8*z[5]*z[6]*z[10]*z[15] - 4*f3*z[5]*z[6]*z[10]*z[16] + (8*f0*f7 +
8*f1*f6)*z[5]*z[6]*z[11]^2 + (-16*f0*f8 - 8*f1*f7)*z[5]*z[6]*z[11]*z[13] +
8*f1*f8*z[5]*z[6]*z[13]^2 - 8*f3*f8*z[5]*z[6]*z[13]*z[15] +
8*f3*f8*z[5]*z[6]*z[14]^2 + (-16*f0*f3*f7*f8 - 64*f0*f4*f6*f8 + 16*f0*f4*f7^2 +
16*f0*f5^2*f8 + 16*f1*f2*f7*f8 + 16*f1*f4*f5*f8)*z[5]*z[7]*z[9]^2 + (64*f0*f4*f8 -
8*f0*f5*f7 - 8*f1*f3*f8)*z[5]*z[7]*z[9]*z[10] + (-32*f0*f5*f8 -
16*f1*f4*f8)*z[5]*z[7]*z[9]*z[11] + (16*f1*f5*f8 + 8*f3^2*f8)*z[5]*z[7]*z[9]*z[12]
+ (32*f0*f6*f8 - 8*f0*f7^2 - 8*f1*f5*f8)*z[5]*z[7]*z[9]*z[13] +
16*f0*f7*f8*z[5]*z[7]*z[9]*z[14] + (-16*f1*f7*f8 -
8*f3*f5*f8)*z[5]*z[7]*z[9]*z[15] - 4*f1*f5*z[5]*z[7]*z[10]^2 + (8*f0*f7 +
8*f1*f6)*z[5]*z[7]*z[10]*z[11] + (-16*f0*f8 + 4*f3*f5)*z[5]*z[7]*z[10]*z[12] +
(-16*f0*f8 - 4*f1*f7)*z[5]*z[7]*z[10]*z[13] + (16*f0*f8 -
4*f1*f7)*z[5]*z[7]*z[11]^2 + (-16*f1*f8 - 8*f3*f6)*z[5]*z[7]*z[11]*z[12] +
8*f1*f8*z[5]*z[7]*z[11]*z[13] + 4*f3*f7*z[5]*z[7]*z[11]*z[14] +
8*f3*f8*z[5]*z[7]*z[11]*z[15] + (16*f2*f8 + 16*f4*f6 - 4*f5^2)*z[5]*z[7]*z[12]^2 +
4*f3*f7*z[5]*z[7]*z[12]*z[13] + (-8*f3*f8 - 16*f4*f7)*z[5]*z[7]*z[12]*z[14] +
(-16*f4*f8 + 8*f5*f7)*z[5]*z[7]*z[12]*z[15] - 8*f6*z[5]*z[7]*z[12]*z[16] -
8*f3*f8*z[5]*z[7]*z[13]*z[14] + 16*f4*f8*z[5]*z[7]*z[14]^2 -
8*f5*f8*z[5]*z[7]*z[14]*z[15] + 4*f7*z[5]*z[7]*z[14]*z[16] + (16*f6*f8 -
4*f7^2)*z[5]*z[7]*z[15]^2 - 8*f8*z[5]*z[7]*z[15]*z[16] -
8*f1*f4*f7*z[5]*z[8]*z[9]^2 + 4*f1*f5*z[5]*z[8]*z[9]*z[10] -
4*f3*f5*z[5]*z[8]*z[9]*z[12] + 4*f1*f7*z[5]*z[8]*z[9]*z[13] +
4*f3*f7*z[5]*z[8]*z[9]*z[15] - 4*f1*z[5]*z[8]*z[10]*z[11] +
4*f3*z[5]*z[8]*z[11]*z[12] - 8*f4*z[5]*z[8]*z[12]^2 + 4*f5*z[5]*z[8]*z[12]*z[14] +
4*z[5]*z[8]*z[12]*z[16] - 4*f7*z[5]*z[8]*z[14]*z[15] + (32*f0*f2*f8^2 -
16*f0*f3*f7*f8 + 96*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 16*f0*f5^2*f8 + 16*f1*f2*f7*f8 -
32*f1*f3*f6*f8 + 16*f1*f4*f5*f8 + 32*f2^2*f6*f8 - 16*f2*f3*f5*f8 + 32*f2*f4^2*f8 -
8*f3^2*f4*f8)*z[6]^2*z[9]^2 + (-64*f0*f4*f8 + 8*f0*f5*f7 + 24*f1*f3*f8 -
32*f2^2*f8)*z[6]^2*z[9]*z[10] + (32*f0*f5*f8 - 16*f1*f4*f8 +
16*f2*f3*f8)*z[6]^2*z[9]*z[11] + (-16*f1*f5*f8 - 8*f3^2*f8)*z[6]^2*z[9]*z[12] +
(-64*f0*f6*f8 + 8*f0*f7^2 - 32*f2*f4*f8 + 8*f3^2*f8)*z[6]^2*z[9]*z[13] +
(16*f0*f7*f8 + 32*f1*f6*f8 + 16*f3*f4*f8)*z[6]^2*z[9]*z[14] + (-32*f0*f8^2 -
16*f1*f7*f8 - 32*f2*f6*f8 + 16*f3*f5*f8 - 32*f4^2*f8)*z[6]^2*z[9]*z[15] +
16*f2*f8*z[6]^2*z[9]*z[16] + (-8*f0*f6 - 4*f1*f5 - 8*f2*f4 +
2*f3^2)*z[6]^2*z[10]^2 + (8*f0*f7 + 8*f1*f6 + 8*f2*f5)*z[6]^2*z[10]*z[11] +
(16*f0*f8 - 4*f3*f5)*z[6]^2*z[10]*z[12] + (16*f0*f8 - 4*f1*f7)*z[6]^2*z[10]*z[13]
- 16*f1*f8*z[6]^2*z[10]*z[14] + 16*f2*f8*z[6]^2*z[10]*z[15] +
8*f4*z[6]^2*z[10]*z[16] + (-24*f0*f8 - 4*f1*f7 - 8*f2*f6)*z[6]^2*z[11]^2 +
(16*f1*f8 + 8*f3*f6)*z[6]^2*z[11]*z[12] + (8*f1*f8 + 8*f2*f7)*z[6]^2*z[11]*z[13] -
4*f3*f7*z[6]^2*z[11]*z[14] - 8*f3*f8*z[6]^2*z[11]*z[15] - 4*f5*z[6]^2*z[11]*z[16]
+ (-16*f2*f8 - 16*f4*f6 + 4*f5^2)*z[6]^2*z[12]^2 - 4*f3*f7*z[6]^2*z[12]*z[13] +
(8*f3*f8 + 16*f4*f7)*z[6]^2*z[12]*z[14] + (16*f4*f8 - 8*f5*f7)*z[6]^2*z[12]*z[15]
+ 8*f6*z[6]^2*z[12]*z[16] - 8*f2*f8*z[6]^2*z[13]^2 + 8*f3*f8*z[6]^2*z[13]*z[14] +
16*f4*f8*z[6]^2*z[13]*z[15] - 32*f4*f8*z[6]^2*z[14]^2 +
16*f5*f8*z[6]^2*z[14]*z[15] - 4*f7*z[6]^2*z[14]*z[16] + (-16*f6*f8 +
4*f7^2)*z[6]^2*z[15]^2 + 8*f8*z[6]^2*z[15]*z[16] + (32*f0*f3*f8^2 - 32*f0*f4*f7*f8
- 32*f1*f2*f8^2 + 32*f1*f3*f7*f8 - 32*f1*f4*f6*f8 + 8*f1*f4*f7^2 - 32*f2^2*f7*f8 -
32*f2*f4*f5*f8 + 8*f3^2*f5*f8)*z[6]*z[7]*z[9]^2 + (-4*f1*f5*f7 +
16*f2*f3*f8)*z[6]*z[7]*z[9]*z[10] + (32*f2*f4*f8 -
16*f3^2*f8)*z[6]*z[7]*z[9]*z[11] + 4*f3*f5*f7*z[6]*z[7]*z[9]*z[12] + (32*f0*f7*f8
+ 16*f1*f6*f8 - 4*f1*f7^2 + 16*f2*f5*f8)*z[6]*z[7]*z[9]*z[13] + (-32*f0*f8^2 -
32*f1*f7*f8 - 24*f3*f5*f8)*z[6]*z[7]*z[9]*z[14] + (32*f1*f8^2 + 32*f2*f7*f8 +
16*f3*f6*f8 - 4*f3*f7^2 + 32*f4*f5*f8)*z[6]*z[7]*z[9]*z[15] -
16*f3*f8*z[6]*z[7]*z[9]*z[16] + (8*f0*f7 + 8*f1*f6 + 8*f2*f5)*z[6]*z[7]*z[10]^2 +
(-16*f0*f8 - 12*f1*f7 - 16*f2*f6 - 4*f3*f5)*z[6]*z[7]*z[10]*z[11] + (8*f1*f8 +
8*f2*f7)*z[6]*z[7]*z[10]*z[13] - 8*f3*f8*z[6]*z[7]*z[10]*z[15] -
8*f5*z[6]*z[7]*z[10]*z[16] + (8*f1*f8 + 8*f2*f7 + 8*f3*f6)*z[6]*z[7]*z[11]^2 -
4*f3*f7*z[6]*z[7]*z[11]*z[12] + (-16*f2*f8 - 8*f3*f7)*z[6]*z[7]*z[11]*z[13] +
8*f3*f8*z[6]*z[7]*z[11]*z[14] - 16*f4*f8*z[6]*z[7]*z[11]*z[15] +
8*f6*z[6]*z[7]*z[11]*z[16] + 8*f4*f7*z[6]*z[7]*z[12]^2 -
4*f5*f7*z[6]*z[7]*z[12]*z[14] - 4*f7*z[6]*z[7]*z[12]*z[16] +
8*f3*f8*z[6]*z[7]*z[13]^2 - 8*f5*f8*z[6]*z[7]*z[13]*z[15] -
4*f7*z[6]*z[7]*z[13]*z[16] + 16*f5*f8*z[6]*z[7]*z[14]^2 + (-16*f6*f8 +
4*f7^2)*z[6]*z[7]*z[14]*z[15] + 8*f8*z[6]*z[7]*z[14]*z[16] + (16*f1*f4*f8 +
16*f2*f4*f7 - 4*f3^2*f7)*z[6]*z[8]*z[9]^2 - 8*f2*f5*z[6]*z[8]*z[9]*z[10] +
4*f3*f5*z[6]*z[8]*z[9]*z[11] + (-8*f1*f8 - 8*f2*f7)*z[6]*z[8]*z[9]*z[13] +
8*f3*f7*z[6]*z[8]*z[9]*z[14] + (-8*f3*f8 - 16*f4*f7)*z[6]*z[8]*z[9]*z[15] +
4*f5*z[6]*z[8]*z[9]*z[16] - 4*f1*z[6]*z[8]*z[10]^2 + 8*f2*z[6]*z[8]*z[10]*z[11] +
4*f5*z[6]*z[8]*z[10]*z[15] - 4*f3*z[6]*z[8]*z[11]^2 - 4*z[6]*z[8]*z[11]*z[16] +
4*f7*z[6]*z[8]*z[13]*z[15] - 4*f7*z[6]*z[8]*z[14]^2 + 8*f8*z[6]*z[8]*z[14]*z[15] +
(32*f0*f4*f8^2 - 32*f1*f3*f8^2 + 32*f2^2*f8^2 + 64*f2*f4*f6*f8 - 16*f2*f4*f7^2 -
8*f2*f5^2*f8 - 16*f3^2*f6*f8 + 4*f3^2*f7^2)*z[7]^2*z[9]^2 + (8*f1*f5*f8 -
32*f2*f4*f8 + 8*f2*f5*f7 + 8*f3^2*f8)*z[7]^2*z[9]*z[10] -
4*f3*f5*f7*z[7]^2*z[9]*z[11] - 8*f3*f5*f8*z[7]^2*z[9]*z[12] + (-32*f0*f8^2 -
32*f2*f6*f8 + 8*f2*f7^2 + 8*f3*f5*f8)*z[7]^2*z[9]*z[13] + (32*f1*f8^2 +
32*f3*f6*f8 - 8*f3*f7^2)*z[7]^2*z[9]*z[14] + (-32*f2*f8^2 - 64*f4*f6*f8 +
16*f4*f7^2 + 8*f5^2*f8)*z[7]^2*z[9]*z[15] + (16*f4*f8 - 4*f5*f7)*z[7]^2*z[9]*z[16]
+ (-8*f0*f8 - 4*f1*f7 - 8*f2*f6)*z[7]^2*z[10]^2 + (8*f1*f8 + 8*f2*f7 +
8*f3*f6)*z[7]^2*z[10]*z[11] - 4*f3*f7*z[7]^2*z[10]*z[13] -
8*f3*f8*z[7]^2*z[10]*z[14] + (16*f4*f8 - 4*f5*f7)*z[7]^2*z[10]*z[15] +
8*f6*z[7]^2*z[10]*z[16] + (-8*f2*f8 - 4*f3*f7 - 8*f4*f6 + 2*f5^2)*z[7]^2*z[11]^2 +
8*f3*f8*z[7]^2*z[11]*z[12] + (8*f3*f8 + 8*f4*f7)*z[7]^2*z[11]*z[13] -
4*f7*z[7]^2*z[11]*z[16] - 16*f4*f8*z[7]^2*z[12]^2 + 8*f5*f8*z[7]^2*z[12]*z[14] +
8*f8*z[7]^2*z[12]*z[16] - 8*f4*f8*z[7]^2*z[13]^2 + (16*f6*f8 -
4*f7^2)*z[7]^2*z[13]*z[15] + (-16*f6*f8 + 4*f7^2)*z[7]^2*z[14]^2 + (-32*f2*f4*f8 +
8*f3^2*f8)*z[7]*z[8]*z[9]^2 + 16*f2*f8*z[7]*z[8]*z[9]*z[13] -
16*f3*f8*z[7]*z[8]*z[9]*z[14] + 32*f4*f8*z[7]*z[8]*z[9]*z[15] +
8*f2*z[7]*z[8]*z[10]^2 - 8*f3*z[7]*z[8]*z[10]*z[11] - 8*z[7]*z[8]*z[10]*z[16] +
8*f4*z[7]*z[8]*z[11]^2 - 4*f5*z[7]*z[8]*z[11]*z[13] - 8*f8*z[7]*z[8]*z[13]*z[15] +
8*f8*z[7]*z[8]*z[14]^2 + 2*z[8]^2*z[13]^2,

// Bmat[6,1]
  (8*f0*f2*f5 - 2*f1^2*f5)*z[1]^2*z[10]^2 + (-16*f0*f2*f6 - 4*f0*f3*f5 +
4*f1^2*f6)*z[1]^2*z[10]*z[11] + (8*f0*f3*f6 + 2*f1*f3*f5)*z[1]^2*z[10]*z[12] +
(8*f0*f2*f7 - 2*f1^2*f7)*z[1]^2*z[10]*z[13] - 4*f0*f3*f7*z[1]^2*z[10]*z[14] -
4*f0*f5*z[1]^2*z[10]*z[16] + (8*f0*f2*f7 + 8*f0*f3*f6 - 2*f1^2*f7)*z[1]^2*z[11]^2
+ (-8*f0*f3*f7 - 16*f0*f4*f6 + 4*f0*f5^2 - 4*f1*f3*f6)*z[1]^2*z[11]*z[12] +
(-16*f0*f2*f8 - 8*f0*f3*f7 + 4*f1^2*f8)*z[1]^2*z[11]*z[13] + (8*f0*f3*f8 +
8*f0*f4*f7 + 2*f1*f3*f7)*z[1]^2*z[11]*z[14] - 4*f0*f5*f7*z[1]^2*z[11]*z[15] +
8*f0*f6*z[1]^2*z[11]*z[16] + (8*f0*f4*f7 + 8*f1*f4*f6 - 2*f1*f5^2)*z[1]^2*z[12]^2
+ (8*f0*f3*f8 + 8*f0*f4*f7 + 2*f1*f3*f7)*z[1]^2*z[12]*z[13] + (-16*f0*f4*f8 -
4*f0*f5*f7 - 8*f1*f4*f7)*z[1]^2*z[12]*z[14] + (8*f0*f5*f8 +
4*f1*f5*f7)*z[1]^2*z[12]*z[15] + (-4*f0*f7 - 4*f1*f6)*z[1]^2*z[12]*z[16] +
8*f0*f3*f8*z[1]^2*z[13]^2 + (-16*f0*f4*f8 - 4*f1*f3*f8)*z[1]^2*z[13]*z[14] +
8*f0*f5*f8*z[1]^2*z[13]*z[15] - 4*f0*f7*z[1]^2*z[13]*z[16] + (8*f0*f5*f8 +
8*f1*f4*f8)*z[1]^2*z[14]^2 + (-16*f0*f6*f8 + 4*f0*f7^2 -
8*f1*f5*f8)*z[1]^2*z[14]*z[15] + (8*f0*f8 + 2*f1*f7)*z[1]^2*z[14]*z[16] +
(8*f1*f6*f8 - 2*f1*f7^2)*z[1]^2*z[15]^2 - 4*f1*f8*z[1]^2*z[15]*z[16] +
(-16*f0*f2*f5 + 4*f1^2*f5)*z[1]*z[2]*z[9]*z[10] + (16*f0*f2*f6 + 4*f0*f3*f5 -
4*f1^2*f6)*z[1]*z[2]*z[9]*z[11] + (-8*f0*f3*f6 - 2*f1*f3*f5)*z[1]*z[2]*z[9]*z[12]
+ (-8*f0*f2*f7 + 2*f1^2*f7)*z[1]*z[2]*z[9]*z[13] + 4*f0*f3*f7*z[1]*z[2]*z[9]*z[14]
+ 4*f0*f5*z[1]*z[2]*z[9]*z[16] + (8*f0*f2 - 2*f1^2)*z[1]*z[2]*z[10]*z[11] -
4*f0*f3*z[1]*z[2]*z[10]*z[12] + 4*f0*f3*z[1]*z[2]*z[10]*z[13] -
2*f1*f3*z[1]*z[2]*z[10]*z[14] + 4*f0*f5*z[1]*z[2]*z[10]*z[15] -
8*f0*f3*z[1]*z[2]*z[11]^2 + (16*f0*f4 + 4*f1*f3)*z[1]*z[2]*z[11]*z[12] -
4*f0*f5*z[1]*z[2]*z[11]*z[14] - 8*f0*z[1]*z[2]*z[11]*z[16] + (-4*f0*f5 -
8*f1*f4)*z[1]*z[2]*z[12]^2 - 4*f0*f5*z[1]*z[2]*z[12]*z[13] + (8*f0*f6 +
4*f1*f5)*z[1]*z[2]*z[12]*z[14] - 4*f1*f6*z[1]*z[2]*z[12]*z[15] +
6*f1*z[1]*z[2]*z[12]*z[16] - 4*f0*f7*z[1]*z[2]*z[14]^2 + (8*f0*f8 +
2*f1*f7)*z[1]*z[2]*z[14]*z[15] - 4*f1*f8*z[1]*z[2]*z[15]^2 + (16*f0*f2*f6 +
4*f0*f3*f5 - 4*f1^2*f6)*z[1]*z[3]*z[9]*z[10] + (-16*f0*f2*f7 - 16*f0*f3*f6 +
4*f1^2*f7)*z[1]*z[3]*z[9]*z[11] + (8*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 +
4*f1*f3*f6)*z[1]*z[3]*z[9]*z[12] + (16*f0*f2*f8 + 8*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[3]*z[9]*z[13] + (-8*f0*f3*f8 - 8*f0*f4*f7 -
2*f1*f3*f7)*z[1]*z[3]*z[9]*z[14] + 4*f0*f5*f7*z[1]*z[3]*z[9]*z[15] -
8*f0*f6*z[1]*z[3]*z[9]*z[16] + (-8*f0*f2 + 2*f1^2)*z[1]*z[3]*z[10]^2 +
8*f0*f3*z[1]*z[3]*z[10]*z[11] + (-8*f0*f4 - 2*f1*f3)*z[1]*z[3]*z[10]*z[12] -
8*f0*f4*z[1]*z[3]*z[10]*z[13] + (4*f0*f5 + 4*f1*f4)*z[1]*z[3]*z[10]*z[14] +
(-8*f0*f6 - 2*f1*f5)*z[1]*z[3]*z[10]*z[15] + 8*f0*z[1]*z[3]*z[10]*z[16] -
4*f0*f5*z[1]*z[3]*z[11]*z[12] + 4*f0*f5*z[1]*z[3]*z[11]*z[13] -
2*f1*f5*z[1]*z[3]*z[11]*z[14] + (8*f0*f7 + 4*f1*f6)*z[1]*z[3]*z[11]*z[15] -
2*f1*z[1]*z[3]*z[11]*z[16] + 4*f1*f5*z[1]*z[3]*z[12]^2 -
4*f1*f6*z[1]*z[3]*z[12]*z[14] + (-8*f0*f8 - 4*f1*f7)*z[1]*z[3]*z[12]*z[15] +
(-8*f0*f8 - 2*f1*f7)*z[1]*z[3]*z[13]*z[15] + 2*f1*f7*z[1]*z[3]*z[14]^2 +
4*f1*f8*z[1]*z[3]*z[14]*z[15] + (-8*f0*f3*f6 - 2*f1*f3*f5)*z[1]*z[4]*z[9]*z[10] +
(8*f0*f3*f7 + 16*f0*f4*f6 - 4*f0*f5^2 + 4*f1*f3*f6)*z[1]*z[4]*z[9]*z[11] +
(-16*f0*f4*f7 - 16*f1*f4*f6 + 4*f1*f5^2)*z[1]*z[4]*z[9]*z[12] + (-8*f0*f3*f8 -
8*f0*f4*f7 - 2*f1*f3*f7)*z[1]*z[4]*z[9]*z[13] + (16*f0*f4*f8 + 4*f0*f5*f7 +
8*f1*f4*f7)*z[1]*z[4]*z[9]*z[14] + (-8*f0*f5*f8 - 4*f1*f5*f7)*z[1]*z[4]*z[9]*z[15]
+ (4*f0*f7 + 4*f1*f6)*z[1]*z[4]*z[9]*z[16] + 4*f0*f3*z[1]*z[4]*z[10]^2 + (-8*f0*f4
- 2*f1*f3)*z[1]*z[4]*z[10]*z[11] + (4*f0*f5 + 8*f1*f4)*z[1]*z[4]*z[10]*z[12] +
(4*f0*f5 + 4*f1*f4)*z[1]*z[4]*z[10]*z[13] + (-4*f1*f5 - 8*f2*f4 +
2*f3^2)*z[1]*z[4]*z[10]*z[14] + (-4*f0*f7 + 4*f1*f6 +
4*f2*f5)*z[1]*z[4]*z[10]*z[15] - 4*f1*z[1]*z[4]*z[10]*z[16] +
4*f0*f5*z[1]*z[4]*z[11]^2 - 4*f1*f5*z[1]*z[4]*z[11]*z[12] + (-8*f0*f6 -
2*f1*f5)*z[1]*z[4]*z[11]*z[13] + (-4*f0*f7 + 4*f1*f6 +
4*f2*f5)*z[1]*z[4]*z[11]*z[14] + (8*f0*f8 - 8*f2*f6)*z[1]*z[4]*z[11]*z[15] +
4*f2*z[1]*z[4]*z[11]*z[16] + (4*f0*f7 + 4*f1*f6)*z[1]*z[4]*z[12]*z[13] -
2*f3*f5*z[1]*z[4]*z[12]*z[14] + 4*f3*f6*z[1]*z[4]*z[12]*z[15] -
2*f3*z[1]*z[4]*z[12]*z[16] + 4*f0*f7*z[1]*z[4]*z[13]^2 -
4*f1*f7*z[1]*z[4]*z[13]*z[14] + 4*f2*f7*z[1]*z[4]*z[13]*z[15] -
2*f3*z[1]*z[4]*z[13]*z[16] - 2*f3*f7*z[1]*z[4]*z[14]*z[15] +
4*f4*z[1]*z[4]*z[14]*z[16] - 2*f5*z[1]*z[4]*z[15]*z[16] + (-8*f0*f2*f7 +
2*f1^2*f7)*z[1]*z[5]*z[9]*z[10] + (16*f0*f2*f8 + 8*f0*f3*f7 -
4*f1^2*f8)*z[1]*z[5]*z[9]*z[11] + (-8*f0*f3*f8 - 8*f0*f4*f7 -
2*f1*f3*f7)*z[1]*z[5]*z[9]*z[12] - 16*f0*f3*f8*z[1]*z[5]*z[9]*z[13] + (16*f0*f4*f8
+ 4*f1*f3*f8)*z[1]*z[5]*z[9]*z[14] - 8*f0*f5*f8*z[1]*z[5]*z[9]*z[15] +
4*f0*f7*z[1]*z[5]*z[9]*z[16] - 4*f0*f3*z[1]*z[5]*z[10]^2 +
8*f0*f4*z[1]*z[5]*z[10]*z[11] - 4*f1*f4*z[1]*z[5]*z[10]*z[12] +
4*f0*f7*z[1]*z[5]*z[10]*z[15] + 2*f1*z[1]*z[5]*z[10]*z[16] -
4*f0*f5*z[1]*z[5]*z[11]^2 + (8*f0*f6 + 2*f1*f5)*z[1]*z[5]*z[11]*z[12] -
4*f0*f7*z[1]*z[5]*z[11]*z[14] + (-8*f0*f8 - 2*f1*f7)*z[1]*z[5]*z[11]*z[15] +
(-4*f0*f7 - 4*f1*f6)*z[1]*z[5]*z[12]^2 - 4*f0*f7*z[1]*z[5]*z[12]*z[13] + (8*f0*f8
+ 6*f1*f7)*z[1]*z[5]*z[12]*z[14] + 4*f1*f8*z[1]*z[5]*z[12]*z[15] +
8*f0*f8*z[1]*z[5]*z[13]*z[14] + 4*f1*f8*z[1]*z[5]*z[13]*z[15] -
8*f1*f8*z[1]*z[5]*z[14]^2 + 4*f0*f3*f7*z[1]*z[6]*z[9]*z[10] + (-8*f0*f3*f8 -
8*f0*f4*f7 - 2*f1*f3*f7)*z[1]*z[6]*z[9]*z[11] + (16*f0*f4*f8 + 4*f0*f5*f7 +
8*f1*f4*f7)*z[1]*z[6]*z[9]*z[12] + (16*f0*f4*f8 + 4*f1*f3*f8)*z[1]*z[6]*z[9]*z[13]
+ (-16*f0*f5*f8 - 16*f1*f4*f8)*z[1]*z[6]*z[9]*z[14] + (16*f0*f6*f8 - 4*f0*f7^2 +
8*f1*f5*f8)*z[1]*z[6]*z[9]*z[15] + (-8*f0*f8 - 2*f1*f7)*z[1]*z[6]*z[9]*z[16] +
2*f1*f3*z[1]*z[6]*z[10]^2 - 4*f1*f4*z[1]*z[6]*z[10]*z[11] + (-8*f0*f6 + 8*f2*f4 -
2*f3^2)*z[1]*z[6]*z[10]*z[12] + 4*f0*f7*z[1]*z[6]*z[10]*z[14] -
2*f1*f7*z[1]*z[6]*z[10]*z[15] - 4*f2*z[1]*z[6]*z[10]*z[16] +
2*f1*f5*z[1]*z[6]*z[11]^2 + (4*f0*f7 - 4*f2*f5)*z[1]*z[6]*z[11]*z[12] +
4*f0*f7*z[1]*z[6]*z[11]*z[13] - 2*f1*f7*z[1]*z[6]*z[11]*z[14] +
4*f2*f7*z[1]*z[6]*z[11]*z[15] + 2*f3*z[1]*z[6]*z[11]*z[16] +
2*f3*f5*z[1]*z[6]*z[12]^2 + (-8*f0*f8 - 2*f1*f7)*z[1]*z[6]*z[12]*z[13] -
2*f3*f7*z[1]*z[6]*z[12]*z[15] - 4*f4*z[1]*z[6]*z[12]*z[16] -
8*f0*f8*z[1]*z[6]*z[13]^2 + 8*f1*f8*z[1]*z[6]*z[13]*z[14] -
8*f2*f8*z[1]*z[6]*z[13]*z[15] + 4*f3*f8*z[1]*z[6]*z[14]*z[15] +
2*z[1]*z[6]*z[16]^2 + 4*f0*f5*f7*z[1]*z[7]*z[9]*z[11] + (-8*f0*f5*f8 -
4*f1*f5*f7)*z[1]*z[7]*z[9]*z[12] - 8*f0*f5*f8*z[1]*z[7]*z[9]*z[13] + (16*f0*f6*f8
- 4*f0*f7^2 + 8*f1*f5*f8)*z[1]*z[7]*z[9]*z[14] + (-16*f1*f6*f8 +
4*f1*f7^2)*z[1]*z[7]*z[9]*z[15] + 4*f1*f8*z[1]*z[7]*z[9]*z[16] -
4*f0*f5*z[1]*z[7]*z[10]^2 + (8*f0*f6 + 2*f1*f5)*z[1]*z[7]*z[10]*z[11] + (4*f0*f7 -
4*f2*f5)*z[1]*z[7]*z[10]*z[12] - 4*f0*f7*z[1]*z[7]*z[10]*z[13] -
8*f0*f8*z[1]*z[7]*z[10]*z[14] + 4*f1*f8*z[1]*z[7]*z[10]*z[15] + (-8*f0*f7 -
4*f1*f6)*z[1]*z[7]*z[11]^2 + (4*f1*f7 + 8*f2*f6)*z[1]*z[7]*z[11]*z[12] + (16*f0*f8
+ 4*f1*f7)*z[1]*z[7]*z[11]*z[13] + (-4*f1*f8 - 4*f2*f7)*z[1]*z[7]*z[11]*z[14] -
4*f3*f6*z[1]*z[7]*z[12]^2 + (-4*f1*f8 - 4*f2*f7)*z[1]*z[7]*z[12]*z[13] +
4*f3*f7*z[1]*z[7]*z[12]*z[14] + 2*f5*z[1]*z[7]*z[12]*z[16] -
4*f1*f8*z[1]*z[7]*z[13]^2 + 8*f2*f8*z[1]*z[7]*z[13]*z[14] -
4*f3*f8*z[1]*z[7]*z[14]^2 + 4*f0*f5*z[1]*z[8]*z[9]*z[10] -
8*f0*f6*z[1]*z[8]*z[9]*z[11] + (4*f0*f7 + 4*f1*f6)*z[1]*z[8]*z[9]*z[12] +
4*f0*f7*z[1]*z[8]*z[9]*z[13] + (-8*f0*f8 - 2*f1*f7)*z[1]*z[8]*z[9]*z[14] +
4*f1*f8*z[1]*z[8]*z[9]*z[15] + f3*z[1]*z[8]*z[9]*z[16] -
2*f1*z[1]*z[8]*z[10]*z[12] - 2*f1*z[1]*z[8]*z[10]*z[13] +
4*f2*z[1]*z[8]*z[10]*z[14] - f3*z[1]*z[8]*z[10]*z[15] + 2*f1*z[1]*z[8]*z[11]^2 -
4*f2*z[1]*z[8]*z[11]*z[12] - f3*z[1]*z[8]*z[11]*z[14] + 2*f3*z[1]*z[8]*z[12]^2 +
f3*z[1]*z[8]*z[12]*z[13] - 2*z[1]*z[8]*z[14]*z[16] + (8*f0*f2*f5 -
2*f1^2*f5)*z[2]^2*z[9]^2 + (-8*f0*f2 + 2*f1^2)*z[2]^2*z[9]*z[11] +
4*f0*f3*z[2]^2*z[9]*z[12] - 4*f0*f3*z[2]^2*z[9]*z[13] + 2*f1*f3*z[2]^2*z[9]*z[14]
- 4*f0*f5*z[2]^2*z[9]*z[15] - 4*f0*z[2]^2*z[12]*z[14] + 2*f1*z[2]^2*z[12]*z[15] +
4*f0*z[2]^2*z[13]*z[14] - 2*f1*z[2]^2*z[14]^2 + (-16*f0*f2*f6 - 4*f0*f3*f5 +
4*f1^2*f6)*z[2]*z[3]*z[9]^2 + (8*f0*f2 - 2*f1^2)*z[2]*z[3]*z[9]*z[10] +
8*f0*f3*z[2]*z[3]*z[9]*z[11] + (-8*f0*f4 - 2*f1*f3)*z[2]*z[3]*z[9]*z[12] +
8*f0*f4*z[2]*z[3]*z[9]*z[13] - 4*f1*f4*z[2]*z[3]*z[9]*z[14] + (8*f0*f6 +
2*f1*f5)*z[2]*z[3]*z[9]*z[15] - 2*f1*z[2]*z[3]*z[11]*z[15] +
4*f0*z[2]*z[3]*z[12]^2 + 2*f1*z[2]*z[3]*z[12]*z[14] - 4*f0*z[2]*z[3]*z[13]^2 +
2*f1*z[2]*z[3]*z[13]*z[14] + (8*f0*f3*f6 + 2*f1*f3*f5)*z[2]*z[4]*z[9]^2 -
4*f0*f3*z[2]*z[4]*z[9]*z[10] + (-8*f0*f4 - 2*f1*f3)*z[2]*z[4]*z[9]*z[11] +
(4*f0*f5 + 8*f1*f4)*z[2]*z[4]*z[9]*z[12] - 4*f1*f4*z[2]*z[4]*z[9]*z[13] +
(-8*f0*f6 + 8*f2*f4 - 2*f3^2)*z[2]*z[4]*z[9]*z[14] + (4*f0*f7 -
4*f2*f5)*z[2]*z[4]*z[9]*z[15] - 2*f1*z[2]*z[4]*z[9]*z[16] +
4*f0*z[2]*z[4]*z[10]*z[14] - 2*f1*z[2]*z[4]*z[10]*z[15] -
4*f0*z[2]*z[4]*z[11]*z[12] + 4*f0*z[2]*z[4]*z[11]*z[13] -
2*f1*z[2]*z[4]*z[11]*z[14] + 4*f2*z[2]*z[4]*z[11]*z[15] -
2*f1*z[2]*z[4]*z[12]*z[13] - 2*f3*z[2]*z[4]*z[12]*z[15] + 2*f1*z[2]*z[4]*z[13]^2 -
4*f2*z[2]*z[4]*z[13]*z[14] + 2*f3*z[2]*z[4]*z[13]*z[15] + 2*f3*z[2]*z[4]*z[14]^2 -
4*f4*z[2]*z[4]*z[14]*z[15] + 2*f5*z[2]*z[4]*z[15]^2 + (8*f0*f2*f7 -
2*f1^2*f7)*z[2]*z[5]*z[9]^2 + 4*f0*f3*z[2]*z[5]*z[9]*z[10] -
8*f0*f4*z[2]*z[5]*z[9]*z[11] + (4*f0*f5 + 4*f1*f4)*z[2]*z[5]*z[9]*z[12] -
4*f0*f7*z[2]*z[5]*z[9]*z[15] - 2*f1*z[2]*z[5]*z[9]*z[16] -
4*f0*z[2]*z[5]*z[10]*z[14] - 4*f0*z[2]*z[5]*z[11]*z[12] +
4*f0*z[2]*z[5]*z[11]*z[13] + 2*f1*z[2]*z[5]*z[12]^2 - 2*f1*z[2]*z[5]*z[12]*z[13] -
4*f0*f3*f7*z[2]*z[6]*z[9]^2 - 2*f1*f3*z[2]*z[6]*z[9]*z[10] + (4*f0*f5 +
4*f1*f4)*z[2]*z[6]*z[9]*z[11] + (-4*f1*f5 - 8*f2*f4 + 2*f3^2)*z[2]*z[6]*z[9]*z[12]
+ 4*f0*f7*z[2]*z[6]*z[9]*z[14] - 8*f0*f8*z[2]*z[6]*z[9]*z[15] +
4*f2*z[2]*z[6]*z[9]*z[16] + 4*f0*z[2]*z[6]*z[10]*z[12] -
4*f0*z[2]*z[6]*z[10]*z[13] + 4*f1*z[2]*z[6]*z[10]*z[14] -
2*f1*z[2]*z[6]*z[11]*z[13] - 2*f3*z[2]*z[6]*z[11]*z[15] +
4*f2*z[2]*z[6]*z[12]*z[13] - 2*f3*z[2]*z[6]*z[12]*z[14] +
4*f4*z[2]*z[6]*z[12]*z[15] - 2*z[2]*z[6]*z[15]*z[16] +
4*f0*f5*z[2]*z[7]*z[9]*z[10] + (-8*f0*f6 - 2*f1*f5)*z[2]*z[7]*z[9]*z[11] +
(-4*f0*f7 + 4*f1*f6 + 4*f2*f5)*z[2]*z[7]*z[9]*z[12] + 4*f0*f7*z[2]*z[7]*z[9]*z[13]
- 2*f1*f7*z[2]*z[7]*z[9]*z[14] + 4*f1*f8*z[2]*z[7]*z[9]*z[15] -
f3*z[2]*z[7]*z[9]*z[16] - 2*f1*z[2]*z[7]*z[10]*z[12] + f3*z[2]*z[7]*z[10]*z[15] +
2*f1*z[2]*z[7]*z[11]^2 - 4*f2*z[2]*z[7]*z[11]*z[12] + f3*z[2]*z[7]*z[11]*z[14] +
2*f3*z[2]*z[7]*z[12]^2 - f3*z[2]*z[7]*z[12]*z[13] - 2*f5*z[2]*z[7]*z[12]*z[15] -
4*f0*f5*z[2]*z[8]*z[9]^2 + 8*f0*z[2]*z[8]*z[9]*z[11] - 4*f1*z[2]*z[8]*z[9]*z[12] +
2*f1*z[2]*z[8]*z[9]*z[13] - 4*f2*z[2]*z[8]*z[9]*z[14] + 2*z[2]*z[8]*z[14]*z[15] +
(8*f0*f2*f7 + 8*f0*f3*f6 - 2*f1^2*f7)*z[3]^2*z[9]^2 - 8*f0*f3*z[3]^2*z[9]*z[10] +
4*f0*f5*z[3]^2*z[9]*z[12] - 4*f0*f5*z[3]^2*z[9]*z[13] + 2*f1*f5*z[3]^2*z[9]*z[14]
+ (-8*f0*f7 - 4*f1*f6)*z[3]^2*z[9]*z[15] + 2*f1*z[3]^2*z[9]*z[16] +
2*f1*z[3]^2*z[10]*z[15] - 2*f1*z[3]^2*z[12]^2 + (-8*f0*f3*f7 - 16*f0*f4*f6 +
4*f0*f5^2 - 4*f1*f3*f6)*z[3]*z[4]*z[9]^2 + (16*f0*f4 +
4*f1*f3)*z[3]*z[4]*z[9]*z[10] - 4*f0*f5*z[3]*z[4]*z[9]*z[11] -
4*f1*f5*z[3]*z[4]*z[9]*z[12] + (8*f0*f6 + 2*f1*f5)*z[3]*z[4]*z[9]*z[13] + (4*f0*f7
- 4*f2*f5)*z[3]*z[4]*z[9]*z[14] + (4*f1*f7 + 8*f2*f6)*z[3]*z[4]*z[9]*z[15] -
4*f2*z[3]*z[4]*z[9]*z[16] - 4*f0*z[3]*z[4]*z[10]*z[12] -
4*f0*z[3]*z[4]*z[10]*z[13] - 4*f2*z[3]*z[4]*z[10]*z[15] +
4*f1*z[3]*z[4]*z[11]*z[12] + 2*f5*z[3]*z[4]*z[14]*z[15] - 4*f6*z[3]*z[4]*z[15]^2 +
4*z[3]*z[4]*z[15]*z[16] + (-16*f0*f2*f8 - 8*f0*f3*f7 + 4*f1^2*f8)*z[3]*z[5]*z[9]^2
+ 4*f0*f5*z[3]*z[5]*z[9]*z[11] + (-8*f0*f6 - 2*f1*f5)*z[3]*z[5]*z[9]*z[12] +
4*f0*f7*z[3]*z[5]*z[9]*z[14] + (16*f0*f8 + 4*f1*f7)*z[3]*z[5]*z[9]*z[15] +
4*f0*z[3]*z[5]*z[10]*z[12] + 4*f0*z[3]*z[5]*z[10]*z[13] -
2*f1*z[3]*z[5]*z[10]*z[14] + (8*f0*f3*f8 + 8*f0*f4*f7 +
2*f1*f3*f7)*z[3]*z[6]*z[9]^2 - 4*f0*f5*z[3]*z[6]*z[9]*z[10] -
2*f1*f5*z[3]*z[6]*z[9]*z[11] + (-4*f0*f7 + 4*f1*f6 + 4*f2*f5)*z[3]*z[6]*z[9]*z[12]
- 4*f0*f7*z[3]*z[6]*z[9]*z[13] - 2*f1*f7*z[3]*z[6]*z[9]*z[14] + (-4*f1*f8 -
4*f2*f7)*z[3]*z[6]*z[9]*z[15] - f3*z[3]*z[6]*z[9]*z[16] -
2*f1*z[3]*z[6]*z[10]*z[12] + f3*z[3]*z[6]*z[10]*z[15] + f3*z[3]*z[6]*z[11]*z[14] -
f3*z[3]*z[6]*z[12]*z[13] - 2*f5*z[3]*z[6]*z[12]*z[15] + 2*f7*z[3]*z[6]*z[15]^2 -
4*f0*f5*f7*z[3]*z[7]*z[9]^2 + (8*f0*f7 + 4*f1*f6)*z[3]*z[7]*z[9]*z[11] + (8*f0*f8
- 8*f2*f6)*z[3]*z[7]*z[9]*z[12] + (-8*f0*f8 - 2*f1*f7)*z[3]*z[7]*z[9]*z[13] +
4*f2*f7*z[3]*z[7]*z[9]*z[14] - 2*f1*z[3]*z[7]*z[10]*z[11] +
4*f2*z[3]*z[7]*z[10]*z[12] - 2*f3*z[3]*z[7]*z[10]*z[14] +
4*f6*z[3]*z[7]*z[12]*z[15] - 2*z[3]*z[7]*z[12]*z[16] + 2*z[3]*z[7]*z[13]*z[16] -
2*f7*z[3]*z[7]*z[14]*z[15] + 8*f0*f6*z[3]*z[8]*z[9]^2 - 8*f0*z[3]*z[8]*z[9]*z[10]
- 2*f1*z[3]*z[8]*z[9]*z[11] + 4*f2*z[3]*z[8]*z[9]*z[12] +
2*f3*z[3]*z[8]*z[9]*z[14] - 2*z[3]*z[8]*z[12]*z[15] - 2*z[3]*z[8]*z[13]*z[15] +
(8*f0*f4*f7 + 8*f1*f4*f6 - 2*f1*f5^2)*z[4]^2*z[9]^2 + (-4*f0*f5 -
8*f1*f4)*z[4]^2*z[9]*z[10] + 4*f1*f5*z[4]^2*z[9]*z[11] + (-4*f0*f7 -
4*f1*f6)*z[4]^2*z[9]*z[13] + 2*f3*f5*z[4]^2*z[9]*z[14] - 4*f3*f6*z[4]^2*z[9]*z[15]
+ 2*f3*z[4]^2*z[9]*z[16] + 4*f0*z[4]^2*z[10]*z[11] + 2*f1*z[4]^2*z[10]*z[13] +
2*f3*z[4]^2*z[10]*z[15] - 2*f1*z[4]^2*z[11]^2 - 2*f5*z[4]^2*z[14]^2 +
4*f6*z[4]^2*z[14]*z[15] - 2*z[4]^2*z[14]*z[16] - 2*f7*z[4]^2*z[15]^2 + (8*f0*f3*f8
+ 8*f0*f4*f7 + 2*f1*f3*f7)*z[4]*z[5]*z[9]^2 - 4*f0*f5*z[4]*z[5]*z[9]*z[10] +
(4*f0*f7 + 4*f1*f6)*z[4]*z[5]*z[9]*z[12] - 4*f0*f7*z[4]*z[5]*z[9]*z[13] +
(-8*f0*f8 - 2*f1*f7)*z[4]*z[5]*z[9]*z[14] + (-4*f1*f8 -
4*f2*f7)*z[4]*z[5]*z[9]*z[15] + f3*z[4]*z[5]*z[9]*z[16] -
2*f1*z[4]*z[5]*z[10]*z[12] - 2*f1*z[4]*z[5]*z[10]*z[13] +
4*f2*z[4]*z[5]*z[10]*z[14] - f3*z[4]*z[5]*z[10]*z[15] - f3*z[4]*z[5]*z[11]*z[14] +
f3*z[4]*z[5]*z[12]*z[13] - 2*z[4]*z[5]*z[14]*z[16] + 2*f7*z[4]*z[5]*z[15]^2 +
(-16*f0*f4*f8 - 4*f0*f5*f7 - 8*f1*f4*f7)*z[4]*z[6]*z[9]^2 + (8*f0*f6 +
4*f1*f5)*z[4]*z[6]*z[9]*z[10] - 4*f1*f6*z[4]*z[6]*z[9]*z[11] -
2*f3*f5*z[4]*z[6]*z[9]*z[12] + (8*f0*f8 + 6*f1*f7)*z[4]*z[6]*z[9]*z[13] +
4*f3*f7*z[4]*z[6]*z[9]*z[15] - 4*f0*z[4]*z[6]*z[10]^2 + 2*f1*z[4]*z[6]*z[10]*z[11]
- 2*f3*z[4]*z[6]*z[10]*z[14] + 4*f5*z[4]*z[6]*z[12]*z[14] -
4*f6*z[4]*z[6]*z[12]*z[15] + 2*z[4]*z[6]*z[12]*z[16] - 2*f7*z[4]*z[6]*z[14]*z[15]
+ 4*f8*z[4]*z[6]*z[15]^2 + (8*f0*f5*f8 + 4*f1*f5*f7)*z[4]*z[7]*z[9]^2 -
4*f1*f6*z[4]*z[7]*z[9]*z[10] + (-8*f0*f8 - 4*f1*f7)*z[4]*z[7]*z[9]*z[11] +
4*f3*f6*z[4]*z[7]*z[9]*z[12] + 4*f1*f8*z[4]*z[7]*z[9]*z[13] -
2*f3*f7*z[4]*z[7]*z[9]*z[14] + 2*f1*z[4]*z[7]*z[10]^2 - 2*f3*z[4]*z[7]*z[10]*z[12]
+ 4*f4*z[4]*z[7]*z[10]*z[14] - 2*f5*z[4]*z[7]*z[10]*z[15] -
2*f5*z[4]*z[7]*z[11]*z[14] + 4*f6*z[4]*z[7]*z[11]*z[15] - 2*z[4]*z[7]*z[11]*z[16]
- 4*f6*z[4]*z[7]*z[12]*z[14] + 4*f7*z[4]*z[7]*z[12]*z[15] -
2*f7*z[4]*z[7]*z[13]*z[15] + 2*f7*z[4]*z[7]*z[14]^2 - 4*f8*z[4]*z[7]*z[14]*z[15] +
(-4*f0*f7 - 4*f1*f6)*z[4]*z[8]*z[9]^2 + 6*f1*z[4]*z[8]*z[9]*z[10] -
2*f3*z[4]*z[8]*z[9]*z[12] - 4*f4*z[4]*z[8]*z[9]*z[14] + 2*f5*z[4]*z[8]*z[9]*z[15]
- 2*z[4]*z[8]*z[11]*z[15] + 2*z[4]*z[8]*z[12]*z[14] + 2*z[4]*z[8]*z[13]*z[14] +
8*f0*f3*f8*z[5]^2*z[9]^2 + 4*f0*f7*z[5]^2*z[9]*z[12] - 8*f0*f8*z[5]^2*z[9]*z[14] -
4*f1*f8*z[5]^2*z[9]*z[15] - 4*f0*z[5]^2*z[10]*z[11] + 2*f1*z[5]^2*z[10]*z[12] +
(-16*f0*f4*f8 - 4*f1*f3*f8)*z[5]*z[6]*z[9]^2 - 4*f1*f7*z[5]*z[6]*z[9]*z[12] +
8*f0*f8*z[5]*z[6]*z[9]*z[13] + 8*f1*f8*z[5]*z[6]*z[9]*z[14] +
8*f2*f8*z[5]*z[6]*z[9]*z[15] + 4*f0*z[5]*z[6]*z[10]^2 + 2*f1*z[5]*z[6]*z[10]*z[11]
- 4*f2*z[5]*z[6]*z[10]*z[12] + 2*z[5]*z[6]*z[12]*z[16] - 4*f8*z[5]*z[6]*z[15]^2 +
8*f0*f5*f8*z[5]*z[7]*z[9]^2 + (-8*f0*f8 - 2*f1*f7)*z[5]*z[7]*z[9]*z[11] +
4*f2*f7*z[5]*z[7]*z[9]*z[12] + 4*f1*f8*z[5]*z[7]*z[9]*z[13] -
8*f2*f8*z[5]*z[7]*z[9]*z[14] + 2*f3*z[5]*z[7]*z[10]*z[12] -
2*z[5]*z[7]*z[11]*z[16] - 2*f7*z[5]*z[7]*z[12]*z[15] + 4*f8*z[5]*z[7]*z[14]*z[15]
- 4*f0*f7*z[5]*z[8]*z[9]^2 - 2*f3*z[5]*z[8]*z[9]*z[12] + 2*z[5]*z[8]*z[11]*z[15] +
(8*f0*f5*f8 + 8*f1*f4*f8)*z[6]^2*z[9]^2 - 4*f0*f7*z[6]^2*z[9]*z[10] +
2*f1*f7*z[6]^2*z[9]*z[11] - 8*f1*f8*z[6]^2*z[9]*z[13] - 4*f3*f8*z[6]^2*z[9]*z[15]
- 2*f1*z[6]^2*z[10]^2 + 2*f3*z[6]^2*z[10]*z[12] - 2*f5*z[6]^2*z[12]^2 +
2*f7*z[6]^2*z[12]*z[15] + (-16*f0*f6*f8 + 4*f0*f7^2 - 8*f1*f5*f8)*z[6]*z[7]*z[9]^2
+ (8*f0*f8 + 2*f1*f7)*z[6]*z[7]*z[9]*z[10] + 4*f1*f8*z[6]*z[7]*z[9]*z[11] -
2*f3*f7*z[6]*z[7]*z[9]*z[12] + 4*f3*f8*z[6]*z[7]*z[9]*z[14] -
4*f4*z[6]*z[7]*z[10]*z[12] + 2*z[6]*z[7]*z[10]*z[16] + 2*f5*z[6]*z[7]*z[11]*z[12]
- 2*f7*z[6]*z[7]*z[11]*z[15] + 4*f6*z[6]*z[7]*z[12]^2 - 2*f7*z[6]*z[7]*z[12]*z[14]
- 4*f8*z[6]*z[7]*z[12]*z[15] + 4*f8*z[6]*z[7]*z[13]*z[15] + (8*f0*f8 +
2*f1*f7)*z[6]*z[8]*z[9]^2 + 4*f4*z[6]*z[8]*z[9]*z[12] - 2*z[6]*z[8]*z[9]*z[16] -
2*z[6]*z[8]*z[12]^2 - 2*z[6]*z[8]*z[12]*z[13] + (8*f1*f6*f8 -
2*f1*f7^2)*z[7]^2*z[9]^2 - 4*f1*f8*z[7]^2*z[9]*z[10] + 2*f5*z[7]^2*z[10]*z[12] -
4*f6*z[7]^2*z[11]*z[12] + 2*f7*z[7]^2*z[11]*z[14] - 2*f7*z[7]^2*z[12]^2 +
2*f7*z[7]^2*z[12]*z[13] + 4*f8*z[7]^2*z[12]*z[14] - 4*f8*z[7]^2*z[13]*z[14] -
4*f1*f8*z[7]*z[8]*z[9]^2 - 2*f5*z[7]*z[8]*z[9]*z[12] - 2*z[7]*z[8]*z[10]*z[14] +
4*z[7]*z[8]*z[11]*z[12] + 2*z[8]^2*z[9]*z[14],

// Bmat[6,2]
  (-128*f0^2*f3*f6*f8^2 + 32*f0^2*f3*f7^2*f8 + 128*f0^2*f4*f6*f7*f8 -
32*f0^2*f4*f7^3 - 32*f0^2*f5^2*f7*f8 + 128*f0*f1*f2*f6*f8^2 - 32*f0*f1*f2*f7^2*f8
+ 32*f0*f1*f3*f5*f8^2 - 64*f0*f1*f3*f6*f7*f8 + 16*f0*f1*f3*f7^3 -
128*f0*f2^2*f5*f8^2 + 128*f0*f2^2*f6*f7*f8 - 32*f0*f2^2*f7^3 +
128*f0*f2*f3*f4*f8^2 - 32*f0*f2*f3*f5*f7*f8 + 64*f0*f2*f4*f5*f6*f8 -
16*f0*f2*f4*f5*f7^2 - 16*f0*f2*f5^3*f8 - 32*f0*f3^3*f8^2 - 16*f0*f3^2*f5*f6*f8 +
4*f0*f3^2*f5*f7^2 - 32*f1^3*f6*f8^2 + 8*f1^3*f7^2*f8 + 32*f1^2*f2*f5*f8^2 -
32*f1^2*f2*f6*f7*f8 + 8*f1^2*f2*f7^3 - 32*f1^2*f3*f4*f8^2 + 8*f1^2*f3*f5*f7*f8 -
16*f1^2*f4*f5*f6*f8 + 4*f1^2*f4*f5*f7^2 + 4*f1^2*f5^3*f8)*z[1]^2*z[9]^2 +
(64*f0^2*f3*f8^2 - 64*f0^2*f4*f7*f8 + 16*f0^2*f5*f7^2 - 64*f0*f1*f2*f8^2 +
24*f0*f1*f3*f7*f8 - 32*f0*f2^2*f7*f8 - 32*f0*f2*f3*f6*f8 + 16*f0*f2*f3*f7^2 -
32*f0*f2*f4*f5*f8 + 8*f0*f2*f5^2*f7 + 16*f0*f3^2*f5*f8 + 16*f1^3*f8^2 +
8*f1^2*f2*f7*f8 + 8*f1^2*f3*f6*f8 - 4*f1^2*f3*f7^2 + 8*f1^2*f4*f5*f8 -
2*f1^2*f5^2*f7)*z[1]^2*z[9]*z[10] + (16*f0^2*f5*f7*f8 - 16*f0*f1*f3*f8^2 +
16*f0*f1*f4*f7*f8 - 8*f0*f1*f5*f7^2 + 64*f0*f2^2*f8^2 - 64*f0*f2*f4*f6*f8 +
32*f0*f2*f4*f7^2 + 48*f0*f2*f5^2*f8 - 16*f0*f2*f5*f6*f7 + 32*f0*f3^2*f6*f8 -
16*f0*f3^2*f7^2 - 16*f0*f3*f4*f5*f8 - 16*f1^2*f2*f8^2 - 4*f1^2*f3*f7*f8 +
16*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 - 12*f1^2*f5^2*f8 +
4*f1^2*f5*f6*f7)*z[1]^2*z[9]*z[11] + (-32*f0^2*f5*f8^2 + 32*f0*f1*f4*f8^2 -
8*f0*f1*f5*f7*f8 - 32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 - 16*f0*f2*f5*f7^2 -
16*f0*f3^2*f7*f8 - 16*f0*f3*f5^2*f8 + 8*f0*f3*f5*f6*f7 - 16*f1^2*f4*f7*f8 +
8*f1^2*f5*f7^2 + 8*f1*f2*f3*f7*f8 - 8*f1*f3^2*f6*f8 + 4*f1*f3^2*f7^2 +
8*f1*f3*f4*f5*f8)*z[1]^2*z[9]*z[12] + (32*f0^2*f5*f8^2 - 64*f0^2*f6*f7*f8 +
16*f0^2*f7^3 - 32*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 - 32*f0*f2*f3*f8^2 -
32*f0*f2*f4*f7*f8 - 32*f0*f2*f5*f6*f8 + 16*f0*f2*f5*f7^2 + 16*f0*f3^2*f7*f8 +
8*f0*f3*f5^2*f8 + 16*f1^2*f3*f8^2 + 8*f1^2*f4*f7*f8 + 8*f1^2*f5*f6*f8 -
4*f1^2*f5*f7^2)*z[1]^2*z[9]*z[13] + (64*f0^2*f6*f8^2 - 16*f0^2*f7^2*f8 -
32*f0*f1*f5*f8^2 + 32*f0*f1*f6*f7*f8 - 8*f0*f1*f7^3 - 64*f0*f2*f4*f8^2 +
32*f0*f2*f5*f7*f8 + 48*f0*f3^2*f8^2 + 16*f0*f3*f5*f6*f8 - 8*f0*f3*f5*f7^2 +
32*f1^2*f4*f8^2 - 16*f1^2*f5*f7*f8 - 16*f1*f2*f3*f8^2 - 4*f1*f3^2*f7*f8 -
4*f1*f3*f5^2*f8)*z[1]^2*z[9]*z[14] + (-32*f0*f1*f6*f8^2 + 8*f0*f1*f7^2*f8 +
96*f0*f2*f5*f8^2 - 128*f0*f2*f6*f7*f8 + 32*f0*f2*f7^3 - 64*f0*f3*f4*f8^2 +
24*f0*f3*f5*f7*f8 - 32*f0*f4*f5*f6*f8 + 8*f0*f4*f5*f7^2 + 8*f0*f5^3*f8 -
16*f1^2*f5*f8^2 + 32*f1^2*f6*f7*f8 - 8*f1^2*f7^3 + 16*f1*f3^2*f8^2 +
8*f1*f3*f5*f6*f8 - 2*f1*f3*f5*f7^2)*z[1]^2*z[9]*z[15] + (16*f0*f2*f7*f8 +
16*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 8*f0*f4*f5*f8 - 2*f0*f5^2*f7 - 4*f1^2*f7*f8 -
6*f1*f3*f5*f8)*z[1]^2*z[9]*z[16] - 16*f0^2*f5*f8*z[1]^2*z[10]^2 + (32*f0^2*f6*f8 -
16*f0^2*f7^2 + 8*f0*f1*f5*f8)*z[1]^2*z[10]*z[11] + (16*f0^2*f7*f8 - 16*f0*f1*f6*f8
+ 8*f0*f1*f7^2 + 16*f0*f2*f5*f8 - 8*f1^2*f5*f8)*z[1]^2*z[10]*z[12] +
(16*f0^2*f7*f8 + 16*f0*f2*f5*f8 - 4*f0*f3*f5*f7 - 4*f1^2*f5*f8)*z[1]^2*z[10]*z[13]
+ (-32*f0^2*f8^2 - 8*f0*f1*f7*f8 - 16*f0*f3*f5*f8 +
2*f1*f3*f5*f7)*z[1]^2*z[10]*z[14] + (16*f0*f1*f8^2 + 16*f0*f2*f7*f8 +
16*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 8*f0*f4*f5*f8 - 2*f0*f5^2*f7 - 4*f1^2*f7*f8 -
2*f1*f3*f5*f8)*z[1]^2*z[10]*z[15] + (-16*f0*f1*f6*f8 + 8*f0*f1*f7^2 -
16*f0*f2*f5*f8 + 4*f0*f3*f5*f7 + 4*f1^2*f5*f8)*z[1]^2*z[11]^2 + (-8*f0*f1*f7*f8 +
8*f0*f3*f5*f8 - 8*f0*f4*f5*f7 + 16*f1^2*f6*f8 - 8*f1^2*f7^2 -
2*f1*f3*f5*f7)*z[1]^2*z[11]*z[12] - 8*f0*f1*f7*f8*z[1]^2*z[11]*z[13] +
(16*f0*f1*f8^2 + 8*f0*f4*f5*f8 + 2*f0*f5^2*f7 + 4*f1^2*f7*f8 +
2*f1*f3*f5*f8)*z[1]^2*z[11]*z[14] + (-32*f0*f2*f8^2 - 8*f0*f5^2*f8 - 8*f1*f3*f6*f8
+ 4*f1*f3*f7^2)*z[1]^2*z[11]*z[15] + 4*f0*f5*f7*z[1]^2*z[11]*z[16] +
(-16*f0*f2*f7*f8 + 16*f0*f3*f6*f8 - 8*f0*f3*f7^2 - 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 +
8*f1^2*f7*f8 - 16*f1*f2*f6*f8 + 8*f1*f2*f7^2 + 4*f1*f3*f5*f8 +
4*f1*f4*f5*f7)*z[1]^2*z[12]^2 + (8*f0*f4*f5*f8 + 2*f0*f5^2*f7 + 4*f1^2*f7*f8 -
2*f1*f3*f5*f8)*z[1]^2*z[12]*z[13] + (32*f0*f2*f8^2 + 16*f0*f3*f7*f8 -
32*f0*f4*f6*f8 + 16*f0*f4*f7^2 + 16*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 16*f1^2*f8^2 -
8*f1*f2*f7*f8 + 8*f1*f3*f6*f8 - 4*f1*f3*f7^2 - 8*f1*f4*f5*f8 -
2*f1*f5^2*f7)*z[1]^2*z[12]*z[14] + (-16*f0*f3*f8^2 + 16*f1*f2*f8^2 - 4*f1*f3*f7*f8
+ 16*f1*f4*f6*f8 - 8*f1*f4*f7^2 - 4*f1*f5^2*f8 + 4*f1*f5*f6*f7)*z[1]^2*z[12]*z[15]
+ (8*f0*f5*f8 - 4*f1*f5*f7)*z[1]^2*z[12]*z[16] - 8*f0*f5^2*f8*z[1]^2*z[13]*z[14] +
(16*f0*f3*f8^2 + 16*f0*f5*f6*f8 - 4*f0*f5*f7^2 - 4*f1*f3*f7*f8)*z[1]^2*z[13]*z[15]
- 8*f0*f5*f8*z[1]^2*z[13]*z[16] + (-16*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 4*f0*f5*f7^2
+ 4*f1*f3*f7*f8 + 4*f1*f5^2*f8)*z[1]^2*z[14]^2 + (32*f0*f4*f8^2 - 8*f0*f5*f7*f8 +
8*f1*f4*f7*f8 - 8*f1*f5*f6*f8)*z[1]^2*z[14]*z[15] + 4*f1*f5*f8*z[1]^2*z[14]*z[16]
+ (-16*f1*f4*f8^2 + 4*f1*f5*f7*f8)*z[1]^2*z[15]^2 + (64*f0^2*f3*f8^2 -
64*f0^2*f4*f7*f8 + 16*f0^2*f5*f7^2 - 64*f0*f1*f2*f8^2 + 24*f0*f1*f3*f7*f8 -
32*f0*f2^2*f7*f8 - 32*f0*f2*f3*f6*f8 + 16*f0*f2*f3*f7^2 - 32*f0*f2*f4*f5*f8 +
8*f0*f2*f5^2*f7 + 16*f0*f3^2*f5*f8 + 16*f1^3*f8^2 + 8*f1^2*f2*f7*f8 +
8*f1^2*f3*f6*f8 - 4*f1^2*f3*f7^2 + 8*f1^2*f4*f5*f8 -
2*f1^2*f5^2*f7)*z[1]*z[2]*z[9]^2 + (32*f0^2*f5*f8 - 32*f0^2*f6*f7 + 32*f0*f2*f3*f8
- 16*f0*f2*f5*f6 - 8*f0*f3^2*f7 - 8*f1^2*f3*f8 +
4*f1^2*f5*f6)*z[1]*z[2]*z[9]*z[10] + (-16*f0*f1*f5*f8 + 16*f0*f1*f6*f7 +
32*f0*f2*f4*f8 - 32*f0*f2*f5*f7 + 32*f0*f2*f6^2 - 16*f0*f3^2*f8 + 16*f0*f3*f4*f7 -
8*f1^2*f4*f8 + 8*f1^2*f5*f7 - 8*f1^2*f6^2)*z[1]*z[2]*z[9]*z[11] + (-32*f0*f2*f5*f8
+ 32*f0*f2*f6*f7 + 16*f0*f3*f4*f8 + 8*f0*f3*f5*f7 - 16*f0*f3*f6^2 + 16*f1^2*f5*f8
- 16*f1^2*f6*f7 - 8*f1*f3*f4*f7)*z[1]*z[2]*z[9]*z[12] + (32*f0^2*f7*f8 -
8*f0*f1*f7^2 + 48*f0*f2*f5*f8 - 16*f0*f2*f6*f7 - 16*f0*f3*f4*f8 - 4*f0*f3*f5*f7 -
12*f1^2*f5*f8 + 4*f1^2*f6*f7)*z[1]*z[2]*z[9]*z[13] + (-32*f0^2*f8^2 -
8*f0*f1*f7*f8 - 16*f0*f2*f7^2 - 24*f0*f3*f5*f8 + 8*f0*f3*f6*f7 + 8*f1^2*f7^2 +
8*f1*f3*f4*f8 + 2*f1*f3*f5*f7)*z[1]*z[2]*z[9]*z[14] + (16*f0*f1*f8^2 +
48*f0*f2*f7*f8 + 16*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 16*f0*f4*f5*f8 - 4*f0*f5^2*f7 -
16*f1^2*f7*f8 - 8*f1*f3*f5*f8)*z[1]*z[2]*z[9]*z[15] + (-16*f0*f3*f8 + 4*f0*f5*f6 +
4*f1*f3*f7)*z[1]*z[2]*z[9]*z[16] + (16*f0^2*f7 + 8*f0*f2*f5 -
2*f1^2*f5)*z[1]*z[2]*z[10]^2 + (-32*f0^2*f8 - 8*f0*f1*f7 - 16*f0*f2*f6 -
4*f0*f3*f5 + 4*f1^2*f6)*z[1]*z[2]*z[10]*z[11] + (8*f0*f1*f8 - 16*f0*f2*f7 +
8*f0*f3*f6 + 8*f1^2*f7 + 2*f1*f3*f5)*z[1]*z[2]*z[10]*z[12] +
8*f0*f3*f6*z[1]*z[2]*z[10]*z[13] + (8*f0*f3*f7 - 4*f1*f3*f6)*z[1]*z[2]*z[10]*z[14]
+ (-16*f0*f3*f8 + 4*f0*f5*f6)*z[1]*z[2]*z[10]*z[15] -
4*f0*f5*z[1]*z[2]*z[10]*z[16] + (16*f0*f1*f8 + 16*f0*f2*f7 -
4*f1^2*f7)*z[1]*z[2]*z[11]^2 + (16*f0*f2*f8 - 8*f0*f3*f7 + 4*f0*f5^2 -
16*f1^2*f8)*z[1]*z[2]*z[11]*z[12] + (-16*f0*f2*f8 - 8*f0*f3*f7 +
4*f1^2*f8)*z[1]*z[2]*z[11]*z[13] - 4*f0*f5*f6*z[1]*z[2]*z[11]*z[14] +
8*f1*f3*f8*z[1]*z[2]*z[11]*z[15] + (-8*f0*f3*f8 + 16*f0*f4*f7 - 8*f0*f5*f6 +
8*f1*f2*f8 - 4*f1*f3*f7 - 2*f1*f5^2)*z[1]*z[2]*z[12]^2 + (-4*f0*f5*f6 +
4*f1*f3*f7)*z[1]*z[2]*z[12]*z[13] + (-16*f0*f5*f7 + 16*f0*f6^2 +
4*f1*f5*f6)*z[1]*z[2]*z[12]*z[14] + (8*f0*f5*f8 - 8*f1*f4*f8 + 8*f1*f5*f7 -
8*f1*f6^2)*z[1]*z[2]*z[12]*z[15] + (-8*f0*f7 + 4*f1*f6)*z[1]*z[2]*z[12]*z[16] +
8*f0*f3*f8*z[1]*z[2]*z[13]^2 + (4*f0*f5*f7 - 4*f1*f3*f8)*z[1]*z[2]*z[13]*z[14] -
8*f0*f5*f8*z[1]*z[2]*z[13]*z[15] + (16*f0*f5*f8 - 8*f0*f6*f7 -
2*f1*f5*f7)*z[1]*z[2]*z[14]^2 + (-16*f0*f6*f8 + 8*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[2]*z[14]*z[15] + 8*f0*f8*z[1]*z[2]*z[14]*z[16] + (8*f1*f6*f8 -
4*f1*f7^2)*z[1]*z[2]*z[15]^2 - 4*f1*f8*z[1]*z[2]*z[15]*z[16] + (16*f0^2*f5*f7*f8 -
16*f0*f1*f3*f8^2 + 16*f0*f1*f4*f7*f8 - 8*f0*f1*f5*f7^2 + 64*f0*f2^2*f8^2 -
64*f0*f2*f4*f6*f8 + 32*f0*f2*f4*f7^2 + 48*f0*f2*f5^2*f8 - 16*f0*f2*f5*f6*f7 +
32*f0*f3^2*f6*f8 - 16*f0*f3^2*f7^2 - 16*f0*f3*f4*f5*f8 - 16*f1^2*f2*f8^2 -
4*f1^2*f3*f7*f8 + 16*f1^2*f4*f6*f8 - 8*f1^2*f4*f7^2 - 12*f1^2*f5^2*f8 +
4*f1^2*f5*f6*f7)*z[1]*z[3]*z[9]^2 + (-16*f0*f1*f5*f8 + 16*f0*f1*f6*f7 +
32*f0*f2*f4*f8 - 32*f0*f2*f5*f7 + 32*f0*f2*f6^2 - 16*f0*f3^2*f8 + 16*f0*f3*f4*f7 -
8*f1^2*f4*f8 + 8*f1^2*f5*f7 - 8*f1^2*f6^2)*z[1]*z[3]*z[9]*z[10] + (-48*f0*f2*f5*f8
+ 32*f0*f3*f5*f7 - 32*f0*f3*f6^2 - 32*f0*f4^2*f7 + 16*f0*f4*f5*f6 - 4*f0*f5^3 +
20*f1^2*f5*f8 - 8*f1^2*f6*f7)*z[1]*z[3]*z[9]*z[11] + (32*f0^2*f8^2 +
48*f0*f3*f5*f8 - 32*f0*f3*f6*f7 - 32*f0*f4^2*f8 + 32*f0*f4*f6^2 - 8*f0*f5^2*f6 -
16*f1*f2*f5*f8 + 16*f1*f2*f6*f7 + 8*f1*f3*f4*f8 - 12*f1*f3*f5*f7 + 8*f1*f3*f6^2 +
16*f1*f4^2*f7 - 8*f1*f4*f5*f6 + 2*f1*f5^3)*z[1]*z[3]*z[9]*z[12] + (-32*f0^2*f8^2 -
8*f0*f1*f7*f8 + 32*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 32*f0*f3*f5*f8 + 16*f0*f3*f6*f7 +
32*f0*f4^2*f8 - 8*f1^2*f6*f8 + 8*f1^2*f7^2)*z[1]*z[3]*z[9]*z[13] + (16*f0*f1*f8^2
- 16*f0*f3*f6*f8 + 24*f0*f3*f7^2 + 16*f0*f4*f5*f8 - 16*f0*f4*f6*f7 - 8*f1*f2*f7^2
+ 12*f1*f3*f5*f8 - 4*f1*f3*f6*f7 - 16*f1*f4^2*f8)*z[1]*z[3]*z[9]*z[14] +
(-64*f0*f2*f8^2 - 16*f0*f3*f7*f8 + 32*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 32*f0*f5^2*f8
+ 16*f0*f5*f6*f7 + 16*f1^2*f8^2 + 8*f1*f2*f7*f8 - 16*f1*f3*f6*f8 + 8*f1*f3*f7^2 +
8*f1*f4*f5*f8)*z[1]*z[3]*z[9]*z[15] + (12*f0*f5*f7 - 16*f0*f6^2 + 4*f1*f3*f8 -
8*f1*f4*f7 + 2*f1*f5*f6)*z[1]*z[3]*z[9]*z[16] + (-8*f0*f1*f7 - 16*f0*f2*f6 +
4*f1^2*f6)*z[1]*z[3]*z[10]^2 + (8*f0*f1*f8 + 16*f0*f2*f7 +
16*f0*f3*f6)*z[1]*z[3]*z[10]*z[11] + (8*f0*f3*f7 - 16*f0*f4*f6 - 8*f1*f2*f7 -
4*f1*f3*f6)*z[1]*z[3]*z[10]*z[12] + (-16*f0*f2*f8 - 16*f0*f4*f6 + 4*f0*f5^2 +
4*f1^2*f8)*z[1]*z[3]*z[10]*z[13] + (8*f0*f3*f8 - 16*f0*f4*f7 + 8*f0*f5*f6 +
8*f1*f4*f6 - 2*f1*f5^2)*z[1]*z[3]*z[10]*z[14] + (12*f0*f5*f7 - 16*f0*f6^2 +
4*f1*f3*f8 - 2*f1*f5*f6)*z[1]*z[3]*z[10]*z[15] + 16*f0*f6*z[1]*z[3]*z[10]*z[16] +
(-16*f0*f3*f7 - 4*f1^2*f8)*z[1]*z[3]*z[11]^2 + (-16*f0*f3*f8 + 16*f0*f4*f7 +
8*f1*f2*f8 + 8*f1*f3*f7)*z[1]*z[3]*z[11]*z[12] + (16*f0*f3*f8 +
16*f0*f4*f7)*z[1]*z[3]*z[11]*z[13] + (-4*f0*f5*f7 - 4*f1*f3*f8 -
2*f1*f5*f6)*z[1]*z[3]*z[11]*z[14] + (16*f0*f5*f8 - 8*f1*f4*f8 - 4*f1*f5*f7 +
8*f1*f6^2)*z[1]*z[3]*z[11]*z[15] + (-8*f0*f7 - 4*f1*f6)*z[1]*z[3]*z[11]*z[16] +
(16*f0*f4*f8 - 8*f0*f5*f7 - 4*f1*f3*f8 - 8*f1*f4*f7 +
4*f1*f5*f6)*z[1]*z[3]*z[12]^2 + (-4*f0*f5*f7 - 4*f1*f3*f8 - 8*f1*f4*f7 +
2*f1*f5*f6)*z[1]*z[3]*z[12]*z[13] + (-24*f0*f5*f8 + 16*f0*f6*f7 + 8*f1*f4*f8 +
8*f1*f5*f7 - 8*f1*f6^2)*z[1]*z[3]*z[12]*z[14] + (4*f1*f5*f8 -
8*f1*f6*f7)*z[1]*z[3]*z[12]*z[15] + (-8*f0*f8 + 8*f1*f7)*z[1]*z[3]*z[12]*z[16] -
16*f0*f4*f8*z[1]*z[3]*z[13]^2 + (8*f0*f5*f8 + 8*f1*f4*f8)*z[1]*z[3]*z[13]*z[14] +
(-16*f0*f6*f8 + 8*f0*f7^2 + 4*f1*f5*f8 - 4*f1*f6*f7)*z[1]*z[3]*z[13]*z[15] +
8*f0*f8*z[1]*z[3]*z[13]*z[16] + (-8*f0*f7^2 - 8*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[3]*z[14]^2 + (8*f0*f7*f8 + 8*f1*f6*f8)*z[1]*z[3]*z[14]*z[15] -
4*f1*f8*z[1]*z[3]*z[14]*z[16] - 4*f1*f7*f8*z[1]*z[3]*z[15]^2 + (-32*f0^2*f5*f8^2 +
32*f0*f1*f4*f8^2 - 8*f0*f1*f5*f7*f8 - 32*f0*f2*f3*f8^2 + 32*f0*f2*f4*f7*f8 -
16*f0*f2*f5*f7^2 - 16*f0*f3^2*f7*f8 - 16*f0*f3*f5^2*f8 + 8*f0*f3*f5*f6*f7 -
16*f1^2*f4*f7*f8 + 8*f1^2*f5*f7^2 + 8*f1*f2*f3*f7*f8 - 8*f1*f3^2*f6*f8 +
4*f1*f3^2*f7^2 + 8*f1*f3*f4*f5*f8)*z[1]*z[4]*z[9]^2 + (-32*f0*f2*f5*f8 +
32*f0*f2*f6*f7 + 16*f0*f3*f4*f8 + 8*f0*f3*f5*f7 - 16*f0*f3*f6^2 + 16*f1^2*f5*f8 -
16*f1^2*f6*f7 - 8*f1*f3*f4*f7)*z[1]*z[4]*z[9]*z[10] + (32*f0^2*f8^2 +
48*f0*f3*f5*f8 - 32*f0*f3*f6*f7 - 32*f0*f4^2*f8 + 32*f0*f4*f6^2 - 8*f0*f5^2*f6 -
16*f1*f2*f5*f8 + 16*f1*f2*f6*f7 + 8*f1*f3*f4*f8 - 12*f1*f3*f5*f7 + 8*f1*f3*f6^2 +
16*f1*f4^2*f7 - 8*f1*f4*f5*f6 + 2*f1*f5^3)*z[1]*z[4]*z[9]*z[11] + (-32*f0*f1*f8^2
- 16*f0*f4*f5*f8 - 32*f1*f3*f5*f8 + 32*f1*f3*f6*f7 + 32*f1*f4^2*f8 - 32*f1*f4*f6^2
+ 8*f1*f5^2*f6 + 32*f2^2*f5*f8 - 32*f2^2*f6*f7 - 32*f2*f3*f4*f8 + 16*f2*f3*f5*f7 -
32*f2*f4^2*f7 + 16*f2*f4*f5*f6 - 4*f2*f5^3 + 8*f3^3*f8 + 8*f3^2*f4*f7 -
4*f3^2*f5*f6)*z[1]*z[4]*z[9]*z[12] + (-16*f0*f2*f7*f8 + 16*f0*f3*f7^2 +
16*f0*f4*f5*f8 - 16*f0*f4*f6*f7 + 8*f1^2*f7*f8 - 8*f1*f2*f7^2 + 8*f1*f3*f5*f8 -
4*f1*f3*f6*f7 - 16*f1*f4^2*f8)*z[1]*z[4]*z[9]*z[13] + (8*f0*f3*f7*f8 +
8*f0*f5^2*f8 - 16*f1*f3*f7^2 - 16*f1*f4*f5*f8 + 16*f1*f4*f6*f7 + 16*f2^2*f7^2 -
8*f2*f3*f5*f8 + 32*f2*f4^2*f8 - 8*f3^2*f4*f8)*z[1]*z[4]*z[9]*z[14] +
(32*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 8*f0*f5*f7^2 + 16*f1*f3*f7*f8 + 8*f1*f5^2*f8 -
8*f1*f5*f6*f7 - 16*f2^2*f7*f8 + 16*f2*f3*f6*f8 - 8*f2*f3*f7^2 -
16*f2*f4*f5*f8)*z[1]*z[4]*z[9]*z[15] + (12*f0*f5*f8 - 8*f0*f6*f7 - 8*f1*f4*f8 -
4*f1*f5*f7 + 8*f1*f6^2 + 16*f2*f4*f7 - 4*f2*f5*f6 - 4*f3^2*f7 +
f3*f5^2)*z[1]*z[4]*z[9]*z[16] + (-16*f0*f2*f7 + 8*f0*f3*f6 +
8*f1^2*f7)*z[1]*z[4]*z[10]^2 + (16*f0*f2*f8 + 16*f0*f3*f7 - 16*f0*f4*f6 -
8*f1^2*f8 - 8*f1*f2*f7 - 4*f1*f3*f6)*z[1]*z[4]*z[10]*z[11] + (-8*f0*f3*f8 -
16*f1*f3*f7 + 16*f1*f4*f6 + 16*f2^2*f7)*z[1]*z[4]*z[10]*z[12] + (-16*f0*f4*f7 +
8*f0*f5*f6 + 4*f1*f3*f7 + 8*f1*f4*f6 - 2*f1*f5^2)*z[1]*z[4]*z[10]*z[13] +
(16*f1*f4*f7 - 8*f1*f5*f6 - 8*f2*f3*f7 - 16*f2*f4*f6 + 4*f2*f5^2 +
4*f3^2*f6)*z[1]*z[4]*z[10]*z[14] + (4*f0*f5*f8 - 8*f0*f6*f7 - 8*f1*f4*f8 -
4*f1*f5*f7 + 8*f1*f6^2 + 4*f2*f5*f6 + 4*f3^2*f7 - f3*f5^2)*z[1]*z[4]*z[10]*z[15] +
(8*f0*f7 - 8*f1*f6)*z[1]*z[4]*z[10]*z[16] + (-16*f0*f3*f8 + 8*f0*f5*f6 +
8*f1*f2*f8 + 4*f1*f3*f7)*z[1]*z[4]*z[11]^2 + (16*f0*f4*f8 - 8*f0*f5*f7 +
16*f1*f3*f8 - 8*f1*f5*f6 - 16*f2^2*f8 - 8*f2*f3*f7)*z[1]*z[4]*z[11]*z[12] +
(16*f0*f4*f8 + 8*f0*f5*f7 - 16*f0*f6^2 - 8*f1*f3*f8 -
8*f1*f4*f7)*z[1]*z[4]*z[11]*z[13] + (-12*f0*f5*f8 + 8*f0*f6*f7 - 8*f1*f4*f8 -
4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 + 4*f2*f5*f6 + 4*f3^2*f7 -
f3*f5^2)*z[1]*z[4]*z[11]*z[14] + (16*f2*f4*f8 + 8*f2*f5*f7 - 16*f2*f6^2 -
8*f3^2*f8 - 8*f3*f4*f7 + 4*f3*f5*f6)*z[1]*z[4]*z[11]*z[15] + (-8*f0*f8 +
8*f2*f6)*z[1]*z[4]*z[11]*z[16] + (8*f0*f5*f8 - 16*f1*f4*f8 + 8*f1*f5*f7 +
8*f2*f3*f8 + 4*f3^2*f7)*z[1]*z[4]*z[12]^2 + (-4*f0*f5*f8 + 8*f0*f6*f7 - 8*f1*f4*f8
- 4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 + 16*f2*f4*f7 - 4*f2*f5*f6 - 4*f3^2*f7 +
f3*f5^2)*z[1]*z[4]*z[12]*z[13] + (16*f1*f5*f8 - 16*f1*f6*f7 - 8*f3^2*f8 -
8*f3*f4*f7)*z[1]*z[4]*z[12]*z[14] + (-16*f2*f5*f8 + 16*f2*f6*f7 + 8*f3*f4*f8 -
12*f3*f5*f7 + 8*f3*f6^2 + 16*f4^2*f7 - 8*f4*f5*f6 + 2*f5^3)*z[1]*z[4]*z[12]*z[15]
+ (8*f1*f8 - 8*f2*f7 - 4*f3*f6)*z[1]*z[4]*z[12]*z[16] + (-8*f0*f5*f8 + 8*f0*f6*f7
+ 8*f1*f4*f8)*z[1]*z[4]*z[13]^2 + (-8*f0*f7^2 + 8*f1*f5*f8 - 8*f1*f6*f7 -
16*f2*f4*f8)*z[1]*z[4]*z[13]*z[14] + (8*f0*f7*f8 - 8*f2*f5*f8 + 8*f2*f6*f7 +
8*f3*f4*f8)*z[1]*z[4]*z[13]*z[15] - 4*f3*f6*z[1]*z[4]*z[13]*z[16] + (8*f1*f7^2 +
8*f3*f4*f8)*z[1]*z[4]*z[14]^2 + (-8*f1*f7*f8 - 8*f2*f7^2 + 8*f3*f5*f8 - 4*f3*f6*f7
- 16*f4^2*f8)*z[1]*z[4]*z[14]*z[15] + (4*f3*f7 + 8*f4*f6 -
2*f5^2)*z[1]*z[4]*z[14]*z[16] + (8*f2*f7*f8 - 8*f3*f6*f8 + 4*f3*f7^2 +
8*f4*f5*f8)*z[1]*z[4]*z[15]^2 - 8*f4*f7*z[1]*z[4]*z[15]*z[16] + (32*f0^2*f5*f8^2 -
64*f0^2*f6*f7*f8 + 16*f0^2*f7^3 - 32*f0*f1*f4*f8^2 + 16*f0*f1*f5*f7*f8 -
32*f0*f2*f3*f8^2 - 32*f0*f2*f4*f7*f8 - 32*f0*f2*f5*f6*f8 + 16*f0*f2*f5*f7^2 +
16*f0*f3^2*f7*f8 + 8*f0*f3*f5^2*f8 + 16*f1^2*f3*f8^2 + 8*f1^2*f4*f7*f8 +
8*f1^2*f5*f6*f8 - 4*f1^2*f5*f7^2)*z[1]*z[5]*z[9]^2 + (32*f0^2*f7*f8 - 8*f0*f1*f7^2
+ 48*f0*f2*f5*f8 - 16*f0*f2*f6*f7 - 16*f0*f3*f4*f8 - 4*f0*f3*f5*f7 - 12*f1^2*f5*f8
+ 4*f1^2*f6*f7)*z[1]*z[5]*z[9]*z[10] + (-32*f0^2*f8^2 - 8*f0*f1*f7*f8 +
32*f0*f2*f6*f8 - 16*f0*f2*f7^2 - 32*f0*f3*f5*f8 + 16*f0*f3*f6*f7 + 32*f0*f4^2*f8 -
8*f1^2*f6*f8 + 8*f1^2*f7^2)*z[1]*z[5]*z[9]*z[11] + (-16*f0*f2*f7*f8 +
16*f0*f3*f7^2 + 16*f0*f4*f5*f8 - 16*f0*f4*f6*f7 + 8*f1^2*f7*f8 - 8*f1*f2*f7^2 +
8*f1*f3*f5*f8 - 4*f1*f3*f6*f7 - 16*f1*f4^2*f8)*z[1]*z[5]*z[9]*z[12] +
(32*f0*f1*f8^2 + 32*f0*f2*f7*f8 - 8*f0*f3*f7^2 - 16*f0*f4*f5*f8 -
16*f1^2*f7*f8)*z[1]*z[5]*z[9]*z[13] + (32*f0*f2*f8^2 - 40*f0*f3*f7*f8 +
8*f0*f4*f7^2 - 16*f1^2*f8^2 + 16*f1*f2*f7*f8 + 2*f1*f3*f7^2 +
8*f1*f4*f5*f8)*z[1]*z[5]*z[9]*z[14] + (32*f0*f3*f8^2 + 16*f0*f4*f7*f8 +
16*f0*f5*f6*f8 - 12*f0*f5*f7^2 - 16*f1*f2*f8^2 - 8*f1*f3*f7*f8 -
4*f1*f5^2*f8)*z[1]*z[5]*z[9]*z[15] + (-20*f0*f5*f8 + 8*f0*f6*f7 + 8*f1*f4*f8 +
f1*f5*f7)*z[1]*z[5]*z[9]*z[16] + (8*f0*f1*f8 + 8*f0*f2*f7 -
2*f1^2*f7)*z[1]*z[5]*z[10]^2 + (-16*f0*f2*f8 - 8*f0*f3*f7)*z[1]*z[5]*z[10]*z[11] +
(-8*f0*f3*f8 + 8*f0*f4*f7 + 8*f1*f2*f8 + 2*f1*f3*f7)*z[1]*z[5]*z[10]*z[12] +
8*f0*f4*f7*z[1]*z[5]*z[10]*z[13] + (16*f0*f4*f8 -
4*f1*f4*f7)*z[1]*z[5]*z[10]*z[14] + (-20*f0*f5*f8 + 8*f0*f6*f7 +
f1*f5*f7)*z[1]*z[5]*z[10]*z[15] - 8*f0*f7*z[1]*z[5]*z[10]*z[16] +
16*f0*f3*f8*z[1]*z[5]*z[11]^2 + (-16*f0*f4*f8 + 4*f0*f5*f7 -
8*f1*f3*f8)*z[1]*z[5]*z[11]*z[12] + (-16*f0*f4*f8 -
4*f0*f5*f7)*z[1]*z[5]*z[11]*z[13] + (-4*f0*f5*f8 + f1*f5*f7)*z[1]*z[5]*z[11]*z[14]
+ (8*f1*f5*f8 - 4*f1*f6*f7)*z[1]*z[5]*z[11]*z[15] + (8*f0*f8 +
2*f1*f7)*z[1]*z[5]*z[11]*z[16] + (8*f0*f5*f8 + 8*f1*f4*f8 -
4*f1*f5*f7)*z[1]*z[5]*z[12]^2 + (-4*f0*f5*f8 + 8*f1*f4*f8 +
f1*f5*f7)*z[1]*z[5]*z[12]*z[13] + (16*f0*f6*f8 - 16*f0*f7^2 - 4*f1*f5*f8 +
4*f1*f6*f7)*z[1]*z[5]*z[12]*z[14] + (-8*f1*f6*f8 +
8*f1*f7^2)*z[1]*z[5]*z[12]*z[15] - 8*f1*f8*z[1]*z[5]*z[12]*z[16] +
8*f0*f5*f8*z[1]*z[5]*z[13]^2 - 4*f1*f5*f8*z[1]*z[5]*z[13]*z[14] + (-8*f0*f7*f8 +
2*f1*f7^2)*z[1]*z[5]*z[13]*z[15] + (24*f0*f7*f8 - 2*f1*f7^2)*z[1]*z[5]*z[14]^2 +
(-32*f0*f8^2 - 8*f1*f7*f8)*z[1]*z[5]*z[14]*z[15] + 16*f1*f8^2*z[1]*z[5]*z[15]^2 +
(64*f0^2*f6*f8^2 - 16*f0^2*f7^2*f8 - 32*f0*f1*f5*f8^2 + 32*f0*f1*f6*f7*f8 -
8*f0*f1*f7^3 - 64*f0*f2*f4*f8^2 + 32*f0*f2*f5*f7*f8 + 48*f0*f3^2*f8^2 +
16*f0*f3*f5*f6*f8 - 8*f0*f3*f5*f7^2 + 32*f1^2*f4*f8^2 - 16*f1^2*f5*f7*f8 -
16*f1*f2*f3*f8^2 - 4*f1*f3^2*f7*f8 - 4*f1*f3*f5^2*f8)*z[1]*z[6]*z[9]^2 +
(-32*f0^2*f8^2 - 8*f0*f1*f7*f8 - 16*f0*f2*f7^2 - 24*f0*f3*f5*f8 + 8*f0*f3*f6*f7 +
8*f1^2*f7^2 + 8*f1*f3*f4*f8 + 2*f1*f3*f5*f7)*z[1]*z[6]*z[9]*z[10] + (16*f0*f1*f8^2
- 16*f0*f3*f6*f8 + 24*f0*f3*f7^2 + 16*f0*f4*f5*f8 - 16*f0*f4*f6*f7 - 8*f1*f2*f7^2
+ 12*f1*f3*f5*f8 - 4*f1*f3*f6*f7 - 16*f1*f4^2*f8)*z[1]*z[6]*z[9]*z[11] +
(8*f0*f3*f7*f8 + 8*f0*f5^2*f8 - 16*f1*f3*f7^2 - 16*f1*f4*f5*f8 + 16*f1*f4*f6*f7 +
16*f2^2*f7^2 - 8*f2*f3*f5*f8 + 32*f2*f4^2*f8 - 8*f3^2*f4*f8)*z[1]*z[6]*z[9]*z[12]
+ (32*f0*f2*f8^2 - 40*f0*f3*f7*f8 + 8*f0*f4*f7^2 - 16*f1^2*f8^2 + 16*f1*f2*f7*f8 +
2*f1*f3*f7^2 + 8*f1*f4*f5*f8)*z[1]*z[6]*z[9]*z[13] + (-32*f0*f3*f8^2 -
16*f0*f5*f6*f8 + 4*f0*f5*f7^2 + 32*f1*f3*f7*f8 - 8*f1*f4*f7^2 - 32*f2^2*f7*f8 -
16*f2*f4*f5*f8 + 4*f3^2*f5*f8)*z[1]*z[6]*z[9]*z[14] + (32*f0*f4*f8^2 -
16*f0*f5*f7*f8 - 32*f1*f3*f8^2 + 4*f1*f5*f7^2 + 32*f2^2*f8^2 + 8*f2*f3*f7*f8 +
8*f2*f5^2*f8)*z[1]*z[6]*z[9]*z[15] + (4*f0*f7^2 + 8*f1*f5*f8 - 4*f1*f6*f7 -
16*f2*f4*f8 - 2*f2*f5*f7 + 4*f3^2*f8)*z[1]*z[6]*z[9]*z[16] + (16*f0*f2*f8 -
4*f0*f3*f7 - 8*f1^2*f8)*z[1]*z[6]*z[10]^2 + (-16*f0*f3*f8 + 8*f0*f4*f7 +
8*f1*f2*f8 + 2*f1*f3*f7)*z[1]*z[6]*z[10]*z[11] + (-4*f0*f5*f7 + 16*f1*f3*f8 -
8*f1*f4*f7 - 16*f2^2*f8)*z[1]*z[6]*z[10]*z[12] + (16*f0*f4*f8 - 4*f1*f3*f8 -
4*f1*f4*f7)*z[1]*z[6]*z[10]*z[13] + (8*f0*f5*f8 - 16*f1*f4*f8 + 8*f2*f3*f8 +
8*f2*f4*f7 - 2*f3^2*f7)*z[1]*z[6]*z[10]*z[14] + (4*f0*f7^2 + 8*f1*f5*f8 -
4*f1*f6*f7 - 2*f2*f5*f7 - 4*f3^2*f8)*z[1]*z[6]*z[10]*z[15] + (-8*f0*f8 +
4*f1*f7)*z[1]*z[6]*z[10]*z[16] + (-4*f0*f5*f7 - 4*f1*f3*f8)*z[1]*z[6]*z[11]^2 +
(8*f0*f5*f8 + 4*f1*f5*f7 + 8*f2*f3*f8)*z[1]*z[6]*z[11]*z[12] + (-16*f0*f5*f8 +
8*f0*f6*f7 + 8*f1*f4*f8 + 2*f1*f5*f7)*z[1]*z[6]*z[11]*z[13] + (-4*f0*f7^2 +
8*f1*f5*f8 - 4*f1*f6*f7 - 2*f2*f5*f7 - 4*f3^2*f8)*z[1]*z[6]*z[11]*z[14] +
(-16*f2*f5*f8 + 8*f2*f6*f7 + 8*f3*f4*f8)*z[1]*z[6]*z[11]*z[15] -
4*f2*f7*z[1]*z[6]*z[11]*z[16] + (-16*f0*f6*f8 + 8*f0*f7^2 - 8*f1*f5*f8 -
4*f3^2*f8)*z[1]*z[6]*z[12]^2 + (-4*f0*f7^2 + 8*f1*f5*f8 - 4*f1*f6*f7 - 16*f2*f4*f8
- 2*f2*f5*f7 + 4*f3^2*f8)*z[1]*z[6]*z[12]*z[13] + (-8*f0*f7*f8 + 8*f1*f7^2 +
8*f3*f4*f8 + 2*f3*f5*f7)*z[1]*z[6]*z[12]*z[14] + (16*f0*f8^2 - 8*f2*f7^2 +
12*f3*f5*f8 - 4*f3*f6*f7 - 16*f4^2*f8)*z[1]*z[6]*z[12]*z[15] + (8*f2*f8 +
2*f3*f7)*z[1]*z[6]*z[12]*z[16] + (-4*f0*f7^2 - 4*f1*f5*f8)*z[1]*z[6]*z[13]^2 +
(16*f0*f7*f8 + 4*f1*f7^2 + 8*f2*f5*f8)*z[1]*z[6]*z[13]*z[14] + (-16*f0*f8^2 -
4*f2*f7^2 - 4*f3*f5*f8)*z[1]*z[6]*z[13]*z[15] + 2*f3*f7*z[1]*z[6]*z[13]*z[16] +
(-16*f1*f7*f8 - 4*f3*f5*f8)*z[1]*z[6]*z[14]^2 + (16*f1*f8^2 + 16*f2*f7*f8 +
2*f3*f7^2 + 8*f4*f5*f8)*z[1]*z[6]*z[14]*z[15] + (-4*f3*f8 -
4*f4*f7)*z[1]*z[6]*z[14]*z[16] + (-16*f2*f8^2 - 4*f3*f7*f8 -
4*f5^2*f8)*z[1]*z[6]*z[15]^2 + (8*f4*f8 + 2*f5*f7)*z[1]*z[6]*z[15]*z[16] +
(-32*f0*f1*f6*f8^2 + 8*f0*f1*f7^2*f8 + 96*f0*f2*f5*f8^2 - 128*f0*f2*f6*f7*f8 +
32*f0*f2*f7^3 - 64*f0*f3*f4*f8^2 + 24*f0*f3*f5*f7*f8 - 32*f0*f4*f5*f6*f8 +
8*f0*f4*f5*f7^2 + 8*f0*f5^3*f8 - 16*f1^2*f5*f8^2 + 32*f1^2*f6*f7*f8 - 8*f1^2*f7^3
+ 16*f1*f3^2*f8^2 + 8*f1*f3*f5*f6*f8 - 2*f1*f3*f5*f7^2)*z[1]*z[7]*z[9]^2 +
(16*f0*f1*f8^2 + 48*f0*f2*f7*f8 + 16*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 16*f0*f4*f5*f8 -
4*f0*f5^2*f7 - 16*f1^2*f7*f8 - 8*f1*f3*f5*f8)*z[1]*z[7]*z[9]*z[10] +
(-64*f0*f2*f8^2 - 16*f0*f3*f7*f8 + 32*f0*f4*f6*f8 - 16*f0*f4*f7^2 - 32*f0*f5^2*f8
+ 16*f0*f5*f6*f7 + 16*f1^2*f8^2 + 8*f1*f2*f7*f8 - 16*f1*f3*f6*f8 + 8*f1*f3*f7^2 +
8*f1*f4*f5*f8)*z[1]*z[7]*z[9]*z[11] + (32*f0*f3*f8^2 - 16*f0*f4*f7*f8 +
8*f0*f5*f7^2 + 16*f1*f3*f7*f8 + 8*f1*f5^2*f8 - 8*f1*f5*f6*f7 - 16*f2^2*f7*f8 +
16*f2*f3*f6*f8 - 8*f2*f3*f7^2 - 16*f2*f4*f5*f8)*z[1]*z[7]*z[9]*z[12] +
(32*f0*f3*f8^2 + 16*f0*f4*f7*f8 + 16*f0*f5*f6*f8 - 12*f0*f5*f7^2 - 16*f1*f2*f8^2 -
8*f1*f3*f7*f8 - 4*f1*f5^2*f8)*z[1]*z[7]*z[9]*z[13] + (32*f0*f4*f8^2 -
16*f0*f5*f7*f8 - 32*f1*f3*f8^2 + 4*f1*f5*f7^2 + 32*f2^2*f8^2 + 8*f2*f3*f7*f8 +
8*f2*f5^2*f8)*z[1]*z[7]*z[9]*z[14] + (-64*f0*f5*f8^2 + 96*f0*f6*f7*f8 - 24*f0*f7^3
+ 32*f1*f4*f8^2 - 16*f1*f5*f7*f8 - 32*f2*f3*f8^2 - 16*f2*f5*f6*f8 +
4*f2*f5*f7^2)*z[1]*z[7]*z[9]*z[15] + (-16*f0*f7*f8 - 8*f1*f6*f8 + 4*f1*f7^2 +
12*f2*f5*f8)*z[1]*z[7]*z[9]*z[16] - 4*f0*f5*f7*z[1]*z[7]*z[10]*z[11] +
(-8*f0*f5*f8 + 4*f1*f5*f7)*z[1]*z[7]*z[10]*z[12] + (-16*f0*f5*f8 +
2*f1*f5*f7)*z[1]*z[7]*z[10]*z[13] + (8*f1*f5*f8 -
4*f2*f5*f7)*z[1]*z[7]*z[10]*z[14] + (-16*f0*f7*f8 - 8*f1*f6*f8 + 4*f1*f7^2 +
4*f2*f5*f8)*z[1]*z[7]*z[10]*z[15] + (16*f0*f5*f8 - 2*f1*f5*f7)*z[1]*z[7]*z[11]^2 +
(-16*f0*f6*f8 + 8*f0*f7^2 - 8*f1*f5*f8 + 4*f2*f5*f7)*z[1]*z[7]*z[11]*z[12] +
(16*f0*f6*f8 - 8*f0*f7^2)*z[1]*z[7]*z[11]*z[13] + (-8*f1*f6*f8 + 4*f1*f7^2 -
4*f2*f5*f8)*z[1]*z[7]*z[11]*z[14] + (32*f0*f8^2 + 16*f2*f6*f8 -
8*f2*f7^2)*z[1]*z[7]*z[11]*z[15] + (8*f0*f7*f8 + 16*f1*f6*f8 - 8*f1*f7^2 -
2*f3*f5*f7)*z[1]*z[7]*z[12]^2 + (-8*f1*f6*f8 + 4*f1*f7^2 +
4*f2*f5*f8)*z[1]*z[7]*z[12]*z[13] - 16*f0*f8^2*z[1]*z[7]*z[12]*z[14] +
(-16*f1*f8^2 + 8*f2*f7*f8 - 16*f3*f6*f8 + 8*f3*f7^2 +
8*f4*f5*f8)*z[1]*z[7]*z[12]*z[15] + 8*f0*f7*f8*z[1]*z[7]*z[13]^2 + (-16*f0*f8^2 -
8*f1*f7*f8)*z[1]*z[7]*z[13]*z[14] + 8*f2*f7*f8*z[1]*z[7]*z[13]*z[15] +
16*f1*f8^2*z[1]*z[7]*z[14]^2 + (-16*f2*f8^2 - 8*f3*f7*f8 -
4*f5^2*f8)*z[1]*z[7]*z[14]*z[15] + 2*f5*f7*z[1]*z[7]*z[14]*z[16] + (16*f3*f8^2 +
8*f5*f6*f8 - 2*f5*f7^2)*z[1]*z[7]*z[15]^2 - 8*f5*f8*z[1]*z[7]*z[15]*z[16] +
(16*f0*f2*f7*f8 + 16*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 8*f0*f4*f5*f8 - 2*f0*f5^2*f7 -
4*f1^2*f7*f8 - 6*f1*f3*f5*f8)*z[1]*z[8]*z[9]^2 + (-16*f0*f3*f8 + 4*f0*f5*f6 +
4*f1*f3*f7)*z[1]*z[8]*z[9]*z[10] + (12*f0*f5*f7 - 16*f0*f6^2 + 4*f1*f3*f8 -
8*f1*f4*f7 + 2*f1*f5*f6)*z[1]*z[8]*z[9]*z[11] + (12*f0*f5*f8 - 8*f0*f6*f7 -
8*f1*f4*f8 - 4*f1*f5*f7 + 8*f1*f6^2 + 16*f2*f4*f7 - 4*f2*f5*f6 - 4*f3^2*f7 +
f3*f5^2)*z[1]*z[8]*z[9]*z[12] + (-20*f0*f5*f8 + 8*f0*f6*f7 + 8*f1*f4*f8 +
f1*f5*f7)*z[1]*z[8]*z[9]*z[13] + (4*f0*f7^2 + 8*f1*f5*f8 - 4*f1*f6*f7 -
16*f2*f4*f8 - 2*f2*f5*f7 + 4*f3^2*f8)*z[1]*z[8]*z[9]*z[14] + (-16*f0*f7*f8 -
8*f1*f6*f8 + 4*f1*f7^2 + 12*f2*f5*f8)*z[1]*z[8]*z[9]*z[15] + (6*f1*f8 - 6*f2*f7 +
2*f3*f6 - f4*f5)*z[1]*z[8]*z[9]*z[16] - 2*f0*f5*z[1]*z[8]*z[10]^2 + (8*f0*f6 +
f1*f5)*z[1]*z[8]*z[10]*z[11] + (4*f0*f7 - 4*f1*f6 - 2*f2*f5)*z[1]*z[8]*z[10]*z[12]
+ (4*f0*f7 - 4*f1*f6)*z[1]*z[8]*z[10]*z[13] + (-4*f1*f7 + 8*f2*f6 -
f3*f5)*z[1]*z[8]*z[10]*z[14] + (6*f1*f8 - 2*f2*f7 - 2*f3*f6 +
f4*f5)*z[1]*z[8]*z[10]*z[15] - 8*f0*f7*z[1]*z[8]*z[11]^2 +
4*f1*f7*z[1]*z[8]*z[11]*z[12] + 4*f1*f7*z[1]*z[8]*z[11]*z[13] + (2*f1*f8 - 2*f2*f7
- 2*f3*f6 + f4*f5)*z[1]*z[8]*z[11]*z[14] + (-8*f2*f8 + 4*f3*f7 -
f5^2)*z[1]*z[8]*z[11]*z[15] - 4*f1*f8*z[1]*z[8]*z[12]^2 + (2*f1*f8 - 6*f2*f7 +
2*f3*f6 - f4*f5)*z[1]*z[8]*z[12]*z[13] + 4*f3*f7*z[1]*z[8]*z[12]*z[14] + (4*f3*f8
- 8*f4*f7 + 2*f5*f6)*z[1]*z[8]*z[12]*z[15] + f5*z[1]*z[8]*z[12]*z[16] -
4*f1*f8*z[1]*z[8]*z[13]^2 + 8*f2*f8*z[1]*z[8]*z[13]*z[14] -
4*f3*f8*z[1]*z[8]*z[13]*z[15] + f5*z[1]*z[8]*z[13]*z[16] -
4*f3*f8*z[1]*z[8]*z[14]^2 + (8*f4*f8 + f5*f7)*z[1]*z[8]*z[14]*z[15] -
4*f6*z[1]*z[8]*z[14]*z[16] - 6*f5*f8*z[1]*z[8]*z[15]^2 +
4*f7*z[1]*z[8]*z[15]*z[16] - 16*f0^2*f5*f8*z[2]^2*z[9]^2 + (16*f0^2*f7 +
8*f0*f2*f5 - 2*f1^2*f5)*z[2]^2*z[9]*z[10] + (-8*f0*f1*f7 - 16*f0*f2*f6 +
4*f1^2*f6)*z[2]^2*z[9]*z[11] + (-16*f0*f2*f7 + 8*f0*f3*f6 +
8*f1^2*f7)*z[2]^2*z[9]*z[12] + (8*f0*f1*f8 + 8*f0*f2*f7 -
2*f1^2*f7)*z[2]^2*z[9]*z[13] + (16*f0*f2*f8 - 4*f0*f3*f7 -
8*f1^2*f8)*z[2]^2*z[9]*z[14] - 2*f0*f5*z[2]^2*z[9]*z[16] + (8*f0*f2 -
2*f1^2)*z[2]^2*z[10]*z[11] - 4*f0*f3*z[2]^2*z[10]*z[12] -
4*f0*f3*z[2]^2*z[10]*z[13] + 2*f1*f3*z[2]^2*z[10]*z[14] -
2*f0*f5*z[2]^2*z[10]*z[15] + 2*f0*f5*z[2]^2*z[11]*z[14] + 4*f0*f5*z[2]^2*z[12]^2 +
2*f0*f5*z[2]^2*z[12]*z[13] + (-8*f0*f6 - 2*f1*f5)*z[2]^2*z[12]*z[14] +
4*f1*f6*z[2]^2*z[12]*z[15] - 2*f1*z[2]^2*z[12]*z[16] + 4*f0*f7*z[2]^2*z[14]^2 -
2*f1*f7*z[2]^2*z[14]*z[15] + (32*f0^2*f6*f8 - 16*f0^2*f7^2 +
8*f0*f1*f5*f8)*z[2]*z[3]*z[9]^2 + (-32*f0^2*f8 - 8*f0*f1*f7 - 16*f0*f2*f6 -
4*f0*f3*f5 + 4*f1^2*f6)*z[2]*z[3]*z[9]*z[10] + (8*f0*f1*f8 + 16*f0*f2*f7 +
16*f0*f3*f6)*z[2]*z[3]*z[9]*z[11] + (16*f0*f2*f8 + 16*f0*f3*f7 - 16*f0*f4*f6 -
8*f1^2*f8 - 8*f1*f2*f7 - 4*f1*f3*f6)*z[2]*z[3]*z[9]*z[12] + (-16*f0*f2*f8 -
8*f0*f3*f7)*z[2]*z[3]*z[9]*z[13] + (-16*f0*f3*f8 + 8*f0*f4*f7 + 8*f1*f2*f8 +
2*f1*f3*f7)*z[2]*z[3]*z[9]*z[14] - 4*f0*f5*f7*z[2]*z[3]*z[9]*z[15] + (8*f0*f6 +
f1*f5)*z[2]*z[3]*z[9]*z[16] + (8*f0*f2 - 2*f1^2)*z[2]*z[3]*z[10]^2 -
8*f0*f3*z[2]*z[3]*z[10]*z[11] + (8*f0*f4 + 2*f1*f3)*z[2]*z[3]*z[10]*z[12] +
8*f0*f4*z[2]*z[3]*z[10]*z[13] - 4*f1*f4*z[2]*z[3]*z[10]*z[14] + (8*f0*f6 +
f1*f5)*z[2]*z[3]*z[10]*z[15] - 8*f0*z[2]*z[3]*z[10]*z[16] -
4*f0*f5*z[2]*z[3]*z[11]*z[12] - 4*f0*f5*z[2]*z[3]*z[11]*z[13] +
f1*f5*z[2]*z[3]*z[11]*z[14] - 4*f1*f6*z[2]*z[3]*z[11]*z[15] +
2*f1*z[2]*z[3]*z[11]*z[16] + f1*f5*z[2]*z[3]*z[12]*z[13] +
4*f1*f6*z[2]*z[3]*z[12]*z[14] + 2*f1*f7*z[2]*z[3]*z[13]*z[15] -
2*f1*f7*z[2]*z[3]*z[14]^2 + (16*f0^2*f7*f8 - 16*f0*f1*f6*f8 + 8*f0*f1*f7^2 +
16*f0*f2*f5*f8 - 8*f1^2*f5*f8)*z[2]*z[4]*z[9]^2 + (8*f0*f1*f8 - 16*f0*f2*f7 +
8*f0*f3*f6 + 8*f1^2*f7 + 2*f1*f3*f5)*z[2]*z[4]*z[9]*z[10] + (8*f0*f3*f7 -
16*f0*f4*f6 - 8*f1*f2*f7 - 4*f1*f3*f6)*z[2]*z[4]*z[9]*z[11] + (-8*f0*f3*f8 -
16*f1*f3*f7 + 16*f1*f4*f6 + 16*f2^2*f7)*z[2]*z[4]*z[9]*z[12] + (-8*f0*f3*f8 +
8*f0*f4*f7 + 8*f1*f2*f8 + 2*f1*f3*f7)*z[2]*z[4]*z[9]*z[13] + (-4*f0*f5*f7 +
16*f1*f3*f8 - 8*f1*f4*f7 - 16*f2^2*f8)*z[2]*z[4]*z[9]*z[14] + (-8*f0*f5*f8 +
4*f1*f5*f7)*z[2]*z[4]*z[9]*z[15] + (4*f0*f7 - 4*f1*f6 -
2*f2*f5)*z[2]*z[4]*z[9]*z[16] - 4*f0*f3*z[2]*z[4]*z[10]^2 + (8*f0*f4 +
2*f1*f3)*z[2]*z[4]*z[10]*z[11] + (4*f0*f5 - 8*f1*f4)*z[2]*z[4]*z[10]*z[12] -
4*f1*f4*z[2]*z[4]*z[10]*z[13] + (8*f2*f4 - 2*f3^2)*z[2]*z[4]*z[10]*z[14] +
(4*f0*f7 - 4*f1*f6 - 2*f2*f5)*z[2]*z[4]*z[10]*z[15] + 4*f1*z[2]*z[4]*z[10]*z[16] -
4*f0*f5*z[2]*z[4]*z[11]^2 + 4*f1*f5*z[2]*z[4]*z[11]*z[12] + (8*f0*f6 +
2*f1*f5)*z[2]*z[4]*z[11]*z[13] + (-4*f0*f7 - 4*f1*f6 -
2*f2*f5)*z[2]*z[4]*z[11]*z[14] + 8*f2*f6*z[2]*z[4]*z[11]*z[15] -
4*f2*z[2]*z[4]*z[11]*z[16] - 8*f0*f7*z[2]*z[4]*z[12]^2 + (-4*f0*f7 - 4*f1*f6 -
2*f2*f5)*z[2]*z[4]*z[12]*z[13] + (8*f0*f8 + 8*f1*f7 +
2*f3*f5)*z[2]*z[4]*z[12]*z[14] + (-8*f2*f7 - 4*f3*f6)*z[2]*z[4]*z[12]*z[15] +
2*f3*z[2]*z[4]*z[12]*z[16] - 4*f0*f7*z[2]*z[4]*z[13]^2 + (8*f0*f8 +
4*f1*f7)*z[2]*z[4]*z[13]*z[14] - 4*f2*f7*z[2]*z[4]*z[13]*z[15] +
2*f3*z[2]*z[4]*z[13]*z[16] - 8*f1*f8*z[2]*z[4]*z[14]^2 + (8*f2*f8 +
2*f3*f7)*z[2]*z[4]*z[14]*z[15] - 4*f4*z[2]*z[4]*z[14]*z[16] +
2*f5*z[2]*z[4]*z[15]*z[16] + (16*f0^2*f7*f8 + 16*f0*f2*f5*f8 - 4*f0*f3*f5*f7 -
4*f1^2*f5*f8)*z[2]*z[5]*z[9]^2 + 8*f0*f3*f6*z[2]*z[5]*z[9]*z[10] + (-16*f0*f2*f8 -
16*f0*f4*f6 + 4*f0*f5^2 + 4*f1^2*f8)*z[2]*z[5]*z[9]*z[11] + (-16*f0*f4*f7 +
8*f0*f5*f6 + 4*f1*f3*f7 + 8*f1*f4*f6 - 2*f1*f5^2)*z[2]*z[5]*z[9]*z[12] +
8*f0*f4*f7*z[2]*z[5]*z[9]*z[13] + (16*f0*f4*f8 - 4*f1*f3*f8 -
4*f1*f4*f7)*z[2]*z[5]*z[9]*z[14] + (-16*f0*f5*f8 +
2*f1*f5*f7)*z[2]*z[5]*z[9]*z[15] + (4*f0*f7 - 4*f1*f6)*z[2]*z[5]*z[9]*z[16] -
4*f0*f3*z[2]*z[5]*z[10]^2 + 8*f0*f4*z[2]*z[5]*z[10]*z[11] -
4*f1*f4*z[2]*z[5]*z[10]*z[12] - 4*f0*f5*z[2]*z[5]*z[10]*z[13] + (-8*f0*f6 +
2*f1*f5)*z[2]*z[5]*z[10]*z[14] + 4*f0*f7*z[2]*z[5]*z[10]*z[15] +
2*f1*z[2]*z[5]*z[10]*z[16] - 4*f0*f5*z[2]*z[5]*z[11]^2 +
2*f1*f5*z[2]*z[5]*z[11]*z[12] + 8*f0*f6*z[2]*z[5]*z[11]*z[13] +
4*f0*f7*z[2]*z[5]*z[11]*z[14] - 4*f1*f7*z[2]*z[5]*z[11]*z[15] + (4*f0*f7 -
4*f1*f6)*z[2]*z[5]*z[12]*z[13] - 8*f0*f8*z[2]*z[5]*z[12]*z[14] +
4*f1*f8*z[2]*z[5]*z[12]*z[15] - 4*f0*f7*z[2]*z[5]*z[13]^2 + (-8*f0*f8 +
2*f1*f7)*z[2]*z[5]*z[13]*z[14] + 4*f1*f8*z[2]*z[5]*z[13]*z[15] + (-32*f0^2*f8^2 -
8*f0*f1*f7*f8 - 16*f0*f3*f5*f8 + 2*f1*f3*f5*f7)*z[2]*z[6]*z[9]^2 + (8*f0*f3*f7 -
4*f1*f3*f6)*z[2]*z[6]*z[9]*z[10] + (8*f0*f3*f8 - 16*f0*f4*f7 + 8*f0*f5*f6 +
8*f1*f4*f6 - 2*f1*f5^2)*z[2]*z[6]*z[9]*z[11] + (16*f1*f4*f7 - 8*f1*f5*f6 -
8*f2*f3*f7 - 16*f2*f4*f6 + 4*f2*f5^2 + 4*f3^2*f6)*z[2]*z[6]*z[9]*z[12] +
(16*f0*f4*f8 - 4*f1*f4*f7)*z[2]*z[6]*z[9]*z[13] + (8*f0*f5*f8 - 16*f1*f4*f8 +
8*f2*f3*f8 + 8*f2*f4*f7 - 2*f3^2*f7)*z[2]*z[6]*z[9]*z[14] + (8*f1*f5*f8 -
4*f2*f5*f7)*z[2]*z[6]*z[9]*z[15] + (-4*f1*f7 + 8*f2*f6 -
f3*f5)*z[2]*z[6]*z[9]*z[16] + 2*f1*f3*z[2]*z[6]*z[10]^2 -
4*f1*f4*z[2]*z[6]*z[10]*z[11] + (8*f2*f4 - 2*f3^2)*z[2]*z[6]*z[10]*z[12] +
(-8*f0*f6 + 2*f1*f5)*z[2]*z[6]*z[10]*z[13] + (8*f1*f6 -
4*f2*f5)*z[2]*z[6]*z[10]*z[14] + (-4*f1*f7 + f3*f5)*z[2]*z[6]*z[10]*z[15] -
4*f2*z[2]*z[6]*z[10]*z[16] + 2*f1*f5*z[2]*z[6]*z[11]^2 -
4*f2*f5*z[2]*z[6]*z[11]*z[12] + (8*f0*f7 - 4*f1*f6)*z[2]*z[6]*z[11]*z[13] +
(-4*f1*f7 + f3*f5)*z[2]*z[6]*z[11]*z[14] + (8*f2*f7 -
4*f3*f6)*z[2]*z[6]*z[11]*z[15] + 2*f3*z[2]*z[6]*z[11]*z[16] + (8*f0*f8 +
2*f3*f5)*z[2]*z[6]*z[12]^2 + (-4*f1*f7 + 8*f2*f6 - f3*f5)*z[2]*z[6]*z[12]*z[13] -
4*f3*f6*z[2]*z[6]*z[12]*z[14] + (8*f4*f6 - 2*f5^2)*z[2]*z[6]*z[12]*z[15] -
4*f4*z[2]*z[6]*z[12]*z[16] + (-8*f0*f8 + 2*f1*f7)*z[2]*z[6]*z[13]^2 + (8*f1*f8 -
4*f2*f7)*z[2]*z[6]*z[13]*z[14] + (-8*f2*f8 + 2*f3*f7)*z[2]*z[6]*z[13]*z[15] +
2*f3*f7*z[2]*z[6]*z[14]^2 - 4*f4*f7*z[2]*z[6]*z[14]*z[15] +
2*f5*z[2]*z[6]*z[14]*z[16] + 2*f5*f7*z[2]*z[6]*z[15]^2 -
4*f6*z[2]*z[6]*z[15]*z[16] + 2*z[2]*z[6]*z[16]^2 + (16*f0*f1*f8^2 + 16*f0*f2*f7*f8
+ 16*f0*f3*f6*f8 - 8*f0*f3*f7^2 + 8*f0*f4*f5*f8 - 2*f0*f5^2*f7 - 4*f1^2*f7*f8 -
2*f1*f3*f5*f8)*z[2]*z[7]*z[9]^2 + (-16*f0*f3*f8 + 4*f0*f5*f6)*z[2]*z[7]*z[9]*z[10]
+ (12*f0*f5*f7 - 16*f0*f6^2 + 4*f1*f3*f8 - 2*f1*f5*f6)*z[2]*z[7]*z[9]*z[11] +
(4*f0*f5*f8 - 8*f0*f6*f7 - 8*f1*f4*f8 - 4*f1*f5*f7 + 8*f1*f6^2 + 4*f2*f5*f6 +
4*f3^2*f7 - f3*f5^2)*z[2]*z[7]*z[9]*z[12] + (-20*f0*f5*f8 + 8*f0*f6*f7 +
f1*f5*f7)*z[2]*z[7]*z[9]*z[13] + (4*f0*f7^2 + 8*f1*f5*f8 - 4*f1*f6*f7 - 2*f2*f5*f7
- 4*f3^2*f8)*z[2]*z[7]*z[9]*z[14] + (-16*f0*f7*f8 - 8*f1*f6*f8 + 4*f1*f7^2 +
4*f2*f5*f8)*z[2]*z[7]*z[9]*z[15] + (6*f1*f8 - 2*f2*f7 - 2*f3*f6 +
f4*f5)*z[2]*z[7]*z[9]*z[16] - 2*f0*f5*z[2]*z[7]*z[10]^2 + (8*f0*f6 +
f1*f5)*z[2]*z[7]*z[10]*z[11] + (4*f0*f7 - 4*f1*f6 - 2*f2*f5)*z[2]*z[7]*z[10]*z[12]
+ 4*f0*f7*z[2]*z[7]*z[10]*z[13] + (-4*f1*f7 + f3*f5)*z[2]*z[7]*z[10]*z[14] +
(6*f1*f8 + 2*f2*f7 + 2*f3*f6 - f4*f5)*z[2]*z[7]*z[10]*z[15] -
8*f0*f7*z[2]*z[7]*z[11]^2 + 4*f1*f7*z[2]*z[7]*z[11]*z[12] + (2*f1*f8 + 2*f2*f7 +
2*f3*f6 - f4*f5)*z[2]*z[7]*z[11]*z[14] + (-8*f2*f8 - 4*f3*f7 +
f5^2)*z[2]*z[7]*z[11]*z[15] - 4*f1*f8*z[2]*z[7]*z[12]^2 + (2*f1*f8 - 2*f2*f7 -
2*f3*f6 + f4*f5)*z[2]*z[7]*z[12]*z[13] + (4*f3*f8 - 2*f5*f6)*z[2]*z[7]*z[12]*z[15]
+ f5*z[2]*z[7]*z[12]*z[16] + 4*f3*f8*z[2]*z[7]*z[13]*z[15] -
f5*z[2]*z[7]*z[13]*z[16] + f5*f7*z[2]*z[7]*z[14]*z[15] - 2*f5*f8*z[2]*z[7]*z[15]^2
- 4*f0*f5*z[2]*z[8]*z[9]*z[10] + 16*f0*f6*z[2]*z[8]*z[9]*z[11] + (8*f0*f7 -
8*f1*f6)*z[2]*z[8]*z[9]*z[12] - 8*f0*f7*z[2]*z[8]*z[9]*z[13] + (-8*f0*f8 +
4*f1*f7)*z[2]*z[8]*z[9]*z[14] - 8*f0*z[2]*z[8]*z[10]*z[11] +
4*f1*z[2]*z[8]*z[10]*z[12] + 2*f1*z[2]*z[8]*z[10]*z[13] -
4*f2*z[2]*z[8]*z[10]*z[14] + 2*z[2]*z[8]*z[14]*z[16] + (-16*f0*f1*f6*f8 +
8*f0*f1*f7^2 - 16*f0*f2*f5*f8 + 4*f0*f3*f5*f7 + 4*f1^2*f5*f8)*z[3]^2*z[9]^2 +
(16*f0*f1*f8 + 16*f0*f2*f7 - 4*f1^2*f7)*z[3]^2*z[9]*z[10] + (-16*f0*f3*f7 -
4*f1^2*f8)*z[3]^2*z[9]*z[11] + (-16*f0*f3*f8 + 8*f0*f5*f6 + 8*f1*f2*f8 +
4*f1*f3*f7)*z[3]^2*z[9]*z[12] + 16*f0*f3*f8*z[3]^2*z[9]*z[13] + (-4*f0*f5*f7 -
4*f1*f3*f8)*z[3]^2*z[9]*z[14] + (16*f0*f5*f8 - 2*f1*f5*f7)*z[3]^2*z[9]*z[15] -
8*f0*f7*z[3]^2*z[9]*z[16] - 4*f0*f5*z[3]^2*z[10]*z[12] -
4*f0*f5*z[3]^2*z[10]*z[13] + 2*f1*f5*z[3]^2*z[10]*z[14] -
8*f0*f7*z[3]^2*z[10]*z[15] + 4*f0*f5*z[3]^2*z[11]^2 - 2*f1*f5*z[3]^2*z[11]*z[12] +
4*f1*f7*z[3]^2*z[11]*z[15] + 8*f0*f7*z[3]^2*z[12]^2 - 4*f1*f7*z[3]^2*z[12]*z[14] -
4*f1*f8*z[3]^2*z[12]*z[15] - 4*f1*f8*z[3]^2*z[13]*z[15] + 4*f1*f8*z[3]^2*z[14]^2 +
(-8*f0*f1*f7*f8 + 8*f0*f3*f5*f8 - 8*f0*f4*f5*f7 + 16*f1^2*f6*f8 - 8*f1^2*f7^2 -
2*f1*f3*f5*f7)*z[3]*z[4]*z[9]^2 + (16*f0*f2*f8 - 8*f0*f3*f7 + 4*f0*f5^2 -
16*f1^2*f8)*z[3]*z[4]*z[9]*z[10] + (-16*f0*f3*f8 + 16*f0*f4*f7 + 8*f1*f2*f8 +
8*f1*f3*f7)*z[3]*z[4]*z[9]*z[11] + (16*f0*f4*f8 - 8*f0*f5*f7 + 16*f1*f3*f8 -
8*f1*f5*f6 - 16*f2^2*f8 - 8*f2*f3*f7)*z[3]*z[4]*z[9]*z[12] + (-16*f0*f4*f8 +
4*f0*f5*f7 - 8*f1*f3*f8)*z[3]*z[4]*z[9]*z[13] + (8*f0*f5*f8 + 4*f1*f5*f7 +
8*f2*f3*f8)*z[3]*z[4]*z[9]*z[14] + (-16*f0*f6*f8 + 8*f0*f7^2 - 8*f1*f5*f8 +
4*f2*f5*f7)*z[3]*z[4]*z[9]*z[15] + 4*f1*f7*z[3]*z[4]*z[9]*z[16] -
4*f0*f5*z[3]*z[4]*z[10]*z[11] + 4*f1*f5*z[3]*z[4]*z[10]*z[12] +
2*f1*f5*z[3]*z[4]*z[10]*z[13] - 4*f2*f5*z[3]*z[4]*z[10]*z[14] +
4*f1*f7*z[3]*z[4]*z[10]*z[15] - 2*f1*f5*z[3]*z[4]*z[11]^2 + (8*f0*f7 +
4*f2*f5)*z[3]*z[4]*z[11]*z[12] - 8*f0*f7*z[3]*z[4]*z[11]*z[13] +
4*f1*f7*z[3]*z[4]*z[11]*z[14] - 8*f2*f7*z[3]*z[4]*z[11]*z[15] + (-8*f0*f8 -
8*f1*f7 - 2*f3*f5)*z[3]*z[4]*z[12]^2 + 4*f1*f7*z[3]*z[4]*z[12]*z[13] + (8*f2*f8 +
8*f3*f7)*z[3]*z[4]*z[12]*z[15] + 8*f0*f8*z[3]*z[4]*z[13]^2 -
8*f1*f8*z[3]*z[4]*z[13]*z[14] + 8*f2*f8*z[3]*z[4]*z[13]*z[15] -
8*f3*f8*z[3]*z[4]*z[14]*z[15] + 2*f5*z[3]*z[4]*z[14]*z[16] -
2*f5*f7*z[3]*z[4]*z[15]^2 - 8*f0*f1*f7*f8*z[3]*z[5]*z[9]^2 + (-16*f0*f2*f8 -
8*f0*f3*f7 + 4*f1^2*f8)*z[3]*z[5]*z[9]*z[10] + (16*f0*f3*f8 +
16*f0*f4*f7)*z[3]*z[5]*z[9]*z[11] + (16*f0*f4*f8 + 8*f0*f5*f7 - 16*f0*f6^2 -
8*f1*f3*f8 - 8*f1*f4*f7)*z[3]*z[5]*z[9]*z[12] + (-16*f0*f4*f8 -
4*f0*f5*f7)*z[3]*z[5]*z[9]*z[13] + (-16*f0*f5*f8 + 8*f0*f6*f7 + 8*f1*f4*f8 +
2*f1*f5*f7)*z[3]*z[5]*z[9]*z[14] + (16*f0*f6*f8 - 8*f0*f7^2)*z[3]*z[5]*z[9]*z[15]
+ 4*f1*f7*z[3]*z[5]*z[9]*z[16] - 4*f0*f5*z[3]*z[5]*z[10]*z[11] + (8*f0*f6 +
2*f1*f5)*z[3]*z[5]*z[10]*z[12] + 8*f0*f6*z[3]*z[5]*z[10]*z[13] + (8*f0*f7 -
4*f1*f6)*z[3]*z[5]*z[10]*z[14] - 8*f0*f7*z[3]*z[5]*z[11]*z[12] -
8*f0*f7*z[3]*z[5]*z[11]*z[13] - 8*f0*f8*z[3]*z[5]*z[12]^2 +
4*f1*f7*z[3]*z[5]*z[12]*z[13] + 4*f1*f8*z[3]*z[5]*z[12]*z[14] +
8*f0*f8*z[3]*z[5]*z[13]^2 - 4*f1*f8*z[3]*z[5]*z[13]*z[14] + (16*f0*f1*f8^2 +
8*f0*f4*f5*f8 + 2*f0*f5^2*f7 + 4*f1^2*f7*f8 + 2*f1*f3*f5*f8)*z[3]*z[6]*z[9]^2 -
4*f0*f5*f6*z[3]*z[6]*z[9]*z[10] + (-4*f0*f5*f7 - 4*f1*f3*f8 -
2*f1*f5*f6)*z[3]*z[6]*z[9]*z[11] + (-12*f0*f5*f8 + 8*f0*f6*f7 - 8*f1*f4*f8 -
4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 + 4*f2*f5*f6 + 4*f3^2*f7 -
f3*f5^2)*z[3]*z[6]*z[9]*z[12] + (-4*f0*f5*f8 + f1*f5*f7)*z[3]*z[6]*z[9]*z[13] +
(-4*f0*f7^2 + 8*f1*f5*f8 - 4*f1*f6*f7 - 2*f2*f5*f7 -
4*f3^2*f8)*z[3]*z[6]*z[9]*z[14] + (-8*f1*f6*f8 + 4*f1*f7^2 -
4*f2*f5*f8)*z[3]*z[6]*z[9]*z[15] + (2*f1*f8 - 2*f2*f7 - 2*f3*f6 +
f4*f5)*z[3]*z[6]*z[9]*z[16] + 2*f0*f5*z[3]*z[6]*z[10]^2 +
f1*f5*z[3]*z[6]*z[10]*z[11] + (-4*f0*f7 - 4*f1*f6 - 2*f2*f5)*z[3]*z[6]*z[10]*z[12]
+ 4*f0*f7*z[3]*z[6]*z[10]*z[13] + (-4*f1*f7 + f3*f5)*z[3]*z[6]*z[10]*z[14] +
(2*f1*f8 + 2*f2*f7 + 2*f3*f6 - f4*f5)*z[3]*z[6]*z[10]*z[15] +
4*f1*f7*z[3]*z[6]*z[11]*z[12] + (-2*f1*f8 + 2*f2*f7 + 2*f3*f6 -
f4*f5)*z[3]*z[6]*z[11]*z[14] + (-4*f3*f7 + f5^2)*z[3]*z[6]*z[11]*z[15] +
4*f1*f8*z[3]*z[6]*z[12]^2 + (-2*f1*f8 - 2*f2*f7 - 2*f3*f6 +
f4*f5)*z[3]*z[6]*z[12]*z[13] + (-4*f3*f8 - 2*f5*f6)*z[3]*z[6]*z[12]*z[15] +
f5*z[3]*z[6]*z[12]*z[16] + 4*f3*f8*z[3]*z[6]*z[13]*z[15] -
f5*z[3]*z[6]*z[13]*z[16] + f5*f7*z[3]*z[6]*z[14]*z[15] + 2*f5*f8*z[3]*z[6]*z[15]^2
+ (-32*f0*f2*f8^2 - 8*f0*f5^2*f8 - 8*f1*f3*f6*f8 + 4*f1*f3*f7^2)*z[3]*z[7]*z[9]^2
+ 8*f1*f3*f8*z[3]*z[7]*z[9]*z[10] + (16*f0*f5*f8 - 8*f1*f4*f8 - 4*f1*f5*f7 +
8*f1*f6^2)*z[3]*z[7]*z[9]*z[11] + (16*f2*f4*f8 + 8*f2*f5*f7 - 16*f2*f6^2 -
8*f3^2*f8 - 8*f3*f4*f7 + 4*f3*f5*f6)*z[3]*z[7]*z[9]*z[12] + (8*f1*f5*f8 -
4*f1*f6*f7)*z[3]*z[7]*z[9]*z[13] + (-16*f2*f5*f8 + 8*f2*f6*f7 +
8*f3*f4*f8)*z[3]*z[7]*z[9]*z[14] + (32*f0*f8^2 + 16*f2*f6*f8 -
8*f2*f7^2)*z[3]*z[7]*z[9]*z[15] + (-8*f2*f8 + 4*f3*f7 - f5^2)*z[3]*z[7]*z[9]*z[16]
- 4*f1*f6*z[3]*z[7]*z[10]*z[11] + 8*f2*f6*z[3]*z[7]*z[10]*z[12] -
4*f1*f7*z[3]*z[7]*z[10]*z[13] + (8*f2*f7 - 4*f3*f6)*z[3]*z[7]*z[10]*z[14] +
(-8*f2*f8 - 4*f3*f7 + f5^2)*z[3]*z[7]*z[10]*z[15] + 4*f1*f7*z[3]*z[7]*z[11]^2 -
8*f2*f7*z[3]*z[7]*z[11]*z[12] + (-4*f3*f7 + f5^2)*z[3]*z[7]*z[11]*z[14] + (8*f3*f8
+ 8*f4*f7 - 4*f5*f6)*z[3]*z[7]*z[11]*z[15] + 4*f3*f7*z[3]*z[7]*z[12]^2 + (4*f3*f7
- f5^2)*z[3]*z[7]*z[12]*z[13] + (-8*f4*f8 - 4*f5*f7 +
8*f6^2)*z[3]*z[7]*z[12]*z[15] - 4*f6*z[3]*z[7]*z[12]*z[16] -
8*f4*f8*z[3]*z[7]*z[13]*z[15] + 4*f6*z[3]*z[7]*z[13]*z[16] + (8*f5*f8 -
4*f6*f7)*z[3]*z[7]*z[14]*z[15] - 4*f7*z[3]*z[7]*z[14]*z[16] + (-8*f6*f8 +
4*f7^2)*z[3]*z[7]*z[15]^2 + 8*f8*z[3]*z[7]*z[15]*z[16] +
4*f0*f5*f7*z[3]*z[8]*z[9]^2 + (-8*f0*f7 - 4*f1*f6)*z[3]*z[8]*z[9]*z[11] +
(-8*f0*f8 + 8*f2*f6)*z[3]*z[8]*z[9]*z[12] + (8*f0*f8 +
2*f1*f7)*z[3]*z[8]*z[9]*z[13] - 4*f2*f7*z[3]*z[8]*z[9]*z[14] +
2*f1*z[3]*z[8]*z[10]*z[11] - 4*f2*z[3]*z[8]*z[10]*z[12] +
2*f3*z[3]*z[8]*z[10]*z[14] - 4*f6*z[3]*z[8]*z[12]*z[15] + 2*z[3]*z[8]*z[12]*z[16]
- 2*z[3]*z[8]*z[13]*z[16] + 2*f7*z[3]*z[8]*z[14]*z[15] + (-16*f0*f2*f7*f8 +
16*f0*f3*f6*f8 - 8*f0*f3*f7^2 - 16*f0*f4*f5*f8 + 4*f0*f5^2*f7 + 8*f1^2*f7*f8 -
16*f1*f2*f6*f8 + 8*f1*f2*f7^2 + 4*f1*f3*f5*f8 + 4*f1*f4*f5*f7)*z[4]^2*z[9]^2 +
(-8*f0*f3*f8 + 16*f0*f4*f7 - 8*f0*f5*f6 + 8*f1*f2*f8 - 4*f1*f3*f7 -
2*f1*f5^2)*z[4]^2*z[9]*z[10] + (16*f0*f4*f8 - 8*f0*f5*f7 - 4*f1*f3*f8 - 8*f1*f4*f7
+ 4*f1*f5*f6)*z[4]^2*z[9]*z[11] + (8*f0*f5*f8 - 16*f1*f4*f8 + 8*f1*f5*f7 +
8*f2*f3*f8 + 4*f3^2*f7)*z[4]^2*z[9]*z[12] + (8*f0*f5*f8 + 8*f1*f4*f8 -
4*f1*f5*f7)*z[4]^2*z[9]*z[13] + (-16*f0*f6*f8 + 8*f0*f7^2 - 8*f1*f5*f8 -
4*f3^2*f8)*z[4]^2*z[9]*z[14] + (8*f0*f7*f8 + 16*f1*f6*f8 - 8*f1*f7^2 -
2*f3*f5*f7)*z[4]^2*z[9]*z[15] - 4*f1*f8*z[4]^2*z[9]*z[16] + 4*f0*f5*z[4]^2*z[10]^2
- 8*f0*f7*z[4]^2*z[10]*z[12] + (8*f0*f8 + 2*f3*f5)*z[4]^2*z[10]*z[14] -
4*f1*f8*z[4]^2*z[10]*z[15] + 8*f0*f7*z[4]^2*z[11]^2 + (-8*f0*f8 - 8*f1*f7 -
2*f3*f5)*z[4]^2*z[11]*z[12] - 8*f0*f8*z[4]^2*z[11]*z[13] +
4*f1*f8*z[4]^2*z[11]*z[14] + 4*f3*f7*z[4]^2*z[11]*z[15] + (8*f1*f8 + 8*f2*f7 +
4*f4*f5)*z[4]^2*z[12]^2 + 4*f1*f8*z[4]^2*z[12]*z[13] + (-8*f2*f8 - 4*f3*f7 -
2*f5^2)*z[4]^2*z[12]*z[14] + (-4*f3*f8 - 8*f4*f7 + 4*f5*f6)*z[4]^2*z[12]*z[15] -
4*f5*z[4]^2*z[12]*z[16] - 4*f3*f8*z[4]^2*z[13]*z[15] + 4*f3*f8*z[4]^2*z[14]^2 +
8*f4*f8*z[4]^2*z[14]*z[15] + (8*f0*f4*f5*f8 + 2*f0*f5^2*f7 + 4*f1^2*f7*f8 -
2*f1*f3*f5*f8)*z[4]*z[5]*z[9]^2 + (-4*f0*f5*f6 + 4*f1*f3*f7)*z[4]*z[5]*z[9]*z[10]
+ (-4*f0*f5*f7 - 4*f1*f3*f8 - 8*f1*f4*f7 + 2*f1*f5*f6)*z[4]*z[5]*z[9]*z[11] +
(-4*f0*f5*f8 + 8*f0*f6*f7 - 8*f1*f4*f8 - 4*f1*f5*f7 + 8*f1*f6^2 + 8*f2*f3*f8 +
16*f2*f4*f7 - 4*f2*f5*f6 - 4*f3^2*f7 + f3*f5^2)*z[4]*z[5]*z[9]*z[12] +
(-4*f0*f5*f8 + 8*f1*f4*f8 + f1*f5*f7)*z[4]*z[5]*z[9]*z[13] + (-4*f0*f7^2 +
8*f1*f5*f8 - 4*f1*f6*f7 - 16*f2*f4*f8 - 2*f2*f5*f7 +
4*f3^2*f8)*z[4]*z[5]*z[9]*z[14] + (-8*f1*f6*f8 + 4*f1*f7^2 +
4*f2*f5*f8)*z[4]*z[5]*z[9]*z[15] + (2*f1*f8 - 6*f2*f7 + 2*f3*f6 -
f4*f5)*z[4]*z[5]*z[9]*z[16] + 2*f0*f5*z[4]*z[5]*z[10]^2 +
f1*f5*z[4]*z[5]*z[10]*z[11] + (-4*f0*f7 - 4*f1*f6 - 2*f2*f5)*z[4]*z[5]*z[10]*z[12]
+ (4*f0*f7 - 4*f1*f6)*z[4]*z[5]*z[10]*z[13] + (-4*f1*f7 + 8*f2*f6 -
f3*f5)*z[4]*z[5]*z[10]*z[14] + (2*f1*f8 - 2*f2*f7 - 2*f3*f6 +
f4*f5)*z[4]*z[5]*z[10]*z[15] + 4*f1*f7*z[4]*z[5]*z[11]*z[12] +
4*f1*f7*z[4]*z[5]*z[11]*z[13] + (-2*f1*f8 - 2*f2*f7 - 2*f3*f6 +
f4*f5)*z[4]*z[5]*z[11]*z[14] + (4*f3*f7 - f5^2)*z[4]*z[5]*z[11]*z[15] +
4*f1*f8*z[4]*z[5]*z[12]^2 + (-2*f1*f8 - 6*f2*f7 + 2*f3*f6 -
f4*f5)*z[4]*z[5]*z[12]*z[13] + 4*f3*f7*z[4]*z[5]*z[12]*z[14] + (-4*f3*f8 - 8*f4*f7
+ 2*f5*f6)*z[4]*z[5]*z[12]*z[15] + f5*z[4]*z[5]*z[12]*z[16] -
4*f1*f8*z[4]*z[5]*z[13]^2 + 8*f2*f8*z[4]*z[5]*z[13]*z[14] -
4*f3*f8*z[4]*z[5]*z[13]*z[15] + f5*z[4]*z[5]*z[13]*z[16] -
4*f3*f8*z[4]*z[5]*z[14]^2 + (8*f4*f8 + f5*f7)*z[4]*z[5]*z[14]*z[15] -
4*f6*z[4]*z[5]*z[14]*z[16] - 2*f5*f8*z[4]*z[5]*z[15]^2 +
4*f7*z[4]*z[5]*z[15]*z[16] + (32*f0*f2*f8^2 + 16*f0*f3*f7*f8 - 32*f0*f4*f6*f8 +
16*f0*f4*f7^2 + 16*f0*f5^2*f8 - 8*f0*f5*f6*f7 - 16*f1^2*f8^2 - 8*f1*f2*f7*f8 +
8*f1*f3*f6*f8 - 4*f1*f3*f7^2 - 8*f1*f4*f5*f8 - 2*f1*f5^2*f7)*z[4]*z[6]*z[9]^2 +
(-16*f0*f5*f7 + 16*f0*f6^2 + 4*f1*f5*f6)*z[4]*z[6]*z[9]*z[10] + (-24*f0*f5*f8 +
16*f0*f6*f7 + 8*f1*f4*f8 + 8*f1*f5*f7 - 8*f1*f6^2)*z[4]*z[6]*z[9]*z[11] +
(16*f1*f5*f8 - 16*f1*f6*f7 - 8*f3^2*f8 - 8*f3*f4*f7)*z[4]*z[6]*z[9]*z[12] +
(16*f0*f6*f8 - 16*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7)*z[4]*z[6]*z[9]*z[13] +
(-8*f0*f7*f8 + 8*f1*f7^2 + 8*f3*f4*f8 + 2*f3*f5*f7)*z[4]*z[6]*z[9]*z[14] -
16*f0*f8^2*z[4]*z[6]*z[9]*z[15] + 4*f3*f7*z[4]*z[6]*z[9]*z[16] + (-8*f0*f6 -
2*f1*f5)*z[4]*z[6]*z[10]^2 + 4*f1*f6*z[4]*z[6]*z[10]*z[11] + (8*f0*f8 + 8*f1*f7 +
2*f3*f5)*z[4]*z[6]*z[10]*z[12] - 8*f0*f8*z[4]*z[6]*z[10]*z[13] -
4*f3*f6*z[4]*z[6]*z[10]*z[14] - 4*f1*f7*z[4]*z[6]*z[11]^2 +
4*f1*f8*z[4]*z[6]*z[11]*z[13] + (-8*f2*f8 - 4*f3*f7 - 2*f5^2)*z[4]*z[6]*z[12]^2 +
4*f3*f7*z[4]*z[6]*z[12]*z[13] + (8*f3*f8 + 4*f5*f6)*z[4]*z[6]*z[12]*z[14] +
(8*f4*f8 + 8*f5*f7 - 8*f6^2)*z[4]*z[6]*z[12]*z[15] + 4*f6*z[4]*z[6]*z[12]*z[16] -
4*f3*f8*z[4]*z[6]*z[13]*z[14] - 2*f5*f7*z[4]*z[6]*z[14]^2 + (-12*f5*f8 +
4*f6*f7)*z[4]*z[6]*z[14]*z[15] + (8*f6*f8 - 4*f7^2)*z[4]*z[6]*z[15]^2 -
4*f8*z[4]*z[6]*z[15]*z[16] + (-16*f0*f3*f8^2 + 16*f1*f2*f8^2 - 4*f1*f3*f7*f8 +
16*f1*f4*f6*f8 - 8*f1*f4*f7^2 - 4*f1*f5^2*f8 + 4*f1*f5*f6*f7)*z[4]*z[7]*z[9]^2 +
(8*f0*f5*f8 - 8*f1*f4*f8 + 8*f1*f5*f7 - 8*f1*f6^2)*z[4]*z[7]*z[9]*z[10] +
(4*f1*f5*f8 - 8*f1*f6*f7)*z[4]*z[7]*z[9]*z[11] + (-16*f2*f5*f8 + 16*f2*f6*f7 +
8*f3*f4*f8 - 12*f3*f5*f7 + 8*f3*f6^2 + 16*f4^2*f7 - 8*f4*f5*f6 +
2*f5^3)*z[4]*z[7]*z[9]*z[12] + (-8*f1*f6*f8 + 8*f1*f7^2)*z[4]*z[7]*z[9]*z[13] +
(16*f0*f8^2 - 8*f2*f7^2 + 12*f3*f5*f8 - 4*f3*f6*f7 -
16*f4^2*f8)*z[4]*z[7]*z[9]*z[14] + (-16*f1*f8^2 + 8*f2*f7*f8 - 16*f3*f6*f8 +
8*f3*f7^2 + 8*f4*f5*f8)*z[4]*z[7]*z[9]*z[15] + (4*f3*f8 - 8*f4*f7 +
2*f5*f6)*z[4]*z[7]*z[9]*z[16] + 4*f1*f6*z[4]*z[7]*z[10]^2 + (-8*f2*f7 -
4*f3*f6)*z[4]*z[7]*z[10]*z[12] + 4*f1*f8*z[4]*z[7]*z[10]*z[13] + (8*f4*f6 -
2*f5^2)*z[4]*z[7]*z[10]*z[14] + (4*f3*f8 - 2*f5*f6)*z[4]*z[7]*z[10]*z[15] -
4*f1*f8*z[4]*z[7]*z[11]^2 + (8*f2*f8 + 8*f3*f7)*z[4]*z[7]*z[11]*z[12] + (-4*f3*f8
- 2*f5*f6)*z[4]*z[7]*z[11]*z[14] + (-8*f4*f8 - 4*f5*f7 +
8*f6^2)*z[4]*z[7]*z[11]*z[15] - 4*f6*z[4]*z[7]*z[11]*z[16] + (-4*f3*f8 - 8*f4*f7 +
4*f5*f6)*z[4]*z[7]*z[12]^2 + (-4*f3*f8 - 8*f4*f7 + 2*f5*f6)*z[4]*z[7]*z[12]*z[13]
+ (8*f4*f8 + 8*f5*f7 - 8*f6^2)*z[4]*z[7]*z[12]*z[14] + (4*f5*f8 -
8*f6*f7)*z[4]*z[7]*z[12]*z[15] + 8*f7*z[4]*z[7]*z[12]*z[16] +
8*f4*f8*z[4]*z[7]*z[13]*z[14] + (4*f5*f8 - 4*f6*f7)*z[4]*z[7]*z[13]*z[15] +
(-8*f5*f8 + 4*f6*f7)*z[4]*z[7]*z[14]^2 + 8*f6*f8*z[4]*z[7]*z[14]*z[15] -
4*f8*z[4]*z[7]*z[14]*z[16] - 4*f7*f8*z[4]*z[7]*z[15]^2 + (8*f0*f5*f8 -
4*f1*f5*f7)*z[4]*z[8]*z[9]^2 + (-8*f0*f7 + 4*f1*f6)*z[4]*z[8]*z[9]*z[10] +
(-8*f0*f8 + 8*f1*f7)*z[4]*z[8]*z[9]*z[11] + (8*f1*f8 - 8*f2*f7 -
4*f3*f6)*z[4]*z[8]*z[9]*z[12] - 8*f1*f8*z[4]*z[8]*z[9]*z[13] + (8*f2*f8 +
2*f3*f7)*z[4]*z[8]*z[9]*z[14] + f5*z[4]*z[8]*z[9]*z[16] - 2*f1*z[4]*z[8]*z[10]^2 +
2*f3*z[4]*z[8]*z[10]*z[12] - 4*f4*z[4]*z[8]*z[10]*z[14] + f5*z[4]*z[8]*z[10]*z[15]
+ f5*z[4]*z[8]*z[11]*z[14] - 4*f6*z[4]*z[8]*z[11]*z[15] + 2*z[4]*z[8]*z[11]*z[16]
- 4*f5*z[4]*z[8]*z[12]^2 + f5*z[4]*z[8]*z[12]*z[13] + 4*f6*z[4]*z[8]*z[12]*z[14] +
8*f7*z[4]*z[8]*z[12]*z[15] + 2*f7*z[4]*z[8]*z[13]*z[15] - 2*f7*z[4]*z[8]*z[14]^2 -
8*f8*z[4]*z[8]*z[14]*z[15] + 8*f0*f3*f8*z[5]^2*z[9]*z[10] -
16*f0*f4*f8*z[5]^2*z[9]*z[11] + (-8*f0*f5*f8 + 8*f0*f6*f7 +
8*f1*f4*f8)*z[5]^2*z[9]*z[12] + 8*f0*f5*f8*z[5]^2*z[9]*z[13] + (-4*f0*f7^2 -
4*f1*f5*f8)*z[5]^2*z[9]*z[14] + 8*f0*f7*f8*z[5]^2*z[9]*z[15] -
4*f1*f8*z[5]^2*z[9]*z[16] - 4*f0*f7*z[5]^2*z[10]*z[12] -
4*f0*f7*z[5]^2*z[10]*z[13] + (-8*f0*f8 + 2*f1*f7)*z[5]^2*z[10]*z[14] +
8*f0*f8*z[5]^2*z[11]*z[12] + 8*f0*f8*z[5]^2*z[11]*z[13] -
4*f1*f8*z[5]^2*z[12]*z[13] - 8*f0*f5^2*f8*z[5]*z[6]*z[9]^2 + (4*f0*f5*f7 -
4*f1*f3*f8)*z[5]*z[6]*z[9]*z[10] + (8*f0*f5*f8 + 8*f1*f4*f8)*z[5]*z[6]*z[9]*z[11]
+ (-8*f0*f7^2 + 8*f1*f5*f8 - 8*f1*f6*f7 - 16*f2*f4*f8)*z[5]*z[6]*z[9]*z[12] -
4*f1*f5*f8*z[5]*z[6]*z[9]*z[13] + (16*f0*f7*f8 + 4*f1*f7^2 +
8*f2*f5*f8)*z[5]*z[6]*z[9]*z[14] + (-16*f0*f8^2 - 8*f1*f7*f8)*z[5]*z[6]*z[9]*z[15]
+ 8*f2*f8*z[5]*z[6]*z[9]*z[16] + (8*f0*f8 + 4*f1*f7)*z[5]*z[6]*z[10]*z[12] +
(-8*f0*f8 + 2*f1*f7)*z[5]*z[6]*z[10]*z[13] + (8*f1*f8 -
4*f2*f7)*z[5]*z[6]*z[10]*z[14] - 8*f1*f8*z[5]*z[6]*z[11]*z[12] -
4*f1*f8*z[5]*z[6]*z[11]*z[13] + 8*f2*f8*z[5]*z[6]*z[12]*z[13] -
4*f3*f8*z[5]*z[6]*z[12]*z[14] + 8*f4*f8*z[5]*z[6]*z[12]*z[15] -
4*f5*f8*z[5]*z[6]*z[14]*z[15] + 2*f7*z[5]*z[6]*z[14]*z[16] -
4*f8*z[5]*z[6]*z[15]*z[16] + (16*f0*f3*f8^2 + 16*f0*f5*f6*f8 - 4*f0*f5*f7^2 -
4*f1*f3*f7*f8)*z[5]*z[7]*z[9]^2 - 8*f0*f5*f8*z[5]*z[7]*z[9]*z[10] + (-16*f0*f6*f8
+ 8*f0*f7^2 + 4*f1*f5*f8 - 4*f1*f6*f7)*z[5]*z[7]*z[9]*z[11] + (8*f0*f7*f8 -
8*f2*f5*f8 + 8*f2*f6*f7 + 8*f3*f4*f8)*z[5]*z[7]*z[9]*z[12] + (-8*f0*f7*f8 +
2*f1*f7^2)*z[5]*z[7]*z[9]*z[13] + (-16*f0*f8^2 - 4*f2*f7^2 -
4*f3*f5*f8)*z[5]*z[7]*z[9]*z[14] + 8*f2*f7*f8*z[5]*z[7]*z[9]*z[15] -
4*f3*f8*z[5]*z[7]*z[9]*z[16] + 2*f1*f7*z[5]*z[7]*z[10]*z[11] -
4*f2*f7*z[5]*z[7]*z[10]*z[12] + 4*f1*f8*z[5]*z[7]*z[10]*z[13] + (-8*f2*f8 +
2*f3*f7)*z[5]*z[7]*z[10]*z[14] + 4*f3*f8*z[5]*z[7]*z[10]*z[15] -
4*f1*f8*z[5]*z[7]*z[11]^2 + 8*f2*f8*z[5]*z[7]*z[11]*z[12] +
4*f3*f8*z[5]*z[7]*z[11]*z[14] - 8*f4*f8*z[5]*z[7]*z[11]*z[15] -
4*f3*f8*z[5]*z[7]*z[12]^2 - 4*f3*f8*z[5]*z[7]*z[12]*z[13] + (4*f5*f8 -
4*f6*f7)*z[5]*z[7]*z[12]*z[15] + 2*f7*z[5]*z[7]*z[12]*z[16] +
4*f5*f8*z[5]*z[7]*z[13]*z[15] - 2*f7*z[5]*z[7]*z[13]*z[16] +
2*f7^2*z[5]*z[7]*z[14]*z[15] + 4*f8*z[5]*z[7]*z[14]*z[16] -
4*f7*f8*z[5]*z[7]*z[15]^2 - 8*f0*f5*f8*z[5]*z[8]*z[9]^2 +
8*f0*f8*z[5]*z[8]*z[9]*z[11] - 4*f3*f6*z[5]*z[8]*z[9]*z[12] +
2*f3*f7*z[5]*z[8]*z[9]*z[14] + f5*z[5]*z[8]*z[9]*z[16] +
2*f3*z[5]*z[8]*z[10]*z[12] - f5*z[5]*z[8]*z[10]*z[15] - f5*z[5]*z[8]*z[11]*z[14] +
4*f6*z[5]*z[8]*z[11]*z[15] - 2*z[5]*z[8]*z[11]*z[16] + f5*z[5]*z[8]*z[12]*z[13] -
2*f7*z[5]*z[8]*z[13]*z[15] + (-16*f0*f3*f8^2 - 16*f0*f4*f7*f8 + 4*f0*f5*f7^2 +
4*f1*f3*f7*f8 + 4*f1*f5^2*f8)*z[6]^2*z[9]^2 + (16*f0*f5*f8 - 8*f0*f6*f7 -
2*f1*f5*f7)*z[6]^2*z[9]*z[10] + (-8*f0*f7^2 - 8*f1*f5*f8 +
4*f1*f6*f7)*z[6]^2*z[9]*z[11] + (8*f1*f7^2 + 8*f3*f4*f8)*z[6]^2*z[9]*z[12] +
(24*f0*f7*f8 - 2*f1*f7^2)*z[6]^2*z[9]*z[13] + (-16*f1*f7*f8 -
4*f3*f5*f8)*z[6]^2*z[9]*z[14] + 16*f1*f8^2*z[6]^2*z[9]*z[15] -
4*f3*f8*z[6]^2*z[9]*z[16] + 4*f0*f7*z[6]^2*z[10]^2 - 2*f1*f7*z[6]^2*z[10]*z[11] -
8*f1*f8*z[6]^2*z[10]*z[12] + 2*f3*f7*z[6]^2*z[10]*z[14] + 4*f1*f8*z[6]^2*z[11]^2 +
4*f3*f8*z[6]^2*z[12]^2 - 4*f3*f8*z[6]^2*z[12]*z[13] - 2*f5*f7*z[6]^2*z[12]*z[14] +
(-8*f5*f8 + 4*f6*f7)*z[6]^2*z[12]*z[15] - 2*f7*z[6]^2*z[12]*z[16] +
4*f5*f8*z[6]^2*z[14]^2 - 2*f7^2*z[6]^2*z[14]*z[15] + 4*f7*f8*z[6]^2*z[15]^2 +
(32*f0*f4*f8^2 - 8*f0*f5*f7*f8 + 8*f1*f4*f7*f8 - 8*f1*f5*f6*f8)*z[6]*z[7]*z[9]^2 +
(-16*f0*f6*f8 + 8*f0*f7^2 - 4*f1*f5*f8 + 4*f1*f6*f7)*z[6]*z[7]*z[9]*z[10] +
(8*f0*f7*f8 + 8*f1*f6*f8)*z[6]*z[7]*z[9]*z[11] + (-8*f1*f7*f8 - 8*f2*f7^2 +
8*f3*f5*f8 - 4*f3*f6*f7 - 16*f4^2*f8)*z[6]*z[7]*z[9]*z[12] + (-32*f0*f8^2 -
8*f1*f7*f8)*z[6]*z[7]*z[9]*z[13] + (16*f1*f8^2 + 16*f2*f7*f8 + 2*f3*f7^2 +
8*f4*f5*f8)*z[6]*z[7]*z[9]*z[14] + (-16*f2*f8^2 - 8*f3*f7*f8 -
4*f5^2*f8)*z[6]*z[7]*z[9]*z[15] + (8*f4*f8 + f5*f7)*z[6]*z[7]*z[9]*z[16] -
2*f1*f7*z[6]*z[7]*z[10]^2 + (8*f2*f8 + 2*f3*f7)*z[6]*z[7]*z[10]*z[12] -
4*f4*f7*z[6]*z[7]*z[10]*z[14] + f5*f7*z[6]*z[7]*z[10]*z[15] -
8*f3*f8*z[6]*z[7]*z[11]*z[12] + f5*f7*z[6]*z[7]*z[11]*z[14] + (8*f5*f8 -
4*f6*f7)*z[6]*z[7]*z[11]*z[15] + 2*f7*z[6]*z[7]*z[11]*z[16] +
8*f4*f8*z[6]*z[7]*z[12]^2 + (8*f4*f8 + f5*f7)*z[6]*z[7]*z[12]*z[13] + (-12*f5*f8 +
4*